/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;

public abstract class IO {
    public static final IO object = new IO(){

        @Override
        public void write(Object object, OutputStream out) throws IOException {
            ObjectOutputStream oout = new ObjectOutputStream(out);
            oout.writeObject(object);
            out.flush();
        }

        @Override
        public <T> T read(Class<T> type, InputStream in) throws IOException {
            ObjectInputStream oin = new ObjectInputStream(in);
            try {
                return type.cast(oin.readObject());
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
    };

    protected IO() {
    }

    public byte[] toByteArray(Object object) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(object, out);
        return out.toByteArray();
    }

    public void write(Object object, String path) throws IOException {
        this.write(object, new File(path));
    }

    public void write(Object object, Path path) throws IOException {
        this.write(object, path.toFile());
    }

    public void write(Object object, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.write(object, out);
        }
    }

    public abstract void write(Object var1, OutputStream var2) throws IOException;

    public Object fromByteArray(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return this.read(in);
    }

    public <T> T read(Class<T> type, String path) throws IOException {
        try (FileInputStream in = new FileInputStream(new File(path));){
            T t = this.read(type, in);
            return t;
        }
    }

    public Object read(String path) throws IOException {
        return this.read(Object.class, path);
    }

    public <T> T read(Class<T> type, Path path) throws IOException {
        try (FileInputStream in = new FileInputStream(path.toFile());){
            T t = this.read(type, in);
            return t;
        }
    }

    public Object read(Path path) throws IOException {
        return this.read(Object.class, path);
    }

    public <T> T read(Class<T> type, File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            T t = this.read(type, in);
            return t;
        }
    }

    public Object read(File file) throws IOException {
        return this.read(Object.class, file);
    }

    public abstract <T> T read(Class<T> var1, InputStream var2) throws IOException;

    public Object read(InputStream in) throws IOException {
        return this.read(Object.class, in);
    }
}

