//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// AccessReviewScheduleDefinitionsServer is a fake server for instances of the armauthorization.AccessReviewScheduleDefinitionsClient type.
type AccessReviewScheduleDefinitionsServer struct {
	// CreateOrUpdateByID is the fake for method AccessReviewScheduleDefinitionsClient.CreateOrUpdateByID
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateByID func(ctx context.Context, scheduleDefinitionID string, properties armauthorization.AccessReviewScheduleDefinitionProperties, options *armauthorization.AccessReviewScheduleDefinitionsClientCreateOrUpdateByIDOptions) (resp azfake.Responder[armauthorization.AccessReviewScheduleDefinitionsClientCreateOrUpdateByIDResponse], errResp azfake.ErrorResponder)

	// DeleteByID is the fake for method AccessReviewScheduleDefinitionsClient.DeleteByID
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteByID func(ctx context.Context, scheduleDefinitionID string, options *armauthorization.AccessReviewScheduleDefinitionsClientDeleteByIDOptions) (resp azfake.Responder[armauthorization.AccessReviewScheduleDefinitionsClientDeleteByIDResponse], errResp azfake.ErrorResponder)

	// GetByID is the fake for method AccessReviewScheduleDefinitionsClient.GetByID
	// HTTP status codes to indicate success: http.StatusOK
	GetByID func(ctx context.Context, scheduleDefinitionID string, options *armauthorization.AccessReviewScheduleDefinitionsClientGetByIDOptions) (resp azfake.Responder[armauthorization.AccessReviewScheduleDefinitionsClientGetByIDResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method AccessReviewScheduleDefinitionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armauthorization.AccessReviewScheduleDefinitionsClientListOptions) (resp azfake.PagerResponder[armauthorization.AccessReviewScheduleDefinitionsClientListResponse])

	// Stop is the fake for method AccessReviewScheduleDefinitionsClient.Stop
	// HTTP status codes to indicate success: http.StatusNoContent
	Stop func(ctx context.Context, scheduleDefinitionID string, options *armauthorization.AccessReviewScheduleDefinitionsClientStopOptions) (resp azfake.Responder[armauthorization.AccessReviewScheduleDefinitionsClientStopResponse], errResp azfake.ErrorResponder)
}

// NewAccessReviewScheduleDefinitionsServerTransport creates a new instance of AccessReviewScheduleDefinitionsServerTransport with the provided implementation.
// The returned AccessReviewScheduleDefinitionsServerTransport instance is connected to an instance of armauthorization.AccessReviewScheduleDefinitionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAccessReviewScheduleDefinitionsServerTransport(srv *AccessReviewScheduleDefinitionsServer) *AccessReviewScheduleDefinitionsServerTransport {
	return &AccessReviewScheduleDefinitionsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armauthorization.AccessReviewScheduleDefinitionsClientListResponse]](),
	}
}

// AccessReviewScheduleDefinitionsServerTransport connects instances of armauthorization.AccessReviewScheduleDefinitionsClient to instances of AccessReviewScheduleDefinitionsServer.
// Don't use this type directly, use NewAccessReviewScheduleDefinitionsServerTransport instead.
type AccessReviewScheduleDefinitionsServerTransport struct {
	srv          *AccessReviewScheduleDefinitionsServer
	newListPager *tracker[azfake.PagerResponder[armauthorization.AccessReviewScheduleDefinitionsClientListResponse]]
}

// Do implements the policy.Transporter interface for AccessReviewScheduleDefinitionsServerTransport.
func (a *AccessReviewScheduleDefinitionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AccessReviewScheduleDefinitionsClient.CreateOrUpdateByID":
		resp, err = a.dispatchCreateOrUpdateByID(req)
	case "AccessReviewScheduleDefinitionsClient.DeleteByID":
		resp, err = a.dispatchDeleteByID(req)
	case "AccessReviewScheduleDefinitionsClient.GetByID":
		resp, err = a.dispatchGetByID(req)
	case "AccessReviewScheduleDefinitionsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	case "AccessReviewScheduleDefinitionsClient.Stop":
		resp, err = a.dispatchStop(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AccessReviewScheduleDefinitionsServerTransport) dispatchCreateOrUpdateByID(req *http.Request) (*http.Response, error) {
	if a.srv.CreateOrUpdateByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateByID not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armauthorization.AccessReviewScheduleDefinitionProperties](req)
	if err != nil {
		return nil, err
	}
	scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateOrUpdateByID(req.Context(), scheduleDefinitionIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessReviewScheduleDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessReviewScheduleDefinitionsServerTransport) dispatchDeleteByID(req *http.Request) (*http.Response, error) {
	if a.srv.DeleteByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteByID not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.DeleteByID(req.Context(), scheduleDefinitionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessReviewScheduleDefinitionsServerTransport) dispatchGetByID(req *http.Request) (*http.Response, error) {
	if a.srv.GetByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByID not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetByID(req.Context(), scheduleDefinitionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessReviewScheduleDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessReviewScheduleDefinitionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armauthorization.AccessReviewScheduleDefinitionsClientListOptions
		if filterParam != nil {
			options = &armauthorization.AccessReviewScheduleDefinitionsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := a.srv.NewListPager(options)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armauthorization.AccessReviewScheduleDefinitionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}

func (a *AccessReviewScheduleDefinitionsServerTransport) dispatchStop(req *http.Request) (*http.Response, error) {
	if a.srv.Stop == nil {
		return nil, &nonRetriableError{errors.New("fake for method Stop not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Stop(req.Context(), scheduleDefinitionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
