// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/bigquery/reservation/v1/reservation.proto

package reservationpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of editions.
// Different features and behaviors are provided to different editions
// Capacity commitments and reservations are linked to editions.
type Edition int32

const (
	// Default value, which will be treated as ENTERPRISE.
	Edition_EDITION_UNSPECIFIED Edition = 0
	// Standard edition.
	Edition_STANDARD Edition = 1
	// Enterprise edition.
	Edition_ENTERPRISE Edition = 2
	// Enterprise Plus edition.
	Edition_ENTERPRISE_PLUS Edition = 3
)

// Enum value maps for Edition.
var (
	Edition_name = map[int32]string{
		0: "EDITION_UNSPECIFIED",
		1: "STANDARD",
		2: "ENTERPRISE",
		3: "ENTERPRISE_PLUS",
	}
	Edition_value = map[string]int32{
		"EDITION_UNSPECIFIED": 0,
		"STANDARD":            1,
		"ENTERPRISE":          2,
		"ENTERPRISE_PLUS":     3,
	}
)

func (x Edition) Enum() *Edition {
	p := new(Edition)
	*p = x
	return p
}

func (x Edition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Edition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[0].Descriptor()
}

func (Edition) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[0]
}

func (x Edition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Edition.Descriptor instead.
func (Edition) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{0}
}

// The failover mode when a user initiates a failover on a reservation
// determines how writes that are pending replication are handled after the
// failover is initiated.
type FailoverMode int32

const (
	// Invalid value.
	FailoverMode_FAILOVER_MODE_UNSPECIFIED FailoverMode = 0
	// When customers initiate a soft failover, BigQuery will wait until all
	// committed writes are replicated to the secondary. This mode requires both
	// regions to be available for the failover to succeed and prevents data loss.
	FailoverMode_SOFT FailoverMode = 1
	// When customers initiate a hard failover, BigQuery will not wait until all
	// committed writes are replicated to the secondary. There can be data loss
	// for hard failover.
	FailoverMode_HARD FailoverMode = 2
)

// Enum value maps for FailoverMode.
var (
	FailoverMode_name = map[int32]string{
		0: "FAILOVER_MODE_UNSPECIFIED",
		1: "SOFT",
		2: "HARD",
	}
	FailoverMode_value = map[string]int32{
		"FAILOVER_MODE_UNSPECIFIED": 0,
		"SOFT":                      1,
		"HARD":                      2,
	}
)

func (x FailoverMode) Enum() *FailoverMode {
	p := new(FailoverMode)
	*p = x
	return p
}

func (x FailoverMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FailoverMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[1].Descriptor()
}

func (FailoverMode) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[1]
}

func (x FailoverMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FailoverMode.Descriptor instead.
func (FailoverMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{1}
}

// The scaling mode for the reservation. This enum determines how the
// reservation scales up and down.
type Reservation_ScalingMode int32

const (
	// Default value of ScalingMode.
	Reservation_SCALING_MODE_UNSPECIFIED Reservation_ScalingMode = 0
	// The reservation will scale up only using slots from autoscaling. It will
	// not use any idle slots even if there may be some available. The upper
	// limit that autoscaling can scale up to will be max_slots - baseline.
	// For example, if max_slots is 1000, baseline is 200 and customer sets
	// ScalingMode to AUTOSCALE_ONLY, then autoscalerg will scale up to 800
	// slots and no idle slots will be used.
	//
	// Please note, in this mode, the ignore_idle_slots field must be set to
	// true. Otherwise the request will be rejected with error code
	// `google.rpc.Code.INVALID_ARGUMENT`.
	Reservation_AUTOSCALE_ONLY Reservation_ScalingMode = 1
	// The reservation will scale up using only idle slots contributed by
	// other reservations or from unassigned commitments. If no idle slots are
	// available it will not scale up further. If the idle slots which it is
	// using are reclaimed by the contributing reservation(s) it may be forced
	// to scale down. The max idle slots the reservation can be max_slots -
	// baseline capacity. For example, if max_slots is 1000, baseline is 200 and
	// customer sets ScalingMode to IDLE_SLOTS_ONLY,
	// 1. if there are 1000 idle slots available in other reservations, the
	// reservation will scale up to 1000 slots with 200 baseline and 800 idle
	// slots.
	// 2. if there are 500 idle slots available in other reservations, the
	// reservation will scale up to 700 slots with 200 baseline and 300 idle
	// slots.
	// Please note, in this mode, the reservation might not be able to scale up
	// to max_slots.
	//
	// Please note, in this mode, the ignore_idle_slots field must be set to
	// false. Otherwise the request will be rejected with error code
	// `google.rpc.Code.INVALID_ARGUMENT`.
	Reservation_IDLE_SLOTS_ONLY Reservation_ScalingMode = 2
	// The reservation will scale up using all slots available to it. It will
	// use idle slots contributed by other reservations or from unassigned
	// commitments first. If no idle slots are available it will scale up using
	// autoscaling. For example, if max_slots is 1000, baseline is 200 and
	// customer sets ScalingMode to ALL_SLOTS,
	// 1. if there are 800 idle slots available in other reservations, the
	// reservation will scale up to 1000 slots with 200 baseline and 800 idle
	// slots.
	// 2. if there are 500 idle slots available in other reservations, the
	// reservation will scale up to 1000 slots with 200 baseline, 500 idle
	// slots and 300 autoscaling slots.
	// 3. if there are no idle slots available in other reservations, it will
	// scale up to 1000 slots with 200 baseline and 800 autoscaling slots.
	//
	// Please note, in this mode, the ignore_idle_slots field must be set to
	// false. Otherwise the request will be rejected with error code
	// `google.rpc.Code.INVALID_ARGUMENT`.
	Reservation_ALL_SLOTS Reservation_ScalingMode = 3
)

// Enum value maps for Reservation_ScalingMode.
var (
	Reservation_ScalingMode_name = map[int32]string{
		0: "SCALING_MODE_UNSPECIFIED",
		1: "AUTOSCALE_ONLY",
		2: "IDLE_SLOTS_ONLY",
		3: "ALL_SLOTS",
	}
	Reservation_ScalingMode_value = map[string]int32{
		"SCALING_MODE_UNSPECIFIED": 0,
		"AUTOSCALE_ONLY":           1,
		"IDLE_SLOTS_ONLY":          2,
		"ALL_SLOTS":                3,
	}
)

func (x Reservation_ScalingMode) Enum() *Reservation_ScalingMode {
	p := new(Reservation_ScalingMode)
	*p = x
	return p
}

func (x Reservation_ScalingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Reservation_ScalingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[2].Descriptor()
}

func (Reservation_ScalingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[2]
}

func (x Reservation_ScalingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Reservation_ScalingMode.Descriptor instead.
func (Reservation_ScalingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{0, 0}
}

// Commitment plan defines the current committed period. Capacity commitment
// cannot be deleted during it's committed period.
type CapacityCommitment_CommitmentPlan int32

const (
	// Invalid plan value. Requests with this value will be rejected with
	// error code `google.rpc.Code.INVALID_ARGUMENT`.
	CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED CapacityCommitment_CommitmentPlan = 0
	// Flex commitments have committed period of 1 minute after becoming ACTIVE.
	// After that, they are not in a committed period anymore and can be removed
	// any time.
	CapacityCommitment_FLEX CapacityCommitment_CommitmentPlan = 3
	// Same as FLEX, should only be used if flat-rate commitments are still
	// available.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/reservation/v1/reservation.proto.
	CapacityCommitment_FLEX_FLAT_RATE CapacityCommitment_CommitmentPlan = 7
	// Trial commitments have a committed period of 182 days after becoming
	// ACTIVE. After that, they are converted to a new commitment based on the
	// `renewal_plan`. Default `renewal_plan` for Trial commitment is Flex so
	// that it can be deleted right after committed period ends.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/reservation/v1/reservation.proto.
	CapacityCommitment_TRIAL CapacityCommitment_CommitmentPlan = 5
	// Monthly commitments have a committed period of 30 days after becoming
	// ACTIVE. After that, they are not in a committed period anymore and can be
	// removed any time.
	CapacityCommitment_MONTHLY CapacityCommitment_CommitmentPlan = 2
	// Same as MONTHLY, should only be used if flat-rate commitments are still
	// available.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/reservation/v1/reservation.proto.
	CapacityCommitment_MONTHLY_FLAT_RATE CapacityCommitment_CommitmentPlan = 8
	// Annual commitments have a committed period of 365 days after becoming
	// ACTIVE. After that they are converted to a new commitment based on the
	// renewal_plan.
	CapacityCommitment_ANNUAL CapacityCommitment_CommitmentPlan = 4
	// Same as ANNUAL, should only be used if flat-rate commitments are still
	// available.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/reservation/v1/reservation.proto.
	CapacityCommitment_ANNUAL_FLAT_RATE CapacityCommitment_CommitmentPlan = 9
	// 3-year commitments have a committed period of 1095(3 * 365) days after
	// becoming ACTIVE. After that they are converted to a new commitment based
	// on the renewal_plan.
	CapacityCommitment_THREE_YEAR CapacityCommitment_CommitmentPlan = 10
	// Should only be used for `renewal_plan` and is only meaningful if
	// edition is specified to values other than EDITION_UNSPECIFIED. Otherwise
	// CreateCapacityCommitmentRequest or UpdateCapacityCommitmentRequest will
	// be rejected with error code `google.rpc.Code.INVALID_ARGUMENT`. If the
	// renewal_plan is NONE, capacity commitment will be removed at the end of
	// its commitment period.
	CapacityCommitment_NONE CapacityCommitment_CommitmentPlan = 6
)

// Enum value maps for CapacityCommitment_CommitmentPlan.
var (
	CapacityCommitment_CommitmentPlan_name = map[int32]string{
		0:  "COMMITMENT_PLAN_UNSPECIFIED",
		3:  "FLEX",
		7:  "FLEX_FLAT_RATE",
		5:  "TRIAL",
		2:  "MONTHLY",
		8:  "MONTHLY_FLAT_RATE",
		4:  "ANNUAL",
		9:  "ANNUAL_FLAT_RATE",
		10: "THREE_YEAR",
		6:  "NONE",
	}
	CapacityCommitment_CommitmentPlan_value = map[string]int32{
		"COMMITMENT_PLAN_UNSPECIFIED": 0,
		"FLEX":                        3,
		"FLEX_FLAT_RATE":              7,
		"TRIAL":                       5,
		"MONTHLY":                     2,
		"MONTHLY_FLAT_RATE":           8,
		"ANNUAL":                      4,
		"ANNUAL_FLAT_RATE":            9,
		"THREE_YEAR":                  10,
		"NONE":                        6,
	}
)

func (x CapacityCommitment_CommitmentPlan) Enum() *CapacityCommitment_CommitmentPlan {
	p := new(CapacityCommitment_CommitmentPlan)
	*p = x
	return p
}

func (x CapacityCommitment_CommitmentPlan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CapacityCommitment_CommitmentPlan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[3].Descriptor()
}

func (CapacityCommitment_CommitmentPlan) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[3]
}

func (x CapacityCommitment_CommitmentPlan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CapacityCommitment_CommitmentPlan.Descriptor instead.
func (CapacityCommitment_CommitmentPlan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{3, 0}
}

// Capacity commitment can either become ACTIVE right away or transition
// from PENDING to ACTIVE or FAILED.
type CapacityCommitment_State int32

const (
	// Invalid state value.
	CapacityCommitment_STATE_UNSPECIFIED CapacityCommitment_State = 0
	// Capacity commitment is pending provisioning. Pending capacity commitment
	// does not contribute to the project's slot_capacity.
	CapacityCommitment_PENDING CapacityCommitment_State = 1
	// Once slots are provisioned, capacity commitment becomes active.
	// slot_count is added to the project's slot_capacity.
	CapacityCommitment_ACTIVE CapacityCommitment_State = 2
	// Capacity commitment is failed to be activated by the backend.
	CapacityCommitment_FAILED CapacityCommitment_State = 3
)

// Enum value maps for CapacityCommitment_State.
var (
	CapacityCommitment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "ACTIVE",
		3: "FAILED",
	}
	CapacityCommitment_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"ACTIVE":            2,
		"FAILED":            3,
	}
)

func (x CapacityCommitment_State) Enum() *CapacityCommitment_State {
	p := new(CapacityCommitment_State)
	*p = x
	return p
}

func (x CapacityCommitment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CapacityCommitment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[4].Descriptor()
}

func (CapacityCommitment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[4]
}

func (x CapacityCommitment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CapacityCommitment_State.Descriptor instead.
func (CapacityCommitment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{3, 1}
}

// Types of job, which could be specified when using the reservation.
type Assignment_JobType int32

const (
	// Invalid type. Requests with this value will be rejected with
	// error code `google.rpc.Code.INVALID_ARGUMENT`.
	Assignment_JOB_TYPE_UNSPECIFIED Assignment_JobType = 0
	// Pipeline (load/export) jobs from the project will use the reservation.
	Assignment_PIPELINE Assignment_JobType = 1
	// Query jobs from the project will use the reservation.
	Assignment_QUERY Assignment_JobType = 2
	// BigQuery ML jobs that use services external to BigQuery for model
	// training. These jobs will not utilize idle slots from other reservations.
	Assignment_ML_EXTERNAL Assignment_JobType = 3
	// Background jobs that BigQuery runs for the customers in the background.
	Assignment_BACKGROUND Assignment_JobType = 4
	// Continuous SQL jobs will use this reservation. Reservations with
	// continuous assignments cannot be mixed with non-continuous assignments.
	Assignment_CONTINUOUS Assignment_JobType = 6
	// Finer granularity background jobs for capturing changes in a source
	// database and streaming them into BigQuery. Reservations with this job
	// type take priority over a default BACKGROUND reservation assignment (if
	// it exists).
	Assignment_BACKGROUND_CHANGE_DATA_CAPTURE Assignment_JobType = 7
	// Finer granularity background jobs for refreshing cached metadata for
	// BigQuery tables. Reservations with this job type take priority over a
	// default BACKGROUND reservation assignment (if it exists).
	Assignment_BACKGROUND_COLUMN_METADATA_INDEX Assignment_JobType = 8
	// Finer granularity background jobs for refreshing search indexes upon
	// BigQuery table columns. Reservations with this job type
	// take priority over a default BACKGROUND reservation assignment (if it
	// exists).
	Assignment_BACKGROUND_SEARCH_INDEX_REFRESH Assignment_JobType = 9
)

// Enum value maps for Assignment_JobType.
var (
	Assignment_JobType_name = map[int32]string{
		0: "JOB_TYPE_UNSPECIFIED",
		1: "PIPELINE",
		2: "QUERY",
		3: "ML_EXTERNAL",
		4: "BACKGROUND",
		6: "CONTINUOUS",
		7: "BACKGROUND_CHANGE_DATA_CAPTURE",
		8: "BACKGROUND_COLUMN_METADATA_INDEX",
		9: "BACKGROUND_SEARCH_INDEX_REFRESH",
	}
	Assignment_JobType_value = map[string]int32{
		"JOB_TYPE_UNSPECIFIED":             0,
		"PIPELINE":                         1,
		"QUERY":                            2,
		"ML_EXTERNAL":                      3,
		"BACKGROUND":                       4,
		"CONTINUOUS":                       6,
		"BACKGROUND_CHANGE_DATA_CAPTURE":   7,
		"BACKGROUND_COLUMN_METADATA_INDEX": 8,
		"BACKGROUND_SEARCH_INDEX_REFRESH":  9,
	}
)

func (x Assignment_JobType) Enum() *Assignment_JobType {
	p := new(Assignment_JobType)
	*p = x
	return p
}

func (x Assignment_JobType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Assignment_JobType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[5].Descriptor()
}

func (Assignment_JobType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[5]
}

func (x Assignment_JobType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Assignment_JobType.Descriptor instead.
func (Assignment_JobType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{25, 0}
}

// Assignment will remain in PENDING state if no active capacity commitment is
// present. It will become ACTIVE when some capacity commitment becomes
// active.
type Assignment_State int32

const (
	// Invalid state value.
	Assignment_STATE_UNSPECIFIED Assignment_State = 0
	// Queries from assignee will be executed as on-demand, if related
	// assignment is pending.
	Assignment_PENDING Assignment_State = 1
	// Assignment is ready.
	Assignment_ACTIVE Assignment_State = 2
)

// Enum value maps for Assignment_State.
var (
	Assignment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "ACTIVE",
	}
	Assignment_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"ACTIVE":            2,
	}
)

func (x Assignment_State) Enum() *Assignment_State {
	p := new(Assignment_State)
	*p = x
	return p
}

func (x Assignment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Assignment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[6].Descriptor()
}

func (Assignment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes[6]
}

func (x Assignment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Assignment_State.Descriptor instead.
func (Assignment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{25, 1}
}

// A reservation is a mechanism used to guarantee slots to users.
type Reservation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the reservation, e.g.,
	// `projects/*/locations/*/reservations/team1-prod`.
	// The reservation_id must only contain lower case alphanumeric characters or
	// dashes. It must start with a letter and must not end with a dash. Its
	// maximum length is 64 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Baseline slots available to this reservation. A slot is a unit of
	// computational power in BigQuery, and serves as the unit of parallelism.
	//
	// Queries using this reservation might use more slots during runtime if
	// ignore_idle_slots is set to false, or autoscaling is enabled.
	//
	// The total slot_capacity of the reservation and its siblings
	// may exceed the total slot_count of capacity commitments. In that case, the
	// exceeding slots will be charged with the autoscale SKU. You can increase
	// the number of baseline slots in a reservation every few minutes. If you
	// want to decrease your baseline slots, you are limited to once an hour if
	// you have recently changed your baseline slot capacity and your baseline
	// slots exceed your committed slots. Otherwise, you can decrease your
	// baseline slots every few minutes.
	SlotCapacity int64 `protobuf:"varint,2,opt,name=slot_capacity,json=slotCapacity,proto3" json:"slot_capacity,omitempty"`
	// Optional. If false, any query or pipeline job using this reservation will
	// use idle slots from other reservations within the same admin project. If
	// true, a query or pipeline job using this reservation will execute with the
	// slot capacity specified in the slot_capacity field at most.
	IgnoreIdleSlots bool `protobuf:"varint,4,opt,name=ignore_idle_slots,json=ignoreIdleSlots,proto3" json:"ignore_idle_slots,omitempty"`
	// Optional. The configuration parameters for the auto scaling feature.
	Autoscale *Reservation_Autoscale `protobuf:"bytes,7,opt,name=autoscale,proto3" json:"autoscale,omitempty"`
	// Optional. Job concurrency target which sets a soft upper bound on the
	// number of jobs that can run concurrently in this reservation. This is a
	// soft target due to asynchronous nature of the system and various
	// optimizations for small queries. Default value is 0 which means that
	// concurrency target will be automatically computed by the system. NOTE: this
	// field is exposed as target job concurrency in the Information Schema, DDL
	// and BigQuery CLI.
	Concurrency int64 `protobuf:"varint,16,opt,name=concurrency,proto3" json:"concurrency,omitempty"`
	// Output only. Creation time of the reservation.
	CreationTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Output only. Last update time of the reservation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Applicable only for reservations located within one of the BigQuery
	// multi-regions (US or EU).
	//
	// If set to true, this reservation is placed in the organization's
	// secondary region which is designated for disaster recovery purposes.
	// If false, this reservation is placed in the organization's default region.
	//
	// NOTE: this is a preview feature. Project must be allow-listed in order to
	// set this field.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/reservation/v1/reservation.proto.
	MultiRegionAuxiliary bool `protobuf:"varint,14,opt,name=multi_region_auxiliary,json=multiRegionAuxiliary,proto3" json:"multi_region_auxiliary,omitempty"`
	// Optional. Edition of the reservation.
	Edition Edition `protobuf:"varint,17,opt,name=edition,proto3,enum=google.cloud.bigquery.reservation.v1.Edition" json:"edition,omitempty"`
	// Output only. The current location of the reservation's primary replica.
	// This field is only set for reservations using the managed disaster recovery
	// feature.
	PrimaryLocation string `protobuf:"bytes,18,opt,name=primary_location,json=primaryLocation,proto3" json:"primary_location,omitempty"`
	// Optional. The current location of the reservation's secondary replica. This
	// field is only set for reservations using the managed disaster recovery
	// feature. Users can set this in create reservation calls
	// to create a failover reservation or in update reservation calls to convert
	// a non-failover reservation to a failover reservation(or vice versa).
	SecondaryLocation string `protobuf:"bytes,19,opt,name=secondary_location,json=secondaryLocation,proto3" json:"secondary_location,omitempty"`
	// Output only. The location where the reservation was originally created.
	// This is set only during the failover reservation's creation. All billing
	// charges for the failover reservation will be applied to this location.
	OriginalPrimaryLocation string `protobuf:"bytes,20,opt,name=original_primary_location,json=originalPrimaryLocation,proto3" json:"original_primary_location,omitempty"`
	// Optional. The overall max slots for the reservation, covering slot_capacity
	// (baseline), idle slots (if ignore_idle_slots is false) and scaled slots.
	// If present, the reservation won't use more than the specified number of
	// slots, even if there is demand and supply (from idle slots).
	// NOTE: capping a reservation's idle slot usage is best effort and its
	// usage may exceed the max_slots value. However, in terms of
	// autoscale.current_slots (which accounts for the additional added slots), it
	// will never exceed the max_slots - baseline.
	//
	// This field must be set together with the scaling_mode enum value,
	// otherwise the request will be rejected with error code
	// `google.rpc.Code.INVALID_ARGUMENT`.
	//
	// If the max_slots and scaling_mode are set, the autoscale or
	// autoscale.max_slots field must be unset. Otherwise the request will be
	// rejected with error code `google.rpc.Code.INVALID_ARGUMENT`. However, the
	// autoscale field may still be in the output. The autopscale.max_slots will
	// always show as 0 and the autoscaler.current_slots will represent the
	// current slots from autoscaler excluding idle slots.
	// For example, if the max_slots is 1000 and scaling_mode is AUTOSCALE_ONLY,
	// then in the output, the autoscaler.max_slots will be 0 and the
	// autoscaler.current_slots may be any value between 0 and 1000.
	//
	// If the max_slots is 1000, scaling_mode is ALL_SLOTS, the baseline is 100
	// and idle slots usage is 200, then in the output, the autoscaler.max_slots
	// will be 0 and the autoscaler.current_slots will not be higher than 700.
	//
	// If the max_slots is 1000, scaling_mode is IDLE_SLOTS_ONLY, then in the
	// output, the autoscaler field will be null.
	//
	// If the max_slots and scaling_mode are set, then the ignore_idle_slots field
	// must be aligned with the scaling_mode enum value.(See details in
	// ScalingMode comments). Otherwise the request will be rejected with
	// error code `google.rpc.Code.INVALID_ARGUMENT`.
	//
	// Please note,  the max_slots is for user to manage the part of slots greater
	// than the baseline. Therefore, we don't allow users to set max_slots smaller
	// or equal to the baseline as it will not be meaningful. If the field is
	// present and slot_capacity>=max_slots, requests will be rejected with error
	// code `google.rpc.Code.INVALID_ARGUMENT`.
	//
	// Please note that if max_slots is set to 0, we will treat it as unset.
	// Customers can set max_slots to 0 and set scaling_mode to
	// SCALING_MODE_UNSPECIFIED to disable the max_slots feature.
	MaxSlots *int64 `protobuf:"varint,21,opt,name=max_slots,json=maxSlots,proto3,oneof" json:"max_slots,omitempty"`
	// Optional. The scaling mode for the reservation.
	// If the field is present but max_slots is not present, requests will be
	// rejected with error code `google.rpc.Code.INVALID_ARGUMENT`.
	ScalingMode Reservation_ScalingMode `protobuf:"varint,22,opt,name=scaling_mode,json=scalingMode,proto3,enum=google.cloud.bigquery.reservation.v1.Reservation_ScalingMode" json:"scaling_mode,omitempty"`
	// Optional. The labels associated with this reservation. You can use these
	// to organize and group your reservations.
	// You can set this property when you create or update a reservation.
	Labels map[string]string `protobuf:"bytes,23,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The reservation group that this reservation belongs to.
	// You can set this property when you create or update a reservation.
	// Reservations do not need to belong to a reservation group.
	// Format:
	// projects/{project}/locations/{location}/reservationGroups/{reservation_group}
	// or just {reservation_group}
	ReservationGroup string `protobuf:"bytes,25,opt,name=reservation_group,json=reservationGroup,proto3" json:"reservation_group,omitempty"`
	// Output only. The Disaster Recovery(DR) replication status of the
	// reservation. This is only available for the primary replicas of DR/failover
	// reservations and provides information about the both the staleness of the
	// secondary and the last error encountered while trying to replicate changes
	// from the primary to the secondary. If this field is blank, it means that
	// the reservation is either not a DR reservation or the reservation is a DR
	// secondary or that any replication operations on the reservation have
	// succeeded.
	ReplicationStatus *Reservation_ReplicationStatus `protobuf:"bytes,24,opt,name=replication_status,json=replicationStatus,proto3" json:"replication_status,omitempty"`
	// Optional. The scheduling policy to use for jobs and queries running under
	// this reservation. The scheduling policy controls how the reservation's
	// resources are distributed.
	//
	// This feature is not yet generally available.
	SchedulingPolicy *SchedulingPolicy `protobuf:"bytes,27,opt,name=scheduling_policy,json=schedulingPolicy,proto3" json:"scheduling_policy,omitempty"`
}

func (x *Reservation) Reset() {
	*x = Reservation{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Reservation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Reservation) ProtoMessage() {}

func (x *Reservation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Reservation.ProtoReflect.Descriptor instead.
func (*Reservation) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{0}
}

func (x *Reservation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Reservation) GetSlotCapacity() int64 {
	if x != nil {
		return x.SlotCapacity
	}
	return 0
}

func (x *Reservation) GetIgnoreIdleSlots() bool {
	if x != nil {
		return x.IgnoreIdleSlots
	}
	return false
}

func (x *Reservation) GetAutoscale() *Reservation_Autoscale {
	if x != nil {
		return x.Autoscale
	}
	return nil
}

func (x *Reservation) GetConcurrency() int64 {
	if x != nil {
		return x.Concurrency
	}
	return 0
}

func (x *Reservation) GetCreationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreationTime
	}
	return nil
}

func (x *Reservation) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/bigquery/reservation/v1/reservation.proto.
func (x *Reservation) GetMultiRegionAuxiliary() bool {
	if x != nil {
		return x.MultiRegionAuxiliary
	}
	return false
}

func (x *Reservation) GetEdition() Edition {
	if x != nil {
		return x.Edition
	}
	return Edition_EDITION_UNSPECIFIED
}

func (x *Reservation) GetPrimaryLocation() string {
	if x != nil {
		return x.PrimaryLocation
	}
	return ""
}

func (x *Reservation) GetSecondaryLocation() string {
	if x != nil {
		return x.SecondaryLocation
	}
	return ""
}

func (x *Reservation) GetOriginalPrimaryLocation() string {
	if x != nil {
		return x.OriginalPrimaryLocation
	}
	return ""
}

func (x *Reservation) GetMaxSlots() int64 {
	if x != nil && x.MaxSlots != nil {
		return *x.MaxSlots
	}
	return 0
}

func (x *Reservation) GetScalingMode() Reservation_ScalingMode {
	if x != nil {
		return x.ScalingMode
	}
	return Reservation_SCALING_MODE_UNSPECIFIED
}

func (x *Reservation) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Reservation) GetReservationGroup() string {
	if x != nil {
		return x.ReservationGroup
	}
	return ""
}

func (x *Reservation) GetReplicationStatus() *Reservation_ReplicationStatus {
	if x != nil {
		return x.ReplicationStatus
	}
	return nil
}

func (x *Reservation) GetSchedulingPolicy() *SchedulingPolicy {
	if x != nil {
		return x.SchedulingPolicy
	}
	return nil
}

// The scheduling policy controls how a reservation's resources are distributed.
type SchedulingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If present and > 0, the reservation will attempt to limit the
	// concurrency of jobs running for any particular project within it to the
	// given value.
	//
	// This feature is not yet generally available.
	Concurrency *int64 `protobuf:"varint,1,opt,name=concurrency,proto3,oneof" json:"concurrency,omitempty"`
	// Optional. If present and > 0, the reservation will attempt to limit the
	// slot consumption of queries running for any particular project within it to
	// the given value.
	//
	// This feature is not yet generally available.
	MaxSlots *int64 `protobuf:"varint,2,opt,name=max_slots,json=maxSlots,proto3,oneof" json:"max_slots,omitempty"`
}

func (x *SchedulingPolicy) Reset() {
	*x = SchedulingPolicy{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SchedulingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulingPolicy) ProtoMessage() {}

func (x *SchedulingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulingPolicy.ProtoReflect.Descriptor instead.
func (*SchedulingPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{1}
}

func (x *SchedulingPolicy) GetConcurrency() int64 {
	if x != nil && x.Concurrency != nil {
		return *x.Concurrency
	}
	return 0
}

func (x *SchedulingPolicy) GetMaxSlots() int64 {
	if x != nil && x.MaxSlots != nil {
		return *x.MaxSlots
	}
	return 0
}

// A reservation group is a container for reservations.
type ReservationGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the reservation group, e.g.,
	// `projects/*/locations/*/reservationGroups/team1-prod`.
	// The reservation_group_id must only contain lower case alphanumeric
	// characters or dashes. It must start with a letter and must not end with a
	// dash. Its maximum length is 64 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ReservationGroup) Reset() {
	*x = ReservationGroup{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReservationGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReservationGroup) ProtoMessage() {}

func (x *ReservationGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReservationGroup.ProtoReflect.Descriptor instead.
func (*ReservationGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{2}
}

func (x *ReservationGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Capacity commitment is a way to purchase compute capacity for BigQuery jobs
// (in the form of slots) with some committed period of usage. Annual
// commitments renew by default. Commitments can be removed after their
// commitment end time passes.
//
// In order to remove annual commitment, its plan needs to be changed
// to monthly or flex first.
//
// A capacity commitment resource exists as a child resource of the admin
// project.
type CapacityCommitment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the capacity commitment, e.g.,
	// `projects/myproject/locations/US/capacityCommitments/123`
	// The commitment_id must only contain lower case alphanumeric characters or
	// dashes. It must start with a letter and must not end
	// with a dash. Its maximum length is 64 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Number of slots in this commitment.
	SlotCount int64 `protobuf:"varint,2,opt,name=slot_count,json=slotCount,proto3" json:"slot_count,omitempty"`
	// Optional. Capacity commitment commitment plan.
	Plan CapacityCommitment_CommitmentPlan `protobuf:"varint,3,opt,name=plan,proto3,enum=google.cloud.bigquery.reservation.v1.CapacityCommitment_CommitmentPlan" json:"plan,omitempty"`
	// Output only. State of the commitment.
	State CapacityCommitment_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.bigquery.reservation.v1.CapacityCommitment_State" json:"state,omitempty"`
	// Output only. The start of the current commitment period. It is applicable
	// only for ACTIVE capacity commitments. Note after the commitment is renewed,
	// commitment_start_time won't be changed. It refers to the start time of the
	// original commitment.
	CommitmentStartTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=commitment_start_time,json=commitmentStartTime,proto3" json:"commitment_start_time,omitempty"`
	// Output only. The end of the current commitment period. It is applicable
	// only for ACTIVE capacity commitments. Note after renewal,
	// commitment_end_time is the time the renewed commitment expires. So itwould
	// be at a time after commitment_start_time + committed period, because we
	// don't change commitment_start_time ,
	CommitmentEndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=commitment_end_time,json=commitmentEndTime,proto3" json:"commitment_end_time,omitempty"`
	// Output only. For FAILED commitment plan, provides the reason of failure.
	FailureStatus *status.Status `protobuf:"bytes,7,opt,name=failure_status,json=failureStatus,proto3" json:"failure_status,omitempty"`
	// Optional. The plan this capacity commitment is converted to after
	// commitment_end_time passes. Once the plan is changed, committed period is
	// extended according to commitment plan. Only applicable for ANNUAL and TRIAL
	// commitments.
	RenewalPlan CapacityCommitment_CommitmentPlan `protobuf:"varint,8,opt,name=renewal_plan,json=renewalPlan,proto3,enum=google.cloud.bigquery.reservation.v1.CapacityCommitment_CommitmentPlan" json:"renewal_plan,omitempty"`
	// Applicable only for commitments located within one of the BigQuery
	// multi-regions (US or EU).
	//
	// If set to true, this commitment is placed in the organization's
	// secondary region which is designated for disaster recovery purposes.
	// If false, this commitment is placed in the organization's default region.
	//
	// NOTE: this is a preview feature. Project must be allow-listed in order to
	// set this field.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/reservation/v1/reservation.proto.
	MultiRegionAuxiliary bool `protobuf:"varint,10,opt,name=multi_region_auxiliary,json=multiRegionAuxiliary,proto3" json:"multi_region_auxiliary,omitempty"`
	// Optional. Edition of the capacity commitment.
	Edition Edition `protobuf:"varint,12,opt,name=edition,proto3,enum=google.cloud.bigquery.reservation.v1.Edition" json:"edition,omitempty"`
	// Output only. If true, the commitment is a flat-rate commitment, otherwise,
	// it's an edition commitment.
	IsFlatRate bool `protobuf:"varint,14,opt,name=is_flat_rate,json=isFlatRate,proto3" json:"is_flat_rate,omitempty"`
}

func (x *CapacityCommitment) Reset() {
	*x = CapacityCommitment{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CapacityCommitment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapacityCommitment) ProtoMessage() {}

func (x *CapacityCommitment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapacityCommitment.ProtoReflect.Descriptor instead.
func (*CapacityCommitment) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{3}
}

func (x *CapacityCommitment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CapacityCommitment) GetSlotCount() int64 {
	if x != nil {
		return x.SlotCount
	}
	return 0
}

func (x *CapacityCommitment) GetPlan() CapacityCommitment_CommitmentPlan {
	if x != nil {
		return x.Plan
	}
	return CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED
}

func (x *CapacityCommitment) GetState() CapacityCommitment_State {
	if x != nil {
		return x.State
	}
	return CapacityCommitment_STATE_UNSPECIFIED
}

func (x *CapacityCommitment) GetCommitmentStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitmentStartTime
	}
	return nil
}

func (x *CapacityCommitment) GetCommitmentEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitmentEndTime
	}
	return nil
}

func (x *CapacityCommitment) GetFailureStatus() *status.Status {
	if x != nil {
		return x.FailureStatus
	}
	return nil
}

func (x *CapacityCommitment) GetRenewalPlan() CapacityCommitment_CommitmentPlan {
	if x != nil {
		return x.RenewalPlan
	}
	return CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/cloud/bigquery/reservation/v1/reservation.proto.
func (x *CapacityCommitment) GetMultiRegionAuxiliary() bool {
	if x != nil {
		return x.MultiRegionAuxiliary
	}
	return false
}

func (x *CapacityCommitment) GetEdition() Edition {
	if x != nil {
		return x.Edition
	}
	return Edition_EDITION_UNSPECIFIED
}

func (x *CapacityCommitment) GetIsFlatRate() bool {
	if x != nil {
		return x.IsFlatRate
	}
	return false
}

// The request for
// [ReservationService.CreateReservation][google.cloud.bigquery.reservation.v1.ReservationService.CreateReservation].
type CreateReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project, location. E.g.,
	// `projects/myproject/locations/US`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The reservation ID. It must only contain lower case alphanumeric
	// characters or dashes. It must start with a letter and must not end
	// with a dash. Its maximum length is 64 characters.
	ReservationId string `protobuf:"bytes,2,opt,name=reservation_id,json=reservationId,proto3" json:"reservation_id,omitempty"`
	// Definition of the new reservation to create.
	Reservation *Reservation `protobuf:"bytes,3,opt,name=reservation,proto3" json:"reservation,omitempty"`
}

func (x *CreateReservationRequest) Reset() {
	*x = CreateReservationRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReservationRequest) ProtoMessage() {}

func (x *CreateReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReservationRequest.ProtoReflect.Descriptor instead.
func (*CreateReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{4}
}

func (x *CreateReservationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReservationRequest) GetReservationId() string {
	if x != nil {
		return x.ReservationId
	}
	return ""
}

func (x *CreateReservationRequest) GetReservation() *Reservation {
	if x != nil {
		return x.Reservation
	}
	return nil
}

// The request for
// [ReservationService.ListReservations][google.cloud.bigquery.reservation.v1.ReservationService.ListReservations].
type ListReservationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name containing project and location, e.g.:
	//
	//	`projects/myproject/locations/US`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListReservationsRequest) Reset() {
	*x = ListReservationsRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReservationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReservationsRequest) ProtoMessage() {}

func (x *ListReservationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReservationsRequest.ProtoReflect.Descriptor instead.
func (*ListReservationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{5}
}

func (x *ListReservationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReservationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReservationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ReservationService.ListReservations][google.cloud.bigquery.reservation.v1.ReservationService.ListReservations].
type ListReservationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of reservations visible to the user.
	Reservations []*Reservation `protobuf:"bytes,1,rep,name=reservations,proto3" json:"reservations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListReservationsResponse) Reset() {
	*x = ListReservationsResponse{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReservationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReservationsResponse) ProtoMessage() {}

func (x *ListReservationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReservationsResponse.ProtoReflect.Descriptor instead.
func (*ListReservationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{6}
}

func (x *ListReservationsResponse) GetReservations() []*Reservation {
	if x != nil {
		return x.Reservations
	}
	return nil
}

func (x *ListReservationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.GetReservation][google.cloud.bigquery.reservation.v1.ReservationService.GetReservation].
type GetReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the reservation to retrieve. E.g.,
	//
	//	`projects/myproject/locations/US/reservations/team1-prod`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReservationRequest) Reset() {
	*x = GetReservationRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReservationRequest) ProtoMessage() {}

func (x *GetReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReservationRequest.ProtoReflect.Descriptor instead.
func (*GetReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{7}
}

func (x *GetReservationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ReservationService.DeleteReservation][google.cloud.bigquery.reservation.v1.ReservationService.DeleteReservation].
type DeleteReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the reservation to retrieve. E.g.,
	//
	//	`projects/myproject/locations/US/reservations/team1-prod`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteReservationRequest) Reset() {
	*x = DeleteReservationRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReservationRequest) ProtoMessage() {}

func (x *DeleteReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReservationRequest.ProtoReflect.Descriptor instead.
func (*DeleteReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteReservationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ReservationService.UpdateReservation][google.cloud.bigquery.reservation.v1.ReservationService.UpdateReservation].
type UpdateReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content of the reservation to update.
	Reservation *Reservation `protobuf:"bytes,1,opt,name=reservation,proto3" json:"reservation,omitempty"`
	// Standard field mask for the set of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateReservationRequest) Reset() {
	*x = UpdateReservationRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateReservationRequest) ProtoMessage() {}

func (x *UpdateReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateReservationRequest.ProtoReflect.Descriptor instead.
func (*UpdateReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateReservationRequest) GetReservation() *Reservation {
	if x != nil {
		return x.Reservation
	}
	return nil
}

func (x *UpdateReservationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request for ReservationService.FailoverReservation.
type FailoverReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the reservation to failover. E.g.,
	//
	//	`projects/myproject/locations/US/reservations/team1-prod`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A parameter that determines how writes that are pending
	// replication are handled after a failover is initiated. If not specified,
	// HARD failover mode is used by default.
	FailoverMode FailoverMode `protobuf:"varint,2,opt,name=failover_mode,json=failoverMode,proto3,enum=google.cloud.bigquery.reservation.v1.FailoverMode" json:"failover_mode,omitempty"`
}

func (x *FailoverReservationRequest) Reset() {
	*x = FailoverReservationRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FailoverReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailoverReservationRequest) ProtoMessage() {}

func (x *FailoverReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailoverReservationRequest.ProtoReflect.Descriptor instead.
func (*FailoverReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{10}
}

func (x *FailoverReservationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FailoverReservationRequest) GetFailoverMode() FailoverMode {
	if x != nil {
		return x.FailoverMode
	}
	return FailoverMode_FAILOVER_MODE_UNSPECIFIED
}

// The request for
// [ReservationService.CreateReservationGroup][google.cloud.bigquery.reservation.v1.ReservationService.CreateReservationGroup].
type CreateReservationGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project, location. E.g.,
	// `projects/myproject/locations/US`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The reservation group ID. It must only contain lower case
	// alphanumeric characters or dashes. It must start with a letter and must not
	// end with a dash. Its maximum length is 64 characters.
	ReservationGroupId string `protobuf:"bytes,2,opt,name=reservation_group_id,json=reservationGroupId,proto3" json:"reservation_group_id,omitempty"`
	// Required. New Reservation Group to create.
	ReservationGroup *ReservationGroup `protobuf:"bytes,3,opt,name=reservation_group,json=reservationGroup,proto3" json:"reservation_group,omitempty"`
}

func (x *CreateReservationGroupRequest) Reset() {
	*x = CreateReservationGroupRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateReservationGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReservationGroupRequest) ProtoMessage() {}

func (x *CreateReservationGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReservationGroupRequest.ProtoReflect.Descriptor instead.
func (*CreateReservationGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{11}
}

func (x *CreateReservationGroupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReservationGroupRequest) GetReservationGroupId() string {
	if x != nil {
		return x.ReservationGroupId
	}
	return ""
}

func (x *CreateReservationGroupRequest) GetReservationGroup() *ReservationGroup {
	if x != nil {
		return x.ReservationGroup
	}
	return nil
}

// The request for
// [ReservationService.GetReservationGroup][google.cloud.bigquery.reservation.v1.ReservationService.GetReservationGroup].
type GetReservationGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the reservation group to retrieve. E.g.,
	//
	//	`projects/myproject/locations/US/reservationGroups/team1-prod`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReservationGroupRequest) Reset() {
	*x = GetReservationGroupRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetReservationGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReservationGroupRequest) ProtoMessage() {}

func (x *GetReservationGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReservationGroupRequest.ProtoReflect.Descriptor instead.
func (*GetReservationGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{12}
}

func (x *GetReservationGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ReservationService.ListReservationGroups][google.cloud.bigquery.reservation.v1.ReservationService.ListReservationGroups].
type ListReservationGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name containing project and location, e.g.:
	//
	//	`projects/myproject/locations/US`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListReservationGroupsRequest) Reset() {
	*x = ListReservationGroupsRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReservationGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReservationGroupsRequest) ProtoMessage() {}

func (x *ListReservationGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReservationGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListReservationGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{13}
}

func (x *ListReservationGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReservationGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReservationGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ReservationService.ListReservationGroups][google.cloud.bigquery.reservation.v1.ReservationService.ListReservationGroups].
type ListReservationGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of reservations visible to the user.
	ReservationGroups []*ReservationGroup `protobuf:"bytes,1,rep,name=reservation_groups,json=reservationGroups,proto3" json:"reservation_groups,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListReservationGroupsResponse) Reset() {
	*x = ListReservationGroupsResponse{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReservationGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReservationGroupsResponse) ProtoMessage() {}

func (x *ListReservationGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReservationGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListReservationGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{14}
}

func (x *ListReservationGroupsResponse) GetReservationGroups() []*ReservationGroup {
	if x != nil {
		return x.ReservationGroups
	}
	return nil
}

func (x *ListReservationGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.DeleteReservationGroup][google.cloud.bigquery.reservation.v1.ReservationService.DeleteReservationGroup].
type DeleteReservationGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the reservation group to retrieve. E.g.,
	//
	//	`projects/myproject/locations/US/reservationGroups/team1-prod`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteReservationGroupRequest) Reset() {
	*x = DeleteReservationGroupRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteReservationGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReservationGroupRequest) ProtoMessage() {}

func (x *DeleteReservationGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReservationGroupRequest.ProtoReflect.Descriptor instead.
func (*DeleteReservationGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteReservationGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ReservationService.CreateCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.CreateCapacityCommitment].
type CreateCapacityCommitmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent reservation. E.g.,
	//
	//	`projects/myproject/locations/US`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Content of the capacity commitment to create.
	CapacityCommitment *CapacityCommitment `protobuf:"bytes,2,opt,name=capacity_commitment,json=capacityCommitment,proto3" json:"capacity_commitment,omitempty"`
	// If true, fail the request if another project in the organization has a
	// capacity commitment.
	EnforceSingleAdminProjectPerOrg bool `protobuf:"varint,4,opt,name=enforce_single_admin_project_per_org,json=enforceSingleAdminProjectPerOrg,proto3" json:"enforce_single_admin_project_per_org,omitempty"`
	// The optional capacity commitment ID. Capacity commitment name will be
	// generated automatically if this field is empty.
	// This field must only contain lower case alphanumeric characters or dashes.
	// The first and last character cannot be a dash. Max length is 64 characters.
	// NOTE: this ID won't be kept if the capacity commitment is split or merged.
	CapacityCommitmentId string `protobuf:"bytes,5,opt,name=capacity_commitment_id,json=capacityCommitmentId,proto3" json:"capacity_commitment_id,omitempty"`
}

func (x *CreateCapacityCommitmentRequest) Reset() {
	*x = CreateCapacityCommitmentRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCapacityCommitmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCapacityCommitmentRequest) ProtoMessage() {}

func (x *CreateCapacityCommitmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCapacityCommitmentRequest.ProtoReflect.Descriptor instead.
func (*CreateCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{16}
}

func (x *CreateCapacityCommitmentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCapacityCommitmentRequest) GetCapacityCommitment() *CapacityCommitment {
	if x != nil {
		return x.CapacityCommitment
	}
	return nil
}

func (x *CreateCapacityCommitmentRequest) GetEnforceSingleAdminProjectPerOrg() bool {
	if x != nil {
		return x.EnforceSingleAdminProjectPerOrg
	}
	return false
}

func (x *CreateCapacityCommitmentRequest) GetCapacityCommitmentId() string {
	if x != nil {
		return x.CapacityCommitmentId
	}
	return ""
}

// The request for
// [ReservationService.ListCapacityCommitments][google.cloud.bigquery.reservation.v1.ReservationService.ListCapacityCommitments].
type ListCapacityCommitmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent reservation. E.g.,
	//
	//	`projects/myproject/locations/US`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCapacityCommitmentsRequest) Reset() {
	*x = ListCapacityCommitmentsRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCapacityCommitmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCapacityCommitmentsRequest) ProtoMessage() {}

func (x *ListCapacityCommitmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCapacityCommitmentsRequest.ProtoReflect.Descriptor instead.
func (*ListCapacityCommitmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{17}
}

func (x *ListCapacityCommitmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCapacityCommitmentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCapacityCommitmentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ReservationService.ListCapacityCommitments][google.cloud.bigquery.reservation.v1.ReservationService.ListCapacityCommitments].
type ListCapacityCommitmentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of capacity commitments visible to the user.
	CapacityCommitments []*CapacityCommitment `protobuf:"bytes,1,rep,name=capacity_commitments,json=capacityCommitments,proto3" json:"capacity_commitments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCapacityCommitmentsResponse) Reset() {
	*x = ListCapacityCommitmentsResponse{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCapacityCommitmentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCapacityCommitmentsResponse) ProtoMessage() {}

func (x *ListCapacityCommitmentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCapacityCommitmentsResponse.ProtoReflect.Descriptor instead.
func (*ListCapacityCommitmentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{18}
}

func (x *ListCapacityCommitmentsResponse) GetCapacityCommitments() []*CapacityCommitment {
	if x != nil {
		return x.CapacityCommitments
	}
	return nil
}

func (x *ListCapacityCommitmentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.GetCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.GetCapacityCommitment].
type GetCapacityCommitmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the capacity commitment to retrieve. E.g.,
	//
	//	`projects/myproject/locations/US/capacityCommitments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCapacityCommitmentRequest) Reset() {
	*x = GetCapacityCommitmentRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCapacityCommitmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCapacityCommitmentRequest) ProtoMessage() {}

func (x *GetCapacityCommitmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCapacityCommitmentRequest.ProtoReflect.Descriptor instead.
func (*GetCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{19}
}

func (x *GetCapacityCommitmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ReservationService.DeleteCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.DeleteCapacityCommitment].
type DeleteCapacityCommitmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the capacity commitment to delete. E.g.,
	//
	//	`projects/myproject/locations/US/capacityCommitments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Can be used to force delete commitments even if assignments exist. Deleting
	// commitments with assignments may cause queries to fail if they no longer
	// have access to slots.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteCapacityCommitmentRequest) Reset() {
	*x = DeleteCapacityCommitmentRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCapacityCommitmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCapacityCommitmentRequest) ProtoMessage() {}

func (x *DeleteCapacityCommitmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCapacityCommitmentRequest.ProtoReflect.Descriptor instead.
func (*DeleteCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{20}
}

func (x *DeleteCapacityCommitmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteCapacityCommitmentRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The request for
// [ReservationService.UpdateCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.UpdateCapacityCommitment].
type UpdateCapacityCommitmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content of the capacity commitment to update.
	CapacityCommitment *CapacityCommitment `protobuf:"bytes,1,opt,name=capacity_commitment,json=capacityCommitment,proto3" json:"capacity_commitment,omitempty"`
	// Standard field mask for the set of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCapacityCommitmentRequest) Reset() {
	*x = UpdateCapacityCommitmentRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateCapacityCommitmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCapacityCommitmentRequest) ProtoMessage() {}

func (x *UpdateCapacityCommitmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCapacityCommitmentRequest.ProtoReflect.Descriptor instead.
func (*UpdateCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{21}
}

func (x *UpdateCapacityCommitmentRequest) GetCapacityCommitment() *CapacityCommitment {
	if x != nil {
		return x.CapacityCommitment
	}
	return nil
}

func (x *UpdateCapacityCommitmentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request for
// [ReservationService.SplitCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.SplitCapacityCommitment].
type SplitCapacityCommitmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name e.g.,:
	//
	//	`projects/myproject/locations/US/capacityCommitments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Number of slots in the capacity commitment after the split.
	SlotCount int64 `protobuf:"varint,2,opt,name=slot_count,json=slotCount,proto3" json:"slot_count,omitempty"`
}

func (x *SplitCapacityCommitmentRequest) Reset() {
	*x = SplitCapacityCommitmentRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SplitCapacityCommitmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitCapacityCommitmentRequest) ProtoMessage() {}

func (x *SplitCapacityCommitmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitCapacityCommitmentRequest.ProtoReflect.Descriptor instead.
func (*SplitCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{22}
}

func (x *SplitCapacityCommitmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SplitCapacityCommitmentRequest) GetSlotCount() int64 {
	if x != nil {
		return x.SlotCount
	}
	return 0
}

// The response for
// [ReservationService.SplitCapacityCommitment][google.cloud.bigquery.reservation.v1.ReservationService.SplitCapacityCommitment].
type SplitCapacityCommitmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// First capacity commitment, result of a split.
	First *CapacityCommitment `protobuf:"bytes,1,opt,name=first,proto3" json:"first,omitempty"`
	// Second capacity commitment, result of a split.
	Second *CapacityCommitment `protobuf:"bytes,2,opt,name=second,proto3" json:"second,omitempty"`
}

func (x *SplitCapacityCommitmentResponse) Reset() {
	*x = SplitCapacityCommitmentResponse{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SplitCapacityCommitmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitCapacityCommitmentResponse) ProtoMessage() {}

func (x *SplitCapacityCommitmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitCapacityCommitmentResponse.ProtoReflect.Descriptor instead.
func (*SplitCapacityCommitmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{23}
}

func (x *SplitCapacityCommitmentResponse) GetFirst() *CapacityCommitment {
	if x != nil {
		return x.First
	}
	return nil
}

func (x *SplitCapacityCommitmentResponse) GetSecond() *CapacityCommitment {
	if x != nil {
		return x.Second
	}
	return nil
}

// The request for
// [ReservationService.MergeCapacityCommitments][google.cloud.bigquery.reservation.v1.ReservationService.MergeCapacityCommitments].
type MergeCapacityCommitmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent resource that identifies admin project and location e.g.,
	//
	//	`projects/myproject/locations/us`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Ids of capacity commitments to merge.
	// These capacity commitments must exist under admin project and location
	// specified in the parent.
	// ID is the last portion of capacity commitment name e.g., 'abc' for
	// projects/myproject/locations/US/capacityCommitments/abc
	CapacityCommitmentIds []string `protobuf:"bytes,2,rep,name=capacity_commitment_ids,json=capacityCommitmentIds,proto3" json:"capacity_commitment_ids,omitempty"`
	// Optional. The optional resulting capacity commitment ID. Capacity
	// commitment name will be generated automatically if this field is empty.
	// This field must only contain lower case alphanumeric characters or dashes.
	// The first and last character cannot be a dash. Max length is 64 characters.
	CapacityCommitmentId string `protobuf:"bytes,3,opt,name=capacity_commitment_id,json=capacityCommitmentId,proto3" json:"capacity_commitment_id,omitempty"`
}

func (x *MergeCapacityCommitmentsRequest) Reset() {
	*x = MergeCapacityCommitmentsRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MergeCapacityCommitmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeCapacityCommitmentsRequest) ProtoMessage() {}

func (x *MergeCapacityCommitmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeCapacityCommitmentsRequest.ProtoReflect.Descriptor instead.
func (*MergeCapacityCommitmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{24}
}

func (x *MergeCapacityCommitmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *MergeCapacityCommitmentsRequest) GetCapacityCommitmentIds() []string {
	if x != nil {
		return x.CapacityCommitmentIds
	}
	return nil
}

func (x *MergeCapacityCommitmentsRequest) GetCapacityCommitmentId() string {
	if x != nil {
		return x.CapacityCommitmentId
	}
	return ""
}

// An assignment allows a project to submit jobs
// of a certain type using slots from the specified reservation.
type Assignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the resource. E.g.:
	// `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
	// The assignment_id must only contain lower case alphanumeric characters or
	// dashes and the max length is 64 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The resource which will use the reservation. E.g.
	// `projects/myproject`, `folders/123`, or `organizations/456`.
	Assignee string `protobuf:"bytes,4,opt,name=assignee,proto3" json:"assignee,omitempty"`
	// Optional. Which type of jobs will use the reservation.
	JobType Assignment_JobType `protobuf:"varint,3,opt,name=job_type,json=jobType,proto3,enum=google.cloud.bigquery.reservation.v1.Assignment_JobType" json:"job_type,omitempty"`
	// Output only. State of the assignment.
	State Assignment_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.bigquery.reservation.v1.Assignment_State" json:"state,omitempty"`
	// Optional. This field controls if "Gemini in BigQuery"
	// (https://cloud.google.com/gemini/docs/bigquery/overview) features should be
	// enabled for this reservation assignment, which is not on by default.
	// "Gemini in BigQuery" has a distinct compliance posture from BigQuery.  If
	// this field is set to true, the assignment job type is QUERY, and
	// the parent reservation edition is ENTERPRISE_PLUS, then the assignment will
	// give the grantee project/organization access to "Gemini in BigQuery"
	// features.
	EnableGeminiInBigquery bool `protobuf:"varint,10,opt,name=enable_gemini_in_bigquery,json=enableGeminiInBigquery,proto3" json:"enable_gemini_in_bigquery,omitempty"`
	// Optional. The scheduling policy to use for jobs and queries of this
	// assignee when running under the associated reservation. The scheduling
	// policy controls how the reservation's resources are distributed. This
	// overrides the default scheduling policy specified on the reservation.
	//
	// This feature is not yet generally available.
	SchedulingPolicy *SchedulingPolicy `protobuf:"bytes,11,opt,name=scheduling_policy,json=schedulingPolicy,proto3" json:"scheduling_policy,omitempty"`
}

func (x *Assignment) Reset() {
	*x = Assignment{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Assignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Assignment) ProtoMessage() {}

func (x *Assignment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Assignment.ProtoReflect.Descriptor instead.
func (*Assignment) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{25}
}

func (x *Assignment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Assignment) GetAssignee() string {
	if x != nil {
		return x.Assignee
	}
	return ""
}

func (x *Assignment) GetJobType() Assignment_JobType {
	if x != nil {
		return x.JobType
	}
	return Assignment_JOB_TYPE_UNSPECIFIED
}

func (x *Assignment) GetState() Assignment_State {
	if x != nil {
		return x.State
	}
	return Assignment_STATE_UNSPECIFIED
}

func (x *Assignment) GetEnableGeminiInBigquery() bool {
	if x != nil {
		return x.EnableGeminiInBigquery
	}
	return false
}

func (x *Assignment) GetSchedulingPolicy() *SchedulingPolicy {
	if x != nil {
		return x.SchedulingPolicy
	}
	return nil
}

// The request for
// [ReservationService.CreateAssignment][google.cloud.bigquery.reservation.v1.ReservationService.CreateAssignment].
// Note: "bigquery.reservationAssignments.create" permission is required on the
// related assignee.
type CreateAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name of the assignment
	// E.g. `projects/myproject/locations/US/reservations/team1-prod`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Assignment resource to create.
	Assignment *Assignment `protobuf:"bytes,2,opt,name=assignment,proto3" json:"assignment,omitempty"`
	// The optional assignment ID. Assignment name will be generated automatically
	// if this field is empty.
	// This field must only contain lower case alphanumeric characters or dashes.
	// Max length is 64 characters.
	AssignmentId string `protobuf:"bytes,4,opt,name=assignment_id,json=assignmentId,proto3" json:"assignment_id,omitempty"`
}

func (x *CreateAssignmentRequest) Reset() {
	*x = CreateAssignmentRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAssignmentRequest) ProtoMessage() {}

func (x *CreateAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAssignmentRequest.ProtoReflect.Descriptor instead.
func (*CreateAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{26}
}

func (x *CreateAssignmentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAssignmentRequest) GetAssignment() *Assignment {
	if x != nil {
		return x.Assignment
	}
	return nil
}

func (x *CreateAssignmentRequest) GetAssignmentId() string {
	if x != nil {
		return x.AssignmentId
	}
	return ""
}

// The request for
// [ReservationService.ListAssignments][google.cloud.bigquery.reservation.v1.ReservationService.ListAssignments].
type ListAssignmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name e.g.:
	//
	// `projects/myproject/locations/US/reservations/team1-prod`
	//
	// Or:
	//
	// `projects/myproject/locations/US/reservations/-`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAssignmentsRequest) Reset() {
	*x = ListAssignmentsRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAssignmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssignmentsRequest) ProtoMessage() {}

func (x *ListAssignmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssignmentsRequest.ProtoReflect.Descriptor instead.
func (*ListAssignmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{27}
}

func (x *ListAssignmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAssignmentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAssignmentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ReservationService.ListAssignments][google.cloud.bigquery.reservation.v1.ReservationService.ListAssignments].
type ListAssignmentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of assignments visible to the user.
	Assignments []*Assignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAssignmentsResponse) Reset() {
	*x = ListAssignmentsResponse{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAssignmentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssignmentsResponse) ProtoMessage() {}

func (x *ListAssignmentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssignmentsResponse.ProtoReflect.Descriptor instead.
func (*ListAssignmentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{28}
}

func (x *ListAssignmentsResponse) GetAssignments() []*Assignment {
	if x != nil {
		return x.Assignments
	}
	return nil
}

func (x *ListAssignmentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.DeleteAssignment][google.cloud.bigquery.reservation.v1.ReservationService.DeleteAssignment].
// Note: "bigquery.reservationAssignments.delete" permission is required on the
// related assignee.
type DeleteAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource, e.g.
	//
	//	`projects/myproject/locations/US/reservations/team1-prod/assignments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAssignmentRequest) Reset() {
	*x = DeleteAssignmentRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAssignmentRequest) ProtoMessage() {}

func (x *DeleteAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAssignmentRequest.ProtoReflect.Descriptor instead.
func (*DeleteAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{29}
}

func (x *DeleteAssignmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ReservationService.SearchAssignments][google.cloud.bigquery.reservation.v1.ReservationService.SearchAssignments].
// Note: "bigquery.reservationAssignments.search" permission is required on the
// related assignee.
type SearchAssignmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the admin project(containing project and
	// location), e.g.:
	//
	//	`projects/myproject/locations/US`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Please specify resource name as assignee in the query.
	//
	// Examples:
	//
	// * `assignee=projects/myproject`
	// * `assignee=folders/123`
	// * `assignee=organizations/456`
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of items to return per page.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchAssignmentsRequest) Reset() {
	*x = SearchAssignmentsRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchAssignmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAssignmentsRequest) ProtoMessage() {}

func (x *SearchAssignmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAssignmentsRequest.ProtoReflect.Descriptor instead.
func (*SearchAssignmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{30}
}

func (x *SearchAssignmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchAssignmentsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchAssignmentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAssignmentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The request for
// [ReservationService.SearchAllAssignments][google.cloud.bigquery.reservation.v1.ReservationService.SearchAllAssignments].
// Note: "bigquery.reservationAssignments.search" permission is required on the
// related assignee.
type SearchAllAssignmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name with location (project name could be the
	// wildcard '-'), e.g.:
	//
	//	`projects/-/locations/US`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Please specify resource name as assignee in the query.
	//
	// Examples:
	//
	// * `assignee=projects/myproject`
	// * `assignee=folders/123`
	// * `assignee=organizations/456`
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of items to return per page.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchAllAssignmentsRequest) Reset() {
	*x = SearchAllAssignmentsRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchAllAssignmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllAssignmentsRequest) ProtoMessage() {}

func (x *SearchAllAssignmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllAssignmentsRequest.ProtoReflect.Descriptor instead.
func (*SearchAllAssignmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{31}
}

func (x *SearchAllAssignmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchAllAssignmentsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchAllAssignmentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAllAssignmentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ReservationService.SearchAssignments][google.cloud.bigquery.reservation.v1.ReservationService.SearchAssignments].
type SearchAssignmentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of assignments visible to the user.
	Assignments []*Assignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAssignmentsResponse) Reset() {
	*x = SearchAssignmentsResponse{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchAssignmentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAssignmentsResponse) ProtoMessage() {}

func (x *SearchAssignmentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAssignmentsResponse.ProtoReflect.Descriptor instead.
func (*SearchAssignmentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{32}
}

func (x *SearchAssignmentsResponse) GetAssignments() []*Assignment {
	if x != nil {
		return x.Assignments
	}
	return nil
}

func (x *SearchAssignmentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The response for
// [ReservationService.SearchAllAssignments][google.cloud.bigquery.reservation.v1.ReservationService.SearchAllAssignments].
type SearchAllAssignmentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of assignments visible to the user.
	Assignments []*Assignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAllAssignmentsResponse) Reset() {
	*x = SearchAllAssignmentsResponse{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchAllAssignmentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllAssignmentsResponse) ProtoMessage() {}

func (x *SearchAllAssignmentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllAssignmentsResponse.ProtoReflect.Descriptor instead.
func (*SearchAllAssignmentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{33}
}

func (x *SearchAllAssignmentsResponse) GetAssignments() []*Assignment {
	if x != nil {
		return x.Assignments
	}
	return nil
}

func (x *SearchAllAssignmentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.MoveAssignment][google.cloud.bigquery.reservation.v1.ReservationService.MoveAssignment].
//
// **Note**: "bigquery.reservationAssignments.create" permission is required on
// the destination_id.
//
// **Note**: "bigquery.reservationAssignments.create" and
// "bigquery.reservationAssignments.delete" permission are required on the
// related assignee.
type MoveAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the assignment,
	// e.g.
	// `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The new reservation ID, e.g.:
	//
	//	`projects/myotherproject/locations/US/reservations/team2-prod`
	DestinationId string `protobuf:"bytes,3,opt,name=destination_id,json=destinationId,proto3" json:"destination_id,omitempty"`
	// The optional assignment ID. A new assignment name is generated if this
	// field is empty.
	//
	// This field can contain only lowercase alphanumeric characters or dashes.
	// Max length is 64 characters.
	AssignmentId string `protobuf:"bytes,5,opt,name=assignment_id,json=assignmentId,proto3" json:"assignment_id,omitempty"`
}

func (x *MoveAssignmentRequest) Reset() {
	*x = MoveAssignmentRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveAssignmentRequest) ProtoMessage() {}

func (x *MoveAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveAssignmentRequest.ProtoReflect.Descriptor instead.
func (*MoveAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{34}
}

func (x *MoveAssignmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MoveAssignmentRequest) GetDestinationId() string {
	if x != nil {
		return x.DestinationId
	}
	return ""
}

func (x *MoveAssignmentRequest) GetAssignmentId() string {
	if x != nil {
		return x.AssignmentId
	}
	return ""
}

// The request for
// [ReservationService.UpdateAssignment][google.cloud.bigquery.reservation.v1.ReservationService.UpdateAssignment].
type UpdateAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content of the assignment to update.
	Assignment *Assignment `protobuf:"bytes,1,opt,name=assignment,proto3" json:"assignment,omitempty"`
	// Standard field mask for the set of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAssignmentRequest) Reset() {
	*x = UpdateAssignmentRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAssignmentRequest) ProtoMessage() {}

func (x *UpdateAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAssignmentRequest.ProtoReflect.Descriptor instead.
func (*UpdateAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{35}
}

func (x *UpdateAssignmentRequest) GetAssignment() *Assignment {
	if x != nil {
		return x.Assignment
	}
	return nil
}

func (x *UpdateAssignmentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Fully qualified reference to BigQuery table.
// Internally stored as google.cloud.bi.v1.BqTableReference.
type TableReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The assigned project ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Optional. The ID of the dataset in the above project.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Optional. The ID of the table in the above dataset.
	TableId string `protobuf:"bytes,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
}

func (x *TableReference) Reset() {
	*x = TableReference{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TableReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableReference) ProtoMessage() {}

func (x *TableReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableReference.ProtoReflect.Descriptor instead.
func (*TableReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{36}
}

func (x *TableReference) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *TableReference) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *TableReference) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

// Represents a BI Reservation.
type BiReservation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the singleton BI reservation.
	// Reservation names have the form
	// `projects/{project_id}/locations/{location_id}/biReservation`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The last update timestamp of a reservation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Size of a reservation, in bytes.
	Size int64 `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	// Optional. Preferred tables to use BI capacity for.
	PreferredTables []*TableReference `protobuf:"bytes,5,rep,name=preferred_tables,json=preferredTables,proto3" json:"preferred_tables,omitempty"`
}

func (x *BiReservation) Reset() {
	*x = BiReservation{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BiReservation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BiReservation) ProtoMessage() {}

func (x *BiReservation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BiReservation.ProtoReflect.Descriptor instead.
func (*BiReservation) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{37}
}

func (x *BiReservation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BiReservation) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BiReservation) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *BiReservation) GetPreferredTables() []*TableReference {
	if x != nil {
		return x.PreferredTables
	}
	return nil
}

// A request to get a singleton BI reservation.
type GetBiReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the requested reservation, for example:
	// `projects/{project_id}/locations/{location_id}/biReservation`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBiReservationRequest) Reset() {
	*x = GetBiReservationRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBiReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBiReservationRequest) ProtoMessage() {}

func (x *GetBiReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBiReservationRequest.ProtoReflect.Descriptor instead.
func (*GetBiReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{38}
}

func (x *GetBiReservationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to update a BI reservation.
type UpdateBiReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A reservation to update.
	BiReservation *BiReservation `protobuf:"bytes,1,opt,name=bi_reservation,json=biReservation,proto3" json:"bi_reservation,omitempty"`
	// A list of fields to be updated in this request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBiReservationRequest) Reset() {
	*x = UpdateBiReservationRequest{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBiReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBiReservationRequest) ProtoMessage() {}

func (x *UpdateBiReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBiReservationRequest.ProtoReflect.Descriptor instead.
func (*UpdateBiReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{39}
}

func (x *UpdateBiReservationRequest) GetBiReservation() *BiReservation {
	if x != nil {
		return x.BiReservation
	}
	return nil
}

func (x *UpdateBiReservationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Auto scaling settings.
type Reservation_Autoscale struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The slot capacity added to this reservation when autoscale
	// happens. Will be between [0, max_slots]. Note: after users reduce
	// max_slots, it may take a while before it can be propagated, so
	// current_slots may stay in the original value and could be larger than
	// max_slots for that brief period (less than one minute)
	CurrentSlots int64 `protobuf:"varint,1,opt,name=current_slots,json=currentSlots,proto3" json:"current_slots,omitempty"`
	// Optional. Number of slots to be scaled when needed.
	MaxSlots int64 `protobuf:"varint,2,opt,name=max_slots,json=maxSlots,proto3" json:"max_slots,omitempty"`
}

func (x *Reservation_Autoscale) Reset() {
	*x = Reservation_Autoscale{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Reservation_Autoscale) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Reservation_Autoscale) ProtoMessage() {}

func (x *Reservation_Autoscale) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Reservation_Autoscale.ProtoReflect.Descriptor instead.
func (*Reservation_Autoscale) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Reservation_Autoscale) GetCurrentSlots() int64 {
	if x != nil {
		return x.CurrentSlots
	}
	return 0
}

func (x *Reservation_Autoscale) GetMaxSlots() int64 {
	if x != nil {
		return x.MaxSlots
	}
	return 0
}

// Disaster Recovery(DR) replication status of the reservation.
type Reservation_ReplicationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The last error encountered while trying to replicate changes
	// from the primary to the secondary. This field is only available if the
	// replication has not succeeded since.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. The time at which the last error was encountered while
	// trying to replicate changes from the primary to the secondary. This field
	// is only available if the replication has not succeeded since.
	LastErrorTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_error_time,json=lastErrorTime,proto3" json:"last_error_time,omitempty"`
	// Output only. A timestamp corresponding to the last change on the primary
	// that was successfully replicated to the secondary.
	LastReplicationTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=last_replication_time,json=lastReplicationTime,proto3" json:"last_replication_time,omitempty"`
	// Output only. The time at which a soft failover for the reservation and
	// its associated datasets was initiated. After this field is set, all
	// subsequent changes to the reservation will be rejected unless a hard
	// failover overrides this operation. This field will be cleared once the
	// failover is complete.
	SoftFailoverStartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=soft_failover_start_time,json=softFailoverStartTime,proto3" json:"soft_failover_start_time,omitempty"`
}

func (x *Reservation_ReplicationStatus) Reset() {
	*x = Reservation_ReplicationStatus{}
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Reservation_ReplicationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Reservation_ReplicationStatus) ProtoMessage() {}

func (x *Reservation_ReplicationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Reservation_ReplicationStatus.ProtoReflect.Descriptor instead.
func (*Reservation_ReplicationStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Reservation_ReplicationStatus) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *Reservation_ReplicationStatus) GetLastErrorTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastErrorTime
	}
	return nil
}

func (x *Reservation_ReplicationStatus) GetLastReplicationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastReplicationTime
	}
	return nil
}

func (x *Reservation_ReplicationStatus) GetSoftFailoverStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SoftFailoverStartTime
	}
	return nil
}

var File_google_cloud_bigquery_reservation_v1_reservation_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31,
	0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xeb, 0x0f, 0x0a, 0x0b, 0x52, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x28, 0x0a, 0x0d, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x6c, 0x6f,
	0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x12, 0x2f, 0x0a, 0x11, 0x69, 0x67, 0x6e,
	0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x67, 0x6e, 0x6f, 0x72,
	0x65, 0x49, 0x64, 0x6c, 0x65, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x12, 0x5e, 0x0a, 0x09, 0x61, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x63, 0x6f,
	0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x79, 0x12, 0x44, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x16, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69,
	0x61, 0x72, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x14, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x41, 0x75, 0x78, 0x69, 0x6c, 0x69,
	0x61, 0x72, 0x79, 0x12, 0x4c, 0x0a, 0x07, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x54, 0x0a, 0x10, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x12, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x65, 0x0a, 0x19, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x17, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f,
	0x73, 0x6c, 0x6f, 0x74, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x65, 0x0a, 0x0c, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x5a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x30, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x77, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x68, 0x0a,
	0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x57, 0x0a, 0x09, 0x41, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x6c, 0x6f, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x12, 0x20,
	0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x53, 0x6c, 0x6f, 0x74, 0x73,
	0x1a, 0xba, 0x02, 0x0a, 0x11, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x47, 0x0a, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x6c, 0x61, 0x73, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x53,
	0x0a, 0x15, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13,
	0x6c, 0x61, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x18, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x66, 0x61, 0x69, 0x6c,
	0x6f, 0x76, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x73, 0x6f, 0x66, 0x74, 0x46, 0x61, 0x69, 0x6c,
	0x6f, 0x76, 0x65, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x63, 0x0a, 0x0b, 0x53, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x43, 0x41, 0x4c, 0x49,
	0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x55, 0x54, 0x4f, 0x53, 0x43, 0x41,
	0x4c, 0x45, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x49, 0x44, 0x4c,
	0x45, 0x5f, 0x53, 0x4c, 0x4f, 0x54, 0x53, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0d,
	0x0a, 0x09, 0x41, 0x4c, 0x4c, 0x5f, 0x53, 0x4c, 0x4f, 0x54, 0x53, 0x10, 0x03, 0x3a, 0x77, 0xea,
	0x41, 0x74, 0x0a, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x42, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x73,
	0x6c, 0x6f, 0x74, 0x73, 0x22, 0x83, 0x01, 0x0a, 0x10, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2a, 0x0a, 0x0b, 0x63, 0x6f, 0x6e,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x79, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x6c, 0x6f,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52,
	0x08, 0x6d, 0x61, 0x78, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c,
	0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x42, 0x0c, 0x0a, 0x0a,
	0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x22, 0xdb, 0x01, 0x0a, 0x10, 0x52,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0xad, 0x01, 0xea, 0x41, 0xa9, 0x01, 0x0a,
	0x33, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x4d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f,
	0x7b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x7d, 0x2a, 0x11, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x32, 0x10, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xb7, 0x09, 0x0a, 0x12, 0x43, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x6c, 0x6f, 0x74,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x73, 0x6c, 0x6f, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x60, 0x0a, 0x04,
	0x70, 0x6c, 0x61, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x6c, 0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x12, 0x59,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x53, 0x0a, 0x15, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f,
	0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3e, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x6f, 0x0a, 0x0c, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x50, 0x6c, 0x61, 0x6e,
	0x12, 0x38, 0x0a, 0x16, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x14, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x52, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x41, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x12, 0x4c, 0x0a, 0x07, 0x65, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0c, 0x69, 0x73, 0x5f, 0x66,
	0x6c, 0x61, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x69, 0x73, 0x46, 0x6c, 0x61, 0x74, 0x52, 0x61, 0x74, 0x65, 0x22,
	0xca, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c,
	0x61, 0x6e, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x4c, 0x45, 0x58, 0x10, 0x03, 0x12, 0x16, 0x0a,
	0x0e, 0x46, 0x4c, 0x45, 0x58, 0x5f, 0x46, 0x4c, 0x41, 0x54, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x10,
	0x07, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x0d, 0x0a, 0x05, 0x54, 0x52, 0x49, 0x41, 0x4c, 0x10, 0x05,
	0x1a, 0x02, 0x08, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10,
	0x02, 0x12, 0x19, 0x0a, 0x11, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x5f, 0x46, 0x4c, 0x41,
	0x54, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x10, 0x08, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x4e, 0x4e, 0x55, 0x41, 0x4c, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x10, 0x41, 0x4e, 0x4e, 0x55,
	0x41, 0x4c, 0x5f, 0x46, 0x4c, 0x41, 0x54, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x10, 0x09, 0x1a, 0x02,
	0x08, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x48, 0x52, 0x45, 0x45, 0x5f, 0x59, 0x45, 0x41, 0x52,
	0x10, 0x0a, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x06, 0x22, 0x43, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x03, 0x3a, 0x8e, 0x01, 0xea, 0x41, 0x8a, 0x01, 0x0a, 0x35, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x7d, 0x22, 0xe6, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x25, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa5, 0x01, 0x0a, 0x17,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x99, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x55, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x63, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xac, 0x01, 0x0a,
	0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x0b, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xc6, 0x01, 0x0a, 0x1a,
	0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30,
	0x0a, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76,
	0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x4d, 0x6f, 0x64,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x65, 0x22, 0x95, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x12, 0x33,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x14, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x49, 0x64, 0x12, 0x68, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x6d, 0x0a, 0x1a,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35,
	0x0a, 0x33, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xaf, 0x01, 0x0a, 0x1c,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x35, 0x12, 0x33, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xae, 0x01,
	0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x65, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x11, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x70,
	0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xe8, 0x02, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x3d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37, 0x12, 0x35, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x69, 0x0a, 0x13, 0x63,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x12, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x24, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x5f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6f, 0x72, 0x67, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x1f, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x50,
	0x65, 0x72, 0x4f, 0x72, 0x67, 0x12, 0x34, 0x0a, 0x16, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0xb3, 0x01, 0x0a, 0x1e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37, 0x12, 0x35, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xb6, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6b, 0x0a, 0x14, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x13, 0x63,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x71, 0x0a, 0x1c, 0x47, 0x65,
	0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37,
	0x0a, 0x35, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8a, 0x01,
	0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x51, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x3d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37, 0x0a, 0x35, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x70, 0x61,
	0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xc9, 0x01, 0x0a, 0x1f, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x69,
	0x0a, 0x13, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x92, 0x01, 0x0a, 0x1e, 0x53, 0x70, 0x6c, 0x69, 0x74,
	0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37, 0x0a,
	0x35, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x09, 0x73, 0x6c, 0x6f, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xc3, 0x01, 0x0a, 0x1f,
	0x53, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4e, 0x0a, 0x05, 0x66, 0x69, 0x72, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x66, 0x69, 0x72, 0x73, 0x74, 0x12,
	0x50, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x22, 0xe8, 0x01, 0x0a, 0x1f, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xfa, 0x41, 0x37, 0x12, 0x35, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x63, 0x61, 0x70, 0x61,
	0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x73, 0x12, 0x39, 0x0a, 0x16, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0xe1, 0x06, 0x0a,
	0x0a, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x61, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x65, 0x65, 0x12, 0x58, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x51, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x3e, 0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x67, 0x65, 0x6d,
	0x69, 0x6e, 0x69, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x47, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x49, 0x6e, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x68, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xdc, 0x01, 0x0a,
	0x07, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4a, 0x4f, 0x42, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x01,
	0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x4d,
	0x4c, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a,
	0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a,
	0x43, 0x4f, 0x4e, 0x54, 0x49, 0x4e, 0x55, 0x4f, 0x55, 0x53, 0x10, 0x06, 0x12, 0x22, 0x0a, 0x1e,
	0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47,
	0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x43, 0x41, 0x50, 0x54, 0x55, 0x52, 0x45, 0x10, 0x07,
	0x12, 0x24, 0x0a, 0x20, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x43,
	0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x49,
	0x4e, 0x44, 0x45, 0x58, 0x10, 0x08, 0x12, 0x23, 0x0a, 0x1f, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52,
	0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x49, 0x4e, 0x44, 0x45,
	0x58, 0x5f, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53, 0x48, 0x10, 0x09, 0x22, 0x37, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x02, 0x3a, 0xa9, 0x01, 0xea, 0x41, 0xa5, 0x01, 0x0a, 0x2d, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2a, 0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x32, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0xdf, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0a, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a,
	0x0d, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x49, 0x64, 0x22, 0xa3, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x95, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x61, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x64, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2f, 0x0a, 0x2d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xaf, 0x01, 0x0a, 0x18, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb2, 0x01, 0x0a, 0x1b, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x97, 0x01,
	0x0a, 0x19, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0b, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9a, 0x01, 0x0a, 0x1c, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x6c, 0x6c, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe2, 0x01, 0x0a, 0x15, 0x4d, 0x6f, 0x76, 0x65, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x0e, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x32, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0xa8, 0x01, 0x0a, 0x17, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x61, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x78, 0x0a, 0x0e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1e,
	0x0a, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x22, 0xd7,
	0x02, 0x0a, 0x0d, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x73, 0x69, 0x7a, 0x65, 0x12, 0x64, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65,
	0x64, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x72, 0x65, 0x64, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x3a, 0x6c, 0xea, 0x41, 0x69, 0x0a,
	0x30, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x35, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x69, 0x52, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x42,
	0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69,
	0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xb5, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69, 0x52, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x5a, 0x0a, 0x0e, 0x62, 0x69, 0x5f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x62,
	0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x2a, 0x55, 0x0a, 0x07, 0x45, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x45,
	0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49, 0x53, 0x45, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x45,
	0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49, 0x53, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x53, 0x10, 0x03,
	0x2a, 0x41, 0x0a, 0x0c, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x1d, 0x0a, 0x19, 0x46, 0x41, 0x49, 0x4c, 0x4f, 0x56, 0x45, 0x52, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x08, 0x0a, 0x04, 0x53, 0x4f, 0x46, 0x54, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x41, 0x52,
	0x44, 0x10, 0x02, 0x32, 0xa3, 0x36, 0x0a, 0x12, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xf1, 0x01, 0x0a, 0x11, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x69, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a,
	0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x30, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xd4,
	0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc1, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xac, 0x01, 0x0a, 0x11, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf3, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x6b, 0xda, 0x41, 0x17, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4b, 0x3a, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x32, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdb,
	0x01, 0x0a, 0x13, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61,
	0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4f, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x49, 0x3a, 0x01, 0x2a, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8e, 0x02, 0x0a,
	0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x71, 0xda, 0x41, 0x1a, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a,
	0x13, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xf0, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0xdd, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xc1, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x46, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa8, 0x02, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x8a, 0x01, 0xda, 0x41, 0x1f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x62, 0x3a, 0x13, 0x63,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x32, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0x82, 0x02, 0x0a, 0x17, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a, 0xda, 0x41, 0x0f, 0x6e, 0x61, 0x6d,
	0x65, 0x2c, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x70, 0x6c, 0x69, 0x74, 0x12, 0x86, 0x02, 0x0a, 0x18, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x43, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x43, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x69, 0xda, 0x41, 0x1e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x12, 0xeb, 0x01,
	0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x22, 0x66, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a,
	0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x3e, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xdf, 0x01, 0x0a, 0x0f,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4f, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x12, 0x3e, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xb8, 0x01,
	0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x2a, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe5, 0x01, 0x0a, 0x11, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x4f, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x88, 0x02, 0x01,
	0x12, 0xee, 0x01, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x4f, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0xe5, 0x01, 0x0a, 0x0e, 0x4d, 0x6f, 0x76, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x76, 0x65,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x22, 0x64, 0xda, 0x41, 0x13, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x48, 0x3a, 0x01, 0x2a, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x6f, 0x76, 0x65, 0x12, 0xfb, 0x01, 0x0a, 0x10, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0x76, 0xda, 0x41, 0x16, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57,
	0x3a, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x49, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc6, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x42,
	0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12,
	0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x62, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x12, 0x81, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69, 0x52, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x73, 0xda, 0x41, 0x1a, 0x62, 0x69, 0x5f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x50, 0x3a, 0x0e, 0x62, 0x69, 0x5f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x32, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x62, 0x69, 0x5f, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x12, 0xf4, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x22, 0xa8, 0x01, 0xda, 0x41, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x96, 0x01, 0x5a, 0x51, 0x12, 0x4f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67,
	0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x81, 0x02, 0x0a, 0x0c,
	0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xb5, 0x01, 0xda, 0x41, 0x0f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x9c, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x54, 0x3a, 0x01, 0x2a, 0x22, 0x4f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x41, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x9b, 0x02, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xaf, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0xa8, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x5a, 0x3a, 0x01, 0x2a, 0x22, 0x55, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe7, 0x01,
	0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x11, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0xd5, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xbb, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe8, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x1a, 0x7f, 0xca, 0x41, 0x22, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x57, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd8, 0x01, 0x0a, 0x28, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x52,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x24,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x5c, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescData = file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDesc
)

func file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescData)
	})
	return file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDescData
}

var file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes = make([]protoimpl.MessageInfo, 43)
var file_google_cloud_bigquery_reservation_v1_reservation_proto_goTypes = []any{
	(Edition)(0),                             // 0: google.cloud.bigquery.reservation.v1.Edition
	(FailoverMode)(0),                        // 1: google.cloud.bigquery.reservation.v1.FailoverMode
	(Reservation_ScalingMode)(0),             // 2: google.cloud.bigquery.reservation.v1.Reservation.ScalingMode
	(CapacityCommitment_CommitmentPlan)(0),   // 3: google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan
	(CapacityCommitment_State)(0),            // 4: google.cloud.bigquery.reservation.v1.CapacityCommitment.State
	(Assignment_JobType)(0),                  // 5: google.cloud.bigquery.reservation.v1.Assignment.JobType
	(Assignment_State)(0),                    // 6: google.cloud.bigquery.reservation.v1.Assignment.State
	(*Reservation)(nil),                      // 7: google.cloud.bigquery.reservation.v1.Reservation
	(*SchedulingPolicy)(nil),                 // 8: google.cloud.bigquery.reservation.v1.SchedulingPolicy
	(*ReservationGroup)(nil),                 // 9: google.cloud.bigquery.reservation.v1.ReservationGroup
	(*CapacityCommitment)(nil),               // 10: google.cloud.bigquery.reservation.v1.CapacityCommitment
	(*CreateReservationRequest)(nil),         // 11: google.cloud.bigquery.reservation.v1.CreateReservationRequest
	(*ListReservationsRequest)(nil),          // 12: google.cloud.bigquery.reservation.v1.ListReservationsRequest
	(*ListReservationsResponse)(nil),         // 13: google.cloud.bigquery.reservation.v1.ListReservationsResponse
	(*GetReservationRequest)(nil),            // 14: google.cloud.bigquery.reservation.v1.GetReservationRequest
	(*DeleteReservationRequest)(nil),         // 15: google.cloud.bigquery.reservation.v1.DeleteReservationRequest
	(*UpdateReservationRequest)(nil),         // 16: google.cloud.bigquery.reservation.v1.UpdateReservationRequest
	(*FailoverReservationRequest)(nil),       // 17: google.cloud.bigquery.reservation.v1.FailoverReservationRequest
	(*CreateReservationGroupRequest)(nil),    // 18: google.cloud.bigquery.reservation.v1.CreateReservationGroupRequest
	(*GetReservationGroupRequest)(nil),       // 19: google.cloud.bigquery.reservation.v1.GetReservationGroupRequest
	(*ListReservationGroupsRequest)(nil),     // 20: google.cloud.bigquery.reservation.v1.ListReservationGroupsRequest
	(*ListReservationGroupsResponse)(nil),    // 21: google.cloud.bigquery.reservation.v1.ListReservationGroupsResponse
	(*DeleteReservationGroupRequest)(nil),    // 22: google.cloud.bigquery.reservation.v1.DeleteReservationGroupRequest
	(*CreateCapacityCommitmentRequest)(nil),  // 23: google.cloud.bigquery.reservation.v1.CreateCapacityCommitmentRequest
	(*ListCapacityCommitmentsRequest)(nil),   // 24: google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsRequest
	(*ListCapacityCommitmentsResponse)(nil),  // 25: google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsResponse
	(*GetCapacityCommitmentRequest)(nil),     // 26: google.cloud.bigquery.reservation.v1.GetCapacityCommitmentRequest
	(*DeleteCapacityCommitmentRequest)(nil),  // 27: google.cloud.bigquery.reservation.v1.DeleteCapacityCommitmentRequest
	(*UpdateCapacityCommitmentRequest)(nil),  // 28: google.cloud.bigquery.reservation.v1.UpdateCapacityCommitmentRequest
	(*SplitCapacityCommitmentRequest)(nil),   // 29: google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentRequest
	(*SplitCapacityCommitmentResponse)(nil),  // 30: google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentResponse
	(*MergeCapacityCommitmentsRequest)(nil),  // 31: google.cloud.bigquery.reservation.v1.MergeCapacityCommitmentsRequest
	(*Assignment)(nil),                       // 32: google.cloud.bigquery.reservation.v1.Assignment
	(*CreateAssignmentRequest)(nil),          // 33: google.cloud.bigquery.reservation.v1.CreateAssignmentRequest
	(*ListAssignmentsRequest)(nil),           // 34: google.cloud.bigquery.reservation.v1.ListAssignmentsRequest
	(*ListAssignmentsResponse)(nil),          // 35: google.cloud.bigquery.reservation.v1.ListAssignmentsResponse
	(*DeleteAssignmentRequest)(nil),          // 36: google.cloud.bigquery.reservation.v1.DeleteAssignmentRequest
	(*SearchAssignmentsRequest)(nil),         // 37: google.cloud.bigquery.reservation.v1.SearchAssignmentsRequest
	(*SearchAllAssignmentsRequest)(nil),      // 38: google.cloud.bigquery.reservation.v1.SearchAllAssignmentsRequest
	(*SearchAssignmentsResponse)(nil),        // 39: google.cloud.bigquery.reservation.v1.SearchAssignmentsResponse
	(*SearchAllAssignmentsResponse)(nil),     // 40: google.cloud.bigquery.reservation.v1.SearchAllAssignmentsResponse
	(*MoveAssignmentRequest)(nil),            // 41: google.cloud.bigquery.reservation.v1.MoveAssignmentRequest
	(*UpdateAssignmentRequest)(nil),          // 42: google.cloud.bigquery.reservation.v1.UpdateAssignmentRequest
	(*TableReference)(nil),                   // 43: google.cloud.bigquery.reservation.v1.TableReference
	(*BiReservation)(nil),                    // 44: google.cloud.bigquery.reservation.v1.BiReservation
	(*GetBiReservationRequest)(nil),          // 45: google.cloud.bigquery.reservation.v1.GetBiReservationRequest
	(*UpdateBiReservationRequest)(nil),       // 46: google.cloud.bigquery.reservation.v1.UpdateBiReservationRequest
	(*Reservation_Autoscale)(nil),            // 47: google.cloud.bigquery.reservation.v1.Reservation.Autoscale
	(*Reservation_ReplicationStatus)(nil),    // 48: google.cloud.bigquery.reservation.v1.Reservation.ReplicationStatus
	nil,                                      // 49: google.cloud.bigquery.reservation.v1.Reservation.LabelsEntry
	(*timestamppb.Timestamp)(nil),            // 50: google.protobuf.Timestamp
	(*status.Status)(nil),                    // 51: google.rpc.Status
	(*fieldmaskpb.FieldMask)(nil),            // 52: google.protobuf.FieldMask
	(*iampb.GetIamPolicyRequest)(nil),        // 53: google.iam.v1.GetIamPolicyRequest
	(*iampb.SetIamPolicyRequest)(nil),        // 54: google.iam.v1.SetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),  // 55: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                    // 56: google.protobuf.Empty
	(*iampb.Policy)(nil),                     // 57: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil), // 58: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_bigquery_reservation_v1_reservation_proto_depIdxs = []int32{
	47, // 0: google.cloud.bigquery.reservation.v1.Reservation.autoscale:type_name -> google.cloud.bigquery.reservation.v1.Reservation.Autoscale
	50, // 1: google.cloud.bigquery.reservation.v1.Reservation.creation_time:type_name -> google.protobuf.Timestamp
	50, // 2: google.cloud.bigquery.reservation.v1.Reservation.update_time:type_name -> google.protobuf.Timestamp
	0,  // 3: google.cloud.bigquery.reservation.v1.Reservation.edition:type_name -> google.cloud.bigquery.reservation.v1.Edition
	2,  // 4: google.cloud.bigquery.reservation.v1.Reservation.scaling_mode:type_name -> google.cloud.bigquery.reservation.v1.Reservation.ScalingMode
	49, // 5: google.cloud.bigquery.reservation.v1.Reservation.labels:type_name -> google.cloud.bigquery.reservation.v1.Reservation.LabelsEntry
	48, // 6: google.cloud.bigquery.reservation.v1.Reservation.replication_status:type_name -> google.cloud.bigquery.reservation.v1.Reservation.ReplicationStatus
	8,  // 7: google.cloud.bigquery.reservation.v1.Reservation.scheduling_policy:type_name -> google.cloud.bigquery.reservation.v1.SchedulingPolicy
	3,  // 8: google.cloud.bigquery.reservation.v1.CapacityCommitment.plan:type_name -> google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan
	4,  // 9: google.cloud.bigquery.reservation.v1.CapacityCommitment.state:type_name -> google.cloud.bigquery.reservation.v1.CapacityCommitment.State
	50, // 10: google.cloud.bigquery.reservation.v1.CapacityCommitment.commitment_start_time:type_name -> google.protobuf.Timestamp
	50, // 11: google.cloud.bigquery.reservation.v1.CapacityCommitment.commitment_end_time:type_name -> google.protobuf.Timestamp
	51, // 12: google.cloud.bigquery.reservation.v1.CapacityCommitment.failure_status:type_name -> google.rpc.Status
	3,  // 13: google.cloud.bigquery.reservation.v1.CapacityCommitment.renewal_plan:type_name -> google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan
	0,  // 14: google.cloud.bigquery.reservation.v1.CapacityCommitment.edition:type_name -> google.cloud.bigquery.reservation.v1.Edition
	7,  // 15: google.cloud.bigquery.reservation.v1.CreateReservationRequest.reservation:type_name -> google.cloud.bigquery.reservation.v1.Reservation
	7,  // 16: google.cloud.bigquery.reservation.v1.ListReservationsResponse.reservations:type_name -> google.cloud.bigquery.reservation.v1.Reservation
	7,  // 17: google.cloud.bigquery.reservation.v1.UpdateReservationRequest.reservation:type_name -> google.cloud.bigquery.reservation.v1.Reservation
	52, // 18: google.cloud.bigquery.reservation.v1.UpdateReservationRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 19: google.cloud.bigquery.reservation.v1.FailoverReservationRequest.failover_mode:type_name -> google.cloud.bigquery.reservation.v1.FailoverMode
	9,  // 20: google.cloud.bigquery.reservation.v1.CreateReservationGroupRequest.reservation_group:type_name -> google.cloud.bigquery.reservation.v1.ReservationGroup
	9,  // 21: google.cloud.bigquery.reservation.v1.ListReservationGroupsResponse.reservation_groups:type_name -> google.cloud.bigquery.reservation.v1.ReservationGroup
	10, // 22: google.cloud.bigquery.reservation.v1.CreateCapacityCommitmentRequest.capacity_commitment:type_name -> google.cloud.bigquery.reservation.v1.CapacityCommitment
	10, // 23: google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsResponse.capacity_commitments:type_name -> google.cloud.bigquery.reservation.v1.CapacityCommitment
	10, // 24: google.cloud.bigquery.reservation.v1.UpdateCapacityCommitmentRequest.capacity_commitment:type_name -> google.cloud.bigquery.reservation.v1.CapacityCommitment
	52, // 25: google.cloud.bigquery.reservation.v1.UpdateCapacityCommitmentRequest.update_mask:type_name -> google.protobuf.FieldMask
	10, // 26: google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentResponse.first:type_name -> google.cloud.bigquery.reservation.v1.CapacityCommitment
	10, // 27: google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentResponse.second:type_name -> google.cloud.bigquery.reservation.v1.CapacityCommitment
	5,  // 28: google.cloud.bigquery.reservation.v1.Assignment.job_type:type_name -> google.cloud.bigquery.reservation.v1.Assignment.JobType
	6,  // 29: google.cloud.bigquery.reservation.v1.Assignment.state:type_name -> google.cloud.bigquery.reservation.v1.Assignment.State
	8,  // 30: google.cloud.bigquery.reservation.v1.Assignment.scheduling_policy:type_name -> google.cloud.bigquery.reservation.v1.SchedulingPolicy
	32, // 31: google.cloud.bigquery.reservation.v1.CreateAssignmentRequest.assignment:type_name -> google.cloud.bigquery.reservation.v1.Assignment
	32, // 32: google.cloud.bigquery.reservation.v1.ListAssignmentsResponse.assignments:type_name -> google.cloud.bigquery.reservation.v1.Assignment
	32, // 33: google.cloud.bigquery.reservation.v1.SearchAssignmentsResponse.assignments:type_name -> google.cloud.bigquery.reservation.v1.Assignment
	32, // 34: google.cloud.bigquery.reservation.v1.SearchAllAssignmentsResponse.assignments:type_name -> google.cloud.bigquery.reservation.v1.Assignment
	32, // 35: google.cloud.bigquery.reservation.v1.UpdateAssignmentRequest.assignment:type_name -> google.cloud.bigquery.reservation.v1.Assignment
	52, // 36: google.cloud.bigquery.reservation.v1.UpdateAssignmentRequest.update_mask:type_name -> google.protobuf.FieldMask
	50, // 37: google.cloud.bigquery.reservation.v1.BiReservation.update_time:type_name -> google.protobuf.Timestamp
	43, // 38: google.cloud.bigquery.reservation.v1.BiReservation.preferred_tables:type_name -> google.cloud.bigquery.reservation.v1.TableReference
	44, // 39: google.cloud.bigquery.reservation.v1.UpdateBiReservationRequest.bi_reservation:type_name -> google.cloud.bigquery.reservation.v1.BiReservation
	52, // 40: google.cloud.bigquery.reservation.v1.UpdateBiReservationRequest.update_mask:type_name -> google.protobuf.FieldMask
	51, // 41: google.cloud.bigquery.reservation.v1.Reservation.ReplicationStatus.error:type_name -> google.rpc.Status
	50, // 42: google.cloud.bigquery.reservation.v1.Reservation.ReplicationStatus.last_error_time:type_name -> google.protobuf.Timestamp
	50, // 43: google.cloud.bigquery.reservation.v1.Reservation.ReplicationStatus.last_replication_time:type_name -> google.protobuf.Timestamp
	50, // 44: google.cloud.bigquery.reservation.v1.Reservation.ReplicationStatus.soft_failover_start_time:type_name -> google.protobuf.Timestamp
	11, // 45: google.cloud.bigquery.reservation.v1.ReservationService.CreateReservation:input_type -> google.cloud.bigquery.reservation.v1.CreateReservationRequest
	12, // 46: google.cloud.bigquery.reservation.v1.ReservationService.ListReservations:input_type -> google.cloud.bigquery.reservation.v1.ListReservationsRequest
	14, // 47: google.cloud.bigquery.reservation.v1.ReservationService.GetReservation:input_type -> google.cloud.bigquery.reservation.v1.GetReservationRequest
	15, // 48: google.cloud.bigquery.reservation.v1.ReservationService.DeleteReservation:input_type -> google.cloud.bigquery.reservation.v1.DeleteReservationRequest
	16, // 49: google.cloud.bigquery.reservation.v1.ReservationService.UpdateReservation:input_type -> google.cloud.bigquery.reservation.v1.UpdateReservationRequest
	17, // 50: google.cloud.bigquery.reservation.v1.ReservationService.FailoverReservation:input_type -> google.cloud.bigquery.reservation.v1.FailoverReservationRequest
	23, // 51: google.cloud.bigquery.reservation.v1.ReservationService.CreateCapacityCommitment:input_type -> google.cloud.bigquery.reservation.v1.CreateCapacityCommitmentRequest
	24, // 52: google.cloud.bigquery.reservation.v1.ReservationService.ListCapacityCommitments:input_type -> google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsRequest
	26, // 53: google.cloud.bigquery.reservation.v1.ReservationService.GetCapacityCommitment:input_type -> google.cloud.bigquery.reservation.v1.GetCapacityCommitmentRequest
	27, // 54: google.cloud.bigquery.reservation.v1.ReservationService.DeleteCapacityCommitment:input_type -> google.cloud.bigquery.reservation.v1.DeleteCapacityCommitmentRequest
	28, // 55: google.cloud.bigquery.reservation.v1.ReservationService.UpdateCapacityCommitment:input_type -> google.cloud.bigquery.reservation.v1.UpdateCapacityCommitmentRequest
	29, // 56: google.cloud.bigquery.reservation.v1.ReservationService.SplitCapacityCommitment:input_type -> google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentRequest
	31, // 57: google.cloud.bigquery.reservation.v1.ReservationService.MergeCapacityCommitments:input_type -> google.cloud.bigquery.reservation.v1.MergeCapacityCommitmentsRequest
	33, // 58: google.cloud.bigquery.reservation.v1.ReservationService.CreateAssignment:input_type -> google.cloud.bigquery.reservation.v1.CreateAssignmentRequest
	34, // 59: google.cloud.bigquery.reservation.v1.ReservationService.ListAssignments:input_type -> google.cloud.bigquery.reservation.v1.ListAssignmentsRequest
	36, // 60: google.cloud.bigquery.reservation.v1.ReservationService.DeleteAssignment:input_type -> google.cloud.bigquery.reservation.v1.DeleteAssignmentRequest
	37, // 61: google.cloud.bigquery.reservation.v1.ReservationService.SearchAssignments:input_type -> google.cloud.bigquery.reservation.v1.SearchAssignmentsRequest
	38, // 62: google.cloud.bigquery.reservation.v1.ReservationService.SearchAllAssignments:input_type -> google.cloud.bigquery.reservation.v1.SearchAllAssignmentsRequest
	41, // 63: google.cloud.bigquery.reservation.v1.ReservationService.MoveAssignment:input_type -> google.cloud.bigquery.reservation.v1.MoveAssignmentRequest
	42, // 64: google.cloud.bigquery.reservation.v1.ReservationService.UpdateAssignment:input_type -> google.cloud.bigquery.reservation.v1.UpdateAssignmentRequest
	45, // 65: google.cloud.bigquery.reservation.v1.ReservationService.GetBiReservation:input_type -> google.cloud.bigquery.reservation.v1.GetBiReservationRequest
	46, // 66: google.cloud.bigquery.reservation.v1.ReservationService.UpdateBiReservation:input_type -> google.cloud.bigquery.reservation.v1.UpdateBiReservationRequest
	53, // 67: google.cloud.bigquery.reservation.v1.ReservationService.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	54, // 68: google.cloud.bigquery.reservation.v1.ReservationService.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	55, // 69: google.cloud.bigquery.reservation.v1.ReservationService.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	18, // 70: google.cloud.bigquery.reservation.v1.ReservationService.CreateReservationGroup:input_type -> google.cloud.bigquery.reservation.v1.CreateReservationGroupRequest
	19, // 71: google.cloud.bigquery.reservation.v1.ReservationService.GetReservationGroup:input_type -> google.cloud.bigquery.reservation.v1.GetReservationGroupRequest
	22, // 72: google.cloud.bigquery.reservation.v1.ReservationService.DeleteReservationGroup:input_type -> google.cloud.bigquery.reservation.v1.DeleteReservationGroupRequest
	20, // 73: google.cloud.bigquery.reservation.v1.ReservationService.ListReservationGroups:input_type -> google.cloud.bigquery.reservation.v1.ListReservationGroupsRequest
	7,  // 74: google.cloud.bigquery.reservation.v1.ReservationService.CreateReservation:output_type -> google.cloud.bigquery.reservation.v1.Reservation
	13, // 75: google.cloud.bigquery.reservation.v1.ReservationService.ListReservations:output_type -> google.cloud.bigquery.reservation.v1.ListReservationsResponse
	7,  // 76: google.cloud.bigquery.reservation.v1.ReservationService.GetReservation:output_type -> google.cloud.bigquery.reservation.v1.Reservation
	56, // 77: google.cloud.bigquery.reservation.v1.ReservationService.DeleteReservation:output_type -> google.protobuf.Empty
	7,  // 78: google.cloud.bigquery.reservation.v1.ReservationService.UpdateReservation:output_type -> google.cloud.bigquery.reservation.v1.Reservation
	7,  // 79: google.cloud.bigquery.reservation.v1.ReservationService.FailoverReservation:output_type -> google.cloud.bigquery.reservation.v1.Reservation
	10, // 80: google.cloud.bigquery.reservation.v1.ReservationService.CreateCapacityCommitment:output_type -> google.cloud.bigquery.reservation.v1.CapacityCommitment
	25, // 81: google.cloud.bigquery.reservation.v1.ReservationService.ListCapacityCommitments:output_type -> google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsResponse
	10, // 82: google.cloud.bigquery.reservation.v1.ReservationService.GetCapacityCommitment:output_type -> google.cloud.bigquery.reservation.v1.CapacityCommitment
	56, // 83: google.cloud.bigquery.reservation.v1.ReservationService.DeleteCapacityCommitment:output_type -> google.protobuf.Empty
	10, // 84: google.cloud.bigquery.reservation.v1.ReservationService.UpdateCapacityCommitment:output_type -> google.cloud.bigquery.reservation.v1.CapacityCommitment
	30, // 85: google.cloud.bigquery.reservation.v1.ReservationService.SplitCapacityCommitment:output_type -> google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentResponse
	10, // 86: google.cloud.bigquery.reservation.v1.ReservationService.MergeCapacityCommitments:output_type -> google.cloud.bigquery.reservation.v1.CapacityCommitment
	32, // 87: google.cloud.bigquery.reservation.v1.ReservationService.CreateAssignment:output_type -> google.cloud.bigquery.reservation.v1.Assignment
	35, // 88: google.cloud.bigquery.reservation.v1.ReservationService.ListAssignments:output_type -> google.cloud.bigquery.reservation.v1.ListAssignmentsResponse
	56, // 89: google.cloud.bigquery.reservation.v1.ReservationService.DeleteAssignment:output_type -> google.protobuf.Empty
	39, // 90: google.cloud.bigquery.reservation.v1.ReservationService.SearchAssignments:output_type -> google.cloud.bigquery.reservation.v1.SearchAssignmentsResponse
	40, // 91: google.cloud.bigquery.reservation.v1.ReservationService.SearchAllAssignments:output_type -> google.cloud.bigquery.reservation.v1.SearchAllAssignmentsResponse
	32, // 92: google.cloud.bigquery.reservation.v1.ReservationService.MoveAssignment:output_type -> google.cloud.bigquery.reservation.v1.Assignment
	32, // 93: google.cloud.bigquery.reservation.v1.ReservationService.UpdateAssignment:output_type -> google.cloud.bigquery.reservation.v1.Assignment
	44, // 94: google.cloud.bigquery.reservation.v1.ReservationService.GetBiReservation:output_type -> google.cloud.bigquery.reservation.v1.BiReservation
	44, // 95: google.cloud.bigquery.reservation.v1.ReservationService.UpdateBiReservation:output_type -> google.cloud.bigquery.reservation.v1.BiReservation
	57, // 96: google.cloud.bigquery.reservation.v1.ReservationService.GetIamPolicy:output_type -> google.iam.v1.Policy
	57, // 97: google.cloud.bigquery.reservation.v1.ReservationService.SetIamPolicy:output_type -> google.iam.v1.Policy
	58, // 98: google.cloud.bigquery.reservation.v1.ReservationService.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	9,  // 99: google.cloud.bigquery.reservation.v1.ReservationService.CreateReservationGroup:output_type -> google.cloud.bigquery.reservation.v1.ReservationGroup
	9,  // 100: google.cloud.bigquery.reservation.v1.ReservationService.GetReservationGroup:output_type -> google.cloud.bigquery.reservation.v1.ReservationGroup
	56, // 101: google.cloud.bigquery.reservation.v1.ReservationService.DeleteReservationGroup:output_type -> google.protobuf.Empty
	21, // 102: google.cloud.bigquery.reservation.v1.ReservationService.ListReservationGroups:output_type -> google.cloud.bigquery.reservation.v1.ListReservationGroupsResponse
	74, // [74:103] is the sub-list for method output_type
	45, // [45:74] is the sub-list for method input_type
	45, // [45:45] is the sub-list for extension type_name
	45, // [45:45] is the sub-list for extension extendee
	0,  // [0:45] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_reservation_v1_reservation_proto_init() }
func file_google_cloud_bigquery_reservation_v1_reservation_proto_init() {
	if File_google_cloud_bigquery_reservation_v1_reservation_proto != nil {
		return
	}
	file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes[1].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   43,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_reservation_v1_reservation_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_reservation_v1_reservation_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_reservation_v1_reservation_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_reservation_v1_reservation_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_reservation_v1_reservation_proto = out.File
	file_google_cloud_bigquery_reservation_v1_reservation_proto_rawDesc = nil
	file_google_cloud_bigquery_reservation_v1_reservation_proto_goTypes = nil
	file_google_cloud_bigquery_reservation_v1_reservation_proto_depIdxs = nil
}
