// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// MarketplacePrivateOffer API
//
// Use the Marketplace Publisher API to manage the publishing of applications in Oracle Cloud Infrastructure Marketplace.
//

package marketplaceprivateoffer

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// BuyerInformation The information related to the buyer of an Offer
type BuyerInformation struct {

	// the name of the company for the buyer
	CompanyName *string `mandatory:"false" json:"companyName"`

	// a note the seller can specify for the buyer through a notification email
	NoteToBuyer *string `mandatory:"false" json:"noteToBuyer"`

	PrimaryContact *Contact `mandatory:"false" json:"primaryContact"`

	// the additional contacts associated with the buyer
	AdditionalContacts []Contact `mandatory:"false" json:"additionalContacts"`
}

func (m BuyerInformation) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m BuyerInformation) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
