// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Network Monitoring API
//
// Use the Network Monitoring API to troubleshoot routing and security issues for resources such as virtual cloud networks (VCNs) and compute instances. For more information, see the console
// documentation for the Network Path Analyzer (https://docs.oracle.com/iaas/Content/Network/Concepts/path_analyzer.htm) tool.
//

package vnmonitoring

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ForwardedRoutingActionDetails Defines details for the forwarded routing action.
type ForwardedRoutingActionDetails struct {

	// If true, the forwarded routing configuration details are incomplete.
	IsRestrictedOrPartial *bool `mandatory:"true" json:"isRestrictedOrPartial"`

	ForwardedRoutingConfiguration ForwardedRoutingConfiguration `mandatory:"false" json:"forwardedRoutingConfiguration"`
}

func (m ForwardedRoutingActionDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ForwardedRoutingActionDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// UnmarshalJSON unmarshals from json
func (m *ForwardedRoutingActionDetails) UnmarshalJSON(data []byte) (e error) {
	model := struct {
		ForwardedRoutingConfiguration forwardedroutingconfiguration `json:"forwardedRoutingConfiguration"`
		IsRestrictedOrPartial         *bool                         `json:"isRestrictedOrPartial"`
	}{}

	e = json.Unmarshal(data, &model)
	if e != nil {
		return
	}
	var nn interface{}
	nn, e = model.ForwardedRoutingConfiguration.UnmarshalPolymorphicJSON(model.ForwardedRoutingConfiguration.JsonData)
	if e != nil {
		return
	}
	if nn != nil {
		m.ForwardedRoutingConfiguration = nn.(ForwardedRoutingConfiguration)
	} else {
		m.ForwardedRoutingConfiguration = nil
	}

	m.IsRestrictedOrPartial = model.IsRestrictedOrPartial

	return
}
