// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatch

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/query"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatch/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"path"
	"sort"
)

type awsAwsquery_serializeOpDeleteAlarms struct {
}

func (*awsAwsquery_serializeOpDeleteAlarms) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteAlarms) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAlarmsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteAlarms")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDeleteAlarmsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteAnomalyDetector struct {
}

func (*awsAwsquery_serializeOpDeleteAnomalyDetector) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteAnomalyDetector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAnomalyDetectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteAnomalyDetector")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDeleteAnomalyDetectorInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteDashboards struct {
}

func (*awsAwsquery_serializeOpDeleteDashboards) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteDashboards) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDashboardsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteDashboards")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDeleteDashboardsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteInsightRules struct {
}

func (*awsAwsquery_serializeOpDeleteInsightRules) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteInsightRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInsightRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteInsightRules")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDeleteInsightRulesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteMetricStream struct {
}

func (*awsAwsquery_serializeOpDeleteMetricStream) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteMetricStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMetricStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteMetricStream")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDeleteMetricStreamInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAlarmContributors struct {
}

func (*awsAwsquery_serializeOpDescribeAlarmContributors) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAlarmContributors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAlarmContributorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAlarmContributors")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAlarmContributorsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAlarmHistory struct {
}

func (*awsAwsquery_serializeOpDescribeAlarmHistory) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAlarmHistory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAlarmHistoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAlarmHistory")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAlarmHistoryInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAlarms struct {
}

func (*awsAwsquery_serializeOpDescribeAlarms) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAlarms) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAlarmsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAlarms")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAlarmsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAlarmsForMetric struct {
}

func (*awsAwsquery_serializeOpDescribeAlarmsForMetric) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAlarmsForMetric) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAlarmsForMetricInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAlarmsForMetric")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAlarmsForMetricInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAnomalyDetectors struct {
}

func (*awsAwsquery_serializeOpDescribeAnomalyDetectors) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAnomalyDetectors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAnomalyDetectorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAnomalyDetectors")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAnomalyDetectorsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeInsightRules struct {
}

func (*awsAwsquery_serializeOpDescribeInsightRules) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeInsightRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInsightRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInsightRules")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDescribeInsightRulesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDisableAlarmActions struct {
}

func (*awsAwsquery_serializeOpDisableAlarmActions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDisableAlarmActions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableAlarmActionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableAlarmActions")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDisableAlarmActionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDisableInsightRules struct {
}

func (*awsAwsquery_serializeOpDisableInsightRules) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDisableInsightRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableInsightRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableInsightRules")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentDisableInsightRulesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpEnableAlarmActions struct {
}

func (*awsAwsquery_serializeOpEnableAlarmActions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpEnableAlarmActions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableAlarmActionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableAlarmActions")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentEnableAlarmActionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpEnableInsightRules struct {
}

func (*awsAwsquery_serializeOpEnableInsightRules) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpEnableInsightRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableInsightRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableInsightRules")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentEnableInsightRulesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetDashboard struct {
}

func (*awsAwsquery_serializeOpGetDashboard) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetDashboard) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDashboardInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetDashboard")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentGetDashboardInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetInsightRuleReport struct {
}

func (*awsAwsquery_serializeOpGetInsightRuleReport) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetInsightRuleReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetInsightRuleReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetInsightRuleReport")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentGetInsightRuleReportInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetMetricData struct {
}

func (*awsAwsquery_serializeOpGetMetricData) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetMetricData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMetricDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetMetricData")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentGetMetricDataInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetMetricStatistics struct {
}

func (*awsAwsquery_serializeOpGetMetricStatistics) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetMetricStatistics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMetricStatisticsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetMetricStatistics")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentGetMetricStatisticsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetMetricStream struct {
}

func (*awsAwsquery_serializeOpGetMetricStream) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetMetricStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMetricStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetMetricStream")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentGetMetricStreamInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetMetricWidgetImage struct {
}

func (*awsAwsquery_serializeOpGetMetricWidgetImage) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetMetricWidgetImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMetricWidgetImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetMetricWidgetImage")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentGetMetricWidgetImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListDashboards struct {
}

func (*awsAwsquery_serializeOpListDashboards) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListDashboards) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDashboardsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListDashboards")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentListDashboardsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListManagedInsightRules struct {
}

func (*awsAwsquery_serializeOpListManagedInsightRules) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListManagedInsightRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListManagedInsightRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListManagedInsightRules")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentListManagedInsightRulesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListMetrics struct {
}

func (*awsAwsquery_serializeOpListMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListMetrics")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentListMetricsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListMetricStreams struct {
}

func (*awsAwsquery_serializeOpListMetricStreams) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListMetricStreams) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMetricStreamsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListMetricStreams")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentListMetricStreamsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListTagsForResource struct {
}

func (*awsAwsquery_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListTagsForResource")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentListTagsForResourceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutAnomalyDetector struct {
}

func (*awsAwsquery_serializeOpPutAnomalyDetector) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutAnomalyDetector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAnomalyDetectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutAnomalyDetector")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentPutAnomalyDetectorInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutCompositeAlarm struct {
}

func (*awsAwsquery_serializeOpPutCompositeAlarm) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutCompositeAlarm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutCompositeAlarmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutCompositeAlarm")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentPutCompositeAlarmInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutDashboard struct {
}

func (*awsAwsquery_serializeOpPutDashboard) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutDashboard) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutDashboardInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutDashboard")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentPutDashboardInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutInsightRule struct {
}

func (*awsAwsquery_serializeOpPutInsightRule) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutInsightRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutInsightRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutInsightRule")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentPutInsightRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutManagedInsightRules struct {
}

func (*awsAwsquery_serializeOpPutManagedInsightRules) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutManagedInsightRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutManagedInsightRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutManagedInsightRules")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentPutManagedInsightRulesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutMetricAlarm struct {
}

func (*awsAwsquery_serializeOpPutMetricAlarm) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutMetricAlarm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutMetricAlarmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutMetricAlarm")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentPutMetricAlarmInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutMetricData struct {
}

func (*awsAwsquery_serializeOpPutMetricData) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutMetricData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutMetricDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutMetricData")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentPutMetricDataInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPutMetricStream struct {
}

func (*awsAwsquery_serializeOpPutMetricStream) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPutMetricStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutMetricStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PutMetricStream")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentPutMetricStreamInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetAlarmState struct {
}

func (*awsAwsquery_serializeOpSetAlarmState) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetAlarmState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetAlarmStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetAlarmState")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentSetAlarmStateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpStartMetricStreams struct {
}

func (*awsAwsquery_serializeOpStartMetricStreams) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpStartMetricStreams) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartMetricStreamsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("StartMetricStreams")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentStartMetricStreamsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpStopMetricStreams struct {
}

func (*awsAwsquery_serializeOpStopMetricStreams) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpStopMetricStreams) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopMetricStreamsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("StopMetricStreams")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentStopMetricStreamsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpTagResource struct {
}

func (*awsAwsquery_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("TagResource")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentTagResourceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUntagResource struct {
}

func (*awsAwsquery_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UntagResource")
	body.Key("Version").String("2010-08-01")

	if err := awsAwsquery_serializeOpDocumentUntagResourceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsquery_serializeDocumentAlarmNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentAlarmTypes(v []types.AlarmType, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentAnomalyDetectorConfiguration(v *types.AnomalyDetectorConfiguration, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ExcludedTimeRanges != nil {
		objectKey := object.Key("ExcludedTimeRanges")
		if err := awsAwsquery_serializeDocumentAnomalyDetectorExcludedTimeRanges(v.ExcludedTimeRanges, objectKey); err != nil {
			return err
		}
	}

	if v.MetricTimezone != nil {
		objectKey := object.Key("MetricTimezone")
		objectKey.String(*v.MetricTimezone)
	}

	return nil
}

func awsAwsquery_serializeDocumentAnomalyDetectorExcludedTimeRanges(v []types.Range, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentRange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentAnomalyDetectorTypes(v []types.AnomalyDetectorType, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentCounts(v []float64, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsAwsquery_serializeDocumentDashboardNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentDimension(v *types.Dimension, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentDimensionFilter(v *types.DimensionFilter, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentDimensionFilters(v []types.DimensionFilter, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentDimensionFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentDimensions(v []types.Dimension, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentDimension(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentEntity(v *types.Entity, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Attributes != nil {
		objectKey := object.Key("Attributes")
		if err := awsAwsquery_serializeDocumentEntityAttributesMap(v.Attributes, objectKey); err != nil {
			return err
		}
	}

	if v.KeyAttributes != nil {
		objectKey := object.Key("KeyAttributes")
		if err := awsAwsquery_serializeDocumentEntityKeyAttributesMap(v.KeyAttributes, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentEntityAttributesMap(v map[string]string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	object := value.Map("key", "value")

	keys := make([]string, 0, len(v))
	for key := range v {
		keys = append(keys, key)
	}
	sort.Strings(keys)

	for _, key := range keys {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsquery_serializeDocumentEntityKeyAttributesMap(v map[string]string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	object := value.Map("key", "value")

	keys := make([]string, 0, len(v))
	for key := range v {
		keys = append(keys, key)
	}
	sort.Strings(keys)

	for _, key := range keys {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsquery_serializeDocumentEntityMetricData(v *types.EntityMetricData, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Entity != nil {
		objectKey := object.Key("Entity")
		if err := awsAwsquery_serializeDocumentEntity(v.Entity, objectKey); err != nil {
			return err
		}
	}

	if v.MetricData != nil {
		objectKey := object.Key("MetricData")
		if err := awsAwsquery_serializeDocumentMetricData(v.MetricData, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentEntityMetricDataList(v []types.EntityMetricData, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentEntityMetricData(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentExtendedStatistics(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentInsightRuleMetricList(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentInsightRuleNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentLabelOptions(v *types.LabelOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Timezone != nil {
		objectKey := object.Key("Timezone")
		objectKey.String(*v.Timezone)
	}

	return nil
}

func awsAwsquery_serializeDocumentManagedRule(v *types.ManagedRule, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ResourceARN != nil {
		objectKey := object.Key("ResourceARN")
		objectKey.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	if v.TemplateName != nil {
		objectKey := object.Key("TemplateName")
		objectKey.String(*v.TemplateName)
	}

	return nil
}

func awsAwsquery_serializeDocumentManagedRules(v []types.ManagedRule, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentManagedRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentMetric(v *types.Metric, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentDimensions(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	return nil
}

func awsAwsquery_serializeDocumentMetricCharacteristics(v *types.MetricCharacteristics, value query.Value) error {
	object := value.Object()
	_ = object

	if v.PeriodicSpikes != nil {
		objectKey := object.Key("PeriodicSpikes")
		objectKey.Boolean(*v.PeriodicSpikes)
	}

	return nil
}

func awsAwsquery_serializeDocumentMetricData(v []types.MetricDatum, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentMetricDatum(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentMetricDataQueries(v []types.MetricDataQuery, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentMetricDataQuery(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentMetricDataQuery(v *types.MetricDataQuery, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountId != nil {
		objectKey := object.Key("AccountId")
		objectKey.String(*v.AccountId)
	}

	if v.Expression != nil {
		objectKey := object.Key("Expression")
		objectKey.String(*v.Expression)
	}

	if v.Id != nil {
		objectKey := object.Key("Id")
		objectKey.String(*v.Id)
	}

	if v.Label != nil {
		objectKey := object.Key("Label")
		objectKey.String(*v.Label)
	}

	if v.MetricStat != nil {
		objectKey := object.Key("MetricStat")
		if err := awsAwsquery_serializeDocumentMetricStat(v.MetricStat, objectKey); err != nil {
			return err
		}
	}

	if v.Period != nil {
		objectKey := object.Key("Period")
		objectKey.Integer(*v.Period)
	}

	if v.ReturnData != nil {
		objectKey := object.Key("ReturnData")
		objectKey.Boolean(*v.ReturnData)
	}

	return nil
}

func awsAwsquery_serializeDocumentMetricDatum(v *types.MetricDatum, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Counts != nil {
		objectKey := object.Key("Counts")
		if err := awsAwsquery_serializeDocumentCounts(v.Counts, objectKey); err != nil {
			return err
		}
	}

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentDimensions(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.StatisticValues != nil {
		objectKey := object.Key("StatisticValues")
		if err := awsAwsquery_serializeDocumentStatisticSet(v.StatisticValues, objectKey); err != nil {
			return err
		}
	}

	if v.StorageResolution != nil {
		objectKey := object.Key("StorageResolution")
		objectKey.Integer(*v.StorageResolution)
	}

	if v.Timestamp != nil {
		objectKey := object.Key("Timestamp")
		objectKey.String(smithytime.FormatDateTime(*v.Timestamp))
	}

	if len(v.Unit) > 0 {
		objectKey := object.Key("Unit")
		objectKey.String(string(v.Unit))
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		switch {
		case math.IsNaN(*v.Value):
			objectKey.String("NaN")

		case math.IsInf(*v.Value, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Value, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Value)

		}
	}

	if v.Values != nil {
		objectKey := object.Key("Values")
		if err := awsAwsquery_serializeDocumentValues(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentMetricMathAnomalyDetector(v *types.MetricMathAnomalyDetector, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MetricDataQueries != nil {
		objectKey := object.Key("MetricDataQueries")
		if err := awsAwsquery_serializeDocumentMetricDataQueries(v.MetricDataQueries, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentMetricStat(v *types.MetricStat, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Metric != nil {
		objectKey := object.Key("Metric")
		if err := awsAwsquery_serializeDocumentMetric(v.Metric, objectKey); err != nil {
			return err
		}
	}

	if v.Period != nil {
		objectKey := object.Key("Period")
		objectKey.Integer(*v.Period)
	}

	if v.Stat != nil {
		objectKey := object.Key("Stat")
		objectKey.String(*v.Stat)
	}

	if len(v.Unit) > 0 {
		objectKey := object.Key("Unit")
		objectKey.String(string(v.Unit))
	}

	return nil
}

func awsAwsquery_serializeDocumentMetricStreamFilter(v *types.MetricStreamFilter, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MetricNames != nil {
		objectKey := object.Key("MetricNames")
		if err := awsAwsquery_serializeDocumentMetricStreamFilterMetricNames(v.MetricNames, objectKey); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	return nil
}

func awsAwsquery_serializeDocumentMetricStreamFilterMetricNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentMetricStreamFilters(v []types.MetricStreamFilter, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentMetricStreamFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentMetricStreamNames(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentMetricStreamStatisticsAdditionalStatistics(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentMetricStreamStatisticsConfiguration(v *types.MetricStreamStatisticsConfiguration, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AdditionalStatistics != nil {
		objectKey := object.Key("AdditionalStatistics")
		if err := awsAwsquery_serializeDocumentMetricStreamStatisticsAdditionalStatistics(v.AdditionalStatistics, objectKey); err != nil {
			return err
		}
	}

	if v.IncludeMetrics != nil {
		objectKey := object.Key("IncludeMetrics")
		if err := awsAwsquery_serializeDocumentMetricStreamStatisticsIncludeMetrics(v.IncludeMetrics, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentMetricStreamStatisticsConfigurations(v []types.MetricStreamStatisticsConfiguration, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentMetricStreamStatisticsConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentMetricStreamStatisticsIncludeMetrics(v []types.MetricStreamStatisticsMetric, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentMetricStreamStatisticsMetric(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentMetricStreamStatisticsMetric(v *types.MetricStreamStatisticsMetric, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	return nil
}

func awsAwsquery_serializeDocumentRange(v *types.Range, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

func awsAwsquery_serializeDocumentResourceList(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentSingleMetricAnomalyDetector(v *types.SingleMetricAnomalyDetector, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountId != nil {
		objectKey := object.Key("AccountId")
		objectKey.String(*v.AccountId)
	}

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentDimensions(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	if v.Stat != nil {
		objectKey := object.Key("Stat")
		objectKey.String(*v.Stat)
	}

	return nil
}

func awsAwsquery_serializeDocumentStatistics(v []types.Statistic, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentStatisticSet(v *types.StatisticSet, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Maximum != nil {
		objectKey := object.Key("Maximum")
		switch {
		case math.IsNaN(*v.Maximum):
			objectKey.String("NaN")

		case math.IsInf(*v.Maximum, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Maximum, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Maximum)

		}
	}

	if v.Minimum != nil {
		objectKey := object.Key("Minimum")
		switch {
		case math.IsNaN(*v.Minimum):
			objectKey.String("NaN")

		case math.IsInf(*v.Minimum, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Minimum, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Minimum)

		}
	}

	if v.SampleCount != nil {
		objectKey := object.Key("SampleCount")
		switch {
		case math.IsNaN(*v.SampleCount):
			objectKey.String("NaN")

		case math.IsInf(*v.SampleCount, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.SampleCount, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.SampleCount)

		}
	}

	if v.Sum != nil {
		objectKey := object.Key("Sum")
		switch {
		case math.IsNaN(*v.Sum):
			objectKey.String("NaN")

		case math.IsInf(*v.Sum, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Sum, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Sum)

		}
	}

	return nil
}

func awsAwsquery_serializeDocumentTag(v *types.Tag, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentTagKeyList(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTagList(v []types.Tag, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentValues(v []float64, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsAwsquery_serializeOpDocumentDeleteAlarmsInput(v *DeleteAlarmsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AlarmNames != nil {
		objectKey := object.Key("AlarmNames")
		if err := awsAwsquery_serializeDocumentAlarmNames(v.AlarmNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteAnomalyDetectorInput(v *DeleteAnomalyDetectorInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentDimensions(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.MetricMathAnomalyDetector != nil {
		objectKey := object.Key("MetricMathAnomalyDetector")
		if err := awsAwsquery_serializeDocumentMetricMathAnomalyDetector(v.MetricMathAnomalyDetector, objectKey); err != nil {
			return err
		}
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	if v.SingleMetricAnomalyDetector != nil {
		objectKey := object.Key("SingleMetricAnomalyDetector")
		if err := awsAwsquery_serializeDocumentSingleMetricAnomalyDetector(v.SingleMetricAnomalyDetector, objectKey); err != nil {
			return err
		}
	}

	if v.Stat != nil {
		objectKey := object.Key("Stat")
		objectKey.String(*v.Stat)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteDashboardsInput(v *DeleteDashboardsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DashboardNames != nil {
		objectKey := object.Key("DashboardNames")
		if err := awsAwsquery_serializeDocumentDashboardNames(v.DashboardNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteInsightRulesInput(v *DeleteInsightRulesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RuleNames != nil {
		objectKey := object.Key("RuleNames")
		if err := awsAwsquery_serializeDocumentInsightRuleNames(v.RuleNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteMetricStreamInput(v *DeleteMetricStreamInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAlarmContributorsInput(v *DescribeAlarmContributorsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AlarmName != nil {
		objectKey := object.Key("AlarmName")
		objectKey.String(*v.AlarmName)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAlarmHistoryInput(v *DescribeAlarmHistoryInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AlarmContributorId != nil {
		objectKey := object.Key("AlarmContributorId")
		objectKey.String(*v.AlarmContributorId)
	}

	if v.AlarmName != nil {
		objectKey := object.Key("AlarmName")
		objectKey.String(*v.AlarmName)
	}

	if v.AlarmTypes != nil {
		objectKey := object.Key("AlarmTypes")
		if err := awsAwsquery_serializeDocumentAlarmTypes(v.AlarmTypes, objectKey); err != nil {
			return err
		}
	}

	if v.EndDate != nil {
		objectKey := object.Key("EndDate")
		objectKey.String(smithytime.FormatDateTime(*v.EndDate))
	}

	if len(v.HistoryItemType) > 0 {
		objectKey := object.Key("HistoryItemType")
		objectKey.String(string(v.HistoryItemType))
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	if len(v.ScanBy) > 0 {
		objectKey := object.Key("ScanBy")
		objectKey.String(string(v.ScanBy))
	}

	if v.StartDate != nil {
		objectKey := object.Key("StartDate")
		objectKey.String(smithytime.FormatDateTime(*v.StartDate))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAlarmsForMetricInput(v *DescribeAlarmsForMetricInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentDimensions(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.ExtendedStatistic != nil {
		objectKey := object.Key("ExtendedStatistic")
		objectKey.String(*v.ExtendedStatistic)
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	if v.Period != nil {
		objectKey := object.Key("Period")
		objectKey.Integer(*v.Period)
	}

	if len(v.Statistic) > 0 {
		objectKey := object.Key("Statistic")
		objectKey.String(string(v.Statistic))
	}

	if len(v.Unit) > 0 {
		objectKey := object.Key("Unit")
		objectKey.String(string(v.Unit))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAlarmsInput(v *DescribeAlarmsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ActionPrefix != nil {
		objectKey := object.Key("ActionPrefix")
		objectKey.String(*v.ActionPrefix)
	}

	if v.AlarmNamePrefix != nil {
		objectKey := object.Key("AlarmNamePrefix")
		objectKey.String(*v.AlarmNamePrefix)
	}

	if v.AlarmNames != nil {
		objectKey := object.Key("AlarmNames")
		if err := awsAwsquery_serializeDocumentAlarmNames(v.AlarmNames, objectKey); err != nil {
			return err
		}
	}

	if v.AlarmTypes != nil {
		objectKey := object.Key("AlarmTypes")
		if err := awsAwsquery_serializeDocumentAlarmTypes(v.AlarmTypes, objectKey); err != nil {
			return err
		}
	}

	if v.ChildrenOfAlarmName != nil {
		objectKey := object.Key("ChildrenOfAlarmName")
		objectKey.String(*v.ChildrenOfAlarmName)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	if v.ParentsOfAlarmName != nil {
		objectKey := object.Key("ParentsOfAlarmName")
		objectKey.String(*v.ParentsOfAlarmName)
	}

	if len(v.StateValue) > 0 {
		objectKey := object.Key("StateValue")
		objectKey.String(string(v.StateValue))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAnomalyDetectorsInput(v *DescribeAnomalyDetectorsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AnomalyDetectorTypes != nil {
		objectKey := object.Key("AnomalyDetectorTypes")
		if err := awsAwsquery_serializeDocumentAnomalyDetectorTypes(v.AnomalyDetectorTypes, objectKey); err != nil {
			return err
		}
	}

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentDimensions(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		objectKey := object.Key("MaxResults")
		objectKey.Integer(*v.MaxResults)
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeInsightRulesInput(v *DescribeInsightRulesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MaxResults != nil {
		objectKey := object.Key("MaxResults")
		objectKey.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDisableAlarmActionsInput(v *DisableAlarmActionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AlarmNames != nil {
		objectKey := object.Key("AlarmNames")
		if err := awsAwsquery_serializeDocumentAlarmNames(v.AlarmNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDisableInsightRulesInput(v *DisableInsightRulesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RuleNames != nil {
		objectKey := object.Key("RuleNames")
		if err := awsAwsquery_serializeDocumentInsightRuleNames(v.RuleNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentEnableAlarmActionsInput(v *EnableAlarmActionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AlarmNames != nil {
		objectKey := object.Key("AlarmNames")
		if err := awsAwsquery_serializeDocumentAlarmNames(v.AlarmNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentEnableInsightRulesInput(v *EnableInsightRulesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RuleNames != nil {
		objectKey := object.Key("RuleNames")
		if err := awsAwsquery_serializeDocumentInsightRuleNames(v.RuleNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetDashboardInput(v *GetDashboardInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DashboardName != nil {
		objectKey := object.Key("DashboardName")
		objectKey.String(*v.DashboardName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetInsightRuleReportInput(v *GetInsightRuleReportInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.MaxContributorCount != nil {
		objectKey := object.Key("MaxContributorCount")
		objectKey.Integer(*v.MaxContributorCount)
	}

	if v.Metrics != nil {
		objectKey := object.Key("Metrics")
		if err := awsAwsquery_serializeDocumentInsightRuleMetricList(v.Metrics, objectKey); err != nil {
			return err
		}
	}

	if v.OrderBy != nil {
		objectKey := object.Key("OrderBy")
		objectKey.String(*v.OrderBy)
	}

	if v.Period != nil {
		objectKey := object.Key("Period")
		objectKey.Integer(*v.Period)
	}

	if v.RuleName != nil {
		objectKey := object.Key("RuleName")
		objectKey.String(*v.RuleName)
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetMetricDataInput(v *GetMetricDataInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.LabelOptions != nil {
		objectKey := object.Key("LabelOptions")
		if err := awsAwsquery_serializeDocumentLabelOptions(v.LabelOptions, objectKey); err != nil {
			return err
		}
	}

	if v.MaxDatapoints != nil {
		objectKey := object.Key("MaxDatapoints")
		objectKey.Integer(*v.MaxDatapoints)
	}

	if v.MetricDataQueries != nil {
		objectKey := object.Key("MetricDataQueries")
		if err := awsAwsquery_serializeDocumentMetricDataQueries(v.MetricDataQueries, objectKey); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	if len(v.ScanBy) > 0 {
		objectKey := object.Key("ScanBy")
		objectKey.String(string(v.ScanBy))
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetMetricStatisticsInput(v *GetMetricStatisticsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentDimensions(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.EndTime != nil {
		objectKey := object.Key("EndTime")
		objectKey.String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.ExtendedStatistics != nil {
		objectKey := object.Key("ExtendedStatistics")
		if err := awsAwsquery_serializeDocumentExtendedStatistics(v.ExtendedStatistics, objectKey); err != nil {
			return err
		}
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	if v.Period != nil {
		objectKey := object.Key("Period")
		objectKey.Integer(*v.Period)
	}

	if v.StartTime != nil {
		objectKey := object.Key("StartTime")
		objectKey.String(smithytime.FormatDateTime(*v.StartTime))
	}

	if v.Statistics != nil {
		objectKey := object.Key("Statistics")
		if err := awsAwsquery_serializeDocumentStatistics(v.Statistics, objectKey); err != nil {
			return err
		}
	}

	if len(v.Unit) > 0 {
		objectKey := object.Key("Unit")
		objectKey.String(string(v.Unit))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetMetricStreamInput(v *GetMetricStreamInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetMetricWidgetImageInput(v *GetMetricWidgetImageInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MetricWidget != nil {
		objectKey := object.Key("MetricWidget")
		objectKey.String(*v.MetricWidget)
	}

	if v.OutputFormat != nil {
		objectKey := object.Key("OutputFormat")
		objectKey.String(*v.OutputFormat)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListDashboardsInput(v *ListDashboardsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DashboardNamePrefix != nil {
		objectKey := object.Key("DashboardNamePrefix")
		objectKey.String(*v.DashboardNamePrefix)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListManagedInsightRulesInput(v *ListManagedInsightRulesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MaxResults != nil {
		objectKey := object.Key("MaxResults")
		objectKey.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	if v.ResourceARN != nil {
		objectKey := object.Key("ResourceARN")
		objectKey.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListMetricsInput(v *ListMetricsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentDimensionFilters(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.IncludeLinkedAccounts != nil {
		objectKey := object.Key("IncludeLinkedAccounts")
		objectKey.Boolean(*v.IncludeLinkedAccounts)
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	if v.OwningAccount != nil {
		objectKey := object.Key("OwningAccount")
		objectKey.String(*v.OwningAccount)
	}

	if len(v.RecentlyActive) > 0 {
		objectKey := object.Key("RecentlyActive")
		objectKey.String(string(v.RecentlyActive))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListMetricStreamsInput(v *ListMetricStreamsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MaxResults != nil {
		objectKey := object.Key("MaxResults")
		objectKey.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ResourceARN != nil {
		objectKey := object.Key("ResourceARN")
		objectKey.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutAnomalyDetectorInput(v *PutAnomalyDetectorInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Configuration != nil {
		objectKey := object.Key("Configuration")
		if err := awsAwsquery_serializeDocumentAnomalyDetectorConfiguration(v.Configuration, objectKey); err != nil {
			return err
		}
	}

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentDimensions(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.MetricCharacteristics != nil {
		objectKey := object.Key("MetricCharacteristics")
		if err := awsAwsquery_serializeDocumentMetricCharacteristics(v.MetricCharacteristics, objectKey); err != nil {
			return err
		}
	}

	if v.MetricMathAnomalyDetector != nil {
		objectKey := object.Key("MetricMathAnomalyDetector")
		if err := awsAwsquery_serializeDocumentMetricMathAnomalyDetector(v.MetricMathAnomalyDetector, objectKey); err != nil {
			return err
		}
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	if v.SingleMetricAnomalyDetector != nil {
		objectKey := object.Key("SingleMetricAnomalyDetector")
		if err := awsAwsquery_serializeDocumentSingleMetricAnomalyDetector(v.SingleMetricAnomalyDetector, objectKey); err != nil {
			return err
		}
	}

	if v.Stat != nil {
		objectKey := object.Key("Stat")
		objectKey.String(*v.Stat)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutCompositeAlarmInput(v *PutCompositeAlarmInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ActionsEnabled != nil {
		objectKey := object.Key("ActionsEnabled")
		objectKey.Boolean(*v.ActionsEnabled)
	}

	if v.ActionsSuppressor != nil {
		objectKey := object.Key("ActionsSuppressor")
		objectKey.String(*v.ActionsSuppressor)
	}

	if v.ActionsSuppressorExtensionPeriod != nil {
		objectKey := object.Key("ActionsSuppressorExtensionPeriod")
		objectKey.Integer(*v.ActionsSuppressorExtensionPeriod)
	}

	if v.ActionsSuppressorWaitPeriod != nil {
		objectKey := object.Key("ActionsSuppressorWaitPeriod")
		objectKey.Integer(*v.ActionsSuppressorWaitPeriod)
	}

	if v.AlarmActions != nil {
		objectKey := object.Key("AlarmActions")
		if err := awsAwsquery_serializeDocumentResourceList(v.AlarmActions, objectKey); err != nil {
			return err
		}
	}

	if v.AlarmDescription != nil {
		objectKey := object.Key("AlarmDescription")
		objectKey.String(*v.AlarmDescription)
	}

	if v.AlarmName != nil {
		objectKey := object.Key("AlarmName")
		objectKey.String(*v.AlarmName)
	}

	if v.AlarmRule != nil {
		objectKey := object.Key("AlarmRule")
		objectKey.String(*v.AlarmRule)
	}

	if v.InsufficientDataActions != nil {
		objectKey := object.Key("InsufficientDataActions")
		if err := awsAwsquery_serializeDocumentResourceList(v.InsufficientDataActions, objectKey); err != nil {
			return err
		}
	}

	if v.OKActions != nil {
		objectKey := object.Key("OKActions")
		if err := awsAwsquery_serializeDocumentResourceList(v.OKActions, objectKey); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutDashboardInput(v *PutDashboardInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DashboardBody != nil {
		objectKey := object.Key("DashboardBody")
		objectKey.String(*v.DashboardBody)
	}

	if v.DashboardName != nil {
		objectKey := object.Key("DashboardName")
		objectKey.String(*v.DashboardName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutInsightRuleInput(v *PutInsightRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ApplyOnTransformedLogs != nil {
		objectKey := object.Key("ApplyOnTransformedLogs")
		objectKey.Boolean(*v.ApplyOnTransformedLogs)
	}

	if v.RuleDefinition != nil {
		objectKey := object.Key("RuleDefinition")
		objectKey.String(*v.RuleDefinition)
	}

	if v.RuleName != nil {
		objectKey := object.Key("RuleName")
		objectKey.String(*v.RuleName)
	}

	if v.RuleState != nil {
		objectKey := object.Key("RuleState")
		objectKey.String(*v.RuleState)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutManagedInsightRulesInput(v *PutManagedInsightRulesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ManagedRules != nil {
		objectKey := object.Key("ManagedRules")
		if err := awsAwsquery_serializeDocumentManagedRules(v.ManagedRules, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutMetricAlarmInput(v *PutMetricAlarmInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ActionsEnabled != nil {
		objectKey := object.Key("ActionsEnabled")
		objectKey.Boolean(*v.ActionsEnabled)
	}

	if v.AlarmActions != nil {
		objectKey := object.Key("AlarmActions")
		if err := awsAwsquery_serializeDocumentResourceList(v.AlarmActions, objectKey); err != nil {
			return err
		}
	}

	if v.AlarmDescription != nil {
		objectKey := object.Key("AlarmDescription")
		objectKey.String(*v.AlarmDescription)
	}

	if v.AlarmName != nil {
		objectKey := object.Key("AlarmName")
		objectKey.String(*v.AlarmName)
	}

	if len(v.ComparisonOperator) > 0 {
		objectKey := object.Key("ComparisonOperator")
		objectKey.String(string(v.ComparisonOperator))
	}

	if v.DatapointsToAlarm != nil {
		objectKey := object.Key("DatapointsToAlarm")
		objectKey.Integer(*v.DatapointsToAlarm)
	}

	if v.Dimensions != nil {
		objectKey := object.Key("Dimensions")
		if err := awsAwsquery_serializeDocumentDimensions(v.Dimensions, objectKey); err != nil {
			return err
		}
	}

	if v.EvaluateLowSampleCountPercentile != nil {
		objectKey := object.Key("EvaluateLowSampleCountPercentile")
		objectKey.String(*v.EvaluateLowSampleCountPercentile)
	}

	if v.EvaluationPeriods != nil {
		objectKey := object.Key("EvaluationPeriods")
		objectKey.Integer(*v.EvaluationPeriods)
	}

	if v.ExtendedStatistic != nil {
		objectKey := object.Key("ExtendedStatistic")
		objectKey.String(*v.ExtendedStatistic)
	}

	if v.InsufficientDataActions != nil {
		objectKey := object.Key("InsufficientDataActions")
		if err := awsAwsquery_serializeDocumentResourceList(v.InsufficientDataActions, objectKey); err != nil {
			return err
		}
	}

	if v.MetricName != nil {
		objectKey := object.Key("MetricName")
		objectKey.String(*v.MetricName)
	}

	if v.Metrics != nil {
		objectKey := object.Key("Metrics")
		if err := awsAwsquery_serializeDocumentMetricDataQueries(v.Metrics, objectKey); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	if v.OKActions != nil {
		objectKey := object.Key("OKActions")
		if err := awsAwsquery_serializeDocumentResourceList(v.OKActions, objectKey); err != nil {
			return err
		}
	}

	if v.Period != nil {
		objectKey := object.Key("Period")
		objectKey.Integer(*v.Period)
	}

	if len(v.Statistic) > 0 {
		objectKey := object.Key("Statistic")
		objectKey.String(string(v.Statistic))
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	if v.Threshold != nil {
		objectKey := object.Key("Threshold")
		switch {
		case math.IsNaN(*v.Threshold):
			objectKey.String("NaN")

		case math.IsInf(*v.Threshold, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Threshold, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Threshold)

		}
	}

	if v.ThresholdMetricId != nil {
		objectKey := object.Key("ThresholdMetricId")
		objectKey.String(*v.ThresholdMetricId)
	}

	if v.TreatMissingData != nil {
		objectKey := object.Key("TreatMissingData")
		objectKey.String(*v.TreatMissingData)
	}

	if len(v.Unit) > 0 {
		objectKey := object.Key("Unit")
		objectKey.String(string(v.Unit))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutMetricDataInput(v *PutMetricDataInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EntityMetricData != nil {
		objectKey := object.Key("EntityMetricData")
		if err := awsAwsquery_serializeDocumentEntityMetricDataList(v.EntityMetricData, objectKey); err != nil {
			return err
		}
	}

	if v.MetricData != nil {
		objectKey := object.Key("MetricData")
		if err := awsAwsquery_serializeDocumentMetricData(v.MetricData, objectKey); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		objectKey := object.Key("Namespace")
		objectKey.String(*v.Namespace)
	}

	if v.StrictEntityValidation != nil {
		objectKey := object.Key("StrictEntityValidation")
		objectKey.Boolean(*v.StrictEntityValidation)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPutMetricStreamInput(v *PutMetricStreamInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ExcludeFilters != nil {
		objectKey := object.Key("ExcludeFilters")
		if err := awsAwsquery_serializeDocumentMetricStreamFilters(v.ExcludeFilters, objectKey); err != nil {
			return err
		}
	}

	if v.FirehoseArn != nil {
		objectKey := object.Key("FirehoseArn")
		objectKey.String(*v.FirehoseArn)
	}

	if v.IncludeFilters != nil {
		objectKey := object.Key("IncludeFilters")
		if err := awsAwsquery_serializeDocumentMetricStreamFilters(v.IncludeFilters, objectKey); err != nil {
			return err
		}
	}

	if v.IncludeLinkedAccountsMetrics != nil {
		objectKey := object.Key("IncludeLinkedAccountsMetrics")
		objectKey.Boolean(*v.IncludeLinkedAccountsMetrics)
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if len(v.OutputFormat) > 0 {
		objectKey := object.Key("OutputFormat")
		objectKey.String(string(v.OutputFormat))
	}

	if v.RoleArn != nil {
		objectKey := object.Key("RoleArn")
		objectKey.String(*v.RoleArn)
	}

	if v.StatisticsConfigurations != nil {
		objectKey := object.Key("StatisticsConfigurations")
		if err := awsAwsquery_serializeDocumentMetricStreamStatisticsConfigurations(v.StatisticsConfigurations, objectKey); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetAlarmStateInput(v *SetAlarmStateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AlarmName != nil {
		objectKey := object.Key("AlarmName")
		objectKey.String(*v.AlarmName)
	}

	if v.StateReason != nil {
		objectKey := object.Key("StateReason")
		objectKey.String(*v.StateReason)
	}

	if v.StateReasonData != nil {
		objectKey := object.Key("StateReasonData")
		objectKey.String(*v.StateReasonData)
	}

	if len(v.StateValue) > 0 {
		objectKey := object.Key("StateValue")
		objectKey.String(string(v.StateValue))
	}

	return nil
}

func awsAwsquery_serializeOpDocumentStartMetricStreamsInput(v *StartMetricStreamsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Names != nil {
		objectKey := object.Key("Names")
		if err := awsAwsquery_serializeDocumentMetricStreamNames(v.Names, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentStopMetricStreamsInput(v *StopMetricStreamsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Names != nil {
		objectKey := object.Key("Names")
		if err := awsAwsquery_serializeDocumentMetricStreamNames(v.Names, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentTagResourceInput(v *TagResourceInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ResourceARN != nil {
		objectKey := object.Key("ResourceARN")
		objectKey.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ResourceARN != nil {
		objectKey := object.Key("ResourceARN")
		objectKey.String(*v.ResourceARN)
	}

	if v.TagKeys != nil {
		objectKey := object.Key("TagKeys")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	return nil
}
