/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.CronParser;
import it.sauronsoftware.cron4j.TaskCollector;
import it.sauronsoftware.cron4j.TaskTable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

class FileTaskCollector
implements TaskCollector {
    private ArrayList files = new ArrayList();

    FileTaskCollector() {
    }

    public synchronized void addFile(File file) {
        this.files.add(file);
    }

    public synchronized void removeFile(File file) {
        this.files.remove(file);
    }

    public synchronized File[] getFiles() {
        int n = this.files.size();
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = (File)this.files.get(i);
        }
        return fileArray;
    }

    public synchronized TaskTable getTasks() {
        TaskTable taskTable = new TaskTable();
        int n = this.files.size();
        for (int i = 0; i < n; ++i) {
            File file = (File)this.files.get(i);
            TaskTable taskTable2 = null;
            try {
                taskTable2 = CronParser.parse(file);
            }
            catch (IOException iOException) {
                Exception exception = new Exception("Cannot parse cron file: " + file.getAbsolutePath(), iOException);
                exception.printStackTrace();
            }
            if (taskTable2 == null) continue;
            int n2 = taskTable2.size();
            for (int j = 0; j < n2; ++j) {
                taskTable.add(taskTable2.getSchedulingPattern(j), taskTable2.getTask(j));
            }
        }
        return taskTable;
    }
}

