/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.Selector;
import io.jenetics.internal.math.DoubleAdder;
import io.jenetics.internal.math.base;
import io.jenetics.internal.util.IndexSorter;
import io.jenetics.internal.util.array;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import io.jenetics.util.Seq;
import java.util.Comparator;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;

public abstract class ProbabilitySelector<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Selector<G, C> {
    private static final int SERIAL_INDEX_THRESHOLD = 35;
    private static final long MAX_ULP_DISTANCE = base.pow(10L, 10L);
    protected final Comparator<Phenotype<G, C>> POPULATION_COMPARATOR = (a, b) -> Optimize.MAXIMUM.descending().compare(a.getFitness(), b.getFitness());
    protected final boolean _sorted;
    protected final Function<double[], double[]> _reverter;

    protected ProbabilitySelector(boolean sorted) {
        this._sorted = sorted;
        this._reverter = sorted ? array::revert : ProbabilitySelector::sortAndRevert;
    }

    protected ProbabilitySelector() {
        this(false);
    }

    @Override
    public ISeq<Phenotype<G, C>> select(Seq<Phenotype<G, C>> population, int count, Optimize opt) {
        Objects.requireNonNull(population, "Population");
        Objects.requireNonNull(opt, "Optimization");
        if (count < 0) {
            throw new IllegalArgumentException(String.format("Selection count must be greater or equal then zero, but was %s.", count));
        }
        MSeq<Phenotype> selection = MSeq.ofLength(population.isEmpty() ? 0 : count);
        if (count > 0 && !population.isEmpty()) {
            Seq pop = this._sorted ? population.asISeq().copy().sort(this.POPULATION_COMPARATOR) : population;
            double[] prob = this.probabilities(pop, count, opt);
            assert (pop.size() == prob.length) : "Population size and probability length are not equal.";
            ProbabilitySelector.checkAndCorrect(prob);
            assert (ProbabilitySelector.sum2one(prob)) : "Probabilities doesn't sum to one.";
            ProbabilitySelector.incremental(prob);
            Random random2 = RandomRegistry.getRandom();
            selection.fill(() -> (Phenotype)pop.get(ProbabilitySelector.indexOf(prob, random2.nextDouble())));
        }
        return selection.toISeq();
    }

    protected final double[] probabilities(Seq<Phenotype<G, C>> population, int count, Optimize opt) {
        return Objects.requireNonNull(opt) == Optimize.MINIMUM ? this._reverter.apply(this.probabilities(population, count)) : this.probabilities(population, count);
    }

    static double[] sortAndRevert(double[] array2) {
        int[] indexes = IndexSorter.sort(array2);
        double[] result = new double[array2.length];
        for (int i = 0; i < result.length; ++i) {
            result[indexes[result.length - 1 - i]] = array2[indexes[i]];
        }
        return result;
    }

    protected abstract double[] probabilities(Seq<Phenotype<G, C>> var1, int var2);

    private static void checkAndCorrect(double[] probabilities) {
        boolean ok = true;
        int i = probabilities.length;
        while (--i >= 0 && ok) {
            ok = Double.isFinite(probabilities[i]);
        }
        if (!ok) {
            double value = 1.0 / (double)probabilities.length;
            int i2 = probabilities.length;
            while (--i2 >= 0) {
                probabilities[i2] = value;
            }
        }
    }

    static boolean sum2one(double[] probabilities) {
        double sum = probabilities.length > 0 ? DoubleAdder.sum(probabilities) : 1.0;
        return Math.abs(base.ulpDistance(sum, 1.0)) < MAX_ULP_DISTANCE;
    }

    static boolean eq(double a, double b) {
        return Math.abs(base.ulpDistance(a, b)) < MAX_ULP_DISTANCE;
    }

    static int indexOf(double[] incr, double v) {
        return incr.length <= 35 ? ProbabilitySelector.indexOfSerial(incr, v) : ProbabilitySelector.indexOfBinary(incr, v);
    }

    static int indexOfBinary(double[] incr, double v) {
        int imin = 0;
        int imax = incr.length;
        int index = -1;
        while (imax > imin && index == -1) {
            int imid = imin + imax >>> 1;
            if (imid == 0 || incr[imid] >= v && incr[imid - 1] < v) {
                index = imid;
                continue;
            }
            if (incr[imid] <= v) {
                imin = imid + 1;
                continue;
            }
            if (!(incr[imid] > v)) continue;
            imax = imid;
        }
        return index;
    }

    static int indexOfSerial(double[] incr, double v) {
        int index = -1;
        for (int i = 0; i < incr.length && index == -1; ++i) {
            if (!(incr[i] >= v)) continue;
            index = i;
        }
        return index;
    }

    static double[] incremental(double[] values) {
        DoubleAdder adder = new DoubleAdder(values[0]);
        for (int i = 1; i < values.length; ++i) {
            values[i] = adder.add(values[i]).doubleValue();
        }
        return values;
    }
}

