/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class GatorProtocolEncoder
extends BaseProtocolEncoder {
    public GatorProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    public ByteBuf encodeId(long deviceId) {
        ByteBuf buf = Unpooled.buffer();
        String id = this.getUniqueId(deviceId);
        int firstDigit = Integer.parseInt(id.substring(1, 3)) - 30;
        buf.writeByte(Integer.parseInt(id.substring(3, 5)) | (firstDigit >> 3 & 1) << 7);
        buf.writeByte(Integer.parseInt(id.substring(5, 7)) | (firstDigit >> 2 & 1) << 7);
        buf.writeByte(Integer.parseInt(id.substring(7, 9)) | (firstDigit >> 1 & 1) << 7);
        buf.writeByte(Integer.parseInt(id.substring(9)) | (firstDigit & 1) << 7);
        return buf;
    }

    private ByteBuf encodeContent(long deviceId, int type, ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(36);
        buf.writeByte(36);
        buf.writeByte(type);
        buf.writeByte(0);
        buf.writeByte(5 + (content != null ? content.readableBytes() : 0) + 1);
        ByteBuf pseudoIPAddress = this.encodeId(deviceId);
        buf.writeBytes(pseudoIPAddress);
        if (content != null) {
            buf.writeBytes(content);
        }
        int checksum = Checksum.xor(buf.nioBuffer());
        buf.writeByte(checksum);
        buf.writeByte(13);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        ByteBuf content = Unpooled.buffer();
        return switch (command.getType()) {
            case "positionSingle" -> this.encodeContent(command.getDeviceId(), 48, null);
            case "engineStop" -> this.encodeContent(command.getDeviceId(), 57, null);
            case "engineResume" -> this.encodeContent(command.getDeviceId(), 56, null);
            case "setSpeedLimit" -> {
                content.writeByte(command.getInteger("data"));
                yield this.encodeContent(command.getDeviceId(), 107, content);
            }
            case "setOdometer" -> {
                content.writeShort(command.getInteger("data"));
                yield this.encodeContent(command.getDeviceId(), 63, content);
            }
            default -> null;
        };
    }
}

