/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape;

public enum SpatialRelation {
    WITHIN,
    CONTAINS,
    DISJOINT,
    INTERSECTS;


    public SpatialRelation transpose() {
        switch (this) {
            case CONTAINS: {
                return WITHIN;
            }
            case WITHIN: {
                return CONTAINS;
            }
        }
        return this;
    }

    public SpatialRelation combine(SpatialRelation other) {
        if (other == this || other == null) {
            return this;
        }
        if (this == DISJOINT && other == CONTAINS || this == CONTAINS && other == DISJOINT) {
            return CONTAINS;
        }
        return INTERSECTS;
    }

    public boolean intersects() {
        return this != DISJOINT;
    }

    public SpatialRelation inverse() {
        switch (this) {
            case DISJOINT: {
                return CONTAINS;
            }
            case CONTAINS: {
                return DISJOINT;
            }
            case WITHIN: {
                return INTERSECTS;
            }
        }
        return INTERSECTS;
    }
}

