/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;

final class FcmOptionsUtil {
    private static final Pattern ANALYTICS_LABEL_REGEX = Pattern.compile("^[a-zA-Z0-9-_.~%]{0,50}$");

    FcmOptionsUtil() {
    }

    private static boolean isValid(String analyticsLabel) {
        return ANALYTICS_LABEL_REGEX.matcher(analyticsLabel).matches();
    }

    static void checkAnalyticsLabel(String analyticsLabel) {
        Preconditions.checkArgument((analyticsLabel == null || FcmOptionsUtil.isValid(analyticsLabel) ? 1 : 0) != 0, (Object)"Analytics label must have format matching'^[a-zA-Z0-9-_.~%]{1,50}$");
    }
}

