/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geofence;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.jts.JtsShapeFactory;
import org.traccar.geofence.GeofenceGeometry;

public class GeofencePolygon
extends GeofenceGeometry {
    private final List<GeofenceGeometry.Coordinate> coordinates;
    private final double[] constant;
    private final double[] multiple;
    private final boolean needNormalize;

    public GeofencePolygon(String wkt) throws ParseException {
        int i;
        this.coordinates = this.fromWkt(wkt);
        this.calculateBoundary(this.coordinates, 0.0);
        int polyCorners = this.coordinates.size();
        int j = polyCorners - 1;
        this.constant = new double[polyCorners];
        this.multiple = new double[polyCorners];
        boolean hasNegative = false;
        boolean hasPositive = false;
        for (i = 0; i < polyCorners; ++i) {
            if (this.coordinates.get(i).lon() > 90.0) {
                hasPositive = true;
                continue;
            }
            if (!(this.coordinates.get(i).lon() < -90.0)) continue;
            hasNegative = true;
        }
        this.needNormalize = hasPositive && hasNegative;
        i = 0;
        while (i < polyCorners) {
            if (this.normalizeLon(this.coordinates.get(j).lon()) == this.normalizeLon(this.coordinates.get(i).lon())) {
                this.constant[i] = this.coordinates.get(i).lon();
                this.multiple[i] = 0.0;
            } else {
                this.constant[i] = this.coordinates.get(i).lat() - this.normalizeLon(this.coordinates.get(i).lon()) * this.coordinates.get(j).lat() / (this.normalizeLon(this.coordinates.get(j).lon()) - this.normalizeLon(this.coordinates.get(i).lon())) + this.normalizeLon(this.coordinates.get(i).lon()) * this.coordinates.get(i).lat() / (this.normalizeLon(this.coordinates.get(j).lon()) - this.normalizeLon(this.coordinates.get(i).lon()));
                this.multiple[i] = (this.coordinates.get(j).lat() - this.coordinates.get(i).lat()) / (this.normalizeLon(this.coordinates.get(j).lon()) - this.normalizeLon(this.coordinates.get(i).lon()));
            }
            j = i++;
        }
    }

    private double normalizeLon(double lon) {
        if (this.needNormalize && lon < -90.0) {
            return lon + 360.0;
        }
        return lon;
    }

    @Override
    protected boolean containsPointInternal(double latitude, double longitude) {
        int polyCorners = this.coordinates.size();
        int j = polyCorners - 1;
        double longitudeNorm = this.normalizeLon(longitude);
        boolean oddNodes = false;
        int i = 0;
        while (i < polyCorners) {
            if (this.normalizeLon(this.coordinates.get(i).lon()) < longitudeNorm && this.normalizeLon(this.coordinates.get(j).lon()) >= longitudeNorm || this.normalizeLon(this.coordinates.get(j).lon()) < longitudeNorm && this.normalizeLon(this.coordinates.get(i).lon()) >= longitudeNorm) {
                oddNodes ^= longitudeNorm * this.multiple[i] + this.constant[i] < latitude;
            }
            j = i++;
        }
        return oddNodes;
    }

    @Override
    public double calculateArea() {
        JtsShapeFactory jtsShapeFactory = new JtsSpatialContextFactory().newSpatialContext().getShapeFactory();
        ShapeFactory.PolygonBuilder polygonBuilder = jtsShapeFactory.polygon();
        for (GeofenceGeometry.Coordinate coordinate : this.coordinates) {
            polygonBuilder.pointXY(coordinate.lon(), coordinate.lat());
        }
        return polygonBuilder.build().getArea(SpatialContext.GEO) * 111.19507973436875 * 111.19507973436875;
    }

    @Override
    public String toWkt() {
        StringBuilder buf = new StringBuilder();
        buf.append("POLYGON ((");
        for (GeofenceGeometry.Coordinate coordinate : this.coordinates) {
            buf.append(coordinate.lat());
            buf.append(" ");
            buf.append(coordinate.lon());
            buf.append(", ");
        }
        return buf.substring(0, buf.length() - 2) + "))";
    }

    public List<GeofenceGeometry.Coordinate> fromWkt(String wkt) throws ParseException {
        ArrayList<GeofenceGeometry.Coordinate> coordinates = new ArrayList<GeofenceGeometry.Coordinate>();
        if (!wkt.startsWith("POLYGON")) {
            throw new ParseException("Mismatch geometry type", 0);
        }
        String content = wkt.substring(wkt.indexOf("((") + 2, wkt.indexOf("))"));
        if (content.isEmpty()) {
            throw new ParseException("No content", 0);
        }
        String[] commaTokens = content.split(",");
        if (commaTokens.length < 3) {
            throw new ParseException("Not valid content", 0);
        }
        for (String commaToken : commaTokens) {
            double lon;
            double lat;
            String[] tokens = commaToken.trim().split("\\s");
            if (tokens.length != 2) {
                throw new ParseException("Here must be two coordinates: " + commaToken, 0);
            }
            try {
                lat = Double.parseDouble(tokens[0]);
            }
            catch (NumberFormatException e) {
                throw new ParseException(tokens[0] + " is not a double", 0);
            }
            try {
                lon = Double.parseDouble(tokens[1]);
            }
            catch (NumberFormatException e) {
                throw new ParseException(tokens[1] + " is not a double", 0);
            }
            coordinates.add(new GeofenceGeometry.Coordinate(lat, lon));
        }
        return coordinates;
    }
}

