/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import com.google.inject.Provider;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.traccar.api.security.PermissionsService;
import org.traccar.model.Server;
import org.traccar.storage.StorageException;
import org.traccar.web.ResponseWrapper;

@Singleton
public class OverrideTextFilter
implements Filter {
    private final Provider<PermissionsService> permissionsServiceProvider;

    @Inject
    public OverrideTextFilter(Provider<PermissionsService> permissionsServiceProvider) {
        this.permissionsServiceProvider = permissionsServiceProvider;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getServletPath() != null && httpRequest.getServletPath().startsWith("/api")) {
            chain.doFilter(request, response);
            return;
        }
        ResponseWrapper wrappedResponse = new ResponseWrapper(httpResponse);
        chain.doFilter(request, (ServletResponse)wrappedResponse);
        if (response.isCommitted() || httpResponse.getStatus() >= 300 || "HEAD".equals(httpRequest.getMethod())) {
            return;
        }
        byte[] bytes = wrappedResponse.getCapture();
        if (bytes != null) {
            boolean isManifest;
            String contentType = wrappedResponse.getContentType();
            String requestUri = httpRequest.getRequestURI();
            boolean isHtml = contentType != null && contentType.contains("text/html");
            boolean bl = isManifest = requestUri != null && requestUri.endsWith("manifest.webmanifest");
            if (isHtml || isManifest) {
                Server server;
                try {
                    server = ((PermissionsService)this.permissionsServiceProvider.get()).getServer();
                }
                catch (StorageException e) {
                    throw new RuntimeException(e);
                }
                String title = server.getString("title", "Traccar");
                String description = server.getString("description", "Traccar GPS Tracking System");
                String colorPrimary = server.getString("colorPrimary", "#1a237e");
                String alteredContent = new String(wrappedResponse.getCapture(), StandardCharsets.UTF_8).replace("${title}", title).replace("${description}", description).replace("${colorPrimary}", colorPrimary);
                byte[] data = alteredContent.getBytes(StandardCharsets.UTF_8);
                response.setContentLength(data.length);
                response.getOutputStream().write(data);
            } else {
                response.getOutputStream().write(bytes);
            }
        }
    }
}

