// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
)

func TestCopyOrigLogRecordSlice(t *testing.T) {
	src := []*otlplogs.LogRecord{}
	dest := []*otlplogs.LogRecord{}
	// Test CopyTo empty
	dest = CopyOrigLogRecordSlice(dest, src)
	assert.Equal(t, []*otlplogs.LogRecord{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestLogRecordSlice()
	dest = CopyOrigLogRecordSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLogRecordSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigLogRecordSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLogRecordSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigLogRecordSlice(dest, []*otlplogs.LogRecord{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigLogRecordSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLogRecordSlice(), dest)
}
