/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SelectAction
extends AbstractRelationEditorAction {
    private static final long serialVersionUID = 1L;

    public SelectAction(IRelationEditorActionAccess editorAccess) {
        super(editorAccess, IRelationEditorUpdateOn.TAG_CHANGE);
        this.putValue("Name", I18n.tr("Select", new Object[0]));
        this.putValue("ShortDescription", I18n.tr("Select the currently edited relation", new Object[0]));
        new ImageProvider("dialogs", "select").getResource().attachImageIcon(this, true);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation toSelect = this.editorAccess.getEditor().getRelation();
        if (toSelect == null) {
            return;
        }
        this.getLayer().data.setSelected(toSelect);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.editorAccess.getEditor().getRelationSnapshot() != null);
    }
}

