/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.LatLonDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class MoveNodeAction
extends JosmAction {
    public MoveNodeAction() {
        super(I18n.tr("Move Node...", new Object[0]), "movenode", I18n.tr("Edit latitude and longitude of a node.", new Object[0]), Shortcut.registerShortcut("movenode", I18n.tr("Tools: {0}", I18n.tr("Move Node...", new Object[0])), 65535, 5000), true);
        this.setHelpId(HelpUtil.ht("/Action/MoveNode"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection selNodes = this.getLayerManager().getEditDataSet().getSelectedNodes();
        if (!this.isEnabled() || selNodes.size() != 1) {
            return;
        }
        LatLonDialog dialog = new LatLonDialog((Component)MainApplication.getMainFrame(), I18n.tr("Move Node...", new Object[0]), HelpUtil.ht("/Action/MoveNode"));
        Node n = (Node)selNodes.toArray()[0];
        dialog.setCoordinates(n.getCoor());
        dialog.showDialog();
        if (dialog.getValue() != 1) {
            return;
        }
        LatLon coordinates = dialog.getCoordinates();
        if (coordinates == null) {
            return;
        }
        UndoRedoHandler.getInstance().add(new MoveCommand(n, coordinates));
        if (n.getCoor().distance(coordinates) > 1.0) {
            if (coordinates.lon() >= 180.0) {
                coordinates = new LatLon(coordinates.lat(), Math.nextDown(180.0));
            } else if (coordinates.lon() <= -180.0) {
                coordinates = new LatLon(coordinates.lat(), Math.nextUp(-180.0));
            }
            UndoRedoHandler.getInstance().undo(1);
            UndoRedoHandler.getInstance().add(new MoveCommand(n, coordinates));
        }
        MainApplication.getMap().mapView.repaint();
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(OsmUtils.isOsmCollectionEditable(selection) && selection.size() == 1 && selection.toArray()[0] instanceof Node);
    }
}

