// sin.testdata
// copyright (C) 2005 F. de Dinechin, Ch. Q. Lauter and V.Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Special cases
T(RN,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RN,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RU,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RU,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RD,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RD,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RZ,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RZ,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RN,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RN,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RU,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RU,              -0x1p-1074,                 -0x0p+0,          0x1p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RD,               0x1p-1074,                  0x0p+0,         -0x1p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RD,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RZ,               0x1p-1074,                  0x0p+0,         -0x1p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RZ,              -0x1p-1074,                 -0x0p+0,          0x1p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RN,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RN,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RU,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RU,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RD,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RD,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RZ,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RZ,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RN,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RU,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RD,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RZ,                     nan,                     nan,          0x0p+0, 0) // NaN
// Various bad cases either provided by Evgeny Gvozdev, or found during debugging
T(RD,    0x1.32ce90b3217ep+18,                 -0x1p+0,   -0x1.2355ap-2, INEXACT) // a bad case around Pi
T(RD,   0x1.32ce90b32181ep+18,                 -0x1p+0,  -0x1.fc707cp-2, INEXACT) // a transition on a binade boundary
T(RD,   0x1.32ce90b32181fp+18,   -0x1.fffffffffffffp-1, -0x1.bbab8ap-11, INEXACT)
T(RU,   0x1.32ce90b32173ep+18,   -0x1.fffffffffffffp-1,   0x1.f8708cp-1, INEXACT)
// One in five of the very worst cases computed by Lefevre and Muller.
// Rounding these values requires evaluating the function to at least 2^(-100).
// These worst cases have been selected thanks to the filterlists 5 script
// If you want the full list please contact Jean-Michel Muller
T(RN,    0x1.54b3504c6b4a3p-1,    0x1.3c1b936417dddp-1,          0x1p-1, INEXACT) // 6.654305547032389744899205652473e-01
T(RZ,   0x1.84d161f7b171cp-10,   0x1.84d1589fe0e99p-10,  -0x1.8a931p-51, INEXACT) // 1.483222584214022830850776557554e-03
T(RN,   0x1.9161eb1f20886p-10,   0x1.9161e0d7dd8e9p-10,          0x1p-1, INEXACT) // 1.531152702029221681495618767599e-03
T(RZ,   0x1.c4c8b9f809874p-10,   0x1.c4c8ab36e7a47p-10,         -0x1p+0, INEXACT) // 1.727234221115672881119440518205e-03
T(RN,   0x1.c558bb83fe758p-10,   0x1.c558acb4c4313p-10,          0x1p-1, INEXACT) // 1.729380078357730873839237517586e-03
T(RN,   0x1.c60cdb2cd0303p-10,   0x1.c60ccc4be7e9bp-10,         -0x1p-1, INEXACT) // 1.732064130195166236012016547363e-03
T(RZ,   0x1.446b74d46480cp-11,   0x1.446b73790e4f4p-11,         -0x1p+0, INEXACT) // 6.187815693456956943341307209039e-04
T(RN,   0x1.6e3bbdba9ae42p-11,   0x1.6e3bbbc6e9b42p-11,          0x1p-1, INEXACT) // 6.985347057030871168598062936894e-04
T(RZ,   0x1.f12960ec65acbp-11,   0x1.f1295c0a5d205p-11,         -0x1p+0, INEXACT) // 9.482605651552565009451689626019e-04
T(RN,   0x1.8bc6a16659cdap-12,    0x1.8bc6a0c8b147p-12,          0x1p-1, INEXACT) // 3.774413111358850209456350377479e-04
T(RZ,   0x1.c63d1e34b8dd8p-12,   0x1.c63d1d465e65cp-12, -0x1.06d036p-51, INEXACT) // 4.331958219110066364565536645159e-04
T(RZ,   0x1.ecc3edd1ccccep-12,   0x1.ecc3eca182456p-12, -0x1.59279ap-51, INEXACT) // 4.699376560097335382357175426193e-04
T(RN,   0x1.107b328b22c92p-13,   0x1.107b327e46097p-13,          0x1p-1, INEXACT) // 1.299291801369657100607979405282e-04
T(RZ,   0x1.2359262c76506p-13,   0x1.2359261cbd20ap-13,         -0x1p+0, INEXACT) // 1.389256662054709728741641594496e-04
T(RZ,   0x1.8682328e43efdp-13,   0x1.868232686754bp-13,         -0x1p+0, INEXACT) // 1.862090034099247190611109425973e-04
T(RZ,   0x1.852ecf61f5f67p-14,    0x1.852ecf589768p-14,         -0x1p+0, INEXACT) // 9.278842256265976953712865116231e-05
T(RN,   0x1.8d41a9eb26026p-14,   0x1.8d41a9e12f0f6p-14,          0x1p-1, INEXACT) // 9.471333003074951391829505720210e-05
T(RN,   0x1.997d35866ce04p-14,   0x1.997d357b82f1bp-14,          0x1p-1, INEXACT) // 9.762980889754113581271988131505e-05
T(RN,   0x1.c033181c04101p-14,    0x1.c033180db481p-14,         -0x1p-1, INEXACT) // 1.068591085984262192354679599227e-04
T(RN,   0x1.708b239a9dd02p-15,   0x1.708b2398a09afp-15,          0x1p-1, INEXACT) // 4.393381023686840326173547177646e-05
T(RN,   0x1.986a75aeb40f4p-16,   0x1.986a75ae06cefp-16,          0x1p-1, INEXACT) // 2.434348214813780123411818268053e-05
T(RZ,   0x1.aa6782f196027p-16,   0x1.aa6782f0d0d7bp-16,         -0x1p+0, INEXACT) // 2.541567932320978220168093686393e-05
T(RN,   0x1.55a1feaa926f1p-16,   0x1.55a1feaa2d082p-16,          0x1p-1, INEXACT) // 2.036290121968422958524148891346e-05
T(RZ,   0x1.98ec45c2eaa5ep-17,   0x1.98ec45c2bf2c7p-17, -0x1.d77ee8p-53, INEXACT) // 1.218685327393947935028205298291e-05
T(RZ,   0x1.6800000002f76p-17,   0x1.67ffffffe54dap-17,   -0x1.fd15p-59, INEXACT) // 1.072883605959089540061827949824e-05
T(RN,   0x1.d81c0fe235a3dp-17,   0x1.d81c0fe1f2bcfp-17,         -0x1p-1, INEXACT) // 1.406996301904245219983966702637e-05
T(RZ,    0x1.e00000000708p-17,    0x1.dfffffffc0b8p-17,  -0x1.dcba6p-56, INEXACT) // 1.430511474614253909776184769953e-05
T(RZ,   0x1.7388a06068301p-18,   0x1.7388a06060093p-18,         -0x1p+0, INEXACT) // 5.536283510216385095813965838696e-06
T(RN,   0x1.1872e4d27cfb9p-18,    0x1.1872e4d2797ap-18,         -0x1p-1, INEXACT) // 4.179012835770568958014634791676e-06
T(RZ,   0x1.13841c84df561p-19,   0x1.13841c84de815p-19,  -0x1.47a22p-53, INEXACT) // 2.052754612013000006036063729842e-06
T(RZ,   0x1.202c386b35cacp-19,   0x1.202c386b34d74p-19,         -0x1p+0, INEXACT) // 2.147054194527930879080566961559e-06
T(RN,   0x1.32b8464dd24abp-19,   0x1.32b8464dd1253p-19,          0x1p-1, INEXACT) // 2.285240760101038111432860885919e-06
T(RZ,   0x1.580646ae65d0ep-19,   0x1.580646ae6432bp-19,  -0x1.f1f2ep-54, INEXACT) // 2.563182383851322767383176109979e-06
T(RN,   0x1.8175b05446bd1p-19,   0x1.8175b05444767p-19,         -0x1p-1, INEXACT) // 2.871898724288756083925346421215e-06
T(RN,   0x1.bc13870c062f4p-19,   0x1.bc13870c02b46p-19,         -0x1p-1, INEXACT) // 3.308626110875749083543341522162e-06
T(RZ,   0x1.c420e5a255372p-19,   0x1.c420e5a2518afp-19,  -0x1.e243cp-51, INEXACT) // 3.368619858760301073784346886919e-06
T(RN,     0x1.1c63df63d59dp-2,    0x1.18bf91b163125p-2,          0x1p-1, INEXACT) // 2.777247337993715703419184137601e-01
T(RZ,    0x1.50954b7bbf87bp-2,    0x1.4a8e1a96e38e3p-2, -0x1.a24f48p-54, INEXACT) // 3.286945146827588426496902229701e-01
T(RZ,    0x1.69b8bc35af31fp-2,    0x1.623ee90376578p-2,         -0x1p+0, INEXACT) // 3.532437713400202183855469684204e-01
T(RZ,    0x1.e05b0e0a809bcp-2,    0x1.ceee68154d1c8p-2,         -0x1p+0, INEXACT) // 4.690973466787473622474635703838e-01
T(RZ,   0x1.4bec6c97ff89ap-20,   0x1.4bec6c97ff2c9p-20,         -0x1p+0, INEXACT) // 1.236511513624403977483707031682e-06
T(RN,   0x1.56afd8a717aaap-20,   0x1.56afd8a717445p-20,          0x1p-1, INEXACT) // 1.276608182519389185412836754119e-06
T(RZ,   0x1.7c94ac65768c4p-20,      0x1.7c94ac6576p-20,         -0x1p+0, INEXACT) // 1.417773796466698664790143796788e-06
T(RZ,   0x1.9baddc3e50b47p-20,   0x1.9baddc3e5002fp-20,         -0x1p+0, INEXACT) // 1.533624313391269313234014336211e-06
T(RZ,   0x1.a2ce34e9584edp-20,   0x1.a2ce34e95793fp-20,         -0x1p+0, INEXACT) // 1.560172046964892219225837406704e-06
T(RZ,   0x1.ab8aeac473b99p-21,   0x1.ab8aeac47387ep-21,  -0x1.78822p-51, INEXACT) // 7.963602333629416173460991053290e-07
T(RN,   0x1.37d8eed285d62p-21,   0x1.37d8eed285c2ep-21,          0x1p-1, INEXACT) // 5.808610359950615074318145195087e-07
T(RN,   0x1.c47fb71e1a10fp-21,   0x1.c47fb71e19d61p-21,          0x1p-1, INEXACT) // 8.428448585841931068584893631257e-07
T(RZ,   0x1.e267dbfdf41a7p-21,   0x1.e267dbfdf3d31p-21, -0x1.76c9c8p-51, INEXACT) // 8.985506381124528823263019998435e-07
T(RZ,   0x1.fd1109fca2f82p-21,   0x1.fd1109fca2a43p-21,         -0x1p+0, INEXACT) // 9.482103560816799822137538114597e-07
T(RN,   0x1.a050ba4d79ae6p-22,   0x1.a050ba4d79a2fp-22,          0x1p-1, INEXACT) // 3.877238768643274658600036096379e-07
T(RZ,   0x1.5ce31c83539eap-22,   0x1.5ce31c835397ep-22,  -0x1.b6b97p-51, INEXACT) // 3.249264823494212958929238700689e-07
T(RZ,   0x1.61246d6ad9af9p-22,   0x1.61246d6ad9a89p-22, -0x1.bc498cp-51, INEXACT) // 3.288893909908682867212928544604e-07
T(RZ,   0x1.3bacd6561ff5ep-24,   0x1.3bacd6561ff59p-24,  -0x1.9ca09p-53, INEXACT) // 7.349884731562347096546136942380e-08
T(RZ,   0x1.7137449123ef7p-25,   0x1.7137449123ef4p-25,         -0x1p+0, INEXACT) // 4.298238665781642567566384299620e-08
T(RN,   0x1.e3cf476542bd1p-25,   0x1.e3cf476542bccp-25,         -0x1p-1, INEXACT) // 5.632285996801584652132150539579e-08
T(RN,    0x1.2fc3d8d81b559p-3,    0x1.2ea707f215de9p-3,         -0x1p-1, INEXACT) // 1.483227673483422937028564092543e-01
T(RN,    0x1.01a9891dd8e91p-4,    0x1.017e0a8039fb5p-4,         -0x1p-1, INEXACT) // 6.290582238357901589953513621367e-02
T(RN,    0x1.09d9410464c64p-5,    0x1.09cd4f1326d42p-5,          0x1p-1, INEXACT) // 3.245222757973278970844432933518e-02
T(RN,    0x1.2cb566b139f7ep-5,    0x1.2ca41d3efb7d5p-5,         -0x1p-1, INEXACT) // 3.670759255493204198383949687923e-02
T(RZ,    0x1.69949b3d51fb1p-5,      0x1.69768dc89bbp-5,   -0x1.1474p-56, INEXACT) // 4.413824386807563976420354379115e-02
T(RN,    0x1.1d60c80ae0d38p-6,    0x1.1d5d165cf4841p-6,          0x1p-1, INEXACT) // 1.741809401893343323131091437972e-02
T(RN,    0x1.289869cfcd01dp-6,    0x1.2894442d88186p-6,         -0x1p-1, INEXACT) // 1.810274441886871102380673903554e-02
T(RN,    0x1.4c377e1d8441fp-6,    0x1.4c31aa32e3bbep-6,          0x1p-1, INEXACT) // 2.027690235087586598239361990181e-02
T(RN,    0x1.646a68c0185d4p-6,    0x1.6463367fc6012p-6,          0x1p-1, INEXACT) // 2.175388555077069352439167460034e-02
T(RZ,    0x1.d641e6d5e769ap-6,    0x1.d6315f7ee7e01p-6, -0x1.af506cp-51, INEXACT) // 2.870223562751181983765391692032e-02
T(RZ,    0x1.ea829e3e988e5p-6,    0x1.ea6fdc56fc61ap-6,  -0x1.f31fap-51, INEXACT) // 2.993836835447262825771197469749e-02
T(RZ,    0x1.4cf42052e2f0ep-7,    0x1.4cf2a8da00fe4p-7,         -0x1p+0, INEXACT) // 1.016093805608122777051072205268e-02
T(RN,    0x1.8479f46c5bb63p-9,    0x1.8479cf264a7a4p-9,         -0x1p-1, INEXACT) // 2.963839613748063452763892300368e-03
T(RZ,    0x1.d37487f715637p-9,    0x1.d3744705d2484p-9, -0x1.be14cap-51, INEXACT) // 3.566400143919758441296563589162e-03
T(RZ,    0x1.02c2f02bd16d5p+0,    0x1.b1cac622470fep-1,  -0x1.45d3ep-51, INEXACT) // 1.010787020395061519550949924451e+00
T(RZ,    0x1.8272d4fd7730bp+0,    0x1.ff0a5ca04152fp-1, -0x1.f944c8p-52, INEXACT) // 1.509564697152373069499731172982e+00
T(RN,    0x1.d1772843917d7p+0,    0x1.f06844e3884a2p-1,          0x1p-1, INEXACT) // 1.818224445816204015713424269052e+00
// The following are Sun's value distributed with libmcr 0.9
T(RZ, -0x1.5f9f1bdb17192p+749,    0x1.3f601435d8424p-1,  -0x1.ffcfd4p-1, INEXACT)
T(RD, -0x1.5f9f1bdb17192p+749,    0x1.3f601435d8424p-1,  -0x1.ffcfd4p-1, INEXACT)
T(RU, -0x1.5f9f1bdb17192p+749,    0x1.3f601435d8425p-1,   0x1.81581p-12, INEXACT)
T(RZ,  0x1.00c52a5812bd6p+521,   -0x1.fe62d5c04a4e6p-4,   0x1.fffda8p-1, INEXACT)
T(RU,  0x1.00c52a5812bd6p+521,   -0x1.fe62d5c04a4e6p-4,   0x1.fffda8p-1, INEXACT)
T(RD,  0x1.00c52a5812bd6p+521,   -0x1.fe62d5c04a4e7p-4, -0x1.2bc99ep-16, INEXACT)
T(RZ, -0x1.f35d6564377c3p+456,   -0x1.136bee4c1c49cp-1,   0x1.ff8e52p-1, INEXACT)
T(RU, -0x1.f35d6564377c3p+456,   -0x1.136bee4c1c49cp-1,   0x1.ff8e52p-1, INEXACT)
T(RD, -0x1.f35d6564377c3p+456,   -0x1.136bee4c1c49dp-1, -0x1.c6b72ap-11, INEXACT)
T(RZ,  0x1.d63ee836fd883p+982,    0x1.f1181ca5b1be2p-1,  -0x1.ffe944p-1, INEXACT)
T(RD,  0x1.d63ee836fd883p+982,    0x1.f1181ca5b1be2p-1,  -0x1.ffe944p-1, INEXACT)
T(RU,  0x1.d63ee836fd883p+982,    0x1.f1181ca5b1be3p-1,  0x1.6bb15cp-13, INEXACT)
T(RZ, -0x1.d1761c4bb82b3p+663,   -0x1.372e902d9cb5ap-2,   0x1.641acp-11, INEXACT)
T(RU, -0x1.d1761c4bb82b3p+663,   -0x1.372e902d9cb5ap-2,   0x1.641acp-11, INEXACT)
T(RD, -0x1.d1761c4bb82b3p+663,   -0x1.372e902d9cb5bp-2,  -0x1.ffa6fap-1, INEXACT)
T(RZ,  -0x1.78cfb5a61082p+322,   -0x1.d25a82d9993cep-1,  0x1.4ff342p-11, INEXACT)
T(RU,  -0x1.78cfb5a61082p+322,   -0x1.d25a82d9993cep-1,  0x1.4ff342p-11, INEXACT)
T(RD,  -0x1.78cfb5a61082p+322,   -0x1.d25a82d9993cfp-1,  -0x1.ffac04p-1, INEXACT)
T(RZ, -0x1.8a70ced3226b7p+836,    0x1.ed05b63c0242ap-2,  -0x1.ffc8fcp-1, INEXACT)
T(RD, -0x1.8a70ced3226b7p+836,    0x1.ed05b63c0242ap-2,  -0x1.ffc8fcp-1, INEXACT)
T(RU, -0x1.8a70ced3226b7p+836,    0x1.ed05b63c0242bp-2,   0x1.b8278p-12, INEXACT)
T(RZ,  0x1.f2a7172cc06cdp+341,    0x1.16cb83019dabep-1,  -0x1.ff8a9ep-1, INEXACT)
T(RD,  0x1.f2a7172cc06cdp+341,    0x1.16cb83019dabep-1,  -0x1.ff8a9ep-1, INEXACT)
T(RU,  0x1.f2a7172cc06cdp+341,    0x1.16cb83019dabfp-1,  0x1.d5885cp-11, INEXACT)
T(RZ, -0x1.70e3992b8e579p+638,   -0x1.6312891f3b8c7p-3,    0x1.ff88dp-1, INEXACT)
T(RU, -0x1.70e3992b8e579p+638,   -0x1.6312891f3b8c7p-3,    0x1.ff88dp-1, INEXACT)
T(RD, -0x1.70e3992b8e579p+638,   -0x1.6312891f3b8c8p-3, -0x1.dcc3c4p-11, INEXACT)
T(RZ, -0x1.1a765ea9ec213p+196,     -0x1.ff6441bbb6cp-1,    0x1.ffd0cp-1, INEXACT)
T(RU, -0x1.1a765ea9ec213p+196,     -0x1.ff6441bbb6cp-1,    0x1.ffd0cp-1, INEXACT)
T(RD, -0x1.1a765ea9ec213p+196,   -0x1.ff6441bbb6c01p-1, -0x1.7a06e8p-12, INEXACT)
T(RZ,  0x1.a171863a223bap+751,   -0x1.998a82112a225p-1,    0x1.ffedap-1, INEXACT)
T(RU,  0x1.a171863a223bap+751,   -0x1.998a82112a225p-1,    0x1.ffedap-1, INEXACT)
T(RD,  0x1.a171863a223bap+751,   -0x1.998a82112a226p-1, -0x1.25fab2p-13, INEXACT)
T(RZ,   0x1.1ed9b5c46b27p+201,   -0x1.ad44ae51b2d08p-1,  0x1.87b102p-11, INEXACT)
T(RU,   0x1.1ed9b5c46b27p+201,   -0x1.ad44ae51b2d08p-1,  0x1.87b102p-11, INEXACT)
T(RD,   0x1.1ed9b5c46b27p+201,   -0x1.ad44ae51b2d09p-1,  -0x1.ff9e14p-1, INEXACT)
T(RN,    0x1.2e9eff2eb5e07p+7,    0x1.f78c235df2c7fp-2,  -0x1.ffabeap-2, INEXACT)
T(RZ,  0x1.95379e1e5a7b9p+130,    0x1.ffffe776a31bep-1, -0x1.f729dap-12, INEXACT)
T(RD,  0x1.95379e1e5a7b9p+130,    0x1.ffffe776a31bep-1, -0x1.f729dap-12, INEXACT)
T(RU,  0x1.95379e1e5a7b9p+130,    0x1.ffffe776a31bfp-1,   0x1.ffc11ap-1, INEXACT)
T(RN, -0x1.0be4a97f5a84dp+331,    0x1.4ae1c631ace31p-1,  -0x1.ff9e08p-2, INEXACT)
T(RZ,  0x1.f75e0e3d75339p+197,   -0x1.a211942d5d2a1p-1,   0x1.fff57ap-1, INEXACT)
T(RU,  0x1.f75e0e3d75339p+197,   -0x1.a211942d5d2a1p-1,   0x1.fff57ap-1, INEXACT)
T(RD,  0x1.f75e0e3d75339p+197,   -0x1.a211942d5d2a2p-1,  -0x1.50b0ap-14, INEXACT)
T(RN, -0x1.81fcb9ad6e2d8p+325,   -0x1.e0354edbf0bdcp-1,  -0x1.ffb552p-2, INEXACT)
T(RZ,   0x1.f345926e3483p+765,    0x1.e9f0491863653p-4, -0x1.0f360cp-12, INEXACT)
T(RD,   0x1.f345926e3483p+765,    0x1.e9f0491863653p-4, -0x1.0f360cp-12, INEXACT)
T(RU,   0x1.f345926e3483p+765,    0x1.e9f0491863654p-4,   0x1.ffde1ap-1, INEXACT)
T(RZ,  0x1.d502048a3da6fp+855,   -0x1.b95e9ddf12822p-2,   0x1.ce3f9p-12, INEXACT)
T(RU,  0x1.d502048a3da6fp+855,   -0x1.b95e9ddf12822p-2,   0x1.ce3f9p-12, INEXACT)
T(RD,  0x1.d502048a3da6fp+855,   -0x1.b95e9ddf12823p-2,  -0x1.ffc638p-1, INEXACT)
T(RZ,   -0x1.30bf9082423p+787,   -0x1.e8be8c304826dp-1,  0x1.ceddf8p-11, INEXACT)
T(RU,   -0x1.30bf9082423p+787,   -0x1.e8be8c304826dp-1,  0x1.ceddf8p-11, INEXACT)
T(RD,   -0x1.30bf9082423p+787,   -0x1.e8be8c304826ep-1,  -0x1.ff8c48p-1, INEXACT)
T(RZ, -0x1.d7cabede26ebep+725,    -0x1.99fc2cb3b505p-1,   0x1.fcea2p-12, INEXACT)
T(RU, -0x1.d7cabede26ebep+725,    -0x1.99fc2cb3b505p-1,   0x1.fcea2p-12, INEXACT)
T(RD, -0x1.d7cabede26ebep+725,   -0x1.99fc2cb3b5051p-1,  -0x1.ffc062p-1, INEXACT)
T(RZ,  -0x1.a7c878dae43cp+761,   -0x1.4ff41838afb63p-1,  0x1.4a13aap-11, INEXACT)
T(RU,  -0x1.a7c878dae43cp+761,   -0x1.4ff41838afb63p-1,  0x1.4a13aap-11, INEXACT)
T(RD,  -0x1.a7c878dae43cp+761,   -0x1.4ff41838afb64p-1,  -0x1.ffad7cp-1, INEXACT)
T(RZ,  0x1.2910bde3b4944p+895,    0x1.48b1e4b5228dfp-5, -0x1.5d6a3ep-13, INEXACT)
T(RD,  0x1.2910bde3b4944p+895,    0x1.48b1e4b5228dfp-5, -0x1.5d6a3ep-13, INEXACT)
T(RU,  0x1.2910bde3b4944p+895,     0x1.48b1e4b5228ep-5,   0x1.ffea2ap-1, INEXACT)
T(RN,   0x1.2a2a578d79469p+54,    0x1.e5aadfc9dee64p-1,  -0x1.ffab94p-2, INEXACT)
T(RN,   0x1.1075cae366d6cp+98,     0x1.bccfe46ed83bp-1,  -0x1.ff7d88p-2, INEXACT)
T(RN,  -0x1.d757c586a429bp+73,    0x1.89949f55956efp-1,  -0x1.ffff76p-2, INEXACT)
T(RN, -0x1.6042513cd49eap+583,    0x1.f93fe81ff530cp-2,  -0x1.ff2e16p-2, INEXACT)
T(RN,  0x1.4480d5dc90828p+858,    0x1.d89b89e580d39p-1,  -0x1.ffe1d4p-2, INEXACT)
T(RN,   0x1.9efaa34b6807p+565,    0x1.89149ae22af06p-1,   -0x1.ff495p-2, INEXACT)
T(RN,  0x1.43cf269db3c5dp+939,    0x1.87af8a78f4e2cp-1,  -0x1.ff0796p-2, INEXACT)
T(RN,  0x1.f884b62034105p+268,   -0x1.bb787c52c5a14p-8,   -0x1.ff99cp-2, INEXACT)
T(RN, -0x1.9194aacab303fp+278,    0x1.f74c655412d98p-1,   -0x1.ffa54p-2, INEXACT)
T(RN, -0x1.9452afdcc8677p+152,    0x1.03166a5d48b09p-2,  -0x1.ff0042p-2, INEXACT)
T(RN, -0x1.bf8a4bf119ea2p+964,   -0x1.fe43ca14b06f2p-1,  -0x1.ff516ep-2, INEXACT)
T(RN,  0x1.471a9ed06baedp+541,   -0x1.c21c945dff42ep-1,  -0x1.ff1f06p-2, INEXACT)
T(RN, 0x1.45a696a9a1d5cp+1003,   -0x1.ab45fa2f2099dp-1,   -0x1.ff376p-2, INEXACT)
T(RN,  0x1.97c098b783386p+897,   -0x1.395c0696ee749p-2,  -0x1.ffacb4p-2, INEXACT)
T(RN, -0x1.25a70a1b8e77bp+198,   -0x1.9d6cb02073442p-1,  -0x1.ff05a8p-2, INEXACT)
T(RN, -0x1.7b850a284b69fp+258,    0x1.5684a83dac0a5p-1,   -0x1.ff725p-2, INEXACT)
T(RN,  0x1.65f011dc85024p+327,   -0x1.8d552cf3721aap-1,  -0x1.ff5024p-2, INEXACT)
T(RZ, -0x1.dab963a0798bfp+108,   -0x1.25d3a454d39eap-2,  0x1.1020eap-15, INEXACT)
T(RU, -0x1.dab963a0798bfp+108,   -0x1.25d3a454d39eap-2,  0x1.1020eap-15, INEXACT)
T(RD, -0x1.dab963a0798bfp+108,   -0x1.25d3a454d39ebp-2,   -0x1.fffbcp-1, INEXACT)
T(RZ, -0x1.608f20fbd712ap+933,   -0x1.37240a39f25a7p-2,   0x1.fff726p-1, INEXACT)
T(RU, -0x1.608f20fbd712ap+933,   -0x1.37240a39f25a7p-2,   0x1.fff726p-1, INEXACT)
T(RD, -0x1.608f20fbd712ap+933,   -0x1.37240a39f25a8p-2, -0x1.1b35eep-14, INEXACT)
T(RZ, -0x1.466db5f95fc26p+443,   -0x1.da3af25ec53aap-1,   0x1.fffb6ap-1, INEXACT)
T(RU, -0x1.466db5f95fc26p+443,   -0x1.da3af25ec53aap-1,   0x1.fffb6ap-1, INEXACT)
T(RD, -0x1.466db5f95fc26p+443,   -0x1.da3af25ec53abp-1, -0x1.25452ep-15, INEXACT)
T(RZ,  0x1.9e82efbe6ec1ap+742,   -0x1.bf3b085f43b09p-2,  0x1.4b4daep-18, INEXACT)
T(RU,  0x1.9e82efbe6ec1ap+742,   -0x1.bf3b085f43b09p-2,  0x1.4b4daep-18, INEXACT)
T(RD,  0x1.9e82efbe6ec1ap+742,   -0x1.bf3b085f43b0ap-2,  -0x1.ffff5ap-1, INEXACT)
T(RZ,  0x1.c56ba795b75a5p+242,   -0x1.eb7a65a026985p-1,  0x1.56b1f6p-14, INEXACT)
T(RU,  0x1.c56ba795b75a5p+242,   -0x1.eb7a65a026985p-1,  0x1.56b1f6p-14, INEXACT)
T(RD,  0x1.c56ba795b75a5p+242,   -0x1.eb7a65a026986p-1,  -0x1.fff54ap-1, INEXACT)
T(RN, -0x1.0a42a7a161cb6p+907,   -0x1.5d3a9da42282dp-1,  -0x1.ffec4ep-2, INEXACT)
T(RZ,  0x1.65790905ef165p+757,    0x1.58c87a29f59fbp-1,  -0x1.66616p-14, INEXACT)
T(RD,  0x1.65790905ef165p+757,    0x1.58c87a29f59fbp-1,  -0x1.66616p-14, INEXACT)
T(RU,  0x1.65790905ef165p+757,    0x1.58c87a29f59fcp-1,   0x1.fff4ccp-1, INEXACT)
T(RN,  0x1.5783e2ba92048p+749,   -0x1.56a73e819b994p-1,  -0x1.ffe992p-2, INEXACT)
T(RZ, -0x1.986cdc8e3968ap+292,   -0x1.d975f283dac49p-1,   0x1.fffda8p-1, INEXACT)
T(RU, -0x1.986cdc8e3968ap+292,   -0x1.d975f283dac49p-1,   0x1.fffda8p-1, INEXACT)
T(RD, -0x1.986cdc8e3968ap+292,   -0x1.d975f283dac4ap-1, -0x1.2b9154p-16, INEXACT)
T(RN,  -0x1.25cb40708dc16p+80,   -0x1.2ac6cca512461p-1,  -0x1.fffa5ap-2, INEXACT)
T(RZ, -0x1.36185f37025cbp+979,    0x1.0bd92113f4896p-3,  -0x1.fffb8ep-1, INEXACT)
T(RD, -0x1.36185f37025cbp+979,    0x1.0bd92113f4896p-3,  -0x1.fffb8ep-1, INEXACT)
T(RU, -0x1.36185f37025cbp+979,    0x1.0bd92113f4897p-3,  0x1.1c969ap-15, INEXACT)
T(RZ,  0x1.29ba130472fc6p+271,   -0x1.6662fb93af1f4p-1,  0x1.bff24cp-15, INEXACT)
T(RU,  0x1.29ba130472fc6p+271,   -0x1.6662fb93af1f4p-1,  0x1.bff24cp-15, INEXACT)
T(RD,  0x1.29ba130472fc6p+271,   -0x1.6662fb93af1f5p-1,    -0x1.fff9p-1, INEXACT)
T(RN, -0x1.d379f62c695d9p+135,   -0x1.27e25571a5cf8p-1,  -0x1.ffe4f2p-2, INEXACT)
T(RN, -0x1.dd10271efd07dp+400,    0x1.c5d3791174288p-2,  -0x1.ffeddcp-2, INEXACT)
T(RN,  0x1.a19fd8051cfdap+346,   -0x1.9a467a9fe42edp-3,  -0x1.ffef6ap-2, INEXACT)
T(RN,-0x1.a64a91df15ed4p+1017,   -0x1.a66b6c375135bp-1,   -0x1.fff41p-2, INEXACT)
T(RN,   0x1.6dbaac3676a0fp+20,    0x1.819f178fb1bd7p-1,   -0x1.ffef4p-2, INEXACT)
T(RZ, -0x1.c6ef96d56d62ap+745,   -0x1.21b13100491d6p-2,   0x1.fffdfap-1, INEXACT)
T(RU, -0x1.c6ef96d56d62ap+745,   -0x1.21b13100491d6p-2,   0x1.fffdfap-1, INEXACT)
T(RD, -0x1.c6ef96d56d62ap+745,   -0x1.21b13100491d7p-2, -0x1.02b05ap-16, INEXACT)
T(RZ,    0x1.e62ea30906114p-2,    0x1.d41eeffb3fa0dp-2, -0x1.c994a6p-14, INEXACT)
T(RD,    0x1.e62ea30906114p-2,    0x1.d41eeffb3fa0dp-2, -0x1.c994a6p-14, INEXACT)
T(RU,    0x1.e62ea30906114p-2,    0x1.d41eeffb3fa0ep-2,   0x1.fff1b4p-1, INEXACT)
T(RZ,  0x1.50e032751c7ffp+215,   -0x1.ede358a7fc1a6p-1,   0x1.fff9dep-1, INEXACT)
T(RU,  0x1.50e032751c7ffp+215,   -0x1.ede358a7fc1a6p-1,   0x1.fff9dep-1, INEXACT)
T(RD,  0x1.50e032751c7ffp+215,   -0x1.ede358a7fc1a7p-1, -0x1.88952ap-15, INEXACT)
T(RN,  0x1.d21ac92cfc7a2p+725,   -0x1.5204ff391f9aep-2,  -0x1.fff7d8p-2, INEXACT)
T(RN, -0x1.56ed200c65feep+918,   -0x1.fb750f6a35df3p-1,  -0x1.fff35ap-2, INEXACT)
T(RZ, -0x1.ba607bc641338p+737,   -0x1.fad24e7c284e9p-1,  0x1.388d34p-15, INEXACT)
T(RU, -0x1.ba607bc641338p+737,   -0x1.fad24e7c284e9p-1,  0x1.388d34p-15, INEXACT)
T(RD, -0x1.ba607bc641338p+737,   -0x1.fad24e7c284eap-1,  -0x1.fffb1ep-1, INEXACT)
T(RZ,  0x1.a1b2e141099b8p+929,   -0x1.1f81e1ae0c004p-3,   0x1.fffd98p-1, INEXACT)
T(RU,  0x1.a1b2e141099b8p+929,   -0x1.1f81e1ae0c004p-3,   0x1.fffd98p-1, INEXACT)
T(RD,  0x1.a1b2e141099b8p+929,   -0x1.1f81e1ae0c005p-3, -0x1.34611ap-16, INEXACT)
T(RZ, -0x1.71296ab8c3a6bp+554,   -0x1.e1447128cf0a7p-1,   0x1.fffc38p-1, INEXACT)
T(RU, -0x1.71296ab8c3a6bp+554,   -0x1.e1447128cf0a7p-1,   0x1.fffc38p-1, INEXACT)
T(RD, -0x1.71296ab8c3a6bp+554,   -0x1.e1447128cf0a8p-1, -0x1.e388acp-16, INEXACT)
T(RZ,  0x1.f3db7d8c065dfp+607,     0x1.fc04e92a40acp-7, -0x1.1cc21cp-14, INEXACT)
T(RD,  0x1.f3db7d8c065dfp+607,     0x1.fc04e92a40acp-7, -0x1.1cc21cp-14, INEXACT)
T(RU,  0x1.f3db7d8c065dfp+607,    0x1.fc04e92a40ac1p-7,   0x1.fff71ap-1, INEXACT)
T(RZ, -0x1.48670d1332f78p+993,   -0x1.364b324fd9883p-1,  0x1.836dc4p-14, INEXACT)
T(RU, -0x1.48670d1332f78p+993,   -0x1.364b324fd9883p-1,  0x1.836dc4p-14, INEXACT)
T(RD, -0x1.48670d1332f78p+993,   -0x1.364b324fd9884p-1,  -0x1.fff3e4p-1, INEXACT)
T(RN,   0x1.a51969eaf1f2p+281,   -0x1.ee49c888a3d6dp-1,  -0x1.ffed7cp-2, INEXACT)
T(RZ,   0x1.8f6ec6541c4ap+357,    0x1.cf25b3afbc256p-2,  -0x1.fff7ccp-1, INEXACT)
T(RD,   0x1.8f6ec6541c4ap+357,    0x1.cf25b3afbc256p-2,  -0x1.fff7ccp-1, INEXACT)
T(RU,   0x1.8f6ec6541c4ap+357,    0x1.cf25b3afbc257p-2,  0x1.0696aap-14, INEXACT)
T(RZ, -0x1.17c1ce4f56deap+702,   -0x1.f9114a93867b5p-1,  0x1.af49a4p-17, INEXACT)
T(RU, -0x1.17c1ce4f56deap+702,   -0x1.f9114a93867b5p-1,  0x1.af49a4p-17, INEXACT)
T(RD, -0x1.17c1ce4f56deap+702,   -0x1.f9114a93867b6p-1,   -0x1.fffe5p-1, INEXACT)
T(RZ,  0x1.99586b42195e5p+551,    0x1.f34ceae007facp-1,  -0x1.e1239p-14, INEXACT)
T(RD,  0x1.99586b42195e5p+551,    0x1.f34ceae007facp-1,  -0x1.e1239p-14, INEXACT)
T(RU,  0x1.99586b42195e5p+551,    0x1.f34ceae007fadp-1,   0x1.fff0f6p-1, INEXACT)
T(RN, -0x1.69e7b910a54f2p+139,    0x1.b8da2b040149dp-4,  -0x1.ffe2bcp-2, INEXACT)
T(RN,  0x1.a9793832c4185p+992,    0x1.70e79879d412fp-1,  -0x1.fff994p-2, INEXACT)
T(RN, -0x1.9551b0d340e0dp+777,   -0x1.ff0861df974b4p-1,   -0x1.ffec8p-2, INEXACT)
T(RN,  0x1.45da236ce3ea7p+716,    0x1.9e17310535384p-1,  -0x1.ffece2p-2, INEXACT)
T(RN, -0x1.219cd16073f81p+312,   -0x1.cd89ee30b0259p-1,  -0x1.fffda6p-2, INEXACT)
T(RN, -0x1.abac17f237847p+241,   -0x1.88d9cf4858223p-8,  -0x1.fff80ap-2, INEXACT)
T(RN, -0x1.f5dde59469b6fp+742,   -0x1.7140f482b1ef3p-2,  -0x1.fff98cp-2, INEXACT)
T(RN,  0x1.7c7212e50d094p+478,    0x1.b492ab9a2230ap-1,  -0x1.ffea64p-2, INEXACT)
T(RN,  0x1.a15519fb5a764p+861,    0x1.4c02de34d82b4p-6,  -0x1.ffe3f2p-2, INEXACT)
T(RZ, -0x1.ec9cb558d5785p+121,   -0x1.683f2009d98c7p-1,   0x1.ffff28p-1, INEXACT)
T(RU, -0x1.ec9cb558d5785p+121,   -0x1.683f2009d98c7p-1,   0x1.ffff28p-1, INEXACT)
T(RD, -0x1.ec9cb558d5785p+121,   -0x1.683f2009d98c8p-1, -0x1.af7f64p-18, INEXACT)
T(RZ, -0x1.005b4fd32fd1cp+127,    0x1.d974d00f8d408p-4,  -0x1.fffe3cp-1, INEXACT)
T(RD, -0x1.005b4fd32fd1cp+127,    0x1.d974d00f8d408p-4,  -0x1.fffe3cp-1, INEXACT)
T(RU, -0x1.005b4fd32fd1cp+127,    0x1.d974d00f8d409p-4,  0x1.c4dbcep-17, INEXACT)
T(RZ, -0x1.7a0da3c2aa173p+764,   -0x1.61559155d3dbcp-1,   0x1.fffe9cp-1, INEXACT)
T(RU, -0x1.7a0da3c2aa173p+764,   -0x1.61559155d3dbcp-1,   0x1.fffe9cp-1, INEXACT)
T(RD, -0x1.7a0da3c2aa173p+764,   -0x1.61559155d3dbdp-1,  -0x1.64882p-17, INEXACT)
T(RZ,  0x1.5f9713d4cabcfp+479,    0x1.109164b5a5e23p-1,   -0x1.fffebp-1, INEXACT)
T(RD,  0x1.5f9713d4cabcfp+479,    0x1.109164b5a5e23p-1,   -0x1.fffebp-1, INEXACT)
T(RU,  0x1.5f9713d4cabcfp+479,    0x1.109164b5a5e24p-1,    0x1.4f84p-17, INEXACT)
T(RN,  -0x1.cbee43aeb4196p+65,    0x1.bfbd9b02cee6cp-3,  -0x1.fffe8ap-2, INEXACT)
T(RN, -0x1.c0a16304a4fcfp+993,   -0x1.0e0e3b8e1af33p-2,  -0x1.fffc04p-2, INEXACT)
T(RZ, -0x1.3f8846196906fp+931,    0x1.8dc8de6993f1ep-3, -0x1.8ebb04p-18, INEXACT)
T(RD, -0x1.3f8846196906fp+931,    0x1.8dc8de6993f1ep-3, -0x1.8ebb04p-18, INEXACT)
T(RU, -0x1.3f8846196906fp+931,    0x1.8dc8de6993f1fp-3,   0x1.ffff38p-1, INEXACT)
T(RN, -0x1.a92ad5676205fp+898,    0x1.fb8b0f101c5cbp-1,  -0x1.fffc48p-2, INEXACT)
T(RZ, -0x1.a03def3b48ae8p+900,   -0x1.f07ccd56c08eep-4,   0x1.fffe9cp-1, INEXACT)
T(RU, -0x1.a03def3b48ae8p+900,   -0x1.f07ccd56c08eep-4,   0x1.fffe9cp-1, INEXACT)
T(RD, -0x1.a03def3b48ae8p+900,   -0x1.f07ccd56c08efp-4, -0x1.64f2f8p-17, INEXACT)
T(RN, -0x1.6c3c4743ac66bp+445,     -0x1.14fcaceaac1p-1,  -0x1.ffffcep-2, INEXACT)
T(RZ, -0x1.f7b58885a6556p+186,    0x1.a38edae9a452bp-1, -0x1.063254p-18, INEXACT)
T(RD, -0x1.f7b58885a6556p+186,    0x1.a38edae9a452bp-1, -0x1.063254p-18, INEXACT)
T(RU, -0x1.f7b58885a6556p+186,    0x1.a38edae9a452cp-1,   0x1.ffff7cp-1, INEXACT)
T(RN,  -0x1.8ae90dc63d19p+653,    0x1.6ca7e24c78e03p-3,  -0x1.ffff8cp-2, INEXACT)
T(RZ,  -0x1.0a885a0843e5bp+86,    0x1.fae1c57519ec4p-1, -0x1.52ce2cp-18, INEXACT)
T(RD,  -0x1.0a885a0843e5bp+86,    0x1.fae1c57519ec4p-1, -0x1.52ce2cp-18, INEXACT)
T(RU,  -0x1.0a885a0843e5bp+86,    0x1.fae1c57519ec5p-1,   0x1.ffff56p-1, INEXACT)
T(RZ, -0x1.c21dd8b21a754p+122,    0x1.402a0b2c738e7p-1,  -0x1.fffe42p-1, INEXACT)
T(RD, -0x1.c21dd8b21a754p+122,    0x1.402a0b2c738e7p-1,  -0x1.fffe42p-1, INEXACT)
T(RU, -0x1.c21dd8b21a754p+122,    0x1.402a0b2c738e8p-1,  0x1.be0b38p-17, INEXACT)
T(RZ, -0x1.3479cc9d40e68p+296,   -0x1.dad056ac41d43p-1,   0x1.36343p-17, INEXACT)
T(RU, -0x1.3479cc9d40e68p+296,   -0x1.dad056ac41d43p-1,   0x1.36343p-17, INEXACT)
T(RD, -0x1.3479cc9d40e68p+296,   -0x1.dad056ac41d44p-1,  -0x1.fffecap-1, INEXACT)
T(RZ, -0x1.3c52d9d9cbf88p+907,   -0x1.41f72e3e35e0dp-1,  0x1.0b950cp-25, INEXACT)
T(RU, -0x1.3c52d9d9cbf88p+907,   -0x1.41f72e3e35e0dp-1,  0x1.0b950cp-25, INEXACT)
T(RD, -0x1.3c52d9d9cbf88p+907,   -0x1.41f72e3e35e0ep-1,  -0x1.fffffep-1, INEXACT)
T(RZ,  0x1.99c1a1d86be3dp+732,    0x1.0622c27a3ef77p-1,  -0x1.fffe46p-1, INEXACT)
T(RD,  0x1.99c1a1d86be3dp+732,    0x1.0622c27a3ef77p-1,  -0x1.fffe46p-1, INEXACT)
T(RU,  0x1.99c1a1d86be3dp+732,    0x1.0622c27a3ef78p-1,  0x1.ba969cp-17, INEXACT)
T(RZ,  0x1.0fc3b46f16d62p+284,    0x1.56d2fe8d8940dp-1, -0x1.37466ep-17, INEXACT)
T(RD,  0x1.0fc3b46f16d62p+284,    0x1.56d2fe8d8940dp-1, -0x1.37466ep-17, INEXACT)
T(RU,  0x1.0fc3b46f16d62p+284,    0x1.56d2fe8d8940ep-1,   0x1.fffec8p-1, INEXACT)
T(RZ, -0x1.f6bc88b4194cbp+685,    0x1.a575bc1e37fadp-1, -0x1.6350e2p-21, INEXACT)
T(RD, -0x1.f6bc88b4194cbp+685,    0x1.a575bc1e37fadp-1, -0x1.6350e2p-21, INEXACT)
T(RU, -0x1.f6bc88b4194cbp+685,    0x1.a575bc1e37faep-1,   0x1.ffffeap-1, INEXACT)
T(RZ, -0x1.cf091ea461dc1p+629,   -0x1.161c0887aa789p-1,    0x1.fffe2p-1, INEXACT)
T(RU, -0x1.cf091ea461dc1p+629,   -0x1.161c0887aa789p-1,    0x1.fffe2p-1, INEXACT)
T(RD, -0x1.cf091ea461dc1p+629,   -0x1.161c0887aa78ap-1, -0x1.e05d74p-17, INEXACT)
T(RZ,  0x1.f89951c0f49d1p+459,    0x1.daf6809d74949p-1, -0x1.9e63dcp-25, INEXACT)
T(RD,  0x1.f89951c0f49d1p+459,    0x1.daf6809d74949p-1, -0x1.9e63dcp-25, INEXACT)
T(RU,  0x1.f89951c0f49d1p+459,    0x1.daf6809d7494ap-1,   0x1.fffffep-1, INEXACT)
T(RZ, -0x1.78e3c52c2d2b8p+227,    0x1.fff8db09424dap-3, -0x1.2caf4ap-17, INEXACT)
T(RD, -0x1.78e3c52c2d2b8p+227,    0x1.fff8db09424dap-3, -0x1.2caf4ap-17, INEXACT)
T(RU, -0x1.78e3c52c2d2b8p+227,    0x1.fff8db09424dbp-3,   0x1.fffed4p-1, INEXACT)
T(RN,  0x1.f7a8b5065b16ap+130,    0x1.95a393bea815fp-1,  -0x1.fffcbcp-2, INEXACT)
T(RZ, -0x1.f9a3623f779a8p+428,    0x1.211954c572e74p-2, -0x1.67ed4cp-19, INEXACT)
T(RD, -0x1.f9a3623f779a8p+428,    0x1.211954c572e74p-2, -0x1.67ed4cp-19, INEXACT)
T(RU, -0x1.f9a3623f779a8p+428,    0x1.211954c572e75p-2,   0x1.ffffa6p-1, INEXACT)
T(RN,  0x1.45efdffc1f933p+825,    0x1.84cdc045cacfcp-2,  -0x1.fffe72p-2, INEXACT)
T(RZ,-0x1.29112b043b435p+1016,   -0x1.df26b930ab9a8p-1,  0x1.4a9724p-17, INEXACT)
T(RU,-0x1.29112b043b435p+1016,   -0x1.df26b930ab9a8p-1,  0x1.4a9724p-17, INEXACT)
T(RD,-0x1.29112b043b435p+1016,   -0x1.df26b930ab9a9p-1,  -0x1.fffeb6p-1, INEXACT)
T(RZ,  0x1.e544be316187dp+126,   -0x1.fceb6c47fde1cp-1,   0x1.fffeb8p-1, INEXACT)
T(RU,  0x1.e544be316187dp+126,   -0x1.fceb6c47fde1cp-1,   0x1.fffeb8p-1, INEXACT)
T(RD,  0x1.e544be316187dp+126,   -0x1.fceb6c47fde1dp-1, -0x1.482324p-17, INEXACT)
T(RN, -0x1.cfbbedb9d9339p+922,     0x1.147bd0588352p-1,  -0x1.ffffd4p-2, INEXACT)
T(RN, -0x1.2bab0c5447352p+346,   -0x1.7de9578009cf9p-1,  -0x1.fffc46p-2, INEXACT)
T(RN, -0x1.95bf7e6411928p+156,   -0x1.84b01dd640bacp-2,  -0x1.ffff84p-2, INEXACT)
T(RN,  -0x1.e2df833c97132p+64,   -0x1.bede58155fb7ep-1,  -0x1.fffd86p-2, INEXACT)
T(RN,  0x1.6bbeabf5faceap+529,   -0x1.907d8791330ffp-1,  -0x1.fffe62p-2, INEXACT)
T(RN,  0x1.31a028bf845e4p+144,    0x1.fd8e746d53bcbp-1,  -0x1.ffffd2p-2, INEXACT)
T(RN,   -0x1.29aabac3413cbp+1,   -0x1.74f893c37f458p-1,  -0x1.fffea4p-2, INEXACT)
T(RN,  0x1.f799d92ff4d54p+687,   -0x1.eb4ac79c126d8p-1,  -0x1.fffc8ep-2, INEXACT)
T(RN, -0x1.51e7af148da21p+886,    0x1.f7bcfcf3a016ep-1,  -0x1.fffc76p-2, INEXACT)
T(RN,  0x1.c7b01c5cb67bfp+578,    0x1.5f2c46fbf68e9p-2,  -0x1.fffea6p-2, INEXACT)
T(RN,    0x1.c5d97f43de742p-2,    0x1.b722d297bfe27p-2,  -0x1.fffebap-2, INEXACT)
T(RN,  0x1.3e06ef0a47251p+792,    0x1.f04281440a3b4p-2,  -0x1.fffcfcp-2, INEXACT)
T(RN, -0x1.44c8fa1517775p+715,    0x1.901b7fba562fep-3,  -0x1.fffcd4p-2, INEXACT)
T(RZ,  0x1.417116c995e5cp+808,    0x1.267c48368f32bp-1, -0x1.7bd652p-22, INEXACT)
T(RD,  0x1.417116c995e5cp+808,    0x1.267c48368f32bp-1, -0x1.7bd652p-22, INEXACT)
T(RU,  0x1.417116c995e5cp+808,    0x1.267c48368f32cp-1,   0x1.fffff4p-1, INEXACT)
T(RN,  0x1.626d09d738c66p+977,   -0x1.33dd0f784f876p-3,  -0x1.fffff4p-2, INEXACT)
T(RN,  0x1.c3c73ec2884dbp+965,   -0x1.bfec18bf2a785p-5,  -0x1.ffffb4p-2, INEXACT)
T(RN, -0x1.fa022523e8205p+667,    0x1.be7ef70e561e2p-1,   -0x1.ffffep-2, INEXACT)
T(RZ, -0x1.e8a088705e5b7p+229,    0x1.26145640d9571p-2, -0x1.941328p-20, INEXACT)
T(RD, -0x1.e8a088705e5b7p+229,    0x1.26145640d9571p-2, -0x1.941328p-20, INEXACT)
T(RU, -0x1.e8a088705e5b7p+229,    0x1.26145640d9572p-2,   0x1.ffffcep-1, INEXACT)
T(RN,  0x1.fed2c87db8984p+330,   -0x1.ab1136cd112a1p-1,   -0x1.ffffcp-2, INEXACT)
T(RZ, -0x1.898ec39157754p+290,   -0x1.e3f58496e1b09p-2,   0x1.ffffd8p-1, INEXACT)
T(RU, -0x1.898ec39157754p+290,   -0x1.e3f58496e1b09p-2,   0x1.ffffd8p-1, INEXACT)
T(RD, -0x1.898ec39157754p+290,   -0x1.e3f58496e1b0ap-2, -0x1.3c74b6p-20, INEXACT)
T(RN,  0x1.7bf3a8410de3fp+802,    0x1.95a97fa5b956cp-3,  -0x1.ffffb6p-2, INEXACT)
T(RZ,     0x1.e578ed54b3a5p-2,    0x1.d37d4c3be7373p-2,  -0x1.ffffc8p-1, INEXACT)
T(RD,     0x1.e578ed54b3a5p-2,    0x1.d37d4c3be7373p-2,  -0x1.ffffc8p-1, INEXACT)
T(RU,     0x1.e578ed54b3a5p-2,    0x1.d37d4c3be7374p-2,  0x1.bbd974p-20, INEXACT)
T(RN,  0x1.6f693c24f11dap+387,   -0x1.ff5d51df24db6p-1,   -0x1.ffffbp-2, INEXACT)
T(RZ, -0x1.3ab432eec3ee1p+707,   -0x1.fdd41c5a29eedp-1,  0x1.ff6034p-20, INEXACT)
T(RU, -0x1.3ab432eec3ee1p+707,   -0x1.fdd41c5a29eedp-1,  0x1.ff6034p-20, INEXACT)
T(RD, -0x1.3ab432eec3ee1p+707,   -0x1.fdd41c5a29eeep-1,   -0x1.ffffcp-1, INEXACT)
T(RZ, -0x1.8d376b23b2ff2p+875,    -0x1.2fdf8854eb2ap-1,   0x1.ffffc8p-1, INEXACT)
T(RU, -0x1.8d376b23b2ff2p+875,    -0x1.2fdf8854eb2ap-1,   0x1.ffffc8p-1, INEXACT)
T(RD, -0x1.8d376b23b2ff2p+875,   -0x1.2fdf8854eb2a1p-1, -0x1.bb3274p-20, INEXACT)
T(RZ, -0x1.3c083445f43c2p+383,   -0x1.a2c3a9c4ede89p-1,   0x1.ffffdep-1, INEXACT)
T(RU, -0x1.3c083445f43c2p+383,   -0x1.a2c3a9c4ede89p-1,   0x1.ffffdep-1, INEXACT)
T(RD, -0x1.3c083445f43c2p+383,   -0x1.a2c3a9c4ede8ap-1,   -0x1.17bap-20, INEXACT)
T(RZ, -0x1.362fa9aa597e6p+555,    0x1.58618b170f90cp-2, -0x1.1aff84p-21, INEXACT)
T(RD, -0x1.362fa9aa597e6p+555,    0x1.58618b170f90cp-2, -0x1.1aff84p-21, INEXACT)
T(RU, -0x1.362fa9aa597e6p+555,    0x1.58618b170f90dp-2,   0x1.ffffeep-1, INEXACT)
T(RZ,  0x1.c6cadb5811939p+139,   -0x1.f8befd481531fp-1,  0x1.16eabcp-21, INEXACT)
T(RU,  0x1.c6cadb5811939p+139,   -0x1.f8befd481531fp-1,  0x1.16eabcp-21, INEXACT)
T(RD,  0x1.c6cadb5811939p+139,    -0x1.f8befd481532p-1,  -0x1.ffffeep-1, INEXACT)
T(RZ, -0x1.8fd1d19522b8fp+326,   -0x1.c493f3d8360bcp-2,  0x1.20937ep-21, INEXACT)
T(RU, -0x1.8fd1d19522b8fp+326,   -0x1.c493f3d8360bcp-2,  0x1.20937ep-21, INEXACT)
T(RD, -0x1.8fd1d19522b8fp+326,   -0x1.c493f3d8360bdp-2,  -0x1.ffffeep-1, INEXACT)
T(RN,  -0x1.c8178887106dcp+49,   -0x1.b3144551c1161p-1,  -0x1.ffffcep-2, INEXACT)
T(RN,  0x1.76ef864123fbbp+779,    0x1.2437d904c564ap-1,  -0x1.ffffacp-2, INEXACT)
T(RN, -0x1.b02f04875d125p+335,   -0x1.8bd0aba93469bp-2,  -0x1.fffff8p-2, INEXACT)
T(RN, -0x1.7e8de5e2dab3dp+647,   -0x1.f1d46956ef583p-1,  -0x1.ffffdcp-2, INEXACT)
T(RZ, -0x1.18c3e7f3816c2p+704,   -0x1.9c741b1b42b37p-2,  0x1.055c18p-20, INEXACT)
T(RU, -0x1.18c3e7f3816c2p+704,   -0x1.9c741b1b42b37p-2,  0x1.055c18p-20, INEXACT)
T(RD, -0x1.18c3e7f3816c2p+704,   -0x1.9c741b1b42b38p-2,   -0x1.ffffep-1, INEXACT)
T(RZ, -0x1.5f253e8f3284ep+456,   -0x1.e05646fe02b03p-1,  0x1.889534p-20, INEXACT)
T(RU, -0x1.5f253e8f3284ep+456,   -0x1.e05646fe02b03p-1,  0x1.889534p-20, INEXACT)
T(RD, -0x1.5f253e8f3284ep+456,   -0x1.e05646fe02b04p-1,  -0x1.ffffcep-1, INEXACT)
T(RN,  0x1.c07965a13a416p+551,   -0x1.ff940ef712b78p-1,  -0x1.ffffc8p-2, INEXACT)
T(RZ, -0x1.44c6f9c2a4b66p+881,    0x1.b4079148131cbp-1,  -0x1.ffffcep-1, INEXACT)
T(RD, -0x1.44c6f9c2a4b66p+881,    0x1.b4079148131cbp-1,  -0x1.ffffcep-1, INEXACT)
T(RU, -0x1.44c6f9c2a4b66p+881,    0x1.b4079148131ccp-1,  0x1.883454p-20, INEXACT)
T(RN, -0x1.2066aa147b342p+232,   -0x1.6a30e2b763b89p-2,  -0x1.ffffbep-2, INEXACT)
T(RZ, -0x1.d7de5490e7bb7p+742,    0x1.8fd34c0250b9fp-1,  -0x1.ffffc2p-1, INEXACT)
T(RD, -0x1.d7de5490e7bb7p+742,    0x1.8fd34c0250b9fp-1,  -0x1.ffffc2p-1, INEXACT)
T(RU, -0x1.d7de5490e7bb7p+742,     0x1.8fd34c0250bap-1,  0x1.f7bdb4p-20, INEXACT)
T(RZ,  0x1.0adec2398d678p+405,   -0x1.ab2065666158fp-1,  0x1.4137ecp-20, INEXACT)
T(RU,  0x1.0adec2398d678p+405,   -0x1.ab2065666158fp-1,  0x1.4137ecp-20, INEXACT)
T(RD,  0x1.0adec2398d678p+405,    -0x1.ab2065666159p-1,  -0x1.ffffd8p-1, INEXACT)
T(RZ, -0x1.6bf588e01a976p+398,   -0x1.9076b154188cep-1,  0x1.b6eda2p-21, INEXACT)
T(RU, -0x1.6bf588e01a976p+398,   -0x1.9076b154188cep-1,  0x1.b6eda2p-21, INEXACT)
T(RD, -0x1.6bf588e01a976p+398,   -0x1.9076b154188cfp-1,  -0x1.ffffe4p-1, INEXACT)
T(RN, -0x1.04c5bdf662754p+276,    0x1.962154a6e1747p-2,   -0x1.ffff8p-2, INEXACT)
T(RZ,  0x1.8ba06fbed3703p+856,   -0x1.e34ced69bbf3bp-1,   0x1.ffffc4p-1, INEXACT)
T(RU,  0x1.8ba06fbed3703p+856,   -0x1.e34ced69bbf3bp-1,   0x1.ffffc4p-1, INEXACT)
T(RD,  0x1.8ba06fbed3703p+856,   -0x1.e34ced69bbf3cp-1, -0x1.e4e90ep-20, INEXACT)
T(RN,  0x1.bc2a58a6a70fbp+891,    0x1.b52f3b12eca2ep-1,  -0x1.ffffd6p-2, INEXACT)
T(RZ,  0x1.64ac2ebfdac21p+253,   -0x1.fe6ec2d5886fbp-1,  0x1.26ac68p-20, INEXACT)
T(RU,  0x1.64ac2ebfdac21p+253,   -0x1.fe6ec2d5886fbp-1,  0x1.26ac68p-20, INEXACT)
T(RD,  0x1.64ac2ebfdac21p+253,   -0x1.fe6ec2d5886fcp-1,  -0x1.ffffdcp-1, INEXACT)
T(RZ,  0x1.ff37895732fe8p+826,    0x1.cc0ccaa40f162p-1, -0x1.bdb09ep-22, INEXACT)
T(RD,  0x1.ff37895732fe8p+826,    0x1.cc0ccaa40f162p-1, -0x1.bdb09ep-22, INEXACT)
T(RU,  0x1.ff37895732fe8p+826,    0x1.cc0ccaa40f163p-1,   0x1.fffff2p-1, INEXACT)
T(RN, -0x1.d3fb4a4b16d4dp+343,   -0x1.f7e71c0d047ccp-1,  -0x1.ffff9ap-2, INEXACT)
T(RN, -0x1.e5f942f539171p+707,   -0x1.c6bd0ac05db24p-1,  -0x1.ffffa8p-2, INEXACT)
T(RZ, -0x1.d991422700871p+534,    0x1.7ed81ad050b71p-2,         -0x1p+0, INEXACT)
T(RD, -0x1.d991422700871p+534,    0x1.7ed81ad050b71p-2,         -0x1p+0, INEXACT)
T(RU, -0x1.d991422700871p+534,    0x1.7ed81ad050b72p-2,  0x1.6de202p-27, INEXACT)
T(RN,  0x1.2eb933d486a69p+958,   -0x1.23701267ebfd9p-1,   -0x1.ffffdp-2, INEXACT)
T(RN,   0x1.05bc23ef55992p+45,   -0x1.a9cc37777cb5bp-1,  -0x1.fffff2p-2, INEXACT)
T(RN,  0x1.8717657db5cc2p+443,   -0x1.94bde58279dffp-1,   -0x1.ffffbp-2, INEXACT)
T(RN, -0x1.6af1e3a94f8a2p+433,   -0x1.0d9af1d537783p-1,  -0x1.ffffc4p-2, INEXACT)
T(RZ, -0x1.d7b26119e4009p+968,   -0x1.9c355fed7c98dp-5,   0x1.fffff8p-1, INEXACT)
T(RU, -0x1.d7b26119e4009p+968,   -0x1.9c355fed7c98dp-5,   0x1.fffff8p-1, INEXACT)
T(RD, -0x1.d7b26119e4009p+968,   -0x1.9c355fed7c98ep-5, -0x1.f4c18ap-23, INEXACT)
T(RZ,  0x1.cc9b323a1d617p+711,   -0x1.197f396e3a1fep-3,   0x1.fffffep-1, INEXACT)
T(RU,  0x1.cc9b323a1d617p+711,   -0x1.197f396e3a1fep-3,   0x1.fffffep-1, INEXACT)
T(RD,  0x1.cc9b323a1d617p+711,   -0x1.197f396e3a1ffp-3, -0x1.d60d74p-25, INEXACT)
T(RN,  0x1.5becbd2db44eep+571,    0x1.8001c41726ae9p-1,  -0x1.fffff4p-2, INEXACT)
T(RZ,  0x1.fcf4a9be664cdp+164,    -0x1.f1c9f48b20bfp-1,  0x1.cee08cp-23, INEXACT)
T(RU,  0x1.fcf4a9be664cdp+164,    -0x1.f1c9f48b20bfp-1,  0x1.cee08cp-23, INEXACT)
T(RD,  0x1.fcf4a9be664cdp+164,   -0x1.f1c9f48b20bf1p-1,  -0x1.fffff8p-1, INEXACT)
T(RN,  0x1.6943ad8787d7bp+900,   -0x1.ff43e47d61573p-1,  -0x1.fffff8p-2, INEXACT)
T(RN,   0x1.a79b66743a83dp+32,   -0x1.d947c1efd85c1p-1,  -0x1.fffffap-2, INEXACT)
T(RZ, -0x1.9d212f5137efdp+943,   -0x1.8404820869937p-1,  0x1.30520cp-32, INEXACT)
T(RU, -0x1.9d212f5137efdp+943,   -0x1.8404820869937p-1,  0x1.30520cp-32, INEXACT)
T(RD, -0x1.9d212f5137efdp+943,   -0x1.8404820869938p-1,         -0x1p+0, INEXACT)
T(RZ,   0x1.2b5200ed2676p+366,    0x1.b0571ecfd9c35p-2,  -0x1.b6255p-23, INEXACT)
T(RD,   0x1.2b5200ed2676p+366,    0x1.b0571ecfd9c35p-2,  -0x1.b6255p-23, INEXACT)
T(RU,   0x1.2b5200ed2676p+366,    0x1.b0571ecfd9c36p-2,   0x1.fffffap-1, INEXACT)
T(RN,   0x1.4790085aa1d6cp+60,    0x1.09752f3f61407p-1,  -0x1.fffffcp-2, INEXACT)
T(RZ,  0x1.816dc5bc1b76bp+596,    0x1.f7f3d502e7c93p-1, -0x1.1ac794p-23, INEXACT)
T(RD,  0x1.816dc5bc1b76bp+596,    0x1.f7f3d502e7c93p-1, -0x1.1ac794p-23, INEXACT)
T(RU,  0x1.816dc5bc1b76bp+596,    0x1.f7f3d502e7c94p-1,   0x1.fffffcp-1, INEXACT)
T(RZ,  0x1.77a5e8c69b79fp+359,    -0x1.f4e64f602f85p-1,   0x1.fffffcp-1, INEXACT)
T(RU,  0x1.77a5e8c69b79fp+359,    -0x1.f4e64f602f85p-1,   0x1.fffffcp-1, INEXACT)
T(RD,  0x1.77a5e8c69b79fp+359,   -0x1.f4e64f602f851p-1, -0x1.32663ep-23, INEXACT)
T(RZ,   0x1.9212ced91caa4p+91,   -0x1.856cdabd4b935p-4,  0x1.c09b8cp-23, INEXACT)
T(RU,   0x1.9212ced91caa4p+91,   -0x1.856cdabd4b935p-4,  0x1.c09b8cp-23, INEXACT)
T(RD,   0x1.9212ced91caa4p+91,   -0x1.856cdabd4b936p-4,  -0x1.fffff8p-1, INEXACT)
T(RZ, -0x1.fec2c6b48066bp+661,    0x1.6f2db3eabf4e4p-2,  -0x1.fffff8p-1, INEXACT)
T(RD, -0x1.fec2c6b48066bp+661,    0x1.6f2db3eabf4e4p-2,  -0x1.fffff8p-1, INEXACT)
T(RU, -0x1.fec2c6b48066bp+661,    0x1.6f2db3eabf4e5p-2,  0x1.c011e6p-23, INEXACT)
T(RN,  0x1.38bef457317fep+407,   -0x1.00ca933b74a33p-1,   -0x1.fffffp-2, INEXACT)
T(RN,  0x1.80488dc041105p+556,    0x1.d3ed293a8c027p-1,         -0x1p-1, INEXACT)
T(RZ, -0x1.debc20b3bcadfp+894,    0x1.a4d76aae36433p-3, -0x1.11f64cp-24, INEXACT)
T(RD, -0x1.debc20b3bcadfp+894,    0x1.a4d76aae36433p-3, -0x1.11f64cp-24, INEXACT)
T(RU, -0x1.debc20b3bcadfp+894,    0x1.a4d76aae36434p-3,   0x1.fffffep-1, INEXACT)
T(RZ,  0x1.8902d30e09c84p+399,   -0x1.15b634676a4eep-2,  0x1.85785ap-23, INEXACT)
T(RU,  0x1.8902d30e09c84p+399,   -0x1.15b634676a4eep-2,  0x1.85785ap-23, INEXACT)
T(RD,  0x1.8902d30e09c84p+399,   -0x1.15b634676a4efp-2,  -0x1.fffffap-1, INEXACT)
T(RZ,  0x1.ef46e4da73db6p+446,   -0x1.56642113e7106p-3,  0x1.261d32p-24, INEXACT)
T(RU,  0x1.ef46e4da73db6p+446,   -0x1.56642113e7106p-3,  0x1.261d32p-24, INEXACT)
T(RD,  0x1.ef46e4da73db6p+446,   -0x1.56642113e7107p-3,  -0x1.fffffep-1, INEXACT)
T(RZ, -0x1.c8a0059fd3e33p+705,    0x1.ed96780113ef3p-4,         -0x1p+0, INEXACT)
T(RD, -0x1.c8a0059fd3e33p+705,    0x1.ed96780113ef3p-4,         -0x1p+0, INEXACT)
T(RU, -0x1.c8a0059fd3e33p+705,    0x1.ed96780113ef4p-4,  0x1.09ec98p-26, INEXACT)
T(RZ, -0x1.6c6c1ad15d0dfp+115,   -0x1.db19d6757e9ebp-1,  0x1.417e0ap-23, INEXACT)
T(RU, -0x1.6c6c1ad15d0dfp+115,   -0x1.db19d6757e9ebp-1,  0x1.417e0ap-23, INEXACT)
T(RD, -0x1.6c6c1ad15d0dfp+115,   -0x1.db19d6757e9ecp-1,  -0x1.fffffap-1, INEXACT)
T(RZ,   0x1.bc02c213cb385p+42,    0x1.242d8e6677163p-1, -0x1.12b2d4p-24, INEXACT)
T(RD,   0x1.bc02c213cb385p+42,    0x1.242d8e6677163p-1, -0x1.12b2d4p-24, INEXACT)
T(RU,   0x1.bc02c213cb385p+42,    0x1.242d8e6677164p-1,   0x1.fffffep-1, INEXACT)
T(RN,    0x1.fd227d71b472p+11,    0x1.ffff6f37e956fp-1,  -0x1.fffff2p-2, INEXACT)
T(RZ,  0x1.b549ba1268e56p+580,    0x1.594319c6b5c22p-3, -0x1.0f9fa2p-23, INEXACT)
T(RD,  0x1.b549ba1268e56p+580,    0x1.594319c6b5c22p-3, -0x1.0f9fa2p-23, INEXACT)
T(RU,  0x1.b549ba1268e56p+580,    0x1.594319c6b5c23p-3,   0x1.fffffcp-1, INEXACT)
T(RZ,  0x1.3ea676b9150d7p+993,    0x1.8234168a0e13ap-5,  -0x1.fffffcp-1, INEXACT)
T(RD,  0x1.3ea676b9150d7p+993,    0x1.8234168a0e13ap-5,  -0x1.fffffcp-1, INEXACT)
T(RU,  0x1.3ea676b9150d7p+993,    0x1.8234168a0e13bp-5,    0x1.14c7p-23, INEXACT)
T(RZ, -0x1.5a8b1e16a51d3p+597,    0x1.f4609e7769d8cp-1, -0x1.b10406p-23, INEXACT)
T(RD, -0x1.5a8b1e16a51d3p+597,    0x1.f4609e7769d8cp-1, -0x1.b10406p-23, INEXACT)
T(RU, -0x1.5a8b1e16a51d3p+597,    0x1.f4609e7769d8dp-1,   0x1.fffffap-1, INEXACT)
T(RZ,  0x1.96eb5a0a7363bp+949,    0x1.cdd9c97b1414dp-1,  -0x1.7b852p-23, INEXACT)
T(RD,  0x1.96eb5a0a7363bp+949,    0x1.cdd9c97b1414dp-1,  -0x1.7b852p-23, INEXACT)
T(RU,  0x1.96eb5a0a7363bp+949,    0x1.cdd9c97b1414ep-1,   0x1.fffffap-1, INEXACT)
T(RN,  0x1.89c7ef8dace1fp+927,    0x1.fdf01077b9e8ap-1,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.358c1bb71c1c6p+398,    0x1.02aaac1095c71p-1,  -0x1.fffff8p-2, INEXACT)
T(RZ,  0x1.a547ddf045e53p+617,    0x1.628e5b87db40ap-2,  -0x1.fffffap-1, INEXACT)
T(RD,  0x1.a547ddf045e53p+617,    0x1.628e5b87db40ap-2,  -0x1.fffffap-1, INEXACT)
T(RU,  0x1.a547ddf045e53p+617,    0x1.628e5b87db40bp-2,   0x1.7949cp-23, INEXACT)
T(RN,  0x1.3379f7540b53bp+206,    0x1.0a3403a625047p-1,  -0x1.fffff4p-2, INEXACT)
T(RN,  0x1.74c9acde46ab1p+862,   -0x1.63892f23445e4p-1,   -0x1.fffffp-2, INEXACT)
T(RN, -0x1.69a95d565e2d8p+906,    0x1.7cfb0060231b1p-3,  -0x1.fffff4p-2, INEXACT)
T(RN, -0x1.654dd0db38eaap+613,    0x1.4e7897eb2331ap-1,         -0x1p-1, INEXACT)
T(RN, -0x1.aff691f8d397dp+282,   -0x1.3f12a44f63784p-1,  -0x1.fffffep-2, INEXACT)
T(RN,  -0x1.09ad5f266a63dp+60,    0x1.a6365650d9b35p-1,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.8d536db7864ep+898,    0x1.48bcecf48fc4ep-1,  -0x1.fffff8p-2, INEXACT)
T(RN,  0x1.7f56a5d6d8f6bp+514,   -0x1.6a1c28a44d729p-1,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.c0500580f735bp+355,   -0x1.f7589003122c4p-1,  -0x1.fffff2p-2, INEXACT)
T(RN, -0x1.3b96d47f2320ap+679,    0x1.2790a5ecadee1p-2,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.703cd18bd101cp+874,   -0x1.13ebdb7b8f0c9p-7,  -0x1.fffff2p-2, INEXACT)
T(RN,  0x1.1c6a83ca4d108p+858,    0x1.e5a2a84702b7fp-2,  -0x1.fffffep-2, INEXACT)
T(RZ,   0x1.17f9e1396548p+953,   -0x1.b48aae421e92ap-1,  0x1.0c4c2ep-26, INEXACT)
T(RU,   0x1.17f9e1396548p+953,   -0x1.b48aae421e92ap-1,  0x1.0c4c2ep-26, INEXACT)
T(RD,   0x1.17f9e1396548p+953,   -0x1.b48aae421e92bp-1,         -0x1p+0, INEXACT)
T(RZ,  0x1.5d5c6f73c4016p+455,   -0x1.f482f32241d23p-1,          0x1p+0, INEXACT)
T(RU,  0x1.5d5c6f73c4016p+455,   -0x1.f482f32241d23p-1,          0x1p+0, INEXACT)
T(RD,  0x1.5d5c6f73c4016p+455,   -0x1.f482f32241d24p-1, -0x1.5ebc3ep-26, INEXACT)
T(RN,  0x1.2f1e0142448dfp+306,   -0x1.d439fdea2ed74p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.ec071b1991aaap+592,   -0x1.f6e23f16e38bap-1,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.477c81ceead25p+281,   -0x1.ee32e087f6aa9p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.18da378fc46c6p+661,    0x1.375a1271e969dp-3,         -0x1p-1, INEXACT)
T(RZ,  0x1.dc1679b09ec0ep+216,    0x1.bb2847634e026p-1,         -0x1p+0, INEXACT)
T(RD,  0x1.dc1679b09ec0ep+216,    0x1.bb2847634e026p-1,         -0x1p+0, INEXACT)
T(RU,  0x1.dc1679b09ec0ep+216,    0x1.bb2847634e027p-1,  0x1.d99098p-26, INEXACT)
T(RZ,   0x1.ab4b7fc8b0aaap+68,   -0x1.afdf55c4643bfp-1,  0x1.a25af4p-26, INEXACT)
T(RU,   0x1.ab4b7fc8b0aaap+68,   -0x1.afdf55c4643bfp-1,  0x1.a25af4p-26, INEXACT)
T(RD,   0x1.ab4b7fc8b0aaap+68,    -0x1.afdf55c4643cp-1,         -0x1p+0, INEXACT)
T(RZ, -0x1.5036c65b7e901p+175,    0x1.7bdbdb80db6f2p-1,  -0x1.7cb61p-26, INEXACT)
T(RD, -0x1.5036c65b7e901p+175,    0x1.7bdbdb80db6f2p-1,  -0x1.7cb61p-26, INEXACT)
T(RU, -0x1.5036c65b7e901p+175,    0x1.7bdbdb80db6f3p-1,          0x1p+0, INEXACT)
T(RZ, -0x1.1a7137bc76082p+208,    0x1.e430eaab2557ap-1,         -0x1p+0, INEXACT)
T(RD, -0x1.1a7137bc76082p+208,    0x1.e430eaab2557ap-1,         -0x1p+0, INEXACT)
T(RU, -0x1.1a7137bc76082p+208,    0x1.e430eaab2557bp-1,  0x1.cb0b18p-32, INEXACT)
T(RN, -0x1.3d50d1886247cp+969,    0x1.5c708dc93658dp-3,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.5180c0fce7bc7p+61,     -0x1.d3041fc3b01p-3,         -0x1p-1, INEXACT)
T(RN,  0x1.d93f5715bbc8bp+419,   -0x1.117f273281064p-1,         -0x1p-1, INEXACT)
T(RZ, -0x1.5c0c2b229663bp+723,   -0x1.8c4ad474af731p-3,  0x1.3d0f8ap-26, INEXACT)
T(RU, -0x1.5c0c2b229663bp+723,   -0x1.8c4ad474af731p-3,  0x1.3d0f8ap-26, INEXACT)
T(RD, -0x1.5c0c2b229663bp+723,   -0x1.8c4ad474af732p-3,         -0x1p+0, INEXACT)
T(RN, -0x1.6b438a3af2725p+459,    0x1.6f65f7e9b3bedp-2,  -0x1.fffffep-2, INEXACT)
T(RZ,  -0x1.c75e801ea6f4p+607,    0x1.98a244e0dcb94p-1,         -0x1p+0, INEXACT)
T(RD,  -0x1.c75e801ea6f4p+607,    0x1.98a244e0dcb94p-1,         -0x1p+0, INEXACT)
T(RU,  -0x1.c75e801ea6f4p+607,    0x1.98a244e0dcb95p-1,  0x1.24b97ep-27, INEXACT)
T(RZ, -0x1.efd3ab5f3cf39p+272,   -0x1.ffcd1b92019aep-1,          0x1p+0, INEXACT)
T(RU, -0x1.efd3ab5f3cf39p+272,   -0x1.ffcd1b92019aep-1,          0x1p+0, INEXACT)
T(RD, -0x1.efd3ab5f3cf39p+272,   -0x1.ffcd1b92019afp-1, -0x1.c10d94p-27, INEXACT)
T(RZ,  0x1.5f28113a0c0c6p+844,     0x1.795dca910ca9p-1,  -0x1.2737cp-26, INEXACT)
T(RD,  0x1.5f28113a0c0c6p+844,     0x1.795dca910ca9p-1,  -0x1.2737cp-26, INEXACT)
T(RU,  0x1.5f28113a0c0c6p+844,    0x1.795dca910ca91p-1,          0x1p+0, INEXACT)
T(RZ,  0x1.b4ec977861861p+622,   -0x1.2fbf85a92dfe2p-3,          0x1p+0, INEXACT)
T(RU,  0x1.b4ec977861861p+622,   -0x1.2fbf85a92dfe2p-3,          0x1p+0, INEXACT)
T(RD,  0x1.b4ec977861861p+622,   -0x1.2fbf85a92dfe3p-3, -0x1.319a7ap-31, INEXACT)
T(RN,  0x1.7f7d867b4c861p+638,    0x1.8785638533844p-4,  -0x1.fffffep-2, INEXACT)
T(RZ, -0x1.1278edba51ff5p+798,    0x1.d82e7f89edfd2p-1,         -0x1p+0, INEXACT)
T(RD, -0x1.1278edba51ff5p+798,    0x1.d82e7f89edfd2p-1,         -0x1p+0, INEXACT)
T(RU, -0x1.1278edba51ff5p+798,    0x1.d82e7f89edfd3p-1,  0x1.d7e43ep-26, INEXACT)
T(RZ,  0x1.f72a070ad5a3cp+616,   -0x1.cc17fff3cb7dfp-3,  0x1.25a29ap-26, INEXACT)
T(RU,  0x1.f72a070ad5a3cp+616,   -0x1.cc17fff3cb7dfp-3,  0x1.25a29ap-26, INEXACT)
T(RD,  0x1.f72a070ad5a3cp+616,    -0x1.cc17fff3cb7ep-3,         -0x1p+0, INEXACT)
T(RZ,  0x1.2f46a3b8b1183p+162,   -0x1.fb07c9107e97bp-1,          0x1p+0, INEXACT)
T(RU,  0x1.2f46a3b8b1183p+162,   -0x1.fb07c9107e97bp-1,          0x1p+0, INEXACT)
T(RD,  0x1.2f46a3b8b1183p+162,   -0x1.fb07c9107e97cp-1, -0x1.8de3c2p-27, INEXACT)
T(RZ,  0x1.94f9238bcbce9p+649,    0x1.11d10916b068bp-3, -0x1.1f3772p-26, INEXACT)
T(RD,  0x1.94f9238bcbce9p+649,    0x1.11d10916b068bp-3, -0x1.1f3772p-26, INEXACT)
T(RU,  0x1.94f9238bcbce9p+649,    0x1.11d10916b068cp-3,          0x1p+0, INEXACT)
T(RZ,   0x1.e3895b56f013dp+78,    0x1.f77f622f13117p-1,         -0x1p+0, INEXACT)
T(RD,   0x1.e3895b56f013dp+78,    0x1.f77f622f13117p-1,         -0x1p+0, INEXACT)
T(RU,   0x1.e3895b56f013dp+78,    0x1.f77f622f13118p-1,  0x1.1553b6p-26, INEXACT)
T(RN,  0x1.b565bebba482dp+876,   -0x1.b91514c9abdccp-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.10fc45baf591ep+117,    0x1.fa8e71c458eb5p-1, -0x1.4c0278p-27, INEXACT)
T(RD,  0x1.10fc45baf591ep+117,    0x1.fa8e71c458eb5p-1, -0x1.4c0278p-27, INEXACT)
T(RU,  0x1.10fc45baf591ep+117,    0x1.fa8e71c458eb6p-1,          0x1p+0, INEXACT)
T(RN,  0x1.a094cc6dab342p+924,    0x1.fdd2d24a0f5b6p-1,         -0x1p-1, INEXACT)
T(RZ, -0x1.e115c5a33030dp+564,   -0x1.a049af0e1a73cp-1,          0x1p+0, INEXACT)
T(RU, -0x1.e115c5a33030dp+564,   -0x1.a049af0e1a73cp-1,          0x1p+0, INEXACT)
T(RD, -0x1.e115c5a33030dp+564,   -0x1.a049af0e1a73dp-1, -0x1.848b48p-27, INEXACT)
T(RN,  0x1.71e85a55d24a5p+317,   -0x1.d6030cb7d6fc6p-2,  -0x1.fffffep-2, INEXACT)
T(RZ, -0x1.a4f98c9f1cc25p+317,     -0x1.10115e598eep-3,  0x1.bc7a0ap-26, INEXACT)
T(RU, -0x1.a4f98c9f1cc25p+317,     -0x1.10115e598eep-3,  0x1.bc7a0ap-26, INEXACT)
T(RD, -0x1.a4f98c9f1cc25p+317,   -0x1.10115e598ee01p-3,         -0x1p+0, INEXACT)
T(RZ, -0x1.7d8d66b30eca9p+960,   -0x1.9313ac24942e7p-2,          0x1p+0, INEXACT)
T(RU, -0x1.7d8d66b30eca9p+960,   -0x1.9313ac24942e7p-2,          0x1p+0, INEXACT)
T(RD, -0x1.7d8d66b30eca9p+960,   -0x1.9313ac24942e8p-2, -0x1.6a17fep-26, INEXACT)
T(RN, -0x1.3ec2e9bfd617dp+923,   -0x1.ee9e9590d5f7bp-1,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.93348c7914bcfp+835,    0x1.16d220ed14328p-1,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.9aaf57dd64754p+543,   -0x1.df29e31494c0ep-1,         -0x1p-1, INEXACT)
T(RN, -0x1.0aab43e8d9fdbp+638,    0x1.0bf4cda47d2cfp-1,         -0x1p-1, INEXACT)
T(RN, -0x1.f4de99e152545p+758,   -0x1.3881d2225229cp-1,         -0x1p-1, INEXACT)
T(RN,  0x1.cc9b288eb3ec2p+792,    0x1.7b380f09e6202p-1,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.d5ca2e0028c37p+173,    0x1.cefd40137a473p-1,         -0x1p-1, INEXACT)
T(RZ, -0x1.c6758b01c3b39p+246,   -0x1.98c1ab6efd401p-1,  0x1.514596p-29, INEXACT)
T(RU, -0x1.c6758b01c3b39p+246,   -0x1.98c1ab6efd401p-1,  0x1.514596p-29, INEXACT)
T(RD, -0x1.c6758b01c3b39p+246,   -0x1.98c1ab6efd402p-1,         -0x1p+0, INEXACT)
T(RN,  0x1.a4eb3e40e7994p+590,    0x1.ff78381c68c1dp-1,         -0x1p-1, INEXACT)
T(RN,  0x1.c24bae750e444p+689,    -0x1.6209fc1c2bffp-1,         -0x1p-1, INEXACT)
T(RN,  0x1.9323284e53428p+560,    0x1.26160034d774fp-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.190ee43ecd289p+509,    0x1.b6ec79801a3dcp-1,         -0x1p+0, INEXACT)
T(RD,  0x1.190ee43ecd289p+509,    0x1.b6ec79801a3dcp-1,         -0x1p+0, INEXACT)
T(RU,  0x1.190ee43ecd289p+509,    0x1.b6ec79801a3ddp-1,  0x1.e1c1d4p-31, INEXACT)
T(RZ,  -0x1.4dd8bc38a912ep+41,    0x1.dfb9969ef5d2bp-1,  -0x1.6ae8ep-30, INEXACT)
T(RD,  -0x1.4dd8bc38a912ep+41,    0x1.dfb9969ef5d2bp-1,  -0x1.6ae8ep-30, INEXACT)
T(RU,  -0x1.4dd8bc38a912ep+41,    0x1.dfb9969ef5d2cp-1,          0x1p+0, INEXACT)
T(RZ,  -0x1.39f821756c164p+89,   -0x1.fe4c1a2733a46p-1,  0x1.470eaep-29, INEXACT)
T(RU,  -0x1.39f821756c164p+89,   -0x1.fe4c1a2733a46p-1,  0x1.470eaep-29, INEXACT)
T(RD,  -0x1.39f821756c164p+89,   -0x1.fe4c1a2733a47p-1,         -0x1p+0, INEXACT)
T(RZ,  0x1.c9bec0d180b36p+843,    0x1.94c730bfbb5bcp-1,         -0x1p+0, INEXACT)
T(RD,  0x1.c9bec0d180b36p+843,    0x1.94c730bfbb5bcp-1,         -0x1p+0, INEXACT)
T(RU,  0x1.c9bec0d180b36p+843,    0x1.94c730bfbb5bdp-1,  0x1.de74e8p-30, INEXACT)
T(RZ, -0x1.d28a62575c9b9p+119,    0x1.3e730b0bc08f6p-2, -0x1.964b9ep-29, INEXACT)
T(RD, -0x1.d28a62575c9b9p+119,    0x1.3e730b0bc08f6p-2, -0x1.964b9ep-29, INEXACT)
T(RU, -0x1.d28a62575c9b9p+119,    0x1.3e730b0bc08f7p-2,          0x1p+0, INEXACT)
T(RZ,  -0x1.bcb6a2f257fd4p+15,    0x1.6fa15b7df8108p-1,         -0x1p+0, INEXACT)
T(RD,  -0x1.bcb6a2f257fd4p+15,    0x1.6fa15b7df8108p-1,         -0x1p+0, INEXACT)
T(RU,  -0x1.bcb6a2f257fd4p+15,    0x1.6fa15b7df8109p-1,  0x1.e9f6b4p-32, INEXACT)
T(RN,  0x1.f440e50c16776p+124,   -0x1.7be9cd24f9475p-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.9681e5dee2cb9p+137,   -0x1.ad694b0bab3dfp-1,  0x1.e647d4p-30, INEXACT)
T(RU,  0x1.9681e5dee2cb9p+137,   -0x1.ad694b0bab3dfp-1,  0x1.e647d4p-30, INEXACT)
T(RD,  0x1.9681e5dee2cb9p+137,    -0x1.ad694b0bab3ep-1,         -0x1p+0, INEXACT)
T(RZ, -0x1.c58e8e8a8d3c2p+811,   -0x1.dd3d94658909cp-2,          0x1p+0, INEXACT)
T(RU, -0x1.c58e8e8a8d3c2p+811,   -0x1.dd3d94658909cp-2,          0x1p+0, INEXACT)
T(RD, -0x1.c58e8e8a8d3c2p+811,   -0x1.dd3d94658909dp-2, -0x1.5b6448p-29, INEXACT)
T(RN,  0x1.8d5c8070c6801p+818,   -0x1.72b611619e0f6p-1,         -0x1p-1, INEXACT)
T(RZ, -0x1.c7088d46b3bb1p+638,   -0x1.ce425a8ed0273p-1,          0x1p+0, INEXACT)
T(RU, -0x1.c7088d46b3bb1p+638,   -0x1.ce425a8ed0273p-1,          0x1p+0, INEXACT)
T(RD, -0x1.c7088d46b3bb1p+638,   -0x1.ce425a8ed0274p-1, -0x1.0bde24p-30, INEXACT)
T(RZ, -0x1.afb999288bc37p+876,    0x1.f99f777e7cc35p-2,         -0x1p+0, INEXACT)
T(RD, -0x1.afb999288bc37p+876,    0x1.f99f777e7cc35p-2,         -0x1p+0, INEXACT)
T(RU, -0x1.afb999288bc37p+876,    0x1.f99f777e7cc36p-2,   0x1.59ca5p-31, INEXACT)
T(RZ,  0x1.7c84dd29bd995p+948,    0x1.f3f18a9faabd4p-1, -0x1.9aafbep-31, INEXACT)
T(RD,  0x1.7c84dd29bd995p+948,    0x1.f3f18a9faabd4p-1, -0x1.9aafbep-31, INEXACT)
T(RU,  0x1.7c84dd29bd995p+948,    0x1.f3f18a9faabd5p-1,          0x1p+0, INEXACT)
T(RN,-0x1.7e03b70bf09adp+1018,   -0x1.51d4a321e26d8p-2,         -0x1p-1, INEXACT)
T(RN, -0x1.10f6785a7cf9dp+235,   -0x1.0ea448de9999fp-2,         -0x1p-1, INEXACT)
T(RZ,  0x1.a05a2ce98b13ap+979,    0x1.b3e4c3bb208fep-1, -0x1.2fc3aap-29, INEXACT)
T(RD,  0x1.a05a2ce98b13ap+979,    0x1.b3e4c3bb208fep-1, -0x1.2fc3aap-29, INEXACT)
T(RU,  0x1.a05a2ce98b13ap+979,    0x1.b3e4c3bb208ffp-1,          0x1p+0, INEXACT)
T(RN, -0x1.c5bf473577738p+498,    0x1.ad0eb4583af72p-1,         -0x1p-1, INEXACT)
T(RZ, -0x1.15bcba559992dp+510,   -0x1.c9aa013d59914p-1,          0x1p+0, INEXACT)
T(RU, -0x1.15bcba559992dp+510,   -0x1.c9aa013d59914p-1,          0x1p+0, INEXACT)
T(RD, -0x1.15bcba559992dp+510,   -0x1.c9aa013d59915p-1, -0x1.982b46p-29, INEXACT)
T(RZ,  0x1.695981dc05748p+229,    0x1.aa370dd1b5daep-1,         -0x1p+0, INEXACT)
T(RD,  0x1.695981dc05748p+229,    0x1.aa370dd1b5daep-1,         -0x1p+0, INEXACT)
T(RU,  0x1.695981dc05748p+229,    0x1.aa370dd1b5dafp-1,  0x1.387c7ep-29, INEXACT)
T(RZ, -0x1.ae70d3975d611p+300,   -0x1.7b6cd7f129fbap-1,          0x1p+0, INEXACT)
T(RU, -0x1.ae70d3975d611p+300,   -0x1.7b6cd7f129fbap-1,          0x1p+0, INEXACT)
T(RD, -0x1.ae70d3975d611p+300,   -0x1.7b6cd7f129fbbp-1, -0x1.fa54ccp-31, INEXACT)
T(RZ,   0x1.15e90f976dca8p+68,    0x1.321640064091bp-1, -0x1.d7279ep-30, INEXACT)
T(RD,   0x1.15e90f976dca8p+68,    0x1.321640064091bp-1, -0x1.d7279ep-30, INEXACT)
T(RU,   0x1.15e90f976dca8p+68,    0x1.321640064091cp-1,          0x1p+0, INEXACT)
T(RN, -0x1.5e7cffde61637p+371,    0x1.710ae2447d934p-4,         -0x1p-1, INEXACT)
T(RN, -0x1.6cf9791469f64p+554,   -0x1.3cc07f0728968p-4,         -0x1p-1, INEXACT)
T(RZ, -0x1.84cc9f4a45ccbp+646,    0x1.ec7742bc5d953p-1,         -0x1p+0, INEXACT)
T(RD, -0x1.84cc9f4a45ccbp+646,    0x1.ec7742bc5d953p-1,         -0x1p+0, INEXACT)
T(RU, -0x1.84cc9f4a45ccbp+646,    0x1.ec7742bc5d954p-1,  0x1.6c54dcp-30, INEXACT)
T(RZ,  0x1.78f5cc780831cp+610,   -0x1.8e9c85f3c8cc4p-4,  0x1.1a86b6p-29, INEXACT)
T(RU,  0x1.78f5cc780831cp+610,   -0x1.8e9c85f3c8cc4p-4,  0x1.1a86b6p-29, INEXACT)
T(RD,  0x1.78f5cc780831cp+610,   -0x1.8e9c85f3c8cc5p-4,         -0x1p+0, INEXACT)
T(RZ, -0x1.092ab04256306p+493,   -0x1.15cbfd596ddf6p-1,  0x1.6ed4e4p-30, INEXACT)
T(RU, -0x1.092ab04256306p+493,   -0x1.15cbfd596ddf6p-1,  0x1.6ed4e4p-30, INEXACT)
T(RD, -0x1.092ab04256306p+493,   -0x1.15cbfd596ddf7p-1,         -0x1p+0, INEXACT)
T(RN,  -0x1.cf65ff85b408p+512,    0x1.e2c2264def5e4p-2,         -0x1p-1, INEXACT)
T(RN,   0x1.c443dd7bf5244p+85,   -0x1.3cdb7ea211eecp-1,         -0x1p-1, INEXACT)
T(RN,   0x1.d13a8714336f7p-12,   0x1.d13a86142018ep-12,   0x1.33001ep-9, INEXACT)
T(RN,   0x1.b410e67922c2ap-12,   0x1.b410e5a642b46p-12,   0x1.ae915ep-4, INEXACT)
T(RN,   0x1.c8226940cd2f9p-12,   0x1.c822684f73946p-12,   0x1.2aaeecp-3, INEXACT)
T(RN,   0x1.8b931d152ac5fp-12,   0x1.8b931c77bfc81p-12,  -0x1.0f0d6ap-5, INEXACT)
T(RN,   0x1.f95000afac272p-12,   0x1.f94fff678a499p-12,   0x1.62d5bcp-3, INEXACT)
T(RN,   0x1.c1662cc358c8bp-12,   0x1.c1662bdc87f2bp-12,   0x1.0a1328p-2, INEXACT)
T(RN,   0x1.48089ffd1c542p-12,    0x1.48089fa35795p-12,   0x1.255004p-2, INEXACT)
T(RN,   0x1.fdad1c59a9013p-12,   0x1.fdad1b08f40f2p-12,   0x1.e03504p-3, INEXACT)
T(RN,   0x1.4ac013baa1528p-12,   0x1.4ac0135e9ce3bp-12,   0x1.b0c02cp-4, INEXACT)
T(RN,   0x1.5f96b4f27e6b4p-12,   0x1.5f96b483f72bdp-12,   0x1.290588p-5, INEXACT)
T(RN,   0x1.b28a32c707848p-11,   0x1.b28a2f845aa0dp-11,   0x1.28900cp-2, INEXACT)
T(RN,   0x1.91401343407ccp-11,   0x1.914010b216116p-11,   -0x1.71418p-2, INEXACT)
T(RN,    0x1.a802ada3dd3fp-11,   0x1.a802aa9c67e44p-11,  -0x1.859942p-4, INEXACT)
T(RN,   0x1.2bbb1fc5d97b8p-11,   0x1.2bbb1eb3edfccp-11,    0x1.1654ap-2, INEXACT)
T(RN,   0x1.881123a22256fp-11,   0x1.8811213d109fap-11,   0x1.9cf1aep-3, INEXACT)
T(RN,   0x1.a5196bc3b26a8p-11,   0x1.a51968cc19faep-11,   0x1.0ac204p-2, INEXACT)
T(RN,   0x1.03768347c17c8p-11,   0x1.0376829611b3ep-11,   0x1.bd7504p-2, INEXACT)
T(RN,   0x1.6399d1e1328e4p-11,   0x1.6399d017c67b6p-11,     0x1.e098p-2, INEXACT)
T(RN,   0x1.267f1c55443b4p-11,    0x1.267f1b5172cfp-11,  -0x1.0c111ep-2, INEXACT)
T(RN,   0x1.d1f49148d3419p-11,   0x1.d1f48d43b72b4p-11,  -0x1.dd9eecp-3, INEXACT)
T(RN,   0x1.6c1fe820a020dp-10,   0x1.6c1fe0742f477p-10,    0x1.cc947p-6, INEXACT)
T(RN,   0x1.da22af4c38fa8p-10,   0x1.da229e5b27dd6p-10,   0x1.9db062p-3, INEXACT)
T(RN,   0x1.8f6244c3668cfp-10,   0x1.8f623aa33fe8cp-10,  -0x1.796c6ap-2, INEXACT)
T(RN,   0x1.198894d6fd8b8p-10,   0x1.1988914b01267p-10,    0x1.826e8p-3, INEXACT)
T(RN,   0x1.9f675253501b6p-10,   0x1.9f6746ee8f93cp-10,   0x1.cce484p-3, INEXACT)
T(RN,   0x1.036ac60798d78p-10,   0x1.036ac3413a2b1p-10,  -0x1.f7a0c6p-3, INEXACT)
T(RN,   0x1.60c262e8daaa8p-10,   0x1.60c25beead99ap-10,  -0x1.934764p-3, INEXACT)
T(RN,   0x1.9094dc06242b6p-10,   0x1.9094d1ce99f0ep-10,   0x1.6180f4p-3, INEXACT)
T(RN,   0x1.bd5d0e3c19128p-10,   0x1.bd5d0031a58d1p-10,   0x1.a5d6f8p-8, INEXACT)
T(RN,   0x1.49b5b5e2238a4p-10,   0x1.49b5b02fb6841p-10,  -0x1.1f2e56p-3, INEXACT)
T(RN,    0x1.0d03f40f834d2p-9,    0x1.0d03e7aed192dp-9,  -0x1.ccf97ep-3, INEXACT)
T(RN,    0x1.a401a1e3f1f74p-9,    0x1.a40172c8cef26p-9,  -0x1.da1716p-6, INEXACT)
T(RN,    0x1.3f878755a25d3p-9,    0x1.3f877297cc25fp-9,   0x1.26c6d2p-4, INEXACT)
T(RN,    0x1.91b9c6f671308p-9,    0x1.91b99dbe60d55p-9,   0x1.3f11c4p-2, INEXACT)
T(RN,    0x1.df637f76e6a61p-9,    0x1.df63396b99ca3p-9,    -0x1.bb24p-2, INEXACT)
T(RN,    0x1.80a6df4f2e7a6p-9,    0x1.80a6bb202c496p-9,   0x1.4eff2ap-3, INEXACT)
T(RN,    0x1.be115015aa771p-9,    0x1.be1117a79079dp-9,  -0x1.1f04e4p-2, INEXACT)
T(RN,    0x1.86097046c9158p-9,    0x1.86094a8d4421cp-9,  -0x1.737c2ep-4, INEXACT)
T(RN,     0x1.57b3c7dca3ecp-9,    0x1.57b3ae0c3f67dp-9,   0x1.db3852p-2, INEXACT)
T(RN,    0x1.d8966ad49f0d9p-9,    0x1.d89627b9b848fp-9,   0x1.4602c4p-3, INEXACT)
T(RN,    0x1.eb05e3933328cp-8,    0x1.eb04b68047b12p-8,  -0x1.6ddef6p-2, INEXACT)
T(RN,     0x1.74843ebb13c8p-8,    0x1.7483bb4470af9p-8,  -0x1.69f434p-2, INEXACT)
T(RN,    0x1.e5bf8564e7d6cp-8,     0x1.e5be61eb5a56p-8,   0x1.9f52f4p-6, INEXACT)
T(RN,     0x1.1685da32e419p-8,    0x1.1685a3403b9bfp-8,  -0x1.336b72p-3, INEXACT)
T(RN,    0x1.ee8c943d459bap-8,     0x1.ee8b60a1ee92p-8,   0x1.5bcb28p-2, INEXACT)
T(RN,    0x1.fe5e8cb2e16e9p-8,    0x1.fe5d3a9e0de36p-8,   0x1.ab61dap-2, INEXACT)
T(RN,    0x1.ce00523528554p-8,    0x1.cdff576cd74cfp-8,  -0x1.a50db6p-2, INEXACT)
T(RN,     0x1.c85f40318637p-8,     0x1.c85e4e777157p-8,  -0x1.dc0a42p-2, INEXACT)
T(RN,    0x1.268a1cadb66e5p-8,     0x1.2689dbb217cep-8,   0x1.5db43ap-2, INEXACT)
T(RN,    0x1.a459efc637e7bp-8,    0x1.a45932e2cd77ap-8,   0x1.cfb9cep-4, INEXACT)
T(RN,    0x1.e5dfd2e01efc2p-7,     0x1.e5db4413b682p-7,    0x1.51c55p-2, INEXACT)
T(RN,    0x1.5f9e835ed2897p-7,    0x1.5f9cc92507ed8p-7,  -0x1.eb3506p-2, INEXACT)
T(RN,    0x1.b321d20031addp-7,    0x1.b31e8bea477f9p-7,  -0x1.ba20ecp-2, INEXACT)
T(RN,     0x1.754c629d580bp-7,    0x1.754a51721b6e7p-7,   0x1.52ce68p-4, INEXACT)
T(RN,    0x1.3bb34878925e3p-7,    0x1.3bb2086559188p-7,   0x1.487766p-2, INEXACT)
T(RN,    0x1.234c2f6073e19p-7,    0x1.234b33ef4da75p-7,  -0x1.eb2984p-3, INEXACT)
T(RN,    0x1.c45bc2eb0c15cp-7,    0x1.c458154defedbp-7,   0x1.e7e5f6p-5, INEXACT)
T(RN,    0x1.99e01097c5ba9p-7,    0x1.99dd54232ea1ap-7,  -0x1.6cdbe8p-2, INEXACT)
T(RN,    0x1.00922f2a3c158p-7,    0x1.0091835aae86fp-7,   0x1.4a2c98p-5, INEXACT)
T(RN,    0x1.7ef5f5f71f431p-7,    0x1.7ef3baa20f75fp-7,  -0x1.54b76cp-4, INEXACT)
T(RN,    0x1.b38b534d49bd2p-6,    0x1.b37e3183a52d6p-6,   0x1.489628p-3, INEXACT)
T(RN,    0x1.85237d2f4d5bap-6,    0x1.851a1f8388a1dp-6,   0x1.451a48p-6, INEXACT)
T(RN,    0x1.5c62bbcb72202p-6,    0x1.5c5c03462fcdbp-6,  -0x1.f65928p-3, INEXACT)
T(RN,    0x1.6029ae6bda693p-6,    0x1.6022bd54f953bp-6,   0x1.8800a2p-2, INEXACT)
T(RN,    0x1.656d740f4d121p-6,    0x1.65663212c391ep-6,  -0x1.964decp-3, INEXACT)
T(RN,    0x1.18ff150137b27p-6,    0x1.18fb8e3809911p-6,  -0x1.b35ef2p-3, INEXACT)
T(RN,    0x1.5ab6a3ad48cc7p-6,    0x1.5ab003d00826bp-6,  -0x1.78f3a4p-4, INEXACT)
T(RN,     0x1.91f31c608a26p-6,    0x1.91e8ca06612edp-6,   0x1.8e8db8p-6, INEXACT)
T(RN,     0x1.942296ff2543p-6,    0x1.9418194f56111p-6,   0x1.27b478p-2, INEXACT)
T(RN,    0x1.158ed015575e5p-6,    0x1.158b6a0912e35p-6,   -0x1.5b632p-2, INEXACT)
T(RN,     0x1.91100e8089f8p-5,    0x1.90e70bd90bd23p-5,   -0x1.8eaf3p-3, INEXACT)
T(RN,    0x1.56f363175fb85p-5,    0x1.56d9be86cf38cp-5,  -0x1.c3938cp-3, INEXACT)
T(RN,    0x1.7f58607bd4c6bp-5,    0x1.7f34908d1ca0ep-5,   0x1.4e69d4p-2, INEXACT)
T(RN,     0x1.f1e33aeedc0dp-5,    0x1.f194c65cb20bdp-5,    0x1.9b341p-7, INEXACT)
T(RN,    0x1.35debd7f04004p-5,    0x1.35cbd3240f05bp-5,   0x1.6a377ep-3, INEXACT)
T(RN,    0x1.4d8f7e1105e8dp-5,    0x1.4d77e611d8925p-5,   0x1.0f55c4p-3, INEXACT)
T(RN,    0x1.e6f721094cd52p-5,    0x1.e6adb95443aa9p-5,   0x1.a66aacp-2, INEXACT)
T(RN,    0x1.03d36ffe2351ep-5,    0x1.03c849337dfaap-5,    0x1.822fbp-5, INEXACT)
T(RN,     0x1.39600a11a1fap-5,    0x1.394c7988b8dcap-5,    -0x1.8bf2p-6, INEXACT)
T(RN,    0x1.7570518fc88cap-5,    0x1.754f362174423p-5,    0x1.28768p-2, INEXACT)
T(RN,    0x1.7334c694aa30fp-4,    0x1.72b2bf7b6c9d1p-4,   0x1.60051ep-5, INEXACT)
T(RN,    0x1.d9a0b40604c82p-4,    0x1.d892afddc043ap-4,  -0x1.108956p-3, INEXACT)
T(RN,    0x1.3857f8f35051bp-4,    0x1.380a804f83899p-4,    0x1.98a39p-2, INEXACT)
T(RN,    0x1.b9d8e353b2439p-4,    0x1.b8fda43e68e1ap-4,   0x1.fc361ap-3, INEXACT)
T(RN,    0x1.6576d5d5ef376p-4,    0x1.6502b78594d6bp-4,  -0x1.1a201ap-2, INEXACT)
T(RN,    0x1.8107c1f315188p-4,    0x1.8076a8d7254cep-4,   0x1.6295d4p-4, INEXACT)
T(RN,    0x1.97e97f87fee37p-4,    0x1.973cf9029a1aap-4,  -0x1.601908p-3, INEXACT)
T(RN,    0x1.183c0521eb455p-4,    0x1.180410e3527b2p-4,   -0x1.5e2acp-6, INEXACT)
T(RN,    0x1.523e24a938af1p-4,    0x1.51dbc36a768c9p-4,   0x1.e4d382p-3, INEXACT)
T(RN,    0x1.5ab4f3aa3ca2cp-4,     0x1.5a4b007ec9bep-4,   -0x1.93438p-3, INEXACT)
T(RN,    0x1.2328844d0920ap-3,    0x1.222db024adccdp-3,  -0x1.5c4e32p-2, INEXACT)
T(RN,    0x1.9e422bc1a0c8ap-3,    0x1.9b70797b3ab85p-3,  -0x1.da8c7ap-3, INEXACT)
T(RN,    0x1.d20e39f6a7c3cp-3,    0x1.ce0b1d9448bf5p-3,  -0x1.c4a406p-3, INEXACT)
T(RN,    0x1.00ffaeac7bf06p-3,    0x1.0053256fa8c39p-3,  -0x1.4ef346p-2, INEXACT)
T(RN,    0x1.94fe9eea05ef4p-3,    0x1.925c34a04fc79p-3,   0x1.a6e1dcp-2, INEXACT)
T(RN,    0x1.858f6ee300e67p-3,     0x1.833722845f87p-3,  -0x1.26d836p-5, INEXACT)
T(RN,    0x1.0c6671607b1eap-3,    0x1.0ba1ec8dc65f4p-3,   -0x1.a17afp-2, INEXACT)
T(RN,    0x1.3d51c8ad65de8p-3,    0x1.3c0d25acf3d04p-3,    0x1.df4eap-2, INEXACT)
T(RN,    0x1.74e57f04dea83p-3,    0x1.72d6e7a3f3383p-3,  -0x1.540ca8p-2, INEXACT)
T(RN,    0x1.d79beb03ed6fep-3,    0x1.d373b790386c9p-3,  -0x1.a0eab4p-2, INEXACT)
T(RN,    0x1.aa59df0273ab6p-2,    0x1.9e239b49ceedfp-2,  -0x1.887b3cp-2, INEXACT)
T(RN,    0x1.dcdb5e4be95e8p-2,    0x1.cbcec8ec2187fp-2,   -0x1.f43c6p-5, INEXACT)
T(RN,    0x1.4225528b512ebp-2,    0x1.3cdbb3c7744dcp-2,   -0x1.0219fp-4, INEXACT)
T(RN,    0x1.5ecd575ffd20bp-2,    0x1.57fb029d16161p-2,   0x1.a49b8ap-2, INEXACT)
T(RN,    0x1.0c2f48d5f407dp-2,    0x1.09211d446390ep-2,   0x1.edc268p-2, INEXACT)
T(RN,    0x1.176df5a024a97p-2,    0x1.13f97a7180319p-2,  -0x1.321c28p-5, INEXACT)
T(RN,    0x1.778ef1d5a9352p-2,    0x1.6f32070fa671fp-2,   0x1.c00e58p-3, INEXACT)
T(RN,    0x1.a1f9e37315316p-2,    0x1.967743e577e33p-2,   -0x1.943eep-2, INEXACT)
T(RN,    0x1.ef3ef767d6ff9p-2,     0x1.dc29e4d7ca97p-2,   0x1.4db3d6p-3, INEXACT)
T(RN,    0x1.bfef93ee5e804p-2,    0x1.b1c9502a73e05p-2,   0x1.6ef7e2p-2, INEXACT)
T(RN,    0x1.32a6e003ad473p-1,    0x1.20a4f5f0f0357p-1,  -0x1.58601cp-2, INEXACT)
T(RN,    0x1.fb952aa0bd80ap-1,    0x1.ac6e321c42d5cp-1,   0x1.24ecb2p-2, INEXACT)
T(RN,    0x1.d2b3d9a891752p-1,    0x1.94b4aa42b09e2p-1,  -0x1.915964p-2, INEXACT)
T(RN,    0x1.7c6ea538fd338p-1,    0x1.5a614ce7a1cd7p-1,   0x1.2c5a94p-4, INEXACT)
T(RN,    0x1.aa7d6135a97dap-1,    0x1.7ada00d2e28cbp-1,   0x1.4ccd02p-2, INEXACT)
T(RN,    0x1.f8795dc235dd5p-1,    0x1.aab8715f81e48p-1,   0x1.a41186p-2, INEXACT)
T(RN,    0x1.b39a01e265de2p-1,    0x1.80eba5662b0a1p-1,   0x1.f7c08cp-6, INEXACT)
T(RN,    0x1.493826fe41c4ep-1,    0x1.32ff5493454bep-1,   0x1.566c18p-2, INEXACT)
T(RN,    0x1.d8615350e2934p-1,    0x1.9828960db92d4p-1,  -0x1.eb8b2cp-2, INEXACT)
T(RN,    0x1.4cd91fff279dbp-1,    0x1.35e4cdcf4e32cp-1,   0x1.4d432cp-4, INEXACT)
T(RN,    0x1.2018b263f51a3p+0,    0x1.ce0b4e9d611e8p-1,  -0x1.b29d7ap-3, INEXACT)
T(RN,    0x1.91d30c40a1eb1p+0,    0x1.ffffe90b366e9p-1,  -0x1.c49d16p-2, INEXACT)
T(RN,    0x1.5ac6236d37cffp+0,    0x1.f4144e7b00eaap-1,  -0x1.54884ep-5, INEXACT)
T(RN,    0x1.8bac18aa9747cp+0,    0x1.ffd6610319359p-1,  -0x1.cfebbep-4, INEXACT)
T(RN,    0x1.61cba9e79429cp+0,    0x1.f6e74dcd358d2p-1,    0x1.f6388p-3, INEXACT)
T(RN,    0x1.9ba46a0387a46p+0,    0x1.ffa5692ba66bbp-1,    0x1.1c2cdp-2, INEXACT)
T(RN,    0x1.07736e2a0a35cp+0,    0x1.b6b375d0560c6p-1,   0x1.3196eap-2, INEXACT)
T(RN,    0x1.40b878dce05fap+0,    0x1.e65527cd6f39cp-1,   0x1.332eeep-4, INEXACT)
T(RN,    0x1.c96687a4b0c55p+0,    0x1.f41c586560057p-1,   0x1.1a102cp-3, INEXACT)
T(RN,    0x1.ae5e4cbc6157ep+0,    0x1.fce30ea4795e5p-1,   0x1.c9ad66p-3, INEXACT)
T(RN,    0x1.a72f960899053p+1,   -0x1.4f79453e2951fp-3,  -0x1.023446p-4, INEXACT)
T(RN,    0x1.06a9f0d2edb2dp+1,     0x1.c5d78c765629p-1,   0x1.97e122p-8, INEXACT)
T(RN,    0x1.922cafa7ec521p+1,  -0x1.9f4c7479e8c49p-12,   0x1.db04f8p-2, INEXACT)
T(RN,    0x1.58bf397908a42p+1,    0x1.bbcbfd479c152p-2,  -0x1.9bbe14p-5, INEXACT)
T(RN,    0x1.71ed08bf76866p+1,    0x1.fdc05946acbd2p-3,  -0x1.822d06p-2, INEXACT)
T(RN,    0x1.c8f18184f6564p+1,   -0x1.a945960191a14p-2,  -0x1.62412ap-2, INEXACT)
T(RN,    0x1.aa2861bc41b2bp+1,   -0x1.7e495aed369b3p-3,   0x1.e2b5fep-2, INEXACT)
T(RN,     0x1.2b3d13a17664p+1,    0x1.70a2d51522bebp-1,   0x1.4c63aep-3, INEXACT)
T(RN,    0x1.335aa7929c1a3p+1,    0x1.5961df2205fbfp-1,  -0x1.fa20dcp-2, INEXACT)
T(RN,    0x1.189765a7aea1dp+1,    0x1.a04fc15ab3a7ep-1,   0x1.a0b6e4p-6, INEXACT)
T(RN,    0x1.c25e564c49904p+2,    0x1.5e6db39d4e6b3p-1,   0x1.63c50ap-2, INEXACT)
T(RN,    0x1.ef3ae92f630a7p+2,    0x1.fc8ef818594cbp-1,  -0x1.8c437ap-2, INEXACT)
T(RN,    0x1.b5a2bd102c314p+2,     0x1.0dbd4defec35p-1,   0x1.6dd87ep-2, INEXACT)
T(RN,    0x1.da4652dbf81fep+2,    0x1.ce7ae3fe873adp-1,   0x1.72d822p-2, INEXACT)
T(RN,    0x1.b38e867559f5cp+2,    0x1.feed32c3e47b7p-2,   0x1.f7baa4p-2, INEXACT)
T(RN,    0x1.574243098c1a3p+2,   -0x1.974683112d3b4p-1,   0x1.9a4564p-2, INEXACT)
T(RN,    0x1.ba8988b5d226ep+2,    0x1.2e3ed531af58ap-1,  -0x1.ebb0aap-2, INEXACT)
T(RN,    0x1.b4a9efe4692cep+2,    0x1.07199f492f308p-1,  -0x1.8c684cp-3, INEXACT)
T(RN,    0x1.091cf3111f0c3p+2,    -0x1.af0dda8a2ff4p-1,   0x1.9f9306p-4, INEXACT)
T(RN,    0x1.65d4cb2cb5155p+2,   -0x1.46b9851a4d33dp-1,  -0x1.b03f9cp-5, INEXACT)
T(RN,    0x1.9aab542af4d2dp+3,    0x1.0e36cd54c03ccp-2,   0x1.e2f3b8p-2, INEXACT)
T(RN,    0x1.239b8a473b601p+3,    0x1.3a5eb03a8cc9fp-2,  -0x1.4a4af2p-5, INEXACT)
T(RN,    0x1.1f2076b1d048dp+3,    0x1.bf4ed323c0b7cp-2,   0x1.d162b6p-2, INEXACT)
T(RN,    0x1.e5ed395d9fd9ap+3,    0x1.ff40740cf8d0ap-2,  -0x1.c4ae94p-2, INEXACT)
T(RN,    0x1.cf83ecc20f3a9p+3,    0x1.e15d145f11e7dp-1,  -0x1.8946e6p-3, INEXACT)
T(RN,    0x1.33d9bc9f6011dp+3,   -0x1.8df0fc019b036p-3,  -0x1.50afa8p-6, INEXACT)
T(RN,     0x1.b13db1e74ea7p+3,    0x1.a709b65336373p-1,  -0x1.9cb892p-4, INEXACT)
T(RN,    0x1.47e4be7a14ef3p+3,   -0x1.77020412d3cc5p-1,  -0x1.8574bap-7, INEXACT)
T(RN,    0x1.c99dab9b6b446p+3,    0x1.f92f99e5bdbc7p-1,   0x1.c2656ep-4, INEXACT)
T(RN,    0x1.d3159c6ca2f74p+3,    0x1.caf4adf07d89ap-1,   0x1.67402ap-2, INEXACT)
T(RN,    0x1.8fc1348b2fc2cp+4,   -0x1.2e24fc9829156p-3,   0x1.626be4p-3, INEXACT)
T(RN,    0x1.736638a15a396p+4,   -0x1.e10c6e4a07445p-1,   0x1.9fd956p-4, INEXACT)
T(RN,    0x1.88694cc804da2p+4,   -0x1.240fd372c3949p-1,   0x1.579af6p-4, INEXACT)
T(RN,    0x1.421125c3e5c26p+4,    0x1.ea7328e63220fp-1,  -0x1.446604p-2, INEXACT)
T(RN,    0x1.320d5a03ddff7p+4,    0x1.19b6581a6a401p-2,  -0x1.53060ap-3, INEXACT)
T(RN,     0x1.9ab2dfc4376fp+4,    0x1.0572a14e7ddffp-1,    0x1.80346p-2, INEXACT)
T(RN,    0x1.130ffa5df6f43p+4,   -0x1.fe0c2d51e813ep-1,   -0x1.8375ap-2, INEXACT)
T(RN,    0x1.b4dd8a2edf196p+4,    0x1.a669b8547066ep-1,  -0x1.58a472p-8, INEXACT)
T(RN,    0x1.45857b5e1e697p+4,    0x1.fe8cefbcffbaap-1,   0x1.715cb2p-4, INEXACT)
T(RN,    0x1.06a24ff29a0d8p+4,   -0x1.4c710f01fdc08p-1,   -0x1.8308fp-4, INEXACT)
T(RN,    0x1.9d4352e1c3b56p+5,    0x1.f7df9abcaa5e2p-1,  -0x1.527622p-2, INEXACT)
T(RN,    0x1.73e407de694fep+5,     0x1.30c170ffe46dp-1,  -0x1.e927f8p-3, INEXACT)
T(RN,    0x1.cd81519b7eb34p+5,    0x1.d11bb8b2da0a3p-1,    0x1.9fe17p-3, INEXACT)
T(RN,     0x1.34f784b7d1fep+5,    0x1.97e3a3df551c3p-1,  -0x1.b0f264p-4, INEXACT)
T(RN,    0x1.fead247e38229p+5,    0x1.af93548ba7695p-1,   0x1.3d4d24p-3, INEXACT)
T(RN,    0x1.f6b08cd89e457p+5,    0x1.1d482e4bfe867p-8,  -0x1.bd7bfap-2, INEXACT)
T(RN,    0x1.876ca1f1ac935p+5,   -0x1.f21f5de8b4af2p-1,   0x1.8815aep-3, INEXACT)
T(RN,    0x1.730366992f3fcp+5,    0x1.5bf5b0622b54ap-1,   0x1.76fec4p-4, INEXACT)
T(RN,    0x1.2f857d91dce89p+5,    0x1.e8f0ff7e1771bp-3,    0x1.4dd7ep-2, INEXACT)
T(RN,    0x1.6dd11fb540af6p+5,    0x1.f8446df62abbap-1,   0x1.b4e0c6p-2, INEXACT)
T(RN,    0x1.f8b9167e90dd2p+6,     0x1.fa2d0bb7bb43p-2,   0x1.74122ep-9, INEXACT)
T(RN,    0x1.0bd23c0afa7c6p+6,   -0x1.a9beaab945877p-1,   0x1.ce149ap-2, INEXACT)
T(RN,    0x1.396d957b8429dp+6,    0x1.744b63055c346p-3,    0x1.80d49p-3, INEXACT)
T(RN,    0x1.eecdd5dc642fep+6,   -0x1.d92ed8a1fc462p-1,   0x1.75f4ecp-2, INEXACT)
T(RN,    0x1.bb58a671bde52p+6,   -0x1.8ae387beea9c8p-1,  -0x1.c4e27ap-3, INEXACT)
T(RN,    0x1.d4a62e13edb18p+6,   -0x1.986312226a612p-1,  -0x1.b21bcap-2, INEXACT)
T(RN,    0x1.4e90465527578p+6,    0x1.d9cef4eac96bep-1,  -0x1.0f82dep-2, INEXACT)
T(RN,    0x1.c4382d7eae27fp+6,   -0x1.5bd8a904fc238p-5,   0x1.8d5c2cp-2, INEXACT)
T(RN,    0x1.795403a954188p+6,    0x1.58be5d5ed2a98p-4,   0x1.4921e2p-2, INEXACT)
T(RN,    0x1.d825d0633ef0cp+6,   -0x1.f2d7794d7675cp-1,  -0x1.87a2cep-2, INEXACT)
T(RN,    0x1.091ff1718007bp+7,    0x1.279c5b86726c9p-1,   0x1.023c22p-3, INEXACT)
T(RN,    0x1.2a6a6f4523dcbp+7,   -0x1.ffeb4dd447b03p-1,    0x1.ce22bp-3, INEXACT)
T(RN,    0x1.2bd7a20dabfc4p+7,   -0x1.8913bfd2979a2p-1,  -0x1.533108p-2, INEXACT)
T(RN,    0x1.d80cf72050f7ap+7,   -0x1.944c2ba542509p-2,  -0x1.051ce4p-2, INEXACT)
T(RN,    0x1.a9719e2ad74f8p+7,   -0x1.9316cd84f1b68p-1,   0x1.c72906p-2, INEXACT)
T(RN,    0x1.4a4bd19c4d975p+7,    0x1.f44512c7e9b2fp-1,  -0x1.a35d5ep-6, INEXACT)
T(RN,    0x1.8da501f00949ep+7,   -0x1.91ae5b5a7a145p-1,  -0x1.72a2e8p-3, INEXACT)
T(RN,     0x1.e40eff687cc1p+7,   -0x1.02b3e17be0db5p-3,   0x1.c38bd6p-4, INEXACT)
T(RN,    0x1.257af2df17a1ep+7,    0x1.95b46b9fc6297p-1,  -0x1.da6fbep-2, INEXACT)
T(RN,     0x1.16d168585868p+7,    0x1.d93016b66293bp-1,  -0x1.d52e42p-2, INEXACT)
T(RN,    0x1.4fce652e6847bp+8,    0x1.598688592ed3cp-2,  -0x1.4cf102p-3, INEXACT)
T(RN,     0x1.5d2c3bd0708cp+8,   -0x1.c2ee909b3e408p-2,  -0x1.44317cp-3, INEXACT)
T(RN,    0x1.0f655d6b5615ap+8,    0x1.e0a40201a72f8p-1,   -0x1.d4d3fp-2, INEXACT)
T(RN,    0x1.f42562bbb6b3ap+8,   -0x1.2ecd3f5551ae9p-1,  -0x1.8afec8p-2, INEXACT)
T(RN,    0x1.819f9847d45a8p+8,     0x1.6c97d6b611dbp-1,   0x1.3e352cp-2, INEXACT)
T(RN,    0x1.8a17c2bb9a2f5p+8,   -0x1.f7feb9caaa787p-1,  -0x1.718e8ep-3, INEXACT)
T(RN,    0x1.aba61e750b52ep+8,    0x1.877dd4ef40455p-2,    0x1.d0d5cp-3, INEXACT)
T(RN,    0x1.157a8a0f07797p+8,    0x1.b3e18d256acfep-1,   0x1.de17d4p-3, INEXACT)
T(RN,    0x1.5dd6a11ac2c09p+8,   -0x1.cd35d24b5798bp-1,   0x1.ffe66ep-3, INEXACT)
T(RN,    0x1.c4282786a287dp+8,    -0x1.d7dc18bf31a2p-3,   0x1.29fac2p-2, INEXACT)
T(RN,    0x1.5d2f3980d93fdp+9,    0x1.9c11749127174p-1,   0x1.b3f286p-2, INEXACT)
T(RN,    0x1.d3c2a6154903ep+9,   -0x1.3f83b403136d2p-1,  -0x1.94cc74p-4, INEXACT)
T(RN,     0x1.f204661259cfp+9,   -0x1.310630f521c4bp-3,  -0x1.e9767cp-3, INEXACT)
T(RN,    0x1.b7cfb95ec8102p+9,   -0x1.7a69531e2acffp-6,  -0x1.fac7c8p-5, INEXACT)
T(RN,    0x1.b7f49b5a8f138p+9,    0x1.0c3e172f089a2p-2,   0x1.575a94p-3, INEXACT)
T(RN,    0x1.2dd53e1e59a96p+9,    0x1.d903de7660be6p-2,  -0x1.9eb128p-2, INEXACT)
T(RN,    0x1.8edcfe8e2d2b5p+9,   -0x1.e2ddcfcf8e2d2p-3,   0x1.a8e8f6p-2, INEXACT)
T(RN,    0x1.ea3b4196ed492p+9,    0x1.20eb1f3014edfp-2,   0x1.430df2p-2, INEXACT)
T(RN,    0x1.7aeb9e479c8e3p+9,   -0x1.506cc2d183da4p-1,  -0x1.64bdd8p-2, INEXACT)
T(RN,    0x1.64e8e6ebf5352p+9,   -0x1.4126ab84d77a6p-1,  -0x1.8cb1eep-2, INEXACT)
T(RN,   0x1.19334147461e2p+10,    0x1.c475459c62041p-4,  -0x1.5c99b8p-4, INEXACT)
T(RN,   0x1.bc8f48d3124c8p+10,    0x1.8e3adb44b0edcp-4,  -0x1.64d80ap-7, INEXACT)
T(RN,   0x1.820721e9050b8p+10,   -0x1.ffe9313f882b3p-1,  -0x1.c6dc04p-2, INEXACT)
T(RN,   0x1.18c3a66aaf9ffp+10,   -0x1.ff01615455c77p-1,   0x1.b52c42p-4, INEXACT)
T(RN,   0x1.1c34d7f22ea89p+10,   -0x1.abad21a49e16bp-2,   0x1.2e5972p-2, INEXACT)
T(RN,   0x1.228949ef4aedfp+10,   -0x1.ef0e0ad1bd0cfp-3,   0x1.c8415ep-2, INEXACT)
T(RN,   0x1.c6c4e8c1fc7dep+10,   -0x1.82bd9fdf8ce6dp-4,   0x1.d025e4p-5, INEXACT)
T(RN,   0x1.e6017d7805531p+10,    0x1.2a8f4d1c617c8p-1,   0x1.4c9022p-4, INEXACT)
T(RN,   0x1.024a6d55f50abp+10,    0x1.a2898c4ac98adp-2,    0x1.5e3e1p-6, INEXACT)
T(RN,   0x1.6ae47c1f107a8p+10,    0x1.3ab15ec557889p-3,   0x1.70f86ep-3, INEXACT)
T(RN,   0x1.f2654a4c2e9e2p+11,   -0x1.dcb5edaca6bd9p-2,   0x1.7c523ap-2, INEXACT)
T(RN,   0x1.92100319f496ap+11,   -0x1.e25f15510fefep-2,   0x1.8be558p-2, INEXACT)
T(RN,   0x1.fde0c82b5a128p+11,    0x1.e3c4d7a0e71ecp-1,  -0x1.797c08p-2, INEXACT)
T(RN,   0x1.8ba761438f5edp+11,   -0x1.fe8566e538123p-1,  -0x1.2661f4p-3, INEXACT)
T(RN,   0x1.2c1ba215f9ee7p+11,    0x1.449f12e140deep-1,  -0x1.caf374p-2, INEXACT)
T(RN,   0x1.4935371d3df7dp+11,    0x1.b11fa80d770a1p-1,   0x1.97b104p-5, INEXACT)
T(RN,   0x1.178eb590565d7p+11,   -0x1.6344131162146p-2,   0x1.f9b81cp-6, INEXACT)
T(RN,   0x1.de01f8ef460f9p+11,   -0x1.5a82bc882ddc3p-1,  -0x1.4fd9c2p-3, INEXACT)
T(RN,   0x1.d2e1d88fffeaep+11,    0x1.2aad4a4bd7b9fp-2,   -0x1.58f0fp-2, INEXACT)
T(RN,   0x1.48af706da77f2p+11,    0x1.f4e4cc8027ddcp-6,  -0x1.0ef4ecp-3, INEXACT)
T(RN,   0x1.c74e80dab1dd4p+12,     0x1.ba8c857ca366p-2,   0x1.662262p-2, INEXACT)
T(RN,   0x1.30f63932b2e74p+12,   -0x1.e6f2ef2383425p-2,  -0x1.e4ddb4p-3, INEXACT)
T(RN,   0x1.022a1adaf60a5p+12,    0x1.112c6c4dca8e6p-1,  -0x1.7d7916p-2, INEXACT)
T(RN,   0x1.20839e59243d7p+12,   -0x1.e1f61088a623cp-1,  -0x1.fcf318p-4, INEXACT)
T(RN,   0x1.feab6855b462cp+12,    0x1.1415a283ea7cap-1,   0x1.6181bap-3, INEXACT)
T(RN,   0x1.84c884f6f698ep+12,    0x1.6ca74ee93f699p-3,  -0x1.d073a2p-6, INEXACT)
T(RN,   0x1.07023d3d44215p+12,   -0x1.ffdc173adabb2p-1,   -0x1.40a9cp-2, INEXACT)
T(RN,   0x1.382fccbe7c238p+12,   -0x1.2794ef9529b8bp-3,   -0x1.3c599p-2, INEXACT)
T(RN,   0x1.6bfa590071a3cp+12,   -0x1.86078feca4974p-1,  -0x1.7d87c2p-6, INEXACT)
T(RN,   0x1.37e6161c585d4p+12,    0x1.ff999832cc463p-1,   0x1.79bca8p-5, INEXACT)
T(RN,   0x1.83afb0c4e5266p+13,    0x1.7ee9ae6c1ab23p-3,   0x1.04de06p-5, INEXACT)
T(RN,   0x1.febb646e2ee57p+13,    0x1.83b3062414974p-1,   0x1.369decp-3, INEXACT)
T(RN,   0x1.9e651a6f4f63dp+13,    0x1.945e4295dc40bp-6,   0x1.ed915cp-3, INEXACT)
T(RN,   0x1.c7d715fcc39a2p+13,   -0x1.d0b5afe93b6a4p-2,  -0x1.49ba7cp-4, INEXACT)
T(RN,   0x1.39762be31254ep+13,    0x1.4f9be1864f787p-2,   -0x1.1a549p-2, INEXACT)
T(RN,   0x1.22b9ee4f00dd3p+13,   -0x1.aac7e59de8846p-1,  -0x1.86b8cap-4, INEXACT)
T(RN,   0x1.40ce6a2c71811p+13,   -0x1.9842d680f96e8p-1,  -0x1.a4bf62p-6, INEXACT)
T(RN,   0x1.6a3f85fdb6707p+13,   -0x1.05af298c8f659p-1,    0x1.69389p-2, INEXACT)
T(RN,   0x1.a272a586df829p+13,    0x1.84fe6c0e9928fp-1,  -0x1.f043bap-2, INEXACT)
T(RN,   0x1.e8a8b14009f7ap+13,   -0x1.f6b34b1d91f52p-1,  -0x1.322132p-3, INEXACT)
T(RN,   0x1.3924d232b3631p+14,   -0x1.aad7d1dbc4df7p-1,  -0x1.ea596ap-2, INEXACT)
T(RN,   0x1.44f6d5922a526p+14,    0x1.6db4c08e44acdp-2,  -0x1.bddf5ap-7, INEXACT)
T(RN,   0x1.6fdbe6c40b6eap+14,   -0x1.ea4ba9ab6f085p-4,   0x1.125912p-2, INEXACT)
T(RN,   0x1.103799783c19bp+14,   -0x1.f603f2c23d374p-1,  -0x1.973ee4p-2, INEXACT)
T(RN,   0x1.e0e831e386568p+14,    0x1.12a453db5cf1bp-3,   -0x1.4e035p-2, INEXACT)
T(RN,   0x1.33e7bc9a2520bp+14,    0x1.e9fe0e1b1f83dp-1,  -0x1.8cdd88p-2, INEXACT)
T(RN,   0x1.488b44ebdf206p+14,   -0x1.1911d3d1e514fp-3,  -0x1.3a5dbcp-5, INEXACT)
T(RN,   0x1.80451bed23e68p+14,    0x1.8ddaa841ac358p-1,  -0x1.059246p-2, INEXACT)
T(RN,    0x1.aa963d7875c7p+14,    0x1.ccd28c5501622p-1,     0x1.2538p-6, INEXACT)
T(RN,   0x1.58ec9d6543a9ep+14,    0x1.759a1453818dfp-1,  -0x1.7a2a94p-2, INEXACT)
T(RN,   0x1.166ef20627721p+15,    0x1.e52bf7f9d29ebp-1,   0x1.180f2ep-2, INEXACT)
T(RN,   0x1.0e6f9e2945905p+15,    0x1.f898e8191d15bp-1,  -0x1.9f252cp-2, INEXACT)
T(RN,    0x1.eb826cb6909dp+15,   -0x1.4434a685bc23ep-2,  -0x1.ed19aep-2, INEXACT)
T(RN,   0x1.65fb02b180626p+15,   -0x1.f65b63425da6ep-1,   0x1.8bbb86p-3, INEXACT)
T(RN,   0x1.68228d673f758p+15,   -0x1.44ca02fcc9d7ep-1,  -0x1.84de22p-2, INEXACT)
T(RN,   0x1.e05575eb77984p+15,    0x1.f6a957e6d9925p-1,   -0x1.b2844p-2, INEXACT)
T(RN,   0x1.90ca6f4872e62p+15,    -0x1.ac3cba4d5e46p-1,   0x1.73eb96p-3, INEXACT)
T(RN,   0x1.7b5128dd38b11p+15,    0x1.573502e81f956p-1,  -0x1.2c11e8p-3, INEXACT)
T(RN,   0x1.707a3ebbb8448p+15,   -0x1.873917ecfacd7p-2,  -0x1.f27c9ep-2, INEXACT)
T(RN,   0x1.ad9a06e0ae4e4p+15,   -0x1.fa857a78c2f13p-1,   0x1.f39c0cp-3, INEXACT)
T(RN,   0x1.4f37c94fdd5dep+16,    0x1.5374ddde8c5b5p-5,   0x1.a48196p-2, INEXACT)
T(RN,   0x1.bba31f035f9e8p+16,    0x1.1eed66ddfd48bp-1,  -0x1.3cd2e6p-2, INEXACT)
T(RN,   0x1.eead2885619bfp+16,   -0x1.b5a04d41d2fb7p-2,  -0x1.8a6468p-3, INEXACT)
T(RN,   0x1.59aaa63d06746p+16,   -0x1.f95223d7c7e0bp-1,    0x1.99436p-5, INEXACT)
T(RN,   0x1.d4c07bfa82a18p+16,   -0x1.c10dab87a85fdp-1,  -0x1.e2bd26p-2, INEXACT)
T(RN,   0x1.0dcf3dc26d9e8p+16,    0x1.790e9704baad9p-3,   -0x1.5db2dp-3, INEXACT)
T(RN,   0x1.c89d0a3d94f62p+16,    0x1.3a231edcf6492p-1,   0x1.099e92p-2, INEXACT)
T(RN,   0x1.ffce694580849p+16,   -0x1.81541ba347308p-1,   0x1.624e7cp-2, INEXACT)
T(RN,   0x1.29252f23f647fp+16,   -0x1.f277b2644f29ap-1,  -0x1.43b20ap-2, INEXACT)
T(RN,     0x1.beb3258824dp+16,    0x1.d8391e5425bd8p-1,   0x1.279f82p-3, INEXACT)
T(RN,   0x1.08a55c2c34aa9p+17,    0x1.ef08aca960057p-1,   0x1.9e8052p-3, INEXACT)
T(RN,   0x1.b92523c4699bdp+17,   -0x1.fdae8f59d1503p-1,   0x1.22b048p-2, INEXACT)
T(RN,   0x1.4a8cf65eb050fp+17,    -0x1.dabcb6e96a5ep-1,    0x1.9c9c6p-5, INEXACT)
T(RN,   0x1.43383bfdd6752p+17,    0x1.de965b6c523d9p-1,  -0x1.b36a34p-3, INEXACT)
T(RN,    0x1.e27bbad78187p+17,    0x1.f825a9ae3c243p-1,   -0x1.f1719p-3, INEXACT)
T(RN,   0x1.b5709a393da6fp+17,   -0x1.e091e70fec6b2p-1,  -0x1.edd84cp-2, INEXACT)
T(RN,   0x1.fe270c4c35148p+17,   -0x1.97890b33bb104p-3,  -0x1.b9a5dcp-3, INEXACT)
T(RN,   0x1.919449158100cp+17,   -0x1.5f73d7358d20fp-1,   0x1.e246e6p-2, INEXACT)
T(RN,   0x1.4193355a4b3dfp+17,    0x1.ef0607e06a679p-1,   0x1.16751cp-4, INEXACT)
T(RN,   0x1.e46827213433ep+17,    0x1.0db1dbea6221cp-3,  -0x1.e327f6p-3, INEXACT)
T(RN,   0x1.03bc06b910821p+18,    0x1.87a9f5d273f4dp-1,  -0x1.ee229ep-5, INEXACT)
T(RN,   0x1.381c74a3bc364p+18,    0x1.efcfad6a49691p-1,   0x1.88f87ep-2, INEXACT)
T(RN,   0x1.75c4efd374163p+18,   -0x1.de095d99d64a7p-2,  -0x1.ef1136p-3, INEXACT)
T(RN,   0x1.278e3c744fcf3p+18,    0x1.d40fec1a6b8edp-2,  -0x1.c97792p-3, INEXACT)
T(RN,   0x1.5d0c6d65a65eap+18,    0x1.aad312dde6da7p-2,   0x1.d6af6cp-2, INEXACT)
T(RN,    0x1.e6d789081f8fp+18,   -0x1.2def36ad28c78p-1,    0x1.d502ep-2, INEXACT)
T(RN,   0x1.e939eb570670dp+18,     0x1.ca55825ab1f5p-4,   0x1.cf6994p-2, INEXACT)
T(RN,   0x1.79410574a2891p+18,   -0x1.ae0027b036bf1p-1,  -0x1.7a2bc4p-3, INEXACT)
T(RN,   0x1.f8fe75ef74366p+18,     0x1.f94b5b93dd1ap-1,   0x1.2a9c0ep-3, INEXACT)
T(RN,   0x1.d70e0c973a3d6p+18,    0x1.f0eed1c0a5d94p-5,  -0x1.e99976p-3, INEXACT)
T(RN,   0x1.46bfef0a93085p+19,   -0x1.906620d4d17c3p-1,  -0x1.f3fbaep-3, INEXACT)
T(RN,   0x1.aea4def7cf2eep+19,     0x1.73bc175a61bbp-1,   0x1.b97ab6p-2, INEXACT)
T(RN,   0x1.c12430786aab9p+19,    0x1.c9c111c96b4dbp-1,  -0x1.1f335ap-2, INEXACT)
T(RN,   0x1.5b2f20781d3dcp+19,    0x1.f30733218f2cbp-2,  -0x1.98015ep-5, INEXACT)
T(RN,   0x1.79981d32839e2p+19,   -0x1.c2e3bf9cf33efp-2,  -0x1.2d76e6p-2, INEXACT)
T(RN,   0x1.4fd86cb9c4b6cp+19,   -0x1.0173db58a7cfep-1,  -0x1.d30bbap-2, INEXACT)
T(RN,   0x1.efb7ff64902bfp+19,    0x1.d9d7552d6e569p-1,   0x1.f0a174p-2, INEXACT)
T(RN,   0x1.cb470d600ab1cp+19,    0x1.ec8dbb30910b8p-1,   0x1.3dc8cap-3, INEXACT)
T(RN,   0x1.ef2f43723257ap+19,    0x1.19f36392d5268p-1,   0x1.9e53d8p-2, INEXACT)
T(RN,   0x1.b8d2e57c11f3ep+19,    0x1.f92d12f7e1737p-1,  -0x1.db25aep-2, INEXACT)
T(RN,   0x1.322a28585a67ap+20,    0x1.b155f47fdd727p-1,  -0x1.3ee1c8p-5, INEXACT)
T(RN,   0x1.fe2f86a8fe2eep+20,    0x1.ba7238727eb79p-1,   0x1.01dff8p-5, INEXACT)
T(RN,   0x1.be441fdf02ac8p+20,    0x1.fa20ff1036535p-1,   0x1.c97382p-4, INEXACT)
T(RN,   0x1.8e8315cded982p+20,    0x1.a414d3bd34fbcp-3,   0x1.21ffe2p-2, INEXACT)
T(RN,   0x1.da795842f62f5p+20,   -0x1.f66076aab428cp-3,   0x1.bba008p-6, INEXACT)
T(RN,   0x1.c9c82cf00d448p+20,    0x1.d3ff615cca016p-2,   0x1.c39e3ep-3, INEXACT)
T(RN,   0x1.ba21fc5ac013ap+20,   -0x1.ffd5bcde85d5ep-1,  -0x1.a7112ep-3, INEXACT)
T(RN,   0x1.25564d52a9e2fp+20,    0x1.b35b493593182p-2,   0x1.eb2accp-2, INEXACT)
T(RN,   0x1.b07077e22a6aap+20,    -0x1.4f41ee046ae9p-1,  -0x1.5bade2p-5, INEXACT)
T(RN,   0x1.a3f5752ead13dp+20,   -0x1.0791d70c1db6fp-1,   0x1.6e5ee8p-2, INEXACT)
T(RN,   0x1.201aa6cc0123dp+21,    0x1.92e186e1672b9p-1,   0x1.8937acp-2, INEXACT)
T(RN,   0x1.123321c83dc81p+21,   -0x1.72082fd77cfc2p-1,  -0x1.53ecc8p-2, INEXACT)
T(RN,   0x1.0f596af58306cp+21,    0x1.9bbfc7042579ep-3,   -0x1.204b1p-2, INEXACT)
T(RN,   0x1.e3a89d7c53093p+21,   -0x1.ab1e0950a1498p-1,    0x1.e86a2p-2, INEXACT)
T(RN,   0x1.e2a4ed0cd737ap+21,    0x1.ff8b2c0017874p-1,  -0x1.15d5fcp-2, INEXACT)
T(RN,   0x1.468b6a5c657d5p+21,   -0x1.1dfbf123afdb5p-2,   0x1.68e3aep-2, INEXACT)
T(RN,   0x1.36201dfec7cd1p+21,   -0x1.fce686af70a24p-1,   0x1.00a61cp-3, INEXACT)
T(RN,   0x1.1274c64f05946p+21,    0x1.d841d7df08272p-1,   -0x1.aa74bp-2, INEXACT)
T(RN,   0x1.e5a5a131afcc9p+21,    0x1.fce40b04bc2ecp-1,    0x1.8158dp-2, INEXACT)
T(RN,   0x1.7262615d927d4p+21,    0x1.219d888abfc8bp-2,   0x1.ba43b4p-2, INEXACT)
T(RN,   0x1.e24f53ba2f445p+22,   -0x1.466d661501b6ep-1,  -0x1.02e80ep-4, INEXACT)
T(RN,   0x1.51cf5f9f40caap+22,   -0x1.b9586b15a893dp-1,  -0x1.0cc4f6p-3, INEXACT)
T(RN,   0x1.f1253eda89eaap+22,   -0x1.46cf25e451ab8p-1,  -0x1.27c204p-3, INEXACT)
T(RN,    0x1.7ac7ec0a823fp+22,    0x1.911571568eb28p-1,    0x1.e9193p-5, INEXACT)
T(RN,    0x1.3cf90dfde5dcp+22,   -0x1.fee6f6489a711p-1,   0x1.ca5816p-2, INEXACT)
T(RN,   0x1.b29ae341982e8p+22,   -0x1.f961d92d746c3p-1,  -0x1.e0173cp-3, INEXACT)
T(RN,   0x1.d91f3c580aac1p+22,    0x1.217dedf348acdp-1,   0x1.7e9c54p-3, INEXACT)
T(RN,   0x1.030d2c30cf5b9p+22,    0x1.c5d47ab5e58d3p-1,  -0x1.872e56p-4, INEXACT)
T(RN,   0x1.5e960043810efp+22,    0x1.73c4089412d06p-6,  -0x1.98662cp-6, INEXACT)
T(RN,    0x1.da4ecac4dcc6p+22,    0x1.22a1820b8d63ep-1,   0x1.5d635ep-2, INEXACT)
T(RN,   0x1.df9d56a34e4f8p+23,   -0x1.4d7e9450ac59fp-1,  -0x1.a7c7f8p-3, INEXACT)
T(RN,   0x1.56acf294772b4p+23,   -0x1.10f5b34ff12b9p-2,   0x1.192e62p-4, INEXACT)
T(RN,   0x1.6e099f42bb7b5p+23,    0x1.ff52669755201p-1,   0x1.a7d502p-3, INEXACT)
T(RN,   0x1.769fa6f31b38fp+23,    0x1.ad767754df4a1p-1,  -0x1.fd02aap-2, INEXACT)
T(RN,   0x1.412f8d1386675p+23,    0x1.c04b909e8fbe1p-2,  -0x1.06bc86p-3, INEXACT)
T(RN,   0x1.5492b0038dc5fp+23,   -0x1.4feb7e3c47f21p-1,  -0x1.e3bfc8p-5, INEXACT)
T(RN,   0x1.5df3d0d2f965ap+23,   -0x1.edd09e35b5f0dp-6,   0x1.ee115ep-5, INEXACT)
T(RN,   0x1.40a9e35caa8eep+23,    0x1.903b7d18d06dep-3,    0x1.11c1bp-2, INEXACT)
T(RN,   0x1.0bcbc38ba644fp+23,   -0x1.4dcc0649d6ae7p-2,  -0x1.dd7d36p-3, INEXACT)
T(RN,   0x1.908630d6e1e15p+23,    0x1.59501c8f21b24p-1,   0x1.959464p-2, INEXACT)
T(RN,   0x1.fa27782dcf2a6p+24,   -0x1.d2f6bb4a82c3ap-2,   0x1.ce277cp-2, INEXACT)
T(RN,   0x1.05c0f8795e46cp+24,    0x1.e8530b0e01dcbp-2,   0x1.f750f4p-3, INEXACT)
T(RN,   0x1.d08233e2512ccp+24,    0x1.21dd049abe892p-4,   0x1.3c3f22p-2, INEXACT)
T(RN,   0x1.6ca334560c488p+24,    0x1.fd3898783c493p-1,   0x1.9cdb2ap-3, INEXACT)
T(RN,   0x1.87a0bef8663c9p+24,    0x1.d569ff42c8463p-1,   0x1.9c5b6ap-2, INEXACT)
T(RN,   0x1.d0f304e94c42fp+24,    0x1.29e44748d1549p-2,   0x1.6f67cap-3, INEXACT)
T(RN,   0x1.5c93f9027388cp+24,   -0x1.54ba0a488a3b2p-1,   0x1.9b2e5cp-2, INEXACT)
T(RN,   0x1.01658e725b571p+24,    0x1.be52b2ca107bap-4,   0x1.2b1852p-2, INEXACT)
T(RN,   0x1.b668ca49e517ep+24,    0x1.ffd7a352fa79ep-1,   0x1.6b28dep-2, INEXACT)
T(RN,   0x1.a7114800f1de4p+24,    0x1.932f35eb39d2dp-1,   0x1.eb1798p-3, INEXACT)
T(RN,   0x1.40bb4399854f4p+25,   -0x1.ed942f651faa7p-1,   0x1.b456dep-2, INEXACT)
T(RN,   0x1.80bde92e70aeap+25,   -0x1.2607b599898e6p-1,   0x1.9fb3cep-5, INEXACT)
T(RN,    0x1.a6ddd020f96dp+25,    0x1.f8720100ebfddp-1,  -0x1.eb2472p-2, INEXACT)
T(RN,   0x1.0d2638a0a8651p+25,    0x1.231482b1910a8p-1,   -0x1.dcca2p-2, INEXACT)
T(RN,   0x1.6e2a466203e3ap+25,   -0x1.c9a3e795bfd05p-1,  -0x1.606c48p-2, INEXACT)
T(RN,   0x1.d6b572884bccdp+25,    0x1.d840975e428fbp-1,    0x1.fb66fp-2, INEXACT)
T(RN,   0x1.8cd360fc5564fp+25,    0x1.9a9fab6545792p-1,    0x1.88212p-4, INEXACT)
T(RN,   0x1.1f1dfe0391caap+25,    0x1.b1dd74ce9493bp-1,  -0x1.493c04p-2, INEXACT)
T(RN,   0x1.43ac41d4cf2acp+25,    0x1.dc1e50648f8d1p-1,   -0x1.6fd07p-2, INEXACT)
T(RN,   0x1.a4f7fd3129fe4p+25,   -0x1.f7ba0bd129e7ep-1,   0x1.dcf456p-2, INEXACT)
T(RN,   0x1.702f1da97af59p+26,   -0x1.68bd5d801536ap-1,  -0x1.72f8bep-2, INEXACT)
T(RN,   0x1.685c7908c15e2p+26,    -0x1.25d773b2dd63p-2,   0x1.9e561ep-3, INEXACT)
T(RN,   0x1.bb9a9d3ee9ae1p+26,   -0x1.8bec9d917f89fp-1,   -0x1.ca262p-2, INEXACT)
T(RN,   0x1.c0172a37c665ep+26,    0x1.e8e56b8f6dd84p-1,   0x1.8295e8p-4, INEXACT)
T(RN,   0x1.5a12d744df198p+26,    0x1.f9efdc3c0b626p-1,   -0x1.3b808p-2, INEXACT)
T(RN,   0x1.8e5aa44623fa6p+26,   -0x1.7d00fe4ce0679p-1,  -0x1.3d2fdep-2, INEXACT)
T(RN,    0x1.7ad384804814p+26,    0x1.c1a9b0d5f61dap-2,   0x1.5d49ecp-3, INEXACT)
T(RN,   0x1.366119d8f5f1ep+26,    0x1.a1990753c9391p-1,   0x1.e4bad4p-2, INEXACT)
T(RN,   0x1.bd7f20ef6e34ap+26,    0x1.f2517aaf52ea3p-1,   0x1.e3918ap-5, INEXACT)
T(RN,   0x1.071480e02503ep+26,   -0x1.88d4e3b5d2befp-2,   0x1.0681b4p-3, INEXACT)
T(RN,   0x1.e773317df5a58p+27,     0x1.ff26ed92520ep-1,   0x1.9e760ap-3, INEXACT)
T(RN,   0x1.d64be385cdb2ep+27,    0x1.3766204aa0b44p-4,   0x1.59aec8p-2, INEXACT)
T(RN,   0x1.7978462c1a1d2p+27,    0x1.75596fc57b3a7p-1,  -0x1.aaac5cp-3, INEXACT)
T(RN,   0x1.2520b1f6b620dp+27,   -0x1.cc1491fb69e51p-1,  -0x1.eb1562p-5, INEXACT)
T(RN,   0x1.f068919f8729ap+27,    0x1.88109cefb0d68p-2,   0x1.ecdc58p-2, INEXACT)
T(RN,   0x1.159bf219d93c6p+27,   -0x1.cc0fd9bd41c64p-1,  -0x1.32193ap-2, INEXACT)
T(RN,   0x1.ef66143693341p+27,    -0x1.b891afa0c1cep-1,   0x1.a46468p-2, INEXACT)
T(RN,   0x1.c834269192998p+27,   -0x1.e1230b28413a1p-1,    0x1.be675p-2, INEXACT)
T(RN,   0x1.186f43e465299p+27,    0x1.cb2671a50066ep-1,   0x1.cc2c98p-3, INEXACT)
T(RN,   0x1.772d7042bb8abp+27,   -0x1.ec4a686bb95c3p-1,   0x1.0b8e14p-3, INEXACT)
T(RN,    0x1.9f5f55490789p+28,    -0x1.eb0055f08046p-1,   0x1.8d07fcp-2, INEXACT)
T(RN,   0x1.f6d36819270d1p+28,   -0x1.451d563d844c1p-1,   0x1.6e4d94p-4, INEXACT)
T(RN,   0x1.783a1b2961c3bp+28,    0x1.5dc67de8aea1dp-2,   -0x1.5c337p-2, INEXACT)
T(RN,   0x1.890e2d4651e42p+28,   -0x1.79cdeca3b382cp-2,  -0x1.dda508p-4, INEXACT)
T(RN,   0x1.8c7746deb6646p+28,   -0x1.8325de4346afep-1,   -0x1.debcdp-2, INEXACT)
T(RN,   0x1.7f59f0f243432p+28,    0x1.d703e7663f275p-2,  -0x1.843636p-2, INEXACT)
T(RN,   0x1.58a1c4d7d7e94p+28,    0x1.5e4efe2b644cdp-1,  -0x1.2ad294p-2, INEXACT)
T(RN,   0x1.e3bf316ec1a1fp+28,    0x1.09a41d2bc065fp-1,   0x1.140446p-2, INEXACT)
T(RN,   0x1.ad335ddfa2e3fp+28,   -0x1.686104c74fa5bp-1,    0x1.01f3bp-7, INEXACT)
T(RN,   0x1.fa2717900c3e2p+28,    0x1.c780c285393e5p-1,    0x1.3c8f7p-3, INEXACT)
T(RN,   0x1.eceea877ef0ecp+29,   -0x1.c058cc2e97b1dp-5,   0x1.3875c2p-2, INEXACT)
T(RN,   0x1.d2d66082ce1ccp+29,    0x1.44c6416952107p-1,  -0x1.20cac8p-2, INEXACT)
T(RN,   0x1.57971660e38b6p+29,    0x1.87edfe6e66adfp-1,   -0x1.4f11dp-4, INEXACT)
T(RN,   0x1.7c7f9d106c67ap+29,   -0x1.f1cde69471014p-2,   0x1.49c8c2p-2, INEXACT)
T(RN,   0x1.04b4e6f9fd362p+29,   -0x1.ff70aa2ca5e9cp-1,   0x1.0b5b28p-4, INEXACT)
T(RN,   0x1.0e35e16bb509fp+29,    0x1.fe4b74bb9feb1p-1,  -0x1.4e6df4p-3, INEXACT)
T(RN,   0x1.1c4ef6f8d2098p+29,    0x1.188d926d793b7p-2,   0x1.9d4228p-3, INEXACT)
T(RN,   0x1.d5b7965758e42p+29,   -0x1.751293986f284p-1,  -0x1.4bc2e2p-3, INEXACT)
T(RN,   0x1.6f766e73a21b2p+29,   -0x1.211eb7d0863b6p-2,   0x1.815d8cp-3, INEXACT)
T(RN,   0x1.0955beb34365cp+29,    0x1.1166ada189819p-1,   0x1.a695fcp-5, INEXACT)
T(RN,   0x1.f733018f7e995p+30,    0x1.e04575250d364p-2,  -0x1.e9c10cp-5, INEXACT)
T(RN,    0x1.fd9bc1f68c8cp+30,   -0x1.d1f672ad46f0dp-7,   0x1.6fd722p-4, INEXACT)
T(RN,   0x1.d742cddabf622p+30,    0x1.605b1f3d039a9p-2,  -0x1.19f84cp-3, INEXACT)
T(RN,   0x1.cece20adc9584p+30,    0x1.02550baf9447fp-1,    0x1.e34ecp-3, INEXACT)
T(RN,   0x1.9260b381c0b8ap+30,   -0x1.f8ac7b653aa7bp-1,   0x1.e1ae96p-2, INEXACT)
T(RN,   0x1.b03a0549a7efap+30,   -0x1.fd8a1a18cac06p-4,  -0x1.392f44p-6, INEXACT)
T(RN,   0x1.acbac62dfc931p+30,    0x1.0fe0135f83c6ep-4,  -0x1.c52872p-4, INEXACT)
T(RN,   0x1.0ba7297ab7912p+30,    0x1.569e24d57c9d8p-2,  -0x1.0f20e8p-4, INEXACT)
T(RN,   0x1.2d2253cbb62fbp+30,    0x1.ead3fe0508511p-1,   0x1.d1a41cp-4, INEXACT)
T(RN,   0x1.aaa29f9762cc7p+30,    0x1.ffc9d26005b06p-1,    0x1.22bd8p-9, INEXACT)
T(RN,   0x1.860c298c322cbp+31,   -0x1.c46470f5f5f29p-2,  -0x1.6d8e7ap-3, INEXACT)
T(RN,    0x1.0a907e6c61ecp+31,   -0x1.ecc03da3f9e8fp-1,  -0x1.b2ec16p-4, INEXACT)
T(RN,   0x1.b2c19e949b33bp+31,    0x1.f10abadfcefafp-1,   0x1.bcbd2ep-3, INEXACT)
T(RN,   0x1.c863cd4069af4p+31,   -0x1.8ac213fc074dbp-1,   0x1.89c2aap-2, INEXACT)
T(RN,    0x1.515e23bef5b4p+31,   -0x1.ddc69203f88a3p-4,   0x1.4ad24ep-5, INEXACT)
T(RN,   0x1.e5cd991acf4d6p+31,   -0x1.e4ed1be33f318p-1,  -0x1.c78fdcp-4, INEXACT)
T(RN,   0x1.b2d7956dee228p+31,   -0x1.423886d2f2b96p-2,   0x1.86ce44p-5, INEXACT)
T(RN,   0x1.6aa862ac0750bp+31,    0x1.ace415bf4bb54p-1,   0x1.4524d4p-2, INEXACT)
T(RN,   0x1.88120bf1f14b4p+31,   -0x1.87008696a53abp-1,   0x1.37922ep-3, INEXACT)
T(RN,   0x1.e0ad3b5fb9bfap+31,    0x1.82124a5911f65p-1,    -0x1.1cfap-3, INEXACT)
T(RN,   0x1.143106b1b9545p+32,    0x1.c54ea46a4bafap-4,   0x1.48c768p-2, INEXACT)
T(RN,   0x1.d8ccc97e0168cp+32,   -0x1.711fdafa8162ep-2,   0x1.bd0f6cp-2, INEXACT)
T(RN,   0x1.dd23da6dd93ccp+32,   -0x1.27e8959700413p-3,   0x1.a75be2p-2, INEXACT)
T(RN,   0x1.d9bd095dcff84p+32,   -0x1.bad11e0209b65p-1,  -0x1.f493ecp-2, INEXACT)
T(RN,   0x1.7ccd8a0141edep+32,    0x1.cd13f2b11fd8bp-1,  -0x1.3d3128p-4, INEXACT)
T(RN,     0x1.019432468d9p+32,   -0x1.ac8d99c8f48b9p-1,  -0x1.077e3ap-3, INEXACT)
T(RN,   0x1.acf549a6d52f9p+32,   -0x1.8a98ff7ca3bbfp-1,  -0x1.803c84p-4, INEXACT)
T(RN,   0x1.0ddd0b4b69358p+32,   -0x1.3b4b149867808p-3,   0x1.943248p-3, INEXACT)
T(RN,   0x1.52fad0e046d78p+32,   -0x1.6ba9c7e558bd9p-1,  -0x1.46e792p-3, INEXACT)
T(RN,   0x1.bf9e42eb9e17ep+32,   -0x1.fe8a03d1911b1p-1,   0x1.457edap-3, INEXACT)
T(RN,    0x1.571d85ca2884p+33,   -0x1.d1c5f939cc8dfp-6,  -0x1.368ec6p-2, INEXACT)
T(RN,   0x1.4e1fecaeef8bbp+33,    0x1.4376d37b0214cp-1,  -0x1.9d7dc2p-3, INEXACT)
T(RN,   0x1.f2e4da878b272p+33,    0x1.e74a9d1436a67p-1,   0x1.3c311ep-2, INEXACT)
T(RN,   0x1.4a58ba1555bb9p+33,    0x1.5e0fe90d34d7ep-1,  -0x1.92a9a8p-4, INEXACT)
T(RN,   0x1.dd3913c17ca7dp+33,    0x1.ffc7d3ff22f69p-1,  -0x1.9c277cp-4, INEXACT)
T(RN,   0x1.4b670b03783b3p+33,    0x1.f47d8bd70551bp-1,  -0x1.814646p-3, INEXACT)
T(RN,   0x1.332e5bc816fa6p+33,    0x1.617e060e9ccbfp-4,   0x1.1e7f28p-2, INEXACT)
T(RN,   0x1.bbecc98e0b314p+33,   -0x1.db08e5548f79bp-1,  -0x1.fcd7b2p-2, INEXACT)
T(RN,   0x1.d3ddf7ec769f2p+33,   -0x1.e41c6cfb3141dp-4,  -0x1.2f4832p-2, INEXACT)
T(RN,   0x1.f3ed0636b274bp+33,   -0x1.cc1cfdc12f675p-1,  -0x1.db5c26p-2, INEXACT)
T(RN,   0x1.0cc0430bbdec6p+34,   -0x1.c55ac6ce76756p-1,   0x1.4cff32p-3, INEXACT)
T(RN,   0x1.47284f225b219p+34,    0x1.e2678f0073f47p-1,   0x1.47c198p-3, INEXACT)
T(RN,     0x1.7450c6751fdp+34,   -0x1.1af6e1abece64p-1,  -0x1.f049eap-2, INEXACT)
T(RN,   0x1.b2105307c57fep+34,    0x1.81f8f50421c14p-2,    0x1.5aa46p-2, INEXACT)
T(RN,   0x1.4e93752b68133p+34,    0x1.518e239f49b95p-2,   -0x1.d9b22p-4, INEXACT)
T(RN,   0x1.953b5c4bde006p+34,   -0x1.fda6a967b5297p-1,   0x1.3a428ep-2, INEXACT)
T(RN,   0x1.19f87b28449bep+34,   -0x1.ebfbd991f7b9cp-2,  -0x1.4ca246p-2, INEXACT)
T(RN,   0x1.5326d7c1d1e18p+34,   -0x1.00b0cff4fd20ap-3,   0x1.d34012p-2, INEXACT)
T(RN,   0x1.0a9cc38a94ab1p+34,    -0x1.411c527afb73p-4,  -0x1.413c14p-6, INEXACT)
T(RN,   0x1.d8710ff625ae3p+34,   -0x1.f1feb8daf0ce2p-1,   0x1.293b96p-2, INEXACT)
T(RN,   0x1.5630103d038a6p+35,   -0x1.54c8488c3f77ep-1,  -0x1.a54728p-2, INEXACT)
T(RN,   0x1.65b270b08625cp+35,   -0x1.c840c1ac9759fp-7,  -0x1.e5919cp-2, INEXACT)
T(RN,    0x1.cae3b5d9baf3p+35,   -0x1.cbd658def5835p-1,    0x1.70e0ep-7, INEXACT)
T(RN,   0x1.740f579bfd2a2p+35,    0x1.cfed7c82a8ee9p-1,      0x1.31fp-2, INEXACT)
T(RN,   0x1.e97cfd67c4f22p+35,    0x1.670943e051cebp-3,   -0x1.2bbbdp-3, INEXACT)
T(RN,   0x1.ad56f2ee04f14p+35,   -0x1.ecf867788eafbp-1,   0x1.6c5f5ep-4, INEXACT)
T(RN,   0x1.1aa644d47e304p+35,   -0x1.d18da417d6944p-2,   0x1.afbce8p-3, INEXACT)
T(RN,   0x1.e6a83413b299ep+35,    -0x1.fdcdc1ce06bfp-1,   0x1.5d283cp-4, INEXACT)
T(RN,   0x1.c540b109fab8cp+35,   -0x1.bf967fb935337p-1,  -0x1.6f1df4p-2, INEXACT)
T(RN,   0x1.5243c2b22268ap+35,    0x1.32d67176b0065p-2,   0x1.ca5d3ap-2, INEXACT)
T(RN,   0x1.cb8a896c22f07p+36,   -0x1.121ba937b5048p-3,  -0x1.7e0aacp-3, INEXACT)
T(RN,   0x1.3e7e6045823ecp+36,    0x1.4385e4e4304a4p-1,   0x1.1db4e2p-2, INEXACT)
T(RN,   0x1.8edaa290ac75dp+36,   -0x1.8963590d7dc24p-1,  -0x1.6b9deep-4, INEXACT)
T(RN,   0x1.4f55e189e0c5cp+36,    0x1.fe5985833a057p-1,   0x1.9d175cp-2, INEXACT)
T(RN,   0x1.73c57c8372e4ap+36,    0x1.a3dec199b5d91p-1,   0x1.c954ecp-4, INEXACT)
T(RN,   0x1.f7d87be90bb53p+36,    0x1.6abd58cda8999p-5,   0x1.176956p-2, INEXACT)
T(RN,        0x1.6f8226f6p+36,    0x1.06e2fd61eb86ep-1,   0x1.4c2b3ep-3, INEXACT)
T(RN,   0x1.0af5e5618e2cap+36,    -0x1.e1e066aeb8dep-1,  -0x1.4ccef6p-2, INEXACT)
T(RN,   0x1.b52ffc52f0586p+36,    0x1.869188489ce34p-1,  -0x1.c45d66p-2, INEXACT)
T(RN,    0x1.6b34e7d9dfe5p+36,   -0x1.c3200baaad7cep-1,   0x1.36f2ccp-7, INEXACT)
T(RN,   0x1.9321ce6707838p+37,   -0x1.bccb852711019p-1,   0x1.2665d4p-5, INEXACT)
T(RN,   0x1.383839c5dafd3p+37,   -0x1.2d071cd3927c4p-1,  -0x1.5eec32p-4, INEXACT)
T(RN,   0x1.953ecd1739faep+37,    0x1.7368ff98246a1p-2,   0x1.b879a6p-4, INEXACT)
T(RN,   0x1.fbdab22bde77ep+37,    0x1.73e9047aa14bep-1,   0x1.676766p-2, INEXACT)
T(RN,    0x1.a843b7916d4fp+37,    0x1.edc243a8018e5p-1,   0x1.489068p-2, INEXACT)
T(RN,   0x1.da6194e7d71cap+37,    0x1.5f843d29ac935p-2,  -0x1.4252b8p-2, INEXACT)
T(RN,   0x1.b16a3a032e5c2p+37,    0x1.56811cb133b8bp-1,  -0x1.eeb7d8p-3, INEXACT)
T(RN,   0x1.b3fc210c69ab9p+37,    0x1.83f0232e848e2p-4,    0x1.1b81ap-3, INEXACT)
T(RN,   0x1.743cdf56a60dap+37,   -0x1.be73c99d5606bp-1,   0x1.96ef26p-4, INEXACT)
T(RN,   0x1.972dac3d6c811p+37,   -0x1.fed492b14e1c8p-1,   0x1.28ec78p-3, INEXACT)
T(RN,   0x1.eae908f94091ap+38,    -0x1.e0b6268d747bp-1,  -0x1.70e134p-4, INEXACT)
T(RN,   0x1.0de1f3844cd58p+38,   -0x1.a80cb27917c65p-1,  -0x1.13ed3ap-3, INEXACT)
T(RN,    0x1.952ffa61b395p+38,    0x1.cf742d8d70b26p-4,  -0x1.53dd06p-3, INEXACT)
T(RN,   0x1.2e8d76d5654fcp+38,    0x1.2f0243c342364p-2,  -0x1.6c1136p-5, INEXACT)
T(RN,   0x1.cf803a11974dap+38,    0x1.06ef9369874f5p-1,  -0x1.9b6c1cp-2, INEXACT)
T(RN,   0x1.41062274aa448p+38,   -0x1.99f89f74dc458p-1,   0x1.51a5c8p-3, INEXACT)
T(RN,   0x1.b50047e6b391cp+38,   -0x1.a4c974b622eefp-1,   0x1.0201e4p-3, INEXACT)
T(RN,   0x1.2ebffaa013009p+38,    0x1.6d0db0eb2408cp-1,  -0x1.651aa8p-7, INEXACT)
T(RN,   0x1.c47ca32bd2de1p+38,    0x1.6bfaa39c172c5p-3,   0x1.b3dbacp-5, INEXACT)
T(RN,   0x1.08a7dcb61ae85p+38,   -0x1.b9b273fc0e3bcp-2,  -0x1.fd51fap-3, INEXACT)
T(RN,   0x1.5d753bc897c89p+39,   -0x1.74633bfc8332fp-1,   -0x1.679b2p-2, INEXACT)
T(RN,   0x1.c8cc790adfa29p+39,    0x1.d1005aabc12c6p-1,   0x1.e293fep-4, INEXACT)
T(RN,   0x1.2a73caf00a9bfp+39,   -0x1.e6c1172c7d953p-6,  -0x1.684fbcp-2, INEXACT)
T(RN,   0x1.924f485360df8p+39,   -0x1.9a81c18555935p-2,  -0x1.88e908p-3, INEXACT)
T(RN,   0x1.3879694dc4bdap+39,   -0x1.b167bb0cc0a09p-3,   0x1.66e0e4p-4, INEXACT)
T(RN,   0x1.4d953548d4ceap+39,    0x1.43b292462918dp-1,  -0x1.a6db3cp-2, INEXACT)
T(RN,   0x1.5e4d472c3dccep+39,   -0x1.40c508f01612dp-1,   0x1.dc9f82p-2, INEXACT)
T(RN,   0x1.331505bca26bcp+39,   -0x1.fe14ad3efe6fep-1,   0x1.eb3e76p-2, INEXACT)
T(RN,   0x1.3c495fe4ecc17p+39,   -0x1.5af3b7329018ap-3,   0x1.db3ab4p-4, INEXACT)
T(RN,   0x1.a2d2acc46629cp+39,    0x1.f9015fff5bd07p-2,  -0x1.f06494p-4, INEXACT)
T(RN,   0x1.8a3cc28c122cap+40,   -0x1.b5cad648f83ccp-4,  -0x1.76850ap-2, INEXACT)
T(RN,   0x1.292d37e7bb2d5p+40,    0x1.d4433442939a8p-1,   0x1.419accp-4, INEXACT)
T(RN,   0x1.ce41076e6fb0fp+40,    0x1.ef0b40c6187a5p-1,   0x1.e9727cp-2, INEXACT)
T(RN,   0x1.6157e7dba2156p+40,    0x1.b07ae4e2fd9cap-1,    -0x1.9051p-2, INEXACT)
T(RN,   0x1.ea8aedca23bb7p+40,    0x1.3e08e4b884f6fp-1,   0x1.7c510cp-4, INEXACT)
T(RN,   0x1.ea7e887d5a6a5p+40,    0x1.c386e0b51efc3p-1,   0x1.7bc7a6p-2, INEXACT)
T(RN,   0x1.bc8e447c7e1aap+40,   -0x1.ffad61f3c7746p-1,   0x1.4b1ff8p-2, INEXACT)
T(RN,   0x1.3f4351cdad401p+40,    0x1.058a9bef7f82ap-3,  -0x1.c1f018p-4, INEXACT)
T(RN,   0x1.12e471dae0b0dp+40,    0x1.81c863f8039c6p-1,  -0x1.783176p-2, INEXACT)
T(RN,   0x1.8a52af6dd50bap+40,   -0x1.6a87f4b3239a5p-1,   0x1.b8b3eap-2, INEXACT)
T(RN,   0x1.c8d836a7043e8p+41,   -0x1.b3e2eae09f57ep-1,   0x1.4e75aep-3, INEXACT)
T(RN,   0x1.2d62d0e373f0cp+41,    0x1.2f9caa8eb8ce8p-2,   0x1.a1edbcp-2, INEXACT)
T(RN,   0x1.3536257075c6fp+41,   -0x1.8a077dc486c3fp-2,   0x1.d6daccp-3, INEXACT)
T(RN,   0x1.0f15c2b55b387p+41,    0x1.5273ed574d4adp-5,  -0x1.25b488p-2, INEXACT)
T(RN,    0x1.890ead58b38bp+41,    0x1.cc57219ecc15ap-3,  -0x1.751ce8p-2, INEXACT)
T(RN,   0x1.ad4f7da7c79cdp+41,   -0x1.43024a5633386p-1,   0x1.c771bcp-2, INEXACT)
T(RN,    0x1.30eb793d6d95p+41,   -0x1.fcb5cbb1ffa01p-1,   0x1.024ca8p-2, INEXACT)
T(RN,   0x1.4047eb74edd8dp+41,    -0x1.f8d70ec4a123p-1,   -0x1.705e1p-3, INEXACT)
T(RN,   0x1.eacd40e342f3ap+41,   -0x1.a458814322071p-2,    0x1.c6ec9p-2, INEXACT)
T(RN,   0x1.ed9b02fc4416ep+41,     0x1.fffe3f652e27p-1,  -0x1.bb0106p-2, INEXACT)
T(RN,   0x1.083a536049695p+42,   -0x1.599224065e3dcp-1,   -0x1.b57bdp-6, INEXACT)
T(RN,   0x1.44e771d700a2fp+42,   -0x1.7e552aeec032fp-2,  -0x1.f6ded8p-4, INEXACT)
T(RN,   0x1.7d5267b1112a8p+42,    0x1.85eeee323746fp-1,  -0x1.f69886p-2, INEXACT)
T(RN,    0x1.16083bf1aee2p+42,   -0x1.1126ee1307bcbp-2,  -0x1.ec2c42p-2, INEXACT)
T(RN,   0x1.b6047606abcbdp+42,    0x1.b4a98ed4892a5p-2,  -0x1.969a2ep-2, INEXACT)
T(RN,   0x1.eb154b0832ffdp+42,   -0x1.b588c4f1f4492p-2,   0x1.94ba28p-4, INEXACT)
T(RN,   0x1.68025b68d39b7p+42,   -0x1.f77fafb4645cbp-1,   0x1.7222ecp-3, INEXACT)
T(RN,   0x1.9e496ac63f748p+42,   -0x1.c7860fe607411p-1,    0x1.67fb2p-3, INEXACT)
T(RN,   0x1.addef7766ea7ep+42,    0x1.e3fbc4550b112p-2,   0x1.e18a8ep-2, INEXACT)
T(RN,   0x1.fe05a5055ab8ap+42,    0x1.065b71085203ep-1,   0x1.3aaae6p-2, INEXACT)
T(RN,   0x1.003717a14503dp+43,    0x1.ff31403de67bdp-1,   0x1.87f952p-7, INEXACT)
T(RN,   0x1.218d911c54a6ep+43,    0x1.96bdd81da556ep-3,  -0x1.fcba14p-3, INEXACT)
T(RN,   0x1.35d3204773981p+43,    0x1.ef865de022638p-1,  -0x1.3cd0b8p-3, INEXACT)
T(RN,   0x1.52ef235b6d84ap+43,    0x1.2843fd4be29b2p-1,  -0x1.5e8cbcp-2, INEXACT)
T(RN,   0x1.c0cfa647ddadap+43,    0x1.ffa7617d7a28fp-2,   0x1.2f746ap-2, INEXACT)
T(RN,   0x1.abfb9dd2d6c92p+43,    0x1.a494af6cc25bep-2,  -0x1.b3f3a2p-2, INEXACT)
T(RN,   0x1.038e7a149ecc8p+43,    0x1.d22adb5197686p-1,   -0x1.d29fep-5, INEXACT)
T(RN,   0x1.8929354ebc6aap+43,     0x1.44302d6a82d4p-9,   -0x1.dd6f9p-3, INEXACT)
T(RN,   0x1.7b72419985218p+43,    0x1.1c6b8ef1fa915p-3,   0x1.d2d73ap-4, INEXACT)
T(RN,   0x1.edb305c49ad4bp+43,    0x1.fd12dd998dbebp-3,  -0x1.d50f04p-3, INEXACT)
T(RN,   0x1.30dc61aeec65bp+44,    0x1.94bb6719733c1p-4,   0x1.dfd616p-3, INEXACT)
T(RN,   0x1.6147744c653f6p+44,    0x1.36138fff1794ep-1,   0x1.d51948p-3, INEXACT)
T(RN,   0x1.b24b4281e1212p+44,   -0x1.ff987d4c5cc68p-1,   -0x1.70942p-3, INEXACT)
T(RN,   0x1.6c7c1dd3095f1p+44,     -0x1.4b674a4cc86p-1,  -0x1.c9d794p-4, INEXACT)
T(RN,   0x1.80f981c720f76p+44,    0x1.487ee0ce6dbccp-2,   0x1.31b1fap-2, INEXACT)
T(RN,   0x1.f0258f7a15df7p+44,    0x1.bf10fbd5f49f2p-1,   0x1.21f3f8p-6, INEXACT)
T(RN,   0x1.e58feb2185452p+44,    0x1.e2bc1f63c574bp-1,  -0x1.8f46cp-10, INEXACT)
T(RN,   0x1.e0bb226d96bd2p+44,   -0x1.df76647b6143ep-2,   0x1.80b79ep-4, INEXACT)
T(RN,   0x1.a50ef5a52fd34p+44,    0x1.bf201ebff2f41p-1,  -0x1.6f00b8p-3, INEXACT)
T(RN,   0x1.5484066c39968p+44,     0x1.d588723c8558p-1,   -0x1.c51efp-2, INEXACT)
T(RN,   0x1.9b26d855c5306p+45,    0x1.ede75fce4e5f1p-2,  -0x1.a4e2b6p-2, INEXACT)
T(RN,   0x1.d219b9ad8382ep+45,    0x1.661ce261079ecp-3,    0x1.35296p-6, INEXACT)
T(RN,   0x1.f403e1f3fac46p+45,    0x1.ff3d02c04f7c8p-1,     0x1.cea8p-2, INEXACT)
T(RN,   0x1.e9accfe0b03dep+45,    0x1.fa51e51a15c93p-1,  -0x1.2bce5ap-2, INEXACT)
T(RN,   0x1.f180b2bd73ce6p+45,    0x1.8b4d52bb3f0b8p-1,   0x1.4b940ap-2, INEXACT)
T(RN,   0x1.efdf663a0d006p+45,   -0x1.fdeed9fbd87aap-1,   -0x1.15a4dp-9, INEXACT)
T(RN,   0x1.e687a1538567cp+45,   -0x1.5c79ecfae2769p-1,   -0x1.e2519p-6, INEXACT)
T(RN,   0x1.6a6455684df9ep+45,    0x1.ffffaf9bf3121p-1,   0x1.0ddfdcp-4, INEXACT)
T(RN,   0x1.13904e86bb11ap+45,   -0x1.18814f89fd097p-1,  -0x1.22e758p-4, INEXACT)
T(RN,    0x1.9f65585582cbp+45,    0x1.9ca63884a32c9p-5,  -0x1.70da2ap-3, INEXACT)
T(RN,   0x1.819c05bbf36fep+46,   -0x1.93223ba440d23p-1,   0x1.f6e052p-2, INEXACT)
T(RN,   0x1.9f826ac7023bbp+46,    0x1.62bc47949bb2ap-2,  -0x1.eac342p-2, INEXACT)
T(RN,   0x1.f6907952dc33ap+46,    0x1.6fdeb3eff91d4p-6,  -0x1.578b82p-2, INEXACT)
T(RN,   0x1.4d311a9f149f3p+46,   -0x1.4af39e4a4808ap-1,  -0x1.f92cd2p-4, INEXACT)
T(RN,   0x1.b116d511c3f9ap+46,    -0x1.f007dea2f2abp-1,  -0x1.5aeafcp-7, INEXACT)
T(RN,   0x1.50082cf97cac6p+46,    0x1.84bfb4058561bp-1,  -0x1.c55f92p-2, INEXACT)
T(RN,   0x1.2f409073f59bcp+46,     0x1.4f2d5cff93a7p-1,   0x1.d0835cp-2, INEXACT)
T(RN,   0x1.bfdbbab148da6p+46,   -0x1.990c9e1f74537p-2,   0x1.f34e4ap-3, INEXACT)
T(RN,   0x1.1b5381ace55f5p+46,   -0x1.b4426bfe76ca8p-1,  -0x1.169536p-2, INEXACT)
T(RN,   0x1.56172464e6444p+46,    0x1.a51d79058ced8p-1,  -0x1.a25486p-3, INEXACT)
T(RN,   0x1.014b57aec28f3p+47,    0x1.bc2949ad2adcep-1,  -0x1.06ebccp-3, INEXACT)
T(RN,   0x1.fd18ccb54fd4ap+47,   -0x1.497b450d4336bp-1,   0x1.a8ec9ap-2, INEXACT)
T(RN,   0x1.401cb21e5e65cp+47,   -0x1.fc1d73a9b2904p-1,    0x1.92713p-3, INEXACT)
T(RN,   0x1.d4905a690fa4ep+47,    0x1.f6bbd907b4f05p-1,   0x1.65d9b8p-3, INEXACT)
T(RN,   0x1.b5516fe5409fcp+47,   -0x1.68b6e70703b21p-2,   0x1.2a930cp-3, INEXACT)
T(RN,   0x1.ffb94778d4decp+47,   -0x1.fe93c4fd70d7ap-1,    0x1.2dcd7p-2, INEXACT)
T(RN,   0x1.bd83cb7306dcdp+47,    0x1.019679b1c25cbp-1,  -0x1.617bb2p-3, INEXACT)
T(RN,   0x1.39766114bcebap+47,    0x1.e97983050b01ap-1,  -0x1.a2eb1ep-2, INEXACT)
T(RN,   0x1.305e3e0591727p+47,   -0x1.ffa5be4040defp-1,  -0x1.728eeep-2, INEXACT)
T(RN,   0x1.0688dd9063c39p+47,   -0x1.e6a60ba9bb988p-1,   0x1.3b3d62p-2, INEXACT)
T(RN,   0x1.165b656fb4f26p+48,   0x1.cc71cdecd32b8p-10,   0x1.160b44p-2, INEXACT)
T(RN,    0x1.0ac48ff39cb7p+48,    0x1.3609bdc7e7042p-1,  -0x1.44dfd8p-2, INEXACT)
T(RN,   0x1.0dc9981bd96d4p+48,   -0x1.2c68811a58326p-1,   0x1.8f9c62p-4, INEXACT)
T(RN,   0x1.55d374591602cp+48,   -0x1.fd5928c4d8a1cp-1,   0x1.308646p-3, INEXACT)
T(RN,   0x1.a4a66151b258ep+48,   -0x1.430bb2de17b96p-3,   0x1.54591ap-3, INEXACT)
T(RN,   0x1.8172e2edf0c0ap+48,    0x1.eaaa668e9bc65p-3,   0x1.eae2f8p-2, INEXACT)
T(RN,   0x1.12661db7a62a6p+48,    0x1.d1caa34b53b01p-1,   0x1.19b63cp-3, INEXACT)
T(RN,   0x1.2325876c974d3p+48,    0x1.17a32e1b836b4p-1,  -0x1.331134p-4, INEXACT)
T(RN,   0x1.da0efdd7648b6p+48,    0x1.c7ac2d48345bcp-4,     0x1.0e6fp-2, INEXACT)
T(RN,   0x1.8242b29e0dee8p+48,   -0x1.f15719cb72456p-1,  -0x1.00d198p-2, INEXACT)
T(RN,   0x1.600572c0c78b8p+49,    -0x1.e5df634ab5d8p-1,  -0x1.d2a01ep-6, INEXACT)
T(RN,   0x1.1a3f0847ebd23p+49,    0x1.2ccc2d03db8e7p-5,   0x1.cc8536p-2, INEXACT)
T(RN,   0x1.6bcc0fa447613p+49,   -0x1.ceaac673d4924p-1,   0x1.3ff386p-4, INEXACT)
T(RN,   0x1.588d15122ba55p+49,   -0x1.c06bad010f0bap-4,  -0x1.e02bbep-2, INEXACT)
T(RN,    0x1.956731bf942bp+49,   -0x1.7ef0101b3939ap-7,   0x1.45a29ep-4, INEXACT)
T(RN,   0x1.583e9f7b54caep+49,   -0x1.899335ce8edb3p-2,   0x1.6073e6p-2, INEXACT)
T(RN,   0x1.757c9bd1c1928p+49,    0x1.f3610fd547d32p-1,   -0x1.62f5ep-3, INEXACT)
T(RN,    0x1.9a35a7a48735p+49,   -0x1.8d0fdc63ccf1ep-1,  -0x1.0ddfa8p-4, INEXACT)
T(RN,   0x1.f4adc4300cd4ep+49,    0x1.0e6a27607417bp-1,  -0x1.8dd282p-4, INEXACT)
T(RN,   0x1.7cdeb80050ee7p+49,   -0x1.f11327a49e581p-5,   0x1.683c4cp-2, INEXACT)
T(RN,   0x1.69a3e0ddbae47p+50,   -0x1.bcbad93bd1396p-3,   -0x1.de8eap-3, INEXACT)
T(RN,   0x1.b63ba6d6d5fbep+50,   -0x1.777a59d2c1389p-1,  -0x1.fe1708p-2, INEXACT)
T(RN,   0x1.13236c859250ep+50,    0x1.72d9ae3048c48p-2,   -0x1.ca541p-2, INEXACT)
T(RN,   0x1.b1c135764d2f2p+50,   -0x1.71d1b575784afp-1,  -0x1.09b594p-4, INEXACT)
T(RN,   0x1.0394a7bf3b6d2p+50,    0x1.614bfa5c165d7p-1,  -0x1.47b096p-2, INEXACT)
T(RN,   0x1.1edfc6924fa43p+50,    0x1.a0fce73d33dc5p-3,  -0x1.85ac28p-2, INEXACT)
T(RN,    0x1.4e4eab91f1e3p+50,    0x1.ea49310dec5f2p-1,    0x1.915cdp-2, INEXACT)
T(RN,    0x1.f061c365f5bcp+50,   -0x1.f9a6a61a5efd1p-2,  -0x1.ed41d4p-2, INEXACT)
T(RN,    0x1.56b8576c80b1p+50,   -0x1.ef585171e59aap-2,   -0x1.38d37p-5, INEXACT)
T(RN,   0x1.5a34f267d57d5p+50,    0x1.432f12eeedb4ep-2,  -0x1.8e01b6p-2, INEXACT)
T(RN,   0x1.4de3480801bd5p+51,    0x1.c3b3910c8c977p-1,   0x1.5381f4p-2, INEXACT)
T(RN,   0x1.64dea0455d822p+51,   -0x1.ea5e30a48de43p-1,  -0x1.0b731ap-2, INEXACT)
T(RN,   0x1.766d2e49f085dp+51,    0x1.4ad15e1b0028cp-1,   0x1.6fb76ap-4, INEXACT)
T(RN,   0x1.4f0de91829f06p+51,   -0x1.202d39596214bp-2,   0x1.58bf9ap-2, INEXACT)
T(RN,    0x1.fde831881d2fp+51,   -0x1.b6674f591a349p-1,  -0x1.a4dd42p-2, INEXACT)
T(RN,   0x1.72541f83b1388p+51,    0x1.8f14a31a4f18bp-1,  -0x1.a298e2p-2, INEXACT)
T(RN,   0x1.3a285c99da577p+51,    0x1.866c424e0b573p-1,  -0x1.1f5d5cp-2, INEXACT)
T(RN,   0x1.d74f6b4712646p+51,   -0x1.c2a21db3b3d03p-1,   0x1.784bbcp-3, INEXACT)
T(RN,   0x1.0b2e3dd0c04cfp+51,   -0x1.94a9449a36ae8p-4,   0x1.6b3058p-2, INEXACT)
T(RN,   0x1.290e57927f1fep+51,   -0x1.acd9bbf55ab82p-2,   0x1.3a31dcp-2, INEXACT)
T(RN,   0x1.e2cd36ca5fb51p+52,   -0x1.f324fa04f774cp-1,   0x1.7b8b7cp-2, INEXACT)
T(RN,   0x1.9bfceea566b67p+52,   -0x1.c1727c414cf93p-1,   0x1.4e1bbap-2, INEXACT)
T(RN,   0x1.bbd61692f9212p+52,   -0x1.cde4bba1320a2p-1,  -0x1.f515a4p-4, INEXACT)
T(RN,   0x1.0165518f07292p+52,    0x1.e09960a963a75p-1,   -0x1.aade2p-5, INEXACT)
T(RN,   0x1.a6cb599e53e5ap+52,    0x1.910dbec693f98p-1,   0x1.210c4ap-4, INEXACT)
T(RN,   0x1.50cb9860c521bp+52,   -0x1.683bb00815ab6p-1,   -0x1.37694p-2, INEXACT)
T(RN,   0x1.4f324c2b823acp+52,    0x1.fea587455c842p-1,   0x1.008ffcp-3, INEXACT)
T(RN,   0x1.533d068eb06fap+52,   -0x1.0ea9a413fc056p-1,    0x1.8a5a3p-3, INEXACT)
T(RN,    0x1.bb2f74b0631ep+52,    0x1.f3b69ee36dfd3p-3,   -0x1.66fd4p-3, INEXACT)
T(RN,   0x1.43b456e809cebp+52,   -0x1.e5bc62c55a18dp-1,   0x1.c08b26p-4, INEXACT)
T(RN,   0x1.b7ae13d2a90d7p+53,   -0x1.fc77164abd596p-1,  -0x1.07c51ep-4, INEXACT)
T(RN,    0x1.169f34482b4dp+53,   -0x1.ff056159409e8p-1,  -0x1.b5763cp-3, INEXACT)
T(RN,   0x1.6f44596418d16p+53,    0x1.6043f6ab88a68p-1,   0x1.056016p-3, INEXACT)
T(RN,   0x1.30bf15ebf0affp+53,   -0x1.0d81e6fb6aa7dp-1,   0x1.efa60cp-2, INEXACT)
T(RN,   0x1.dd94b16691908p+53,    0x1.6daed47ea72f3p-2,   -0x1.21736p-8, INEXACT)
T(RN,   0x1.cb340fc952342p+53,   -0x1.a2c6b9a57221dp-1,   0x1.91c028p-2, INEXACT)
T(RN,   0x1.103ba6e2b917fp+53,   -0x1.8c3cbd845cc1cp-1,  -0x1.5b067ep-3, INEXACT)
T(RN,   0x1.eb0036b0f0334p+53,    0x1.e4c4202884e66p-4,   0x1.4d7606p-2, INEXACT)
T(RN,   0x1.ffd48eee77106p+53,   -0x1.e60f71dd9227fp-4,   0x1.c8cf46p-3, INEXACT)
T(RN,    0x1.bcc2e18f99aep+53,    0x1.f2ebc18b914ccp-1,   0x1.1d89b8p-6, INEXACT)
T(RN,   0x1.be099d0e22b19p+54,    0x1.71b3531ab1a72p-2,  -0x1.3b543cp-2, INEXACT)
T(RN,   0x1.8c7847b172104p+54,   -0x1.f687b546e8b8ap-1,  -0x1.75cdc8p-3, INEXACT)
T(RN,   0x1.c136fc11549acp+54,   -0x1.3c69ec1d8f948p-1,    0x1.6abf4p-2, INEXACT)
T(RN,   0x1.2d5be99cfbd91p+54,   -0x1.66b117a5c35e3p-2,  -0x1.def7fep-4, INEXACT)
T(RN,   0x1.6fe5ecc7790f7p+54,   -0x1.e5d7dd7352715p-1,   0x1.f1076ap-2, INEXACT)
T(RN,   0x1.a25ed9bd32cc8p+54,   -0x1.fbded38058706p-1,  -0x1.1f53d4p-2, INEXACT)
T(RN,   0x1.d4c866d797572p+54,     0x1.f9dc06b4f3e8p-1,   -0x1.57eb6p-3, INEXACT)
T(RN,   0x1.15b20b6fa8dc6p+54,    -0x1.8839ad45e2ddp-1,   0x1.69dfa6p-2, INEXACT)
T(RN,    0x1.9a82c4807da7p+54,   -0x1.1a6393bb0db6cp-1,   0x1.28f2bep-4, INEXACT)
T(RN,   0x1.bc30053af6624p+54,    0x1.b618ad498b9e7p-3,  -0x1.6e087ep-4, INEXACT)
T(RN,   0x1.12aaec38e5431p+55,   -0x1.427cf65985ba4p-3,   0x1.e9cc0ap-2, INEXACT)
T(RN,   0x1.c935f2f04adbep+55,   -0x1.b8881481babb8p-1,  -0x1.f4b908p-5, INEXACT)
T(RN,   0x1.3864bdfde6625p+55,    0x1.b1df52bdcf8a2p-1,  -0x1.d1bce4p-2, INEXACT)
T(RN,   0x1.006207bb0afabp+55,   -0x1.55f61c0a29beep-3,   0x1.13323ep-2, INEXACT)
T(RN,   0x1.250241c68e99ap+55,   -0x1.fb486a272a7aep-1,    0x1.ed104p-5, INEXACT)
T(RN,   0x1.21c28dfb3c5cap+55,   -0x1.eee4b0ec0fde2p-5,  -0x1.907a32p-3, INEXACT)
T(RN,   0x1.cd2aa84ec5442p+55,    0x1.759b2441604e9p-1,  -0x1.ca00fep-5, INEXACT)
T(RN,   0x1.fa7054cf8345bp+55,    0x1.5d4b630338a84p-1,   0x1.4a7972p-2, INEXACT)
T(RN,   0x1.b618137860fbap+55,   -0x1.56417503362edp-4,    0x1.dd676p-4, INEXACT)
T(RN,   0x1.f3130435193a4p+55,   -0x1.dcc7aaeae16c5p-1,  -0x1.a10fb4p-2, INEXACT)
T(RN,   0x1.2191ba8f96cc6p+56,   -0x1.f8baebdebbc65p-1,  -0x1.075f1ep-2, INEXACT)
T(RN,   0x1.471ba8dc6b83fp+56,   -0x1.e001172d4a3d7p-1,  -0x1.8c2e86p-6, INEXACT)
T(RN,   0x1.35b6dd32db4dbp+56,   -0x1.3578cc687adafp-1,   0x1.1accc8p-7, INEXACT)
T(RN,   0x1.13288c1008ab2p+56,     0x1.52d121f94d0ap-2,  -0x1.16eb06p-3, INEXACT)
T(RN,   0x1.023166090c1f9p+56,    0x1.596ab481bc6cbp-1,   0x1.83f4eep-2, INEXACT)
T(RN,   0x1.ff67979e3da05p+56,    0x1.fc74e0eb824f3p-1,   -0x1.36a6fp-2, INEXACT)
T(RN,   0x1.c9a7c4e000a6dp+56,   -0x1.f0e5fdd1fb14dp-1,   0x1.98aa72p-2, INEXACT)
T(RN,    0x1.6a3831e4048ap+56,    0x1.9dadc4797e86bp-1,   0x1.a03028p-4, INEXACT)
T(RN,     0x1.c139cd65af8p+56,   -0x1.fc92a2515a04cp-1,   0x1.d44bbcp-4, INEXACT)
T(RN,    0x1.e658e2b87fe8p+56,   -0x1.b6c83f7c67b91p-2,  -0x1.4bb93cp-8, INEXACT)
T(RN,    0x1.6cf9e2b28cdfp+57,   -0x1.b9243c7c0514fp-1,   0x1.9deaf2p-2, INEXACT)
T(RN,   0x1.c3690323502d6p+57,    0x1.6fb49c77e2a85p-1,   0x1.d35b54p-2, INEXACT)
T(RN,   0x1.561b0d74fb88dp+57,    0x1.65541e565b5edp-1,   0x1.a6f56cp-4, INEXACT)
T(RN,   0x1.0210b12c5e067p+57,    0x1.a5d98a7536333p-3,  -0x1.0d2c48p-3, INEXACT)
T(RN,   0x1.9bcbbea9d0b26p+57,   -0x1.7b3532472515cp-1,   0x1.a6e656p-4, INEXACT)
T(RN,   0x1.1e0a292d60204p+57,    0x1.f90ea227c6b86p-1,   0x1.f08d36p-2, INEXACT)
T(RN,    0x1.8394c6f9270ap+57,    0x1.538df8fb4e13fp-3,  -0x1.0c0c06p-2, INEXACT)
T(RN,   0x1.178cc5a817cc3p+57,   -0x1.5f09842afba5bp-2,  -0x1.1b2cccp-2, INEXACT)
T(RN,   0x1.5ed4808b912aep+57,    0x1.b3552aa795a48p-1,  -0x1.535e26p-4, INEXACT)
T(RN,    0x1.e25a6f736dfdp+57,   -0x1.11c8152e9efcfp-1,  -0x1.b17634p-2, INEXACT)
T(RN,   0x1.2b3a2e2ffd636p+58,    -0x1.14eed7c5d22ap-2,   0x1.ba8576p-2, INEXACT)
T(RN,   0x1.7529f03a358c2p+58,    0x1.8bfa90dd5be2bp-1,   0x1.1b40dcp-2, INEXACT)
T(RN,    0x1.65ca6ea71304p+58,    0x1.36719a8a88db4p-3,  -0x1.f51982p-2, INEXACT)
T(RN,   0x1.f2495b0be8db5p+58,   -0x1.80c4b0027b489p-1,   -0x1.56151p-3, INEXACT)
T(RN,   0x1.67c90444ce092p+58,   -0x1.85fcaec683a89p-2,  -0x1.9cff34p-3, INEXACT)
T(RN,   0x1.e918fde0d4008p+58,    0x1.a7733f540201ep-6,   -0x1.7c0dap-3, INEXACT)
T(RN,   0x1.072145c0bcec2p+58,    0x1.ffc072996aedcp-1,  -0x1.2e94dap-3, INEXACT)
T(RN,   0x1.2df190f840d59p+58,   -0x1.07bdb1a121981p-5,   -0x1.2ab8dp-3, INEXACT)
T(RN,   0x1.d2aef8975d79ep+58,   -0x1.aab4a712163b6p-3,   0x1.fed97ep-2, INEXACT)
T(RN,   0x1.3c0f3a33f6e94p+58,   -0x1.0f2babb0577b3p-2,  -0x1.8a4456p-2, INEXACT)
T(RN,   0x1.b8a9b8ec7cd64p+59,    0x1.bc3a13cad164bp-5,   0x1.574eb6p-3, INEXACT)
T(RN,   0x1.a2821d3b28e1ap+59,    0x1.f97d6050dd5d4p-1,    0x1.f6d4ap-5, INEXACT)
T(RN,   0x1.e05178e242a42p+59,   -0x1.f4e41840ff479p-1,   0x1.1ce2bep-5, INEXACT)
T(RN,   0x1.8ae5cd3b9906ap+59,   -0x1.aa84577a15a26p-1,  -0x1.37113cp-3, INEXACT)
T(RN,   0x1.850c99665f678p+59,    0x1.1df375383c229p-2,   0x1.0b4c04p-3, INEXACT)
T(RN,   0x1.7d5abfb55bff9p+59,    0x1.73f7dd4b4f3cep-6,   0x1.1af7bcp-4, INEXACT)
T(RN,   0x1.39e932f138792p+59,    0x1.599ba8095cd3dp-2,   0x1.d01332p-2, INEXACT)
T(RN,   0x1.a3d3c3971556fp+59,   -0x1.9fc61ac923647p-1,  -0x1.369e7ep-2, INEXACT)
T(RN,   0x1.7ba33ffd481dbp+59,    0x1.df2a7cc20398ep-3,    0x1.98fbcp-2, INEXACT)
T(RN,   0x1.7ed24723de9dep+59,   -0x1.7e5889f8ad81ap-1,   0x1.2cbaacp-8, INEXACT)
T(RN,   0x1.8c7b94b060169p+60,   -0x1.fec473519676fp-1,   0x1.362d78p-2, INEXACT)
T(RN,    0x1.99f62b6784c6p+60,    0x1.7bcc37a4f309ep-2,  -0x1.7bc2bcp-2, INEXACT)
T(RN,   0x1.ac04913050eeap+60,    0x1.6577fecd806adp-2,   0x1.a03564p-4, INEXACT)
T(RN,   0x1.4f466d4570cd6p+60,    0x1.a67c5ceb98783p-1,  -0x1.d4cbcap-2, INEXACT)
T(RN,   0x1.7cfe590b18b4ep+60,    0x1.553aeba8563f6p-1,   0x1.a2dc4ep-2, INEXACT)
T(RN,   0x1.86838069eba47p+60,    0x1.bb324aedeed87p-5,  -0x1.c13006p-3, INEXACT)
T(RN,   0x1.a6c9531f13082p+60,   -0x1.bf285a9139f1bp-7,  -0x1.4f3d42p-3, INEXACT)
T(RN,   0x1.cbc7d14be7a1cp+60,    0x1.cd5c34a9934a1p-1,  -0x1.d5f5aap-4, INEXACT)
T(RN,   0x1.f660832b81a2fp+60,    0x1.1954913506609p-1,   0x1.dfcab6p-3, INEXACT)
T(RN,   0x1.ffd58f2b39509p+60,     0x1.e3562a90fbb1p-1,   0x1.e5ace8p-2, INEXACT)
T(RN,   0x1.fe7976849f47ap+61,   -0x1.54cde05bc6374p-1,  -0x1.ec2f4cp-2, INEXACT)
T(RN,   0x1.b53bb56d47928p+61,   -0x1.530a8cc705eaep-1,   -0x1.8a1dfp-2, INEXACT)
T(RN,   0x1.6cfc07fa74029p+61,    0x1.dfce3513f3d48p-1,  -0x1.fca9f8p-8, INEXACT)
T(RN,   0x1.5051d1546db9bp+61,   -0x1.c1114dc3dcb0bp-1,   0x1.dccc3cp-4, INEXACT)
T(RN,   0x1.12db385c7a24fp+61,    0x1.a7f9d1c478979p-1,   0x1.02c226p-2, INEXACT)
T(RN,   0x1.2c9ea0bccd1d2p+61,    0x1.18a593d16e974p-3,   0x1.7e8d2cp-2, INEXACT)
T(RN,   0x1.e2c43f53139dfp+61,   -0x1.2bcc730a79989p-6,    0x1.a22d9p-2, INEXACT)
T(RN,   0x1.4f37c04e4283bp+61,   -0x1.cb49fa76b01e7p-2,  -0x1.159c18p-4, INEXACT)
T(RN,   0x1.b953d6a5f2c8bp+61,    0x1.da86ed3b44915p-1,   0x1.679098p-4, INEXACT)
T(RN,   0x1.44f5aa8348fb8p+61,   -0x1.7e89ad4e8a9c4p-1,  -0x1.f5bab2p-3, INEXACT)
T(RN,   0x1.232a08d7fd7b9p+62,    0x1.b13ffbfb9a281p-1,   0x1.8dacd4p-2, INEXACT)
T(RN,   0x1.01f2250b704a9p+62,    0x1.dc03a498f21f6p-1,  -0x1.3c2b18p-2, INEXACT)
T(RN,   0x1.c5f024078ba52p+62,   -0x1.b8edc4aeb1a59p-1,   0x1.5e1944p-3, INEXACT)
T(RN,   0x1.52e374da9f3f6p+62,   -0x1.ff6e1df9a1624p-1,  -0x1.1093cep-2, INEXACT)
T(RN,   0x1.c1c06c15cc18bp+62,   -0x1.f290598aa5e01p-1,    0x1.b8742p-2, INEXACT)
T(RN,   0x1.6dfe21d3c61e9p+62,   -0x1.fe37c9efff6acp-1,  -0x1.d795e8p-2, INEXACT)
T(RN,   0x1.8425f7788f3d4p+62,    0x1.30f493dbab692p-3,  -0x1.d292d4p-4, INEXACT)
T(RN,   0x1.55333a628e5e5p+62,    -0x1.623ae00a786bp-1,   0x1.b840cap-2, INEXACT)
T(RN,   0x1.8b9c9680c35fap+62,   -0x1.63a8b3d4bb764p-3,   0x1.5cf99ap-5, INEXACT)
T(RN,   0x1.6774376b2db1ap+62,   -0x1.d7e02410841fap-1,  -0x1.a83fbap-2, INEXACT)
T(RN,   0x1.28d84b9f7bd7bp+63,    0x1.fdb22e972c606p-1,   -0x1.0c645p-2, INEXACT)
T(RN,   0x1.05f0bda4def7fp+63,    0x1.b8199dedae2b2p-2,  -0x1.ee3b1ep-2, INEXACT)
T(RN,   0x1.114dd8b94c721p+63,   -0x1.6d866d8376b54p-1,  -0x1.c62c74p-2, INEXACT)
T(RN,   0x1.3fa37599f32dcp+63,    0x1.2793cc5dd6942p-2,  -0x1.06f9f4p-2, INEXACT)
T(RN,   0x1.bbc0283d46934p+63,   -0x1.1a173792c71bfp-3,   0x1.2ccaa6p-2, INEXACT)
T(RN,   0x1.614fb5b9adc84p+63,   -0x1.12e6df7d7fb93p-1,  -0x1.e3b762p-3, INEXACT)
T(RN,   0x1.d06125699176ep+63,   -0x1.5c379d56ff1a8p-2,   0x1.2db632p-2, INEXACT)
T(RN,   0x1.f2010b8004404p+63,    0x1.249ceeea23d69p-1,   0x1.0c57e8p-8, INEXACT)
T(RN,   0x1.db9541966911fp+63,    0x1.f5c9cdca0e9c6p-1,  -0x1.025438p-3, INEXACT)
T(RN,   0x1.9c6f484328b66p+63,    0x1.df29e327dcaadp-2,  -0x1.5c047ap-2, INEXACT)
T(RN,   0x1.108078b5d2e82p+64,   -0x1.e0660a5a164acp-1,   0x1.8e37a2p-2, INEXACT)
T(RN,   0x1.91f5cfbc35a5ap+64,    0x1.fee50c52629e4p-1,  -0x1.f5e272p-4, INEXACT)
T(RN,   0x1.457b18f0beaa4p+64,   -0x1.86251437f8591p-2,   0x1.03ac18p-6, INEXACT)
T(RN,   0x1.5cbca57da715fp+64,    0x1.abc74b7818535p-1,  -0x1.ca8296p-2, INEXACT)
T(RN,   0x1.7029a4e4eeb21p+64,   -0x1.9b5c80f174ea2p-1,  -0x1.9b8aa2p-4, INEXACT)
T(RN,   0x1.01158e9ad0424p+64,    0x1.213a0da211f1ap-1,   0x1.2e9224p-2, INEXACT)
T(RN,    0x1.31629663af41p+64,   -0x1.71ac8bfe102f8p-4,   0x1.7aa108p-2, INEXACT)
T(RN,    0x1.cdb3840dbdf7p+64,   -0x1.d2ce911ca93fdp-1,  -0x1.0d82cap-3, INEXACT)
T(RN,   0x1.1517691852f76p+64,   -0x1.d4903574439d6p-2,   0x1.5af9c4p-3, INEXACT)
T(RN,   0x1.f0a988c3ea348p+64,   -0x1.a6236c2bc11abp-1,   -0x1.852e3p-5, INEXACT)
T(RN,   0x1.bf7111912b22ap+65,   -0x1.f4899997eafabp-1,  -0x1.a47e92p-5, INEXACT)
T(RN,   0x1.bf939d692fbbbp+65,    0x1.6bd489e91d042p-2,  -0x1.950be2p-5, INEXACT)
T(RN,   0x1.9c03bfe2d6477p+65,    0x1.fdb4eab4574f2p-1,   -0x1.9fdbap-2, INEXACT)
T(RN,   0x1.7b7fa42d31f25p+65,   -0x1.cece205bdd77fp-1,   0x1.bdfceap-2, INEXACT)
T(RN,    0x1.5ca2bd609affp+65,    0x1.ca9a4bd0be355p-1,   0x1.cce852p-3, INEXACT)
T(RN,   0x1.cb053faf1135cp+65,    0x1.dd0e54d8ad86cp-1,  -0x1.521ebep-3, INEXACT)
T(RN,   0x1.0e547c11ffb0ep+65,    0x1.0c68cdcfbc653p-3,     -0x1.d4ap-3, INEXACT)
T(RN,    0x1.f5d8ac9913bfp+65,   -0x1.3b6c4b3d8079cp-1,   0x1.e6d1a8p-2, INEXACT)
T(RN,    0x1.283f9f621ef3p+65,    0x1.ad4737d7406fbp-1,   0x1.db28ecp-3, INEXACT)
T(RN,   0x1.dcdba512ce7cdp+65,    0x1.95fb50c3dfb5bp-1,  -0x1.f20f48p-2, INEXACT)
T(RN,   0x1.544bfe777fa01p+66,    0x1.9503300e0c1ccp-1,   0x1.c52e98p-4, INEXACT)
T(RN,   0x1.3bf750168b21fp+66,   -0x1.b60a4258871eap-1,  -0x1.f2cb3cp-5, INEXACT)
T(RN,   0x1.965b27c5b3cacp+66,   -0x1.cda29686f53b7p-1,   0x1.dd62dep-6, INEXACT)
T(RN,   0x1.eb93dca2bb365p+66,   -0x1.5e14dd740664ep-4,   0x1.71206ap-3, INEXACT)
T(RN,   0x1.def2e6f770b14p+66,   -0x1.180180a157408p-1,  -0x1.4089e6p-3, INEXACT)
T(RN,   0x1.9f3563d8158acp+66,   -0x1.ace33a2727aa1p-1,   0x1.28dbe4p-3, INEXACT)
T(RN,   0x1.34b8effca78c6p+66,   -0x1.fc2379d128317p-1,  -0x1.2d02dcp-5, INEXACT)
T(RN,   0x1.f162ef09bb1f5p+66,    0x1.4b0272724823bp-1,   0x1.a470d2p-5, INEXACT)
T(RN,   0x1.4d757fe6f1782p+66,    0x1.d42ef278277cbp-4,  -0x1.33f936p-4, INEXACT)
T(RN,   0x1.3c3644cd7f9acp+66,   -0x1.8f448ec959d5ep-3,  -0x1.4cd356p-2, INEXACT)
T(RN,   0x1.bc42e8c6d359ep+67,   -0x1.5aa10c1e4416ep-1,  -0x1.a0b4bcp-3, INEXACT)
T(RN,   0x1.eaf0c9f62b933p+67,    0x1.e8b5a74819f4fp-1,  -0x1.021898p-3, INEXACT)
T(RN,   0x1.0b07855f9ce8fp+67,    0x1.65c75064226f8p-2,   0x1.68c72ap-2, INEXACT)
T(RN,   0x1.3a8701cae93e4p+67,   -0x1.b7572649a89d3p-2,  -0x1.218416p-2, INEXACT)
T(RN,   0x1.1e175c0924db8p+67,    0x1.0e404d6e524d5p-2,  -0x1.adf5a8p-3, INEXACT)
T(RN,   0x1.e63c7115f275cp+67,    0x1.fbf42d2da4cd6p-1,  -0x1.40c118p-6, INEXACT)
T(RN,   0x1.2142e18d1c841p+67,    0x1.1e04ef3bcf718p-2,  -0x1.634566p-2, INEXACT)
T(RN,   0x1.0db1e33817e2dp+67,   -0x1.d07e0feb04771p-1,  -0x1.5793bap-2, INEXACT)
T(RN,   0x1.412b4009d3ef5p+67,    0x1.726132b63765cp-1,  -0x1.db0e28p-2, INEXACT)
T(RN,   0x1.3a29bdc65beb1p+67,    0x1.f81b437b17c38p-1,   0x1.5ca998p-3, INEXACT)
T(RN,   0x1.31ed56cf64ab7p+68,     0x1.ffe64697d743p-1,    0x1.028b7p-2, INEXACT)
T(RN,   0x1.64a6a0f042b26p+68,   -0x1.eb47cd4e16fbbp-1,   0x1.c0628ap-2, INEXACT)
T(RN,    0x1.1973cd945912p+68,   -0x1.eb37e9dd7fb3ap-1,   0x1.90b8b6p-3, INEXACT)
T(RN,   0x1.4b0945189dc84p+68,   -0x1.e41ea111db41ap-1,  -0x1.98d0d8p-2, INEXACT)
T(RN,   0x1.25b41fbcf7f97p+68,    0x1.c3e93c1ed34fdp-1,   0x1.9315bcp-2, INEXACT)
T(RN,   0x1.c11f376e43eb2p+68,   -0x1.b224fbae6f3b6p-1,   0x1.32e958p-3, INEXACT)
T(RN,   0x1.14a9dc68a71abp+68,    -0x1.2c8a135349bdp-2,   0x1.c80328p-2, INEXACT)
T(RN,   0x1.d73fbec31a222p+68,   -0x1.ec13bed40400bp-1,   0x1.9eaea4p-2, INEXACT)
T(RN,   0x1.05fa474bc1468p+68,    -0x1.732031a7d4b2p-2,   0x1.845f6ep-2, INEXACT)
T(RN,   0x1.8390793f7c4a5p+68,   -0x1.b9050eb77d40cp-1,  -0x1.b9cfb6p-7, INEXACT)
T(RN,   0x1.fceb77fc6a182p+69,   -0x1.9293a710d53f2p-2,   0x1.d4301ep-2, INEXACT)
T(RN,   0x1.9f80bbfbe862ap+69,   -0x1.e2b660e8a3373p-1,  -0x1.16860ep-2, INEXACT)
T(RN,   0x1.8815e144e43e8p+69,   -0x1.9396133caa821p-1,   0x1.3e1566p-2, INEXACT)
T(RN,   0x1.dc62aec54eb42p+69,    0x1.2f4f0addacd51p-2,   0x1.22e772p-4, INEXACT)
T(RN,   0x1.4d7d8be6920bfp+69,   -0x1.9b2ccf10aee55p-1,   0x1.35a274p-3, INEXACT)
T(RN,   0x1.4c9875876775ap+69,     0x1.3fde80cb6a08p-1,  -0x1.ec1efap-2, INEXACT)
T(RN,   0x1.89e2324d2bb2ep+69,   -0x1.ed3cae77d3923p-1,  -0x1.db39e4p-3, INEXACT)
T(RN,   0x1.ee6ba7fb05a8cp+69,    0x1.6715060ca049bp-2,  -0x1.f819f8p-2, INEXACT)
T(RN,   0x1.8c8dc67409b07p+69,   -0x1.a049045fc9835p-4,    0x1.e223cp-2, INEXACT)
T(RN,   0x1.44af7519c8b33p+69,   -0x1.f4bbe09e7d102p-1,   0x1.242e82p-2, INEXACT)
T(RN,   0x1.210348ab5bc59p+70,    0x1.4a5e2340c07c7p-1,  -0x1.77aba4p-3, INEXACT)
T(RN,   0x1.bda4f1d4ba0b9p+70,    0x1.7523f4b81c7eep-2,   0x1.f51858p-2, INEXACT)
T(RN,   0x1.ba2f0e19f8ad2p+70,   -0x1.fb92e0f3a404bp-1,   0x1.3d19d6p-2, INEXACT)
T(RN,   0x1.7f801e3b817bep+70,    0x1.e7bb2cbe1d15ep-5,  -0x1.a7ef62p-2, INEXACT)
T(RN,   0x1.23793268ef0d3p+70,    0x1.b234591e1961bp-1,   0x1.281d2cp-3, INEXACT)
T(RN,   0x1.5004a3e931422p+70,    0x1.e0943ef95f907p-1,  -0x1.b85ffcp-3, INEXACT)
T(RN,   0x1.4719c91377e1ep+70,    0x1.e63fc3791577cp-1,  -0x1.8e6512p-5, INEXACT)
T(RN,   0x1.baa0a0a6765ccp+70,   -0x1.eacb868874bc3p-1,   -0x1.34c88p-3, INEXACT)
T(RN,    0x1.a11207290f8bp+70,   -0x1.34ab3b7c28b6ep-1,   0x1.56eaaap-2, INEXACT)
T(RN,   0x1.7678f6599fc15p+70,     0x1.768274bbc9f6p-1,  -0x1.29fa1ep-5, INEXACT)
T(RN,   0x1.54ab169d83784p+71,   -0x1.fda14cfed8dd1p-1,  -0x1.e6bcd8p-2, INEXACT)
T(RN,   0x1.a02f363c62d74p+71,   -0x1.bc403339a480ep-1,   0x1.43483cp-3, INEXACT)
T(RN,   0x1.48eb4d5f582eap+71,    0x1.888a6f6200d28p-1,    0x1.1ccedp-3, INEXACT)
T(RN,   0x1.2228a9f677931p+71,    -0x1.a06ab2b5bf06p-2,  -0x1.83279ap-3, INEXACT)
T(RN,   0x1.fe05a6cd46b84p+71,    0x1.ff73cb4dcecfap-1,   0x1.9d2492p-5, INEXACT)
T(RN,   0x1.00ac03f82107fp+71,   -0x1.fdfc79f6dc857p-1,    -0x1.46b5p-2, INEXACT)
T(RN,   0x1.1f26a99a320c5p+71,    0x1.e9c2d3ab61fb2p-1,  -0x1.da42d8p-4, INEXACT)
T(RN,   0x1.7cfbe4faa65e2p+71,   -0x1.d4f06ae896257p-1,   0x1.89214ap-2, INEXACT)
T(RN,   0x1.e566620dff2d2p+71,   -0x1.f854bee99141dp-1,   0x1.e40b7ap-6, INEXACT)
T(RN,   0x1.396477a7e6e49p+71,    0x1.58836125ec52cp-2,  -0x1.5af3c2p-3, INEXACT)
T(RN,   0x1.983230af9b469p+72,    0x1.777d509e977bap-4,  -0x1.931eb6p-4, INEXACT)
T(RN,   0x1.bd6cc375af844p+72,   -0x1.6a46a1ee86c92p-1,   0x1.1b2ee4p-3, INEXACT)
T(RN,   0x1.5125780b6abb3p+72,    0x1.776622429d837p-1,   0x1.eff374p-3, INEXACT)
T(RN,   0x1.5c9fcc4fa4878p+72,   -0x1.d7f6d7c529486p-1,  -0x1.205dfap-3, INEXACT)
T(RN,   0x1.09e4af09f2529p+72,    -0x1.5e4198c4df4dp-1,   -0x1.e2973p-3, INEXACT)
T(RN,   0x1.a11744ae35348p+72,    0x1.d20bef8d46048p-1,   0x1.a8cc5ep-2, INEXACT)
T(RN,   0x1.ce8e215e86f22p+72,    0x1.90c62d3ef81d3p-2,  -0x1.59d31cp-3, INEXACT)
T(RN,   0x1.281a5d5c8e858p+72,   -0x1.9a3c2cb7368a1p-1,  -0x1.591886p-2, INEXACT)
T(RN,   0x1.4e651a620187ep+72,    0x1.dd6cfbbe6508ap-1,  -0x1.31eed8p-2, INEXACT)
T(RN,   0x1.b16a40b0e35acp+72,    0x1.a6ea1cdb6bc4ap-2,  -0x1.1ddc68p-2, INEXACT)
T(RN,   0x1.b5b2975222baep+73,    0x1.fbb7d6ad336ccp-1,   0x1.539922p-3, INEXACT)
T(RN,   0x1.eb355de1fc9cfp+73,   -0x1.af59922f10482p-1,  -0x1.ed9012p-2, INEXACT)
T(RN,   0x1.a211c876ba41ap+73,   -0x1.f7244f0b447f9p-1,  -0x1.b7d214p-4, INEXACT)
T(RN,   0x1.1049e3e2d0d6fp+73,    0x1.4f81e0090cad3p-1,  -0x1.3f8034p-2, INEXACT)
T(RN,   0x1.91f3f22d29031p+73,   -0x1.e19892e5902fep-2,  -0x1.52a48ep-4, INEXACT)
T(RN,   0x1.caf703d0ecbe6p+73,   -0x1.fffe42c03d8cap-1,   -0x1.3ff3cp-6, INEXACT)
T(RN,   0x1.67ab1c80aa617p+73,    0x1.875f32798629ap-1,  -0x1.e625c4p-5, INEXACT)
T(RN,   0x1.3d6f65aed1255p+73,    0x1.1b072ab9aa55bp-4,  -0x1.990c5ap-3, INEXACT)
T(RN,   0x1.0d6e1bf94c2cdp+73,   -0x1.f4e25bfb4d513p-1,  -0x1.47e2e6p-2, INEXACT)
T(RN,   0x1.de93359225ef8p+73,    0x1.c2007081f5fa1p-2,  -0x1.7fe976p-5, INEXACT)
T(RN,   0x1.13b07469aee54p+74,   -0x1.54e51c578ae55p-3,   0x1.70790ap-5, INEXACT)
T(RN,   0x1.de568415c8433p+74,    0x1.e0b0ac69697ffp-2,  -0x1.b8df12p-7, INEXACT)
T(RN,     0x1.82546eeadecp+74,   -0x1.24e7e440140e1p-1,    0x1.8a794p-6, INEXACT)
T(RN,   0x1.ec93b4476b07cp+74,   -0x1.f5dd9fc73492dp-1,    0x1.7882dp-2, INEXACT)
T(RN,   0x1.7e7e7f90c7f14p+74,    0x1.feda6decc53ecp-1,  -0x1.491d4cp-7, INEXACT)
T(RN,   0x1.0f3c3c673f4f8p+74,    0x1.8504f5f6110aep-1,   0x1.746062p-3, INEXACT)
T(RN,   0x1.677e854b743f2p+74,    0x1.fffe8e852feabp-1,   0x1.c05d68p-8, INEXACT)
T(RN,   0x1.cd6d800a12e7ep+74,    0x1.fc154ff982808p-1,  -0x1.bb1aa2p-3, INEXACT)
T(RN,   0x1.1f9bbd7d51e8ep+74,   -0x1.edc6dee5fee8dp-1,   0x1.f1a0c2p-2, INEXACT)
T(RN,   0x1.84b96732bb277p+74,   -0x1.e6fabdc18e213p-1,   0x1.6f46dap-3, INEXACT)
T(RN,   0x1.266a14bd7243bp+75,   -0x1.afca8a0bebb49p-2,   0x1.dcc16ap-2, INEXACT)
T(RN,   0x1.6d16ebf073a6ep+75,    0x1.7b5688681bccdp-1,  -0x1.c01c6cp-4, INEXACT)
T(RN,   0x1.360c96e8178b2p+75,   -0x1.6c4bcf91db764p-3,   0x1.78b678p-3, INEXACT)
T(RN,   0x1.1032bec2c0b5cp+75,    0x1.9584cdad3a0cbp-1,   0x1.9a8c2ap-2, INEXACT)
T(RN,   0x1.a22a36925ba62p+75,    0x1.9715eb2b5f026p-1,  -0x1.5f26fcp-3, INEXACT)
T(RN,   0x1.54721b7b74944p+75,    0x1.fffa51689ee7bp-1,   0x1.fe6a64p-2, INEXACT)
T(RN,   0x1.02a288da70a2ap+75,    0x1.e87547cccbd7ep-1,  -0x1.2ec1d4p-2, INEXACT)
T(RN,   0x1.045d56b365d28p+75,    0x1.f7ac2cf113f33p-1,    0x1.c9e83p-4, INEXACT)
T(RN,   0x1.9872932883ffap+75,   -0x1.990b698f44f4cp-1,  -0x1.114c92p-3, INEXACT)
T(RN,    0x1.412c979ac16ap+75,    0x1.22cb81e9e90dbp-3,   0x1.aa17d2p-2, INEXACT)
T(RN,   0x1.9245a99d6b131p+76,    0x1.de2a5a5953d0cp-3,     0x1.5abep-3, INEXACT)
T(RN,   0x1.c0c4fd6595374p+76,     0x1.e668c51f6fe5p-1,  -0x1.81f2a8p-3, INEXACT)
T(RN,   0x1.f0044e0392d5cp+76,   -0x1.fff79d2daf15ap-1,   0x1.1ba008p-3, INEXACT)
T(RN,   0x1.5de54ac2163c6p+76,    -0x1.813c73c60f9dp-2,  -0x1.b7eb3ap-2, INEXACT)
T(RN,   0x1.86f93a45c382ep+76,    0x1.333e7088be2dep-3,   0x1.8c3362p-5, INEXACT)
T(RN,    0x1.d917414fab8ep+76,    0x1.52312be32cc75p-2,  -0x1.0f6aa2p-5, INEXACT)
T(RN,   0x1.f6f999c833e22p+76,    0x1.7ab7c9a049435p-1,  -0x1.6de176p-2, INEXACT)
T(RN,   0x1.44324099efc4cp+76,   -0x1.77fe1d7def6e8p-1,   0x1.f89fccp-8, INEXACT)
T(RN,   0x1.039a400665ce1p+76,    0x1.cf5ba890addfep-2,   -0x1.1d36ap-3, INEXACT)
T(RN,   0x1.8e3b695ae1477p+76,   -0x1.f8831cf334e4dp-1,   0x1.45a8b6p-2, INEXACT)
T(RN,   0x1.7824844dd8c5ap+77,   -0x1.d3f7eea4312a3p-1,  -0x1.da4326p-6, INEXACT)
T(RN,   0x1.ff67a6af94675p+77,    0x1.8849fff75ce03p-2,  -0x1.184148p-8, INEXACT)
T(RN,   0x1.cd850038246b2p+77,   -0x1.33beb5d7c8e05p-2,  -0x1.10d3c4p-2, INEXACT)
T(RN,   0x1.26bf6d94ee63ap+77,   -0x1.fff32e6763eccp-1,  -0x1.62566cp-3, INEXACT)
T(RN,   0x1.5149a03358bc5p+77,    0x1.28dccab0c4a61p-2,    0x1.25fbdp-2, INEXACT)
T(RN,   0x1.a2cd312df9918p+77,    0x1.cd3a1edb3cc7dp-2,    0x1.c1be5p-2, INEXACT)
T(RN,   0x1.223cb73f44b4fp+77,    0x1.39a0bdde819ebp-2,  -0x1.caac38p-3, INEXACT)
T(RN,   0x1.22bd2cf88fdd7p+77,    0x1.02b33b3be2a86p-1,  -0x1.b9eec8p-7, INEXACT)
T(RN,   0x1.15e092b11bfbbp+77,   -0x1.8982a8fc7ad05p-1,  -0x1.8c5194p-5, INEXACT)
T(RN,    0x1.89bb5d9d4586p+77,    0x1.d38e8f12b4ec8p-1,  -0x1.950996p-5, INEXACT)
T(RN,   0x1.f8a5f5cd629cap+78,    0x1.84de6406dabddp-1,  -0x1.8d2228p-7, INEXACT)
T(RN,   0x1.23d2c6b8e2f08p+78,     0x1.7987734a1affp-5,   0x1.1f4916p-2, INEXACT)
T(RN,   0x1.4a1ef4c42587cp+78,    0x1.070713a002c1bp-3,  -0x1.d16faep-4, INEXACT)
T(RN,   0x1.0bd28a2b8d0e1p+78,    0x1.24ea7e765c912p-2,  -0x1.2da9a6p-2, INEXACT)
T(RN,   0x1.4d76d1f21cf86p+78,    0x1.fad405e264346p-2,    0x1.2b5e9p-2, INEXACT)
T(RN,   0x1.92e7a02271fdep+78,   -0x1.c0aa86caf7e67p-1,   0x1.edcb5cp-2, INEXACT)
T(RN,   0x1.4bdc3215c0a38p+78,   -0x1.2480a15fb63f2p-1,  -0x1.a7a7eap-2, INEXACT)
T(RN,   0x1.3fd75b0f1ceb5p+78,   -0x1.ec9a62651570dp-2,  -0x1.fdf772p-4, INEXACT)
T(RN,   0x1.0b7acba6fd003p+78,   -0x1.e5f0381eac67ap-1,  -0x1.90b662p-3, INEXACT)
T(RN,   0x1.cbd79d1e80496p+78,     0x1.8d7955695c81p-1,   0x1.31c3fep-3, INEXACT)
T(RN,   0x1.03a7174e2f07dp+79,    0x1.25e9db2db546fp-1,  -0x1.bd361ap-2, INEXACT)
T(RN,   0x1.d966c312be9d4p+79,   -0x1.a83dce237f62cp-3,   0x1.622d92p-5, INEXACT)
T(RN,   0x1.5bb5967402f9cp+79,    0x1.fa865b0d99497p-1,   0x1.f1bc1ap-2, INEXACT)
T(RN,   0x1.f6c1d236a6cc7p+79,    0x1.c96d5afbff59ap-5,   0x1.a3fbb6p-2, INEXACT)
T(RN,   0x1.f57aacd8c2d12p+79,    0x1.8d43a7f9d0faap-2,  -0x1.889ceap-3, INEXACT)
T(RN,   0x1.0bf0760183014p+79,   -0x1.e4ed983ecefaep-1,   0x1.4ceaa2p-5, INEXACT)
T(RN,   0x1.fa2b98297ba29p+79,    0x1.f3deb35a331a9p-1,  -0x1.fbfee6p-5, INEXACT)
T(RN,   0x1.149bf70ab72a5p+79,    0x1.3ec95ebc9b7e5p-2,    0x1.2d2c5p-3, INEXACT)
T(RN,   0x1.46d094c39c7ebp+79,   -0x1.2863e44105a9cp-1,  -0x1.90cff4p-2, INEXACT)
T(RN,   0x1.f3c1e07946e73p+79,   -0x1.e0585319b0433p-1,   0x1.00431ep-5, INEXACT)
T(RN,   0x1.fb7eccfbed09ap+80,    0x1.feaded92ed90bp-1,   0x1.9fdf4ap-3, INEXACT)
T(RN,   0x1.161dc537d06e1p+80,    0x1.7b5e3cd9c7bcep-6,   0x1.7f2842p-2, INEXACT)
T(RN,    0x1.3c2f30e2fcddp+80,    0x1.ffff8f4f42631p-1,   -0x1.9ec7ep-3, INEXACT)
T(RN,   0x1.eb7fea66be494p+80,   -0x1.e2f80c1262a6cp-1,  -0x1.2ecb5cp-3, INEXACT)
T(RN,   0x1.c136819eb3ca4p+80,   -0x1.0af36be537ac1p-1,   -0x1.ba695p-6, INEXACT)
T(RN,   0x1.0df4ee012826cp+80,   -0x1.61f522e0f783ep-2,   0x1.26b59ep-2, INEXACT)
T(RN,   0x1.73633a82f658cp+80,   -0x1.f0f0ca15ae816p-1,   0x1.cba5c6p-2, INEXACT)
T(RN,   0x1.c3e494ff86c28p+80,    0x1.b883718576fdap-1,   0x1.c9620ap-2, INEXACT)
T(RN,   0x1.082771225dcb3p+80,   -0x1.3088dd025876cp-2,   0x1.a75e82p-2, INEXACT)
T(RN,   0x1.6cebfda099993p+80,   -0x1.b29f318eae873p-2,   0x1.918052p-4, INEXACT)
T(RN,   0x1.330d55dcf7354p+81,   -0x1.eec5a1752b5f5p-1,  -0x1.356708p-2, INEXACT)
T(RN,   0x1.43876550cabeep+81,    0x1.6ef8f64306c7cp-2,  -0x1.33f3d8p-4, INEXACT)
T(RN,    0x1.30898e8f1c5ap+81,    0x1.7bbecfb61fa65p-1,   -0x1.1f9e4p-2, INEXACT)
T(RN,   0x1.22b8d82534dbep+81,   -0x1.ec6b6dff6b741p-1,   0x1.ae25dcp-4, INEXACT)
T(RN,   0x1.f96d1d82b7017p+81,   -0x1.9583abc6e2ecfp-1,   0x1.806b9cp-3, INEXACT)
T(RN,   0x1.390f64fb56bacp+81,   -0x1.ffed2095ab37fp-1,  -0x1.dec97ap-2, INEXACT)
T(RN,   0x1.c5fe2856201a6p+81,   -0x1.9aad87b59cb23p-1,  -0x1.ab5b02p-2, INEXACT)
T(RN,   0x1.eb41e79b2cddap+81,    0x1.e170cd80716bap-1,  -0x1.a44354p-2, INEXACT)
T(RN,   0x1.d95955518f558p+81,    0x1.f35468568a33ep-2,  -0x1.7230acp-3, INEXACT)
T(RN,   0x1.e9e80607b2218p+81,   -0x1.213368038e7c7p-1,  -0x1.9fd426p-2, INEXACT)
T(RN,   0x1.2194973f72242p+82,    0x1.f9073bbcc563ap-1,  -0x1.cf0914p-2, INEXACT)
T(RN,   0x1.030d80df18532p+82,   -0x1.000cc6096bc04p-1,   0x1.581572p-4, INEXACT)
T(RN,   0x1.744d7e7bf9616p+82,    0x1.0c25b7c149fc1p-1,   0x1.dd3afcp-3, INEXACT)
T(RN,   0x1.da9ae2244beb6p+82,   -0x1.fbe17c280c47bp-1,  -0x1.468146p-2, INEXACT)
T(RN,   0x1.64106517815f8p+82,    0x1.72d98afbd84fcp-2,   0x1.55fc5cp-2, INEXACT)
T(RN,   0x1.908accbd1eabep+82,    0x1.ff8041280a977p-1,   0x1.1bb586p-3, INEXACT)
T(RN,   0x1.28d5160187415p+82,    0x1.fa7cb064f3273p-1,    0x1.944c9p-4, INEXACT)
T(RN,   0x1.33306de6d54ecp+82,   -0x1.c889e4fb3dfc2p-2,   0x1.633e18p-2, INEXACT)
T(RN,   0x1.43eba488f0602p+82,    0x1.f353bda43761ep-1,  -0x1.ad5cb8p-2, INEXACT)
T(RN,   0x1.e714c6b656bbcp+82,   -0x1.ba0489876e9ccp-1,   0x1.c3253cp-4, INEXACT)
T(RN,   0x1.9e8a0d9455abap+83,    0x1.ff4cb1d9c3463p-5,   0x1.e2aa94p-4, INEXACT)
T(RN,   0x1.421e63b92dd52p+83,   -0x1.566e4f1e5003fp-1,  -0x1.7a4dc4p-2, INEXACT)
T(RN,    0x1.978dbc1e9222p+83,   -0x1.9f14a9f848d9bp-2,   0x1.7a762ap-7, INEXACT)
T(RN,   0x1.8eb4485f6692ap+83,   -0x1.a7e99e1f5cd6bp-1,   -0x1.69b5ep-5, INEXACT)
T(RN,   0x1.78fa3ea983004p+83,    0x1.be9353ec12492p-1,  -0x1.3f998ap-3, INEXACT)
T(RN,   0x1.d18f15a48f4d1p+83,   -0x1.94377c074784ep-2,   0x1.bbc08ep-2, INEXACT)
T(RN,   0x1.64639725274a4p+83,    0x1.fecef183b4c75p-1,   0x1.ce29cap-4, INEXACT)
T(RN,   0x1.e771b95876122p+83,   -0x1.7464730a151dcp-1,   -0x1.b3305p-2, INEXACT)
T(RN,   0x1.75d4fdab2748ep+83,    0x1.aeb93fa29b5e1p-1,   0x1.c0ed8ap-3, INEXACT)
T(RN,   0x1.45b7f30f53fd5p+83,    0x1.7ae37de01d014p-1,  -0x1.8977dep-3, INEXACT)
T(RN,   0x1.f8792256d1316p+84,    0x1.2b36aae8fc50fp-4,  -0x1.bf5ec6p-2, INEXACT)
T(RN,   0x1.a45cfa4410d34p+84,   -0x1.f1aafa1c3c1a7p-5,  -0x1.83fd1ep-4, INEXACT)
T(RN,   0x1.ad90d9a5be07cp+84,   -0x1.01752b9746d25p-1,   0x1.ba33d2p-4, INEXACT)
T(RN,   0x1.f49da10f48af8p+84,   -0x1.f90bfead80664p-1,   0x1.5a9b2cp-3, INEXACT)
T(RN,   0x1.593f916da21f1p+84,    0x1.f3729345acbe5p-1,   0x1.dcf9e8p-2, INEXACT)
T(RN,   0x1.5d6e120b0a25cp+84,    0x1.cf74b86a316ebp-1,   0x1.b35d28p-2, INEXACT)
T(RN,    0x1.f270a83a85c7p+84,   -0x1.8a6a7d9b2a58ep-1,    0x1.9eac4p-2, INEXACT)
T(RN,   0x1.7c757d821da3ap+84,   -0x1.658114cef160dp-5,   0x1.e98d36p-2, INEXACT)
T(RN,    0x1.6bf57f58ea68p+84,   -0x1.4555aebe25538p-2,  -0x1.b3cc7cp-2, INEXACT)
T(RN,   0x1.f9621b4a59dc4p+84,   -0x1.ff785eb2a0838p-1,  -0x1.bd3664p-3, INEXACT)
T(RN,   0x1.662ef2c432e7ep+85,    0x1.fe18484bbd8bap-1,   0x1.1595ecp-4, INEXACT)
T(RN,   0x1.ba8ae2b6a442cp+85,   -0x1.1426d11b64fc8p-1,  -0x1.93fb3ap-2, INEXACT)
T(RN,   0x1.0d71165fd9cf5p+85,   -0x1.c700cc96b0107p-2,  -0x1.07335ap-2, INEXACT)
T(RN,   0x1.a223d3081c108p+85,   -0x1.fc3d9f26451dfp-1,   0x1.8da34cp-4, INEXACT)
T(RN,   0x1.b0ea9cf461decp+85,    0x1.fe58def920c22p-1,   0x1.0e9274p-2, INEXACT)
T(RN,   0x1.f8695cb5f2f8ep+85,    0x1.383dff59f0201p-3,   -0x1.74091p-3, INEXACT)
T(RN,   0x1.98b84b8180daep+85,   -0x1.532e744157379p-1,   0x1.13ec26p-9, INEXACT)
T(RN,   0x1.234090a2f4949p+85,   -0x1.9399b16429612p-1,   0x1.e52236p-2, INEXACT)
T(RN,   0x1.c957682e885d3p+85,   -0x1.5ded7264f891bp-2,   0x1.fe6c6ap-2, INEXACT)
T(RN,   0x1.cd56dc0059062p+85,    0x1.adfd16beeada2p-2,   0x1.9162aap-3, INEXACT)
T(RN,   0x1.50ece35add51ep+86,    0x1.c8ff98c7e0832p-2,  -0x1.4f3cecp-2, INEXACT)
T(RN,   0x1.d94d8a4001e03p+86,    0x1.ff15fc4a33d26p-1,   0x1.80e7a6p-4, INEXACT)
T(RN,   0x1.e38568ddb5ec9p+86,    0x1.f366f79b9b2aep-1,  -0x1.7110c8p-2, INEXACT)
T(RN,   0x1.daec444c4bc4fp+86,    0x1.fffd15311f975p-1,  -0x1.6c8dfap-2, INEXACT)
T(RN,   0x1.43ff63b92a968p+86,    0x1.ba4b6f7c49a32p-1,   0x1.706e58p-3, INEXACT)
T(RN,   0x1.f7b9e2f2ae1b6p+86,   -0x1.c8d65db34d252p-1,  -0x1.84c212p-2, INEXACT)
T(RN,   0x1.965bfbb067cc3p+86,   -0x1.424defa9f095fp-4,  -0x1.b8291ep-2, INEXACT)
T(RN,    0x1.21f7ed0bd546p+86,    0x1.58c3a8aaa1022p-3,   0x1.cfb02cp-3, INEXACT)
T(RN,   0x1.7dbc175820a9ap+86,    0x1.c958eea504a42p-1,   0x1.8da5d4p-2, INEXACT)
T(RN,   0x1.31c26b076e317p+86,    0x1.fb2345e0cf536p-1,   0x1.0981a8p-2, INEXACT)
T(RN,   0x1.624d875317a5bp+87,   -0x1.d07c7153a84cep-1,  -0x1.365f0cp-4, INEXACT)
T(RN,   0x1.eb06b54bffd0cp+87,   -0x1.de6f263e8f13dp-6,   0x1.42260ap-2, INEXACT)
T(RN,   0x1.aa4cfa3f41dbap+87,   -0x1.d7142ed1bed36p-5,   0x1.a8c2b2p-4, INEXACT)
T(RN,   0x1.8e3ae384c05e6p+87,    0x1.fe9d22376a9f4p-1,   0x1.64386cp-2, INEXACT)
T(RN,    0x1.55d1d743354ap+87,    0x1.523ab4f7eef04p-1,    0x1.cd732p-2, INEXACT)
T(RN,   0x1.3ab659fd31cb7p+87,    0x1.457c66374ac45p-1,  -0x1.0c0c92p-4, INEXACT)
T(RN,   0x1.42e568720b262p+87,    0x1.46103d8eb1aa1p-2,  -0x1.32bb12p-4, INEXACT)
T(RN,   0x1.a3d16d7352ec9p+87,   -0x1.f233f922ba3e1p-2,   0x1.2a652ap-2, INEXACT)
T(RN,   0x1.e232bfb324139p+87,    0x1.be085aba08255p-2,   -0x1.be4fep-2, INEXACT)
T(RN,    0x1.fd3b3065176dp+87,    0x1.45329f3964a9ap-2,   0x1.cb32c4p-2, INEXACT)
T(RN,   0x1.12406adb09057p+88,    0x1.7aa00d07269e6p-1,  -0x1.391726p-2, INEXACT)
T(RN,   0x1.77b38b9e9b117p+88,   -0x1.86e0749c0f413p-1,  -0x1.b3057ep-2, INEXACT)
T(RN,   0x1.055684eee6c2fp+88,    0x1.e2f8c2ba1dfcfp-1,  -0x1.58a62ep-2, INEXACT)
T(RN,   0x1.828b7e0a834c4p+88,    0x1.ab64ecf9a540cp-3,    0x1.eee2fp-2, INEXACT)
T(RN,   0x1.0bfe09af0860cp+88,   -0x1.15d6119e6bec5p-3,  -0x1.42a6eep-2, INEXACT)
T(RN,   0x1.75b2e79df7c91p+88,     0x1.1097b28ebaffp-1,   0x1.d152bep-3, INEXACT)
T(RN,   0x1.877d28021996ep+88,   -0x1.70181a3d6b1f7p-1,   -0x1.91809p-3, INEXACT)
T(RN,   0x1.b001f163741b1p+88,    0x1.1a98e6fdc0998p-1,   0x1.b0e078p-2, INEXACT)
T(RN,   0x1.4a7b2376dd603p+88,   -0x1.989d1f71e067fp-1,  -0x1.730622p-2, INEXACT)
T(RN,   0x1.b0d2a5358f2c3p+88,   -0x1.79d191f0f1b2fp-3,   0x1.933dbcp-2, INEXACT)
T(RN,   0x1.d29bec234bed6p+89,   -0x1.faef85d0e7e07p-1,  -0x1.8bd54ep-6, INEXACT)
T(RN,   0x1.59407d094c0e3p+89,     0x1.fd215ec72645p-1,  -0x1.d0d61ap-2, INEXACT)
T(RN,   0x1.99da4abc9b3a9p+89,    0x1.349875bf5e63bp-1,   0x1.df2ea4p-2, INEXACT)
T(RN,   0x1.857b02346328fp+89,    0x1.16d68245de85ap-3,   0x1.1bd394p-2, INEXACT)
T(RN,   0x1.cf37d5d29b2b8p+89,    0x1.26f01c04e7d69p-2,   0x1.0cacfep-5, INEXACT)
T(RN,    0x1.af8365f8a66ap+89,     0x1.633f667c17fcp-3,   0x1.f45e48p-6, INEXACT)
T(RN,   0x1.d51584cd816a8p+89,   -0x1.72b9b3773a6f1p-1,    0x1.5f336p-3, INEXACT)
T(RN,   0x1.dd7160ab302d5p+89,   -0x1.870a1cd4d9d07p-7,  -0x1.6aa0d2p-2, INEXACT)
T(RN,   0x1.bc45c26ed0bb4p+89,    0x1.fc78f440617e6p-1,  -0x1.b0a40ap-2, INEXACT)
T(RN,   0x1.a61ba87b7ceb2p+89,    0x1.3094b3d2d56f2p-2,    0x1.a4a7ep-2, INEXACT)
T(RN,   0x1.403be51dfa0cep+90,  -0x1.09989a8c0661cp-12,    0x1.e72d7p-3, INEXACT)
T(RN,   0x1.d5375a7784098p+90,   -0x1.591b749a96d0bp-2,    0x1.839bcp-4, INEXACT)
T(RN,   0x1.8b28fca10e1f2p+90,    0x1.209c20e675ccep-2,    0x1.05eb2p-2, INEXACT)
T(RN,   0x1.c0a82b7f40e64p+90,   -0x1.f18752e21ac6fp-1,   0x1.a4ddfcp-2, INEXACT)
T(RN,    0x1.8b9d4b28d675p+90,   -0x1.6e5a4e1ab41bap-1,   0x1.996e96p-7, INEXACT)
T(RN,   0x1.95c8bde80af73p+90,    0x1.b957c84fcc10dp-2,   0x1.992b2cp-2, INEXACT)
T(RN,   0x1.5d900d0369ca9p+90,   -0x1.de44ac782686ep-2,  -0x1.4f6872p-2, INEXACT)
T(RN,   0x1.a9b97fed8ce62p+90,   -0x1.f20e19349b474p-1,   0x1.57029ap-2, INEXACT)
T(RN,   0x1.ba4ca68397892p+90,   -0x1.c07e8fe5fdb5dp-8,   -0x1.a4255p-2, INEXACT)
T(RN,   0x1.16db314274394p+90,    0x1.c2d76ced4b00cp-2,   0x1.6ca42ap-2, INEXACT)
T(RN,   0x1.d24a5c294eacep+91,    0x1.0027a6a5c06acp-6,   0x1.3e2d32p-3, INEXACT)
T(RN,   0x1.6d91491435696p+91,   -0x1.c2918ec36b607p-1,    0x1.523f4p-2, INEXACT)
T(RN,   0x1.98e185fe798e5p+91,   -0x1.96de6542bddcep-1,   0x1.e776a6p-2, INEXACT)
T(RN,   0x1.b66fbd4bd96c1p+91,   -0x1.a9a451f8f118bp-1,   0x1.b7121cp-2, INEXACT)
T(RN,   0x1.6f63c283549ecp+91,   -0x1.df80dce857d34p-1,   0x1.a0c982p-6, INEXACT)
T(RN,   0x1.3f476c4597a78p+91,    0x1.7e007bc459e0ep-1,  -0x1.b29f72p-2, INEXACT)
T(RN,   0x1.205563325a685p+91,    0x1.feaff141f100ap-1,   0x1.7d8592p-2, INEXACT)
T(RN,   0x1.230274328329cp+91,    0x1.3a9477ecff97fp-2,  -0x1.dc70fcp-2, INEXACT)
T(RN,   0x1.dae6a47376659p+91,   -0x1.1ff5ad178ec78p-3,  -0x1.81c83ap-3, INEXACT)
T(RN,   0x1.d2a799e622882p+91,    0x1.e8a888891141ep-2,    0x1.1578fp-2, INEXACT)
T(RN,   0x1.581eff6c81f6cp+92,    0x1.9c9402af78125p-1,   0x1.840994p-2, INEXACT)
T(RN,   0x1.58dd99d3e1fd3p+92,    0x1.8fe4416ced847p-1,  -0x1.053096p-2, INEXACT)
T(RN,   0x1.3c8ec9fd58726p+92,   -0x1.a8bd3505959b7p-2,  -0x1.75f304p-2, INEXACT)
T(RN,   0x1.70d534d226fa4p+92,    0x1.cbc688e90786cp-1,   0x1.681388p-2, INEXACT)
T(RN,   0x1.0279bffe7bca7p+92,    0x1.fd51bd9354457p-2,   0x1.1c1ec4p-2, INEXACT)
T(RN,   0x1.8e46f1755eceep+92,    -0x1.111e3ced8cefp-1,  -0x1.f42168p-4, INEXACT)
T(RN,   0x1.6d5ab74111a86p+92,   -0x1.60e29e6290e72p-2,  -0x1.52a3cap-3, INEXACT)
T(RN,   0x1.99a494cbd2002p+92,   -0x1.37287e0131a02p-1,  -0x1.ec4ad6p-4, INEXACT)
T(RN,   0x1.bea1faa6f2cedp+92,     0x1.6ac0806fda6fp-1,   0x1.c8777cp-3, INEXACT)
T(RN,   0x1.a1571093b9037p+92,    0x1.a87ae8bcf7932p-5,   0x1.c9c65ap-3, INEXACT)
T(RN,   0x1.2bb04ebd53edep+93,   -0x1.2e4561af8aa09p-2,    0x1.9c871p-4, INEXACT)
T(RN,   0x1.c1cded5e20102p+93,   -0x1.ff5e0ebfb1e75p-2,   0x1.d87b48p-2, INEXACT)
T(RN,   0x1.e4c285204f045p+93,    0x1.f6a4163ce5178p-1,  -0x1.b5c0fep-2, INEXACT)
T(RN,   0x1.318f61b89bfedp+93,    0x1.ffefccc819072p-1,   0x1.f5b904p-4, INEXACT)
T(RN,   0x1.4b1377c0160f1p+93,   -0x1.2a7260402b203p-2,    0x1.26a77p-4, INEXACT)
T(RN,   0x1.c34e25b907058p+93,    0x1.f8f30a59d931fp-1,  -0x1.1e44bcp-2, INEXACT)
T(RN,   0x1.720e065af3a28p+93,    0x1.7287f21613cbdp-2,   0x1.c16322p-2, INEXACT)
T(RN,   0x1.3f407c1b8364ap+93,    0x1.41f396d404e4bp-1,   -0x1.28b99p-2, INEXACT)
T(RN,   0x1.58bd93678ccdcp+93,    0x1.ffff18069dbd3p-1,  -0x1.9aecb6p-3, INEXACT)
T(RN,   0x1.05af42e641ed3p+93,   -0x1.2d151d6df542ep-1,  -0x1.5d8fc8p-2, INEXACT)
T(RN,   0x1.45ad7c52d8543p+94,   -0x1.514e7147a3ca3p-2,   0x1.4ad5c2p-3, INEXACT)
T(RN,   0x1.49695cc996845p+94,   -0x1.fda9fadb473bbp-1,  -0x1.a35a56p-3, INEXACT)
T(RN,   0x1.77b60542cec56p+94,    0x1.9a85d5878b715p-1,  -0x1.c60234p-3, INEXACT)
T(RN,   0x1.a7d6902d4fd25p+94,   -0x1.b6678f7539e0fp-1,  -0x1.1ad3a2p-2, INEXACT)
T(RN,   0x1.daf20e57473fap+94,    0x1.d7c46b409f3c1p-1,   0x1.195426p-2, INEXACT)
T(RN,    0x1.c01e3556abebp+94,   -0x1.d5a04b0d5cc78p-1,   0x1.bb78aap-4, INEXACT)
T(RN,   0x1.289465e6066fcp+94,     0x1.e5716ec4f27ep-1,  -0x1.f800e4p-3, INEXACT)
T(RN,   0x1.9b87ac12532fdp+94,   -0x1.f538f908cd2b6p-3,  -0x1.f48e2ap-5, INEXACT)
T(RN,   0x1.a81f72b4c1b21p+94,    0x1.83361cf8556ebp-1,   0x1.15a05ap-4, INEXACT)
T(RN,   0x1.8cd791fd42b5cp+94,   -0x1.b8e6d4301667dp-2,  -0x1.f607c6p-2, INEXACT)
T(RN,   0x1.32566c7935967p+95,   -0x1.8c1e93ddd30dap-1,  -0x1.616efap-4, INEXACT)
T(RN,   0x1.58e30eee97655p+95,   -0x1.60ff675e00187p-1,  -0x1.8c758cp-8, INEXACT)
T(RN,   0x1.a2e5311270c4bp+95,   -0x1.64b166f19167bp-1,   0x1.55c06cp-2, INEXACT)
T(RN,   0x1.4a210724e0f71p+95,   -0x1.5172f3c88519ap-1,    0x1.f7153p-2, INEXACT)
T(RN,   0x1.93d716dd1392dp+95,    0x1.fbe5947256dcep-1,   0x1.ac1c1ep-3, INEXACT)
T(RN,   0x1.b7e4ff63dced6p+95,   -0x1.0b60b59893531p-3,  -0x1.8a52fap-4, INEXACT)
T(RN,     0x1.2cdff28f35cp+95,     0x1.fc5a3286326bp-1,   0x1.34c06ap-2, INEXACT)
T(RN,   0x1.a3e5f054f7592p+95,    0x1.9df52380e07acp-1,   0x1.fb5e92p-3, INEXACT)
T(RN,   0x1.2512cb3cd5741p+95,    0x1.609bba1f478d9p-2,     0x1.81a3p-2, INEXACT)
T(RN,    0x1.5fa02c862bb9p+95,    0x1.fcaba148c633cp-1,   0x1.8a6bf4p-4, INEXACT)
T(RN,   0x1.203562e9c0452p+96,    0x1.b39cafaa6e19fp-1,   0x1.df6796p-3, INEXACT)
T(RN,   0x1.edaac64f3c308p+96,   -0x1.d6e72b097472fp-1,    0x1.f8fd2p-2, INEXACT)
T(RN,   0x1.1347b9e3de655p+96,   -0x1.fe92a3f32f0adp-1,   -0x1.fd624p-2, INEXACT)
T(RN,   0x1.0184e9483797bp+96,    0x1.fa083a54a932dp-1,   0x1.ecb2bep-4, INEXACT)
T(RN,    0x1.c1472d8377f3p+96,   -0x1.f0d2f127275d1p-3,  -0x1.fd5dfcp-2, INEXACT)
T(RN,   0x1.54a71070b527ap+96,   -0x1.1d10d7ae01d91p-1,  -0x1.d70dbcp-3, INEXACT)
T(RN,   0x1.97f2940604fdap+96,   -0x1.9c7dc84755726p-1,  -0x1.b27c26p-9, INEXACT)
T(RN,   0x1.6c72d8172c4a8p+96,    0x1.aa216c5d3a1b7p-3,   0x1.690d74p-5, INEXACT)
T(RN,   0x1.2021dbe50f391p+96,    0x1.ee893a13fc788p-1,   -0x1.9fb86p-2, INEXACT)
T(RN,   0x1.eb6d5c4d21b05p+96,    0x1.c65e55843386fp-1,   -0x1.f3707p-4, INEXACT)
T(RN,   0x1.fecf29282ae96p+97,   -0x1.ba5bcb80aa67cp-1,  -0x1.248e8ap-2, INEXACT)
T(RN,   0x1.b075cdbe3eb9cp+97,    0x1.deb3cf287a525p-1,   0x1.0acf6ep-5, INEXACT)
T(RN,   0x1.0253ce1aa2811p+97,   -0x1.07bde878cfe2ap-1,   0x1.1806cap-2, INEXACT)
T(RN,   0x1.d2ab01a9e3ebcp+97,     0x1.16c46bf140edp-1,  -0x1.e5533ap-3, INEXACT)
T(RN,   0x1.37bb9ed3458c8p+97,     0x1.747fced8beeap-1,  -0x1.bbcd4ap-2, INEXACT)
T(RN,   0x1.9f36cdbc35378p+97,    0x1.d9aa8d65e5205p-2,   -0x1.e2501p-3, INEXACT)
T(RN,   0x1.9187efd8303cep+97,    -0x1.0089ffb73f0fp-2,   0x1.6cbd7ep-2, INEXACT)
T(RN,   0x1.16babd0cf0057p+97,    0x1.57beaf9c8fb1bp-1,   0x1.8d382cp-2, INEXACT)
T(RN,   0x1.7f4321e46c7c2p+97,   -0x1.47560ad777d44p-1,   0x1.359d9ep-3, INEXACT)
T(RN,   0x1.7eeacfb0570edp+97,    0x1.ff0e7d10dc73bp-1, -0x1.ed3ecap-10, INEXACT)
T(RN,   0x1.d76bb27f7c302p+98,    0x1.ff4c878e4fdf7p-1,   0x1.f5e23cp-4, INEXACT)
T(RN,   0x1.4c04a0abab53dp+98,   -0x1.1fb10ad68ef1ep-1,   0x1.d018fcp-3, INEXACT)
T(RN,   0x1.9ebbd96f151f6p+98,   -0x1.10aaa4eee7f88p-1,   0x1.4797bap-2, INEXACT)
T(RN,   0x1.07eee3d17d91cp+98,   -0x1.8ac5ca74b8102p-1,   0x1.ed89dep-4, INEXACT)
T(RN,   0x1.eb7dd5f41a194p+98,   -0x1.4491d06887099p-5,   0x1.5b0d58p-2, INEXACT)
T(RN,   0x1.38aa0f256a2edp+98,    0x1.0b0e55a9a7f08p-2,   0x1.f2dd88p-2, INEXACT)
T(RN,   0x1.c7f3e527369f4p+98,    0x1.ab3df53f477d2p-1,  -0x1.295728p-2, INEXACT)
T(RN,   0x1.9d29b1f997e9cp+98,     0x1.b70c2a498a95p-1,   0x1.c62becp-2, INEXACT)
T(RN,   0x1.e1028319f6147p+98,   -0x1.f62001b52c992p-1,   -0x1.b0748p-3, INEXACT)
T(RN,    0x1.f3f4e91420ffp+98,   -0x1.ec040132666bdp-1,   0x1.c00f5ap-4, INEXACT)
T(RN,   0x1.1295efc296494p+99,   -0x1.4db44d38b4b5cp-1,   0x1.ea0392p-2, INEXACT)
T(RN,   0x1.673312b6ca5acp+99,    0x1.d3694288ab185p-1,   0x1.a80e1ep-3, INEXACT)
T(RN,   0x1.7348a88b5dd98p+99,   -0x1.66e5725168c24p-1,   -0x1.e35c4p-6, INEXACT)
T(RN,   0x1.f330e491900bep+99,     0x1.8c006afc9109p-1,   0x1.3dd6fcp-2, INEXACT)
T(RN,   0x1.cb552b3d801d4p+99,    0x1.f3ea3df61cd3cp-2,   0x1.92cf12p-2, INEXACT)
T(RN,   0x1.8e26e41f5742ap+99,   -0x1.46eacd7729372p-1,  -0x1.d66bcep-2, INEXACT)
T(RN,   0x1.34b5576d0a2e4p+99,   -0x1.f23070c909d9dp-1,   0x1.d6ef44p-2, INEXACT)
T(RN,   0x1.054df2652d2b4p+99,    0x1.ec75b5a75de8bp-1,    0x1.93a9ep-2, INEXACT)
T(RN,    0x1.4fa878e05045p+99,   -0x1.98c934c4a4f5ap-2,  -0x1.2b4744p-2, INEXACT)
T(RN,   0x1.a2fef6c8ff337p+99,     0x1.b211c8cadc4cp-1,  -0x1.addb12p-4, INEXACT)
T(RN,   0x1.e667bafdc7d8p+100,   -0x1.d6eb26148020fp-1,  -0x1.15442ap-3, INEXACT)
T(RN,  0x1.3bbf798da6215p+100,    0x1.e8d0728b3dfb6p-1,  -0x1.019ea4p-3, INEXACT)
T(RN,   0x1.43d83df0d32ep+100,   -0x1.fbf27f3cc242ap-1,  -0x1.403c6ap-2, INEXACT)
T(RN,  0x1.ed281513038f2p+100,    0x1.f4230305b52fap-1,   0x1.27cbb6p-3, INEXACT)
T(RN,  0x1.8d8808dd6cea8p+100,    0x1.1a730f609a3c8p-2,  -0x1.9a162cp-3, INEXACT)
T(RN,  0x1.759c305f159eep+100,   -0x1.b9c28dbe71601p-1,   0x1.376086p-2, INEXACT)
T(RN,  0x1.b3e146f7fb0e3p+100,    0x1.b2fe275452d2ep-1,   0x1.8d5cd2p-3, INEXACT)
T(RN,  0x1.910ad1bb5be2ap+100,    0x1.5d95d466eb4f8p-1,  -0x1.da7b28p-4, INEXACT)
T(RN,  0x1.ff0438904272cp+100,   -0x1.52097a974741fp-1,   0x1.b1cd38p-2, INEXACT)
T(RN,  0x1.4c997d01d8638p+100,    0x1.6c74efb394d16p-4,   0x1.8f2708p-2, INEXACT)
T(RN,  0x1.cd7429d93d4fap+101,    0x1.cdab0b03b403dp-2,   -0x1.86298p-3, INEXACT)
T(RN,  0x1.d51d57ff9fef1p+101,   -0x1.d1feb621ce424p-1,   0x1.376906p-2, INEXACT)
T(RN,  0x1.df42554f5dd66p+101,   -0x1.ffd56e37bab6cp-1,    0x1.cb629p-3, INEXACT)
T(RN,  0x1.feeb46646c3b7p+101,    0x1.d6272890e71b3p-1,   0x1.dd50c4p-7, INEXACT)
T(RN,  0x1.e687c6d3e03c2p+101,   -0x1.028a268937419p-2,   0x1.3ca5f8p-7, INEXACT)
T(RN,  0x1.740263337b114p+101,   -0x1.6915d14bf2d77p-1,    0x1.871f9p-2, INEXACT)
T(RN,  0x1.96d95466aa088p+101,    0x1.4ccd5c6518035p-2,  -0x1.af31f2p-2, INEXACT)
T(RN,  0x1.48aa65ec44e63p+101,   -0x1.5cfa22bbb5247p-1,  -0x1.59f284p-3, INEXACT)
T(RN,  0x1.7c4e91d139d0ep+101,    0x1.3e08063372c8bp-1,  -0x1.554de4p-5, INEXACT)
T(RN,  0x1.70498b1ead7c5p+101,    0x1.a9b3604259bdfp-1,   0x1.73c702p-2, INEXACT)
T(RN,  0x1.2fb33c8219c0cp+102,    0x1.0f134ebd01f4ep-1,   0x1.b51e9ep-3, INEXACT)
T(RN,  0x1.29aa6d0f8cbd4p+102,   -0x1.369230bb802cfp-2,   -0x1.cf03cp-4, INEXACT)
T(RN,  0x1.ebd523c79bc4fp+102,   -0x1.8a180aff8446dp-1,  -0x1.89d76ep-6, INEXACT)
T(RN,  0x1.9d57913869ecap+102,   -0x1.b8ff37e167eb3p-1,  -0x1.7125f4p-7, INEXACT)
T(RN,  0x1.a524d7976d831p+102,   -0x1.7723b62dfe538p-1,  -0x1.c53bb2p-3, INEXACT)
T(RN,  0x1.f161121aa7782p+102,    0x1.9fb7bb0c8a40cp-1,  -0x1.e9217ep-5, INEXACT)
T(RN,  0x1.d31a715a5f45ep+102,   -0x1.f00a599233397p-1,  -0x1.8c9aaep-3, INEXACT)
T(RN,  0x1.cd03b30a4cfe8p+102,   -0x1.ddbd528ae6b97p-1,   0x1.8ca2c4p-3, INEXACT)
T(RN,  0x1.fc4fa89e48f7ap+102,    0x1.72300043c4507p-1,  -0x1.604a84p-2, INEXACT)
T(RN,  0x1.a8746736a4a7bp+102,    0x1.26ff54010cc38p-3,   0x1.789e84p-2, INEXACT)
T(RN,  0x1.574f16857ff66p+103,   -0x1.f0ef8fcc5b457p-1,   0x1.f778b2p-2, INEXACT)
T(RN,  0x1.04c6e1e20ee8cp+103,    0x1.ff7d3d87c1944p-1,   0x1.4c1b26p-2, INEXACT)
T(RN,  0x1.aad265b2d8f6cp+103,    0x1.896863ca80926p-3,   0x1.c4c6b8p-5, INEXACT)
T(RN,  0x1.c70a1da6bdae8p+103,     0x1.85190a44e869p-3,  -0x1.98942cp-2, INEXACT)
T(RN,  0x1.a65f3286f7f59p+103,   -0x1.834a0a861c1b3p-3,  -0x1.8cfbbap-2, INEXACT)
T(RN,  0x1.9316c10727a3fp+103,    0x1.ef887acc35ba5p-1,   0x1.65a588p-2, INEXACT)
T(RN,  0x1.627b78971f46ap+103,   -0x1.55c0710efb59bp-2,  -0x1.3901dcp-2, INEXACT)
T(RN,  0x1.b3c81dcc8e83cp+103,    0x1.f8db804811a81p-1,   0x1.75d1fap-3, INEXACT)
T(RN,  0x1.1ce990408db18p+103,    0x1.fc514ac392551p-1,   0x1.36b09cp-3, INEXACT)
T(RN,  0x1.7d3df2bcd053cp+103,   -0x1.f7449c73e695ap-1,   0x1.1d34cep-2, INEXACT)
T(RN,  0x1.d6ba8c8d002ccp+104,   -0x1.608280a76fe34p-1,   0x1.a5a26ep-2, INEXACT)
T(RN,  0x1.dbcdc673a836ap+104,   -0x1.968ae9d5cc422p-2,  -0x1.06ba6cp-8, INEXACT)
T(RN,  0x1.1bb2909b50bbap+104,    0x1.ff5f999f3bb59p-1,  -0x1.8561bap-2, INEXACT)
T(RN,  0x1.b7f1e98ed2085p+104,    0x1.fb09af95b557ep-2,  -0x1.a9ff58p-3, INEXACT)
T(RN,  0x1.7ce34c9cdf922p+104,    0x1.44fde822c9015p-1,   0x1.eb00b2p-2, INEXACT)
T(RN,  0x1.9667cdcfa60a2p+104,      0x1.cd26429af32p-1,   0x1.13e69ap-2, INEXACT)
T(RN,  0x1.2a299e07172cep+104,    0x1.d2061c974497bp-1,   0x1.3e9deap-7, INEXACT)
T(RN,  0x1.8baf7d2c7d404p+104,   -0x1.3c5c0f3a06449p-1,   0x1.c6a122p-3, INEXACT)
T(RN,  0x1.409270a201fb6p+104,    0x1.089bf0581352dp-1,   0x1.cb08f6p-5, INEXACT)
T(RN,  0x1.081b27625f119p+104,    0x1.b6205bba4eb29p-2,   -0x1.606acp-5, INEXACT)
T(RN,  0x1.460c71e8605bfp+105,   -0x1.efa91e4b8a28dp-2,   0x1.fcba32p-2, INEXACT)
T(RN,  0x1.a4c4073eb970ep+105,    0x1.f0c7ef82cc395p-3,  -0x1.cb1c24p-2, INEXACT)
T(RN,  0x1.1c452425258b2p+105,   -0x1.fc4c9e3181c9fp-1,  -0x1.39c3dep-2, INEXACT)
T(RN,  0x1.50b0da431c759p+105,    0x1.aa826a0c1587bp-3,   0x1.b4e054p-2, INEXACT)
T(RN,  0x1.732c24cd9bc05p+105,    0x1.d10a65a94b74ap-3,   0x1.914894p-4, INEXACT)
T(RN,  0x1.a2d52b4e62dcap+105,   -0x1.cddeb381b0fe2p-1,   -0x1.e0133p-5, INEXACT)
T(RN,  0x1.2e099252a7a12p+105,   -0x1.83c71ed14e51bp-2,  -0x1.f3db68p-5, INEXACT)
T(RN,  0x1.faf32e41f84a9p+105,   -0x1.29cc7c86e8e32p-3,   0x1.e72e42p-6, INEXACT)
T(RN,  0x1.4627c5357d8fap+105,   -0x1.546c30e34b0c7p-1,  -0x1.6ba516p-2, INEXACT)
T(RN,  0x1.a70c8d2810a54p+105,    0x1.d24fd9f6ae7bbp-1,    0x1.c57dep-2, INEXACT)
T(RN,  0x1.0a291455cefeap+106,    0x1.68af2a56a09adp-1,  -0x1.9cfa36p-2, INEXACT)
T(RN,  0x1.2c37bafa6c071p+106,   -0x1.c3a69f8e1fe59p-3,  -0x1.6c0348p-3, INEXACT)
T(RN,  0x1.7e2a0f4d17ca1p+106,    0x1.cd62a40591dc5p-2,   0x1.d3b542p-2, INEXACT)
T(RN,  0x1.66aec7588fd7ap+106,   -0x1.ff5eb824c1903p-1,   0x1.88e828p-4, INEXACT)
T(RN,  0x1.845ac8db5f514p+106,   -0x1.784147486b664p-1,  -0x1.f04c74p-2, INEXACT)
T(RN,  0x1.e163e27663fbcp+106,    0x1.722306a09c0b2p-1,  -0x1.633ceap-3, INEXACT)
T(RN,  0x1.edc94f404db72p+106,   -0x1.4c4a81aeae84fp-7,  -0x1.10035ap-2, INEXACT)
T(RN,  0x1.e846decaa8b32p+106,   -0x1.66861c8d448a3p-4,  -0x1.a375bap-3, INEXACT)
T(RN,  0x1.21cc00f51d55fp+106,    0x1.6711d2d2cb5a1p-1,  -0x1.ea7574p-6, INEXACT)
T(RN,  0x1.39a7cb3bc5a4ep+106,   -0x1.b8aa980dbac0fp-2,   0x1.3fb1e6p-6, INEXACT)
T(RN,   0x1.dd1525e3000bp+107,   -0x1.0afad384f5851p-4,   0x1.175bcep-3, INEXACT)
T(RN,  0x1.142c51d894bbcp+107,   -0x1.3434248cac892p-8,  -0x1.7394bep-3, INEXACT)
T(RN,  0x1.a3c472f31540dp+107,   -0x1.c956a4afccaf3p-1,    0x1.9f939p-2, INEXACT)
T(RN,  0x1.8dff16965bd88p+107,    0x1.f89c36f5cf66ep-1,   0x1.b472c6p-2, INEXACT)
T(RN,  0x1.ff12f6a4b087ap+107,    0x1.b7ce1b367812fp-2,  -0x1.a492b8p-2, INEXACT)
T(RN,  0x1.14a796ae2c60ap+107,   -0x1.c637b2fb7feeap-1,   0x1.6dcb74p-2, INEXACT)
T(RN,   0x1.420fe8f3cbd2p+107,    0x1.27a6df79ea176p-1,   0x1.6322b4p-2, INEXACT)
T(RN,  0x1.e0c29d1397b6ap+107,   -0x1.088d312967e7ep-1,    0x1.d0f4ap-8, INEXACT)
T(RN,  0x1.902a9361caddap+107,   -0x1.ee57bc4ceea77p-1,   0x1.f5309cp-3, INEXACT)
T(RN,  0x1.7a66c22dbb82ap+107,     -0x1.a505d7bc7c5p-1,   -0x1.b65eep-3, INEXACT)
T(RN,  0x1.50dcf789abfd4p+108,    0x1.c452041045269p-2,   0x1.f5fc4cp-2, INEXACT)
T(RN,  0x1.c3ddacdd18512p+108,    0x1.2d991b0a191a4p-1,   0x1.ec40f6p-2, INEXACT)
T(RN,  0x1.429ecf6ee9748p+108,      0x1.54052f05b5bp-1,   -0x1.8720dp-3, INEXACT)
T(RN,  0x1.881fb212a7758p+108,   -0x1.45786e8b47defp-2,   0x1.26d16ep-2, INEXACT)
T(RN,  0x1.60efd35c88fa1p+108,   -0x1.1cabbeb75f779p-1,    0x1.d4583p-2, INEXACT)
T(RN,  0x1.384d55eec5f98p+108,   -0x1.fd2ea5ea2c7bep-1,  -0x1.843c32p-2, INEXACT)
T(RN,  0x1.ff62b4712154ap+108,   -0x1.dc22be8850a8fp-1,  -0x1.e588d4p-3, INEXACT)
T(RN,  0x1.88bde3aa034a4p+108,    0x1.69f8a6f85bb47p-2,   -0x1.46066p-6, INEXACT)
T(RN,  0x1.f47ac35edb46cp+108,   -0x1.1489e9f3dae0cp-3,  -0x1.1679c6p-4, INEXACT)
T(RN,  0x1.67d2182adace2p+108,   -0x1.ffff6c42e40d7p-1,  -0x1.57546cp-2, INEXACT)
T(RN,  0x1.3d3411fd1b08dp+109,   -0x1.f3156c895bf88p-1,   0x1.e5fbb8p-2, INEXACT)
T(RN,  0x1.d5c6ba394fa52p+109,   -0x1.46081e7b680bcp-1,   0x1.99947cp-2, INEXACT)
T(RN,  0x1.51a020e7da145p+109,   -0x1.384ac1f37409bp-1,  -0x1.e083d4p-2, INEXACT)
T(RN,  0x1.d2e004f2839bap+109,    0x1.5bae856b960ddp-3,   0x1.ae1a38p-3, INEXACT)
T(RN,  0x1.d0b82d8821ff8p+109,   -0x1.f323a19ed0cbap-1,   -0x1.2fda6p-2, INEXACT)
T(RN,  0x1.44d95de91ba12p+109,    0x1.acebc5ab83cefp-1,  -0x1.5ab4f8p-4, INEXACT)
T(RN,   0x1.e0e715f5fb13p+109,    0x1.acd5d13209cefp-1,   0x1.635498p-4, INEXACT)
T(RN,  0x1.eb0bf9aed85dep+109,    0x1.10fa51acee324p-2,   0x1.484796p-4, INEXACT)
T(RN,  0x1.043024e8f7c6fp+109,    0x1.26f4c361c442dp-1,   0x1.cabd7ep-2, INEXACT)
T(RN,  0x1.00d72d936128ep+109,   -0x1.202dd2a6c8aedp-5,   0x1.7eaeb6p-2, INEXACT)
T(RN,  0x1.315abdbfcde19p+110,   -0x1.22d120c51385ap-1,   0x1.7b0ef6p-2, INEXACT)
T(RN,  0x1.ca7d1fb9db804p+110,    0x1.f8c122de53818p-1,  -0x1.b61efcp-3, INEXACT)
T(RN,  0x1.23e15d830a47cp+110,   -0x1.c64b686fc3a82p-1,  -0x1.29950ap-2, INEXACT)
T(RN,  0x1.0819910632d0bp+110,    0x1.ce3639f5f2b9ep-1,   -0x1.6c8e1p-2, INEXACT)
T(RN,  0x1.ddcab9f1bb184p+110,   -0x1.8d9638d059075p-1,   0x1.b7890cp-2, INEXACT)
T(RN,  0x1.a73c2c7f3a315p+110,    0x1.fdff7d28eca2ap-1,   0x1.1ef95cp-2, INEXACT)
T(RN,  0x1.4135e6ee32c48p+110,    0x1.ddeec79ad2557p-1,  -0x1.645a2ep-3, INEXACT)
T(RN,  0x1.f5930e06f5652p+110,    0x1.cc0e5f7b2fc85p-2,   0x1.ce484ep-2, INEXACT)
T(RN,  0x1.4cc7f593f06f7p+110,    0x1.cf4df3edb4314p-1,  -0x1.4b087ep-3, INEXACT)
T(RN,  0x1.b8e8a871aba58p+110,   -0x1.f2fdebcb9444dp-1,  -0x1.95cfe2p-2, INEXACT)
T(RN,  0x1.c714d79446ba2p+111,    0x1.cdf6afbe8086bp-1,   0x1.eb17c2p-2, INEXACT)
T(RN,  0x1.66b57c133f9b7p+111,    0x1.20e372445f293p-1,   0x1.4ca2f8p-2, INEXACT)
T(RN,  0x1.3cb48a775caf7p+111,     0x1.d13306331d36p-1,   0x1.a27aacp-3, INEXACT)
T(RN,  0x1.1fc5097b86048p+111,   -0x1.575142603798ep-1,    0x1.1acbbp-2, INEXACT)
T(RN,  0x1.1c7109d8253dap+111,    0x1.c36147ff176e2p-1,   0x1.5bbd64p-3, INEXACT)
T(RN,  0x1.9321a98aa57d9p+111,   -0x1.8c2bfff395e5bp-1,   0x1.e5f6eep-2, INEXACT)
T(RN,  0x1.2ec4391e68d0ep+111,   -0x1.a4c1c6bca61dfp-3,   0x1.c9b8fap-2, INEXACT)
T(RN,  0x1.db2ab5f8ffecep+111,   -0x1.6606db43d21dcp-3,    0x1.5f23ep-5, INEXACT)
T(RN,  0x1.484c0eb5ca3bcp+111,    0x1.a994ae4c557e9p-1,   -0x1.2b22ep-2, INEXACT)
T(RN,  0x1.499159c27d2c8p+111,     0x1.50ce54d8b09fp-1,   0x1.89281ap-3, INEXACT)
T(RN,  0x1.b977882f14fd1p+112,    0x1.2482d7da9c6c4p-1,   0x1.b29b7ep-3, INEXACT)
T(RN,  0x1.6cb75c0bb0a3ep+112,    0x1.ffd25dfa6e1f2p-1,   0x1.baf21ep-3, INEXACT)
T(RN,  0x1.b313ea305d32bp+112,   -0x1.eb0342c8ba863p-1,   0x1.d5aafap-4, INEXACT)
T(RN,  0x1.e4317ab13b547p+112,   -0x1.05d4e78c42963p-2,   0x1.5175c4p-4, INEXACT)
T(RN,   0x1.fda0ac81561ep+112,    0x1.4d7e6eb63c636p-1,  -0x1.ab7c1ap-2, INEXACT)
T(RN,  0x1.1a1b80c4f1a73p+112,    0x1.bc7f90505153ep-2,   -0x1.800a2p-3, INEXACT)
T(RN,  0x1.4ed1584a5d38fp+112,    0x1.7c2214d1d94c7p-1,    0x1.26884p-3, INEXACT)
T(RN,  0x1.74f90b515466dp+112,   -0x1.a7f15d6dd2ff4p-1,   0x1.73f384p-2, INEXACT)
T(RN,  0x1.db33ffc8af368p+112,   -0x1.dd531be828513p-1,    0x1.56c45p-2, INEXACT)
T(RN,  0x1.aa2f65e57561bp+112,    0x1.df8ed6bf76567p-1,  -0x1.e6ecf6p-3, INEXACT)
T(RN,  0x1.f7ea7b3aebd73p+113,   -0x1.fbdf7c4bf1515p-1,  -0x1.c2a75ep-2, INEXACT)
T(RN,  0x1.0d4ba44665554p+113,    0x1.ca0abb647320dp-1,   0x1.36938ep-2, INEXACT)
T(RN,  0x1.0758de765845cp+113,    0x1.97148d541e176p-2,  -0x1.b1a85cp-4, INEXACT)
T(RN,  0x1.70998044b0a9cp+113,   -0x1.d55148f284efdp-2,   0x1.b5890ap-5, INEXACT)
T(RN,  0x1.b1fb6316e9e64p+113,    0x1.f247e65dd3bd1p-1,  -0x1.85963ep-4, INEXACT)
T(RN,   0x1.efbb67b24b82p+113,   -0x1.f93ed771bb318p-1,   0x1.139c88p-2, INEXACT)
T(RN,  0x1.ab070f3f68713p+113,    0x1.1b892e3562b61p-3,  -0x1.109de8p-2, INEXACT)
T(RN,  0x1.490e9d28c42f3p+113,   -0x1.8598f4c3a6e81p-2,   0x1.942d0ap-3, INEXACT)
T(RN,  0x1.30d8ea2bdbdcep+113,    0x1.f203ebd7a3fd3p-1,   0x1.19ce18p-3, INEXACT)
T(RN,  0x1.7da0fc008efeap+113,    -0x1.b82c761b4e9dp-2,  -0x1.6c72aep-4, INEXACT)
T(RN,  0x1.3dd3beb9d4c13p+114,      0x1.0c117b1030bp-1,   0x1.2c22cap-2, INEXACT)
T(RN,  0x1.ca98b70bfcc9fp+114,    0x1.3298196d78503p-1,  -0x1.add4fep-4, INEXACT)
T(RN,  0x1.379b88bba0575p+114,   -0x1.f5ee031c84fbap-1,   0x1.0275e8p-2, INEXACT)
T(RN,  0x1.64528e9273feap+114,   -0x1.ea7bd1628423bp-1,   0x1.b88332p-2, INEXACT)
T(RN,  0x1.88faf7ba0dddep+114,    0x1.eeb37b99cb4bbp-1,  -0x1.291606p-4, INEXACT)
T(RN,  0x1.9f1e961a3006ep+114,    0x1.29e1ba09169d2p-1,  -0x1.4198f4p-4, INEXACT)
T(RN,  0x1.5b58223d92eaep+114,    0x1.f815a341d8b2dp-2,   0x1.9619d6p-2, INEXACT)
T(RN,  0x1.fe3bb1e053d3cp+114,   -0x1.04ccef37b64bbp-1,   0x1.15e85cp-2, INEXACT)
T(RN,  0x1.dd4f0d82aef47p+114,   -0x1.6952a34b6ffffp-1,   0x1.e554aep-2, INEXACT)
T(RN,  0x1.ee5f2acf486e8p+114,   -0x1.70f3f15867cc5p-1,  -0x1.458664p-2, INEXACT)
T(RN,  0x1.587e5413de494p+115,    0x1.de1652cc19d8fp-1,  -0x1.b4f598p-4, INEXACT)
T(RN,  0x1.cc99cfd180a98p+115,    0x1.fb810e08f20bep-1,   0x1.48532cp-2, INEXACT)
T(RN,  0x1.d35bd4840528ap+115,    0x1.c25e7cd749563p-1,  -0x1.a5bd2cp-5, INEXACT)
T(RN,  0x1.9297da8259179p+115,   -0x1.46d0da5776d4dp-3,   0x1.07eab8p-3, INEXACT)
T(RN,  0x1.d5b8d1bf829efp+115,   -0x1.4852a6f1a1318p-4,  -0x1.f08324p-3, INEXACT)
T(RN,  0x1.c059a1ff49a89p+115,    0x1.dda5ae87145a1p-1,  -0x1.ade2b8p-3, INEXACT)
T(RN,  0x1.669786edb239ep+115,    0x1.7c8c5dc4102e2p-6,   0x1.abbe96p-3, INEXACT)
T(RN,  0x1.8d914147df918p+115,    0x1.ff972e73b956ap-1,  -0x1.b6913ep-3, INEXACT)
T(RN,   0x1.d3097a1ee93ap+115,   -0x1.df62e3c248e47p-1,   0x1.2883b2p-2, INEXACT)
T(RN,   0x1.72ff67e20d28p+115,    0x1.53ba015610ceap-1,  -0x1.ab577cp-5, INEXACT)
T(RN,  0x1.293299d947c65p+116,   -0x1.ca7a2468ef429p-1,   0x1.1f08b4p-4, INEXACT)
T(RN,  0x1.2fb8b5e69effap+116,    0x1.093dfb3da2b5ep-1,   0x1.2c5048p-4, INEXACT)
T(RN,  0x1.911a5e10bd92bp+116,    0x1.5a442a99032f6p-2,  -0x1.6fabe6p-2, INEXACT)
T(RN,   0x1.fbf75c75efa4p+116,   -0x1.b1a3a12b3bee3p-2,   0x1.0db958p-2, INEXACT)
T(RN,  0x1.028d710954dfdp+116,    0x1.f2d85e6c2bf83p-2,   -0x1.0ddf1p-5, INEXACT)
T(RN,  0x1.9b4b55a5f6cf2p+116,   -0x1.460a86b1c34dfp-1,  -0x1.d80508p-3, INEXACT)
T(RN,   0x1.2e291f944d9dp+116,    0x1.fbbc316774715p-1,   0x1.d0de8ep-4, INEXACT)
T(RN,  0x1.12cb0e9e004d5p+116,   -0x1.d6e91a8ba50afp-1,  -0x1.fe76f6p-4, INEXACT)
T(RN,  0x1.074d1e2652042p+116,   -0x1.c066fd9d22836p-4,  -0x1.b92252p-2, INEXACT)
T(RN,  0x1.6cf90aae06ebep+116,   -0x1.fe58ccbbcb42ap-1,  -0x1.b9e466p-2, INEXACT)
T(RN,  0x1.8c02f22d3345ap+117,    0x1.d281a1c407fbep-1,   0x1.9d50dep-2, INEXACT)
T(RN,  0x1.a8a4c0e3a1825p+117,    0x1.b63ea156ca708p-1,   -0x1.3df01p-3, INEXACT)
T(RN,  0x1.be2541c1adb52p+117,    0x1.0ad759322c31fp-1,   0x1.924982p-3, INEXACT)
T(RN,  0x1.a3a0e94e3308cp+117,   -0x1.f5b592781361dp-1,  -0x1.d8cd38p-2, INEXACT)
T(RN,  0x1.70785f32c1d3cp+117,   -0x1.97f996111f3acp-1,   0x1.cddf2ep-5, INEXACT)
T(RN,  0x1.329f6df54bce2p+117,   -0x1.5f77fa80ea94ep-1,  -0x1.38177ep-2, INEXACT)
T(RN,  0x1.12b8e1e61e07bp+117,    0x1.e352e7c0732ecp-3,   0x1.33fd82p-2, INEXACT)
T(RN,  0x1.5ddf1cbf7d77ep+117,   -0x1.fd7174878e54bp-4,  -0x1.f4341ap-5, INEXACT)
T(RN,  0x1.f12c18979a09ap+117,    0x1.f0ee88ebf091dp-1,   -0x1.2a93ep-2, INEXACT)
T(RN,  0x1.3c9f6caa841f4p+117,    0x1.46383985d149cp-1,   0x1.7756eap-2, INEXACT)
T(RN,  0x1.b52a3645c809dp+118,    0x1.b5287766400bbp-1,   0x1.b3de44p-4, INEXACT)
T(RN,  0x1.f010e8d6030e6p+118,   -0x1.cebc111c430d6p-3,   0x1.5bc7eep-2, INEXACT)
T(RN,  0x1.998f68539e2fap+118,    0x1.f52de83f6b3b5p-1,    0x1.66708p-2, INEXACT)
T(RN,  0x1.504f4e16a5d65p+118,    0x1.2b70861c89e8ep-1,   0x1.81a8eap-2, INEXACT)
T(RN,  0x1.6dd9b0b50b8f3p+118,    0x1.fff03c321dc04p-1,    0x1.054d1p-4, INEXACT)
T(RN,  0x1.2b424faaacb87p+118,   -0x1.fbdbe788fa865p-1,    0x1.c4cc7p-2, INEXACT)
T(RN,  0x1.8b0e62f9cbf24p+118,    0x1.d8ca780abd094p-1,  -0x1.6a2f0ap-2, INEXACT)
T(RN,  0x1.edfbdd64872b7p+118,    0x1.42982d257f00fp-2,   0x1.7b9236p-2, INEXACT)
T(RN,  0x1.dfeac4cbb3b54p+118,   -0x1.41e2ff7c5aea9p-1,  -0x1.ff18cep-2, INEXACT)
T(RN,  0x1.3308a4a7a9bb6p+118,    0x1.d1581e28f1cdep-1,   0x1.634f32p-3, INEXACT)
T(RN,  0x1.0f6e0845fe966p+119,   -0x1.d29bac9fb94a7p-1,   0x1.0057d8p-3, INEXACT)
T(RN,  0x1.2d500bf43f2d3p+119,    0x1.c9c537fa13006p-3,  -0x1.b8674ap-3, INEXACT)
T(RN,  0x1.64becc00d5099p+119,    0x1.de2a7d852c942p-3,  -0x1.e9fbf6p-2, INEXACT)
T(RN,  0x1.4c6a7a23d185fp+119,    0x1.5453e7bda508ep-2,   0x1.c001e4p-2, INEXACT)
T(RN,  0x1.be882c14c7db2p+119,    0x1.c8c208f379a6bp-2,   0x1.935e64p-2, INEXACT)
T(RN,  0x1.02cad2b9f7a26p+119,    0x1.f5482329f42cfp-1,   0x1.151434p-3, INEXACT)
T(RN,  0x1.59d792c87e2fdp+119,   -0x1.cfb46028a5747p-1,   0x1.fd274ap-2, INEXACT)
T(RN,  0x1.5aa4f38bef4ddp+119,   -0x1.a8019affdac34p-6,   0x1.cd880ep-4, INEXACT)
T(RN,   0x1.0883d480c61bp+119,   -0x1.3cb8bb0c1ba7dp-1,  -0x1.91f682p-2, INEXACT)
T(RN,  0x1.1f7947125cae3p+119,   -0x1.6d9df2f371b69p-5,  -0x1.e539eep-2, INEXACT)
T(RN,  0x1.adc7efc513f9ep+120,   -0x1.a64345e0d99b1p-1,   0x1.d5ed6cp-2, INEXACT)
T(RN,  0x1.15d3734e7c8d6p+120,    0x1.30524efecc768p-1,   0x1.3b15e2p-3, INEXACT)
T(RN,  0x1.2c122a0052548p+120,    0x1.fce232a752ccfp-1,  -0x1.a94e06p-6, INEXACT)
T(RN,  0x1.db68b1a2e1706p+120,   -0x1.c328ef4876a63p-2,   0x1.db3e6ep-2, INEXACT)
T(RN,  0x1.2e55065f41077p+120,   -0x1.672547cca13f4p-1,  -0x1.4eb442p-2, INEXACT)
T(RN,  0x1.5583a96738da1p+120,   -0x1.94001c016a8b2p-2,   0x1.7b8c06p-2, INEXACT)
T(RN,   0x1.2d310068e86cp+120,    0x1.bbb4e277ad7dcp-1,  -0x1.d94f52p-2, INEXACT)
T(RN,  0x1.6e360e49b4e04p+120,   -0x1.ea5794031e291p-2,  -0x1.8e745ep-8, INEXACT)
T(RN,  0x1.dc485e68d5664p+120,   -0x1.c5bc7f4ce810bp-1,  -0x1.e74316p-2, INEXACT)
T(RN,  0x1.8d9d0a9580da4p+120,   -0x1.8293ab29031c1p-1,   0x1.bec98ep-2, INEXACT)
T(RN,  0x1.d8f83182849c5p+121,    0x1.b030f68684f2bp-1,  -0x1.d7fb6cp-2, INEXACT)
T(RN,  0x1.ff595f45f1988p+121,     0x1.8ed124b27ac9p-1,  -0x1.f3b654p-2, INEXACT)
T(RN,  0x1.23f0e82c7ebddp+121,   -0x1.08ca8c236a42bp-2,   -0x1.c1c97p-6, INEXACT)
T(RN,  0x1.049ef6886257ep+121,    0x1.d052309fa2f95p-1,  -0x1.dbd7b2p-3, INEXACT)
T(RN,  0x1.6d95cf656496bp+121,   -0x1.5c3eac40fdfc6p-1,   0x1.8edba6p-2, INEXACT)
T(RN,  0x1.c1fafc8812feep+121,   -0x1.b2072d7f9677fp-1,   0x1.f4f726p-6, INEXACT)
T(RN,  0x1.7387cf5c1fa66p+121,    0x1.b27cf9b79658ep-1,   0x1.3f569ep-3, INEXACT)
T(RN,  0x1.25fd1c23474d2p+121,    0x1.8ec630d3ff128p-1,  -0x1.dc3e5ap-2, INEXACT)
T(RN,  0x1.79a731b12730fp+121,    0x1.a16234705b64ap-1,   0x1.5d998ap-2, INEXACT)
T(RN,  0x1.2e0fdd43fb762p+121,   -0x1.180a4ccb4d244p-2,   0x1.7c1222p-3, INEXACT)
T(RN,  0x1.982bcd2b5b6dap+122,    0x1.4666ef7152bf9p-4,   0x1.d8050ap-2, INEXACT)
T(RN,  0x1.19f20960a4f2cp+122,    0x1.e1671aa853c9cp-1,   0x1.6c5d3ap-3, INEXACT)
T(RN,   0x1.abf879cc1ca4p+122,    0x1.45e8cb6c38bfep-1,   0x1.2a0c3cp-9, INEXACT)
T(RN,  0x1.355109d470982p+122,    0x1.d2fb333ca3208p-1,   0x1.817b6ap-2, INEXACT)
T(RN,  0x1.f4e18234f17fap+122,   -0x1.91836f83888fbp-3,  -0x1.ebf516p-2, INEXACT)
T(RN,  0x1.c270e509def7bp+122,    0x1.70f9d8eb08d49p-1,  -0x1.fd4c9cp-2, INEXACT)
T(RN,  0x1.b1cc4ec9a6d66p+122,    0x1.a8ae44e453cf1p-1,  -0x1.5c207ep-3, INEXACT)
T(RN,  0x1.dc56cc14ca872p+122,    0x1.5285afbb7deaep-2,   0x1.572976p-2, INEXACT)
T(RN,  0x1.410c2964f9d6ap+122,   -0x1.f9de66998b904p-1,   -0x1.853c8p-3, INEXACT)
T(RN,   0x1.40c84811530bp+122,   -0x1.8f23c0acbd55fp-2,  -0x1.b1c046p-2, INEXACT)
T(RN,    0x1.d77fee5e3e2p+123,   -0x1.bca2c06f050d4p-2,  -0x1.5c784ep-3, INEXACT)
T(RN,  0x1.7ca36338a703ap+123,   -0x1.993da5ddb89b6p-1,   0x1.1cf8bcp-2, INEXACT)
T(RN,  0x1.31c0717d9bca9p+123,    0x1.dbdbc56ed8dc7p-1,   0x1.db6654p-3, INEXACT)
T(RN,  0x1.e09c856566d7dp+123,     0x1.f935a1b3d573p-1,   0x1.4534c6p-4, INEXACT)
T(RN,  0x1.cadd9c5a3bd08p+123,   -0x1.f9485f692a959p-1,   0x1.34320ep-2, INEXACT)
T(RN,  0x1.e384e0f5ac42dp+123,    0x1.d0dea95e70928p-1,   0x1.e9882cp-2, INEXACT)
T(RN,  0x1.b811b179e532ap+123,   -0x1.40da41a2e0fe9p-3,   -0x1.68ff1p-6, INEXACT)
T(RN,  0x1.a3bb3b9e96682p+123,    0x1.ff1373c72e296p-1,  -0x1.afb072p-4, INEXACT)
T(RN,  0x1.30d9150ffa296p+123,    0x1.82e6a43027261p-1,  -0x1.0ee20ap-2, INEXACT)
T(RN,  0x1.88a0e281c1b6ap+123,    0x1.edc4e0136cd35p-1,    -0x1.8267p-3, INEXACT)
T(RN,  0x1.83f52f446bb3bp+124,   -0x1.fc8fded55441ap-1,  -0x1.159cccp-3, INEXACT)
T(RN,  0x1.d1f9699069eddp+124,   -0x1.c3b8ea5e1ac14p-1,   0x1.b3c90ap-2, INEXACT)
T(RN,  0x1.aa3e66aef6496p+124,   -0x1.20c8bb9c03f1bp-2,   0x1.35d092p-2, INEXACT)
T(RN,  0x1.d11412ce1276bp+124,    0x1.68618377ed00ep-1,   -0x1.ca217p-2, INEXACT)
T(RN,   0x1.d704f45d5e12p+124,     0x1.fd65d69b58a5p-1,   0x1.d52338p-3, INEXACT)
T(RN,  0x1.f188c098ff814p+124,    0x1.51cd6e86a5809p-3,  -0x1.cf481cp-2, INEXACT)
T(RN,  0x1.00c6deb688306p+124,   -0x1.460daf09b575ap-2,   -0x1.e7119p-2, INEXACT)
T(RN,  0x1.02844e31efec8p+124,   -0x1.0bd17b0fdde95p-1,  -0x1.1c2ec6p-2, INEXACT)
T(RN,  0x1.4366754eb4e7dp+124,     0x1.ac52636f2eeap-2,  -0x1.c3756cp-2, INEXACT)
T(RN,  0x1.bdb7664376e8ap+124,   -0x1.835cb7c37dfbdp-2,   -0x1.850b5p-3, INEXACT)
T(RN,  0x1.76014549db412p+125,    0x1.c9016349a7783p-1,   0x1.12eb54p-2, INEXACT)
T(RN,  0x1.a1457bdf2b83cp+125,    0x1.8394d1aac69dbp-1,   0x1.63e228p-2, INEXACT)
T(RN,    0x1.a93e50090a1p+125,   -0x1.fb08230ae9f19p-1,  -0x1.404544p-4, INEXACT)
T(RN,  0x1.216b4aa944b34p+125,    0x1.873783c850a35p-1,   -0x1.d9ef5p-3, INEXACT)
T(RN,  0x1.6b2ee4c764e64p+125,   -0x1.e1d84def109f8p-1,   0x1.d834b4p-3, INEXACT)
T(RN,  0x1.0862e184d1b05p+125,   -0x1.309e0ce25a0b1p-1,   0x1.0ff676p-2, INEXACT)
T(RN,  0x1.abe3bc430af2ap+125,   -0x1.6059a3e29a0a5p-3,  -0x1.62b534p-3, INEXACT)
T(RN,  0x1.e3663853fea34p+125,     0x1.c920ec60709cp-2,  -0x1.925e0ap-2, INEXACT)
T(RN,   0x1.dae6ce21a24bp+125,   -0x1.a743093a0dc31p-3,  -0x1.bc09eap-2, INEXACT)
T(RN,  0x1.dd5803aa09c88p+125,    0x1.f43b64830f229p-5,   0x1.7cff14p-2, INEXACT)
T(RN,  0x1.3ad96c574fc22p+126,   -0x1.a041b634ee6bcp-1,    -0x1.60bcp-2, INEXACT)
T(RN,  0x1.41d4523b067b6p+126,   -0x1.496224418ede4p-1,   0x1.032d16p-3, INEXACT)
T(RN,  0x1.97f5f1743a70ep+126,   -0x1.5710b53a12774p-1,  -0x1.8d9b82p-3, INEXACT)
T(RN,  0x1.496901279ba01p+126,    0x1.cb7acfe14d4a3p-1,   0x1.fce6a6p-2, INEXACT)
T(RN,  0x1.60361de431826p+126,   -0x1.7c68189b2950ep-1,  -0x1.20c39ep-6, INEXACT)
T(RN,  0x1.95f96979701aep+126,   -0x1.b241693ad5773p-1,   0x1.0c4fcep-2, INEXACT)
T(RN,  0x1.d966a2ba29e2cp+126,   -0x1.d61873d591568p-1,   0x1.1f3f22p-3, INEXACT)
T(RN,  0x1.5369fee7a39d7p+126,    0x1.3f32da27a907ap-2,   -0x1.d3726p-5, INEXACT)
T(RN,  0x1.441acba56031cp+126,   -0x1.07c7d1561e775p-1,   0x1.cd0de4p-2, INEXACT)
T(RN,  0x1.ff4c41d73c3bcp+126,    0x1.af8d699735925p-2,  -0x1.7ca3cap-2, INEXACT)
T(RN,  0x1.c6bcae8263566p+127,    0x1.6d40e915397a8p-3,  -0x1.aa4c06p-2, INEXACT)
T(RN,  0x1.c9c2e2e5743acp+127,    0x1.47b2abbc12df2p-1,  -0x1.9ecd9ap-2, INEXACT)
T(RN,  0x1.5ed6c3fc25992p+127,   -0x1.ced990e9f6215p-1,  -0x1.b64c98p-3, INEXACT)
T(RN,  0x1.76ff3e2d8bdc2p+127,   -0x1.7c4083227cbc2p-1,   0x1.111f68p-2, INEXACT)
T(RN,  0x1.c5fe892be091cp+127,   -0x1.f463cd8d92cd4p-1,   0x1.3049ccp-2, INEXACT)
T(RN,  0x1.0422938358c9cp+127,    -0x1.292529b94608p-1,  -0x1.5b54c2p-3, INEXACT)
T(RN,  0x1.85e59c8527348p+127,    0x1.782c5b54e8e79p-2,   0x1.cf4144p-2, INEXACT)
T(RN,  0x1.272b6b0e1dba8p+127,   -0x1.1b20ab308dcf7p-1,  -0x1.4cbf32p-3, INEXACT)
T(RN,  0x1.0452280afbbf6p+127,   -0x1.8c7a751cf593ep-1,    0x1.9ee56p-6, INEXACT)
T(RN,  0x1.ba2cb09089565p+127,   -0x1.d5231901200bbp-1,  -0x1.f3553ap-2, INEXACT)
T(RN,  0x1.e429f9b581802p+128,    0x1.863d54e33cdefp-1,  -0x1.17bb02p-2, INEXACT)
T(RN,  0x1.10f06382e79dcp+128,   -0x1.350ae3a316f05p-1,  -0x1.437926p-5, INEXACT)
T(RN,  0x1.46dbb124d3d8ep+128,   -0x1.364ffd80951e5p-3,    0x1.c7f5bp-3, INEXACT)
T(RN,  0x1.cd57c2be399c6p+128,   -0x1.ae10426f26e0cp-2,   0x1.c52cb8p-2, INEXACT)
T(RN,  0x1.8c199f3e87be5p+128,     0x1.2a2a0fc14a16p-1,  -0x1.235fdcp-2, INEXACT)
T(RN,  0x1.79a46d3c3bb94p+128,    0x1.95930b10c5296p-2,    0x1.2f71fp-4, INEXACT)
T(RN,  0x1.7854ca9baf2f7p+128,   -0x1.93748e68b65cap-4,   -0x1.5b322p-8, INEXACT)
T(RN,  0x1.615140b05a06fp+128,   -0x1.0d3191858e145p-1,   0x1.603d32p-2, INEXACT)
T(RN,  0x1.35b6a8a929588p+128,   -0x1.6f1fffc0abe4dp-1,   -0x1.14c3ep-2, INEXACT)
T(RN,  0x1.05af500dae325p+128,   -0x1.b9658e6728759p-1,    -0x1.59e1p-4, INEXACT)
T(RN,  0x1.490d138808f04p+129,    0x1.842f4502f3a79p-4,   0x1.1a117ep-3, INEXACT)
T(RN,  0x1.cbdb182d68fe6p+129,    0x1.7e628f280dee2p-1,   0x1.a78322p-4, INEXACT)
T(RN,  0x1.e82b271df2c58p+129,   -0x1.f6efa1de1763bp-1,  -0x1.da06fap-4, INEXACT)
T(RN,  0x1.05c5bae7ea515p+129,   -0x1.91c095506da92p-3,   0x1.a8d428p-5, INEXACT)
T(RN,  0x1.091190c0f91a2p+129,    0x1.792e2d8f2cf1bp-3,   0x1.b8bb66p-2, INEXACT)
T(RN,  0x1.7a4f9f75905c8p+129,   -0x1.f46ab3644bb72p-1,   0x1.cfe606p-3, INEXACT)
T(RN,  0x1.61b12ed8fa5dep+129,    -0x1.21ac53229a11p-5,  -0x1.a8b0f8p-3, INEXACT)
T(RN,  0x1.d0d0d43f47a4ap+129,    0x1.b767ac66470a4p-3,  -0x1.ca6d6ep-3, INEXACT)
T(RN,  0x1.9785ff8975a64p+129,    0x1.f7b95219dca0cp-1,   -0x1.8b772p-2, INEXACT)
T(RN,  0x1.92aff1abcaf52p+129,   -0x1.d70ed6c6a40c3p-1,  -0x1.7bbdf6p-3, INEXACT)
T(RN,  0x1.03a00de33662ep+130,    0x1.ada712af4c4eap-1,   0x1.a4ba1ap-3, INEXACT)
T(RN,  0x1.0b603a8f5aadbp+130,    0x1.081612f88ac2cp-2,   0x1.20f846p-3, INEXACT)
T(RN,  0x1.fb5d5c4b7c636p+130,   -0x1.ff9792e15e6bdp-1,   0x1.a4fc24p-3, INEXACT)
T(RN,  0x1.824b6620553c1p+130,    0x1.fb1e7bea19e85p-1,  -0x1.4f7f4ap-2, INEXACT)
T(RN,  0x1.9b5d160a99a8cp+130,   -0x1.beeb58d627c19p-2,  -0x1.29f314p-3, INEXACT)
T(RN,  0x1.bbc418f905b26p+130,   -0x1.4c64002272c87p-1,    0x1.50404p-8, INEXACT)
T(RN,  0x1.640ca65391124p+130,    0x1.e77b2607ffb3dp-1,   0x1.363104p-2, INEXACT)
T(RN,  0x1.9a9e604e6c95fp+130,   -0x1.a53e0a6e0b4abp-1,   0x1.e269d6p-2, INEXACT)
T(RN,  0x1.d1108c6da8defp+130,    0x1.df446d79ff788p-1,   0x1.941d9ap-2, INEXACT)
T(RN,  0x1.ef8e960fa58fap+130,    0x1.f9568d4e13453p-1,   0x1.dfd892p-2, INEXACT)
T(RN,  0x1.2c147d6c33462p+131,   -0x1.e1e0ff6d9fae9p-1,  -0x1.b0bf9cp-2, INEXACT)
T(RN,    0x1.7426bbb949ep+131,    0x1.5342eb24947c3p-1,   0x1.f30bbcp-3, INEXACT)
T(RN,   0x1.e96e1c96dcfbp+131,    0x1.ba7ad7b4a2771p-1,  -0x1.f9ef72p-2, INEXACT)
T(RN,  0x1.dc60555bb10b9p+131,    0x1.d1c3e48b8c1e6p-2,  -0x1.42e29ep-2, INEXACT)
T(RN,  0x1.b3362c5f9d0c4p+131,   -0x1.6a98c658e3bcep-2,    -0x1.4bfdp-2, INEXACT)
T(RN,  0x1.adbdb61dea4d4p+131,   -0x1.8d4617aa5772ap-1,   -0x1.eefc4p-3, INEXACT)
T(RN,  0x1.7662b5e187a2bp+131,   -0x1.fffd1afbd66d8p-1,   0x1.a57ccep-4, INEXACT)
T(RN,  0x1.9f852a8e223f8p+131,    0x1.22e2b2f4d8c66p-1,  -0x1.598dc2p-2, INEXACT)
T(RN,  0x1.ab185df308234p+131,   -0x1.b812f7f31579cp-1,   0x1.97965cp-2, INEXACT)
T(RN,  0x1.b9817a4762512p+131,    0x1.b8b9b36d8f19dp-7,  -0x1.7dbfa8p-2, INEXACT)
T(RN,  0x1.f9c2eabb181b7p+132,    0x1.af8be8f598f0ep-1,  -0x1.286ca4p-6, INEXACT)
T(RN,  0x1.3b1a9e971afb4p+132,    0x1.0ffa05b89cbcdp-1,  -0x1.a9fe02p-2, INEXACT)
T(RN,  0x1.fad1f6070d8fcp+132,   -0x1.84e8e4ecaba77p-1,   0x1.ee28bap-2, INEXACT)
T(RN,  0x1.c0d011c9264fcp+132,   -0x1.90506ef2cebf9p-2,  -0x1.8252c2p-5, INEXACT)
T(RN,  0x1.c78d929a6042ap+132,    0x1.777aeee671976p-1,   0x1.942e04p-2, INEXACT)
T(RN,  0x1.5e50221a2ce1ap+132,    0x1.3f5e9cd46863ap-3,   0x1.53db1ep-3, INEXACT)
T(RN,  0x1.ee8840a7dca73p+132,   -0x1.92efb571d831ep-2,  -0x1.369eb8p-3, INEXACT)
T(RN,  0x1.e247dbfc0da88p+132,   -0x1.f9ff4c3632c97p-1,   0x1.233924p-2, INEXACT)
T(RN,   0x1.677286dc27acp+132,     0x1.9c60cfcc7f85p-1,   0x1.da809cp-2, INEXACT)
T(RN,  0x1.b9de9331d3b62p+132,   -0x1.45f5e3cc13ddbp-1,   0x1.6b170ap-3, INEXACT)
T(RN,  0x1.dadf30d526782p+133,    0x1.617e8bdd85d7ap-4,   0x1.adc93ep-2, INEXACT)
T(RN,  0x1.e959862214658p+133,   -0x1.b8cbfd4aa77c1p-3,    -0x1.f066p-3, INEXACT)
T(RN,  0x1.9486634056094p+133,    0x1.53c274f5c73cdp-3,  -0x1.29b63ap-2, INEXACT)
T(RN,  0x1.ae9e54f73f8f4p+133,    0x1.729fdeb3abd2bp-1,  -0x1.5ac732p-2, INEXACT)
T(RN,   0x1.13cacb09e1d8p+133,   -0x1.aec5100ff83c7p-2,   0x1.b81d3cp-4, INEXACT)
T(RN,  0x1.9fd24db7d1e62p+133,   -0x1.de1dee45fecbcp-1,   0x1.efe7eap-2, INEXACT)
T(RN,  0x1.743877b81e1d5p+133,    0x1.a86dc67c49e93p-1,   0x1.5bb774p-2, INEXACT)
T(RN,  0x1.75f398b56d8cfp+133,    0x1.4ca7c47e72f0cp-2,   0x1.4ab544p-2, INEXACT)
T(RN,  0x1.1f668764ece09p+133,    0x1.31ff01420529cp-2,    0x1.4150ap-2, INEXACT)
T(RN,  0x1.dea9b73f61b8fp+133,    0x1.2beafbb3b3cb4p-4,    0x1.d8fbcp-2, INEXACT)
T(RN,  0x1.d9842d9860dc6p+134,    0x1.f70ae1720e11ep-1,   0x1.d30c34p-2, INEXACT)
T(RN,   0x1.e7409c040e91p+134,    0x1.bf83feb9cebdbp-2,   0x1.f02cc4p-2, INEXACT)
T(RN,  0x1.dcc6738ad384ep+134,   -0x1.f1f101efdf996p-1,   0x1.a81718p-2, INEXACT)
T(RN,  0x1.e4a1c871f8bb6p+134,    -0x1.f5b178d703cbp-1,   0x1.2832f8p-2, INEXACT)
T(RN,  0x1.cbe6f8b2058ebp+134,    0x1.c665e927d2863p-2,     0x1.a965p-2, INEXACT)
T(RN,  0x1.f40df92ca722cp+134,    0x1.c4fb744412052p-1,    0x1.563c7p-2, INEXACT)
T(RN,   0x1.804909690784p+134,    -0x1.1f174238710ap-1,  -0x1.2a767cp-2, INEXACT)
T(RN,  0x1.ac7dd8ae40e5ap+134,   -0x1.6b0d364c6f923p-1,   0x1.831158p-8, INEXACT)
T(RN,  0x1.6ae722eb490a4p+134,   -0x1.131ac674f4aabp-2,   0x1.b94166p-2, INEXACT)
T(RN,    0x1.a0852e7ae0cp+134,   -0x1.2d4465cde323fp-2,  -0x1.1834e6p-2, INEXACT)
T(RN,  0x1.55ff2548664b4p+135,    0x1.e4ec4b2d7c4f2p-1,  -0x1.798eb8p-3, INEXACT)
T(RN,  0x1.d98f1567e69b4p+135,   -0x1.80664c0678ca4p-1,    0x1.4ee68p-4, INEXACT)
T(RN,  0x1.b35b3525b06a8p+135,   -0x1.f3a88e3429ffbp-3,   0x1.8b21f2p-4, INEXACT)
T(RN,  0x1.2d91043c95693p+135,    0x1.bc9bac1dec7c7p-1,  -0x1.2971eep-2, INEXACT)
T(RN,  0x1.0eea05449762cp+135,    0x1.180da35cb7bc2p-4,   0x1.3df616p-2, INEXACT)
T(RN,  0x1.50f0f27947306p+135,   -0x1.0959bf673b2d7p-2,   -0x1.895c3p-6, INEXACT)
T(RN,  0x1.e3d55a91dfc9ep+135,   -0x1.e3c190b022f51p-1,   -0x1.782ecp-2, INEXACT)
T(RN,  0x1.5c5d7e084f2eep+135,   -0x1.03a3e091a45cap-1,  -0x1.8f4104p-6, INEXACT)
T(RN,  0x1.08049da77dba1p+135,    0x1.849c0aa9c2fa4p-2,   0x1.0fd234p-5, INEXACT)
T(RN,  0x1.7e1cc6304cfcfp+135,   -0x1.f32805157a2a9p-3,  -0x1.c787dep-4, INEXACT)
T(RN,  0x1.fe46dbacf477ap+136,    0x1.4cd95dffcf1f7p-2,  -0x1.f5945cp-2, INEXACT)
T(RN,  0x1.ba55f695008e2p+136,   -0x1.733355ab8aef5p-3,   0x1.ac5c2ep-4, INEXACT)
T(RN,  0x1.7a594d7ada37cp+136,    0x1.b845525194b2bp-1,  -0x1.2b9828p-5, INEXACT)
T(RN,  0x1.dd47813f73cd2p+136,    0x1.ae12c8a2f635ep-2,   0x1.afee9cp-4, INEXACT)
T(RN,  0x1.febf23bc19252p+136,   -0x1.0fa56222fcdecp-1,  -0x1.f16cc4p-2, INEXACT)
T(RN,  0x1.9474e9569ba38p+136,    0x1.d7a8b2abf476ep-1,  -0x1.409b6ap-2, INEXACT)
T(RN,  0x1.33168ac5913fep+136,    0x1.b9b60bce5d286p-2,   0x1.d3026ep-2, INEXACT)
T(RN,  0x1.a00e6d5c957efp+136,    0x1.d59171b4f2eaep-3,   -0x1.4acc8p-3, INEXACT)
T(RN,   0x1.e02260d92983p+136,    0x1.b0ee81fdc4c41p-1,  -0x1.070ce2p-2, INEXACT)
T(RN,  0x1.768c10bb14e3ap+136,   -0x1.bd35890fcccd1p-1,   0x1.35a5e4p-7, INEXACT)
T(RN,  0x1.3b0c2fed30fe9p+137,   -0x1.bc3a09d616569p-1,  -0x1.282d46p-5, INEXACT)
T(RN,  0x1.472cf0fa5529dp+137,   -0x1.9903b4a6058a6p-1,  -0x1.96da4cp-4, INEXACT)
T(RN,  0x1.a4796b6ea388ep+137,    0x1.9f927cd106d71p-7,   -0x1.4e612p-2, INEXACT)
T(RN,  0x1.f92915dcbe978p+137,   -0x1.25aeb58f26d03p-4,  -0x1.20992ap-4, INEXACT)
T(RN,  0x1.c5f324dbd114ep+137,     0x1.6b352f7dd6aap-2,  -0x1.216d88p-2, INEXACT)
T(RN,  0x1.181a1f8e9b58bp+137,   -0x1.7f195e55fa196p-1,  -0x1.502c92p-4, INEXACT)
T(RN,  0x1.a071eae13a8b4p+137,   -0x1.9e51acbe29988p-1,   0x1.275a2cp-2, INEXACT)
T(RN,   0x1.650be3db03b7p+137,   -0x1.20a0caa3f6dddp-3,    0x1.f8d57p-2, INEXACT)
T(RN,  0x1.12a4034c7fadfp+137,    0x1.ff684f4ff2c6cp-1,    0x1.1e251p-3, INEXACT)
T(RN,  0x1.0384c055d89e5p+137,    0x1.1ad1d70073cefp-1,   0x1.f24596p-2, INEXACT)
T(RN,  0x1.0a9124571a8b1p+138,   -0x1.fd4b59896d405p-1,   -0x1.98f61p-4, INEXACT)
T(RN,  0x1.dd4e73936fc32p+138,   -0x1.fe0ebabb4644ap-1,    0x1.dd063p-2, INEXACT)
T(RN,  0x1.c6e500b18cff1p+138,   -0x1.8e49fdc56bbc1p-1,  -0x1.a82728p-2, INEXACT)
T(RN,  0x1.2169fdd3deafbp+138,    0x1.d720468041d29p-3,   0x1.74107ep-5, INEXACT)
T(RN,  0x1.15d396aaef6b3p+138,   -0x1.2ab994ca3ac44p-3,  -0x1.1fa966p-3, INEXACT)
T(RN,  0x1.3523b47991f6ap+138,   -0x1.46bebcb97d492p-1,   0x1.8c591cp-6, INEXACT)
T(RN,   0x1.54273cd04d84p+138,   -0x1.ddfcf36d50923p-1,   0x1.deda7ep-3, INEXACT)
T(RN,   0x1.ce613e4ea4b7p+138,   -0x1.c6f3c5f28b27cp-4,  -0x1.63515ep-3, INEXACT)
T(RN,  0x1.a4a4765f3c12fp+138,   -0x1.6a9943bece238p-1,   -0x1.3036bp-4, INEXACT)
T(RN,  0x1.038b0ebb05acfp+138,   -0x1.310e7d590b36cp-1,  -0x1.d59ae6p-5, INEXACT)
T(RN,  0x1.a8a1336188028p+139,    0x1.ae2a56a07fad3p-1,  -0x1.a74dcep-2, INEXACT)
T(RN,  0x1.d4daaed04789ap+139,    0x1.4570c74bfc2d1p-2,   0x1.91d7c2p-2, INEXACT)
T(RN,  0x1.c6120dccac75ep+139,    0x1.6b21accb45278p-1,   0x1.2a3b6ap-2, INEXACT)
T(RN,  0x1.05c3112bd2bdbp+139,    0x1.fc4ba1ce6526fp-2,   0x1.e66ddcp-8, INEXACT)
T(RN,  0x1.5a30da77cea9ap+139,   -0x1.f47e569cf0de3p-1,  -0x1.7aa4bcp-2, INEXACT)
T(RN,  0x1.41187e1e7d4f1p+139,    0x1.d3faad0314c3ap-3,  -0x1.9dd75ap-2, INEXACT)
T(RN,  0x1.6a7857439b738p+139,    0x1.8b76355680778p-3,  -0x1.28f654p-2, INEXACT)
T(RN,  0x1.354e5840b1181p+139,    0x1.7cfcc212ee841p-2,  -0x1.92afdcp-2, INEXACT)
T(RN,  0x1.4409273383766p+139,   -0x1.5a8fbba8aaac3p-1,   0x1.14717cp-3, INEXACT)
T(RN,  0x1.78dc281f6ca58p+139,    0x1.5e746bf268531p-1,   0x1.82cbfcp-3, INEXACT)
T(RN,  0x1.19e6b7b1c43c3p+140,    0x1.ffe9e1bb72afep-1,   0x1.5958c2p-2, INEXACT)
T(RN,  0x1.c4b719dd3aff8p+140,    0x1.65e01941c5b3fp-2,   0x1.f4f394p-4, INEXACT)
T(RN,  0x1.0796c4dd28933p+140,    -0x1.009ad9350748p-1,   0x1.2e6fd4p-2, INEXACT)
T(RN,  0x1.512e91cf359e7p+140,    0x1.eba62f754ba6ap-1,   0x1.59e504p-6, INEXACT)
T(RN,  0x1.b230c6bf4f3a9p+140,   -0x1.f49cc57e5f10cp-1,   0x1.eb5b9ep-2, INEXACT)
T(RN,  0x1.a17a60a921aeap+140,    0x1.330c384a3dfd3p-1,   0x1.07e714p-2, INEXACT)
T(RN,  0x1.3a740babdce31p+140,   -0x1.c9ee54332b529p-1,   0x1.f4801ep-4, INEXACT)
T(RN,  0x1.4102c6a662921p+140,   -0x1.59ea878dd929bp-2,  -0x1.9e5c6cp-4, INEXACT)
T(RN,  0x1.d874c9885051ep+140,   -0x1.131d8127cb9f5p-1,   -0x1.f9ca5p-4, INEXACT)
T(RN,  0x1.4ac77603b3e9cp+140,   -0x1.947c459cd237ep-1,  -0x1.b480b4p-2, INEXACT)
T(RN,  0x1.4472d588a1c8dp+141,   -0x1.d366b4c58782fp-1,   0x1.1e819cp-2, INEXACT)
T(RN,  0x1.943fac8482235p+141,   -0x1.fdd87141b6fb4p-1,  -0x1.eadddcp-2, INEXACT)
T(RN,  0x1.8b4d50db0d2dap+141,    0x1.ffef46fa5d4e1p-1,  -0x1.17f6a8p-4, INEXACT)
T(RN,  0x1.122e21146d16ap+141,    0x1.64d5e7655f633p-1,   0x1.0af226p-4, INEXACT)
T(RN,  0x1.c6d1d878b34fep+141,   -0x1.1ff63eeca0d11p-1,   0x1.7424fap-3, INEXACT)
T(RN,   0x1.377c2c79d40ep+141,   -0x1.768d7f8505522p-1,  -0x1.b00bc8p-3, INEXACT)
T(RN,  0x1.5916d5fd16908p+141,   -0x1.385268f898584p-3,  -0x1.1a385cp-4, INEXACT)
T(RN,  0x1.eac8b39a6206ap+141,    -0x1.201a161479e9p-2,  -0x1.c8d3acp-3, INEXACT)
T(RN,  0x1.c2b81cbc0a845p+141,   -0x1.19d5e61471263p-1,  -0x1.b1414ap-2, INEXACT)
T(RN,  0x1.f62fffda58728p+141,   -0x1.d453bc12e5dc8p-1,  -0x1.8acca2p-3, INEXACT)
T(RN,   0x1.8e518a94584dp+142,    0x1.fdf3730be67a9p-1,   0x1.3fb1f6p-5, INEXACT)
T(RN,  0x1.2547279ac7bf8p+142,    0x1.ac21336e6d8fcp-1,  -0x1.8772b6p-2, INEXACT)
T(RN,  0x1.cdce421d67405p+142,    0x1.a94671970046cp-2,  -0x1.32d214p-2, INEXACT)
T(RN,  0x1.f10ebee33aeafp+142,   -0x1.aed9a98680b7fp-2,  -0x1.74437cp-2, INEXACT)
T(RN,  0x1.b559470f3293cp+142,    0x1.05a0d9e5bd0c5p-1,   0x1.db957ep-2, INEXACT)
T(RN,  0x1.0299fa108cef4p+142,   -0x1.68e09b5da9425p-1,  -0x1.199ca8p-3, INEXACT)
T(RN,  0x1.d2653e6361caep+142,    0x1.beb9a1e6a71e8p-1,   0x1.3c9b0ep-2, INEXACT)
T(RN,   0x1.52da360274cbp+142,   -0x1.e77588172808ep-1,   -0x1.a3f29p-2, INEXACT)
T(RN,  0x1.62ad1517f2853p+142,   -0x1.dd5ffd6e0929ap-1,   0x1.0babacp-2, INEXACT)
T(RN,  0x1.6d73e54247e57p+142,   -0x1.bafe310db78f8p-1,  -0x1.ecd4a8p-2, INEXACT)
T(RN,  0x1.0f0e808cdfd09p+143,    0x1.cf7d6ec526a2fp-1,  -0x1.4a4c76p-2, INEXACT)
T(RN,  0x1.ac6fc86832d59p+143,   -0x1.da40a1db8fc83p-4,  -0x1.a49188p-3, INEXACT)
T(RN,  0x1.cf6bd140ce238p+143,    0x1.7e22de79522b4p-1,  -0x1.4f704cp-2, INEXACT)
T(RN,  0x1.04e09a2f33f78p+143,    0x1.500c1f15e7bd4p-1,   0x1.8f784ep-3, INEXACT)
T(RN,  0x1.43b3d09fede5bp+143,    0x1.f6e098839b93fp-4,   0x1.e9559ap-3, INEXACT)
T(RN,  0x1.953e2bb24e90cp+143,   -0x1.32a32366bd8b8p-1,  -0x1.fe5cd4p-2, INEXACT)
T(RN,   0x1.d276c9905a51p+143,    0x1.838202960cb0cp-1,  -0x1.c9fde4p-3, INEXACT)
T(RN,   0x1.d2cf55d7e381p+143,   -0x1.b34db96f91e25p-2,   0x1.38268ap-4, INEXACT)
T(RN,  0x1.8933461db0cedp+143,    0x1.ed653b5d81852p-4,  -0x1.1e817cp-3, INEXACT)
T(RN,  0x1.1069747451a0cp+143,   -0x1.5c21f07950177p-1,  -0x1.c2ccd2p-3, INEXACT)
T(RN,  0x1.aa9a0795e69d3p+144,   -0x1.267f45a304c2ap-1,   0x1.cf6f72p-5, INEXACT)
T(RN,  0x1.51c22ad9918dap+144,   -0x1.f44b80c9f101cp-1,   0x1.ab9ddap-2, INEXACT)
T(RN,  0x1.8dfff09acb568p+144,   -0x1.f7f71a10974a2p-1,    0x1.03241p-2, INEXACT)
T(RN,  0x1.37078a71b5816p+144,    0x1.b6f923058ee78p-2,   0x1.9cdf96p-2, INEXACT)
T(RN,  0x1.6e8c34f82941cp+144,   -0x1.f7e654e2b8ea1p-1,  -0x1.817b7ep-2, INEXACT)
T(RN,  0x1.f544eef05311ap+144,    0x1.1dc658649597fp-4,   0x1.63df38p-4, INEXACT)
T(RN,   0x1.430c5a9ea629p+144,   -0x1.f7cc3d6cdd769p-1,   0x1.3859bcp-3, INEXACT)
T(RN,  0x1.a12705e544fdap+144,    0x1.d538cc291eb92p-1,   0x1.1a70c4p-2, INEXACT)
T(RN,  0x1.d91111b124dbep+144,   -0x1.dc5b4f65df73fp-1,   0x1.7eb78ep-3, INEXACT)
T(RN,  0x1.60ce0e91c8de6p+144,    0x1.fb7824f38c815p-1,   0x1.d393eep-2, INEXACT)
T(RN,  0x1.8ee96b80a09a5p+145,   -0x1.ecae70804abc9p-1,    0x1.1f51dp-2, INEXACT)
T(RN,  0x1.1a2ccd74a7fb5p+145,    0x1.77714fda36b84p-1,   0x1.029372p-3, INEXACT)
T(RN,  0x1.bebfe69ae7712p+145,    0x1.913eea729134dp-1,    0x1.914c1p-3, INEXACT)
T(RN,  0x1.4e1ec2a002fa4p+145,   -0x1.f6623d42e3d94p-1,   0x1.79aea6p-2, INEXACT)
T(RN,  0x1.a674a0ba49904p+145,    0x1.a2e9cc486686ap-3,  -0x1.5cd728p-5, INEXACT)
T(RN,  0x1.12500bd18306ap+145,   -0x1.f1cf1081b9291p-1,   0x1.a8a89ep-4, INEXACT)
T(RN,  0x1.79f10bc7bcc77p+145,    0x1.bb5bee278c063p-1,  -0x1.30eca6p-3, INEXACT)
T(RN,  0x1.1f72375baabe3p+145,    0x1.7c72e710f24abp-3,   -0x1.5ae14p-4, INEXACT)
T(RN,  0x1.de18d73671dc7p+145,   -0x1.a2f163b89847bp-1,   0x1.d3486ap-2, INEXACT)
T(RN,   0x1.b0804ab47478p+145,    0x1.dda4daffc7be2p-1,   -0x1.d9dcfp-4, INEXACT)
T(RN,  0x1.b2fc4b8fa1a3cp+146,    0x1.e35e99d2291bep-1,    0x1.918c8p-2, INEXACT)
T(RN,  0x1.d53ed09fb7744p+146,   -0x1.6abe966a04506p-2,  -0x1.3bf2cep-2, INEXACT)
T(RN,  0x1.751dbb1b4f23ap+146,   -0x1.d0bad406f8b4dp-1,  -0x1.a83434p-3, INEXACT)
T(RN,  0x1.44353f324e4b8p+146,   -0x1.4ddc2116c9687p-1,   -0x1.23359p-2, INEXACT)
T(RN,  0x1.c833056c41efcp+146,    0x1.68ee045ac9304p-2,    0x1.d0033p-4, INEXACT)
T(RN,   0x1.ce3cf0785de6p+146,   -0x1.1433cf0ab434ep-1,   0x1.3962dap-2, INEXACT)
T(RN,  0x1.54cd383831391p+146,    0x1.9651f8ba3d75fp-1,  -0x1.aee01ep-3, INEXACT)
T(RN,  0x1.616077a57a8e2p+146,    0x1.fdc2c3456b0dfp-1,    0x1.6a9acp-2, INEXACT)
T(RN,  0x1.1cc4aa38f41f3p+146,    0x1.8b63bcf4633c7p-1,   0x1.f2c658p-4, INEXACT)
T(RN,  0x1.065ee665b212ep+146,   -0x1.e3ad5928c23ffp-2,   0x1.57b2a2p-2, INEXACT)
T(RN,  0x1.52bdcce187d06p+147,    0x1.4de468bd4d9a5p-1,   0x1.04559cp-3, INEXACT)
T(RN,   0x1.19248a4088d2p+147,    0x1.4a32b9ab33318p-1,   0x1.988f78p-2, INEXACT)
T(RN,  0x1.f65042f804014p+147,    0x1.4df52a3854077p-1,   0x1.9f3b84p-4, INEXACT)
T(RN,  0x1.d4c1b048fc1a6p+147,   -0x1.2aa56b810b69cp-4,   0x1.acaa52p-2, INEXACT)
T(RN,  0x1.5ce049cb5de5bp+147,    0x1.f7026732978bap-2,  -0x1.d3010ap-2, INEXACT)
T(RN,  0x1.94869e65bdc74p+147,    0x1.5d39078f3d71bp-1,   0x1.f7c0eap-2, INEXACT)
T(RN,  0x1.bdc969b528b8fp+147,   -0x1.dbfe1595854c8p-1,  -0x1.f173d2p-7, INEXACT)
T(RN,  0x1.14d987994b926p+147,    0x1.2e7651fa537d5p-1,  -0x1.087e32p-2, INEXACT)
T(RN,  0x1.1161bf09cf3dap+147,   -0x1.d4298b496b831p-1,   0x1.6b406cp-3, INEXACT)
T(RN,  0x1.5a514a5383ba6p+147,    0x1.4ef5ea8ef2651p-5,  -0x1.697292p-2, INEXACT)
T(RN,   0x1.930214355a37p+148,   -0x1.374397a3ffe49p-1,   0x1.c8a6a8p-5, INEXACT)
T(RN,  0x1.14e55192e54fcp+148,   -0x1.e2bb902394129p-1,  -0x1.4b589ap-2, INEXACT)
T(RN,  0x1.177c90b21beddp+148,    0x1.e7bd0f439f643p-1,  -0x1.31bf5ep-2, INEXACT)
T(RN,  0x1.36a294bb91687p+148,    0x1.02ac0257a8c28p-1,   0x1.d745bcp-7, INEXACT)
T(RN,  0x1.8928b86a370f8p+148,    0x1.23acb56b463efp-2,  -0x1.52068ap-2, INEXACT)
T(RN,  0x1.5b6ac2aa61b5fp+148,    0x1.751ed5a437912p-2,   0x1.06bb62p-5, INEXACT)
T(RN,  0x1.c5561e5b563d2p+148,    0x1.70d434f983ba4p-3,  -0x1.42c56cp-3, INEXACT)
T(RN,  0x1.d137dffffe083p+148,    0x1.f84a749ad66efp-1,  -0x1.a81bb4p-4, INEXACT)
T(RN,  0x1.05e9c6bb1680ap+148,   -0x1.e13f043a46c25p-1,  -0x1.e24734p-2, INEXACT)
T(RN,  0x1.47faf51e9b69bp+148,   -0x1.55ef83e70d31fp-1,  -0x1.e949f4p-3, INEXACT)
T(RN,  0x1.7c3e76ac1c03bp+149,   -0x1.a4b9a3dfe30bdp-1,   -0x1.20a82p-7, INEXACT)
T(RN,  0x1.4eb67ef1e65c8p+149,   -0x1.0f0c6cbdee556p-2,  -0x1.fb0402p-4, INEXACT)
T(RN,  0x1.91f7323ca84f6p+149,   -0x1.b95596acc8499p-1,   0x1.9ca812p-3, INEXACT)
T(RN,  0x1.a064f7d8a901dp+149,    0x1.f293ee354d6f2p-1,   0x1.bdcf1cp-2, INEXACT)
T(RN,   0x1.12c27c8441ccp+149,   -0x1.f6d851e7089cap-1,   0x1.78cbd4p-3, INEXACT)
T(RN,  0x1.d47b9630490b6p+149,    0x1.88fbcc6aab769p-3,  -0x1.34eab6p-3, INEXACT)
T(RN,  0x1.61badf70275cap+149,   -0x1.ccf4aca235cdap-4,   0x1.769fb8p-3, INEXACT)
T(RN,  0x1.4d1b191639b28p+149,    0x1.053f0b02229a4p-1,   0x1.96c47cp-4, INEXACT)
T(RN,  0x1.0c1ff0364d997p+149,    0x1.fdc383203c605p-1,   0x1.3e388cp-2, INEXACT)
T(RN,  0x1.27bdb1d350b4cp+149,   -0x1.dfe586bec18e5p-1,  -0x1.73d4b4p-2, INEXACT)
T(RN,  0x1.8955dcc93bd17p+150,    0x1.d057d4526eb81p-1,   0x1.bb1de8p-2, INEXACT)
T(RN,  0x1.ef95217225a84p+150,    0x1.e4f6dfd9efcf2p-5,   0x1.90332ap-3, INEXACT)
T(RN,  0x1.d9c8a7cd52b11p+150,    0x1.7a1a765f2e08fp-1,    0x1.e2c1cp-4, INEXACT)
T(RN,  0x1.77bde4bc63625p+150,   -0x1.b07ce59d79176p-1,  -0x1.13ad04p-3, INEXACT)
T(RN,  0x1.accdac6bbb46dp+150,     0x1.eafe57ad0b0dp-1,   0x1.32f272p-2, INEXACT)
T(RN,  0x1.e49df39300b18p+150,   -0x1.5d66be91c9dcep-3,   0x1.52edcap-2, INEXACT)
T(RN,  0x1.d04f43aa6533ep+150,   -0x1.32345d039c2ecp-1,   0x1.e8738ap-5, INEXACT)
T(RN,  0x1.5bd85327e2d9ap+150,   -0x1.91fa0b2a27fa6p-1,   0x1.b19d3ap-9, INEXACT)
T(RN,   0x1.dfb9a6c953d6p+150,   -0x1.6bfd7502ceaf1p-2,  -0x1.8f6658p-3, INEXACT)
T(RN,  0x1.99cd7cfa6710dp+150,    0x1.129a3c8aef313p-2,  -0x1.f0c7fap-2, INEXACT)
T(RN,  0x1.3cc0c979d4087p+151,    0x1.4f72bbf476eabp-2,    0x1.3c235p-5, INEXACT)
T(RN,  0x1.43e37430e7fc2p+151,   -0x1.dcf6b205c3622p-1,   0x1.0e2bc2p-3, INEXACT)
T(RN,   0x1.cd606df4de14p+151,   -0x1.ffec0c4625cbap-1,  -0x1.59aaf8p-2, INEXACT)
T(RN,  0x1.c550a4d8d24f2p+151,    0x1.ff4c97b8e253cp-2,  -0x1.ce3414p-4, INEXACT)
T(RN,    0x1.69c03dc3314p+151,    0x1.1784f17b1b91bp-1,  -0x1.1a925ap-2, INEXACT)
T(RN,   0x1.fca11dc57378p+151,    0x1.95906daad775cp-2,   0x1.4c49bcp-2, INEXACT)
T(RN,   0x1.8d42942178b5p+151,   -0x1.520f95c32c864p-2,   0x1.07b3aep-4, INEXACT)
T(RN,  0x1.a4df31f99e4a2p+151,    0x1.f97b75d234334p-3,   0x1.ca7176p-3, INEXACT)
T(RN,  0x1.1426125cc0354p+151,     0x1.f8bd7712eacap-1,  -0x1.ba5f54p-4, INEXACT)
T(RN,  0x1.09875d9bfb9f5p+151,   -0x1.2dd67dab6355ep-1,  -0x1.39f87ep-2, INEXACT)
T(RN,  0x1.b17cbbef53b8bp+152,    0x1.8b3fb4e10d56fp-1,   0x1.e72154p-3, INEXACT)
T(RN,  0x1.7343fc93d5828p+152,   -0x1.d6e5969e65e82p-1,   0x1.598fbap-3, INEXACT)
T(RN,  0x1.c06fa1e0372e5p+152,    0x1.b9a349766a49fp-5,  -0x1.dd1378p-2, INEXACT)
T(RN,  0x1.0b2cee8f757b4p+152,    0x1.cb9e3592555d8p-1,  -0x1.26e52ep-2, INEXACT)
T(RN,  0x1.d308d562235bdp+152,   -0x1.e6387a7d0ea4ep-2,   0x1.20085cp-4, INEXACT)
T(RN,  0x1.48c0027f8dad3p+152,   -0x1.effbdc820603dp-1,   0x1.008096p-2, INEXACT)
T(RN,  0x1.076c7af817fc8p+152,   -0x1.dfcfbf62c1183p-1,  -0x1.6b0f4ep-3, INEXACT)
T(RN,  0x1.7859af94b74dep+152,    0x1.4517d1471e82bp-1,  -0x1.ad5c78p-2, INEXACT)
T(RN,  0x1.a2b114cdae991p+152,   -0x1.b3cace042089ap-1,   0x1.baa5f6p-3, INEXACT)
T(RN,  0x1.ec57ec9acb77ep+152,     0x1.84c0f51bbaf8p-2,   0x1.749b46p-2, INEXACT)
T(RN,   0x1.2923fa758105p+153,   -0x1.284370ef5b4e5p-1,    0x1.000c1p-3, INEXACT)
T(RN,  0x1.6f897bf3a7e64p+153,   -0x1.d32bd82a7bb4bp-2,   0x1.770c7cp-3, INEXACT)
T(RN,  0x1.ec5df914dcd77p+153,    0x1.2c303002dc92dp-4,   0x1.561ceap-4, INEXACT)
T(RN,  0x1.b64c5719691acp+153,   -0x1.f0142e5fd0498p-2,  -0x1.6546fcp-2, INEXACT)
T(RN,  0x1.5af439b39fcc2p+153,   -0x1.cf394d6818ca4p-1,  -0x1.cb87d2p-3, INEXACT)
T(RN,  0x1.5deb402f2a7ccp+153,    0x1.ebfe06244a81ep-1,   0x1.731e0ap-2, INEXACT)
T(RN,  0x1.0e437bc4ef7e8p+153,   -0x1.9a39cfc8f5771p-1,  -0x1.12cb76p-2, INEXACT)
T(RN,  0x1.9980fed17a4cep+153,     0x1.c8047bc2177bp-1,  -0x1.4ca5f2p-2, INEXACT)
T(RN,  0x1.9df184af6bd1ap+153,   -0x1.38b49be3ae8ebp-1,  -0x1.30fbcap-2, INEXACT)
T(RN,  0x1.222509a931249p+153,    0x1.f92803a083e64p-1,   0x1.033628p-5, INEXACT)
T(RN,   0x1.0ff475824693p+154,   -0x1.0b414493a1e5bp-3,   0x1.affde8p-3, INEXACT)
T(RN,  0x1.a83b64eae6357p+154,   -0x1.be57865e0f573p-2,   -0x1.7c022p-4, INEXACT)
T(RN,  0x1.b7e0ecc59a5bfp+154,   -0x1.53695d324891dp-3,   0x1.0104fap-2, INEXACT)
T(RN,  0x1.217263d18c93ep+154,    0x1.ff71883f3f949p-1,   0x1.2122dcp-2, INEXACT)
T(RN,  0x1.3d49fd80ed41ep+154,   -0x1.6d4470c47a6a3p-1,   0x1.ef738cp-2, INEXACT)
T(RN,  0x1.7523352fccaa4p+154,    0x1.3f45238ec8602p-1,  -0x1.4a1016p-4, INEXACT)
T(RN,  0x1.abd25108aba04p+154,    0x1.e219e47ebabccp-1,   0x1.41075cp-3, INEXACT)
T(RN,  0x1.6ba288a6a9dcfp+154,   -0x1.ceb08a308e74cp-1,  -0x1.e76c88p-2, INEXACT)
T(RN,  0x1.b1b41c0b6abb2p+154,   -0x1.f639e799aa332p-1,   0x1.a140c2p-5, INEXACT)
T(RN,  0x1.a7680520cca7ap+154,    0x1.f23f8d39687f5p-2,  -0x1.698f1ep-3, INEXACT)
T(RN,  0x1.804cc31b30c06p+155,   -0x1.18351276e4d68p-1,   0x1.dae906p-3, INEXACT)
T(RN,  0x1.a11d72f8cad08p+155,   -0x1.d151258b5db9ep-1,  -0x1.d217e8p-7, INEXACT)
T(RN,  0x1.646db93559e55p+155,   -0x1.062188907ed54p-3,  -0x1.9ae112p-2, INEXACT)
T(RN,  0x1.80d5be8ec55f4p+155,    -0x1.e71bf2756703p-2,  -0x1.5df964p-3, INEXACT)
T(RN,  0x1.c3dad710ef99ap+155,    0x1.8400babb06044p-1,  -0x1.d729f2p-4, INEXACT)
T(RN,  0x1.8871465074d01p+155,    0x1.f10093393c459p-1,   0x1.fa0a0ep-2, INEXACT)
T(RN,  0x1.4db70764ff57ep+155,   -0x1.5ee12edf5dac2p-1,  -0x1.dd0258p-4, INEXACT)
T(RN,  0x1.0b1b8dbca14f3p+155,    0x1.f7d91cbc587d9p-1,   0x1.3ad4dep-3, INEXACT)
T(RN,  0x1.5df039954d342p+155,    0x1.3a056b9155394p-1,  -0x1.726d28p-2, INEXACT)
T(RN,  0x1.54e056cf7712bp+155,   -0x1.9e69cc16a71c2p-2,  -0x1.aa6576p-3, INEXACT)
T(RN,  0x1.48d5fa0ed8a07p+156,   -0x1.9becfd753f288p-1,    0x1.33ee3p-2, INEXACT)
T(RN,  0x1.a9d480784b8dap+156,   -0x1.f70678b01117fp-1,  -0x1.ca3324p-4, INEXACT)
T(RN,   0x1.a75bd59fa72cp+156,    0x1.d0975bfb5544fp-1,  -0x1.3415d6p-4, INEXACT)
T(RN,  0x1.60284b8b6bf56p+156,     0x1.edaf0e7385eep-1,  -0x1.5784fap-2, INEXACT)
T(RN,  0x1.0a6af79bd617ep+156,   -0x1.2eb7b0aff893ep-3,  -0x1.aed9a4p-5, INEXACT)
T(RN,  0x1.12a6a9a4bd543p+156,   -0x1.b1f75b04cac7fp-1,   0x1.fdf098p-2, INEXACT)
T(RN,  0x1.b17bab8d46ccap+156,   -0x1.f84b861596cd9p-1,   0x1.6975d4p-4, INEXACT)
T(RN,  0x1.2d69675577d14p+156,   -0x1.e91e8cdf5d2dbp-1,  -0x1.d3a96ap-4, INEXACT)
T(RN,   0x1.e5c0776649edp+156,    0x1.df95539dddb52p-2,   -0x1.18f69p-2, INEXACT)
T(RN,  0x1.5496130184c34p+156,   -0x1.18fa2d4b5dadbp-1,  -0x1.4f14ecp-3, INEXACT)
T(RN,  0x1.3c571aceb97bbp+157,   -0x1.acd17b26d728dp-2,  -0x1.b5898cp-2, INEXACT)
T(RN,  0x1.2869e2a979d76p+157,    -0x1.ed994ae6b02ap-4,   0x1.4f2322p-4, INEXACT)
T(RN,  0x1.b3fe2b498083cp+157,    -0x1.25c62f9f83fcp-2,   0x1.9e919ap-2, INEXACT)
T(RN,  0x1.fa2b0ffd74f46p+157,    0x1.df4a2431ede52p-1,  -0x1.71f588p-4, INEXACT)
T(RN,  0x1.f1a4ba06d2f5bp+157,   -0x1.d3f0e857c4711p-1,  -0x1.86b5e8p-2, INEXACT)
T(RN,  0x1.2daa123d330fap+157,    0x1.b3524aee872eep-1,  -0x1.1583a6p-5, INEXACT)
T(RN,  0x1.7c13af4a8cbcap+157,   -0x1.551eb5a66bea1p-2,   0x1.567c72p-2, INEXACT)
T(RN,  0x1.55b32455fb49bp+157,    0x1.d56171c5a31a7p-1,   0x1.fc39fcp-2, INEXACT)
T(RN,  0x1.5ae790b7ce9f4p+157,   -0x1.26ebb1c8c6487p-2,  -0x1.b8d4d8p-2, INEXACT)
T(RN,  0x1.1e9f640167f8ap+157,   -0x1.aad7ffd56c8eep-7,   0x1.f5709cp-3, INEXACT)
T(RN,  0x1.ca88b009fcd4bp+158,    0x1.dd81741240c34p-1,   0x1.a3d0f4p-5, INEXACT)
T(RN,   0x1.1b328a0b2527p+158,    -0x1.4c662c74365bp-2,    0x1.0ac19p-2, INEXACT)
T(RN,  0x1.e15078ae6a946p+158,    0x1.e2673a30feac6p-1,  -0x1.3d9f3ap-5, INEXACT)
T(RN,  0x1.f30b627acf24ep+158,    0x1.d39d173ac8f43p-2,   -0x1.1a16fp-3, INEXACT)
T(RN,  0x1.2c70780734294p+158,   -0x1.cdb45c6ba7229p-1,  -0x1.eb8c34p-2, INEXACT)
T(RN,  0x1.0bd6106ff7e03p+158,    0x1.4efdf83cfa57dp-1,  -0x1.3fcc4ep-4, INEXACT)
T(RN,  0x1.34e6024c7720bp+158,   -0x1.f0e0336e48395p-1,  -0x1.04156ap-2, INEXACT)
T(RN,  0x1.80f6e3fe832b6p+158,    0x1.a4d1c406c6d77p-1,   0x1.5e800cp-3, INEXACT)
T(RN,  0x1.4460b18a5d85fp+158,   -0x1.ec69a88ed7ce8p-1,   0x1.4c4896p-3, INEXACT)
T(RN,   0x1.ed0e7d5270f3p+158,     0x1.f3e23adeca35p-1,  -0x1.cd4a62p-2, INEXACT)
T(RN,  0x1.fcff8ad2f8da9p+159,    0x1.3a8be2ce49fcap-2,   -0x1.ffb8cp-2, INEXACT)
T(RN,  0x1.c599a530f555bp+159,   -0x1.a21533395d624p-1,   -0x1.32e3cp-3, INEXACT)
T(RN,  0x1.234b318796c94p+159,   -0x1.8447a4578ba15p-1,  -0x1.2d51e6p-3, INEXACT)
T(RN,  0x1.83421a4fa7086p+159,    0x1.8393b168f8872p-2,   0x1.a4e5dep-5, INEXACT)
T(RN,  0x1.e2d010685d86cp+159,   -0x1.fd29a0c59017fp-1,    0x1.5d038p-2, INEXACT)
T(RN,  0x1.57253cc18412dp+159,    0x1.e415512e70305p-1,  -0x1.adfd48p-2, INEXACT)
T(RN,  0x1.48b38b7d8b3bcp+159,     0x1.5975a423881bp-1,  -0x1.2a6d8ep-2, INEXACT)
T(RN,  0x1.d4e66ba474eb6p+159,   -0x1.9530d0ed08fb7p-5,   -0x1.1ff95p-3, INEXACT)
T(RN,  0x1.c8cdcb880622cp+159,   -0x1.feb64db2feb88p-1,   0x1.2f4318p-2, INEXACT)
T(RN,  0x1.8142615ab4002p+159,   -0x1.f3059496d126cp-1,   -0x1.0095ap-3, INEXACT)
T(RN,  0x1.a1493a751dd58p+160,    0x1.09e7cb89823e5p-1,   0x1.c5594ep-5, INEXACT)
T(RN,  0x1.9f1ef0fa336d8p+160,    0x1.84cfdbafbee1dp-3,   0x1.239e14p-2, INEXACT)
T(RN,    0x1.72a64b3cd95p+160,   -0x1.4a88e5edf368dp-1,   0x1.a57decp-2, INEXACT)
T(RN,  0x1.4dc8b4247ed2bp+160,    0x1.8133b9f65e086p-1,  -0x1.b4d35ap-9, INEXACT)
T(RN,  0x1.93acc86c360a8p+160,    0x1.134dbccb6c3b6p-3,  -0x1.1af90cp-2, INEXACT)
T(RN,  0x1.dde5a6ed5569fp+160,    0x1.fbf1bfeec7e16p-1,    0x1.7de3dp-2, INEXACT)
T(RN,  0x1.8f474100cc0a1p+160,   -0x1.ffff08ed4ad14p-1,  -0x1.314c68p-5, INEXACT)
T(RN,  0x1.2ba61d77cc201p+160,   -0x1.0928b0026492bp-2,   0x1.7e109cp-2, INEXACT)
T(RN,  0x1.248eac54a79b8p+160,    0x1.6dac29a136c8dp-1,   0x1.9f89e4p-4, INEXACT)
T(RN,  0x1.7c19470fbcd15p+160,    0x1.4fb75b853951ep-1,  -0x1.d6fa04p-4, INEXACT)
T(RN,  0x1.c4ed71c6e9262p+161,   -0x1.a10a62e0dddf8p-1,   0x1.54034ep-3, INEXACT)
T(RN,  0x1.f7ee6d4e9bdf9p+161,   -0x1.c30beebf21e29p-1,   0x1.79d2d8p-2, INEXACT)
T(RN,  0x1.1060c969ab3b1p+161,   -0x1.fd63077d4642cp-1,   0x1.83d41cp-2, INEXACT)
T(RN,  0x1.716e4a30e72c2p+161,   -0x1.fd5eaa42825dbp-1,   0x1.3e4332p-2, INEXACT)
T(RN,  0x1.4679acf5a10a7p+161,    0x1.7702377f13862p-2,   0x1.5c9af6p-2, INEXACT)
T(RN,  0x1.a93e5314e7d98p+161,   -0x1.df22516df70a8p-2,  -0x1.32a768p-2, INEXACT)
T(RN,  0x1.22334ab71b5bfp+161,    0x1.f77637f589b0dp-1,   0x1.0f941ap-3, INEXACT)
T(RN,  0x1.b7e71dda10a68p+161,    0x1.9943160326d39p-4,  -0x1.14314cp-2, INEXACT)
T(RN,  0x1.b7fdd4ccf6262p+161,    0x1.b724440e6e9ebp-3,   0x1.c28ad4p-2, INEXACT)
T(RN,  0x1.8b86391df0039p+161,     0x1.abff9641d6f7p-1,   0x1.300af2p-2, INEXACT)
T(RN,  0x1.aae3d4b10e007p+162,   -0x1.955901e1c25b6p-1,  -0x1.af86f2p-4, INEXACT)
T(RN,  0x1.3fd035f15b599p+162,   -0x1.ce0d6429fd97fp-1,   -0x1.cd96ep-2, INEXACT)
T(RN,  0x1.364e91e5144ecp+162,   -0x1.69ef405de6aa9p-5,   0x1.c40c66p-2, INEXACT)
T(RN,  0x1.fcab5f8e41d22p+162,   -0x1.fed1ecc424d6bp-1,   -0x1.70d7fp-8, INEXACT)
T(RN,  0x1.2ec92a50e7a4fp+162,   -0x1.3c974c71a1d48p-1,   0x1.ead88ap-2, INEXACT)
T(RN,  0x1.1fb8555032772p+162,   -0x1.de5b917fa15d7p-3,  -0x1.0ab874p-2, INEXACT)
T(RN,  0x1.da3b96f885192p+162,   -0x1.1b16497d9af36p-2,   0x1.f3ddc6p-5, INEXACT)
T(RN,  0x1.f2b78514ad933p+162,   -0x1.cbe826748257ep-3,   -0x1.bd236p-3, INEXACT)
T(RN,  0x1.a98d12b47f3d8p+162,   -0x1.cd8c3af4f6b79p-2,   0x1.f9dea8p-3, INEXACT)
T(RN,   0x1.551a653d722ap+162,   -0x1.ff2c4eaf9bbe9p-1,  -0x1.79df12p-2, INEXACT)
T(RN,  0x1.2d07bf8a37649p+163,   -0x1.ff65161204178p-1,  -0x1.27863cp-5, INEXACT)
T(RN,   0x1.d958ad7aec4bp+163,   -0x1.005167abca39ep-2,   0x1.3a1712p-2, INEXACT)
T(RN,  0x1.bedd099dacd0fp+163,   -0x1.7b9ecaf3dcc66p-1,     0x1.8115p-3, INEXACT)
T(RN,  0x1.c752e7bd420c8p+163,    0x1.38e2ee5519096p-4,    0x1.480c1p-3, INEXACT)
T(RN,  0x1.5200183413c7cp+163,   -0x1.afde85e96be13p-2,   0x1.68e34ep-2, INEXACT)
T(RN,  0x1.705d6b4b753bbp+163,    0x1.4739701b1e56ep-1,   0x1.f8394cp-2, INEXACT)
T(RN,  0x1.48cdfd6e8b67cp+163,   -0x1.cd268f1d2ff9dp-1,   0x1.204ebap-8, INEXACT)
T(RN,  0x1.9d638b17e9bb2p+163,   -0x1.9daee29253178p-1,   0x1.1998bcp-2, INEXACT)
T(RN,  0x1.b78847a328508p+163,    0x1.f3ec118b960edp-1,    0x1.93b12p-2, INEXACT)
T(RN,  0x1.64aea79e1f03ep+163,    0x1.3fe46951e5c2fp-1,   0x1.8fba76p-6, INEXACT)
T(RN,  0x1.2878c32265aacp+164,    0x1.5792ddeff661ep-1,   -0x1.f34f8p-2, INEXACT)
T(RN,  0x1.84de38713e29dp+164,    0x1.fb8c96b84923ep-1,   0x1.a2eb8cp-2, INEXACT)
T(RN,  0x1.97f4832c4c116p+164,   -0x1.b5f47d91eb831p-1,  -0x1.7041a2p-2, INEXACT)
T(RN,  0x1.eb6e921b8a516p+164,   -0x1.1bc4b3705fb32p-3,   0x1.3abaecp-2, INEXACT)
T(RN,  0x1.4e4de5f89d148p+164,   -0x1.cf742019b16fbp-1,   0x1.f201a2p-3, INEXACT)
T(RN,  0x1.bdb4edd735854p+164,   -0x1.d5f583f922ddbp-1,   0x1.89c3bap-2, INEXACT)
T(RN,  0x1.d3c5ff77abe83p+164,    0x1.7e77ad40bbc12p-1,   0x1.843fdcp-2, INEXACT)
T(RN,  0x1.cdf0eaf6261fcp+164,   -0x1.620134bf89722p-7,  -0x1.1952cep-3, INEXACT)
T(RN,   0x1.d4eefc22457fp+164,   -0x1.152534590e45ep-2,    0x1.68b0bp-2, INEXACT)
T(RN,  0x1.fb2a74c32edd7p+164,    0x1.fd039354ebe6ep-2,  -0x1.f73f44p-2, INEXACT)
T(RN,  0x1.73bac6bdbb2d8p+165,    0x1.b4081453e4faep-1,  -0x1.d23e22p-2, INEXACT)
T(RN,   0x1.389e3f1614c8p+165,    0x1.263c51a317216p-1,   0x1.b4de1ep-2, INEXACT)
T(RN,  0x1.c04996ab7a368p+165,   -0x1.e8bfbbbe5d016p-3,  -0x1.2830a2p-3, INEXACT)
T(RN,  0x1.4912f13028238p+165,    0x1.f75d47245e08ap-1,  -0x1.5f81f2p-3, INEXACT)
T(RN,  0x1.4d0cd5f866a3ep+165,    0x1.542861639be5cp-5,  -0x1.143c2ep-2, INEXACT)
T(RN,  0x1.639aaac5aeae2p+165,   -0x1.5ca8c08a338ffp-3,   0x1.32cf46p-6, INEXACT)
T(RN,  0x1.5e1e9ce653f3ap+165,    0x1.d3e8e3f70a434p-1,   0x1.89b0e2p-2, INEXACT)
T(RN,  0x1.3ae17291312a4p+165,   -0x1.6113d149f6062p-1,   0x1.5f0e0ap-2, INEXACT)
T(RN,  0x1.50bb896b1e7a7p+165,    0x1.1673a9b21377bp-1,  -0x1.8fc2f4p-3, INEXACT)
T(RN,  0x1.30bf403615bdcp+165,   -0x1.388d038c86f2fp-3,   0x1.e6b43ap-3, INEXACT)
T(RN,  0x1.e86d1b2d3d591p+166,   -0x1.b32e75832343fp-1,   0x1.af3f9ep-2, INEXACT)
T(RN,  0x1.f0777c65ff474p+166,   -0x1.3d7a9fefb65bcp-4,  -0x1.478ce8p-3, INEXACT)
T(RN,  0x1.e9152ddda565ep+166,   -0x1.09f59c308e88dp-1,   0x1.537d1cp-2, INEXACT)
T(RN,   0x1.0cc88a3ec5a1p+166,    0x1.5c872d12f48edp-3,   0x1.7eab96p-3, INEXACT)
T(RN,  0x1.66b92b93db533p+166,   -0x1.21d94bf024793p-1,  -0x1.3c571ap-4, INEXACT)
T(RN,  0x1.2eb6e97fe7171p+166,    0x1.8aec3f963cfdfp-4,   0x1.aba1c4p-2, INEXACT)
T(RN,  0x1.7122d6d645f72p+166,    0x1.3943e87755734p-3,   0x1.c473ccp-3, INEXACT)
T(RN,  0x1.ec16d5edca92fp+166,    0x1.1ccc280d1018bp-2,   -0x1.d9866p-2, INEXACT)
T(RN,  0x1.772d5e3186737p+166,    0x1.a9b729237f357p-1,  -0x1.168eeap-3, INEXACT)
T(RN,  0x1.9abd2d947eb04p+166,    -0x1.71e697344c94p-1,   0x1.17a2bep-2, INEXACT)
T(RN,  0x1.b7a11486a13ebp+167,   -0x1.c079237f0f884p-4,  -0x1.1bcbbcp-2, INEXACT)
T(RN,  0x1.c125714e576e4p+167,    0x1.260fb85b5b4d9p-1,   -0x1.a6448p-2, INEXACT)
T(RN,  0x1.ad76bd22fe676p+167,   -0x1.48f296a410ce9p-2,   0x1.62d82cp-2, INEXACT)
T(RN,  0x1.42147584b4d12p+167,    0x1.d0e88c9663107p-2,   0x1.16ef1cp-2, INEXACT)
T(RN,  0x1.0b818ff6fdc0dp+167,   0x1.e472a25fc4d16p-12,  -0x1.3dbcfap-2, INEXACT)
T(RN,  0x1.883072b282cb6p+167,   -0x1.00f192a095cf8p-1,    0x1.c4e52p-2, INEXACT)
T(RN,  0x1.acf2fcbaab412p+167,    0x1.14ba725561983p-1,   0x1.eb123ap-3, INEXACT)
T(RN,  0x1.76c9abfd311cap+167,    0x1.d5d8fd345cb7dp-2,  -0x1.ee83c4p-4, INEXACT)
T(RN,  0x1.085beacd07079p+167,    0x1.b7444517104aap-1,  -0x1.b75968p-2, INEXACT)
T(RN,  0x1.e29daab65dd44p+167,   -0x1.11e70323d9712p-1,   0x1.f54368p-2, INEXACT)
T(RN,  0x1.69e0b9ee5c0f6p+168,    0x1.887b9970f7e2ep-3,  -0x1.760c08p-2, INEXACT)
T(RN,   0x1.51be2330d3e8p+168,    0x1.9c9fde9ceb17fp-1,   0x1.c7deeep-3, INEXACT)
T(RN,  0x1.8561dec6b6242p+168,   -0x1.3b545ec31bcbdp-1,  -0x1.9cef04p-4, INEXACT)
T(RN,  0x1.5c8f80c0a6737p+168,    0x1.060de9f5e7112p-2,   -0x1.52c68p-4, INEXACT)
T(RN,  0x1.dbdbf1408c5c2p+168,    0x1.a39fd275ae94cp-1,   0x1.ab5424p-8, INEXACT)
T(RN,  0x1.bdf031fd9a34bp+168,    0x1.01da6d1377915p-3,   0x1.296326p-3, INEXACT)
T(RN,  0x1.0770dda8d747ap+168,   -0x1.f5e873b2abdcfp-1,   0x1.9a6c3ap-2, INEXACT)
T(RN,  0x1.98502c0ce2d3dp+168,    -0x1.cdba4d4b893ep-4,   0x1.71121cp-5, INEXACT)
T(RN,  0x1.6e284144b37f1p+168,    0x1.440d723542daap-2,   0x1.e01964p-2, INEXACT)
T(RN,  0x1.5217aaff543e2p+168,    0x1.cc2687d6f03d4p-1,   0x1.76714ap-2, INEXACT)
T(RN,  0x1.7c4728d872518p+169,    0x1.40303953791d7p-2,   0x1.5b0496p-3, INEXACT)
T(RN,  0x1.89b670fa9376ap+169,    -0x1.cc37f606caedp-1,   0x1.82d806p-2, INEXACT)
T(RN,  0x1.b54f0ddc03d08p+169,    0x1.db252180e8c4cp-1,  -0x1.0ef776p-2, INEXACT)
T(RN,  0x1.6346fb018c9e5p+169,    0x1.fd50d930c3dbap-2,  -0x1.8b48a6p-5, INEXACT)
T(RN,  0x1.e6ef1e2146247p+169,   -0x1.0213974f69b77p-1,  -0x1.753edep-2, INEXACT)
T(RN,  0x1.f5baf122fe82fp+169,   -0x1.9e5e66d7035e7p-1,  -0x1.9d7902p-2, INEXACT)
T(RN,  0x1.87e7852b8c703p+169,   -0x1.fe705cdf893eep-1,   0x1.768686p-2, INEXACT)
T(RN,  0x1.f83b6bc1e7d5ap+169,    0x1.03185935abbbfp-1,  -0x1.43129ap-2, INEXACT)
T(RN,  0x1.d00b664a9204bp+169,   -0x1.fffc985de618cp-1,  -0x1.16925ep-3, INEXACT)
T(RN,  0x1.f393763e8dcaep+169,   -0x1.bb5d47e7336d7p-1,   0x1.43b66cp-2, INEXACT)
T(RN,  0x1.13c313169156ep+170,    0x1.57d57e8d0ea86p-1,   0x1.662018p-2, INEXACT)
T(RN,  0x1.a4fe115ae50b6p+170,    0x1.df3a74d38b828p-1,  -0x1.dc128ep-2, INEXACT)
T(RN,  0x1.ff5017fa260f8p+170,   -0x1.7f52d6eab23e2p-1,  -0x1.fead4ap-2, INEXACT)
T(RN,  0x1.c2a77740fe55cp+170,    0x1.31106bf08d1ccp-1,   -0x1.771c7p-3, INEXACT)
T(RN,  0x1.b122e41856388p+170,    -0x1.3c541e0d7b41p-3,    -0x1.2aeep-5, INEXACT)
T(RN,  0x1.67d85530caf6ep+170,    0x1.cf23233fb9524p-2,  -0x1.49f626p-5, INEXACT)
T(RN,  0x1.d6cf9d7069bf9p+170,    0x1.857c8eb1f0aa3p-3,   -0x1.c0f01p-3, INEXACT)
T(RN,  0x1.4318e833ab139p+170,    0x1.ee10bfc9355ddp-1,  -0x1.19dbcep-2, INEXACT)
T(RN,   0x1.d96be826f6c5p+170,   -0x1.c591c53b8f074p-1,   0x1.1f8724p-7, INEXACT)
T(RN,  0x1.ad8623800a86ap+170,    0x1.6a5840930d35cp-2,   0x1.185778p-2, INEXACT)
T(RN,  0x1.354ac6b0c51fdp+171,   -0x1.fe8bdfa88806ap-1,   0x1.d6388ap-3, INEXACT)
T(RN,  0x1.59b46ccd3cad6p+171,   -0x1.afe17fdd16e2ep-1,   0x1.36bb3ap-2, INEXACT)
T(RN,  0x1.56ad519e4bcffp+171,   -0x1.e911763b786b2p-1,   0x1.4daaa8p-7, INEXACT)
T(RN,  0x1.86691daa40d82p+171,   -0x1.f727069ac4bb8p-1,   0x1.d6d822p-3, INEXACT)
T(RN,  0x1.e231a3879b884p+171,   -0x1.0a1774bbfb1dep-3,   -0x1.8790ep-2, INEXACT)
T(RN,  0x1.b45ac253a485bp+171,    0x1.a3bfef30e0fffp-2,  -0x1.913ddcp-7, INEXACT)
T(RN,  0x1.b9f8a91edd4a5p+171,    0x1.c364678ed16bdp-4,   0x1.94c1ecp-2, INEXACT)
T(RN,  0x1.8bc3481633c99p+171,    0x1.fe9322b36cf0cp-1,   0x1.a27668p-2, INEXACT)
T(RN,  0x1.54394b6f81cb5p+171,     0x1.6d63fd1a615ap-4,  -0x1.18da32p-2, INEXACT)
T(RN,  0x1.7017596e65b62p+171,    0x1.e9807af891b77p-1,    0x1.2b062p-3, INEXACT)
T(RN,  0x1.4fc51680efa53p+172,   -0x1.1d860d70c4348p-5,    0x1.a482bp-8, INEXACT)
T(RN,  0x1.f9fe2d398f63ep+172,    0x1.d97a67f202a89p-1,  -0x1.36147ap-4, INEXACT)
T(RN,  0x1.6e4d8a5bf4885p+172,    0x1.b1684c0aa0c9ap-1,  -0x1.0f1026p-2, INEXACT)
T(RN,  0x1.e25e5011e2168p+172,   -0x1.56c4d35a531e9p-1,  -0x1.be119ep-2, INEXACT)
T(RN,  0x1.29d52ba17ef8ap+172,   -0x1.f6ca6e4d3359cp-1,  -0x1.27fdbcp-7, INEXACT)
T(RN,  0x1.e29608141debep+172,    0x1.ee26d0006ced6p-1,  -0x1.040abep-4, INEXACT)
T(RN,  0x1.7483faaa1038cp+172,    0x1.679d4d1493637p-3,  -0x1.25fbe4p-2, INEXACT)
T(RN,  0x1.d44acc6437672p+172,   -0x1.96c0a12f668b9p-3,  -0x1.7f484ep-2, INEXACT)
T(RN,  0x1.de18710ced394p+172,    0x1.3c5a90408f9bcp-1,   0x1.14bb22p-4, INEXACT)
T(RN,  0x1.964d1af17f0aep+172,    0x1.f71d4c258fb3ap-1,   0x1.d75c64p-4, INEXACT)
T(RN,  0x1.5105ed03abbedp+173,   -0x1.717fef89fb163p-1,   0x1.cd46d2p-5, INEXACT)
T(RN,  0x1.45654df97ee3cp+173,    0x1.f2e91eb776692p-1,    0x1.527a7p-3, INEXACT)
T(RN,  0x1.c5b91769caefep+173,    -0x1.3a0afce79796p-2,   0x1.e7dd8cp-2, INEXACT)
T(RN,  0x1.3428f7a18dbf4p+173,   -0x1.0e11a49e6e019p-1,   0x1.d564e6p-2, INEXACT)
T(RN,  0x1.03d48c7fa8178p+173,     0x1.25b88bbd9806p-1,  -0x1.1a3dfcp-5, INEXACT)
T(RN,  0x1.825685456d884p+173,   -0x1.3b9ff4372b1b2p-3,   0x1.966f88p-3, INEXACT)
T(RN,  0x1.75a88234b98cbp+173,   -0x1.1c7c6b4db6c8fp-1,  -0x1.f45526p-3, INEXACT)
T(RN,  0x1.dcd397c13cbc6p+173,   -0x1.8e7095f13559ep-3,   -0x1.7ecbfp-3, INEXACT)
T(RN,  0x1.4393230cedf38p+173,    0x1.9b79b6b62489cp-1,   0x1.243036p-3, INEXACT)
T(RN,  0x1.3380c9065f3a6p+173,    0x1.864b2fbed549cp-1,   0x1.bc2b5ap-4, INEXACT)
T(RN,  0x1.e05aac1aefa18p+174,    -0x1.b2776f79cdddp-3,   0x1.b9d332p-5, INEXACT)
T(RN,  0x1.e6fe10536aeb2p+174,   -0x1.a47fdfd34f16fp-1,   0x1.f70668p-2, INEXACT)
T(RN,   0x1.cb269594aec2p+174,    0x1.dbb84bce641a5p-8,  -0x1.a7f404p-2, INEXACT)
T(RN,  0x1.9b3ca6a6df548p+174,   -0x1.fd7054a2da8b1p-1,   0x1.8b28b2p-2, INEXACT)
T(RN,  0x1.69f947d09895bp+174,    0x1.e9dd487fa987cp-1,   0x1.d4f614p-3, INEXACT)
T(RN,  0x1.9e0c82bc46751p+174,   -0x1.78eb5a92cd773p-2,   -0x1.9d7f6p-2, INEXACT)
T(RN,  0x1.0e90a1c07f79ep+174,   -0x1.d2dfa3638ce93p-1,   0x1.627458p-3, INEXACT)
T(RN,  0x1.635a39756ca2dp+174,    0x1.f58a0bf21f492p-1,   0x1.6761fep-3, INEXACT)
T(RN,  0x1.d6906c9818967p+174,    0x1.28c1a41000621p-1,  -0x1.6dec36p-2, INEXACT)
T(RN,  0x1.0dc574e651301p+174,   -0x1.2b588d33f4c72p-1,   0x1.e1a356p-2, INEXACT)
T(RN,  0x1.4624aa3c5dbdep+175,    0x1.8e872fa41431cp-1,   0x1.367d92p-2, INEXACT)
T(RN,   0x1.db2178f6c0dbp+175,    0x1.0141df988a559p-1,   0x1.b90928p-2, INEXACT)
T(RN,  0x1.e9a6006f2c7f8p+175,    0x1.2a806ad63116fp-1,   0x1.07bee2p-2, INEXACT)
T(RN,  0x1.325852a3e18c9p+175,    0x1.101d7d4635e53p-4,  -0x1.ddd48ep-5, INEXACT)
T(RN,  0x1.d5910a6e41608p+175,   -0x1.fea87afd86f5ep-1,   0x1.6ddfbep-6, INEXACT)
T(RN,  0x1.8c5ab06fc6389p+175,    0x1.c1b798399a8bap-1,   0x1.f2ba1ep-2, INEXACT)
T(RN,  0x1.2a3309674d819p+175,    0x1.fedbe450fa0cap-1,   0x1.d316fep-4, INEXACT)
T(RN,  0x1.f62e6bee10d2ep+175,   -0x1.eff0e9efc58fcp-1,  -0x1.d317aap-2, INEXACT)
T(RN,  0x1.26bb0d421483cp+175,   -0x1.bc3c50d745c4fp-2,   0x1.d1c442p-3, INEXACT)
T(RN,  0x1.31ee863c14f87p+175,    0x1.3c2cc86551634p-2,   -0x1.3b826p-3, INEXACT)
T(RN,  0x1.b277299ad11fcp+176,   -0x1.568b38d54afa1p-2,   0x1.83186cp-2, INEXACT)
T(RN,  0x1.af48b89da42fep+176,   -0x1.ddc36ac4d62d8p-1,  -0x1.e445e2p-3, INEXACT)
T(RN,  0x1.c821e3e2a7031p+176,   -0x1.d24f899b7fa04p-8,   0x1.e8abb2p-6, INEXACT)
T(RN,  0x1.695f34f8f7158p+176,   -0x1.de793fc798a5bp-1,  -0x1.b776bap-4, INEXACT)
T(RN,  0x1.190b8ab548ca5p+176,    0x1.df5ea3c5ab9cdp-1,  -0x1.dd985cp-2, INEXACT)
T(RN,  0x1.8cdbd4476de39p+176,    0x1.8807b77d56165p-1,  -0x1.737f34p-6, INEXACT)
T(RN,   0x1.49fdba6b5293p+176,    0x1.e7a40f1f673bbp-1,   -0x1.6fb84p-2, INEXACT)
T(RN,  0x1.85efdd4601232p+176,    0x1.2a29fe7f0a17bp-1,   0x1.b5858cp-2, INEXACT)
T(RN,  0x1.c86315647a91ap+176,     0x1.4523ab4472d9p-1,   0x1.1cb224p-4, INEXACT)
T(RN,  0x1.22375b8f71d75p+176,   -0x1.866c5f0c24595p-1,  -0x1.1a0f64p-2, INEXACT)
T(RN,  0x1.c2e043891b674p+177,    0x1.fc54848272144p-1,  -0x1.62dc92p-3, INEXACT)
T(RN,  0x1.42b6e580679a2p+177,   -0x1.f861f5fe0ffabp-1,   0x1.5e1542p-2, INEXACT)
T(RN,  0x1.b5b3e81b5c5aep+177,    0x1.f1a2dc3f51cfap-1,  -0x1.fcacd8p-3, INEXACT)
T(RN,  0x1.419f6361814e1p+177,   -0x1.bc6689a04018ep-1,   0x1.11d3d4p-3, INEXACT)
T(RN,  0x1.0436ecf4ce98bp+177,   -0x1.cf25b48f37b5dp-1,  -0x1.65f73ep-3, INEXACT)
T(RN,  0x1.be19e97117792p+177,    0x1.6626115e16c56p-1,   0x1.bebdbap-5, INEXACT)
T(RN,  0x1.baac26cb09e92p+177,    0x1.5af1c947c4105p-1,  -0x1.e4f8b6p-2, INEXACT)
T(RN,  0x1.95c78247e3b13p+177,    0x1.9e2e764cada9dp-1,   0x1.0be80ep-2, INEXACT)
T(RN,  0x1.0c9e7d910588fp+177,    0x1.6177ffe54c42dp-1,   0x1.cd5ad8p-3, INEXACT)
T(RN,   0x1.9d9743df0943p+177,    0x1.d8c17a4cf4b01p-2,   0x1.6ef26ep-2, INEXACT)
T(RN,  0x1.fbc25a53430edp+178,    0x1.a5c0dd9d89358p-1,  -0x1.9587b4p-3, INEXACT)
T(RN,  0x1.69d10a3687c4ep+178,   -0x1.f78ffd33e0ffdp-1,   -0x1.6e191p-4, INEXACT)
T(RN,  0x1.4bb7eaf92e4a7p+178,   -0x1.b03c36e601e6bp-4,  -0x1.3feb36p-2, INEXACT)
T(RN,  0x1.f1ae6c45ed5b5p+178,   -0x1.560b28e9760cfp-1,   0x1.adcfacp-2, INEXACT)
T(RN,  0x1.aa55d44dd83c4p+178,    0x1.98ad88e7c49f8p-1,   0x1.57459cp-2, INEXACT)
T(RN,  0x1.d3754c69fd836p+178,   -0x1.ac1258b4e40a2p-1,  -0x1.a0267cp-4, INEXACT)
T(RN,  0x1.1af50fc796608p+178,   -0x1.c0574656b3fdfp-1,   0x1.4c2f88p-3, INEXACT)
T(RN,  0x1.1c8220603bc55p+178,   -0x1.633bec5783446p-1,  -0x1.c1f394p-2, INEXACT)
T(RN,    0x1.f52cd46f06cp+178,    0x1.e0e1d710070e8p-1,  -0x1.b638b4p-3, INEXACT)
T(RN,  0x1.1454dc4d466adp+178,   -0x1.eeebd31c68d32p-1,    -0x1.2b28p-2, INEXACT)
T(RN,  0x1.09d9eac6dd569p+179,    0x1.b57b01cb7eb12p-1,   0x1.3b8c1ep-3, INEXACT)
T(RN,  0x1.de1a84cb994e7p+179,    0x1.359d545e417dfp-1,    0x1.f4416p-3, INEXACT)
T(RN,  0x1.1eb6a09e704f6p+179,    0x1.b19b2a91f6af3p-1,   0x1.27d8a8p-2, INEXACT)
T(RN,  0x1.c05879304f0dep+179,    0x1.8c6e6e6b8d40dp-4,  -0x1.90a244p-2, INEXACT)
T(RN,  0x1.1a795a46f0161p+179,    0x1.b3379abb2de68p-3,   0x1.1e7d3ep-3, INEXACT)
T(RN,  0x1.6151bc10f066ep+179,    0x1.38a0ede7c7588p-1,  -0x1.6403d8p-2, INEXACT)
T(RN,  0x1.555aaad99f086p+179,    0x1.d838032be2025p-1,  -0x1.c6dcf6p-4, INEXACT)
T(RN,  0x1.a9557964eaa52p+179,    0x1.cf258ca33f006p-1,  -0x1.603254p-3, INEXACT)
T(RN,  0x1.124af9367b666p+179,   -0x1.76519d8c3888dp-1,    0x1.42313p-2, INEXACT)
T(RN,  0x1.2cdd511cc118cp+179,    0x1.b42b04ede823bp-1,  -0x1.5a7dfap-2, INEXACT)
T(RN,  0x1.f725547316dc4p+180,   -0x1.b05e6cd9b6739p-1,  -0x1.907232p-2, INEXACT)
T(RN,  0x1.7b99ee4bf157ep+180,   -0x1.f475122d2bee6p-1,  -0x1.d0f06cp-2, INEXACT)
T(RN,  0x1.1ae980396c89bp+180,    0x1.96b71a18cdf8bp-1,   0x1.0bf30cp-2, INEXACT)
T(RN,  0x1.2562b23777c3ep+180,    0x1.0282ce41dfff6p-1,   0x1.5d7efcp-2, INEXACT)
T(RN,  0x1.de46113683b4ep+180,     0x1.fd98df993432p-1,  -0x1.55cb56p-5, INEXACT)
T(RN,   0x1.4a41e477c8a5p+180,    0x1.d05742df65a43p-1,  -0x1.79f062p-3, INEXACT)
T(RN,  0x1.01de94292e0aap+180,   -0x1.cbc584210e8d8p-1,  -0x1.30f1b6p-3, INEXACT)
T(RN,    0x1.c12b089d8cbp+180,   -0x1.14848797bbc41p-1,  -0x1.ed8ea6p-2, INEXACT)
T(RN,  0x1.1c9e0387096b3p+180,   -0x1.649d3642797c1p-1,   0x1.7fd6c2p-2, INEXACT)
T(RN,  0x1.1c64b1c0c7947p+180,   -0x1.c92b582f38847p-2,    0x1.75e57p-2, INEXACT)
T(RN,  0x1.689493b8a8f6ep+181,    0x1.ad436fe4c83b8p-4,   0x1.0e05c6p-2, INEXACT)
T(RN,  0x1.1fa31ec86fa43p+181,    0x1.cbb4f56d32b76p-1,   0x1.e9e702p-3, INEXACT)
T(RN,  0x1.695466f24fc1ap+181,    0x1.aa7bd28203d47p-7,  -0x1.e78282p-2, INEXACT)
T(RN,  0x1.538dc415e9309p+181,   -0x1.f63386d5f562cp-1,   -0x1.a9121p-3, INEXACT)
T(RN,  0x1.70e63be2eb343p+181,   -0x1.fb178019a8ae7p-3,  -0x1.6ad57ap-3, INEXACT)
T(RN,  0x1.608d882673dbep+181,    0x1.b30b9b05b58c8p-1,  -0x1.4f9c88p-3, INEXACT)
T(RN,  0x1.01fcd15192ae5p+181,    -0x1.666cfb82fc7ep-3,   0x1.5d589ap-2, INEXACT)
T(RN,  0x1.82c6044f3c80ep+181,   -0x1.fb61266ca6f7fp-1,   0x1.dff566p-4, INEXACT)
T(RN,  0x1.0eeb8285dd96cp+181,     0x1.f9368aae7c5dp-1,   0x1.bfc5a8p-3, INEXACT)
T(RN,   0x1.b2b73ae149c1p+181,   -0x1.76401650c3022p-1,   0x1.b8796ep-4, INEXACT)
T(RN,  0x1.1e35c6658dd43p+182,    0x1.9cd33b3407f19p-1,  -0x1.87c212p-2, INEXACT)
T(RN,  0x1.b36f1ed00d93cp+182,    0x1.2203a7552ec9ap-2,  -0x1.c09f78p-4, INEXACT)
T(RN,  0x1.491ad9055ee2ap+182,   -0x1.f9640123870c2p-1,   0x1.546a88p-4, INEXACT)
T(RN,  0x1.5428aa28466a8p+182,    0x1.21664706ef649p-1,   0x1.4ebabep-2, INEXACT)
T(RN,  0x1.2c1e237dd66f6p+182,    0x1.621462cfe862ep-2,   0x1.b81026p-4, INEXACT)
T(RN,  0x1.edb300dad202ap+182,    0x1.e351322119934p-1,   0x1.68fefcp-2, INEXACT)
T(RN,   0x1.2f99d12f9429p+182,   -0x1.e97ce0ad8857bp-2,  -0x1.4e0b66p-2, INEXACT)
T(RN,  0x1.a486dc1db1eb1p+182,    0x1.4753dd0496b82p-2,   0x1.858134p-2, INEXACT)
T(RN,  0x1.6bb6f51b4a25bp+182,    -0x1.e5b1a8fd72dcp-2,  -0x1.13dd28p-6, INEXACT)
T(RN,  0x1.eec89dd101078p+182,    0x1.cd559b4a22a4bp-2,   0x1.24cf08p-3, INEXACT)
T(RN,  0x1.64aaf83d81e4ep+183,    0x1.d6872faeec635p-1,   0x1.bcfcdep-4, INEXACT)
T(RN,  0x1.367e989db4ce9p+183,    0x1.c4998d22fbfaap-1,  -0x1.5c7d14p-5, INEXACT)
T(RN,  0x1.4e469c88736f4p+183,    0x1.c669d21181ea5p-1,   0x1.c59512p-2, INEXACT)
T(RN,  0x1.df3815e674d12p+183,    -0x1.fffbc9ca7417p-1,  -0x1.e4341ep-5, INEXACT)
T(RN,  0x1.5e0bd09772002p+183,   -0x1.d5b2f6c19ac72p-1,   0x1.b5d4fep-2, INEXACT)
T(RN,  0x1.6885febe6d458p+183,   -0x1.5ffaa560cfdb8p-2,    0x1.83f64p-2, INEXACT)
T(RN,  0x1.621f7bfe34c24p+183,   -0x1.e6b52041de85cp-1,   0x1.ea7964p-2, INEXACT)
T(RN,  0x1.1ba13eb9d4bdep+183,    0x1.7e4f63928c362p-1,   0x1.44ef38p-2, INEXACT)
T(RN,  0x1.46ae549646198p+183,   -0x1.e57a91e6ceff6p-1,   -0x1.c7f7fp-5, INEXACT)
T(RN,  0x1.2ac4ab2bbd992p+183,   -0x1.b7915fb0299b4p-2,   0x1.8cc33cp-2, INEXACT)
T(RN,  0x1.50ec864af27b7p+184,     0x1.dfa3eaec7fcap-1,  -0x1.f57198p-3, INEXACT)
T(RN,  0x1.c16fca3d5c718p+184,   -0x1.083211219e83fp-1,   0x1.b1f4a4p-3, INEXACT)
T(RN,   0x1.bf60cab5f83fp+184,   -0x1.c72dc04cae951p-1,   0x1.251968p-2, INEXACT)
T(RN,  0x1.92cad219f2406p+184,    0x1.3d7db3e6808fcp-1,  -0x1.f769acp-4, INEXACT)
T(RN,  0x1.e867cd50cf354p+184,    0x1.802e872a55815p-1,   0x1.6000fcp-3, INEXACT)
T(RN,  0x1.94317f09bc14dp+184,   -0x1.e44bd78278d87p-2,   0x1.d7d8a4p-3, INEXACT)
T(RN,  0x1.e8548f14ecbbep+184,    0x1.c12171dcf4e65p-1,  -0x1.144a32p-2, INEXACT)
T(RN,  0x1.a49e8c79a656fp+184,   -0x1.8751d55da1c46p-1,   -0x1.26b93p-2, INEXACT)
T(RN,  0x1.7f35b9befe37ap+184,   -0x1.eace720d0a028p-1,   0x1.357facp-2, INEXACT)
T(RN,  0x1.0e98ae7a17e52p+184,   -0x1.d0ee56f575838p-2,  -0x1.709b26p-3, INEXACT)
T(RN,  0x1.73ec1b6db4f8ap+185,   -0x1.66f10add362cdp-1,   -0x1.75e0ap-3, INEXACT)
T(RN,  0x1.dfd3eb7e5006dp+185,   -0x1.c1e43bc6b9f47p-1,   0x1.69e778p-3, INEXACT)
T(RN,  0x1.56b0dd447a30bp+185,   -0x1.fffd425bd42efp-1,   0x1.1738f2p-6, INEXACT)
T(RN,  0x1.6f39a37263084p+185,    0x1.5d379568e94fcp-1,     0x1.a635p-2, INEXACT)
T(RN,  0x1.716e564a5f492p+185,    0x1.f86230b3e323dp-1,   0x1.10b508p-6, INEXACT)
T(RN,  0x1.49940912561d4p+185,     0x1.ddee9950b55ap-1,   0x1.b55114p-2, INEXACT)
T(RN,  0x1.69c665f40b5f7p+185,   -0x1.fff6e524f579cp-1,   0x1.2d6518p-4, INEXACT)
T(RN,   0x1.90f032385b81p+185,   -0x1.5dd4d505c4559p-2,  -0x1.b33b6ep-2, INEXACT)
T(RN,   0x1.2ae2876a62a6p+185,    0x1.3d73576ae72dap-6,  -0x1.40312ep-2, INEXACT)
T(RN,  0x1.f9a1b5420e691p+185,     0x1.fff3c27afd7bp-1,    0x1.ece61p-2, INEXACT)
T(RN,  0x1.b677f1c7b3516p+186,    0x1.829801f8c4f7cp-1,   0x1.a9f15ep-4, INEXACT)
T(RN,  0x1.8a27e6d45373fp+186,   -0x1.d1b496dc71e61p-1,   0x1.59ee64p-3, INEXACT)
T(RN,  0x1.cf84dc05901b8p+186,   -0x1.fe611833d1a55p-1,   0x1.061726p-3, INEXACT)
T(RN,  0x1.7135f5618c577p+186,   -0x1.231a7af51b52ap-2,   0x1.8027bep-3, INEXACT)
T(RN,  0x1.d38944a5b710ep+186,    0x1.9f2550df60fe6p-1,  -0x1.faae92p-2, INEXACT)
T(RN,  0x1.3a3b4dd91d704p+186,    0x1.2805e4e992615p-2,  -0x1.c527bcp-4, INEXACT)
T(RN,  0x1.b3240093b06cap+186,    0x1.c429879816235p-1,  -0x1.1ca85cp-8, INEXACT)
T(RN,  0x1.0497729cc97fcp+186,    0x1.ce55557d092dap-4,   0x1.92a236p-4, INEXACT)
T(RN,   0x1.801979b32e6ep+186,   -0x1.93e788c587584p-1,  -0x1.f722d2p-4, INEXACT)
T(RN,  0x1.79732dbf53d7ep+186,   -0x1.49c95bdeefad6p-3,    0x1.5faecp-2, INEXACT)
T(RN,  0x1.d683af7729a82p+187,   -0x1.97f76a3475bf5p-1,  -0x1.1f37aep-2, INEXACT)
T(RN,   0x1.c943cd5ab5cap+187,    -0x1.ef2a57b316d8p-1,  -0x1.f4c46ep-2, INEXACT)
T(RN,  0x1.c604ee5c0da4cp+187,   -0x1.3868f80ab9694p-2,  -0x1.0454bap-2, INEXACT)
T(RN,  0x1.a80b0bfbe1055p+187,    0x1.ff8054e02338bp-1,  -0x1.117654p-4, INEXACT)
T(RN,  0x1.513b79584849ap+187,   -0x1.78f2b0e80fdcdp-1,   0x1.727176p-2, INEXACT)
T(RN,  0x1.0192894d325bfp+187,    0x1.fee6557d16fbbp-1,  -0x1.3d9a08p-2, INEXACT)
T(RN,  0x1.3ff8bed41eaabp+187,    0x1.cda36e9dba753p-1,  -0x1.2b1668p-2, INEXACT)
T(RN,   0x1.9bf1bb673022p+187,    0x1.271d9ef985a4ep-2,   0x1.9f1a0ep-7, INEXACT)
T(RN,  0x1.dc632d55c1495p+187,   -0x1.990bebc768e33p-2,    0x1.d1482p-4, INEXACT)
T(RN,  0x1.6df2c93933218p+187,    0x1.697e3e947d802p-1,  -0x1.c5a0d8p-4, INEXACT)
T(RN,  0x1.9b1e3b847f0b1p+188,    0x1.c0ee52fecea8ap-1,  -0x1.150bd2p-2, INEXACT)
T(RN,  0x1.9c93d526ab688p+188,    0x1.c15638c979ddbp-2,    0x1.ef63cp-2, INEXACT)
T(RN,  0x1.708334b315339p+188,   -0x1.01bac5b1bbe51p-1,     0x1.92b5p-2, INEXACT)
T(RN,  0x1.f9fcbf099ff6ep+188,    0x1.a6fdabf50d74dp-1,   0x1.751c38p-3, INEXACT)
T(RN,   0x1.10647d4c15bcp+188,    0x1.39cb537003befp-4,   -0x1.a3a1cp-2, INEXACT)
T(RN,  0x1.64905a886d3f9p+188,    0x1.fc752ef8d2c7bp-1,  -0x1.d52ccep-2, INEXACT)
T(RN,  0x1.62c8230e1a764p+188,    0x1.d33e628d07fa2p-3,  -0x1.8e41cap-2, INEXACT)
T(RN,  0x1.5df41b2bb66cdp+188,    0x1.221b3d569711ap-1,   0x1.1b6acep-5, INEXACT)
T(RN,  0x1.53baeb3ecea12p+188,    0x1.05dc1fe7eed8dp-1,  -0x1.c3fbbcp-2, INEXACT)
T(RN,  0x1.05d2e901e4794p+188,    -0x1.1dc0a26bcb34p-6,  0x1.8a5b8cp-11, INEXACT)
T(RN,  0x1.6a80ec033c37ap+189,   -0x1.a384d2078b017p-1,   0x1.9c71c4p-3, INEXACT)
T(RN,   0x1.68c27e46fbf3p+189,     0x1.b70031b5e35cp-3,   0x1.531802p-2, INEXACT)
T(RN,  0x1.e6a0c948ff8b2p+189,   -0x1.fc16d58202329p-1,  -0x1.0e164ap-3, INEXACT)
T(RN,  0x1.de361a25d0b36p+189,    0x1.dfcaa81b90f88p-5,  -0x1.c1a7dcp-2, INEXACT)
T(RN,  0x1.31ef90ba6409ap+189,   -0x1.0dae813227241p-1,   0x1.45fe2ap-2, INEXACT)
T(RN,  0x1.f6cf1413c3025p+189,     -0x1.8dbacb36a19p-4,  -0x1.066f76p-2, INEXACT)
T(RN,  0x1.5c06b2a514956p+189,    0x1.f3f5053bb7c9ep-7,   0x1.f3c1d4p-2, INEXACT)
T(RN,  0x1.c4bf7a45279cfp+189,      0x1.4347743f8c8p-1,   0x1.295d7ap-2, INEXACT)
T(RN,  0x1.2d9e80ef1cdf6p+189,    0x1.553ff299a339fp-1,  -0x1.04916ap-3, INEXACT)
T(RN,   0x1.848161ebe31ap+189,   -0x1.e3967be9a55dfp-1,  -0x1.c4075ap-3, INEXACT)
T(RN,  0x1.c7df37af707a4p+190,   -0x1.346fa5366526ap-1,    0x1.57dacp-3, INEXACT)
T(RN,  0x1.4f68fa89656f2p+190,    0x1.e48483dbc8618p-1,  -0x1.d69b3ep-3, INEXACT)
T(RN,  0x1.59cbd0e089d3ap+190,    0x1.7b226e311e979p-1,   0x1.b26994p-3, INEXACT)
T(RN,  0x1.569be0642fdd2p+190,    0x1.899782c1830d5p-1,   0x1.6d7044p-2, INEXACT)
T(RN,  0x1.0d1b954421e91p+190,    0x1.6f2c4343ab4f1p-1,  -0x1.056742p-3, INEXACT)
T(RN,   0x1.b39d8714dcb5p+190,    0x1.f1fb250c65debp-1,  -0x1.6b7b98p-4, INEXACT)
T(RN,  0x1.306115afa5328p+190,   -0x1.0a557bd2b7a26p-6,   0x1.2bdc16p-4, INEXACT)
T(RN,  0x1.c125bc870aa23p+190,    0x1.ce53e02e8159cp-1,   0x1.bd85ecp-2, INEXACT)
T(RN,  0x1.c0c134a0154a4p+190,    0x1.ffa75b60b9bf4p-1,  -0x1.a0975cp-3, INEXACT)
T(RN,  0x1.f786f518a78dcp+190,    0x1.d6d5bb88dcde3p-2,  -0x1.d446acp-2, INEXACT)
T(RN,  0x1.862c7d03261f6p+191,    0x1.c8542fa16de3cp-4,   0x1.fbb2cap-3, INEXACT)
T(RN,  0x1.5531f9c09f53cp+191,   -0x1.25aa9640d46c7p-5,   0x1.dfa302p-2, INEXACT)
T(RN,  0x1.39624f2c23b8cp+191,   -0x1.d4219da8dc80dp-1,   0x1.c9224ap-2, INEXACT)
T(RN,   0x1.0a825b65267dp+191,   -0x1.459533e734f3fp-2,   0x1.1cd2a4p-2, INEXACT)
T(RN,  0x1.12823ef9ba4ecp+191,   -0x1.afb09a71fbdcbp-1,   0x1.528dbap-4, INEXACT)
T(RN,  0x1.5a3f9ad6230a4p+191,    0x1.937d31e0cb28ep-1,  -0x1.78a5b6p-4, INEXACT)
T(RN,  0x1.09bcd97951171p+191,   -0x1.2edce7e310237p-4,   0x1.c432a4p-2, INEXACT)
T(RN,  0x1.6970f067d1a3cp+191,   -0x1.5d0b17fc58e9fp-5,   0x1.af8998p-3, INEXACT)
T(RN,  0x1.a560dfe9370eap+191,   -0x1.5c829202f1598p-1,    0x1.e5dbdp-2, INEXACT)
T(RN,  0x1.575aed368ae28p+191,   -0x1.1e26496824a0ep-2,  -0x1.dfe04ap-2, INEXACT)
T(RN,  0x1.0e2492f212ccap+192,     0x1.fff07d70a71fp-1,   0x1.478244p-2, INEXACT)
T(RN,  0x1.abdfbe6fdedaap+192,   -0x1.355069464a39cp-3,   0x1.6423cap-2, INEXACT)
T(RN,   0x1.dd4dcac6d783p+192,    0x1.5cde664c79f45p-1,   0x1.23a1f4p-4, INEXACT)
T(RN,   0x1.9b9af091ef4ep+192,    0x1.f101414425b3dp-1,  -0x1.ef0024p-4, INEXACT)
T(RN,  0x1.994dad95cfe12p+192,   -0x1.a52b6d9d59c3dp-2,   0x1.c4dd96p-2, INEXACT)
T(RN,  0x1.744566b4dd17ep+192,   -0x1.78e2b4f1fad73p-4,   0x1.288362p-7, INEXACT)
T(RN,  0x1.c7335bdf8c732p+192,   -0x1.9e8665086be74p-3,    0x1.2b2d4p-2, INEXACT)
T(RN,  0x1.3a8ebaac2f4eep+192,   -0x1.6021b51a15978p-1,   0x1.073114p-5, INEXACT)
T(RN,  0x1.19289efab3b3dp+192,   -0x1.1d43674bf0109p-1,  -0x1.26c9bep-3, INEXACT)
T(RN,  0x1.0253827ff3999p+192,    0x1.e7878d343c4ddp-1,   -0x1.dec7cp-2, INEXACT)
T(RN,  0x1.bf47695902cdap+193,    0x1.ffb802a6f481ap-1,   0x1.845a1ap-4, INEXACT)
T(RN,  0x1.1040548c2e65ap+193,   -0x1.fef300f935213p-1,  -0x1.1839b8p-3, INEXACT)
T(RN,  0x1.1e3bfc37cedeep+193,   -0x1.832c98eb0e941p-1,  -0x1.91c1d2p-2, INEXACT)
T(RN,  0x1.4b3d12aed39ccp+193,     0x1.1d2b2d5160ddp-1,    -0x1.c5a2p-4, INEXACT)
T(RN,  0x1.6f445a2e0ff52p+193,    0x1.0264894c6b578p-4,    0x1.18462p-2, INEXACT)
T(RN,  0x1.30f2e16c3df0ap+193,    0x1.029839ec6e5b3p-2,   0x1.da858ep-2, INEXACT)
T(RN,  0x1.26a73a18ba9ddp+193,   -0x1.a7d3902a5a193p-4,   0x1.b67048p-2, INEXACT)
T(RN,  0x1.1c2a21707f308p+193,    0x1.ab996b31d10c6p-1,  -0x1.cf77e2p-2, INEXACT)
T(RN,  0x1.63139dfc66935p+193,   -0x1.71883d4c77867p-1,    -0x1.49e4p-2, INEXACT)
T(RN,  0x1.ba3d2753a234ap+193,   -0x1.75f6a7c3daba3p-2,   0x1.f791c4p-5, INEXACT)
T(RN,  0x1.1d472149ba0b5p+194,   -0x1.66dd3ab8538edp-2,  -0x1.1cb898p-3, INEXACT)
T(RN,  0x1.7d28625afe9c3p+194,    0x1.90e9eb5dc39dap-5,   0x1.45047ap-2, INEXACT)
T(RN,  0x1.4ec8617f09966p+194,    0x1.db2ef9f3339aep-1,  -0x1.fa1c78p-2, INEXACT)
T(RN,  0x1.285ff73ee181fp+194,    0x1.402d5810c8f5ep-1,   0x1.6ab1bap-2, INEXACT)
T(RN,  0x1.28a912dfd21bap+194,    -0x1.63a2fc03ed41p-1,  -0x1.d85044p-2, INEXACT)
T(RN,  0x1.e92814bb5d151p+194,   -0x1.7677f1ae01c07p-7,   0x1.86e9c4p-3, INEXACT)
T(RN,   0x1.e5e85aea4e7bp+194,     0x1.b7aaf5bcd354p-1,  -0x1.879318p-2, INEXACT)
T(RN,  0x1.8fd04d45a3c96p+194,   -0x1.6d6cbf6c1190cp-1,  -0x1.0c4ef4p-2, INEXACT)
T(RN,  0x1.52b39c1dfa4ecp+194,    0x1.b20eeb7b33ffdp-1,    0x1.7404cp-2, INEXACT)
T(RN,  0x1.7bfb63f564ca6p+194,   -0x1.d7fd6129acecap-1,  -0x1.85ba76p-5, INEXACT)
T(RN,  0x1.1a76010c8b709p+195,   -0x1.fcff2970c342ep-1,   0x1.b0ef66p-4, INEXACT)
T(RN,  0x1.856f78d1f4048p+195,   -0x1.feaa642ab5be4p-1,   0x1.cdda78p-5, INEXACT)
T(RN,  0x1.d9ad8897ec72bp+195,    0x1.cc895511b76dap-3,   0x1.3a98d2p-3, INEXACT)
T(RN,  0x1.82d15fbfafa5cp+195,   -0x1.a36d0b2fbd62cp-1,   -0x1.d438cp-2, INEXACT)
T(RN,  0x1.f8a22b4ff5fc6p+195,     0x1.e9249398ed4dp-2,  -0x1.d289bap-2, INEXACT)
T(RN,  0x1.2ae49bb9086a4p+195,    0x1.fb7316754c529p-1,   0x1.cba7eap-2, INEXACT)
T(RN,  0x1.8230274052a16p+195,    0x1.265fd7fc29853p-1,   -0x1.4beadp-2, INEXACT)
T(RN,  0x1.9e51970e75768p+195,   -0x1.1ac004bd077efp-1,  -0x1.baff62p-2, INEXACT)
T(RN,  0x1.c688a57ac9195p+195,    0x1.b373fd5f67901p-1,  -0x1.accca2p-3, INEXACT)
T(RN,  0x1.70f416fd4e6a1p+195,    0x1.df38cfc1099a5p-3,   0x1.774e7ep-2, INEXACT)
T(RN,  0x1.ee5ad959c79dap+196,    0x1.2daf80c0ee17ap-2,  -0x1.42dd68p-3, INEXACT)
T(RN,   0x1.3cf3201e7cc7p+196,   -0x1.a4b1ef52b62d7p-1,   0x1.51b994p-4, INEXACT)
T(RN,  0x1.2d4bc23c676cbp+196,   -0x1.3ad8beb6b9567p-1,  -0x1.07c814p-5, INEXACT)
T(RN,  0x1.4b2fccb1e5b89p+196,    0x1.df3f2c4d08c0ep-4,    0x1.840eap-2, INEXACT)
T(RN,  0x1.07b4c9fc028ecp+196,   -0x1.8820b960188c4p-1,   0x1.6183dcp-3, INEXACT)
T(RN,  0x1.046a9312bfb42p+196,   -0x1.e99a7e8d10353p-5,  -0x1.2cdb0ep-2, INEXACT)
T(RN,  0x1.fd8adafa60081p+196,   -0x1.a3d1d5601a051p-1,   0x1.bacffap-3, INEXACT)
T(RN,  0x1.81692da6f8649p+196,    -0x1.c14c9914656cp-1,   0x1.595b0cp-3, INEXACT)
T(RN,  0x1.94e82790562ccp+196,   -0x1.eb2f3a82e2251p-1,  -0x1.ee8e44p-3, INEXACT)
T(RN,   0x1.c2566e29163dp+196,   -0x1.94d2ad93a216bp-1,  -0x1.3c608cp-3, INEXACT)
T(RN,  0x1.e80b14fe20ffcp+197,    0x1.0291f7c376bd5p-1,  -0x1.9c777ep-4, INEXACT)
T(RN,  0x1.cbdac47f14cc2p+197,    0x1.37e1475c6d31fp-1,   0x1.0f337ep-4, INEXACT)
T(RN,  0x1.d2b54d0446cf2p+197,   -0x1.26f35c0c68087p-1,  -0x1.6e8222p-3, INEXACT)
T(RN,  0x1.dbab2f1824ec4p+197,   -0x1.ffeed51a3e77cp-1,   0x1.c8f0acp-3, INEXACT)
T(RN,   0x1.3c4e882f00dbp+197,   -0x1.f2c4ce6cbbf16p-1,   0x1.a67f4ep-2, INEXACT)
T(RN,  0x1.f575fecb51e66p+197,    0x1.3e32ab14b0492p-1,   0x1.de084ap-4, INEXACT)
T(RN,  0x1.d89b0c5e9c81ap+197,   -0x1.5a21ccf4d2b99p-3,   0x1.c2784cp-2, INEXACT)
T(RN,  0x1.1b25c324a3f75p+197,   -0x1.ab85b1a90f672p-1,  -0x1.56d292p-3, INEXACT)
T(RN,  0x1.9a5881b71d3bcp+197,    0x1.4b2c575d6e9c9p-2,   0x1.8ed842p-7, INEXACT)
T(RN,  0x1.e52dcdcb6cf0ap+197,    0x1.f454569414a88p-1,  -0x1.b32656p-2, INEXACT)
T(RN,  0x1.b62e6a1d800cdp+198,   -0x1.c57b241d0200fp-1,   0x1.6a085ap-5, INEXACT)
T(RN,  0x1.ade8d66793164p+198,   -0x1.d3deee66029f4p-1,  -0x1.0f585ep-2, INEXACT)
T(RN,  0x1.8632fe6016c54p+198,   -0x1.d47ffc5578213p-4,  -0x1.8ec90cp-2, INEXACT)
T(RN,  0x1.005f6bae59b52p+198,   -0x1.d37f2e3d1a903p-8,  -0x1.144184p-3, INEXACT)
T(RN,   0x1.79a401e2f156p+198,    0x1.fe18858b88ae7p-1,   0x1.43cad2p-2, INEXACT)
T(RN,  0x1.5ccd1778f5a46p+198,    0x1.b80c10333f8bdp-2,  -0x1.c92ed8p-2, INEXACT)
T(RN,   0x1.a801b92c96cbp+198,    0x1.535c24f6d5a37p-1,   0x1.a1ecb8p-2, INEXACT)
T(RN,  0x1.ecfe227a1e8cbp+198,    0x1.ed8e2b105dc6bp-1,   0x1.2e6d04p-2, INEXACT)
T(RN,  0x1.cb16706401c58p+198,    0x1.cfc1e4249c4efp-1,   0x1.e8211cp-8, INEXACT)
T(RN,  0x1.77161d94ab072p+198,    0x1.e9c0487250ee7p-1,   0x1.8c43e8p-4, INEXACT)
T(RN,  0x1.a3e6d3f2fb069p+199,    0x1.fd2a64d6c238cp-1,   0x1.287852p-2, INEXACT)
T(RN,  0x1.5f7266404140ap+199,    0x1.e1a4a1455a196p-1,   0x1.f825b4p-2, INEXACT)
T(RN,  0x1.627a8b95850b7p+199,   -0x1.46e78995a2ffep-1,  -0x1.deefccp-5, INEXACT)
T(RN,  0x1.77001997eba62p+199,   -0x1.8fba4dec6625cp-1,  -0x1.c6c87cp-3, INEXACT)
T(RN,  0x1.fe43ade2a7fa9p+199,    0x1.ff099e1b92bc2p-4,  -0x1.2781eep-4, INEXACT)
T(RN,  0x1.e9977f980ea61p+199,   -0x1.e68b21e4ab64ep-1,  -0x1.80a9f6p-4, INEXACT)
T(RN,   0x1.79febd55f29ap+199,   -0x1.fed7704f0e01ep-1,   0x1.59c77cp-4, INEXACT)
T(RN,  0x1.a297d6972e63dp+199,    0x1.19b1d77fd97b2p-1,   -0x1.47bdap-2, INEXACT)
T(RN,  0x1.72d120e7c823ep+199,     0x1.28998d63c381p-2,  -0x1.16a62ep-2, INEXACT)
T(RN,  0x1.4a7601e07e01ep+199,    0x1.4f61bf7d21309p-1,   0x1.193056p-3, INEXACT)
T(RN,  0x1.5fe7534d15491p+200,   -0x1.bec5805386502p-1,   0x1.e7edd8p-5, INEXACT)
T(RN,  0x1.60424ec147ba5p+200,   -0x1.a30dc22f867b9p-1,   0x1.0360c4p-2, INEXACT)
T(RN,  0x1.b6771c2312b32p+200,   -0x1.4c1e6527054efp-3,   0x1.ec1fd4p-2, INEXACT)
T(RN,   0x1.535dbba75be7p+200,   -0x1.5fb225235f193p-3,    0x1.163f2p-3, INEXACT)
T(RN,  0x1.1ee5eab5574b4p+200,   -0x1.480a8a308213ap-1,    0x1.081dap-2, INEXACT)
T(RN,  0x1.e1885df6a9f4cp+200,    0x1.d497268d8cec3p-1,   0x1.101712p-8, INEXACT)
T(RN,  0x1.4961bbaf456a4p+200,    0x1.6bb1cc5c699dep-1,   0x1.2c735ap-5, INEXACT)
T(RN,  0x1.82bdc94dabdbcp+200,    0x1.e456a7cc6deefp-2,   -0x1.643e4p-2, INEXACT)
T(RN,  0x1.f26feefaa646dp+200,    0x1.d72a85c0c3a55p-5,  -0x1.92f4bep-2, INEXACT)
T(RN,  0x1.4cf36d17c596ep+200,    0x1.ffe38008ef6b5p-1,   0x1.aa535cp-2, INEXACT)
T(RN,  0x1.df179d2723954p+201,   -0x1.d718c2db7538dp-1,   0x1.04bbe8p-3, INEXACT)
T(RN,  0x1.09daa35ec4353p+201,   -0x1.84a755de643a5p-4,   0x1.215188p-2, INEXACT)
T(RN,  0x1.0d7cbc1b0a989p+201,    0x1.6a078b7abdc9ap-1,  -0x1.2d4f6ep-5, INEXACT)
T(RN,  0x1.9ef32753f8b54p+201,   -0x1.d3d7142b7fcb9p-3,   -0x1.a66edp-2, INEXACT)
T(RN,  0x1.3767064d59888p+201,    0x1.d4ba4b088219ap-1,   0x1.f9237ap-3, INEXACT)
T(RN,  0x1.ec56444569125p+201,     0x1.9714f9e69c31p-1,  -0x1.3ed02cp-4, INEXACT)
T(RN,  0x1.bc46422d36116p+201,    0x1.1617295f43c84p-1,  -0x1.f3bd6cp-2, INEXACT)
T(RN,  0x1.c6de556a73156p+201,    0x1.b29dd4e5b98d5p-2,  -0x1.8ed7dcp-2, INEXACT)
T(RN,  0x1.6b7cbfab05285p+201,    0x1.3a109b31c5e06p-1,   0x1.70972cp-3, INEXACT)
T(RN,  0x1.00a10bad5462fp+201,   -0x1.d04ff788b4619p-1,   0x1.366c16p-2, INEXACT)
T(RN,  0x1.4ed2030cdf743p+202,    -0x1.f7f2437f745ep-1,   0x1.cd6dbep-2, INEXACT)
T(RN,  0x1.a0c3d34556d48p+202,   -0x1.0c4b1f1d42c0bp-1,   0x1.fe6c96p-5, INEXACT)
T(RN,  0x1.6767b6eb95d65p+202,   -0x1.df6c3ca09f5b6p-1,   0x1.2b1ed8p-3, INEXACT)
T(RN,  0x1.f3e3286f80f41p+202,   -0x1.42fcf76f0b381p-1,   -0x1.9e4d3p-2, INEXACT)
T(RN,   0x1.84df52bcdbc3p+202,    0x1.e19000c4050e6p-3,   0x1.d32aeep-3, INEXACT)
T(RN,  0x1.e059dd83ffcbep+202,    0x1.b74bbb719a8eep-1,    0x1.79907p-6, INEXACT)
T(RN,  0x1.b202f8f7b9102p+202,    0x1.b9a8be4f95a76p-2,  -0x1.bba13ap-4, INEXACT)
T(RN,  0x1.e1d2b725ac295p+202,   -0x1.8fbc659be4a27p-1,  -0x1.ccf0f2p-2, INEXACT)
T(RN,  0x1.5b5c3249f258ep+202,    0x1.efce0c41a64c6p-2,  -0x1.4c94b2p-4, INEXACT)
T(RN,  0x1.090bc3602314fp+202,   -0x1.fa2f19d9425cdp-1,  -0x1.02dcdep-7, INEXACT)
T(RN,  0x1.fd4a99c001f2ep+203,    0x1.f7846d501b57cp-1,   0x1.cdedd8p-2, INEXACT)
T(RN,  0x1.063b251b40cfdp+203,   -0x1.a4a6a94c2ceaep-3,    0x1.df731p-3, INEXACT)
T(RN,  0x1.26f1bf2bcfe45p+203,    0x1.ffd110d0a7b0fp-1,  -0x1.b854f4p-2, INEXACT)
T(RN,  0x1.396622ab2b333p+203,    0x1.26c80fe3f74a7p-2,  -0x1.832cf4p-3, INEXACT)
T(RN,  0x1.05bfcec26dd92p+203,    0x1.47c6e5f7e6529p-1,   -0x1.fe9e3p-4, INEXACT)
T(RN,  0x1.84288a7fa5d58p+203,    0x1.830d88ecea271p-1,  -0x1.00aa76p-2, INEXACT)
T(RN,  0x1.fe35f0bef440dp+203,   -0x1.06032050922eep-4,  -0x1.9580b2p-4, INEXACT)
T(RN,  0x1.63795cdfb74d2p+203,   -0x1.9adbf65534c4dp-1,  -0x1.cbeea6p-3, INEXACT)
T(RN,  0x1.d33858ae87d73p+203,   -0x1.e3a317459f60bp-1,  -0x1.6e2b74p-2, INEXACT)
T(RN,  0x1.789bce0825cb4p+203,   -0x1.30e8b639a0191p-1,   0x1.c92c4ap-2, INEXACT)
T(RN,  0x1.984d2556df72cp+204,   -0x1.1518e11dc6787p-1,   0x1.ad1194p-4, INEXACT)
T(RN,  0x1.a76f6f13892fcp+204,   -0x1.cedf5261820dfp-2,   0x1.65bd7ep-3, INEXACT)
T(RN,   0x1.671ff7855e58p+204,   -0x1.41d7b7539248ep-1,   -0x1.1be8dp-3, INEXACT)
T(RN,  0x1.8cb239e2aa485p+204,   -0x1.b69449007e648p-1,   0x1.c64bacp-2, INEXACT)
T(RN,  0x1.9e2ae86ee3cd1p+204,    0x1.a68160490936ep-3,    0x1.c6be3p-2, INEXACT)
T(RN,  0x1.da85ed69a6186p+204,    -0x1.1bfde59e2e67p-1,  -0x1.66fd34p-3, INEXACT)
T(RN,   0x1.0409363c3577p+204,    0x1.bb64202af7a43p-1,  -0x1.04b11cp-3, INEXACT)
T(RN,  0x1.0467538d3a5a3p+204,   -0x1.47288281c7794p-1,   0x1.3cdbb2p-3, INEXACT)
T(RN,  0x1.284b84048d481p+204,   -0x1.76c9b0f3a22f7p-1,   0x1.e7ea22p-3, INEXACT)
T(RN,  0x1.e9ccb8d8503d6p+204,    0x1.3daa142f15e09p-2,  -0x1.479588p-3, INEXACT)
T(RN,  0x1.20dd9b4a810b5p+205,    0x1.fb0354951d018p-1,   0x1.83a59cp-2, INEXACT)
T(RN,  0x1.13a630b8f5f2dp+205,    0x1.426b502d4f5abp-1,  -0x1.374c48p-3, INEXACT)
T(RN,  0x1.3c5e07a4f31d8p+205,   -0x1.0d6dc301da669p-2,  -0x1.0b1b44p-4, INEXACT)
T(RN,  0x1.ef1c01a477f58p+205,    0x1.ebb66f921e62cp-1,  -0x1.e77122p-2, INEXACT)
T(RN,  0x1.c85596f606952p+205,    0x1.c292555184262p-1,   0x1.cfbd64p-3, INEXACT)
T(RN,  0x1.ac22eba96c566p+205,   -0x1.b0a4d9081ed5bp-1,  -0x1.982a5ep-3, INEXACT)
T(RN,  0x1.1866070624837p+205,   -0x1.77f93bc41ac0bp-2,  -0x1.4e4f8ep-3, INEXACT)
T(RN,  0x1.189bd7a9c1e55p+205,    0x1.13be317b11b7ep-2,   -0x1.d8702p-2, INEXACT)
T(RN,  0x1.e64277244bf1ap+205,    0x1.cade42ead9971p-1,   0x1.024682p-4, INEXACT)
T(RN,  0x1.acc5b43b3c3a2p+205,    0x1.6efce010bfbc5p-1,  -0x1.a04262p-2, INEXACT)
T(RN,  0x1.d950467b49b7ep+206,   -0x1.facc9c6e5cc5ep-1,  -0x1.e62a94p-2, INEXACT)
T(RN,  0x1.97247b60a5056p+206,    0x1.e69540880d465p-5,   0x1.6cb9d8p-6, INEXACT)
T(RN,  0x1.8f6ba51a18d67p+206,   -0x1.6734ae1766c8ap-2,  -0x1.942ff2p-2, INEXACT)
T(RN,  0x1.8132e5dc952d2p+206,    -0x1.ccae2a8f11ecp-1,  -0x1.5e2cd8p-3, INEXACT)
T(RN,   0x1.a8a7baf632d4p+206,   -0x1.f0c00ce0f104fp-1,  -0x1.0273a8p-2, INEXACT)
T(RN,  0x1.81a0555d88c7ep+206,    0x1.868205dfe4a5bp-3,   0x1.c0e67ep-3, INEXACT)
T(RN,  0x1.ba959eb416258p+206,   -0x1.fefe56987c4e8p-1,  -0x1.b39df6p-3, INEXACT)
T(RN,  0x1.ce4387d257996p+206,    0x1.d760d570e2cefp-1,  -0x1.85027cp-3, INEXACT)
T(RN,  0x1.059e41833dec7p+206,   -0x1.86dcf4802a778p-1,   0x1.1f22a4p-2, INEXACT)
T(RN,  0x1.e9034bb87d9c4p+206,    0x1.1e6f8a3e9c72dp-1,  -0x1.75ede2p-2, INEXACT)
T(RN,  0x1.767a6fe90f73ep+207,   -0x1.8c0ce3424b69ap-1,    0x1.ed5ccp-2, INEXACT)
T(RN,  0x1.b57ece8bb6dc8p+207,   -0x1.63cd572853defp-1,    0x1.852b2p-2, INEXACT)
T(RN,  0x1.a2e109451c1cap+207,    0x1.e5ec4b84a1befp-2,  -0x1.4225b8p-9, INEXACT)
T(RN,   0x1.3944b31aadebp+207,   -0x1.03f11b576c5c8p-3,  -0x1.302fd6p-3, INEXACT)
T(RN,  0x1.7237484d988ecp+207,   -0x1.b625b5f61ad52p-1,   0x1.1de7acp-4, INEXACT)
T(RN,  0x1.d459674230f37p+207,   -0x1.be96ef2353c98p-4,   0x1.38f104p-2, INEXACT)
T(RN,  0x1.9d1ebe9c93e9ep+207,    0x1.b042b89de1d45p-1,  -0x1.2ee032p-2, INEXACT)
T(RN,  0x1.11fcae35c6445p+207,   -0x1.6c901c9a59e4cp-1,    0x1.ae2a8p-2, INEXACT)
T(RN,  0x1.17dea1aebef41p+207,     0x1.0e92262290a9p-5,   0x1.2f87a2p-2, INEXACT)
T(RN,  0x1.5e0487e73feeep+207,   -0x1.ffaacfe05bc5ap-1,  -0x1.28a972p-2, INEXACT)
T(RN,  0x1.8a3a61e4c5d66p+208,    0x1.3ba3773cf8a62p-2,   0x1.9823b8p-2, INEXACT)
T(RN,  0x1.8d0a75c9ba2a7p+208,   -0x1.9b591b01a4b49p-1,  -0x1.5e7a54p-5, INEXACT)
T(RN,   0x1.3ff1eaf8cc7dp+208,    0x1.12141f1ad951bp-2,  -0x1.26b03cp-2, INEXACT)
T(RN,  0x1.db9c62445c77cp+208,    0x1.47f72cbfe517ap-2,   0x1.2a53c2p-3, INEXACT)
T(RN,  0x1.707839bc668f2p+208,   -0x1.3a54a7b4cece2p-1,  -0x1.f48cbap-2, INEXACT)
T(RN,  0x1.2903f09352b26p+208,   -0x1.f786fb46be825p-1,   0x1.3b30a8p-4, INEXACT)
T(RN,  0x1.37c6c6d9fa1a4p+208,    0x1.da41930902f1fp-2,   0x1.4bc7bep-4, INEXACT)
T(RN,  0x1.7bc94dbfe865ep+208,   -0x1.9765ae88d6d28p-2,  -0x1.9c1c12p-2, INEXACT)
T(RN,   0x1.4193f5c9da09p+208,    0x1.eefb00e2eb4f7p-1,  -0x1.53a376p-2, INEXACT)
T(RN,  0x1.15cd3dc23870ap+208,     -0x1.c12bf9b8da5p-1,  -0x1.691c4cp-2, INEXACT)
T(RN,  0x1.94562901f82cbp+209,   -0x1.0413539f8c8dap-1,  -0x1.a3b444p-3, INEXACT)
T(RN,  0x1.4fd7c1434a60bp+209,   -0x1.f7d383abbeae1p-3,   0x1.8ffc1ap-2, INEXACT)
T(RN,  0x1.c3bf100ae60d7p+209,   -0x1.a580db20ea0d4p-1,   -0x1.996fep-2, INEXACT)
T(RN,  0x1.687b4ec2748d2p+209,   -0x1.bd66e77ba00ddp-4,  -0x1.87052ap-3, INEXACT)
T(RN,  0x1.a45604ac39889p+209,    0x1.07b408c535109p-1,  -0x1.1478c8p-2, INEXACT)
T(RN,   0x1.e494a0bbb6d1p+209,    0x1.5f5f4588fc08dp-1,  -0x1.d871fap-4, INEXACT)
T(RN,  0x1.6c1b1a44946dfp+209,   -0x1.5609c67024e52p-3,  -0x1.ae7026p-4, INEXACT)
T(RN,  0x1.9eb04b2edca21p+209,   -0x1.fff62613c0fc6p-1,   0x1.613ae6p-2, INEXACT)
T(RN,  0x1.112519c8e8308p+209,    0x1.e2edaecf7fc78p-2,   0x1.7daf0ap-2, INEXACT)
T(RN,  0x1.cc1858bd7fcc3p+209,    0x1.f9ea56cb36a78p-1,    0x1.a1e81p-3, INEXACT)
T(RN,  0x1.9e38847c0b21dp+210,    0x1.bdb88599d3449p-1,  -0x1.a049cep-2, INEXACT)
T(RN,  0x1.5832fb6011c26p+210,    0x1.09aab07f12105p-2,   0x1.36204cp-2, INEXACT)
T(RN,  0x1.7917f237f1038p+210,    0x1.5684c3f8d828bp-4,  -0x1.1694a4p-3, INEXACT)
T(RN,  0x1.6fe03647a2178p+210,   -0x1.d6a63e3f693efp-2,  -0x1.a7dc14p-2, INEXACT)
T(RN,  0x1.2b431c29b410cp+210,    0x1.8b64aeff9c1d3p-1,   0x1.f0a2d4p-2, INEXACT)
T(RN,  0x1.bf800ab501ec7p+210,   -0x1.ebdf8dc9f3456p-1,   0x1.5c404ep-3, INEXACT)
T(RN,  0x1.96c727b8c752ap+210,    0x1.3a9c51b5b45e3p-1,  -0x1.aaa6acp-2, INEXACT)
T(RN,  0x1.9f3ef4eea4558p+210,    0x1.10aab7a4110c1p-2,   0x1.3a9d02p-3, INEXACT)
T(RN,  0x1.a8e3c527e751cp+210,     0x1.8375aa01f14dp-3,  -0x1.c608cep-5, INEXACT)
T(RN,  0x1.e80a0999dc054p+210,    0x1.bcf87bf718996p-1,   0x1.1e3b12p-2, INEXACT)
T(RN,  0x1.8747e092774eep+211,    0x1.ff85426adbf2ep-2,   0x1.dd7d54p-2, INEXACT)
T(RN,  0x1.058b059341a89p+211,    0x1.c9beb65e2eeb6p-1,  -0x1.ccc66cp-2, INEXACT)
T(RN,   0x1.fa071e1f2542p+211,   -0x1.adc925f3c6839p-1,  -0x1.173808p-4, INEXACT)
T(RN,  0x1.b9637060be05cp+211,   -0x1.1e28ba91e1ea8p-2,   0x1.8d1faep-6, INEXACT)
T(RN,  0x1.45584b5d9c471p+211,   -0x1.28b9e4985b395p-1,  -0x1.cca47ap-2, INEXACT)
T(RN,  0x1.6f711f634179cp+211,   -0x1.82d200fb25d38p-2,  -0x1.f81822p-2, INEXACT)
T(RN,  0x1.acb58d48a2faap+211,    0x1.7f8e3485c4ecfp-1,   0x1.b85b6cp-6, INEXACT)
T(RN,  0x1.b4b65aeaf2308p+211,   -0x1.c2336631796c6p-3,  -0x1.536c88p-7, INEXACT)
T(RN,  0x1.38851cea59a38p+211,   -0x1.fff9af9dcf103p-1,  -0x1.6ae738p-2, INEXACT)
T(RN,  0x1.4df3d208428a4p+211,    0x1.ff0243fd7599ap-1,   0x1.59441ap-2, INEXACT)
T(RN,  0x1.a2dfa148e7083p+212,     0x1.b134937d6712p-1,   0x1.fc5752p-4, INEXACT)
T(RN,  0x1.dce799808b706p+212,   -0x1.269674d7470d5p-1,   0x1.e2b0cep-3, INEXACT)
T(RN,  0x1.6549fed3859fep+212,    0x1.feebb30be3031p-3,   0x1.ebe828p-3, INEXACT)
T(RN,  0x1.00b45dfa557e4p+212,   -0x1.ab0d32523c7adp-1,    0x1.3a495p-4, INEXACT)
T(RN,   0x1.438a658f16c3p+212,    0x1.46af065a2d536p-2,  -0x1.6ef818p-3, INEXACT)
T(RN,  0x1.f58e887fbd5bap+212,    0x1.dd6db025dbba1p-1,  -0x1.e66baep-6, INEXACT)
T(RN,  0x1.23e24a8aa43f9p+212,   -0x1.f7d66b879047ap-1,   0x1.32181ap-3, INEXACT)
T(RN,  0x1.44e31f138e788p+212,    0x1.fca1372499ee1p-1,   0x1.d726f6p-2, INEXACT)
T(RN,  0x1.61718f9b81081p+212,   -0x1.eaaa33776cb1cp-1,   0x1.77f1dep-2, INEXACT)
T(RN,  0x1.7f2dadc15d8d6p+212,    0x1.2728c1eaf2e2fp-1,  -0x1.362a56p-3, INEXACT)
T(RN,  0x1.fe2bc66f1e492p+213,   -0x1.b74b0a7ab28cep-1,  -0x1.93ce34p-2, INEXACT)
T(RN,  0x1.c7f7cdab5207fp+213,    0x1.be9d8116478bdp-8,  -0x1.09f9dep-2, INEXACT)
T(RN,  0x1.9dcb25b65b9e9p+213,   -0x1.f83bdc7cb3a48p-1,  -0x1.df470ap-2, INEXACT)
T(RN,  0x1.4a8f8e1592468p+213,    0x1.97eb8d90ef686p-1,  -0x1.50466ap-3, INEXACT)
T(RN,  0x1.ed6ea3aa9a477p+213,   -0x1.c0f78370086d7p-1,  -0x1.c8c4b4p-2, INEXACT)
T(RN,  0x1.a68da9cd1e918p+213,   -0x1.67db084ff8367p-2,   0x1.1f9958p-2, INEXACT)
T(RN,  0x1.7e361ec7a4f26p+213,    0x1.9dbf2cff85021p-2,   0x1.ab41c6p-3, INEXACT)
T(RN,  0x1.7e9cadedd2bbep+213,   -0x1.fb1d154c1e0d3p-1,   0x1.5cdf86p-2, INEXACT)
T(RN,  0x1.cd00b507e7e38p+213,   -0x1.f7e17de173dd4p-5,   0x1.db83b2p-2, INEXACT)
T(RN,  0x1.37dd59627893ep+213,   -0x1.a7d63a7371cd2p-2,   -0x1.41a1cp-3, INEXACT)
T(RN,  0x1.45faec7f2717fp+214,    0x1.fd8a73987ec23p-1,   0x1.06b16cp-3, INEXACT)
T(RN,  0x1.26495daadcfe2p+214,    0x1.b1981a8cf1645p-1,   0x1.fa2adcp-4, INEXACT)
T(RN,  0x1.08e9f21feee55p+214,   -0x1.ef732fd5c0483p-1,   0x1.949fbap-6, INEXACT)
T(RN,  0x1.50bff6d365698p+214,    0x1.f063e05caaf09p-6,   0x1.f1bfdcp-2, INEXACT)
T(RN,  0x1.537553d85fbf2p+214,   -0x1.4861d8a1bbd6ep-4,   -0x1.db039p-2, INEXACT)
T(RN,  0x1.2c320440979a7p+214,   -0x1.8e41f771cd29bp-1,      0x1.e6dp-2, INEXACT)
T(RN,  0x1.06ff728a9ec16p+214,   -0x1.20c9295ec8c81p-1,   0x1.a49e64p-2, INEXACT)
T(RN,  0x1.80dafb9df035cp+214,    0x1.73473cf1afb09p-1,   0x1.83e972p-5, INEXACT)
T(RN,  0x1.1bdcfb08f3f1dp+214,   -0x1.ffee34ba7770dp-1,  -0x1.d7e112p-5, INEXACT)
T(RN,  0x1.991eb21b76068p+214,   -0x1.fe0feba013b56p-1,  -0x1.ec12e2p-4, INEXACT)
T(RN,  0x1.673e89e405fc3p+215,   -0x1.fff6fe442904bp-1,  -0x1.3addfap-2, INEXACT)
T(RN,  0x1.642792fd2efcbp+215,    0x1.8c09cd5aecb82p-1,   0x1.7f25e2p-4, INEXACT)
T(RN,  0x1.82946e3e20f92p+215,    0x1.fdbcabdcbc0edp-1,  -0x1.56eb3ap-2, INEXACT)
T(RN,  0x1.56e64b9667c62p+215,   -0x1.1123afadc93a4p-1,  -0x1.95a9ccp-4, INEXACT)
T(RN,  0x1.23b49c99a8835p+215,   -0x1.ae72af07f7193p-7,   0x1.93946cp-3, INEXACT)
T(RN,  0x1.8d65b7c4d488cp+215,    0x1.e16246b0f7826p-1,   0x1.e497e4p-2, INEXACT)
T(RN,  0x1.a83cfb3f12d02p+215,    0x1.04ecd74e32b41p-1,   0x1.33796cp-3, INEXACT)
T(RN,  0x1.2020979b493cbp+215,   -0x1.01a61af0cd9fap-1,   0x1.07c812p-2, INEXACT)
T(RN,  0x1.984314e7e6d89p+215,    0x1.05ec708f78d02p-4,  -0x1.012382p-4, INEXACT)
T(RN,  0x1.129c145d98acdp+215,    0x1.fd4ec2519ca68p-1,   0x1.702322p-3, INEXACT)
T(RN,  0x1.fa8b8a09f237ap+216,    0x1.efb0009843fa7p-1,   0x1.ab1d02p-9, INEXACT)
T(RN,  0x1.b0aa3cf35d6d1p+216,    0x1.40b462a46c64bp-1,   0x1.dfb9ecp-2, INEXACT)
T(RN,  0x1.7556d05638f06p+216,   -0x1.ae8a3707ffb81p-3,    0x1.721e8p-6, INEXACT)
T(RN,  0x1.e8734260229cbp+216,    0x1.aeaa43061d0b8p-1,  -0x1.a7d414p-4, INEXACT)
T(RN,  0x1.84857002588cfp+216,   -0x1.03ac7ae8c417dp-2,  -0x1.b667f8p-4, INEXACT)
T(RN,   0x1.d22356c18ba5p+216,    0x1.a89b873820d0ap-1,   0x1.7c7f0ap-3, INEXACT)
T(RN,  0x1.6b4d1fe1e09c5p+216,    0x1.efbf9c122d4f6p-1,   0x1.811a2ap-3, INEXACT)
T(RN,  0x1.c96bc365ea423p+216,    0x1.b5c000fc38d07p-2,   0x1.637a9cp-5, INEXACT)
T(RN,  0x1.060acc94370fep+216,     0x1.c130cc596408p-1,    0x1.09fbep-2, INEXACT)
T(RN,  0x1.c05bbbd1b17dap+216,    0x1.9de46786dac4ep-1,  -0x1.7b6d54p-5, INEXACT)
T(RN,  0x1.f084cb8c86448p+217,   -0x1.f1a38aaf5cb1ep-1,   0x1.c8eda8p-2, INEXACT)
T(RN,  0x1.530982ab3eea5p+217,    0x1.e5a3eeea1fc0ap-1,   0x1.4bd194p-5, INEXACT)
T(RN,  0x1.8485b1b576b0ep+217,    0x1.ff024b56dacccp-1,   -0x1.c0a2bp-4, INEXACT)
T(RN,  0x1.e2fcad4154529p+217,    0x1.8452003915f48p-1,  -0x1.9d0878p-2, INEXACT)
T(RN,   0x1.c88e298aabaep+217,   -0x1.826a7e43089dep-1,  -0x1.53b3eep-2, INEXACT)
T(RN,  0x1.2eeab78817eb8p+217,   -0x1.572c454d292eep-3,    -0x1.138cp-2, INEXACT)
T(RN,  0x1.bad04c5d14f3cp+217,    0x1.979e3afd4de9cp-1,  -0x1.a5a3ecp-3, INEXACT)
T(RN,  0x1.db4b28be9444fp+217,    0x1.c1b21ce87e62dp-1,   0x1.401dd6p-2, INEXACT)
T(RN,  0x1.9af4ed0e66a82p+217,     0x1.e44d91d96772p-1,  -0x1.da7266p-4, INEXACT)
T(RN,  0x1.04455fee8828bp+217,    0x1.fefe83de49998p-1,   -0x1.a148bp-3, INEXACT)
T(RN,  0x1.72e53cdbf0862p+218,    0x1.8878817de8d84p-2,   0x1.e27b2cp-2, INEXACT)
T(RN,  0x1.72e561665624dp+218,    0x1.56f60582d7c25p-2,  -0x1.565422p-2, INEXACT)
T(RN,  0x1.7c445b7beadbbp+218,   -0x1.fc4e039b8f17fp-1,   0x1.e86426p-2, INEXACT)
T(RN,  0x1.d1b2c09ffb1b8p+218,    0x1.74e8af5547dc8p-2,  -0x1.d12a14p-2, INEXACT)
T(RN,  0x1.8a7706ebaf6ecp+218,   -0x1.57b2a6b2bbad1p-1,  -0x1.23e424p-2, INEXACT)
T(RN,  0x1.1b348830c3cbdp+218,   -0x1.5e7f939d7072cp-1,   -0x1.7b1b2p-2, INEXACT)
T(RN,  0x1.64300b1a115aep+218,   -0x1.76190baef7916p-2,   0x1.a4e70cp-2, INEXACT)
T(RN,  0x1.aeb093c256d5ap+218,   -0x1.ff528584deb9ep-1,   0x1.d47674p-3, INEXACT)
T(RN,  0x1.c1d03cd42d7bep+218,   -0x1.ffff3b7e59eadp-1,  -0x1.af5128p-3, INEXACT)
T(RN,  0x1.7c7c8f24b9ff1p+218,    0x1.69a3e3ce097ffp-3,   0x1.648e92p-2, INEXACT)
T(RN,  0x1.3c22bf52bd469p+219,    0x1.e8113e0d5809bp-1,  -0x1.41fb22p-2, INEXACT)
T(RN,  0x1.ba6a855c1f5f9p+219,    0x1.8f51c557e1b08p-1,   -0x1.e037fp-3, INEXACT)
T(RN,  0x1.c03b2531afceap+219,    0x1.9a06afc22a773p-2,  -0x1.f6c436p-2, INEXACT)
T(RN,  0x1.94aa13f381a0ap+219,   -0x1.4e49847b5917ap-1,   0x1.197096p-2, INEXACT)
T(RN,  0x1.d629274de862ap+219,   -0x1.fe4f062b71ea1p-1,   0x1.a07da8p-5, INEXACT)
T(RN,  0x1.90a03d1858103p+219,    0x1.676a52479b941p-6,  -0x1.ce48a4p-2, INEXACT)
T(RN,  0x1.a890b014fbf0ep+219,   -0x1.ffe857124b12ap-1,  -0x1.d64432p-4, INEXACT)
T(RN,  0x1.9891adeb2fdd2p+219,    0x1.33d8afe590234p-3,   -0x1.bfa6ap-3, INEXACT)
T(RN,  0x1.3b9c4f0697ad5p+219,   -0x1.e08918e38b7fdp-1,   0x1.1bb994p-5, INEXACT)
T(RN,  0x1.3eb625c7267d3p+219,   -0x1.802bcadd1b3a9p-1,   -0x1.31233p-3, INEXACT)
T(RN,  0x1.dcff99390491ap+220,    0x1.201f5fc94e77ap-1,   0x1.7ea682p-2, INEXACT)
T(RN,  0x1.8d230683d6c22p+220,    0x1.be783ad66b753p-7,   0x1.d6df34p-2, INEXACT)
T(RN,  0x1.8cfaf53bd4301p+220,   -0x1.7f7f04d2fe33ap-1,   0x1.2c8e66p-2, INEXACT)
T(RN,  0x1.46041c9df6e92p+220,   -0x1.e82f688bc6b39p-3,   0x1.60a4a4p-2, INEXACT)
T(RN,  0x1.819609bb290cfp+220,    0x1.2564c6d054356p-6,   -0x1.4e45dp-3, INEXACT)
T(RN,  0x1.169398468d4bdp+220,   -0x1.cce30bd3d22ebp-2,   -0x1.fb1c1p-5, INEXACT)
T(RN,  0x1.74f37b6bcbe4bp+220,    0x1.273fadadf0b1cp-2,  -0x1.b9aeb4p-2, INEXACT)
T(RN,  0x1.6dfe9eca4aaf9p+220,   -0x1.fac27d521929cp-1,   0x1.f47d88p-3, INEXACT)
T(RN,  0x1.a43213f1dd074p+220,    0x1.03b78bdcd45f5p-3,   0x1.2b0116p-4, INEXACT)
T(RN,  0x1.ac9e3648c2fa2p+220,   -0x1.8837b3d8c27b7p-1,   0x1.0a7d42p-2, INEXACT)
T(RN,  0x1.b8224287d6c82p+221,    0x1.ac68c0fcb97a1p-1,  -0x1.f0e172p-2, INEXACT)
T(RN,    0x1.e38b507365ap+221,    0x1.f77b85d9eade2p-3,  -0x1.02050ep-4, INEXACT)
T(RN,  0x1.5ea9cdc11aa54p+221,     0x1.9adf261bcf1fp-1,   0x1.8a1fb2p-4, INEXACT)
T(RN,  0x1.ee9ee0b1c3736p+221,    0x1.0fbac1be5036fp-2,  -0x1.dd8948p-2, INEXACT)
T(RN,   0x1.aff025a350cfp+221,   -0x1.fa45fa2ce5493p-1,   0x1.3d8678p-3, INEXACT)
T(RN,  0x1.b9eb4b2afc8a8p+221,    0x1.c8d83e8a4d77cp-2,   -0x1.28c76p-2, INEXACT)
T(RN,  0x1.1e0e6221f4232p+221,    0x1.2f024492f9794p-2,   0x1.c2bab6p-2, INEXACT)
T(RN,  0x1.98d742b3bc228p+221,   -0x1.d290cc7be1f78p-1,   0x1.dd1392p-6, INEXACT)
T(RN,  0x1.1491683f49b31p+221,    0x1.c0eb83fb5ae14p-2,  -0x1.67e62ep-2, INEXACT)
T(RN,  0x1.918a1777fd0f1p+221,   -0x1.10c5a9a2327bep-2,   0x1.1e9418p-2, INEXACT)
T(RN,  0x1.a432294ced2fdp+222,   -0x1.147dc00f3a45ap-1,   0x1.c9cb94p-2, INEXACT)
T(RN,  0x1.b21843ca97f9ep+222,     0x1.630fc3fb59e9p-1,  -0x1.24cbc4p-5, INEXACT)
T(RN,  0x1.57f970e64cb86p+222,   -0x1.a23626f1428c9p-6,  -0x1.32b392p-2, INEXACT)
T(RN,  0x1.b6bd42c538f58p+222,    0x1.2e9b7a844c34fp-1,   0x1.849bb6p-3, INEXACT)
T(RN,  0x1.51ba39ecc0eb4p+222,    0x1.62ec8f30b4214p-1,   -0x1.ae27cp-2, INEXACT)
T(RN,  0x1.848f2ff2d92a2p+222,    0x1.c7a26697d03ecp-3,    0x1.33acep-2, INEXACT)
T(RN,  0x1.525d4d194af11p+222,   -0x1.f40dc35c18f27p-1,   0x1.de24d8p-4, INEXACT)
T(RN,  0x1.58a69e33627a6p+222,    0x1.c7a7fbd798226p-2,   0x1.692722p-5, INEXACT)
T(RN,  0x1.222faf879b77ap+222,   -0x1.d80aae584f674p-1,   0x1.a15386p-2, INEXACT)
T(RN,  0x1.cb1a97cb5ae6ep+222,    0x1.7ace1036c367dp-1,  -0x1.19e39cp-3, INEXACT)
T(RN,  0x1.87d84a3a98a66p+223,   -0x1.9bda1a6102a4bp-1,   0x1.3d9528p-3, INEXACT)
T(RN,  0x1.10331ae0b629ap+223,     0x1.7fd2843245f4p-2,  -0x1.bfa9bap-2, INEXACT)
T(RN,  0x1.b9c9e96fe3e5cp+223,   -0x1.500ff2a803073p-1,  -0x1.e5fd04p-5, INEXACT)
T(RN,  0x1.8e12106f3e5b6p+223,   -0x1.fb8b5c06e31a7p-1,   0x1.06ce46p-3, INEXACT)
T(RN,  0x1.dd1c29a238604p+223,    0x1.dea91c3738336p-1,  -0x1.f7ba08p-2, INEXACT)
T(RN,  0x1.e0be8b7d4990cp+223,    0x1.7c4be06dc36f2p-3,  -0x1.1995fcp-4, INEXACT)
T(RN,  0x1.8500b5e3e4708p+223,    0x1.7107bcd87e5fcp-4,   0x1.3183f2p-2, INEXACT)
T(RN,  0x1.70b384928026ap+223,   -0x1.d1387d38b2b7ep-2,  -0x1.fda35ap-2, INEXACT)
T(RN,  0x1.5e5a8db925602p+223,   -0x1.f2edf2a00e4ddp-1,   0x1.e55e8cp-2, INEXACT)
T(RN,  0x1.9ac9824002c5ep+223,   -0x1.54c5bae143675p-1,  -0x1.23b9a8p-2, INEXACT)
T(RN,  0x1.e14d8cbf3a7a2p+224,    0x1.da8269112f5c8p-2,  -0x1.f155f4p-2, INEXACT)
T(RN,  0x1.333bbe3bc5329p+224,   -0x1.9636981d007fdp-4,    0x1.03b96p-2, INEXACT)
T(RN,  0x1.2ad44ca631d02p+224,     0x1.b508dbe41401p-5,  -0x1.ff654ep-3, INEXACT)
T(RN,  0x1.534bdf13f590fp+224,    -0x1.e43c43099a0fp-1,  -0x1.1db0bcp-3, INEXACT)
T(RN,  0x1.8a0574932f776p+224,     0x1.f833e29874ccp-1,   0x1.795adap-3, INEXACT)
T(RN,  0x1.f9a4ba0027e58p+224,    0x1.fa5e234a33d52p-1,   0x1.cc9d0ep-2, INEXACT)
T(RN,  0x1.7caf88dc3b4b6p+224,   -0x1.cc6668b9f2d0bp-3,    0x1.05396p-3, INEXACT)
T(RN,  0x1.4f5d37a57c20ap+224,   -0x1.914c47e30e7e1p-2,  -0x1.f8180cp-3, INEXACT)
T(RN,  0x1.5582202a79384p+224,    -0x1.19a28d1b8cefp-3,   0x1.c09f9cp-2, INEXACT)
T(RN,  0x1.c84cd2867d618p+224,    0x1.ce3e51cc5daf4p-1,  -0x1.64380ap-3, INEXACT)
T(RN,  0x1.6c73ffde3279ap+225,     0x1.a313104f0667p-3,   0x1.17fe26p-2, INEXACT)
T(RN,  0x1.6bfc574c0e9dep+225,    0x1.1015b03bf1f2bp-1,  -0x1.3ce248p-2, INEXACT)
T(RN,  0x1.bac42c4b421fap+225,    0x1.767559e830e5cp-1,   0x1.c7a3e8p-4, INEXACT)
T(RN,   0x1.bf1c06ca4248p+225,    0x1.03f584e10b1a1p-1,  -0x1.2c17dep-4, INEXACT)
T(RN,  0x1.ef660b5af6af2p+225,    -0x1.f00236891d98p-1,  -0x1.40d508p-2, INEXACT)
T(RN,  0x1.c5ee9c90b8196p+225,    0x1.9e1b78fd43bbdp-1,   0x1.1adeb8p-3, INEXACT)
T(RN,  0x1.ee73b006d2a04p+225,    0x1.fd4c482d4c5e2p-1,   0x1.6e9f88p-2, INEXACT)
T(RN,  0x1.9bec7a6431af2p+225,   -0x1.d11a05bca9444p-1,   0x1.32e47cp-2, INEXACT)
T(RN,  0x1.8368c72d4c6edp+225,    0x1.63d57b627bc6dp-1,  -0x1.3c732ap-4, INEXACT)
T(RN,  0x1.ce5f65fb5d4dcp+225,   -0x1.c2a77d4e1e51ep-1,   0x1.991c32p-2, INEXACT)
T(RN,  0x1.2b8332e9ef332p+226,   -0x1.2442d4b29c7d5p-1,   0x1.055f9cp-2, INEXACT)
T(RN,  0x1.2fd4954d96c13p+226,   -0x1.dcdb06e4944f9p-2,   0x1.732fb2p-2, INEXACT)
T(RN,  0x1.b750d955b0b3dp+226,    0x1.67d5f52213974p-2,  -0x1.4de4c2p-6, INEXACT)
T(RN,   0x1.2ce6d353f6ebp+226,    0x1.b797320ed5c42p-1,   0x1.e699e4p-3, INEXACT)
T(RN,  0x1.678afaed86212p+226,    0x1.ff27d243862b8p-1,   0x1.0b65cap-2, INEXACT)
T(RN,  0x1.ff8e131a0da09p+226,   -0x1.ff51f69a1fcf2p-1,   -0x1.8a474p-2, INEXACT)
T(RN,  0x1.a88d0c71daf7cp+226,   -0x1.d7110e1b059ccp-1,   0x1.e4bf66p-2, INEXACT)
T(RN,  0x1.a99a488822a2cp+226,    0x1.3ddcf3c0adf51p-4,  -0x1.79275ep-2, INEXACT)
T(RN,  0x1.b884ee95ac474p+226,   -0x1.f7d68599180f3p-1,  -0x1.1d45c6p-2, INEXACT)
T(RN,  0x1.32bd044102702p+226,   -0x1.6aefb89d6ca27p-2,   0x1.fda6e6p-3, INEXACT)
T(RN,  0x1.a97dc0da8cc04p+227,   -0x1.9a1df2992c076p-2,  -0x1.47026ep-2, INEXACT)
T(RN,  0x1.6726bf193a6d5p+227,   -0x1.fa5a44de69fe6p-1,    0x1.d69b1p-3, INEXACT)
T(RN,  0x1.49e16b6b40273p+227,   -0x1.5e0b592a6373cp-1,  -0x1.8b708ep-3, INEXACT)
T(RN,  0x1.431ab55b6fef6p+227,    0x1.2e3a32b041ee4p-1,   0x1.1a9c72p-2, INEXACT)
T(RN,  0x1.4fbb10ad7fe97p+227,   -0x1.035c058e645dap-3,   0x1.669736p-2, INEXACT)
T(RN,  0x1.67e33bba5f024p+227,    -0x1.48791ba89dc5p-1,   -0x1.814e9p-3, INEXACT)
T(RN,  0x1.a2969f92d35bcp+227,   -0x1.8903e06add2e1p-2,   0x1.5b742ep-2, INEXACT)
T(RN,  0x1.230e21f359dafp+227,   -0x1.d4844a387f2e6p-1,   0x1.905db4p-3, INEXACT)
T(RN,  0x1.d9c4a38e6eb56p+227,   -0x1.495ccd110370dp-1,  -0x1.1e7456p-5, INEXACT)
T(RN,  0x1.6fffed3973e27p+227,    0x1.117a813036218p-1,  -0x1.1f1d6ep-2, INEXACT)
T(RN,  0x1.4dc0aef89192cp+228,    0x1.c12e0e07fa818p-1,    0x1.2bbb2p-2, INEXACT)
T(RN,  0x1.850acc549994bp+228,   -0x1.35d2b0325d6aap-1,  -0x1.247236p-3, INEXACT)
T(RN,  0x1.071c75e2c7c4ep+228,    0x1.e19317db93627p-1,    0x1.18b9dp-3, INEXACT)
T(RN,  0x1.f1f026bbbed24p+228,   -0x1.d3ee8639555dbp-1,   0x1.1e211ep-5, INEXACT)
T(RN,  0x1.864d4586f780cp+228,    0x1.68445956be632p-1,   -0x1.603f3p-3, INEXACT)
T(RN,  0x1.bdd814b26d347p+228,    0x1.124158b2ee033p-3,  -0x1.8373b4p-3, INEXACT)
T(RN,  0x1.d7f711004236cp+228,   -0x1.41c0164ef7a02p-1,   0x1.b1e626p-3, INEXACT)
T(RN,  0x1.0b823683af44dp+228,    0x1.52ecfd10f491ap-4,  -0x1.543a8cp-3, INEXACT)
T(RN,  0x1.b2e6d18cd4ad4p+228,   -0x1.1563879b4dd68p-1,   0x1.da28aep-5, INEXACT)
T(RN,  0x1.53095dc2dd6b2p+228,    0x1.1ac66c6ca7edbp-1,  -0x1.e404dcp-3, INEXACT)
T(RN,  0x1.7b0e9d5c92f03p+229,    0x1.25f2f1122700ap-2,   -0x1.2caf9p-2, INEXACT)
T(RN,  0x1.5ee6af8b59d2ep+229,    0x1.da61ccd39d672p-1,   0x1.03dbbap-2, INEXACT)
T(RN,  0x1.8c5e2f4084bb6p+229,   -0x1.fabb42d48e56dp-1,  -0x1.f450a8p-3, INEXACT)
T(RN,  0x1.0fb8fe8c1c8b4p+229,   -0x1.ebeaabf167099p-1,  -0x1.fc5f54p-4, INEXACT)
T(RN,   0x1.6793daaddc8ep+229,     0x1.fff0aaf7bc62p-1,   0x1.44842cp-3, INEXACT)
T(RN,  0x1.46498f5002041p+229,   -0x1.ff91bb0e73b39p-1,  -0x1.a6f8b6p-2, INEXACT)
T(RN,  0x1.51cd2f79d3addp+229,   -0x1.1a3c80f6a3d57p-1,   -0x1.37d7ep-3, INEXACT)
T(RN,   0x1.617e55bc0ae7p+229,   -0x1.db9be99498567p-1,  -0x1.af0bacp-3, INEXACT)
T(RN,  0x1.c5f2dfc8d8d6bp+229,    0x1.fff62dcb47423p-1,  -0x1.a72d66p-2, INEXACT)
T(RN,  0x1.06633f26e0f44p+229,   -0x1.c28514656771dp-1,   0x1.77c098p-6, INEXACT)
T(RN,  0x1.7027fa67a482dp+230,   -0x1.df8fc1856ae78p-1,  -0x1.ee7844p-3, INEXACT)
T(RN,  0x1.93aa4c701ca7ep+230,   -0x1.625c9f0f09a9bp-1,   0x1.3e76fcp-4, INEXACT)
T(RN,  0x1.3acbc306bd62ap+230,   -0x1.1bb7c409fa86fp-1,     0x1.c0abp-4, INEXACT)
T(RN,  0x1.c0c07f1c0bdb5p+230,    0x1.f615ac21f335ep-1,  -0x1.fbfcf4p-2, INEXACT)
T(RN,   0x1.c8fa059152a9p+230,   -0x1.eef0f5fc54f8cp-1,  -0x1.b08812p-4, INEXACT)
T(RN,  0x1.d9541e701f1aep+230,    0x1.d474a3a48638fp-1,  -0x1.2b2af6p-4, INEXACT)
T(RN,  0x1.9386c0df50046p+230,    0x1.7f0164932fe4bp-1,    0x1.59e39p-3, INEXACT)
T(RN,  0x1.1cc6e437f29cdp+230,    0x1.7a18e20720f55p-1,  -0x1.65de04p-2, INEXACT)
T(RN,  0x1.988c7a5b9a5a1p+230,    0x1.e51d311bfa699p-3,  -0x1.459708p-2, INEXACT)
T(RN,  0x1.e609c23328c05p+230,   -0x1.53b72c7b2ac74p-6,   0x1.4a42eap-2, INEXACT)
T(RN,  0x1.21393c9b6cb8ep+231,    0x1.0b2842dd86f9ap-1,  -0x1.ed1992p-2, INEXACT)
T(RN,  0x1.94643c1fe64e2p+231,    0x1.dba946708df9cp-1,  -0x1.5a75a8p-3, INEXACT)
T(RN,  0x1.ec02830c0b138p+231,   -0x1.23d150f6e1a37p-3,   0x1.662abap-3, INEXACT)
T(RN,  0x1.40a7d64fb34b7p+231,   -0x1.1f686f073cecfp-1,  -0x1.95c5e4p-2, INEXACT)
T(RN,  0x1.8519bab4e9414p+231,   -0x1.fb8397cee40c8p-1,   0x1.5497e6p-2, INEXACT)
T(RN,  0x1.db821abd7ff22p+231,   -0x1.f71f54cbf872cp-2,  -0x1.9a3a48p-2, INEXACT)
T(RN,  0x1.b2dbb89377136p+231,   -0x1.5eb47727f6cbdp-3,   0x1.01d0d8p-2, INEXACT)
T(RN,  0x1.7a531286d2cfcp+231,    0x1.d8a25c133ee54p-2,  -0x1.fb6eacp-2, INEXACT)
T(RN,  0x1.4433db93e82d2p+231,   -0x1.f677ac4ee017fp-1,  -0x1.254b54p-5, INEXACT)
T(RN,  0x1.6cffd129ef494p+231,    0x1.e918058fd0949p-1,   0x1.aade24p-3, INEXACT)
T(RN,  0x1.48ea5834199fcp+232,   -0x1.c091f0be58ef7p-2,   0x1.f494f4p-5, INEXACT)
T(RN,  0x1.e33d854514f38p+232,    0x1.8438fbd218b29p-1,   0x1.18de8ap-2, INEXACT)
T(RN,   0x1.6a72ec1476a2p+232,   -0x1.d0b02388842e9p-1,   0x1.b3f742p-2, INEXACT)
T(RN,   0x1.d177fef3dd0ep+232,    0x1.dfd2300e7e227p-1,  -0x1.aaa7f2p-2, INEXACT)
T(RN,  0x1.784d8d07005f5p+232,    -0x1.59c43a723746p-1,   0x1.180f6ap-2, INEXACT)
T(RN,  0x1.85dedf1cd8e75p+232,   -0x1.3f9b9e68247d1p-1,  -0x1.2e2eaep-2, INEXACT)
T(RN,  0x1.6c97eaeece94cp+232,    0x1.effed7bcebd5fp-1,  -0x1.27f058p-2, INEXACT)
T(RN,  0x1.a27ef62890f2ep+232,   -0x1.42197320b7c56p-1,   0x1.b797d4p-3, INEXACT)
T(RN,  0x1.1157432d8d20dp+232,    -0x1.c4b794c91e46p-3,     0x1.48e5p-3, INEXACT)
T(RN,  0x1.a9e5e10f225b6p+232,   -0x1.57f56f9240e21p-2,   0x1.5baceep-3, INEXACT)
T(RN,  0x1.1c70498e94c7ep+233,   -0x1.eaedb9feba7cbp-1,   0x1.1ad5b6p-5, INEXACT)
T(RN,  0x1.61d18bdf82f05p+233,   -0x1.f828bc4ffbcc9p-1,   0x1.02ac68p-2, INEXACT)
T(RN,  0x1.1df13b9356972p+233,    0x1.a88321249ca9bp-2,   0x1.07a28ep-2, INEXACT)
T(RN,  0x1.1eba4b7940398p+233,    0x1.44a06cfd21111p-1,  -0x1.808972p-2, INEXACT)
T(RN,  0x1.b129b751af814p+233,    0x1.f37f098180e94p-1,  -0x1.87ec82p-8, INEXACT)
T(RN,  0x1.28042478214edp+233,   -0x1.ffabd2427f3cfp-1,   0x1.ec0d2cp-2, INEXACT)
T(RN,  0x1.9b309e0c04f94p+233,    0x1.d9475f375c803p-1,   0x1.ec8b08p-2, INEXACT)
T(RN,  0x1.53cea98f12aadp+233,   -0x1.f27eede59ab4dp-1,    -0x1.5808p-2, INEXACT)
T(RN,  0x1.163e95a349084p+233,   -0x1.f62b33fb855b9p-5,  -0x1.04c922p-2, INEXACT)
T(RN,  0x1.a6dc45684a762p+233,   -0x1.6226836e4db1fp-1,    0x1.81976p-3, INEXACT)
T(RN,  0x1.a7e09b208601dp+234,   -0x1.58b19f5e9b9bdp-3,  -0x1.cfccd8p-5, INEXACT)
T(RN,  0x1.6e68a38d9e532p+234,   -0x1.6bb4876b66d63p-2,   0x1.c884bap-3, INEXACT)
T(RN,  0x1.d5bff5c55078dp+234,   -0x1.d49f03f30f18ap-2,   0x1.d94342p-4, INEXACT)
T(RN,  0x1.953e103f82d54p+234,    0x1.6cabe806faf3ep-1,  -0x1.3ce81cp-2, INEXACT)
T(RN,  0x1.cb6cbbf2d7fffp+234,    0x1.c33b0cb4531d1p-1,    0x1.4c44bp-2, INEXACT)
T(RN,  0x1.9987b55416104p+234,   -0x1.eda7c7ecf0f3dp-1,  -0x1.2f0824p-3, INEXACT)
T(RN,  0x1.56c032a24533ep+234,    0x1.9c13cbe4320bap-1,  -0x1.b880fap-2, INEXACT)
T(RN,  0x1.5e140e92e138ep+234,   -0x1.24af19df1766ap-6,   0x1.c8201ap-2, INEXACT)
T(RN,  0x1.85b9ba340185dp+234,    0x1.16dd10826506ap-1,  -0x1.4b0852p-6, INEXACT)
T(RN,  0x1.e58d6e5d74a86p+234,   -0x1.c9519c6ccb5c4p-1,   0x1.83dd84p-3, INEXACT)
T(RN,  0x1.3d6df64eef0ddp+235,     0x1.38df4814b1edp-1,    0x1.da173p-2, INEXACT)
T(RN,  0x1.af2be16b8b594p+235,    0x1.a0a403baa62e5p-1,   0x1.334fb4p-2, INEXACT)
T(RN,  0x1.625f2fb4c82a6p+235,   -0x1.c38bc20336f73p-1,  -0x1.51469ep-3, INEXACT)
T(RN,  0x1.72847fd6636b9p+235,    0x1.e7cab5c07c9f1p-1,    0x1.1f641p-4, INEXACT)
T(RN,  0x1.a2b2f0facac2ap+235,   -0x1.19ef551189b4ep-1,    0x1.1d996p-2, INEXACT)
T(RN,  0x1.66813cc806cc5p+235,    0x1.cd12d5bd53663p-1,  -0x1.d9577ep-3, INEXACT)
T(RN,  0x1.d5eff29660351p+235,   -0x1.828c579e1036bp-2,   0x1.eec128p-3, INEXACT)
T(RN,   0x1.e443d0cf4ca8p+235,    0x1.5f50d3a50e77ep-1,  -0x1.40c754p-3, INEXACT)
T(RN,  0x1.b1aca1836870cp+235,   -0x1.a76a275911b14p-1,    -0x1.4ca8p-2, INEXACT)
T(RN,    0x1.bc54189fcd9p+235,   -0x1.fd86cf44b1602p-1,   0x1.7e331cp-3, INEXACT)
T(RN,  0x1.53853d07aea41p+236,    0x1.016141523e5fap-2,   0x1.a8cd12p-4, INEXACT)
T(RN,  0x1.40f50f8a6b1efp+236,   -0x1.4c483180d4b51p-2,    0x1.2e38cp-3, INEXACT)
T(RN,  0x1.53e28ca9b9849p+236,    0x1.587206bc03057p-4,  -0x1.87875ap-2, INEXACT)
T(RN,  0x1.3019a561f5653p+236,    0x1.ad36f1be165fap-1,   -0x1.3083fp-2, INEXACT)
T(RN,  0x1.6e3da16ea2be4p+236,    0x1.4c79ea5477562p-1,  -0x1.98b934p-3, INEXACT)
T(RN,  0x1.cdac3117ff41cp+236,   -0x1.9caec495ba854p-2,   0x1.64e06cp-2, INEXACT)
T(RN,  0x1.3429702a440ddp+236,    0x1.e5a2f30d2874dp-1,   0x1.690a44p-2, INEXACT)
T(RN,  0x1.22bde3f888a18p+236,   -0x1.ca14a4de97f9fp-1,  -0x1.cf8752p-2, INEXACT)
T(RN,  0x1.44cef1d628394p+236,    0x1.ffef6e7d28eb2p-1,  -0x1.34bde8p-2, INEXACT)
T(RN,  0x1.349350992fb45p+236,   -0x1.26c4fbbc1852bp-3,   0x1.3970f8p-4, INEXACT)
T(RN,  0x1.4afaa454e6779p+237,   -0x1.5dff51ad05488p-1,   0x1.c3f866p-2, INEXACT)
T(RN,  0x1.652aa41fa7e17p+237,    0x1.fff8072f29099p-1,   0x1.ee94b6p-2, INEXACT)
T(RN,  0x1.f5d377f38a6d8p+237,   -0x1.efb6a7275200dp-1,   0x1.24c9aep-4, INEXACT)
T(RN,  0x1.d265ca553e19fp+237,   -0x1.5bce92581c553p-1,  -0x1.8e47e6p-2, INEXACT)
T(RN,  0x1.76bde9b940c98p+237,   -0x1.ff6c541154466p-1,  -0x1.b7df9ep-2, INEXACT)
T(RN,  0x1.043b40aa3625cp+237,    0x1.be0c4a8572d06p-1,   0x1.0f0f8ap-5, INEXACT)
T(RN,  0x1.da38ceabc4caap+237,    0x1.8c0b4709fbea5p-1,   0x1.97ccd6p-3, INEXACT)
T(RN,  0x1.3c0b5e2f4f244p+237,   -0x1.b5ad44bff806bp-6,  -0x1.d68822p-2, INEXACT)
T(RN,   0x1.bb3cc8b0b3a1p+237,   -0x1.afaf95a9a9d95p-2,   0x1.1bfd92p-2, INEXACT)
T(RN,  0x1.aedbe759bf704p+237,   -0x1.cf33a6bd35528p-3,   0x1.17b534p-3, INEXACT)
T(RN,  0x1.dec8babf12d5ap+238,    0x1.51aeef2bde915p-3,  -0x1.f207e6p-5, INEXACT)
T(RN,  0x1.cdfcb6a7ac906p+238,    0x1.75702cbebbc28p-1,  -0x1.875f7ap-2, INEXACT)
T(RN,  0x1.db7a9fdf816d8p+238,   -0x1.b32552ec32babp-1,  -0x1.a3b69ap-3, INEXACT)
T(RN,  0x1.c7b1bef01f54ep+238,   -0x1.35d3dc6d4e111p-2,   -0x1.0f9f2p-3, INEXACT)
T(RN,  0x1.a58fe2f13c14ap+238,    0x1.dbce55c6df586p-1,   0x1.1024fep-2, INEXACT)
T(RN,  0x1.6651afe80dde2p+238,   -0x1.8548c91faa2b4p-1,   0x1.06e68cp-2, INEXACT)
T(RN,  0x1.a39f6f16cab4ap+238,   -0x1.79875ea469986p-2,   -0x1.ff06ep-3, INEXACT)
T(RN,  0x1.0f79939058531p+238,   -0x1.33007e6723084p-1,  -0x1.3c1464p-2, INEXACT)
T(RN,  0x1.23577a09a375ap+238,    0x1.e3e68bff524dcp-1,  -0x1.fbe1a8p-4, INEXACT)
T(RN,  0x1.a9d01c299e6b4p+238,    0x1.1e3edc96d17b6p-1,   0x1.569b8cp-2, INEXACT)
T(RN,  0x1.86fb31bdad291p+239,     0x1.a2f4e09c9b1bp-1,   0x1.03f94ap-2, INEXACT)
T(RN,  0x1.5a405d7599453p+239,   -0x1.ffee32bb2e4adp-1,  -0x1.359042p-2, INEXACT)
T(RN,  0x1.3ba64c8465038p+239,   -0x1.6fc1b286bea6ep-1,   0x1.77fedap-3, INEXACT)
T(RN,  0x1.ceade92d9b56ep+239,    0x1.9fa337d432971p-1,   0x1.ed5c3ep-2, INEXACT)
T(RN,  0x1.4eeb1e6ae7017p+239,    0x1.fbd2124382f37p-1,   0x1.2b9726p-2, INEXACT)
T(RN,  0x1.116627b84b3fbp+239,   -0x1.d7262c570fc95p-2,   0x1.04104ep-4, INEXACT)
T(RN,  0x1.7bd11c3c3bd06p+239,   -0x1.440bf547d91bdp-1,   0x1.8b494ap-2, INEXACT)
T(RN,  0x1.422faf44f0f82p+239,     0x1.ffbef9f55cf4p-1,  -0x1.1e17b4p-3, INEXACT)
T(RN,  0x1.073ca5d54a9afp+239,   -0x1.9d9be75bd299ep-1,   0x1.ea579cp-3, INEXACT)
T(RN,  0x1.3381108b3c035p+239,   -0x1.24acd3ee20c03p-5,   0x1.d40db4p-2, INEXACT)
T(RN,  0x1.f2b20fd5f9bf4p+240,   -0x1.4c71fa016bef6p-1,  -0x1.a23584p-2, INEXACT)
T(RN,  0x1.432d708b122e4p+240,   -0x1.c94ba25fc3852p-1,   0x1.c2f6a8p-2, INEXACT)
T(RN,  0x1.1db269f0d8249p+240,    0x1.2f6f691c26623p-1,  -0x1.05076cp-2, INEXACT)
T(RN,  0x1.01d19ec8b6d29p+240,   -0x1.f8ec2bea2f6f2p-1,   -0x1.f6b91p-3, INEXACT)
T(RN,  0x1.6e47c89e9bcd1p+240,    0x1.fc9b2374d9726p-1,  -0x1.7c7268p-2, INEXACT)
T(RN,   0x1.68609f6c25e7p+240,   -0x1.1fe753f9e4fa7p-1,  -0x1.ee6ed4p-3, INEXACT)
T(RN,  0x1.cc1a1f358fbfdp+240,   -0x1.c8ddd6f65094ap-1,  -0x1.99040cp-2, INEXACT)
T(RN,  0x1.12d0b3749d9e3p+240,   -0x1.56b4b4cfd8f93p-1,    0x1.58017p-2, INEXACT)
T(RN,  0x1.79e15eb1caecap+240,    0x1.5e99d2e6e0a0ap-2,   0x1.1dd934p-3, INEXACT)
T(RN,  0x1.1a18d13d1b2b3p+240,    0x1.54c9744125485p-1,   0x1.7937fep-3, INEXACT)
T(RN,  0x1.9e741e9eaa226p+241,    0x1.181810ff6a4b8p-1,   0x1.78d052p-2, INEXACT)
T(RN,  0x1.a1dfc15094baap+241,   -0x1.af27c751ed608p-1,     0x1.bf2ap-2, INEXACT)
T(RN,  0x1.3b4490b0059afp+241,   -0x1.bb2d459b8bf7dp-2,   0x1.319bccp-3, INEXACT)
T(RN,  0x1.bd22bc711286cp+241,   -0x1.fda3e9c0d0846p-1,  -0x1.fcb146p-5, INEXACT)
T(RN,  0x1.543d5ecbbc074p+241,     0x1.0cc8edf0c04cp-1,   0x1.fccbd6p-2, INEXACT)
T(RN,  0x1.7bb59ffaea8ebp+241,    0x1.de42f1aecd47dp-1,   0x1.a3062ep-4, INEXACT)
T(RN,  0x1.356670d612fe5p+241,    0x1.f003eeedadcdep-1,  -0x1.e8d2c6p-4, INEXACT)
T(RN,  0x1.72427e19b2738p+241,    0x1.8b5ea061a9bb6p-4,   0x1.9cba62p-7, INEXACT)
T(RN,  0x1.b47401c616deap+241,    0x1.7bf9a5a3bbef4p-1,  -0x1.b7a964p-3, INEXACT)
T(RN,  0x1.33dbb6013439ep+241,    0x1.2d36e41a04ef4p-1,   0x1.c12ec2p-4, INEXACT)
T(RN,  0x1.32e472302f868p+242,    0x1.2d55b8232def2p-1,  -0x1.a62e3cp-2, INEXACT)
T(RN,  0x1.c6907c50bebc9p+242,   -0x1.29829ae8c187bp-3,  -0x1.2827a4p-2, INEXACT)
T(RN,  0x1.73b405219c129p+242,   -0x1.c55f77f20d462p-3,  -0x1.ac172ep-2, INEXACT)
T(RN,   0x1.7cf6d92552afp+242,    -0x1.fcb2a42b9106p-1,  -0x1.29b8d4p-2, INEXACT)
T(RN,  0x1.9a0f450b9fb66p+242,    0x1.4dabb3a9ced61p-4,   0x1.4444f6p-2, INEXACT)
T(RN,  0x1.1c3590461882cp+242,   -0x1.65f083b0d8253p-1,  -0x1.abdbaep-3, INEXACT)
T(RN,  0x1.51ced70d3e95dp+242,    0x1.c2bc9f57bfbf4p-1,   0x1.62e93cp-3, INEXACT)
T(RN,  0x1.ce1f150bafa32p+242,    0x1.d202c34dae532p-3,   0x1.cb97c8p-2, INEXACT)
T(RN,  0x1.ac42a74909952p+242,    0x1.3f6cdb096cd76p-3,   0x1.47fc42p-2, INEXACT)
T(RN,  0x1.3c16c7dd225cap+242,    0x1.da3b9b7d031d9p-4,   0x1.d4494ap-3, INEXACT)
T(RN,  0x1.a8a58b82bde87p+243,   -0x1.9ec8e3062dfe2p-1,   0x1.8f23c4p-3, INEXACT)
T(RN,  0x1.f21bd5c324828p+243,   -0x1.4201c5e154d29p-2,    0x1.453dfp-2, INEXACT)
T(RN,  0x1.bab8d8c276338p+243,    0x1.44c9e8255f554p-3,   -0x1.8c12ap-4, INEXACT)
T(RN,  0x1.d7611cfa5a40fp+243,     0x1.5da2c89192cap-1,     0x1.9047p-4, INEXACT)
T(RN,  0x1.95049968e1409p+243,   -0x1.819dea2d04ffdp-3,  -0x1.7c0124p-4, INEXACT)
T(RN,  0x1.0e268286550d3p+243,   -0x1.fa918bb6aba69p-1,   0x1.29ab34p-3, INEXACT)
T(RN,  0x1.2b02e792c80aep+243,    0x1.1d3fdf6733ef2p-4,   0x1.11f558p-3, INEXACT)
T(RN,  0x1.478fc0be99942p+243,    0x1.6aa4d8371c6edp-1,  -0x1.8ccb4ep-2, INEXACT)
T(RN,  0x1.fcc882cf0479cp+243,   -0x1.d8ea7196ddc3cp-2,   0x1.42a938p-6, INEXACT)
T(RN,  0x1.a80d352d9c358p+243,    0x1.dd845d425aca1p-1,   0x1.0c4fd8p-3, INEXACT)
T(RN,  0x1.df19f950a25cap+244,    0x1.eddc10f0891b5p-1,   0x1.2d3d26p-5, INEXACT)
T(RN,  0x1.a4cb4ba11bd86p+244,   -0x1.451550c2f2572p-3,  -0x1.522c92p-3, INEXACT)
T(RN,  0x1.f96af5e8e9ebep+244,    -0x1.4515d40e281ep-1,  -0x1.714b8ap-5, INEXACT)
T(RN,  0x1.ab8e47fac300cp+244,   -0x1.4a234ddf910c1p-2,  -0x1.68171cp-3, INEXACT)
T(RN,  0x1.f829f9bbd4d58p+244,    0x1.f349b27d8a314p-1,   -0x1.3a34bp-2, INEXACT)
T(RN,  0x1.56898f1be83c3p+244,    0x1.f4318ccf305dep-1,  -0x1.614784p-2, INEXACT)
T(RN,  0x1.5a4d0feeffdbdp+244,    0x1.6530008f7a3ccp-2,   0x1.103722p-2, INEXACT)
T(RN,  0x1.7d613c8e7f5a1p+244,    0x1.d0fd18026e489p-1,    0x1.05185p-2, INEXACT)
T(RN,  0x1.e3e3012a90b0bp+244,    0x1.bf9489827e5acp-1,   0x1.bbe1bcp-2, INEXACT)
T(RN,  0x1.dcb3a05a3edacp+244,    0x1.7cfde07c810c6p-2,  -0x1.d97d32p-3, INEXACT)
T(RN,  0x1.108dc39c899e6p+245,   -0x1.c4c6cbf6b3acep-1,   0x1.ec07ecp-5, INEXACT)
T(RN,  0x1.fac7f06d9b48bp+245,    0x1.df6fadb6e3bd6p-1,    0x1.e977ap-4, INEXACT)
T(RN,   0x1.2ec3ff78f03bp+245,    0x1.2a20ba5818b71p-2,  -0x1.6fbf16p-2, INEXACT)
T(RN,  0x1.cc621769494d6p+245,   -0x1.075458b6c16e2p-4,   0x1.b69534p-2, INEXACT)
T(RN,  0x1.8892de172e7bcp+245,   -0x1.370108640f58dp-1,  -0x1.84c974p-4, INEXACT)
T(RN,  0x1.eb8453f730618p+245,   -0x1.6034cbbc0d993p-3,   0x1.d964bcp-4, INEXACT)
T(RN,  0x1.e2f0466a9c499p+245,   -0x1.b7db1778424e5p-1,  -0x1.aebec2p-3, INEXACT)
T(RN,  0x1.9a38def268d88p+245,   -0x1.a1c5578d19756p-1,  -0x1.d1a0cap-2, INEXACT)
T(RN,  0x1.c7dcd8e20f599p+245,   -0x1.ab6bb8e45b97cp-1,  -0x1.2822d4p-2, INEXACT)
T(RN,  0x1.b3bfc24c6aceep+245,    0x1.85a827a89bae4p-1,   0x1.aebec2p-2, INEXACT)
T(RN,  0x1.f818a6cc64af8p+246,    0x1.fa39b94853021p-2,  -0x1.91da1ap-3, INEXACT)
T(RN,  0x1.e4f58471916a6p+246,   -0x1.5d876261e05eap-2,  -0x1.88c9ccp-2, INEXACT)
T(RN,  0x1.46398b5fdf94ep+246,   -0x1.1c61e53bcfd64p-2,   -0x1.6c06dp-2, INEXACT)
T(RN,  0x1.362dbaafe7f05p+246,    0x1.727a721ab2129p-2,   0x1.4c5c4ap-3, INEXACT)
T(RN,  0x1.9040a6cfdccfap+246,    0x1.8123947e40bd3p-1,   0x1.6e48e2p-3, INEXACT)
T(RN,  0x1.23ffc121bef58p+246,    0x1.a9031611a9a1fp-1,   0x1.149c48p-3, INEXACT)
T(RN,  0x1.d386739f58bfcp+246,    0x1.ff72e0ae04458p-1,   0x1.763048p-2, INEXACT)
T(RN,  0x1.81471a25ac4b8p+246,    0x1.349029a344ed8p-1,  -0x1.840192p-2, INEXACT)
T(RN,  0x1.d7548a818c40ep+246,    0x1.ca14882001b52p-1,   0x1.d717fap-3, INEXACT)
T(RN,  0x1.5b7eb0809006bp+246,    0x1.4d282fdf6f913p-2,   0x1.721268p-2, INEXACT)
T(RN,  0x1.e1f1cbd49c46fp+247,     0x1.ffff720b084fp-1,   0x1.db53eap-9, INEXACT)
T(RN,  0x1.543cf02a967c4p+247,    0x1.bb572efd8040bp-2,  -0x1.e6fee2p-2, INEXACT)
T(RN,  0x1.5f568a5322755p+247,   -0x1.cae7be06673a9p-2,   0x1.92085ap-2, INEXACT)
T(RN,  0x1.3d2844e3a4629p+247,   -0x1.df374cb6fc7b2p-2,  -0x1.788fcap-5, INEXACT)
T(RN,  0x1.cedec7b0c4552p+247,   -0x1.dd6e7f0b6f31dp-1,   0x1.108d9cp-2, INEXACT)
T(RN,  0x1.d7d25292ebdfap+247,    0x1.fe055a2bfffa2p-1,   0x1.71df5ep-6, INEXACT)
T(RN,  0x1.9ebff047283b2p+247,    0x1.4c280e9f53fd1p-1,   0x1.2f8536p-7, INEXACT)
T(RN,  0x1.1471e239527b4p+247,    0x1.39b136098c662p-3,   0x1.6cda7ep-4, INEXACT)
T(RN,  0x1.7b98510412d0ap+247,   -0x1.7773cac607695p-1,  -0x1.c458bep-2, INEXACT)
T(RN,  0x1.b0e16c3d98b86p+247,   -0x1.522150926eb14p-1,   0x1.489ef2p-4, INEXACT)
T(RN,  0x1.9cf5b7335d934p+248,    0x1.0950b780cbe5ap-1,  -0x1.37745ep-3, INEXACT)
T(RN,  0x1.8bdb9d30edfd4p+248,   -0x1.c89bebeea7efdp-1,   0x1.4e7774p-2, INEXACT)
T(RN,  0x1.91f7f8bdf2f0dp+248,    0x1.0a61b29c84b03p-2,  -0x1.2f4942p-2, INEXACT)
T(RN,   0x1.d34d4a23526cp+248,   -0x1.c4369df3f8d98p-1,  -0x1.39e0bcp-2, INEXACT)
T(RN,  0x1.d7cc1da6a0be4p+248,    0x1.964639b9d6eafp-2,   0x1.f86cbcp-5, INEXACT)
T(RN,  0x1.073830755d26cp+248,    0x1.344e9d886a11bp-2,  -0x1.64554cp-2, INEXACT)
T(RN,  0x1.0ebfe9138583cp+248,   -0x1.fbcb131dc0a09p-1,   0x1.272418p-3, INEXACT)
T(RN,  0x1.83d494569a5aep+248,    0x1.63c4dcb1c054dp-1,   0x1.9640bcp-2, INEXACT)
T(RN,  0x1.7504217ad1956p+248,    0x1.9179681928d45p-2,   0x1.ef5c4ap-4, INEXACT)
T(RN,  0x1.b331ad6e1b0edp+248,    0x1.d2b3915622c24p-2,  -0x1.cf3544p-3, INEXACT)
T(RN,  0x1.868859f774041p+249,    0x1.1e464803216f4p-3,  -0x1.689976p-2, INEXACT)
T(RN,  0x1.e53b68aca16e1p+249,    0x1.7d41bebdd2d51p-1,   0x1.3adb78p-5, INEXACT)
T(RN,  0x1.338e8bbfd43aep+249,    0x1.fcedff9fe16dap-1,   0x1.9f63d8p-2, INEXACT)
T(RN,  0x1.67f2b4309fdeep+249,    0x1.ca32ef40ab186p-2,   0x1.a18776p-5, INEXACT)
T(RN,   0x1.9a71259462e6p+249,    0x1.fa20addf9c635p-2,  -0x1.624552p-4, INEXACT)
T(RN,  0x1.372a7c054390dp+249,   -0x1.bf3ca2174febap-1,   0x1.c2c3b2p-2, INEXACT)
T(RN,  0x1.651352af896b1p+249,    0x1.87f27e3b9c81dp-1,  -0x1.52b872p-2, INEXACT)
T(RN,  0x1.faac807bbfc59p+249,    0x1.9510870d9e1bdp-1,   0x1.9edd9ap-2, INEXACT)
T(RN,  0x1.2522f5c5466f8p+249,    0x1.5c3f504aed0fap-4,  -0x1.61b1b2p-4, INEXACT)
T(RN,  0x1.85257a9cf412ap+249,    0x1.dde3e001c26b4p-1,  -0x1.c0000ap-4, INEXACT)
T(RN,  0x1.df07e5a7a6aaap+250,    0x1.70823d64ad74ep-2,  -0x1.2169ccp-2, INEXACT)
T(RN,  0x1.01d5a617786adp+250,    0x1.dd6f336eb485bp-1,  -0x1.6149bcp-4, INEXACT)
T(RN,  0x1.76cec6bfdd271p+250,    0x1.e78fbc8fe1246p-1,   0x1.955a16p-2, INEXACT)
T(RN,  0x1.578708133585ap+250,    0x1.96c21fddbc743p-2,   0x1.7c748ap-4, INEXACT)
T(RN,  0x1.5e37a4cf36071p+250,    0x1.255755beac51bp-5,  -0x1.4741d2p-4, INEXACT)
T(RN,  0x1.a67b1c7b7932cp+250,    0x1.fa0f8e10254ccp-1,   0x1.b65b46p-3, INEXACT)
T(RN,  0x1.bc020e892bb97p+250,   -0x1.f63112f550d9fp-1,   -0x1.2e7dep-4, INEXACT)
T(RN,  0x1.48851a991cf3ep+250,    0x1.428c944e6f49dp-3,  -0x1.d57aeep-3, INEXACT)
T(RN,  0x1.eb6a07708c00fp+250,   -0x1.c195b5be20f7ap-3,  -0x1.9c3772p-3, INEXACT)
T(RN,  0x1.2416cb40fe5b1p+250,   -0x1.f9ac5799b6047p-2,   0x1.2b0682p-4, INEXACT)
T(RN,  0x1.bc635cb25accbp+251,    0x1.30806d2b09bb3p-3,    0x1.5d708p-3, INEXACT)
T(RN,  0x1.3df04563760b2p+251,    0x1.94221dd3933d6p-1,   0x1.fd3884p-2, INEXACT)
T(RN,  0x1.1bbf767276703p+251,    0x1.e6c1a5269b289p-3,   0x1.c696fcp-3, INEXACT)
T(RN,  0x1.06e463e07eb58p+251,     0x1.2c4528ced759p-2,  -0x1.fc485ap-3, INEXACT)
T(RN,  0x1.902c9e4ed9fdap+251,   -0x1.f8cfbfa8b437cp-1,  -0x1.0af30ap-3, INEXACT)
T(RN,  0x1.008d4e4306429p+251,    0x1.0e3e78691fdd4p-2,  -0x1.6cfa48p-2, INEXACT)
T(RN,  0x1.3ea14fdf267ffp+251,   -0x1.87a6cc11fb0f1p-1,  -0x1.f38bdap-3, INEXACT)
T(RN,  0x1.84e001e32cb11p+251,    0x1.454059220e3b8p-2,  -0x1.463ae6p-2, INEXACT)
T(RN,  0x1.0d5014a88ad7fp+251,   -0x1.813b9d4bba243p-2,  -0x1.28ed5cp-3, INEXACT)
T(RN,  0x1.2ad2549c4e916p+251,   -0x1.2a017d80b1b5cp-1,   0x1.08d29cp-4, INEXACT)
T(RN,  0x1.d1fd5354774d4p+252,    0x1.4eb93c235f07bp-1,   0x1.b8bcfap-3, INEXACT)
T(RN,  0x1.ab31e79239716p+252,   -0x1.6a7bd62fc1e7bp-1,   0x1.357f8ep-3, INEXACT)
T(RN,  0x1.466a46d692331p+252,   -0x1.4c68158a50804p-3,   0x1.a5ed74p-2, INEXACT)
T(RN,  0x1.b617e7a84d092p+252,   -0x1.ec0d5eb4f93b6p-2,    0x1.31389p-2, INEXACT)
T(RN,  0x1.e7d69a67821d6p+252,    0x1.cfdf3152faa9ap-1,  -0x1.ab7932p-2, INEXACT)
T(RN,  0x1.55ec941cec2c4p+252,    0x1.a88f7cfe01b96p-1,   0x1.585fe8p-3, INEXACT)
T(RN,  0x1.16696da41da14p+252,    0x1.d01200999744dp-2,  -0x1.f4fbb6p-3, INEXACT)
T(RN,  0x1.a422e8843b047p+252,   -0x1.117b1849e498dp-4,  -0x1.878a6cp-2, INEXACT)
T(RN,  0x1.c885213c1cb9cp+252,    0x1.8fa4f27a81219p-1,  -0x1.50ec6ap-5, INEXACT)
T(RN,  0x1.ddc8aa30e22f4p+252,     0x1.674bccd7d748p-4,  -0x1.852e8ep-4, INEXACT)
T(RN,  0x1.1fe3ee9e8c1e6p+253,   -0x1.f9b41b832d36ap-1,   0x1.2dd946p-2, INEXACT)
T(RN,  0x1.09203d082f1c2p+253,   -0x1.d2d18674664bep-1,  -0x1.734d24p-2, INEXACT)
T(RN,  0x1.3dcd010589c96p+253,   -0x1.9aa9ddda6190fp-2,   0x1.67567cp-4, INEXACT)
T(RN,  0x1.0ffcf4ccd8529p+253,    0x1.7937122b6df68p-2,   0x1.80048ep-2, INEXACT)
T(RN,  0x1.d62ed2c43b4f5p+253,   -0x1.9c69303667f75p-1,    0x1.d4c75p-3, INEXACT)
T(RN,  0x1.04f297892a34ep+253,   -0x1.495affef1f733p-1,   0x1.c1478cp-4, INEXACT)
T(RN,  0x1.e0f0d83a618bcp+253,   -0x1.1d9ebc9f49cdcp-2,  -0x1.192d1ap-6, INEXACT)
T(RN,  0x1.6bdec21e4b707p+253,   -0x1.ff09bad540a27p-1,   0x1.21857ep-2, INEXACT)
T(RN,   0x1.2448a2b13bb6p+253,   -0x1.a8c23fcd47273p-5,  -0x1.55f1c6p-2, INEXACT)
T(RN,  0x1.852c60477e3cap+253,   -0x1.ec59a1eb66249p-1,   0x1.cfaa12p-4, INEXACT)
T(RN,  0x1.a3ee7a2f127dep+254,   -0x1.c6723454ae6c7p-1,   -0x1.0b2fbp-3, INEXACT)
T(RN,   0x1.55bb8e9b791bp+254,    0x1.78230b6b87d47p-1,  -0x1.2db496p-2, INEXACT)
T(RN,  0x1.8376fe31a7607p+254,    0x1.4301cbd88d415p-1,  -0x1.5f4ac8p-3, INEXACT)
T(RN,  0x1.73ca4f4f47264p+254,   -0x1.537ee61655829p-1,  -0x1.93fbc4p-2, INEXACT)
T(RN,  0x1.349a34f7c86e5p+254,    0x1.5b0a0adfcc0eap-2,   0x1.a33cf6p-2, INEXACT)
T(RN,  0x1.0f8c180461435p+254,   -0x1.5a003d2c4d08ap-1,   0x1.d15b92p-3, INEXACT)
T(RN,  0x1.e33a4265b53bfp+254,    0x1.ff0723f1f7174p-1,  -0x1.85d338p-2, INEXACT)
T(RN,  0x1.944c5a761b9b7p+254,    0x1.278a77be5066dp-1,  -0x1.0bf74cp-2, INEXACT)
T(RN,  0x1.cbded1399982cp+254,   -0x1.b80bbaeafe9abp-1,   -0x1.1f70cp-2, INEXACT)
T(RN,  0x1.dca030fc842cap+254,     0x1.ff4c6725442dp-1,   0x1.1e2b88p-2, INEXACT)
T(RN,  0x1.14612c1301818p+255,   -0x1.a0d430bccd1afp-2,  -0x1.7a5b22p-4, INEXACT)
T(RN,  0x1.3244d9109986cp+255,    0x1.1cc72d2715ac6p-1,  -0x1.4d757ap-5, INEXACT)
T(RN,   0x1.d6c631123e8fp+255,   -0x1.ffcb2e1a2b4c5p-1,  -0x1.ffd56ap-6, INEXACT)
T(RN,  0x1.d84d9e023963cp+255,   -0x1.fff5534a23046p-1,   0x1.88e128p-4, INEXACT)
T(RN,  0x1.3ebcbbbb2fe48p+255,    -0x1.a1266df0e64fp-1,   -0x1.4eaddp-2, INEXACT)
T(RN,  0x1.8d74d700ff7c2p+255,   -0x1.00d389ba5aba8p-2,   0x1.4a645ap-2, INEXACT)
T(RN,   0x1.89358ccc20d5p+255,   -0x1.6d01f90d51e72p-2,   0x1.4b7588p-2, INEXACT)
T(RN,  0x1.a5d7dab0fab8cp+255,   -0x1.a87e7367c4975p-7,   0x1.e8bf3ep-2, INEXACT)
T(RN,   0x1.dbf61c2caa22p+255,    0x1.fb7c9e2578264p-1,   -0x1.a5fadp-2, INEXACT)
T(RN,  0x1.7436bfc56b14cp+255,   -0x1.531e3ef472dfap-3,  -0x1.e6662ep-3, INEXACT)
T(RN,  0x1.051ff9ed766c6p+256,    0x1.f0b724089484bp-1,  -0x1.940b58p-4, INEXACT)
T(RN,  0x1.850e3e31e98a7p+256,    0x1.dd8d0df56de39p-3,  -0x1.379208p-9, INEXACT)
T(RN,  0x1.e944ee8f585b7p+256,    0x1.ea7587d4a9b4fp-1,   0x1.2dccd8p-4, INEXACT)
T(RN,  0x1.4c631bca92b81p+256,    0x1.0f727ce1f936ep-1,   0x1.8dd65cp-3, INEXACT)
T(RN,  0x1.daae81b7e9284p+256,   -0x1.d1e3138b293a7p-1,   0x1.b4f706p-2, INEXACT)
T(RN,  0x1.6c9a1e4e17768p+256,    0x1.a902567ac9e9ap-1,   0x1.1429b2p-3, INEXACT)
T(RN,  0x1.3304e56bbeb19p+256,     0x1.96570bf44db2p-1,  -0x1.d61cecp-4, INEXACT)
T(RN,  0x1.1962d6e8dcb53p+256,   -0x1.fd2538ba6ae8ep-1,    -0x1.8f6fp-8, INEXACT)
T(RN,  0x1.f11eaba8618bcp+256,   -0x1.be133b1a52c61p-2,    0x1.0b6f8p-2, INEXACT)
T(RN,  0x1.cb07b4df76ea8p+256,   -0x1.bbea6e6db3cd7p-1,  -0x1.6e7ba2p-2, INEXACT)
T(RN,   0x1.afb0387742b6p+257,   -0x1.1b696f4d12f02p-6,   0x1.b368c8p-2, INEXACT)
T(RN,  0x1.544bba447d8eap+257,   -0x1.81c75ed187c02p-1,  -0x1.54cc36p-2, INEXACT)
T(RN,  0x1.2a79df49c38e1p+257,    0x1.ebe1b304ab7c2p-1,  -0x1.9a21fcp-4, INEXACT)
T(RN,  0x1.2187cc0321a48p+257,   -0x1.c1d11043029edp-1,  -0x1.27ed0cp-2, INEXACT)
T(RN,  0x1.baedb1b0f1895p+257,   -0x1.5d64df0e38bb5p-4,  -0x1.c1ea16p-2, INEXACT)
T(RN,  0x1.658c623fed7f7p+257,   -0x1.d151dc0419ef3p-3,  -0x1.a9473ap-5, INEXACT)
T(RN,  0x1.0800a4401ffb1p+257,    0x1.d3ffe1bc92fcep-1,   0x1.e875dcp-2, INEXACT)
T(RN,  0x1.79269a5b55841p+257,   -0x1.82118d9ec001bp-2,    0x1.79885p-2, INEXACT)
T(RN,  0x1.324dcc481556fp+257,    0x1.b6ae76727a3a9p-1,  -0x1.51a7f2p-2, INEXACT)
T(RN,   0x1.227fa07fcd94p+257,     0x1.8b0f6ea3209cp-1,   -0x1.b0a2ap-3, INEXACT)
T(RN,  0x1.4c5b9d00c03d2p+258,   -0x1.74e262b3f620dp-1,  -0x1.5b6936p-2, INEXACT)
T(RN,  0x1.ee83186bc7f06p+258,   -0x1.c34a87aa23414p-1,   0x1.791afap-2, INEXACT)
T(RN,   0x1.8fa820eed119p+258,    0x1.d9022fab7b6d6p-2,   0x1.479506p-2, INEXACT)
T(RN,  0x1.04cc59fea28abp+258,    0x1.ffffbab7beb3dp-1,   0x1.710e74p-2, INEXACT)
T(RN,  0x1.11f97705e34ffp+258,    0x1.f43e09f903987p-1, -0x1.1b5a16p-12, INEXACT)
T(RN,  0x1.44b73e3858623p+258,    0x1.d5fa12b0e05f9p-3,  -0x1.71c3eep-4, INEXACT)
T(RN,  0x1.203eb34925de4p+258,    0x1.b34e4cf939823p-1,   0x1.f84552p-2, INEXACT)
T(RN,  0x1.51481d2253ccdp+258,    0x1.f867c06e3d0d4p-1,   0x1.07d048p-4, INEXACT)
T(RN,  0x1.3f895ed2f3296p+258,   -0x1.cb39b7baf1d14p-1,  -0x1.1f941cp-5, INEXACT)
T(RN,  0x1.0aaf65d34e953p+258,   -0x1.fe4daa5568dc5p-1,   0x1.98d5eap-2, INEXACT)
T(RN,  0x1.a005899a6c12ep+259,   -0x1.e51264b13c3dap-1,  -0x1.74117ep-3, INEXACT)
T(RN,  0x1.986b0b7915702p+259,   -0x1.09ca3962b38d6p-1,  -0x1.b07394p-2, INEXACT)
T(RN,  0x1.52b913e491b66p+259,    0x1.575aac8ae1a24p-1,  -0x1.3aafc6p-2, INEXACT)
T(RN,  0x1.e3012d8cc722dp+259,   -0x1.c083120f2a20dp-1,   0x1.37ba06p-2, INEXACT)
T(RN,  0x1.f01c3d82c22bbp+259,    0x1.1a7d6597be381p-1,  -0x1.4c9eb2p-3, INEXACT)
T(RN,  0x1.81953156a74fcp+259,    0x1.0514df19fe2a3p-2,   0x1.091d9ep-2, INEXACT)
T(RN,  0x1.df09af2b9467cp+259,     0x1.36121c10b1d4p-1,  -0x1.b36df6p-5, INEXACT)
T(RN,   0x1.772a9a849236p+259,   -0x1.fde0ce9aaf7d1p-1,  -0x1.28f46cp-3, INEXACT)
T(RN,  0x1.e535632442118p+259,    0x1.2906b9af4eeb7p-1,  -0x1.c3442ep-3, INEXACT)
T(RN,  0x1.a822da6084233p+259,   -0x1.3ca8988233a8cp-3,   0x1.8fdc06p-2, INEXACT)
T(RN,  0x1.6c6e0a012322ep+260,   -0x1.7579586533a99p-1,   0x1.14d1dcp-2, INEXACT)
T(RN,  0x1.e4955dff6939ep+260,    0x1.fca070232a2a8p-2,    0x1.a54eap-4, INEXACT)
T(RN,  0x1.9ca4c1ba991cap+260,    0x1.926afac09f9a7p-1,   0x1.63a75cp-2, INEXACT)
T(RN,  0x1.c7cc02f323546p+260,    0x1.e4264ed8bd221p-1,   0x1.e896f4p-2, INEXACT)
T(RN,  0x1.62459f1de51c7p+260,   -0x1.f71ba2b3988a7p-1,   0x1.806c2ap-2, INEXACT)
T(RN,  0x1.e3d243909367ap+260,    0x1.50a354a52b4d4p-3,   -0x1.877cap-2, INEXACT)
T(RN,  0x1.9176ed313a724p+260,   -0x1.fa7fcdaa2b33ap-1,  -0x1.6a7b94p-6, INEXACT)
T(RN,  0x1.b9bd78bb9aa8ep+260,    0x1.955fdbae32da1p-1,   0x1.abd932p-2, INEXACT)
T(RN,  0x1.5d35146f1710ep+260,   -0x1.b1b81cebec974p-1,   0x1.eebf5cp-3, INEXACT)
T(RN,  0x1.54416a644d763p+260,    0x1.d98977b906304p-1,  -0x1.9dd894p-3, INEXACT)
T(RN,  0x1.85562808446bcp+261,   -0x1.38644a91cf7e9p-2,   0x1.0d124cp-2, INEXACT)
T(RN,  0x1.5b633fd8bc7f4p+261,    0x1.e223eb0c2aa75p-3,   -0x1.72515p-3, INEXACT)
T(RN,   0x1.d82217730d32p+261,   -0x1.39ec5e260e954p-4,   0x1.aaea0cp-4, INEXACT)
T(RN,  0x1.14b215864cfaap+261,    0x1.5b9c90ca0fa86p-3,  -0x1.caa752p-3, INEXACT)
T(RN,  0x1.f333fd6ac7ba2p+261,    0x1.ff58761741109p-1,  -0x1.acd9aep-3, INEXACT)
T(RN,  0x1.96b4c2ad5da3cp+261,    0x1.0581f084f1ca3p-1,   -0x1.522f6p-3, INEXACT)
T(RN,  0x1.e75effa8c2fb7p+261,    0x1.d9f73da6ac231p-1,  -0x1.30003cp-2, INEXACT)
T(RN,  0x1.a8401a960197fp+261,    0x1.fdaf16cf5453bp-1,    0x1.339b3p-3, INEXACT)
T(RN,  0x1.ed1f1bf1ca278p+261,    0x1.7f6699afa2cccp-6,  -0x1.fef1fap-2, INEXACT)
T(RN,  0x1.40559f6b08a67p+261,    0x1.dbc9c28eb14f3p-2,    0x1.36227p-2, INEXACT)
T(RN,  0x1.6e9c0da231b0cp+262,   -0x1.888275880454dp-1,  -0x1.81ed1ap-7, INEXACT)
T(RN,  0x1.05d696fe9135cp+262,   -0x1.54be7596b4016p-1,   0x1.0faa68p-2, INEXACT)
T(RN,  0x1.5c1fce4d18e3ap+262,   -0x1.035a056780326p-3,  -0x1.f271c8p-2, INEXACT)
T(RN,  0x1.3574c829031abp+262,   -0x1.45b6b8793cb9ep-4,  -0x1.5eebd4p-2, INEXACT)
T(RN,  0x1.1ff66e90c7accp+262,   -0x1.d76651bc34f1bp-1,   -0x1.7e26cp-2, INEXACT)
T(RN,  0x1.c7db1f916bab2p+262,    0x1.c0178fe62246bp-1,   0x1.71069ep-3, INEXACT)
T(RN,  0x1.4292652258485p+262,    -0x1.484843556333p-6,   0x1.f351dap-3, INEXACT)
T(RN,  0x1.58e73977cd592p+262,    0x1.5f556f3b49c81p-1,    0x1.82ad9p-2, INEXACT)
T(RN,  0x1.b47501e0da9cap+262,    -0x1.1342a13f0ceap-3,   -0x1.29c86p-2, INEXACT)
T(RN,  0x1.7589932a22af3p+262,     0x1.77d709f19592p-2,   0x1.ca5a92p-2, INEXACT)
T(RN,  0x1.ed9a22c01a6d5p+263,    0x1.a1f4bb33f5ffdp-2,  -0x1.792b9cp-2, INEXACT)
T(RN,  0x1.cead8af3bd929p+263,    0x1.cdbbef8ee1cb1p-3,   0x1.8f7258p-2, INEXACT)
T(RN,  0x1.36c0f55c67af8p+263,    -0x1.de1701b1ca07p-2,  -0x1.765602p-2, INEXACT)
T(RN,  0x1.53dc6c8884dcbp+263,     0x1.43e16e9cf079p-2,  -0x1.941e4ep-3, INEXACT)
T(RN,  0x1.9ddbcc275d02ep+263,   -0x1.cb3cc7c716e47p-1,  -0x1.ce28f6p-2, INEXACT)
T(RN,   0x1.8fdbbd8d2ce1p+263,    0x1.dc2cbaed7aaa9p-1,   0x1.c7da6cp-7, INEXACT)
T(RN,  0x1.41cdb46355ae7p+263,    0x1.bae7883154e6bp-1,    0x1.b3191p-5, INEXACT)
T(RN,  0x1.e57ac0a93aff7p+263,    0x1.9e81ca334d7a6p-1,  -0x1.47ec16p-3, INEXACT)
T(RN,  0x1.72ebbe1ae27cep+263,    0x1.6955316d873d4p-5,  -0x1.6b7feep-3, INEXACT)
T(RN,  0x1.1e0b221874936p+263,    0x1.e8cab117d004fp-1,   0x1.bfa766p-2, INEXACT)
T(RN,  0x1.c36ad884b8a93p+264,   -0x1.c9fa959de590ep-1,    0x1.c1fbdp-3, INEXACT)
T(RN,  0x1.ce7afb8792816p+264,    0x1.b00d844bc3348p-1,  -0x1.067886p-2, INEXACT)
T(RN,  0x1.3ec8f513e6d76p+264,   -0x1.6dd2cbbbbad1fp-1,   0x1.a92d7ap-2, INEXACT)
T(RN,   0x1.b01f761feff2p+264,   -0x1.ffcf1f02a34cbp-1,   0x1.91ac38p-5, INEXACT)
T(RN,  0x1.dcbf300e6706ep+264,   -0x1.40c8da3a8aec5p-1,   0x1.bec96cp-2, INEXACT)
T(RN,  0x1.07b6f021dff57p+264,    -0x1.b9ebdb63fe63p-6,  -0x1.cfdc7cp-2, INEXACT)
T(RN,  0x1.918112fd431e8p+264,    0x1.eeaa603198b9fp-1,  -0x1.d00b66p-3, INEXACT)
T(RN,  0x1.54169ed4ed1e1p+264,   -0x1.78543578de688p-1,   0x1.f5e91ep-2, INEXACT)
T(RN,  0x1.8b4071739f2fep+264,    0x1.31c1f8129f646p-1,   0x1.16bc2ap-3, INEXACT)
T(RN,  0x1.c4e2374903fa8p+264,    0x1.b54fa4bdfca5bp-3,  -0x1.946024p-3, INEXACT)
T(RN,  0x1.16aad8cb69c5bp+265,   -0x1.c5a914d8bcc23p-1,  -0x1.31abbcp-3, INEXACT)
T(RN,  0x1.6bc3adaa6c65cp+265,    0x1.829cf7c9d6981p-1,    0x1.b95ddp-6, INEXACT)
T(RN,  0x1.321e4547da708p+265,   -0x1.c1a8252dfb064p-1,    0x1.29701p-2, INEXACT)
T(RN,  0x1.f1a5869bd956fp+265,    0x1.fed100bb9b923p-1,  -0x1.f04dfcp-2, INEXACT)
T(RN,  0x1.62215e130e99cp+265,   -0x1.137e4b446be59p-2,  -0x1.1e9fd2p-2, INEXACT)
T(RN,  0x1.974305a3a7b8ap+265,   -0x1.8985a229678f9p-1,  -0x1.9cb6cap-2, INEXACT)
T(RN,  0x1.64ccaf4adc4fcp+265,    0x1.0832ca569ac35p-3,   0x1.380bb6p-2, INEXACT)
T(RN,   0x1.dc513b134e7ap+265,    0x1.cb8846c9e42b9p-1,   0x1.e7c414p-3, INEXACT)
T(RN,  0x1.d382bbbb1b3fap+265,   -0x1.ab0c1e17f9079p-2,   0x1.b46ebep-5, INEXACT)
T(RN,  0x1.8d1df60ab72eep+265,    0x1.e901ef5db3dcap-1,  -0x1.c265eap-4, INEXACT)
T(RN,  0x1.40733a9a885dep+266,    0x1.396f694bcaeadp-3,   0x1.710f14p-2, INEXACT)
T(RN,  0x1.06ad2dd68f35bp+266,   -0x1.a55ee4e6a87c4p-1,  -0x1.cfa4b4p-6, INEXACT)
T(RN,  0x1.66d2a3a1d1ecdp+266,    0x1.e2e305568322fp-1,   0x1.a6a9d6p-2, INEXACT)
T(RN,  0x1.b71325d0a4f49p+266,   -0x1.66f7f687aac1fp-3,    0x1.b1401p-3, INEXACT)
T(RN,  0x1.595e45f8c9f6ap+266,     0x1.70dd7268f063p-1,   0x1.aefeacp-2, INEXACT)
T(RN,  0x1.3da702ba3bceep+266,    0x1.ac258602e9096p-1,   0x1.d56486p-2, INEXACT)
T(RN,  0x1.5132a8e346188p+266,    0x1.715b33c3ab64dp-2,  -0x1.c5709ap-3, INEXACT)
T(RN,  0x1.bec3279e5c09ap+266,   -0x1.adcae8f3083c4p-1,   0x1.01720ep-4, INEXACT)
T(RN,  0x1.23cb47151a058p+266,   -0x1.6c90f485d32c4p-1,   0x1.f529b6p-2, INEXACT)
T(RN,  0x1.5dbba5b5ca498p+266,   -0x1.6f43bf265ded8p-1,  -0x1.ab4f58p-2, INEXACT)
T(RN,  0x1.d86aeb6123073p+267,   -0x1.4e00f79bb3737p-1,   0x1.7a159ep-2, INEXACT)
T(RN,  0x1.c2cde829451dcp+267,   -0x1.fbd1394daca17p-1,   0x1.e3e6bep-2, INEXACT)
T(RN,   0x1.8d51cf9466cbp+267,    0x1.ff62d70016e5cp-1,   0x1.7a59c6p-6, INEXACT)
T(RN,  0x1.8d1412cbc316bp+267,   -0x1.ffd4e3a5e663fp-1,  -0x1.f0fdaap-2, INEXACT)
T(RN,  0x1.b72b50c3389cap+267,   -0x1.75898adc56292p-1,    0x1.e8052p-2, INEXACT)
T(RN,  0x1.8c4d414ca677cp+267,    0x1.ffffb13b812d1p-1,   0x1.cd16e6p-2, INEXACT)
T(RN,  0x1.b80ab4086611fp+267,   -0x1.dc9342884d0e8p-1,  -0x1.bdf80ap-3, INEXACT)
T(RN,  0x1.d8bba01abea61p+267,   -0x1.9a66e7d076146p-2,   0x1.41cfacp-2, INEXACT)
T(RN,  0x1.7642bc54a1e0ep+267,   -0x1.4ebf0e7f82a29p-4,   0x1.1b6b5ap-5, INEXACT)
T(RN,  0x1.6bf2c48392dc7p+267,    0x1.ec0ca0b400b8ap-1,   0x1.e5a168p-2, INEXACT)
T(RN,  0x1.462a0ee3cbe61p+268,    0x1.ff83147880fc3p-1,  -0x1.6993e4p-3, INEXACT)
T(RN,  0x1.3d4b1a5a6e2b6p+268,   -0x1.d1935048c7591p-1,  -0x1.3ed3cep-4, INEXACT)
T(RN,  0x1.be3040ce2e782p+268,   -0x1.185740bfc5f12p-4,  -0x1.49d3a6p-4, INEXACT)
T(RN,  0x1.75b126f3a6a76p+268,    0x1.21d3673fdffddp-2,   0x1.39ebcep-5, INEXACT)
T(RN,  0x1.146d3a4d9cb32p+268,    0x1.01b25eeecc61ap-2,   0x1.fb4bbcp-3, INEXACT)
T(RN,  0x1.49e0b27f5cf7dp+268,    0x1.97af675f8509cp-3,  -0x1.ac6d18p-4, INEXACT)
T(RN,  0x1.13ae2ecb32f0dp+268,   -0x1.49b33f5305ad3p-4,   0x1.92bda4p-2, INEXACT)
T(RN,  0x1.492ddc39d84d2p+268,    0x1.fff0a1cf5edd9p-1,   0x1.887e7ap-3, INEXACT)
T(RN,  0x1.349839360ef17p+268,    0x1.bcac5c7ff966ap-4,   0x1.2e5382p-2, INEXACT)
T(RN,  0x1.8d4971f25b091p+268,   -0x1.dd88f37e246eap-1,   0x1.fa13acp-3, INEXACT)
T(RN,  0x1.67c263e739921p+269,   -0x1.5075bf12e58e2p-1,   0x1.d38938p-5, INEXACT)
T(RN,  0x1.360363896c386p+269,      0x1.169532056b6p-1,   0x1.a3d05ap-2, INEXACT)
T(RN,  0x1.b40582b50d21cp+269,     0x1.f7259425e703p-1,   0x1.60f528p-2, INEXACT)
T(RN,  0x1.dc3ddb0ce780ep+269,   -0x1.ec86029de9a08p-1,   0x1.131772p-6, INEXACT)
T(RN,  0x1.db45526a22c85p+269,     0x1.0275f17226aap-3,   0x1.817268p-2, INEXACT)
T(RN,  0x1.1baf708e69ef7p+269,    0x1.c8b416cb6fafcp-3,  -0x1.038b06p-2, INEXACT)
T(RN,  0x1.eab97ff11c7a4p+269,    0x1.f5b43a1e8d588p-1,   0x1.66f6d4p-2, INEXACT)
T(RN,  0x1.dc828441c97d5p+269,    0x1.10ef6c248b083p-1,    0x1.e04d7p-2, INEXACT)
T(RN,  0x1.77d040123a1c2p+269,    0x1.ba05f32e63a4cp-6,   0x1.a3fb1ap-2, INEXACT)
T(RN,  0x1.623031ee881a5p+269,   -0x1.d8c5b34b521a6p-1,   0x1.207b94p-2, INEXACT)
T(RN,  0x1.64e6de0eceec5p+270,   -0x1.cebf229dbd3cbp-1,   0x1.814c74p-3, INEXACT)
T(RN,  0x1.939417b180dc2p+270,    0x1.8d05cf2e60258p-1,    0x1.b9ba2p-2, INEXACT)
T(RN,  0x1.88a79588849a3p+270,   -0x1.66f16a3933f03p-1,  -0x1.b646d2p-2, INEXACT)
T(RN,   0x1.3bdf255bf505p+270,    0x1.fc72037c90b7ap-1,   -0x1.5d3b3p-3, INEXACT)
T(RN,  0x1.637a885893fdcp+270,    0x1.9efb70584197fp-1,   0x1.eaff22p-2, INEXACT)
T(RN,  0x1.20109f28a5c24p+270,   -0x1.fd6ae1860a524p-1,  -0x1.c9b722p-2, INEXACT)
T(RN,  0x1.7f95fc37eba5cp+270,    0x1.a0f2fc98bb567p-3,  -0x1.ac0108p-4, INEXACT)
T(RN,  0x1.bf523e055f79ep+270,   -0x1.bb40c4a2e3621p-5,   0x1.fc3688p-5, INEXACT)
T(RN,   0x1.d76749b70152p+270,    0x1.fd91b57583c74p-1,   0x1.b7cb14p-6, INEXACT)
T(RN,  0x1.2a7e2417d27c8p+270,    0x1.e21174c1c506cp-1,  -0x1.543c8ap-3, INEXACT)
T(RN,  0x1.39d43ad2b8b8dp+271,    0x1.ffacda3d0c585p-1,  -0x1.1f723cp-2, INEXACT)
T(RN,   0x1.42ee04435c86p+271,    0x1.0e9a183ccfee6p-2,    -0x1.b69dp-2, INEXACT)
T(RN,  0x1.d915addb5eaaep+271,   -0x1.6dcc155531bb6p-2,  -0x1.3983c2p-4, INEXACT)
T(RN,   0x1.8f81e1645fe4p+271,   -0x1.8685b26bbca9fp-1,   0x1.a82174p-2, INEXACT)
T(RN,  0x1.354675f33c3cdp+271,    0x1.53fc921e6c3a4p-1,   0x1.e52c78p-4, INEXACT)
T(RN,  0x1.3e5866cdfe0d6p+271,    0x1.ada7ad09bc683p-1,     0x1.58bdp-3, INEXACT)
T(RN,  0x1.d14d430bcce88p+271,   -0x1.160ef9b7fbc63p-1,  -0x1.2b091ap-2, INEXACT)
T(RN,  0x1.823b87f48aa5cp+271,    0x1.d5d53e46a822dp-1,  -0x1.7d01dcp-3, INEXACT)
T(RN,   0x1.896d1ea4094bp+271,   -0x1.fabf36904d101p-2,  -0x1.544b52p-2, INEXACT)
T(RN,  0x1.e6bd04f1eb2c6p+271,   -0x1.9a4eeaf298fa3p-1,   0x1.89122ep-3, INEXACT)
T(RN,  0x1.1c20bdf5f02afp+272,    0x1.652862519abe6p-4,  -0x1.fd3dbap-6, INEXACT)
T(RN,  0x1.fa8feaecc5c68p+272,   -0x1.cbdaa07f97591p-1,   0x1.02f202p-6, INEXACT)
T(RN,  0x1.d02a433bf424cp+272,    0x1.0145b137edcf6p-1,  -0x1.241f42p-2, INEXACT)
T(RN,  0x1.de28b66a30de5p+272,    0x1.314432609c1fap-3,  -0x1.824e88p-2, INEXACT)
T(RN,  0x1.c2b3f35ac794cp+272,    0x1.961f35a7ab60fp-3,  -0x1.be8bbcp-4, INEXACT)
T(RN,  0x1.e4ec14cf8ae52p+272,   -0x1.f8bc3f682c67fp-1,   0x1.f98c2ep-2, INEXACT)
T(RN,  0x1.da97e539da884p+272,    0x1.ff6e5171f9519p-1,   0x1.88434ap-5, INEXACT)
T(RN,  0x1.9fdaa6c41126cp+272,    0x1.fcfcc1d7705dap-1,  -0x1.79f262p-2, INEXACT)
T(RN,  0x1.985d1ff76a738p+272,    0x1.a2439dda82f48p-1,  -0x1.9f3014p-3, INEXACT)
T(RN,  0x1.c0ab9b7ea5d36p+272,   -0x1.5023950e9b57cp-1,   0x1.a1bcf2p-2, INEXACT)
T(RN,  0x1.6d566dfd34d16p+273,    0x1.f257ce87e70edp-1,   -0x1.6bd2bp-2, INEXACT)
T(RN,  0x1.803353dad748ep+273,   -0x1.d9d6e25efa283p-1,   0x1.9b3e94p-3, INEXACT)
T(RN,  0x1.1b0329af38462p+273,    0x1.fbf8ce4b67035p-1,  -0x1.9eda0ap-4, INEXACT)
T(RN,  0x1.ba6a866213e1ap+273,   -0x1.f7d91d83b972cp-1,   0x1.f95918p-2, INEXACT)
T(RN,  0x1.c07e532934f4ep+273,     0x1.6c19eae15771p-6,   0x1.9e097ap-2, INEXACT)
T(RN,  0x1.cfe7cd685af3ap+273,    0x1.f5702b26ec175p-1,  -0x1.905b0ap-4, INEXACT)
T(RN,  0x1.d2243b4d84e1ep+273,   -0x1.d777ff7132266p-3,  -0x1.8ff624p-3, INEXACT)
T(RN,  0x1.a5e9c179ee668p+273,     0x1.1fb7d8a785a7p-1,  -0x1.e12406p-2, INEXACT)
T(RN,  0x1.7374d4214caa9p+273,    0x1.fea75784bbe45p-1,  -0x1.f7ed1ep-2, INEXACT)
T(RN,  0x1.4799243328dd1p+273,   -0x1.ee885bb9b4cbcp-1,   0x1.c409eep-2, INEXACT)
T(RN,  0x1.654aac05ec7c6p+274,   -0x1.dc0d9e755d7afp-1,   -0x1.b8794p-2, INEXACT)
T(RN,  0x1.2d1f25f96a0c9p+274,   -0x1.6ed8892114906p-4,  -0x1.a18caap-7, INEXACT)
T(RN,  0x1.d9e21b797a818p+274,    0x1.fff0a1b73b40bp-1,   0x1.4bc5aep-3, INEXACT)
T(RN,   0x1.fefa6fbe2594p+274,    0x1.e2da8e498a079p-1,   0x1.1d0c18p-5, INEXACT)
T(RN,  0x1.ca1872d085cd2p+274,    -0x1.759320308fbep-1,   0x1.14fdd4p-2, INEXACT)
T(RN,  0x1.51295ef798094p+274,   -0x1.31896ff744f7fp-1,  -0x1.7f815ep-2, INEXACT)
T(RN,  0x1.5cd8a27b5289ap+274,    0x1.d342b7bd127adp-4,  -0x1.7ddc0cp-3, INEXACT)
T(RN,  0x1.9df6b11951998p+274,     0x1.88ef00577c13p-2,  -0x1.c15e42p-4, INEXACT)
T(RN,  0x1.75d720af27dd3p+274,    0x1.99e9e61e3d42fp-1,  -0x1.e57328p-7, INEXACT)
T(RN,  0x1.d200ced15b2f1p+274,    0x1.7e15912f4631dp-3,  -0x1.ef7814p-2, INEXACT)
T(RN,  0x1.8fdd668088588p+275,   -0x1.1d9d9a6182ff6p-3,   0x1.78a70ap-9, INEXACT)
T(RN,  0x1.aec8b55d53693p+275,    0x1.3ae26c4ee5baep-2,  -0x1.b80c0ep-2, INEXACT)
T(RN,  0x1.f259e2a844804p+275,    0x1.1a4ae63082708p-1,  -0x1.5d7aacp-4, INEXACT)
T(RN,  0x1.a52d18eeb702fp+275,   -0x1.fab467d0d7b16p-1,  -0x1.bfc29cp-2, INEXACT)
T(RN,  0x1.0f7c8b810197cp+275,   -0x1.501d19c6702f4p-1,  -0x1.6e5398p-2, INEXACT)
T(RN,  0x1.e63b53027f522p+275,    0x1.96c76df869a5cp-1,   0x1.7077dcp-4, INEXACT)
T(RN,  0x1.d7da1807a4b36p+275,    0x1.25f64dae11e94p-2,   0x1.d11b2ep-2, INEXACT)
T(RN,  0x1.9d0ad78c198a4p+275,   -0x1.51d376734890ap-1,  -0x1.68ec84p-3, INEXACT)
T(RN,  0x1.f71263cbcd18cp+275,   -0x1.cd0f42cb0166ep-1,  -0x1.f77d74p-2, INEXACT)
T(RN,  0x1.9fec52719ca64p+275,    0x1.fb355e4b79e03p-1,    0x1.e10f8p-2, INEXACT)
T(RN,   0x1.20b3539757cep+276,   -0x1.fee4a6d8ee154p-1,   0x1.9b4abap-4, INEXACT)
T(RN,  0x1.3b6168ca14448p+276,   -0x1.fb338c2e650c8p-1,  -0x1.7a63f6p-2, INEXACT)
T(RN,  0x1.232c27f429eccp+276,   -0x1.9f723da51b29ep-1,   0x1.ea4e36p-3, INEXACT)
T(RN,  0x1.8d3a97b529347p+276,   -0x1.ff5f2c20f1decp-1,   0x1.e64a52p-5, INEXACT)
T(RN,  0x1.987b91ef7dfa6p+276,    0x1.e38da477232e1p-1,   0x1.3bd428p-7, INEXACT)
T(RN,  0x1.8fd1c6131bfe6p+276,    0x1.20372db10e99bp-1,  -0x1.515fc6p-3, INEXACT)
T(RN,  0x1.b35595acd6d53p+276,   -0x1.971d9f69e7985p-1,  -0x1.f51a38p-3, INEXACT)
T(RN,  0x1.bc51d7f519fd6p+276,    0x1.de69825385085p-3,   -0x1.08bcap-2, INEXACT)
T(RN,  0x1.bf967b7afb8c7p+276,    0x1.aab0ea96ffbcdp-1,  -0x1.358662p-4, INEXACT)
T(RN,  0x1.58505cd819ae1p+276,    0x1.ff9551c2f4d2ap-1,  -0x1.086c66p-2, INEXACT)
T(RN,  0x1.025bd6526d8a7p+277,    0x1.57ace71a19911p-3,  -0x1.274dbap-9, INEXACT)
T(RN,  0x1.e214fdcf570a4p+277,    0x1.e49c5cfa4d585p-2,   0x1.35f262p-2, INEXACT)
T(RN,  0x1.5b484389ce4bap+277,    -0x1.2232248c7a86p-1,  -0x1.86e29ep-3, INEXACT)
T(RN,  0x1.ec28db4966e52p+277,    0x1.42d14d16ab116p-1,   0x1.e4d40ap-2, INEXACT)
T(RN,  0x1.168344a3e9ed1p+277,    0x1.3e7f00143679ap-2,   0x1.115f08p-3, INEXACT)
T(RN,  0x1.44e3b672ea6fep+277,   -0x1.fa85fbf9baafcp-1,   0x1.06bfdep-3, INEXACT)
T(RN,  0x1.8843852a50cb7p+277,   -0x1.8a393df64df1ap-1,   0x1.e6d5fap-2, INEXACT)
T(RN,  0x1.914c992e9b765p+277,   -0x1.6b0aa6856267dp-2,   -0x1.57f5bp-2, INEXACT)
T(RN,  0x1.de507c1184cc4p+277,   -0x1.fda96df8bdb97p-1,   -0x1.136f5p-6, INEXACT)
T(RN,  0x1.f645a9cf0af37p+277,   -0x1.55f7ad6ab9e25p-1,  -0x1.ba5424p-5, INEXACT)
T(RN,  0x1.1cddea1f61619p+278,    0x1.c8ba866b8c53ep-1,  -0x1.f16f8cp-2, INEXACT)
T(RN,  0x1.8054770cae426p+278,   -0x1.7813903aafbbcp-1,   0x1.d830e8p-3, INEXACT)
T(RN,   0x1.9aea9b9248a2p+278,   -0x1.86c6917ffd225p-1,  -0x1.340a4cp-2, INEXACT)
T(RN,  0x1.5eb8048b78222p+278,   -0x1.af3daf18f0ff1p-2,   -0x1.4236dp-3, INEXACT)
T(RN,   0x1.93faead6b2ffp+278,    0x1.74b84829c4accp-3,   0x1.744d68p-3, INEXACT)
T(RN,   0x1.e87bb8191fd3p+278,    0x1.f7681d7dfb196p-1,   0x1.f786a6p-2, INEXACT)
T(RN,  0x1.b004a92ceddd3p+278,    -0x1.e26ebb09389ep-1,  -0x1.4699a2p-2, INEXACT)
T(RN,  0x1.fceb2fcf94adap+278,    0x1.6d3f7e4eff683p-1,    0x1.4be85p-2, INEXACT)
T(RN,  0x1.8cfe448ca8287p+278,   -0x1.72d32d8564c3bp-2,  -0x1.b5ba14p-4, INEXACT)
T(RN,  0x1.1f5b9ac39d423p+278,    0x1.031fccfa12192p-1,  -0x1.243bdcp-2, INEXACT)
T(RN,  0x1.115def9a9a253p+279,    0x1.257c5eadc994ap-3,   0x1.b02c08p-2, INEXACT)
T(RN,  0x1.601e81b35a949p+279,    0x1.005a44ea90156p-2,   0x1.5e6818p-2, INEXACT)
T(RN,  0x1.87a6bf72fe5b4p+279,   -0x1.c8ccfff618255p-1,  -0x1.f28facp-2, INEXACT)
T(RN,   0x1.5b12eab4ef61p+279,   -0x1.d88a549112d27p-1,   0x1.990636p-5, INEXACT)
T(RN,  0x1.3d3be2095ce7dp+279,    0x1.bd6e7a325e165p-1,   0x1.42db74p-2, INEXACT)
T(RN,  0x1.d6c9042485e43p+279,   -0x1.8a60d8d481d9fp-1,  -0x1.ca9e5ep-2, INEXACT)
T(RN,   0x1.91c82da4b4d5p+279,   -0x1.ff38fc217819dp-1,  -0x1.9bc96ap-2, INEXACT)
T(RN,  0x1.9107a4b706b64p+279,   -0x1.eb3da78b775d9p-2,   0x1.af0cecp-2, INEXACT)
T(RN,  0x1.2e83c11c71f3dp+279,   -0x1.a594bea066b7ep-1,   0x1.397586p-2, INEXACT)
T(RN,  0x1.51f0436ddfa8cp+279,    0x1.96ccc4b7950dep-8,   0x1.f666dep-3, INEXACT)
T(RN,  0x1.60d6605e5987dp+280,    0x1.27f0893e48a29p-2,   0x1.bf402cp-3, INEXACT)
T(RN,  0x1.b1322de0a354ap+280,    0x1.8d4ebf4a2dc1ep-2,   0x1.969f38p-3, INEXACT)
T(RN,  0x1.53ba3cd475742p+280,    0x1.360a01ad5fa44p-1,   0x1.3424c6p-3, INEXACT)
T(RN,  0x1.d90ce663f780ep+280,    0x1.fc020b7514c05p-1,   0x1.c4ed44p-2, INEXACT)
T(RN,  0x1.4f0bfc1bca8ffp+280,    0x1.f728182ed5c61p-3,  -0x1.daa8a4p-5, INEXACT)
T(RN,  0x1.7f7a84ae65678p+280,    0x1.fad3165da6a7ap-1,  -0x1.524c9ap-6, INEXACT)
T(RN,  0x1.b3bebe07d5d2ep+280,    0x1.1830d0e63c4c8p-3,   0x1.771648p-3, INEXACT)
T(RN,  0x1.b559743b37429p+280,    0x1.8bcd50785736cp-1,   0x1.ab54fep-3, INEXACT)
T(RN,  0x1.0e2f9ef801d96p+280,   -0x1.41897bfe09dfap-3,  -0x1.79b286p-3, INEXACT)
T(RN,  0x1.8143c7ccfa5ccp+280,    0x1.ec880af1554a7p-1,   0x1.c4e60cp-7, INEXACT)
T(RN,  0x1.fd3612de8a70ap+281,    0x1.48eee8a3b6668p-1,   0x1.b4ddd6p-2, INEXACT)
T(RN,  0x1.c25489165dfecp+281,   -0x1.11ccfb4f619bfp-1,  -0x1.0da278p-2, INEXACT)
T(RN,  0x1.6ba4e50026896p+281,   -0x1.4cb40b1adecc5p-1,   0x1.15eac4p-3, INEXACT)
T(RN,  0x1.4cbc4dacd8096p+281,    0x1.5ca4410373aabp-2,  -0x1.913a3ep-6, INEXACT)
T(RN,  0x1.bb8ac3b2eb28cp+281,   -0x1.eb33eb565872ep-1,  -0x1.cb00bcp-2, INEXACT)
T(RN,  0x1.af56c9dfa7324p+281,    0x1.d21eb72b28bddp-2,   0x1.d452a4p-2, INEXACT)
T(RN,  0x1.63ddd31b73147p+281,    0x1.c2d0a1c08eca3p-1,   0x1.4f985cp-2, INEXACT)
T(RN,  0x1.97ea97e5b227cp+281,    0x1.81aae3988619ap-2,   0x1.e8fa84p-3, INEXACT)
T(RN,  0x1.6022b4c630a61p+281,    -0x1.f63b61ed5621p-1,  -0x1.85c69ep-2, INEXACT)
T(RN,  0x1.9b6713b0653dcp+281,   -0x1.8d4ce6952126bp-3,  -0x1.2a13dcp-2, INEXACT)
T(RN,  0x1.4bd1589d99d44p+282,    0x1.ed98076e30dd3p-1,   0x1.8403f6p-2, INEXACT)
T(RN,  0x1.776a4c073e5b4p+282,    -0x1.c6083592a516p-1,   0x1.e1a2ecp-5, INEXACT)
T(RN,  0x1.3b93414645de1p+282,   -0x1.f99847f4901fep-1,   0x1.ddb99ep-2, INEXACT)
T(RN,  0x1.ec2ea8c03bf34p+282,    0x1.fab7323faf473p-1,   0x1.8fa02ep-3, INEXACT)
T(RN,  0x1.9382b3dace8cdp+282,    -0x1.f7e79fd727d6p-1,   -0x1.0a63dp-9, INEXACT)
T(RN,  0x1.12c906cece2cbp+282,   -0x1.fe65b01527c81p-1,   0x1.1e618ep-7, INEXACT)
T(RN,  0x1.81f32fa9084b6p+282,    0x1.d9a807d50b6a6p-1,  -0x1.f66e9ap-4, INEXACT)
T(RN,  0x1.fafaffe8282dcp+282,    0x1.c46df0720b447p-1,  -0x1.d32656p-4, INEXACT)
T(RN,  0x1.47932ffa071a3p+282,   -0x1.4b9204f36d055p-6,  -0x1.2e8204p-3, INEXACT)
T(RN,  0x1.de4f63fbce5f8p+282,   -0x1.a3d93ac588736p-2,  -0x1.cb91fap-6, INEXACT)
T(RN,  0x1.ae7170536f0c9p+283,    0x1.05b10be973ab9p-1,   0x1.4ce9cep-2, INEXACT)
T(RN,  0x1.8fed4d0bf4e41p+283,    0x1.dc39d826b6b79p-1,   0x1.3b74b8p-4, INEXACT)
T(RN,  0x1.c2de6b45d34a6p+283,    0x1.3cb30a0dc9064p-2,  -0x1.8180fap-4, INEXACT)
T(RN,  0x1.c98e81b3b8264p+283,    0x1.92b1dfec10f5dp-3,  -0x1.aaafccp-5, INEXACT)
T(RN,  0x1.ef608766e80b2p+283,    0x1.df3fa2099f423p-1,   0x1.22e7d8p-2, INEXACT)
T(RN,  0x1.5bc9560a38b6dp+283,   -0x1.4cf5c8ce8cd44p-5,   0x1.24472ep-4, INEXACT)
T(RN,  0x1.078c507092f2ap+283,   -0x1.967b9ebdf4cbap-1,  -0x1.19f83ap-2, INEXACT)
T(RN,  0x1.a2ab5d2fe42c9p+283,    0x1.f53980f35f64fp-1,   0x1.ae8542p-3, INEXACT)
T(RN,  0x1.74f2d9ace46d3p+283,    0x1.32bd8e0465434p-3,  -0x1.85194ep-2, INEXACT)
T(RN,  0x1.4483a27bf2b06p+283,    0x1.378ed0ffb6cfdp-1,  -0x1.fb548cp-3, INEXACT)
T(RN,   0x1.e36c112e53cap+284,   -0x1.861d4f1b50e32p-1,   0x1.676714p-3, INEXACT)
T(RN,  0x1.5add2960a60dfp+284,   -0x1.b09f5b8e9089ap-3,   0x1.5ebf36p-2, INEXACT)
T(RN,  0x1.7377290d1cc46p+284,    0x1.43d0f31f4c11ep-1,   0x1.5eb8cap-3, INEXACT)
T(RN,  0x1.e0ae69de747d1p+284,    0x1.a0edade2cf88cp-1,  -0x1.6ad208p-2, INEXACT)
T(RN,   0x1.61c488c7a5c4p+284,    0x1.235cb22a9fcaap-3,  -0x1.eb81bcp-2, INEXACT)
T(RN,  0x1.c77e3d7492caap+284,   -0x1.e566b68caac55p-1,  -0x1.98ca48p-3, INEXACT)
T(RN,  0x1.6f8412e06b653p+284,    0x1.484304b723636p-1,  -0x1.729aa4p-4, INEXACT)
T(RN,  0x1.891d50924f398p+284,   -0x1.70028ddf0359fp-2,   -0x1.e21c2p-4, INEXACT)
T(RN,  0x1.6e7a8328e29f9p+284,    0x1.2e9e6ce3e1f95p-1,   0x1.a0be0ep-4, INEXACT)
T(RN,   0x1.6b676564d3c4p+284,    0x1.ce2c85b67cadbp-1,   0x1.f91286p-2, INEXACT)
T(RN,  0x1.8683f5c0c5d44p+285,   -0x1.1a6fa8ccbaa0fp-1,  -0x1.a2c352p-4, INEXACT)
T(RN,  0x1.c4e0ec2d8a93cp+285,    0x1.fff4c62e8f045p-1,   0x1.52ff74p-4, INEXACT)
T(RN,  0x1.c1b5a572d1c7dp+285,   -0x1.fff17d6905857p-1,   0x1.dd4fc6p-2, INEXACT)
T(RN,  0x1.aa657c2804ddbp+285,   -0x1.efb7fbfa0acedp-1,   0x1.2933f4p-4, INEXACT)
T(RN,  0x1.d7771b7757642p+285,   -0x1.65ba60c4e20a3p-2,   -0x1.f26ecp-4, INEXACT)
T(RN,  0x1.393eb8cfd051ep+285,    0x1.caaf2241ea74ap-1,   0x1.79c688p-2, INEXACT)
T(RN,  0x1.e9ad8a0085eacp+285,    0x1.55db7a55ca673p-4,   -0x1.7754dp-2, INEXACT)
T(RN,  0x1.21476d5c0e05ap+285,    0x1.5de8c9778cf07p-2,    0x1.1c276p-2, INEXACT)
T(RN,  0x1.3833dd22d7b56p+285,   -0x1.79f57f0046568p-1,  -0x1.97bfdep-5, INEXACT)
T(RN,  0x1.76d5c05187cacp+285,    0x1.5b87aa0ad829fp-1,   0x1.f68742p-2, INEXACT)
T(RN,  0x1.2188479fb562bp+286,    0x1.a5495ae187ff1p-2,   -0x1.39f21p-2, INEXACT)
T(RN,  0x1.daa116589f1edp+286,    0x1.0078b04c0c3c3p-1,    0x1.c72a4p-3, INEXACT)
T(RN,  0x1.fb68f6f32991cp+286,   -0x1.fcc69e67c590bp-1,   0x1.7effeep-2, INEXACT)
T(RN,  0x1.7c438c4701f43p+286,   -0x1.4692de5363c1dp-1,  -0x1.58dc96p-3, INEXACT)
T(RN,  0x1.9c8f25f9471f9p+286,     0x1.0003146c2e1ap-2,   0x1.65872cp-6, INEXACT)
T(RN,  0x1.3cef2d06d8262p+286,   -0x1.a96f30f6ead74p-4,  -0x1.657d9cp-2, INEXACT)
T(RN,  0x1.29f3f269d9f95p+286,   -0x1.ac8ef88d510dcp-4,  -0x1.4a33c8p-3, INEXACT)
T(RN,  0x1.c77c68ad238d9p+286,    0x1.3c0a0ef041957p-4,  -0x1.aeb6f4p-4, INEXACT)
T(RN,  0x1.f74066ef0c025p+286,    0x1.bc6550745f2e5p-1,  -0x1.1a16cap-3, INEXACT)
T(RN,   0x1.6d431098b048p+286,   -0x1.fa6c55de9e10dp-1,    0x1.50b99p-2, INEXACT)
T(RN,  0x1.88a2bca2f4dc2p+287,    0x1.fc1290b6aa57dp-1,  -0x1.ad050cp-4, INEXACT)
T(RN,  0x1.fd8ce8e94d61cp+287,   -0x1.144ee69e8566ep-3,   0x1.522d34p-2, INEXACT)
T(RN,  0x1.08552960e5d1ap+287,    0x1.46628a17811f1p-4,  -0x1.965c5ep-2, INEXACT)
T(RN,  0x1.270dce24b1664p+287,    0x1.44619987995a6p-5,   0x1.abfb9ep-4, INEXACT)
T(RN,  0x1.6bcfb27971636p+287,    -0x1.8f7f79c0f70ap-2,  -0x1.b28e5cp-2, INEXACT)
T(RN,  0x1.474fa864706dap+287,    0x1.7217429432019p-1,   0x1.3306ecp-3, INEXACT)
T(RN,  0x1.8c1611f66bb34p+287,    -0x1.2c135acfd776p-1,   0x1.db99b8p-3, INEXACT)
T(RN,  0x1.9068b979cfdabp+287,    0x1.fdfea11cf3084p-1,   0x1.4647bap-4, INEXACT)
T(RN,  0x1.6b515eb232d3ep+287,    0x1.af1b976f37bb8p-1,  -0x1.1cbed2p-2, INEXACT)
T(RN,  0x1.e02edcc4f4c68p+287,   -0x1.f617370dfe6fap-1,    0x1.e5318p-4, INEXACT)
T(RN,  0x1.aa4975f4c0d7bp+288,   -0x1.9dfe2a28ea9b5p-2,   0x1.c90ad8p-2, INEXACT)
T(RN,  0x1.a74d718f46243p+288,   -0x1.730075d980a49p-1,   0x1.c45bcep-3, INEXACT)
T(RN,  0x1.af2ff1d3e6be4p+288,    0x1.e5b1c453801ffp-1,   0x1.5af8d6p-2, INEXACT)
T(RN,  0x1.6d3b9d965982dp+288,   -0x1.f83b1e64c61b6p-1,  -0x1.49d59cp-4, INEXACT)
T(RN,  0x1.9f7ca8e1ab419p+288,   -0x1.cdce023ed9472p-1,    0x1.417adp-7, INEXACT)
T(RN,  0x1.7c8887085015dp+288,    0x1.d5044f447db8fp-1,  -0x1.e33088p-2, INEXACT)
T(RN,  0x1.4e03edb15a8d3p+288,    0x1.fcc1028c31a83p-1,   0x1.c3a8a2p-2, INEXACT)
T(RN,  0x1.c49486158f878p+288,    0x1.76234a1f16603p-2,   0x1.06cf4ep-2, INEXACT)
T(RN,  0x1.291d9baf0bec4p+288,    0x1.8ed43e77ce888p-1,  -0x1.fc08ecp-2, INEXACT)
T(RN,  0x1.cd3acf8f5b17dp+288,    0x1.bf87b780d0c06p-1,   -0x1.d9f6ap-3, INEXACT)
T(RN,  0x1.1f297afa8c6aep+289,    0x1.cbdb5f5bf9a18p-1,  -0x1.5d3a56p-2, INEXACT)
T(RN,  0x1.36072c60eb5b3p+289,    -0x1.f311c462160fp-1,  -0x1.8ca364p-3, INEXACT)
T(RN,  0x1.ac87792a22c82p+289,    0x1.f97c67eae0dbbp-1,  -0x1.382a6ep-2, INEXACT)
T(RN,  0x1.e304bd48c7a23p+289,    0x1.6eac53606f12fp-2,   -0x1.86aa2p-4, INEXACT)
T(RN,  0x1.d9f8f7e0bb5c4p+289,   -0x1.fbc353febb4bdp-3,  -0x1.7d0176p-3, INEXACT)
T(RN,  0x1.dc1dce28daf48p+289,   -0x1.8e9840384d084p-4,   0x1.0c5406p-2, INEXACT)
T(RN,  0x1.a2bd2dabd24f3p+289,    0x1.ff42971500644p-1,  -0x1.94b3b4p-2, INEXACT)
T(RN,   0x1.06b976fa94c7p+289,   -0x1.d590a16a8b759p-2,    0x1.6fb8ep-2, INEXACT)
T(RN,   0x1.8d8a2f5746a2p+289,     0x1.afc13cea0799p-1,   0x1.114094p-2, INEXACT)
T(RN,  0x1.02d374bd03714p+289,   -0x1.fffb421595fa5p-1,   0x1.42b23ep-2, INEXACT)
T(RN,  0x1.90b27df75800ep+290,    0x1.52ea8b590d775p-2,  -0x1.59ff14p-2, INEXACT)
T(RN,  0x1.5729c588979dfp+290,    -0x1.fe472a9c1bdbp-1,   0x1.c2dd92p-4, INEXACT)
T(RN,  0x1.726e8beaef971p+290,    0x1.836b164756891p-1,  -0x1.fb6506p-2, INEXACT)
T(RN,  0x1.0139e4fab730ep+290,    0x1.7a4b9a1d57badp-4,   0x1.b74706p-4, INEXACT)
T(RN,  0x1.836a57f9b7259p+290,    0x1.fb07d17c5db38p-1,    0x1.8f57dp-2, INEXACT)
T(RN,  0x1.3533fd06b1d0fp+290,   -0x1.1d01abe2f16aep-2,   0x1.788d8ap-2, INEXACT)
T(RN,  0x1.815f505bc1738p+290,    0x1.fb27201a51aafp-1,   0x1.38c3eap-2, INEXACT)
T(RN,  0x1.0d323d59ae59cp+290,   -0x1.dacd6eb4c1d44p-3,  -0x1.d72ea4p-3, INEXACT)
T(RN,  0x1.83560563f450cp+290,    0x1.f5ba26d5eafd3p-1,    0x1.c51d3p-2, INEXACT)
T(RN,  0x1.feb6b744b3fa7p+290,    0x1.a3ec347fd3f27p-1,  -0x1.f94786p-6, INEXACT)
T(RN,  0x1.6b55619126402p+291,    0x1.7c2cfba7115a5p-1,   0x1.bbe8f8p-4, INEXACT)
T(RN,  0x1.e792929d8b47cp+291,   -0x1.c1d75781b73eap-1,   0x1.7e0d82p-8, INEXACT)
T(RN,  0x1.e2c718e911c96p+291,   -0x1.f3a92075c9c28p-1,  -0x1.f7db5ep-4, INEXACT)
T(RN,  0x1.0a5e0149697d3p+291,    0x1.e035252ae53bfp-2,   0x1.66b11ep-2, INEXACT)
T(RN,  0x1.bf7a21e75fe86p+291,   -0x1.3be017a2974f9p-3,   0x1.db5a3ep-3, INEXACT)
T(RN,  0x1.12c4d8d7bebbdp+291,    0x1.78c903eda1523p-1,  -0x1.e0d1b8p-2, INEXACT)
T(RN,  0x1.6f823df8fd8f8p+291,   -0x1.4dc286dc0fd39p-1,   0x1.458abep-2, INEXACT)
T(RN,  0x1.10dcaab665a4ep+291,   -0x1.8e9076266cfddp-1,   0x1.970ea4p-2, INEXACT)
T(RN,   0x1.37da11bd4e76p+291,    0x1.33b69aa0531c7p-2,    0x1.06103p-2, INEXACT)
T(RN,  0x1.6e9b0575c891ap+291,    -0x1.5e1ae2fb7d21p-1,  -0x1.cadf08p-2, INEXACT)
T(RN,  0x1.c20bc0bbc6272p+292,    0x1.e91f5185fa2f2p-3,   0x1.39024cp-3, INEXACT)
T(RN,   0x1.c075d7f87527p+292,    0x1.e848df0fd8da6p-1,  -0x1.b513d2p-5, INEXACT)
T(RN,  0x1.a3019ab5580bap+292,    0x1.0920791adeb2cp-2,  -0x1.0f53fap-2, INEXACT)
T(RN,   0x1.93cae753ee71p+292,   -0x1.8c6263b9bb0eep-1,  -0x1.0abdecp-2, INEXACT)
T(RN,  0x1.97be7ab321bf8p+292,    0x1.4a3f302586035p-1,   -0x1.fca5cp-2, INEXACT)
T(RN,  0x1.0f764d891c0c7p+292,    0x1.9ff61be3a58ddp-1,   0x1.df7b5ap-2, INEXACT)
T(RN,  0x1.4c61ba6a136c5p+292,    0x1.edafe1fb3924fp-1,   0x1.9a0704p-2, INEXACT)
T(RN,  0x1.800e7b72a4b84p+292,   -0x1.0f2907e689cabp-2,  -0x1.80262cp-4, INEXACT)
T(RN,  0x1.a7973ee26b12ap+292,    0x1.535040d7c0257p-2,   0x1.abfbc6p-6, INEXACT)
T(RN,  0x1.9d4c58d26d3e6p+292,    0x1.bc3d5b316b0a9p-1,   0x1.93f9c8p-2, INEXACT)
T(RN,  0x1.c45f781b67f04p+293,   -0x1.f2bfcc9f205f4p-1,  -0x1.c680a6p-2, INEXACT)
T(RN,  0x1.8d57c50f7a6e2p+293,    0x1.435b15e52fd06p-1,   0x1.30218ep-2, INEXACT)
T(RN,  0x1.1461eb449e3f6p+293,   -0x1.ea849b6f5419fp-1,  -0x1.87ebf2p-5, INEXACT)
T(RN,  0x1.634d2b3a0c8f4p+293,   -0x1.ceda4837ac66dp-1,   0x1.8fe672p-2, INEXACT)
T(RN,  0x1.7d4d60ab87716p+293,    0x1.3cdf42a4011a4p-1,   0x1.be19f2p-7, INEXACT)
T(RN,  0x1.cbe1ca2a378cdp+293,    0x1.dca1b5ee5a7b1p-3,   0x1.569982p-5, INEXACT)
T(RN,  0x1.9fd0e8ad7bbf1p+293,   -0x1.875e42b9acd79p-1,  -0x1.1c3806p-2, INEXACT)
T(RN,  0x1.18a7ee1a00e3dp+293,    0x1.fd03499dcea9cp-3,   0x1.01d816p-2, INEXACT)
T(RN,  0x1.000484c140b8ep+293,    0x1.2f3bddd789b88p-3,   0x1.10718ap-5, INEXACT)
T(RN,  0x1.28b2e6197a20ap+293,   -0x1.fe91d069eb5c8p-1,  -0x1.5583b4p-2, INEXACT)
T(RN,  0x1.6e5432cd2e4a2p+294,    0x1.1229793877157p-1,  -0x1.ce00f4p-2, INEXACT)
T(RN,  0x1.979166cb64108p+294,    0x1.bbed49c05eed2p-3,   0x1.e6c7e6p-2, INEXACT)
T(RN,  0x1.7f79bb033e4d8p+294,    0x1.7123ef0bfca54p-5,   -0x1.bc4fbp-2, INEXACT)
T(RN,  0x1.8006ba73b9cd3p+294,    0x1.7fe31b3bc6134p-5,   0x1.d7e024p-3, INEXACT)
T(RN,  0x1.aa7129bedd668p+294,   -0x1.a7955c93de924p-3,   0x1.5b8da6p-3, INEXACT)
T(RN,  0x1.d64a55a5422cep+294,    0x1.28ca6bc6fb8aap-3,   0x1.b62776p-2, INEXACT)
T(RN,  0x1.136eb5441210fp+294,    0x1.446e022bd5be8p-5,  -0x1.5918acp-4, INEXACT)
T(RN,  0x1.01369c259a68ap+294,   -0x1.f6e766daaa5afp-1,   0x1.cfaa2ep-2, INEXACT)
T(RN,  0x1.abbc7e0bc5f1ep+294,   -0x1.fed39d8f3ad19p-1,    0x1.c6053p-3, INEXACT)
T(RN,  0x1.d2904fc3b20bcp+294,   -0x1.e68dea8a3e5f2p-1,  -0x1.704688p-2, INEXACT)
T(RN,  0x1.5ed784cdb017cp+295,    0x1.f2b76f74f4971p-3,   0x1.f95532p-4, INEXACT)
T(RN,  0x1.a8723b090afa6p+295,   -0x1.ffba2caaab62ap-1,  -0x1.4e1374p-2, INEXACT)
T(RN,  0x1.c8a17627eca6ap+295,   -0x1.0ced93e86851cp-2,   -0x1.71a84p-2, INEXACT)
T(RN,  0x1.222dc49b24ee5p+295,    0x1.51e17ce145292p-1,  -0x1.922ef8p-3, INEXACT)
T(RN,  0x1.4d344d71289d6p+295,    0x1.8ad553f1dd69dp-4,   0x1.6cf3a4p-3, INEXACT)
T(RN,  0x1.831f8dc9aa113p+295,    0x1.c0ce104e0db66p-3,  -0x1.0e4e02p-4, INEXACT)
T(RN,  0x1.063e8afb176e3p+295,    0x1.cfdcb260ab024p-1,  -0x1.40b87ep-3, INEXACT)
T(RN,  0x1.06124448591bfp+295,    0x1.d8ccdcca2ede9p-1,  -0x1.d301d6p-3, INEXACT)
T(RN,  0x1.aab6042b96a0ap+295,   -0x1.ede425ef421fap-1,   0x1.9a1736p-3, INEXACT)
T(RN,  0x1.7f748c61716fap+295,   -0x1.1b9583ee548abp-1,  -0x1.2e7a6ep-2, INEXACT)
T(RN,  0x1.2bc2ff496da82p+296,   -0x1.86ca18af48688p-1,  -0x1.957108p-2, INEXACT)
T(RN,   0x1.8d0ad049c1c7p+296,    0x1.f245d214b4cdfp-4,   0x1.e15796p-4, INEXACT)
T(RN,  0x1.5727766c863fap+296,    0x1.049e4fa27839fp-2,   0x1.e15a38p-2, INEXACT)
T(RN,  0x1.dacb95995874bp+296,   -0x1.ecbb9108b5707p-1,  -0x1.a6ece6p-3, INEXACT)
T(RN,  0x1.e1ecedd145febp+296,    0x1.1fdb8f4ec726ep-3,  -0x1.8e5124p-2, INEXACT)
T(RN,  0x1.14a6087ba4737p+296,    0x1.52d2596d4f16cp-2,  -0x1.25721ep-3, INEXACT)
T(RN,  0x1.dbe616e096f68p+296,   -0x1.a58226fb32eb5p-1,  -0x1.c27dd2p-3, INEXACT)
T(RN,   0x1.583e0fe1a18ap+296,   -0x1.542ed2b5b2449p-1,    0x1.c2431p-3, INEXACT)
T(RN,  0x1.50a8e80a5a633p+296,    0x1.db0f17014757bp-1,  -0x1.f927b2p-4, INEXACT)
T(RN,  0x1.6966434db88c8p+296,    0x1.cf2988343614fp-1,   -0x1.e2412p-2, INEXACT)
T(RN,  0x1.e854a3b804f69p+297,   -0x1.bda32f03053d9p-1,  -0x1.5458fep-3, INEXACT)
T(RN,  0x1.a9e96c0558747p+297,    0x1.3acabe3968dc3p-2,  -0x1.b5e7ecp-4, INEXACT)
T(RN,  0x1.0513ae818a78bp+297,    0x1.f3a8c8aacc62dp-1,   0x1.720dd8p-2, INEXACT)
T(RN,  0x1.5dc0f41632a32p+297,    -0x1.955a3492b018p-3,  -0x1.08a162p-5, INEXACT)
T(RN,   0x1.34ddfbf696f3p+297,     0x1.3b809df8e7cdp-1,  -0x1.6ea036p-2, INEXACT)
T(RN,  0x1.72087edb0cd25p+297,    0x1.ffd884c9feffap-1,   0x1.260042p-2, INEXACT)
T(RN,  0x1.d42728de77d1ap+297,   -0x1.0a62cf03b2e52p-1,  -0x1.819cc4p-2, INEXACT)
T(RN,  0x1.b9eebfc42dcc1p+297,   -0x1.1cfd6d542a252p-2,  -0x1.601cfap-2, INEXACT)
T(RN,  0x1.00f5922c0adf6p+297,    0x1.fea2caedd30d5p-1,   0x1.66303ap-2, INEXACT)
T(RN,  0x1.fd07ba9f07629p+297,   -0x1.f0066ca6668c9p-1,  -0x1.8f8a5ap-2, INEXACT)
T(RN,  0x1.df2a1831963b1p+298,    0x1.19788e7037679p-1,   0x1.e9426ap-3, INEXACT)
T(RN,  0x1.c75378b0e6203p+298,    0x1.f326007d723f8p-1,   0x1.80dce4p-3, INEXACT)
T(RN,  0x1.772c83cd1b2b8p+298,    0x1.832eda46ab6cap-1,   0x1.897864p-3, INEXACT)
T(RN,  0x1.62bb36d53c6dbp+298,    0x1.b44a2302e8c7ep-3,  -0x1.55a43ep-3, INEXACT)
T(RN,  0x1.0d69e1e6c4b57p+298,   -0x1.b4f633a8b403ap-1,   0x1.618e42p-5, INEXACT)
T(RN,  0x1.c907647d28882p+298,    0x1.a30b292f59c66p-7,  -0x1.8c259ap-3, INEXACT)
T(RN,  0x1.4753d5fb84147p+298,    0x1.9829c470972d7p-2,  -0x1.ca8ea8p-2, INEXACT)
T(RN,  0x1.9e6e661ae9cc8p+298,    0x1.677391d34b535p-1,  -0x1.36707ep-3, INEXACT)
T(RN,  0x1.2a3fb4ef02153p+298,    0x1.0440f05519a7ep-4,   0x1.4b020cp-2, INEXACT)
T(RN,  0x1.362cb0b3932b6p+298,    0x1.a33a78264442fp-1,   0x1.ed6c94p-7, INEXACT)
T(RN,  0x1.4c0a11ae8eb3ep+299,   -0x1.b28cf47f3b1b8p-2,   0x1.bce62cp-2, INEXACT)
T(RN,  0x1.0410c33f68325p+299,     0x1.a6ccc79c78dbp-1,  -0x1.06075ep-5, INEXACT)
T(RN,  0x1.f42d5b1e338eep+299,    0x1.cac015cdccc14p-1,  -0x1.c980a4p-3, INEXACT)
T(RN,  0x1.8cfa176d8f3e2p+299,    0x1.4255e7f30081fp-3,   0x1.61eaecp-4, INEXACT)
T(RN,   0x1.0d220b8d8ef4p+299,   -0x1.82ae58b4fbac2p-1,  -0x1.2668eep-3, INEXACT)
T(RN,  0x1.5bf3cadd6729cp+299,   -0x1.611f896e17417p-2,   0x1.728ec6p-5, INEXACT)
T(RN,  0x1.eb586efc289cfp+299,    0x1.ffd90a06bae0ep-1,    0x1.1ffcep-3, INEXACT)
T(RN,  0x1.a0aea5193623cp+299,   -0x1.5fe24f4e3dc22p-2,  -0x1.bf12b2p-2, INEXACT)
T(RN,  0x1.f89a043d85772p+299,    0x1.0ea7b9627d903p-2,   0x1.05e4b2p-3, INEXACT)
T(RN,  0x1.1390faed2ae0dp+299,   -0x1.ca6d93d6e7cefp-2,   0x1.1b4246p-2, INEXACT)
T(RN,  0x1.cb9bd18c0c7fep+300,    0x1.98928990366e2p-1,  -0x1.10f572p-3, INEXACT)
T(RN,  0x1.ad4171c98812ap+300,   -0x1.fe5c4946eeee9p-1,  -0x1.2e7708p-2, INEXACT)
T(RN,  0x1.969162baa7244p+300,   -0x1.fd1bebe0eb6d7p-6,  -0x1.dc4576p-5, INEXACT)
T(RN,  0x1.d489b8998b688p+300,   -0x1.79ccef4fb5923p-1,  -0x1.867624p-4, INEXACT)
T(RN,  0x1.01dcf659557a7p+300,   -0x1.f0316e0ca0665p-1,   0x1.172274p-2, INEXACT)
T(RN,  0x1.570b500aaba78p+300,   -0x1.0ff37d9e2b08dp-1,  -0x1.ab71cep-3, INEXACT)
T(RN,  0x1.a2611911f55f8p+300,   -0x1.bda461cfb1298p-4,   0x1.8dc5d8p-2, INEXACT)
T(RN,  0x1.685f7723256bap+300,    0x1.b20771dbef5d5p-4,    0x1.aa5b7p-2, INEXACT)
T(RN,  0x1.801e4e76ec944p+300,    0x1.c48ff1070967dp-1,  -0x1.e758bcp-3, INEXACT)
T(RN,  0x1.b6aae751638cap+300,   -0x1.a7bf5c3ba0548p-4,  -0x1.352434p-2, INEXACT)
T(RN,   0x1.9c50032e5825p+301,   -0x1.888c45b7fd142p-1,   0x1.507222p-4, INEXACT)
T(RN,  0x1.0b364a625a796p+301,   -0x1.f9c6317dd4b12p-1,   0x1.195264p-3, INEXACT)
T(RN,  0x1.3995f7e5f7875p+301,   -0x1.9f6a4ea34d589p-1,   0x1.dab98ep-3, INEXACT)
T(RN,  0x1.4a9e952ecc4c5p+301,    0x1.138309078bb48p-1,   0x1.630a06p-3, INEXACT)
T(RN,  0x1.c83697402aec7p+301,    0x1.27593be65fccep-6,  -0x1.fd52c6p-2, INEXACT)
T(RN,  0x1.b8a31a76d2f78p+301,   -0x1.5544dd6ad8aa3p-3,  -0x1.9f5236p-4, INEXACT)
T(RN,  0x1.efde6925274f4p+301,   -0x1.ccb181928284cp-1,  -0x1.b721bcp-2, INEXACT)
T(RN,   0x1.a5a03a5fb4d1p+301,   -0x1.c5da780054795p-2,  -0x1.ef3abep-5, INEXACT)
T(RN,  0x1.975ab005df40cp+301,    0x1.20a007a32995fp-1,  -0x1.56dc5cp-2, INEXACT)
T(RN,  0x1.76c3250e7f032p+301,   -0x1.f7b6f34a57ef5p-1,    0x1.7c287p-3, INEXACT)
T(RN,  0x1.5bc0d4abbe4d1p+302,    0x1.399c3d9ee3f3cp-1,  -0x1.610a62p-2, INEXACT)
T(RN,  0x1.d9053eededcf7p+302,   -0x1.fe8a60ff578b7p-1,  -0x1.8d935ap-4, INEXACT)
T(RN,  0x1.58725072cc0c8p+302,   -0x1.ff4ba8db142bep-1,   0x1.fa0fe8p-4, INEXACT)
T(RN,  0x1.b7b5dc513fc11p+302,   -0x1.5207d41883775p-3,   0x1.c12872p-2, INEXACT)
T(RN,  0x1.15b19852b5ac2p+302,    0x1.fff6e4040fbb8p-1,  -0x1.0c31e4p-2, INEXACT)
T(RN,  0x1.7cfd52de99209p+302,    0x1.d9f99f34ed0cfp-6,   0x1.f79704p-2, INEXACT)
T(RN,  0x1.43472cfe08a7ep+302,    0x1.d3567aa8daeb8p-1,   0x1.711794p-3, INEXACT)
T(RN,  0x1.b798e91c617fep+302,   -0x1.60af36b94e8fap-1,   0x1.f11334p-2, INEXACT)
T(RN,  0x1.a8b4af9cb234bp+302,   -0x1.6430c4f5c61aap-4,  -0x1.3ac902p-2, INEXACT)
T(RN,  0x1.d453e41e192fep+302,    0x1.ea40d75de881bp-1,   0x1.f6b8c2p-2, INEXACT)
T(RN,  0x1.332ecd6f1a924p+303,    0x1.a80e5eac1b044p-3,  -0x1.a5a344p-3, INEXACT)
T(RN,  0x1.d912556af1292p+303,   -0x1.b056b3c98421bp-1,   0x1.08acdep-6, INEXACT)
T(RN,  0x1.b3d369a5b0c24p+303,   -0x1.feaec91c92e4bp-1,  -0x1.7b6262p-3, INEXACT)
T(RN,  0x1.02abdc63b2b47p+303,   -0x1.aa9d8e0cbe5c8p-3,   0x1.810866p-5, INEXACT)
T(RN,  0x1.68bf2436a0b08p+303,    0x1.fe134d895425ep-1,   -0x1.78204p-3, INEXACT)
T(RN,  0x1.0a92e17193ad9p+303,   -0x1.fa97724af24edp-1,  -0x1.f3990ep-3, INEXACT)
T(RN,  0x1.4f7fc33383f8ap+303,    0x1.9ecc517d51f58p-1,  -0x1.a278a6p-2, INEXACT)
T(RN,  0x1.31df493338b15p+303,   -0x1.996f30bd6407cp-1,  -0x1.0a9e68p-2, INEXACT)
T(RN,  0x1.c9da2e7fd4391p+303,   -0x1.cd72a38825efbp-2,  -0x1.3a93d4p-3, INEXACT)
T(RN,  0x1.587ea7a8339f7p+303,   -0x1.b63c9cd70f5a4p-1,  -0x1.a6435ap-2, INEXACT)
T(RN,  0x1.e208ff400bde7p+304,   -0x1.f0b0556c9930bp-2,   0x1.06599ap-2, INEXACT)
T(RN,  0x1.47b1222db58e6p+304,    0x1.b3d616abfad85p-1,  -0x1.0b025ep-4, INEXACT)
T(RN,  0x1.8cb157c895962p+304,    0x1.a2a849eed447ap-3,  -0x1.7a23fcp-2, INEXACT)
T(RN,  0x1.642eca2a25bc2p+304,   -0x1.ee89ca40d1952p-1,   0x1.779a46p-3, INEXACT)
T(RN,  0x1.5c624c6c54eaap+304,    0x1.9dc3ce5d7e8f9p-1,  -0x1.3748e6p-3, INEXACT)
T(RN,  0x1.4399e0f536a38p+304,    0x1.45b3153ee27dfp-1,  -0x1.677648p-2, INEXACT)
T(RN,  0x1.ee29e09bc5348p+304,    0x1.2ab9ef48d4b28p-1,  -0x1.01a038p-5, INEXACT)
T(RN,  0x1.ad46a3c52f4e2p+304,    0x1.0aaf828c72935p-2,  -0x1.28bec2p-2, INEXACT)
T(RN,   0x1.ebb11df42c36p+304,   -0x1.04b6bcfecd99ep-1,   0x1.631058p-3, INEXACT)
T(RN,  0x1.5ff8059391c5ep+304,   -0x1.44c744baae6ddp-1,  -0x1.0eeea2p-2, INEXACT)
T(RN,  0x1.a8976abd691f3p+305,    0x1.4f73192031178p-3,  -0x1.eff26cp-3, INEXACT)
T(RN,  0x1.5270aab5cd05ap+305,    0x1.31abdc0020c43p-1,    0x1.cf50cp-6, INEXACT)
T(RN,  0x1.50459152019b4p+305,   -0x1.487d654650b99p-1,   0x1.0c09b6p-2, INEXACT)
T(RN,  0x1.ee6feeeefc776p+305,    0x1.2eec7a25bfa1cp-1,  -0x1.9a0d38p-5, INEXACT)
T(RN,  0x1.a5673bddcbd2bp+305,    0x1.fa91b09336a96p-1,  -0x1.812676p-2, INEXACT)
T(RN,  0x1.f8e53e22abfb6p+305,   -0x1.140d2d47da201p-1,  -0x1.b8cb58p-3, INEXACT)
T(RN,  0x1.5f2c4791c1b04p+305,   -0x1.fff263499897cp-1,   0x1.00e91cp-5, INEXACT)
T(RN,  0x1.66281a951153dp+305,    0x1.fb06baa99532dp-1,   0x1.8a9712p-2, INEXACT)
T(RN,  0x1.f9196f3e8419cp+305,    0x1.26ed933a16a67p-2,  -0x1.3c5abep-3, INEXACT)
T(RN,  0x1.c2425c647b75dp+305,    0x1.ff97437586f58p-1,   0x1.f3a868p-4, INEXACT)
T(RN,  0x1.c2386d720ac74p+306,    0x1.0edb8568fd796p-1,  -0x1.8c4d0ap-4, INEXACT)
T(RN,  0x1.35fb897b9ab9cp+306,   -0x1.7deae47f5171ep-1,   0x1.5d47dep-2, INEXACT)
T(RN,  0x1.b0724c4d9db0bp+306,   -0x1.fddb9e5345ca4p-1,  -0x1.09d3dep-2, INEXACT)
T(RN,  0x1.1c218a24fb059p+306,    0x1.3a47daf65b8e8p-2,   0x1.09dee2p-3, INEXACT)
T(RN,  0x1.2ef849f7ab3dcp+306,    0x1.fd9ae948852bep-1,   0x1.56d724p-3, INEXACT)
T(RN,  0x1.360611f34f3fdp+306,   -0x1.0aeede00441a6p-7,   0x1.eac806p-3, INEXACT)
T(RN,  0x1.6419670657e96p+306,    0x1.9aacb1005a89bp-2,  -0x1.d1679cp-3, INEXACT)
T(RN,  0x1.dfff2936ae431p+306,    0x1.0e988121b74bbp-2,   0x1.2883e4p-3, INEXACT)
T(RN,  0x1.6e0d750da92b3p+306,   -0x1.34dd7ae98712dp-4,  -0x1.050b1ep-2, INEXACT)
T(RN,  0x1.7273df471ff8ap+306,    0x1.457a62dab32fcp-4,   0x1.5cade6p-2, INEXACT)
T(RN,   0x1.5ee8e9005e5ep+307,    0x1.fa575d5f3540cp-1,  -0x1.7a9df8p-4, INEXACT)
T(RN,  0x1.1e739b572232cp+307,   -0x1.f41e26699dcd5p-1,  -0x1.771f1ep-3, INEXACT)
T(RN,  0x1.8f8a08a8ce37ep+307,   -0x1.f4a31c4f9021cp-1,   0x1.059b18p-2, INEXACT)
T(RN,  0x1.4ca6e8cd1db04p+307,   -0x1.1c6bb462d0f2dp-1,    0x1.8d24ap-3, INEXACT)
T(RN,  0x1.3ec10271296b4p+307,    0x1.b0cf108ea03f8p-1,   0x1.08c05ap-2, INEXACT)
T(RN,    0x1.a63e66ab4c2p+307,   -0x1.f034b84fd36c4p-1,  -0x1.619b3ep-6, INEXACT)
T(RN,  0x1.2995294e5e6f4p+307,    0x1.db59225230e74p-4,   0x1.edfdacp-2, INEXACT)
T(RN,   0x1.7789bf020b73p+307,    0x1.ecf67b5254285p-1,  -0x1.00ed0ep-6, INEXACT)
T(RN,  0x1.4ca2c5bf93b1ep+307,    0x1.7d5ea0207a3cfp-5,   0x1.fd586ap-4, INEXACT)
T(RN,  0x1.2f1c79f94114dp+307,    0x1.7704bfbb7fd2cp-1,   0x1.94a818p-2, INEXACT)
T(RN,  0x1.7e36d96b74d52p+308,   -0x1.d4cc383e16a96p-1,   -0x1.7ae13p-3, INEXACT)
T(RN,  0x1.ae7a0692fef8dp+308,    0x1.33313886b2f53p-3,   0x1.1c551ap-6, INEXACT)
T(RN,  0x1.c3c3e94072494p+308,    0x1.fdc1b7627f64dp-1,  -0x1.ec55b4p-4, INEXACT)
T(RN,  0x1.a6d6d3e56cb36p+308,   -0x1.4830079f663dap-1,   0x1.fe9f4cp-2, INEXACT)
T(RN,  0x1.427619da1c1a9p+308,    0x1.f5e565f276c31p-1,  -0x1.31cff2p-3, INEXACT)
T(RN,   0x1.17062bdfc41cp+308,    0x1.4859af9f42977p-1,  -0x1.03166cp-3, INEXACT)
T(RN,  0x1.d8714ea765985p+308,    0x1.ffcb1826ffd65p-1,   0x1.ed4404p-2, INEXACT)
T(RN,  0x1.6643f718298adp+308,   -0x1.fc699049ea583p-1,   0x1.ae64d2p-2, INEXACT)
T(RN,  0x1.1e9d66b3bfda6p+308,   -0x1.e08732195347cp-1,   -0x1.8a6d1p-3, INEXACT)
T(RN,  0x1.47ebbab1a1d5bp+308,    0x1.854abadddd492p-1,   0x1.97be46p-2, INEXACT)
T(RN,  0x1.944cc3d17c5d6p+309,   -0x1.a7c8978a2165dp-5,  -0x1.1d6bb2p-2, INEXACT)
T(RN,  0x1.e6e3bf66f7ee4p+309,    0x1.6c21d1e80fc73p-1,   0x1.13951ep-7, INEXACT)
T(RN,  0x1.0b2c628b99f65p+309,    0x1.407bcb2cca7fep-1,  -0x1.f19fe8p-2, INEXACT)
T(RN,  0x1.af2084212cfeep+309,    0x1.f9c756768cdcap-1,   0x1.faa63ap-2, INEXACT)
T(RN,  0x1.7823c2705a085p+309,     0x1.38ada2857cd6p-3,  -0x1.73354ep-2, INEXACT)
T(RN,  0x1.cdaff203d758ap+309,   -0x1.a1cfc9930c987p-1,    0x1.7d232p-2, INEXACT)
T(RN,  0x1.2aa3667b5eca7p+309,   -0x1.e69df4007d32ep-3,   0x1.743636p-3, INEXACT)
T(RN,  0x1.c862dfc6d4b7ap+309,    0x1.a8b1c945cea6ap-1,   0x1.ba670cp-2, INEXACT)
T(RN,  0x1.14775a9be30b2p+309,   -0x1.ba283df0af95ap-1,  -0x1.7f4a1ap-3, INEXACT)
T(RN,  0x1.e2c61a9e39b13p+309,   -0x1.8c0e3642405ebp-3,  -0x1.367a9cp-5, INEXACT)
T(RN,   0x1.c91be2fefe15p+310,    0x1.ef30e238aeb17p-1,   -0x1.83383p-3, INEXACT)
T(RN,  0x1.890978e528082p+310,    0x1.1e38cf0952a6dp-5,  -0x1.4f51e4p-3, INEXACT)
T(RN,  0x1.578db5423a07ap+310,   -0x1.fd4001200120bp-1,  -0x1.c3d192p-5, INEXACT)
T(RN,   0x1.14a203d2c51ep+310,    0x1.43947cf91065dp-1,   0x1.0af218p-4, INEXACT)
T(RN,  0x1.d40cf168e6d88p+310,   -0x1.0e772992f08a2p-1,   0x1.1ee562p-2, INEXACT)
T(RN,  0x1.007c58ab7dcaap+310,    0x1.12057de1a0ba6p-2,   -0x1.51237p-3, INEXACT)
T(RN,  0x1.e4fd7b601e96cp+310,   -0x1.d2c668db74f5ep-1,  -0x1.fc7c82p-3, INEXACT)
T(RN,  0x1.5134a808d982cp+310,    0x1.db44c47d2b1c6p-1,   0x1.e3eaf6p-7, INEXACT)
T(RN,  0x1.41e45e28cf2c4p+310,   -0x1.b93cc83c8a851p-1,  -0x1.9d1c82p-3, INEXACT)
T(RN,  0x1.b5a203ec4b76bp+310,   -0x1.e3cecb8676a4ap-4,  -0x1.d7d668p-2, INEXACT)
T(RN,  0x1.aacb7064fe6d2p+311,   -0x1.3ab16ee5aab0ap-1,  -0x1.fcb22ap-2, INEXACT)
T(RN,  0x1.fe20de2d9d8a6p+311,   -0x1.91aea466a750dp-2,  -0x1.9d8d5ep-4, INEXACT)
T(RN,  0x1.fbbff973f92d6p+311,   -0x1.f683564a59dadp-2,   0x1.6da012p-2, INEXACT)
T(RN,  0x1.cd9fec31ca0dep+311,   -0x1.ccfe698a72f54p-1,   0x1.323ac6p-2, INEXACT)
T(RN,  0x1.0e885aaf76478p+311,   -0x1.251feec58e09ep-2,   0x1.577c7ep-3, INEXACT)
T(RN,  0x1.43d214d003956p+311,    0x1.40efe528b0419p-2,  -0x1.36e77ep-3, INEXACT)
T(RN,  0x1.58a6b15c8b498p+311,    0x1.c4d7b61b1ee8ap-2,   0x1.c9e1f8p-2, INEXACT)
T(RN,  0x1.2719a2bdd3d52p+311,   -0x1.ea0eeb62fca26p-1,   0x1.aa1562p-5, INEXACT)
T(RN,  0x1.74a3f3e8f9666p+311,   -0x1.8517d11486fa9p-4,   0x1.151ff4p-2, INEXACT)
T(RN,    0x1.07d46d06b3ep+311,    0x1.ea0d88469be66p-2,  -0x1.8d5898p-3, INEXACT)
T(RN,  0x1.21cd7adc892c6p+312,   -0x1.ff79a25c5fab2p-1,   0x1.2d239ap-3, INEXACT)
T(RN,  0x1.9a9213948f48cp+312,    0x1.5dc39367035b1p-3,   0x1.2ca934p-2, INEXACT)
T(RN,  0x1.a96d9e31c3577p+312,    0x1.75369d3ca2db2p-2,    0x1.43ba9p-2, INEXACT)
T(RN,  0x1.43a65d74fb692p+312,    0x1.fc6025e297646p-1,   0x1.0204a4p-3, INEXACT)
T(RN,  0x1.221873508ea79p+312,   -0x1.fa7c44ddfd3d9p-1,   0x1.ec0f9ep-4, INEXACT)
T(RN,  0x1.d564f6094e1a6p+312,    0x1.82a1d1a0d9d5dp-1,  -0x1.806926p-6, INEXACT)
T(RN,  0x1.3df03c39dcf22p+312,   -0x1.0a1daae42a85bp-1,   0x1.359b12p-2, INEXACT)
T(RN,  0x1.1965ec7039abfp+312,    0x1.b13a7f2d4ad5ep-1,   0x1.02e954p-2, INEXACT)
T(RN,  0x1.bba45029fc886p+312,    -0x1.0ff8556759e7p-1,   0x1.33b234p-2, INEXACT)
T(RN,  0x1.3cfa41266c3a3p+312,   -0x1.f66f290631305p-1,  -0x1.3d04fcp-2, INEXACT)
T(RN,  0x1.016bc768791dcp+313,   -0x1.e3f3e315a8e62p-5,  -0x1.b99fb8p-2, INEXACT)
T(RN,  0x1.4f04e59964f23p+313,    0x1.99036524a732bp-2,   0x1.04388ap-3, INEXACT)
T(RN,  0x1.ae0d449e6e47ep+313,    0x1.f76f7d0d985e9p-1,  -0x1.dd868ap-3, INEXACT)
T(RN,  0x1.de57e134775e6p+313,   -0x1.e9def81907861p-1,   0x1.db672ep-4, INEXACT)
T(RN,  0x1.dbdcf865010fbp+313,   -0x1.e0c6f4ea9d3d3p-2,   0x1.c63ec4p-5, INEXACT)
T(RN,  0x1.01775700a2845p+313,   -0x1.0f0ac0e26e5ffp-1,  -0x1.77a3a6p-2, INEXACT)
T(RN,  0x1.4626e42b5cef3p+313,   -0x1.5c70260fe278cp-2,  -0x1.277f62p-2, INEXACT)
T(RN,  0x1.6d562d440bb63p+313,   -0x1.1a48eb9a791c9p-2,  -0x1.4e3d5cp-6, INEXACT)
T(RN,  0x1.6f9a17a1222d5p+313,   -0x1.40301fb916e4dp-7,  -0x1.105934p-4, INEXACT)
T(RN,   0x1.2ef2b84a36bcp+313,    0x1.f9276601dbfb6p-2,  -0x1.3c30ccp-2, INEXACT)
T(RN,   0x1.c8508a04bf5bp+314,   -0x1.f4b101f680bd9p-1,  -0x1.e9794ap-2, INEXACT)
T(RN,  0x1.6082fc94e2298p+314,    0x1.869fc942dba35p-1,   0x1.ce84d6p-3, INEXACT)
T(RN,  0x1.4d8a1f91529ffp+314,   -0x1.0e546c5c14c33p-1,  -0x1.167698p-5, INEXACT)
T(RN,  0x1.866cd49c88f5ap+314,    0x1.54eafc124a793p-1,   0x1.f02458p-2, INEXACT)
T(RN,  0x1.d61cba7d7375dp+314,    0x1.ffafa773acdc2p-1,    0x1.8f45ep-3, INEXACT)
T(RN,  0x1.60c2a3a003dc2p+314,    0x1.3c42864b38c14p-2,  -0x1.b2b5f4p-2, INEXACT)
T(RN,  0x1.a12d94f79bae4p+314,    0x1.f6728a866c8dap-6,   0x1.cab918p-2, INEXACT)
T(RN,  0x1.87c283dd25345p+314,   -0x1.af0d9530c3a5cp-1,   0x1.fb6232p-2, INEXACT)
T(RN,  0x1.7a5d9a0292638p+314,   -0x1.68d7446140bcep-5,   0x1.05b3f4p-3, INEXACT)
T(RN,  0x1.f78f1e2501e14p+314,    0x1.fd63f4d656204p-1,  -0x1.d00534p-6, INEXACT)
T(RN,  0x1.9e01dc33e396ep+315,   -0x1.05312790c614fp-6,   0x1.48694ap-2, INEXACT)
T(RN,   0x1.5333ade1a817p+315,   -0x1.fee8e7c43f991p-1,   0x1.48fd9ap-5, INEXACT)
T(RN,  0x1.557c377ed5b66p+315,   -0x1.24d650581e11ep-1,   0x1.676878p-2, INEXACT)
T(RN,   0x1.44533b718befp+315,   -0x1.0a1e43a387887p-2,   0x1.eb8dfep-2, INEXACT)
T(RN,  0x1.7928761e7653ep+315,   -0x1.b7268e53aa405p-2,  -0x1.534f46p-3, INEXACT)
T(RN,  0x1.ac50b3e740b37p+315,   -0x1.d71dde9d45455p-2,   0x1.e39c16p-2, INEXACT)
T(RN,  0x1.d696deddb2b8ap+315,   -0x1.c48b906ebae5dp-1,   0x1.4a5b6cp-2, INEXACT)
T(RN,  0x1.b508e709dfa92p+315,    0x1.db14988cee4bfp-4,   -0x1.91219p-2, INEXACT)
T(RN,  0x1.64de2df66148cp+315,    0x1.6a5880d716f63p-4,  -0x1.f1f1acp-2, INEXACT)
T(RN,  0x1.591c8eb8d4718p+315,   -0x1.b1d6e8819a1dbp-2,   0x1.c98436p-3, INEXACT)
T(RN,  0x1.6282567c00ba1p+316,    0x1.5793dd74b5b83p-1,  -0x1.e66fdep-8, INEXACT)
T(RN,  0x1.76b0708c91c2ep+316,   -0x1.2b70ebec29527p-2,   0x1.847f1ap-2, INEXACT)
T(RN,  0x1.8f7ff1ae1f214p+316,    0x1.a36445d283523p-5,    0x1.872bfp-3, INEXACT)
T(RN,  0x1.b61a95043be86p+316,    0x1.d9776577d416ap-1,   0x1.5a25fcp-3, INEXACT)
T(RN,  0x1.97a543a0515bep+316,    0x1.da3d5ef3805bcp-3,  -0x1.0b976ap-2, INEXACT)
T(RN,  0x1.97b8ff28b4a08p+316,   -0x1.ffbfc7310e37dp-1,  -0x1.7eb92cp-4, INEXACT)
T(RN,  0x1.a76e1b5470cf4p+316,   -0x1.cf9657ff1b48ap-1,  -0x1.3dd1fcp-3, INEXACT)
T(RN,  0x1.0ffed0abf7e7fp+316,   -0x1.603582f62c4c6p-1,   0x1.f7ffe4p-2, INEXACT)
T(RN,  0x1.504422f0145fbp+316,   -0x1.8d2f8be608a6dp-1,    0x1.6c92dp-2, INEXACT)
T(RN,  0x1.907a0fd119c11p+316,   -0x1.d33714832e9edp-1,   0x1.03f0dap-4, INEXACT)
T(RN,  0x1.ddb9c5cc2265ap+317,   -0x1.c4f066c082ce2p-1,   0x1.0d0d9cp-5, INEXACT)
T(RN,  0x1.4e0271ce04ff1p+317,   -0x1.ed4ecdc8caac4p-1,   0x1.5d70eap-3, INEXACT)
T(RN,  0x1.6327fc0fa85ccp+317,   -0x1.bce578a6f4608p-4,   0x1.66ba16p-3, INEXACT)
T(RN,   0x1.f3a18e96413cp+317,     0x1.2196d9619acbp-1,  -0x1.16a412p-2, INEXACT)
T(RN,  0x1.b144e8a84a234p+317,    0x1.6adea3b13e73dp-1,   0x1.dc7912p-2, INEXACT)
T(RN,  0x1.2196eb6b4aa9dp+317,   -0x1.f26280e4e69cep-1,  -0x1.e3b524p-3, INEXACT)
T(RN,  0x1.9bf18b734aae2p+317,    0x1.30c063b403c36p-2,  -0x1.1a996cp-2, INEXACT)
T(RN,   0x1.d016f7f8a3ffp+317,    0x1.fe974f2ee8391p-1,   0x1.37be0cp-4, INEXACT)
T(RN,    0x1.eb3e6128c41p+317,   -0x1.979d999e3d248p-2,  -0x1.a3010ap-3, INEXACT)
T(RN,  0x1.f1de5979ac74ap+317,     0x1.1ebf7b073cb3p-7,    0x1.ebc72p-2, INEXACT)
T(RN,  0x1.f55a73c4a6884p+318,   -0x1.8ed0e9be3c3ebp-1,   0x1.1b52a4p-4, INEXACT)
T(RN,  0x1.c8080f50bf6eep+318,   -0x1.30418f2fb533ep-1,   0x1.393bfcp-4, INEXACT)
T(RN,  0x1.c93de3cd1c31ep+318,    0x1.08ba322110ccdp-1,   0x1.9fd79cp-3, INEXACT)
T(RN,  0x1.41d16463ebc8ep+318,    0x1.518290356911dp-3,  -0x1.f1ffb8p-5, INEXACT)
T(RN,  0x1.d79df1c12b952p+318,   -0x1.84c86e8eed671p-4,   -0x1.abe85p-6, INEXACT)
T(RN,  0x1.2f6d8bd6c6a98p+318,   -0x1.9667270e624dbp-1,  -0x1.e538ccp-3, INEXACT)
T(RN,  0x1.498e8e6bdefe2p+318,   -0x1.4caf44da5f192p-1,  -0x1.53b2c8p-2, INEXACT)
T(RN,  0x1.0203e4841d7e2p+318,    0x1.53d35a5bf2ab6p-1,  -0x1.2e3af2p-3, INEXACT)
T(RN,  0x1.5359d4b92eaf6p+318,    0x1.c962858953d0dp-1,    0x1.15582p-2, INEXACT)
T(RN,  0x1.1eac91416bb08p+318,   -0x1.d8749e6c94c65p-2,  -0x1.008618p-2, INEXACT)
T(RN,  0x1.2bcb602355458p+319,    0x1.d8e2ca0abbdeep-2,  -0x1.c94938p-4, INEXACT)
T(RN,  0x1.b32fc7716d143p+319,   -0x1.36db29a40c1f5p-2,   0x1.367bb6p-2, INEXACT)
T(RN,  0x1.09e629f552c18p+319,   -0x1.aad91c7596b24p-1,   -0x1.616c4p-2, INEXACT)
T(RN,  0x1.024f724f95bfcp+319,   -0x1.59525b04b611ep-2,   0x1.b36eb8p-4, INEXACT)
T(RN,  0x1.b479575e2e295p+319,    0x1.d6e179a80933cp-1,  -0x1.f21856p-3, INEXACT)
T(RN,  0x1.921d64bbac04dp+319,   -0x1.4753116d3a027p-6,    0x1.85863p-2, INEXACT)
T(RN,  0x1.6c9272a23d0dcp+319,   -0x1.f8a74a21a2c2ap-1,  -0x1.c6178ep-4, INEXACT)
T(RN,  0x1.3b56d0a90fa24p+319,   -0x1.6a6bb3b52d787p-3,   0x1.654c6ap-2, INEXACT)
T(RN,  0x1.6b80d87102991p+319,    0x1.c0fabf1f58286p-1,   0x1.2ceac4p-2, INEXACT)
T(RN,  0x1.0da2b4c897a63p+319,    0x1.ffce1552fc87bp-1,  -0x1.23649ep-3, INEXACT)
T(RN,  0x1.5c4cbb588b01dp+320,    0x1.46565d30586fbp-1,   0x1.e5452ep-3, INEXACT)
T(RN,  0x1.bb6ed730869b4p+320,    0x1.347119723fc1cp-1,  -0x1.22fd1ap-2, INEXACT)
T(RN,  0x1.85c3cb16f5097p+320,    0x1.ffc67b53a7a88p-1,  -0x1.66eebep-2, INEXACT)
T(RN,  0x1.7a89c20aa91edp+320,    0x1.eb970ec0055dep-1,   0x1.3c242cp-5, INEXACT)
T(RN,  0x1.4b0e08612042fp+320,    0x1.9d4bee40b1a6bp-1,   0x1.2876ecp-3, INEXACT)
T(RN,  0x1.5e7027c48a937p+320,    0x1.3cd3f13832d2ep-2,  -0x1.471a3ep-2, INEXACT)
T(RN,  0x1.254143f8eba86p+320,    0x1.ffa47ee3ace81p-1,  -0x1.22bba2p-2, INEXACT)
T(RN,   0x1.4b1f700ba796p+320,   -0x1.ec663e934f311p-2,    0x1.8915dp-5, INEXACT)
T(RN,  0x1.d549fec42751ap+320,   -0x1.5650053908912p-4,  -0x1.3c61acp-4, INEXACT)
T(RN,  0x1.5341c513686d8p+320,   -0x1.ecb3948fcf94bp-1,   0x1.13baf8p-4, INEXACT)
T(RN,  0x1.f2b2aa952fd0ep+321,    0x1.0b13767216fb5p-1,    0x1.cf79ep-2, INEXACT)
T(RN,  0x1.6adcf001d3a88p+321,   -0x1.33feedef447fbp-1,  -0x1.a4824cp-2, INEXACT)
T(RN,  0x1.02da3c2ee1045p+321,   -0x1.1bb185439c688p-1,   -0x1.c6712p-2, INEXACT)
T(RN,  0x1.4dd8f7b3d6bb8p+321,    0x1.40c3d79573062p-1,   0x1.897c8cp-5, INEXACT)
T(RN,  0x1.bf9d2aa5e9c62p+321,    -0x1.058fd4b07d45p-1,   -0x1.b0889p-3, INEXACT)
T(RN,  0x1.0f3cfd88c64bdp+321,   -0x1.be0c4ff32f0f3p-1,   0x1.723a5cp-5, INEXACT)
T(RN,  0x1.99060570933a2p+321,    0x1.d2d2167a4386fp-1,  -0x1.9b6d08p-2, INEXACT)
T(RN,  0x1.130b233c5362bp+321,   -0x1.2ecf381b76262p-4,   0x1.e5d144p-3, INEXACT)
T(RN,  0x1.770a6e1be7a2ap+321,   -0x1.e8b5cbc72fed8p-3,    0x1.453c3p-2, INEXACT)
T(RN,  0x1.a49802c313786p+321,   -0x1.ff700462c31a3p-1,   0x1.476422p-2, INEXACT)
T(RN,  0x1.d1e413280d1cep+322,   -0x1.ff6ba8b5cd9cdp-1,   0x1.711028p-4, INEXACT)
T(RN,  0x1.312a640ad160cp+322,    -0x1.f192bad774f1p-1,   0x1.c5a918p-2, INEXACT)
T(RN,  0x1.63a4e75cb75ebp+322,   -0x1.8cf33a5a3e05fp-3,  -0x1.12d792p-2, INEXACT)
T(RN,  0x1.fe44f1d471d31p+322,    0x1.c287afe3368dcp-1,   0x1.cdc3fcp-4, INEXACT)
T(RN,  0x1.3cb6712c0297fp+322,    -0x1.cafd7bbc901dp-1,   0x1.65cf32p-2, INEXACT)
T(RN,  0x1.9c966773ca295p+322,    0x1.eaf62a3113e7fp-1,  -0x1.0da764p-2, INEXACT)
T(RN,  0x1.1961746a69f4fp+322,   -0x1.78297d3c9b7a3p-1,  -0x1.cd576cp-3, INEXACT)
T(RN,  0x1.96355008b4ccep+322,    0x1.a2dd192c231edp-4,  -0x1.22b986p-3, INEXACT)
T(RN,  0x1.36b8143620f69p+322,   -0x1.42ce8c5007f94p-1,   0x1.8e84ecp-3, INEXACT)
T(RN,  0x1.0cd05f68ce0a3p+322,   -0x1.e114dae22bf0fp-1,  -0x1.63f6e4p-2, INEXACT)
T(RN,  0x1.690b5b54ab51ap+323,   -0x1.24bfe98de5a5ap-1,   0x1.22f86cp-2, INEXACT)
T(RN,  0x1.971ed01e4fd0cp+323,    0x1.1ba2880b2f0f8p-3,  -0x1.893ea6p-2, INEXACT)
T(RN,  0x1.1b31da98d78e5p+323,    0x1.f66fbb8595409p-1,  -0x1.0bd938p-4, INEXACT)
T(RN,  0x1.b451ff6a0a36dp+323,   -0x1.fb84ab62b594bp-1,    0x1.cefa9p-6, INEXACT)
T(RN,  0x1.7aadbd5a8ec1ep+323,   -0x1.e8f920f151fa5p-1,   0x1.f99ee4p-4, INEXACT)
T(RN,   0x1.85bb52321b71p+323,    0x1.ffbd6f675d2d7p-1,  -0x1.e21cb8p-2, INEXACT)
T(RN,  0x1.4e3a544e639a6p+323,   -0x1.1a09f05f6531fp-1,   0x1.e767f8p-6, INEXACT)
T(RN,  0x1.b8bc8a3526e82p+323,    0x1.9339ca36cf96ep-1,   0x1.787ab8p-4, INEXACT)
T(RN,  0x1.76243bcf31c8dp+323,   -0x1.f089300359b4dp-1,   0x1.e2a742p-3, INEXACT)
T(RN,  0x1.99113736da4cap+323,    0x1.1b41fb5b49aadp-2,  -0x1.607e62p-3, INEXACT)
T(RN,  0x1.f21268d2ffb96p+324,   -0x1.e5734df7c2167p-2,  -0x1.dfbd68p-2, INEXACT)
T(RN,   0x1.4fd35990c351p+324,    0x1.f724c7abd9f87p-1,   0x1.0d7a44p-6, INEXACT)
T(RN,  0x1.a27fdbb07f222p+324,   -0x1.82659446811d4p-1,  -0x1.0016f2p-4, INEXACT)
T(RN,  0x1.4c348253ec15bp+324,   -0x1.f287d9ccd433fp-1,   0x1.91e404p-4, INEXACT)
T(RN,  0x1.e6ca85d243b39p+324,    0x1.e716a74d9688ep-1,   0x1.b844f4p-3, INEXACT)
T(RN,  0x1.92ca7695f60b4p+324,    -0x1.4846bafa5d85p-1,  -0x1.1e4846p-3, INEXACT)
T(RN,   0x1.d0ef972dcde5p+324,   -0x1.f3218445e0d11p-2,   0x1.2329d6p-3, INEXACT)
T(RN,  0x1.7b6f8e03dc2d1p+324,    0x1.e4a5bccaebdf9p-3,  -0x1.4ab05cp-2, INEXACT)
T(RN,  0x1.3c56df3d567a7p+324,    0x1.9ebcbe8e3627cp-5,  -0x1.96e5e4p-2, INEXACT)
T(RN,  0x1.19231cae9276dp+324,   -0x1.f8c0556a6d295p-1,  -0x1.5e4fc8p-3, INEXACT)
T(RN,  0x1.988fb9332755dp+325,   -0x1.a693a1f0f3678p-1,   0x1.a7c342p-3, INEXACT)
T(RN,  0x1.bb27b6355bf38p+325,    0x1.f68f7fdd1e692p-1,  -0x1.4f33fcp-3, INEXACT)
T(RN,  0x1.473362a1f63a4p+325,   -0x1.f9b74486e9c3dp-1,  -0x1.af1696p-2, INEXACT)
T(RN,  0x1.4b9f94e07f3aep+325,    0x1.5ccd71fdd504ep-1,   0x1.1b0182p-2, INEXACT)
T(RN,  0x1.b3ae9e20ed726p+325,   -0x1.9be1900ad2357p-4,   0x1.3360dcp-3, INEXACT)
T(RN,  0x1.928e1933e7d48p+325,    0x1.d47dac95175edp-2,   0x1.fc866ap-3, INEXACT)
T(RN,  0x1.5530579ef746bp+325,   -0x1.f0ddd96b8d3a9p-1,  -0x1.4af704p-3, INEXACT)
T(RN,  0x1.ce1bc4f2e4708p+325,   -0x1.1d8196f45be23p-4,  -0x1.b867b2p-2, INEXACT)
T(RN,  0x1.d2b7e0eb53942p+325,    0x1.c3b33c4eefed8p-1,  -0x1.2cf016p-2, INEXACT)
T(RN,  0x1.84f28fa8ccf93p+325,   -0x1.bb7ff3c4557f3p-1,   -0x1.1cebcp-3, INEXACT)
T(RN,  0x1.cf96a8aba950ep+326,   -0x1.c6e2145d729eep-3,  -0x1.2be44ep-2, INEXACT)
T(RN,  0x1.0200c72118c7ep+326,     0x1.2c69b33f2d02p-2,  -0x1.657256p-3, INEXACT)
T(RN,  0x1.86d04a55858ecp+326,   -0x1.82016ea9c8879p-1,   0x1.f1df62p-2, INEXACT)
T(RN,  0x1.590671df2c4b8p+326,   -0x1.e53c023482429p-1,  -0x1.64bb28p-3, INEXACT)
T(RN,  0x1.b67ee135cfd34p+326,    0x1.01cf7eccf901ap-1,  -0x1.e5f9cep-2, INEXACT)
T(RN,  0x1.518f821882fadp+326,    0x1.ffbbeab91c24bp-1,   -0x1.64129p-4, INEXACT)
T(RN,  0x1.8f88dc2dfcd84p+326,   -0x1.ee7c33820cda3p-4,   0x1.b38aacp-3, INEXACT)
T(RN,  0x1.ff8c7aebf5d06p+326,   -0x1.cf28c00878abcp-1,   0x1.a520dep-2, INEXACT)
T(RN,  0x1.3fdf1254750e5p+326,   -0x1.c0ebbf34b6769p-1,   0x1.bd4664p-3, INEXACT)
T(RN,  0x1.06226a76faf45p+326,    -0x1.3b47c7650ad2p-5,  -0x1.560f28p-2, INEXACT)
T(RN,  0x1.cf1dae1459b17p+327,    0x1.f2eea24605c0fp-1,  -0x1.ad19f8p-3, INEXACT)
T(RN,  0x1.fa0d900ac356ep+327,   -0x1.ab0a61357507ap-7,   0x1.c737ecp-2, INEXACT)
T(RN,  0x1.609b096ac8004p+327,   -0x1.f3e7b5f795f94p-1,   0x1.8a0682p-2, INEXACT)
T(RN,  0x1.78c02e0da062ap+327,    0x1.b0c5be0e857e2p-3,  -0x1.105edcp-4, INEXACT)
T(RN,  0x1.ecce3c6e0f182p+327,   -0x1.0db9f694cc0f4p-2,   0x1.6edb7ep-2, INEXACT)
T(RN,  0x1.81e78f6999eccp+327,   -0x1.f000c53456cecp-1,  -0x1.a7e038p-3, INEXACT)
T(RN,  0x1.ff93abb534524p+327,   -0x1.89264461de524p-3,   0x1.24fa94p-4, INEXACT)
T(RN,  0x1.180973add7031p+327,    -0x1.058b0eb6b343p-2,   0x1.003e02p-3, INEXACT)
T(RN,  0x1.59c0cf0228bbdp+327,    0x1.50b9909b7b897p-1,    0x1.f0031p-2, INEXACT)
T(RN,  0x1.83d281dfdfe2ap+327,    0x1.e61b323c7b138p-1,  -0x1.48b2c8p-4, INEXACT)
T(RN,  0x1.eceeb6155626ep+328,    0x1.60d20566d3b9fp-5,  -0x1.e7e02ep-2, INEXACT)
T(RN,  0x1.d654395e30eb2p+328,    -0x1.d378a9705bb7p-1,   0x1.75a918p-3, INEXACT)
T(RN,  0x1.9ccaacb8bfdc4p+328,    0x1.2fe8f4e2fecf2p-1,  -0x1.39d2ecp-2, INEXACT)
T(RN,  0x1.81a3209228741p+328,    0x1.6171ed4674027p-1,  -0x1.4bc7fcp-3, INEXACT)
T(RN,   0x1.720bc52c45dap+328,   -0x1.f0bf1be8ac373p-1,  -0x1.83d8cap-4, INEXACT)
T(RN,  0x1.ab2fe1eeeeed8p+328,     0x1.fffdadee081cp-1,   0x1.b54042p-6, INEXACT)
T(RN,  0x1.c19ee8cc2c526p+328,    0x1.36b01e2e53e72p-2,  -0x1.e8b88ep-3, INEXACT)
T(RN,  0x1.d566bbd76582ep+328,   -0x1.adba7ce85e711p-1,  -0x1.00161ep-3, INEXACT)
T(RN,  0x1.b251999cac5f8p+328,    0x1.d0e0180f86ee8p-1,  -0x1.6f37cap-3, INEXACT)
T(RN,  0x1.0cd3331b0e5acp+328,   -0x1.e1155017a636ap-1,   0x1.2085aap-2, INEXACT)
T(RN,  0x1.22aef18a667c8p+329,    0x1.e211240fa98ffp-1,   0x1.0230d6p-2, INEXACT)
T(RN,  0x1.6f53eaed40149p+329,   -0x1.f19f88715ec99p-1,   -0x1.b5f3ap-7, INEXACT)
T(RN,  0x1.2f07c3c1dd308p+329,   -0x1.b7a285f38b93bp-2,  -0x1.333288p-2, INEXACT)
T(RN,  0x1.2e37c5edc6347p+329,    0x1.3844753d1e689p-1,  -0x1.cce27ap-2, INEXACT)
T(RN,  0x1.d4b7fa660a962p+329,   -0x1.f7ad9cf6e9329p-3,  -0x1.d511c8p-6, INEXACT)
T(RN,  0x1.df3a53a1495ffp+329,    0x1.a283178b5986dp-1,   0x1.67925ep-3, INEXACT)
T(RN,  0x1.f12e85705d6f5p+329,    0x1.c03c2e9fc09e4p-2,  -0x1.a67688p-3, INEXACT)
T(RN,  0x1.dbd777aece03cp+329,    0x1.f5b3bd81aa118p-1,  -0x1.0d67eap-2, INEXACT)
T(RN,  0x1.981ba7fcae5aap+329,   -0x1.713db36d5eb9cp-1,   0x1.acbbc8p-3, INEXACT)
T(RN,  0x1.f5c0c8fd5ee45p+329,    0x1.c2f853d75ed7ap-1,  -0x1.8c5bcap-3, INEXACT)
T(RN,  0x1.079c3c4bc3d6fp+330,   -0x1.ff2130e797606p-1,  -0x1.8a6264p-3, INEXACT)
T(RN,  0x1.b81dcafc01b74p+330,   -0x1.947da1fd166a2p-1,   0x1.6ce1dap-4, INEXACT)
T(RN,  0x1.be3b9888cb487p+330,    0x1.cfb5f0966678cp-1,   0x1.af5872p-6, INEXACT)
T(RN,  0x1.5e7f734cc408fp+330,    0x1.4cb65b1855cbbp-4,  -0x1.380d14p-3, INEXACT)
T(RN,  0x1.11960ad27bc6dp+330,   -0x1.121ff23aea944p-3,   0x1.97e2c2p-2, INEXACT)
T(RN,  0x1.c43ea7d3edc1dp+330,   -0x1.cb2aed95cb20dp-2,  -0x1.dac27ap-2, INEXACT)
T(RN,  0x1.22b3eb9e81921p+330,   -0x1.335a651adcf6ap-1,   -0x1.d4857p-2, INEXACT)
T(RN,  0x1.b61d6384b68f6p+330,   -0x1.c674533504747p-1,   0x1.dc8bacp-5, INEXACT)
T(RN,  0x1.4ff3d32e0ad01p+330,    0x1.037b6aa4ec4f3p-3,   -0x1.d9a2ep-4, INEXACT)
T(RN,   0x1.f6e9f53be225p+330,   -0x1.c0d1e8157c78ap-2,  -0x1.beaa18p-3, INEXACT)
T(RN,  0x1.41095dea5d3c7p+331,   -0x1.a27fa629d79f7p-2,    0x1.7a7d5p-3, INEXACT)
T(RN,  0x1.89402eb8b7755p+331,   -0x1.1eefef4cb8b9fp-1,  -0x1.02a98ep-2, INEXACT)
T(RN,  0x1.60063e11dc22fp+331,    0x1.63fee931a56ebp-1,  -0x1.f079b6p-7, INEXACT)
T(RN,  0x1.4e634066ccb7bp+331,   -0x1.a1382a865b724p-1,  -0x1.e1dca6p-5, INEXACT)
T(RN,  0x1.37dc456894026p+331,    0x1.aba1988170896p-3,   0x1.21d4c8p-8, INEXACT)
T(RN,  0x1.ff2936d8cba1dp+331,   -0x1.e231bf4033569p-1,   0x1.2218d6p-2, INEXACT)
T(RN,  0x1.c9b0d88c0ff71p+331,    0x1.f9807bf5bd4cdp-2,   0x1.981f8ap-2, INEXACT)
T(RN,  0x1.be392c3801ebap+331,     0x1.e6a373817651p-3,   0x1.33b898p-4, INEXACT)
T(RN,  0x1.bf5f0cdf875bap+331,   -0x1.ec4e4e51548ddp-1,    0x1.6c6fbp-4, INEXACT)
T(RN,  0x1.2074888c8f512p+331,   -0x1.b3eb729272ad1p-1,  -0x1.e3a1d4p-2, INEXACT)
T(RN,   0x1.20298e449e5dp+332,   -0x1.f362121c41c9fp-1,   0x1.c4963ap-3, INEXACT)
T(RN,  0x1.e4d3712e42992p+332,    0x1.94fbe5409244bp-1,   0x1.443618p-8, INEXACT)
T(RN,  0x1.88b5d4108b277p+332,    0x1.244e627d254d9p-2,  -0x1.193ba8p-5, INEXACT)
T(RN,   0x1.e32c298e0768p+332,    0x1.8dfb84c06f3cfp-1,   0x1.8f9616p-2, INEXACT)
T(RN,  0x1.f69e783bad474p+332,   -0x1.0923985d793dap-1,    -0x1.cfdap-4, INEXACT)
T(RN,  0x1.e42d31615f042p+332,   -0x1.7991ca613a961p-1,  -0x1.c794cap-2, INEXACT)
T(RN,  0x1.e42c57dee9d27p+332,    -0x1.4ac2deb64152p-1,   -0x1.c7b9ep-2, INEXACT)
T(RN,  0x1.ac645402d7f93p+332,    0x1.93fcdb5b95145p-1,   0x1.87d568p-2, INEXACT)
T(RN,  0x1.df437744a5609p+332,   -0x1.e27345e4da352p-1,  -0x1.4a68a2p-2, INEXACT)
T(RN,  0x1.4952ef297989ep+332,   -0x1.3f46cd25ff73fp-2,   0x1.e2681ep-5, INEXACT)
T(RN,  0x1.b6fb7adc73d3ep+333,    0x1.fff7cfe90a23ep-1,  -0x1.7a347ap-4, INEXACT)
T(RN,  0x1.4742609b96b6bp+333,     0x1.fcb174d790b6p-1,  -0x1.0e3fbep-2, INEXACT)
T(RN,  0x1.24108edd07175p+333,   -0x1.22d105e97c51bp-2,   0x1.e1a096p-3, INEXACT)
T(RN,  0x1.22f15b1a89684p+333,   -0x1.f68bf454f08bfp-1,  -0x1.625a96p-2, INEXACT)
T(RN,   0x1.783345002977p+333,    0x1.e72672223bc1ep-1,   0x1.c3d66cp-2, INEXACT)
T(RN,  0x1.c8218be4833d8p+333,    0x1.f9f2bf7658c56p-4,   0x1.31be8cp-4, INEXACT)
T(RN,  0x1.52ce471a79d1ep+333,    0x1.5ed380b47e3c1p-3,   0x1.1b62c2p-3, INEXACT)
T(RN,  0x1.5319a53e094a3p+333,    0x1.aa7b11185c8dbp-2,  -0x1.6a0ebap-2, INEXACT)
T(RN,  0x1.a8006f3f10252p+333,   -0x1.f58fb3d80574cp-1,  -0x1.d1a20cp-4, INEXACT)
T(RN,  0x1.986199572afd5p+333,    0x1.fff2a312ea313p-1,   0x1.8ebceap-2, INEXACT)
T(RN,  0x1.e67353718dc36p+334,    0x1.938f4135ff145p-1,  -0x1.ad3998p-2, INEXACT)
T(RN,  0x1.35270220789e8p+334,   -0x1.736e77b5369c4p-1,   0x1.038846p-3, INEXACT)
T(RN,  0x1.2d117fdab3cbdp+334,      0x1.a94d17faec4p-1,   0x1.cca52ep-5, INEXACT)
T(RN,  0x1.59ab415e38399p+334,    0x1.92cd7bcbf919dp-1,   0x1.852576p-3, INEXACT)
T(RN,  0x1.fc891c450e572p+334,   -0x1.d8e7b7cda01e2p-1,   0x1.eddac2p-2, INEXACT)
T(RN,  0x1.64f4a01a4b8eap+334,   -0x1.cb15c3af3f0c3p-2,   0x1.f894ccp-4, INEXACT)
T(RN,  0x1.1aff823a4232fp+334,   -0x1.70c70f74ad814p-1,   0x1.3854ecp-2, INEXACT)
T(RN,  0x1.ca785c015def4p+334,    0x1.73c4e42da0dfdp-2,   0x1.efccfcp-2, INEXACT)
T(RN,  0x1.eafd6314aeebbp+334,    0x1.e7b6b13f6e3cbp-1,   0x1.e7f79ep-2, INEXACT)
T(RN,  0x1.4641d76cb0cf4p+334,    0x1.29c19fc038d2bp-1,   0x1.3ed37ap-4, INEXACT)
T(RN,  0x1.56fd0d5ed398ep+335,   -0x1.af64770a9c7fbp-1,  -0x1.abf0e4p-2, INEXACT)
T(RN,  0x1.f9f90eb70d753p+335,   -0x1.145ffc2cbc062p-2,   0x1.1c19bap-2, INEXACT)
T(RN,  0x1.1e2c45a247b0cp+335,    0x1.dd3840f489c3ep-1,   -0x1.807e5p-3, INEXACT)
T(RN,  0x1.4374156bae9e9p+335,    0x1.0f0b4be33b8fap-1,   0x1.b0b168p-2, INEXACT)
T(RN,  0x1.3c6f1ef700c8ep+335,    0x1.ae41509dcbec6p-2,   -0x1.54494p-7, INEXACT)
T(RN,  0x1.516632a275d27p+335,     0x1.d74920a28e4fp-1,   0x1.3858e2p-2, INEXACT)
T(RN,  0x1.f6ed883dbde28p+335,    0x1.b30f8588be31cp-1,   0x1.06c6bcp-2, INEXACT)
T(RN,  0x1.2bbcf78527629p+335,    0x1.2eba55f5a46f3p-1,   0x1.b53102p-5, INEXACT)
T(RN,  0x1.0117aecef06b5p+335,    0x1.42914ba65bb2fp-1,   0x1.1d183cp-2, INEXACT)
T(RN,  0x1.bcf2d48f17afbp+335,   -0x1.600035060fca6p-2,  -0x1.96e036p-3, INEXACT)
T(RN,  0x1.0a95fa80c8fd6p+336,   -0x1.13cd2c11da362p-3,   0x1.af533ap-6, INEXACT)
T(RN,  0x1.1aed3341e09a8p+336,    0x1.cee8124a43673p-1,   -0x1.0f102p-2, INEXACT)
T(RN,  0x1.184cdcccc3d0ep+336,    0x1.9ea6aee53a6e2p-1,   0x1.a3277ep-2, INEXACT)
T(RN,  0x1.a42a207d28d14p+336,    -0x1.f02e3bb07e65p-4,  -0x1.a3aa34p-2, INEXACT)
T(RN,  0x1.a2874e32db84ap+336,    0x1.9012465c17a2bp-1,  -0x1.c70cb4p-3, INEXACT)
T(RN,  0x1.3539c405cf822p+336,   -0x1.8a5ca3b1aaae6p-2,  -0x1.e71058p-4, INEXACT)
T(RN,  0x1.fcb621eb6c1f6p+336,    0x1.cf04afd930ee7p-3,   0x1.5dcc0ep-4, INEXACT)
T(RN,  0x1.f13e1207bc3a4p+336,    0x1.f32be74e359bap-1,  -0x1.0f30aap-3, INEXACT)
T(RN,  0x1.d8db87e46be4cp+336,    0x1.578f369eff0e5p-1,   0x1.c5bfaap-3, INEXACT)
T(RN,  0x1.a546faac0aaf6p+336,    0x1.d57d348c4fbc1p-1,    0x1.e024cp-3, INEXACT)
T(RN,   0x1.b2f33fd938efp+337,   -0x1.eb3ce4093b9f8p-2,  -0x1.b49e22p-2, INEXACT)
T(RN,   0x1.834866d8e8f8p+337,    0x1.c517ecfc2ea65p-1,   0x1.9ae13cp-3, INEXACT)
T(RN,  0x1.80714ce2d65cap+337,    0x1.ff6233239ea0ep-1,   0x1.d45f4ap-2, INEXACT)
T(RN,  0x1.005f4f3f99075p+337,    0x1.d9bccf5b7f503p-3,   0x1.c2631cp-3, INEXACT)
T(RN,  0x1.725956b71dda4p+337,    0x1.2ab6773e99a2cp-1,  -0x1.8378d2p-2, INEXACT)
T(RN,   0x1.909ea85419eap+337,    0x1.cc9453c9247b2p-1,   0x1.b25604p-3, INEXACT)
T(RN,  0x1.40c2d048bbb9ep+337,   -0x1.a7fe2df1078b5p-1,   0x1.259776p-2, INEXACT)
T(RN,  0x1.7079a17e9e2eep+337,   -0x1.4c8b41c8788c6p-1,  -0x1.363722p-2, INEXACT)
T(RN,  0x1.8546f0652b866p+337,    0x1.550d241fd92d8p-1,   0x1.566036p-6, INEXACT)
T(RN,  0x1.7428a0bc02d1ep+337,   -0x1.01e807f1ae90ep-2,  -0x1.7bf042p-5, INEXACT)
T(RN,  0x1.65db6cec3a056p+338,    0x1.5b372900c130ep-1,   -0x1.406bep-2, INEXACT)
T(RN,  0x1.4e26ee0e428c2p+338,   -0x1.c728b911aafbfp-1,  -0x1.98061cp-2, INEXACT)
T(RN,  0x1.bee668fc69fb4p+338,    0x1.fc0bce03de5cep-1,   -0x1.e72c5p-5, INEXACT)
T(RN,  0x1.2ec8dc5e530ecp+338,   -0x1.fff764f98b8a5p-1,    0x1.3efa2p-3, INEXACT)
T(RN,  0x1.0bbae45722612p+338,   -0x1.cb79e3a03951dp-1,  -0x1.c505e4p-5, INEXACT)
T(RN,  0x1.3cab55b2c110ap+338,   -0x1.fc40d867ba86cp-1,   0x1.c0c178p-3, INEXACT)
T(RN,  0x1.c33c01eac0a7ap+338,    0x1.8702e348f48dbp-2,   0x1.422168p-2, INEXACT)
T(RN,  0x1.cae925eea8c37p+338,    0x1.8eec8b0873bfcp-1,  -0x1.2d679ap-4, INEXACT)
T(RN,  0x1.d91c003e5ee5ap+338,    0x1.f9a4154eec302p-1,    0x1.e0934p-3, INEXACT)
T(RN,   0x1.2ea3383b108dp+338,    0x1.c9626e51b6ad1p-1,   0x1.7fa79ep-2, INEXACT)
T(RN,   0x1.640f9376b3aap+339,   -0x1.a237e62b3db6fp-1,  -0x1.31144ap-2, INEXACT)
T(RN,  0x1.5ac8389bd3c0ep+339,   -0x1.ef5555a7ed492p-1,   0x1.776cb6p-2, INEXACT)
T(RN,  0x1.1473fa43ce50bp+339,    0x1.c15bdd3727a07p-1,   0x1.f91678p-5, INEXACT)
T(RN,  0x1.051be3e55a30fp+339,   -0x1.a33628d3cf7dcp-2,   0x1.dad512p-2, INEXACT)
T(RN,  0x1.78c095231aabcp+339,   -0x1.5bb3aa9607abep-1,  -0x1.8f421cp-4, INEXACT)
T(RN,   0x1.07492a16b844p+339,   -0x1.e576dd5433409p-1,  -0x1.e3fac2p-3, INEXACT)
T(RN,  0x1.6961a3dda37f4p+339,   -0x1.4c79b30a8799fp-2,   -0x1.699d7p-2, INEXACT)
T(RN,  0x1.b8c9f1a89cfb6p+339,   -0x1.a806206676051p-2,   0x1.33635ep-2, INEXACT)
T(RN,  0x1.e648b8e806da7p+339,    0x1.e56f64484f4efp-1,   0x1.5c081ap-6, INEXACT)
T(RN,  0x1.47a3c291e7679p+339,   -0x1.fab1ec3111749p-1,  -0x1.e3a0ccp-3, INEXACT)
T(RN,  0x1.1e8fba0153771p+340,    0x1.f9e108718a0f7p-1,   -0x1.11178p-2, INEXACT)
T(RN,  0x1.c5f9da6277e5fp+340,   -0x1.883e047af0036p-1,  -0x1.e23ac8p-2, INEXACT)
T(RN,  0x1.d09cf559d4368p+340,   -0x1.b844f55149106p-6,  -0x1.d244a6p-4, INEXACT)
T(RN,  0x1.49855bc32bafcp+340,   -0x1.cfafe397b3babp-1,   0x1.ebdeaep-2, INEXACT)
T(RN,  0x1.a60553244f33ap+340,   -0x1.fee00043aa44dp-1,   0x1.47ae32p-2, INEXACT)
T(RN,  0x1.85bbb70baed12p+340,    0x1.fd9f7e0fb3322p-1,   0x1.3691bap-2, INEXACT)
T(RN,  0x1.68175ca8ecceap+340,   -0x1.c8142e4bf0b7cp-3,  -0x1.11e56cp-2, INEXACT)
T(RN,  0x1.0191e1948e009p+340,    0x1.3f1655eebbe7dp-1,   0x1.c6a7b4p-3, INEXACT)
T(RN,  0x1.14f573a5b54cfp+340,    0x1.c8021fb164574p-1,  -0x1.d7deaap-2, INEXACT)
T(RN,   0x1.3ad67c2c4f34p+340,    0x1.ad5e5301babfep-3,  -0x1.f81a7ap-2, INEXACT)
T(RN,  0x1.80e3807043d94p+341,    0x1.cb30a4cb92a7ap-3,  -0x1.da4ef4p-2, INEXACT)
T(RN,  0x1.4b3b7caca3694p+341,   -0x1.5f3df933aaeebp-1,   0x1.e737b6p-4, INEXACT)
T(RN,  0x1.0724f0838de3bp+341,    -0x1.cf22619fd8d5p-1,   0x1.d264b4p-2, INEXACT)
T(RN,  0x1.1ebca7b6be205p+341,   -0x1.82135a372b655p-4,   0x1.2ec1fep-3, INEXACT)
T(RN,  0x1.4c2abaffbe758p+341,   -0x1.5b15fe73ea654p-1,  -0x1.06c208p-2, INEXACT)
T(RN,  0x1.64b6a92035688p+341,    0x1.b20e6da11a73dp-1,   0x1.d948fep-2, INEXACT)
T(RN,   0x1.362a3be12957p+341,   -0x1.3fb0ba76b8364p-2,   0x1.0e7dcep-2, INEXACT)
T(RN,  0x1.aabb34f34b5ecp+341,    0x1.e8ec6022f634ep-2,   -0x1.98b19p-4, INEXACT)
T(RN,  0x1.d4454e25e8a2ap+341,   -0x1.d4ef1c95f5997p-2,  -0x1.1d9b56p-2, INEXACT)
T(RN,  0x1.756a09ce50ecep+341,   -0x1.ffa1c7fc1d096p-1,   0x1.7f24a2p-4, INEXACT)
T(RN,  0x1.d6cd62cd72738p+342,    0x1.1371ae7a78b0dp-1,   0x1.2b6752p-2, INEXACT)
T(RN,  0x1.b0b60c80b887ap+342,     0x1.684167d53cc9p-3,  -0x1.610a9ep-2, INEXACT)
T(RN,  0x1.7cdfc97a51926p+342,   -0x1.61344108f626dp-6,   0x1.178e4ap-4, INEXACT)
T(RN,  0x1.afc6419dc81a8p+342,    0x1.0748f0182780cp-1,   0x1.171e94p-2, INEXACT)
T(RN,  0x1.fb369f428c948p+342,   -0x1.a6fe68e7fecd4p-1,   0x1.8c89f2p-3, INEXACT)
T(RN,  0x1.9296866b44934p+342,     0x1.2abc2e68af2ep-2,   0x1.835b42p-2, INEXACT)
T(RN,  0x1.7e811a7b85ef3p+342,    0x1.c854192cf0822p-1,    0x1.f6bdcp-2, INEXACT)
T(RN,  0x1.ba44e5c6a9b8ep+342,     0x1.9466e34437b7p-3,   0x1.0540a6p-2, INEXACT)
T(RN,  0x1.19c6086ed73cep+342,   -0x1.76236108356a5p-1,   0x1.538f48p-3, INEXACT)
T(RN,  0x1.628af23d52cdap+342,   -0x1.d54be29d93706p-1,   0x1.718a0ep-5, INEXACT)
T(RN,  0x1.abf096b2b0bb6p+343,    0x1.fffffbfd686f1p-1,   0x1.a388e8p-3, INEXACT)
T(RN,  0x1.2f6bfaa66055ap+343,   -0x1.8af5311817d68p-1,  -0x1.ec68b2p-2, INEXACT)
T(RN,  0x1.e2a0534482a6fp+343,   -0x1.0365bacf9196dp-1,  -0x1.c19ca2p-2, INEXACT)
T(RN,  0x1.1874009b316b3p+343,    0x1.e240d7146682dp-1,  -0x1.45bc46p-2, INEXACT)
T(RN,  0x1.ae3a2ff7f36f6p+343,    0x1.69375206645c6p-2,   0x1.50a39cp-4, INEXACT)
T(RN,  0x1.63ede29913c49p+343,    0x1.a3546f525c5c7p-1,   0x1.af4a28p-3, INEXACT)
T(RN,  0x1.b680830b7b35bp+343,    0x1.f35a2183d1f74p-1,  -0x1.6a3d9ap-2, INEXACT)
T(RN,  0x1.bcb754ff4e3dep+343,   -0x1.d73d022aca5c4p-3,  -0x1.be8972p-5, INEXACT)
T(RN,  0x1.c7ae97f9862bdp+343,   -0x1.794d6feb9f1cep-1,    0x1.638cfp-5, INEXACT)
T(RN,  0x1.d691a0969591ap+343,     0x1.ffd714406e18p-1,    0x1.6220fp-2, INEXACT)
T(RN,  0x1.5cc1fda5a19a8p+344,   -0x1.f3de41634a81bp-1,   0x1.20cfc8p-4, INEXACT)
T(RN,  0x1.cf13882e52292p+344,   -0x1.ed6dcf40a5a6cp-1,  -0x1.bde86cp-3, INEXACT)
T(RN,  0x1.5fb8f9df9f7a2p+344,   -0x1.7cb111bef9939p-1,    0x1.0d5c3p-2, INEXACT)
T(RN,  0x1.7cca6e402ae1ep+344,   -0x1.f92eb23219bf1p-1,   0x1.dc6596p-8, INEXACT)
T(RN,  0x1.3575d5dd2e1dcp+344,   -0x1.b1825031c3362p-3,  -0x1.2d9e84p-3, INEXACT)
T(RN,  0x1.65211e049dbf2p+344,    0x1.df6b4c4258904p-1,   0x1.5d7ef4p-2, INEXACT)
T(RN,   0x1.8479a98a976cp+344,    0x1.ec576927aa181p-1,  -0x1.bee3eap-2, INEXACT)
T(RN,    0x1.cceec6cd47dp+344,   -0x1.c4a38ab7aaa7fp-1,   0x1.0b43eap-2, INEXACT)
T(RN,  0x1.9e75e98088856p+344,   -0x1.1af5b888f6017p-1,   0x1.1bc8cep-5, INEXACT)
T(RN,  0x1.1799aeb91945ap+344,   -0x1.0dcc8a3a96b78p-4,   0x1.73daa4p-2, INEXACT)
T(RN,  0x1.ae8f8bcf4ddf8p+345,   -0x1.e1cf91c77e246p-1,  -0x1.cdab44p-4, INEXACT)
T(RN,  0x1.48e583385dee6p+345,    0x1.dd157b2985e97p-1,  -0x1.9075cep-4, INEXACT)
T(RN,  0x1.a5f76fcc488aap+345,    0x1.96aa5985578fap-1,  -0x1.5e721ep-3, INEXACT)
T(RN,  0x1.f5c6248933563p+345,   -0x1.4e4fed54c616bp-1,  -0x1.9e86d6p-3, INEXACT)
T(RN,  0x1.6764b00d94366p+345,    0x1.7cccbc2af8b08p-1,   0x1.38989ap-2, INEXACT)
T(RN,  0x1.2d2b4f32d6103p+345,   -0x1.881f47c646dccp-1,   0x1.7df282p-4, INEXACT)
T(RN,  0x1.f86a4427cba9ep+345,    0x1.cddb06329503ep-3,   0x1.cd8158p-2, INEXACT)
T(RN,  0x1.d4132ecad2f82p+345,   -0x1.600303b463ae8p-1,  -0x1.273602p-2, INEXACT)
T(RN,  0x1.9a2f7b19ddf28p+345,   -0x1.57384114f88f9p-1,   0x1.472c08p-2, INEXACT)
T(RN,  0x1.5f4c46286edccp+345,    0x1.d6b732bd5deb6p-6,  -0x1.8a51e4p-2, INEXACT)
T(RN,  0x1.9b0545a2d27f2p+346,    0x1.0c4b82dcaad03p-1,  -0x1.a8cd78p-3, INEXACT)
T(RN,  0x1.3599c287b83d1p+346,   -0x1.104db14610b89p-3,   0x1.95b312p-2, INEXACT)
T(RN,  0x1.9c0cddba735fcp+346,    0x1.c7b2aa864c65bp-3,   0x1.038082p-4, INEXACT)
T(RN,   0x1.d21c4fea760dp+346,    0x1.fcf1c00a060d9p-1,  -0x1.9c35d6p-2, INEXACT)
T(RN,  0x1.9de497e494307p+346,   -0x1.3d2984dbd34d5p-1,   0x1.0a7e36p-2, INEXACT)
T(RN,  0x1.d16a26315f86dp+346,    0x1.df3db6098d884p-1,   -0x1.d16d4p-5, INEXACT)
T(RN,  0x1.eb0ed9e28c3bap+346,   -0x1.f6b13b940daa2p-1,  -0x1.8c11c6p-2, INEXACT)
T(RN,  0x1.c0fd874e9bb04p+346,   -0x1.ffa5c37c834cbp-1,  -0x1.9cb652p-2, INEXACT)
T(RN,  0x1.7092dea72a3bep+346,     0x1.d30d2c60901ep-1,  -0x1.7a1a88p-3, INEXACT)
T(RN,  0x1.fe8880ffb3514p+346,    0x1.f68a047ba8d45p-1,  -0x1.d6b046p-3, INEXACT)
T(RN,  0x1.90e1b63307872p+347,   -0x1.7faa1f8557625p-1,   0x1.fe4248p-3, INEXACT)
T(RN,  0x1.73c55b38e8c79p+347,   -0x1.509d39ffb8b4ap-1,  -0x1.163698p-3, INEXACT)
T(RN,  0x1.ef4ed7378f29cp+347,   -0x1.d9c68c84bd253p-1,  -0x1.8198eep-4, INEXACT)
T(RN,  0x1.d24b3c9776251p+347,    0x1.0c2d37c77e33dp-1,   0x1.036e7ep-2, INEXACT)
T(RN,  0x1.a71fa8f575d04p+347,    0x1.ca9a9affee111p-1,  -0x1.7603c4p-2, INEXACT)
T(RN,  0x1.f0dc4867f7be2p+347,    0x1.2ba6bfdb4796bp-1,  -0x1.42367cp-3, INEXACT)
T(RN,  0x1.c3c6b6cef78dap+347,   -0x1.44a91d1cb007fp-4,   0x1.4aded2p-6, INEXACT)
T(RN,  0x1.5ee7564e08f88p+347,    0x1.8bb2edcfbb1e3p-1,  -0x1.40de0ap-2, INEXACT)
T(RN,  0x1.b72266b955b8ap+347,   -0x1.e8dd0b1479ef3p-2,  -0x1.636472p-2, INEXACT)
T(RN,  0x1.42f99d0b1ec24p+347,   -0x1.6fd05d9352aabp-1,   0x1.1248e4p-4, INEXACT)
T(RN,  0x1.d292c0484c364p+348,   -0x1.db5349c330899p-1,  -0x1.b56fe4p-3, INEXACT)
T(RN,  0x1.ff009673105e8p+348,    0x1.3ce6c762013b1p-4,   0x1.70ff66p-2, INEXACT)
T(RN,  0x1.5e0617a5b67d8p+348,   -0x1.7123d3f96e645p-3,  -0x1.da1a2ep-3, INEXACT)
T(RN,  0x1.f0be833e4f76ap+348,    0x1.f3f78427eb981p-1,  -0x1.72156cp-5, INEXACT)
T(RN,  0x1.20fceab6dd76cp+348,   -0x1.24b19a855c09dp-1,  -0x1.639864p-2, INEXACT)
T(RN,  0x1.1b9758ab003a8p+348,    0x1.fdb9744980939p-3,    -0x1.b077p-2, INEXACT)
T(RN,  0x1.bcadcd2857953p+348,    0x1.09addc50afdd7p-4,   0x1.d014eap-4, INEXACT)
T(RN,  0x1.55e2f0eb28ba8p+348,    0x1.811ea899dacb6p-1,   0x1.a3ec6cp-2, INEXACT)
T(RN,  0x1.9d8ea5c1d1adcp+348,   -0x1.d3b25d6723a1fp-1,  -0x1.641f52p-2, INEXACT)
T(RN,  0x1.c5e754f479ecfp+348,   -0x1.947d8a7a3022bp-1,  -0x1.46f826p-6, INEXACT)
T(RN,  0x1.107a12b7aede5p+349,   -0x1.ffdd40ed7e813p-1,   0x1.949c16p-4, INEXACT)
T(RN,  0x1.edcd4a99959e2p+349,   -0x1.e88db88d5788dp-1,  -0x1.d1780cp-3, INEXACT)
T(RN,  0x1.edbcbbe389b74p+349,    0x1.33411db558c11p-1,   -0x1.1ded9p-7, INEXACT)
T(RN,  0x1.ae867fb6e9774p+349,    0x1.2b54cd8f18235p-1,  -0x1.18f874p-2, INEXACT)
T(RN,   0x1.f6cabe0475ddp+349,   -0x1.ff9864435bb4cp-1,  -0x1.230876p-3, INEXACT)
T(RN,  0x1.3f4d7179fab33p+349,    0x1.df3216c758fbfp-1,   0x1.359446p-2, INEXACT)
T(RN,  0x1.aba0501e4017fp+349,   -0x1.7887144ec1d88p-1,  -0x1.5b776ap-4, INEXACT)
T(RN,  0x1.983670a3e0af4p+349,    0x1.484988ec8f6aap-1,   0x1.b848ecp-2, INEXACT)
T(RN,  0x1.d47abc07db21ap+349,    0x1.dc68c58f7ae12p-4,   0x1.d7d3ecp-5, INEXACT)
T(RN,  0x1.29c84b281cffap+349,   -0x1.f9dd4bac2dafbp-1,   -0x1.75853p-4, INEXACT)
T(RN,  0x1.950f17390d6efp+350,    0x1.d3202e68c4c2ep-1,  -0x1.7dad5ep-2, INEXACT)
T(RN,  0x1.bf06e5bd8e365p+350,    0x1.6b0dd75d0c074p-2,   0x1.5b8deap-5, INEXACT)
T(RN,  0x1.84011d5a6fe2ep+350,    0x1.fe4ca0778a722p-1,   -0x1.bd4eap-3, INEXACT)
T(RN,  0x1.e15700c90f854p+350,    0x1.e16f7787ad26bp-2,   0x1.4dbb94p-2, INEXACT)
T(RN,  0x1.9ff364f02f5b5p+350,    -0x1.43bb895161d4p-2,  -0x1.a6842cp-2, INEXACT)
T(RN,  0x1.f10dc20252f1ep+350,    0x1.b75ba38407311p-1,    0x1.b82a1p-5, INEXACT)
T(RN,  0x1.747f3571a37fap+350,   -0x1.e5be8788ca1b8p-1,  -0x1.024654p-3, INEXACT)
T(RN,  0x1.9b0f9660f8dacp+350,    0x1.92f183ab7ceebp-1,  -0x1.131f66p-7, INEXACT)
T(RN,  0x1.daeb2b829d3d7p+350,   -0x1.a171a161f13d7p-1,   0x1.a7c2d4p-2, INEXACT)
T(RN,   0x1.fbf1c83e97a5p+350,    0x1.f8f53e2dbe2d3p-1,   0x1.e2e764p-5, INEXACT)
T(RN,  0x1.94313e6492192p+351,    0x1.cab0f20767d78p-1,  -0x1.ee012cp-2, INEXACT)
T(RN,  0x1.d7c073ad9f979p+351,   -0x1.2c33c1934e527p-1,   0x1.6280b4p-3, INEXACT)
T(RN,  0x1.095265eed9934p+351,   -0x1.d11368a02ac3bp-1,  -0x1.537d0cp-2, INEXACT)
T(RN,  0x1.1b7a3a9003c34p+351,    0x1.4df88c00247cdp-1,  -0x1.bb073cp-3, INEXACT)
T(RN,  0x1.44bbb5423326ep+351,   -0x1.41b1f0954a7eep-1,  -0x1.4d2eb4p-2, INEXACT)
T(RN,  0x1.456d15dc1c6f1p+351,   -0x1.b4994d3941f3fp-1,   0x1.e09d0ep-3, INEXACT)
T(RN,  0x1.c4a37b7190c6dp+351,   -0x1.2a4453ebd2afcp-2,  -0x1.30f236p-3, INEXACT)
T(RN,   0x1.ff4db6d0df6dp+351,    0x1.bd3a551b85cc6p-1,  -0x1.0ecfaap-3, INEXACT)
T(RN,  0x1.266e9a64a8e5fp+351,   -0x1.62552fa1ec867p-1,   0x1.ef8ba4p-2, INEXACT)
T(RN,  0x1.9604cb7d99624p+351,    0x1.7eee916b7ae43p-1,   0x1.39a3fcp-4, INEXACT)
T(RN,  0x1.c4d851b829f04p+352,    0x1.6350e8c3f11b8p-1,  -0x1.e5ad94p-3, INEXACT)
T(RN,  0x1.8ccaa024a3d6cp+352,    0x1.fed02a9d61f94p-1,   0x1.be72bcp-2, INEXACT)
T(RN,   0x1.e04fbd6db6ffp+352,   -0x1.bef3e1249bd08p-1,  -0x1.d9a5c8p-2, INEXACT)
T(RN,  0x1.192becbf990aep+352,    0x1.e4f8037f0f3f6p-3,   0x1.af672ep-5, INEXACT)
T(RN,  0x1.db3a3c2ca67a5p+352,   -0x1.e883f0b68b015p-1,    0x1.82a14p-2, INEXACT)
T(RN,    0x1.43aca216962p+352,    0x1.cd163e89b3fb3p-1,  -0x1.55e0bap-2, INEXACT)
T(RN,  0x1.bda77b9e386b5p+352,   -0x1.a185eb0e6c658p-4,  -0x1.14452ep-2, INEXACT)
T(RN,  0x1.60de543b092e1p+352,    0x1.9459762200792p-1,   0x1.df8918p-5, INEXACT)
T(RN,  0x1.bb63c0a30dcf8p+352,    0x1.ed9b13cbde055p-1,  -0x1.f2d608p-3, INEXACT)
T(RN,  0x1.adac7955815d2p+352,   -0x1.a656263dd03eap-1,  -0x1.29d5bap-2, INEXACT)
T(RN,  0x1.0a88421ae003cp+353,   -0x1.fdbe01de372e4p-1,   -0x1.7ffbap-2, INEXACT)
T(RN,  0x1.95fb1e3a4704ap+353,   -0x1.b0f78612eb746p-1,   0x1.2749fep-3, INEXACT)
T(RN,  0x1.4973bdb1075edp+353,     0x1.795d9bb9e291p-5,  -0x1.265606p-2, INEXACT)
T(RN,  0x1.2137afb0d668ap+353,   -0x1.3f00560bdf1c3p-1,   0x1.336222p-2, INEXACT)
T(RN,  0x1.2e99beed76a26p+353,   -0x1.e026e49d4874cp-2,   0x1.8ce966p-4, INEXACT)
T(RN,  0x1.f5f30df6ce125p+353,    0x1.849339d00915bp-1,   0x1.a46436p-2, INEXACT)
T(RN,  0x1.ec714f6db081bp+353,   -0x1.fb57c2b05b78bp-1,  -0x1.8875e8p-3, INEXACT)
T(RN,  0x1.ac0e5dc8436e6p+353,   -0x1.5131f9c8c6402p-1,    0x1.132b5p-2, INEXACT)
T(RN,  0x1.d2b3ee29ab2d9p+353,    0x1.cc41588ee540cp-1,  -0x1.8002aap-2, INEXACT)
T(RN,  0x1.81b0ccf8982ccp+353,     0x1.744a71a5285bp-1,  -0x1.96d7fcp-3, INEXACT)
T(RN,  0x1.f3deee28fbc4ap+354,   -0x1.8094a3c11f8eep-1,    0x1.1bf47p-5, INEXACT)
T(RN,  0x1.6f462c519cd8ep+354,    0x1.49642908746bdp-2,  -0x1.5448aap-3, INEXACT)
T(RN,  0x1.a87dfd62fa567p+354,   -0x1.bf7d22bfc8009p-2,   0x1.a54d64p-2, INEXACT)
T(RN,  0x1.ccc7c46563185p+354,    0x1.ff2e3829f060ep-1,  -0x1.abc22ep-2, INEXACT)
T(RN,  0x1.9cf6acaa98cccp+354,   -0x1.ec83a57891427p-6,  -0x1.237ac8p-4, INEXACT)
T(RN,  0x1.cacf040225ee5p+354,   -0x1.fcef83a4050bap-2,  -0x1.f9e672p-2, INEXACT)
T(RN,  0x1.252f72250c9c8p+354,   -0x1.4591ef3336232p-1,   0x1.c12b08p-3, INEXACT)
T(RN,  0x1.b9009e3494a06p+354,    0x1.3f8dcb5e21a43p-1,   0x1.2be028p-2, INEXACT)
T(RN,  0x1.ec600679d03ecp+354,   -0x1.87dc5552703dap-3,   0x1.a5487ap-3, INEXACT)
T(RN,  0x1.3d14f05abc5e2p+354,   -0x1.adb02e5a06fb3p-3,   0x1.871d48p-2, INEXACT)
T(RN,  0x1.d993ba79bc688p+355,    0x1.ebe3250e5078dp-1,   0x1.05509ep-3, INEXACT)
T(RN,  0x1.e457a5aa9384ap+355,   -0x1.521885a2d76bap-2,    0x1.ccf3ap-4, INEXACT)
T(RN,  0x1.c7e04e8b34acep+355,    0x1.0215f9e94c2dap-3,   -0x1.3206dp-2, INEXACT)
T(RN,   0x1.96ecb0b73aadp+355,   -0x1.49572df395fd7p-3,   -0x1.45c2bp-3, INEXACT)
T(RN,  0x1.3ff43832f2ffap+355,     0x1.2bdfd6f6d61bp-1,   -0x1.e6efbp-3, INEXACT)
T(RN,  0x1.72c3c193f6d4ap+355,   -0x1.8f244e52362afp-1,   -0x1.8c24cp-2, INEXACT)
T(RN,  0x1.dc5b9fa89602ep+355,   -0x1.92a63ae035cc5p-1,   0x1.ecc9a4p-2, INEXACT)
T(RN,  0x1.7df5f01276ddep+355,    0x1.bd1679f958d69p-1,    0x1.58a65p-2, INEXACT)
T(RN,  0x1.082e8b7498999p+355,    0x1.691aba92b949fp-1,   -0x1.c0429p-3, INEXACT)
T(RN,  0x1.3f537f65fbd81p+355,    0x1.85bc5799d426dp-1,   0x1.f6bfd4p-2, INEXACT)
T(RN,  0x1.3932c68ffae4ap+356,   -0x1.2a683c0de4cabp-1,   0x1.ae0624p-6, INEXACT)
T(RN,  0x1.d93e9d5fa15bcp+356,   -0x1.7b860b487e2e3p-1,  -0x1.207e5ap-4, INEXACT)
T(RN,  0x1.0f823a3130497p+356,     0x1.c81ef46942aep-1,   0x1.2b09d6p-2, INEXACT)
T(RN,   0x1.5b6178feb0d8p+356,   -0x1.9ce52de3127afp-3,   0x1.6f0f18p-2, INEXACT)
T(RN,  0x1.637c023fffd42p+356,   -0x1.0706f0ff580b9p-1,  -0x1.e8fa9cp-2, INEXACT)
T(RN,  0x1.80fae7816f662p+356,    -0x1.ae3ce31b2626p-1,  -0x1.5859fap-2, INEXACT)
T(RN,  0x1.4bee7486aef22p+356,    0x1.c040447a0795dp-3,   0x1.8113e6p-2, INEXACT)
T(RN,  0x1.eecc49a1c6275p+356,     0x1.bd32a46652e4p-1,   0x1.761c54p-4, INEXACT)
T(RN,  0x1.55bb4a147ab8dp+356,   -0x1.51acc46221ff4p-1,   0x1.134cc6p-2, INEXACT)
T(RN,  0x1.71e4038ac4be5p+356,   -0x1.55213096c0d65p-1,  -0x1.28477ep-2, INEXACT)
T(RN,  0x1.78a645ce95c98p+357,   -0x1.507e6168458f1p-2,   0x1.cf1178p-2, INEXACT)
T(RN,  0x1.47ac5a0569d15p+357,    0x1.6fb1c950bb6f9p-3,   0x1.4d81aap-5, INEXACT)
T(RN,  0x1.52b54faadebb1p+357,   -0x1.b5507c776554ap-1,  -0x1.9edc9ap-3, INEXACT)
T(RN,  0x1.ebae4adde50dcp+357,   -0x1.6242a0112591ep-2,   0x1.74da04p-4, INEXACT)
T(RN,  0x1.a67c6f609b232p+357,    0x1.5d69ba10a545fp-3,   0x1.77b184p-6, INEXACT)
T(RN,  0x1.12f68a39a77cep+357,    0x1.71e24c4aebd3bp-2,   0x1.2e7782p-2, INEXACT)
T(RN,   0x1.2e88cab9de8dp+357,   -0x1.fbb52828c48bcp-1,   0x1.1ce1a8p-2, INEXACT)
T(RN,   0x1.9cb5bc4be9b3p+357,    0x1.2f23663573a44p-2,   0x1.64da1ep-4, INEXACT)
T(RN,  0x1.22b6823370401p+357,   -0x1.74a8b72e545dap-1,  -0x1.7922dcp-7, INEXACT)
T(RN,  0x1.6014a9dfe63b2p+357,   -0x1.a1957a851b401p-1,  -0x1.22f6a6p-2, INEXACT)
T(RN,  0x1.0157cec4c4201p+358,    0x1.477b3dc6959bep-2,   0x1.3d8f2cp-4, INEXACT)
T(RN,   0x1.2fa3fcdb5addp+358,   -0x1.9366fdbc65fbap-2,  -0x1.42ba78p-2, INEXACT)
T(RN,  0x1.4061a66bf4fd8p+358,   -0x1.d4c2a5d857b69p-2,   0x1.8400fap-3, INEXACT)
T(RN,  0x1.845d8b0a64501p+358,    0x1.cf104198975f1p-1,   0x1.0ae68ep-5, INEXACT)
T(RN,   0x1.9689ba00aba9p+358,   -0x1.d96aaf0fd3e4ap-1,  -0x1.d5ac8cp-3, INEXACT)
T(RN,  0x1.dd9cf93992408p+358,    0x1.e2a122209eca8p-1,   0x1.cedcfcp-3, INEXACT)
T(RN,  0x1.eaedf2ce121f6p+358,   -0x1.ef51299023f1ep-1,  -0x1.658822p-7, INEXACT)
T(RN,  0x1.5080c1274a774p+358,    0x1.359b6c760e5dap-5,   0x1.ee8676p-4, INEXACT)
T(RN,  0x1.1ce4f426532edp+358,   -0x1.f48bf76fc55dap-1,   0x1.eb4ee4p-3, INEXACT)
T(RN,  0x1.4e8e3a2c2613ep+358,    0x1.1d147ef7b79efp-5,    0x1.2df3dp-7, INEXACT)
T(RN,  0x1.3dcbd56cae801p+359,   -0x1.fde04dafedddep-1,   0x1.5cd4a6p-2, INEXACT)
T(RN,   0x1.c31c79cee0dcp+359,   -0x1.648a683ab0afcp-1,   -0x1.450bep-5, INEXACT)
T(RN,  0x1.b46e7322803ccp+359,   -0x1.47f278721f514p-1,   0x1.a0a29cp-3, INEXACT)
T(RN,   0x1.c6edaad83d65p+359,   -0x1.8e18292f2ef2dp-1,  -0x1.b37d4cp-5, INEXACT)
T(RN,  0x1.5a5b450d701eap+359,   -0x1.c390b576dace7p-1,  -0x1.dd452cp-2, INEXACT)
T(RN,  0x1.224f884ff13bap+359,   -0x1.f9d791e2b427dp-1,  -0x1.d9efaep-3, INEXACT)
T(RN,  0x1.f645b50c8cb6cp+359,    0x1.9f2775cfdaca1p-1,  -0x1.de5c36p-2, INEXACT)
T(RN,  0x1.1fbfdd319ed54p+359,    0x1.8db59f750d65dp-4,  -0x1.208cb2p-3, INEXACT)
T(RN,  0x1.c8bbecbcb8b6cp+359,    0x1.c4d7fbeaafb2ap-1,   -0x1.7fd79p-2, INEXACT)
T(RN,  0x1.ebd0471436bfcp+359,   -0x1.bd3616dd53ce1p-1,  -0x1.85adc8p-2, INEXACT)
T(RN,  0x1.5e16d0f1e41ccp+360,   -0x1.e8a20764d9db4p-1,    0x1.0e1d8p-2, INEXACT)
T(RN,  0x1.3aebe0840f845p+360,    0x1.86996ae27016ap-1,  -0x1.41115ap-4, INEXACT)
T(RN,  0x1.fd8a6281a905cp+360,   -0x1.e67cc19e2d96ap-1,   0x1.3ceff6p-2, INEXACT)
T(RN,  0x1.6283f07004a06p+360,   -0x1.7b06cbfc6831fp-1,   0x1.5c1434p-5, INEXACT)
T(RN,  0x1.dfd2d3b89617cp+360,   -0x1.99dbf8d3c0027p-1,   0x1.5aedeep-6, INEXACT)
T(RN,  0x1.0ef127127e26ap+360,    0x1.794a1494d6439p-3,   0x1.98462ep-3, INEXACT)
T(RN,  0x1.2543bc952af0cp+360,    0x1.d8743011202bep-1,  -0x1.9f400ep-3, INEXACT)
T(RN,  0x1.ed5bca0a4de66p+360,   -0x1.5a74161af00afp-2,    0x1.ebce4p-2, INEXACT)
T(RN,  0x1.d0c7d9d81c89ap+360,   -0x1.a419f286e42f1p-1,    0x1.6b36ap-3, INEXACT)
T(RN,  0x1.49ffff17d924ep+360,    0x1.a012c90703df2p-1,  -0x1.4011a4p-3, INEXACT)
T(RN,  0x1.1ae5b2962343fp+361,    0x1.bb242388d35c7p-2,  -0x1.8c0934p-7, INEXACT)
T(RN,  0x1.2ba5dc7ea5d39p+361,   -0x1.d3618de28ece4p-4,   0x1.9b6694p-3, INEXACT)
T(RN,  0x1.13e507133f68fp+361,   -0x1.9aa4e714b198dp-2,   0x1.dbac92p-3, INEXACT)
T(RN,  0x1.5a7c72c6d0d72p+361,   -0x1.760921104606ep-1,   0x1.7b382ep-4, INEXACT)
T(RN,  0x1.a4ea429759c1cp+361,    0x1.fd86f88bd424ep-1,   0x1.d96874p-2, INEXACT)
T(RN,  0x1.eaac6b0e0724cp+361,    0x1.ff0b21ce761cfp-1,   0x1.41c8c6p-2, INEXACT)
T(RN,  0x1.818a8be838131p+361,    0x1.2ed369c7c65fdp-2,   -0x1.2c837p-2, INEXACT)
T(RN,  0x1.240044aff97c3p+361,   -0x1.c6aba6cef951cp-2,  -0x1.20b986p-2, INEXACT)
T(RN,  0x1.f5436243ba094p+361,    0x1.72ea56ef41e34p-1,   0x1.84e2ecp-2, INEXACT)
T(RN,  0x1.dd4688925ca1dp+361,   -0x1.f595d435105dcp-1,   0x1.415eb8p-3, INEXACT)
T(RN,  0x1.bef8f7effd044p+362,   -0x1.9dc0f6764afdbp-1,  -0x1.46d95ap-2, INEXACT)
T(RN,  0x1.f15cdffdc69c6p+362,   -0x1.d3bc3ac2829c8p-1,  -0x1.813fe2p-3, INEXACT)
T(RN,  0x1.bf9930d290c3dp+362,    0x1.828d5d8471ed8p-1,   0x1.0cd448p-3, INEXACT)
T(RN,  0x1.0a2b2076d09c1p+362,    -0x1.0bbe6cedc53dp-1,   0x1.6db7d6p-3, INEXACT)
T(RN,  0x1.b2a205eb754c1p+362,    0x1.2224bce11b27cp-1,  -0x1.118a9cp-3, INEXACT)
T(RN,  0x1.adaa6f7e660b9p+362,   -0x1.085cefcc8f92dp-3,   0x1.f79da4p-3, INEXACT)
T(RN,  0x1.84a8fe3f072fep+362,   -0x1.a9aba1f7f41d4p-1,   0x1.4e91b8p-4, INEXACT)
T(RN,   0x1.f0d79812a071p+362,    0x1.3a60eafb5ad63p-1,  -0x1.3f9088p-5, INEXACT)
T(RN,  0x1.8fe6c95f1e35ap+362,    0x1.12d01f0322b1dp-3,    0x1.147e2p-2, INEXACT)
T(RN,  0x1.1724686a2faddp+362,   -0x1.93bb022679d7ap-1,  -0x1.656c5ep-5, INEXACT)
T(RN,  0x1.99e3c70e13487p+363,    -0x1.c0c290c846edp-1,  -0x1.def0b2p-4, INEXACT)
T(RN,  0x1.f4524007d9acap+363,    0x1.60ecdffc287eep-3,   0x1.01dbf8p-2, INEXACT)
T(RN,  0x1.039b09039489ep+363,    0x1.849d12dada0b1p-1,  -0x1.578644p-4, INEXACT)
T(RN,  0x1.c1c6cf620e667p+363,    0x1.19f2471f36406p-1,   0x1.5cda1ap-2, INEXACT)
T(RN,  0x1.1175ba9b6355bp+363,    0x1.ff277b724c366p-1,  -0x1.50b432p-2, INEXACT)
T(RN,  0x1.7a7281e3c8858p+363,   -0x1.40292c38426d8p-3,  -0x1.4b424ap-4, INEXACT)
T(RN,  0x1.5455f065cecbbp+363,   -0x1.9ab4bfceee144p-2,   0x1.cfef06p-2, INEXACT)
T(RN,  0x1.c8f819d8e5126p+363,   -0x1.4fc488ab35853p-5,   -0x1.c655fp-2, INEXACT)
T(RN,   0x1.5b39854d61f8p+363,    0x1.ecbe7b825fd24p-2,   0x1.3110a2p-3, INEXACT)
T(RN,  0x1.241bba9192537p+363,   -0x1.ed9793509418ap-1,   0x1.c1889ep-2, INEXACT)
T(RN,  0x1.0075650790918p+364,   -0x1.54a5ba13c61cep-1,   -0x1.318c2p-2, INEXACT)
T(RN,  0x1.1c8cb19b8dddcp+364,   -0x1.d413a8282a60ep-2,   -0x1.ebe1ep-2, INEXACT)
T(RN,  0x1.ab1351c5b8503p+364,    -0x1.4478183cb65ap-1,   -0x1.42689p-4, INEXACT)
T(RN,  0x1.6e13ccda6c9acp+364,   -0x1.ff50a69156defp-1,   0x1.e63f1ap-2, INEXACT)
T(RN,  0x1.12f898ac8f0c6p+364,    0x1.31b603084992bp-1,   0x1.d058e6p-3, INEXACT)
T(RN,  0x1.b58b647a5dffcp+364,   -0x1.21276e4ee6d41p-4,   0x1.b279a2p-2, INEXACT)
T(RN,  0x1.dd4a2030049d5p+364,   -0x1.cc5684b183d2fp-1,   0x1.cc3b8ap-2, INEXACT)
T(RN,   0x1.aadb2208bd23p+364,    0x1.98edaf652dd1fp-1,   0x1.341e56p-4, INEXACT)
T(RN,  0x1.04b07869c342dp+364,    0x1.2265db5d0c7d1p-2,   0x1.7ee922p-2, INEXACT)
T(RN,  0x1.eb28ad6c7f644p+364,    0x1.e6e7bb1e20922p-1,  -0x1.ecc3bap-2, INEXACT)
T(RN,  0x1.60db273ab3d4dp+365,   -0x1.ed63e3a2f267ep-3,  -0x1.352a98p-2, INEXACT)
T(RN,  0x1.ead9152669283p+365,    0x1.f7d97120b81f9p-2,   0x1.5f0158p-2, INEXACT)
T(RN,  0x1.f65937497372ep+365,    0x1.b87c71f834a52p-1,   0x1.b1c2b4p-3, INEXACT)
T(RN,  0x1.20c36e80783cfp+365,   -0x1.f771338bbc8ccp-1,   0x1.1b2912p-3, INEXACT)
T(RN,  0x1.5ce5127fa37ebp+365,     0x1.626fb6e07c14p-1,  -0x1.b68b9cp-2, INEXACT)
T(RN,  0x1.cea68c444c64bp+365,    0x1.09410629a7e72p-1,   -0x1.cdb01p-3, INEXACT)
T(RN,   0x1.6b6fcffa4e13p+365,   -0x1.ff6a887df45fep-1,   -0x1.da3e8p-2, INEXACT)
T(RN,  0x1.af27e6843e722p+365,   -0x1.e42bc539312e7p-1,   0x1.fbd064p-2, INEXACT)
T(RN,  0x1.5d068db19e274p+365,    0x1.ec9b1056404f7p-1,   0x1.dd0ddap-2, INEXACT)
T(RN,  0x1.652aa9e766f6cp+365,    0x1.ffee3e292bd5ap-1,  -0x1.0620a2p-4, INEXACT)
T(RN,  0x1.f74ef4c597e22p+366,   -0x1.042bfe5415de1p-2,  -0x1.a26708p-5, INEXACT)
T(RN,  0x1.28f1fb76ffe82p+366,   -0x1.c3b331cea87bap-1,   -0x1.0b069p-3, INEXACT)
T(RN,  0x1.9c9b8b5c0f79bp+366,    0x1.a236bb27923f5p-1,   0x1.9951ecp-4, INEXACT)
T(RN,  0x1.6ae515225a05cp+366,    -0x1.f8c7b66c88abp-1,   -0x1.a6e89p-3, INEXACT)
T(RN,  0x1.19ae2bb6d5028p+366,   -0x1.bc1498474ced5p-1,  -0x1.c1a62cp-2, INEXACT)
T(RN,  0x1.43abde0b2fdc6p+366,   -0x1.e7307da45c7dbp-1,  -0x1.66b1f6p-2, INEXACT)
T(RN,  0x1.8b60b33759ebep+366,   -0x1.6a22afea67c32p-1,   -0x1.31618p-3, INEXACT)
T(RN,  0x1.0b04dfc556ed3p+366,    0x1.b0244526c229dp-2,    0x1.9740bp-4, INEXACT)
T(RN,  0x1.8cb593c907627p+366,   -0x1.7abe00ca1394fp-4,   0x1.d77044p-3, INEXACT)
T(RN,  0x1.7a3945f2917d6p+366,    0x1.9f6ef142a55cfp-1,   0x1.fd7e8ap-2, INEXACT)
T(RN,  0x1.a61f28163291cp+367,    0x1.448d4fbf609efp-1,   0x1.dfcc68p-2, INEXACT)
T(RN,  0x1.25f5a5c316574p+367,    0x1.ad83ebf839593p-3,   0x1.bfe82ep-3, INEXACT)
T(RN,  0x1.8fa4175029784p+367,   -0x1.f313085339e26p-1,  -0x1.fb258ap-3, INEXACT)
T(RN,  0x1.fba255bcd941ep+367,    0x1.dc90fc104461dp-5,   0x1.4b3ae4p-3, INEXACT)
T(RN,  0x1.336a066ffc70dp+367,   -0x1.2e206b01f5855p-6,  -0x1.3848acp-2, INEXACT)
T(RN,  0x1.09e167ecc23d9p+367,    -0x1.7777ad35246ap-1,  -0x1.bdd3bap-4, INEXACT)
T(RN,  0x1.c9da3cd5333f2p+367,   -0x1.836aae3823606p-2,   -0x1.1d268p-3, INEXACT)
T(RN,  0x1.5c2bae79b9502p+367,    0x1.21329781cd5b8p-2,   0x1.c2ae3ep-3, INEXACT)
T(RN,  0x1.414109cd21385p+367,    0x1.6967027d1f377p-4,  -0x1.1d8f26p-2, INEXACT)
T(RN,  0x1.d0d317cbdad87p+367,    0x1.9d96e07d5b501p-1,   0x1.268d76p-4, INEXACT)
T(RN,  0x1.2c31fc36f1df7p+368,   -0x1.9c51ed4465b13p-3,   0x1.9b6ec8p-2, INEXACT)
T(RN,  0x1.04efc12b07e4dp+368,    0x1.feb042b418373p-1,   -0x1.f4725p-4, INEXACT)
T(RN,  0x1.26a91a1babb4ap+368,   -0x1.3893eb1e46147p-2,   0x1.b9851cp-4, INEXACT)
T(RN,  0x1.974402928f148p+368,    0x1.dc1256390dad4p-1,   0x1.142a3ap-3, INEXACT)
T(RN,  0x1.a5aa57e21a90ep+368,    0x1.5c169df28a03ap-3,   -0x1.8dfd5p-2, INEXACT)
T(RN,  0x1.2f93bbb7e7c24p+368,     0x1.ffdac10af468p-1,   0x1.cff446p-3, INEXACT)
T(RN,  0x1.15103dacd830fp+368,   -0x1.a45e6cc9a67aep-1,    0x1.a3d3ep-6, INEXACT)
T(RN,    0x1.19eab0e1247p+368,    0x1.294990f784fa9p-2,  -0x1.70d71ap-5, INEXACT)
T(RN,  0x1.c99ee9cb75c44p+368,     0x1.b6be814dd00ep-1,  -0x1.3d056cp-2, INEXACT)
T(RN,  0x1.24ba9b07423ebp+368,    0x1.8e947d4cb9382p-1,   0x1.eaedc6p-4, INEXACT)
T(RN,  0x1.c0d8db6c75167p+369,   -0x1.ca638a51bbf67p-4,   0x1.b9f9aap-5, INEXACT)
T(RN,  0x1.089d42ef28c8ap+369,   -0x1.cfbbf0f143d09p-1,  -0x1.e6f96cp-3, INEXACT)
T(RN,   0x1.a55db7baab95p+369,   -0x1.ba878b3c39f78p-2,   0x1.669866p-5, INEXACT)
T(RN,  0x1.880caad65b4f4p+369,   -0x1.05d75e7f0f072p-3,   0x1.b1384cp-2, INEXACT)
T(RN,  0x1.7f77a6b2989fcp+369,    0x1.bf992c881b0d5p-2,  -0x1.006a3cp-3, INEXACT)
T(RN,  0x1.f777c52d37fc2p+369,    0x1.e7e37320e0c97p-1,   0x1.efdd74p-4, INEXACT)
T(RN,  0x1.a0ec88b425d92p+369,    0x1.01c6107238c6dp-1,  -0x1.332928p-3, INEXACT)
T(RN,  0x1.d8777ec1e6da2p+369,   -0x1.d8315b6d9f77ap-1,   0x1.80cf9ap-3, INEXACT)
T(RN,  0x1.fc8f4dcd7f8b2p+369,    0x1.cc02ffbe6168ap-4,  -0x1.9a4622p-2, INEXACT)
T(RN,  0x1.fb9dcf73a9baap+369,    0x1.8bf4bf7e29292p-1,  -0x1.c8ca28p-3, INEXACT)
T(RN,  0x1.0a529d0759632p+370,   -0x1.1a0389e55d28ap-1,  -0x1.9d1712p-2, INEXACT)
T(RN,  0x1.d37544ec51a46p+370,    0x1.335268458e825p-1,  -0x1.0fb77ap-3, INEXACT)
T(RN,  0x1.19094428d7464p+370,    0x1.9ce3380f5606dp-2,   0x1.d25bb6p-2, INEXACT)
T(RN,   0x1.f76aeb3d8c96p+370,   -0x1.8c18ab1df6e12p-2,  -0x1.160944p-7, INEXACT)
T(RN,  0x1.5512d30a79ae9p+370,    0x1.280f5a88607f7p-2,   0x1.e42f5ep-2, INEXACT)
T(RN,  0x1.3be1fa002ab84p+370,   -0x1.0123cb243b6d7p-1,    0x1.38272p-7, INEXACT)
T(RN,  0x1.1d5c2bb36c57ap+370,   -0x1.0176a03c89e53p-3,    0x1.64cdfp-2, INEXACT)
T(RN,  0x1.e2bf28923a92bp+370,    0x1.057d98d511baep-1,  -0x1.4e5648p-3, INEXACT)
T(RN,  0x1.0113b6cb830edp+370,   -0x1.ed68ecea05288p-4,   0x1.8fae52p-2, INEXACT)
T(RN,  0x1.b857f0f4f466ep+370,   -0x1.7085aafcab2b6p-2,  -0x1.a38b16p-2, INEXACT)
T(RN,  0x1.a87702895e15dp+371,    0x1.a12ad301ca955p-4,   0x1.82942ap-2, INEXACT)
T(RN,   0x1.027da52abcbfp+371,   -0x1.17b52619bdcb6p-2,   0x1.6b17c4p-2, INEXACT)
T(RN,  0x1.8e0ce86b272fcp+371,   -0x1.44d1409c4d7dcp-1,   0x1.19f27cp-2, INEXACT)
T(RN,  0x1.8a8aca7bb884ep+371,   -0x1.ced8abccc29fdp-1,    0x1.23cd2p-2, INEXACT)
T(RN,  0x1.2cf8d273d93e8p+371,    0x1.eab175d4ec823p-3,   0x1.3317d2p-4, INEXACT)
T(RN,  0x1.0547a62fe78c7p+371,    0x1.2756e1f158474p-4,   0x1.1a835ep-6, INEXACT)
T(RN,  0x1.b21cc63ff27d6p+371,    0x1.879febc8d26dcp-1,   0x1.623a8ep-2, INEXACT)
T(RN,  0x1.8015920909757p+371,    0x1.8a6be2f8c43a7p-4,  -0x1.0cb788p-2, INEXACT)
T(RN,  0x1.79099fc4ca298p+371,    0x1.72bae0e35735ap-3,   0x1.10f6f6p-5, INEXACT)
T(RN,  0x1.c36c45e6b11f6p+371,   -0x1.3d162e78a39dep-1,   0x1.065b18p-4, INEXACT)
T(RN,  0x1.2c3a711ff8355p+372,     0x1.84d15c11ff18p-3,   0x1.a45258p-2, INEXACT)
T(RN,  0x1.3039a4fc972a3p+372,    0x1.ca68cd7993fedp-3,  -0x1.19c2d4p-2, INEXACT)
T(RN,  0x1.a35d772bab772p+372,    0x1.f8db1c3cb6f6ep-1,  -0x1.7fbfa2p-4, INEXACT)
T(RN,  0x1.23bf4212174fcp+372,   -0x1.6bd3e11814437p-1,   0x1.cb411cp-2, INEXACT)
T(RN,  0x1.487ced42f2c9bp+372,   -0x1.b148a4b6fc001p-1,  -0x1.9b51e4p-2, INEXACT)
T(RN,  0x1.d27b1e53b6065p+372,    0x1.10ef7e3efb012p-1,   0x1.db0e22p-5, INEXACT)
T(RN,  0x1.ef33762b0c5bcp+372,    0x1.81eb4f3172d6dp-4,    0x1.7ed3dp-3, INEXACT)
T(RN,   0x1.cc7c2606a4fep+372,    0x1.a02e05ee3cc85p-1,  -0x1.1785e8p-6, INEXACT)
T(RN,  0x1.3796f537056b9p+372,   -0x1.e107233d5c31fp-2,   0x1.93378cp-2, INEXACT)
T(RN,  0x1.37d66d22385dcp+372,   -0x1.289985f1353b4p-3,  -0x1.48d592p-4, INEXACT)
T(RN,   0x1.7f640914e55ep+373,    0x1.dba9746bf08f1p-1,   0x1.960c3cp-2, INEXACT)
T(RN,  0x1.ef6ec3cb06a1ep+373,   -0x1.9a78c4b52165bp-1,  -0x1.2c2cc4p-3, INEXACT)
T(RN,  0x1.02951183acfe8p+373,    0x1.64537e8ed1052p-1,  -0x1.3228a4p-6, INEXACT)
T(RN,  0x1.901a8b07d9ff2p+373,   -0x1.7a301bdd60b65p-1,   0x1.29aed4p-2, INEXACT)
T(RN,  0x1.5da58ef3ddb68p+373,    0x1.c1a1caa784af4p-1,  -0x1.e7506ep-3, INEXACT)
T(RN,  0x1.2e02b0cfeecb9p+373,    0x1.0d27625c850e4p-1,   0x1.ecb1f6p-2, INEXACT)
T(RN,    0x1.3728a673dd3p+373,   -0x1.82ec6a56b9decp-2,  -0x1.d49f9cp-2, INEXACT)
T(RN,  0x1.ec9bdb3ddcc78p+373,    0x1.b5541ce79e9bfp-1,   0x1.75c7dap-3, INEXACT)
T(RN,  0x1.95caf2694720ap+373,    -0x1.7b5952e144d1p-6,   0x1.543a36p-2, INEXACT)
T(RN,  0x1.ee551d982bafcp+373,    0x1.7a2001b9d3831p-1,  -0x1.515162p-2, INEXACT)
T(RN,   0x1.c4730707c035p+374,   -0x1.5737724b19562p-1,   0x1.b087f8p-2, INEXACT)
T(RN,  0x1.919c28a514a6bp+374,   -0x1.dda7909532d97p-3,  -0x1.64a4c2p-2, INEXACT)
T(RN,  0x1.468ff5b35c426p+374,     0x1.ea5200359373p-1,  -0x1.601a48p-4, INEXACT)
T(RN,  0x1.608352fb17d47p+374,    0x1.080ca7eb11b3ap-3,   0x1.526796p-2, INEXACT)
T(RN,  0x1.63b26fdeba30cp+374,   -0x1.a1b51d74ba147p-2,   0x1.75e998p-3, INEXACT)
T(RN,  0x1.76eeebc0dae46p+374,    0x1.057edcaff660bp-3,  -0x1.a14c88p-4, INEXACT)
T(RN,  0x1.963e40f04a948p+374,   -0x1.04be9971dbc2fp-1,   -0x1.9e298p-2, INEXACT)
T(RN,  0x1.81ce7d83280ccp+374,   -0x1.f25c19cca158bp-1,  -0x1.c2c9c8p-3, INEXACT)
T(RN,  0x1.916a1bdf2e494p+374,    0x1.292fb03630c06p-1,  -0x1.2d8d1ep-2, INEXACT)
T(RN,  0x1.7019675353803p+374,    0x1.10588967c7e63p-2,   0x1.856682p-4, INEXACT)
T(RN,  0x1.d6a3473859bcep+375,    0x1.380939e8a2e8dp-1,  -0x1.540186p-2, INEXACT)
T(RN,  0x1.e3c1ae60d03a4p+375,   -0x1.2c718175d51eap-2,   0x1.1dd1bcp-2, INEXACT)
T(RN,  0x1.5097901522a5ap+375,    0x1.e213ed233e75bp-1,  -0x1.29a05ap-4, INEXACT)
T(RN,  0x1.f6887a30ab23fp+375,   -0x1.f4bde9e449a76p-2,  -0x1.f3930ep-2, INEXACT)
T(RN,  0x1.401b87a9764dbp+375,   -0x1.dd4c4d32f81cdp-2,   0x1.601014p-2, INEXACT)
T(RN,  0x1.8805f93788a14p+375,   -0x1.331943191f2c1p-1,   -0x1.a0087p-3, INEXACT)
T(RN,    0x1.c7e9ff665ebp+375,   -0x1.6b8e7d4647314p-1,   0x1.234584p-2, INEXACT)
T(RN,  0x1.134865265b035p+375,    0x1.2cb771e251c3ap-7,  -0x1.33c87cp-2, INEXACT)
T(RN,  0x1.2d70834ba0338p+375,   -0x1.46d1226aaee24p-1,   0x1.b4b982p-2, INEXACT)
T(RN,   0x1.b893aa6e3373p+375,    0x1.254b73788291bp-1,   0x1.676946p-3, INEXACT)
T(RN,  0x1.fa2d389f3675ap+376,    0x1.94a2f5c6dbbbfp-1,   0x1.625644p-4, INEXACT)
T(RN,  0x1.7f698847296ecp+376,    0x1.b26b2c692b9d5p-1,  -0x1.b60612p-2, INEXACT)
T(RN,  0x1.5866f6104d0fep+376,    0x1.e77979b0246cap-1,  -0x1.b9a89cp-2, INEXACT)
T(RN,  0x1.ce393406538acp+376,   -0x1.e573d79e5b4c6p-1,   0x1.946f52p-2, INEXACT)
T(RN,  0x1.5f791a98f550dp+376,    0x1.e0f822ddea03dp-1,   0x1.cfc308p-2, INEXACT)
T(RN,  0x1.1abb2c5db82e6p+376,    0x1.ff92b3c7c5863p-1,   -0x1.75ab1p-2, INEXACT)
T(RN,  0x1.435875e9e944ap+376,   -0x1.01c7c1c3f5807p-4,  -0x1.d6a0e8p-2, INEXACT)
T(RN,  0x1.269b840241871p+376,    0x1.5deeb758d2816p-1,   -0x1.97fecp-5, INEXACT)
T(RN,  0x1.1b28f43ccb58bp+376,   -0x1.efeb41a77b963p-1,  -0x1.4800b2p-2, INEXACT)
T(RN,  0x1.6befe511d67c4p+376,   -0x1.9e65c6e85adaap-1,   0x1.199a0ep-2, INEXACT)
T(RN,  0x1.898330442f80cp+377,    0x1.fe5e3c86b3fdep-1,  -0x1.039c4ep-2, INEXACT)
T(RN,  0x1.8fdf8db659d0fp+377,    0x1.6e9a4320d82aep-1,  -0x1.4a4e46p-3, INEXACT)
T(RN,  0x1.3c302e41df4f4p+377,    0x1.aab01e9688ab3p-2,   -0x1.35031p-3, INEXACT)
T(RN,  0x1.2c858564c54c8p+377,   -0x1.e7acc7eeea338p-1,   0x1.6f772ep-5, INEXACT)
T(RN,  0x1.722eaf522756cp+377,   -0x1.fc0ec7ecaa82cp-4,    0x1.a87bfp-3, INEXACT)
T(RN,  0x1.9fcf4e497cc26p+377,    0x1.eb76a7f611929p-1,   0x1.313f54p-3, INEXACT)
T(RN,  0x1.af5d988733ccdp+377,   -0x1.cc1aa4dd13c54p-2,  -0x1.e648fcp-3, INEXACT)
T(RN,  0x1.22dda24e076f6p+377,   -0x1.b9a475d59d876p-1,    0x1.61873p-3, INEXACT)
T(RN,  0x1.6931a598a4142p+377,    0x1.91ee857d007c3p-8,   0x1.de083ap-2, INEXACT)
T(RN,  0x1.6964ce9c1232cp+377,   -0x1.7f30f05167466p-1,  -0x1.e5a79ap-2, INEXACT)
T(RN,  0x1.88c06897b83acp+378,   -0x1.d24ec33803284p-3,   0x1.23eba8p-2, INEXACT)
T(RN,  0x1.99eb0ffa42b7fp+378,    0x1.fffe693750f1ap-1,    0x1.10562p-7, INEXACT)
T(RN,  0x1.d2ad3f58b9014p+378,    0x1.f89eb45b1e2e6p-1,   0x1.08952ep-2, INEXACT)
T(RN,  0x1.cadb3ffabf676p+378,    0x1.f380afaa8e9c4p-3,  -0x1.45d914p-3, INEXACT)
T(RN,  0x1.48866014d5843p+378,    -0x1.d0d8b6afb634p-1,   0x1.142deap-2, INEXACT)
T(RN,  0x1.3eedff9be678ap+378,    0x1.580728b3204b8p-1,  -0x1.96c56cp-3, INEXACT)
T(RN,  0x1.306626bcbe47ep+378,   -0x1.18181a8e26876p-2,   0x1.2b2e84p-4, INEXACT)
T(RN,  0x1.0ddea4a373f38p+378,    0x1.feab4987d47cep-1,  -0x1.3b5464p-2, INEXACT)
T(RN,  0x1.bbf5340986a44p+378,   -0x1.91e2bc993ba4ep-1,   -0x1.c8a7dp-3, INEXACT)
T(RN,  0x1.fc7b3e04ce7bbp+378,   -0x1.1e4471d96d7a1p-1,   0x1.c9aeb8p-2, INEXACT)
T(RN,   0x1.d64d6994b109p+379,    0x1.feff6d5927a8ap-1,   0x1.9190f2p-2, INEXACT)
T(RN,  0x1.dd80819b4800ep+379,    -0x1.fea3a2adb712p-1,   0x1.101b28p-2, INEXACT)
T(RN,  0x1.9dae1f8052cd2p+379,   -0x1.e50ef27a245cbp-2,  -0x1.eba146p-2, INEXACT)
T(RN,    0x1.d8b2f3ce266p+379,    0x1.b4654beb98c96p-1,  -0x1.d04efcp-2, INEXACT)
T(RN,   0x1.3cc46e80e564p+379,    0x1.ec0ec138d8e78p-1,    0x1.ceb35p-3, INEXACT)
T(RN,  0x1.333621cec966bp+379,   -0x1.c6ad3f04212a4p-1,  -0x1.540e02p-2, INEXACT)
T(RN,  0x1.ba5d206c8d0cfp+379,    0x1.909db3f699337p-2,  -0x1.93ec22p-2, INEXACT)
T(RN,  0x1.50bbc8f654d4bp+379,    0x1.b8593774cd0afp-5,   0x1.c6b5e4p-2, INEXACT)
T(RN,  0x1.410b0cd375c4ap+379,   -0x1.21134a228502dp-2,   0x1.07d176p-3, INEXACT)
T(RN,  0x1.f7c278024b5d3p+379,   -0x1.dc323cd8fb7bap-1,  -0x1.84a632p-2, INEXACT)
T(RN,  0x1.c9e4a5005283fp+380,   -0x1.fac9114d4ab57p-1,    0x1.2f31ep-5, INEXACT)
T(RN,  0x1.078a455785c0bp+380,    0x1.5943a6e691959p-1,  -0x1.90b0e8p-4, INEXACT)
T(RN,  0x1.1c84c37e9da6ap+380,   -0x1.0036cb5181642p-1,   0x1.403d28p-2, INEXACT)
T(RN,   0x1.a25b2eb464e7p+380,    0x1.3f06e9fb89eedp-3,   0x1.2f8342p-2, INEXACT)
T(RN,  0x1.e3eb5d38ae2b2p+380,    0x1.716f72433ab29p-1,  -0x1.25f412p-3, INEXACT)
T(RN,  0x1.01a8f2d77d37dp+380,    0x1.ae4998d6a50c8p-1,    0x1.0e542p-3, INEXACT)
T(RN,  0x1.ff9bda0b5341ep+380,      0x1.a59c53ebd4fp-4,  -0x1.20a432p-2, INEXACT)
T(RN,  0x1.313a00e97959dp+380,    0x1.d883580eb9f15p-1,  -0x1.50df82p-2, INEXACT)
T(RN,  0x1.64d5afa7c47b8p+380,   -0x1.c080a587d67cfp-1,  -0x1.20643ep-7, INEXACT)
T(RN,  0x1.2b69be6dd0824p+380,    -0x1.3c882b96398ap-1,   -0x1.c493bp-3, INEXACT)
T(RN,  0x1.a8577a597f2adp+381,    0x1.fa1588b96675ep-1,   -0x1.adf53p-5, INEXACT)
T(RN,  0x1.ebf296f2dce76p+381,    0x1.bd17c3d1faed3p-2,  -0x1.5e91f4p-2, INEXACT)
T(RN,  0x1.2b2582c420428p+381,   -0x1.a15c697330b2ap-2,   0x1.44c3fap-5, INEXACT)
T(RN,  0x1.27ef94b90d5e2p+381,   -0x1.0ba82805090f2p-3,   0x1.a32574p-2, INEXACT)
T(RN,  0x1.550f2f5759693p+381,    0x1.02d188eb0f188p-4,   0x1.5712f8p-2, INEXACT)
T(RN,  0x1.4ce67a5b30b81p+381,   -0x1.4bc59087f339cp-4,  -0x1.46c248p-4, INEXACT)
T(RN,  0x1.8ce1b28986559p+381,     0x1.e5189bf7e065p-2,    0x1.d4c59p-2, INEXACT)
T(RN,  0x1.cb4bba5787ce2p+381,    -0x1.cd20a8c615bep-1,  -0x1.9d6316p-2, INEXACT)
T(RN,  0x1.223d64dba6eb2p+381,    0x1.62858d5639a9cp-1,  -0x1.8c7666p-3, INEXACT)
T(RN,  0x1.4f4322ec6509ep+381,   -0x1.b131b6f303101p-3,  -0x1.ff09cap-2, INEXACT)
T(RN,  0x1.a4ed025e79c59p+382,    0x1.6f042658645f2p-1,   0x1.c0e656p-2, INEXACT)
T(RN,  0x1.9f344fae33144p+382,   -0x1.fa073f5ec64a9p-1,   0x1.ae3a52p-2, INEXACT)
T(RN,   0x1.eddaeb9085c5p+382,    0x1.547e35d8c5134p-1,   0x1.72f9f6p-2, INEXACT)
T(RN,   0x1.6cac5a594d9ep+382,    0x1.0b4d82e74710bp-4,   0x1.9889ecp-5, INEXACT)
T(RN,  0x1.e055d3e158582p+382,    0x1.e2208f82ea6f9p-7,  -0x1.cd1754p-2, INEXACT)
T(RN,  0x1.a8e328bec3efap+382,   -0x1.b22163107e0dep-1,  -0x1.d9514ap-2, INEXACT)
T(RN,  0x1.bfed4f07da79ap+382,   -0x1.dc7595f134a9dp-1,  -0x1.77e334p-2, INEXACT)
T(RN,  0x1.9da22b8490d98p+382,   -0x1.f65b457161c16p-1,   0x1.9868b4p-4, INEXACT)
T(RN,  0x1.c7d22e87d7614p+382,   -0x1.7e96b208a60dep-1,  -0x1.2cbd32p-2, INEXACT)
T(RN,  0x1.f768096feab42p+382,   -0x1.d846f91623c1fp-1,  -0x1.bdc642p-4, INEXACT)
T(RN,    0x1.97d11532332p+383,   -0x1.6fc3689537567p-1,  -0x1.986b2ep-4, INEXACT)
T(RN,  0x1.d500443c2f51cp+383,     0x1.277adfc2b2dcp-1,   0x1.17ce7ap-4, INEXACT)
T(RN,  0x1.69f73707cb411p+383,   -0x1.f8080e835ed4bp-1,    0x1.b2bb7p-3, INEXACT)
T(RN,  0x1.1670939bd5a32p+383,   -0x1.cf29eedd96bdfp-1,  -0x1.b796f6p-3, INEXACT)
T(RN,  0x1.798708085dbc6p+383,   -0x1.983e58cda6068p-2,  -0x1.63130cp-2, INEXACT)
T(RN,  0x1.ee1bc59e2f808p+383,   -0x1.d63c34669a9a8p-3,   0x1.f3d7dcp-4, INEXACT)
T(RN,  0x1.0f16f589e545ep+383,   -0x1.862480f46491ep-1,  -0x1.b52afap-2, INEXACT)
T(RN,  0x1.d7becd0c2a122p+383,    0x1.23228f180e22dp-4,   0x1.59d1bep-8, INEXACT)
T(RN,  0x1.9ce4792b02ac7p+383,    0x1.fd08c252514e1p-1,   0x1.29f972p-3, INEXACT)
T(RN,  0x1.1faf1c43c6eb3p+383,    0x1.efcae3b5ef71ap-1,   0x1.18a256p-2, INEXACT)
T(RN,  0x1.7ca4c35d342bap+384,    0x1.ffffeee288c71p-1,   0x1.d392d8p-2, INEXACT)
T(RN,  0x1.8c0f712cdbf8ep+384,   -0x1.c8a85bab16808p-1,  -0x1.e6615ep-2, INEXACT)
T(RN,  0x1.dd2c334c1a81ep+384,    0x1.da7aed926dd6cp-1,  -0x1.db045cp-3, INEXACT)
T(RN,  0x1.fdd5e61f9395ep+384,    0x1.3ad6c2a9beb5ap-1,   0x1.360864p-2, INEXACT)
T(RN,  0x1.c1073e637fc88p+384,    0x1.8d21a12b4e9cfp-2,  -0x1.adbe2ap-3, INEXACT)
T(RN,   0x1.ee7c1064bfaep+384,   -0x1.ef3adc9ee4bc3p-3,  -0x1.51e592p-4, INEXACT)
T(RN,  0x1.c1f1a60cf1ffbp+384,    0x1.91c6614e549a3p-3,  -0x1.2b5d5cp-4, INEXACT)
T(RN,   0x1.0e64ac762ee1p+384,    0x1.d20e0b6b0eee6p-1,  -0x1.ec770cp-2, INEXACT)
T(RN,  0x1.1ce9d2eda0de3p+384,    0x1.0aad1e715f32cp-2,  -0x1.2c2926p-4, INEXACT)
T(RN,  0x1.8e576382ac934p+384,    0x1.79b40b095ce4ap-2,    0x1.e0ae5p-2, INEXACT)
T(RN,  0x1.a5376912e41fcp+385,   -0x1.8369b9b988458p-1,   0x1.a7c03cp-6, INEXACT)
T(RN,  0x1.b4a677c15fa8cp+385,    0x1.fd7d2a33b7eccp-1,   0x1.df169ap-2, INEXACT)
T(RN,  0x1.254d74320911ep+385,   -0x1.e14e747ad78ddp-1,    0x1.2618bp-2, INEXACT)
T(RN,  0x1.6b7315918f434p+385,   -0x1.2433c7d9018b7p-1,    0x1.89df9p-3, INEXACT)
T(RN,  0x1.8600ee5655133p+385,    0x1.3ef23ca2a5c2dp-1,  -0x1.89a71ep-4, INEXACT)
T(RN,  0x1.29128159bd962p+385,   -0x1.c826ebe8ff03bp-1,  -0x1.5312fep-3, INEXACT)
T(RN,  0x1.f42b493972af3p+385,    0x1.8fb14e835ed99p-2,   0x1.42b71cp-2, INEXACT)
T(RN,   0x1.0515563af3b6p+385,    0x1.b177a576852a5p-1,  -0x1.ad7c36p-2, INEXACT)
T(RN,  0x1.ca6b71c269b4ep+385,   -0x1.38e803ea0519ep-2,   0x1.634ca2p-6, INEXACT)
T(RN,  0x1.9af4e8349d226p+385,    0x1.1053bee163c85p-1,  -0x1.fb64e8p-3, INEXACT)
T(RN,  0x1.0306e9b11cb1cp+386,    0x1.efd5375f0ae77p-1,    0x1.4e3c3p-3, INEXACT)
T(RN,  0x1.c387bd6637cdep+386,   -0x1.9aa0a8f141dbfp-1,  -0x1.d86b88p-2, INEXACT)
T(RN,  0x1.37cb60b44de0cp+386,   -0x1.1455f4127aeaep-1,   0x1.397a5ep-6, INEXACT)
T(RN,  0x1.a9e5550b46d67p+386,    0x1.b9e055dac7d3bp-2,   -0x1.4dffbp-2, INEXACT)
T(RN,  0x1.f87cbdb44f112p+386,   -0x1.c0c667a5a6268p-3,   -0x1.fdef5p-8, INEXACT)
T(RN,  0x1.91354bd04f4b8p+386,   -0x1.28bf47f663aecp-1,   0x1.747528p-2, INEXACT)
T(RN,  0x1.e434b29f15f34p+386,    0x1.b89c7392d3712p-1,   0x1.6a8924p-2, INEXACT)
T(RN,  0x1.d0f8c7c6985c4p+386,   -0x1.f395e3dd684d9p-1,    0x1.4456cp-6, INEXACT)
T(RN,  0x1.d6db824ad59fep+386,    0x1.514207674bff4p-1,   0x1.f5c1f2p-3, INEXACT)
T(RN,  0x1.501857dfe9885p+386,    0x1.c1399e42a1b08p-1,  -0x1.26aa3ap-2, INEXACT)
T(RN,  0x1.54ddf8ce0cff4p+387,    0x1.6a842eab828cfp-1,    0x1.96614p-3, INEXACT)
T(RN,  0x1.ad61109a68d99p+387,   -0x1.bf28a855c99bdp-2,  -0x1.658224p-2, INEXACT)
T(RN,  0x1.b2dedada44df2p+387,   -0x1.fb18cfe09809bp-1,   0x1.21de7ap-8, INEXACT)
T(RN,  0x1.481da3911b62fp+387,   -0x1.2c98737f0cd3fp-1,   0x1.451f24p-2, INEXACT)
T(RN,  0x1.618e653fab53cp+387,    0x1.379b12d2b92bep-1,   0x1.cc0848p-2, INEXACT)
T(RN,  0x1.e48a54c75aaeep+387,    0x1.93b50c4569e9fp-1,    0x1.c9401p-8, INEXACT)
T(RN,  0x1.c7f8d2abdec4fp+387,    0x1.943dd3c454f6cp-2,   0x1.86a726p-2, INEXACT)
T(RN,  0x1.e0ba8cce271f3p+387,    0x1.cbb259e4223cfp-1,  -0x1.46a188p-2, INEXACT)
T(RN,  0x1.7eafdf4c45b11p+387,    0x1.096a75255660cp-1,  -0x1.c948fep-3, INEXACT)
T(RN,   0x1.b94709d3b418p+387,   -0x1.fc1dd431f9787p-1,  -0x1.cc9ee6p-5, INEXACT)
T(RN,  0x1.fc6dc10c4a179p+388,   -0x1.968e5f8bc8837p-2,   0x1.fed862p-2, INEXACT)
T(RN,  0x1.60a41a0cf9709p+388,     0x1.c308c8f0c947p-1,  -0x1.c3c44ap-6, INEXACT)
T(RN,  0x1.cbf9ab9c04b44p+388,    0x1.ff4049073cf62p-3,  -0x1.5a3b6cp-3, INEXACT)
T(RN,  0x1.bfe63e99309bcp+388,    -0x1.f4df19956429p-1,   0x1.7d434ep-2, INEXACT)
T(RN,  0x1.cdc3e4ffcbd9dp+388,   -0x1.b1ed3463b9c76p-7,    0x1.f94aap-3, INEXACT)
T(RN,  0x1.489106eb34f68p+388,    0x1.c74a92196e74dp-1,  -0x1.d58bcep-3, INEXACT)
T(RN,  0x1.fa53b8e2d0c5bp+388,    0x1.d9c7df312a8bdp-1,  -0x1.867e9ep-3, INEXACT)
T(RN,  0x1.5f88a88c44d83p+388,   -0x1.4525cf97474bbp-4,   0x1.fa56e8p-2, INEXACT)
T(RN,  0x1.181877ad33dc9p+388,    0x1.f919748e67797p-1,   0x1.959a58p-4, INEXACT)
T(RN,  0x1.33bd2b90338b2p+388,    0x1.5bf97e554c038p-2,   0x1.fa67a6p-3, INEXACT)
T(RN,  0x1.5d779c81e354ap+389,    0x1.cc12f87e75691p-2,  -0x1.fbb5b8p-3, INEXACT)
T(RN,  0x1.64f3d8b30b03ep+389,   -0x1.fff54fa74d50bp-1,  -0x1.5ad128p-5, INEXACT)
T(RN,  0x1.e7d0fbe29dd43p+389,   -0x1.c03250b4c00a8p-3,   0x1.406032p-5, INEXACT)
T(RN,  0x1.e4ebf842cb883p+389,    -0x1.e89461e0ed96p-1,   0x1.098044p-2, INEXACT)
T(RN,  0x1.d34588d26b19ap+389,    0x1.0bde3cd577618p-1,   0x1.ddb26ep-2, INEXACT)
T(RN,  0x1.da9101f1359cap+389,    0x1.fa3016dde81bcp-1,   0x1.7026eap-2, INEXACT)
T(RN,   0x1.db907b4e0847p+389,    -0x1.77b8c60c298cp-2,   -0x1.4b9edp-2, INEXACT)
T(RN,  0x1.62ee53df31081p+389,    0x1.8591b38f18874p-1,  -0x1.d59764p-3, INEXACT)
T(RN,  0x1.29b354498f361p+389,    -0x1.37c0078a5853p-2,  -0x1.c05a38p-2, INEXACT)
T(RN,  0x1.347b650bd4113p+389,   -0x1.f17e3277ac18ep-1,  -0x1.2de286p-3, INEXACT)
T(RN,  0x1.284db741d7a7ap+390,   -0x1.f84120487c395p-1,    0x1.b156ep-3, INEXACT)
T(RN,  0x1.7a49f04f66d7dp+390,    0x1.eb4278fd24078p-2,   0x1.00216ap-2, INEXACT)
T(RN,  0x1.ec6cc73696a59p+390,    0x1.354e5ad068183p-3,   0x1.d96792p-2, INEXACT)
T(RN,  0x1.827849ac3206ep+390,   -0x1.0bfaecb5c4805p-2,   0x1.f04398p-2, INEXACT)
T(RN,  0x1.1ef2c886d717ep+390,   -0x1.a3b626163eabcp-3,     0x1.b69cp-2, INEXACT)
T(RN,  0x1.2e6c2d793af6dp+390,    0x1.fffe59ccf12edp-1,   0x1.6d6be8p-5, INEXACT)
T(RN,  0x1.45cf2366e6253p+390,   -0x1.664220e97ddacp-1,   0x1.436006p-9, INEXACT)
T(RN,  0x1.eb23472b2337ep+390,    0x1.8fe42bc01aef5p-4,   0x1.bed9a8p-2, INEXACT)
T(RN,  0x1.fe4864fdb338ep+390,   -0x1.ec8c89b2266cap-1,  -0x1.0ca3d2p-3, INEXACT)
T(RN,  0x1.1f3f4549d38fdp+390,    0x1.5ee049e040864p-5,   0x1.d46d66p-2, INEXACT)
T(RN,   0x1.ccd46c27420bp+391,    0x1.5d3f0c4db510bp-3,   0x1.62fe5cp-2, INEXACT)
T(RN,  0x1.dbf2058a94a7dp+391,   -0x1.4a3196544f5fcp-3,   0x1.51c6c4p-2, INEXACT)
T(RN,  0x1.67c199fc1546bp+391,    0x1.fe2cd1bc302a1p-1,   0x1.b7f506p-2, INEXACT)
T(RN,  0x1.023af6ed9d1bcp+391,    0x1.fff5db06a189cp-1,   0x1.f00c3ep-2, INEXACT)
T(RN,  0x1.7390d554c8d58p+391,    0x1.6ef338a126493p-3,  -0x1.52732cp-3, INEXACT)
T(RN,  0x1.767a99813c506p+391,   -0x1.716c20dff46f3p-1,   0x1.6a4d22p-4, INEXACT)
T(RN,   0x1.c0299434f88dp+391,    0x1.9d2cbd2dfc448p-1,  -0x1.1c8744p-2, INEXACT)
T(RN,  0x1.13376a2b0f133p+391,    0x1.f3b91e4f953d9p-2,  -0x1.1555dep-2, INEXACT)
T(RN,  0x1.d26ad61692a9ap+391,   -0x1.fc62d5292cd05p-1,   0x1.8045dap-2, INEXACT)
T(RN,   0x1.c20fe5e93849p+391,     0x1.11fa6b2205a2p-1,  -0x1.5650dep-3, INEXACT)
T(RN,  0x1.d0a5dd31cfc13p+392,   -0x1.c8faa0c7fc817p-1,   0x1.e74074p-3, INEXACT)
T(RN,   0x1.9248e5b916c3p+392,    0x1.54400a3dbfc2dp-1,  -0x1.ab5f26p-3, INEXACT)
T(RN,  0x1.952f74a3919e8p+392,   -0x1.83d190666a05cp-1,   0x1.2cb93ap-3, INEXACT)
T(RN,  0x1.0c40f12da4fccp+392,    0x1.5bd3b906343ecp-1,   -0x1.ae522p-4, INEXACT)
T(RN,  0x1.9eddf52804eedp+392,   -0x1.95c2fdb061b0ep-1,  -0x1.f070aep-3, INEXACT)
T(RN,  0x1.c792c32417b8ep+392,    0x1.4a542c06ef4d9p-3,   0x1.116428p-3, INEXACT)
T(RN,  0x1.b310fe1f2e964p+392,   -0x1.35c5b6af42c23p-1,  -0x1.e3a3f4p-3, INEXACT)
T(RN,  0x1.24591ea61a3dep+392,   -0x1.dc93d46d99a57p-1,  -0x1.d87382p-2, INEXACT)
T(RN,  0x1.bf9353ea6924ap+392,   -0x1.87368cc9bf9c5p-1,   0x1.579dd6p-4, INEXACT)
T(RN,  0x1.892a9dc2ec3bap+392,    0x1.9eb36a290f568p-1,   0x1.036904p-2, INEXACT)
T(RN,  0x1.d7e2e588c80d8p+393,   -0x1.12e6a7c4c32ffp-1,   0x1.5119ecp-2, INEXACT)
T(RN,  0x1.df0d25f6ad02ap+393,    0x1.59f3bf709bf2dp-1,  -0x1.6978b4p-2, INEXACT)
T(RN,  0x1.5aa1e4da45949p+393,    0x1.daacc4611a671p-1,  -0x1.394668p-3, INEXACT)
T(RN,  0x1.3fbee7e9b41c3p+393,     0x1.6693d8a83aedp-3,   -0x1.f59ccp-2, INEXACT)
T(RN,  0x1.c5fc9471d820ep+393,    0x1.4d90542ee5052p-1,   0x1.ae5d8ep-2, INEXACT)
T(RN,  0x1.83ad7769df774p+393,    0x1.a2a267a703a4cp-1,  -0x1.db53dap-3, INEXACT)
T(RN,  0x1.6cb7dd9c01895p+393,    0x1.f3926634d086dp-2,  -0x1.488618p-2, INEXACT)
T(RN,  0x1.d44e13df635cap+393,    0x1.b9f70d9335cc3p-5,  -0x1.1271d4p-2, INEXACT)
T(RN,  0x1.b56d93293e387p+393,   -0x1.a3fed43e3bf2ep-1,   0x1.6cad72p-4, INEXACT)
T(RN,  0x1.3762610186469p+393,   -0x1.ff5119c323d52p-1,  -0x1.eef902p-6, INEXACT)
T(RN,  0x1.bb4af4918bab5p+394,    0x1.10c6cd084fa77p-1,    0x1.f233ep-6, INEXACT)
T(RN,  0x1.516b88468c966p+394,   -0x1.b119091ca9f9ap-1,   0x1.7c9846p-5, INEXACT)
T(RN,  0x1.553d8542f69bbp+394,   -0x1.fcb15ecc78822p-1,  -0x1.40ba52p-3, INEXACT)
T(RN,  0x1.2f78192844b55p+394,    0x1.573eb372fa761p-1,    0x1.72f66p-2, INEXACT)
T(RN,  0x1.fe68e4c8b553ep+394,    -0x1.ff69d0dfd3b6p-1,   -0x1.71ce3p-2, INEXACT)
T(RN,  0x1.753f030b8973fp+394,    0x1.08963766ad833p-3,  -0x1.8f0668p-5, INEXACT)
T(RN,  0x1.cd89008134e0ep+394,   -0x1.635e2d65ab949p-2,  -0x1.c8e6e2p-2, INEXACT)
T(RN,  0x1.2d796505e06e9p+394,   -0x1.fac935cec2846p-1,   0x1.da7f64p-2, INEXACT)
T(RN,  0x1.ffc5aa6fb86acp+394,   -0x1.27d93ffe04a07p-1,  -0x1.665578p-3, INEXACT)
T(RN,  0x1.eadaba13f1cd6p+394,    0x1.35012e28a7cbap-2,   0x1.f4b002p-4, INEXACT)
T(RN,  0x1.62575888d64cdp+395,    0x1.fc63f7399234cp-1,  -0x1.384994p-2, INEXACT)
T(RN,  0x1.6fae848fbd1c2p+395,    0x1.ffa2270ccbb88p-1,  -0x1.a31ba6p-2, INEXACT)
T(RN,  0x1.6c2682467a6c4p+395,   -0x1.0f42d7461ca9ap-2,  -0x1.e3bc7ap-2, INEXACT)
T(RN,  0x1.8bab4f9d693f9p+395,    0x1.c91bed32b35dfp-1,   0x1.57afd8p-2, INEXACT)
T(RN,  0x1.2e3c299e7a44fp+395,    0x1.ecfe4272302b2p-1,   0x1.4c8ddep-2, INEXACT)
T(RN,  0x1.f4f01afd02782p+395,    0x1.ed8395f3029b2p-1,  -0x1.1aefccp-2, INEXACT)
T(RN,  0x1.80ee464147602p+395,    0x1.ef531abaaee26p-1,   0x1.93efd6p-3, INEXACT)
T(RN,  0x1.0e9e49b721069p+395,    0x1.293b3cf4ee9f3p-2,   0x1.0195d6p-3, INEXACT)
T(RN,  0x1.e40a1a2977b49p+395,   -0x1.3ff0d3838b8bep-3,   0x1.15efdep-2, INEXACT)
T(RN,  0x1.e3fdf14807d4cp+395,   -0x1.f7df062a7fe1fp-1,   0x1.bc47b2p-3, INEXACT)
T(RN,  0x1.c58c59044cec1p+396,   -0x1.f46e3eba9f9bbp-1,   0x1.ca8186p-2, INEXACT)
T(RN,   0x1.ba1a3f3da98fp+396,    0x1.ed73468c86886p-1,   -0x1.9c5dap-2, INEXACT)
T(RN,  0x1.292f176eb1b48p+396,    0x1.1ddceeb3fafa1p-3,   -0x1.6732ep-2, INEXACT)
T(RN,  0x1.494657aae3f22p+396,   -0x1.98ccebac5bf4dp-2,  -0x1.26d722p-2, INEXACT)
T(RN,  0x1.7c2bd3816c035p+396,   -0x1.4fa5fc66c9db2p-1,  -0x1.772a5cp-2, INEXACT)
T(RN,  0x1.86e8126a6f8e8p+396,   -0x1.41b45d61576ffp-2,  -0x1.48a48cp-2, INEXACT)
T(RN,  0x1.729aa6859d1f4p+396,   -0x1.fdbe5085494aep-1,   0x1.ff91fep-2, INEXACT)
T(RN,  0x1.513c0a87e9bb9p+396,    0x1.ee43ed28f59d7p-1,  -0x1.837d42p-3, INEXACT)
T(RN,  0x1.26ce575d71a55p+396,    0x1.d40b8257bd13cp-1,   0x1.53b7d4p-3, INEXACT)
T(RN,  0x1.248cf5b9e57c4p+396,    0x1.194bf673a1dd5p-2,   0x1.9a614ep-2, INEXACT)
T(RN,  0x1.0b9ddcd1284c8p+397,   -0x1.16bc4fc084c1dp-1,  -0x1.00e7a6p-5, INEXACT)
T(RN,  0x1.ca789402e8f13p+397,   -0x1.e717f9dd7b613p-1,   0x1.5f20a2p-3, INEXACT)
T(RN,   0x1.f95a5061de44p+397,   -0x1.d40fd30bbda98p-1,  -0x1.877952p-3, INEXACT)
T(RN,  0x1.667e18874f327p+397,   -0x1.c5698297e8ca9p-2,   0x1.e85582p-3, INEXACT)
T(RN,  0x1.07aeddc0870dap+397,   -0x1.febb0e3f4f73dp-1,   -0x1.4f858p-3, INEXACT)
T(RN,  0x1.7f7be8b6c6dfap+397,    0x1.95ce4724b2b75p-2,   0x1.56f7c4p-3, INEXACT)
T(RN,  0x1.0f185ad838715p+397,    0x1.ff326f7185243p-1,   0x1.018426p-3, INEXACT)
T(RN,   0x1.336c00dbc4eep+397,   -0x1.bbb771221eefap-1,  -0x1.3c6dc8p-2, INEXACT)
T(RN,  0x1.8bc12224541afp+397,    0x1.019cdd59213f2p-1,   -0x1.69482p-2, INEXACT)
T(RN,  0x1.c724e641f089ep+397,   -0x1.fe29587d1f47ap-1,   0x1.4e5f46p-5, INEXACT)
T(RN,  0x1.851611e0029eap+398,   -0x1.d56f4286e698ap-1,   0x1.7e50eep-2, INEXACT)
T(RN,  0x1.eb35aeb271012p+398,   -0x1.27e5e463aa49ep-5,   0x1.5f9166p-2, INEXACT)
T(RN,  0x1.b6cb6e001847ep+398,   -0x1.3bdef74d44788p-1,  -0x1.df8254p-2, INEXACT)
T(RN,  0x1.f4140fd44633ep+398,   -0x1.7c9dba32a84bcp-2,   0x1.b9e928p-2, INEXACT)
T(RN,  0x1.1018d557c3455p+398,   -0x1.c8e3633f2ddb6p-1,  -0x1.2aeedcp-3, INEXACT)
T(RN,  0x1.fcb02d3c4f898p+398,   -0x1.f006dd6410912p-1,   -0x1.432b6p-5, INEXACT)
T(RN,  0x1.6a2fc2f0bb44ep+398,   -0x1.e6579a3a93bf9p-3,    0x1.cd5f8p-3, INEXACT)
T(RN,  0x1.977731e3b667cp+398,   -0x1.fd15843bad728p-1,    0x1.978dbp-5, INEXACT)
T(RN,  0x1.c6a3ca97ed05ap+398,    0x1.9e8c84aea8e92p-1,  -0x1.c64958p-2, INEXACT)
T(RN,  0x1.67644d4fe926bp+398,   -0x1.ff51bbf9d8e82p-1,   0x1.accc5cp-4, INEXACT)
T(RN,  0x1.13d8bd0943ee4p+399,   -0x1.4d38c26d31ad3p-2,   -0x1.a620cp-3, INEXACT)
T(RN,  0x1.3389ed9db0873p+399,   -0x1.6a1a04c094a5bp-2,  -0x1.6a7a66p-2, INEXACT)
T(RN,  0x1.38bda6416683ep+399,    0x1.f39efc380c51bp-1,   0x1.1ad218p-2, INEXACT)
T(RN,   0x1.ce51b878fa0ap+399,    0x1.a567814b391c9p-1,   0x1.ec8ee6p-2, INEXACT)
T(RN,  0x1.a95bfd41bf388p+399,   -0x1.afe9ab27d86c6p-1,   0x1.fdc496p-3, INEXACT)
T(RN,  0x1.be114ad7e5543p+399,    0x1.bc277ad37b5e9p-1,   0x1.4ec7fap-2, INEXACT)
T(RN,  0x1.84b155ed55caap+399,    0x1.df82ab4e2070dp-1,  -0x1.e6a3bcp-2, INEXACT)
T(RN,   0x1.14adbc8920bbp+399,    0x1.060a8653f1b68p-3,     0x1.8c34p-4, INEXACT)
T(RN,   0x1.d5ba6d6d7322p+399,   -0x1.d07f3738172a7p-1,  -0x1.87302ap-3, INEXACT)
T(RN,  0x1.29f89521ca2e5p+399,    0x1.be5ac5b3873dbp-4,  -0x1.96dcb4p-2, INEXACT)
T(RN,   0x1.f7de7d419a17p+400,   -0x1.121adf2282689p-1,   0x1.4792a2p-3, INEXACT)
T(RN,  0x1.f9cfbe7b08fc2p+400,   -0x1.c2f6ac488aba3p-1,  -0x1.19426cp-2, INEXACT)
T(RN,  0x1.855e2cc236abcp+400,    0x1.dffcfd7983f19p-1,   0x1.d4b6fep-2, INEXACT)
T(RN,   0x1.69e800daa1f4p+400,   -0x1.fd38bc84eb3ffp-1,   0x1.f1613cp-4, INEXACT)
T(RN,  0x1.2f95da441a846p+400,    0x1.fca887b5234b9p-1,  -0x1.9ec068p-2, INEXACT)
T(RN,   0x1.a033c4053e27p+400,    0x1.4fb7c51b97f1bp-1,   0x1.f6eee2p-2, INEXACT)
T(RN,  0x1.73ef05aef7ef4p+400,    0x1.b18bc5d272e8cp-1,  -0x1.8a9eb8p-2, INEXACT)
T(RN,  0x1.9f4088aaee103p+400,    0x1.494151a795286p-2,   0x1.be9b3ep-2, INEXACT)
T(RN,  0x1.10792e4db423ap+400,   -0x1.ff8c1624702dcp-1,    0x1.5fe94p-2, INEXACT)
T(RN,  0x1.b33960cd9ef83p+400,   -0x1.ff44638a70352p-1,   0x1.296d4cp-3, INEXACT)
T(RN,  0x1.803012f761491p+401,    0x1.d8adf6248d9bap-1,   -0x1.c9415p-2, INEXACT)
T(RN,  0x1.455ed9bdfac66p+401,    0x1.623d8654d65a1p-1,  -0x1.c86108p-2, INEXACT)
T(RN,  0x1.1df4ed71d7ba3p+401,   -0x1.91e1ac60671b9p-2,   -0x1.50524p-5, INEXACT)
T(RN,  0x1.11580d02b2633p+401,    -0x1.7df9856ec3dap-1,   0x1.aea6dep-2, INEXACT)
T(RN,  0x1.dda8a9904be82p+401,    0x1.e182a55fd70bap-1,   0x1.b2ed82p-2, INEXACT)
T(RN,  0x1.ea75b050aee56p+401,   -0x1.35a0d753afbedp-5,  -0x1.3f3f2ep-2, INEXACT)
T(RN,   0x1.77cf72993dbbp+401,    0x1.c9600f3069d01p-1,   0x1.fbcd76p-2, INEXACT)
T(RN,  0x1.2d7e6fed3e8e3p+401,   -0x1.0acaa7f0a4ec1p-1,  -0x1.d743fcp-4, INEXACT)
T(RN,  0x1.4aeafb76c53dap+401,   -0x1.ffeb3843af399p-1,  -0x1.b2fbc8p-3, INEXACT)
T(RN,  0x1.60e62a6306732p+401,    0x1.8f2cd9b4e80c1p-1,   0x1.ab6c06p-4, INEXACT)
T(RN,  0x1.bdf7113a6c917p+402,   -0x1.0355cce9cc531p-1,   0x1.4e446ap-7, INEXACT)
T(RN,  0x1.caa62a58edc8cp+402,   -0x1.a545216cfee9dp-6,  -0x1.b3882ep-4, INEXACT)
T(RN,  0x1.aac9f8e97764dp+402,   -0x1.f07bb6a70fc97p-1,  -0x1.b5a01cp-2, INEXACT)
T(RN,  0x1.9dd58f4f6ad5ap+402,    0x1.ea4d7628784dcp-1,  -0x1.04c0dcp-3, INEXACT)
T(RN,   0x1.f640c2fe1789p+402,    0x1.f8c221fbf1b39p-1,  -0x1.e1ccb6p-5, INEXACT)
T(RN,  0x1.daf9d4cff4abcp+402,   -0x1.572b6935646c9p-2,  -0x1.68a79ep-2, INEXACT)
T(RN,  0x1.beabc74ae4c7cp+402,     0x1.433ad25fc077p-2,   0x1.4eebacp-3, INEXACT)
T(RN,  0x1.24d2dfc2b451cp+402,   -0x1.4c192f230bb1bp-2,   -0x1.691bdp-2, INEXACT)
T(RN,  0x1.fa64a94293d76p+402,   -0x1.75ba0845d8cb4p-2,  -0x1.ee4dccp-2, INEXACT)
T(RN,  0x1.b7cab1f142e6dp+402,    0x1.d2d273d0d504ap-2,  -0x1.8dd8aep-6, INEXACT)
T(RN,  0x1.6dbeb97fe412cp+403,    0x1.75df19749eb23p-1,  -0x1.b316c2p-5, INEXACT)
T(RN,  0x1.4097f2c624f99p+403,   -0x1.ff7db63ad4382p-1,   0x1.32737ep-4, INEXACT)
T(RN,  0x1.71c974710c0d1p+403,    0x1.1469abeca1119p-2,   0x1.9d519cp-2, INEXACT)
T(RN,   0x1.a8aec9f0ed03p+403,    0x1.e8b9175bf3b59p-1,   0x1.50871ep-3, INEXACT)
T(RN,  0x1.511f39658cd1bp+403,   -0x1.b11610fafe3b8p-2,  -0x1.cecea2p-2, INEXACT)
T(RN,  0x1.c28e5b90fa614p+403,   -0x1.8ab088e58efcfp-1,   0x1.bbf4a2p-4, INEXACT)
T(RN,  0x1.4076c3acd3b1bp+403,    0x1.0b70565842a05p-1,  -0x1.9e3accp-2, INEXACT)
T(RN,  0x1.eec93de5fb2e8p+403,    0x1.ffd93684d864dp-1,  -0x1.56708ep-2, INEXACT)
T(RN,  0x1.8db8b97099d2cp+403,   -0x1.a11730b60829dp-5,  -0x1.d73d0cp-2, INEXACT)
T(RN,  0x1.f2bb7df8111c6p+403,   -0x1.a7e4da7a86f2ep-2,  -0x1.640396p-5, INEXACT)
T(RN,  0x1.ae6165e99556ep+404,    0x1.199f2f2b01155p-1,  -0x1.c48b4ep-2, INEXACT)
T(RN,  0x1.72a4b7529199ep+404,   -0x1.b7a90640156e7p-1,  -0x1.dee456p-5, INEXACT)
T(RN,  0x1.e6277f8129485p+404,   -0x1.88ceaeae123cep-2,  -0x1.53bb8cp-4, INEXACT)
T(RN,  0x1.c1ff22d178abcp+404,     0x1.ff30b01b87f6p-1,   -0x1.58e63p-3, INEXACT)
T(RN,  0x1.8400a6a7a4f6cp+404,   -0x1.f995fa066ab0ep-1,  -0x1.de5106p-6, INEXACT)
T(RN,  0x1.c2e62ca0ba2c6p+404,   -0x1.d58724112c77bp-1,   0x1.435da6p-3, INEXACT)
T(RN,  0x1.c6cc2dd257438p+404,    0x1.ee98af7c0aa9ep-1,   0x1.660124p-2, INEXACT)
T(RN,  0x1.c35f276207f44p+404,   -0x1.bbeb6adaf27aep-1,  -0x1.4c5c2cp-2, INEXACT)
T(RN,  0x1.cebeef3c6ae1ep+404,    0x1.4b5b376ae6255p-1,   -0x1.5a95cp-3, INEXACT)
T(RN,   0x1.acbcbf2bd51ep+404,    0x1.cbb33d969c2e5p-1,   0x1.0560c2p-3, INEXACT)
T(RN,  0x1.8d290b0e4142cp+405,    -0x1.c859287d67bap-1,  -0x1.bc2f9cp-2, INEXACT)
T(RN,  0x1.182585c495846p+405,    0x1.a04513b07a783p-4,  -0x1.0bf2eep-4, INEXACT)
T(RN,  0x1.8cf6fc686ff33p+405,   -0x1.86b58046878f3p-4,  -0x1.adc9eep-2, INEXACT)
T(RN,  0x1.4133e3aacd957p+405,    0x1.cbabea9289057p-2,  -0x1.84c1fap-6, INEXACT)
T(RN,  0x1.716ed05f04391p+405,    0x1.226c5a1ae8084p-2,  -0x1.cc61b8p-7, INEXACT)
T(RN,  0x1.68e2ea6adac5cp+405,   -0x1.bdd43598508e5p-1,   0x1.599a0cp-3, INEXACT)
T(RN,  0x1.37a17fa6a3d64p+405,   -0x1.847b0d0aee7e4p-2,  -0x1.1add66p-2, INEXACT)
T(RN,  0x1.ebf3885e4591fp+405,   -0x1.99f6932cd5f61p-1,  -0x1.70af5ap-4, INEXACT)
T(RN,  0x1.690f4568b52ecp+405,   -0x1.ffe4dbec25c46p-1,    0x1.77833p-2, INEXACT)
T(RN,  0x1.9826d44b32d58p+405,   -0x1.f424ca26fa711p-1,    0x1.ee822p-4, INEXACT)
T(RN,   0x1.d36c4fa4ecfdp+406,   -0x1.fbe3224ba20bbp-1,  -0x1.5e28b2p-2, INEXACT)
T(RN,  0x1.ccc8723bc2c34p+406,   -0x1.a9ce2526d7277p-1,   0x1.87c95ap-2, INEXACT)
T(RN,   0x1.c98b81cd6846p+406,    0x1.cfe76dd6619a2p-1,  -0x1.dcb2fep-2, INEXACT)
T(RN,  0x1.2a721de0dd494p+406,   -0x1.1f02ab4fe1856p-1,   0x1.9c626cp-5, INEXACT)
T(RN,  0x1.244688ead35a3p+406,    0x1.c888516f60c54p-1,  -0x1.6c9076p-2, INEXACT)
T(RN,  0x1.fb36f4c0cc6c8p+406,   -0x1.ef7acfeaf81dep-1,  -0x1.e96ceap-2, INEXACT)
T(RN,  0x1.a88359fcc2f08p+406,   -0x1.3e2850ca25e1cp-1,  -0x1.5ac692p-3, INEXACT)
T(RN,  0x1.2ce0add8fe5abp+406,    0x1.ec377964a3d6dp-1,   -0x1.0771dp-2, INEXACT)
T(RN,  0x1.d3edd9661c19dp+406,   -0x1.6650ad60d68f7p-1,  -0x1.5d0992p-6, INEXACT)
T(RN,  0x1.06c124945984ap+406,    0x1.37fa7cc5987a6p-1,   0x1.4e2d5cp-3, INEXACT)
T(RN,  0x1.85b6eecd640b2p+407,   -0x1.0a1acd1c0dd78p-1,  -0x1.eadf48p-4, INEXACT)
T(RN,  0x1.2e15b0709063ap+407,    0x1.510dd55ee6578p-2,  -0x1.5aeb0ep-4, INEXACT)
T(RN,  0x1.16ad5643727d5p+407,    0x1.24d5d4f25468fp-5,   0x1.0ee0d2p-3, INEXACT)
T(RN,  0x1.0f4a3bc80b1fap+407,   -0x1.dfbe0ade6fa52p-1,  -0x1.70c8d6p-2, INEXACT)
T(RN,  0x1.fe9960fc2e6f4p+407,    0x1.b8c3f9f54414ap-1,  -0x1.1a1666p-5, INEXACT)
T(RN,  0x1.e4efd98f37ffcp+407,   -0x1.dfeb56624da5cp-1,  -0x1.117b7ap-3, INEXACT)
T(RN,  0x1.d20d23d0db958p+407,   -0x1.00da99ed7fb99p-2,  -0x1.de3232p-3, INEXACT)
T(RN,  0x1.b99f68933ca22p+407,    0x1.ccd264503cda2p-1,   -0x1.bf337p-2, INEXACT)
T(RN,  0x1.a724756f910a2p+407,   -0x1.e3f95cf308f42p-1,  -0x1.88aedap-3, INEXACT)
T(RN,   0x1.2bff222c0cd9p+407,   -0x1.eaa9a441b2fa5p-1,   0x1.aeb712p-2, INEXACT)
T(RN,  0x1.f9c98b86a7bf6p+408,    0x1.e6222c63d7ee1p-1,  -0x1.51e1b4p-3, INEXACT)
T(RN,  0x1.ee4c6d73be92ep+408,    0x1.0d5745be89662p-1,  -0x1.a4c07cp-2, INEXACT)
T(RN,   0x1.89f86a5da236p+408,    0x1.b944f5f817f64p-1,  -0x1.190b38p-2, INEXACT)
T(RN,  0x1.a169c86780fb2p+408,    0x1.e66a9a2050a67p-1,  -0x1.fde224p-2, INEXACT)
T(RN,  0x1.f8bfea0fe649cp+408,    0x1.91c1044460944p-1,   0x1.5307d6p-5, INEXACT)
T(RN,  0x1.cc09612397ba4p+408,    0x1.f5b1384aec156p-2,  -0x1.72b924p-2, INEXACT)
T(RN,  0x1.c76a00c3da10cp+408,    0x1.70037c7c2a741p-2,  -0x1.e7976ap-2, INEXACT)
T(RN,  0x1.3eaf77b22c11ep+408,   -0x1.995315f6fe887p-1,   0x1.33f5a6p-3, INEXACT)
T(RN,  0x1.26657b5b1939bp+408,    0x1.4714bf115487ep-3,  -0x1.ad4638p-2, INEXACT)
T(RN,  0x1.3f19a99385018p+408,   -0x1.fd79188cd17cep-1,   0x1.84114ap-2, INEXACT)
T(RN,  0x1.63856b1c52684p+409,    0x1.ccded5a8bcf37p-1,   0x1.c0125ep-2, INEXACT)
T(RN,   0x1.ead4b56588e1p+409,    0x1.8c5dd2db3e9a1p-1,   0x1.3491ecp-4, INEXACT)
T(RN,  0x1.d7238cebc03b9p+409,   -0x1.c6d9da0627ddfp-1,   0x1.db7ea8p-4, INEXACT)
T(RN,  0x1.ca94413214afap+409,   -0x1.e2a696d6188b7p-3,  -0x1.f7f45cp-9, INEXACT)
T(RN,  0x1.12bb190d3c73fp+409,    0x1.dbd19d8236d27p-1,   0x1.e6d08ep-3, INEXACT)
T(RN,  0x1.ef5205fdd0991p+409,    0x1.e31a305008cb3p-1,   0x1.6d67bep-2, INEXACT)
T(RN,  0x1.a34a5122b937cp+409,    0x1.a3d4069d5807fp-1,  -0x1.8c0e3ep-4, INEXACT)
T(RN,  0x1.3a6107bb6bb7ap+409,    0x1.b2c3cdaa3e427p-2,   0x1.0a1926p-5, INEXACT)
T(RN,  0x1.60630311fbf78p+409,    0x1.85667c374c492p-2,   -0x1.44a48p-2, INEXACT)
T(RN,  0x1.19fa49eff7387p+409,   -0x1.9c103d66c6519p-3,   0x1.502624p-2, INEXACT)
T(RN,  0x1.c9d5706117c1ep+410,    0x1.d259589eb29fap-4,  -0x1.4561b4p-4, INEXACT)
T(RN,  0x1.21159927ac593p+410,    0x1.b8fbca7e4ac04p-3,   0x1.5cc6f8p-2, INEXACT)
T(RN,  0x1.703f2861513f6p+410,   -0x1.7c0817b6d600fp-4,   0x1.358522p-2, INEXACT)
T(RN,  0x1.85b90ec386ec6p+410,    0x1.f8d1d873b940dp-1,   0x1.1376a6p-2, INEXACT)
T(RN,   0x1.b99608dc8354p+410,   -0x1.8145c49fd5e42p-2,  -0x1.e7a052p-4, INEXACT)
T(RN,  0x1.3fa32afd39221p+410,    0x1.a6797f4a6a99ep-1,  -0x1.fb8262p-3, INEXACT)
T(RN,  0x1.a89db0c2f438ap+410,   -0x1.c611879b83547p-1,   0x1.edd118p-4, INEXACT)
T(RN,  0x1.ee5afb3e4af98p+410,    0x1.713484ca9eed2p-1,  -0x1.a361cep-2, INEXACT)
T(RN,  0x1.45a4418a8041ep+410,   -0x1.add29c6e1e8e9p-1,  -0x1.f9aa24p-2, INEXACT)
T(RN,  0x1.eb5575ef8bcd4p+410,   -0x1.d9beb58405a86p-1,  -0x1.aef04ep-2, INEXACT)
T(RN,  0x1.dd76bf74e0374p+411,   -0x1.846ee06e47e7fp-1,  -0x1.02bcb6p-2, INEXACT)
T(RN,  0x1.1cee42e5cb073p+411,    0x1.4baf7cc99aec4p-2,   -0x1.16a2fp-6, INEXACT)
T(RN,  0x1.b1b5abb3e240cp+411,    0x1.c0508f5f986edp-1,   0x1.02e0f4p-3, INEXACT)
T(RN,  0x1.0df1bcf90011cp+411,   -0x1.72e97c097357ap-1,     0x1.a144p-5, INEXACT)
T(RN,   0x1.a1cff16a29dep+411,    0x1.d02454ae0fc6dp-2,   0x1.66862ap-5, INEXACT)
T(RN,  0x1.2cfd85d90e283p+411,   -0x1.6bc7b6c882c0fp-3,   0x1.1b78fcp-5, INEXACT)
T(RN,  0x1.39f09a3e12be8p+411,    0x1.ffb433cf3c091p-1,  -0x1.ad5076p-2, INEXACT)
T(RN,  0x1.89f91f57b1b2ap+411,    0x1.c4f7ab2a62b1ep-2,   0x1.c3dd1ep-2, INEXACT)
T(RN,  0x1.cfd355763bb64p+411,    0x1.ceb0872f262cep-4,   0x1.84e8ecp-2, INEXACT)
T(RN,  0x1.921d5d6dfe0aep+411,    -0x1.3e2d46865f7fp-6,  0x1.85036cp-11, INEXACT)
T(RN,  0x1.6ab2f5c94444ep+412,    0x1.dabccf208ad16p-1,    0x1.412ddp-2, INEXACT)
T(RN,  0x1.3e74204a9fa0dp+412,   -0x1.8c8e39812e63cp-1,  -0x1.0969dcp-2, INEXACT)
T(RN,  0x1.edca8290d2542p+412,    0x1.ae6c2e0d44a84p-1,  -0x1.9f27fep-2, INEXACT)
T(RN,  0x1.372204965990dp+412,   -0x1.8c142faaa63a9p-1,   0x1.6aea4cp-2, INEXACT)
T(RN,  0x1.3923cab842753p+412,   -0x1.f5e73636ea7c6p-1,   -0x1.5acffp-3, INEXACT)
T(RN,  0x1.0164de0618b5ap+412,    0x1.0974b6774fd4ap-1,   -0x1.e847bp-2, INEXACT)
T(RN,  0x1.892a36bf71286p+412,   -0x1.9e19882d32a88p-6,  -0x1.345746p-2, INEXACT)
T(RN,  0x1.bd77d0039899ep+412,    0x1.11db81c91eef4p-3,  -0x1.86a498p-2, INEXACT)
T(RN,  0x1.26ac6098e2ce4p+412,   -0x1.cd137cb05eb48p-1,  -0x1.87486ep-2, INEXACT)
T(RN,  0x1.6e5803d851504p+412,    0x1.a4de3e08554e8p-1,    -0x1.aa28p-2, INEXACT)
T(RN,  0x1.922dd38d1e1aap+413,    0x1.9cbeead3075cfp-1,    0x1.5eb6dp-4, INEXACT)
T(RN,  0x1.a39ad5a0728b3p+413,    0x1.17dee3d8a7d72p-4,   0x1.a02028p-2, INEXACT)
T(RN,  0x1.e16bf5c7b25cap+413,    0x1.d917987dfcbd3p-1,   0x1.b6e6dap-3, INEXACT)
T(RN,  0x1.00173dfcf8e63p+413,   -0x1.2ab14d6207c2dp-3,  -0x1.423336p-9, INEXACT)
T(RN,   0x1.f61ed0375bdep+413,    0x1.7c7ff741adf24p-1,  -0x1.2050b4p-5, INEXACT)
T(RN,  0x1.25d62abaa3b17p+413,   -0x1.dc629d5015745p-1,   0x1.3e9b4ap-2, INEXACT)
T(RN,  0x1.7c83dae6c9966p+413,   -0x1.fd8a29aa42024p-2,   0x1.7d5d64p-2, INEXACT)
T(RN,  0x1.1b37e612f4288p+413,   -0x1.cfd250babcbddp-1,   0x1.9cb3a4p-4, INEXACT)
T(RN,  0x1.4143f288754a4p+413,   -0x1.006721f91baadp-1,   0x1.211f1ap-3, INEXACT)
T(RN,  0x1.8fdbb4f18d8d8p+413,   -0x1.c6e0881196122p-2,   0x1.4ded88p-3, INEXACT)
T(RN,  0x1.3f98936a2e455p+414,    0x1.0bed7478a36bcp-4,   0x1.ce0484p-2, INEXACT)
T(RN,    0x1.f116ca48e24p+414,    0x1.79365aeebb0acp-1,   0x1.c01d4ep-4, INEXACT)
T(RN,  0x1.c593fb0e937f3p+414,   -0x1.a2862bbb153b3p-1,  -0x1.c2b6eap-3, INEXACT)
T(RN,   0x1.af50050fac0fp+414,   -0x1.ec650957f98c9p-1,  -0x1.73171cp-2, INEXACT)
T(RN,  0x1.a7642b780a646p+414,    0x1.e6482524662dfp-1,  -0x1.f04facp-2, INEXACT)
T(RN,  0x1.837ab21811b47p+414,    0x1.0a8de274a67d1p-1,   0x1.945808p-2, INEXACT)
T(RN,  0x1.66ed6637486b2p+414,     0x1.40b4fec7e6f5p-1,   0x1.da980ep-3, INEXACT)
T(RN,  0x1.943ea2982caacp+414,    0x1.e8782383561a7p-1,   0x1.b32dd2p-2, INEXACT)
T(RN,  0x1.471ad5fbabd7ap+414,    0x1.9a085a4bb7d7ap-1,  -0x1.052a96p-2, INEXACT)
T(RN,  0x1.ff970151c195bp+414,    0x1.6a0a4294084d8p-3,   0x1.bc986ap-3, INEXACT)
T(RN,  0x1.f2f30cac1cd66p+415,    0x1.ffe3566c19b74p-1,   0x1.86e966p-2, INEXACT)
T(RN,  0x1.ee7868b9cbf92p+415,   -0x1.ef42ded12a855p-1,  -0x1.88c2c2p-3, INEXACT)
T(RN,  0x1.d1f1a30dbcf1ep+415,   -0x1.c3b2fc21588f3p-1,       0x1.4ep-5, INEXACT)
T(RN,  0x1.abae445189712p+415,    0x1.5dfa50471eb7cp-3,   0x1.957488p-3, INEXACT)
T(RN,  0x1.2c7eae1d998b5p+415,   -0x1.2ea5eff819ae5p-2,   -0x1.83ae3p-5, INEXACT)
T(RN,  0x1.b0f8b895f0614p+415,    0x1.dd123bcaad63bp-1,  -0x1.8449dap-5, INEXACT)
T(RN,   0x1.96ce52ae4746p+415,    0x1.67ee14971695ap-1,   0x1.ef81e6p-2, INEXACT)
T(RN,  0x1.75eac5c487416p+415,    0x1.156ccd5fc89bbp-1,  -0x1.ba1f04p-2, INEXACT)
T(RN,  0x1.dbf411f992d96p+415,   -0x1.d2d77023a0e8dp-1,    0x1.43212p-2, INEXACT)
T(RN,  0x1.ee3fe4ee80cfcp+415,   -0x1.ff7969dc0444bp-1,  -0x1.24ae02p-2, INEXACT)
T(RN,  0x1.52ffd6f7db012p+416,    0x1.00f5133fb2f2bp-2,   0x1.0cfec2p-2, INEXACT)
T(RN,  0x1.0987ae1e736f6p+416,    0x1.6e7dd54123e9fp-2,   0x1.0ff01ap-2, INEXACT)
T(RN,  0x1.c62261774f7aep+416,   -0x1.5c4b6205fb35ap-1,  -0x1.4f54dep-2, INEXACT)
T(RN,  0x1.35d4e345aa956p+416,     0x1.dbe80102edebp-1,   0x1.36edecp-3, INEXACT)
T(RN,  0x1.c697e3279e2eep+416,   -0x1.bd6ad07979965p-1,   -0x1.70438p-2, INEXACT)
T(RN,  0x1.59bb1f3c063bcp+416,     0x1.886023e5e661p-3,   0x1.2cce56p-4, INEXACT)
T(RN,  0x1.0e704e438bca9p+416,   -0x1.020c13e00ea17p-1,   -0x1.9ffc9p-2, INEXACT)
T(RN,  0x1.18b734487670ep+416,    0x1.b8f442ee71b59p-1,   0x1.bff37cp-2, INEXACT)
T(RN,  0x1.eaeec8b4afd88p+416,    0x1.8c54589101b76p-1,    0x1.f3265p-3, INEXACT)
T(RN,   0x1.875bd8a432b4p+416,   -0x1.08f1f5cfaf1e2p-2,  -0x1.35710ap-3, INEXACT)
T(RN,  0x1.24c67eb7bb313p+417,    0x1.e1f3abc09e417p-1,   0x1.b13ec2p-3, INEXACT)
T(RN,  0x1.cd8be20cd9a7fp+417,   -0x1.84f737aa7898ap-5,  -0x1.e5dff6p-2, INEXACT)
T(RN,  0x1.ea9efbf4e6f3ap+417,    0x1.939c5d4888c0fp-1,  -0x1.177c6ep-3, INEXACT)
T(RN,  0x1.0f70018bd3f8dp+417,    0x1.3932665c567b1p-3,   0x1.e4802ap-8, INEXACT)
T(RN,  0x1.aee463b07258cp+417,     0x1.13b2a17f6e99p-1,  -0x1.0f1658p-2, INEXACT)
T(RN,  0x1.0c058a86c3c94p+417,    0x1.832e2a75f6b1ep-4,   0x1.3be97ap-2, INEXACT)
T(RN,  0x1.6265302160e64p+417,    0x1.c0e3e17629113p-1,   0x1.ae09d6p-4, INEXACT)
T(RN,  0x1.fc95940f0802cp+417,    0x1.20078651ca204p-1,  -0x1.7840d6p-4, INEXACT)
T(RN,  0x1.97a2bd0caeedfp+417,   -0x1.deed23a7a2a06p-2,   0x1.d09304p-4, INEXACT)
T(RN,  0x1.f1dc7e02884f6p+417,   -0x1.fb171b3a80de4p-1,  -0x1.f21a8ap-2, INEXACT)
T(RN,  0x1.7b6b08de9fd71p+418,   -0x1.7c60843180c8dp-1,   0x1.49ba78p-2, INEXACT)
T(RN,  0x1.138a5507d485dp+418,   -0x1.8ad4e5d7443c6p-1,   0x1.0a3a52p-2, INEXACT)
T(RN,  0x1.171b236a4a5a3p+418,    0x1.e9ba60ef7f4e7p-2,   -0x1.6f935p-4, INEXACT)
T(RN,  0x1.393c55b29f9ddp+418,   -0x1.e833ebf7e66e4p-1,  -0x1.b81bb6p-3, INEXACT)
T(RN,   0x1.4cf478980957p+418,   -0x1.5918d80ec06c8p-1,  -0x1.661a86p-8, INEXACT)
T(RN,  0x1.23bce9a06ec67p+418,    0x1.b1479046db70bp-4,  -0x1.0fbfc8p-3, INEXACT)
T(RN,  0x1.ae7524b9d3c34p+418,    0x1.ec52bea0ca6dfp-2,   0x1.945646p-2, INEXACT)
T(RN,   0x1.833136035c57p+418,   -0x1.fefbe74c8c8fdp-1,   -0x1.c7137p-4, INEXACT)
T(RN,  0x1.8da6d9475bc0cp+418,   -0x1.8ef86f0e2e82ep-1,   0x1.1baca4p-4, INEXACT)
T(RN,  0x1.5cfadfe8c7cffp+418,    0x1.554e8d26e888fp-1,  -0x1.d8ebd4p-2, INEXACT)
T(RN,   0x1.664a9dab7844p+419,    0x1.aa3ca4551c74cp-1,  -0x1.b9fcf6p-2, INEXACT)
T(RN,  0x1.d34ab26270e6ap+419,   -0x1.9a8515f4ea447p-1,  -0x1.d31224p-2, INEXACT)
T(RN,  0x1.2d932590a8f06p+419,    0x1.ec478a97d0e21p-1,   0x1.179832p-4, INEXACT)
T(RN,   0x1.9ac41c12a5b9p+419,   -0x1.fff533bdfdc71p-1,   0x1.979308p-3, INEXACT)
T(RN,  0x1.7ecb25edf12f3p+419,    0x1.fb81c44e789cdp-5,   0x1.5c9b74p-2, INEXACT)
T(RN,  0x1.b84fc406c5acep+419,    0x1.c2d76964bf611p-1,  -0x1.7daa0ep-2, INEXACT)
T(RN,  0x1.8fa2c4190b20ap+419,    0x1.b26b04f6d7756p-2,  -0x1.2addfcp-6, INEXACT)
T(RN,  0x1.a4a40e13cf62cp+419,    0x1.59e557a06789ap-4,  -0x1.a9ac12p-3, INEXACT)
T(RN,  0x1.e8c0a45511098p+419,    -0x1.ba7ee0fbfb69p-1,  -0x1.de58d8p-2, INEXACT)
T(RN,  0x1.5dc01b4db548ep+419,    0x1.2f31d32c93683p-4,   0x1.a51a6cp-2, INEXACT)
T(RN,  0x1.fd3a6ebf963aep+420,   -0x1.bde7233f6340dp-2,   0x1.c47814p-4, INEXACT)
T(RN,  0x1.e08bd77cb9512p+420,    0x1.e6b48141bb07bp-1,  -0x1.9ee37ep-2, INEXACT)
T(RN,  0x1.83a72b1c9ae5ep+420,    0x1.ab0b1e38ccefdp-1,   0x1.4261eap-2, INEXACT)
T(RN,   0x1.cf260398c099p+420,    0x1.6625b8bb8bf9fp-1,  -0x1.bb25e6p-2, INEXACT)
T(RN,  0x1.1d55a7569d618p+420,    0x1.f575a4a6a0c33p-1,   -0x1.35a59p-2, INEXACT)
T(RN,  0x1.36d804e16a76cp+420,   -0x1.8f94bbc281f43p-1,   0x1.705794p-2, INEXACT)
T(RN,  0x1.3e1bb199ca22fp+420,    0x1.617d31cc67a53p-4,   0x1.7fc1b2p-3, INEXACT)
T(RN,  0x1.3f085dd3c4267p+420,   -0x1.ee9b6c4bbee17p-3,  -0x1.bd865ap-2, INEXACT)
T(RN,  0x1.f3c92c0f586c9p+420,    0x1.e6d1bde3fdff1p-1,  -0x1.131ae8p-3, INEXACT)
T(RN,  0x1.da88ab86d8cbbp+420,   -0x1.fca42b32f873ep-1,   0x1.165fbcp-2, INEXACT)
T(RN,  0x1.b818a527d1fb6p+421,   -0x1.9d7540ae7f9dep-3,  -0x1.fdde5ap-2, INEXACT)
T(RN,  0x1.6c39d065aa768p+421,   -0x1.ef90aaca96fcbp-1,    0x1.cb6f6p-2, INEXACT)
T(RN,  0x1.7f515626e6655p+421,    0x1.d786b100ba9abp-1,   -0x1.3b458p-2, INEXACT)
T(RN,  0x1.23a0b26751514p+421,    0x1.f4e09568083ecp-1,  -0x1.813c0ep-5, INEXACT)
T(RN,  0x1.71b903cbae7e6p+421,   -0x1.82b1b01a53f7fp-1,   0x1.9ea26cp-2, INEXACT)
T(RN,  0x1.712e66ea69ed4p+421,   -0x1.a1b319f5171d5p-1,   0x1.ee9b7ep-5, INEXACT)
T(RN,  0x1.e3589ffead8c9p+421,    0x1.3cd3f56bc7938p-1,   0x1.5f37a6p-2, INEXACT)
T(RN,  0x1.5e3915170df16p+421,   -0x1.e7ea68f20fca8p-1,   0x1.38ff76p-3, INEXACT)
T(RN,  0x1.04f8d3c52339cp+421,    0x1.cbf66e77aa436p-1,   0x1.214f6cp-2, INEXACT)
T(RN,  0x1.7a63d2c6b25bap+421,   -0x1.6ac61e1ce43b4p-1,   0x1.0e4db2p-4, INEXACT)
T(RN,  0x1.901e67667dd19p+422,   -0x1.24e6e2431350dp-3,   0x1.84b2f8p-2, INEXACT)
T(RN,  0x1.5b2992e27ac43p+422,   -0x1.de40b96a14f88p-1,  -0x1.80b486p-2, INEXACT)
T(RN,  0x1.0cfa87bb57ac4p+422,    0x1.ed1bbea14f935p-1,  -0x1.2838bap-2, INEXACT)
T(RN,  0x1.394422b5039cep+422,   -0x1.d0a3caa747f27p-1,   -0x1.c14f4p-2, INEXACT)
T(RN,  0x1.4d2f45bda6861p+422,   -0x1.8d64e113669f2p-1,   0x1.e9c3a8p-2, INEXACT)
T(RN,  0x1.38d7b90e932f3p+422,    0x1.4d94da82eb3c2p-1,   -0x1.d33abp-3, INEXACT)
T(RN,  0x1.7e68aed9c8bbap+422,   -0x1.4b6a99109e9c7p-1,   0x1.804274p-2, INEXACT)
T(RN,  0x1.76bf3ea24c17cp+422,   -0x1.eace8af1c4559p-1,  -0x1.f983c4p-2, INEXACT)
T(RN,  0x1.5ba8d08f76791p+422,    0x1.fcb6c5c8c3b4bp-2,  -0x1.0cd62cp-3, INEXACT)
T(RN,  0x1.b00c02a66368bp+422,   -0x1.70a5c6e7b0578p-1,  -0x1.8bd1ecp-2, INEXACT)
T(RN,  0x1.df84da164f1f6p+423,   -0x1.f8f031cb9373ap-1,   0x1.9e06d2p-2, INEXACT)
T(RN,  0x1.0ed08636ef633p+423,    0x1.d73c28d3f8c37p-2,  -0x1.1d2c86p-2, INEXACT)
T(RN,  0x1.c6bdfeb7a3744p+423,   -0x1.86d738f8d1755p-2,   -0x1.ad7aep-2, INEXACT)
T(RN,  0x1.2006f5832ac6ap+423,   -0x1.17ac79d2b9667p-1,    0x1.9aa7cp-3, INEXACT)
T(RN,  0x1.051ed7d830499p+423,    0x1.513c27b2e4885p-3,   0x1.d71f84p-6, INEXACT)
T(RN,  0x1.3aa99b82520a5p+423,    0x1.1a7649e5547a5p-6,  -0x1.ee96e4p-3, INEXACT)
T(RN,  0x1.fe0b0914cf8bap+423,   -0x1.b82be5c182fb4p-1,    0x1.30634p-4, INEXACT)
T(RN,  0x1.622e84f959a3cp+423,   -0x1.8fe0b79f88c89p-1,   0x1.0d4ae4p-3, INEXACT)
T(RN,  0x1.f6d98eb812ce9p+423,   -0x1.808e3c22ce15fp-6,   0x1.122c6ap-3, INEXACT)
T(RN,  0x1.0c221be3ece42p+423,   -0x1.ffa9a584e0d98p-1,   0x1.d3e9c2p-2, INEXACT)
T(RN,  0x1.b63f45882e7cap+424,   -0x1.55b462b14d611p-1,  -0x1.2fcf7ep-2, INEXACT)
T(RN,  0x1.00d6344850ebbp+424,   -0x1.3fad5654ab636p-2,  -0x1.12f8e2p-6, INEXACT)
T(RN,   0x1.f160d40f6046p+424,    0x1.20785b69061a5p-1,  -0x1.a7f7e6p-2, INEXACT)
T(RN,  0x1.c3311aeb31c92p+424,   -0x1.247d54a927c05p-1,  -0x1.a3b3f8p-3, INEXACT)
T(RN,  0x1.ff03e2260cf4dp+424,   -0x1.de20d42775b5bp-1,     0x1.1d86p-4, INEXACT)
T(RN,  0x1.36702623f5a15p+424,   -0x1.ee657605dd1abp-1,   0x1.5a8172p-4, INEXACT)
T(RN,  0x1.999c1b2d00904p+424,    0x1.3b1f03231ab4ap-1,   0x1.1a5d62p-5, INEXACT)
T(RN,  0x1.9222dbac4ccf6p+424,   -0x1.fd5b11233b564p-4,  -0x1.c57314p-2, INEXACT)
T(RN,  0x1.d3615d07e0914p+424,    -0x1.353552df7c49p-1,   0x1.e4a7f2p-2, INEXACT)
T(RN,  0x1.fde89dd55cde6p+424,    0x1.320e694b9fb2bp-1,   0x1.818974p-3, INEXACT)
T(RN,  0x1.8e1a6313c58b6p+425,    0x1.f1e5f91d65e75p-1,   0x1.752b5ap-2, INEXACT)
T(RN,  0x1.ff9c4e7c37884p+425,   -0x1.5142212da437bp-1,   0x1.dd576ap-2, INEXACT)
T(RN,  0x1.4f16a084454aap+425,    0x1.a44f41d881f7fp-2,   0x1.425d42p-5, INEXACT)
T(RN,  0x1.3a4bfbcbca869p+425,   -0x1.0490aaa1c5649p-1,   0x1.68e96ep-3, INEXACT)
T(RN,  0x1.fa5d023a8552ep+425,   -0x1.d5511c612b1b4p-1,  -0x1.0cae38p-2, INEXACT)
T(RN,   0x1.c14d3acd8033p+425,    0x1.ee9c2be95a7c6p-1,   0x1.e6ba94p-2, INEXACT)
T(RN,  0x1.e204c26da3483p+425,    0x1.83aff71044e54p-1,   0x1.c2a914p-2, INEXACT)
T(RN,  0x1.3170cdc406299p+425,    0x1.ea44dab41662cp-1,    0x1.e88d9p-2, INEXACT)
T(RN,  0x1.7336045cb940ap+425,   -0x1.f4d45a753210cp-1,   0x1.8cb516p-2, INEXACT)
T(RN,  0x1.2b2b07f4210a2p+425,     0x1.f128f42c8e4dp-2,  -0x1.2ffd72p-3, INEXACT)
T(RN,  0x1.9265e1d591026p+426,    0x1.873f205499cbfp-5,  -0x1.f75536p-3, INEXACT)
T(RN,  0x1.0474fb0be12a6p+426,   -0x1.789a48ca357d9p-1,   0x1.4b7f14p-2, INEXACT)
T(RN,  0x1.a8dc9fca288eap+426,    -0x1.c778743ff5fap-1,  -0x1.8bc07ep-3, INEXACT)
T(RN,  0x1.12d8a1698f968p+426,   -0x1.19b075476500cp-2,   0x1.f10616p-6, INEXACT)
T(RN,  0x1.828f401e4e678p+426,   -0x1.0af3723f3ea94p-1,  -0x1.086304p-2, INEXACT)
T(RN,  0x1.02c3e5c3bf67ep+426,   -0x1.543cc2aa230b9p-1,  -0x1.043cd6p-2, INEXACT)
T(RN,  0x1.931204b0572c6p+426,    0x1.f12a06bbedc8ep-1,   -0x1.616e9p-7, INEXACT)
T(RN,  0x1.2b87566d74047p+426,    0x1.e9d61499c50f4p-1,   0x1.f44706p-2, INEXACT)
T(RN,  0x1.3f975f6bb14a2p+426,   -0x1.f5f40f7513485p-1,  -0x1.e28882p-7, INEXACT)
T(RN,  0x1.a21a418991d5ap+426,    0x1.fb26d91fddc65p-1,  -0x1.63ec64p-2, INEXACT)
T(RN,  0x1.3ca51d1c9f13fp+427,    0x1.207003959e7adp-1,   0x1.729568p-4, INEXACT)
T(RN,  0x1.2ac3bec01cc9ap+427,   -0x1.ea1c837732aefp-1,  -0x1.060dbap-4, INEXACT)
T(RN,  0x1.144af8405b5bcp+427,   -0x1.546ef2c1bd1cap-3,   0x1.e12b4cp-2, INEXACT)
T(RN,  0x1.805d2edec5234p+427,   -0x1.e2f2d5b3c00dcp-1,   0x1.81868ep-4, INEXACT)
T(RN,  0x1.d75d52a0ec0c8p+427,    0x1.6c2a46f51a609p-1,   0x1.cbf16ep-3, INEXACT)
T(RN,  0x1.9c1fa97d5b774p+427,   -0x1.8067ed797a318p-7,   0x1.f0e8bep-3, INEXACT)
T(RN,  0x1.a453ddfc622f6p+427,   -0x1.2789003e0b918p-2,    0x1.8f99bp-7, INEXACT)
T(RN,   0x1.575abe58993dp+427,    0x1.17de14abc2fb7p-2,  -0x1.32b10ep-5, INEXACT)
T(RN,  0x1.021fa5ce676e6p+427,    0x1.fff88bf935de4p-1,   0x1.fb1ddep-2, INEXACT)
T(RN,   0x1.71d763269312p+427,   -0x1.81dc7f9988c99p-2,   0x1.4fc2c6p-2, INEXACT)
T(RN,  0x1.3b8e84097f7d2p+428,   -0x1.ebcf3bedce0edp-1,  -0x1.4ad756p-2, INEXACT)
T(RN,  0x1.b4ff8d22e5166p+428,   -0x1.6eea86c000efap-4,   -0x1.80e51p-4, INEXACT)
T(RN,  0x1.fecf32ddbdde6p+428,   -0x1.fe25818b0c64ep-1,  -0x1.842456p-2, INEXACT)
T(RN,  0x1.b2f33d8153406p+428,    0x1.75bfe29364fd6p-2,  -0x1.fba47ap-2, INEXACT)
T(RN,  0x1.82ae8e30ba001p+428,    -0x1.bdf3cfa9f956p-1,  -0x1.6f6214p-2, INEXACT)
T(RN,   0x1.0a5c55e4297bp+428,   -0x1.9e317f4bf915fp-2,  -0x1.f4f1a8p-2, INEXACT)
T(RN,  0x1.51de9d9a12746p+428,    0x1.b40a54d23d825p-1,  -0x1.c1819cp-2, INEXACT)
T(RN,  0x1.da00471aa4006p+428,    0x1.8800c4859c33ep-2,   0x1.684dc2p-3, INEXACT)
T(RN,   0x1.bc16a633e6b6p+428,    0x1.face4c4df24b2p-1,  -0x1.6f93aep-3, INEXACT)
T(RN,  0x1.90ae8971c36dcp+428,    0x1.7fe13d905e3fep-1,  -0x1.490ad8p-5, INEXACT)
T(RN,  0x1.53741d1201feep+429,   -0x1.0e6368e381683p-1,  -0x1.d9876ep-3, INEXACT)
T(RN,   0x1.dc73b0724f76p+429,    0x1.766c09aa74516p-1,   0x1.3e72acp-3, INEXACT)
T(RN,  0x1.aa2f7b58847ccp+429,   -0x1.7e736a420a8b4p-1,  -0x1.1694b6p-2, INEXACT)
T(RN,  0x1.fd6ab01fa3ff9p+429,    0x1.1017051d5d5d6p-1,  -0x1.2f171ap-2, INEXACT)
T(RN,  0x1.4131da6dab82ap+429,   -0x1.157c55ad68abbp-5,    -0x1.c055p-2, INEXACT)
T(RN,  0x1.ebb7093db2549p+429,   -0x1.f744559208692p-1,  -0x1.9b61a6p-2, INEXACT)
T(RN,  0x1.e49d68311e118p+429,    0x1.6e81e87491577p-1,  -0x1.a2a42cp-4, INEXACT)
T(RN,  0x1.ac907c44ec294p+429,    -0x1.f28bf6c5cf1cp-1,    0x1.33763p-3, INEXACT)
T(RN,  0x1.32d140afbe0f2p+429,   -0x1.674c0d4629ed5p-1,   0x1.588f7cp-3, INEXACT)
T(RN,  0x1.da416fb8db63ep+429,   -0x1.cfa2656053353p-1,   -0x1.9a9fdp-2, INEXACT)
T(RN,  0x1.72a735a89094cp+430,   -0x1.1e0ef9ea5c949p-1,  -0x1.2e8f6ep-6, INEXACT)
T(RN,  0x1.89e6f9f17d3a2p+430,    0x1.e49ec7a9a5825p-1,   0x1.d32976p-3, INEXACT)
T(RN,  0x1.285112122a7e3p+430,   -0x1.832a6397940bdp-1,   0x1.07b742p-2, INEXACT)
T(RN,  0x1.56944dd73b545p+430,   -0x1.1b58cb820e46bp-1,  -0x1.435d0ap-3, INEXACT)
T(RN,  0x1.1bdebc0741645p+430,    0x1.624ac86b61b11p-2,  -0x1.018478p-4, INEXACT)
T(RN,  0x1.0c4f64435d525p+430,    0x1.01da16b05e3aep-1,   0x1.2d9a4ep-2, INEXACT)
T(RN,  0x1.53b076863c55fp+430,    0x1.caea71d9548e4p-2,  -0x1.c6b6ccp-2, INEXACT)
T(RN,  0x1.573c37a96e5c1p+430,   -0x1.3c8c97918250dp-1,  -0x1.0eb178p-2, INEXACT)
T(RN,  0x1.2da97adbd72ebp+430,    0x1.b27066ab207c6p-3,   0x1.15e83cp-2, INEXACT)
T(RN,  0x1.554136737f608p+430,   -0x1.e8e8d2dcac22cp-1,   0x1.fc1cd4p-6, INEXACT)
T(RN,  0x1.21e93d24c7f87p+431,   -0x1.c628c8843c28cp-3,   0x1.8693d6p-3, INEXACT)
T(RN,  0x1.b950c2d8826ecp+431,    0x1.21800226ade97p-2,  0x1.a001bcp-11, INEXACT)
T(RN,   0x1.7ae15b5edad6p+431,    0x1.f14eca6bc2659p-2,   0x1.5a012ep-3, INEXACT)
T(RN,  0x1.c3187819e05dap+431,    0x1.65c927128f26cp-1,   -0x1.31c06p-2, INEXACT)
T(RN,  0x1.ad572655c39eep+431,    -0x1.019a4bd39986p-1,  -0x1.353778p-3, INEXACT)
T(RN,  0x1.27d524ebf528bp+431,    0x1.6d8837e3b816bp-2,  -0x1.e552c6p-4, INEXACT)
T(RN,  0x1.8d1e9335d20eap+431,    0x1.ff48c0db4a7e4p-1,    -0x1.31c2p-3, INEXACT)
T(RN,  0x1.68c1b38be0c74p+431,    0x1.98d69ef1998bbp-1,   0x1.81950ep-3, INEXACT)
T(RN,  0x1.b2a307542a63ap+431,   -0x1.ecb9d99d6c385p-1,   0x1.8d7fe2p-2, INEXACT)
T(RN,  0x1.efadf0c783212p+431,    0x1.e8f793d1eec01p-1,   0x1.abd8e2p-3, INEXACT)
T(RN,  0x1.36eb2f6a2a2e8p+432,    0x1.810a7fa7d36c1p-2,  -0x1.e46742p-4, INEXACT)
T(RN,  0x1.28a14e7b0d59ap+432,    0x1.a794622a74cbbp-2,    0x1.919cap-7, INEXACT)
T(RN,  0x1.eb22ebd724e7dp+432,   -0x1.cf6e831832d42p-1,  -0x1.40a762p-3, INEXACT)
T(RN,   0x1.e6dc7da0783ap+432,    0x1.f69a2bad340d5p-1,   0x1.4a70acp-2, INEXACT)
T(RN,  0x1.2ea69e6ee37c2p+432,   -0x1.cbca723a7596ap-7,   0x1.fd75f2p-4, INEXACT)
T(RN,  0x1.4345a26d57efdp+432,    0x1.55cc5b354e68dp-1,  -0x1.c07224p-4, INEXACT)
T(RN,  0x1.5268c7da5e64ep+432,   -0x1.4887b0f42b90fp-3,   0x1.fa9d8cp-4, INEXACT)
T(RN,  0x1.4a7067e366d72p+432,   -0x1.29e12ca7cb15bp-2,   0x1.d92ee6p-2, INEXACT)
T(RN,  0x1.f010271e82a67p+432,   -0x1.b24c8a47f3139p-1,   0x1.1b77cep-8, INEXACT)
T(RN,  0x1.67e172047376ap+432,   -0x1.9d56e7e34a78ap-2,  -0x1.b59a42p-2, INEXACT)
T(RN,  0x1.2d34d917b5a68p+433,   -0x1.fdae1c603980cp-2,  -0x1.fbed36p-2, INEXACT)
T(RN,  0x1.6ac80506c05a4p+433,   -0x1.e920dee956787p-1,  -0x1.fe733cp-2, INEXACT)
T(RN,  0x1.a547d2e68e442p+433,   -0x1.85d6caa6191bbp-2,   0x1.80a3dap-4, INEXACT)
T(RN,  0x1.ea67296dd4f24p+433,    -0x1.2cf5e6bf84f6p-3,  -0x1.8a44dcp-3, INEXACT)
T(RN,  0x1.bde8f0e1130b6p+433,    0x1.ffb257ba8c3a1p-1,   -0x1.52c23p-4, INEXACT)
T(RN,  0x1.2b16b0889482bp+433,    -0x1.4ab07d1fdc9fp-1,   0x1.424d46p-2, INEXACT)
T(RN,  0x1.5ab666fff2403p+433,    0x1.7e9edef4ed303p-2,   0x1.3c8794p-3, INEXACT)
T(RN,  0x1.82638453780f3p+433,   -0x1.a7cdc1d01cc2ep-1,   0x1.3b57d8p-2, INEXACT)
T(RN,  0x1.cb0724d5c8935p+433,   -0x1.fcd5fa21da3b1p-1,   0x1.8c732ep-2, INEXACT)
T(RN,  0x1.8abfcce2621e8p+433,    0x1.f6d43409a8c31p-1,  -0x1.5d467ap-3, INEXACT)
T(RN,  0x1.c5bb6e4585482p+434,    0x1.1bcc61f3fab61p-2,   0x1.3d3eccp-4, INEXACT)
T(RN,  0x1.cdbd6b488551cp+434,   -0x1.50c007bffbd6ap-1,    0x1.110f5p-2, INEXACT)
T(RN,  0x1.9f59a241099dcp+434,   -0x1.46be9b8307e9fp-1,   0x1.2a04f4p-2, INEXACT)
T(RN,  0x1.809b5bd07d30ep+434,   -0x1.283e2273debfap-1,   0x1.bb4c0ap-3, INEXACT)
T(RN,  0x1.ca09ada0678cep+434,    0x1.018194b8c7adfp-2,   0x1.63b5dep-2, INEXACT)
T(RN,  0x1.87489a804f2d2p+434,   -0x1.f1b10be1cf2cdp-1,  -0x1.2d9d94p-4, INEXACT)
T(RN,  0x1.3539b38a889bfp+434,    0x1.fe4a5266986dbp-3,   0x1.41fadcp-3, INEXACT)
T(RN,  0x1.f87c147fbb60cp+434,    -0x1.129b050f341ep-1,  -0x1.7db94cp-2, INEXACT)
T(RN,  0x1.65d091042e94fp+434,    0x1.d45af4b4db8dap-2,  -0x1.6dcd02p-4, INEXACT)
T(RN,  0x1.8519defb51db7p+434,   -0x1.c70c492021c5cp-3,  -0x1.31ff98p-4, INEXACT)
T(RN,  0x1.e4cfa53ae6608p+435,   -0x1.7a0aaa6f5b30ap-1,   0x1.e6245ap-2, INEXACT)
T(RN,  0x1.8f67c34bb2129p+435,   -0x1.bfeaf2fa4341fp-1,   0x1.971304p-2, INEXACT)
T(RN,  0x1.8249f58680ea8p+435,    0x1.be839f398bc49p-1,  -0x1.a549f6p-2, INEXACT)
T(RN,   0x1.3cd592c86186p+435,    0x1.a81e4a465ab8bp-2,   0x1.b9228ep-2, INEXACT)
T(RN,  0x1.98c7dd5aa49bdp+435,    0x1.f6ec6f18d1a68p-1,   0x1.2d1488p-4, INEXACT)
T(RN,  0x1.219dc1c280f1fp+435,   -0x1.d5388f72c14bcp-1,  -0x1.0f2242p-2, INEXACT)
T(RN,  0x1.5ce9f852a20d4p+435,    0x1.561e62a50fad7p-1,   -0x1.3c714p-2, INEXACT)
T(RN,  0x1.104980bd2a571p+435,   -0x1.862af97360c85p-2,  -0x1.e81ab6p-4, INEXACT)
T(RN,  0x1.7886b55713dbcp+435,   -0x1.1aa11be121138p-1,   0x1.b4548ap-3, INEXACT)
T(RN,  0x1.2f0cef47ccf89p+435,   -0x1.a20cca75ea9a1p-1,   0x1.608b2cp-3, INEXACT)
T(RN,   0x1.81af66c84eebp+436,    0x1.408b3df2ffa26p-7,  -0x1.416914p-3, INEXACT)
T(RN,  0x1.9803020f7fd94p+436,   -0x1.cc0a774916e73p-1,  -0x1.0f3eaap-5, INEXACT)
T(RN,  0x1.a347f2dd521fep+436,    0x1.2a6904679aadap-6,  -0x1.54ea56p-4, INEXACT)
T(RN,  0x1.9edaaeaecda85p+436,    0x1.ffecea45ff08fp-1,   0x1.edcc0cp-2, INEXACT)
T(RN,  0x1.f07fc86ed0ae8p+436,    0x1.fcce659c6172dp-1,   0x1.0834a2p-3, INEXACT)
T(RN,  0x1.09eeb4956536dp+436,    0x1.f28423d44fd18p-1,  -0x1.1d312ap-3, INEXACT)
T(RN,  0x1.332afa9e0b75fp+436,    0x1.9a14d2e69e01bp-7,   0x1.5a86cep-3, INEXACT)
T(RN,  0x1.de017f9a98b3ap+436,   -0x1.da54f58d6fff9p-1,  -0x1.c11b12p-5, INEXACT)
T(RN,  0x1.b3c4324e94878p+436,   -0x1.bf28dfd8ec8ccp-1,   0x1.bb4634p-2, INEXACT)
T(RN,  0x1.1b84ba001db27p+436,    0x1.532e92b01c805p-3,    0x1.1d603p-3, INEXACT)
T(RN,  0x1.f606c32b7865cp+437,   -0x1.7ee24697ad391p-1,   0x1.1cbc14p-6, INEXACT)
T(RN,  0x1.fa87090687798p+437,    0x1.fc2dfeb9b2255p-1,  -0x1.d6ac64p-3, INEXACT)
T(RN,  0x1.88ecfb05240d2p+437,   -0x1.4d426d7508a1fp-6,   -0x1.5e5a9p-4, INEXACT)
T(RN,  0x1.08b31cebbfdcep+437,   -0x1.ae4017fbe64c4p-2,   -0x1.c1f5bp-2, INEXACT)
T(RN,  0x1.403b6d7539eb1p+437,    0x1.471a7bda5ccc8p-6,   0x1.ee0112p-5, INEXACT)
T(RN,  0x1.b687729996503p+437,   -0x1.23de27d82b6dep-1,  -0x1.9deb2cp-2, INEXACT)
T(RN,  0x1.842724c757504p+437,   -0x1.d477733ab0021p-3,   0x1.ae6a12p-2, INEXACT)
T(RN,  0x1.a278c993e820bp+437,    0x1.ef57931b48cd1p-1,  -0x1.cf41a6p-4, INEXACT)
T(RN,  0x1.7be7fa236bd34p+437,    0x1.90c4297ce3f1dp-1,  -0x1.1cb8dep-2, INEXACT)
T(RN,  0x1.1fb583ddd8e2cp+437,    0x1.f142e7c0c6856p-3,   0x1.d68d16p-3, INEXACT)
T(RN,  0x1.2136eca165176p+438,    0x1.f4edb56e5cc96p-2,   0x1.d1855cp-2, INEXACT)
T(RN,  0x1.fc88597b99f3dp+438,   -0x1.e8d1b0009f089p-1,   0x1.20496ap-6, INEXACT)
T(RN,  0x1.330068222a1b1p+438,   -0x1.d5bc739a1a16dp-1,  -0x1.c4ae94p-7, INEXACT)
T(RN,  0x1.f28ef7fc198acp+438,    0x1.9286304455f1ap-1,  -0x1.b7d2c4p-2, INEXACT)
T(RN,  0x1.42d58018b2de4p+438,   -0x1.8acc873332b83p-1,  -0x1.813e2ap-5, INEXACT)
T(RN,  0x1.8f45415b3e3d2p+438,    0x1.ffb12b8583394p-1,  -0x1.0d6c0ap-2, INEXACT)
T(RN,  0x1.a86414ddf2cf6p+438,   -0x1.ef18014c66392p-3,  -0x1.c10f66p-4, INEXACT)
T(RN,  0x1.2793ef1c51f06p+438,   -0x1.764ff0bd8fd62p-1,  -0x1.b5e12cp-5, INEXACT)
T(RN,  0x1.d32bdc22c3984p+438,   -0x1.f75d96746bb34p-1,   0x1.97f038p-2, INEXACT)
T(RN,  0x1.44b5623b3a1dap+438,    0x1.d67066069fb43p-1,  -0x1.62c398p-2, INEXACT)
T(RN,  0x1.a621b1e1b0db1p+439,   -0x1.65c02179b7e27p-4,   0x1.6c55dap-2, INEXACT)
T(RN,  0x1.cc9a349315171p+439,    0x1.fe44b407f523dp-1,   -0x1.8722bp-2, INEXACT)
T(RN,  0x1.ed32b57bab343p+439,    0x1.6123d8de33192p-1,  -0x1.2feeaep-2, INEXACT)
T(RN,  0x1.4752ef7fa0991p+439,    0x1.07310ad73bcfbp-1,   0x1.8bf1b2p-5, INEXACT)
T(RN,  0x1.63529687300fep+439,     -0x1.352c8e3a294p-2,   0x1.37b54ep-4, INEXACT)
T(RN,  0x1.e120309aa8147p+439,   -0x1.1597904be556cp-1,  -0x1.9a8ddap-2, INEXACT)
T(RN,  0x1.90b89a04ba73ap+439,    -0x1.c26b9f442924p-1,  -0x1.c9ba02p-3, INEXACT)
T(RN,  0x1.e850b2dc473ecp+439,    0x1.f2c44e9e14bf8p-1,    0x1.d280cp-2, INEXACT)
T(RN,  0x1.a72446e79b9efp+439,   -0x1.c9dcdef7d20ccp-1,  -0x1.78959ep-2, INEXACT)
T(RN,  0x1.2010422aba21ap+439,   -0x1.ed6e8257fa8a2p-2,   0x1.833914p-2, INEXACT)
T(RN,  0x1.67bcd9bf70958p+440,   -0x1.f06ee99563799p-5,   0x1.1a541ap-4, INEXACT)
T(RN,  0x1.ca3bb45a91d0ap+440,   -0x1.6cc45dfa47089p-2,  -0x1.df10a6p-4, INEXACT)
T(RN,  0x1.5c323c761c325p+440,    0x1.e625663a0365bp-1,  -0x1.43f74cp-4, INEXACT)
T(RN,  0x1.ef9ff926604aep+440,    0x1.ffffdf9fceb85p-1,   0x1.a1ff22p-3, INEXACT)
T(RN,  0x1.a1c1d10ed06e8p+440,     0x1.ffb6b8473d26p-1,  -0x1.bdb87cp-6, INEXACT)
T(RN,  0x1.8d624e2727efap+440,    0x1.df00828c3c13fp-1,   -0x1.15d15p-3, INEXACT)
T(RN,  0x1.c826d1f748d7cp+440,   -0x1.d9482dd6e5517p-1,   0x1.035c4ep-2, INEXACT)
T(RN,  0x1.ad14fc1ed93ecp+440,   -0x1.30dfffdd2a38cp-1,   0x1.274656p-2, INEXACT)
T(RN,  0x1.2f34c56867e32p+440,   -0x1.cbd23130ad2bep-1,  -0x1.0ec2b8p-2, INEXACT)
T(RN,  0x1.b97aa760056fap+440,    0x1.bed87282d9ce5p-1,  -0x1.a703ecp-2, INEXACT)
T(RN,  0x1.39b75c9eee92cp+441,   -0x1.9f2bb2fec6a3cp-2,    0x1.b3ba6p-2, INEXACT)
T(RN,  0x1.db54155c5a35ep+441,   -0x1.b0dd8c5ccc2e1p-4,   0x1.692b9cp-2, INEXACT)
T(RN,  0x1.e4f1cc6f553b2p+441,    0x1.66456d594fcc6p-1,   0x1.b85e92p-3, INEXACT)
T(RN,  0x1.5208b6094e858p+441,    0x1.ad1664d120469p-1,   0x1.8a0fd2p-2, INEXACT)
T(RN,  0x1.a625fa8194e3ap+441,     0x1.fbd377150688p-1,  -0x1.725b38p-6, INEXACT)
T(RN,  0x1.e5e1686054e35p+441,   -0x1.8ae206585f04bp-1,  -0x1.089e66p-3, INEXACT)
T(RN,  0x1.c79c97b1b0d41p+441,   -0x1.7fe7584a5b70bp-1,   0x1.eea75ep-3, INEXACT)
T(RN,  0x1.38944a29e735bp+441,     0x1.5398269358abp-1,  -0x1.7bd7dcp-2, INEXACT)
T(RN,  0x1.328463d4f8ca6p+441,    0x1.b676077d4faf8p-1,   0x1.b60978p-2, INEXACT)
T(RN,  0x1.2334778ad369bp+441,   -0x1.d788f745eccb3p-2,  -0x1.10bf6cp-4, INEXACT)
T(RN,   0x1.aef23939141bp+442,   -0x1.a65df8f1f3e3fp-1,    0x1.7bf6cp-7, INEXACT)
T(RN,  0x1.986537868931ep+442,   -0x1.db172fffd28fdp-3,   0x1.ca9cf4p-2, INEXACT)
T(RN,  0x1.d404c5dca8978p+442,     0x1.5436397c7f4fp-1,   0x1.ed6534p-2, INEXACT)
T(RN,   0x1.e7f7a4947213p+442,    0x1.9fe4c90c4bc3bp-1,   0x1.0c4d4cp-3, INEXACT)
T(RN,  0x1.cf6975254ebeep+442,   -0x1.6f0b5b12f4d83p-1,  -0x1.de32e8p-8, INEXACT)
T(RN,  0x1.69e84e4d3c278p+442,   -0x1.e815d993fb30dp-2,  -0x1.2bae82p-2, INEXACT)
T(RN,  0x1.4372792dc46c6p+442,    0x1.fc11283777dafp-1,   -0x1.f2e8ap-2, INEXACT)
T(RN,  0x1.d2ab3f832d4f5p+442,   -0x1.99c3431bb08a4p-4,  -0x1.953a3ep-2, INEXACT)
T(RN,  0x1.479823346f1f4p+442,   -0x1.5b9f953b1d734p-5,   0x1.2e3012p-2, INEXACT)
T(RN,  0x1.236258b19004fp+442,   -0x1.ffe6fa60bca2dp-1,   0x1.56046ep-4, INEXACT)
T(RN,  0x1.7391ae9141194p+443,   -0x1.94c93db3e3b96p-2,   0x1.9c2854p-3, INEXACT)
T(RN,  0x1.ae30aa7ce2487p+443,   -0x1.9a9a7d5390188p-1,   0x1.233292p-2, INEXACT)
T(RN,  0x1.f2b1e02a1122ep+443,   -0x1.54b7e49bd5672p-1,  -0x1.c1be58p-2, INEXACT)
T(RN,  0x1.36f3b1569e5dcp+443,   -0x1.6a601a326aa4cp-4,  -0x1.68bf8ep-2, INEXACT)
T(RN,  0x1.57418e6d787e1p+443,   -0x1.d420502d9dfcep-2,  -0x1.faa50cp-5, INEXACT)
T(RN,  0x1.8c3815ea6675ap+443,   -0x1.4fd721ce1a1a8p-5,  -0x1.99a0dap-4, INEXACT)
T(RN,  0x1.49ff4fb18b058p+443,    0x1.34f8e5aebd7fdp-3,   0x1.06612cp-2, INEXACT)
T(RN,  0x1.eddf1269e520ep+443,   -0x1.0d0c44f0be77cp-4,  -0x1.9d2ac6p-2, INEXACT)
T(RN,  0x1.7d4a1df625e24p+443,    0x1.381de09b1edf1p-3,   -0x1.d3193p-2, INEXACT)
T(RN,  0x1.f5c5fd78ea0d6p+443,    0x1.fbdda5092390fp-1,   -0x1.25fb1p-3, INEXACT)
T(RN,  0x1.5d6011d247cf1p+444,   -0x1.ce99efd2ccc4ap-1,  -0x1.a1a854p-3, INEXACT)
T(RN,  0x1.5b1e6a0fcf292p+444,    0x1.6d47e7cdfad31p-1,   0x1.e5622cp-2, INEXACT)
T(RN,  0x1.3033b8ef19a49p+444,    0x1.77b2a9c837fe2p-1,   0x1.d7bb3ap-4, INEXACT)
T(RN,   0x1.1e85d2e68ab5p+444,   -0x1.749de979b9019p-2,  -0x1.7b4c76p-2, INEXACT)
T(RN,  0x1.3bbfd5bd9acb1p+444,   -0x1.3e9e2f0a60261p-4,   0x1.2c9542p-2, INEXACT)
T(RN,  0x1.5b7c8e5885cc1p+444,   -0x1.4de96504d7ab4p-5,   0x1.b1ec3ap-3, INEXACT)
T(RN,  0x1.55e1591d0cb46p+444,    0x1.d4bfa81773aedp-1,   0x1.f3bf98p-2, INEXACT)
T(RN,  0x1.34f9492ff866cp+444,    0x1.bb99a4d6a8e17p-1,   0x1.967a56p-3, INEXACT)
T(RN,  0x1.72c20b3931e6bp+444,   -0x1.370d9472d5c22p-6,  -0x1.44c03ap-4, INEXACT)
T(RN,  0x1.6bf09e71b4952p+444,   -0x1.eea462fdf97ecp-1,   0x1.fb749cp-3, INEXACT)
T(RN,  0x1.b90d753261192p+445,   -0x1.ac2fb6c53ea1ap-3,  -0x1.e783e8p-4, INEXACT)
T(RN,  0x1.3783a15a15dbcp+445,   -0x1.fc90a965fbbadp-1,   0x1.d9c8a6p-2, INEXACT)
T(RN,   0x1.42b77a2fe1bfp+445,    0x1.35be6feef538cp-1,  -0x1.b7e0aap-2, INEXACT)
T(RN,  0x1.dbd5749766e6bp+445,   -0x1.8552347ab786dp-4,  -0x1.1d7658p-7, INEXACT)
T(RN,  0x1.1402b28a084e6p+445,    0x1.957962489645ap-1,  -0x1.4a4f56p-5, INEXACT)
T(RN,  0x1.f6af10774e3e2p+445,   -0x1.16da93513a84ep-1,  -0x1.f11c02p-3, INEXACT)
T(RN,  0x1.25dfc9249cd34p+445,    0x1.664783d53550cp-1,  -0x1.1cb7b6p-6, INEXACT)
T(RN,  0x1.f4198f7c8517ap+445,   -0x1.1ba8eb1fc79bcp-1,   0x1.8a1328p-3, INEXACT)
T(RN,   0x1.79240ea9ec8cp+445,    0x1.3eac0c61289b1p-1,   0x1.33efa8p-2, INEXACT)
T(RN,  0x1.8b21654c4f467p+445,   -0x1.7189a192d1608p-6,   0x1.00f6b6p-3, INEXACT)
T(RN,   0x1.ce31798f1f49p+446,      0x1.1994477087fp-2,  -0x1.1a17d2p-6, INEXACT)
T(RN,  0x1.63ffbd5e8e5e6p+446,    0x1.37ebbf7f69755p-5,   0x1.0a418ep-3, INEXACT)
T(RN,  0x1.4aea82fe0e3b6p+446,    0x1.e2594ed7f9716p-1,  -0x1.a50e2ep-2, INEXACT)
T(RN,  0x1.4200ed2c12aeep+446,    0x1.5459255efdcf8p-2,  -0x1.2ebf46p-2, INEXACT)
T(RN,  0x1.08ecf7fbfbd65p+446,    0x1.7af6ff980fb3ep-2,   0x1.3ee104p-2, INEXACT)
T(RN,  0x1.1740e34255b26p+446,    0x1.4bfa1c3540d82p-1,   0x1.0784a4p-2, INEXACT)
T(RN,  0x1.e7f765e731fbfp+446,    0x1.f9dce38bd63ffp-1,  -0x1.96fc5ep-4, INEXACT)
T(RN,  0x1.bf5694daa3efep+446,   -0x1.ffbfbf205bf9cp-1,  -0x1.d6f57ap-2, INEXACT)
T(RN,  0x1.f4534fd1ed438p+446,   -0x1.99bc317a23a0bp-1,  -0x1.83f1e4p-3, INEXACT)
T(RN,  0x1.494ea4cfa8e46p+446,   -0x1.4e8d9d3d50ae9p-1,  -0x1.d661fcp-3, INEXACT)
T(RN,  0x1.9d42f1b20730ap+447,   -0x1.e3110de0d5555p-1,   -0x1.23672p-4, INEXACT)
T(RN,  0x1.5af782dcb8e52p+447,   -0x1.dda82faf0b655p-1, -0x1.3f2188p-10, INEXACT)
T(RN,  0x1.35aea3f736bebp+447,   -0x1.2276e0d708a64p-3,   0x1.fda986p-5, INEXACT)
T(RN,  0x1.f72161936fc6ap+447,   -0x1.edf348b35a0efp-1,   0x1.f38026p-2, INEXACT)
T(RN,  0x1.78507a602098bp+447,   -0x1.0ba71da69ada8p-1,   0x1.3d405ep-2, INEXACT)
T(RN,  0x1.46169008bf2dbp+447,   -0x1.1d6836fd74c99p-1,   0x1.4a47fcp-2, INEXACT)
T(RN,  0x1.3d25963bc4136p+447,   -0x1.79be4087309acp-1,    0x1.ddb7fp-7, INEXACT)
T(RN,  0x1.1ec638395368fp+447,    0x1.ff7933c2f32b8p-1,  -0x1.7904d6p-6, INEXACT)
T(RN,  0x1.c02f9d493015ap+447,   -0x1.a3de48a74acdep-1,  -0x1.b2b688p-2, INEXACT)
T(RN,  0x1.9f80b30e4ca7ep+447,   -0x1.91a2faa596d94p-2,   0x1.98ef0ap-4, INEXACT)
T(RN,  0x1.85cbb9b9df5fep+448,   -0x1.77491ec954a4bp-2,  -0x1.191242p-4, INEXACT)
T(RN,  0x1.836441041b804p+448,    0x1.ef14a80ec950ep-1,   0x1.c245e6p-3, INEXACT)
T(RN,  0x1.a550311693cb9p+448,   -0x1.b7b8e65b82c13p-1,   0x1.81f946p-3, INEXACT)
T(RN,  0x1.0fe87bf4c32bcp+448,   -0x1.eb1feef5b6344p-1,  -0x1.0055f2p-2, INEXACT)
T(RN,  0x1.95ecfb7108dd8p+448,   -0x1.8de0de65cea03p-1,  -0x1.6b62e4p-2, INEXACT)
T(RN,  0x1.a939093c4c9e6p+448,    0x1.6eb7dbf366d73p-1,   0x1.6f9384p-2, INEXACT)
T(RN,  0x1.c6e9a9cd3571ap+448,    0x1.40cabea7c358ap-1,     0x1.b564p-3, INEXACT)
T(RN,  0x1.536f8f3d2735ep+448,    0x1.59c4664a5fb15p-1,   -0x1.20407p-2, INEXACT)
T(RN,   0x1.b16ce4713e21p+448,   -0x1.619cbb4487731p-1,   0x1.bb40d6p-3, INEXACT)
T(RN,  0x1.630a7b72fe342p+448,    0x1.b032d8ecb38d2p-1,  -0x1.961108p-2, INEXACT)
T(RN,  0x1.626c46fdc2916p+449,   -0x1.de8ffc01283d1p-2,  -0x1.581e12p-2, INEXACT)
T(RN,  0x1.ce19e7d1d2facp+449,   -0x1.bf7b710523ab2p-1,  -0x1.b55d1ep-2, INEXACT)
T(RN,  0x1.585b3aea0cd1bp+449,   -0x1.456fab13e5fb3p-1,  -0x1.007816p-3, INEXACT)
T(RN,  0x1.cbebb7f6b520ap+449,    0x1.93a1b7ebffd74p-1,  -0x1.373198p-2, INEXACT)
T(RN,  0x1.2bcda4c1dc74ap+449,   -0x1.fb9c338951681p-1,   0x1.daebe8p-2, INEXACT)
T(RN,   0x1.482205c7e008p+449,    0x1.31ecd70cdfba3p-1,   0x1.26a916p-3, INEXACT)
T(RN,  0x1.816599812975ep+449,   -0x1.512a084ed80f1p-5,   0x1.bffa46p-2, INEXACT)
T(RN,  0x1.a9e9aec26aed8p+449,    0x1.83ce07af45306p-1,  -0x1.76dd42p-3, INEXACT)
T(RN,   0x1.16313989537ep+449,    0x1.f4668e0998036p-1,   0x1.395be6p-2, INEXACT)
T(RN,  0x1.39a0e95511323p+449,    0x1.dfb3f55b85bb7p-1,    0x1.efd6bp-2, INEXACT)
T(RN,  0x1.1930f9f8dd1c8p+450,   -0x1.0b7348cfb97e6p-5,   -0x1.2d9bep-3, INEXACT)
T(RN,  0x1.26f7dc03297afp+450,    0x1.c5e140c918453p-1,   0x1.348f62p-2, INEXACT)
T(RN,  0x1.cac0db7f2814bp+450,   -0x1.d89eb03cab032p-2,   0x1.103886p-2, INEXACT)
T(RN,  0x1.837cd7d7f3948p+450,   -0x1.d08e235839db3p-8,  -0x1.bcf37ep-2, INEXACT)
T(RN,  0x1.f3e9bebd8668cp+450,   -0x1.2ffa45ed4c87fp-3,  -0x1.3cf3e8p-2, INEXACT)
T(RN,  0x1.356ba437aa85fp+450,   -0x1.bd7ae8d43ce7dp-1,   0x1.9bd3dep-4, INEXACT)
T(RN,  0x1.c7be04d6494e2p+450,    0x1.ff65533374f68p-1,   0x1.4634cap-2, INEXACT)
T(RN,  0x1.cb729c8ad6372p+450,    0x1.45a516952c348p-1,   -0x1.2d057p-2, INEXACT)
T(RN,  0x1.1b7a45398c047p+450,    0x1.6df027c292bfcp-1,  -0x1.7dab72p-2, INEXACT)
T(RN,  0x1.4777b572a2755p+450,    0x1.2997232306368p-1,  -0x1.1faec8p-3, INEXACT)
T(RN,  0x1.d1f77aea1d3cdp+451,    0x1.bf0971e6f0fffp-1,   0x1.be86e8p-2, INEXACT)
T(RN,  0x1.2b637eb9fe70ap+451,    0x1.f508ee9293b4bp-2,   -0x1.8b6c5p-2, INEXACT)
T(RN,  0x1.0e0c091ba8d53p+451,   -0x1.ec550a8d5a20ep-1,    0x1.dcb99p-4, INEXACT)
T(RN,  0x1.609b03110f526p+451,    0x1.4d014461ed0c5p-2,  -0x1.c2fcfap-2, INEXACT)
T(RN,  0x1.771f41a202618p+451,   -0x1.f55f0ae726666p-1,   0x1.c58122p-4, INEXACT)
T(RN,  0x1.fc1b310788657p+451,   -0x1.feab4f30ffeb4p-1,  -0x1.5cf8d4p-3, INEXACT)
T(RN,  0x1.334b2330e11c2p+451,    0x1.3178912c6de82p-2,   0x1.5bea4ap-2, INEXACT)
T(RN,  0x1.1dae4f06f2bd4p+451,   -0x1.ec9692e21046cp-1,  -0x1.d6c322p-4, INEXACT)
T(RN,  0x1.f43837c236c04p+451,    0x1.2b5e277cad0bcp-2,   0x1.3d66eap-3, INEXACT)
T(RN,  0x1.56375b071e027p+451,   -0x1.c88c78c1ee58bp-1,    0x1.cb849p-2, INEXACT)
T(RN,  0x1.44880072e70e7p+452,   -0x1.f04a4df84836cp-1,   0x1.2d4fdcp-7, INEXACT)
T(RN,  0x1.023786863cbe6p+452,    0x1.fe4dacf43228cp-1,    0x1.27b93p-3, INEXACT)
T(RN,  0x1.91bd07d3e773cp+452,     0x1.1161efa2863ep-3,   0x1.b59fa2p-2, INEXACT)
T(RN,  0x1.b506458f6b5bap+452,    0x1.20c145da7b9b7p-2,   0x1.5fd8fcp-2, INEXACT)
T(RN,   0x1.b81b84f38a69p+452,      0x1.f8e9ad3ab05p-1,  -0x1.5b7b84p-4, INEXACT)
T(RN,  0x1.28f7c2b81ab43p+452,    0x1.7c8ee3e7f173ap-1,  -0x1.89d51ap-4, INEXACT)
T(RN,  0x1.180e83d4fa2f1p+452,    0x1.8533f991995fcp-1,   0x1.c415acp-2, INEXACT)
T(RN,  0x1.a633831197188p+452,    0x1.1852821011171p-1,   0x1.62b58cp-2, INEXACT)
T(RN,  0x1.5e8ef9466d21ap+452,    -0x1.c586a2dd67a9p-1,  -0x1.087eb2p-2, INEXACT)
T(RN,  0x1.0ce7bf044d5e3p+452,   -0x1.ff6887477e5d3p-1,   0x1.965d0ep-4, INEXACT)
T(RN,  0x1.67d494b0ee232p+453,    0x1.fd9261b5fef76p-1,  -0x1.b38134p-3, INEXACT)
T(RN,  0x1.e071585c4d39cp+453,    0x1.640ba62668622p-2,  -0x1.3c065cp-2, INEXACT)
T(RN,  0x1.b7c86752ff174p+453,   -0x1.cbb5008626c23p-1,  -0x1.069ad8p-2, INEXACT)
T(RN,  0x1.d742a270a6f64p+453,   -0x1.04362bf6bc6c8p-1,   0x1.ebed9ap-3, INEXACT)
T(RN,  0x1.c3abde4477a81p+453,   -0x1.fc55b15468fbcp-1,   0x1.3edeacp-2, INEXACT)
T(RN,  0x1.7c1a4f4a25534p+453,    0x1.f8c67c630edf6p-1,  -0x1.03eb96p-3, INEXACT)
T(RN,  0x1.08bbdf036361dp+453,    0x1.7fab44a61036cp-1,  -0x1.af445ap-2, INEXACT)
T(RN,    0x1.7f50809844dp+453,    0x1.58a49728a374bp-1,   0x1.c014bcp-6, INEXACT)
T(RN,  0x1.ecd0f0bbaffa6p+453,    0x1.a283586bae2afp-4,  -0x1.c24396p-5, INEXACT)
T(RN,   0x1.337e1e805083p+453,   -0x1.2770ce4d92983p-3,  -0x1.5d99d4p-2, INEXACT)
T(RN,  0x1.315164eac74a2p+454,     0x1.ebab605e3a9cp-1,    0x1.d8ed6p-7, INEXACT)
T(RN,  0x1.64bfa0e37e2a4p+454,    0x1.4b3fd615ff843p-3,   0x1.901602p-3, INEXACT)
T(RN,  0x1.8302e6f172352p+454,   -0x1.95594d7826d33p-1,   0x1.d0eea6p-2, INEXACT)
T(RN,  0x1.acd6f8f54bf2cp+454,   -0x1.f839ee2c60c39p-1,   0x1.461c58p-3, INEXACT)
T(RN,  0x1.473f7ed7f4648p+454,    0x1.f1a2b93b9b7f8p-1,   0x1.0ad4d8p-6, INEXACT)
T(RN,  0x1.66d1616df4844p+454,   -0x1.9809cd55b70b6p-2,   0x1.ef4072p-3, INEXACT)
T(RN,   0x1.6471cac3a865p+454,    0x1.b6c3e9341cdb3p-1,  -0x1.002cb8p-4, INEXACT)
T(RN,  0x1.8bfd8eebb5699p+454,    0x1.866eb241560aep-1,  -0x1.bc914ap-2, INEXACT)
T(RN,  0x1.46e2259c55549p+454,   -0x1.eea6d75ffd83bp-1,   0x1.70f03ap-2, INEXACT)
T(RN,  0x1.753689c6b4118p+454,   -0x1.51c0767de7698p-4,  -0x1.520d96p-6, INEXACT)
T(RN,  0x1.a120f53962b9fp+455,   -0x1.33d5e2d5a642ep-4,  -0x1.949482p-4, INEXACT)
T(RN,  0x1.4ad55284076bap+455,    0x1.496a001160ab8p-1,   0x1.be299ep-6, INEXACT)
T(RN,  0x1.d29bf23f07537p+455,    0x1.f07ca8fa81eefp-1,  -0x1.e30edap-5, INEXACT)
T(RN,   0x1.5ad183b57491p+455,   -0x1.36af5e9fec4c2p-1,   0x1.21a11cp-3, INEXACT)
T(RN,  0x1.76abef032ce56p+455,   -0x1.d9558fc4cad0ep-2,  -0x1.98bc86p-2, INEXACT)
T(RN,  0x1.67a053d7c6c92p+455,    0x1.d58ab4a3e86a8p-1,  -0x1.9de90ep-2, INEXACT)
T(RN,   0x1.7951edecbe62p+455,   -0x1.fff88b7c0fe7fp-1,   0x1.139162p-4, INEXACT)
T(RN,  0x1.4f44c05a41e68p+455,    -0x1.ea62ca80ceafp-2,  -0x1.ada0c6p-2, INEXACT)
T(RN,  0x1.0efed4b6dfec8p+455,   -0x1.fed64b752ccf7p-1,   0x1.937772p-2, INEXACT)
T(RN,  0x1.a7686f7022b5cp+455,    0x1.e67e4144108c8p-2,   0x1.9df6c8p-5, INEXACT)
T(RN,  0x1.9b9041b5e9f3cp+456,   -0x1.2d9651f89042bp-1,  -0x1.96c294p-4, INEXACT)
T(RN,  0x1.dbce0ee67a8f1p+456,    0x1.da399e5533f8cp-1,  -0x1.e3ebf6p-3, INEXACT)
T(RN,   0x1.2e46faeafcd7p+456,   -0x1.1fcb59eb6714ep-1,   0x1.85ae12p-3, INEXACT)
T(RN,  0x1.bb44c0d933077p+456,   -0x1.d640100bcfc82p-1,  -0x1.5bd616p-5, INEXACT)
T(RN,   0x1.ba2787508007p+456,   -0x1.9f97d9cb88b49p-1,   0x1.5de1c4p-5, INEXACT)
T(RN,   0x1.914793f8fd63p+456,   -0x1.e1c96b9775a98p-1,  -0x1.3f76c8p-4, INEXACT)
T(RN,  0x1.94ac3e5b2f37ep+456,   -0x1.fbd6aa0286ad4p-1,  -0x1.bcc896p-2, INEXACT)
T(RN,   0x1.64625e9cdd47p+456,    0x1.5417510ab4aedp-3,  -0x1.0b81d8p-2, INEXACT)
T(RN,  0x1.974b3da55a0d9p+456,   -0x1.df95cc6aac7d8p-1,  -0x1.a93ce8p-3, INEXACT)
T(RN,  0x1.80781be05f318p+456,   -0x1.f58b54fe675e5p-1,   0x1.038982p-4, INEXACT)
T(RN,  0x1.bf69f0fb36af6p+457,   -0x1.f475b80c7afb5p-1,  -0x1.cff9fep-2, INEXACT)
T(RN,  0x1.eb90d352d50bap+457,    0x1.42fd59d50d9f6p-2,  -0x1.ad58e4p-4, INEXACT)
T(RN,  0x1.179a8a6776142p+457,    0x1.f91985f85b32ep-1,  -0x1.93b9d6p-8, INEXACT)
T(RN,  0x1.e6e6201e4390ep+457,   -0x1.8a3d8bf0ef01bp-3,   0x1.ea6f72p-2, INEXACT)
T(RN,  0x1.a748045238652p+457,    0x1.9a184e0c3df61p-1,   0x1.7f5546p-4, INEXACT)
T(RN,  0x1.4addf3e91a28bp+457,   -0x1.26162e2ed4cc1p-1,   0x1.bff0c4p-2, INEXACT)
T(RN,  0x1.095994bc2e5d7p+457,    0x1.40294790514bfp-3,   0x1.b1cc28p-5, INEXACT)
T(RN,  0x1.f3171fa2f8d76p+457,    0x1.d1a12dc3c8232p-1,   0x1.e0356ap-3, INEXACT)
T(RN,  0x1.2f41bf9ca8e45p+457,     0x1.db2f88a0ceffp-1,  -0x1.9fa0eap-3, INEXACT)
T(RN,  0x1.0da60e5cf8591p+457,    0x1.ff15e0be2d828p-1,  -0x1.9178dep-2, INEXACT)
T(RN,  0x1.3846124a5b3cap+458,    0x1.af7ef70ff7091p-4,  -0x1.0ab4d6p-4, INEXACT)
T(RN,  0x1.226d9a7c38a04p+458,    0x1.da9175c80aea5p-2,   0x1.52bb44p-3, INEXACT)
T(RN,  0x1.acdaa2da26a72p+458,    0x1.fb318bf43bf1fp-6,   0x1.cbef2ap-2, INEXACT)
T(RN,  0x1.37d1a943bc776p+458,   -0x1.fe9f192ab36fdp-1,  -0x1.e3732cp-2, INEXACT)
T(RN,   0x1.46818ae34706p+458,   -0x1.d388683566f92p-1,   0x1.4e46f6p-2, INEXACT)
T(RN,  0x1.adcfe573af2f8p+458,   -0x1.ffffef09180eep-1,   0x1.aedc26p-2, INEXACT)
T(RN,   0x1.207c82d0f708p+458,   -0x1.98bb65c1c165dp-1,   0x1.fdd39ap-3, INEXACT)
T(RN,  0x1.2bffa46c56062p+458,   -0x1.aca3404f4e5a8p-4,  -0x1.1638e2p-3, INEXACT)
T(RN,  0x1.1b3c10a429c28p+458,   -0x1.04e5fa94fa0bfp-1,  -0x1.8a4e92p-2, INEXACT)
T(RN,   0x1.52d5d077d585p+458,   -0x1.4f1c48ae82d16p-1,  -0x1.32ff3cp-2, INEXACT)
T(RN,  0x1.41fb6a9ff4408p+459,   -0x1.83afb4f3bcc81p-1,   0x1.363942p-3, INEXACT)
T(RN,  0x1.9f18c5a77c7b8p+459,   -0x1.d95f70aed8e5ep-1,   0x1.9be0f8p-2, INEXACT)
T(RN,  0x1.dd8992a1750e6p+459,    0x1.923522fee1d42p-1,   0x1.c27498p-2, INEXACT)
T(RN,  0x1.f101412abef2cp+459,   -0x1.fd7c7d8dfd9a6p-1,  -0x1.32da06p-3, INEXACT)
T(RN,  0x1.3f7ebc7061b62p+459,    0x1.e715250ec6577p-1,  -0x1.615082p-3, INEXACT)
T(RN,  0x1.5062c0cc3af88p+459,   -0x1.fcf1ea2126e41p-1,   -0x1.7e128p-2, INEXACT)
T(RN,  0x1.6ae1c5058f002p+459,   -0x1.69de23d9c23b5p-1,   0x1.62510cp-5, INEXACT)
T(RN,    0x1.40225ec8a3dp+459,    0x1.5566ae7411faep-1,  -0x1.7f9698p-2, INEXACT)
T(RN,  0x1.4931ae4eefa86p+459,    0x1.f8556ce126aaap-1,  -0x1.dd86f2p-3, INEXACT)
T(RN,  0x1.2f78da7fc9534p+459,   -0x1.31c4e99e533dbp-1,   0x1.f1412ap-9, INEXACT)
T(RN,  0x1.30097825a2c42p+460,   -0x1.e949846b24448p-1,  -0x1.e90388p-3, INEXACT)
T(RN,  0x1.4806e3b499fbap+460,   -0x1.dc8f7e79d42b6p-1,   0x1.01f48cp-2, INEXACT)
T(RN,  0x1.8bbcdff427c92p+460,   -0x1.ba9094e8779e7p-4,   0x1.0c0046p-4, INEXACT)
T(RN,  0x1.af8442faf44eap+460,   -0x1.11396bfed4f4bp-1,   0x1.22376ep-3, INEXACT)
T(RN,    0x1.0dce81aeadep+460,    0x1.08ece8697636bp-1,    0x1.9ab4cp-4, INEXACT)
T(RN,  0x1.986155ac22f4cp+460,    0x1.55e093ccacce6p-6,  -0x1.89e696p-3, INEXACT)
T(RN,  0x1.d518c1d522c08p+460,   -0x1.b27962a77b476p-1,   0x1.e3f63ep-2, INEXACT)
T(RN,  0x1.b2185b3590f98p+460,    0x1.64f9912be2923p-2,   0x1.edc25cp-2, INEXACT)
T(RN,  0x1.5dfae0e7a7362p+460,    0x1.51d6302285529p-1,  -0x1.e34828p-5, INEXACT)
T(RN,  0x1.1071162e9bb63p+460,   -0x1.a967ae3e6352ep-1,  -0x1.8e13e6p-2, INEXACT)
T(RN,  0x1.9fbb4a1e49405p+461,     0x1.0f2349a2d8a4p-1,   0x1.ce9724p-2, INEXACT)
T(RN,  0x1.8d07c34605316p+461,   -0x1.1998bb197ca2cp-2,  -0x1.f533e6p-3, INEXACT)
T(RN,  0x1.8ed0cb812f838p+461,   -0x1.f913cd8357b03p-1,    0x1.7270cp-2, INEXACT)
T(RN,  0x1.c92df7e9eba76p+461,    0x1.e055d80a515c1p-1,  -0x1.d3db98p-4, INEXACT)
T(RN,  0x1.2c5ce976d7db6p+461,   -0x1.4bd704fe3e679p-5,    0x1.cfe32p-5, INEXACT)
T(RN,  0x1.07a943d56f18dp+461,   -0x1.73a381eb900ebp-1,   0x1.ac869cp-4, INEXACT)
T(RN,  0x1.0fb494abadf54p+461,   -0x1.e30701aa6e049p-1,  -0x1.bb79cap-4, INEXACT)
T(RN,  0x1.45c592985431fp+461,   -0x1.9d1a069d4d0ffp-2,    0x1.9ac0ap-2, INEXACT)
T(RN,  0x1.770ae8288cec6p+461,   -0x1.1ae9b62f63bfdp-5,    0x1.7b484p-2, INEXACT)
T(RN,   0x1.c3e4d6faa1bep+461,   -0x1.f77ccc68ee988p-1,   -0x1.2758ap-3, INEXACT)
T(RN,  0x1.19133dcacff2ap+462,   -0x1.fdf4c56ed3a32p-1,  -0x1.5a3064p-2, INEXACT)
T(RN,  0x1.867093d67415ep+462,    0x1.21f7d72c60099p-1,  -0x1.86b65ap-2, INEXACT)
T(RN,  0x1.cc27689257be4p+462,   -0x1.7e9a85aa84d36p-1,   0x1.41eccep-3, INEXACT)
T(RN,  0x1.7b3dcd8e9cbb8p+462,     0x1.ae916c30b489p-3,   -0x1.d85d8p-2, INEXACT)
T(RN,  0x1.797293dc141fep+462,   -0x1.63f5f0cd0727ap-1,   0x1.bd4fc8p-5, INEXACT)
T(RN,   0x1.af0c990adfcdp+462,   -0x1.437fc2cd43218p-3,   0x1.df69cap-6, INEXACT)
T(RN,  0x1.5c3c984bc5fbep+462,    0x1.1a0b92789e737p-2,   0x1.0f2f96p-3, INEXACT)
T(RN,  0x1.97d4d1703fc32p+462,   -0x1.ced6e08ad81e8p-1,    0x1.3d25ep-3, INEXACT)
T(RN,  0x1.ca470c8529b75p+462,    0x1.264506c4d98c8p-1,   0x1.c70256p-2, INEXACT)
T(RN,  0x1.451d409cb2fc3p+462,    0x1.6d7a3e55e2cc9p-1,  -0x1.852916p-2, INEXACT)
T(RN,  0x1.4a89b15368fcap+463,   -0x1.1dac1e6cdf2c7p-1,   0x1.4c9a32p-2, INEXACT)
T(RN,  0x1.6c8319ec97968p+463,    0x1.37a8a8dc6a006p-1,  -0x1.4c2b22p-4, INEXACT)
T(RN,  0x1.4ba0e8c1961dap+463,    0x1.fabf85523bc99p-1,   0x1.020514p-3, INEXACT)
T(RN,  0x1.0ae3b75fba609p+463,   -0x1.bc9aaf51ce5a7p-1,   0x1.aa8b1cp-2, INEXACT)
T(RN,  0x1.0b7897f5b7b73p+463,   -0x1.1f54d2903b228p-1,  -0x1.53b44ap-2, INEXACT)
T(RN,   0x1.3b47e1e2c46fp+463,    0x1.f49c710b23148p-2,   0x1.e55bfcp-3, INEXACT)
T(RN,  0x1.96f5d198b5a54p+463,    0x1.843b45122cf99p-2,   0x1.7fdd38p-5, INEXACT)
T(RN,  0x1.975860b5d02a5p+463,    0x1.ed2868e3b2124p-1,   0x1.741f1ap-3, INEXACT)
T(RN,   0x1.df12d966a65ep+463,   -0x1.67cc5fc596d09p-1,   0x1.a333b2p-2, INEXACT)
T(RN,  0x1.d0f49bcf72764p+463,    0x1.0078fce5fb137p-2,   -0x1.6cdc2p-2, INEXACT)
T(RN,  0x1.c4edd8d8639c3p+464,    0x1.4513ca3608792p-2,  -0x1.1873e2p-3, INEXACT)
T(RN,  0x1.12685466c9da1p+464,    0x1.7dc1429d0d3bdp-1,   0x1.83d7b4p-3, INEXACT)
T(RN,  0x1.b479abbc7aa34p+464,    0x1.bcc3cbd1b4eadp-1,  -0x1.424d5ep-2, INEXACT)
T(RN,  0x1.a7c05faa847a8p+464,   -0x1.e886ebaf5f1c9p-1,   -0x1.4bb28p-2, INEXACT)
T(RN,  0x1.29ef0e64c7271p+464,    0x1.fd41c08784b7dp-1,  -0x1.1eade6p-2, INEXACT)
T(RN,  0x1.865b24fd29c34p+464,   -0x1.747b74b95b4aep-4,   -0x1.80231p-5, INEXACT)
T(RN,  0x1.4ccec7f55331ap+464,   -0x1.d1fc4e071f398p-1,  -0x1.889a4ep-2, INEXACT)
T(RN,  0x1.78dd153f058fcp+464,    0x1.94d3b72f946c6p-1,   -0x1.a50ffp-2, INEXACT)
T(RN,  0x1.56b66d22030cap+464,   -0x1.ff9c73ccd915fp-1,   0x1.9b4412p-2, INEXACT)
T(RN,  0x1.dc6cf74fd12c6p+464,    0x1.d05dff57b2f87p-1,   -0x1.50dfdp-2, INEXACT)
T(RN,  0x1.f0b47e94d2a8ap+465,   -0x1.44087bc806a55p-1,  -0x1.3c51b8p-2, INEXACT)
T(RN,  0x1.8f2327aa379eap+465,   -0x1.e53cf27652533p-1,   0x1.fbcc3ap-2, INEXACT)
T(RN,  0x1.e93a505098699p+465,    0x1.b6a57f748d97dp-2,   0x1.45dd42p-3, INEXACT)
T(RN,  0x1.932642530548ep+465,   -0x1.ae825ce7f2ea8p-1,   0x1.34b32cp-2, INEXACT)
T(RN,  0x1.5c99fec0d086ep+465,   -0x1.ffff632c27d34p-1,  -0x1.f5ab26p-4, INEXACT)
T(RN,  0x1.8cd3ddd6db306p+465,    0x1.42c9cbe9e5498p-1,   -0x1.4c433p-5, INEXACT)
T(RN,  0x1.3f22ec89813a9p+465,   -0x1.425204f8a16e5p-2,   0x1.fc728cp-3, INEXACT)
T(RN,   0x1.c3a703d0f95fp+465,   -0x1.2d4c104c865d9p-3,   0x1.8554d4p-2, INEXACT)
T(RN,  0x1.3d6d4048eb52ap+465,    0x1.08f92b6afbe03p-2,   0x1.f4a026p-4, INEXACT)
T(RN,  0x1.807d9c8c92adcp+465,    -0x1.ced2f50dd1b1p-1,  -0x1.979d98p-4, INEXACT)
T(RN,  0x1.28c30f95f6dd6p+466,    0x1.fa853f04ad3cap-2,  -0x1.14a6f4p-2, INEXACT)
T(RN,  0x1.9394c913b8b35p+466,   -0x1.83790d87e3e8ap-4,  -0x1.3c20eap-2, INEXACT)
T(RN,  0x1.b6253cc890ea4p+466,    0x1.bc1ebc97003f8p-1,  -0x1.8c9b6ep-3, INEXACT)
T(RN,  0x1.53533e152d006p+466,   -0x1.a2c9ceb19284cp-1,  -0x1.c16046p-3, INEXACT)
T(RN,  0x1.6e0a32a44446ap+466,    0x1.497901349f5cfp-1,   -0x1.0c29cp-4, INEXACT)
T(RN,  0x1.9c6b8f4ef7248p+466,    0x1.f33f8ce095e54p-1,  -0x1.6da8f2p-2, INEXACT)
T(RN,  0x1.1c11963a24a9ap+466,    0x1.4759d1f97a77dp-1,   -0x1.2ee8bp-2, INEXACT)
T(RN,  0x1.1774a0f33e0c5p+466,   -0x1.e09cbfc90c971p-1,  -0x1.ecd122p-3, INEXACT)
T(RN,  0x1.2d7f43aff450cp+466,   -0x1.cdd1a50c14784p-1,  -0x1.1a043ep-3, INEXACT)
T(RN,  0x1.81398fa1c0052p+466,    0x1.e9dbd7244802ap-1,    -0x1.0518p-3, INEXACT)
T(RN,  0x1.5e31ffa89c388p+467,   -0x1.987170e8b23fep-1,   0x1.a68734p-3, INEXACT)
T(RN,  0x1.33d258a6606d8p+467,   -0x1.ebe3972d25265p-1,   0x1.214ff2p-4, INEXACT)
T(RN,   0x1.cbf2cc5d326ep+467,   -0x1.dd68d299fcde3p-1,   0x1.d6524ep-2, INEXACT)
T(RN,  0x1.fca534078d281p+467,    0x1.6c3ea44af23f1p-3,   0x1.2d0436p-2, INEXACT)
T(RN,  0x1.999f1c5f41e08p+467,   -0x1.a0618aa129874p-1,   -0x1.7bce9p-2, INEXACT)
T(RN,  0x1.5771a0a397f2ap+467,    -0x1.fffe3de03a98p-1,   0x1.2240a2p-7, INEXACT)
T(RN,  0x1.e0ba74653943ap+467,    0x1.f70887c173eecp-1,   0x1.302e88p-2, INEXACT)
T(RN,  0x1.786d4e745c6ffp+467,    -0x1.fef7a1c73b4bp-1,   -0x1.8876cp-2, INEXACT)
T(RN,  0x1.ab0ca69e9cff4p+467,    0x1.ffe78962733c3p-1,   0x1.fab5aep-4, INEXACT)
T(RN,  0x1.b82ec3356c9eep+467,    0x1.f3494c1320901p-1,   0x1.f7f726p-3, INEXACT)
T(RN,  0x1.188c3f20e93c3p+468,    0x1.0790c87a52c96p-1,   0x1.7a199ep-3, INEXACT)
T(RN,  0x1.e62e4c76c8ec3p+468,   -0x1.7b7441969779fp-2,   0x1.a16b2ap-3, INEXACT)
T(RN,  0x1.808fa9c7d6928p+468,   -0x1.fe749d4ffc8e7p-1,    -0x1.c90ep-2, INEXACT)
T(RN,  0x1.ca12a7e19452ap+468,    0x1.5b118c9d50b5fp-1,   -0x1.d4d6cp-4, INEXACT)
T(RN,  0x1.d4c4dc955958ep+468,   -0x1.f3a9eda7f7255p-1,  -0x1.23fef6p-2, INEXACT)
T(RN,  0x1.2d3ccde25adc5p+468,   -0x1.2b3da5ec60ff6p-1,  -0x1.7ffc8ep-3, INEXACT)
T(RN,  0x1.75369e5dccd2ep+468,   -0x1.20a5875f7a52fp-1,  -0x1.530052p-2, INEXACT)
T(RN,  0x1.a668c113a3431p+468,    0x1.272566530e45dp-4,  -0x1.48998ap-3, INEXACT)
T(RN,  0x1.06a6261583e14p+468,    0x1.85b9978d027b4p-1,   0x1.daf7e8p-4, INEXACT)
T(RN,  0x1.992e1ba05eb4cp+468,    0x1.e188792363d1bp-2,   0x1.c6386ep-5, INEXACT)
T(RN,  0x1.5b4409114b4dap+469,   -0x1.0caf51e242d59p-3,   0x1.9346bcp-2, INEXACT)
T(RN,   0x1.d682e2d02411p+469,    0x1.294328edc09f4p-1,  -0x1.552234p-2, INEXACT)
T(RN,  0x1.94c7e3faafe17p+469,   -0x1.d487b34097311p-2,   0x1.3bb20cp-4, INEXACT)
T(RN,  0x1.7bc7838602a46p+469,   -0x1.3fc7ace9436a9p-1,  -0x1.b5a518p-4, INEXACT)
T(RN,  0x1.cc051c158b9a7p+469,   -0x1.8e08a1d2b5522p-1,  -0x1.3a2a34p-2, INEXACT)
T(RN,  0x1.af0d28ec8fe56p+469,    0x1.af634fa9634ddp-1,    0x1.a79a1p-2, INEXACT)
T(RN,  0x1.8122c23bd6a51p+469,   -0x1.f8a71240c5ad7p-1,  -0x1.352cf8p-3, INEXACT)
T(RN,  0x1.84e7c2541dd6ap+469,   -0x1.4d00c5411eb34p-1,  -0x1.906d56p-2, INEXACT)
T(RN,   0x1.0a51c0c30329p+469,    0x1.0be186f38fbccp-1,  -0x1.63e02ap-3, INEXACT)
T(RN,  0x1.9af83a7350351p+469,    0x1.fd157cb9ca4ddp-1,   0x1.b7c04ep-2, INEXACT)
T(RN,  0x1.dd137c0fae66ep+470,    0x1.d177ac5bb39bap-2,  -0x1.ab4bc2p-4, INEXACT)
T(RN,  0x1.a6eca6aa54d69p+470,    -0x1.b4ee809e1df7p-2,  -0x1.769574p-2, INEXACT)
T(RN,  0x1.db6ebc3d07dddp+470,    0x1.ebc233214d193p-1,   0x1.96ef24p-3, INEXACT)
T(RN,  0x1.bb024f4969f06p+470,   -0x1.5254f51b2d673p-1,   0x1.6592bcp-2, INEXACT)
T(RN,  0x1.af3b0c4733c38p+470,   -0x1.fecfa1e7e17e9p-1,   0x1.aae2b4p-2, INEXACT)
T(RN,  0x1.4652d527ddde4p+470,    0x1.919f11cdc692fp-4,  -0x1.cc10e2p-3, INEXACT)
T(RN,  0x1.b2ac034f43c63p+470,   -0x1.3c58e6facf062p-1,  -0x1.b714c8p-4, INEXACT)
T(RN,  0x1.3da6c2d3097dap+470,   -0x1.c459af92fdcefp-1,   0x1.5b8d38p-5, INEXACT)
T(RN,  0x1.40cf454ad4a08p+470,    0x1.bef9077838b82p-1,   0x1.be6342p-3, INEXACT)
T(RN,  0x1.a2712dfb592dfp+470,   -0x1.ed97f1673547ep-1,  -0x1.4c5712p-2, INEXACT)
T(RN,  0x1.8859481fea7d2p+471,   -0x1.9df9a3031bd9dp-3,   0x1.7905c2p-2, INEXACT)
T(RN,  0x1.26428303d722bp+471,   -0x1.5d03534ec1cf6p-1,   0x1.ca2d5cp-5, INEXACT)
T(RN,  0x1.46d6717bc638ep+471,    0x1.4c492b6682086p-1,  -0x1.c9b06ep-2, INEXACT)
T(RN,  0x1.74b6146764f66p+471,   -0x1.a912c1497c9c5p-1,  -0x1.04c18cp-3, INEXACT)
T(RN,  0x1.ae14a333aa742p+471,   -0x1.decaf1bb4975ep-1,  -0x1.fae71cp-6, INEXACT)
T(RN,  0x1.c240ee088df6ep+471,    0x1.f409f855db05cp-3,  -0x1.22ffe2p-2, INEXACT)
T(RN,  0x1.6444182ce0db2p+471,    0x1.bedbf14ce6102p-1,   0x1.1fa4a6p-2, INEXACT)
T(RN,  0x1.d34f06b5d1859p+471,    0x1.c39273ff55346p-1,  -0x1.4c3b44p-2, INEXACT)
T(RN,  0x1.49da8e165862cp+471,    0x1.8284427ce052cp-1,   0x1.2d312ep-2, INEXACT)
T(RN,  0x1.80574eecbfa41p+471,    0x1.598a348ba9edap-2,  -0x1.40dc8ap-2, INEXACT)
T(RN,  0x1.55a08dc0bdf5ep+472,    0x1.f2686c780c9f1p-1,   0x1.b21258p-2, INEXACT)
T(RN,  0x1.96534bcbf7e0cp+472,   -0x1.5cc71144ae785p-1,  -0x1.c8efb4p-2, INEXACT)
T(RN,  0x1.e7827ed01b044p+472,    0x1.3f53a906d38e5p-3,  -0x1.221ba2p-3, INEXACT)
T(RN,  0x1.c31619fe776e2p+472,    0x1.f5487f84c61e7p-3,   0x1.023a86p-4, INEXACT)
T(RN,  0x1.11e6cccf82707p+472,    0x1.01f0cc180dd3ap-1,  -0x1.b6f03cp-3, INEXACT)
T(RN,   0x1.7b1a4127d97bp+472,    0x1.6da374820b8cdp-1,  -0x1.de4704p-2, INEXACT)
T(RN,  0x1.5b36d5db8a851p+472,   -0x1.d709e9885c9cep-1,   0x1.5e81e8p-2, INEXACT)
T(RN,  0x1.73c4250084ccdp+472,   -0x1.f4e768f344903p-1,   0x1.baf996p-3, INEXACT)
T(RN,  0x1.9fc0270babba4p+472,   -0x1.5d23900cec664p-1,   0x1.188274p-2, INEXACT)
T(RN,  0x1.cc5762bb854e2p+472,    0x1.58c37127fd765p-3,  -0x1.84ea72p-2, INEXACT)
T(RN,  0x1.c995322c97b98p+473,   -0x1.bc9b87b2057fcp-1,  -0x1.7eafccp-2, INEXACT)
T(RN,  0x1.a6a2cc37c3492p+473,     0x1.f7873dc8da58p-1,  -0x1.45189ap-3, INEXACT)
T(RN,  0x1.e9f4cb2a4724ap+473,   -0x1.f6ef387f3a8d4p-2,   0x1.423512p-3, INEXACT)
T(RN,   0x1.6818a8705eaap+473,   -0x1.77e3e9ac5cf8ap-1,   0x1.761368p-2, INEXACT)
T(RN,  0x1.56a7f49887f29p+473,    0x1.3e036c7c84f7bp-1,   0x1.27a45cp-2, INEXACT)
T(RN,  0x1.263fbd92f6b8bp+473,   -0x1.c017edef809aap-7,   0x1.c8cc46p-6, INEXACT)
T(RN,  0x1.90dac14528c78p+473,    0x1.fdce9a80482d5p-1,  -0x1.946404p-3, INEXACT)
T(RN,   0x1.aaf4b94b5546p+473,   -0x1.80a5242b4404dp-1,  -0x1.9ec30ep-3, INEXACT)
T(RN,  0x1.950d6d13bf639p+473,   -0x1.1922a3310d898p-1,   0x1.be2facp-2, INEXACT)
T(RN,  0x1.51bd6e96c0357p+473,    0x1.fff20b73b004fp-1,   0x1.cc852cp-2, INEXACT)
T(RN,  0x1.5710ef43880b8p+474,    0x1.d7b48abe3c051p-1,    0x1.c3e39p-4, INEXACT)
T(RN,  0x1.138fdc51bdb45p+474,   -0x1.f3b2079bd24f7p-3,   0x1.1798d6p-2, INEXACT)
T(RN,   0x1.821b636f8778p+474,    0x1.c25d2c50d6354p-6,  -0x1.6934f6p-3, INEXACT)
T(RN,  0x1.4ad5b145df38cp+474,    0x1.f7de6a02d0321p-1,    0x1.067edp-2, INEXACT)
T(RN,  0x1.eae8fa7de3365p+474,   -0x1.89d1d3a49fdbep-5,   0x1.70fd44p-2, INEXACT)
T(RN,  0x1.0a2b2e5634cf2p+474,   -0x1.97d489ac9361ap-1,    0x1.c1189p-2, INEXACT)
T(RN,  0x1.b630cb16c8ca4p+474,     0x1.c153a34ccc35p-1,  -0x1.60642cp-2, INEXACT)
T(RN,  0x1.4a209f17718eap+474,   -0x1.2c755f256e462p-2,  -0x1.cb97b8p-3, INEXACT)
T(RN,  0x1.7927cccfe3c77p+474,   -0x1.7bf3289c5ca69p-1,  -0x1.cd50d2p-7, INEXACT)
T(RN,  0x1.80e54e6fff3bap+474,    0x1.2ecb6ae162695p-2,  -0x1.311dccp-2, INEXACT)
T(RN,  0x1.c1b6cd13d9a1ap+475,   -0x1.242c99078da7cp-4,  -0x1.c63176p-2, INEXACT)
T(RN,  0x1.f636393271ecdp+475,   -0x1.ff0363f52e1e9p-6,  -0x1.d4632ap-3, INEXACT)
T(RN,  0x1.2706c6b7a262ap+475,    0x1.d01bca1088867p-2,   0x1.708456p-2, INEXACT)
T(RN,  0x1.9e40b45219398p+475,    0x1.fcecd2d28bfe4p-1,   0x1.8c2434p-2, INEXACT)
T(RN,  0x1.71c5fec9e6a35p+475,    0x1.0d972a1a6cb12p-1,   0x1.d0c52cp-2, INEXACT)
T(RN,  0x1.c5825ece5abdap+475,   -0x1.fff91ac5b9764p-1,  -0x1.febe84p-3, INEXACT)
T(RN,  0x1.2af9de5c4343bp+475,    0x1.b40f8514c2b02p-1,    0x1.b0862p-2, INEXACT)
T(RN,  0x1.f63236ab7aa47p+475,    0x1.27ec7a44f14b3p-1,  -0x1.d004f6p-3, INEXACT)
T(RN,  0x1.1fb9a149a2211p+475,    0x1.8932ab62c15aep-2,   0x1.44e9acp-2, INEXACT)
T(RN,  0x1.2f69b6a3d24eep+475,    0x1.56a41bd98cc2cp-2,  -0x1.2b685cp-2, INEXACT)
T(RN,  0x1.4de14f8a23952p+476,    0x1.d96ef341ca852p-1,  -0x1.184e26p-2, INEXACT)
T(RN,  0x1.e3725627eaa4cp+476,   -0x1.80ee32292a193p-1,   0x1.ee5a3cp-5, INEXACT)
T(RN,  0x1.f682c218e6116p+476,   -0x1.323f0c5fe35efp-2,   0x1.0f493cp-2, INEXACT)
T(RN,  0x1.c88bf1eb92854p+476,    0x1.bbf571a4b36bcp-3,   0x1.831922p-5, INEXACT)
T(RN,  0x1.9d4dcec205a54p+476,   -0x1.3ba9169f7f15bp-2,  -0x1.718622p-4, INEXACT)
T(RN,  0x1.245077b345e05p+476,   -0x1.fdd5192b43e62p-1,  -0x1.da306cp-4, INEXACT)
T(RN,  0x1.87744e637e4ccp+476,   -0x1.4cada3dfce7e2p-2,    0x1.d8271p-2, INEXACT)
T(RN,  0x1.6ae4404bb05e6p+476,    0x1.a170fb99661c8p-1,   0x1.e2b98ap-2, INEXACT)
T(RN,  0x1.e30d9801568ddp+476,    0x1.802ecce414782p-1,   0x1.f8fb66p-2, INEXACT)
T(RN,  0x1.1f6a325bbb904p+476,    0x1.f891f0a4bb1d9p-1,    0x1.eaa7fp-2, INEXACT)
T(RN,  0x1.cf82235420866p+477,    0x1.f6ffb69b5a887p-1,  -0x1.a93b0ep-7, INEXACT)
T(RN,  0x1.be7f31b39c7cap+477,    0x1.f9bd2abca4012p-1,  -0x1.6f0266p-4, INEXACT)
T(RN,  0x1.b53b2187c4916p+477,   -0x1.f3ab008053bb4p-1,   0x1.047e92p-2, INEXACT)
T(RN,  0x1.470e46feb6b77p+477,   -0x1.f7755be15fd3cp-1,   0x1.5b9c7ap-2, INEXACT)
T(RN,  0x1.c6f5d044c06cep+477,   -0x1.77b5a4836b322p-1,  -0x1.b357e4p-4, INEXACT)
T(RN,  0x1.7142b14e88c84p+477,    -0x1.52df071d6563p-1,   0x1.ad4c82p-3, INEXACT)
T(RN,  0x1.17bbf2bc44982p+477,   -0x1.eef58f0b8b83ap-1,   0x1.d28adap-3, INEXACT)
T(RN,  0x1.7893c7444a70cp+477,     0x1.fb98ac0aa957p-1,  -0x1.3ae746p-2, INEXACT)
T(RN,   0x1.89428bae2d4ap+477,   -0x1.fe15b4ddd4947p-1,   0x1.308aa6p-2, INEXACT)
T(RN,  0x1.fb2b351cbe9f8p+477,   -0x1.869a0644c3703p-1,  -0x1.db9686p-2, INEXACT)
T(RN,  0x1.a50efeaaca808p+478,     0x1.cc0ddb021f5bp-1,   0x1.271bd4p-2, INEXACT)
T(RN,  0x1.56d4555a219dcp+478,    0x1.cecaa5bfef573p-1,    -0x1.7132p-2, INEXACT)
T(RN,  0x1.883f887917fb2p+478,   -0x1.0780da2345adep-1,   0x1.59f796p-4, INEXACT)
T(RN,  0x1.8b7e878c57d67p+478,    0x1.5c5791b45d524p-1,   -0x1.52fc9p-2, INEXACT)
T(RN,  0x1.b1b291e0b589cp+478,    0x1.fadaf3f0cbf53p-1,  -0x1.ac9378p-2, INEXACT)
T(RN,  0x1.42520b430ef94p+478,   -0x1.fb2ca21b6d409p-1,   0x1.c98cf6p-5, INEXACT)
T(RN,  0x1.d75c0303a543ep+478,   -0x1.1bdb0a0f169b8p-1,   -0x1.78f44p-3, INEXACT)
T(RN,  0x1.460dcaeb3d9bep+478,   -0x1.f7a0e4564ae77p-5,  -0x1.8067d6p-2, INEXACT)
T(RN,  0x1.fd3ed24a4bf62p+478,    0x1.a0dfdeafe9049p-2,   0x1.829308p-2, INEXACT)
T(RN,  0x1.00c574506e376p+478,   -0x1.ffe4aa786953ap-1,   0x1.5ec5b6p-3, INEXACT)
T(RN,  0x1.a588be65741b7p+479,    0x1.c53f494317216p-1,  -0x1.abf598p-2, INEXACT)
T(RN,  0x1.914ae5bfb5b93p+479,    -0x1.f66023dbea99p-1,   0x1.41934ap-2, INEXACT)
T(RN,  0x1.6ea54664a07bbp+479,   -0x1.5b5619c07a3ecp-1,  -0x1.000958p-2, INEXACT)
T(RN,  0x1.635a7128fb10ap+479,   -0x1.7abe318e9d54ep-1,   0x1.eaecbep-2, INEXACT)
T(RN,  0x1.e4d959e3e5aacp+479,   -0x1.dcdaef4e77f1ep-3,   0x1.4a7152p-3, INEXACT)
T(RN,  0x1.0cbd3627ffef6p+479,    0x1.faf457058cd9ap-1,  -0x1.d61884p-2, INEXACT)
T(RN,   0x1.7ed9d8baddf1p+479,   -0x1.fc971ca58d895p-1,   0x1.d4d0eap-2, INEXACT)
T(RN,  0x1.7d795a37a83acp+479,    0x1.62dc39933c2aep-2,   0x1.90931ap-6, INEXACT)
T(RN,  0x1.1374e81674cb7p+479,   -0x1.38c4b0eb9c27dp-1,   -0x1.c375ep-5, INEXACT)
T(RN,  0x1.9834690eac036p+479,    0x1.b6fdf9d167247p-1,   0x1.8588ecp-2, INEXACT)
T(RN,  0x1.4f3ae752db0f9p+480,   -0x1.fb71012a67525p-1,   0x1.e5a11ep-2, INEXACT)
T(RN,  0x1.8855affa4878cp+480,   -0x1.d96ab6d9693dep-1,  -0x1.fd89a8p-3, INEXACT)
T(RN,  0x1.3a3d79baba72fp+480,   -0x1.c87e94bb958adp-1,   0x1.76f148p-3, INEXACT)
T(RN,  0x1.41be24381f112p+480,   -0x1.36536512c0911p-1,  0x1.a331e6p-10, INEXACT)
T(RN,  0x1.e78bd13569e4dp+480,    0x1.dbc2e54935419p-1,  -0x1.2d4d0cp-2, INEXACT)
T(RN,  0x1.273842e7e08cep+480,    0x1.01995a0c73b53p-1,   0x1.635ce8p-2, INEXACT)
T(RN,  0x1.4fa2f15c69a1cp+480,   -0x1.0d49326263ed2p-1,   0x1.805fd8p-2, INEXACT)
T(RN,  0x1.37efd794c7c8cp+480,    0x1.e99346361f7c9p-1,   0x1.eecedap-4, INEXACT)
T(RN,  0x1.044e2a6bcd5f8p+480,    0x1.d495ca63cbb48p-1,  -0x1.91f536p-2, INEXACT)
T(RN,  0x1.b4219859a3b8cp+480,   -0x1.eb9224ec82082p-1,  -0x1.38f00ep-5, INEXACT)
T(RN,  0x1.10689871f8819p+481,    0x1.e130262f3201fp-5,  -0x1.aae1e6p-3, INEXACT)
T(RN,  0x1.722de96cd5ddap+481,   -0x1.35e362fe1550ap-1,  -0x1.f281b2p-3, INEXACT)
T(RN,  0x1.6d0efc0197e06p+481,    0x1.b20455a991feap-1,  -0x1.cd1adcp-2, INEXACT)
T(RN,  0x1.2cdcf716b4224p+481,    0x1.fcbc80ad2f575p-2,  -0x1.d1d77ap-2, INEXACT)
T(RN,  0x1.e00f11360a7d8p+481,    0x1.ff3bc844ab81fp-1,    0x1.fe116p-2, INEXACT)
T(RN,  0x1.82828d72ea025p+481,    0x1.06fb5bc16f09ep-1,   0x1.64340ep-2, INEXACT)
T(RN,  0x1.c0f0e91251cd8p+481,   -0x1.09bfc91704227p-1,   0x1.521b5ap-3, INEXACT)
T(RN,  0x1.3408a6c47c962p+481,    0x1.36405dfc8c315p-1,  -0x1.1af518p-2, INEXACT)
T(RN,  0x1.b9d29b8a3afdap+481,    0x1.d8b4ff8cb51cep-1,  -0x1.874be2p-2, INEXACT)
T(RN,   0x1.c90d64edc117p+481,   -0x1.c2f1cc0ac270fp-8,  -0x1.c95e9ep-2, INEXACT)
T(RN,  0x1.d165f0c4a3dd1p+482,   -0x1.fde4e9bf1cf1cp-1,     0x1.3feap-3, INEXACT)
T(RN,  0x1.d6b429b4b8c87p+482,   -0x1.7f5ac13d110c3p-4,  -0x1.e2f69ap-2, INEXACT)
T(RN,   0x1.387f26a34ef3p+482,   -0x1.697fb414efa37p-1,  -0x1.0fd988p-2, INEXACT)
T(RN,  0x1.c671aac6dc882p+482,    0x1.3bf1e2cf02fb3p-2,   0x1.2a9a1ap-2, INEXACT)
T(RN,  0x1.8c0b7cf543f9ep+482,   -0x1.ff69367f547bdp-1,   0x1.28f53ap-3, INEXACT)
T(RN,  0x1.d98a8ad6e726ep+482,   -0x1.dd5d7b43842b2p-1,   0x1.171b5ep-2, INEXACT)
T(RN,  0x1.892ac51932726p+482,   -0x1.d1b01ead96dc4p-3,   0x1.43fa4ep-2, INEXACT)
T(RN,   0x1.e1f976a48056p+482,   -0x1.fd9633053ee69p-1,   0x1.45f70ap-5, INEXACT)
T(RN,  0x1.4bb29be2cdec7p+482,    0x1.13403f5d825d9p-1,    0x1.7d2f1p-2, INEXACT)
T(RN,  0x1.9517eb9be37fep+482,    0x1.fea7e8cae4619p-1,  -0x1.e0794ep-2, INEXACT)
T(RN,  0x1.02d83a5d6b9a9p+483,   -0x1.a12f9abd05057p-1,   0x1.b14bcep-2, INEXACT)
T(RN,  0x1.ca085ea71992cp+483,    0x1.c4040ca2639e1p-1,  -0x1.5d87b4p-3, INEXACT)
T(RN,  0x1.3160c911ec3cep+483,    0x1.ce32bc51a1211p-1,  -0x1.c674c2p-8, INEXACT)
T(RN,  0x1.5764d13376a54p+483,   -0x1.c49e3a7c9d0a2p-1,     0x1.35fbp-2, INEXACT)
T(RN,  0x1.9791f9feeee06p+483,    0x1.e4037015c1b45p-1,   0x1.a6217ap-3, INEXACT)
T(RN,  0x1.a539d7e19180ap+483,    0x1.5eb18c38c30b2p-2,  -0x1.69d54ep-3, INEXACT)
T(RN,  0x1.546a75335da3bp+483,   -0x1.a7a617cca4fffp-2,   0x1.b3e48cp-4, INEXACT)
T(RN,  0x1.0c564ccdc733fp+483,   -0x1.bbb825655335ap-1,   0x1.72279ap-5, INEXACT)
T(RN,   0x1.1953c2e633b2p+483,    0x1.1120cb407606cp-3,   0x1.49b006p-2, INEXACT)
T(RN,  0x1.131241366522dp+483,    0x1.dcf74bc22aa56p-1,  -0x1.71a90ep-3, INEXACT)
T(RN,  0x1.4a61eff1e5125p+484,   -0x1.70dd8021e21c4p-6,  -0x1.0ddcc6p-4, INEXACT)
T(RN,  0x1.3a09e6d3f1898p+484,    0x1.f548a3df584b2p-1,  -0x1.648ac8p-3, INEXACT)
T(RN,  0x1.073abcdebe0cbp+484,    0x1.5b674f2ad353bp-1,  -0x1.3ddd44p-5, INEXACT)
T(RN,  0x1.b610436c1f1cap+484,   -0x1.20b82afa3ec8ep-1,   0x1.32a20ep-3, INEXACT)
T(RN,  0x1.f210ba49e2fb4p+484,   -0x1.b261c62b20ef1p-1,   0x1.42f65cp-2, INEXACT)
T(RN,  0x1.e15e73396cb1ep+484,    0x1.964febcd672d8p-4,  -0x1.333f76p-2, INEXACT)
T(RN,  0x1.88f40917e8695p+484,   -0x1.cc39bda57cd67p-1,  -0x1.d15734p-3, INEXACT)
T(RN,  0x1.d7eb499e8b596p+484,   -0x1.fb639e9bb5233p-1,   0x1.bf31a4p-2, INEXACT)
T(RN,  0x1.0611a68b44a39p+484,    0x1.f8fce37f3f043p-1,   0x1.c4b6fcp-2, INEXACT)
T(RN,  0x1.82421ba0adaacp+484,   -0x1.8934ec4ecbaf2p-1,   0x1.4a4694p-2, INEXACT)
T(RN,  0x1.394c9e05c2036p+485,   -0x1.3ec369a0dc99ep-1,  -0x1.8e0478p-2, INEXACT)
T(RN,  0x1.7a1dacf482f9ap+485,    0x1.1612899cb032ap-1,   0x1.6d7edcp-5, INEXACT)
T(RN,  0x1.91f73e7a1ed82p+485,    0x1.dd6242737ff06p-1,   0x1.9380b6p-3, INEXACT)
T(RN,  0x1.a3888f09b2d1ap+485,    0x1.8b22c669bf931p-3,   0x1.5058b4p-4, INEXACT)
T(RN,  0x1.3166b85d455a9p+485,   -0x1.ef1d244280474p-1,   0x1.2f535cp-3, INEXACT)
T(RN,  0x1.dd11479471fa2p+485,    0x1.eee04e371c269p-2,  -0x1.763a24p-5, INEXACT)
T(RN,  0x1.16291fee4bbb8p+485,    -0x1.19a049fddd5fp-3,   -0x1.dc6a8p-3, INEXACT)
T(RN,  0x1.25c1630804219p+485,    0x1.6ff2c877d90c7p-1,  -0x1.5f761ap-5, INEXACT)
T(RN,   0x1.280915de9ddbp+485,   -0x1.c7f0721968036p-1,   -0x1.529e4p-2, INEXACT)
T(RN,  0x1.dfc0582029ac7p+485,   -0x1.ffb22841c350bp-1,   -0x1.e48b9p-2, INEXACT)
T(RN,  0x1.5148ae1df786bp+486,    0x1.518e51fbdf44bp-2,  -0x1.bb8c72p-2, INEXACT)
T(RN,  0x1.64b7d78cf0f01p+486,   -0x1.cb51f72861d93p-2,   0x1.7d5dbep-7, INEXACT)
T(RN,  0x1.83b9206ceb684p+486,   -0x1.fc3ef35879282p-1,   0x1.5f8436p-2, INEXACT)
T(RN,  0x1.6a5e946cecbc4p+486,    -0x1.f253ecdea24dp-1,   0x1.937f38p-2, INEXACT)
T(RN,  0x1.99b921a706663p+486,    0x1.350a8010a13e6p-3,  -0x1.b794d4p-4, INEXACT)
T(RN,  0x1.0410e58be6fe6p+486,   -0x1.5f6635933bc26p-4,    -0x1.8052p-3, INEXACT)
T(RN,  0x1.fcf92736ba0f2p+486,   -0x1.f90104ee5cc73p-1,   0x1.6496aap-2, INEXACT)
T(RN,  0x1.2218c3b9079b9p+486,   -0x1.efb01d58d110ep-1,   0x1.b29ee8p-7, INEXACT)
T(RN,  0x1.ea03f0e6291b2p+486,    0x1.0a65157802b4cp-2,   0x1.0abb82p-2, INEXACT)
T(RN,  0x1.4abbe4c59d05cp+486,    0x1.cccf07c629303p-1,  -0x1.a9b214p-4, INEXACT)
T(RN,  0x1.4ce4a26be4ebfp+487,   -0x1.fc09f46466ff4p-1,   -0x1.19e02p-4, INEXACT)
T(RN,  0x1.13da13304149cp+487,   -0x1.faa545c6d26dcp-1,   0x1.6d6eeap-2, INEXACT)
T(RN,  0x1.8b49076132b4fp+487,    0x1.ae4b07a88b5b1p-1,  -0x1.e71916p-2, INEXACT)
T(RN,  0x1.f8a3cceba3ea2p+487,   -0x1.28e89ec179f8fp-4,   0x1.5a6d92p-3, INEXACT)
T(RN,  0x1.95fd8f70d9607p+487,   -0x1.2e5832d8d72c1p-1,  -0x1.11b912p-2, INEXACT)
T(RN,  0x1.e9ca7373d1bdap+487,    0x1.97342bc00c03fp-3,  -0x1.0b47f6p-2, INEXACT)
T(RN,  0x1.8bb898043c084p+487,    0x1.038fad51bc23dp-2,   0x1.c52666p-2, INEXACT)
T(RN,  0x1.966a3002e101cp+487,    0x1.f9cfbc98e9baap-1,  -0x1.71c026p-3, INEXACT)
T(RN,  0x1.c6a6af6b6cf46p+487,    -0x1.997864d8c099p-5,   0x1.f2d642p-2, INEXACT)
T(RN,  0x1.256c815d4d93ep+487,   -0x1.fa709cacd55a5p-1,   0x1.ea02b6p-4, INEXACT)
T(RN,  0x1.62667dfabb825p+488,    -0x1.aa3ce05f5d12p-3,  -0x1.bdf9ccp-2, INEXACT)
T(RN,  0x1.523ec77414654p+488,   -0x1.1bbe48365eb95p-2,    0x1.ad136p-2, INEXACT)
T(RN,  0x1.8474a7c8d2926p+488,    0x1.17cffe6ec1402p-2,  -0x1.494d9cp-3, INEXACT)
T(RN,  0x1.842d33d14be9cp+488,    0x1.4dcabbede494ap-2,  -0x1.d78514p-2, INEXACT)
T(RN,  0x1.305495600b3c4p+488,   -0x1.d0cbce3faff79p-1,   0x1.4fc84ep-2, INEXACT)
T(RN,  0x1.8c4822b62569bp+488,    0x1.1a4ed63d8f973p-1,  -0x1.8468bep-4, INEXACT)
T(RN,  0x1.67e44e7c51433p+488,   -0x1.e70ec39759445p-1,  -0x1.d1492ap-2, INEXACT)
T(RN,  0x1.e90d1a9a5667cp+488,    0x1.a81b5355af197p-1,  -0x1.2b6cbcp-2, INEXACT)
T(RN,   0x1.fa7e327bc99fp+488,   -0x1.df7bbbd397f0fp-1,  -0x1.81bfc8p-4, INEXACT)
T(RN,  0x1.4499571c2d5c1p+488,    0x1.e9747cb09f784p-1,  -0x1.d4f1f2p-4, INEXACT)
T(RN,  0x1.74b4f43209c5bp+489,   -0x1.83db7bb691c2ap-1,   0x1.e2aa96p-2, INEXACT)
T(RN,  0x1.642b143dd220bp+489,   -0x1.69164e5938649p-5,  -0x1.4d854ap-3, INEXACT)
T(RN,  0x1.68ba636e02236p+489,     0x1.2339e2453da7p-1,   0x1.f0a568p-2, INEXACT)
T(RN,  0x1.d26fb91db0a01p+489,   -0x1.7635294ece0ebp-1,   0x1.5170e8p-2, INEXACT)
T(RN,  0x1.02fb435bf2a9bp+489,    0x1.2fa22c017f6f3p-1,   0x1.20aa7ap-2, INEXACT)
T(RN,  0x1.c690ec5fd439cp+489,   -0x1.eb42d51be4536p-2,  -0x1.5bde9ep-2, INEXACT)
T(RN,  0x1.9070f36d6c57ap+489,   -0x1.76477c3ec3292p-3,   0x1.af0dcep-2, INEXACT)
T(RN,  0x1.877c7c8b9f40ep+489,    0x1.f941c24093ee4p-1,  -0x1.2d2026p-2, INEXACT)
T(RN,  0x1.84090209c9fc8p+489,   -0x1.f9a60fd3d6fc1p-1,  -0x1.3d529ap-3, INEXACT)
T(RN,  0x1.e7a42a3ff7e1cp+489,   -0x1.dcb887053690cp-3,   0x1.bc94fep-2, INEXACT)
T(RN,  0x1.65f9666f965d2p+490,     -0x1.2a0a45b687cp-1,  -0x1.d13ee6p-2, INEXACT)
T(RN,  0x1.fe5da762f0ca8p+490,    0x1.31eef3695fe35p-2,   0x1.391636p-2, INEXACT)
T(RN,  0x1.93316ef586148p+490,   -0x1.d9cce64d66b39p-3,   0x1.15eb18p-2, INEXACT)
T(RN,  0x1.3a5b0f4279addp+490,   -0x1.2736db6b6f363p-7,   0x1.45a962p-4, INEXACT)
T(RN,  0x1.d850c184f9532p+490,    0x1.4bbff9dd6c87ep-2,  -0x1.e0b52ep-3, INEXACT)
T(RN,  0x1.0cd8535b7cb96p+490,    0x1.6b830e4be0df5p-1,   0x1.d9a7d6p-3, INEXACT)
T(RN,  0x1.73429231bb5c8p+490,   -0x1.e8f0827106e68p-1,   0x1.f88c96p-2, INEXACT)
T(RN,  0x1.6380533d85e88p+490,    0x1.a831441c49ee2p-1,   0x1.69b64ap-3, INEXACT)
T(RN,  0x1.9c675688611d3p+490,   -0x1.ff2d32922022fp-1,  -0x1.16aa3ep-2, INEXACT)
T(RN,  0x1.06dae5fd1849ap+490,   -0x1.bdf0371f14131p-1,   0x1.da5082p-3, INEXACT)
T(RN,  0x1.20ee4cc306914p+491,    0x1.f864ec1e6560bp-1,  -0x1.df86eep-3, INEXACT)
T(RN,  0x1.5bc67aa44ee59p+491,   -0x1.258243626b2f2p-1,   0x1.a7fb68p-2, INEXACT)
T(RN,  0x1.4bef15fd99922p+491,    0x1.93ddcb065052dp-1,   0x1.c46316p-2, INEXACT)
T(RN,  0x1.18400a60c4066p+491,    0x1.32075990d1757p-1,   0x1.9ee5cep-3, INEXACT)
T(RN,  0x1.5a3dc04af48b1p+491,   -0x1.cec432ea45fd2p-1,   0x1.08f86ep-2, INEXACT)
T(RN,   0x1.8ffeb7465f71p+491,   -0x1.acaa06b4c8bf6p-1,  -0x1.f9e1aap-3, INEXACT)
T(RN,  0x1.3a6bb16dab0e7p+491,   -0x1.b8abce6b667cap-2,   0x1.f4408ep-2, INEXACT)
T(RN,  0x1.1c8fa83a45f5cp+491,    0x1.dba4ab7ef0a6bp-3,  -0x1.5a9dd4p-2, INEXACT)
T(RN,  0x1.6dabbaa739b4ep+491,   -0x1.f5c8043ea990fp-1,    0x1.7117ap-3, INEXACT)
T(RN,  0x1.61468b2e9f544p+491,     0x1.d61b496cf411p-2,  -0x1.7e2feap-3, INEXACT)
T(RN,  0x1.7682a0d51159fp+492,   -0x1.f70d32db93c88p-1,   0x1.664318p-5, INEXACT)
T(RN,  0x1.cf591a2efda98p+492,    0x1.f4790bbce3eefp-1,   0x1.bd7a98p-6, INEXACT)
T(RN,  0x1.37f782a2a91fap+492,    0x1.0eadd1c2e3284p-1,   -0x1.1f1f6p-3, INEXACT)
T(RN,  0x1.fbc8814a2af43p+492,   -0x1.a39f2397bb829p-2,   0x1.ef4dcep-2, INEXACT)
T(RN,  0x1.fdc460c259cb2p+492,   -0x1.b60b51ecfb0b2p-1,  -0x1.4e855ap-4, INEXACT)
T(RN,   0x1.428fa88114eap+492,   -0x1.eff1acac3eb5ep-1,  -0x1.ac9f28p-2, INEXACT)
T(RN,  0x1.a52dff9098d3ap+492,    0x1.86f021dfee2c2p-4,   0x1.e2f1d4p-3, INEXACT)
T(RN,  0x1.4aa219714daa2p+492,    0x1.d21cd4159aaddp-4,   0x1.5788bap-2, INEXACT)
T(RN,  0x1.af21fc14aec3cp+492,   -0x1.cb44108d242b3p-1,   0x1.3769ccp-2, INEXACT)
T(RN,  0x1.d88dd63cfc884p+492,   -0x1.fdbb27c28e463p-1,   0x1.b68452p-3, INEXACT)
T(RN,  0x1.b79bff31b83c2p+493,    0x1.d63bddd2f737dp-1,   0x1.04976ep-3, INEXACT)
T(RN,  0x1.735ebd27628c6p+493,    0x1.f8bf87fc62295p-2,  -0x1.581f36p-2, INEXACT)
T(RN,  0x1.9d175321e8937p+493,   -0x1.5b769f6a354dep-1,   0x1.331438p-2, INEXACT)
T(RN,  0x1.2ac4f67c6fbfap+493,   -0x1.30a5aa44e9dcep-3,   0x1.28f49cp-7, INEXACT)
T(RN,  0x1.643d252aec86fp+493,    0x1.ed97c53d9d682p-2,   0x1.de958ep-2, INEXACT)
T(RN,  0x1.0b07c6ccbe1eep+493,   -0x1.f8fb07b77b70dp-1,    0x1.209d9p-3, INEXACT)
T(RN,  0x1.4b4e656a460a9p+493,   -0x1.9eb811e7a7233p-4,   0x1.6c0194p-2, INEXACT)
T(RN,  0x1.e0bfd4e8d5ea6p+493,    0x1.ed02ec64e263cp-1,  -0x1.14f28cp-4, INEXACT)
T(RN,  0x1.d97be9af34392p+493,    0x1.fcac19d067cc2p-1,  -0x1.2ea486p-5, INEXACT)
T(RN,  0x1.c887a55fda867p+493,   -0x1.c9608948ee6b5p-1,   0x1.7fd672p-3, INEXACT)
T(RN,  0x1.83052b4bfc5fcp+494,   -0x1.efef534685cc4p-1,   0x1.2ee3f2p-4, INEXACT)
T(RN,   0x1.41b7c7b3909ep+494,    0x1.1b4cae28b3a4ap-2,   0x1.a97432p-6, INEXACT)
T(RN,  0x1.45dc93f7f5d83p+494,   -0x1.9730f3eda20a9p-1,  -0x1.fda4b4p-2, INEXACT)
T(RN,  0x1.5da9752e12d34p+494,    0x1.a0a5a178829cbp-1,   -0x1.63913p-5, INEXACT)
T(RN,  0x1.2e0de2de32b59p+494,   -0x1.25a58a3f144bcp-2,  -0x1.8d20aep-3, INEXACT)
T(RN,  0x1.164d9ccc825a7p+494,   -0x1.4b25a230d950ap-1,   0x1.744e1ep-2, INEXACT)
T(RN,  0x1.81a8533fc7e0ep+494,    0x1.60f893c092773p-4,   -0x1.a17adp-5, INEXACT)
T(RN,  0x1.c75924833503ep+494,   -0x1.d1300dadbc4a2p-1,   0x1.8a756ap-5, INEXACT)
T(RN,  0x1.eb8b3a9faf677p+494,    0x1.f768c566b3996p-2,  -0x1.3fda7cp-2, INEXACT)
T(RN,  0x1.a817fbc896e04p+494,    0x1.30c62edf20175p-1,   -0x1.c0dbdp-2, INEXACT)
T(RN,  0x1.a2b091db6d3aap+495,    0x1.c2872298e7414p-1,   0x1.2bf872p-2, INEXACT)
T(RN,  0x1.cac2fdf92eb69p+495,   -0x1.efcca22b951a8p-1,   0x1.60a7fap-2, INEXACT)
T(RN,  0x1.0fad8bbaaff67p+495,    0x1.6395eb28907cbp-4,  -0x1.c4ed3ap-2, INEXACT)
T(RN,  0x1.77d317b24e4c8p+495,    0x1.a11cc694ece44p-2,   0x1.de4232p-2, INEXACT)
T(RN,  0x1.1cd5bb154a573p+495,    0x1.c6d1c30790c42p-1,  -0x1.01770ep-5, INEXACT)
T(RN,  0x1.66f5c26b643adp+495,   -0x1.c56fc5716ab96p-1,   0x1.4fd50ep-5, INEXACT)
T(RN,  0x1.b93278d8ae03ap+495,    0x1.1471ea40da9e7p-1,   0x1.21b2c6p-2, INEXACT)
T(RN,  0x1.b5fb4bc19a45cp+495,   -0x1.fae649fbbf7d2p-1,   -0x1.318e3p-3, INEXACT)
T(RN,   0x1.9148b9541ec4p+495,    0x1.ebd7d79815d95p-1,   0x1.0bf9eap-6, INEXACT)
T(RN,  0x1.dfe7c04797ad9p+495,   -0x1.f484aa278a914p-1,  -0x1.5a7af2p-4, INEXACT)
T(RN,  0x1.6cdfecc21c0e6p+496,    -0x1.88792a3a5b6ep-1,  -0x1.5177acp-2, INEXACT)
T(RN,  0x1.1ac4270ce020fp+496,   -0x1.fc1fb50c2d089p-1,   0x1.22787ap-4, INEXACT)
T(RN,  0x1.90f0ec842f3fep+496,    0x1.43a641d6c9f33p-1,   0x1.921fdcp-2, INEXACT)
T(RN,  0x1.5aa94fa4f8a34p+496,   -0x1.2ce4d4c29d76ep-3,    0x1.15aaap-2, INEXACT)
T(RN,  0x1.26c97ecdde218p+496,    0x1.ffd6644808b33p-1,   0x1.81404ap-4, INEXACT)
T(RN,  0x1.e650c669967fep+496,   -0x1.8fab55dd9eaeep-1,  -0x1.3e69c4p-2, INEXACT)
T(RN,  0x1.5868ecc23f656p+496,   -0x1.fadab4b09e4b6p-1,  -0x1.a361dap-3, INEXACT)
T(RN,  0x1.4f2f8b3c6f32ap+496,    0x1.9d28cd36a9ec7p-1,    0x1.8acbap-2, INEXACT)
T(RN,  0x1.9e693c2ae8358p+496,    0x1.fc7d838878696p-1,   0x1.aa22a8p-3, INEXACT)
T(RN,  0x1.d724f3c4021eep+496,     0x1.7c35189e53b5p-1,   -0x1.246a2p-2, INEXACT)
T(RN,  0x1.26a67b9916114p+497,    0x1.4bf14875ff956p-1,  -0x1.2982b8p-2, INEXACT)
T(RN,  0x1.eb4438cb26e64p+497,   -0x1.156a0a700592cp-3,   0x1.b6380ep-2, INEXACT)
T(RN,  0x1.7184b4b327274p+497,   -0x1.9cb1c6dd42038p-2,   0x1.8a1fe8p-2, INEXACT)
T(RN,  0x1.066799c3faf4bp+497,    0x1.628c526394ac1p-2,   0x1.2afb1cp-6, INEXACT)
T(RN,  0x1.8e0c35170530ap+497,   -0x1.e5bfe838e8a0bp-1,  -0x1.d90722p-3, INEXACT)
T(RN,  0x1.5c8d71f7c2a9ap+497,    0x1.e8f327115ee17p-3,    0x1.7a118p-4, INEXACT)
T(RN,  0x1.54c34a5db4427p+497,    0x1.24759c2a48c38p-1,  -0x1.942a02p-2, INEXACT)
T(RN,  0x1.d56024976aabap+497,   -0x1.fa11071cc4ff8p-1,  -0x1.b17b98p-4, INEXACT)
T(RN,  0x1.019275960fc74p+497,   -0x1.ef4666523cebbp-1,   0x1.90927ap-2, INEXACT)
T(RN,  0x1.3aea6294d0f22p+497,    0x1.06d70b98188bdp-2,  -0x1.9899bep-2, INEXACT)
T(RN,  0x1.9b977c8cb78e8p+498,   -0x1.15ac472b2b424p-4,  -0x1.2b2492p-2, INEXACT)
T(RN,  0x1.b68c706d874a2p+498,   -0x1.78f4e24247d28p-2,  0x1.39d16ep-10, INEXACT)
T(RN,  0x1.cbe6c4d24c249p+498,    0x1.8988f05eb6844p-3,   0x1.77e7d8p-2, INEXACT)
T(RN,  0x1.e6c05426c05f2p+498,   -0x1.c2e3331029fa8p-1,   0x1.f252f2p-2, INEXACT)
T(RN,  0x1.f565d38ee8d02p+498,   -0x1.f6c5b4bf34424p-1,   0x1.0dad8cp-3, INEXACT)
T(RN,  0x1.b2e796e22c774p+498,    0x1.71f6ddf825df4p-1,    0x1.74378p-3, INEXACT)
T(RN,  0x1.85a4c3b96f596p+498,     0x1.78fd7fb87772p-1,  -0x1.bc39d8p-5, INEXACT)
T(RN,  0x1.8513604c431e9p+498,   -0x1.e8137ed1a143fp-1,    0x1.4f2d5p-2, INEXACT)
T(RN,  0x1.3a5d53b102f7ep+498,   -0x1.7949c18e2f12dp-1,  -0x1.099ed8p-2, INEXACT)
T(RN,  0x1.6d36b115a5f5ap+498,   -0x1.a6856bf24fb77p-2,   0x1.aa073cp-3, INEXACT)
T(RN,  0x1.5c2e78bc6399ap+499,    0x1.e411e350d2f2cp-1,  -0x1.c8b1ecp-6, INEXACT)
T(RN,  0x1.f86de886e463fp+499,   -0x1.fe336fb3d1a3bp-1,   -0x1.53d4fp-2, INEXACT)
T(RN,  0x1.c33ac8b47e462p+499,    0x1.a9e9073231b19p-3,  -0x1.d69658p-3, INEXACT)
T(RN,  0x1.7a960cae9dd84p+499,   -0x1.988f1e222447dp-1,   0x1.1a55dcp-2, INEXACT)
T(RN,  0x1.72280a44c7824p+499,   -0x1.f8ba1e6e9bb0fp-1,  -0x1.0976d4p-4, INEXACT)
T(RN,  0x1.eb7ac80867b0ap+499,    0x1.69f04c41bd0dcp-3,   0x1.edb256p-2, INEXACT)
T(RN,  0x1.7017e77e2a3f3p+499,    0x1.86407df311cb2p-1,   0x1.4ee7d2p-8, INEXACT)
T(RN,  0x1.7433c3b0f04ebp+499,   -0x1.1979ae78a3bbbp-1,  -0x1.055b46p-2, INEXACT)
T(RN,  0x1.41211acbc5089p+499,   -0x1.fe6ad1078eb11p-1,   0x1.40786ap-4, INEXACT)
T(RN,  0x1.9ff500b61ed0fp+499,   -0x1.64b7cd6306d4ap-1,   0x1.766998p-2, INEXACT)
T(RN,  0x1.5ab2dc87b6a04p+500,    0x1.58784bd5188afp-4,   0x1.b197f2p-2, INEXACT)
T(RN,  0x1.99e06e27aaf3cp+500,    0x1.cc415909311acp-5,  -0x1.c45bf8p-6, INEXACT)
T(RN,  0x1.1890c13c47b24p+500,    0x1.ac2a5666df427p-2,  -0x1.f0af0ep-3, INEXACT)
T(RN,  0x1.0e3e9480012aap+500,    0x1.216d74f80ec4bp-1,   0x1.291e54p-3, INEXACT)
T(RN,  0x1.578a65bd68572p+500,   -0x1.f1618e10d8a7fp-1,  -0x1.7a4332p-2, INEXACT)
T(RN,  0x1.3b3d3056dd424p+500,   -0x1.08789f5fed3a9p-2,   0x1.6681b4p-3, INEXACT)
T(RN,  0x1.d8c5c9d69b1bap+500,    0x1.3d60c16863824p-1,   0x1.be9cc2p-2, INEXACT)
T(RN,  0x1.119e58a73900dp+500,    -0x1.3d057ec1c246p-3,  -0x1.6346d6p-2, INEXACT)
T(RN,  0x1.e582e6d9b56e7p+500,    0x1.32e1cc766be4fp-1,    0x1.aa4f5p-2, INEXACT)
T(RN,   0x1.8a056c038f9dp+500,    0x1.38e78d5d2fb29p-1,  -0x1.9bb26ep-2, INEXACT)
T(RN,  0x1.f772acb87210bp+501,    0x1.bbb3e83b0d14ap-1,   0x1.08445cp-2, INEXACT)
T(RN,  0x1.5258b3acf2576p+501,   -0x1.53d6a64632495p-1,   0x1.24aef2p-2, INEXACT)
T(RN,  0x1.2aa6cb6d3fd95p+501,   -0x1.ac3ee6806d689p-1,  -0x1.748a9ap-2, INEXACT)
T(RN,  0x1.a7465e4ebbf18p+501,    0x1.30461144270cap-2,   0x1.062ef8p-2, INEXACT)
T(RN,  0x1.de988a704562cp+501,   -0x1.febc4fb753c4ep-1,   0x1.a21fe2p-2, INEXACT)
T(RN,  0x1.71c271e5c6355p+501,   -0x1.f5bbc501a3441p-1,   0x1.b00872p-4, INEXACT)
T(RN,   0x1.dc604f27f6b3p+501,    0x1.5008b7a4651b7p-2,   0x1.ed017ap-2, INEXACT)
T(RN,  0x1.b19efe509160dp+501,    0x1.cf69d7d9e8981p-1,   0x1.1fb2aap-2, INEXACT)
T(RN,  0x1.3cdd0a0e88654p+501,    0x1.e5a41ab7fe27bp-1,   0x1.a77cfcp-2, INEXACT)
T(RN,  0x1.8305f12f4def4p+501,   -0x1.d14698807d9fdp-3,  -0x1.61d906p-2, INEXACT)
T(RN,  0x1.747796b337e75p+502,   -0x1.feb3739d2dbd2p-1,   0x1.5d6a8cp-3, INEXACT)
T(RN,  0x1.a6b239a4801a8p+502,    0x1.5cb9e6012110dp-1,  -0x1.183346p-2, INEXACT)
T(RN,  0x1.defab36fdabdep+502,    0x1.0b48910a24f33p-2,  -0x1.2db3f2p-3, INEXACT)
T(RN,  0x1.9f4cce8518903p+502,    0x1.253953199a0a7p-1,  -0x1.3b6a6ep-5, INEXACT)
T(RN,  0x1.3658d435dcb1cp+502,    0x1.b3099581e41c6p-1,  -0x1.800134p-2, INEXACT)
T(RN,   0x1.9e54d4ee0d53p+502,    0x1.54dbf04425261p-1,   0x1.4d8f48p-2, INEXACT)
T(RN,  0x1.9b67027f26534p+502,    0x1.fc874563eb2e4p-1,  -0x1.20af0cp-4, INEXACT)
T(RN,  0x1.4768a08403cc2p+502,    -0x1.fc23b947729cp-1,   0x1.75aa5ap-2, INEXACT)
T(RN,  0x1.f3a352926d153p+502,    0x1.7f425c538f4bfp-1,   0x1.eab1e8p-3, INEXACT)
T(RN,  0x1.253a03e458eacp+502,    0x1.3f24bdc5443b3p-1,   0x1.15eed8p-2, INEXACT)
T(RN,  0x1.6f08f42b27901p+503,    0x1.3ffac5f130d8bp-3,   0x1.a047a4p-2, INEXACT)
T(RN,  0x1.f498eef005794p+503,    0x1.5c6dac0fc19a6p-1,   0x1.259aaap-3, INEXACT)
T(RN,  0x1.24ea345eaf2a5p+503,    -0x1.85cc964704acp-3,    0x1.783c2p-2, INEXACT)
T(RN,  0x1.f65bd54c0eb3ap+503,   -0x1.5106c7e4a22d3p-1,   0x1.83ec6ep-3, INEXACT)
T(RN,  0x1.cc972b9f2ae35p+503,    0x1.b86060de2bbf1p-1,   0x1.1302e6p-2, INEXACT)
T(RN,  0x1.25f1efe6c2082p+503,     0x1.bedd47b2f409p-1,  -0x1.4f9ee4p-4, INEXACT)
T(RN,  0x1.9c004893c376cp+503,   -0x1.0d8609a68e877p-1,   0x1.0d8b92p-4, INEXACT)
T(RN,  0x1.97e681379d345p+503,    0x1.d59e2b5b95ddfp-2,   0x1.faffd6p-4, INEXACT)
T(RN,  0x1.53aa7b4b6943bp+503,    0x1.e26611a061867p-1,   0x1.9ad62cp-2, INEXACT)
T(RN,  0x1.ce74ef7f7c21bp+503,    0x1.a80900912ebedp-2,  -0x1.e91d18p-2, INEXACT)
T(RN,  0x1.b1b298ec6668ep+504,    0x1.cf334633de3c8p-1,   0x1.f304dcp-3, INEXACT)
T(RN,  0x1.44209bcc17127p+504,    -0x1.79aa3b75deebp-1,  -0x1.d6a612p-2, INEXACT)
T(RN,  0x1.7d0754ba356cep+504,   -0x1.f708d9ca08d23p-1,    0x1.35b8bp-5, INEXACT)
T(RN,  0x1.d45d9b22fdfbdp+504,    0x1.fdfb7c9810f84p-1,   0x1.8c42a8p-2, INEXACT)
T(RN,  0x1.b113e4eac33e9p+504,   -0x1.53bbc7a9f0a7bp-4,    0x1.e18cep-2, INEXACT)
T(RN,  0x1.8f1861bf353bap+504,   -0x1.61006d8004076p-1,   0x1.35b19ep-3, INEXACT)
T(RN,  0x1.25dc13344964cp+504,     0x1.d686dfbbfa11p-1,   0x1.f92512p-3, INEXACT)
T(RN,  0x1.007bda870678cp+504,   -0x1.d3403763afd44p-1,   0x1.f1b848p-3, INEXACT)
T(RN,   0x1.c4a3ef4a7bb8p+504,   -0x1.de8fdc01e6c8fp-1,  -0x1.7cd0b6p-5, INEXACT)
T(RN,  0x1.1d0e9792b160ep+504,    0x1.6b1ce38fb2f9cp-1,  -0x1.623dd8p-2, INEXACT)
T(RN,    0x1.fca6a3c56b2p+505,    0x1.c1c0e3fbf1074p-1,  -0x1.285228p-2, INEXACT)
T(RN,  0x1.f7ee369702641p+505,   -0x1.2fddb659cdd01p-4,  -0x1.559c58p-3, INEXACT)
T(RN,  0x1.025879ac2f517p+505,    0x1.e4ab9ac32ef28p-3,  -0x1.32ac72p-2, INEXACT)
T(RN,  0x1.055d579046b67p+505,    0x1.7ca32076560ffp-1,   0x1.757ffap-2, INEXACT)
T(RN,  0x1.429053df904d9p+505,    0x1.f8f4bbeecd575p-1,   0x1.0d26f6p-3, INEXACT)
T(RN,  0x1.d120c7875fc98p+505,   -0x1.092249a6bbd47p-7,  -0x1.813faep-3, INEXACT)
T(RN,  0x1.195ed04613919p+505,    0x1.fe1e692d36955p-1,   0x1.8f26aep-2, INEXACT)
T(RN,  0x1.e8c3c7cbd17fap+505,   -0x1.4637612e52da6p-4,  -0x1.b3ac78p-5, INEXACT)
T(RN,  0x1.2bd89f3c90897p+505,    0x1.8c11ea35d0b28p-1,   0x1.346536p-2, INEXACT)
T(RN,  0x1.1906435891a9ap+505,   -0x1.3a33281eeebabp-3,  -0x1.9aa1e6p-2, INEXACT)
T(RN,  0x1.324081b35b07ep+506,   -0x1.489bec790f536p-1,  -0x1.780bbep-3, INEXACT)
T(RN,  0x1.b9b74bc6f60cap+506,     0x1.ace102ece99fp-7,  -0x1.861e84p-3, INEXACT)
T(RN,  0x1.c7ad2dd96920cp+506,     0x1.bdae23303a81p-1,   0x1.ac50c4p-3, INEXACT)
T(RN,  0x1.79b33e43d4fb9p+506,    0x1.7aea74e3edc3ap-3,  -0x1.65cbaap-2, INEXACT)
T(RN,  0x1.453efedfbc6e9p+506,   -0x1.962770629fb38p-1,   0x1.323382p-2, INEXACT)
T(RN,  0x1.f235a93f18485p+506,   -0x1.0ef249549947ap-1,  -0x1.24aa12p-4, INEXACT)
T(RN,  0x1.5a92e1b4df2b2p+506,   -0x1.d8a128e4f1587p-1,  -0x1.dea3f6p-3, INEXACT)
T(RN,  0x1.65fa711de3535p+506,    -0x1.5484c14406ecp-2,  -0x1.2052b2p-2, INEXACT)
T(RN,  0x1.42cd1b3af8583p+506,    0x1.ffff53ef9b5b1p-1,   0x1.66951ep-3, INEXACT)
T(RN,   0x1.6818b327e64ep+506,    0x1.131fedfd84044p-1,  -0x1.00bec4p-3, INEXACT)
T(RN,   0x1.59678bc2a66ep+507,   -0x1.300e95c53b809p-1,  -0x1.b324dep-2, INEXACT)
T(RN,  0x1.9e823f95fcba3p+507,   -0x1.9b55e778863bcp-1,   0x1.4fa48ap-2, INEXACT)
T(RN,  0x1.41a2f9053f7b6p+507,    0x1.4177dbfce2145p-1,  -0x1.b3571ap-2, INEXACT)
T(RN,  0x1.ef8c1e0f5f6f9p+507,    0x1.16802e85b7e4ep-3,   0x1.7bf5eep-2, INEXACT)
T(RN,  0x1.89f4e8d702241p+507,    0x1.0852adbe6e71ep-1,   0x1.3aa46ep-5, INEXACT)
T(RN,  0x1.bb31e05733efcp+507,   -0x1.973a9adf2cc3ap-1,   -0x1.9971bp-4, INEXACT)
T(RN,  0x1.e29debbf836d1p+507,   -0x1.cc752a5984aa7p-3,  -0x1.555c12p-2, INEXACT)
T(RN,  0x1.7a8e7971b107cp+507,    0x1.f66e9e7d1a8b1p-1,   0x1.ebe8c2p-2, INEXACT)
T(RN,  0x1.80be1032ba7e4p+507,   -0x1.54704c70f1b18p-4,   0x1.ee759ap-3, INEXACT)
T(RN,  0x1.b0df5aaad43ffp+507,    0x1.17729d528bb4bp-1,  -0x1.c6313cp-2, INEXACT)
T(RN,  0x1.1525fc929f80ap+508,   -0x1.36de70d3052d9p-1,   0x1.ea1712p-4, INEXACT)
T(RN,  0x1.adcab55ff28c4p+508,   -0x1.ba402abc981fep-1,   0x1.cec002p-2, INEXACT)
T(RN,   0x1.cbceadd8d82cp+508,   -0x1.5a8c7a0317ea3p-1,  -0x1.2ca34cp-4, INEXACT)
T(RN,  0x1.b8f0a16222464p+508,   -0x1.13781c98453e7p-1,   0x1.d1d3aap-4, INEXACT)
T(RN,  0x1.d293bfc316f8ep+508,    0x1.930e99e7945a1p-2,   0x1.255adcp-4, INEXACT)
T(RN,  0x1.4090a7a20e741p+508,      0x1.61183ba4975p-2,  -0x1.28e982p-2, INEXACT)
T(RN,   0x1.92dcd0fbd74cp+508,    0x1.f092136f0fae7p-3,    0x1.2244ep-2, INEXACT)
T(RN,  0x1.861492d3bb222p+508,    0x1.0f9de77116fa4p-1,   0x1.71d9a4p-2, INEXACT)
T(RN,  0x1.32decb0fabe9cp+508,   -0x1.6c7ad83b672aap-1,  -0x1.201898p-2, INEXACT)
T(RN,  0x1.5365fa16c6092p+508,   -0x1.ed981dbe68bc1p-1,  -0x1.f44acep-4, INEXACT)
T(RN,  0x1.3c376488e0256p+509,    0x1.addea62eb1b02p-1,  -0x1.f31c84p-3, INEXACT)
T(RN,  0x1.06186a1f4da33p+509,   -0x1.75bf6ec90736fp-1,   0x1.ad85dcp-7, INEXACT)
T(RN,  0x1.3e6abcae12192p+509,   -0x1.321b7819413f7p-2,    0x1.d1362p-2, INEXACT)
T(RN,  0x1.8549524e69bcfp+509,    0x1.6af495aa6b1fdp-1,   0x1.e190d6p-2, INEXACT)
T(RN,  0x1.109df348c0e0ap+509,    0x1.2e226353349b7p-4,  -0x1.fbc9a4p-2, INEXACT)
T(RN,  0x1.21a9e8cc0585cp+509,    0x1.b9407f8633eabp-1,    0x1.06b5cp-2, INEXACT)
T(RN,  0x1.7ae289fd942c2p+509,   -0x1.4035ec54fc1afp-1,  -0x1.724a46p-3, INEXACT)
T(RN,  0x1.10bf694cf5b2ap+509,   -0x1.fccb0ba8507f7p-1,   0x1.86a80ep-2, INEXACT)
T(RN,  0x1.b6cecbbe4a38cp+509,    0x1.d6ce512f5f622p-1,  -0x1.70f36ep-2, INEXACT)
T(RN,  0x1.d11ebc2e55664p+509,   -0x1.5e115a5f87baep-1,   0x1.59adb2p-2, INEXACT)
T(RN,  0x1.931c92f3ca9acp+510,    0x1.f75afa8d3ff0bp-1,   0x1.a5e954p-3, INEXACT)
T(RN,  0x1.e09fb9ef67895p+510,    0x1.617f1843bf1a3p-1,   0x1.060f9ap-6, INEXACT)
T(RN,  0x1.9d57272711266p+510,    0x1.190385917b353p-1,  -0x1.13b5e8p-3, INEXACT)
T(RN,   0x1.89f13ebc29cep+510,    0x1.aaeb5573422a2p-2,  -0x1.e56d1ep-3, INEXACT)
T(RN,  0x1.ca91dd4cecc16p+510,    0x1.bbfad2b75b3a4p-1,   0x1.c52e54p-2, INEXACT)
T(RN,  0x1.75c384d360de6p+510,    0x1.886355bc3bfb3p-3,   0x1.c9747ep-5, INEXACT)
T(RN,  0x1.ca6b2fed4d0ecp+510,    0x1.c8bf9fcf73128p-3,   0x1.a2d452p-3, INEXACT)
T(RN,  0x1.8a12d9e8bd509p+510,   -0x1.0dd3324396638p-1,   0x1.113358p-3, INEXACT)
T(RN,  0x1.6949783917a5fp+510,    0x1.d6999fce6a299p-1,  -0x1.693108p-3, INEXACT)
T(RN,  0x1.85ad523756622p+510,   -0x1.2b78bc2a57f46p-1,   0x1.cec38cp-3, INEXACT)
T(RN,   0x1.b6ecc149d321p+511,   -0x1.fdc63cda22666p-1,  -0x1.133164p-3, INEXACT)
T(RN,  0x1.805c2cc217f0ep+511,   -0x1.3fc0c00c53192p-1,   0x1.67c9cep-2, INEXACT)
T(RN,  0x1.952ba9f227462p+511,   -0x1.ffced30e3e6d8p-1,   0x1.266766p-4, INEXACT)
T(RN,  0x1.134570d788f3cp+511,   -0x1.e07db8ad8c8a9p-1,   -0x1.c7877p-2, INEXACT)
T(RN,  0x1.6b6fe5f15763dp+511,   -0x1.01d31826507a7p-1,  -0x1.a7591ep-4, INEXACT)
T(RN,   0x1.b4c9f408d7fap+511,    0x1.1355e8f43b959p-1,  -0x1.6d5c34p-3, INEXACT)
T(RN,  0x1.3f66bbc1f35f3p+511,   -0x1.755f13c2e5bbep-4,   0x1.0ef766p-4, INEXACT)
T(RN,  0x1.284aa5665175cp+511,    0x1.f201d8fcd4623p-1,   0x1.e9ed96p-3, INEXACT)
T(RN,  0x1.b0b5526ee23d8p+511,   -0x1.535e89c01979bp-3,   0x1.641014p-2, INEXACT)
T(RN,   0x1.4d27e06eb5e2p+511,     0x1.95ef018ba97ap-3,  -0x1.9832acp-2, INEXACT)
T(RN,  0x1.5335224351f31p+512,     0x1.e00eef4c0726p-1,   0x1.bc2b6ep-4, INEXACT)
T(RN,  0x1.b4fbef5582956p+512,    0x1.aee13dd22685ep-1,   0x1.a32bc2p-2, INEXACT)
T(RN,  0x1.11621bdfbc9f6p+512,   -0x1.15ff0c3814564p-2,    0x1.345eep-2, INEXACT)
T(RN,  0x1.72202b272edc4p+512,    0x1.e23199e2e51ffp-1,  -0x1.6bc32ep-2, INEXACT)
T(RN,  0x1.e69b42c50dad4p+512,     0x1.759c4b1a4856p-1,  -0x1.1c29dcp-5, INEXACT)
T(RN,  0x1.73689f1065a4ep+512,   -0x1.008d389968d33p-3,   0x1.2a3644p-5, INEXACT)
T(RN,  0x1.26078bb813519p+512,   -0x1.cd153697117d2p-2,    0x1.f5af8p-2, INEXACT)
T(RN,  0x1.26ec735b4ac49p+512,    0x1.ff7e094b2e948p-1,  -0x1.aa0dbcp-2, INEXACT)
T(RN,  0x1.dd9b46a4a2f38p+512,    -0x1.dc423f82073dp-1,   0x1.01ab94p-6, INEXACT)
T(RN,  0x1.7b7aa2e367d53p+512,   -0x1.be36eeb43f33ap-1,  -0x1.4c3e0ep-2, INEXACT)
T(RN,  0x1.13ffef530ee3fp+513,    0x1.bf424136c28cap-1,   0x1.48d412p-6, INEXACT)
T(RN,  0x1.4150c246932bbp+513,   -0x1.a70df75bf9dacp-2,   -0x1.3f4c1p-2, INEXACT)
T(RN,  0x1.d9182f593a34cp+513,   -0x1.32d430e2226cap-1,   0x1.478a06p-2, INEXACT)
T(RN,  0x1.341089d5e8d88p+513,   -0x1.7cda3faddae21p-2,  -0x1.8da592p-2, INEXACT)
T(RN,  0x1.bfb59d9754dd4p+513,    0x1.ff1861b042301p-1,   0x1.35ce56p-2, INEXACT)
T(RN,  0x1.54a2a4ce5a4eap+513,   -0x1.fe86e4b48d855p-1,   -0x1.b331fp-5, INEXACT)
T(RN,  0x1.75b0e9725967ap+513,   -0x1.c6d88ae82fe7cp-1,   0x1.608306p-2, INEXACT)
T(RN,  0x1.04a7465709601p+513,    0x1.566debcbede1dp-1,   0x1.77010ep-2, INEXACT)
T(RN,  0x1.8f5bccd00c317p+513,    0x1.ffffba2c091b4p-1,   0x1.4b83dap-6, INEXACT)
T(RN,  0x1.70c515f333056p+513,   -0x1.5b94ccba9b6b3p-1,  -0x1.5d73fap-4, INEXACT)
T(RN,  0x1.dfe6db9d9fc18p+514,    0x1.cdf2199993bd4p-1,    0x1.12042p-2, INEXACT)
T(RN,  0x1.323b99ee72516p+514,    0x1.5390883ce761ep-1,    0x1.1ea12p-8, INEXACT)
T(RN,  0x1.779fe0a37de8dp+514,     0x1.f6a48e2a5addp-1,   0x1.d12286p-2, INEXACT)
T(RN,  0x1.f9d4d91fb6576p+514,   -0x1.e02c8942edccbp-1,   0x1.5fac42p-6, INEXACT)
T(RN,  0x1.d48198ccc9371p+514,    0x1.c79c4c4f54449p-1,  -0x1.a1b184p-2, INEXACT)
T(RN,  0x1.ec5b8aac2afd4p+514,    0x1.fff39c2942c6dp-1,  -0x1.c8989ap-6, INEXACT)
T(RN,  0x1.16adbba4ffe64p+514,   -0x1.68aab7dfd40bcp-1,   0x1.646046p-2, INEXACT)
T(RN,  0x1.294a2352f0e4dp+514,    0x1.f1378cad3665ap-1,  -0x1.ede662p-8, INEXACT)
T(RN,  0x1.393ea7cc8f62dp+514,   -0x1.0c18164bb5ef5p-1,   0x1.07bd3ap-2, INEXACT)
T(RN,  0x1.e5509d64789b3p+514,    0x1.b8abd87879bb4p-1,  -0x1.f29bf4p-2, INEXACT)
T(RN,  0x1.a3fec24e372b6p+515,    0x1.0b4592e6db64dp-4,    0x1.94798p-3, INEXACT)
T(RN,   0x1.82d76da1b13bp+515,    0x1.a510173d7649ep-2,   0x1.7ea49ep-2, INEXACT)
T(RN,  0x1.863211587ccd8p+515,   -0x1.5ce536a1bb02bp-1,   0x1.068484p-2, INEXACT)
T(RN,  0x1.c38aa307aeb38p+515,    0x1.c516a7b6cf772p-1,  -0x1.b73b24p-6, INEXACT)
T(RN,  0x1.f5fd2c392b664p+515,    0x1.d8a184bdafa51p-1,  -0x1.aad5b4p-2, INEXACT)
T(RN,  0x1.84db9636d2486p+515,   -0x1.566209f9b820bp-2,   0x1.326456p-2, INEXACT)
T(RN,  0x1.eb009f125bec8p+515,    0x1.0c5059c6a92eep-2,   0x1.4147b8p-3, INEXACT)
T(RN,  0x1.1aa49d6f1143cp+515,    -0x1.13cecb6f77f7p-2,   0x1.57350ap-6, INEXACT)
T(RN,  0x1.7a13404196965p+515,   -0x1.05bad1982f579p-3,  -0x1.b9cad8p-2, INEXACT)
T(RN,  0x1.e56f37f0c4662p+515,     0x1.3f2b491d32e8p-1,  -0x1.5d06e4p-3, INEXACT)
T(RN,  0x1.7d8d07dca7794p+516,    0x1.cdb2ba856d6c5p-1,  -0x1.3d81f6p-4, INEXACT)
T(RN,  0x1.1f9a3886624aap+516,   -0x1.07267a58efa46p-2,   0x1.32df02p-2, INEXACT)
T(RN,  0x1.20f8f7453cc87p+516,     0x1.f9fbf4387495p-2,  -0x1.e1208cp-2, INEXACT)
T(RN,  0x1.182875259eeecp+516,    0x1.fdefd9ffdc4cbp-1,   0x1.e8cbdcp-2, INEXACT)
T(RN,  0x1.4db402b2e554bp+516,    0x1.f18e781a6ef4ep-1,   -0x1.9481ep-6, INEXACT)
T(RN,  0x1.44e70a598ae99p+516,   -0x1.af7b02e2db717p-4,   0x1.58363ap-3, INEXACT)
T(RN,   0x1.62c809f53453p+516,   -0x1.f092ca3f172ccp-1,   0x1.ebf568p-2, INEXACT)
T(RN,  0x1.5784697ea0ac6p+516,     0x1.c324afbe6e01p-1,   0x1.2893fcp-3, INEXACT)
T(RN,  0x1.b2333d7da37a5p+516,   -0x1.ffd887ae4bf48p-1,   0x1.3039cep-3, INEXACT)
T(RN,  0x1.434764cf95c4dp+516,   -0x1.e109c17f6153ep-1,   0x1.c16ceep-7, INEXACT)
T(RN,   0x1.c5e987a3ca87p+517,   -0x1.7192fc5f15d45p-1,   0x1.f324ecp-4, INEXACT)
T(RN,  0x1.a0c7a68c60c3cp+517,    0x1.77ea99992158fp-4,  -0x1.a0c4ccp-5, INEXACT)
T(RN,  0x1.6296ce62207e4p+517,    0x1.ff6294aa99feep-1,    0x1.98c86p-2, INEXACT)
T(RN,  0x1.b6b43abaa705bp+517,   -0x1.a3dada05054dcp-1,  -0x1.af2622p-2, INEXACT)
T(RN,  0x1.00b4d6c708d14p+517,   -0x1.d7c26e33ac556p-1,  -0x1.afcfc2p-2, INEXACT)
T(RN,  0x1.62852ca025957p+517,   -0x1.fffe900ef4aa4p-1,   0x1.7ddec4p-6, INEXACT)
T(RN,   0x1.30f48a159ca7p+517,    0x1.ffa84b28634ffp-1,  -0x1.8c581cp-5, INEXACT)
T(RN,  0x1.938f41a1d145fp+517,   -0x1.aa293623c4becp-1,  -0x1.8c9b4ap-2, INEXACT)
T(RN,   0x1.4b1abb1e83dep+517,   -0x1.dc0b2f9a9ef48p-1,  -0x1.6bb06ep-2, INEXACT)
T(RN,  0x1.a03c8766d3327p+517,    0x1.2e954a1cd51fdp-2,  -0x1.6fee4cp-2, INEXACT)
T(RN,  0x1.b358b661b642ep+518,    0x1.6f62bae83bbbep-1,   0x1.dcf524p-2, INEXACT)
T(RN,  0x1.89b5554705a7ep+518,   -0x1.fae4f9716da6cp-1,  -0x1.8f413ep-3, INEXACT)
T(RN,  0x1.6c8d64b900b46p+518,   -0x1.774d05a2f369fp-1,    0x1.d84c9p-3, INEXACT)
T(RN,  0x1.ef6c0ffd60224p+518,   -0x1.136d0f77fe635p-1,   0x1.c7b9aep-2, INEXACT)
T(RN,  0x1.511f547c5c964p+518,    0x1.2c429dd326172p-2,   0x1.3e040ep-2, INEXACT)
T(RN,  0x1.c980d2336b414p+518,    0x1.be61a4ba71571p-4,   0x1.d2c712p-4, INEXACT)
T(RN,  0x1.6cc1c762ac4adp+518,   -0x1.a1fd53b0b3851p-1,    0x1.ced37p-2, INEXACT)
T(RN,  0x1.5f42b59fd9d78p+518,    0x1.e4f4c1262412ap-1,  -0x1.4bcc8cp-2, INEXACT)
T(RN,  0x1.26fed980a814dp+518,    0x1.f48cd581acbf5p-1,  -0x1.1c64e6p-3, INEXACT)
T(RN,  0x1.95c38ab4716b1p+518,   -0x1.23be1c2e9ea3cp-5,   0x1.330a7ap-4, INEXACT)
T(RN,  0x1.082051c45ba88p+519,   -0x1.7e60fd39bf3aep-1,   0x1.4d27b2p-2, INEXACT)
T(RN,  0x1.9939338fc7f97p+519,   -0x1.da390745893f9p-1,   0x1.e78434p-2, INEXACT)
T(RN,  0x1.33b61fc555915p+519,   -0x1.0b8d187edc184p-1,  -0x1.ceb0c4p-2, INEXACT)
T(RN,  0x1.8ec9f39c0ab08p+519,    0x1.54d1a6f4e85cep-1,   -0x1.29e93p-3, INEXACT)
T(RN,  0x1.07dab87c01eacp+519,    0x1.4ce15c4624dc6p-1,    0x1.588fap-3, INEXACT)
T(RN,  0x1.bf1cb7cc7e552p+519,    0x1.34dced2e52e28p-3,   0x1.32f468p-2, INEXACT)
T(RN,  0x1.1cd64fa8c5b67p+519,    0x1.28db77236211fp-3,  -0x1.b3b666p-2, INEXACT)
T(RN,  0x1.8d1020f4106c9p+519,   -0x1.ecd675b91d2dap-1,   0x1.8127e8p-2, INEXACT)
T(RN,  0x1.b4258e172a9c8p+519,   -0x1.ffcc9748aeb86p-1,  -0x1.bb785ap-2, INEXACT)
T(RN,  0x1.146e40ee1730ep+519,   -0x1.c7096cf3a44dbp-2,  -0x1.1f16a4p-2, INEXACT)
T(RN,  0x1.8d3ac449348e2p+520,   -0x1.644cb19f9cbcbp-1,   0x1.8653e2p-2, INEXACT)
T(RN,  0x1.a3ea3d64a98dcp+520,    0x1.c2746fecb0ba5p-1,  -0x1.68c754p-2, INEXACT)
T(RN,  0x1.3f7d4752c0192p+520,   -0x1.d0ce924b3fa68p-1,  -0x1.1ab742p-3, INEXACT)
T(RN,   0x1.f0a799d5a0acp+520,   -0x1.ff79a64012d7cp-1,  -0x1.1a0de8p-2, INEXACT)
T(RN,    0x1.4083b37389dp+520,    0x1.b5c64e4895722p-2,   0x1.67e66ap-2, INEXACT)
T(RN,  0x1.40480729b6af4p+520,   -0x1.3a6a46b62ab46p-1,   0x1.6d7accp-3, INEXACT)
T(RN,  0x1.f1e83ad0b5f48p+520,   -0x1.1bc67bcc5fc75p-1,   0x1.03a9bcp-3, INEXACT)
T(RN,  0x1.7e253cc140b9dp+520,    0x1.d8caf4f64910fp-1,  -0x1.d8a8aap-2, INEXACT)
T(RN,  0x1.2a08b1ead58f6p+520,    0x1.bcab5347622dcp-2,  -0x1.9b088cp-3, INEXACT)
T(RN,  0x1.19e8754a37d7dp+520,   -0x1.f6f62c10eebfdp-1,   0x1.59260ap-5, INEXACT)
T(RN,  0x1.3708b84477ca4p+521,    0x1.dab1817af8576p-1,  -0x1.810fbap-4, INEXACT)
T(RN,  0x1.bbf39cc96463ap+521,   -0x1.1ef0ca42cf99dp-7,   0x1.8db1dap-3, INEXACT)
T(RN,  0x1.940a4a7c0a8fdp+521,   -0x1.3052841207e9dp-7,   0x1.5d2deap-4, INEXACT)
T(RN,  0x1.d9f902964316bp+521,    0x1.f37fbe9a7a8f1p-1,   0x1.8a418cp-5, INEXACT)
T(RN,  0x1.dedce20abbd74p+521,   -0x1.5b82298acc6f6p-1,   0x1.686128p-5, INEXACT)
T(RN,  0x1.f954b3eae2e87p+521,   -0x1.ec2968803c418p-1,   0x1.102fd6p-3, INEXACT)
T(RN,  0x1.f6045be47673ap+521,    0x1.8ad5a8bd44938p-1,    0x1.d7636p-4, INEXACT)
T(RN,  0x1.5cbca235cbee3p+521,   -0x1.efc42d76663b6p-1,   0x1.ce2c24p-2, INEXACT)
T(RN,  0x1.6f52425fe023dp+521,   -0x1.61d5fce9349a5p-2,   0x1.fb7814p-2, INEXACT)
T(RN,  0x1.c21baf92d588ap+521,   -0x1.f299fc8f70b9dp-2,   0x1.eb899ep-2, INEXACT)
T(RN,  0x1.d6ac2b907c94ap+522,    0x1.9b3b90a344cbbp-1,  -0x1.d45e54p-4, INEXACT)
T(RN,  0x1.2baab4843f64fp+522,   -0x1.f021f98ba32d3p-1,   -0x1.386aep-3, INEXACT)
T(RN,  0x1.51f29951a4e1cp+522,    0x1.facb2d1cebdedp-1,   0x1.8614aep-2, INEXACT)
T(RN,  0x1.fa2b3d077b212p+522,    0x1.cb5715cb630bap-1,  -0x1.79b83cp-2, INEXACT)
T(RN,  0x1.fd31a72230bb9p+522,   -0x1.ec8646bb3636fp-1,   0x1.86db54p-3, INEXACT)
T(RN,  0x1.a00c33d791a76p+522,    0x1.e9b02225cf3cep-2,   0x1.fa7b26p-2, INEXACT)
T(RN,  0x1.4e141519ee9fcp+522,    0x1.f88c461f6189ep-1,     0x1.8499p-2, INEXACT)
T(RN,  0x1.e94cb34c19414p+522,   -0x1.69dfda71a2a04p-6,   0x1.9d376ep-2, INEXACT)
T(RN,  0x1.4a7ed5196124fp+522,   -0x1.6cbc9ebf39b2bp-1,   0x1.6bcf72p-2, INEXACT)
T(RN,  0x1.a3610447c9705p+522,   -0x1.2303d05330a06p-2,   0x1.b3e292p-2, INEXACT)
T(RN,  0x1.0cefad9f380e8p+523,   -0x1.ffbec819eaebep-1,  -0x1.c8b892p-6, INEXACT)
T(RN,  0x1.70ad06896a21cp+523,   -0x1.fd926cd0aafffp-1,   0x1.8c2f6ep-4, INEXACT)
T(RN,  0x1.b4079201eb216p+523,    0x1.2c36f94cecc23p-1,   0x1.503626p-4, INEXACT)
T(RN,  0x1.63839528f053ep+523,    0x1.fff9454df2ea3p-1,   0x1.e25ecep-3, INEXACT)
T(RN,  0x1.724f57b9615bfp+523,     0x1.79a5bc2fb8d9p-2,  -0x1.3dedccp-3, INEXACT)
T(RN,  0x1.00446ebf72863p+523,   -0x1.d492bfb67e869p-1,   0x1.71518ep-2, INEXACT)
T(RN,  0x1.8d81bf260b4fap+523,    0x1.816b6c195c363p-1,  -0x1.b3a094p-2, INEXACT)
T(RN,  0x1.d8b414c37924cp+523,    0x1.0210204784704p-1,  -0x1.aa34d6p-2, INEXACT)
T(RN,  0x1.86df388dd6fc8p+523,    0x1.359913310ac05p-1,   0x1.314ed6p-4, INEXACT)
T(RN,  0x1.2d6d0fae63e44p+523,   -0x1.7d9181e35d66ap-4,   0x1.023186p-4, INEXACT)
T(RN,  0x1.d5ed17f26de16p+524,    0x1.a013a9dff9327p-1,  -0x1.546f82p-3, INEXACT)
T(RN,  0x1.28e38f54f97f3p+524,   -0x1.e7d4a19573407p-2,   0x1.4d2cd6p-2, INEXACT)
T(RN,  0x1.e9917323fd032p+524,   -0x1.e25ab59f8d8f6p-1,   0x1.459896p-2, INEXACT)
T(RN,  0x1.ecccaff173f4bp+524,    0x1.e06c576ed5ea5p-1,  -0x1.c4b932p-2, INEXACT)
T(RN,  0x1.1c3946bc6610ap+524,   -0x1.fd8897d7f74f6p-1,   0x1.df608cp-3, INEXACT)
T(RN,  0x1.459a22842b86cp+524,    0x1.47e4439703489p-1,   0x1.244dc6p-2, INEXACT)
T(RN,  0x1.52c4281824e9ep+524,   -0x1.44c69439b8c5bp-1,   0x1.a1d682p-4, INEXACT)
T(RN,  0x1.ba7e235dce3e7p+524,    0x1.528acc515f3d6p-5,  -0x1.8b3f96p-2, INEXACT)
T(RN,  0x1.c85dcaafe8fcep+524,   -0x1.3062bdb31d13cp-1,   0x1.7838cap-2, INEXACT)
T(RN,  0x1.c6b5519b144dcp+524,   -0x1.ede3c54a5308fp-1,   0x1.8f6fd4p-3, INEXACT)
T(RN,   0x1.e64817bd18e5p+525,   -0x1.1a361156968cdp-2,  -0x1.436e5cp-3, INEXACT)
T(RN,  0x1.1e4eb9255d8dbp+525,    0x1.5bd1aa4eb19e7p-2,   0x1.c9da5ep-3, INEXACT)
T(RN,  0x1.19a6c7dfd3e06p+525,    0x1.ed294c135b2bcp-1,   0x1.f5d348p-7, INEXACT)
T(RN,  0x1.5e69b04d2ac79p+525,   -0x1.fcf206d25a837p-2,  -0x1.96137ap-2, INEXACT)
T(RN,  0x1.7c9d90940c1eep+525,   -0x1.fbdec7c412c46p-1,    0x1.d4a72p-2, INEXACT)
T(RN,  0x1.b361c795e14bep+525,   -0x1.0d283d4e58e79p-2,    -0x1.37c6p-2, INEXACT)
T(RN,   0x1.dd14426efa86p+525,    0x1.d06b6c7d09139p-1,  -0x1.fae77ap-2, INEXACT)
T(RN,  0x1.d9cc4128e71c8p+525,    0x1.95e28d042debdp-1,   0x1.a96d72p-2, INEXACT)
T(RN,  0x1.64126ac2cb899p+525,    -0x1.fca702eee87bp-2,   0x1.87eb2ep-2, INEXACT)
T(RN,  0x1.155837e87aef8p+525,     0x1.7f658351bf71p-1,  -0x1.7845cep-3, INEXACT)
T(RN,  0x1.903230e24468bp+526,     0x1.c4c5c9d506bep-1,  -0x1.00e6e2p-2, INEXACT)
T(RN,  0x1.6e72950bf2686p+526,    -0x1.9c02277d07b9p-2,   0x1.dc238cp-2, INEXACT)
T(RN,  0x1.62af4253805acp+526,   -0x1.b6047587a141ap-3,   0x1.b7918ap-4, INEXACT)
T(RN,  0x1.fc5b861f0764ap+526,    0x1.d5947b6813f0fp-1,  -0x1.b66c34p-2, INEXACT)
T(RN,  0x1.b391465878bf2p+526,   -0x1.bb5eb31707b1dp-1,  -0x1.2a9374p-7, INEXACT)
T(RN,  0x1.0bd1559d1663dp+526,   -0x1.2b4381f2b2a4ap-1,   0x1.1faee6p-2, INEXACT)
T(RN,  0x1.fe4a22482a406p+526,   -0x1.6c79a74e055cep-3,   0x1.ec49d2p-3, INEXACT)
T(RN,  0x1.9171a9165ebcbp+526,   -0x1.f8701525818c4p-1,  -0x1.6ba11cp-3, INEXACT)
T(RN,  0x1.5ff7fed3dd915p+526,    0x1.ffff4c7d608b9p-1,  -0x1.1371bep-2, INEXACT)
T(RN,  0x1.a6dc56ed85b16p+526,   -0x1.fd2e531eeb506p-1,   -0x1.5548cp-2, INEXACT)
T(RN,  0x1.ac5edd1437182p+527,   -0x1.04aebab20576dp-1,  -0x1.b3fb04p-4, INEXACT)
T(RN,  0x1.787510273f75dp+527,    0x1.ff57d4fd44fe3p-1,  -0x1.162fa2p-2, INEXACT)
T(RN,  0x1.a860e327d25c2p+527,   -0x1.7a7a537cfa1bcp-1,  -0x1.93aacap-5, INEXACT)
T(RN,   0x1.55d40876968fp+527,    0x1.cbad3dd9b39f3p-2,   0x1.a88144p-2, INEXACT)
T(RN,  0x1.caa27e342c582p+527,   -0x1.69831dde5d55bp-5,   0x1.7127fcp-2, INEXACT)
T(RN,  0x1.b9a41d386382ap+527,    0x1.4aded59bcd31cp-2,   0x1.e91c3ap-2, INEXACT)
T(RN,  0x1.dc1f76a43baf6p+527,    0x1.2825c5b6e77dcp-2,   0x1.6ca686p-3, INEXACT)
T(RN,  0x1.0fa4a450af989p+527,   -0x1.86448bac80fecp-2,  -0x1.afeef4p-5, INEXACT)
T(RN,  0x1.2f2bc2419f08cp+527,   -0x1.1b712b582e16ep-3,  -0x1.e0731cp-2, INEXACT)
T(RN,  0x1.69b64ae0ecc82p+527,   -0x1.fc9dc3d06106fp-1,  -0x1.091092p-4, INEXACT)
T(RN,  0x1.6f61c395bebfcp+528,    0x1.b3dd21c961844p-1,  -0x1.ed5414p-2, INEXACT)
T(RN,   0x1.bc3491a1e139p+528,   -0x1.ce62147e6f40bp-3,  -0x1.637e42p-2, INEXACT)
T(RN,  0x1.3d53df95ee6c5p+528,   -0x1.4c9cffa308c8bp-1,   0x1.140758p-2, INEXACT)
T(RN,  0x1.fe137b61f32e6p+528,    0x1.156e190b0fef8p-3,  -0x1.a54824p-2, INEXACT)
T(RN,  0x1.8ccd208a8ba8cp+528,   -0x1.f139b693ff91cp-1,  -0x1.cba21ap-5, INEXACT)
T(RN,  0x1.84969a5d906eep+528,   -0x1.56dca670cfcefp-2,   -0x1.356b7p-3, INEXACT)
T(RN,  0x1.394f4671e853ep+528,    0x1.08f58186934c3p-1,  -0x1.8ae14cp-9, INEXACT)
T(RN,  0x1.28a83bd541314p+528,    0x1.1fddd2ce3a2cfp-1,   0x1.32a8aap-2, INEXACT)
T(RN,  0x1.b2021e0b53bf4p+528,   -0x1.42844a5e8f669p-1,   0x1.7ad27cp-2, INEXACT)
T(RN,  0x1.a9ade1360d55dp+528,   -0x1.faf50bbcc9b78p-1,   0x1.c6858ep-2, INEXACT)
T(RN,  0x1.bf49d59fcc9abp+529,    0x1.134acf1cb35b5p-1,  -0x1.c2813cp-2, INEXACT)
T(RN,  0x1.af52eff6e7bdap+529,    0x1.c0bce64bcb2bdp-2,  -0x1.216f48p-9, INEXACT)
T(RN,  0x1.66fb5910a0f17p+529,   -0x1.e16adbc525a09p-1,   0x1.68202ep-3, INEXACT)
T(RN,  0x1.282e284045524p+529,   -0x1.ffee01b859a73p-1,  -0x1.982c5ep-5, INEXACT)
T(RN,  0x1.620a6b56c88dap+529,    0x1.a04e901beec3ap-1,   0x1.756fcap-2, INEXACT)
T(RN,  0x1.b4657f7109c68p+529,   -0x1.400dba9c21f47p-2, -0x1.8c9ea2p-10, INEXACT)
T(RN,  0x1.7b202dcd5055ep+529,    0x1.e2f91d9511785p-1,   0x1.ac704ap-2, INEXACT)
T(RN,  0x1.e0357392f49dep+529,   -0x1.dcb82ccbd6736p-2,   0x1.0c50dep-2, INEXACT)
T(RN,  0x1.5af6997ef5c8bp+529,   -0x1.d8e78bc74c0efp-1,  -0x1.938a6ep-4, INEXACT)
T(RN,  0x1.f9ca5ea96486ap+529,   -0x1.10e52142d8436p-1,  -0x1.391d6cp-2, INEXACT)
T(RN,  0x1.247d35a4c8fabp+530,    0x1.f0e58a3700f3ep-2,  -0x1.2833f8p-3, INEXACT)
T(RN,  0x1.016548696de33p+530,   -0x1.a6116c3dd873fp-1,  -0x1.9a0af8p-3, INEXACT)
T(RN,  0x1.a472d62c9252ep+530,   -0x1.6c52b92e80678p-1,  -0x1.ec378ap-4, INEXACT)
T(RN,  0x1.48ecb6cb7d1eep+530,    0x1.c537aa53402bbp-2,  -0x1.69aa7ap-2, INEXACT)
T(RN,  0x1.7ed8e4e390785p+530,   -0x1.facf54166865dp-3,  -0x1.14cb62p-4, INEXACT)
T(RN,  0x1.3ef09e187c5f6p+530,   -0x1.f40abc387ccf2p-1,   0x1.fa83eep-4, INEXACT)
T(RN,  0x1.dc592c121e524p+530,   -0x1.bb3c8fc90f811p-3,   0x1.475f7cp-3, INEXACT)
T(RN,  0x1.dcf819ed37ca8p+530,    0x1.e6f63ee117b1ep-1,   0x1.8fe238p-3, INEXACT)
T(RN,  0x1.a0d647e011c38p+530,   -0x1.8f8e4504f6babp-2,   0x1.67f916p-2, INEXACT)
T(RN,  0x1.23453650c38a1p+530,    0x1.2baf77996f1d6p-1,   0x1.90cc88p-2, INEXACT)
T(RN,  0x1.fa7bd8b62fff7p+531,     0x1.9183f8f1ad56p-4,  -0x1.62b692p-3, INEXACT)
T(RN,  0x1.aa3a609a26eb4p+531,   -0x1.38c8e44eaa8bdp-1,  -0x1.cc4618p-2, INEXACT)
T(RN,  0x1.c8dd97fa97c5bp+531,    0x1.ff75483020e3fp-1,   0x1.ec0df6p-2, INEXACT)
T(RN,  0x1.8ea6c17751c4cp+531,    0x1.b997577bb5f98p-1,  -0x1.10ba8cp-2, INEXACT)
T(RN,  0x1.00c4a02fbc944p+531,   -0x1.a37f9b142ecbep-2,  -0x1.ff2eaap-2, INEXACT)
T(RN,  0x1.6f220ff72a4a2p+531,    0x1.96b145432548ep-1,   0x1.610774p-2, INEXACT)
T(RN,  0x1.655777e835b3fp+531,    0x1.bc4f0a6af7ab9p-3,  -0x1.083e92p-2, INEXACT)
T(RN,  0x1.755e4afa3a005p+531,    0x1.dbe35352a69d3p-1,   0x1.a23846p-2, INEXACT)
T(RN,  0x1.d38e5cd4800e6p+531,    0x1.e571673b40928p-1,  -0x1.cb557ap-2, INEXACT)
T(RN,  0x1.88bd2fffe510cp+531,   -0x1.2243e9f50df6dp-4,    0x1.21d18p-4, INEXACT)
T(RN,  0x1.c6675db88cc48p+532,   -0x1.fc1128a4ee2adp-3,   -0x1.8e58ep-3, INEXACT)
T(RN,  0x1.e7a0e692a1336p+532,    0x1.ab6510f01e8cfp-6,   0x1.a7a7dep-2, INEXACT)
T(RN,  0x1.8f9e02c072e47p+532,   -0x1.982ac46a68721p-1,  -0x1.db7432p-5, INEXACT)
T(RN,  0x1.6c673407e8bb4p+532,   -0x1.fd3435c74d083p-1,   0x1.cbed88p-4, INEXACT)
T(RN,  0x1.23c045fcb03e6p+532,    0x1.ff1d2a3091466p-1,  -0x1.9f6d92p-2, INEXACT)
T(RN,  0x1.8b250c214c5e4p+532,    0x1.31cb5f40e0abep-3,   0x1.bc8914p-2, INEXACT)
T(RN,  0x1.bdfa9d5c9581dp+532,   -0x1.aa80c211b7739p-1,  -0x1.4f7db2p-2, INEXACT)
T(RN,  0x1.b3967b9ffaf58p+532,    0x1.ff510b0d64c9ep-1,  -0x1.164f66p-3, INEXACT)
T(RN,  0x1.61c979ec25355p+532,   -0x1.a3c19fc687bb4p-2,  -0x1.e88d32p-2, INEXACT)
T(RN,  0x1.0c0845d21627dp+532,    0x1.382dfef91d622p-1,  -0x1.6b0dbcp-2, INEXACT)
T(RN,  0x1.15c6b8c77068ap+533,    0x1.f2a8067ca3aedp-1,   -0x1.e154bp-3, INEXACT)
T(RN,  0x1.e83b476cd6962p+533,    0x1.8f0eba4ac6ecdp-1,  -0x1.2342fap-2, INEXACT)
T(RN,  0x1.28abc09bbcc4dp+533,   -0x1.4364729967dcap-1,   0x1.9419bcp-3, INEXACT)
T(RN,  0x1.990f5b7fb8f61p+533,   -0x1.65a587e4008ddp-4,  -0x1.dd5208p-2, INEXACT)
T(RN,  0x1.781294e545f13p+533,    0x1.77cf4d0348895p-1,   0x1.f13f34p-4, INEXACT)
T(RN,  0x1.65be01ca9e9dfp+533,   -0x1.f0de21f200b2fp-1,   0x1.91bc82p-2, INEXACT)
T(RN,  0x1.c268ade22312ep+533,    0x1.05d30552ee9d2p-4,   0x1.f63062p-2, INEXACT)
T(RN,  0x1.9658c7f65dfb1p+533,   -0x1.f7e8e8a899221p-2,  -0x1.b7b9f6p-5, INEXACT)
T(RN,   0x1.4fb3b79805fbp+533,   -0x1.a9694d5c83902p-1,  -0x1.d7cdbap-4, INEXACT)
T(RN,  0x1.8563358fac648p+533,    0x1.22df616c08e15p-1,  -0x1.bcf1c6p-7, INEXACT)
T(RN,  0x1.b478245fa5f38p+534,    0x1.e70241885883bp-1,  -0x1.ef67bap-2, INEXACT)
T(RN,  0x1.4362801b27f68p+534,     0x1.db4b04ba11bdp-1,  -0x1.66835ap-3, INEXACT)
T(RN,  0x1.b9d5203ff262fp+534,   -0x1.f47e39c50cfecp-1,   -0x1.4da28p-2, INEXACT)
T(RN,  0x1.6e6f55a26bd41p+534,   -0x1.f6a7d6607618ap-1,  -0x1.51154cp-3, INEXACT)
T(RN,   0x1.8d6bdeb7bc9bp+534,   -0x1.9d44dbecf456bp-1,  -0x1.3b4fe2p-2, INEXACT)
T(RN,  0x1.3c3a85d3b8fecp+534,   -0x1.61caf671efaf6p-2,  -0x1.fe3478p-2, INEXACT)
T(RN,  0x1.d3972301f5b1ep+534,   -0x1.c23e72dfe6189p-1,   0x1.893ed2p-4, INEXACT)
T(RN,  0x1.c8de77b8c6f62p+534,   -0x1.9768e71ada729p-1,   0x1.20c3d2p-5, INEXACT)
T(RN,  0x1.c808008365ac6p+534,   -0x1.62ec3f349d2aep-1,   0x1.3fff32p-2, INEXACT)
T(RN,   0x1.c572180d26b6p+534,    0x1.e790dedc3ceb2p-6,   0x1.8041aap-2, INEXACT)
T(RN,  0x1.fe2c831ed72fep+535,   -0x1.a99aaea0496b3p-1,  -0x1.140952p-2, INEXACT)
T(RN,  0x1.f85b823f88916p+535,    0x1.195d7605b6cdcp-1,   0x1.9a5efcp-3, INEXACT)
T(RN,  0x1.0b150771e8042p+535,    0x1.afcffaa11c09bp-1,  -0x1.b62128p-5, INEXACT)
T(RN,  0x1.b17f3097bf64bp+535,   -0x1.fe7bc0a4c0762p-1,  -0x1.e5114ap-2, INEXACT)
T(RN,  0x1.148814620b508p+535,    -0x1.6ec3c2967cc7p-1,   0x1.dbd846p-2, INEXACT)
T(RN,  0x1.2d12c01aa722dp+535,   -0x1.fe0e7f775555bp-1,  -0x1.e7a86ep-5, INEXACT)
T(RN,  0x1.abcc67df0da54p+535,   -0x1.ebb2b6b4115efp-1,  -0x1.08acbep-2, INEXACT)
T(RN,  0x1.e77d6831407b4p+535,   -0x1.a2ac75950a00dp-4,   0x1.f2d598p-3, INEXACT)
T(RN,  0x1.74fac847cf1d8p+535,   -0x1.355aaff204609p-4,   0x1.d919bep-4, INEXACT)
T(RN,   0x1.4d5c14546eafp+535,    0x1.cc72e59fef73ap-1,  -0x1.d63e2ep-6, INEXACT)
T(RN,  0x1.b7024ad3f1b19p+536,    0x1.5ff39821d6c0fp-3,  -0x1.e98df8p-2, INEXACT)
T(RN,  0x1.06985736974a9p+536,      0x1.fc978828b4dp-1,  -0x1.fde84ep-2, INEXACT)
T(RN,  0x1.0e83de55d72a1p+536,    0x1.7c4950a4bf278p-2,   -0x1.c1ef6p-2, INEXACT)
T(RN,  0x1.1d46fa596f5b3p+536,    0x1.824195115d303p-6,  -0x1.6de832p-2, INEXACT)
T(RN,  0x1.732bf8a38bc06p+536,   -0x1.fc86c7a30b87ep-1,   0x1.b021ecp-2, INEXACT)
T(RN,  0x1.9781adcdf7e76p+536,    -0x1.49a4bd21c65bp-4,  -0x1.4f5776p-5, INEXACT)
T(RN,  0x1.7712cad5fd91bp+536,   -0x1.f72c9b528f864p-1,  -0x1.9f2faep-3, INEXACT)
T(RN,  0x1.c9ae34ebb3c98p+536,   -0x1.c524d4164ef22p-1,   0x1.81c99ep-3, INEXACT)
T(RN,  0x1.10f4b7344f57cp+536,    0x1.fa6f4870a8238p-1,     0x1.b843p-4, INEXACT)
T(RN,   0x1.62f98fcf05f9p+536,   -0x1.c6a87ba131ee6p-1,  -0x1.cc7fe4p-3, INEXACT)
T(RN,  0x1.0b61029a9406ep+537,   -0x1.05efbce40ca78p-2,   0x1.94b74ap-3, INEXACT)
T(RN,  0x1.2eb5efc6dbad2p+537,    0x1.16ab6d5fc2a92p-1,  -0x1.f8aaccp-2, INEXACT)
T(RN,  0x1.3117f339ebe5cp+537,    0x1.fed0312dbe213p-1,   0x1.feee8cp-2, INEXACT)
T(RN,     0x1.a8c01fd43cp+537,   -0x1.fff11e871d59cp-1,   0x1.f0999ep-3, INEXACT)
T(RN,  0x1.c369e22187c9cp+537,   -0x1.b654e6fd5d7e3p-1,   0x1.5000d2p-5, INEXACT)
T(RN,  0x1.8f4b1169f62b5p+537,   -0x1.f730d161321a3p-1,   0x1.749e9ep-6, INEXACT)
T(RN,  0x1.2619005e08d7ep+537,    0x1.1b169b10fcdacp-1,  -0x1.bcf77ep-2, INEXACT)
T(RN,  0x1.a11a995accfeep+537,    0x1.3f0a862d621aap-1,  -0x1.c64858p-4, INEXACT)
T(RN,  0x1.a9456b193c88fp+537,   -0x1.b9b7c93670e17p-1,   0x1.d12624p-2, INEXACT)
T(RN,  0x1.f3f849a43344ap+537,   -0x1.ff0197577bd03p-1,  -0x1.6c7492p-4, INEXACT)
T(RN,  0x1.f04e8262327dap+538,    0x1.9a1c7b861ac36p-7,  -0x1.3346e2p-2, INEXACT)
T(RN,   0x1.666ed466c293p+538,   -0x1.b583084c2d289p-2,  -0x1.f49318p-3, INEXACT)
T(RN,  0x1.1d403e6b10797p+538,    0x1.b5581b6698a5ap-1,   0x1.da1074p-2, INEXACT)
T(RN,  0x1.b8f964d9b65aap+538,   -0x1.203983b9909d8p-1,   0x1.80bd66p-2, INEXACT)
T(RN,  0x1.120e4f29ca365p+538,    0x1.8c93f2bf9addfp-1,    0x1.d53b4p-2, INEXACT)
T(RN,  0x1.9d69804300e0ap+538,    -0x1.ffe6edf2b073p-1,  -0x1.7ca27ep-5, INEXACT)
T(RN,  0x1.3ec19cd2639c6p+538,   -0x1.f885749252cb5p-1,   0x1.cb43e8p-2, INEXACT)
T(RN,  0x1.cdd5cbdebe908p+538,    0x1.d66e860824b96p-1,  -0x1.c9407cp-3, INEXACT)
T(RN,  0x1.e00a28612db54p+538,    0x1.494731ff63529p-1,   0x1.a34ca8p-3, INEXACT)
T(RN,  0x1.402563eeb8bcap+538,   -0x1.d9d0bb21591e4p-1,  -0x1.dec772p-2, INEXACT)
T(RN,  0x1.0f83f00ffaa7cp+539,    0x1.37df0c279604fp-1,   0x1.792588p-2, INEXACT)
T(RN,  0x1.cbacaeb6a7493p+539,   -0x1.a2d446e981445p-1,   0x1.47f46ep-6, INEXACT)
T(RN,  0x1.00a1aee02b895p+539,   -0x1.3b2f0dfab4a54p-1,  -0x1.3c0a22p-2, INEXACT)
T(RN,  0x1.78ac61d7f8694p+539,   -0x1.d28aa10f58a8bp-1,   -0x1.20dc3p-2, INEXACT)
T(RN,  0x1.d8d240c89e40cp+539,    0x1.db77804b67d62p-6,  -0x1.9f1f12p-2, INEXACT)
T(RN,  0x1.4415131f9ff26p+539,    -0x1.751e7771646ep-1,   0x1.95c2f6p-4, INEXACT)
T(RN,  0x1.87abb22d6bfd8p+539,    0x1.c63dd657ec69fp-1,   0x1.c53f24p-2, INEXACT)
T(RN,  0x1.9ff9d2c1fb7e8p+539,    0x1.26f12098c81e9p-2,   0x1.5dfba2p-3, INEXACT)
T(RN,  0x1.97381fe60aba8p+539,   -0x1.b0a2583562aeep-1,   0x1.0c45ecp-2, INEXACT)
T(RN,   0x1.9939fbf0fd8dp+539,    0x1.37678f142f9b9p-2,   -0x1.ed232p-4, INEXACT)
T(RN,  0x1.671985c9be283p+540,   -0x1.53b7cf55b0333p-1,  -0x1.0e5a0ep-2, INEXACT)
T(RN,  0x1.e586ef9e669f2p+540,   -0x1.fc899771858ffp-1,   -0x1.c2c7cp-2, INEXACT)
T(RN,  0x1.92ec4fe9cf859p+540,    0x1.a6a707d75bc91p-5,  -0x1.834108p-4, INEXACT)
T(RN,  0x1.7f97b67c84a06p+540,   -0x1.d94846f9a950bp-1,  -0x1.bcdd2ap-6, INEXACT)
T(RN,  0x1.30c966361c221p+540,   -0x1.8ac082ae80507p-1,    0x1.ca872p-2, INEXACT)
T(RN,   0x1.82d3969cd151p+540,    0x1.87414d136f973p-2,   0x1.97ac98p-3, INEXACT)
T(RN,  0x1.8a0d55b6b164cp+540,   -0x1.ff1e0383c8a5ep-1,   0x1.3c0322p-3, INEXACT)
T(RN,  0x1.ff091159d36b4p+540,    0x1.76314b9183248p-2,    0x1.c9583p-2, INEXACT)
T(RN,  0x1.8ad950e7d252ep+540,   -0x1.d4e058e43a76bp-2,  -0x1.4a629ep-4, INEXACT)
T(RN,   0x1.51348980306ep+540,   -0x1.e005e91e396b1p-1,   0x1.4d62bcp-2, INEXACT)
T(RN,  0x1.3a0fc0144236ep+541,    0x1.47043dd2a3739p-5,   -0x1.6f17dp-4, INEXACT)
T(RN,  0x1.874004e8b7e28p+541,    0x1.49417a3750866p-1,  -0x1.c5a158p-5, INEXACT)
T(RN,  0x1.018e2b0a41534p+541,   -0x1.fa670bc95b066p-1,   0x1.10d1ecp-2, INEXACT)
T(RN,  0x1.2125075c6064dp+541,    0x1.4a79cfe272835p-6,    0x1.99e68p-2, INEXACT)
T(RN,  0x1.657858def480ap+541,   -0x1.640f8b4922c52p-3,   0x1.f206c6p-3, INEXACT)
T(RN,  0x1.e449872d251dcp+541,   -0x1.6dab3c06a15e3p-2,   0x1.2b912ap-3, INEXACT)
T(RN,  0x1.28cae1e41f622p+541,    0x1.4773ac46e7ec6p-1,   0x1.f42e5cp-2, INEXACT)
T(RN,  0x1.952b478c785a6p+541,     0x1.f937e84d618bp-1,    0x1.17688p-2, INEXACT)
T(RN,  0x1.f9fe347f3db7bp+541,    0x1.e3f928ed3f417p-1,     0x1.5665p-2, INEXACT)
T(RN,  0x1.702afa13f6ee6p+541,   -0x1.e0873311e93a5p-1,   0x1.755ea4p-3, INEXACT)
T(RN,  0x1.589511607c76cp+542,   -0x1.bdcda8e4079a2p-1,   0x1.d22acep-5, INEXACT)
T(RN,   0x1.a1c3208e1888p+542,   -0x1.2144a2b39abb5p-1,   0x1.27e832p-2, INEXACT)
T(RN,  0x1.e36c7b7da9d82p+542,    0x1.22332dd71f7f2p-1,  -0x1.f41304p-3, INEXACT)
T(RN,  0x1.7620a7fb5f414p+542,    0x1.c819df24ce6d3p-1,    0x1.0dc13p-2, INEXACT)
T(RN,  0x1.ae27c4facc82ep+542,    0x1.f304b04d8adf3p-1,  -0x1.de201ap-4, INEXACT)
T(RN,  0x1.aa87ab94176ecp+542,   -0x1.7322e191de049p-1,    0x1.22554p-3, INEXACT)
T(RN,  0x1.9c338b12136c3p+542,    0x1.cf8feeea24912p-1,   0x1.fcd5f6p-2, INEXACT)
T(RN,  0x1.bdcaedb42337fp+542,     0x1.1027934c990ep-2,  -0x1.e0bbf2p-7, INEXACT)
T(RN,  0x1.785a6088f3f82p+542,   -0x1.d8a799654163dp-1,  -0x1.2a1206p-5, INEXACT)
T(RN,  0x1.d01287887f198p+542,   -0x1.635a13c08e505p-2,   0x1.c845c4p-3, INEXACT)
T(RN,  0x1.c7c154091e976p+543,   -0x1.4d0c9512fe518p-4,   0x1.40bc2ap-5, INEXACT)
T(RN,  0x1.a4c26974e09d6p+543,    0x1.5a7080ed6cb68p-1,  -0x1.ce09bcp-2, INEXACT)
T(RN,  0x1.b21bbad1adf31p+543,    0x1.d682458de0a71p-2,  -0x1.b4bd7ap-5, INEXACT)
T(RN,  0x1.3b801db337fc8p+543,    0x1.cd53ec1264afbp-2,  -0x1.b208a8p-3, INEXACT)
T(RN,  0x1.037d32e6aa9fbp+543,   -0x1.53e5e1190fc1bp-1,  -0x1.17680ap-3, INEXACT)
T(RN,  0x1.1aa430efd3c5cp+543,   -0x1.1ddceb5c1d202p-2,   0x1.642c42p-2, INEXACT)
T(RN,  0x1.5e402aa37e598p+543,   -0x1.20b3ccfdb40bap-1,   0x1.43089cp-3, INEXACT)
T(RN,  0x1.d61bc586329f1p+543,    0x1.6b35d51a5a77fp-3,   0x1.4cff8cp-3, INEXACT)
T(RN,  0x1.21f00ede32191p+543,    -0x1.bad2a5fbdd14p-1,  -0x1.97e51cp-2, INEXACT)
T(RN,  0x1.791a1bf1a63c9p+543,    0x1.d54383bdc3cf7p-2,   0x1.dcb944p-2, INEXACT)
T(RN,  0x1.fde1957058bb8p+544,    0x1.f1daf219b2ebcp-3,    0x1.08874p-3, INEXACT)
T(RN,  0x1.c04bcdee97684p+544,    0x1.f9e9559fd59bfp-1,   0x1.0f63f6p-2, INEXACT)
T(RN,  0x1.da8d0861d99ecp+544,    0x1.7f384a41683f5p-2,   0x1.157a9ep-2, INEXACT)
T(RN,  0x1.d6900dd440dfcp+544,   -0x1.fb3b7c2c8aed6p-1,  -0x1.87151ep-3, INEXACT)
T(RN,  0x1.f56caec5e85aap+544,   -0x1.d6d4956f5f031p-1,  -0x1.d591c6p-4, INEXACT)
T(RN,  0x1.752003d7a8178p+544,   -0x1.81ef4b27655b9p-1,   0x1.d721b4p-3, INEXACT)
T(RN,  0x1.da2a84a63f48cp+544,   -0x1.b050ae94529fap-1,   0x1.2057fcp-2, INEXACT)
T(RN,  0x1.91c0c349fcdcap+544,     0x1.b399863a836ap-2,  -0x1.2a9112p-3, INEXACT)
T(RN,  0x1.aa19c5a056193p+544,    0x1.431705c9eac95p-2,  -0x1.99224ap-3, INEXACT)
T(RN,  0x1.6be53c338dd8fp+544,    0x1.fff4fb980138bp-1,   0x1.190b1cp-2, INEXACT)
T(RN,  0x1.cd8ce70566becp+545,     0x1.b4e9afff1476p-5,  -0x1.d96764p-4, INEXACT)
T(RN,  0x1.2d9790850b6b3p+545,   -0x1.ff94fd8eace27p-1,   0x1.578a4cp-3, INEXACT)
T(RN,  0x1.bcd9291962687p+545,   -0x1.966311b145ba9p-1,  -0x1.588134p-2, INEXACT)
T(RN,  0x1.74ffa37f44cdap+545,    0x1.b733cd695abcfp-1,  -0x1.6dcc12p-2, INEXACT)
T(RN,  0x1.8c3b64fd3d263p+545,    0x1.c4c05fb7f52d1p-1,   0x1.50a842p-2, INEXACT)
T(RN,  0x1.2346e817bbe04p+545,   -0x1.8d4d44e202022p-1,  -0x1.9f104cp-4, INEXACT)
T(RN,  0x1.69c5912961315p+545,    0x1.343afb59fe0abp-2,   -0x1.b19f7p-3, INEXACT)
T(RN,  0x1.5a5deccd9dfa8p+545,    0x1.e7c70a347ff39p-1,  -0x1.4836acp-4, INEXACT)
T(RN,  0x1.d0a2c252aecb8p+545,   -0x1.21e31f133ec72p-1,    -0x1.ea6cp-2, INEXACT)
T(RN,  0x1.c6647c32e7ba2p+545,    0x1.36ebaef8dbb0bp-4,  -0x1.e270b6p-5, INEXACT)
T(RN,  0x1.2a7cd97c53787p+546,    0x1.f72d9b3cc1c62p-1,  -0x1.d3c314p-3, INEXACT)
T(RN,   0x1.e4ffd98986e9p+546,     0x1.4a8f37ffdfe1p-2,   0x1.e2156cp-6, INEXACT)
T(RN,  0x1.eca89888c9de2p+546,    0x1.b08d2d4cd6abdp-1,   0x1.d7f816p-5, INEXACT)
T(RN,  0x1.da4c2448a0b3fp+546,    0x1.eb6cfd4e6bcd4p-1,   0x1.410ad2p-2, INEXACT)
T(RN,  0x1.319d30578b643p+546,   -0x1.b37a6a4d38b3dp-1,   0x1.65110cp-2, INEXACT)
T(RN,  0x1.d5ad4c02ea82cp+546,   -0x1.e83f9255b66f8p-1,  -0x1.af18eap-5, INEXACT)
T(RN,  0x1.cbbed18cf887dp+546,    0x1.a4df91b33b597p-1,  -0x1.f26aaap-2, INEXACT)
T(RN,  0x1.a77bbdb551154p+546,   -0x1.9676f8f5c4cc9p-6,   0x1.ee2774p-2, INEXACT)
T(RN,  0x1.8f40069bf96f2p+546,    -0x1.7686074e79dep-1,  -0x1.ecb18cp-7, INEXACT)
T(RN,   0x1.5104f7067666p+546,   -0x1.d1d06abc5e657p-1,  -0x1.1d48e8p-2, INEXACT)
T(RN,  0x1.064f8b4027fa7p+547,    0x1.d9dd67979936bp-1,   0x1.1dc622p-3, INEXACT)
T(RN,  0x1.6267e4eefc2b3p+547,    0x1.fbff7c51ead4ep-1,   0x1.1f04e6p-2, INEXACT)
T(RN,  0x1.ae4cf53524c72p+547,    0x1.0f399db9e08e9p-8,  -0x1.994a16p-2, INEXACT)
T(RN,   0x1.34793c0a16c6p+547,   -0x1.a28137c96a5edp-2,  -0x1.052582p-6, INEXACT)
T(RN,   0x1.9a704b75f48cp+547,   -0x1.4eab9da51ed23p-1,   0x1.218328p-4, INEXACT)
T(RN,  0x1.ff2f3d8d1dd5ap+547,   -0x1.e2d48f432e03fp-1,   -0x1.abf87p-4, INEXACT)
T(RN,  0x1.5569763f778acp+547,   -0x1.9aa771dc0a81ep-1,  -0x1.eb9b36p-3, INEXACT)
T(RN,  0x1.74cdef337cc56p+547,   -0x1.5456405793816p-2,  -0x1.02563cp-3, INEXACT)
T(RN,  0x1.cc758ffa9ca44p+547,    0x1.80da15344d008p-2,    0x1.75347p-2, INEXACT)
T(RN,  0x1.871b900c27586p+547,   -0x1.b79dda10cfaaap-1,   0x1.f964dcp-6, INEXACT)
T(RN,  0x1.a7a9a477ceb3ep+548,    0x1.1da53cbc4101fp-1,   0x1.9e0b7cp-2, INEXACT)
T(RN,  0x1.554fb090e8c22p+548,   -0x1.74b38d18edd8cp-1,  -0x1.bc4b3cp-8, INEXACT)
T(RN,  0x1.d87e0de23ced8p+548,   -0x1.b7d742b2a7861p-1,   0x1.8d00f6p-2, INEXACT)
T(RN,  0x1.ab4456f32f10ap+548,   -0x1.07fa9a89bd9bap-5,    0x1.6be23p-7, INEXACT)
T(RN,  0x1.00f0b272c7cd6p+548,    0x1.ffff883e48a52p-1,   0x1.cc8d32p-2, INEXACT)
T(RN,  0x1.bd00842363b42p+548,    0x1.78ad5f48a44afp-3,  -0x1.8750cep-2, INEXACT)
T(RN,  0x1.8d39db576cb4ep+548,    0x1.f1c756ceadec8p-1,  -0x1.6f108cp-4, INEXACT)
T(RN,  0x1.682ce3ed24e66p+548,   -0x1.cf9bdf0284fecp-1,   0x1.e44f7ep-2, INEXACT)
T(RN,   0x1.872d9651b967p+548,    0x1.3d1fec688a26bp-1,   0x1.d3df74p-2, INEXACT)
T(RN,  0x1.473b8aee58f9bp+548,   -0x1.7c4f960e15bacp-3,  -0x1.3c43d2p-2, INEXACT)
T(RN,  0x1.6343b8fa236d5p+549,   -0x1.fe419285a0f47p-1,    0x1.b002ap-4, INEXACT)
T(RN,  0x1.110b299636e57p+549,    0x1.e0c8fb2580584p-1,   0x1.d8f566p-3, INEXACT)
T(RN,  0x1.24ec690fe938cp+549,    0x1.3753998981a7cp-1,  -0x1.841954p-3, INEXACT)
T(RN,  0x1.87386f3fe643ep+549,    0x1.343e8409454d9p-1,   0x1.8b205ep-3, INEXACT)
T(RN,  0x1.0f85377d9d602p+549,    0x1.ff93951cbefd7p-1,   0x1.73d2f4p-2, INEXACT)
T(RN,  0x1.1fb05825eb4c1p+549,   -0x1.f94cc5e48d74ap-1,    0x1.84c93p-2, INEXACT)
T(RN,   0x1.cda73f1f891dp+549,    0x1.e46aa4af2db14p-1,  -0x1.ef7372p-2, INEXACT)
T(RN,  0x1.ef690be33f744p+549,      0x1.fffe761c5a8p-1,   0x1.2b3a34p-4, INEXACT)
T(RN,  0x1.8b11ca8b8f876p+549,    0x1.d1e1cb3583defp-2,   -0x1.cc22ap-3, INEXACT)
T(RN,  0x1.cd8baabd46d74p+549,    0x1.fcd1cde6bf095p-1,  -0x1.fe92a2p-2, INEXACT)
T(RN,  0x1.dc6fb2c521b36p+550,   -0x1.b2d32c0581ad7p-4,   0x1.2ab44cp-3, INEXACT)
T(RN,  0x1.a420cc27efb22p+550,   -0x1.1a78f02f71f08p-6,  -0x1.80383ap-2, INEXACT)
T(RN,  0x1.3df131e715cd3p+550,     0x1.55c98709822ep-1,  -0x1.6e39c4p-6, INEXACT)
T(RN,  0x1.58672bdff0b87p+550,    0x1.cc5f5b300f9eep-3,   0x1.a3624ep-2, INEXACT)
T(RN,  0x1.dc060707e640ep+550,   -0x1.3cf3c0d9fafa6p-1,  -0x1.5802a6p-3, INEXACT)
T(RN,  0x1.89678972bc434p+550,    0x1.9abce10b5a24dp-1,  -0x1.bbe58ep-6, INEXACT)
T(RN,  0x1.782bf2a0642d7p+550,    0x1.30180b9ddf092p-4,   -0x1.8265dp-2, INEXACT)
T(RN,   0x1.e75a09208012p+550,   -0x1.36207cc1ddd2bp-3,  -0x1.29801ep-3, INEXACT)
T(RN,  0x1.625f741bc7f3ep+550,    0x1.4f055ce95892fp-1,  -0x1.c954c2p-2, INEXACT)
T(RN,  0x1.840f45f96c822p+550,    0x1.9863bfab3887ap-1,  -0x1.6529aep-7, INEXACT)
T(RN,  0x1.8310c90986e74p+551,   -0x1.6c641203b22dfp-1,   0x1.899952p-2, INEXACT)
T(RN,  0x1.3c7a7e5147fa7p+551,    -0x1.f064d39db257p-2,  -0x1.911554p-4, INEXACT)
T(RN,  0x1.3c29026669728p+551,    0x1.0554ec7a71551p-1,   0x1.2cf2f4p-4, INEXACT)
T(RN,  0x1.559ebb1b36c5ep+551,   -0x1.5128fd75579a7p-1,   0x1.ea201cp-2, INEXACT)
T(RN,  0x1.1ea6da7d97b42p+551,    0x1.07e10f1cbcdcdp-1,  -0x1.ef747cp-3, INEXACT)
T(RN,  0x1.b492f85e58e77p+551,   -0x1.505f5fd1bdf0ap-2,  -0x1.bf837ap-2, INEXACT)
T(RN,  0x1.250510e30268ep+551,   -0x1.f1d1e26e0255ep-1,  -0x1.ad491cp-6, INEXACT)
T(RN,  0x1.da2de2f26aff2p+551,    0x1.f11396e82428bp-2,   0x1.3081f8p-2, INEXACT)
T(RN,  0x1.6eefd8ad216a2p+551,    0x1.7d5722f8a9244p-1,    0x1.efb41p-2, INEXACT)
T(RN,  0x1.83f9a09286dc6p+551,    -0x1.10e3d13e08f7p-3,   0x1.f5269ep-3, INEXACT)
T(RN,  0x1.f5af6302c49e6p+552,   -0x1.acdf632b96c96p-1,  -0x1.dc2926p-2, INEXACT)
T(RN,  0x1.9125efa6d09a8p+552,   -0x1.cfc6f0bf0f68ap-2,   0x1.852848p-3, INEXACT)
T(RN,  0x1.f39c1ffd42c09p+552,    0x1.e9d7ce937b40fp-1,   0x1.382ecep-3, INEXACT)
T(RN,  0x1.4c99afa39fc07p+552,   -0x1.fbbe2be1c5adcp-1,   0x1.2bbd64p-3, INEXACT)
T(RN,  0x1.da704500e238dp+552,    0x1.6ee8f0a1977e3p-3,  -0x1.dc41cep-3, INEXACT)
T(RN,  0x1.75e26090d080fp+552,    0x1.56b327d8c3f32p-1,   0x1.e0cddap-2, INEXACT)
T(RN,  0x1.b4b176a3e2436p+552,   -0x1.ff9d9e4235bcfp-1,   0x1.2fb5e8p-7, INEXACT)
T(RN,  0x1.f747b2511fcfap+552,    -0x1.40fbe9af43f9p-2,  -0x1.4f4e54p-3, INEXACT)
T(RN,  0x1.4c3f99cd5a876p+552,   -0x1.b9177b7993b48p-1,   0x1.35d848p-4, INEXACT)
T(RN,  0x1.bf1e5ae01bc4cp+552,   -0x1.36df8e8b773f2p-1,   0x1.3579a8p-3, INEXACT)
T(RN,   0x1.884fac6dd2d4p+553,    0x1.29bc6a7196d08p-1,   -0x1.03fc5p-2, INEXACT)
T(RN,  0x1.af540a0887e22p+553,    0x1.75c0c71846128p-1,  -0x1.039232p-2, INEXACT)
T(RN,  0x1.af51d4395a5f2p+553,    0x1.cba710835353bp-1,  -0x1.2940bep-2, INEXACT)
T(RN,  0x1.1e371f8469d9cp+553,   -0x1.7b498900f8f6ap-3,  -0x1.0b93f2p-4, INEXACT)
T(RN,  0x1.0bfc52684dccdp+553,   -0x1.f92e607ba4f21p-1,  -0x1.d8979ap-2, INEXACT)
T(RN,  0x1.050b631ab1f66p+553,   -0x1.65c31baf128a8p-1,   0x1.0eb042p-6, INEXACT)
T(RN,  0x1.3d1c31d33f7e5p+553,   -0x1.a922e2646ce0dp-1,  -0x1.9c651ep-2, INEXACT)
T(RN,  0x1.b6057e95109e8p+553,   -0x1.ffe53d283cd71p-1,  -0x1.ba558ep-2, INEXACT)
T(RN,  0x1.2ef9421ec849bp+553,   -0x1.23d9c079e3fbap-1,  -0x1.eb0e62p-7, INEXACT)
T(RN,  0x1.75a9e1d74c688p+553,    0x1.ec391a1b9e5f8p-3,  -0x1.d8a114p-4, INEXACT)
T(RN,  0x1.370c7cb2287dbp+554,   -0x1.131146fec7f54p-2,   0x1.fd812ep-7, INEXACT)
T(RN,  0x1.b353d4ce87fb6p+554,    0x1.1f81d7af18062p-5,   0x1.75d4dep-4, INEXACT)
T(RN,  0x1.493494ea5b96dp+554,    0x1.19a7f926c289dp-1,  -0x1.34882ap-5, INEXACT)
T(RN,  0x1.edeac04aba6acp+554,    0x1.fafcea6c3cffcp-1,  -0x1.b6d1c2p-2, INEXACT)
T(RN,  0x1.7c305194f7bd9p+554,   -0x1.b55c0f011a26fp-5,   0x1.4fda1ap-2, INEXACT)
T(RN,  0x1.ade4823e309fcp+554,    0x1.d0fb560ef4091p-1,   0x1.66b402p-3, INEXACT)
T(RN,   0x1.69f65ac774dap+554,   -0x1.5d578d3cfb3a7p-1,   0x1.9d2ca8p-2, INEXACT)
T(RN,  0x1.dde9551a000b8p+554,    0x1.13adbb8627abfp-1,   0x1.592874p-2, INEXACT)
T(RN,  0x1.80f272106f076p+554,    0x1.27dff18896a4fp-4,    0x1.429f8p-4, INEXACT)
T(RN,  0x1.2081b184c31bdp+554,    0x1.fde3804615de6p-1,  -0x1.dad26cp-3, INEXACT)
T(RN,  0x1.8047fd20cc89ap+555,   -0x1.226340c6b9cabp-1,    0x1.535b1p-4, INEXACT)
T(RN,  0x1.67b07e9635664p+555,   -0x1.fe6174775f901p-1,  -0x1.632776p-2, INEXACT)
T(RN,  0x1.9ee514a205d72p+555,   -0x1.b27183b66b593p-1,  -0x1.d1e652p-2, INEXACT)
T(RN,  0x1.9b4cbb2847b2cp+555,    0x1.bd11bd6619208p-2,  -0x1.b4ce6ap-2, INEXACT)
T(RN,  0x1.89d86e20daa1cp+555,    0x1.aa18c52eedcbfp-2,    0x1.0ec05p-3, INEXACT)
T(RN,  0x1.6d26f94a2c607p+555,    0x1.4be490c1ac1a4p-1,  -0x1.c71958p-4, INEXACT)
T(RN,  0x1.5415febbf323fp+555,   -0x1.6a4630ebf6d48p-1,   0x1.773ae2p-2, INEXACT)
T(RN,  0x1.6231a9b00c10ap+555,    0x1.7667eea6d1fecp-7,   -0x1.bc7bap-3, INEXACT)
T(RN,  0x1.c5441fcd6d825p+555,    0x1.78aa306c1b9dcp-1,  -0x1.1918b4p-3, INEXACT)
T(RN,  0x1.33abdef07c835p+555,    0x1.d37735eba2965p-1,  -0x1.b4bfc6p-3, INEXACT)
T(RN,  0x1.ed81edd9f6886p+556,    0x1.aabdfc43c21e7p-1,   0x1.68a3e4p-3, INEXACT)
T(RN,  0x1.99313a1d570c8p+556,    0x1.6537dc1678bf4p-1,  -0x1.ab83a6p-3, INEXACT)
T(RN,  0x1.2815e23ee18bcp+556,    0x1.390a731489bb9p-3,   0x1.fa2a18p-2, INEXACT)
T(RN,  0x1.282b0681718f6p+556,    0x1.f0679949d60f6p-1,   -0x1.f62a1p-4, INEXACT)
T(RN,  0x1.9462b97cdc8b6p+556,   -0x1.910fd1758446dp-1,  -0x1.3ad0d8p-2, INEXACT)
T(RN,   0x1.88dae536407bp+556,   -0x1.fa7c575e17245p-3,  -0x1.31453cp-2, INEXACT)
T(RN,  0x1.6525362ea2079p+556,   -0x1.5f4444135371cp-1,   0x1.79340ep-3, INEXACT)
T(RN,  0x1.915352a316273p+556,    0x1.a4ace82d4c4bep-1,   0x1.2fc404p-2, INEXACT)
T(RN,  0x1.97e07f671415ep+556,    0x1.f944714d35e1bp-1,  -0x1.4706a4p-3, INEXACT)
T(RN,  0x1.c932e43ea1229p+556,   -0x1.ff5db91015d07p-1,  -0x1.4c5c7ep-2, INEXACT)
T(RN,  0x1.6f9fd166d4637p+557,   -0x1.f09a2023f2783p-1,   0x1.e7ee9ap-2, INEXACT)
T(RN,  0x1.a6e5551a866d6p+557,    0x1.e05d769da127dp-1,  -0x1.8d63a8p-2, INEXACT)
T(RN,  0x1.fadc8ed20abd2p+557,    0x1.d47261697d688p-2,   -0x1.10f4ep-2, INEXACT)
T(RN,  0x1.78a6f848c1589p+557,    0x1.7c14ecc13e81dp-1,   0x1.2fc764p-4, INEXACT)
T(RN,  0x1.7571ccc725a62p+557,    0x1.dfc911d94341dp-2,   0x1.4fd4ccp-2, INEXACT)
T(RN,  0x1.d4753655e00dcp+557,   -0x1.a0b41f712e3c3p-1,  -0x1.73074ap-4, INEXACT)
T(RN,  0x1.bf256e1aa63adp+557,    0x1.2c23d2f18952bp-1,   0x1.cd3bbap-5, INEXACT)
T(RN,  0x1.58e589f8bb655p+557,  -0x1.2bc1e13eba772p-11,    0x1.1baa1p-5, INEXACT)
T(RN,  0x1.45cc426d3af6cp+557,    0x1.7f60abbc1208cp-1,   0x1.ca8e58p-4, INEXACT)
T(RN,  0x1.2e231fd5ad3f6p+557,   -0x1.fc0032088938cp-1,  -0x1.ef0c08p-2, INEXACT)
T(RN,  0x1.88db5d58fb42fp+558,     0x1.1d6eba61dd73p-3,   0x1.400754p-2, INEXACT)
T(RN,  0x1.83f466433d24cp+558,   -0x1.ba09882a183f2p-5,   0x1.74bc6ep-2, INEXACT)
T(RN,  0x1.9e6cfcf8c19d6p+558,   -0x1.bc787da10851bp-1,  -0x1.3d345cp-6, INEXACT)
T(RN,  0x1.cd9738d980e8bp+558,    0x1.c8d59087d4366p-1,   0x1.5ec4e8p-2, INEXACT)
T(RN,  0x1.d33041b962579p+558,    0x1.9fb1f9d4a7425p-2,  -0x1.44b012p-4, INEXACT)
T(RN,  0x1.656a2064a9f6ap+558,    0x1.fbb0b16c137dbp-1,   0x1.84d2b4p-3, INEXACT)
T(RN,  0x1.3e89f2ad8c107p+558,   -0x1.fed4692faef7cp-1,   0x1.74b2e4p-2, INEXACT)
T(RN,  0x1.86b53eb94335ep+558,   -0x1.6ed11afa9ef78p-1,  -0x1.593b62p-2, INEXACT)
T(RN,  0x1.692097e62a54cp+558,   -0x1.3cda3b7bcf081p-2,   -0x1.6b8a8p-3, INEXACT)
T(RN,  0x1.099da3dfd2a66p+558,      0x1.ae15790a346p-1,   0x1.16f6b6p-2, INEXACT)
T(RN,  0x1.681f2b613d978p+559,   -0x1.ecfaa43cb55fdp-1,   0x1.a27e1cp-3, INEXACT)
T(RN,  0x1.023cfd86dcd55p+559,   -0x1.fa9d861502e6ep-1,  -0x1.327cc4p-2, INEXACT)
T(RN,  0x1.f8900c7b77bcfp+559,   -0x1.766e7f9ed2a86p-1,  -0x1.993ddap-2, INEXACT)
T(RN,  0x1.8506660e028dap+559,   -0x1.fc5c7964ee9f2p-1,  -0x1.25fbf6p-3, INEXACT)
T(RN,  0x1.e62f5c4adc12cp+559,   -0x1.b06914439b3c7p-1,  -0x1.c5ed72p-2, INEXACT)
T(RN,  0x1.c645d5fd1ee8ap+559,    0x1.fdb3c4f07bbe8p-1,  -0x1.01524ap-2, INEXACT)
T(RN,    0x1.4df0ef9ea78p+559,   -0x1.9a6b29b910fb5p-2,  -0x1.85fee8p-2, INEXACT)
T(RN,  0x1.e575e36ddbf16p+559,    0x1.fff5c244a7f01p-1,   0x1.7e237cp-2, INEXACT)
T(RN,  0x1.33881ea4001c1p+559,     -0x1.c3592850a4ap-2,   0x1.6e38eap-3, INEXACT)
T(RN,  0x1.c1f700facd5fcp+559,    0x1.f0d3102682213p-1,    0x1.ec5ebp-2, INEXACT)
T(RN,  0x1.6e049cecfd1f9p+560,     0x1.ffa0887ddc65p-1,  -0x1.8bdba4p-2, INEXACT)
T(RN,  0x1.2db82115512d7p+560,    0x1.18fbbfdbb752ap-2,   0x1.d88f5ap-2, INEXACT)
T(RN,  0x1.17312850ff77ap+560,    0x1.20c90597c43efp-2,   0x1.d53068p-2, INEXACT)
T(RN,  0x1.df10412dca1c3p+560,   -0x1.9cb6c4cd203dcp-1,   -0x1.bd889p-2, INEXACT)
T(RN,  0x1.269cdecb0add2p+560,    0x1.5c4d4d34e769dp-1,   0x1.5009d4p-2, INEXACT)
T(RN,  0x1.74182856fc494p+560,    0x1.ddad7a0b658cfp-1,   0x1.e7bf76p-3, INEXACT)
T(RN,  0x1.2c5e51f70725ap+560,   -0x1.c97f281475273p-1,  -0x1.2e6268p-2, INEXACT)
T(RN,  0x1.641cfb7623992p+560,   -0x1.e3e22b73c779ap-1,  -0x1.176a68p-5, INEXACT)
T(RN,  0x1.cb109b758094ep+560,   -0x1.da6a1b42ed4f1p-1,   0x1.8aa638p-3, INEXACT)
T(RN,  0x1.f82131fe70bd8p+560,   -0x1.c63a996e8b74fp-1,   0x1.c3606cp-3, INEXACT)
T(RN,  0x1.1601b6f2e706fp+561,     0x1.12d994fe3991p-1,  -0x1.e779fcp-5, INEXACT)
T(RN,  0x1.09f3c87a5e5d9p+561,    0x1.114c8c4a010d3p-1,   0x1.709c34p-2, INEXACT)
T(RN,  0x1.809352d8ba936p+561,   -0x1.ff8bbcd24f991p-1,   0x1.a321d2p-5, INEXACT)
T(RN,  0x1.ba6e7663db294p+561,   -0x1.83dea8ff91aa6p-3,   0x1.23c6cep-2, INEXACT)
T(RN,  0x1.c30b9284b7c3fp+561,   -0x1.7a167ebf917e9p-1,  -0x1.bbe884p-3, INEXACT)
T(RN,  0x1.5e80d2ed56fb3p+561,    0x1.e28a68a133de8p-2,   0x1.54d108p-2, INEXACT)
T(RN,  0x1.6bc331e1da95ap+561,   -0x1.bced560f02cdbp-4,    0x1.a7c27p-2, INEXACT)
T(RN,  0x1.125f986ae1bb3p+561,    0x1.da9ab7576f508p-1,   0x1.566a42p-5, INEXACT)
T(RN,  0x1.76f59f4598412p+561,   -0x1.3f022ea3e4381p-1,   0x1.6a90ecp-2, INEXACT)
T(RN,  0x1.4e4885cefc7b2p+561,    0x1.fe84effb4e737p-1,  -0x1.c840e2p-3, INEXACT)
T(RN,  0x1.5cbd664f31948p+562,    0x1.d1be53ebb92bdp-3,  -0x1.e161e2p-7, INEXACT)
T(RN,  0x1.a19ca1c06dd04p+562,   -0x1.952eadd971ceep-2,   0x1.66df8ap-2, INEXACT)
T(RN,  0x1.03b87b96dc571p+562,   -0x1.e96e02b1cf9c1p-1,  -0x1.8da17ap-2, INEXACT)
T(RN,  0x1.4f6dc77b7b659p+562,   -0x1.c556e8a8aac08p-1,   0x1.d790a6p-2, INEXACT)
T(RN,  0x1.950234f9bf5fep+562,    0x1.82eed7ffa6106p-1,  -0x1.1c4774p-3, INEXACT)
T(RN,   0x1.710b8bd3df4ep+562,     0x1.e8e74e72ca13p-1,  -0x1.4fdb3ap-3, INEXACT)
T(RN,  0x1.f295ebb405e35p+562,   -0x1.73cbf1306f086p-1,  -0x1.756438p-3, INEXACT)
T(RN,  0x1.0b56a548fae85p+562,   -0x1.e2e8aa7145b23p-1,   -0x1.9e69dp-3, INEXACT)
T(RN,  0x1.861fa7df44dc4p+562,   -0x1.e26b628cb52a8p-1,  -0x1.ee7b7ap-2, INEXACT)
T(RN,  0x1.0a93235aaf732p+562,    0x1.586f3742f329bp-4,  -0x1.b2f35ep-8, INEXACT)
T(RN,  0x1.6066f251cbc19p+563,    0x1.90cdf0e3aa098p-1,  -0x1.5b3db4p-2, INEXACT)
T(RN,  0x1.1c55caec2329bp+563,   -0x1.6e0fe5aa1d42dp-1,   0x1.b44b5cp-3, INEXACT)
T(RN,   0x1.961316dd0fb7p+563,      0x1.f7e0b7d18c7p-1,   -0x1.1dc79p-2, INEXACT)
T(RN,  0x1.6f7ba46f1c6c5p+563,    0x1.73275f81b814ep-1,  -0x1.0b0ff2p-2, INEXACT)
T(RN,   0x1.5f7c0a67f9e8p+563,   -0x1.419fda7064bfdp-1,   0x1.e111fap-2, INEXACT)
T(RN,  0x1.db892c941a05ap+563,    0x1.4faef65ece0f4p-2,   0x1.ff228ap-3, INEXACT)
T(RN,  0x1.83164de38b74ap+563,    -0x1.71932c9ce106p-1,  -0x1.7d7982p-4, INEXACT)
T(RN,  0x1.a6dabe4b72f7cp+563,   -0x1.d67d8ce046219p-1,  -0x1.df2bc2p-3, INEXACT)
T(RN,  0x1.43932498dc94ep+563,   -0x1.fb7b8144294ddp-1,   -0x1.4c556p-3, INEXACT)
T(RN,  0x1.33e652e60358ep+563,    0x1.c08a0fc5ee1cdp-1,  -0x1.b6b232p-2, INEXACT)
T(RN,  0x1.ebbd593ccd676p+564,   -0x1.be6847e83de19p-1,  -0x1.58425ap-2, INEXACT)
T(RN,  0x1.8321d2ae2e2e4p+564,   -0x1.48e4c69091ac4p-1,  -0x1.8cc648p-3, INEXACT)
T(RN,  0x1.9b378198a6e96p+564,    0x1.ffe5d54841da6p-1,   0x1.c0783ep-5, INEXACT)
T(RN,   0x1.182a449d49d3p+564,    0x1.09e641aec9482p-3,   0x1.6b5f38p-7, INEXACT)
T(RN,  0x1.c48fbc2757b46p+564,   -0x1.d0c5e7dc78e9ep-3,   -0x1.9fbe1p-2, INEXACT)
T(RN,   0x1.eea1efe9674cp+564,   -0x1.8fae8fb91e538p-1,  -0x1.37cf52p-4, INEXACT)
T(RN,  0x1.78d76e2281c62p+564,   -0x1.e1e2e625212e3p-2,  -0x1.cd8eeap-2, INEXACT)
T(RN,  0x1.e381b6df3630ep+564,    0x1.09ae35ec89225p-3,   0x1.4fdffcp-4, INEXACT)
T(RN,  0x1.e8464e3f000fbp+564,    0x1.fffef1cdfc574p-1,  -0x1.8b07dcp-4, INEXACT)
T(RN,  0x1.fcaf056f499dcp+564,     -0x1.5e29cac56e1p-3,   0x1.7b9beap-2, INEXACT)
T(RN,  0x1.1e53bdb10315ep+565,   -0x1.445e8f92e6bbcp-1,  -0x1.3481cep-2, INEXACT)
T(RN,  0x1.631f6e99b5bf9p+565,   -0x1.ef5a191b7710bp-1,  -0x1.f1b072p-4, INEXACT)
T(RN,  0x1.c20bded873f89p+565,    0x1.e85791a37eeaep-1,  -0x1.21538ep-5, INEXACT)
T(RN,  0x1.c82ec4d003e58p+565,    0x1.ee3bd050d20f3p-1,  -0x1.01081ep-2, INEXACT)
T(RN,  0x1.b703e431fc2c3p+565,   -0x1.7505b6bc50181p-5,   0x1.fd0e86p-3, INEXACT)
T(RN,  0x1.6f9444388fe18p+565,    0x1.fdd2b73da2049p-1,   0x1.a6ca74p-4, INEXACT)
T(RN,  0x1.b061ccbae7c6cp+565,   -0x1.fd922f29c648fp-1,  -0x1.0bd3a6p-4, INEXACT)
T(RN,  0x1.e0c1ec41598e9p+565,    0x1.6a0bd6e0d92b8p-1,  -0x1.c3b8d4p-5, INEXACT)
T(RN,  0x1.62d1d87311816p+565,    0x1.a95c046588af5p-1,    0x1.cbf0fp-5, INEXACT)
T(RN,  0x1.db6e87f553038p+565,   -0x1.fdf692740b38cp-1,    -0x1.9373p-3, INEXACT)
T(RN,  0x1.ad99ff9700276p+566,    0x1.0e9426312eaaap-1,  -0x1.9feb48p-2, INEXACT)
T(RN,  0x1.4d5953075fc66p+566,   -0x1.4ec8330f0b882p-1,  -0x1.642fd6p-2, INEXACT)
T(RN,  0x1.0221a0c629c78p+566,    0x1.45f7f179c6cfdp-3,   0x1.7b7a34p-2, INEXACT)
T(RN,  0x1.f3db031efcb1cp+566,   -0x1.fe48f7b700fdap-1,   0x1.f6544ep-2, INEXACT)
T(RN,  0x1.6dff146f21738p+566,   -0x1.239acc4a57492p-1,  -0x1.ef948cp-2, INEXACT)
T(RN,  0x1.c25dad01b6d6fp+566,    0x1.4f34b9ea7b8dfp-1,   -0x1.00cdbp-2, INEXACT)
T(RN,   0x1.c3d08a489cc4p+566,    0x1.e1878e9adb909p-2,   0x1.6722e6p-2, INEXACT)
T(RN,  0x1.e418a2ce3deacp+566,   -0x1.adb3ac7ec598dp-5,   0x1.25eeb2p-3, INEXACT)
T(RN,  0x1.9e57d57e55be5p+566,    -0x1.5af8f57a81c6p-1,   -0x1.100f8p-2, INEXACT)
T(RN,  0x1.608c3d9af4242p+566,    0x1.feb6e50fdcbd2p-1,   -0x1.adcedp-5, INEXACT)
T(RN,  0x1.ad2c8a4a4da44p+567,   -0x1.7bb43f19bcc62p-3,  -0x1.151c02p-2, INEXACT)
T(RN,  0x1.39eeebe6f3ceep+567,    0x1.1e2329ad5595cp-1,  -0x1.334bdcp-4, INEXACT)
T(RN,  0x1.1b9c45a7ae574p+567,   -0x1.cc1a94c8bf64ap-1,   0x1.7ab736p-2, INEXACT)
T(RN,  0x1.00270365d9939p+567,   -0x1.90b7d5dd48489p-2,   0x1.70a076p-5, INEXACT)
T(RN,  0x1.01c05dac7e7c1p+567,   -0x1.740c5359c32aep-2,   -0x1.57738p-2, INEXACT)
T(RN,  0x1.01513a82a7af7p+567,   -0x1.f8fe5691a9ad6p-1,   0x1.ede31ep-2, INEXACT)
T(RN,  0x1.7f9e074f9666ap+567,    0x1.89e5f51433f13p-3,  -0x1.ae6756p-2, INEXACT)
T(RN,  0x1.cf78f2035e214p+567,    0x1.fac19aded8641p-1,   0x1.386618p-2, INEXACT)
T(RN,  0x1.62e40f768027bp+567,   -0x1.5adabe68d2965p-2,  -0x1.c2d646p-2, INEXACT)
T(RN,  0x1.87806f4947d44p+567,   -0x1.749d9196a312bp-4,  -0x1.724482p-4, INEXACT)
T(RN,  0x1.8749be2983978p+568,   -0x1.9ffc216b0ca3cp-1,  -0x1.ac34bep-5, INEXACT)
T(RN,  0x1.8005ed3aba9d8p+568,    0x1.6ebefc13c09adp-2,   0x1.1f3ad8p-2, INEXACT)
T(RN,  0x1.75cfd0c546f16p+568,   -0x1.fe4909d91f60cp-1,  -0x1.fe49d4p-3, INEXACT)
T(RN,  0x1.f1dad5f122ee4p+568,   -0x1.c06b44c797f01p-1,  -0x1.fd23dcp-2, INEXACT)
T(RN,  0x1.0ea9fac7d285bp+568,   -0x1.c3493fe115bb5p-1,   0x1.af81cap-2, INEXACT)
T(RN,  0x1.e3c188ea74f59p+568,    -0x1.b79deb998ab3p-1,  -0x1.c0cfbap-5, INEXACT)
T(RN,  0x1.46fc12b32989ep+568,   -0x1.23866110b6aeep-1,  -0x1.e3362ap-2, INEXACT)
T(RN,  0x1.1ba199bdd6905p+568,     0x1.81a4323af3f5p-2,  -0x1.8afd4cp-4, INEXACT)
T(RN,  0x1.5e05b8a9e13bap+568,   -0x1.c67c96042767ap-1,  -0x1.4ca3d8p-5, INEXACT)
T(RN,  0x1.d8629bd07946ep+568,   -0x1.2e16be736791ep-2,  -0x1.0cf13cp-2, INEXACT)
T(RN,  0x1.a117d07e13016p+569,    0x1.db3aabfded994p-1,  -0x1.4d6006p-3, INEXACT)
T(RN,  0x1.f2691d493bcc6p+569,    0x1.cbc6079397b86p-1,   0x1.feca36p-2, INEXACT)
T(RN,  0x1.8d2c211f982bfp+569,    0x1.1348a7bfd99abp-4,  -0x1.56f688p-2, INEXACT)
T(RN,  0x1.e2c352257b50dp+569,     0x1.e8d0af5ea419p-1,   0x1.637cecp-2, INEXACT)
T(RN,  0x1.126473e454863p+569,    0x1.efbd07ba327cbp-1,   0x1.1ca67ep-2, INEXACT)
T(RN,  0x1.b5e5dc3e57681p+569,    0x1.ead1bee8c023cp-1,   0x1.c5f1fap-2, INEXACT)
T(RN,  0x1.11c481baa6824p+569,    0x1.b8ed0be0f0ce7p-1,   0x1.1525bep-3, INEXACT)
T(RN,  0x1.af45eb511c067p+569,   -0x1.7696de3785627p-1,  -0x1.0f4ac4p-3, INEXACT)
T(RN,  0x1.102d88634ac78p+569,   -0x1.f8ebc87e66f61p-1,   -0x1.3df66p-4, INEXACT)
T(RN,  0x1.4bea46c19d4fdp+569,   -0x1.49b71c72005c9p-2,   0x1.088454p-2, INEXACT)
T(RN,  0x1.dc6829ffbf556p+570,     0x1.f19695a4f8afp-1,  -0x1.71217p-10, INEXACT)
T(RN,  0x1.b56600384e128p+570,    0x1.2d487e5305d4bp-4,   0x1.4ddf74p-3, INEXACT)
T(RN,  0x1.460be3a89dedep+570,     0x1.fe97950f6c67p-1,   0x1.c92ffcp-2, INEXACT)
T(RN,  0x1.80490b48f2762p+570,   -0x1.d7d18ec823becp-2,   0x1.77bd8cp-7, INEXACT)
T(RN,  0x1.acf8ec6800126p+570,    0x1.e7012d1d4454ap-1,  -0x1.c3d1b2p-2, INEXACT)
T(RN,  0x1.fc8f4331f6accp+570,   -0x1.ea59a72d15b16p-2,   0x1.0eda44p-8, INEXACT)
T(RN,  0x1.f8e5663ce9994p+570,   -0x1.309d77255af23p-1,   0x1.f2c1dcp-5, INEXACT)
T(RN,  0x1.69751a550e6f4p+570,     0x1.f6756a64b9dap-1,   0x1.8a5472p-2, INEXACT)
T(RN,  0x1.b6c8b0b4dc5e7p+570,   -0x1.7ec9653daf419p-1,   0x1.777204p-3, INEXACT)
T(RN,   0x1.403a7989ed53p+570,   -0x1.8feb7d43be51ep-3,  -0x1.1b26fep-2, INEXACT)
T(RN,  0x1.77f995a8027dap+571,   -0x1.22cba243a08a9p-2,    0x1.d7f71p-2, INEXACT)
T(RN,  0x1.fc5258821b6a8p+571,    0x1.573eb1152c249p-1,  -0x1.022be8p-2, INEXACT)
T(RN,  0x1.58e937dd692f5p+571,   -0x1.043b5b11d5f4cp-1,   0x1.ab2acep-4, INEXACT)
T(RN,  0x1.3764fd54347a2p+571,    0x1.9b8e63fd92212p-1,   0x1.9b0dbap-4, INEXACT)
T(RN,  0x1.66bb275594d01p+571,    0x1.67554cd5cc224p-1,   -0x1.b70e8p-2, INEXACT)
T(RN,  0x1.b0ee54f89df78p+571,    0x1.d46905fa4c832p-2,  -0x1.8325fcp-2, INEXACT)
T(RN,   0x1.ec9ab554c1a1p+571,   -0x1.59031d0d8fb92p-4,  -0x1.ea9182p-2, INEXACT)
T(RN,  0x1.4a6b0773c94fdp+571,    0x1.ffe5b16565e2fp-1,  -0x1.0c245cp-2, INEXACT)
T(RN,  0x1.8f06acb612d48p+571,   -0x1.bda61b6f9b242p-2,   -0x1.8b00ap-2, INEXACT)
T(RN,   0x1.9b1f83841b5cp+571,    0x1.7fc2747b391c9p-1,   0x1.2dba26p-3, INEXACT)
T(RN,  0x1.f0b1b396309e2p+572,   -0x1.3ec311ef04bb2p-1,   0x1.4c0848p-5, INEXACT)
T(RN,  0x1.d7bad9d087058p+572,    0x1.8ce4cb637cbadp-2,   0x1.3946e6p-4, INEXACT)
T(RN,  0x1.99836e44207c2p+572,    0x1.b8332a35f2132p-2,   0x1.c54612p-4, INEXACT)
T(RN,  0x1.3ddf8f4524b79p+572,   -0x1.8191a38fcc0a5p-1,   -0x1.c7cf6p-6, INEXACT)
T(RN,  0x1.d262d106a42f6p+572,   -0x1.820bba44e44acp-1,  -0x1.5b71b6p-2, INEXACT)
T(RN,  0x1.b37517c4fa2d4p+572,   -0x1.fe4aa79e079c4p-1,   0x1.2e72e4p-5, INEXACT)
T(RN,  0x1.d141ab77fd29cp+572,   -0x1.393434782d00ap-1,  -0x1.100886p-4, INEXACT)
T(RN,  0x1.890d6efcaaf94p+572,    0x1.ffff9ac81ccf9p-1,   0x1.12b442p-3, INEXACT)
T(RN,  0x1.5baa71712c8f5p+572,   -0x1.af6511a1885d3p-1,   0x1.b82978p-2, INEXACT)
T(RN,  0x1.1b007fb9233ddp+572,   -0x1.fdca988183ba8p-1,  -0x1.b42f98p-2, INEXACT)
T(RN,   0x1.0b862b833e7ep+573,    0x1.1a2a49b4e4222p-1,   0x1.7f958cp-4, INEXACT)
T(RN,  0x1.b6bbc23a17b03p+573,    0x1.fffd14bc34d5bp-1,  -0x1.dcc4a4p-3, INEXACT)
T(RN,  0x1.ef10d11e22d9dp+573,   -0x1.d47bc426c0df7p-2,  -0x1.8c5f64p-2, INEXACT)
T(RN,  0x1.e99523ec8a57cp+573,    0x1.b8d1b29d08723p-1,   0x1.0b8908p-3, INEXACT)
T(RN,  0x1.df23294174326p+573,   -0x1.8bab4e2e8bc1bp-1,   0x1.cf8764p-2, INEXACT)
T(RN,  0x1.001766cd2e887p+573,    0x1.f58544c0dc901p-1,  -0x1.0a6daep-2, INEXACT)
T(RN,  0x1.00a18841dd406p+573,   -0x1.550339fc41681p-2,   0x1.76cd24p-2, INEXACT)
T(RN,   0x1.6ec4feb26303p+573,   -0x1.c9ad263838d79p-2,  -0x1.157a9cp-2, INEXACT)
T(RN,  0x1.86313f11b65ffp+573,   -0x1.37f476bae46d7p-5,   -0x1.60031p-2, INEXACT)
T(RN,  0x1.8d9d7e7a6b44cp+573,   -0x1.ffbb1105fbf71p-1,    0x1.78e37p-3, INEXACT)
T(RN,  0x1.f6b0eb5c78cacp+574,   -0x1.4fdc7d94ec354p-2,  -0x1.895ab4p-3, INEXACT)
T(RN,  0x1.9fa9c47112f7ep+574,    0x1.f2b70649d481fp-3,   0x1.d25518p-2, INEXACT)
T(RN,  0x1.0e7baa19fa761p+574,    0x1.e9e7533a7cebcp-1,   0x1.4deca2p-2, INEXACT)
T(RN,  0x1.02933f10239d1p+574,    0x1.54ded7e6f0db6p-1,  -0x1.de91cap-3, INEXACT)
T(RN,  0x1.187aebc77dbc8p+574,    0x1.bbd6fad77892cp-2,  -0x1.697d6cp-2, INEXACT)
T(RN,   0x1.748a4e7100d6p+574,    0x1.f5b4741d9b71fp-2,  -0x1.c6538ep-4, INEXACT)
T(RN,  0x1.73c76b75bc404p+574,    0x1.494da1382e11fp-3,  -0x1.8253bep-4, INEXACT)
T(RN,  0x1.76d21b3077932p+574,   -0x1.be39deb695a92p-1,   0x1.104b32p-3, INEXACT)
T(RN,  0x1.322eef56b336ep+574,   -0x1.ffffff9cf42ddp-1,  -0x1.0dd0e4p-2, INEXACT)
T(RN,  0x1.37ea60542a808p+574,    -0x1.3fc52d65f746p-1,  -0x1.00aaa4p-3, INEXACT)
T(RN,  0x1.9d5f82233aa58p+575,   -0x1.d9b515df5ce5cp-1,   0x1.224c5ep-2, INEXACT)
T(RN,  0x1.ae9514f72216ap+575,    -0x1.fed4860c48a8p-1,    0x1.4a5fcp-2, INEXACT)
T(RN,  0x1.b46053af1ca03p+575,   -0x1.ec51bf0fc016cp-1,   0x1.fd7f1ap-2, INEXACT)
T(RN,  0x1.27992a7b8fb9bp+575,   -0x1.fb9a7681b636cp-1,  -0x1.1313b6p-2, INEXACT)
T(RN,   0x1.2abf3b26cf15p+575,   -0x1.3e2655e85ab84p-2,  -0x1.5ff26ap-3, INEXACT)
T(RN,  0x1.ebd8bd512e2bep+575,     0x1.fd85b97fa483p-1,  -0x1.ef3914p-3, INEXACT)
T(RN,  0x1.89b7e2bc5acc8p+575,    0x1.f8f0fc2d88fbcp-2,   0x1.7d3d68p-3, INEXACT)
T(RN,  0x1.142db17b27978p+575,    0x1.70cce8b93ae4bp-2,  -0x1.1d83e8p-2, INEXACT)
T(RN,  0x1.fdf21d4ab1a84p+575,   -0x1.a43230e42a32ap-2,   0x1.322af2p-2, INEXACT)
T(RN,  0x1.fdbfc857f5e06p+575,    0x1.c3b7f187fc17fp-1,    0x1.a9157p-2, INEXACT)
T(RN,  0x1.14d1fd21fc3ddp+576,   -0x1.3ece018591ec4p-4,    0x1.ac7bep-6, INEXACT)
T(RN,  0x1.2237aaddf729dp+576,    0x1.4c5f4bbafc0b4p-1,   0x1.789de2p-3, INEXACT)
T(RN,  0x1.d736ef9c094a9p+576,   -0x1.765c9b10e6839p-1,  -0x1.a7861ep-2, INEXACT)
T(RN,  0x1.c38089bd19946p+576,    0x1.35a6a51d19c4ep-1,    0x1.b2289p-2, INEXACT)
T(RN,  0x1.5ee4478260633p+576,   -0x1.fbbb97ff1b195p-1,   0x1.3b9cf6p-3, INEXACT)
T(RN,  0x1.ee56cf7722f87p+576,   -0x1.42611065f5406p-1,    0x1.09e73p-2, INEXACT)
T(RN,  0x1.33c2e6ddd48f8p+576,   -0x1.eff9ce10d8c8cp-2,  -0x1.163ff2p-2, INEXACT)
T(RN,  0x1.d5cebca15bf31p+576,    0x1.b339b7a423d0ap-1,    0x1.136d7p-4, INEXACT)
T(RN,  0x1.5f8c931a495b6p+576,   -0x1.e80bca6c73ae9p-1,   0x1.e0711ep-2, INEXACT)
T(RN,  0x1.193fc410c4455p+576,   -0x1.e69a4a5cb9574p-1,   0x1.0aa75cp-3, INEXACT)
T(RN,  0x1.f20f73183da12p+577,    0x1.e5ce10ad72513p-1,  -0x1.388c44p-2, INEXACT)
T(RN,  0x1.8d7566daafee6p+577,    0x1.6429559c3f91ap-2,  -0x1.25c392p-2, INEXACT)
T(RN,  0x1.ae19a99b3b1b6p+577,    0x1.f98de2337186bp-1,  -0x1.217ebcp-2, INEXACT)
T(RN,  0x1.0c3edc85032b2p+577,   -0x1.fef64daf6536bp-1,   -0x1.6a047p-2, INEXACT)
T(RN,  0x1.1643aa103c37fp+577,   -0x1.e0331e58ca527p-1,   0x1.3a9a64p-3, INEXACT)
T(RN,  0x1.f4677cd356248p+577,   -0x1.490d1352ba269p-2,  -0x1.596674p-3, INEXACT)
T(RN,  0x1.761d815ac2529p+577,   -0x1.d8af62a00247cp-1,   -0x1.ceab3p-3, INEXACT)
T(RN,  0x1.df3f8fc27ea6ep+577,    0x1.2d9dfeb0ebeb2p-1,   0x1.74045ap-4, INEXACT)
T(RN,  0x1.48f3a2d3bfc9dp+577,   -0x1.fa1e2be1fcccbp-1,   0x1.2f74c8p-2, INEXACT)
T(RN,  0x1.45616c67157e2p+577,    0x1.f4098fc189506p-1,  -0x1.5cd1c8p-2, INEXACT)
T(RN,  0x1.c6df898aee92ep+578,   -0x1.d4d2b414c990ep-1,  -0x1.75670cp-4, INEXACT)
T(RN,   0x1.ba8200366cb7p+578,    0x1.f9a581ffc3bd3p-1,  -0x1.b88fb8p-3, INEXACT)
T(RN,  0x1.c60116d5336e8p+578,   -0x1.a5b903f01ec4bp-2,   0x1.eb6612p-3, INEXACT)
T(RN,  0x1.abc4fb0271d5dp+578,   -0x1.c16bfc5fae3edp-7,   0x1.074208p-2, INEXACT)
T(RN,  0x1.ffeaeb85535f2p+578,   -0x1.dd440a04ce788p-1,   0x1.cf93f8p-3, INEXACT)
T(RN,  0x1.791ef5812e85cp+578,   -0x1.cedf7e4083c1cp-1,   0x1.7e8fa2p-3, INEXACT)
T(RN,  0x1.3c5f68df7413ep+578,    0x1.44409e2843f7cp-3,   0x1.37e218p-2, INEXACT)
T(RN,  0x1.49bd84267969ap+578,    0x1.5476d6b251dfep-1,   0x1.ebeeeap-2, INEXACT)
T(RN,  0x1.0d9151a3dd881p+578,   -0x1.5cbc3e1ed3101p-1,   0x1.ac6304p-2, INEXACT)
T(RN,  0x1.e6909622ef52ap+578,   -0x1.021f8dab0170dp-1,     0x1.e99bp-2, INEXACT)
T(RN,  0x1.b67b27cda357fp+579,     0x1.c74168882e88p-1,   -0x1.8acbfp-3, INEXACT)
T(RN,  0x1.5d02e13ee0229p+579,   -0x1.5f85885e5555ap-2,   0x1.0ee7dcp-2, INEXACT)
T(RN,  0x1.73f0ce34f0d08p+579,   -0x1.43af3ae1342afp-5,   0x1.dda798p-3, INEXACT)
T(RN,  0x1.145f96dac871dp+579,    0x1.9693274df58bbp-1,  -0x1.70ca76p-2, INEXACT)
T(RN,  0x1.ca4e004d155c3p+579,    0x1.498657ab2332bp-2,     0x1.c312p-3, INEXACT)
T(RN,  0x1.0da2800ee7cbfp+579,     0x1.64d7a44880f3p-1,    0x1.0f043p-2, INEXACT)
T(RN,  0x1.4ec730906a37cp+579,    0x1.4ae2ed4d5103dp-1,   0x1.03c51cp-4, INEXACT)
T(RN,  0x1.da213a849397ep+579,   -0x1.50b135f2aa545p-1,   0x1.cd2214p-2, INEXACT)
T(RN,  0x1.2fc8658874413p+579,    0x1.88298fb8385f6p-1,   0x1.f18c7ep-5, INEXACT)
T(RN,  0x1.971af22dbda05p+579,    0x1.3ec4a6831a923p-1,   0x1.84ae98p-2, INEXACT)
T(RN,  0x1.1d46c2f1dd97fp+580,    0x1.7092b36db5bacp-1,  -0x1.c8f268p-5, INEXACT)
T(RN,  0x1.64f68810e3577p+580,   -0x1.67c03efa21fffp-1,  -0x1.c93462p-3, INEXACT)
T(RN,  0x1.982370a14363ap+580,   -0x1.d4756bdcb14e3p-1,   0x1.124f3ap-2, INEXACT)
T(RN,  0x1.f4dceb647b991p+580,    -0x1.9b3235fce1a5p-1,    0x1.38019p-3, INEXACT)
T(RN,   0x1.951c5a841997p+580,    0x1.00bf503304c17p-3,  -0x1.7204d6p-2, INEXACT)
T(RN,  0x1.25f0c42de8263p+580,   -0x1.6e2ec06d6ae01p-2,  -0x1.3cdff6p-2, INEXACT)
T(RN,  0x1.4f22d3ab41ce8p+580,    0x1.eead3eac19326p-2,   0x1.89ca52p-2, INEXACT)
T(RN,  0x1.5b5ff023ece9cp+580,    0x1.73da469e4bfc8p-1,   0x1.b6f2e2p-2, INEXACT)
T(RN,  0x1.feb0f5315f04ep+580,   -0x1.50c55a47ed0acp-1,  -0x1.a5d50ep-2, INEXACT)
T(RN,  0x1.f136692fc20fep+580,    0x1.da5dfe9e5503fp-1,   0x1.6ca5a6p-2, INEXACT)
T(RN,  0x1.e1e71748d6c9fp+581,    -0x1.89838d4db0e7p-1,   0x1.36992cp-3, INEXACT)
T(RN,  0x1.9547fc0c16de4p+581,   -0x1.d7f3748901d47p-1,   0x1.c5c9d2p-6, INEXACT)
T(RN,  0x1.56e62fc99ffd4p+581,   -0x1.a8d0f569c6d6ep-1,    0x1.2c348p-7, INEXACT)
T(RN,  0x1.1c937b495259ep+581,   -0x1.37c2891966bf4p-2,  -0x1.c72ee6p-4, INEXACT)
T(RN,  0x1.68cc763707a8bp+581,    0x1.6f8b94dc71c0ep-3,  -0x1.825174p-5, INEXACT)
T(RN,  0x1.753729a5b096ep+581,    0x1.c47cbd991c3eep-1,   0x1.80fe4ep-2, INEXACT)
T(RN,  0x1.ca20ddcdfb8c6p+581,    0x1.7fbd55fd680f6p-1,  -0x1.05b674p-2, INEXACT)
T(RN,  0x1.79e7fa6793ac9p+581,    0x1.95b5a09f2d396p-3,  -0x1.3ed7c2p-4, INEXACT)
T(RN,  0x1.cbfcc7651b666p+581,    0x1.b67154ff3ac59p-2,   0x1.1e2f46p-2, INEXACT)
T(RN,  0x1.8c06a8238670dp+581,   -0x1.1f983a06f94a8p-1,   0x1.aa2804p-2, INEXACT)
T(RN,  0x1.9c4f3a4b28452p+582,   -0x1.6acee0da0baecp-1,  -0x1.636288p-7, INEXACT)
T(RN,  0x1.d7a6546cfec1ep+582,    0x1.e71cfa3277f9dp-1,   0x1.df7e44p-4, INEXACT)
T(RN,  0x1.5609ffbe81f66p+582,    0x1.7fdb0ff779431p-2,   0x1.2b584ep-5, INEXACT)
T(RN,  0x1.a23d454653eecp+582,   -0x1.e6579844419a3p-2,  -0x1.18c4cep-2, INEXACT)
T(RN,  0x1.37d489eb6b3eap+582,    0x1.64c2dbe535ad3p-1,  -0x1.76c054p-2, INEXACT)
T(RN,  0x1.0377e6402ee2ep+582,   -0x1.29d8317849568p-1,  -0x1.22c3a2p-2, INEXACT)
T(RN,  0x1.bea275b78cb11p+582,    -0x1.74cf496e30aap-2,   0x1.58035ap-2, INEXACT)
T(RN,  0x1.c0e68f7a8ed69p+582,    0x1.9dc11b7802ac7p-5,   0x1.6be81cp-2, INEXACT)
T(RN,  0x1.8c66fc77ab548p+582,   -0x1.d6d1377c39c75p-1,    0x1.2eef6p-2, INEXACT)
T(RN,   0x1.51a85385c8f1p+582,    0x1.f6a1461d0eeeap-1,   0x1.5c36dcp-4, INEXACT)
T(RN,  0x1.ed2998d200dccp+583,    0x1.6e0346b68e604p-1,   0x1.4ff23ep-3, INEXACT)
T(RN,  0x1.f0f878c562394p+583,   -0x1.852dc5c7672d6p-1,   0x1.85ef1ap-2, INEXACT)
T(RN,  0x1.fec095f9db0aap+583,    0x1.895fdaeb3e24dp-1,   0x1.c32df4p-2, INEXACT)
T(RN,  0x1.f3681ddb5b0d5p+583,    0x1.0599c3564c425p-3,  -0x1.10d158p-3, INEXACT)
T(RN,  0x1.f5847b4ea0597p+583,   -0x1.b6872de383dfbp-1,  -0x1.9f9492p-4, INEXACT)
T(RN,  0x1.8fd887573ef58p+583,   -0x1.cd2fd703291a5p-2,   0x1.e450b4p-2, INEXACT)
T(RN,  0x1.6ee66b3302ae8p+583,   -0x1.8cb2efb66d203p-2,   -0x1.f055fp-5, INEXACT)
T(RN,  0x1.18f0bee839d02p+583,   -0x1.fffa4df68b83dp-1,  -0x1.cb9504p-2, INEXACT)
T(RN,  0x1.ad533683fa3c2p+583,    0x1.bfa0af731115ep-1,   0x1.11ddc8p-2, INEXACT)
T(RN,  0x1.2554345638aaep+583,   -0x1.b65959cff3712p-1,   0x1.6d14eap-3, INEXACT)
T(RN,   0x1.26ba12751535p+584,   -0x1.eee9c1bef5138p-1,   0x1.eb95eep-5, INEXACT)
T(RN,  0x1.f191a3153739fp+584,   -0x1.889a1872a141ep-1,  -0x1.8339a6p-3, INEXACT)
T(RN,   0x1.482a9d176406p+584,    0x1.ef3acc87acc1fp-1,  -0x1.69d728p-3, INEXACT)
T(RN,  0x1.b581f4165ffcep+584,   -0x1.db3e98cc2b463p-3,   0x1.d24f7cp-2, INEXACT)
T(RN,  0x1.7181f643f80cbp+584,    0x1.eb50035e322c7p-1,  -0x1.6cdb64p-3, INEXACT)
T(RN,  0x1.5237e9ad31a0fp+584,   -0x1.f2b4fbe5418ccp-2,   0x1.9d771ep-4, INEXACT)
T(RN,  0x1.c19406446b461p+584,    0x1.ffe67de340d2cp-1,   0x1.d29a1ep-4, INEXACT)
T(RN,  0x1.0ab20811ba49cp+584,   -0x1.04fb59faf7a61p-1,   0x1.41d2c8p-2, INEXACT)
T(RN,  0x1.4cfa7444d7692p+584,    0x1.dfbaae8c73fbap-2,   0x1.fe1f4ap-3, INEXACT)
T(RN,   0x1.ac963246c8a8p+584,    0x1.4a260bd917bd8p-1,   0x1.015b24p-5, INEXACT)
T(RN,  0x1.a9ccaf7c14359p+585,   -0x1.a0123bdae672ep-1,  -0x1.44e08cp-5, INEXACT)
T(RN,  0x1.a61c01d79156ap+585,    0x1.3b7d36d59da2ep-5,  -0x1.0840bep-2, INEXACT)
T(RN,  0x1.5726915e92b68p+585,   -0x1.c918c7f27ca88p-2,  -0x1.d01feep-2, INEXACT)
T(RN,  0x1.a00d9ea9a6e3cp+585,    -0x1.46c221abb29dp-1,  -0x1.be4c82p-3, INEXACT)
T(RN,  0x1.ab201b8a194dep+585,    0x1.ce63003146ed8p-1,  -0x1.975f68p-2, INEXACT)
T(RN,  0x1.b5c7f86207e38p+585,    0x1.0278938b18d78p-1,  -0x1.6f9d2ep-6, INEXACT)
T(RN,  0x1.67101807a2951p+585,   -0x1.9ba02874005d9p-3,  -0x1.251388p-3, INEXACT)
T(RN,   0x1.7a6b97cb7019p+585,    0x1.dbd5d2880a5d7p-2,  -0x1.19bbf4p-5, INEXACT)
T(RN,  0x1.8e4c96ddf5b86p+585,   -0x1.46d83fd53211ap-1,   0x1.aa9636p-6, INEXACT)
T(RN,  0x1.e01467661b1d7p+585,   -0x1.cea54cba34c05p-1,    0x1.de491p-2, INEXACT)
T(RN,   0x1.e0eb359fab24p+586,    0x1.df4fcdfb010a3p-1,  -0x1.bd292ep-2, INEXACT)
T(RN,  0x1.f9d1f1ae53cbfp+586,   -0x1.431022ebb6e1ep-1,   0x1.2bb084p-8, INEXACT)
T(RN,  0x1.15d8d3d0194a9p+586,   -0x1.8415e277cfa54p-1,   0x1.ea53ecp-2, INEXACT)
T(RN,  0x1.8d2041f2ec84ep+586,    0x1.744e73bd7a894p-1,  -0x1.b0033cp-3, INEXACT)
T(RN,  0x1.d738b4a0298f5p+586,    0x1.e576e00db64c2p-1,   0x1.1c2bf8p-2, INEXACT)
T(RN,  0x1.37b95638eb1aep+586,    0x1.a03282159f71ap-4,  -0x1.d0230cp-2, INEXACT)
T(RN,  0x1.094a40145b5e9p+586,   -0x1.511021fb40afbp-1,  -0x1.e14c82p-2, INEXACT)
T(RN,  0x1.047699c9af4a1p+586,    0x1.a33efc8755434p-3,   0x1.9f9468p-2, INEXACT)
T(RN,  0x1.1344998afaee9p+586,    0x1.d5894dae4329dp-1,   0x1.898268p-3, INEXACT)
T(RN,  0x1.343902f15d5e4p+586,    0x1.533ae856d036ap-2,  -0x1.a49ecap-2, INEXACT)
T(RN,  0x1.21581bacb6fc7p+587,   -0x1.ccd8e88cf5e0dp-2,   0x1.abbf98p-5, INEXACT)
T(RN,  0x1.7f84f90cfba56p+587,   -0x1.f2d87efc23a28p-1,   -0x1.b7f8fp-4, INEXACT)
T(RN,  0x1.623e5bad7817ap+587,   -0x1.652cfc0d5dbc9p-1,  -0x1.b4a382p-3, INEXACT)
T(RN,   0x1.06ea7ef1ec36p+587,    0x1.254512dca6a35p-2,   0x1.49d41ep-2, INEXACT)
T(RN,  0x1.211e28ad87cd9p+587,    0x1.d3b276bb55211p-1,  -0x1.7feb8ep-2, INEXACT)
T(RN,  0x1.a25c3a9ea400ep+587,    0x1.bccba227fedf1p-1,  -0x1.d98caep-3, INEXACT)
T(RN,  0x1.28abd7a6b9fa8p+587,   -0x1.5c23a8603fa8dp-1,  -0x1.f2c7e2p-5, INEXACT)
T(RN,  0x1.9ef82df586d14p+587,   -0x1.ac134dfaccb1cp-1,   0x1.f994f2p-3, INEXACT)
T(RN,  0x1.8168995f79afep+587,   -0x1.78d6cc336d7eap-1,   0x1.69a71cp-2, INEXACT)
T(RN,  0x1.6ee145c0cea65p+587,    0x1.9007a95ed936dp-1,   0x1.2b3eeep-2, INEXACT)
T(RN,  0x1.c6fcdcff93dfbp+588,    0x1.feda458392a6ap-1,  -0x1.0fd768p-2, INEXACT)
T(RN,  0x1.402de4114102cp+588,   -0x1.f18dd703a49dfp-1,   0x1.5d69f2p-3, INEXACT)
T(RN,  0x1.3daec0634c2f6p+588,   -0x1.e3173721f32dfp-1,   0x1.8cac8ap-2, INEXACT)
T(RN,  0x1.4d7dc48816095p+588,    0x1.9a3504e1a9d9dp-1,   0x1.9ec4aap-3, INEXACT)
T(RN,  0x1.5b1e6967d6879p+588,   -0x1.81b82701ed05bp-1,  -0x1.e6a156p-3, INEXACT)
T(RN,  0x1.3008a53ae3881p+588,   -0x1.e2c7b3bab30d8p-1,    0x1.7742bp-3, INEXACT)
T(RN,  0x1.11efb2039ba1dp+588,    0x1.b6684c38960a2p-3,  -0x1.53b9e6p-3, INEXACT)
T(RN,   0x1.c33075bc70ebp+588,   -0x1.e3c1d0b22c3dbp-1,  -0x1.f184f2p-2, INEXACT)
T(RN,  0x1.d4a741add678fp+588,   -0x1.ee08347bdb8a3p-1,   0x1.6391eap-2, INEXACT)
T(RN,  0x1.953e23d6a6d14p+588,    0x1.fd68a9ad3e7a6p-1,   -0x1.37083p-2, INEXACT)
T(RN,   0x1.d072e3ae4c2dp+589,   -0x1.e4acf89da12ddp-1,   0x1.2098f8p-8, INEXACT)
T(RN,  0x1.7f1bc2bc996bbp+589,    0x1.c26351fc54b4dp-1,  -0x1.2a421ap-6, INEXACT)
T(RN,  0x1.65a2562161c44p+589,     0x1.6dadec437ab2p-1,   0x1.c70592p-2, INEXACT)
T(RN,  0x1.a9771fd6ff912p+589,   -0x1.35c19eace86a2p-2,  -0x1.e42f8ap-3, INEXACT)
T(RN,  0x1.b3db59bc8ac7ap+589,    0x1.499df320fada6p-2,  -0x1.f1247ep-3, INEXACT)
T(RN,  0x1.0be5bdd9e60bcp+589,    0x1.18ec885eda36dp-4,   0x1.31e576p-4, INEXACT)
T(RN,  0x1.3a54f24521c1ep+589,    0x1.bded6a72913f2p-1,   -0x1.ffb32p-5, INEXACT)
T(RN,  0x1.46ec4a546a1bfp+589,     0x1.973e700da6b9p-2,   -0x1.1f4a9p-2, INEXACT)
T(RN,  0x1.0f48eaeed2335p+589,   -0x1.7557996d9ecc2p-3,  -0x1.9ef6cap-4, INEXACT)
T(RN,  0x1.a8367bd40c524p+589,   -0x1.e16e61048efc6p-2,  -0x1.ff61c4p-6, INEXACT)
T(RN,  0x1.7572d6f178669p+590,   -0x1.ffa955e438d67p-1,   0x1.84762ep-2, INEXACT)
T(RN,  0x1.18c2d18e063bep+590,   -0x1.2afeab5464f08p-5,    0x1.55053p-5, INEXACT)
T(RN,  0x1.e592ba63f769cp+590,     0x1.a81c1edb827fp-1,  -0x1.c7d274p-2, INEXACT)
T(RN,  0x1.993b705aa70f2p+590,    0x1.e123f79ef19afp-1,  -0x1.f75ca4p-4, INEXACT)
T(RN,  0x1.c69b4ac1616a2p+590,    0x1.2f53e658f4e7ap-2,   0x1.986d7ap-3, INEXACT)
T(RN,  0x1.394cf9b5bc4a7p+590,   -0x1.f6c3e9ac3b4efp-2,  -0x1.ba74e6p-2, INEXACT)
T(RN,  0x1.91a12b4ccf69bp+590,    0x1.e11df3bf936f2p-1,   0x1.2ba1dcp-4, INEXACT)
T(RN,  0x1.8f8c822303c36p+590,   -0x1.37af4c161da83p-4,  -0x1.b963d6p-3, INEXACT)
T(RN,  0x1.ef1c2f1e79388p+590,   -0x1.69f643b9bdb79p-1,  -0x1.f7e75cp-3, INEXACT)
T(RN,  0x1.d3ff3bdeddc34p+590,    0x1.0d1177cb36256p-1,   0x1.45a2aap-2, INEXACT)
T(RN,  0x1.7c45f4ebf48c3p+591,   -0x1.62a8c972d6626p-1,   0x1.7094d4p-2, INEXACT)
T(RN,  0x1.3abe85c56d6abp+591,   -0x1.3a081658948e1p-2,    0x1.2d12ap-2, INEXACT)
T(RN,  0x1.5b6e4466ff699p+591,   -0x1.fee870e152824p-1,  -0x1.e0d544p-2, INEXACT)
T(RN,   0x1.ab9bdf0a2264p+591,   -0x1.695b3edc2dfc2p-1,    0x1.efa18p-2, INEXACT)
T(RN,  0x1.748f5660804bap+591,   -0x1.47f64e6dbd206p-1,   0x1.62e406p-4, INEXACT)
T(RN,  0x1.be1ea2a80b07dp+591,   -0x1.b84678d9c27cap-2,   0x1.5871c8p-2, INEXACT)
T(RN,  0x1.f0d32814768b6p+591,    0x1.706bdc33235abp-2,  0x1.e3f23ep-12, INEXACT)
T(RN,   0x1.6c86f7552fbep+591,   -0x1.1cb43a047ff33p-1,  -0x1.0f88d4p-5, INEXACT)
T(RN,  0x1.4969213833831p+591,   -0x1.9d015fd5eff44p-1,  -0x1.99c45ep-5, INEXACT)
T(RN,  0x1.686f3f47e764cp+591,    0x1.21fb02a6b0789p-1,   -0x1.fab73p-3, INEXACT)
T(RN,  0x1.8c681e16f6a46p+592,   -0x1.c7bed5096187dp-1,  -0x1.3658d2p-4, INEXACT)
T(RN,  0x1.9beeb48f2e3ebp+592,    0x1.6bb55291ef362p-1,  -0x1.87a6c8p-2, INEXACT)
T(RN,  0x1.15acddf1cf2fap+592,   -0x1.066d3462b5e6dp-2,    0x1.fdb73p-2, INEXACT)
T(RN,  0x1.4689e889529b1p+592,    0x1.9698a7497bd69p-1,  -0x1.12518ap-2, INEXACT)
T(RN,  0x1.d3229ae8b3e5ap+592,    -0x1.b4732473a398p-1,   -0x1.39b02p-3, INEXACT)
T(RN,  0x1.e4fa6792ae3cep+592,    0x1.dcc254ab63ee5p-1,   0x1.d73e94p-2, INEXACT)
T(RN,  0x1.872058e46b5d3p+592,   -0x1.6b56a4d1ef86ep-1,   0x1.d84db6p-7, INEXACT)
T(RN,  0x1.e1d2cd6ab20e4p+592,   -0x1.c293c09e21061p-1,  -0x1.c1d088p-2, INEXACT)
T(RN,  0x1.61123fcfee24dp+592,   -0x1.f61c78c1fe74fp-1,  -0x1.85873ap-3, INEXACT)
T(RN,  0x1.0cb0714967f0bp+592,    0x1.165fbc27a9008p-2,   0x1.92c84ep-5, INEXACT)
T(RN,  0x1.386737221fb38p+593,   -0x1.8b9f66ec15de6p-1,  -0x1.aba012p-5, INEXACT)
T(RN,   0x1.a2c140ea0ddcp+593,    0x1.2bf13b60c64bcp-2,    0x1.fdaf4p-2, INEXACT)
T(RN,  0x1.12500c4b7daccp+593,   -0x1.6ba69e145c2c9p-4,   0x1.92c54ap-3, INEXACT)
T(RN,  0x1.7a1053fe6a2b5p+593,   -0x1.8dbf74972b0aap-1,   0x1.1f792ap-3, INEXACT)
T(RN,  0x1.258a09d79f659p+593,    0x1.fef9c1c262c87p-1,   0x1.7bc002p-2, INEXACT)
T(RN,  0x1.f5a02ebd85e9bp+593,    0x1.95ec7db63842bp-1,  -0x1.bf8c94p-4, INEXACT)
T(RN,  0x1.aac85729cb0b5p+593,    0x1.dfe27ea9c2e56p-1,  -0x1.7f7fdep-4, INEXACT)
T(RN,  0x1.32b3608345227p+593,    0x1.7e0199781cf5cp-1,  -0x1.72a788p-2, INEXACT)
T(RN,  0x1.308a4dd0b8643p+593,    0x1.56f91c673346ap-1,   0x1.9a1118p-2, INEXACT)
T(RN,  0x1.53c5449094aa2p+593,   -0x1.ec05b7b516a2ep-1,  -0x1.be4f3ap-5, INEXACT)
T(RN,  0x1.ad5765d4fa7fep+594,    -0x1.a4334c49d4eep-1,   0x1.ba1ea4p-3, INEXACT)
T(RN,  0x1.381dddd7e39b4p+594,    0x1.b6d29764eaed8p-1,   0x1.987b3cp-4, INEXACT)
T(RN,  0x1.d266ced9d0474p+594,    0x1.e95a2ae604274p-1,   0x1.407cccp-4, INEXACT)
T(RN,  0x1.b98d8552214d8p+594,    0x1.cb43f546c6b8ap-1,  -0x1.a1f3a2p-7, INEXACT)
T(RN,  0x1.1098c3a0ff80bp+594,   -0x1.8e731ddaac1edp-1,   0x1.f7ac36p-3, INEXACT)
T(RN,  0x1.cd17c510e4e0ap+594,   -0x1.70d15578b5863p-2,  -0x1.413b6cp-2, INEXACT)
T(RN,  0x1.223e77139f39ap+594,  -0x1.e33f1cae94573p-13,   0x1.e88434p-4, INEXACT)
T(RN,  0x1.95963b7b4dec4p+594,   -0x1.c8f0ba651f12ap-1,  -0x1.ab56acp-2, INEXACT)
T(RN,    0x1.68ed624b49ap+594,     0x1.e5c40b31d3a3p-1,   0x1.2f5ffcp-3, INEXACT)
T(RN,  0x1.e6fc2466ff9c7p+594,    -0x1.228eb4b8640dp-3,  -0x1.fd289ep-2, INEXACT)
T(RN,  0x1.4cfea71bb01c6p+595,    0x1.1c7e4f0edd39cp-3,   0x1.422cc6p-3, INEXACT)
T(RN,   0x1.c047240cf7a5p+595,    0x1.c537e68bbf2bbp-1,   0x1.06e204p-3, INEXACT)
T(RN,  0x1.a854b208bf094p+595,   -0x1.45cfb53ba2b28p-4,  -0x1.329314p-2, INEXACT)
T(RN,   0x1.3545697d0347p+595,    0x1.d2199365201e8p-1,  -0x1.5d2bd2p-2, INEXACT)
T(RN,  0x1.f974069f1a7bap+595,   -0x1.eed463bcf36eep-3,   0x1.c39a8ap-5, INEXACT)
T(RN,  0x1.fecce65b8f49ap+595,   -0x1.f2ecf9c55d26cp-1,  -0x1.c8d19ap-4, INEXACT)
T(RN,  0x1.1c0646c12b1f7p+595,   -0x1.686f8f6bd506bp-2,   0x1.fc94c8p-2, INEXACT)
T(RN,  0x1.30c461e0743b8p+595,    0x1.f9252cf6d66a3p-1,  -0x1.beeae4p-3, INEXACT)
T(RN,  0x1.3968c8816e8d3p+595,   -0x1.d23c9d3f48b43p-1,  -0x1.d6eb02p-5, INEXACT)
T(RN,  0x1.b39564a23840bp+595,   -0x1.8f2a6198bfad5p-2,   0x1.0779f4p-2, INEXACT)
T(RN,  0x1.1a3d0bf238d33p+596,    0x1.c3541da9a53f5p-1,   0x1.a0cd96p-2, INEXACT)
T(RN,  0x1.e96376b07301bp+596,   -0x1.8e219a129755ap-1,   -0x1.a7bf7p-4, INEXACT)
T(RN,  0x1.213825f1a654ep+596,   -0x1.5996ab1093e8bp-2,    0x1.b47a4p-2, INEXACT)
T(RN,  0x1.4ced580014fa3p+596,   -0x1.9952ae3e630e9p-1,  -0x1.fc64fap-2, INEXACT)
T(RN,  0x1.4fb99c41d67dbp+596,    0x1.349137a3706e5p-3,  -0x1.f2fdc8p-2, INEXACT)
T(RN,  0x1.0860f37a7e27ap+596,    -0x1.9e0ee1e761e5p-2,  -0x1.71deb6p-4, INEXACT)
T(RN,   0x1.2d30d450d7a2p+596,    0x1.ddbf3b99e18adp-1,   0x1.03d88ep-7, INEXACT)
T(RN,  0x1.62e72e5374498p+596,    0x1.eabe6fbc177cdp-1,  -0x1.e44e5cp-2, INEXACT)
T(RN,   0x1.546ae6026ab5p+596,   -0x1.fd2c312d6b0b3p-1,    0x1.6ebc4p-4, INEXACT)
T(RN,  0x1.29447630b0be1p+596,   -0x1.a94afdee8cb8fp-1,  -0x1.64247ep-4, INEXACT)
T(RN,  0x1.c47e8ef83f942p+597,    0x1.9df8dc9ec1f68p-3,     0x1.306bp-3, INEXACT)
T(RN,  0x1.86c796ab40026p+597,     0x1.d7fd9f6e2b37p-1,   0x1.5ddceap-4, INEXACT)
T(RN,  0x1.1da48cf08a3ffp+597,    0x1.5acf8955c2019p-1,  -0x1.a1532cp-3, INEXACT)
T(RN,  0x1.737c75699bc01p+597,   -0x1.fd8d7aca7b891p-1,   0x1.1f2428p-4, INEXACT)
T(RN,  0x1.3c9d2ba5d47f2p+597,    0x1.7d477bb63bce4p-2,   0x1.31b85ap-5, INEXACT)
T(RN,  0x1.212f9b9f9073ap+597,    0x1.8354d109c9e3fp-1,   0x1.7c5f0cp-7, INEXACT)
T(RN,  0x1.1c25cfb301881p+597,   -0x1.3ecb54653ad26p-2,  -0x1.9f477cp-3, INEXACT)
T(RN,  0x1.4775f3de5b972p+597,    0x1.9b2aef123ba83p-1,  -0x1.538314p-3, INEXACT)
T(RN,  0x1.5eab8d31798cdp+597,    0x1.fff7ee3d7ec93p-1,   0x1.9d899cp-6, INEXACT)
T(RN,   0x1.616985b1c908p+597,    0x1.0a8744397bd8fp-4,   0x1.1b786cp-3, INEXACT)
T(RN,  0x1.6f54695fb3faap+598,   -0x1.ffe7e00ad1e49p-1,  -0x1.d77aacp-4, INEXACT)
T(RN,  0x1.4f754fd8e2534p+598,     0x1.fc831789f8d5p-1,   0x1.caa83ep-5, INEXACT)
T(RN,  0x1.83a2563cddfa1p+598,    0x1.3f9509292b5dbp-1,  -0x1.24ebbap-3, INEXACT)
T(RN,  0x1.91e71c13528a4p+598,    0x1.ed201ea8e8ad7p-1,  -0x1.daa402p-4, INEXACT)
T(RN,  0x1.801919b5647d3p+598,    0x1.d26a938f88141p-1,  -0x1.f3d7fep-4, INEXACT)
T(RN,  0x1.60d51eea73b34p+598,   -0x1.cc4a0a7e2f6e9p-1,   0x1.a53d6cp-2, INEXACT)
T(RN,  0x1.5ec20deac00a2p+598,   -0x1.ffb3ecedbdbb4p-1,   0x1.73fad4p-4, INEXACT)
T(RN,  0x1.2709e90c6f912p+598,    0x1.e5abdbbd0c552p-1,   0x1.ac9f72p-2, INEXACT)
T(RN,  0x1.6c0edc5610f9cp+598,   -0x1.6c10a4067d7e7p-1,   0x1.dbf7fep-2, INEXACT)
T(RN,  0x1.7ad8a56aaefdcp+598,   -0x1.ffe2c82b66b84p-1,   0x1.f18408p-4, INEXACT)
T(RN,  0x1.8720517cbe872p+599,   -0x1.fab309e788412p-4,   0x1.a7868ap-3, INEXACT)
T(RN,   0x1.dfeca5e69884p+599,   -0x1.3171709dc46ecp-1,   0x1.630f5cp-2, INEXACT)
T(RN,  0x1.ae6a514b69243p+599,    -0x1.ccfe84784f95p-1,  -0x1.e33222p-3, INEXACT)
T(RN,  0x1.bc50901d7beb4p+599,   -0x1.b5d37f20acd85p-1,   0x1.ca8074p-3, INEXACT)
T(RN,  0x1.6b82deb046453p+599,   -0x1.078d1eba58cbcp-2,   0x1.b7872ep-5, INEXACT)
T(RN,  0x1.928ad83c72b54p+599,   -0x1.f2b1273c6c048p-1,  -0x1.efdd7cp-4, INEXACT)
T(RN,  0x1.7f86e6db51cfcp+599,   -0x1.2cf1bf2e0cb24p-1,   0x1.2c41aep-2, INEXACT)
T(RN,  0x1.e0e1e1287382bp+599,    0x1.9158165ba3e78p-1,   0x1.38fadep-5, INEXACT)
T(RN,  0x1.95331d9676f04p+599,    0x1.9414dbeffb437p-2,    0x1.bf3e3p-2, INEXACT)
T(RN,  0x1.fc89d3db0086cp+599,    0x1.edd70f7a42fecp-1,  -0x1.a1658cp-3, INEXACT)
T(RN,  0x1.94097569638a2p+600,    0x1.67c294383ac34p-3,   0x1.ad866ap-4, INEXACT)
T(RN,  0x1.a3544702dc164p+600,   -0x1.da55d42ab4595p-1,  -0x1.e328c4p-2, INEXACT)
T(RN,  0x1.c864caff47eb8p+600,   -0x1.ea354016f486fp-1,  -0x1.693b12p-2, INEXACT)
T(RN,     0x1.927121af3ap+600,    0x1.a4c133dd11953p-1,   0x1.b1c0e4p-2, INEXACT)
T(RN,   0x1.e7185b242282p+600,    0x1.3b7b70a21ac7dp-3,  -0x1.e67234p-4, INEXACT)
T(RN,  0x1.899afc8aea64bp+600,   -0x1.c4e9e92561dadp-3,   0x1.8265f8p-2, INEXACT)
T(RN,  0x1.aa8724e5ffff2p+600,   -0x1.d626fbf50d32fp-1,  -0x1.d0cedap-3, INEXACT)
T(RN,  0x1.79a97b8d7382ep+600,   -0x1.1c1b0e3d79d34p-1,   0x1.401ed2p-2, INEXACT)
T(RN,   0x1.c44efb5a925bp+600,   -0x1.fffff64cce077p-1,   0x1.9a3bdep-2, INEXACT)
T(RN,  0x1.52bc82a404acdp+600,    0x1.0d948b9bc92a3p-1,   0x1.309918p-2, INEXACT)
T(RN,   0x1.c468433aa60cp+601,    0x1.b3e5b6debcfe4p-1,  -0x1.672a62p-2, INEXACT)
T(RN,  0x1.cebdaa68aaf31p+601,   -0x1.5b0b6d6c1189bp-1,  -0x1.020da2p-4, INEXACT)
T(RN,  0x1.596f154e001c9p+601,   -0x1.f570eff4e3e2fp-1,   0x1.8eb52cp-6, INEXACT)
T(RN,  0x1.8d6fd07570691p+601,   -0x1.92fb2f712062fp-1,   0x1.a18682p-2, INEXACT)
T(RN,  0x1.3f399dd4a63dap+601,   -0x1.23b8ca7e97479p-2,   0x1.d2a27ep-2, INEXACT)
T(RN,  0x1.95bc1fd3bf536p+601,    0x1.fc4824e386087p-1,  -0x1.603e6ap-6, INEXACT)
T(RN,  0x1.211016c58c133p+601,   -0x1.2ee198c3623e5p-3,   0x1.47ce96p-3, INEXACT)
T(RN,  0x1.0680f5932ec59p+601,   -0x1.c41d672c4eadfp-1,  -0x1.1e4f8cp-6, INEXACT)
T(RN,  0x1.0f354f9b053d7p+601,    0x1.cf7657e105ce3p-1,   0x1.377624p-2, INEXACT)
T(RN,  0x1.a0c3bc205ac2dp+601,   -0x1.8c5da2eaa8271p-3,  -0x1.ad9edap-2, INEXACT)
T(RN,  0x1.617839caa739cp+602,   -0x1.5b52c68a09fd6p-2,    0x1.79b8cp-2, INEXACT)
T(RN,  0x1.34d32068878ffp+602,   -0x1.a87f50d0af806p-1,   0x1.ec3fbap-3, INEXACT)
T(RN,  0x1.a912837aeffa1p+602,   -0x1.ab5ac8efa58ffp-1,  -0x1.bd28d6p-2, INEXACT)
T(RN,  0x1.e5620626f3a64p+602,   -0x1.c315011e6c43ap-2,  -0x1.972fcap-6, INEXACT)
T(RN,  0x1.1b2b9f68d2c81p+602,    0x1.6d33060337546p-4,    0x1.28bedp-3, INEXACT)
T(RN,  0x1.1b2ef74746b13p+602,     0x1.535295246b6ap-3,   0x1.56ce08p-2, INEXACT)
T(RN,  0x1.f6acc4d315ec9p+602,   -0x1.fffd06f972c24p-1,   0x1.a29dbap-3, INEXACT)
T(RN,  0x1.8f20841dda908p+602,   -0x1.3f61220527a57p-1,   0x1.768faap-2, INEXACT)
T(RN,  0x1.3bfafc1f4dccep+602,    0x1.d8e861e6f4485p-4,    -0x1.0c2fp-2, INEXACT)
T(RN,  0x1.8779d5836952ep+602,   -0x1.2d6c3ab3d625cp-1,  -0x1.d1ec78p-2, INEXACT)
T(RN,  0x1.d5d9bb63dff51p+603,    0x1.11a772e54fc19p-4,    0x1.c795fp-2, INEXACT)
T(RN,  0x1.3189d74ed5e76p+603,   -0x1.eb51d72e1cbcdp-1,   0x1.bac92cp-2, INEXACT)
T(RN,  0x1.df3adc414af79p+603,    0x1.80b851255c01ep-6,  -0x1.a775a4p-4, INEXACT)
T(RN,  0x1.144380d2363dbp+603,   -0x1.64db1eee764e3p-1,  -0x1.44b296p-4, INEXACT)
T(RN,  0x1.9614d9654be16p+603,    0x1.e171a3dd6fc0ep-3,   0x1.4d64cap-2, INEXACT)
T(RN,  0x1.e30622951ae42p+603,    0x1.ffe4d679d4c5cp-1,  -0x1.d64ad6p-2, INEXACT)
T(RN,  0x1.35a5a868189f6p+603,    0x1.fab82645db351p-1,   0x1.d352f6p-2, INEXACT)
T(RN,  0x1.a94f7b5e36facp+603,   -0x1.9411baff3b9bdp-1,  -0x1.47b292p-3, INEXACT)
T(RN,  0x1.88cc1a06659a5p+603,    0x1.34c26cd0ead88p-4,  -0x1.662f56p-3, INEXACT)
T(RN,  0x1.99ba98fe8f02cp+603,    0x1.c020d45e5e5cbp-1,   0x1.7ea60ap-5, INEXACT)
T(RN,  0x1.6452f955c4f63p+604,    0x1.ca63604dca129p-2,  -0x1.033b08p-3, INEXACT)
T(RN,  0x1.a45c34b2bbaafp+604,    -0x1.6a48cfeef31bp-1,  -0x1.507a32p-2, INEXACT)
T(RN,  0x1.7ae61137f433fp+604,   -0x1.44b38b0d7da31p-2,   0x1.8fb04cp-3, INEXACT)
T(RN,  0x1.f86272c398e1ap+604,     0x1.54666eea98a6p-1,   0x1.89d7e8p-3, INEXACT)
T(RN,  0x1.d2b8b0563a1d4p+604,    0x1.71d1a363f2b52p-1,   -0x1.6c40dp-2, INEXACT)
T(RN,  0x1.ba2402ee00108p+604,    0x1.bc3c60253848dp-6,   0x1.079a68p-3, INEXACT)
T(RN,  0x1.aa53faa0a0003p+604,   -0x1.ce17080f9b564p-2,   0x1.77d762p-2, INEXACT)
T(RN,  0x1.59fb5123106f1p+604,   -0x1.a83b2885b7c36p-2,  -0x1.0eef6ap-3, INEXACT)
T(RN,  0x1.85b02f272eeb4p+604,   -0x1.fc5668fad838ep-2,  -0x1.8f6c88p-2, INEXACT)
T(RN,  0x1.72ef025433074p+604,   -0x1.b85b15bc4047ap-2,    0x1.c507dp-2, INEXACT)
T(RN,  0x1.f47f30ef2074ap+605,   -0x1.b78f1f971b4f8p-1,  -0x1.18bdb2p-2, INEXACT)
T(RN,  0x1.8a926d71f4bdfp+605,   -0x1.7500d5f8c537dp-2,   0x1.3bdf2cp-2, INEXACT)
T(RN,  0x1.226b1b9240235p+605,    0x1.362074cb1421ap-1,  -0x1.2f692ep-7, INEXACT)
T(RN,  0x1.0900702153e9ep+605,     0x1.e627886e7381p-1,  -0x1.5525f6p-2, INEXACT)
T(RN,  0x1.15ade3fa50583p+605,   -0x1.b12461048d4c3p-2,   0x1.8a9502p-2, INEXACT)
T(RN,  0x1.89bd00e0e0dabp+605,    0x1.fff6dea09dc19p-1,   0x1.6033fcp-8, INEXACT)
T(RN,  0x1.6436dbf185654p+605,    0x1.03d4b6aa0ae0ep-2,  -0x1.64b33cp-2, INEXACT)
T(RN,  0x1.6e3ff9f84a3a2p+605,    0x1.d778d6f087596p-1,  -0x1.db71c4p-7, INEXACT)
T(RN,  0x1.67ba21040170cp+605,   -0x1.733eedc97a20dp-2,  -0x1.3325dap-2, INEXACT)
T(RN,  0x1.178d9adcbd541p+605,     0x1.4a9a9de527d8p-1,   0x1.a19e1ep-2, INEXACT)
T(RN,  0x1.9581f3eb0f4f9p+606,   -0x1.efd86f318ccf5p-2,  -0x1.863988p-3, INEXACT)
T(RN,  0x1.354eee4e1be2dp+606,    0x1.fd5e27975ba0bp-1,   0x1.c4a7c8p-2, INEXACT)
T(RN,  0x1.6a847211a9682p+606,    0x1.032db813260adp-4,  -0x1.0e2cacp-2, INEXACT)
T(RN,  0x1.5023d602d6ffep+606,   -0x1.d734f5fd1e4f7p-1,   0x1.62fdacp-2, INEXACT)
T(RN,  0x1.4785cfae40abbp+606,    0x1.d098abd9bf4aap-1,   0x1.4505b2p-2, INEXACT)
T(RN,  0x1.7000a55f5fc13p+606,   -0x1.fbbca30993a15p-1,  -0x1.ebd94ep-2, INEXACT)
T(RN,  0x1.7cfa7098fc822p+606,    0x1.e5ea0fe325fc9p-1,   0x1.3e70c6p-4, INEXACT)
T(RN,  0x1.85e6aa37524e1p+606,   -0x1.0bef1c0656229p-1,   0x1.b48a76p-2, INEXACT)
T(RN,  0x1.6c559739b6343p+606,   -0x1.bb5761ba7b0d6p-1,   0x1.e4bfaep-2, INEXACT)
T(RN,  0x1.9f3a7ba6e2be4p+606,     0x1.ee533bc491ddp-1,   -0x1.4d36bp-2, INEXACT)
T(RN,  0x1.83223497e28a6p+607,   -0x1.ccd40b00df212p-1,   0x1.6e1682p-8, INEXACT)
T(RN,   0x1.b453b7d8b7cfp+607,    0x1.ff8dc41157c67p-1,  -0x1.a0f75ep-4, INEXACT)
T(RN,  0x1.eba127a170df1p+607,    0x1.716e39ac5bf31p-5,   0x1.362654p-2, INEXACT)
T(RN,  0x1.47d669a508d6cp+607,    0x1.fd5e8f056eba3p-2,     0x1.b3bfp-9, INEXACT)
T(RN,  0x1.1c988cc266b28p+607,    0x1.3ac9ecbc286e9p-4,   0x1.8fca8ap-2, INEXACT)
T(RN,   0x1.b595d4f71fd7p+607,    0x1.fe0ac19385527p-1,   -0x1.f5f91p-2, INEXACT)
T(RN,  0x1.8acade9611647p+607,   -0x1.999bf4c122d6cp-1,    0x1.54136p-5, INEXACT)
T(RN,  0x1.9c9449c98d7d7p+607,    0x1.dfe8f2a28a24dp-1,   0x1.64045ap-2, INEXACT)
T(RN,  0x1.8e6ca65be50e6p+607,   -0x1.46bdf9a0a82fdp-1,   0x1.7e58ccp-2, INEXACT)
T(RN,   0x1.19528bb5da98p+607,    0x1.fcbfb3c400db5p-1,   0x1.20f8cap-2, INEXACT)
T(RN,  0x1.c338bf735c604p+608,    0x1.6352f26eab0ebp-1,  -0x1.96abc4p-3, INEXACT)
T(RN,  0x1.f4dd3efcd0c25p+608,    0x1.df157a0984d3dp-1,   0x1.d090a6p-4, INEXACT)
T(RN,  0x1.aa8c90831ffd8p+608,    0x1.df8f3421b4bb7p-1,   0x1.6e2626p-4, INEXACT)
T(RN,  0x1.dd90cec63402cp+608,   -0x1.9ebb571d80a8fp-1,  -0x1.abf172p-3, INEXACT)
T(RN,   0x1.cc1546d1fa4ep+608,   -0x1.09951b7958203p-4,   0x1.d731fcp-4, INEXACT)
T(RN,  0x1.d49fcc5999c1cp+608,    0x1.e4ad6e2a8f86ap-1,  -0x1.e247c6p-4, INEXACT)
T(RN,   0x1.ab7fc145e709p+608,   -0x1.ff2780c366fa2p-1,   0x1.bc272ep-2, INEXACT)
T(RN,  0x1.3e5a7e1a82384p+608,   -0x1.fffb9c738a95cp-1,  -0x1.484cbap-2, INEXACT)
T(RN,  0x1.5aa01e1e389c8p+608,   -0x1.33c54e11aaaa5p-1,  -0x1.d3627cp-3, INEXACT)
T(RN,  0x1.cb154958f3576p+608,    0x1.d47c0fa88c87fp-2,    0x1.8bbbep-2, INEXACT)
T(RN,  0x1.2b6bd6b449b5fp+609,    0x1.ffd60e40361ddp-1,   -0x1.6d577p-3, INEXACT)
T(RN,  0x1.31ea6fb1fe70cp+609,    0x1.5bb4d77519699p-3,   0x1.040554p-3, INEXACT)
T(RN,  0x1.a6082b345e7a5p+609,    0x1.c7bb91ac948e3p-1,  -0x1.fbf9a6p-2, INEXACT)
T(RN,  0x1.407df7ffea764p+609,   -0x1.59ed76842f593p-1,   0x1.4e41ccp-2, INEXACT)
T(RN,  0x1.c7dbee145c616p+609,    0x1.c6b7d954d6532p-1,  -0x1.276a92p-2, INEXACT)
T(RN,  0x1.77885baba22c3p+609,   -0x1.523ad3205e832p-1,     0x1.a196p-5, INEXACT)
T(RN,  0x1.f176cd0c9b2b7p+609,    0x1.ce90f7feb5fc3p-1,  -0x1.b8d1bap-2, INEXACT)
T(RN,  0x1.660233a8bcdfcp+609,    0x1.f53e9e7ee2336p-1,  -0x1.4c8194p-3, INEXACT)
T(RN,  0x1.4058ba3e2a22ep+609,    0x1.fbbc1e34c1abep-1,  -0x1.4a9f96p-2, INEXACT)
T(RN,  0x1.3a7d6376ef255p+609,    0x1.8bfc79a380fdep-3,  -0x1.ed566ep-7, INEXACT)
T(RN,  0x1.a67c10f4bf906p+610,    0x1.3a6b3d55c927cp-2,   0x1.ee51c6p-2, INEXACT)
T(RN,  0x1.fab45483d4e72p+610,    0x1.6128619284d95p-5,    0x1.1fd02p-3, INEXACT)
T(RN,  0x1.272ac99b32edap+610,    0x1.0fd6140d09aeep-1,  -0x1.579fdep-4, INEXACT)
T(RN,  0x1.dadf6ddc7911cp+610,  -0x1.85ce391454138p-11,  -0x1.b3d448p-5, INEXACT)
T(RN,  0x1.f90031e1fa54ap+610,   -0x1.fadf17f12f8efp-1,   0x1.23151cp-6, INEXACT)
T(RN,  0x1.48f37673b2284p+610,    0x1.b3653844bc4a6p-2,   0x1.2cbab6p-3, INEXACT)
T(RN,  0x1.3a0016482b6d7p+610,    -0x1.ff43ee1f4323p-1,   0x1.df52a2p-6, INEXACT)
T(RN,  0x1.82be849774768p+610,    0x1.7fe8a1cba0362p-1,   0x1.d7038cp-7, INEXACT)
T(RN,  0x1.228312a51a614p+610,    0x1.7cbeddd0fa55fp-3,  -0x1.bb4922p-2, INEXACT)
T(RN,  0x1.2ea1c66f49a77p+610,     0x1.bac394b84e5cp-2,  -0x1.63fc3ap-2, INEXACT)
T(RN,  0x1.05399a07ab413p+611,    0x1.b401b466d3919p-1,  -0x1.2e0566p-3, INEXACT)
T(RN,  0x1.17baf0e59453cp+611,   -0x1.5dcd01ccc2fabp-1,   0x1.e72164p-2, INEXACT)
T(RN,  0x1.36741175f18bap+611,   -0x1.e60b9a0810014p-1,   0x1.90a5b8p-2, INEXACT)
T(RN,  0x1.9af5a938256f8p+611,   -0x1.be79a758d87f9p-1,    0x1.f2b4ep-2, INEXACT)
T(RN,  0x1.3486b89a9fb9fp+611,    0x1.460d935c8961dp-1,  -0x1.7890f6p-4, INEXACT)
T(RN,  0x1.100a2aea7878ep+611,   -0x1.c69e0752f4a42p-1,   0x1.4fb54ep-2, INEXACT)
T(RN,  0x1.39b79026abd91p+611,    0x1.d3adfea76e7a9p-1,  -0x1.715906p-2, INEXACT)
T(RN,  0x1.e88b29f7aab9ep+611,   -0x1.cfd6fe62e5212p-2,   0x1.3148f2p-7, INEXACT)
T(RN,   0x1.a62e5d0369e8p+611,    0x1.ffff340d2b171p-1,    0x1.6cf2fp-3, INEXACT)
T(RN,  0x1.0c7e51f45202ep+611,    0x1.e2045625407b3p-1,     0x1.4e88p-3, INEXACT)
T(RN,  0x1.5d2e324665834p+612,    0x1.93f98e6ef1353p-1,  -0x1.e9bb82p-7, INEXACT)
T(RN,  0x1.90411790ea7e2p+612,   -0x1.ff27a482065b1p-1,  -0x1.872938p-3, INEXACT)
T(RN,  0x1.40ea538af952ap+612,    0x1.986337b29218ep-1,  -0x1.ce43b2p-8, INEXACT)
T(RN,  0x1.93045d55aec7fp+612,   -0x1.dc13d52ae4841p-2,  -0x1.35fc9cp-4, INEXACT)
T(RN,   0x1.aaf43b22de21p+612,   -0x1.bccfd5dc70281p-2,  -0x1.f5ffacp-2, INEXACT)
T(RN,  0x1.74b2da6da1537p+612,   -0x1.aba09008fe106p-1,   0x1.547b74p-2, INEXACT)
T(RN,  0x1.da362bff5de94p+612,   -0x1.f18930c4b8971p-5,  -0x1.5aa18ap-7, INEXACT)
T(RN,  0x1.8efa3effa7fe5p+612,   -0x1.fc65460c96d1dp-1,   0x1.9d2d66p-3, INEXACT)
T(RN,  0x1.6b06f0981b8d2p+612,    0x1.c8f0044187293p-1,   0x1.771786p-2, INEXACT)
T(RN,  0x1.c8d71075ec408p+612,   -0x1.25ee8f1c512fcp-1,   0x1.f399a4p-3, INEXACT)
T(RN,  0x1.e1e5352bfd4c4p+613,   -0x1.c4e95cd753a07p-3,   0x1.238616p-3, INEXACT)
T(RN,  0x1.19a428014d80ap+613,    0x1.c124f2eafef46p-3,   0x1.fef43ep-3, INEXACT)
T(RN,  0x1.b210ab6be4cc1p+613,    0x1.ec2a45031b08ap-1,  -0x1.7e087cp-2, INEXACT)
T(RN,  0x1.653e8a6e2ac38p+613,    0x1.2fc6926c44856p-2,   0x1.27cf38p-4, INEXACT)
T(RN,  0x1.108c03fe2cbb5p+613,   -0x1.64ccfe93f4d5ep-2,  -0x1.3ab592p-4, INEXACT)
T(RN,  0x1.87fcba895c556p+613,    0x1.fcb6ad58d1a43p-1,   0x1.3cfc7cp-2, INEXACT)
T(RN,  0x1.68e16d5592a3ap+613,    0x1.73443de9aa22bp-1,   0x1.f611d4p-4, INEXACT)
T(RN,  0x1.d5db44da9d0bap+613,   -0x1.37a4d4308e2c3p-6,   0x1.e2bcfap-3, INEXACT)
T(RN,   0x1.9671a9c6ebe5p+613,    0x1.224c5095d8b1ep-1,  -0x1.7475f6p-2, INEXACT)
T(RN,  0x1.b1885a44d7958p+613,    0x1.ffb7dc6b2a90fp-1,  -0x1.a5b6d2p-6, INEXACT)
T(RN,  0x1.6e2daca3d6359p+614,    0x1.3d1447d2ddd94p-1,   0x1.466646p-2, INEXACT)
T(RN,  0x1.b5ef18789f3fcp+614,     -0x1.416e7ee39a5p-2,  -0x1.86a784p-3, INEXACT)
T(RN,  0x1.702c0d2fe53cap+614,    0x1.8341a99d0aa11p-2,    0x1.3ea59p-2, INEXACT)
T(RN,  0x1.9f22a01ad35b2p+614,    0x1.34b20db410c07p-1,   -0x1.d2029p-4, INEXACT)
T(RN,  0x1.64900cb9d7152p+614,   -0x1.798819324f61ep-1,   0x1.b93c06p-3, INEXACT)
T(RN,  0x1.4ed3ed295f1d2p+614,     0x1.101b5f75be09p-6,  -0x1.0109e6p-2, INEXACT)
T(RN,  0x1.1e8002dfd26cfp+614,    0x1.909a969d52577p-1,    -0x1.4034p-2, INEXACT)
T(RN,  0x1.be0cf75e7b256p+614,   -0x1.feee1299fbad8p-1,   0x1.1b111ap-6, INEXACT)
T(RN,  0x1.68a1d329e05eap+614,    0x1.ffffe34d049d5p-1,   0x1.c91754p-2, INEXACT)
T(RN,  0x1.8584f080db1f7p+614,   -0x1.0222862b7457ep-1,    0x1.ac3c8p-3, INEXACT)
T(RN,  0x1.5b5563f6620f2p+615,    0x1.af20037387952p-3,   0x1.604154p-2, INEXACT)
T(RN,  0x1.4a217e07a9c83p+615,   -0x1.202caaa3bfad6p-1,  -0x1.2094dcp-2, INEXACT)
T(RN,  0x1.b25439cb2f3cep+615,    0x1.fadd54a090e45p-1,   0x1.db9c2ep-3, INEXACT)
T(RN,  0x1.b93580aca4d94p+615,    0x1.cf65bd263dd93p-6,  -0x1.c54446p-3, INEXACT)
T(RN,   0x1.7cfd734d2ce4p+615,    0x1.fcde79f5f1a42p-1,   -0x1.4334bp-4, INEXACT)
T(RN,  0x1.4b9868a50d942p+615,   -0x1.e8a0f16e5bad4p-1,  -0x1.55cba2p-2, INEXACT)
T(RN,  0x1.dcaf364bd2494p+615,    0x1.4091a57cba426p-3,  -0x1.4b8736p-2, INEXACT)
T(RN,  0x1.eea87570292fep+615,   -0x1.d2ede5b56f1d4p-1,   -0x1.72fb3p-2, INEXACT)
T(RN,  0x1.251635787b1f1p+615,    0x1.e5abe9acc43ecp-1,    0x1.fd43ep-3, INEXACT)
T(RN,  0x1.3fded918f7d23p+615,   -0x1.8994e961474d1p-2,   -0x1.4a4afp-3, INEXACT)
T(RN,  0x1.f769bf42b5992p+616,   -0x1.5e4d0aef58a48p-1,  -0x1.e63518p-2, INEXACT)
T(RN,  0x1.082471d207569p+616,   -0x1.4faa81c20c9fcp-2,  -0x1.1aff82p-2, INEXACT)
T(RN,  0x1.a818cfab4b3b8p+616,   -0x1.465b7bfe93c02p-1,  -0x1.856e1ap-2, INEXACT)
T(RN,  0x1.d9075a8a418dbp+616,    0x1.716ab7f676e83p-1,   0x1.f7300ep-2, INEXACT)
T(RN,   0x1.e2d504b0b9b4p+616,   -0x1.e9f1106402454p-1,  -0x1.861064p-3, INEXACT)
T(RN,  0x1.9c7231f671e79p+616,   -0x1.a21051f1f3795p-1,  -0x1.c9365ep-3, INEXACT)
T(RN,  0x1.cfbd72400c3cap+616,   -0x1.abe940603009cp-2,  -0x1.22e9bcp-3, INEXACT)
T(RN,  0x1.f4e2036f462acp+616,   -0x1.d080828036e9dp-3,   0x1.f34ae4p-2, INEXACT)
T(RN,  0x1.e39501968c7aap+616,    0x1.ffe7523d00263p-1,  -0x1.e8c65ep-2, INEXACT)
T(RN,  0x1.db0cbdbf951bap+616,   -0x1.aabdd3cffce3dp-1,   0x1.6a1d32p-4, INEXACT)
T(RN,  0x1.985eb85780124p+617,   -0x1.6187824e186fep-2,  -0x1.9e741cp-2, INEXACT)
T(RN,  0x1.2971a2435f00bp+617,    0x1.cefcb64eeaa03p-1,    0x1.1a071p-2, INEXACT)
T(RN,  0x1.5aadcc969115ep+617,   -0x1.2cee7d8406cc5p-3,   0x1.417034p-6, INEXACT)
T(RN,  0x1.4d7b92b6bbb27p+617,    0x1.1ec823904db46p-3,   0x1.7eea94p-4, INEXACT)
T(RN,  0x1.cafe874c8a802p+617,    0x1.98b22f581e895p-1,  -0x1.d18eb6p-3, INEXACT)
T(RN,  0x1.550aba656721ep+617,   -0x1.e8f75b6d17806p-1,  -0x1.f419fep-2, INEXACT)
T(RN,  0x1.28418768b6082p+617,    0x1.ecb7f039e48dep-1,  -0x1.13157cp-2, INEXACT)
T(RN,  0x1.5a0ee8550bcd2p+617,   -0x1.a82d3b9ac5e38p-1,   0x1.8045eep-3, INEXACT)
T(RN,  0x1.8c13a69397e5ep+617,    0x1.e987247898a88p-2,  -0x1.9c041cp-5, INEXACT)
T(RN,   0x1.f18559a1352bp+617,   -0x1.30990d78dd879p-2,   0x1.41b63cp-3, INEXACT)
T(RN,   0x1.215e8e184f74p+618,    0x1.ded235f97f3bdp-1,   0x1.ef72c8p-3, INEXACT)
T(RN,  0x1.26dd64266bcdep+618,   -0x1.8fd4772cd7115p-2,  -0x1.96699cp-3, INEXACT)
T(RN,  0x1.00ca3ebea06d3p+618,    0x1.ffee9cc994dc4p-1,   0x1.2b01b8p-3, INEXACT)
T(RN,    0x1.e01a01a12f9p+618,   -0x1.49ac4e737308bp-1,  -0x1.a64736p-2, INEXACT)
T(RN,  0x1.50d2478db344fp+618,    0x1.f9204dc757582p-1,   0x1.2ffc4ep-4, INEXACT)
T(RN,  0x1.061f70246c714p+618,    0x1.ff1e7f902ebddp-1,  -0x1.018924p-2, INEXACT)
T(RN,  0x1.0b9d6c0a1ae16p+618,   -0x1.be750ed3d457bp-1,   0x1.452356p-2, INEXACT)
T(RN,  0x1.ad8c77c0f5c9fp+618,    0x1.a6f97166e7d7ap-1,  -0x1.3f113ep-2, INEXACT)
T(RN,   0x1.d4db735fa803p+618,    0x1.ca7d63b9e77b3p-1,   0x1.fdbc84p-6, INEXACT)
T(RN,  0x1.f87aaed36c54dp+618,    0x1.a870530ed939bp-3,   0x1.f8c1f8p-3, INEXACT)
T(RN,  0x1.0a167d8a94092p+619,   -0x1.61b5f7e7385d4p-2,  -0x1.7c0004p-2, INEXACT)
T(RN,  0x1.67959d70162d1p+619,    0x1.fffd62a18c37ep-1,  -0x1.44116cp-3, INEXACT)
T(RN,  0x1.b9e2eca4fac8cp+619,   -0x1.b03947b318a3dp-2,  -0x1.6cfbfcp-2, INEXACT)
T(RN,  0x1.f8770278ad42ap+619,   -0x1.463d6e16216a9p-1,   0x1.92e1aep-3, INEXACT)
T(RN,  0x1.18e2c93b010b8p+619,   -0x1.fffc7fd4b8f3bp-1,  -0x1.74ed62p-2, INEXACT)
T(RN,  0x1.18b5474e16f9fp+619,   -0x1.e3e9f1d0b533ep-1,  -0x1.3b416cp-3, INEXACT)
T(RN,  0x1.6c819f2335a9cp+619,   -0x1.fedb968350549p-1,  -0x1.069362p-2, INEXACT)
T(RN,  0x1.ea7172ec4cb6ap+619,   -0x1.d2ce0c0687069p-2,   0x1.ff1feap-2, INEXACT)
T(RN,  0x1.6169ae95fdc9bp+619,    0x1.84e1506917ce8p-1,   0x1.9e675cp-2, INEXACT)
T(RN,  0x1.79d107a34dfa6p+619,   -0x1.a5866858f1f7cp-1,   0x1.059e44p-2, INEXACT)
T(RN,  0x1.e91d341187116p+620,    0x1.1e978a6237839p-1,   0x1.c04992p-3, INEXACT)
T(RN,  0x1.1bae379624d5dp+620,   -0x1.ff43b2e2e54cap-1,   0x1.743562p-2, INEXACT)
T(RN,  0x1.9a764c70870d6p+620,     0x1.6df867223031p-4,  -0x1.06a6c8p-4, INEXACT)
T(RN,  0x1.896ff5682721cp+620,   -0x1.ee92cfef7693fp-1,  -0x1.226ed4p-2, INEXACT)
T(RN,   0x1.a12a250e35cap+620,   -0x1.e651a52b019aep-1,  -0x1.76c6cap-3, INEXACT)
T(RN,  0x1.a60f05236c67ep+620,   -0x1.19f46626651a6p-1,   0x1.a31e9cp-3, INEXACT)
T(RN,  0x1.02624aadf0407p+620,     0x1.75cfa5561542p-2,   -0x1.8c62dp-3, INEXACT)
T(RN,  0x1.89ec96e473255p+620,    0x1.32996dd77bf59p-1,  -0x1.081916p-5, INEXACT)
T(RN,  0x1.98df5f9a9edfcp+620,   -0x1.b29d55053a49bp-1,   0x1.40dddcp-4, INEXACT)
T(RN,  0x1.294957a1e0836p+620,    0x1.3db3d6da08046p-6,  -0x1.b4f562p-4, INEXACT)
T(RN,  0x1.0501d22221dacp+621,   -0x1.f68f0e26c0f6bp-3,  -0x1.5d8474p-3, INEXACT)
T(RN,  0x1.c8edd34a4c51ep+621,   -0x1.ff4f25c9e5323p-1,   0x1.4c86ccp-2, INEXACT)
T(RN,  0x1.b87999b2ef886p+621,   -0x1.4f75eba35d094p-1,   0x1.145a6ep-2, INEXACT)
T(RN,  0x1.4aa9629f7a348p+621,    0x1.f32361776e3d8p-1,   0x1.3d8e28p-2, INEXACT)
T(RN,  0x1.8d8de7b57ec82p+621,     -0x1.ffda3597f76p-2,   0x1.a554c6p-5, INEXACT)
T(RN,   0x1.f710a6755698p+621,    0x1.9c254f284ef01p-2,   0x1.d088eep-3, INEXACT)
T(RN,  0x1.2db6daf39fe51p+621,    0x1.cc70353b77c35p-1,  -0x1.cdef58p-2, INEXACT)
T(RN,  0x1.c3829fb9ac7c3p+621,   -0x1.65cf4e472ad6cp-1,  -0x1.43f772p-5, INEXACT)
T(RN,  0x1.e7d5c09310847p+621,    0x1.7a317e241368cp-2,   0x1.37d9a6p-3, INEXACT)
T(RN,  0x1.1e0f89aefcdd8p+621,   -0x1.a5a54acf552a7p-1,  -0x1.c33f64p-3, INEXACT)
T(RN,  0x1.e4a2deebc13a7p+622,    -0x1.1b5f8480bd44p-1,  -0x1.69304ep-2, INEXACT)
T(RN,  0x1.135cc8a55feb2p+622,   -0x1.ebd3f9a4d51a7p-2,   0x1.d7c3c8p-2, INEXACT)
T(RN,  0x1.6838d0653b3e6p+622,    0x1.daebb9062f3ddp-1,   0x1.97949ep-2, INEXACT)
T(RN,  0x1.9621062090818p+622,    0x1.16af9ec562a3dp-2,   0x1.f52f2cp-2, INEXACT)
T(RN,  0x1.027fc790c4417p+622,    0x1.984c6e28c1902p-2,   0x1.e6bffap-4, INEXACT)
T(RN,  0x1.1a387b7b7b9a7p+622,    0x1.4a482faf6c0a8p-4,  -0x1.6a14b6p-4, INEXACT)
T(RN,  0x1.bdafd8964ba23p+622,   -0x1.e1cf4fe7a152ep-1,   0x1.f6de48p-3, INEXACT)
T(RN,  0x1.86046c231efd8p+622,   -0x1.d9a999ac1f71ep-1,  -0x1.f9009cp-4, INEXACT)
T(RN,  0x1.0e55cbcf45123p+622,   -0x1.e7549b6dcba88p-1,  -0x1.983b0ep-2, INEXACT)
T(RN,  0x1.4bfdfa485a7fap+622,   -0x1.b3ca48ad173dbp-1,   0x1.85c248p-5, INEXACT)
T(RN,  0x1.ea0fa1ecdb0a8p+623,   -0x1.b571e0fe2e5dfp-3,   -0x1.65f06p-2, INEXACT)
T(RN,  0x1.4a70c31d664b3p+623,   -0x1.fff3451f80839p-1,    0x1.83ac7p-3, INEXACT)
T(RN,  0x1.07809e69ec3ddp+623,     -0x1.b81db3f7103p-1,  -0x1.1e6f8ap-9, INEXACT)
T(RN,  0x1.a2b4dab94e8b1p+623,   -0x1.543cebb7f756ap-3,   0x1.521b44p-3, INEXACT)
T(RN,  0x1.e41a1785e4012p+623,    0x1.c60a5920ff6b4p-2,  -0x1.5e31e4p-4, INEXACT)
T(RN,  0x1.fded9a775b445p+623,    0x1.a9cde76e2337dp-1,   0x1.e0bbaap-2, INEXACT)
T(RN,  0x1.d58b8cf1ea198p+623,    0x1.e172f607a1345p-1,   0x1.3413a2p-3, INEXACT)
T(RN,   0x1.23de079080cap+623,    0x1.2b0e6167ec895p-4,  -0x1.b76a7cp-2, INEXACT)
T(RN,  0x1.2d0eb04c44fcap+623,    0x1.bea3983ecf05bp-1,    0x1.e108dp-5, INEXACT)
T(RN,  0x1.a11776b8033c3p+623,    0x1.c22bd8bd2fa1bp-3,   -0x1.eaf96p-2, INEXACT)
T(RN,  0x1.db634313e284ap+624,   -0x1.1101fda92c9d5p-1,  -0x1.e3ff28p-3, INEXACT)
T(RN,  0x1.c9a1232a7b467p+624,    0x1.5e578a262e11ap-1,   0x1.c42928p-2, INEXACT)
T(RN,  0x1.b6bf2869eacc4p+624,    0x1.cd31ca808907dp-1,  -0x1.a3e5c2p-2, INEXACT)
T(RN,  0x1.ce45d9844bee3p+624,   -0x1.cea90dbe5f812p-1,   0x1.6c664cp-6, INEXACT)
T(RN,  0x1.9ddfbba32a2b3p+624,    0x1.f9faa1e35a85ep-1,   0x1.25e714p-3, INEXACT)
T(RN,  0x1.9246a10090b7ep+624,    0x1.77f4b782f1e4dp-5,  -0x1.72594ap-4, INEXACT)
T(RN,  0x1.0041c63b4d433p+624,      0x1.353e332fae3p-1,  -0x1.956f66p-2, INEXACT)
T(RN,  0x1.def108e269ef6p+624,    0x1.ff63faa075b58p-1,   0x1.1c37e2p-2, INEXACT)
T(RN,  0x1.249a2d6974008p+624,   -0x1.2cb0bcc779487p-1,  -0x1.958792p-3, INEXACT)
T(RN,  0x1.6f827352a6652p+624,   -0x1.65733e76b8b76p-3,   0x1.e26beep-4, INEXACT)
T(RN,  0x1.1e8b3c11c6289p+625,    0x1.fdc580841a011p-1,   0x1.89a88cp-6, INEXACT)
T(RN,  0x1.9f06a5a30b91ap+625,   -0x1.4c90e01b085e7p-2,  -0x1.cd51b4p-2, INEXACT)
T(RN,  0x1.3768a4ab2bde3p+625,    0x1.2cbfcb2f6cefcp-3,    0x1.5e741p-2, INEXACT)
T(RN,  0x1.56a5a07aaecfap+625,    0x1.a2d50e4979546p-1,   0x1.5ca7f2p-2, INEXACT)
T(RN,   0x1.8d540f5f2431p+625,    -0x1.f93bf86ffaf1p-1,  -0x1.ab13fcp-2, INEXACT)
T(RN,  0x1.20c964bd835dbp+625,   -0x1.6c4f8654cc496p-1,  -0x1.139894p-2, INEXACT)
T(RN,  0x1.e4596ebe862b6p+625,   -0x1.110f6c5439e11p-1,  -0x1.415554p-3, INEXACT)
T(RN,  0x1.3d23c5c42469ap+625,   -0x1.0812afe8b6bf7p-1,   0x1.8a4d3cp-4, INEXACT)
T(RN,  0x1.a79da00cc5536p+625,   -0x1.e4c3cac6615aap-1,  -0x1.366c66p-3, INEXACT)
T(RN,   0x1.4037f1905a99p+625,    0x1.f3dc4925a9ffbp-1,  -0x1.d1b6e8p-2, INEXACT)
T(RN,  0x1.d1c148fec463cp+626,   -0x1.ffb338427e886p-1,   0x1.5d2b9ep-2, INEXACT)
T(RN,  0x1.44bef84191772p+626,    0x1.c6585606896f7p-2,   0x1.662062p-2, INEXACT)
T(RN,  0x1.1b9bdbfe51012p+626,   -0x1.ef5ce380502f4p-1,   0x1.6b06d4p-2, INEXACT)
T(RN,  0x1.e502da9dc98a2p+626,   -0x1.fff876eeb30fap-1,  -0x1.994c8ap-2, INEXACT)
T(RN,  0x1.b1efac44790e9p+626,   -0x1.d84d255402cd7p-1,   0x1.ae15c6p-5, INEXACT)
T(RN,  0x1.ee8a05f7f9969p+626,    0x1.f9a4e55e6373fp-4,  -0x1.92a794p-4, INEXACT)
T(RN,  0x1.5694253103da6p+626,   -0x1.56225a0630cc6p-1,   0x1.49c678p-2, INEXACT)
T(RN,  0x1.117203831ce2fp+626,    0x1.29a13ba9f0cedp-2,  -0x1.54ac4ap-3, INEXACT)
T(RN,  0x1.867dac915e424p+626,   -0x1.160e3e640b5fcp-1,   -0x1.5d41bp-2, INEXACT)
T(RN,  0x1.2826ea5b9a046p+626,   -0x1.ac5b01083f79bp-3,   0x1.77c23ap-2, INEXACT)
T(RN,  0x1.86838679a7914p+627,   -0x1.e5c79311c4577p-1,   0x1.b4a956p-2, INEXACT)
T(RN,  0x1.a8574619c9f6ap+627,    0x1.dd683e90eebc4p-2,  -0x1.2baef2p-8, INEXACT)
T(RN,  0x1.de8c546169813p+627,   -0x1.77472e8194d18p-1,   0x1.88760cp-5, INEXACT)
T(RN,  0x1.4fefb89421e67p+627,   -0x1.92c0917dfdb86p-4,  -0x1.fc2292p-3, INEXACT)
T(RN,  0x1.e9704c1851494p+627,   -0x1.1718129ca7ffcp-1,    0x1.36d4cp-2, INEXACT)
T(RN,   0x1.6be86befc47ep+627,    0x1.44729b0a68148p-1,  -0x1.7f9034p-2, INEXACT)
T(RN,   0x1.9ecb0f464232p+627,    0x1.e3839b5e0133ap-3,   0x1.d17378p-2, INEXACT)
T(RN,  0x1.eea8556d90afcp+627,   -0x1.ea8de0126fb29p-1,  -0x1.9aadbcp-5, INEXACT)
T(RN,  0x1.1ce0ab0e7469bp+627,   -0x1.d496ec6b69042p-1,  -0x1.e0a486p-2, INEXACT)
T(RN,  0x1.35284170767c7p+627,   -0x1.4420b9934bd17p-1,  -0x1.4c2894p-2, INEXACT)
T(RN,  0x1.7ef51c7ea9a12p+628,    -0x1.7b15db98a08cp-2,  -0x1.49c416p-3, INEXACT)
T(RN,  0x1.7bc5dfda6bdf9p+628,    0x1.8605a6fe7ac74p-1,  -0x1.69b2dep-2, INEXACT)
T(RN,  0x1.6064c5de35264p+628,    0x1.ff70be1ec6e35p-1,  -0x1.f45e62p-2, INEXACT)
T(RN,  0x1.8d9637ae23f8cp+628,    0x1.fdc60787d2818p-2,  -0x1.ed9ccep-2, INEXACT)
T(RN,  0x1.18eca3665b13ap+628,   -0x1.ef66de206a595p-1,   0x1.f214b6p-2, INEXACT)
T(RN,   0x1.9f9e10a4802dp+628,    0x1.88030165a3202p-1,   0x1.ed51cep-3, INEXACT)
T(RN,  0x1.0e10be94c6693p+628,    -0x1.760c2a554686p-1,   0x1.805eb2p-2, INEXACT)
T(RN,  0x1.95cc602f3b33ep+628,    0x1.db7aa3f809f0fp-3,   -0x1.58fa5p-3, INEXACT)
T(RN,  0x1.4c2e374c9937cp+628,   -0x1.fd437d53cd1bdp-1,  -0x1.807a0ap-3, INEXACT)
T(RN,  0x1.49977d678a5a6p+628,    0x1.b22b9585e300ep-3,  -0x1.55fdbap-2, INEXACT)
T(RN,  0x1.4c9c2665f3d34p+629,   -0x1.6a2186daa0139p-1,  -0x1.b24e04p-4, INEXACT)
T(RN,  0x1.7c3e4fb7d1807p+629,   -0x1.2b1ce122b14efp-1,   0x1.e4d312p-2, INEXACT)
T(RN,  0x1.44b90ea9f84f4p+629,    0x1.fe2dc45dc253cp-1,  -0x1.b77246p-4, INEXACT)
T(RN,  0x1.975a8703abcfep+629,   -0x1.3388b2ef49c3ep-1,   0x1.37c516p-2, INEXACT)
T(RN,  0x1.6c3ed58f4910ap+629,   -0x1.6014bb12c6456p-1,   -0x1.ed731p-2, INEXACT)
T(RN,  0x1.c8f2802bca656p+629,    0x1.3c3b991754c6ep-4,   0x1.f9a922p-4, INEXACT)
T(RN,  0x1.eb76dc686f323p+629,   -0x1.764a53f291052p-2,   -0x1.33365p-2, INEXACT)
T(RN,  0x1.6eaa5971a31bep+629,    0x1.04589c6e0f903p-4,  -0x1.97ed64p-6, INEXACT)
T(RN,  0x1.b08b66e9adc05p+629,    0x1.61de23aa99134p-2,   0x1.a08e32p-2, INEXACT)
T(RN,  0x1.8c86e59f49392p+629,    0x1.d275d7cc9e856p-1,  -0x1.0a4718p-2, INEXACT)
T(RN,  0x1.8106503f4d257p+630,  -0x1.f44b3fe2351cap-11,   0x1.84025cp-2, INEXACT)
T(RN,  0x1.3919ad7bd9a34p+630,    0x1.c7a9f58a70157p-1,  -0x1.8fd39cp-2, INEXACT)
T(RN,  0x1.693dc5347c154p+630,   -0x1.4fc2f720a46f3p-3,   0x1.f39116p-2, INEXACT)
T(RN,  0x1.8575aeea31fd3p+630,   -0x1.7d8b788cce5b9p-1,  -0x1.558454p-2, INEXACT)
T(RN,  0x1.718d6f571e5cep+630,    0x1.c3bfcecd95746p-1,  -0x1.0bcbe2p-2, INEXACT)
T(RN,   0x1.439371b17abbp+630,   -0x1.e8b5b30506f64p-2,   -0x1.faf85p-2, INEXACT)
T(RN,  0x1.47abde1cd9688p+630,    0x1.f932073af140fp-1,   0x1.e0829cp-2, INEXACT)
T(RN,  0x1.32ee6e4a0c7a3p+630,    0x1.645fbdd4e7e5ep-1,  -0x1.ea9c62p-5, INEXACT)
T(RN,  0x1.56383215aebfep+630,   -0x1.873fb747686a5p-1,  -0x1.b3a872p-3, INEXACT)
T(RN,  0x1.7baefdb36b95bp+630,   -0x1.2822668c72a15p-3,   0x1.acad34p-2, INEXACT)
T(RN,  0x1.81c7f7c268b41p+631,    0x1.f05469d410d12p-1,   0x1.db5982p-3, INEXACT)
T(RN,  0x1.e51c755a3aa36p+631,    0x1.45ea1c943a9f9p-1,   0x1.d9a064p-2, INEXACT)
T(RN,  0x1.433c101ad7016p+631,   -0x1.f656dd40bd0a8p-1,  -0x1.c8f266p-3, INEXACT)
T(RN,  0x1.dde1b17fcb03ep+631,    -0x1.cc36a43eb56bp-1,  -0x1.43cff8p-2, INEXACT)
T(RN,  0x1.8b561bce4d378p+631,    -0x1.a0d6efb83749p-5,  -0x1.b01c24p-2, INEXACT)
T(RN,  0x1.5388be38527bcp+631,    0x1.44ba4f045b10fp-1,   0x1.e4aa12p-4, INEXACT)
T(RN,  0x1.2716ea785f836p+631,    -0x1.16ba9b3b9e7bp-2,   -0x1.412dap-4, INEXACT)
T(RN,  0x1.c208e17807c28p+631,    0x1.b37e74c99e256p-7,   0x1.d39feap-3, INEXACT)
T(RN,  0x1.03e5ff6fb0d41p+631,   -0x1.d61ac44301f1dp-1,   0x1.b5e9aep-5, INEXACT)
T(RN,   0x1.fc145c783e1dp+631,   -0x1.5725aed990255p-1,  -0x1.df5bdap-2, INEXACT)
T(RN,  0x1.72c7a2a865c11p+632,   -0x1.192e4006ef744p-1,   -0x1.7cb52p-2, INEXACT)
T(RN,  0x1.db14dec049caap+632,     0x1.e77951bfe3d9p-1,  -0x1.750b0ep-2, INEXACT)
T(RN,  0x1.ae23e2e069148p+632,    0x1.ff782328d2d59p-1,   0x1.44a60cp-4, INEXACT)
T(RN,  0x1.ab8b3e84de80cp+632,   -0x1.ea38269227b05p-1,  -0x1.41df1cp-2, INEXACT)
T(RN,  0x1.30c7decf47e2ap+632,    0x1.300718af55c9fp-4,  -0x1.60aacap-2, INEXACT)
T(RN,  0x1.1e7326a440d16p+632,   -0x1.c02de1edd5272p-1,  -0x1.ef584cp-2, INEXACT)
T(RN,  0x1.719c7cbe11974p+632,    -0x1.2b2b84039913p-2,  -0x1.4f4334p-3, INEXACT)
T(RN,  0x1.1ff93e0137ccdp+632,    0x1.9a6c4feb8e673p-5,   0x1.b0f242p-2, INEXACT)
T(RN,  0x1.806738fc04b5cp+632,    0x1.9ff4f67cd668ap-1,   0x1.9ac372p-2, INEXACT)
T(RN,   0x1.6a9d08a5844bp+632,    0x1.b3bb0443a9b01p-1,   -0x1.4528ap-4, INEXACT)
T(RN,   0x1.9eacfaa21686p+633,   -0x1.90544558381c9p-4,    0x1.9ef6bp-3, INEXACT)
T(RN,  0x1.377c950d3d95cp+633,   -0x1.12853193f9998p-1,   0x1.de175ap-2, INEXACT)
T(RN,  0x1.73e87bf265541p+633,   -0x1.d4d711afad5bbp-2,  -0x1.a70d84p-3, INEXACT)
T(RN,  0x1.f1ed583b442b4p+633,     0x1.64f1b09ef017p-1,   0x1.956314p-3, INEXACT)
T(RN,  0x1.cdfeb5f93e0cap+633,    0x1.f47e1f187b965p-1,    0x1.76e5cp-3, INEXACT)
T(RN,  0x1.5ea71e9f3faffp+633,    0x1.26f54feb1d95dp-4,  -0x1.604de4p-2, INEXACT)
T(RN,  0x1.3e670903a5236p+633,    0x1.d5cbe72c4908fp-1,   -0x1.4b52dp-7, INEXACT)
T(RN,  0x1.92359ddda05dap+633,    0x1.898e5dceb57fep-1,  -0x1.f5c706p-2, INEXACT)
T(RN,   0x1.a324b66b0ceap+633,    0x1.a678a23dbe646p-1,    0x1.dc24dp-5, INEXACT)
T(RN,  0x1.95202d2d2a748p+633,    -0x1.9c9bc35ecadap-1,   0x1.f49552p-3, INEXACT)
T(RN,  0x1.20f7585970ad5p+634,   -0x1.1dbf75afb444bp-1,    0x1.e4165p-6, INEXACT)
T(RN,  0x1.adb4afe743d65p+634,    0x1.f8f65794863dfp-1,   -0x1.a1681p-2, INEXACT)
T(RN,  0x1.25d552c41d212p+634,   -0x1.7662e351a3334p-2,  -0x1.bddf6cp-5, INEXACT)
T(RN,  0x1.452160ea5bdbap+634,    0x1.38fefdc16dd92p-4,   -0x1.93455p-2, INEXACT)
T(RN,  0x1.5979b6769f55bp+634,    0x1.74076c124ebafp-1,  -0x1.e5714ep-2, INEXACT)
T(RN,  0x1.476bf22ebd5ccp+634,    0x1.e69b52dee5d8ep-3,    0x1.dfd0fp-4, INEXACT)
T(RN,  0x1.cd952ca87ffeep+634,    0x1.ad117e2213e9ep-3,   0x1.eed07ep-3, INEXACT)
T(RN,  0x1.4cc1dc866c4cep+634,   -0x1.0aede697849f8p-1,   -0x1.028cdp-2, INEXACT)
T(RN,  0x1.2886a77a61191p+634,   -0x1.b6540cd530205p-1,   -0x1.53793p-2, INEXACT)
T(RN,  0x1.15156f128600dp+634,    0x1.ade24d4963b43p-2,  -0x1.a9ded4p-2, INEXACT)
T(RN,  0x1.6ee3f5f09dc3dp+635,   -0x1.23bd803fbd315p-7,  -0x1.86bb42p-2, INEXACT)
T(RN,  0x1.77852a5f7d12bp+635,     -0x1.026375f60ecp-1,   0x1.b3a54cp-2, INEXACT)
T(RN,  0x1.1fdd4ef4efc21p+635,   -0x1.89d7cc5ecea04p-3,  -0x1.6d54b8p-3, INEXACT)
T(RN,   0x1.562d8f7d1fabp+635,   -0x1.e74c67fa5d569p-1,  -0x1.4d2236p-4, INEXACT)
T(RN,  0x1.c154800dd8ddap+635,    0x1.aa9e99a196053p-1,   -0x1.e3a86p-2, INEXACT)
T(RN,  0x1.bf6ebb1d6c3aap+635,   -0x1.29934d4500b1cp-1,   -0x1.84e15p-3, INEXACT)
T(RN,  0x1.2619d46ebb2eap+635,    -0x1.94ee6f485f75p-1,   0x1.ff396ep-2, INEXACT)
T(RN,  0x1.d77d2d872a0a6p+635,    0x1.f961eead2e01fp-1,   0x1.9cf892p-2, INEXACT)
T(RN,  0x1.c7d5c037c1f22p+635,    0x1.bad65c03c6d65p-1,   0x1.b2e582p-4, INEXACT)
T(RN,  0x1.e1c4f85a0b08ap+635,   -0x1.1e2bf20286b36p-1,   0x1.001dd2p-6, INEXACT)
T(RN,  0x1.d4c61d25492d9p+636,    0x1.f0e0e2c41149bp-3,  -0x1.b1a12ep-3, INEXACT)
T(RN,  0x1.7f7277acd024cp+636,   -0x1.eb0e6786c53c6p-1,  -0x1.b0d40ep-3, INEXACT)
T(RN,  0x1.a31a65e6e4032p+636,   -0x1.895396559a537p-3,  -0x1.b12b06p-5, INEXACT)
T(RN,  0x1.efd268c7f0673p+636,   -0x1.ebcc101ae2099p-1,   0x1.ad2f6ep-4, INEXACT)
T(RN,  0x1.9192a2d407456p+636,   -0x1.a975df8629d55p-2,  -0x1.2f04a8p-4, INEXACT)
T(RN,  0x1.d53de62200f9ap+636,   -0x1.95eb73d9d006dp-1, -0x1.bdcb58p-12, INEXACT)
T(RN,  0x1.38fad7c4265dcp+636,   -0x1.fe021945a2a8ep-1,  -0x1.37bc48p-3, INEXACT)
T(RN,  0x1.8082e10f69d38p+636,     0x1.83275281d8f4p-1,  -0x1.5280c4p-2, INEXACT)
T(RN,  0x1.82a3342a36fa6p+636,   -0x1.fe70910f1b72ap-1,  -0x1.8d1c1ep-2, INEXACT)
T(RN,  0x1.20f744944eb5dp+636,    0x1.ba173272da464p-1,   0x1.bce4b8p-2, INEXACT)
T(RN,  0x1.a8a2bcae46f0bp+637,   -0x1.961b5cc67494cp-3,   0x1.9cb8fap-2, INEXACT)
T(RN,  0x1.39c2f6f49f59ep+637,   -0x1.7d82f4be80cffp-2,   0x1.967682p-2, INEXACT)
T(RN,  0x1.d53734f129788p+637,   -0x1.9666d3d11444ap-1,   0x1.e0cda6p-2, INEXACT)
T(RN,  0x1.818964fd283dap+637,    0x1.c9cea417f5243p-1,  -0x1.ec5872p-4, INEXACT)
T(RN,  0x1.d852f7ba225ccp+637,    0x1.552edabf8bf5bp-1,  -0x1.02535cp-4, INEXACT)
T(RN,  0x1.9e0d2f74b2ab8p+637,    0x1.e43e94d72111dp-1,   -0x1.5a7a2p-6, INEXACT)
T(RN,  0x1.3adc2188e6a44p+637,    0x1.18b33f8ec980bp-3,  -0x1.76c36cp-4, INEXACT)
T(RN,  0x1.f39a1ce3dbb9fp+637,    0x1.a6e1666af45b9p-1,  -0x1.1ae4c4p-2, INEXACT)
T(RN,  0x1.c874fc4f6cc1ap+637,    0x1.bbee8d38297a8p-1,   0x1.2ab0c6p-3, INEXACT)
T(RN,  0x1.b9b390b6dc2a6p+637,    0x1.fbc2220271f6fp-1,  -0x1.7b4cd2p-2, INEXACT)
T(RN,  0x1.d2b3d52cc3cfep+638,    0x1.e1f4f00ab5173p-2,   0x1.60aaaap-3, INEXACT)
T(RN,  0x1.7b48493ee0c66p+638,   -0x1.bcadce0186c04p-1,   0x1.a571fap-6, INEXACT)
T(RN,  0x1.29d2b4eb2a5f1p+638,    0x1.13afea9b1526fp-1,  -0x1.968228p-4, INEXACT)
T(RN,  0x1.40d64ba7ef926p+638,    0x1.e5a124975bebap-1,   0x1.c54cfcp-3, INEXACT)
T(RN,  0x1.6fba6dc1f835ep+638,   -0x1.e06f3e1ef17f7p-1,    0x1.22957p-2, INEXACT)
T(RN,  0x1.7a4312d880912p+638,    0x1.08de53d966e93p-2,   0x1.ee3b14p-3, INEXACT)
T(RN,  0x1.29abe3951e8fep+638,    0x1.440febc031aa4p-1,  -0x1.8edff6p-2, INEXACT)
T(RN,   0x1.4bec99898573p+638,   -0x1.fef18590f966dp-1,  -0x1.07a766p-4, INEXACT)
T(RN,  0x1.74fc26f26cda1p+638,   -0x1.c85d367ea00acp-1,    0x1.bba5fp-5, INEXACT)
T(RN,  0x1.a74a27ae351d4p+638,   -0x1.1b278cdcd6839p-1,   -0x1.872a7p-3, INEXACT)
T(RN,  0x1.d73d6015b79a2p+639,   -0x1.7841d09dc581dp-1,   0x1.03ba04p-3, INEXACT)
T(RN,  0x1.6a594392a031cp+639,    0x1.ff9bad5d6dff6p-1,  -0x1.08f82cp-2, INEXACT)
T(RN,  0x1.3caebb369bb81p+639,    0x1.abcdcb9a130a1p-1,   0x1.395268p-2, INEXACT)
T(RN,  0x1.a244f00c386e2p+639,   -0x1.fbf3f6ca6df36p-1,  -0x1.9f9224p-4, INEXACT)
T(RN,  0x1.2f47a53a6eb33p+639,    0x1.9572f262e44bcp-1,  -0x1.765898p-2, INEXACT)
T(RN,  0x1.90d7221bd58a3p+639,   -0x1.6a6276ef511b2p-2,   0x1.0ed5f4p-2, INEXACT)
T(RN,    0x1.bd232c9a26ep+639,     0x1.e4fbdb512b6bp-1,   0x1.c2106ap-2, INEXACT)
T(RN,  0x1.7100f7c2ad0dbp+639,   -0x1.ca69c81bb523bp-1,  -0x1.5d9e1ep-6, INEXACT)
T(RN,  0x1.3c0081874c1fcp+639,    0x1.d4c39e2c524eep-1,    0x1.b8f59p-3, INEXACT)
T(RN,  0x1.f1fe7e86a9ab4p+639,   -0x1.2e4bea5a5d944p-2,   0x1.314706p-3, INEXACT)
T(RN,  0x1.341ffaec7c854p+640,   -0x1.d26845a842bffp-1,   0x1.350d7ep-2, INEXACT)
T(RN,    0x1.b5ac0935c14p+640,   -0x1.79a24d6b45094p-1,   0x1.adf69ap-4, INEXACT)
T(RN,  0x1.3cce3a04e3fedp+640,   -0x1.5a12d5e34e552p-1,  -0x1.c9d1fcp-2, INEXACT)
T(RN,  0x1.b65cddc1cf738p+640,    0x1.f295fd26e7f9ap-1,  -0x1.d9f864p-3, INEXACT)
T(RN,  0x1.9819bdf02dfe1p+640,    0x1.e940af89a883bp-3,  -0x1.c71f88p-2, INEXACT)
T(RN,  0x1.7813ee3e1f6b7p+640,   -0x1.fd9d20e0b0fffp-1,  -0x1.2d094cp-2, INEXACT)
T(RN,  0x1.be4ed9f889ca1p+640,    0x1.61035dfb84dadp-1,  -0x1.345dfep-2, INEXACT)
T(RN,  0x1.4ee4a78f805dep+640,   -0x1.301568e1af2b7p-1,   0x1.659282p-3, INEXACT)
T(RN,  0x1.68ea7456303e5p+640,    0x1.ff788ce83341fp-1,  -0x1.4b62a2p-2, INEXACT)
T(RN,  0x1.26a7ae11a427bp+640,    -0x1.dbdf5c71d692p-1,   0x1.d63f6ep-2, INEXACT)
T(RN,  0x1.39e7fc1cdb562p+641,    -0x1.6f1d1f497e97p-3,  -0x1.862608p-4, INEXACT)
T(RN,  0x1.541d13686d5f4p+641,    0x1.ec9ff2bcb36adp-1,   0x1.7cdb58p-4, INEXACT)
T(RN,  0x1.3326666f77ff2p+641,   -0x1.e6be05f02a85cp-1,   0x1.8f524ep-2, INEXACT)
T(RN,  0x1.b159c72de95dap+641,   -0x1.a979af489f698p-5,  -0x1.e89c6ep-2, INEXACT)
T(RN,  0x1.7bec2702878c3p+641,     0x1.3c19c320cf13p-2,  -0x1.3ea788p-4, INEXACT)
T(RN,  0x1.31deaa0c3419dp+641,    0x1.37b32aa582f41p-1,   0x1.1404a4p-2, INEXACT)
T(RN,  0x1.a10973e15e48ep+641,    0x1.81f35a406cae6p-1,   0x1.58dfcap-2, INEXACT)
T(RN,  0x1.43653960910dbp+641,    0x1.d16e50ba9d6a8p-6,   0x1.e3ac76p-4, INEXACT)
T(RN,   0x1.6cb1d6cfb063p+641,   -0x1.2a893fdf54cbfp-4,   0x1.99c03ap-2, INEXACT)
T(RN,  0x1.489a896267fa3p+641,   -0x1.4fb2bf0ce46ecp-1,   0x1.32d38ap-4, INEXACT)
T(RN,  0x1.6ac9c864f321ap+642,    0x1.cf5a9d09b3899p-2,   0x1.e05876p-2, INEXACT)
T(RN,  0x1.19146ad79aeacp+642,   -0x1.b6db58abb13a6p-2,  -0x1.52c826p-2, INEXACT)
T(RN,  0x1.d3a536b7dd288p+642,    0x1.4a01c148cab8fp-2,  -0x1.c9ed2ep-2, INEXACT)
T(RN,  0x1.653b6d8d20598p+642,   -0x1.c56a183057a8ap-1,   0x1.a78672p-3, INEXACT)
T(RN,  0x1.4423cef227617p+642,    0x1.88d54ab24c6f1p-1,  -0x1.cdd7ecp-2, INEXACT)
T(RN,  0x1.4f25974c3692ap+642,      0x1.24addb5479dp-5,   0x1.795c8ep-2, INEXACT)
T(RN,  0x1.10e4a6e2b7f42p+642,    -0x1.607b5ed92cd2p-2,  -0x1.c12172p-3, INEXACT)
T(RN,  0x1.442d48bfbbaecp+642,    0x1.aaea801f1b79ap-1,   -0x1.90fadp-2, INEXACT)
T(RN,  0x1.bd57b44232feap+642,     0x1.ed7d31520483p-1,  -0x1.ff7876p-7, INEXACT)
T(RN,  0x1.ea491b3f60b9cp+642,   -0x1.ebb7adea69b17p-2,  -0x1.c0b634p-3, INEXACT)
T(RN,  0x1.08654adfbc4cap+643,     0x1.4fcc4e48f0adp-1,   0x1.6867d2p-2, INEXACT)
T(RN,  0x1.4a41c6bd16873p+643,    0x1.fd5576af00c1ap-1,  -0x1.508596p-5, INEXACT)
T(RN,  0x1.fa338d8c1a2dap+643,   -0x1.cd6fc3e882ca4p-1,   -0x1.dbaf5p-5, INEXACT)
T(RN,  0x1.1f3189d40cf9ap+643,   -0x1.acae1a5999898p-1,  -0x1.dfd41cp-2, INEXACT)
T(RN,  0x1.47248b1aa5f4cp+643,   -0x1.dc3df4888ad7fp-4,  -0x1.df729ep-4, INEXACT)
T(RN,   0x1.7d0ab5d441a5p+643,    0x1.ccc22b6c6bd82p-1,  -0x1.083f26p-7, INEXACT)
T(RN,  0x1.b244cad483b3ap+643,   -0x1.fefdded08dc17p-1,  -0x1.fecfb6p-3, INEXACT)
T(RN,  0x1.c3ca91cfaaba2p+643,    0x1.75605e1f75315p-1,   0x1.d8d608p-3, INEXACT)
T(RN,  0x1.5c119bda8aa04p+643,    -0x1.52daa0e09e4dp-1,  -0x1.dec3ecp-4, INEXACT)
T(RN,  0x1.9135dee9db3f4p+643,    0x1.391d56c41b031p-3,  -0x1.384d24p-3, INEXACT)
T(RN,  0x1.09f95f6b97bedp+644,    0x1.b052e7eeb74cep-2,  -0x1.258ff4p-5, INEXACT)
T(RN,  0x1.ef97446027338p+644,   -0x1.4e0b372eba29cp-7,  -0x1.b26efap-3, INEXACT)
T(RN,  0x1.66171a0e03acbp+644,    0x1.83cfbc98c1dc5p-1,   0x1.e7984cp-2, INEXACT)
T(RN,  0x1.9cb2e247f05acp+644,   -0x1.3be4b22cad98cp-1,  -0x1.814366p-3, INEXACT)
T(RN,   0x1.67740cb30d77p+644,    0x1.c2d78bc1e6df7p-2,   -0x1.a5605p-2, INEXACT)
T(RN,  0x1.1de3ad53943f9p+644,    0x1.87c51a0091535p-1,   0x1.979926p-2, INEXACT)
T(RN,  0x1.a4976523fdaf2p+644,    0x1.ecaac642fd1aap-1,   -0x1.9b45dp-2, INEXACT)
T(RN,  0x1.a977dbd8c019cp+644,   -0x1.656bafc2d9252p-1,   0x1.710356p-3, INEXACT)
T(RN,  0x1.e41270c3d26a8p+644,    0x1.9bcecdf984fd4p-1,   0x1.357698p-2, INEXACT)
T(RN,  0x1.078d50cd53cb8p+644,    0x1.cd27f9178080bp-1,  -0x1.fc3794p-2, INEXACT)
T(RN,  0x1.e46a26a8c351ap+645,   -0x1.db8d851bc116dp-2,  -0x1.a031d8p-3, INEXACT)
T(RN,  0x1.86eb237dfe862p+645,    0x1.ff4b9a25021fep-1,   0x1.4f3616p-4, INEXACT)
T(RN,  0x1.3bfbfc2e1211ap+645,    0x1.2a62430201fd1p-4,   0x1.4e408ep-2, INEXACT)
T(RN,  0x1.c9249efae633ep+645,    0x1.574c569e6b151p-1,  -0x1.5ce446p-5, INEXACT)
T(RN,  0x1.c68d855c0a6a3p+645,   -0x1.3f66e4c893e6bp-1,   0x1.7c6d5ap-2, INEXACT)
T(RN,  0x1.b1058f1dc206fp+645,   -0x1.a8a1d90d913dap-9,   0x1.eb187ep-3, INEXACT)
T(RN,  0x1.e1c8714f0b56cp+645,   -0x1.ae2bba2869a2dp-1,  -0x1.1194f2p-2, INEXACT)
T(RN,  0x1.b8cb74a5a2cb7p+645,    0x1.10d644d1aa882p-3,  -0x1.7a6d42p-2, INEXACT)
T(RN,  0x1.4992a509f4a53p+645,    0x1.ee66b9407f9d1p-1,   0x1.c70e9ep-4, INEXACT)
T(RN,  0x1.0e7803bcf81acp+645,    0x1.56867324474d3p-1,  -0x1.06056cp-3, INEXACT)
T(RN,  0x1.12e8e0311d2f7p+646,    0x1.8861323adfe94p-2,   0x1.123698p-3, INEXACT)
T(RN,  0x1.ad45c9a4c10aap+646,    0x1.e5eaae3f5b18ap-1,  -0x1.5619ccp-2, INEXACT)
T(RN,  0x1.b3c096cd183bfp+646,    0x1.ccd743276eaa1p-3,  -0x1.50d9c2p-3, INEXACT)
T(RN,  0x1.2ea32d5f8a7d4p+646,    0x1.e0d15dacea017p-1,   0x1.ce5e2cp-2, INEXACT)
T(RN,  0x1.6146c13840719p+646,    0x1.38cc85be1c36ap-1,   0x1.ce06d2p-2, INEXACT)
T(RN,  0x1.845e53059e5cfp+646,    0x1.685bc2afc3bffp-1,   0x1.58f088p-2, INEXACT)
T(RN,  0x1.c9d2f8a0ced32p+646,   -0x1.5e0621466c7afp-1,   0x1.27194ep-2, INEXACT)
T(RN,  0x1.7f066d9a2e4e2p+646,    0x1.710c788a06299p-3,   -0x1.4873cp-6, INEXACT)
T(RN,  0x1.ecd6afe325bf2p+646,    0x1.31994c8b33172p-1,  -0x1.b9148ep-3, INEXACT)
T(RN,  0x1.acd210be683c4p+646,    0x1.ff7e8ddced0c8p-1,  -0x1.b55bbap-2, INEXACT)
T(RN,  0x1.050ad89ec53fbp+647,    0x1.88a32c99bc332p-1,   0x1.1a8316p-6, INEXACT)
T(RN,  0x1.199863e1720e7p+647,    -0x1.ff9a7de39036p-1,   -0x1.8923dp-2, INEXACT)
T(RN,  0x1.ad75f41fcfeefp+647,   -0x1.4aa3be8109634p-1,   0x1.42a492p-3, INEXACT)
T(RN,  0x1.0e8785a4cee7fp+647,    0x1.fe957923fd75ap-1,   0x1.d2ee76p-4, INEXACT)
T(RN,  0x1.0d2f665d92f7ep+647,   -0x1.a16421881d8c2p-2,   0x1.d9802cp-3, INEXACT)
T(RN,  0x1.c8da8960ecfeep+647,   -0x1.45a1332096d22p-4,   0x1.73c282p-3, INEXACT)
T(RN,  0x1.c5e7fc4322ee9p+647,   -0x1.ff368060176adp-1,   0x1.916042p-4, INEXACT)
T(RN,  0x1.3b622ff1579dep+647,   -0x1.e2d06a46f53dep-1,  -0x1.44b882p-4, INEXACT)
T(RN,  0x1.563f0aaacbdaap+647,   -0x1.1288df45a835fp-3,  -0x1.06ca84p-2, INEXACT)
T(RN,  0x1.3d3a988fd12b6p+647,   -0x1.bd24c5443162dp-1,   0x1.e1c59ep-3, INEXACT)
T(RN,  0x1.824a395f86ee8p+648,   -0x1.21e85efcb8076p-2,  -0x1.82bd4cp-3, INEXACT)
T(RN,  0x1.4e3befe255418p+648,   -0x1.5edd146a56752p-1,  -0x1.378abep-2, INEXACT)
T(RN,  0x1.2254d2ac86ac9p+648,    0x1.faef533cad33ep-1,  -0x1.6be52cp-2, INEXACT)
T(RN,  0x1.51b12e9654009p+648,   -0x1.fd8c6e71cc0e6p-1,  -0x1.2ccae2p-2, INEXACT)
T(RN,  0x1.32b163b797507p+648,    0x1.d07e5dadca32ep-1,   0x1.7f76dep-2, INEXACT)
T(RN,  0x1.ae037336b1d23p+648,   -0x1.6accfc8ef067ep-1,   0x1.9dfe6ep-3, INEXACT)
T(RN,  0x1.59ae7a7c0582ep+648,    0x1.b8ab623565803p-1,   0x1.f78d98p-5, INEXACT)
T(RN,  0x1.d02f2a6ee342cp+648,   -0x1.2c560896c8cacp-2,  -0x1.5839ccp-3, INEXACT)
T(RN,  0x1.2025ec8d67cf6p+648,   -0x1.a798f6cd297cap-1,  -0x1.4ca8bap-3, INEXACT)
T(RN,  0x1.f65a3336661fcp+648,   -0x1.ff9fca4c3eb96p-1,  -0x1.bf1b4cp-2, INEXACT)
T(RN,  0x1.615eefb0ac894p+649,    0x1.fd065d34d70acp-1,   0x1.77e3a6p-4, INEXACT)
T(RN,  0x1.b834969dfeeacp+649,    0x1.5c2464d4e3188p-1,   0x1.c26ec6p-4, INEXACT)
T(RN,  0x1.9711f016e8d7ap+649,    0x1.4f511082182ffp-1,  -0x1.534244p-2, INEXACT)
T(RN,  0x1.cdbcea3a2eb8ap+649,    0x1.c4d90af2d7498p-2,   -0x1.311d5p-2, INEXACT)
T(RN,  0x1.7e40cde9a73aap+649,    0x1.fab57d22fa0eap-1,  -0x1.af007cp-3, INEXACT)
T(RN,  0x1.3c2e3f7d93ef2p+649,    0x1.995aace14706ep-3,  -0x1.616222p-2, INEXACT)
T(RN,  0x1.ad97b19ae2272p+649,    0x1.16319c3931d9dp-1,   0x1.f56b48p-2, INEXACT)
T(RN,  0x1.b60035586e8bap+649,    0x1.5caa86317246ep-3,  -0x1.6ed464p-3, INEXACT)
T(RN,  0x1.d3d7a137a6e78p+649,    0x1.f9ee4491460d9p-1,  -0x1.1b3c2cp-3, INEXACT)
T(RN,  0x1.53bb52ec423f8p+649,   -0x1.cbf000aa1633dp-1,  -0x1.8e4076p-2, INEXACT)
T(RN,  0x1.2069958387a21p+650,   -0x1.fc8cdb5e28036p-1,  -0x1.09d98ap-3, INEXACT)
T(RN,  0x1.512e08a13a414p+650,    0x1.71c21d4205d47p-2,  -0x1.8d52e6p-2, INEXACT)
T(RN,  0x1.8f029cedb06aep+650,   -0x1.fbe16fb1cbaaep-1,   0x1.b3640cp-3, INEXACT)
T(RN,  0x1.906c1c35c9bd2p+650,   -0x1.c42c4688ffb41p-1,    0x1.16336p-2, INEXACT)
T(RN,  0x1.49a3bc5e023a2p+650,   -0x1.9914be93e6246p-1,   0x1.208c28p-2, INEXACT)
T(RN,  0x1.70b77d69e436ap+650,    0x1.fbe969aa6fdbep-1,   0x1.862238p-2, INEXACT)
T(RN,  0x1.632bcd3cc9e53p+650,   -0x1.fa9a0839ca315p-1,  -0x1.031aacp-2, INEXACT)
T(RN,  0x1.ee46b324126a6p+650,    -0x1.3769c4842b24p-3,   0x1.d33962p-4, INEXACT)
T(RN,   0x1.11e26b14b85bp+650,    0x1.00a4c26d0f73bp-1,   0x1.4e1c76p-2, INEXACT)
T(RN,  0x1.5b62d86546559p+650,    0x1.d00d4f25835dbp-3,  -0x1.6a78acp-3, INEXACT)
T(RN,   0x1.bd9a4a206456p+651,   -0x1.d3a204a54c88ep-5,   0x1.5b2614p-2, INEXACT)
T(RN,  0x1.fe852de709ce6p+651,   -0x1.c96fb2c0b5f39p-1,  -0x1.706decp-2, INEXACT)
T(RN,  0x1.b6920378ec71bp+651,    0x1.8756dbfb760eep-2,   -0x1.6955ap-4, INEXACT)
T(RN,  0x1.39f60b22f76f6p+651,   -0x1.3f95859412e3cp-1,   0x1.69b6f4p-2, INEXACT)
T(RN,   0x1.ef3b1d531979p+651,    0x1.9720fa1d6285fp-1,   -0x1.22a78p-5, INEXACT)
T(RN,  0x1.c301d1ae413d6p+651,   -0x1.e716f7de7fd5fp-2,   0x1.5985c8p-3, INEXACT)
T(RN,  0x1.de0be321ec146p+651,   -0x1.df8a97406c3aap-3,   0x1.e2778ep-2, INEXACT)
T(RN,  0x1.5df22b8d749cap+651,    0x1.ff3d11763795bp-1,   0x1.5d3d2ap-3, INEXACT)
T(RN,  0x1.d49531b2b1755p+651,   -0x1.f80fadcc0cc7ap-5,   0x1.3ea36ap-6, INEXACT)
T(RN,  0x1.f32ecd9d0804ep+651,   -0x1.6029874d6e1b4p-1,  -0x1.f42fe2p-2, INEXACT)
T(RN,  0x1.42241b2efa02cp+652,   -0x1.e78e6b23c11c6p-1,  -0x1.9d7bb4p-2, INEXACT)
T(RN,  0x1.0ef3c800f8981p+652,    0x1.f06419175f636p-1,   0x1.75d7bcp-3, INEXACT)
T(RN,  0x1.d1d7453ddab44p+652,    0x1.3e8f8d756ec59p-2,  -0x1.a892f4p-3, INEXACT)
T(RN,   0x1.e85aaf1222f8p+652,   -0x1.8eaec7c72874bp-2,   0x1.34de96p-5, INEXACT)
T(RN,  0x1.36d32a9fe9fc5p+652,   -0x1.f9defa989e848p-1,  -0x1.239522p-3, INEXACT)
T(RN,  0x1.ff703a0d44b28p+652,    0x1.729a6aa774145p-1,     0x1.7b44p-4, INEXACT)
T(RN,  0x1.00a99be528089p+652,    0x1.d951fe7688a57p-2,  -0x1.449ff8p-4, INEXACT)
T(RN,  0x1.811cb9679c4dcp+652,    0x1.fe4d85b05b603p-5,  -0x1.3fb24ep-2, INEXACT)
T(RN,  0x1.f8a3a7df43ff3p+652,    0x1.0fcd956e663f1p-1,    0x1.7b24ep-2, INEXACT)
T(RN,  0x1.8c7d4003a0e2dp+652,   -0x1.e5673f53c38e2p-1,  -0x1.423684p-4, INEXACT)
T(RN,  0x1.07984cc3f7356p+653,    -0x1.ceaa26789253p-1,  -0x1.fd6a86p-4, INEXACT)
T(RN,   0x1.b5afd3d72c4cp+653,   -0x1.8e2fb653194d6p-1,   0x1.95713ap-2, INEXACT)
T(RN,  0x1.35c5a01913421p+653,   -0x1.fe77eed9367dap-1,   0x1.9c6454p-5, INEXACT)
T(RN,  0x1.dc67d43f82628p+653,   -0x1.596204cf59e0fp-1,   0x1.c1bed6p-3, INEXACT)
T(RN,  0x1.9f684056df058p+653,    0x1.12d2acb6f20b8p-2,   0x1.210128p-7, INEXACT)
T(RN,   0x1.4074f1a345aap+653,    0x1.4f6903dd52c58p-5,   0x1.be8d4ap-3, INEXACT)
T(RN,  0x1.7744cc9a5f8a1p+653,   -0x1.7067fdd0967a5p-4,   0x1.2d78a2p-4, INEXACT)
T(RN,  0x1.9d5232b0b6fdap+653,   -0x1.0aa49fa741a3cp-1,   0x1.a75ac4p-2, INEXACT)
T(RN,  0x1.44987e09b340bp+653,    0x1.42001b8c3ddb1p-1,   0x1.cd112ap-2, INEXACT)
T(RN,  0x1.3d09a8237154cp+653,    -0x1.9ffd18cf16bbp-1,   0x1.503678p-2, INEXACT)
T(RN,  0x1.f4bfe48e79cc4p+654,    0x1.111df769b0eeep-2,   0x1.cebed6p-4, INEXACT)
T(RN,  0x1.2321f442bd50dp+654,    0x1.7411649eec934p-2,   0x1.364718p-4, INEXACT)
T(RN,  0x1.ef512297ca76ep+654,    0x1.01dbc284830f4p-3,    0x1.b715cp-2, INEXACT)
T(RN,  0x1.68f912060a1f6p+654,   -0x1.bb511c1337451p-1,   0x1.7acb04p-2, INEXACT)
T(RN,  0x1.e65be1e6d7da6p+654,    0x1.17d1763cbd0f7p-2,  -0x1.07ab9ep-2, INEXACT)
T(RN,  0x1.31c458dbc4188p+654,   -0x1.d94d704f1a455p-1,   0x1.fda414p-2, INEXACT)
T(RN,  0x1.e0f296a6cbdaep+654,    0x1.5b54a1789c366p-4,   0x1.95654ep-2, INEXACT)
T(RN,  0x1.de5b81d5ba1dap+654,    -0x1.cb55c9643a39p-3,  -0x1.f95672p-3, INEXACT)
T(RN,   0x1.ca0eee236b9dp+654,     0x1.98588ba705e3p-2,   0x1.099558p-2, INEXACT)
T(RN,  0x1.e0222e995dd9ap+654,    0x1.5eeb4dfc7dce8p-1,   0x1.2e2116p-4, INEXACT)
T(RN,  0x1.69a916673a35cp+655,   -0x1.dab7ed2dcb24fp-1,   0x1.8b7c2cp-2, INEXACT)
T(RN,  0x1.0c4ff20f24d6fp+655,    0x1.feb9ed557704cp-1,   0x1.759cf8p-2, INEXACT)
T(RN,  0x1.780db41e0eb6fp+655,   -0x1.6d1b03f8793b8p-1,   0x1.dd2bf4p-4, INEXACT)
T(RN,  0x1.257190367f665p+655,   -0x1.6abb66cb69e72p-1,  -0x1.f520f6p-2, INEXACT)
T(RN,  0x1.ae838de9fb3ecp+655,    0x1.d1d8bf641f5fcp-1,   0x1.2c8baap-2, INEXACT)
T(RN,  0x1.3579f8d8b8e64p+655,   -0x1.fa44055189445p-1,   0x1.2008ccp-3, INEXACT)
T(RN,  0x1.74c108f25bb71p+655,   -0x1.fbf7be643955fp-1,  -0x1.e4c19ap-4, INEXACT)
T(RN,  0x1.7d73224d7eb2bp+655,   -0x1.ff8c282c214dbp-1,  -0x1.a33ef2p-4, INEXACT)
T(RN,  0x1.7b1d849732e1ap+655,   -0x1.ebbb5de72f7ebp-1,   0x1.4d3f26p-4, INEXACT)
T(RN,  0x1.318253cb387f7p+655,   -0x1.ffe36572c3dc1p-1,   0x1.926e9ep-4, INEXACT)
T(RN,  0x1.f1d9313b97d44p+656,     0x1.fd8b12f6e95dp-1,   0x1.87d50cp-3, INEXACT)
T(RN,  0x1.a2ba356f2c5fep+656,   -0x1.40409d31f17c5p-7,  -0x1.5b7624p-4, INEXACT)
T(RN,  0x1.43b6e6af44e56p+656,   -0x1.ed1afea237945p-1,   0x1.104624p-3, INEXACT)
T(RN,  0x1.5fe6af64461e5p+656,   -0x1.fadbba4995eb6p-1,   0x1.eb0116p-2, INEXACT)
T(RN,  0x1.36394548497bdp+656,    0x1.a12a3d5a7711ap-4,   0x1.4961e4p-2, INEXACT)
T(RN,     0x1.861a70c7d7p+656,    0x1.5bc74105f816ep-1,  -0x1.c82df6p-4, INEXACT)
T(RN,  0x1.b418cafa7ee0cp+656,   -0x1.d5c9e4bf7d40fp-1,  -0x1.590dfep-2, INEXACT)
T(RN,  0x1.ce63c73a2cd38p+656,   0x1.c64a46988fb2ap-12,   0x1.b6a3e8p-5, INEXACT)
T(RN,  0x1.4b1ad02d975bfp+656,    0x1.bf14a3c30ab77p-1,   0x1.d3b334p-2, INEXACT)
T(RN,  0x1.a5a3182f8386cp+656,    0x1.a4ec931c4e077p-1,   -0x1.61726p-2, INEXACT)
T(RN,  0x1.539660ab31f7ap+657,   -0x1.4d9dac4c95de8p-4,  -0x1.a116eep-2, INEXACT)
T(RN,   0x1.a65cbdf28b69p+657,   -0x1.5f4d175750261p-2,  -0x1.a64b2ap-7, INEXACT)
T(RN,  0x1.f1d7ca0b59cd2p+657,    0x1.52a2424b3d393p-1,   0x1.1cb516p-2, INEXACT)
T(RN,  0x1.469ca536e4188p+657,    0x1.281d37a8fe755p-4,    0x1.485f2p-3, INEXACT)
T(RN,  0x1.a17be71201123p+657,   -0x1.b10008b709ea9p-4,    0x1.87c7dp-4, INEXACT)
T(RN,  0x1.9e935acdde9f3p+657,    0x1.87cd50610e07ap-2,    0x1.4d9f6p-3, INEXACT)
T(RN,  0x1.a4e1d539feadap+657,   -0x1.f5aed3a0d4b9bp-1,   0x1.fb58e6p-4, INEXACT)
T(RN,  0x1.c151e9d4e6269p+657,   -0x1.7c4e9e1a194afp-3,   0x1.0a8268p-2, INEXACT)
T(RN,  0x1.159a46569d59cp+657,   -0x1.f23513a02db4fp-1,  -0x1.2c8a48p-2, INEXACT)
T(RN,  0x1.81b275a5f6b64p+657,    0x1.503dcc818de1ep-1,   0x1.2afd58p-4, INEXACT)
T(RN,  0x1.60d336dbdcf7fp+658,     0x1.a9e12a3ee315p-1,   0x1.8be6acp-4, INEXACT)
T(RN,   0x1.e18cbd878c57p+658,   -0x1.490f9fc904a1ep-1,  -0x1.1574f2p-2, INEXACT)
T(RN,  0x1.688b174732506p+658,    0x1.225dc542ab8d6p-2,  -0x1.448924p-2, INEXACT)
T(RN,  0x1.b0b871d7d03b3p+658,    0x1.e1306db96c2bbp-1,  -0x1.7e7d4ep-7, INEXACT)
T(RN,  0x1.1a363ce8b0851p+658,   -0x1.fa21feffb8ae4p-1,   0x1.214826p-3, INEXACT)
T(RN,  0x1.2a55c14363c54p+658,     0x1.fe21e5adee99p-1,  -0x1.6eb834p-3, INEXACT)
T(RN,  0x1.dde84d8b8ffe2p+658,   -0x1.46804097bcc12p-4,  -0x1.456fd8p-2, INEXACT)
T(RN,  0x1.3d5b59b1f5736p+658,   -0x1.69fbcdf0d0a65p-1,    0x1.4c8eap-2, INEXACT)
T(RN,  0x1.e90bb6a5f40f2p+658,    0x1.21109a5ecc0a4p-2,   0x1.013446p-4, INEXACT)
T(RN,  0x1.9f34f1171e518p+658,    -0x1.b85e0ad01635p-2,  -0x1.2613dcp-3, INEXACT)
T(RN,  0x1.174b1555d4771p+659,   -0x1.adbde13f92cc2p-4,  -0x1.c0294ep-3, INEXACT)
T(RN,  0x1.8576b39ac23c8p+659,   -0x1.19e383bb2a4c6p-1,   0x1.b1fd8ap-2, INEXACT)
T(RN,  0x1.b46853254a00bp+659,   -0x1.7542ef3fc182cp-1,  -0x1.131ae6p-4, INEXACT)
T(RN,  0x1.34c4474b49196p+659,    0x1.eede5bc3f45cap-2,   0x1.b19ac2p-3, INEXACT)
T(RN,   0x1.da158a25da4ap+659,    0x1.7e698f4131b0bp-4,  -0x1.6dcbcep-2, INEXACT)
T(RN,  0x1.303e9ae4e1184p+659,    0x1.1a4c48949c40cp-1,  -0x1.5196dep-3, INEXACT)
T(RN,  0x1.e9151712a561ap+659,    0x1.d5097fd7592ffp-1,   0x1.4d5d9ap-4, INEXACT)
T(RN,  0x1.06f020d0aadcep+659,   -0x1.9cf41f6245d63p-1,  -0x1.60b22cp-3, INEXACT)
T(RN,  0x1.92ef89fd92049p+659,     0x1.f21e159bc657p-2,   0x1.a952a8p-4, INEXACT)
T(RN,  0x1.537cd85bf1ec8p+659,   -0x1.caaa9db9b6fa9p-3,  -0x1.827e68p-2, INEXACT)
T(RN,  0x1.19d553651719dp+660,   -0x1.c78cef49f21fap-2,   0x1.2923ecp-2, INEXACT)
T(RN,  0x1.4eba497d525f8p+660,  -0x1.b8ab28745f953p-10,   0x1.234abep-7, INEXACT)
T(RN,  0x1.8ae8f4363202cp+660,    0x1.6ffc5d639d631p-2,   0x1.426758p-2, INEXACT)
T(RN,  0x1.540be251811bfp+660,    0x1.270d3faf068a3p-1,   0x1.13ce2ep-2, INEXACT)
T(RN,  0x1.ca40697fb313dp+660,   -0x1.d96aa1aeb424cp-1,    0x1.560a3p-2, INEXACT)
T(RN,  0x1.914e0fba2d059p+660,    0x1.340d9603b176bp-1,  -0x1.3b539cp-3, INEXACT)
T(RN,  0x1.3e697bac27448p+660,   -0x1.ad41f0fc7b764p-1,   -0x1.fa784p-2, INEXACT)
T(RN,  0x1.32f66d6e3d737p+660,   -0x1.d546d2e772548p-1,  -0x1.9c6892p-2, INEXACT)
T(RN,  0x1.634e48538aaa2p+660,    0x1.19139d1f3934ep-1,   0x1.e31ea6p-3, INEXACT)
T(RN,  0x1.c66ad5519c564p+660,   -0x1.27e4673d93eb3p-2,   0x1.af25fap-2, INEXACT)
T(RN,   0x1.cb4d02f91d04p+661,     0x1.6e33c9e65391p-2,   0x1.ed448ap-2, INEXACT)
T(RN,  0x1.7684cd26a9731p+661,   -0x1.95b56e9861c2dp-1,  -0x1.64df26p-5, INEXACT)
T(RN,  0x1.5e0ff5a0e5b63p+661,   -0x1.4e70a061ded98p-2,   -0x1.b1f9cp-3, INEXACT)
T(RN,  0x1.78acc8e37322bp+661,    -0x1.67508d085e21p-2,   -0x1.6fc14p-2, INEXACT)
T(RN,  0x1.f33f636ec4174p+661,   -0x1.a6af45f89b989p-6,   -0x1.5bccep-3, INEXACT)
T(RN,  0x1.832d02268f21cp+661,   -0x1.4e65fbf5e4d7dp-3,   0x1.646caep-2, INEXACT)
T(RN,  0x1.79b2b989a79d8p+661,    0x1.7cc7f9f05d976p-1,   0x1.52272ap-2, INEXACT)
T(RN,  0x1.233523e743a92p+661,    0x1.fee0947a7d893p-1,  -0x1.afb1f4p-4, INEXACT)
T(RN,  0x1.db26220669d44p+661,   -0x1.d818be36c38b5p-1,  -0x1.95ecdap-2, INEXACT)
T(RN,  0x1.1bb3b8c052cb4p+661,   -0x1.c240eb1feaf96p-1,   0x1.53fe6cp-9, INEXACT)
T(RN,  0x1.03efb9d26fd0cp+662,   -0x1.9f42d1cefbde5p-4,   0x1.a34864p-3, INEXACT)
T(RN,  0x1.7ae1b52cea415p+662,    0x1.8ed044a746579p-1,   0x1.a3f128p-2, INEXACT)
T(RN,  0x1.da205f7030082p+662,    0x1.5f40904b8d44cp-3,    0x1.eb1d8p-4, INEXACT)
T(RN,  0x1.f78e135ab6258p+662,    -0x1.087e4e964af8p-2,  -0x1.9c3b64p-2, INEXACT)
T(RN,   0x1.59967501cd09p+662,    0x1.e3b966ff75422p-1,   0x1.74e228p-2, INEXACT)
T(RN,   0x1.a6dc2fc53d76p+662,    0x1.2c6dc5e930a61p-1,  -0x1.120d96p-2, INEXACT)
T(RN,  0x1.a254177607884p+662,   -0x1.ff7cf0c31a585p-1,   0x1.d74318p-2, INEXACT)
T(RN,  0x1.1259233b6851ap+662,    0x1.fffde8add542dp-1,   0x1.9c04e6p-4, INEXACT)
T(RN,  0x1.cee7aa46fae9cp+662,   -0x1.aec8885907d06p-3,    0x1.303b9p-2, INEXACT)
T(RN,  0x1.1f47f63837d06p+662,    0x1.7284fe2604c11p-1,  -0x1.c18fa8p-2, INEXACT)
T(RN,  0x1.078e0eeafca48p+663,    0x1.f72d016f44d5ap-1,  -0x1.9f04acp-4, INEXACT)
T(RN,  0x1.1536ee7a5160bp+663,   -0x1.f8177290e55bep-1,   0x1.0b624cp-5, INEXACT)
T(RN,  0x1.067c7cad68e1dp+663,   -0x1.e51a9dd876c87p-1,   0x1.a29c14p-5, INEXACT)
T(RN,  0x1.e981a5457b578p+663,    0x1.318643c934adcp-1,   0x1.dc44a6p-4, INEXACT)
T(RN,   0x1.df0afa790b9dp+663,   -0x1.79c63891e854bp-1,   0x1.9c4c6cp-2, INEXACT)
T(RN,  0x1.cc216551dec41p+663,     0x1.8073fbf03f3dp-1,  -0x1.0dbf94p-2, INEXACT)
T(RN,   0x1.f067da958ed6p+663,   -0x1.1df1ef80a2764p-1,   0x1.c55512p-2, INEXACT)
T(RN,  0x1.e69fc7f249a98p+663,    0x1.eb5a3009a2fffp-1,  -0x1.a996aep-2, INEXACT)
T(RN,  0x1.9c373666ddfc6p+663,    0x1.87a04be53e85dp-1,   0x1.4157ecp-2, INEXACT)
T(RN,  0x1.aebb740c310f4p+663,   -0x1.25d06dcbd2793p-2,  -0x1.adea9ap-2, INEXACT)
T(RN,  0x1.8bfcfd3619d84p+664,    0x1.af8b9aa10f418p-2,   0x1.898144p-3, INEXACT)
T(RN,  0x1.2183fba3f712fp+664,   -0x1.d672a967efd49p-2,  -0x1.6c6f7cp-2, INEXACT)
T(RN,  0x1.c07d5f33e8cd1p+664,     0x1.87bca07b5b32p-5,   0x1.d85deep-5, INEXACT)
T(RN,  0x1.9157600d93258p+664,    0x1.9ca89e57013b9p-2,  -0x1.26bb8ap-2, INEXACT)
T(RN,  0x1.a1f884347df2cp+664,    0x1.d2a338bca2542p-1,   -0x1.fce9dp-5, INEXACT)
T(RN,  0x1.952af12c426c1p+664,    -0x1.7716a1df8ef3p-1,  -0x1.089198p-2, INEXACT)
T(RN,  0x1.e3d76e0a8ef11p+664,    0x1.24ed063ddbae7p-4,    0x1.d49fep-5, INEXACT)
T(RN,  0x1.e4a9d63b85386p+664,   -0x1.e8116c7958f2ep-1,    0x1.d9d4ap-2, INEXACT)
T(RN,  0x1.dcbe990b07066p+664,   -0x1.d52408fa11856p-1,   0x1.a1277ap-4, INEXACT)
T(RN,  0x1.e0f156f4d2496p+664,   -0x1.ffe9af21b27a2p-1,   0x1.374436p-5, INEXACT)
T(RN,  0x1.8c5ec45dfa0d2p+665,    0x1.bf92bc28bdb52p-1,   0x1.d337f4p-2, INEXACT)
T(RN,  0x1.35f6bf8d62e6ap+665,    0x1.c530c53f3bf77p-3,  -0x1.f4736ep-3, INEXACT)
T(RN,  0x1.7601db21486a4p+665,    0x1.8296259ad42a4p-2,   -0x1.4b55ep-2, INEXACT)
T(RN,   0x1.c7b2ee1ed25ap+665,    0x1.f60de77c33deap-2,  -0x1.7c9334p-2, INEXACT)
T(RN,  0x1.f35085dc5503cp+665,   -0x1.d9591d567a73fp-2,   0x1.bfc934p-4, INEXACT)
T(RN,  0x1.e84533d163f44p+665,   -0x1.7b123f55a88b1p-1,   0x1.ff2432p-4, INEXACT)
T(RN,   0x1.b440f34b7ebfp+665,    0x1.b71335c8ebedap-1,  -0x1.d423a6p-2, INEXACT)
T(RN,  0x1.1b4e299ee9b6dp+665,   -0x1.e03dce4d5614fp-1,   0x1.a3d552p-2, INEXACT)
T(RN,  0x1.f728b12d5434bp+665,    0x1.f0101f4f6726cp-2,   0x1.451af2p-2, INEXACT)
T(RN,  0x1.5861eff6b8fcbp+665,   -0x1.e9dcc9b3c4bb4p-1,   0x1.418e1ap-3, INEXACT)
T(RN,  0x1.845a80248ff46p+666,   -0x1.312815e39dc12p-2,  -0x1.56692ap-5, INEXACT)
T(RN,  0x1.cebe088e8997ep+666,    0x1.fd91c88cf46a9p-1,  -0x1.a0355ep-3, INEXACT)
T(RN,  0x1.71941d8a17775p+666,   -0x1.fa8a250a4370ep-1,  -0x1.ab96c2p-5, INEXACT)
T(RN,  0x1.fa3540cb0205cp+666,   -0x1.bd8b7017ce4e6p-2,  -0x1.52991ep-3, INEXACT)
T(RN,  0x1.8ed070bb2af8fp+666,   -0x1.1faeceb58a558p-5,  -0x1.de7bb2p-2, INEXACT)
T(RN,  0x1.b1e67995c6038p+666,    0x1.a00b6f645197bp-1,   0x1.4a7422p-3, INEXACT)
T(RN,  0x1.92952558c1dbap+666,    -0x1.ff631398b9eap-1,  -0x1.256da2p-2, INEXACT)
T(RN,  0x1.23f51437a3c34p+666,    0x1.e9cc1ab317957p-1,    0x1.12713p-2, INEXACT)
T(RN,  0x1.1691c0cd3c52cp+666,   -0x1.fe6bc3db334aap-1,   0x1.c1d5e2p-2, INEXACT)
T(RN,  0x1.fbfee31f69b18p+666,   -0x1.43a3780375c98p-2,   0x1.a54bdcp-2, INEXACT)
T(RN,  0x1.f0b28c2eb0136p+667,   -0x1.16d48389e1c6ep-2,   0x1.c4daa6p-2, INEXACT)
T(RN,  0x1.0f521841c16c6p+667,   -0x1.ffa4fc564ad71p-1,   0x1.80fcd8p-2, INEXACT)
T(RN,  0x1.02d6cb7784294p+667,    -0x1.63a993a88067p-1,   0x1.974266p-4, INEXACT)
T(RN,  0x1.6bf0a6e9557cfp+667,    -0x1.fee88f3f2a03p-1,   0x1.bf9496p-2, INEXACT)
T(RN,  0x1.bb395b1733c54p+667,   -0x1.e4ee8d50733e3p-1,  -0x1.6da92ap-3, INEXACT)
T(RN,  0x1.cdc034273f38dp+667,    0x1.73655bfdcdef2p-1,  -0x1.307194p-2, INEXACT)
T(RN,  0x1.5636735947f32p+667,   -0x1.d93fd952742e9p-1,   0x1.f0edf6p-2, INEXACT)
T(RN,  0x1.091dbab25d0bbp+667,    0x1.fdab3fa351f29p-1,   0x1.c36f3ap-3, INEXACT)
T(RN,  0x1.9906f61a04672p+667,   -0x1.478b90cc33f1ep-1,   0x1.594776p-3, INEXACT)
T(RN,  0x1.50c3278191712p+667,   -0x1.87f320f869fbep-1,  -0x1.bb629ep-3, INEXACT)
T(RN,  0x1.24f1893e58618p+668,   -0x1.4e969443ed50dp-1,   -0x1.878a9p-2, INEXACT)
T(RN,  0x1.d7c7725d10c56p+668,   -0x1.b15ade2f180efp-1,   0x1.522804p-2, INEXACT)
T(RN,  0x1.d49850b7a3d5ep+668,    0x1.61613304e72c5p-1,  -0x1.f08cdcp-4, INEXACT)
T(RN,  0x1.c02385fafad3fp+668,    0x1.fd091cc69b872p-1,  -0x1.7be408p-2, INEXACT)
T(RN,  0x1.8590f3b7f2028p+668,   -0x1.d78b1dba576f6p-1,    0x1.4fa2fp-5, INEXACT)
T(RN,  0x1.701e2981e2596p+668,     0x1.79b416da517dp-1,  -0x1.9a706cp-3, INEXACT)
T(RN,  0x1.0f223b0f4e932p+668,   -0x1.2a4d48adaa87dp-3,   -0x1.6935bp-5, INEXACT)
T(RN,  0x1.bbe1b69c69de2p+668,   -0x1.b602cdf2fb172p-6,  -0x1.32d9a8p-2, INEXACT)
T(RN,  0x1.fcb3928a2c8f6p+668,   -0x1.02dc6a470295cp-1,   -0x1.03611p-3, INEXACT)
T(RN,  0x1.492ad873b3efep+668,    0x1.a3179bbbb6dffp-1,  -0x1.5d32c6p-2, INEXACT)
T(RN,  0x1.6ea0391f5cf0cp+669,    0x1.ec87806f3a27ap-1,   0x1.6d3d96p-2, INEXACT)
T(RN,  0x1.17a4f83a55d58p+669,    0x1.f409bffd1f7f2p-3,  -0x1.5e0ea6p-7, INEXACT)
T(RN,  0x1.93b7ff4a43ea8p+669,    0x1.89602a5869179p-2,  -0x1.e6a964p-2, INEXACT)
T(RN,  0x1.be46831a320fbp+669,   -0x1.f57cd3a9e3cd3p-2,   -0x1.145bap-2, INEXACT)
T(RN,  0x1.2b4f130b55788p+669,   -0x1.076cc3fcef314p-1,  -0x1.3d6a0ep-6, INEXACT)
T(RN,  0x1.d11f11ac953e4p+669,    0x1.c0874e7d3b8a8p-1,   -0x1.b384ap-3, INEXACT)
T(RN,   0x1.a909668548f8p+669,    0x1.bc57ddb347066p-1,   -0x1.73accp-9, INEXACT)
T(RN,  0x1.8eff4d4cdff4ep+669,   -0x1.547f9cee60978p-3,  -0x1.450586p-3, INEXACT)
T(RN,  0x1.b7001ac683874p+669,    0x1.03350128c6114p-4,  -0x1.8e9514p-2, INEXACT)
T(RN,  0x1.76ec5ae1ac15cp+669,    0x1.a1b1da5a40b39p-1,  -0x1.413b44p-2, INEXACT)
T(RN,  0x1.edbdd9dcfdfeep+670,     0x1.5db12ec08ff4p-3,    0x1.44036p-2, INEXACT)
T(RN,  0x1.f7dd63f7f12cdp+670,   -0x1.cf29247d85175p-1,  -0x1.a8011ep-2, INEXACT)
T(RN,  0x1.b1ac8b8a5f366p+670,    0x1.d9e1acae1e06cp-1,  -0x1.ea3e52p-2, INEXACT)
T(RN,  0x1.b6b187d2f66f8p+670,    0x1.7e8ce3879f567p-1,   0x1.92306ap-3, INEXACT)
T(RN,  0x1.4f7a13336403dp+670,    0x1.269e48db12a9fp-2,  -0x1.44b158p-2, INEXACT)
T(RN,  0x1.bc62fbce9af28p+670,    0x1.888bc9582f03bp-1,  -0x1.a68e52p-3, INEXACT)
T(RN,  0x1.25173d1aea4bdp+670,    0x1.7f0b80beec973p-1,  -0x1.080b9ep-2, INEXACT)
T(RN,  0x1.837b1249d95d6p+670,    0x1.d5d097ee549f1p-4,   0x1.12a012p-2, INEXACT)
T(RN,  0x1.7f98ca626a127p+670,   -0x1.ddccd886e8585p-1,  -0x1.f0b5dap-2, INEXACT)
T(RN,  0x1.778ac070c0473p+670,    0x1.d1131bc6522d3p-1,   0x1.f6d076p-2, INEXACT)
T(RN,  0x1.8ea7d0e16991ap+671,    0x1.9855acd55884ap-4,   0x1.57b694p-4, INEXACT)
T(RN,  0x1.465f9e70444c4p+671,    0x1.bc74f960fb8cap-2,   0x1.db0a64p-2, INEXACT)
T(RN,  0x1.fa406357f4124p+671,   -0x1.d84808eb3e334p-1,  -0x1.fb9a9cp-2, INEXACT)
T(RN,  0x1.69fb73ee32f6bp+671,    0x1.d0fe31df61124p-2,  -0x1.b4604ap-2, INEXACT)
T(RN,  0x1.2cb608d7ecff2p+671,   -0x1.fea6492e835a5p-1,   0x1.adf816p-4, INEXACT)
T(RN,  0x1.e3bb6bb51f7e8p+671,    0x1.9d6fae955cdf6p-1,  -0x1.654456p-2, INEXACT)
T(RN,  0x1.b57e05028e44bp+671,    0x1.b9df7c30f5787p-1,  -0x1.baf346p-6, INEXACT)
T(RN,  0x1.6f31bd7d173b4p+671,   -0x1.fedac72e7e9d2p-1,  -0x1.6d95b8p-2, INEXACT)
T(RN,  0x1.6acd95d43eaf4p+671,    0x1.cfc3c69825b83p-1,  -0x1.0e2bd6p-4, INEXACT)
T(RN,  0x1.12c3eb3a2b586p+671,    0x1.a65ee1a689e01p-2,   0x1.f2a01cp-3, INEXACT)
T(RN,  0x1.329239c19629bp+672,    0x1.13b04aaba3066p-2,  -0x1.992ee2p-3, INEXACT)
T(RN,  0x1.afadc8a6a0a64p+672,   -0x1.ffde910a47552p-1,  -0x1.1112b6p-2, INEXACT)
T(RN,  0x1.b445956b759ecp+672,   -0x1.e7041c3d44a48p-1,  -0x1.ac4a48p-2, INEXACT)
T(RN,  0x1.4b8944c116e99p+672,   -0x1.46911cf2cbc36p-1,   0x1.5ebd6cp-2, INEXACT)
T(RN,  0x1.fa85008f5cb76p+672,    0x1.ec805be3b7f5bp-1,  -0x1.444676p-2, INEXACT)
T(RN,  0x1.0373336cf391cp+672,    -0x1.f3f15d9e3d94p-1,  -0x1.52b748p-3, INEXACT)
T(RN,  0x1.8a1ef142f20b8p+672,   -0x1.3cc8d19026affp-1,  -0x1.67555cp-2, INEXACT)
T(RN,  0x1.833c4b40e3dfap+672,   -0x1.1172b27d31e68p-4,    0x1.cc3f1p-2, INEXACT)
T(RN,  0x1.656803a063342p+672,   -0x1.04f21922cce08p-2,   0x1.6fa62ap-5, INEXACT)
T(RN,  0x1.b3d01e12b2c4ap+672,   -0x1.fcd12a45663d3p-1,  -0x1.168708p-3, INEXACT)
T(RN,  0x1.2a4a02694d1c1p+673,   -0x1.d40051d8eb277p-1,   0x1.0a37d6p-4, INEXACT)
T(RN,  0x1.daa7bdb9e4ceep+673,    -0x1.49e4752bd29cp-1,   0x1.0769aep-2, INEXACT)
T(RN,  0x1.b0564f4bf269fp+673,    0x1.cafc158d22c4fp-1,   0x1.485d6ep-3, INEXACT)
T(RN,  0x1.ee483cc6cd92ep+673,   -0x1.d4a1e77ef0fbap-1,   -0x1.c4716p-2, INEXACT)
T(RN,  0x1.76d585c219787p+673,   -0x1.fffff5a65bb8ap-1,   0x1.7eead8p-2, INEXACT)
T(RN,   0x1.1283a90bd7f7p+673,   -0x1.d7a31df309832p-3,  -0x1.6384eep-4, INEXACT)
T(RN,  0x1.b71a662f34735p+673,    0x1.fa574c549842ap-1,  -0x1.8bf0dcp-4, INEXACT)
T(RN,  0x1.3587bb4a310f3p+673,   -0x1.16183f04cb43ap-1,   0x1.e943eep-2, INEXACT)
T(RN,  0x1.fc3b60461320bp+673,   -0x1.d99e5db9fd773p-1,    0x1.5b10cp-2, INEXACT)
T(RN,  0x1.74a2ab0167428p+673,    0x1.fda1e80c12ba4p-1,   0x1.d5f3dcp-3, INEXACT)
T(RN,  0x1.b36fd741f61d2p+674,   -0x1.d0ec2cb095e01p-1,   0x1.e99848p-4, INEXACT)
T(RN,  0x1.7868175eee7d5p+674,    0x1.93fc7fc08d261p-1,  -0x1.8c1daep-5, INEXACT)
T(RN,  0x1.549e0c1ff95f7p+674,   -0x1.91d5d1e632f4ep-2,  -0x1.7585fap-3, INEXACT)
T(RN,   0x1.47e1ce7b1273p+674,     0x1.b9145b44ba43p-2,  -0x1.f32a66p-2, INEXACT)
T(RN,  0x1.08c35c9f431bdp+674,    0x1.d1d22e59a3d7ap-2,  -0x1.67ee02p-2, INEXACT)
T(RN,  0x1.6b2e7a4810f32p+674,    0x1.6e280f33739d3p-1,  -0x1.c80aa6p-4, INEXACT)
T(RN,  0x1.ed07d98b02d1ep+674,   -0x1.b870828b50f2ep-3,   0x1.8644e4p-4, INEXACT)
T(RN,  0x1.4909d62a6b5ffp+674,    0x1.5d0ca548ef852p-2,   0x1.7642dcp-4, INEXACT)
T(RN,  0x1.f71e1080af8b4p+674,   -0x1.f0584e77bb0a4p-1,   0x1.74f62cp-2, INEXACT)
T(RN,  0x1.9e8599bc5705bp+674,    0x1.b6d78dcd8c75ep-1,  -0x1.78f184p-3, INEXACT)
T(RN,  0x1.1dc1bf90a042bp+675,   -0x1.2a6cef7371ed1p-1,    0x1.86805p-4, INEXACT)
T(RN,  0x1.f0b1bb9fd6591p+675,    0x1.20abfe4f0e585p-1,  -0x1.c1875ep-5, INEXACT)
T(RN,  0x1.d9ca8b301de22p+675,    0x1.c23b565204b2bp-1,  -0x1.e4817ep-2, INEXACT)
T(RN,  0x1.f3b54fc664fd4p+675,   -0x1.d034ccf6ec50ep-3,   0x1.453d5cp-2, INEXACT)
T(RN,  0x1.c26d4d223a3b2p+675,    0x1.efa4b769231bap-1,    0x1.56879p-6, INEXACT)
T(RN,   0x1.c5d72b3fffa5p+675,   -0x1.a8d86ab9f3d7cp-2,  -0x1.a2b0fcp-2, INEXACT)
T(RN,  0x1.eb1fe5f118672p+675,    0x1.1bedfc9732b19p-5,   0x1.1b11f2p-2, INEXACT)
T(RN,  0x1.20643b61a34f5p+675,   -0x1.4686a0ac30132p-3,   0x1.0d5d4ep-3, INEXACT)
T(RN,  0x1.f1b72c59a7826p+675,   -0x1.4f49526645dedp-2,   0x1.0a0ef8p-2, INEXACT)
T(RN,  0x1.e8e698a2cf377p+675,    0x1.18706c092414ap-2,   0x1.ae2ffep-2, INEXACT)
T(RN,  0x1.19fa814b89827p+676,    0x1.96d7c85d39662p-6,   0x1.ce333cp-3, INEXACT)
T(RN,  0x1.d807cd424e968p+676,   -0x1.73f7f566a3f65p-1,   -0x1.97e85p-2, INEXACT)
T(RN,  0x1.5666b52351118p+676,    0x1.ee71c91067d7dp-2,   -0x1.b5ff6p-3, INEXACT)
T(RN,  0x1.69d3b0fec0818p+676,   -0x1.0e8fa8abffe19p-2,   0x1.5a7c96p-2, INEXACT)
T(RN,  0x1.f9cb8dfe15e12p+676,    0x1.9e40a26b5d253p-1,  -0x1.177bb6p-5, INEXACT)
T(RN,  0x1.724796ec743f7p+676,    0x1.aebda073d9ab5p-1,   0x1.9e50bcp-2, INEXACT)
T(RN,   0x1.032b2ba9e8c4p+676,     0x1.b012e6d9230dp-1,  -0x1.592bbcp-3, INEXACT)
T(RN,  0x1.105f3c8114d45p+676,   -0x1.fec28994ba6b2p-1,   0x1.c0e37cp-3, INEXACT)
T(RN,  0x1.0ba45046b5193p+676,    0x1.c0718d583d644p-1,   0x1.4f3982p-2, INEXACT)
T(RN,  0x1.721533a459718p+676,   -0x1.fe8e7f55a5ac3p-1,   0x1.763df8p-5, INEXACT)
T(RN,   0x1.16851f091a17p+677,   -0x1.f63c057dbc0cap-1,  -0x1.04a5b2p-2, INEXACT)
T(RN,  0x1.be8cdfaffa668p+677,   -0x1.fe6f79e04562fp-1,   0x1.25b202p-2, INEXACT)
T(RN,  0x1.37819f66a1efep+677,    0x1.6313b231a4ef9p-2,   0x1.c100b4p-3, INEXACT)
T(RN,   0x1.bede29570d72p+677,    0x1.11eb67959ddf9p-3,   0x1.0f4d68p-3, INEXACT)
T(RN,  0x1.1127e5cd7ebd2p+677,    0x1.f15e6e5226b69p-1,  -0x1.8e87ccp-3, INEXACT)
T(RN,  0x1.83c3d48eb58b8p+677,   -0x1.24076e6f67f2cp-4,  -0x1.478ee6p-2, INEXACT)
T(RN,  0x1.29385a96abbc2p+677,    0x1.b911eb4e502a8p-4,   0x1.2b8608p-4, INEXACT)
T(RN,  0x1.a974c26d8ed2fp+677,   -0x1.52b96e963e1e1p-2,  -0x1.9c594ep-2, INEXACT)
T(RN,  0x1.1898a453b3b15p+677,   -0x1.4039d7f662a9ep-1,   0x1.23730ap-2, INEXACT)
T(RN,  0x1.14232065d3d46p+677,   -0x1.e6cbd05195c68p-1,   0x1.d74b46p-4, INEXACT)
T(RN,  0x1.482098e9e1c7ap+678,   -0x1.8d627bcc680f4p-2,    0x1.9422fp-2, INEXACT)
T(RN,  0x1.23d33721f47b2p+678,   -0x1.fba9a71f9c68ap-1,   0x1.08a928p-2, INEXACT)
T(RN,  0x1.66f2f6c2c9a53p+678,    0x1.9355b71e01f1ep-1,   0x1.bdd724p-2, INEXACT)
T(RN,  0x1.01a9ce9bd90f3p+678,   -0x1.b71df58adec03p-2,  -0x1.abe02cp-2, INEXACT)
T(RN,  0x1.38034d0e3ddcep+678,   -0x1.23e29b1976d73p-3,  -0x1.f8547ap-2, INEXACT)
T(RN,  0x1.020bc8a17dff3p+678,    0x1.e883ffc0f29cfp-4,   -0x1.2e99ep-3, INEXACT)
T(RN,  0x1.59818e96867f6p+678,   -0x1.d986cccb789d4p-1,   0x1.232b2ap-2, INEXACT)
T(RN,   0x1.4a807de2be74p+678,    0x1.1ed6df6bdbfbap-2,   0x1.e562fcp-2, INEXACT)
T(RN,  0x1.105c7aee08fdcp+678,   -0x1.740fb4d7ebb4ap-4,  -0x1.12717ap-5, INEXACT)
T(RN,  0x1.56a678bf31f42p+678,   -0x1.3c479b9687fcap-1,   0x1.9cc8b2p-5, INEXACT)
T(RN,  0x1.c4ca895cf42fcp+679,    0x1.78ede97d21458p-1,   0x1.917334p-6, INEXACT)
T(RN,  0x1.03cc1432c7d45p+679,    -0x1.644ca4b761acp-3,  -0x1.1a4788p-3, INEXACT)
T(RN,  0x1.562e10fb715a8p+679,   -0x1.13780d408fdf8p-1,    0x1.ceccap-4, INEXACT)
T(RN,  0x1.e28a0c32b4a91p+679,   -0x1.86a2daa1dff1fp-2,  -0x1.6d3d86p-3, INEXACT)
T(RN,  0x1.619cbf187f1a5p+679,     0x1.42dcf4c4eeb9p-2,   0x1.d0cd8ep-2, INEXACT)
T(RN,  0x1.92e3e96427988p+679,    0x1.ffbd8ed8202e3p-1,    0x1.f91b4p-3, INEXACT)
T(RN,  0x1.57fe70762a38ap+679,    0x1.e57ef3aac5556p-1,   0x1.e55934p-2, INEXACT)
T(RN,  0x1.feeebb7598398p+679,    -0x1.2076f49d5397p-5,   0x1.3dbadap-3, INEXACT)
T(RN,  0x1.c98dbbcc66c3ap+679,    0x1.b1cdeba29e3c5p-1,    0x1.f2422p-3, INEXACT)
T(RN,  0x1.bc9fb1d6c5906p+679,   -0x1.f76bc8fd1232fp-1,    0x1.2358bp-5, INEXACT)
T(RN,  0x1.b7927e3c744a2p+680,     0x1.9fb7f5d289d3p-1,   0x1.b761c6p-3, INEXACT)
T(RN,  0x1.0356e1b4ffad3p+680,    0x1.a6ee55b8c857bp-2,   0x1.f4521cp-5, INEXACT)
T(RN,  0x1.46975324a53d6p+680,    -0x1.ef6e96174007p-1,   0x1.783eeep-2, INEXACT)
T(RN,  0x1.4421809c0d53dp+680,   -0x1.dea941c7d6a0dp-1,   0x1.3fcfb2p-2, INEXACT)
T(RN,  0x1.b7b565ea717f8p+680,    0x1.e5d8e85d0817bp-2,   -0x1.56867p-5, INEXACT)
T(RN,  0x1.f749064a35a4dp+680,     0x1.22fb4ca44cd6p-2,    0x1.ba132p-2, INEXACT)
T(RN,  0x1.a36f9fd5bb445p+680,    0x1.3b6c94cd94ef1p-1,   0x1.541b6ep-3, INEXACT)
T(RN,  0x1.cc17e16abbe4ap+680,   -0x1.5fba096ae1f35p-3,  -0x1.7dc032p-2, INEXACT)
T(RN,  0x1.7f9ea9c0760f7p+680,   -0x1.b5bd8c8529544p-1,   0x1.4f1b74p-2, INEXACT)
T(RN,  0x1.f921926f20388p+680,    0x1.c99edcd4df3cep-1,   0x1.ec99a4p-5, INEXACT)
T(RN,  0x1.d8971df0c3818p+681,   -0x1.d58525dbde90bp-3,  -0x1.eac70ep-2, INEXACT)
T(RN,  0x1.19001ac9bba9ap+681,    0x1.29e6464238314p-1,   -0x1.bce15p-3, INEXACT)
T(RN,   0x1.9dd952fd23f5p+681,    0x1.b506ad3a6ead4p-2,   0x1.c72416p-3, INEXACT)
T(RN,  0x1.ed6fbfec21dbcp+681,   -0x1.c3aea82a91a46p-1,  -0x1.a41df4p-5, INEXACT)
T(RN,  0x1.ef73bbf93708ap+681,    0x1.c4e26095981f6p-2,   0x1.e186eap-2, INEXACT)
T(RN,  0x1.48e1ec88ab826p+681,    0x1.8cb2e47256ac7p-2,   0x1.cf275ep-2, INEXACT)
T(RN,  0x1.ba524c482a698p+681,    0x1.c2653fd47334dp-1,   0x1.952902p-2, INEXACT)
T(RN,  0x1.89ac78628f1f7p+681,   -0x1.e469189b6f135p-1,  -0x1.f45fb2p-2, INEXACT)
T(RN,  0x1.2698d4646c022p+681,   -0x1.f4a9c390a8499p-2,  -0x1.6dfc48p-3, INEXACT)
T(RN,  0x1.6ac6167672b24p+681,    0x1.3c28c2ae0189fp-1,  -0x1.3d8954p-2, INEXACT)
T(RN,  0x1.26728f0c3bfb4p+682,     0x1.6f5a3f14ff7bp-1,  -0x1.f27332p-2, INEXACT)
T(RN,  0x1.99c32bc04625ap+682,   -0x1.ade37d6bf37fbp-1,  -0x1.f07286p-2, INEXACT)
T(RN,  0x1.97445a66b4b1ap+682,   -0x1.61775e5acd47ep-1,   0x1.7d572cp-2, INEXACT)
T(RN,  0x1.bc3080d38a4d6p+682,    0x1.ffab99cb8b2d9p-1,  -0x1.931f52p-5, INEXACT)
T(RN,  0x1.325d4a5017a72p+682,   -0x1.ec4aff727e157p-1,   -0x1.cb3d8p-2, INEXACT)
T(RN,  0x1.1bc7cab4eb776p+682,    0x1.f77a406aa05a2p-1,    0x1.7e7cfp-3, INEXACT)
T(RN,  0x1.29ceb0244c5a8p+682,   -0x1.12a5d2d9aa17ap-1,   0x1.9f9834p-2, INEXACT)
T(RN,  0x1.38f574f4a3819p+682,    0x1.fff9e559bbee3p-1,  -0x1.c2973ep-2, INEXACT)
T(RN,  0x1.1edd80ddd4a6cp+682,   -0x1.5a72f41eae44bp-1,  -0x1.bbf8fap-4, INEXACT)
T(RN,  0x1.b91525020d033p+682,    0x1.ffe42a8b0e4a1p-1,  -0x1.e708c6p-2, INEXACT)
T(RN,  0x1.304181ac4b189p+683,    0x1.17a03137b9b28p-1,  -0x1.282f44p-2, INEXACT)
T(RN,  0x1.a79d7fac30f2cp+683,   -0x1.30d5b5f5c37dfp-3,    0x1.a9752p-2, INEXACT)
T(RN,  0x1.37ea4ce304d9dp+683,    0x1.f07829a91cfa9p-1,  -0x1.bba7ccp-3, INEXACT)
T(RN,  0x1.986318c458ce2p+683,   -0x1.005acea6e9128p-7,   0x1.750822p-4, INEXACT)
T(RN,  0x1.48d366e5c385fp+683,    0x1.28440b8e026b7p-1,     0x1.f2e6p-2, INEXACT)
T(RN,  0x1.00c9124fce86ep+683,   -0x1.04e7783084cf7p-1,   -0x1.6169cp-2, INEXACT)
T(RN,  0x1.930de20ac89e3p+683,   -0x1.0415d49ee560ap-1,   0x1.711daep-3, INEXACT)
T(RN,  0x1.1bfd78a20eb37p+683,    0x1.ff2d95161dd37p-1,   -0x1.15fa8p-5, INEXACT)
T(RN,  0x1.ee8e55918f486p+683,   -0x1.5244e00c4cf25p-3,  -0x1.1188b2p-6, INEXACT)
T(RN,  0x1.71a54bfd21616p+683,   -0x1.45ae8c24be787p-1,    -0x1.94f2p-2, INEXACT)
T(RN,  0x1.626de859734dcp+684,   -0x1.73f9a8a4b9be2p-1,   -0x1.ad154p-2, INEXACT)
T(RN,  0x1.392dad1b4033cp+684,   -0x1.fc0294b089e12p-1,    0x1.58109p-2, INEXACT)
T(RN,  0x1.8a692439a17dep+684,   -0x1.fd6cdee9a7f8cp-1,   0x1.b6d7eap-3, INEXACT)
T(RN,  0x1.8b69861a40d4ap+684,    0x1.fe6a3ee62f2f1p-1,   -0x1.ceadep-4, INEXACT)
T(RN,  0x1.4e68839db26d8p+684,    -0x1.7601439dca95p-1,  -0x1.06ea0cp-5, INEXACT)
T(RN,  0x1.91674924e317ep+684,   -0x1.ecc9de57a5ccdp-3,  -0x1.18167ep-2, INEXACT)
T(RN,  0x1.b6b5681b6e4eap+684,    0x1.a1ec3d20f17f9p-3,  -0x1.ff0d82p-4, INEXACT)
T(RN,  0x1.4dff03828cf22p+684,   -0x1.3482c5d281de9p-1,   0x1.74f5f2p-3, INEXACT)
T(RN,  0x1.81dea4bfbe0d5p+684,    0x1.f51aa41e5ff5cp-1,  -0x1.3fa176p-2, INEXACT)
T(RN,  0x1.b61700e06ce32p+684,    0x1.8646f41182421p-1,   0x1.08a05ep-3, INEXACT)
T(RN,  0x1.aca74e1aa3b56p+685,    0x1.c61c3e5bee9eap-1,    0x1.3d54ap-3, INEXACT)
T(RN,  0x1.0d3ec64ce749cp+685,   -0x1.2cc2971573b63p-1,   0x1.e81566p-2, INEXACT)
T(RN,  0x1.ba6acd4ef7554p+685,    0x1.be998fd539a54p-2,  -0x1.030d6cp-4, INEXACT)
T(RN,  0x1.d2aebd71f5bbep+685,   -0x1.9329d491d8275p-2,  0x1.5de676p-10, INEXACT)
T(RN,  0x1.2ce425760dbf9p+685,   -0x1.c3d5cd0f876dfp-1,   0x1.fbc4cap-2, INEXACT)
T(RN,  0x1.b79afc5d131bep+685,   -0x1.9f43c011cb8b9p-1,  -0x1.691884p-2, INEXACT)
T(RN,  0x1.30fde6827ae3ep+685,   -0x1.eca95867ede7ep-1,   0x1.4f5fc4p-4, INEXACT)
T(RN,   0x1.fa38a646dd07p+685,    0x1.bb0c7bc26d7bap-1,   0x1.046982p-2, INEXACT)
T(RN,  0x1.6dd751bbac5c9p+685,   -0x1.d1da2df3cd2e3p-4,   0x1.c9382ep-2, INEXACT)
T(RN,  0x1.8f8dcf3866f85p+685,   -0x1.eeb90d562844fp-1,  -0x1.4d21e6p-9, INEXACT)
T(RN,  0x1.449320dbf1248p+686,    0x1.a28ed2563ea41p-1,   0x1.c652a4p-3, INEXACT)
T(RN,  0x1.dccacbce07ed2p+686,    0x1.d6a7b477bf568p-1,    0x1.52aaap-2, INEXACT)
T(RN,  0x1.01f6e1ca3c325p+686,   -0x1.a18ac61c76175p-2,   -0x1.f7147p-9, INEXACT)
T(RN,  0x1.fcfef0ddb9ecbp+686,   -0x1.18df9f78e5a0fp-1,  -0x1.00e2b4p-6, INEXACT)
T(RN,  0x1.9e1df13a811c2p+686,   -0x1.ffe1df9bd6219p-1,  -0x1.ff6a5cp-5, INEXACT)
T(RN,   0x1.872aad62679dp+686,   -0x1.3675540e93b32p-7,  -0x1.6b732ep-3, INEXACT)
T(RN,  0x1.8825987264c1ep+686,   -0x1.df89ba3867a61p-2,   0x1.56e0fcp-2, INEXACT)
T(RN,   0x1.e452a57abd09p+686,   -0x1.97167d22ccc6cp-4,  -0x1.a87c32p-3, INEXACT)
T(RN,  0x1.7f85cf4795af5p+686,    0x1.27725d5a84421p-1,   0x1.00265ap-4, INEXACT)
T(RN,  0x1.992efd047b629p+686,   -0x1.a823fa5190025p-2,  -0x1.546128p-2, INEXACT)
T(RN,  0x1.95117ca824151p+687,    0x1.f680e0ed59145p-5,   -0x1.44e04p-3, INEXACT)
T(RN,  0x1.5c63808ed051ap+687,   -0x1.fffd3a905af6bp-1,   -0x1.9010bp-5, INEXACT)
T(RN,  0x1.929fa4c8dbcaep+687,    0x1.2fcf94a9f4e29p-1,  -0x1.0e1598p-4, INEXACT)
T(RN,  0x1.d5402220e9022p+687,    0x1.f54d660a27c0cp-1,   0x1.6c6582p-2, INEXACT)
T(RN,  0x1.cbabb3f7a75d3p+687,    0x1.e7211471f8b21p-1,  -0x1.78146cp-2, INEXACT)
T(RN,  0x1.c04862b2fcf7ep+687,    0x1.ac3b79228f3b8p-1,  -0x1.7dfba6p-6, INEXACT)
T(RN,  0x1.fa0cb7b041296p+687,    0x1.23ea103a710a6p-2,   -0x1.72687p-3, INEXACT)
T(RN,  0x1.291eeb5252718p+687,   0x1.fcf0860ca327ep-11,   0x1.0e6d62p-3, INEXACT)
T(RN,  0x1.2359729381172p+687,   -0x1.f21235432a523p-1,   0x1.e2fd26p-3, INEXACT)
T(RN,   0x1.2b3f79f882ddp+687,    0x1.f299e41e9900fp-1,  -0x1.7bd832p-9, INEXACT)
T(RN,  0x1.d0e78486780f3p+688,   -0x1.edac9de60e00cp-1,   0x1.9bf10ep-2, INEXACT)
T(RN,   0x1.695870dcf40dp+688,   -0x1.ffd0d0f967115p-1,   0x1.5995acp-2, INEXACT)
T(RN,  0x1.5cc00a7787cafp+688,   -0x1.eaf6a6693fd19p-2,  -0x1.c49f94p-2, INEXACT)
T(RN,  0x1.4f0f308dcc4efp+688,   -0x1.6a1f53df370bbp-1,   0x1.de162ap-3, INEXACT)
T(RN,  0x1.51ede8185794cp+688,   -0x1.2a1520dc58dc9p-1,  -0x1.469014p-7, INEXACT)
T(RN,  0x1.c610d96c33c71p+688,    0x1.ed2285724a58bp-1,    0x1.44448p-2, INEXACT)
T(RN,  0x1.b6a22cff68be3p+688,    0x1.661c7c24a7007p-1,  -0x1.571c22p-2, INEXACT)
T(RN,  0x1.5f3931d2b5d42p+688,   -0x1.14eb6e7d88dcdp-2,  -0x1.92862ep-2, INEXACT)
T(RN,  0x1.b63118bd60b5ep+688,    0x1.178869426e896p-1,  -0x1.5e40c4p-3, INEXACT)
T(RN,  0x1.5e0a93575cf96p+688,    0x1.c1e8acd20fa8ep-1,   0x1.686f6ap-2, INEXACT)
T(RN,  0x1.1729c499fcee3p+689,   -0x1.72074f7e28534p-1,   0x1.839cb8p-2, INEXACT)
T(RN,  0x1.f9d647f39e92ep+689,    0x1.63cda7bc79e66p-1,    0x1.57394p-2, INEXACT)
T(RN,  0x1.329fed99b2483p+689,    0x1.3c3100a6184c1p-1,    0x1.8c1b8p-3, INEXACT)
T(RN,  0x1.3374e429f3709p+689,   -0x1.cd21ee9fbc31dp-1,   0x1.16b1dep-3, INEXACT)
T(RN,  0x1.d35ab92673942p+689,  -0x1.567ae890f7e3fp-12,   0x1.166e5ep-2, INEXACT)
T(RN,  0x1.49ec3e81aea26p+689,     -0x1.deabe71e80ep-3,  -0x1.f66c66p-2, INEXACT)
T(RN,  0x1.09e4cad6ba1b7p+689,   -0x1.423e38c3df945p-3,  -0x1.981bc4p-3, INEXACT)
T(RN,   0x1.a83865fe8b5ep+689,    0x1.ffff850a6438dp-1,  -0x1.f61734p-3, INEXACT)
T(RN,  0x1.f32762ec53d23p+689,   -0x1.cbac28e80e067p-1,  -0x1.96731cp-2, INEXACT)
T(RN,  0x1.5b202ef5f0becp+689,    0x1.6f841eec3dd16p-1,  -0x1.9c295ap-3, INEXACT)
T(RN,  0x1.a4599995ffde7p+690,   -0x1.3fc23d9d7d432p-2,   0x1.220c54p-3, INEXACT)
T(RN,  0x1.cfc55b313686cp+690,    0x1.02f0432884e7ep-1,  -0x1.f74ed8p-2, INEXACT)
T(RN,  0x1.fc46a9b150a79p+690,   -0x1.ff865e3723fbap-1, -0x1.40d77cp-10, INEXACT)
T(RN,  0x1.59c57a61b7bdap+690,   -0x1.c1d4c2f942358p-1,   0x1.0cf372p-2, INEXACT)
T(RN,  0x1.b66ccb1eef699p+690,   -0x1.d17e0dc13b421p-1,   0x1.404f4cp-3, INEXACT)
T(RN,  0x1.adef2532bbabap+690,   -0x1.6ba72a3cb9bd6p-1,    0x1.09b39p-2, INEXACT)
T(RN,  0x1.24686f6819033p+690,    0x1.21dfc2f4be8d9p-1,   0x1.80b4fep-2, INEXACT)
T(RN,  0x1.ad3f2e8cf15c9p+690,    0x1.3986962937269p-1,  -0x1.534432p-2, INEXACT)
T(RN,  0x1.020523f01a21bp+690,    0x1.f4322b9176e07p-1,   0x1.5a5d14p-2, INEXACT)
T(RN,  0x1.a5449f5082decp+690,    0x1.fc9789407b223p-1,  -0x1.d509a4p-3, INEXACT)
T(RN,  0x1.183769a7a9bdfp+691,    0x1.1d9bf79037006p-3,  -0x1.eb05f2p-3, INEXACT)
T(RN,  0x1.23b772abce28cp+691,    0x1.5caaa10dd2383p-4,    0x1.a1e5fp-2, INEXACT)
T(RN,  0x1.47a533c3b50e6p+691,    0x1.218946d92c1cfp-1,  -0x1.bd3fcep-4, INEXACT)
T(RN,  0x1.7d3e36b5d4f08p+691,    0x1.c8087fe6c4d73p-3,   0x1.c7089cp-2, INEXACT)
T(RN,  0x1.e8291e2acd73bp+691,   -0x1.bf26cf5a3bca2p-1,  -0x1.a2a44ap-4, INEXACT)
T(RN,  0x1.8020ed377f7f7p+691,    0x1.b8dc68d513da3p-2,  -0x1.e5c6fep-4, INEXACT)
T(RN,  0x1.62ba96d841393p+691,   -0x1.fa9a8c45bf4e2p-1,  -0x1.a1c62cp-3, INEXACT)
T(RN,  0x1.e4570d7d40966p+691,   -0x1.db4e7b5162c5cp-1,   0x1.0b7402p-3, INEXACT)
T(RN,  0x1.a0d986eb9c776p+691,   -0x1.ba717666620a8p-1,   0x1.030e4ap-2, INEXACT)
T(RN,  0x1.f865450fe8e63p+691,     0x1.5c42f90553e5p-1,  -0x1.ff9c46p-2, INEXACT)
T(RN,  0x1.8c007b08e37f4p+692,   -0x1.5bac850510e9fp-1,   0x1.19d40ap-2, INEXACT)
T(RN,  0x1.06c8cff237593p+692,   -0x1.f1743ed2a01afp-1,  -0x1.bb6d7cp-3, INEXACT)
T(RN,  0x1.7d51038eb0d66p+692,   -0x1.ef08d4cba4cd8p-3,    0x1.f6f62p-2, INEXACT)
T(RN,  0x1.baa7f4762b822p+692,   -0x1.4722e6000a719p-2,  -0x1.62c2acp-2, INEXACT)
T(RN,   0x1.8237e5d9587bp+692,   -0x1.f5e7e443a13c2p-1,  -0x1.5eaec4p-7, INEXACT)
T(RN,  0x1.9ada3c9024fdbp+692,    0x1.5b8062c7deffcp-1,   0x1.d43814p-3, INEXACT)
T(RN,  0x1.2bbd94b442157p+692,    -0x1.8c22aff14d7bp-1,   0x1.f119c4p-5, INEXACT)
T(RN,  0x1.29672e50c4063p+692,    0x1.5e31ea983ec82p-1,   0x1.2baa8ep-2, INEXACT)
T(RN,   0x1.ac49e02ded08p+692,   -0x1.cc246390de12cp-3,   0x1.967776p-3, INEXACT)
T(RN,  0x1.16557820458c7p+692,   -0x1.fc3b267f7f0d5p-3,    0x1.86c6fp-2, INEXACT)
T(RN,  0x1.858f20a66f8f3p+693,   -0x1.be25818084865p-1,  -0x1.76ee6ep-8, INEXACT)
T(RN,  0x1.f84acc5d349c2p+693,   -0x1.d87613747a3dbp-1, -0x1.905184p-11, INEXACT)
T(RN,  0x1.c1c7c47d4da8fp+693,    0x1.9a3a4341e0a52p-1,  -0x1.65f712p-3, INEXACT)
T(RN,  0x1.50518a7189d5bp+693,   -0x1.150f24c765bc2p-2,   0x1.c000e2p-2, INEXACT)
T(RN,  0x1.00ad5e7ced599p+693,    0x1.5cb76ba6040a3p-4,    0x1.b949bp-2, INEXACT)
T(RN,  0x1.78046e1c34b46p+693,   -0x1.adb54d5faad81p-1,   0x1.2100e4p-3, INEXACT)
T(RN,   0x1.c47cbcdab26dp+693,   -0x1.a84b721ce34dap-1,   0x1.772a86p-3, INEXACT)
T(RN,  0x1.0f3e048d3c66cp+693,    0x1.92acb5f6a1d5ep-1,  -0x1.17e1eap-2, INEXACT)
T(RN,  0x1.dc79bb5672a47p+693,   -0x1.d4b0bb22637c1p-1,   0x1.695ffep-3, INEXACT)
T(RN,  0x1.36faf84ce3d23p+693,   -0x1.5a8464303de62p-1,   0x1.8382d6p-2, INEXACT)
T(RN,  0x1.351bd5e9f3162p+694,   -0x1.bbd351f5f710cp-4,  -0x1.6bbf38p-3, INEXACT)
T(RN,  0x1.4f6c209608dbcp+694,    0x1.6a23f728eb225p-1,   -0x1.c8466p-2, INEXACT)
T(RN,  0x1.288e1337098a7p+694,   -0x1.d44b83765a997p-7,  -0x1.285f1cp-2, INEXACT)
T(RN,  0x1.fc52d8827ddb8p+694,   -0x1.994f7666efdfbp-2,  -0x1.0141bcp-3, INEXACT)
T(RN,  0x1.79bcd11c50095p+694,   -0x1.37bf1e7f831e9p-7,  -0x1.15c678p-2, INEXACT)
T(RN,  0x1.b9dd36891f6dep+694,    0x1.542fe92f385bep-2,  -0x1.7ea24cp-3, INEXACT)
T(RN,  0x1.8174e901365adp+694,   -0x1.fcd1646e36af4p-1,   0x1.50598ep-3, INEXACT)
T(RN,  0x1.9742f8f636199p+694,    0x1.04d123c9dc34dp-1,   0x1.cff0aap-6, INEXACT)
T(RN,  0x1.618c604c5917ap+694,    0x1.39bd16e6b4821p-3,  -0x1.0bb78ap-2, INEXACT)
T(RN,  0x1.5ff7522b70a74p+694,     0x1.feedff4922d5p-1,  -0x1.b823b4p-3, INEXACT)
T(RN,  0x1.7a94f1670b4ccp+695,   -0x1.b5b2e040129efp-1,   0x1.2a1832p-6, INEXACT)
T(RN,   0x1.2982125ec29dp+695,   -0x1.df7b618fbeb62p-1,   0x1.610a58p-2, INEXACT)
T(RN,  0x1.920acd247a021p+695,   -0x1.d1c008c1404f2p-6,   0x1.cf23dap-2, INEXACT)
T(RN,  0x1.a7bc064f5c5a6p+695,    0x1.c938ebf0289a1p-1,   0x1.9b9816p-3, INEXACT)
T(RN,  0x1.0c5d642423853p+695,   -0x1.ba42c3963879bp-1,  -0x1.068de2p-2, INEXACT)
T(RN,  0x1.eaec24465cb42p+695,    0x1.c87d3ff22a73ep-1,  -0x1.d9613ep-2, INEXACT)
T(RN,  0x1.d9d756f668542p+695,   -0x1.851a963bb4024p-2,  -0x1.b7ed6cp-2, INEXACT)
T(RN,  0x1.3bf8816d25f0cp+695,    0x1.e707d1ac72fe4p-1,   0x1.7ad568p-3, INEXACT)
T(RN,  0x1.e4a9549335608p+695,    0x1.2d5d7985cba4ap-1,  -0x1.9e9142p-3, INEXACT)
T(RN,  0x1.bb7e47f91db3cp+695,   -0x1.c2dd9888a1dd4p-1,  -0x1.09fafep-2, INEXACT)
T(RN,  0x1.7ba636b3ff284p+696,    0x1.5b4f09a859f67p-3,   0x1.31f022p-3, INEXACT)
T(RN,  0x1.4170d768432b3p+696,   -0x1.10e1c680f738cp-1,  -0x1.2dc3e4p-2, INEXACT)
T(RN,   0x1.13c89566b267p+696,   -0x1.27b036278dfefp-2,   0x1.9fc5d2p-4, INEXACT)
T(RN,  0x1.0ec2e1382c809p+696,   -0x1.417e5b6ab65abp-1,  -0x1.f5554ap-5, INEXACT)
T(RN,  0x1.46d0fd3f0713ep+696,   -0x1.e76ad412de30ap-1,  -0x1.be788ep-2, INEXACT)
T(RN,  0x1.0e9899a501dbfp+696,   -0x1.f326acd28dc42p-2,  -0x1.e72568p-7, INEXACT)
T(RN,  0x1.6e9469d3fef12p+696,    -0x1.12b2daaed9cfp-1,  -0x1.72cb36p-2, INEXACT)
T(RN,  0x1.102ceb662de33p+696,   -0x1.f4b25d680702dp-3,   0x1.50bd2ap-2, INEXACT)
T(RN,  0x1.23a7994dcd9efp+696,    0x1.e2927eebf8e8bp-1,   0x1.0f4d8ep-2, INEXACT)
T(RN,  0x1.36f09ee91e935p+696,    0x1.c59916aa0d5d7p-3,   0x1.061854p-5, INEXACT)
T(RN,  0x1.8d8780f363574p+697,   -0x1.fecc4210b44f8p-1,   0x1.8542dep-5, INEXACT)
T(RN,  0x1.52c11a447173cp+697,   -0x1.e63ee5e36d8e9p-1,   0x1.f545b8p-3, INEXACT)
T(RN,  0x1.f1f2231971778p+697,    0x1.4846a3598a2d1p-1,   0x1.9ea6a4p-2, INEXACT)
T(RN,  0x1.08b7eb9bc2433p+697,   -0x1.6a738c6a53263p-6,   0x1.c4a472p-3, INEXACT)
T(RN,  0x1.7be42d7c177fdp+697,   -0x1.6f1e2ba69a91bp-4,    0x1.821a3p-3, INEXACT)
T(RN,  0x1.26394bb3581d1p+697,     -0x1.baebf2b38aep-1,   0x1.7efc9ap-5, INEXACT)
T(RN,  0x1.e9a63bec90616p+697,   -0x1.dfdb8b2529596p-1,  -0x1.9131d2p-3, INEXACT)
T(RN,  0x1.4199f7cc60f5ep+697,    0x1.fe704293b4a6bp-1,   0x1.41a256p-3, INEXACT)
T(RN,  0x1.a0466c43b521ep+697,    0x1.36bd42a42999fp-1,   0x1.0e9438p-5, INEXACT)
T(RN,  0x1.3d0ac7a2d4811p+697,   -0x1.7aa22cf64d8c2p-1,   0x1.ca7806p-2, INEXACT)
T(RN,  0x1.3e86036fbc2ffp+698,     0x1.0697b75507e4p-1,   0x1.210da4p-2, INEXACT)
T(RN,  0x1.845a410554dd6p+698,   -0x1.95ea02fa597c1p-1,   0x1.81f432p-2, INEXACT)
T(RN,  0x1.be8ded2e27c7ep+698,   -0x1.f1b755b9dfe75p-1,  -0x1.5e7b3ep-3, INEXACT)
T(RN,  0x1.7c9e763bf8e6dp+698,   -0x1.cc90d713a0f1bp-2,  -0x1.5ccd2cp-3, INEXACT)
T(RN,  0x1.ee473b4019cc4p+698,    0x1.308be4e55f42ap-1,  -0x1.42204cp-2, INEXACT)
T(RN,  0x1.34ca533d60702p+698,    0x1.e8c488eb95887p-1,   0x1.64b91cp-2, INEXACT)
T(RN,  0x1.67264232b528ap+698,   -0x1.fd232964ca331p-1,  -0x1.546684p-2, INEXACT)
T(RN,  0x1.29d96933df22fp+698,    0x1.cac17944bec9fp-1,  -0x1.550712p-3, INEXACT)
T(RN,  0x1.f9079794e695cp+698,    0x1.ed91bc2ebce0dp-1,   0x1.5c0fd6p-3, INEXACT)
T(RN,  0x1.2eafb15afb386p+698,   -0x1.106ec4103c687p-1,  -0x1.2ac036p-3, INEXACT)
T(RN,  0x1.971561aa3c0c6p+699,   -0x1.65a60887711cdp-2,   0x1.e56a9ap-2, INEXACT)
T(RN,  0x1.afdda40f27966p+699,    0x1.55cf72e355f7ep-2,  -0x1.4bb30ep-7, INEXACT)
T(RN,  0x1.faba000e26f34p+699,    0x1.e1f45585bf0ffp-1,   0x1.071058p-2, INEXACT)
T(RN,  0x1.9b770a451dafap+699,    0x1.feb948d8e4954p-1,  -0x1.2fdc7ep-5, INEXACT)
T(RN,  0x1.6403e0dc13731p+699,     0x1.127fb3546ac1p-2,   0x1.506a58p-6, INEXACT)
T(RN,  0x1.5aabc3436ffa2p+699,    -0x1.dfcad0c24614p-1,   0x1.ecf688p-2, INEXACT)
T(RN,   0x1.c7be277ac43ep+699,     0x1.a1a5d9290a94p-1,   -0x1.29a1dp-2, INEXACT)
T(RN,   0x1.d454f90df2f7p+699,    0x1.9be7c67cccae3p-2,    0x1.41e9fp-2, INEXACT)
T(RN,  0x1.7a345c31bf0f1p+699,   -0x1.f39bad7d90729p-1,   0x1.fae4c8p-2, INEXACT)
T(RN,  0x1.63857b459ce73p+699,    0x1.57e35fc5202b2p-1,   0x1.4c9f3ep-3, INEXACT)
T(RN,  0x1.eef9bc3f5c2a1p+700,   -0x1.87fd2cecc3a83p-1,  -0x1.d95fe8p-6, INEXACT)
T(RN,  0x1.fdf6968e736c8p+700,    0x1.7a1f62af5b299p-2,  -0x1.cbb0acp-2, INEXACT)
T(RN,  0x1.238b8cf0ced02p+700,   -0x1.c468c9f14ffb9p-1,   -0x1.193d1p-2, INEXACT)
T(RN,  0x1.0532575b35a38p+700,    -0x1.0cc5d83e186bp-2,   0x1.427778p-2, INEXACT)
T(RN,  0x1.3afa3355323edp+700,    0x1.e2388c14f6031p-1,   0x1.4cac9ap-2, INEXACT)
T(RN,  0x1.aa166d25e907cp+700,   -0x1.9a483e7a14306p-1,  -0x1.51f098p-7, INEXACT)
T(RN,  0x1.9034340baabbap+700,    0x1.5d717c622716ep-1,   0x1.53db54p-5, INEXACT)
T(RN,  0x1.f2902808c2d32p+700,    0x1.a16ce15e6d9bdp-1,  -0x1.3845f2p-2, INEXACT)
T(RN,  0x1.90cf0f5681054p+700,    0x1.6c8f53c307cefp-2,   0x1.b3b8d8p-2, INEXACT)
T(RN,  0x1.ab045e37a2cd2p+700,      0x1.f686e9fabf3p-1,   0x1.3f2616p-2, INEXACT)
T(RN,  0x1.984eed4ede8e8p+701,    0x1.e70861c3591afp-1,  -0x1.95d856p-3, INEXACT)
T(RN,  0x1.1c6a143a4e365p+701,   -0x1.c8bf5fa89b44ap-3,    0x1.368f8p-2, INEXACT)
T(RN,  0x1.ca23e6c7e57cbp+701,    0x1.d546157653c25p-1,   0x1.0506fcp-2, INEXACT)
T(RN,  0x1.4135846e84fcap+701,    0x1.4bee4cd3d495cp-1,  -0x1.10686ap-4, INEXACT)
T(RN,  0x1.dc50619cd8c18p+701,   -0x1.e0226eb27ee22p-1,   0x1.34b49cp-3, INEXACT)
T(RN,  0x1.9bbdcb907afacp+701,    -0x1.cf3aadcdf1f6p-1,  -0x1.938486p-3, INEXACT)
T(RN,  0x1.8a0a3a7d9461cp+701,   -0x1.ac77ed1fec7c1p-1,  -0x1.a28244p-2, INEXACT)
T(RN,  0x1.3318ceba1fe3dp+701,    -0x1.e652d3631f1ep-4,  -0x1.f2e794p-2, INEXACT)
T(RN,  0x1.34d514b694bd8p+701,   -0x1.1b6fa17f04411p-4,   0x1.905b2cp-3, INEXACT)
T(RN,  0x1.296bee576b15cp+701,   -0x1.d3b113df89702p-1,   0x1.1c14f6p-2, INEXACT)
T(RN,  0x1.e4300f8929dddp+702,    0x1.8aa6e8620139cp-2,  -0x1.a963dcp-3, INEXACT)
T(RN,   0x1.a07e98eed2c9p+702,   -0x1.098d9fc288c2ep-5,   0x1.6da79ap-2, INEXACT)
T(RN,  0x1.a5a4922cee663p+702,   -0x1.124bbf9213d93p-1,    0x1.61f84p-3, INEXACT)
T(RN,  0x1.b4864d1ea12b6p+702,   -0x1.a99fcd8b29888p-3,  -0x1.cb5904p-4, INEXACT)
T(RN,  0x1.e5194246298a4p+702,    0x1.611debe31d762p-2,   0x1.88322ep-2, INEXACT)
T(RN,  0x1.71226b13003a2p+702,   -0x1.87a53e065b338p-2,    0x1.d907ap-3, INEXACT)
T(RN,  0x1.d073f4d65069cp+702,    0x1.eeff2f0f8ef52p-1,   0x1.be5a0cp-2, INEXACT)
T(RN,  0x1.c5291ceac92c2p+702,    0x1.03ee9e919a3d2p-2,  -0x1.00525ep-2, INEXACT)
T(RN,  0x1.4602d72c3de88p+702,   -0x1.f92db87fd41e8p-1,   0x1.cfaa82p-2, INEXACT)
T(RN,  0x1.2e1fdc9251eabp+702,   -0x1.faeb0e90dd84dp-1,   0x1.94d3fap-3, INEXACT)
T(RN,  0x1.b29b279e98686p+703,    0x1.23d9d3d362bb8p-1,  -0x1.6d12f2p-2, INEXACT)
T(RN,   0x1.eaa77211dfc7p+703,    0x1.d4b6383de5accp-7,  -0x1.c8950ep-2, INEXACT)
T(RN,  0x1.3b08ded2711d1p+703,    -0x1.f1147efb92f6p-1,  -0x1.4f99b2p-9, INEXACT)
T(RN,  0x1.6d6003359533fp+703,    0x1.4b16b71dd7e2ap-1,  -0x1.4bb4bcp-2, INEXACT)
T(RN,   0x1.f56d714d5fa3p+703,    0x1.be5214a50c468p-1,   0x1.6dd9e4p-2, INEXACT)
T(RN,  0x1.a7034f7fd8db6p+703,   -0x1.e4c36e78f0ec5p-1,  -0x1.ad6f5ep-2, INEXACT)
T(RN,  0x1.ab5875a338beap+703,   -0x1.d838d07be95eep-1,    0x1.28b62p-2, INEXACT)
T(RN,  0x1.2a138ebcd6bc4p+703,    0x1.d297f62549094p-2,    0x1.dbe2bp-8, INEXACT)
T(RN,  0x1.e32649c7fffadp+703,   -0x1.b5308c11dbd23p-1,  -0x1.250b46p-2, INEXACT)
T(RN,  0x1.74ecfb90ca507p+703,    0x1.9c1cada0ed9e8p-1,   0x1.d583f2p-2, INEXACT)
T(RN,  0x1.c334265300712p+704,    0x1.acadda4242f4cp-1,   0x1.5eb0f6p-2, INEXACT)
T(RN,  0x1.c6f0e8efd2ccap+704,   -0x1.6b4ee0b8c952fp-2,   0x1.be264ap-2, INEXACT)
T(RN,  0x1.2f47fdf88a0ccp+704,      0x1.6a0230bb59cp-1,  -0x1.b56764p-2, INEXACT)
T(RN,  0x1.a7994b116c12ep+704,    -0x1.e495a74ee47ep-3,  -0x1.9c7822p-3, INEXACT)
T(RN,  0x1.23c57556750a3p+704,   -0x1.d00290f9acddep-1,   0x1.ea635ap-5, INEXACT)
T(RN,  0x1.df97f541bb658p+704,   -0x1.fffcd1f0d1c97p-1,   0x1.d1d91ep-4, INEXACT)
T(RN,  0x1.f55a306d9ad07p+704,    0x1.a0a6e5dbe476cp-4,   0x1.f2bb2ep-4, INEXACT)
T(RN,  0x1.b6c3078e6f7a4p+704,    0x1.4c7e6557c2374p-2,   0x1.7fe51ap-7, INEXACT)
T(RN,  0x1.cc7feaa053c36p+704,   -0x1.2ed4e10fa07cbp-1,   0x1.c1b298p-2, INEXACT)
T(RN,  0x1.2f02757174233p+704,    -0x1.e02afd122e39p-1,   0x1.48ca5ep-2, INEXACT)
T(RN,  0x1.d1c8cf9a3f0e6p+705,    -0x1.07c1154b187ap-1,  -0x1.4394e2p-3, INEXACT)
T(RN,  0x1.32ebb7068cd76p+705,    0x1.fda39b834dc5bp-1,  -0x1.aa3cd4p-2, INEXACT)
T(RN,  0x1.a3df470bc710dp+705,   -0x1.56994b2f27db7p-1,   0x1.b0e79ap-4, INEXACT)
T(RN,  0x1.6fa85209570c4p+705,     0x1.928e303dc453p-1,  -0x1.ea1c78p-5, INEXACT)
T(RN,   0x1.d530f77d3e23p+705,   -0x1.d3255ab5f948dp-3,   0x1.9e7a4ep-2, INEXACT)
T(RN,  0x1.e7c66a6b4e5d7p+705,     0x1.d0f60a4fa74ap-1,   0x1.b0ee4ap-3, INEXACT)
T(RN,  0x1.2f01530e316c4p+705,    0x1.fb4b4c082e0b6p-1,   0x1.a4898cp-5, INEXACT)
T(RN,  0x1.87502ce9454a4p+705,    0x1.c6549cc29b55ap-5,    0x1.31346p-3, INEXACT)
T(RN,  0x1.266d51b31463cp+705,    0x1.de85024991be4p-2,   0x1.d3d50ep-4, INEXACT)
T(RN,  0x1.41b948f0aa14ap+705,   -0x1.dc8f52a333539p-1,  -0x1.ea1cc4p-3, INEXACT)
T(RN,  0x1.a8a8664aaea7ep+706,   -0x1.a057c6243ca67p-1,   0x1.f5e44cp-2, INEXACT)
T(RN,  0x1.ad908ceb1bc22p+706,    0x1.339ec8ef4e038p-2,  -0x1.025fccp-5, INEXACT)
T(RN,  0x1.e0f0301bc1a9cp+706,    0x1.d0e3568143464p-3,   0x1.3e005ap-2, INEXACT)
T(RN,  0x1.40c14f8b9ca5fp+706,    0x1.4b099b5cbfa78p-1,  -0x1.486d46p-2, INEXACT)
T(RN,  0x1.0dcea13b4b8d3p+706,    0x1.801a444287877p-1,  -0x1.9d1e82p-4, INEXACT)
T(RN,  0x1.a0789e6ff777ap+706,    0x1.7c38f533f6ad4p-2,  -0x1.d72026p-2, INEXACT)
T(RN,  0x1.1d18b922e9994p+706,    0x1.fdfdf3a27be0dp-1,  -0x1.413c42p-2, INEXACT)
T(RN,  0x1.95e9d6ec543f2p+706,    0x1.197b9267bc8d8p-3,   0x1.6ceb58p-4, INEXACT)
T(RN,  0x1.dadb4a34f5d4ap+706,    0x1.1f38c4fd47862p-1,  -0x1.2ddd82p-2, INEXACT)
T(RN,  0x1.e9342caf8b0ecp+706,    0x1.cd9606f19e365p-1,  -0x1.4cb06ap-3, INEXACT)
T(RN,  0x1.000de545f0fdep+707,    0x1.24f2ee497dce8p-3,   0x1.0bcc9cp-4, INEXACT)
T(RN,  0x1.9069029c9a7aep+707,    0x1.e0ece324f3444p-3,   -0x1.20d51p-3, INEXACT)
T(RN,  0x1.7e12e9d70b6e9p+707,   -0x1.f2830187da2a7p-1,   0x1.cfcb86p-7, INEXACT)
T(RN,  0x1.76cefe9b69d3bp+707,     0x1.54e6ddce3559p-1,  -0x1.d1c60cp-2, INEXACT)
T(RN,  0x1.65da3703d2885p+707,     0x1.448dfea83ebcp-2,   0x1.217444p-3, INEXACT)
T(RN,  0x1.fea18692af9f9p+707,    0x1.84c4c1e167a8bp-1,   0x1.c390fap-9, INEXACT)
T(RN,  0x1.fbe20abd5e308p+707,    0x1.15004f3b53379p-3,  -0x1.42a44cp-4, INEXACT)
T(RN,  0x1.8aa1e51c3e8d4p+707,    0x1.bfeb14af878c1p-3,   0x1.be4298p-2, INEXACT)
T(RN,  0x1.1a1152cb44d43p+707,   -0x1.7659b276bede5p-1,   -0x1.9a46cp-2, INEXACT)
T(RN,  0x1.b25f45bd1f2a3p+707,   -0x1.bda023c0a7c4bp-4,   0x1.ccd2c4p-2, INEXACT)
T(RN,  0x1.8e94693758643p+708,    0x1.c62493e303cfbp-3,   -0x1.29e98p-2, INEXACT)
T(RN,  0x1.4c2cab23fa651p+708,   -0x1.f7e95e5d027edp-1,  -0x1.86fa3ap-3, INEXACT)
T(RN,  0x1.e3f383fb2232cp+708,    0x1.95570a0802d4fp-5,   0x1.5f7a86p-2, INEXACT)
T(RN,  0x1.18e81059bae47p+708,    0x1.8ae5bce3d60f8p-1,    -0x1.65a4p-2, INEXACT)
T(RN,  0x1.7340b422b4574p+708,   -0x1.bad45b2ed992ep-2,    0x1.de6ffp-2, INEXACT)
T(RN,  0x1.e8db6c0e4dceap+708,     0x1.2e13a72fe074p-1,  -0x1.2bb4fap-2, INEXACT)
T(RN,  0x1.3c3d07c38f889p+708,    0x1.e9a9c421e121fp-3,  -0x1.0a644ep-3, INEXACT)
T(RN,  0x1.7843068935a77p+708,    0x1.d91afdeaae905p-1,  -0x1.8fd906p-2, INEXACT)
T(RN,  0x1.d2b982c8fe9ccp+708,    0x1.cab8f29ebe32ap-1,  -0x1.d1d25ep-3, INEXACT)
T(RN,  0x1.f01c6fb08e9f2p+708,   -0x1.2874902ff1576p-4,  -0x1.436784p-3, INEXACT)
T(RN,  0x1.8e738e20579f4p+709,   -0x1.9cfae432e0d47p-3,   0x1.344b3cp-3, INEXACT)
T(RN,  0x1.deb7d88cb08b1p+709,   -0x1.334c03634d616p-4,  -0x1.cf90c2p-2, INEXACT)
T(RN,  0x1.795d726f64441p+709,   -0x1.33c8b8cdd7905p-5,   0x1.fadb4ep-8, INEXACT)
T(RN,  0x1.438f0d7ecc5e4p+709,    0x1.f86cabc64d939p-2,  -0x1.21f6b4p-3, INEXACT)
T(RN,  0x1.2752682e3dbfap+709,   -0x1.c5ee14ac08cc3p-3,  -0x1.85ce36p-3, INEXACT)
T(RN,  0x1.0476ba1e44318p+709,   -0x1.d3b54e2fb8415p-1,  -0x1.584ff4p-2, INEXACT)
T(RN,  0x1.1b8f2a86df197p+709,    -0x1.1042dd584bbap-3,    0x1.810b4p-4, INEXACT)
T(RN,  0x1.a38a11fab9287p+709,   -0x1.d4ad82f5e580bp-1,   0x1.a31a04p-2, INEXACT)
T(RN,  0x1.94a2563472372p+709,   -0x1.8810ca5f750ccp-1,   0x1.334134p-3, INEXACT)
T(RN,  0x1.d9d8678e72e1ep+709,   -0x1.fc14ddd087954p-1,  -0x1.47367ap-2, INEXACT)
T(RN,  0x1.81e0ef4a02bd6p+710,   -0x1.cf44722793067p-1,   0x1.3c9e24p-2, INEXACT)
T(RN,  0x1.4c8df71d42088p+710,    0x1.fea1fe59cb234p-1,   -0x1.970c2p-2, INEXACT)
T(RN,  0x1.d8cf17c21c408p+710,   -0x1.085fa54a9415dp-3,  -0x1.a43f28p-2, INEXACT)
T(RN,  0x1.748f6e4573f16p+710,    0x1.fb2f1e36334c3p-1,  -0x1.b242f8p-3, INEXACT)
T(RN,  0x1.c43f5ae012e97p+710,    0x1.90984e400f6c4p-3,   0x1.14ff74p-2, INEXACT)
T(RN,  0x1.509ecdf9cdf37p+710,   -0x1.9fa7e7dde974ap-1,   -0x1.abf29p-2, INEXACT)
T(RN,  0x1.d20f5f0dcc206p+710,    0x1.dba2018fb4f0fp-6,    0x1.26207p-3, INEXACT)
T(RN,  0x1.4c29c100b61d9p+710,    0x1.4ecb52e4e6e0ap-5,   0x1.439876p-2, INEXACT)
T(RN,  0x1.2499d2a36f75fp+710,    0x1.a1fe06a9955e2p-4,  -0x1.2dd344p-3, INEXACT)
T(RN,  0x1.583af4fe80c14p+710,    0x1.54180b256e1a7p-2,  -0x1.171bf6p-2, INEXACT)
T(RN,  0x1.84c377f3b028ep+711,    0x1.ab6771a74c435p-1,   0x1.63366cp-4, INEXACT)
T(RN,  0x1.bb527605403c2p+711,      0x1.fd020f4e077p-1,    0x1.118a5p-2, INEXACT)
T(RN,  0x1.3e45d0ccba3bap+711,   -0x1.fbb003515130ep-1,  -0x1.a44824p-3, INEXACT)
T(RN,   0x1.0cea2b9b13a9p+711,   -0x1.d5c16ab914762p-1,    0x1.aeff6p-2, INEXACT)
T(RN,  0x1.0706edfe96b1cp+711,   -0x1.13530e5352ecdp-1,   0x1.331b58p-2, INEXACT)
T(RN,  0x1.6c2b6b6b53b24p+711,     0x1.1c05aa1621bap-7,  -0x1.adfac2p-2, INEXACT)
T(RN,   0x1.ce1cfc6b3a62p+711,    0x1.cfb9d56e24199p-1,   0x1.555976p-6, INEXACT)
T(RN,  0x1.22a3d8d705d0ap+711,   -0x1.ffe007510098fp-1,  -0x1.b96a9ep-2, INEXACT)
T(RN,  0x1.96af9291a15a6p+711,   -0x1.e9b9f6ade1796p-1,  -0x1.4d245cp-2, INEXACT)
T(RN,  0x1.92ba5828fd166p+711,   -0x1.8e2c6d4437bf3p-2,   -0x1.176d1p-4, INEXACT)
T(RN,  0x1.ae85287bf836fp+712,    0x1.6cabd93652814p-1,   0x1.835354p-2, INEXACT)
T(RN,   0x1.9ec4df4fbf5cp+712,    0x1.b98aca7519e83p-3,  -0x1.91cb54p-5, INEXACT)
T(RN,  0x1.586639cc8f6c6p+712,    0x1.fc6d632c3b43ep-1,   0x1.cedb2cp-3, INEXACT)
T(RN,  0x1.9df130af1b383p+712,    0x1.a95116f306b85p-1,  -0x1.97343ap-2, INEXACT)
T(RN,  0x1.0c9a28fda7b8bp+712,    0x1.229d6e664df5fp-1,   0x1.d007eep-4, INEXACT)
T(RN,  0x1.813f7251a6b9ap+712,   -0x1.a48f5abef774ap-2,  -0x1.f66e5ap-3, INEXACT)
T(RN,  0x1.e0a2c4953eb3bp+712,   -0x1.97fe678e1498cp-1,   0x1.7e2eaep-4, INEXACT)
T(RN,  0x1.65126f9180206p+712,   -0x1.9b60408bcaabep-1,    0x1.2fd04p-2, INEXACT)
T(RN,  0x1.c06db787ba272p+712,    0x1.56829e4f847fap-1,  -0x1.c14928p-3, INEXACT)
T(RN,  0x1.8d615c7dc1fd4p+712,   -0x1.c37a65dd40a55p-1,  -0x1.e64facp-2, INEXACT)
T(RN,  0x1.8a2d29933e6d2p+713,   -0x1.f58d99e8baa15p-1,   0x1.13fc1ep-3, INEXACT)
T(RN,  0x1.28fc556cbebf9p+713,    0x1.cf715a4f9541cp-1,  -0x1.21b416p-2, INEXACT)
T(RN,  0x1.44554fec2fc52p+713,     -0x1.f7605213da6p-1,  -0x1.9cf6eap-2, INEXACT)
T(RN,  0x1.01c2305205ac1p+713,   -0x1.0c91cd4fe5eb9p-1,  -0x1.c5492ap-3, INEXACT)
T(RN,   0x1.78fdabd107dcp+713,   -0x1.ef01aee0a89b3p-4,  -0x1.b259fap-5, INEXACT)
T(RN,  0x1.b28d8dc158837p+713,    0x1.db450059b6a07p-1,   -0x1.08878p-2, INEXACT)
T(RN,  0x1.6d9535b822805p+713,    0x1.d3f43e8c3f832p-1,   0x1.565156p-2, INEXACT)
T(RN,  0x1.9a91beba483f3p+713,    0x1.ab0f5c9626471p-1,   -0x1.99421p-3, INEXACT)
T(RN,  0x1.93aad7c3ffe52p+713,    0x1.c4e6af0688b9dp-1,   0x1.837494p-2, INEXACT)
T(RN,  0x1.5e86f37287404p+713,    0x1.298b5ac42dda4p-1,  -0x1.946744p-4, INEXACT)
T(RN,  0x1.fe0f749f2b722p+714,    0x1.f5b28f923c578p-1,  -0x1.c473e6p-2, INEXACT)
T(RN,  0x1.846a082a22112p+714,   -0x1.4c0e274b4db61p-3,   0x1.9b1feep-2, INEXACT)
T(RN,  0x1.ca9618af657bep+714,   -0x1.76136249d1a8ap-1,   0x1.4a0854p-2, INEXACT)
T(RN,  0x1.8ba57d50ca7ecp+714,    0x1.f4d1efbea158ep-1,   0x1.38b5f4p-4, INEXACT)
T(RN,  0x1.aff410215605ep+714,   -0x1.d5c0e48be2ea2p-3,    0x1.05838p-2, INEXACT)
T(RN,  0x1.bb0e7d4ca02d8p+714,    0x1.ff3535a743c59p-1,   0x1.089b9ep-2, INEXACT)
T(RN,  0x1.cefd90f1039d2p+714,    0x1.da4014efffa1ep-1,  -0x1.dd1984p-2, INEXACT)
T(RN,  0x1.bd5ac057fa04cp+714,   -0x1.c08e51b5f2445p-2,  -0x1.b87c3ap-2, INEXACT)
T(RN,  0x1.b262bf9615782p+714,   -0x1.6ffcae0d11ddap-1,  -0x1.a52ac4p-3, INEXACT)
T(RN,  0x1.72d436e320041p+714,    0x1.c16632872d0c5p-5,   0x1.0418e4p-3, INEXACT)
T(RN,  0x1.151964c00d983p+715,   -0x1.8cc7bd80bb42fp-3,  -0x1.4a8c4ap-6, INEXACT)
T(RN,  0x1.72e5842acfad7p+715,    0x1.7aca67496b8fap-1,   0x1.cfa988p-2, INEXACT)
T(RN,  0x1.852eec82e1272p+715,    0x1.e0283c65cdfc5p-3,   0x1.04e0f4p-2, INEXACT)
T(RN,   0x1.4b3e43a372b8p+715,   -0x1.fce37171d866ep-1,   -0x1.81ef1p-2, INEXACT)
T(RN,  0x1.bd796627c74f9p+715,    0x1.2da2aa04fc16ap-1,    0x1.ca05dp-3, INEXACT)
T(RN,  0x1.8ed4820f7c03ep+715,   -0x1.114ba4b6fcc71p-1,   0x1.da9564p-2, INEXACT)
T(RN,  0x1.bcff6ac3bbc0ep+715,   -0x1.8d4d863d2d084p-2,   0x1.e90556p-5, INEXACT)
T(RN,  0x1.4511044c1d5f4p+715,   -0x1.fff66ca5e77cep-1,   0x1.6d8cacp-2, INEXACT)
T(RN,  0x1.271c32f909d54p+715,   -0x1.dcc766ae56f15p-1,  -0x1.eb6488p-4, INEXACT)
T(RN,   0x1.1cfa4dd88b11p+715,   -0x1.c6611008d167dp-2,    0x1.d024ap-2, INEXACT)
T(RN,  0x1.c87a229d97238p+716,   -0x1.d173da2cf7b22p-1,    0x1.2fde1p-2, INEXACT)
T(RN,  0x1.0bdfdba9f9b9fp+716,    0x1.ac727b5e9a4a3p-1,   0x1.632176p-2, INEXACT)
T(RN,  0x1.b7f9c4ce961afp+716,   -0x1.bb7d038287219p-1,   -0x1.1a052p-2, INEXACT)
T(RN,  0x1.80c4f9311f494p+716,    0x1.8727139af0f81p-1,  -0x1.d90ef2p-2, INEXACT)
T(RN,  0x1.76a06568c035dp+716,    0x1.d05b6c1e6f1bfp-1,   0x1.11b1bap-3, INEXACT)
T(RN,  0x1.7207aab65b5c2p+716,     0x1.4c0e8a7f66c1p-3,  -0x1.0f075ap-3, INEXACT)
T(RN,  0x1.9dbf73dfb2cedp+716,   -0x1.3e7d0adb7033fp-1,   0x1.64bd3ep-2, INEXACT)
T(RN,  0x1.4aa55a64c2f64p+716,   -0x1.e7e8a4ac9f7edp-1,  -0x1.2ea40ap-5, INEXACT)
T(RN,  0x1.84ca6647d9094p+716,    0x1.f0455da24bca5p-1,   0x1.08a02ap-3, INEXACT)
T(RN,  0x1.8271c27f82a58p+716,   -0x1.b5e4556e976f9p-1,  -0x1.436ec2p-2, INEXACT)
T(RN,  0x1.7247cca618df1p+717,   -0x1.2149ae2de3cfdp-1,  -0x1.9545b2p-8, INEXACT)
T(RN,  0x1.10f25a90d5ea3p+717,   -0x1.95bb57343f6a4p-2,    0x1.5d298p-2, INEXACT)
T(RN,  0x1.c7de64bcb1982p+717,    0x1.3236c480d6d3cp-1,   0x1.07911cp-2, INEXACT)
T(RN,  0x1.194fbbb770b27p+717,    0x1.dc19fad3ec8b3p-1,  -0x1.f233fap-2, INEXACT)
T(RN,  0x1.0a937798fd546p+717,   -0x1.1baa8657617acp-1,  -0x1.9df236p-2, INEXACT)
T(RN,  0x1.7601b8bccaabbp+717,    0x1.154c6da9075f9p-1,  -0x1.5f8acep-2, INEXACT)
T(RN,  0x1.bee0faa368b12p+717,   -0x1.c54799b9e1ef1p-1,  -0x1.bf250ep-2, INEXACT)
T(RN,  0x1.ca22d1c80c692p+717,   -0x1.f0f29c4fd031bp-1,   0x1.953888p-2, INEXACT)
T(RN,  0x1.fa20a0d0a4603p+717,   -0x1.68dc32f96e47ap-7,   0x1.eeb0dap-7, INEXACT)
T(RN,  0x1.44855da281c15p+717,    0x1.fe8e2f567d553p-1,   0x1.e07974p-2, INEXACT)
T(RN,  0x1.551d2c4240db8p+718,   -0x1.9416132ccc2b6p-2,   0x1.bab962p-4, INEXACT)
T(RN,  0x1.e35fcc281ffd8p+718,    0x1.756d4a5378695p-1,    -0x1.ad5cp-3, INEXACT)
T(RN,  0x1.3533df61febc1p+718,    0x1.26419cb4230a1p-3,   0x1.85b76ep-2, INEXACT)
T(RN,  0x1.79c52872a2804p+718,   -0x1.f3bb1378489aap-1,  -0x1.50177ap-3, INEXACT)
T(RN,  0x1.dd918ffbba1e7p+718,    0x1.39279bd0c4d46p-2,   0x1.902ca8p-2, INEXACT)
T(RN,  0x1.fda1e7c981402p+718,   -0x1.51787d3185073p-1,  -0x1.17a47ap-2, INEXACT)
T(RN,  0x1.6af67fccbfa92p+718,    0x1.2aa0bcd4357d5p-1,   0x1.376f44p-3, INEXACT)
T(RN,   0x1.914cef12d6d5p+718,   -0x1.e6a299b66491ap-2,   0x1.0c9442p-2, INEXACT)
T(RN,  0x1.f457770748964p+718,   -0x1.132e601bb7211p-2,  -0x1.cf7392p-2, INEXACT)
T(RN,  0x1.5a03ff679299cp+718,   -0x1.b118f79bb5916p-2,  -0x1.2a47d2p-2, INEXACT)
T(RN,  0x1.bfafb8178dbd8p+719,   -0x1.e838dc3783961p-1,  -0x1.e290a6p-3, INEXACT)
T(RN,  0x1.d16e07b1c9b68p+719,    0x1.b6bdd6842d669p-3,   0x1.ef8ec4p-6, INEXACT)
T(RN,  0x1.e9e3ca373e3a3p+719,    0x1.515dd14ea8e8dp-1,    -0x1.3288p-3, INEXACT)
T(RN,  0x1.0b966a3cccb43p+719,    0x1.a81844be2e5c9p-1,   0x1.dad706p-2, INEXACT)
T(RN,  0x1.e16eb4c6db264p+719,   -0x1.f91f4258dbe47p-1,  -0x1.02a77ep-3, INEXACT)
T(RN,  0x1.b4609fcbc5d3fp+719,    0x1.ff5df132b6a79p-3,   0x1.b06ec8p-2, INEXACT)
T(RN,  0x1.3b1e1824149eap+719,    0x1.fdfe1d425d81dp-1,   -0x1.3b9b7p-2, INEXACT)
T(RN,  0x1.defe46f9b0846p+719,    0x1.fc2a666ab3355p-1,   0x1.293794p-9, INEXACT)
T(RN,  0x1.8a2347503f474p+719,    0x1.7b6a689f5f766p-4,  -0x1.b6c6f6p-3, INEXACT)
T(RN,   0x1.9ff50923c029p+719,    0x1.6c6e92e9b9bfep-2,  -0x1.7d212ep-3, INEXACT)
T(RN,  0x1.5cdc32035550ep+720,    0x1.4356f4dc116a4p-2,   0x1.455294p-3, INEXACT)
T(RN,  0x1.87c6162109476p+720,   -0x1.7c87f2f1da3bbp-1,   0x1.76d468p-2, INEXACT)
T(RN,  0x1.64e07bce80dd4p+720,   -0x1.ff7677e596b82p-1,     0x1.4238p-3, INEXACT)
T(RN,  0x1.f06136ba21958p+720,    0x1.ff950a5b31ea1p-1,   0x1.df358ep-2, INEXACT)
T(RN,  0x1.32a4f2775437ap+720,    0x1.9d3fc5a0f49cfp-3,    0x1.07cefp-2, INEXACT)
T(RN,  0x1.7d029175b2c55p+720,    0x1.43627026b976bp-2,   0x1.986a36p-2, INEXACT)
T(RN,  0x1.9ba299abe6934p+720,   -0x1.3c9d9ce957dadp-1,   0x1.9dc32ep-7, INEXACT)
T(RN,  0x1.90530a8155abap+720,   -0x1.039a47b072e81p-1,   0x1.282792p-6, INEXACT)
T(RN,  0x1.db7bc3fcb0c14p+720,   -0x1.c1090b29730a1p-2,   0x1.c23d92p-2, INEXACT)
T(RN,  0x1.12a6f1979549fp+720,   -0x1.a1d728a76912dp-1,    -0x1.f9a3p-3, INEXACT)
T(RN,  0x1.c3ef43cd8cb9fp+721,     0x1.0d095ae4ba63p-3,   0x1.7258bap-3, INEXACT)
T(RN,  0x1.c5983e3eb4966p+721,    0x1.e10a75c87441ap-2,    0x1.f203cp-2, INEXACT)
T(RN,  0x1.c7324c7574a65p+721,   -0x1.4c9b5d5e761cbp-1,   -0x1.a04e6p-2, INEXACT)
T(RN,  0x1.f4e881d2583d1p+721,   -0x1.3057b3206c502p-3,  -0x1.7c125ep-2, INEXACT)
T(RN,  0x1.8dff11009a91dp+721,   -0x1.aa35a3c717899p-1,   0x1.c4ed56p-2, INEXACT)
T(RN,   0x1.fda44be0a6fdp+721,    0x1.ebeaed3cde054p-1,   -0x1.4eaadp-2, INEXACT)
T(RN,  0x1.07fae6149f28ap+721,    0x1.c9904fbb9272ep-1,   0x1.5ab5aap-2, INEXACT)
T(RN,  0x1.001345ab8ef58p+721,    0x1.bf97dec2528eep-1,   0x1.3637aap-2, INEXACT)
T(RN,  0x1.f16fec9bd6513p+721,   -0x1.89aa3a20f143dp-3,   0x1.3888bap-2, INEXACT)
T(RN,   0x1.a272b2ea4926p+721,    0x1.8637fcd8bf6fcp-1,  -0x1.2d6eecp-3, INEXACT)
T(RN,  0x1.ec17aaec72794p+722,   -0x1.bfc13ab74dc66p-1,  -0x1.7e7792p-2, INEXACT)
T(RN,  0x1.adccf8f2857cbp+722,   -0x1.134471d9e4e9ap-1,   0x1.bbc2dep-5, INEXACT)
T(RN,  0x1.607c345f0d2f6p+722,    0x1.c89d3630b9e7ep-1,   -0x1.688aep-3, INEXACT)
T(RN,  0x1.9031642d3f6ecp+722,    0x1.ace775006e289p-3,   0x1.3dd94cp-5, INEXACT)
T(RN,  0x1.39f314b23d52dp+722,   -0x1.94ef20ad267e7p-1,   -0x1.5cc5fp-3, INEXACT)
T(RN,  0x1.2cb9ba887026bp+722,    0x1.ad3d2a389cbe8p-3,  -0x1.abb53ap-5, INEXACT)
T(RN,  0x1.d64d61c108efap+722,     0x1.fdaf896630b2p-1,  -0x1.0631c8p-3, INEXACT)
T(RN,  0x1.db7ea8da303fcp+722,    0x1.c3396c0ec28c2p-1,   0x1.428744p-5, INEXACT)
T(RN,  0x1.d0a67b74de58ep+722,   -0x1.0dc637c9c547ep-1,    0x1.9dc34p-2, INEXACT)
T(RN,  0x1.badf2a2c1eb13p+722,    0x1.cc7f32a6b756cp-2,  -0x1.9051c4p-4, INEXACT)
T(RN,  0x1.ab7c56ac457d8p+723,   -0x1.6832bbb5e9b76p-1,  -0x1.9ee0a6p-3, INEXACT)
T(RN,  0x1.5e03b74467153p+723,    0x1.bdce37b074118p-3,   0x1.e25ae2p-3, INEXACT)
T(RN,  0x1.54b8ee9a09aecp+723,    0x1.10d52a561d7aep-8,  -0x1.596ddep-2, INEXACT)
T(RN,  0x1.2d3b247104ebbp+723,    0x1.c9fec9d0fabc9p-1,     0x1.2cdap-3, INEXACT)
T(RN,  0x1.081b4e9ca682cp+723,    0x1.ef9b7dc38234bp-1,   0x1.5f553ep-2, INEXACT)
T(RN,  0x1.501bd510ba4a5p+723,   -0x1.6a4528480862ap-2,  -0x1.67ac82p-2, INEXACT)
T(RN,  0x1.39f94340cff33p+723,    0x1.82c19c871e1cfp-1,  -0x1.ef7248p-3, INEXACT)
T(RN,  0x1.c29f875e22088p+723,    0x1.652b1471ece5cp-1,  -0x1.0851bcp-2, INEXACT)
T(RN,  0x1.a7f657f86463fp+723,   -0x1.ec6ecac2ecb1ep-1,  -0x1.95d48ep-2, INEXACT)
T(RN,  0x1.01cd036e73e3ep+723,   -0x1.2a5f989a1486fp-1,   0x1.d8ca9cp-4, INEXACT)
T(RN,  0x1.3fc94b250ad24p+724,    0x1.8397f2790d617p-2,   0x1.54cfd6p-2, INEXACT)
T(RN,  0x1.701710f7938aap+724,    0x1.f666066f38b11p-1,  -0x1.f51bbep-3, INEXACT)
T(RN,  0x1.3d2fa5a0c8586p+724,     0x1.ffd3f6cd3999p-1,   0x1.ed473ap-2, INEXACT)
T(RN,  0x1.b3555e6743942p+724,   -0x1.fba293e5463d9p-1,   0x1.8e4aaap-4, INEXACT)
T(RN,  0x1.ae251f2e88b8ap+724,    0x1.fde4a090a5d94p-1,   0x1.fc6e84p-2, INEXACT)
T(RN,   0x1.fca96b8431a9p+724,   -0x1.7239c79d99176p-1,  -0x1.57ca9ep-2, INEXACT)
T(RN,  0x1.ae812f0c9ad1cp+724,   -0x1.f2d3ac9247f8cp-1,   -0x1.d65cep-2, INEXACT)
T(RN,  0x1.99cca659d1803p+724,    0x1.f3544a94cb632p-1,  -0x1.3ff6c8p-3, INEXACT)
T(RN,  0x1.05b600be8b50cp+724,   -0x1.ed49fc24e4455p-4,   -0x1.d3349p-5, INEXACT)
T(RN,  0x1.005db43fa0e25p+724,    0x1.859e3bad2da1ap-1,   0x1.f31d64p-3, INEXACT)
T(RN,  0x1.08f23bbadb94fp+725,    0x1.3a39bf2778ee7p-1,   0x1.be1d12p-2, INEXACT)
T(RN,  0x1.70eec62f0158cp+725,    0x1.e966e3234139ep-1,  -0x1.75e51ap-2, INEXACT)
T(RN,  0x1.9153869ace83ep+725,    0x1.aecade991e423p-1,   0x1.807be8p-2, INEXACT)
T(RN,  0x1.a5344bcfde023p+725,    0x1.a47c157195d45p-1,  -0x1.c0feb2p-5, INEXACT)
T(RN,  0x1.e82521e19013ap+725,   -0x1.f7ed1cd0b7a28p-2,   0x1.7c124cp-3, INEXACT)
T(RN,  0x1.7a6d8641bee4fp+725,   -0x1.f3fdbc9d836d8p-1,  -0x1.2fd9d6p-3, INEXACT)
T(RN,  0x1.0d266aa67699bp+725,   -0x1.06a788bcd32e1p-1,   0x1.6cad44p-2, INEXACT)
T(RN,  0x1.7afe6186e444ap+725,   -0x1.62a33e76ae3fep-1,   0x1.058402p-2, INEXACT)
T(RN,   0x1.34f17b679d17p+725,    0x1.f832ef252065ep-1,  -0x1.0b463cp-4, INEXACT)
T(RN,  0x1.72547923c2a86p+725,   -0x1.04d5afb1b5a66p-2,   0x1.aa8d02p-2, INEXACT)
T(RN,  0x1.51247872a1497p+726,    0x1.512b1a8466f06p-1,  -0x1.3af9eep-3, INEXACT)
T(RN,   0x1.1b13447e59d9p+726,   -0x1.a17bba8d737b8p-4,  -0x1.abf138p-2, INEXACT)
T(RN,  0x1.dbe7856c825a7p+726,   -0x1.79b6998709cf7p-2,  -0x1.6ea648p-4, INEXACT)
T(RN,  0x1.b63eb3ec91c77p+726,   -0x1.d2274d79cf06dp-4,  -0x1.64e726p-2, INEXACT)
T(RN,  0x1.db737a61c411bp+726,   -0x1.bf14a0ad8f152p-1,  -0x1.63717ap-2, INEXACT)
T(RN,  0x1.f26ce7a2aa00dp+726,    0x1.d08c018b251c8p-1,   -0x1.54676p-4, INEXACT)
T(RN,  0x1.8611110b1df54p+726,    0x1.2edd3fdb26de9p-2,  -0x1.a1d4b8p-2, INEXACT)
T(RN,  0x1.4c95f6af6e2e9p+726,   -0x1.b77dde87cd76fp-2,   0x1.1f1d72p-2, INEXACT)
T(RN,  0x1.e601628533fa4p+726,     0x1.f95fa4c4e0fbp-2,  -0x1.a37992p-2, INEXACT)
T(RN,  0x1.fb55f72e898dep+726,   -0x1.7ed8a8d7cc895p-7,   0x1.f6062cp-2, INEXACT)
T(RN,  0x1.9cb5a16317e9fp+727,    0x1.fc3d7960eaaa5p-1,   0x1.f1d526p-2, INEXACT)
T(RN,  0x1.1bcfd70e8818ap+727,    0x1.ca2263f79c35fp-2,  -0x1.c3b60cp-2, INEXACT)
T(RN,  0x1.3a47f491080dcp+727,    0x1.f4d571d846bf9p-1,   0x1.273f9cp-2, INEXACT)
T(RN,    0x1.f1db24ebabfp+727,   -0x1.6e22bebfade6bp-1,  -0x1.e291eap-6, INEXACT)
T(RN,  0x1.22eb1d00a55acp+727,   -0x1.65f323f600a16p-1,    0x1.c8f76p-5, INEXACT)
T(RN,  0x1.de45ba0257133p+727,    0x1.b28ee3801a9cap-1,  -0x1.543794p-3, INEXACT)
T(RN,  0x1.33e4c21998a22p+727,    0x1.6ce0bc4c832aep-1,  -0x1.437f18p-2, INEXACT)
T(RN,   0x1.84f3fccac83ep+727,    0x1.1f1f5a5a0f831p-1,  -0x1.66848ap-2, INEXACT)
T(RN,  0x1.2d45b53c5beddp+727,   -0x1.85a08c9263831p-2,  -0x1.5eea38p-2, INEXACT)
T(RN,  0x1.bdd9d98c8f50dp+727,   -0x1.ff64e8773ea9cp-1,   0x1.cc7ecep-3, INEXACT)
T(RN,  0x1.4c25188f06361p+728,    0x1.84e89b1c8aa94p-1,   0x1.3c8a22p-3, INEXACT)
T(RN,  0x1.f2b49d9d4b4b2p+728,   -0x1.905a8a46cff7bp-3,  -0x1.fe04a4p-2, INEXACT)
T(RN,  0x1.ead78945c72d1p+728,   -0x1.c8b1b2c287b76p-2,   0x1.0d7b2ap-2, INEXACT)
T(RN,  0x1.90d2ee9f041efp+728,    0x1.4326d9ccebef9p-2,   0x1.dfd6eep-4, INEXACT)
T(RN,  0x1.a947aa67ff5f4p+728,   -0x1.ba5d40190f83ep-1,   0x1.0f02c4p-3, INEXACT)
T(RN,  0x1.878dd017088f1p+728,   -0x1.bde444dce44a7p-1,   0x1.1f3f5cp-4, INEXACT)
T(RN,  0x1.f5b9d21d95fcbp+728,    -0x1.be593aeccd69p-1,   0x1.0fef56p-2, INEXACT)
T(RN,  0x1.3e4be91a46ca3p+728,   -0x1.ab01df94e7461p-5,   0x1.f6a82cp-9, INEXACT)
T(RN,  0x1.9d1af17b44f06p+728,    0x1.73f73cefd7545p-1,   0x1.825a68p-3, INEXACT)
T(RN,  0x1.18612dd4981acp+728,   -0x1.c774330bde9f1p-1,   0x1.ce4be2p-2, INEXACT)
T(RN,  0x1.da361e7df596bp+729,     0x1.ebb806bdd7a1p-1,  -0x1.6c1674p-5, INEXACT)
T(RN,  0x1.8b839417a389fp+729,   -0x1.ebddffdb3d28bp-1,   0x1.fbf4a6p-3, INEXACT)
T(RN,  0x1.fd385990fa49ep+729,   -0x1.fd238edc69c4ap-1,  -0x1.f3c96cp-2, INEXACT)
T(RN,   0x1.57cf307cd1a2p+729,   -0x1.198d3e26a4f9ep-1,  -0x1.89bb28p-3, INEXACT)
T(RN,  0x1.e056f11ed4debp+729,    0x1.fe40b68e7da54p-1,   0x1.dd0e32p-3, INEXACT)
T(RN,  0x1.f209d8792d918p+729,   -0x1.fdb6469c9d27ap-1,    0x1.23f5ap-2, INEXACT)
T(RN,  0x1.1d7feb69ef534p+729,   -0x1.2818c4faece83p-4,   0x1.5af2c4p-3, INEXACT)
T(RN,  0x1.0e2ed9e0a7572p+729,   -0x1.ff21ebfdc6fc1p-1,   0x1.4a81f2p-4, INEXACT)
T(RN,  0x1.4eb84795ddecep+729,    0x1.07bf56cb0fa2bp-2,   0x1.e3a798p-2, INEXACT)
T(RN,  0x1.071df1a81ea3ep+729,   -0x1.2db7c3b435397p-1,  -0x1.4a64c8p-2, INEXACT)
T(RN,   0x1.53603a1f5964p+730,    0x1.f6daf9a08905fp-1,  -0x1.d0b3b2p-2, INEXACT)
T(RN,  0x1.c2a2e25873078p+730,   -0x1.ea93cbaf5c779p-2,   -0x1.531ccp-2, INEXACT)
T(RN,  0x1.844b7a6d46678p+730,   -0x1.a0170a8e75221p-1,  -0x1.f0efc8p-7, INEXACT)
T(RN,  0x1.f450d9eb8f8a4p+730,    0x1.f199bb5030b03p-1,   0x1.e0778cp-2, INEXACT)
T(RN,  0x1.a7b90323313bfp+730,    0x1.8946120bec1fbp-4,  -0x1.a673e6p-2, INEXACT)
T(RN,  0x1.468ce0c7f873ep+730,   -0x1.c56dd575e98fap-2,   0x1.c5a716p-3, INEXACT)
T(RN,    0x1.9625ae7c416p+730,    0x1.d001ac4fb8e8cp-5,  -0x1.28f8fcp-2, INEXACT)
T(RN,  0x1.34541de2f3829p+730,   -0x1.b86b7a7526e72p-1,  -0x1.faf70ep-2, INEXACT)
T(RN,     0x1.152ca0960bp+730,   -0x1.38453f2380b29p-2,  -0x1.a2178ep-4, INEXACT)
T(RN,  0x1.61db071907465p+730,   -0x1.8c576a4e5dc3cp-8,   -0x1.3801fp-3, INEXACT)
T(RN,  0x1.8c80ade51d961p+731,   -0x1.c641a2277484ep-1,   0x1.cf524ap-5, INEXACT)
T(RN,  0x1.e8bb3b85d18cep+731,   -0x1.83c490232538dp-5,   -0x1.56625p-3, INEXACT)
T(RN,  0x1.fa85a7ca06998p+731,   -0x1.6811e2db25118p-1, -0x1.087d66p-12, INEXACT)
T(RN,  0x1.2e562fd4345a2p+731,    0x1.b2f775428c659p-1,   0x1.53c41ap-2, INEXACT)
T(RN,  0x1.a1cc6679f381ap+731,   -0x1.e3a25ee59d406p-1,   0x1.41ca68p-2, INEXACT)
T(RN,  0x1.445baabed1418p+731,   -0x1.364928f595c85p-1,   0x1.9549aap-5, INEXACT)
T(RN,  0x1.a302255343448p+731,    0x1.e283366ac58d1p-2,  -0x1.474d36p-2, INEXACT)
T(RN,  0x1.b7576d11d3052p+731,   -0x1.2fc749875558dp-1,   0x1.d4bfdap-2, INEXACT)
T(RN,  0x1.dcbf325e4d0f6p+731,   -0x1.8c1e15a31d0ffp-4,   0x1.019072p-2, INEXACT)
T(RN,  0x1.084ebba9188a8p+731,   -0x1.376c2e5d882fep-1,   0x1.f7895ep-2, INEXACT)
T(RN,   0x1.80ea1aec1a5fp+732,    0x1.53d958f31a287p-1,  -0x1.b9048cp-3, INEXACT)
T(RN,  0x1.fcceef86dcfb7p+732,   -0x1.fff527dc0ea14p-1,   0x1.139d68p-2, INEXACT)
T(RN,  0x1.4def444766e0ap+732,   -0x1.65e74ec6a8487p-1,  -0x1.06ed0ep-3, INEXACT)
T(RN,  0x1.77ddf61a3daa7p+732,   -0x1.df8ea62694b81p-2,  -0x1.d3a38ep-2, INEXACT)
T(RN,  0x1.e67ba9dbea946p+732,   -0x1.9af7362277fefp-4,    0x1.94dd6p-4, INEXACT)
T(RN,  0x1.589ed846aeea2p+732,   -0x1.722d05178ee1bp-1,  -0x1.229068p-3, INEXACT)
T(RN,  0x1.23c603543a5d5p+732,    0x1.ee493ca20548dp-1,   0x1.9e8c5cp-4, INEXACT)
T(RN,  0x1.040d3f80e10a5p+732,   -0x1.373039a9ade62p-2,   -0x1.36b05p-3, INEXACT)
T(RN,  0x1.0d6f0982e070ep+732,    0x1.88eb00c6a1e7ap-1,   0x1.e34044p-4, INEXACT)
T(RN,  0x1.1b89539074b7ep+732,    0x1.0cf480300eb44p-3,  -0x1.9b31ecp-2, INEXACT)
T(RN,  0x1.241b0b9f3f1d8p+733,    0x1.13a0bec461146p-1,   0x1.654494p-2, INEXACT)
T(RN,  0x1.d38c833947084p+733,   -0x1.ccbd4b7e74faap-3,  -0x1.1634f4p-3, INEXACT)
T(RN,  0x1.0f47d243225afp+733,   -0x1.f3dbadd5f6dbfp-1,  -0x1.8bcb5cp-2, INEXACT)
T(RN,  0x1.603bcc2e64ad6p+733,   -0x1.ec8b6e9e2cbd3p-1,  -0x1.4b96f6p-3, INEXACT)
T(RN,   0x1.0b0568115c34p+733,   -0x1.4335ea4298d9ap-2,   -0x1.5da8dp-2, INEXACT)
T(RN,  0x1.afa9cab775c8cp+733,    0x1.fd05ce47cc368p-1,  -0x1.3156bcp-2, INEXACT)
T(RN,  0x1.ae25f9eaf0247p+733,   -0x1.c5f71829281f5p-6,  -0x1.74812ap-4, INEXACT)
T(RN,   0x1.34cd2d475985p+733,    0x1.90d78447e6932p-1,   0x1.b11d1cp-3, INEXACT)
T(RN,  0x1.226a418bd0bbdp+733,    0x1.a050efb1da5c2p-2,  -0x1.d851e2p-2, INEXACT)
T(RN,  0x1.d10b590c11576p+733,   -0x1.2df0c0862123ep-3,    0x1.0ef42p-5, INEXACT)
T(RN,   0x1.9a130f530eb5p+734,   -0x1.bc90454596e1fp-1,    0x1.f8108p-2, INEXACT)
T(RN,  0x1.1515e2a773edap+734,    0x1.1323049baf457p-4,   -0x1.ea2e6p-2, INEXACT)
T(RN,  0x1.8c882c80f2158p+734,    0x1.fff87cdda16a6p-1,    0x1.67055p-5, INEXACT)
T(RN,  0x1.d4dad9546a0c2p+734,    0x1.a5d129199f16dp-2,  -0x1.f6f8c4p-2, INEXACT)
T(RN,  0x1.d0f956c2528b4p+734,    0x1.0e046709502c7p-1,   0x1.f58962p-2, INEXACT)
T(RN,  0x1.fb86b2c73aae4p+734,   -0x1.d691b3013a9f9p-1,    0x1.6a4e8p-5, INEXACT)
T(RN,  0x1.1cb3c0c0e380dp+734,   -0x1.6fe47c11d2ad4p-3,   0x1.c7777cp-3, INEXACT)
T(RN,  0x1.afd6f7dc1806cp+734,    0x1.18d47426eb81cp-1,   0x1.4dd4a8p-4, INEXACT)
T(RN,  0x1.449b79323860dp+734,    0x1.de056c05921efp-1,  -0x1.a18408p-2, INEXACT)
T(RN,  0x1.00cc03f8be539p+734,   -0x1.2c4f75f1d0488p-6,   0x1.434bd6p-2, INEXACT)
T(RN,  0x1.5460a6bb8031ep+735,   -0x1.f490fe5ec1772p-2,   0x1.293f58p-5, INEXACT)
T(RN,  0x1.88627d967e4d2p+735,    0x1.5fe8d4c9693e5p-2,   0x1.44b8bep-2, INEXACT)
T(RN,  0x1.82edf418b73ddp+735,    0x1.92e74092d3241p-3,  -0x1.fc43aep-5, INEXACT)
T(RN,  0x1.4d4b611bfccfap+735,    0x1.dff0786228fbbp-2,  -0x1.1c9a44p-2, INEXACT)
T(RN,  0x1.6e6f21b2b31dap+735,    0x1.323dfdcd3fa3ep-2,  -0x1.90aed6p-4, INEXACT)
T(RN,  0x1.801a1f6fe911ap+735,   -0x1.e578ede36d7f9p-1,   0x1.b36ee2p-2, INEXACT)
T(RN,  0x1.a3f437409faedp+735,   -0x1.569e3b7b74a6dp-2,   0x1.0ad1d6p-2, INEXACT)
T(RN,  0x1.ce869481528c2p+735,    0x1.f73f4435d753ap-1,   0x1.d51b2ep-2, INEXACT)
T(RN,  0x1.3852d98ed84ccp+735,    0x1.b8c6f8e59dabcp-1,  -0x1.f14402p-4, INEXACT)
T(RN,  0x1.697dabb6d502bp+735,   -0x1.dd2e855d6598cp-2,     0x1.93bep-3, INEXACT)
T(RN,  0x1.e95fd01b731b3p+736,   -0x1.ff8a507a1c747p-1,   0x1.e32118p-3, INEXACT)
T(RN,  0x1.317f6b2be3332p+736,    0x1.f88487d1cf042p-1,  -0x1.08a6a4p-3, INEXACT)
T(RN,  0x1.32e2fca292d32p+736,    0x1.69da7518b9d63p-7,  -0x1.68372ap-3, INEXACT)
T(RN,  0x1.66c3d825fa618p+736,   -0x1.5975dfc22ee13p-1,   0x1.5fffd4p-5, INEXACT)
T(RN,  0x1.eb950be76d447p+736,   -0x1.a38b1430d8092p-1,  -0x1.92adaep-2, INEXACT)
T(RN,  0x1.2cc468967e8a1p+736,   -0x1.d56e0c657a487p-2,   0x1.599222p-2, INEXACT)
T(RN,  0x1.93982e5f95cfap+736,   -0x1.dbe9171ab48ccp-1,   0x1.fbef2cp-2, INEXACT)
T(RN,  0x1.951fcf034bfc9p+736,   -0x1.b78dc6f3df0a2p-1,  -0x1.4b11c4p-3, INEXACT)
T(RN,  0x1.08d1498cde212p+736,   -0x1.b6785eb72b08dp-4,   0x1.b90a18p-2, INEXACT)
T(RN,  0x1.fd8e0d70780f5p+736,    0x1.9aff907f9a1b9p-1,  -0x1.e43338p-3, INEXACT)
T(RN,   0x1.535a4f63cd0bp+737,    0x1.edb1459d9fc74p-1,    0x1.7cf31p-2, INEXACT)
T(RN,  0x1.3e21e8c3fc16fp+737,   -0x1.aa3ebcc094fcep-1,    0x1.6be8fp-4, INEXACT)
T(RN,  0x1.d7234ba29d716p+737,   -0x1.47e9d34e1321bp-3,   0x1.3bdf54p-4, INEXACT)
T(RN,  0x1.b9d618a70ca04p+737,    0x1.2d5fe7d94c168p-1,  -0x1.b51a3ap-8, INEXACT)
T(RN,  0x1.ae238e8e1c13cp+737,   -0x1.fff274b011b5dp-1,  -0x1.c54af6p-3, INEXACT)
T(RN,  0x1.95eb5747779f7p+737,   -0x1.cb6540b14f8d9p-2,   -0x1.1a8f5p-2, INEXACT)
T(RN,  0x1.3d78643dcd94dp+737,   -0x1.c1c56ce43862cp-2,  -0x1.c714dep-2, INEXACT)
T(RN,  0x1.5c04ee8aea0d1p+737,   -0x1.30560327648b1p-1,   0x1.a0a6aap-3, INEXACT)
T(RN,  0x1.50cde866cc3c7p+737,   -0x1.7c984d6f38817p-2,  -0x1.7e7ebep-3, INEXACT)
T(RN,  0x1.e70607e7f0cf8p+737,    0x1.fff00a91b1aaep-1,   0x1.a52b12p-2, INEXACT)
T(RN,  0x1.d64c42a9a1338p+738,   -0x1.949328151d6a3p-1,    0x1.efc3fp-2, INEXACT)
T(RN,  0x1.91de6f3ec03b4p+738,    0x1.036dfde49c922p-2,   -0x1.7743dp-2, INEXACT)
T(RN,  0x1.4677ecb14b6f6p+738,   -0x1.cc5dcce3e0cb3p-3,   0x1.40092ap-3, INEXACT)
T(RN,  0x1.36488cc4b0627p+738,    0x1.c0d652b853f13p-2,   0x1.9d363ap-2, INEXACT)
T(RN,  0x1.71659374c419ap+738,   -0x1.af294e2b8857ep-2,  -0x1.1a9378p-2, INEXACT)
T(RN,   0x1.0a4e3e206f8cp+738,    0x1.772b38001f358p-4,   0x1.f33872p-6, INEXACT)
T(RN,  0x1.b4778050d8738p+738,    0x1.ffb2019c7e54ep-1,   0x1.eae0ecp-3, INEXACT)
T(RN,  0x1.194fb84597625p+738,    0x1.dd9a09fe9358dp-1,  -0x1.2aab9ap-2, INEXACT)
T(RN,  0x1.09b15026e13efp+738,   -0x1.d04a5e04e1556p-1,   0x1.ae90d4p-8, INEXACT)
T(RN,  0x1.73eabd6f0fb0bp+738,   -0x1.6c6977057d53fp-2,   0x1.5f07cap-3, INEXACT)
T(RN,  0x1.8611f2693ae68p+739,     0x1.ffbe7a6d8c57p-1,  -0x1.617004p-2, INEXACT)
T(RN,  0x1.8661e06d8e2bep+739,    0x1.cdc1801a8ae57p-1,   0x1.9f505cp-2, INEXACT)
T(RN,  0x1.06e10cf800021p+739,   -0x1.8639bf1f74ec8p-2,  -0x1.f8994ap-3, INEXACT)
T(RN,  0x1.b4e2a9df53c8fp+739,    0x1.f1bb0ae82e99cp-1,   0x1.6ec216p-2, INEXACT)
T(RN,  0x1.95f42fb42055bp+739,   -0x1.ab291c9d573d1p-1,  -0x1.6d6232p-2, INEXACT)
T(RN,  0x1.82479f28c10b7p+739,    0x1.cc686d416a754p-1,  -0x1.4b5a92p-8, INEXACT)
T(RN,   0x1.a356334f432fp+739,     0x1.de3d5c49a6e9p-1,  -0x1.7bfb86p-3, INEXACT)
T(RN,  0x1.46b0919d228d8p+739,   -0x1.b8ab2dcae8fe9p-1,  -0x1.815c44p-3, INEXACT)
T(RN,  0x1.bdb9389f01579p+739,   -0x1.df237cbd128edp-1,   0x1.6e9406p-7, INEXACT)
T(RN,  0x1.ed9abd27545b2p+739,   -0x1.89fca40f6e0d1p-1,   0x1.299ddap-4, INEXACT)
T(RN,  0x1.f64679ffe8cd4p+740,    -0x1.773b1c884e7fp-2,   0x1.30bd0cp-2, INEXACT)
T(RN,  0x1.5242225466883p+740,   -0x1.b8863007279dcp-1,  -0x1.a1ae4p-10, INEXACT)
T(RN,  0x1.60c31f9293d4ap+740,   -0x1.e75af697d8e0cp-1,   0x1.4017c2p-2, INEXACT)
T(RN,  0x1.c0f706c1a1eabp+740,    0x1.d105cc9b574cfp-2,   -0x1.9e073p-3, INEXACT)
T(RN,  0x1.c59ac21275e56p+740,    0x1.6bc2b4c836662p-1,  -0x1.55ebf2p-2, INEXACT)
T(RN,  0x1.6c5a4a46eefa1p+740,   -0x1.f103c8fee5dcdp-1,   0x1.534e3ep-2, INEXACT)
T(RN,  0x1.d3ccdf4a77b0ap+740,    0x1.a4e6cae4a058bp-1,   0x1.b20034p-3, INEXACT)
T(RN,  0x1.9157e86997b8ap+740,    0x1.2ee1f10490f17p-2,   0x1.74d6f2p-3, INEXACT)
T(RN,  0x1.c4f0d564d91edp+740,    0x1.18600e87ffa72p-2,  -0x1.d5006ap-2, INEXACT)
T(RN,  0x1.d67abddd9baf4p+740,   -0x1.af8c61d885b4ep-1,  -0x1.970bd8p-2, INEXACT)
T(RN,  0x1.7dffbff0449bcp+741,   -0x1.e138510ad55c9p-1,   -0x1.67523p-2, INEXACT)
T(RN,  0x1.8c72eb95a3ef5p+741,   -0x1.7cd1e51f3e377p-1,   0x1.399352p-3, INEXACT)
T(RN,  0x1.61499bfe31478p+741,   -0x1.3eefa74c9c2cep-1,   0x1.06971ep-2, INEXACT)
T(RN,  0x1.3fd286e55803ep+741,    0x1.f9074eac4b4e3p-2,   0x1.e1ba18p-5, INEXACT)
T(RN,  0x1.ce5f543624e12p+741,    0x1.49f4bbdc27dbap-1,  -0x1.2bad66p-2, INEXACT)
T(RN,  0x1.26f487ee8b05cp+741,     0x1.77534950be5ep-1,  -0x1.407262p-2, INEXACT)
T(RN,  0x1.f0308b36bbd4ap+741,   -0x1.371ba658b651dp-2,  -0x1.64e21ep-7, INEXACT)
T(RN,  0x1.b6c6b920f3f2ap+741,   -0x1.a61d322b4b957p-1,  -0x1.a82d06p-5, INEXACT)
T(RN,  0x1.bf0a2f70a141cp+741,   -0x1.e631687ab50bep-1,  -0x1.487b26p-2, INEXACT)
T(RN,  0x1.5be7e39b164e8p+741,    0x1.904f8ec3ce0f2p-3,  -0x1.fce2f4p-3, INEXACT)
T(RN,  0x1.ddbb0c65ce6a8p+742,   -0x1.cf6055bcbac4bp-1,  -0x1.d664ccp-6, INEXACT)
T(RN,  0x1.a1c484ba786bep+742,   -0x1.f82dbe94930aep-1,  -0x1.753194p-3, INEXACT)
T(RN,  0x1.3ecf53626133ap+742,   -0x1.0ed31e2bdc8f1p-4,   -0x1.2707fp-5, INEXACT)
T(RN,  0x1.524f5d95ccf54p+742,   -0x1.57f4c5724c7dfp-1,   0x1.174228p-3, INEXACT)
T(RN,  0x1.c592120a078e2p+742,    0x1.5af3b3adc0b9cp-1,  -0x1.e2d53ep-2, INEXACT)
T(RN,  0x1.31e6db902f552p+742,   -0x1.39ff47b7c92d5p-2,   0x1.e5eaa6p-2, INEXACT)
T(RN,  0x1.bb0ab8f6ee6c8p+742,    0x1.65d4953d3b4c1p-5,  -0x1.e28a78p-3, INEXACT)
T(RN,   0x1.d7a3804ec32ep+742,    0x1.5a71935d4a3a8p-2,   0x1.ba4ff4p-2, INEXACT)
T(RN,  0x1.9c4ab84bc894bp+742,    0x1.e5679dc424afap-1,  -0x1.49f8a4p-7, INEXACT)
T(RN,  0x1.afa874f074374p+742,   -0x1.79dbc105dc1d1p-1,   0x1.e4b69ep-4, INEXACT)
T(RN,  0x1.567f7db2fa994p+743,    0x1.f7f1d1903d421p-1,    0x1.24166p-2, INEXACT)
T(RN,  0x1.c52e6059ac6d2p+743,    0x1.ffbd787922b12p-1,   0x1.1c1c24p-3, INEXACT)
T(RN,  0x1.9f9c36cf49b22p+743,   -0x1.9646a501c4f65p-1,   0x1.e2a9b2p-2, INEXACT)
T(RN,  0x1.9481470fba0cap+743,   -0x1.99077113c6e3cp-1,   0x1.45f3a8p-7, INEXACT)
T(RN,  0x1.5f155f0d08e57p+743,    0x1.52e7f28557114p-1,  -0x1.f82b68p-2, INEXACT)
T(RN,  0x1.85e9597d2baf2p+743,    0x1.b2dc1b3df8ff6p-1,   0x1.a17022p-5, INEXACT)
T(RN,   0x1.1ca1e495789bp+743,    0x1.c5fc8a1bf1fe5p-5,  -0x1.a0a8fep-4, INEXACT)
T(RN,   0x1.1b1c66ffc292p+743,   -0x1.5d94d8c6d0387p-2,   0x1.537aaap-2, INEXACT)
T(RN,  0x1.33c1933abaf4ap+743,     0x1.94e5e1090769p-2,   0x1.2c14bcp-2, INEXACT)
T(RN,  0x1.7eb4c3bb53dd1p+743,   -0x1.85c721ab106b8p-2,   0x1.de7324p-3, INEXACT)
T(RN,  0x1.fa837b786e807p+744,    0x1.de39f0452eb06p-1,  -0x1.fde5dcp-2, INEXACT)
T(RN,  0x1.9f9f54624c4d6p+744,   -0x1.749ed6749d2fep-2,  -0x1.414664p-3, INEXACT)
T(RN,  0x1.61172039297e8p+744,   -0x1.1994edbbfba0ep-2,  -0x1.a1e2a8p-2, INEXACT)
T(RN,  0x1.4ce4c89a381e8p+744,    0x1.d9650b2aff69cp-3,   0x1.1680b4p-4, INEXACT)
T(RN,  0x1.1da4be885d47cp+744,    0x1.e0ed63feabae5p-3,   0x1.dd4db4p-2, INEXACT)
T(RN,  0x1.80345c0940519p+744,    0x1.c859237cff3e4p-1,   0x1.5b91eep-3, INEXACT)
T(RN,  0x1.5ec348a0f193ap+744,   -0x1.7bd5651c837e8p-2,  -0x1.bcd294p-2, INEXACT)
T(RN,  0x1.77bf787aad068p+744,   -0x1.20276d25cb934p-4,  -0x1.6bc44cp-3, INEXACT)
T(RN,  0x1.146398d9c5b15p+744,    0x1.05f95024b52f8p-1,  -0x1.b55b52p-6, INEXACT)
T(RN,  0x1.d178468ab90ccp+744,   -0x1.ef96abaf5591cp-1,  -0x1.a74426p-2, INEXACT)
T(RN,  0x1.8aa98e4c34db8p+745,    0x1.fa70bfa79b66ap-3,   0x1.4f623ep-2, INEXACT)
T(RN,  0x1.111c53d1702eap+745,    0x1.73dd94ddb80b2p-1,  -0x1.b2b112p-2, INEXACT)
T(RN,  0x1.8c04e9a31d025p+745,     0x1.8919354998d6p-1,   0x1.90ef7ep-2, INEXACT)
T(RN,  0x1.29cd59c151a0cp+745,   -0x1.36d4d16f2ce51p-4,   0x1.7129dcp-2, INEXACT)
T(RN,  0x1.e11bbe209a147p+745,   -0x1.ff4cc1f97eb7dp-1,   0x1.574094p-2, INEXACT)
T(RN,  0x1.6cb5b43e48473p+745,   -0x1.e31468d65b65bp-1,   0x1.87f114p-7, INEXACT)
T(RN,  0x1.46644bb1be29cp+745,   -0x1.fc0d0888bceaep-1,  -0x1.267dccp-3, INEXACT)
T(RN,  0x1.2d617e324fb88p+745,    0x1.e75902158b736p-2,   0x1.cf9306p-4, INEXACT)
T(RN,  0x1.de4eff163b864p+745,    0x1.c10e856d0f851p-1,   0x1.fa5f42p-4, INEXACT)
T(RN,   0x1.949154477444p+745,    0x1.ac97c04ac1d82p-1,  -0x1.3aba6ap-2, INEXACT)
T(RN,   0x1.7d160f14cd5ap+746,    0x1.803ca0d4d3e67p-1,  -0x1.a1bd1ep-2, INEXACT)
T(RN,  0x1.9b7717348c69ap+746,    0x1.f74c7e7fd22a2p-2,   0x1.b9031ep-2, INEXACT)
T(RN,  0x1.67551c2a875aep+746,   -0x1.94b36844361b4p-2,  -0x1.db032ap-2, INEXACT)
T(RN,   0x1.2e48456c7cffp+746,    0x1.34ed2918c3b13p-1,   0x1.49f77ep-2, INEXACT)
T(RN,  0x1.101277774415fp+746,    0x1.b22125d472bdbp-1,  -0x1.7938bep-2, INEXACT)
T(RN,  0x1.5aa7b4e4fdafbp+746,   -0x1.73ccf3e99bbffp-2,   0x1.b84de4p-2, INEXACT)
T(RN,  0x1.bd67923fff996p+746,    0x1.ae0ccb8dd9c75p-4,   0x1.bbb264p-2, INEXACT)
T(RN,  0x1.fc2d4728685eep+746,    0x1.39e718be964dap-2,   0x1.40704ep-3, INEXACT)
T(RN,  0x1.d6e2d5e68d0d2p+746,   -0x1.19547e2896424p-2,  -0x1.9df5c4p-2, INEXACT)
T(RN,  0x1.3130e139f0f59p+746,   -0x1.69703773aa0e1p-1,   -0x1.248bfp-3, INEXACT)
T(RN,   0x1.0dbffd51b797p+747,   -0x1.32123db83c8e1p-1,   0x1.47506ep-2, INEXACT)
T(RN,  0x1.df207819aff5ap+747,     0x1.bf99ddd9c621p-3,    0x1.f404bp-3, INEXACT)
T(RN,  0x1.4f4f826f6f5c4p+747,    0x1.f76d9e7563016p-1,   0x1.d711e6p-2, INEXACT)
T(RN,   0x1.d16146450b08p+747,    0x1.e7d3caa13a128p-3,  -0x1.40a85cp-2, INEXACT)
T(RN,  0x1.a45350109c122p+747,   -0x1.ba6a47e39aecfp-1,   0x1.23e318p-2, INEXACT)
T(RN,  0x1.32f54c3ced507p+747,   -0x1.978d0f03d5c1dp-1,  -0x1.411048p-3, INEXACT)
T(RN,   0x1.19241bcf612cp+747,    0x1.7af144b6762adp-5,    0x1.3fd57p-2, INEXACT)
T(RN,  0x1.d9fd7c1602393p+747,    0x1.b14b44802daf9p-2,   0x1.3ea9a6p-4, INEXACT)
T(RN,  0x1.04b8091accac9p+747,   -0x1.8429fad28328bp-1,  -0x1.e26206p-3, INEXACT)
T(RN,  0x1.dbeb79801bedap+747,    0x1.2e431a7a7f814p-2,   0x1.6fa0c6p-4, INEXACT)
T(RN,  0x1.b9d7214d70658p+748,   -0x1.3a807836c3fdap-1,  -0x1.871ea2p-2, INEXACT)
T(RN,  0x1.f202726e452c8p+748,    0x1.e8ef9c1436adcp-1,  -0x1.2c3342p-2, INEXACT)
T(RN,  0x1.37ad201810037p+748,    -0x1.f04825bea7bbp-2,  -0x1.761626p-2, INEXACT)
T(RN,  0x1.e767ae9f3d576p+748,    0x1.fa04442f5e172p-1,  -0x1.10b0a6p-2, INEXACT)
T(RN,  0x1.e26d47a3ca824p+748,   -0x1.6aaf202764662p-1,  -0x1.68326ep-8, INEXACT)
T(RN,  0x1.00a1a238b9a6dp+748,   -0x1.16cfcb6839439p-2,   0x1.685ba4p-5, INEXACT)
T(RN,  0x1.756d9cb22dfb5p+748,    0x1.eca0c5b173845p-1,   0x1.4dedcep-4, INEXACT)
T(RN,  0x1.c1794b2ca0a6ep+748,    0x1.0625de2d0b31dp-5,  -0x1.44603ap-4, INEXACT)
T(RN,  0x1.2f7256e8f1addp+748,    0x1.fe25450585f37p-1,    0x1.f57c9p-3, INEXACT)
T(RN,  0x1.8449decb555dap+748,   -0x1.a4cb54b43a884p-2,  -0x1.71b196p-2, INEXACT)
T(RN,  0x1.8ac03513cff2ap+749,     0x1.e7f72c3a9aa7p-1,   0x1.147e36p-2, INEXACT)
T(RN,  0x1.e073f36709d06p+749,    0x1.ffcc3fdee546cp-1,  -0x1.996edcp-2, INEXACT)
T(RN,   0x1.62e47fcf9266p+749,   -0x1.b30fda0507c58p-1,  -0x1.e4e458p-2, INEXACT)
T(RN,   0x1.a4505705ff2cp+749,   -0x1.854656891399bp-1,   0x1.c953f8p-2, INEXACT)
T(RN,  0x1.6fbde9e0d4fcap+749,    0x1.4ede43128bc4fp-6,   -0x1.20712p-2, INEXACT)
T(RN,  0x1.5f181ba24cca8p+749,    0x1.f10953a722712p-3,  -0x1.2e86dcp-2, INEXACT)
T(RN,  0x1.399f7fb2eea05p+749,    0x1.73f62bbda3db8p-3,   -0x1.eb8adp-2, INEXACT)
T(RN,   0x1.bc67abd3f5c2p+749,   -0x1.feb27449dde6fp-1,   0x1.daea8ep-2, INEXACT)
T(RN,  0x1.58e2a74123c6fp+749,   -0x1.d33e1d37501e2p-3,  -0x1.5f29fap-2, INEXACT)
T(RN,  0x1.884e8490cd9bep+749,    -0x1.abbc0c44b8a4p-2,   0x1.401d94p-3, INEXACT)
T(RN,  0x1.6373ea86e2ed6p+750,   -0x1.51a402a0a816ep-1,  -0x1.f1d4bep-2, INEXACT)
T(RN,  0x1.6d96f8365f1afp+750,    -0x1.ca2b6941af86p-6,   0x1.dd8d7ep-2, INEXACT)
T(RN,  0x1.0e24e71062153p+750,   -0x1.2cb9682526ce5p-3,   0x1.41fb1cp-2, INEXACT)
T(RN,  0x1.c172505704394p+750,   -0x1.d2b68536aa0b6p-1,  -0x1.0237ccp-2, INEXACT)
T(RN,  0x1.651e03a5772c3p+750,   -0x1.dea53d1a5d8aep-1,   0x1.d9cdf6p-4, INEXACT)
T(RN,  0x1.b8b61213ce914p+750,   -0x1.bac44b95b5811p-1,   0x1.69e564p-2, INEXACT)
T(RN,  0x1.cd54f16dde8a2p+750,    0x1.8f85a9593b766p-1,   0x1.8773e6p-3, INEXACT)
T(RN,   0x1.d312721a2f87p+750,   -0x1.92d66b73c6084p-1,   0x1.297b9ap-5, INEXACT)
T(RN,  0x1.bfe66ed912ba4p+750,   -0x1.1f243f1cbe189p-1,   0x1.a91eb6p-2, INEXACT)
T(RN,  0x1.da2397160dcf8p+750,    0x1.c20bf80b9746ep-1,  -0x1.34a01ap-2, INEXACT)
T(RN,  0x1.cad3b8774ee9dp+751,   -0x1.e126c8251911cp-1,  -0x1.6773eep-3, INEXACT)
T(RN,  0x1.5a1e2493f0f07p+751,   -0x1.a2d6706958e03p-3,  -0x1.b15b02p-3, INEXACT)
T(RN,  0x1.747cd62e478bep+751,   -0x1.824b978701aafp-1,   -0x1.b400fp-4, INEXACT)
T(RN,   0x1.ff481c7dcc08p+751,    0x1.4fde44c923044p-1,   0x1.36b72cp-4, INEXACT)
T(RN,  0x1.b6816113bd9c6p+751,   -0x1.ad0263b664a02p-4,  -0x1.bb5862p-2, INEXACT)
T(RN,  0x1.f5a8453eb07fep+751,    0x1.7d9ab077878d5p-1,   0x1.06e56cp-4, INEXACT)
T(RN,  0x1.bddc466f52464p+751,    0x1.666d4b6e562ffp-2,   0x1.95511cp-2, INEXACT)
T(RN,  0x1.eb5fb3fc84163p+751,     0x1.ee83d2174f59p-1,   0x1.2d4b7ap-3, INEXACT)
T(RN,  0x1.7e0834c14bff2p+751,   -0x1.04d89574e645ep-4,  -0x1.70ff1ep-2, INEXACT)
T(RN,  0x1.b7b6a804500c1p+751,    -0x1.d3a82f7824aap-2,   0x1.adb76ep-3, INEXACT)
T(RN,  0x1.49eef14560ccep+752,    0x1.f69224db50967p-1,  -0x1.0bfdbap-2, INEXACT)
T(RN,  0x1.bb0b18bcbad22p+752,    0x1.b5d72d4cb24cap-4,  -0x1.8a8be2p-6, INEXACT)
T(RN,  0x1.f033333ce69e7p+752,    0x1.a43fabe025abbp-1,  -0x1.e9dd1cp-2, INEXACT)
T(RN,  0x1.6537209d6cbd9p+752,    0x1.4630a29238439p-1,   0x1.1a55e8p-3, INEXACT)
T(RN,  0x1.29c187601647ep+752,    0x1.de6bf3257e13fp-1,  -0x1.64fccep-2, INEXACT)
T(RN,  0x1.d8d920d5677dep+752,   -0x1.bd138b1f4e68fp-1,   0x1.7c2a24p-4, INEXACT)
T(RN,  0x1.078aefc20bd82p+752,   -0x1.80fe8a210ebb3p-1,  -0x1.588a4cp-2, INEXACT)
T(RN,  0x1.4838fb0809d4ap+752,   -0x1.5ca2aac42b328p-1,  -0x1.0565a4p-2, INEXACT)
T(RN,  0x1.64e84091417fbp+752,   -0x1.becfbbb8aa548p-1,  -0x1.c668acp-2, INEXACT)
T(RN,  0x1.ee7e79e1a8cc8p+752,    0x1.59e7fc93ec33dp-2,   -0x1.2f513p-2, INEXACT)
T(RN,  0x1.6058685314b89p+753,    0x1.44d1d4a7acb47p-2,   0x1.67aa8ep-2, INEXACT)
T(RN,  0x1.61a32ee4350bbp+753,    0x1.032e455130324p-2,  -0x1.7e6988p-2, INEXACT)
T(RN,  0x1.399005acbf4f4p+753,   -0x1.7c1fd4c20417ep-4,   0x1.72b126p-2, INEXACT)
T(RN,  0x1.c426956246e7cp+753,   -0x1.5d10322ba9145p-2,   0x1.09d208p-3, INEXACT)
T(RN,  0x1.f6026dec2220ep+753,   -0x1.ff1583ca11053p-1,  -0x1.27351ap-3, INEXACT)
T(RN,  0x1.de031d3473a24p+753,    0x1.ea7ce428bcc8ep-1,   0x1.5fceaap-6, INEXACT)
T(RN,  0x1.1de14cdc45ce5p+753,   -0x1.e2becec466319p-2,   0x1.7ff2f4p-4, INEXACT)
T(RN,  0x1.088c2c6512577p+753,    0x1.c3f4526b98d4cp-1,  -0x1.2ed06cp-2, INEXACT)
T(RN,  0x1.4352098e0cb9ep+753,   -0x1.58de4b3110675p-4,   0x1.850274p-2, INEXACT)
T(RN,   0x1.80d10be3884dp+753,    0x1.544b4e61716dep-2,    0x1.0ab7fp-2, INEXACT)
T(RN,  0x1.8f61944124e28p+754,    0x1.3da4bcf265051p-1,  -0x1.dfc57cp-9, INEXACT)
T(RN,  0x1.ec39229894b24p+754,    0x1.985a531c06583p-1,  -0x1.b1b368p-2, INEXACT)
T(RN,  0x1.4369ce511c022p+754,   -0x1.801a336dcda7fp-2,  -0x1.93f27cp-5, INEXACT)
T(RN,  0x1.998b4d9bb696ep+754,   -0x1.d0d9b6d0106e1p-1,   0x1.cfc844p-2, INEXACT)
T(RN,  0x1.42cdf3b77907ep+754,    0x1.c00f31d6cf01bp-3,   0x1.e7621ap-3, INEXACT)
T(RN,  0x1.9f9d890c7300fp+754,    0x1.4e680c2202258p-1,  -0x1.5165c6p-5, INEXACT)
T(RN,  0x1.eb3f7472b059dp+754,    0x1.6425cef7c0031p-2,  -0x1.ad3698p-5, INEXACT)
T(RN,  0x1.3882ee4adb6b6p+754,   -0x1.d6c700ef7ce4fp-2,  -0x1.a542e6p-2, INEXACT)
T(RN,  0x1.bea5ae575f813p+754,   -0x1.8b56e3df4df9bp-1,   0x1.7385a2p-3, INEXACT)
T(RN,  0x1.946c4edd3b2cep+754,    0x1.e0593c972a71fp-1,  -0x1.f4558cp-4, INEXACT)
T(RN,  0x1.fe1f444d98c38p+755,    0x1.e3bca2217434bp-3,   0x1.280b42p-4, INEXACT)
T(RN,  0x1.92a2b71a5ccfcp+755,    0x1.d2ab19f65dfd4p-1,   0x1.e27e02p-2, INEXACT)
T(RN,  0x1.9ef301a79fceep+755,    -0x1.5fabcdd296dfp-1,  -0x1.3ed2bap-2, INEXACT)
T(RN,  0x1.2dbdb04ce1515p+755,    0x1.f4f7cb5abcfd2p-1,  -0x1.2dd0dap-5, INEXACT)
T(RN,  0x1.8439ebc27517fp+755,   -0x1.ef6a1fa9002abp-1,  -0x1.818384p-2, INEXACT)
T(RN,  0x1.73767ef2932aap+755,    0x1.3b46a8ab63809p-3,  -0x1.1c626ep-2, INEXACT)
T(RN,  0x1.b50eb59ea82bdp+755,   -0x1.01a5ef902827bp-1,  -0x1.f3103ep-3, INEXACT)
T(RN,  0x1.e226f287ae377p+755,    0x1.6954127072715p-2,  -0x1.39c218p-3, INEXACT)
T(RN,  0x1.f64ea05261be7p+755,    0x1.0e0f746c4122cp-3,  -0x1.1b760ap-3, INEXACT)
T(RN,  0x1.696488092acc8p+755,    0x1.c8b504c092c9dp-2,   -0x1.e84c9p-4, INEXACT)
T(RN,  0x1.76a71201cb4c1p+756,   -0x1.60cd4da72f15ep-1,    0x1.9db89p-2, INEXACT)
T(RN,  0x1.284b938fdeb52p+756,   -0x1.b5cd4f4f22eafp-1,   0x1.582bb4p-2, INEXACT)
T(RN,  0x1.edc93c672165ap+756,     0x1.c6a602407a45p-1,  -0x1.726986p-4, INEXACT)
T(RN,  0x1.e3716ede10328p+756,    -0x1.5eeb8543aa29p-1,  -0x1.9c61a4p-3, INEXACT)
T(RN,  0x1.bb32207463e29p+756,    0x1.f001b63026a6cp-2,   0x1.f410acp-4, INEXACT)
T(RN,  0x1.f30f27f674008p+756,   -0x1.94c464c15a78cp-1,  -0x1.c1f1a8p-2, INEXACT)
T(RN,  0x1.2415eb24d34a2p+756,    0x1.0ebe12583b215p-6,  -0x1.7e9cfcp-3, INEXACT)
T(RN,  0x1.82ea0362f7db4p+756,    0x1.ddd7b8744c2f6p-1,   0x1.0efea2p-5, INEXACT)
T(RN,  0x1.4a8ffa5ad24fcp+756,   -0x1.de7b74289053bp-1,  -0x1.7a5c64p-2, INEXACT)
T(RN,  0x1.093e14b307914p+756,    0x1.e005349add138p-2,   -0x1.f1c25p-2, INEXACT)
T(RN,  0x1.e555ac9fa6214p+757,   -0x1.832e32a9f0615p-1,   0x1.133d5ep-4, INEXACT)
T(RN,  0x1.f034f31141232p+757,    0x1.f4aee02c7e5b3p-1,  -0x1.9eb4aep-2, INEXACT)
T(RN,  0x1.d8102f202acc6p+757,   -0x1.ea6891ff2e2cep-1,   0x1.ea8376p-6, INEXACT)
T(RN,  0x1.7cce56fa43ec3p+757,   -0x1.e63b092aa78acp-1,   0x1.d7df3ap-2, INEXACT)
T(RN,  0x1.3625223870ee1p+757,    0x1.d9ae59821a9fcp-1,   0x1.13a8d8p-3, INEXACT)
T(RN,  0x1.5bd8667709fe2p+757,   -0x1.5d3f95355e9eap-2,  -0x1.2d0fb6p-2, INEXACT)
T(RN,  0x1.e4ad585c1e892p+757,   -0x1.3c3c54b79a14cp-1,  -0x1.2b087cp-2, INEXACT)
T(RN,  0x1.c31dfdd5db013p+757,    -0x1.ffb78bac7083p-1,   -0x1.6eed6p-3, INEXACT)
T(RN,  0x1.17fc93cc6e5f4p+757,    0x1.f288b4eb2f169p-1,  -0x1.e77432p-6, INEXACT)
T(RN,  0x1.0c60d79961959p+757,    0x1.fff68dfb3e645p-1,   0x1.8ee44ap-5, INEXACT)
T(RN,  0x1.cd88751d52575p+758,    0x1.29b4e3daee53bp-1,    0x1.438f1p-2, INEXACT)
T(RN,  0x1.09ba1a5829cb3p+758,    0x1.bdb212f6a02dbp-3,  -0x1.cd6222p-8, INEXACT)
T(RN,  0x1.b5139c339e37ep+758,    0x1.a480c2d3ed7f9p-1,   0x1.20de72p-2, INEXACT)
T(RN,  0x1.23fba55fe307ap+758,    -0x1.50796de6d1dfp-6,  -0x1.b5a208p-6, INEXACT)
T(RN,  0x1.c5c0e4b82b998p+758,   -0x1.8aa786ddc4113p-2,    0x1.a8ef4p-2, INEXACT)
T(RN,  0x1.347741804f99bp+758,   -0x1.0f9a3df0b021fp-2,  -0x1.686ceap-2, INEXACT)
T(RN,  0x1.1888e002c6bbdp+758,    -0x1.93c0eb2bc7f2p-1,  -0x1.174154p-3, INEXACT)
T(RN,  0x1.08d4990bb014fp+758,   -0x1.db2086825da4ap-1,  -0x1.2b06a4p-2, INEXACT)
T(RN,  0x1.d6f15713a720fp+758,   -0x1.d1e667fc970e3p-1,  -0x1.a3d66ep-2, INEXACT)
T(RN,  0x1.e9954910e9354p+758,    0x1.1b158d2a4515fp-4,   0x1.6297acp-2, INEXACT)
T(RN,  0x1.e8a9a0118fd8ap+759,    0x1.5d1879effb3e8p-1,  -0x1.eb7338p-8, INEXACT)
T(RN,  0x1.7663cfdf28a7bp+759,   -0x1.e9fa4027c7083p-1,   0x1.adca66p-2, INEXACT)
T(RN,   0x1.e7d684e473b6p+759,    0x1.ef12307679b5cp-1,  -0x1.555082p-2, INEXACT)
T(RN,  0x1.506844f6473e2p+759,   -0x1.7ab4aee7f396cp-1,   0x1.449a8cp-2, INEXACT)
T(RN,   0x1.d514e42a8d7ep+759,    0x1.fa46e02d70ef3p-1,  -0x1.f2f39cp-3, INEXACT)
T(RN,  0x1.b43f366f02e46p+759,    0x1.f312fb756a051p-1,   0x1.d0c692p-2, INEXACT)
T(RN,  0x1.a92cbfbe4affbp+759,    0x1.8863bf0c36b31p-2,   -0x1.b31c2p-3, INEXACT)
T(RN,  0x1.a01b0a64ece41p+759,   -0x1.03033dd0ef169p-3,  -0x1.cdceb8p-3, INEXACT)
T(RN,  0x1.1c68d9e018a3bp+759,    0x1.e2250489626e8p-1,  -0x1.45e4c6p-5, INEXACT)
T(RN,  0x1.7985ee54b9787p+759,   -0x1.cde054a46b52ep-1,   0x1.ccb406p-2, INEXACT)
T(RN,  0x1.a5dd64b8c51cap+760,    0x1.bdb13537d098fp-1,   -0x1.c654fp-5, INEXACT)
T(RN,  0x1.47b596d7aafe3p+760,   -0x1.da26ea2134e81p-1,  -0x1.98bde8p-2, INEXACT)
T(RN,  0x1.b143d49266cc2p+760,    0x1.5397665519b51p-3,  -0x1.d430d8p-3, INEXACT)
T(RN,  0x1.dabe07d190d9ap+760,    0x1.9ce936330f44dp-3,   0x1.7b2b8ep-4, INEXACT)
T(RN,  0x1.67f40703c2996p+760,   -0x1.a0c95e8723eadp-1,  -0x1.923ab6p-4, INEXACT)
T(RN,  0x1.f155c92164f12p+760,    0x1.6186cf3009a88p-2,   0x1.d68f12p-3, INEXACT)
T(RN,  0x1.ee14dd0fc5cbdp+760,   -0x1.2c3d84054a32ap-1,   0x1.c68162p-2, INEXACT)
T(RN,  0x1.4972a29972b85p+760,    0x1.e1091e2f94134p-2,   -0x1.6c4b4p-2, INEXACT)
T(RN,  0x1.d892cbf7487aep+760,   -0x1.ef8d48403f3d6p-2,   0x1.0f173cp-4, INEXACT)
T(RN,  0x1.fd47d39b296e1p+760,     0x1.9ff197fa4d75p-5,   -0x1.a3edep-2, INEXACT)
T(RN,  0x1.50114d7efbadap+761,   -0x1.b41fe0077c5a9p-1,  -0x1.e16b02p-6, INEXACT)
T(RN,  0x1.868d21fbc1556p+761,    0x1.c9674a099a631p-1,   0x1.4fb7dap-5, INEXACT)
T(RN,   0x1.1f39704f52e6p+761,   -0x1.d553a8a9829b4p-2,   0x1.31048cp-2, INEXACT)
T(RN,  0x1.4de7a778e586ep+761,   -0x1.ab04d4ec40c28p-1,   0x1.5a54b4p-3, INEXACT)
T(RN,  0x1.83ffc75970dcbp+761,    0x1.47f7605e28ff5p-2,   0x1.f309c4p-3, INEXACT)
T(RN,  0x1.89a1a5621fad3p+761,   -0x1.e81adcff1adc2p-1,  -0x1.c7090cp-3, INEXACT)
T(RN,   0x1.5fd46303c766p+761,     0x1.1c715242d7d8p-1,   0x1.b373c4p-2, INEXACT)
T(RN,  0x1.84accd2a42128p+761,   -0x1.c8d7c031263bcp-1,   0x1.57c9dcp-2, INEXACT)
T(RN,  0x1.eae88812e8376p+761,    0x1.3e3165be03921p-1,  -0x1.b2b4aep-2, INEXACT)
T(RN,  0x1.ecc826386b06ep+761,    0x1.89a604b952317p-2,   0x1.719e8cp-2, INEXACT)
T(RN,  0x1.f234fe90952c8p+762,    0x1.b2ca1af98cfcbp-1,   0x1.1ec2c4p-2, INEXACT)
T(RN,  0x1.2ecd3a9344b4ap+762,    0x1.ff0fd18ae5b7ap-1,   0x1.9080b8p-5, INEXACT)
T(RN,  0x1.2a8b04d53179fp+762,   -0x1.67ca819499287p-3,   0x1.7ed0cap-2, INEXACT)
T(RN,  0x1.876c9b45f77e4p+762,    0x1.378b47746515ep-5,   0x1.c70018p-2, INEXACT)
T(RN,  0x1.714d739bb3c92p+762,   -0x1.9473fd0b88abbp-4,  -0x1.13fcb4p-2, INEXACT)
T(RN,  0x1.da2cc0312c67cp+762,    0x1.72077a6177f33p-1,  -0x1.0558e6p-4, INEXACT)
T(RN,  0x1.245f1bb8d89c2p+762,   -0x1.d47488de24a33p-2,   0x1.8d11eap-3, INEXACT)
T(RN,  0x1.48d3a2ad2428ep+762,    0x1.06dc77fdb988ap-2,  -0x1.777334p-2, INEXACT)
T(RN,  0x1.101db0e93502ep+762,    0x1.38936263e1452p-1,   0x1.7cc442p-6, INEXACT)
T(RN,  0x1.3bb1cc314132fp+762,    -0x1.400891eae743p-5,    0x1.5d7eap-2, INEXACT)
T(RN,  0x1.c1bac6a535891p+763,   -0x1.dbc517162e774p-1,  -0x1.2dac56p-2, INEXACT)
T(RN,  0x1.fb3729f476ecdp+763,   -0x1.5c94e697efbcbp-7,   0x1.8dfe86p-3, INEXACT)
T(RN,  0x1.b6282cfb911e8p+763,   -0x1.a84b5f7f0d0f3p-2,   0x1.241174p-4, INEXACT)
T(RN,  0x1.14461d00e6057p+763,      0x1.590daac494fp-2,  -0x1.a3d644p-2, INEXACT)
T(RN,  0x1.417bd11500492p+763,   -0x1.61aac8d5b72aep-4,  -0x1.bb572ep-3, INEXACT)
T(RN,  0x1.e46cc64d4c3cbp+763,   -0x1.e319a81c12708p-1,  -0x1.32b38ep-2, INEXACT)
T(RN,  0x1.333549304a34dp+763,    0x1.f2e00ea39a067p-2,  -0x1.ed4f86p-3, INEXACT)
T(RN,  0x1.82cf92bbe935cp+763,    0x1.fde198675fbdcp-1,  -0x1.6341b4p-7, INEXACT)
T(RN,  0x1.8267787710eecp+763,    0x1.fb3a067bf6e76p-1,  -0x1.9e11a8p-2, INEXACT)
T(RN,  0x1.cea3ac7893f72p+763,    0x1.2640ed1a61d3ep-2,  -0x1.3e16ccp-5, INEXACT)
T(RN,  0x1.aeb1dda7ddd56p+764,   -0x1.904220fb7b63ap-1,  -0x1.3e30a8p-7, INEXACT)
T(RN,  0x1.1675f36f7a023p+764,    0x1.6d96a6c179a8ap-7,   0x1.1b6904p-6, INEXACT)
T(RN,  0x1.da68826e09064p+764,   -0x1.ed20116cfd979p-1,  -0x1.a6f056p-2, INEXACT)
T(RN,  0x1.7854b46ca8537p+764,    0x1.fe365ae91b63cp-1,   0x1.dfdf98p-3, INEXACT)
T(RN,  0x1.5ba0d74503cafp+764,   -0x1.e769d0d3d52a9p-1,   0x1.4d3808p-2, INEXACT)
T(RN,  0x1.a47606c4bf518p+764,   -0x1.cbc21955aab96p-1,  -0x1.bb264cp-2, INEXACT)
T(RN,  0x1.1a634816d0314p+764,   -0x1.ec06d7aff6ca1p-1,   0x1.12516ep-4, INEXACT)
T(RN,  0x1.b80a46fb2ece8p+764,   -0x1.766ca92d79931p-3,  -0x1.eb258cp-6, INEXACT)
T(RN,  0x1.bcc42173910e2p+764,    0x1.18a2d21ff56bcp-2,    0x1.6c013p-3, INEXACT)
T(RN,  0x1.101e672d3605fp+764,   -0x1.c424b5e60d4ccp-1,   0x1.6073e6p-2, INEXACT)
T(RN,  0x1.6a6ff6cfaf5ccp+765,    0x1.caa5bf46b208ep-1,   0x1.6373ccp-2, INEXACT)
T(RN,  0x1.0f43887d4b37ap+765,   -0x1.81669b7266e3dp-2,   0x1.7bd07cp-2, INEXACT)
T(RN,  0x1.46a935e5c62f5p+765,   -0x1.c9c0efe7e40cbp-7,  -0x1.264524p-4, INEXACT)
T(RN,  0x1.da8c605b38af4p+765,    0x1.1b81379e56adfp-3,  -0x1.a0395cp-2, INEXACT)
T(RN,  0x1.ab78c2a4753dfp+765,   -0x1.e8a949da85e5ap-1,  -0x1.87f218p-3, INEXACT)
T(RN,  0x1.730cefb217c8dp+765,    0x1.c1c25f2f88251p-1,  -0x1.240e88p-2, INEXACT)
T(RN,  0x1.a1a3b50ef765cp+765,   -0x1.ffd249e500e45p-6,  -0x1.1dcea4p-3, INEXACT)
T(RN,  0x1.d4483f5add85dp+765,     0x1.0943e56db6fep-5,  -0x1.a10082p-4, INEXACT)
T(RN,  0x1.369f102113e6dp+765,   -0x1.308fc66d1fbd4p-1,  -0x1.4a2a48p-4, INEXACT)
T(RN,  0x1.a226c32b1cf88p+765,    0x1.eec5f67ffebc3p-1,  -0x1.f0fd58p-2, INEXACT)
T(RN,  0x1.71d9619e2e1e1p+766,   -0x1.00f0be56081e3p-1,   0x1.2dbba2p-2, INEXACT)
T(RN,  0x1.be77e26db45f5p+766,    0x1.75e3f0b6da368p-1,   0x1.85746cp-4, INEXACT)
T(RN,  0x1.d53f35cb473b9p+766,    0x1.05194d266ee8ep-2,   0x1.20f0b2p-3, INEXACT)
T(RN,  0x1.8f0fca07b5cd7p+766,   -0x1.b6093cacf0bb7p-1,   0x1.0dea3ap-2, INEXACT)
T(RN,  0x1.f199d359407e8p+766,   -0x1.120322b5793c9p-2,   0x1.dd5b58p-5, INEXACT)
T(RN,  0x1.61d9d50674b68p+766,   -0x1.666c1d626b697p-1,  -0x1.6d72a4p-2, INEXACT)
T(RN,  0x1.3e024c90fdecbp+766,    0x1.f8af86728e212p-1,   0x1.1610f2p-2, INEXACT)
T(RN,  0x1.bb819f0b9a8fap+766,    0x1.0d53496c8cbccp-1,  -0x1.62dea2p-2, INEXACT)
T(RN,   0x1.56faf01092e4p+766,    0x1.4bbc6f8afdd21p-1,  -0x1.7b0e5ap-3, INEXACT)
T(RN,  0x1.6f27123ce9598p+766,   -0x1.235e273181bfcp-1,  -0x1.655082p-7, INEXACT)
T(RN,  0x1.ae3ae38412f9cp+767,    0x1.7bd2eb29a2174p-1,  -0x1.105214p-6, INEXACT)
T(RN,   0x1.91f99703c654p+767,     0x1.a38956971023p-2,   0x1.c37128p-3, INEXACT)
T(RN,  0x1.3d967ef5b500bp+767,    0x1.82a425bfa28dap-4,    0x1.b6346p-2, INEXACT)
T(RN,  0x1.14cae30fbea0dp+767,    0x1.6f5652721eb01p-1,  -0x1.f2bef4p-4, INEXACT)
T(RN,   0x1.4fe092204802p+767,   -0x1.fffff9cd4e7bdp-1,  -0x1.4e6f58p-5, INEXACT)
T(RN,  0x1.06a91c663f652p+767,   -0x1.65d53cc14ef2ep-3,   0x1.7b8bc2p-2, INEXACT)
T(RN,  0x1.5bb284807dd56p+767,   -0x1.91e6343fc09e1p-1,  -0x1.78a266p-3, INEXACT)
T(RN,  0x1.2d32478c8e635p+767,    0x1.4442ff57de3fcp-3,   0x1.972858p-2, INEXACT)
T(RN,  0x1.c21b83aec276cp+767,    0x1.a3705c5a82b2ap-1,  -0x1.47ea54p-2, INEXACT)
T(RN,  0x1.cb6aa0f07d808p+767,    0x1.c961d8510fd5bp-1,  -0x1.346bdep-2, INEXACT)
T(RN,  0x1.0f4c7dd0af584p+768,    0x1.88e011afda3e6p-1,  -0x1.e0fe2cp-2, INEXACT)
T(RN,  0x1.92e1e0eafcecep+768,   -0x1.ffbd64c99887bp-1,  -0x1.04c8e2p-4, INEXACT)
T(RN,  0x1.d278eafc6ccacp+768,   -0x1.afac09b0edcdfp-2,  -0x1.fe635ep-2, INEXACT)
T(RN,  0x1.5ebacea22459cp+768,    0x1.7edbbf10c5fdfp-1,  -0x1.bd3b9cp-2, INEXACT)
T(RN,  0x1.4b27bbf47a649p+768,   -0x1.23572281676b3p-1,   0x1.a3983ep-2, INEXACT)
T(RN,  0x1.f610165ebe3d2p+768,   -0x1.4912408cb4a6ep-4,  -0x1.4730f6p-2, INEXACT)
T(RN,  0x1.5ede0400b90a7p+768,   -0x1.04e88bb79c14fp-1,  -0x1.5ef88ep-2, INEXACT)
T(RN,  0x1.53119fcc1f1c5p+768,    0x1.f87f01079abcap-1,   0x1.038022p-3, INEXACT)
T(RN,  0x1.994c804707ce1p+768,    0x1.1dbe2406285e4p-2,   0x1.6b4e06p-2, INEXACT)
T(RN,  0x1.26ffd78383558p+768,    0x1.e0adb709ca882p-1,   0x1.292bc2p-2, INEXACT)
T(RN,  0x1.d6e7f83ce3ff8p+769,     0x1.ffddaefb04b1p-1,  -0x1.311c8ep-2, INEXACT)
T(RN,  0x1.824d6e39841dcp+769,   -0x1.294ed063014e1p-1,  -0x1.eec406p-2, INEXACT)
T(RN,  0x1.20c9fdf8ca742p+769,    0x1.4c6a9d5e34e62p-1,  -0x1.c4e466p-2, INEXACT)
T(RN,  0x1.0bb0ac0fe943ep+769,    0x1.586286359700ap-2,  -0x1.98ca94p-2, INEXACT)
T(RN,  0x1.9d94d9f02524ap+769,   -0x1.5489addbbb1dfp-1,   0x1.533132p-2, INEXACT)
T(RN,  0x1.5d499790b8aecp+769,   -0x1.a97ef2f4cdbd1p-3,   0x1.f4110ep-4, INEXACT)
T(RN,  0x1.9726a45c6293ep+769,    0x1.5dffabe45430ep-4,   0x1.1ac9c6p-3, INEXACT)
T(RN,  0x1.1d47870d4327ep+769,    0x1.48666654e667cp-1,  -0x1.bbcb72p-3, INEXACT)
T(RN,  0x1.97416ab9ae9cap+769,    0x1.e1c58b84f4ce3p-1,    0x1.07097p-2, INEXACT)
T(RN,  0x1.fb5ffdcff0408p+769,   -0x1.3d9782f4ff275p-1,   0x1.18314ap-2, INEXACT)
T(RN,  0x1.2f109f8c60177p+770,   -0x1.642670e842736p-1,   0x1.50632cp-3, INEXACT)
T(RN,  0x1.73e407786dc94p+770,    0x1.d43a142e249d5p-1,   -0x1.50456p-4, INEXACT)
T(RN,  0x1.cd672a3739468p+770,    0x1.cb2501dcadb1cp-1,   0x1.d110a8p-2, INEXACT)
T(RN,  0x1.7f98c27cc2c33p+770,    0x1.e5bfafb6fac4bp-1,   0x1.5b51acp-2, INEXACT)
T(RN,  0x1.75844a257e279p+770,    0x1.ffc3da9005ab7p-1,  -0x1.dd7ddap-8, INEXACT)
T(RN,  0x1.9292185905191p+770,   -0x1.b90d3f00a25bcp-1,    0x1.73034p-2, INEXACT)
T(RN,  0x1.5b9f6fdcc838ap+770,   -0x1.f2cf07262e718p-1,  -0x1.f0cc5ep-2, INEXACT)
T(RN,  0x1.484a1aa5ba55fp+770,    0x1.95909aa8b6cb1p-3,  -0x1.91e984p-2, INEXACT)
T(RN,  0x1.c947d4a5778f2p+770,    0x1.fc0d3fc33f3aap-1,    0x1.8dbfcp-3, INEXACT)
T(RN,  0x1.ce8ae5ecd3cd4p+770,    0x1.b927b4fd771eep-1,   -0x1.53a99p-2, INEXACT)
T(RN,  0x1.53db7d1b05d36p+771,   -0x1.bc9a156ddea1ap-1,  -0x1.a37b38p-2, INEXACT)
T(RN,  0x1.6074ce7823362p+771,    0x1.1b219dd534769p-4,   0x1.4dd4c8p-2, INEXACT)
T(RN,  0x1.aa67d3efb4dbep+771,    0x1.06bfdc8f36229p-1,  -0x1.53fb56p-3, INEXACT)
T(RN,  0x1.71534d0402b56p+771,     0x1.f7fe7f27e829p-1,  -0x1.665c9ep-6, INEXACT)
T(RN,  0x1.5a4784794585cp+771,   -0x1.c929c22b072b6p-1,   0x1.937d64p-3, INEXACT)
T(RN,  0x1.114f23d8c5abep+771,   -0x1.d73f31062ff58p-2,   0x1.3579c8p-4, INEXACT)
T(RN,  0x1.948e74e9b7034p+771,   -0x1.69f5a16ff7468p-1,   0x1.cbbb6ap-2, INEXACT)
T(RN,  0x1.c074514798ebfp+771,    0x1.f2a9abd6e1ec3p-1,    0x1.66abap-3, INEXACT)
T(RN,  0x1.3ecfd56aacd59p+771,    0x1.249a4dfb9cdfbp-1,   0x1.85e9aep-2, INEXACT)
T(RN,  0x1.73a84c3342ea7p+771,   -0x1.6ab2182248a24p-1,  -0x1.e683d2p-3, INEXACT)
T(RN,  0x1.7b3b013a09b14p+772,   -0x1.f26a9e88df9ddp-1,  -0x1.82460ap-7, INEXACT)
T(RN,  0x1.c1b294c13e83cp+772,    -0x1.00f644573d4ap-2,   0x1.e779dep-3, INEXACT)
T(RN,  0x1.e11d47535a26ap+772,    0x1.a3284e7774a68p-1,  -0x1.812aa4p-3, INEXACT)
T(RN,  0x1.d18c171e2ffc4p+772,    0x1.62674cffd28fep-4,  -0x1.477428p-3, INEXACT)
T(RN,  0x1.9fc434b0262d4p+772,   -0x1.e6c254bb62576p-5,   0x1.3870a8p-3, INEXACT)
T(RN,  0x1.d67e46b7e977ep+772,   -0x1.bb4476fdc5b59p-2,  -0x1.e5c16cp-2, INEXACT)
T(RN,  0x1.6618aeb2433a4p+772,    0x1.a376d38661639p-2,     0x1.5acep-5, INEXACT)
T(RN,    0x1.0483c829a66p+772,    0x1.9592776bffd85p-1,  -0x1.3932aap-4, INEXACT)
T(RN,  0x1.74c5e7ada9ed4p+772,    0x1.94177f3b722bep-1,  -0x1.4c3138p-2, INEXACT)
T(RN,  0x1.bd3937f2939dcp+772,   -0x1.299d0fd7eff15p-1,  -0x1.5090e6p-3, INEXACT)
T(RN,  0x1.188731a5a80fap+773,   -0x1.c780e5b2dc0eep-1,   0x1.9ebedep-2, INEXACT)
T(RN,  0x1.9a6afae9a495ap+773,    0x1.e744abd024283p-1,   0x1.446186p-3, INEXACT)
T(RN,  0x1.a238d71e156bap+773,    0x1.489abf758dc32p-1,   0x1.7558e4p-2, INEXACT)
T(RN,  0x1.14ed3b3207f82p+773,     0x1.be7afb60eb3ap-2,   0x1.a71b88p-2, INEXACT)
T(RN,  0x1.1f0dd48115514p+773,   -0x1.60e07a55e6916p-1,   0x1.75556cp-4, INEXACT)
T(RN,  0x1.1e6a21b58bf76p+773,    0x1.9da90480d256dp-1,  -0x1.bef1cep-2, INEXACT)
T(RN,  0x1.216333e81cebcp+773,   -0x1.54501f2870499p-1,   -0x1.7d1d7p-3, INEXACT)
T(RN,  0x1.580a8c7a2a946p+773,    0x1.9e43771635af7p-1,   0x1.c41be6p-2, INEXACT)
T(RN,  0x1.1a1ef08e58f2bp+773,   -0x1.4f40a14551c2cp-2,   0x1.8ed066p-3, INEXACT)
T(RN,  0x1.307ca2803c79ep+773,   -0x1.ceac95c591a0dp-1,   0x1.9707a2p-2, INEXACT)
T(RN,  0x1.d22e29340151cp+774,   -0x1.f357179b93d8bp-1,    0x1.23506p-5, INEXACT)
T(RN,  0x1.31ed28396fdd6p+774,    0x1.ff6121723fd68p-1,   0x1.d3da52p-2, INEXACT)
T(RN,   0x1.58b429f540cep+774,   -0x1.ec0dcc52fdddbp-1,  -0x1.c46ad2p-3, INEXACT)
T(RN,  0x1.9ba3c43ecd5a8p+774,    0x1.95de1b3624b29p-1,  -0x1.2833b2p-2, INEXACT)
T(RN,  0x1.dce51cee78a22p+774,   -0x1.358356387b7a2p-4,   0x1.1bfebep-4, INEXACT)
T(RN,  0x1.c1fe6a299280cp+774,    0x1.219c2365d7525p-2,  -0x1.426276p-6, INEXACT)
T(RN,  0x1.54a58faf9640ap+774,   -0x1.e9718988c403ep-1,   0x1.a2f48ep-2, INEXACT)
T(RN,  0x1.35468d32372a9p+774,    0x1.0ae87fdff27e9p-5,  -0x1.f93cf8p-2, INEXACT)
T(RN,  0x1.444e8e9a0d6b4p+774,    0x1.a95bd11457c83p-1,   0x1.2a3dcap-2, INEXACT)
T(RN,  0x1.462dc3d22aa5ap+774,   -0x1.7de29649d71aep-1,    0x1.25be1p-5, INEXACT)
T(RN,  0x1.30b1e282322f4p+775,    -0x1.d4503d35a795p-1,  -0x1.7bf9bcp-3, INEXACT)
T(RN,  0x1.7ac89e40b0c9ap+775,    0x1.3f1c97df4379bp-2,  -0x1.62cd4ap-2, INEXACT)
T(RN,  0x1.6aad112773686p+775,   -0x1.c439a4a1574e1p-1,  -0x1.cabb3cp-3, INEXACT)
T(RN,  0x1.bb786f80c440ap+775,   -0x1.5b1190d16761ep-1,  -0x1.e008d8p-2, INEXACT)
T(RN,  0x1.fbc8fc48c5a09p+775,    0x1.ef4d5bf903ba1p-1,  -0x1.acd306p-3, INEXACT)
T(RN,  0x1.1d5a7cb854999p+775,   -0x1.9782dc1268c6bp-1,   0x1.c1c1cap-3, INEXACT)
T(RN,  0x1.743841be7c4c5p+775,   -0x1.fa8150501840fp-1,  -0x1.4f0466p-2, INEXACT)
T(RN,  0x1.681c00c6cd4fbp+775,   -0x1.0564f995abde4p-2,   0x1.7af738p-2, INEXACT)
T(RN,  0x1.324fc1ac1652ep+775,   -0x1.f5efa8551df7cp-1,  -0x1.31a532p-3, INEXACT)
T(RN,  0x1.a31518fc6b41ep+775,    0x1.ee2b39f327d16p-3,  -0x1.79ff86p-7, INEXACT)
T(RN,  0x1.93ca7890ca63cp+776,   -0x1.01cbb2650afcdp-1,  -0x1.e4e13ap-2, INEXACT)
T(RN,  0x1.7b56ad3f4281ep+776,   -0x1.6e054d60e9998p-2,  -0x1.78ab64p-2, INEXACT)
T(RN,  0x1.dabbb9c77376ap+776,    0x1.96cb0da71ed55p-1,  -0x1.2665ccp-2, INEXACT)
T(RN,  0x1.d097525b2231ap+776,    0x1.ee12ab252835bp-4,   0x1.7cf53ap-3, INEXACT)
T(RN,  0x1.d75ee7372c374p+776,   -0x1.5108b9d42ee21p-1,   0x1.0e8734p-2, INEXACT)
T(RN,  0x1.03ecf865624f8p+776,    0x1.cea6569b8bdaap-3,   0x1.17b552p-4, INEXACT)
T(RN,  0x1.c5ed9c01f971ep+776,   -0x1.3f1073deb4eeep-1,   0x1.c2465ep-2, INEXACT)
T(RN,  0x1.aca8147fef912p+776,   -0x1.3d074cb7340b4p-2,   0x1.3d30d6p-3, INEXACT)
T(RN,  0x1.401feaa43259dp+776,   -0x1.d751c358c0162p-2,   0x1.922898p-2, INEXACT)
T(RN,  0x1.a80f6f209b39ep+776,   -0x1.f823c2f1944c5p-1,   0x1.85871ep-2, INEXACT)
T(RN,  0x1.714fb42e68695p+777,    0x1.63367532cd2c7p-1,  -0x1.67419ap-4, INEXACT)
T(RN,  0x1.6e155a5afc56bp+777,   -0x1.9f0aea7cc5078p-1,  -0x1.3fd37ap-3, INEXACT)
T(RN,  0x1.78e98c090a761p+777,   -0x1.815cebc3958c9p-1,   0x1.ca444cp-9, INEXACT)
T(RN,  0x1.8922e5f59a0fdp+777,   -0x1.7f4167c50c041p-1,    0x1.f47c3p-2, INEXACT)
T(RN,  0x1.dd1867886d888p+777,    0x1.4ba30fba6e678p-1,  -0x1.4b5fe4p-3, INEXACT)
T(RN,  0x1.e9f7258fd9bf8p+777,    0x1.fab02b14d5384p-1,   0x1.784d48p-2, INEXACT)
T(RN,  0x1.02a0a585a4d46p+777,    0x1.3b3dec62ba92fp-3,   0x1.8b55d8p-2, INEXACT)
T(RN,  0x1.885e4809c40acp+777,   -0x1.221f5005bff6dp-3,   0x1.044298p-2, INEXACT)
T(RN,  0x1.6e8b0f670a3f1p+777,    0x1.1baed91a95f89p-2,  -0x1.8b1798p-8, INEXACT)
T(RN,  0x1.a9fb94656b809p+777,   -0x1.616d1b6d589cep-3,   -0x1.39b06p-3, INEXACT)
T(RN,   0x1.ad59546947fbp+778,   -0x1.c859eed617fd5p-6,   0x1.acd61ep-4, INEXACT)
T(RN,  0x1.b6f42842b115ap+778,     0x1.5044cb4e7212p-1,  -0x1.bb0252p-3, INEXACT)
T(RN,  0x1.666bfea8993e4p+778,    0x1.9f22727ebfa67p-1,  -0x1.dc1d1ep-3, INEXACT)
T(RN,  0x1.63164c464b021p+778,    0x1.fce115f70115ep-1,  -0x1.13d4e8p-2, INEXACT)
T(RN,  0x1.6a48d7211370cp+778,   -0x1.477866e6d7977p-2,   0x1.dba776p-2, INEXACT)
T(RN,  0x1.06423e018b958p+778,    0x1.f750306cb2c47p-1,  -0x1.807bfep-4, INEXACT)
T(RN,  0x1.f8f0b0fc18366p+778,   -0x1.bc8cb54a4b851p-1,    0x1.31ff6p-2, INEXACT)
T(RN,  0x1.4eef17ae4654bp+778,   -0x1.9a0b2bbf25882p-2,   0x1.4f1138p-2, INEXACT)
T(RN,  0x1.16531878edfbap+778,    0x1.e2fa25daf8b5fp-1,   0x1.00bb5ap-2, INEXACT)
T(RN,  0x1.e9ae02a73ae88p+778,   -0x1.fad5ed8f3ffc3p-1,  -0x1.dea9bap-3, INEXACT)
T(RN,  0x1.403876108a826p+779,    0x1.1b9bd0711890cp-2,   0x1.5a68b4p-2, INEXACT)
T(RN,  0x1.f3bc44c842dc4p+779,   -0x1.638b3c99fc0cfp-1,  -0x1.c83abap-2, INEXACT)
T(RN,  0x1.8b430fe235b3ep+779,   -0x1.4ae8363f4e632p-1,   0x1.18fa3cp-2, INEXACT)
T(RN,  0x1.70dce03e04319p+779,   -0x1.ffd6bec4a6ec1p-1,  -0x1.860c8ep-2, INEXACT)
T(RN,  0x1.fa0c31202868fp+779,   -0x1.2bf110745ad16p-1,   0x1.505aa8p-2, INEXACT)
T(RN,  0x1.069c8d094e7afp+779,    0x1.9bed71c83f906p-2,   0x1.a63b06p-2, INEXACT)
T(RN,  0x1.22f8b5e7f009fp+779,    0x1.c8926599cc2b2p-1,  -0x1.274c16p-2, INEXACT)
T(RN,  0x1.5b241d3fcb532p+779,    0x1.6b2fc92ddd23fp-1,   0x1.839e14p-3, INEXACT)
T(RN,  0x1.a67606dc936f2p+779,   -0x1.95e4abd31ffbbp-1,  -0x1.16e4b2p-2, INEXACT)
T(RN,  0x1.6e2860f14fc4fp+779,    0x1.e716fd6ae5938p-1,  -0x1.f34d78p-2, INEXACT)
T(RN,  0x1.5a372847024cap+780,   -0x1.e163e6ba96921p-1,  -0x1.bd82bcp-3, INEXACT)
T(RN,  0x1.df0216fedf088p+780,   -0x1.e8de986926bcep-1,   -0x1.fecf7p-2, INEXACT)
T(RN,  0x1.847c861a742b2p+780,   -0x1.253d021c21703p-1,   0x1.b2b95ap-5, INEXACT)
T(RN,  0x1.88d86a4c1b13cp+780,   -0x1.2d2666f1621c3p-1,  -0x1.7279a6p-2, INEXACT)
T(RN,   0x1.c2465957b161p+780,    0x1.00b6d4c08ddf4p-1,   0x1.5b2796p-4, INEXACT)
T(RN,  0x1.c8176b643f16fp+780,    0x1.4f814db5b90d3p-1,   0x1.2722f4p-3, INEXACT)
T(RN,  0x1.b9d0d25449d4bp+780,    0x1.2e2835d7afd2ep-4,  -0x1.711808p-2, INEXACT)
T(RN,  0x1.53cc7082098fep+780,    0x1.4d43f83699641p-1,   0x1.c2c916p-3, INEXACT)
T(RN,  0x1.8443d4392e966p+780,   -0x1.d9ba9858da99fp-1,    0x1.3f08ap-2, INEXACT)
T(RN,  0x1.fe09beb14e12cp+780,   -0x1.df99dce7c02a8p-1,  -0x1.e7e0b4p-2, INEXACT)
T(RN,  0x1.0d73ba3033e1ep+781,    0x1.9f8fd453196f2p-2,  -0x1.d510a6p-6, INEXACT)
T(RN,  0x1.4f7fd16ae44f8p+781,    0x1.0b8ca78af5927p-2,    0x1.2dd18p-2, INEXACT)
T(RN,  0x1.35849ec9226f3p+781,   -0x1.fbe59e51274d3p-1,  -0x1.b0302ep-3, INEXACT)
T(RN,  0x1.2ff7035ee9c33p+781,    0x1.ff1036fcb61f3p-1,   -0x1.735d4p-2, INEXACT)
T(RN,   0x1.8c1e1c1a2128p+781,    0x1.fce05f75331cfp-1,  -0x1.cbda12p-2, INEXACT)
T(RN,  0x1.a050dd0a73ba4p+781,    0x1.fae609f68e07bp-1,   0x1.2608a2p-5, INEXACT)
T(RN,   0x1.ea9344e07901p+781,   -0x1.78ba80355f0cbp-5,    -0x1.eda7p-2, INEXACT)
T(RN,  0x1.0e2db381915dap+781,     0x1.d12bb4370621p-1,   0x1.4e665ap-4, INEXACT)
T(RN,  0x1.033a1afa2de9ap+781,    0x1.f7fec515b8004p-1,      0x1.9b1p-5, INEXACT)
T(RN,   0x1.e5026b38ac98p+781,    0x1.489ab545a480fp-1,    0x1.2a8d6p-4, INEXACT)
T(RN,  0x1.955e54f51c7ebp+782,    0x1.c16e762015abcp-2,     0x1.d086p-5, INEXACT)
T(RN,   0x1.1250b9d1e0dap+782,     0x1.9cf8f1698182p-4,   0x1.b8adeap-4, INEXACT)
T(RN,  0x1.a690a5d799c7dp+782,   -0x1.6039f37e5fc2ap-1,  -0x1.05c1e8p-5, INEXACT)
T(RN,  0x1.42326d80225a9p+782,    0x1.154e52ffca8cep-1,   0x1.477c8cp-2, INEXACT)
T(RN,  0x1.bb53c5fc83122p+782,    0x1.0c2355ae7832dp-1,  -0x1.164614p-3, INEXACT)
T(RN,  0x1.946ec311abef6p+782,    0x1.99123f138c512p-4,  -0x1.43d944p-2, INEXACT)
T(RN,  0x1.9f459dbdd9f7ep+782,   -0x1.9859c90f984abp-1,   -0x1.114abp-2, INEXACT)
T(RN,  0x1.5e2ef624b855cp+782,    0x1.085043d797411p-2,  -0x1.c43e18p-2, INEXACT)
T(RN,  0x1.6c616c26d4f3dp+782,   -0x1.8166bcc876eb6p-5,   0x1.545814p-2, INEXACT)
T(RN,  0x1.a82446f085cf7p+782,    0x1.ff72385d4919ep-1,   0x1.83a1e4p-3, INEXACT)
T(RN,  0x1.c9ec6c5ef5d98p+783,   -0x1.ce56b7c70b24fp-1,   -0x1.2edf3p-2, INEXACT)
T(RN,  0x1.0652d0bf6a383p+783,   -0x1.7620889f0f6f6p-1,   0x1.0472bap-2, INEXACT)
T(RN,  0x1.393ac55e2fa39p+783,   -0x1.edceb7eeb774cp-4,  -0x1.9e9bb6p-2, INEXACT)
T(RN,   0x1.e63ea67b249fp+783,   -0x1.c0c9800c7cef9p-1,  -0x1.2f7162p-3, INEXACT)
T(RN,  0x1.b242684d4c6b5p+783,    0x1.fec232df4a069p-1,  -0x1.8a6994p-3, INEXACT)
T(RN,  0x1.2737f69139e46p+783,   -0x1.69b66989824d5p-1,   0x1.68b528p-2, INEXACT)
T(RN,  0x1.3c0f2484ea6ffp+783,    -0x1.e5a5361fe498p-7,   0x1.3dd7eap-2, INEXACT)
T(RN,  0x1.b31a21908cc86p+783,    0x1.02ee35cc42aabp-1,   0x1.71f51cp-2, INEXACT)
T(RN,  0x1.7c657bb7e314ap+783,   -0x1.9b477e8cca315p-1,   0x1.b3fc6cp-2, INEXACT)
T(RN,  0x1.50e3112929b87p+783,    0x1.e735474533b3ep-3,   0x1.67ff6ap-2, INEXACT)
T(RN,  0x1.5470580742c3fp+784,   -0x1.dfbe578fc7dfcp-1,   0x1.51bc6cp-2, INEXACT)
T(RN,  0x1.8ed04ccebe6c2p+784,    0x1.31ce514f5c068p-1,   0x1.bf0c1ep-3, INEXACT)
T(RN,  0x1.a8b002cb336d8p+784,   -0x1.c1772faa7f311p-1,   0x1.ae69c4p-2, INEXACT)
T(RN,  0x1.a15abbaa864bdp+784,    0x1.db563374911d5p-1,  -0x1.d108d6p-3, INEXACT)
T(RN,  0x1.1c90ef55ec46ep+784,    0x1.f5dc4a55b4f0fp-1,    0x1.1943bp-2, INEXACT)
T(RN,  0x1.c18f22eb50e87p+784,   -0x1.7554aba241558p-2,  -0x1.5b6e7ep-5, INEXACT)
T(RN,  0x1.c9b1a40d22738p+784,   -0x1.95a5e8062b376p-2,  -0x1.16b738p-2, INEXACT)
T(RN,  0x1.f269b31ca9226p+784,   -0x1.4067c319cb95ep-1,   0x1.e33016p-2, INEXACT)
T(RN,  0x1.b3988ccec3d0dp+784,   -0x1.a675363a15d5fp-1,   0x1.738926p-4, INEXACT)
T(RN,  0x1.e97f9070db73fp+784,   -0x1.8372e6577b338p-1,  -0x1.0a7c74p-4, INEXACT)
T(RN,  0x1.5665672bf7c64p+785,     0x1.8da304f9fb68p-1, -0x1.204194p-10, INEXACT)
T(RN,   0x1.142e06f76786p+785,    0x1.89a0d9b898731p-1,  -0x1.6287f6p-3, INEXACT)
T(RN,  0x1.13e9a82d41c6bp+785,   -0x1.ffd99c41fd394p-1,  -0x1.e65e3ep-3, INEXACT)
T(RN,  0x1.8a745ff178e3ap+785,   -0x1.9b973fca7ef92p-1,   0x1.314da8p-2, INEXACT)
T(RN,  0x1.6d08d88488f16p+785,    0x1.d623e7437f585p-1,   0x1.ebcf02p-5, INEXACT)
T(RN,  0x1.99c29a84a53a6p+785,   -0x1.a3ce875582536p-1,  -0x1.cee6f8p-3, INEXACT)
T(RN,  0x1.720578a503d3fp+785,    0x1.672900ee6f5b2p-2,   0x1.a78e3ap-4, INEXACT)
T(RN,  0x1.0d9a6356030a2p+785,    0x1.a770c07da3695p-1,  -0x1.55ea6ap-2, INEXACT)
T(RN,  0x1.3a1b0cab5c1ffp+785,   -0x1.409a9afcaafa4p-3,  -0x1.705436p-2, INEXACT)
T(RN,  0x1.6d3308dab891cp+785,   -0x1.f148491a9ecffp-1,   0x1.eafd38p-2, INEXACT)
T(RN,  0x1.6c09896bdb981p+786,    0x1.15cc27a2310f6p-3,    0x1.3abfap-2, INEXACT)
T(RN,  0x1.1d46dc7abed1ap+786,    0x1.ee55cfb974f8fp-1,  -0x1.8a8058p-2, INEXACT)
T(RN,  0x1.6b82f18b72803p+786,     0x1.ffc17e1f50e2p-1,   -0x1.29912p-2, INEXACT)
T(RN,  0x1.9760cb7148ceap+786,    0x1.af8fb86317369p-2,   -0x1.6b125p-2, INEXACT)
T(RN,  0x1.07cbc32000ab7p+786,    0x1.0da3ef0b2758bp-1,   0x1.da714ep-5, INEXACT)
T(RN,  0x1.e8e162115b7aap+786,   -0x1.944776ad7d95fp-1,   0x1.91dcc8p-2, INEXACT)
T(RN,  0x1.c3a284d377e85p+786,   -0x1.1f81294903994p-1,  -0x1.109cfap-4, INEXACT)
T(RN,  0x1.1634d07103752p+786,    0x1.f35a712e4bc34p-1,   0x1.6922aap-2, INEXACT)
T(RN,  0x1.255468bfec077p+786,    0x1.3ffca4eba6c39p-2,   0x1.8ced38p-7, INEXACT)
T(RN,  0x1.342b19f396224p+786,    0x1.a289f8608bf23p-2,   0x1.d52e18p-2, INEXACT)
T(RN,  0x1.8fefc42445314p+787,    0x1.ac05ae224a7cap-2,   -0x1.cb267p-3, INEXACT)
T(RN,   0x1.64c2831f1b39p+787,   -0x1.3e71b50652846p-1,   0x1.0ed982p-2, INEXACT)
T(RN,  0x1.4060d94ef4935p+787,    0x1.ec04bd1f3ed97p-1,  0x1.025ea8p-12, INEXACT)
T(RN,  0x1.4fc360042c351p+787,    0x1.435736a1ec6a9p-1,  -0x1.ea6db2p-3, INEXACT)
T(RN,  0x1.898a743696d1ep+787,   -0x1.cf078f04f81fbp-1,   0x1.cf64fep-2, INEXACT)
T(RN,  0x1.6cf3e245f4232p+787,    0x1.725ff478b369dp-1,   -0x1.e3fc7p-2, INEXACT)
T(RN,  0x1.3957eeeaab964p+787,    -0x1.6ebcb81adaf3p-1,   0x1.3f07d4p-2, INEXACT)
T(RN,  0x1.612b4163175d8p+787,     0x1.1a90fcb44f8bp-2,   0x1.3d177ep-2, INEXACT)
T(RN,  0x1.76aa35588d299p+787,    0x1.c89478f1b6fadp-3,  -0x1.3a09bap-3, INEXACT)
T(RN,  0x1.f650a86191106p+787,    0x1.f9e55476ef2b3p-1,  -0x1.56149cp-3, INEXACT)
T(RN,  0x1.eec3a4f4d8428p+788,    0x1.f4eebfbb02024p-1,   -0x1.1601bp-2, INEXACT)
T(RN,  0x1.1e317fab947a6p+788,    0x1.b0ad4872bc976p-1,   0x1.c46edep-2, INEXACT)
T(RN,  0x1.9aa4889545be6p+788,    0x1.f647e8302a408p-1,   0x1.61a4e6p-2, INEXACT)
T(RN,  0x1.656544fb3677fp+788,    0x1.8b567bd2c0a6fp-1,  -0x1.6b775ap-2, INEXACT)
T(RN,  0x1.ff92955d6a558p+788,     0x1.5073960db0c3p-1,   0x1.4b82f2p-3, INEXACT)
T(RN,  0x1.d09c5b8693caep+788,    0x1.964076d30fbfcp-2,  -0x1.d3b514p-3, INEXACT)
T(RN,  0x1.22125f98ce9a5p+788,     0x1.b487dfd9a749p-2,  -0x1.76a4cep-3, INEXACT)
T(RN,  0x1.466136ce5a018p+788,    0x1.fd3f5c38f9fa5p-1,  -0x1.63391ap-4, INEXACT)
T(RN,  0x1.6305e6d46fa6ep+788,   -0x1.a5094e6603231p-1,    0x1.bd216p-7, INEXACT)
T(RN,   0x1.35a7d6c399d3p+788,    0x1.cfd77a264c547p-1,  -0x1.83f2b6p-3, INEXACT)
T(RN,  0x1.388c2f76ebbb5p+789,   -0x1.c08132468f0dbp-1,   0x1.14db1ep-2, INEXACT)
T(RN,  0x1.1e5d12063c34fp+789,    -0x1.64a93ed86484p-2,   0x1.d6b556p-2, INEXACT)
T(RN,   0x1.c7b58ae57b77p+789,    0x1.e41e85bfa8253p-1,  -0x1.fc341ep-3, INEXACT)
T(RN,  0x1.9ede76fe52c24p+789,    0x1.5421ebde6c468p-1,   0x1.dfc9eap-2, INEXACT)
T(RN,   0x1.e8dedfb389c4p+789,   -0x1.3e19716121f1cp-1,   0x1.f5d072p-3, INEXACT)
T(RN,   0x1.1ee5a7604b7dp+789,    0x1.8631505208de1p-2,  -0x1.3c1bb8p-5, INEXACT)
T(RN,  0x1.d043d97c9798cp+789,   -0x1.f3d55169d3539p-1,  -0x1.80db5ep-2, INEXACT)
T(RN,  0x1.6e4ebe4672641p+789,    0x1.f4974bd055358p-1,  -0x1.db0cc6p-2, INEXACT)
T(RN,  0x1.3160f29819e38p+789,   -0x1.f75405bc67c1ep-1,  -0x1.05c6b2p-3, INEXACT)
T(RN,  0x1.620af9528df74p+789,    0x1.ea0795e522c9ep-1,   0x1.f757d4p-2, INEXACT)
T(RN,  0x1.d8cf0bcea278ep+790,   -0x1.b71a26dac23c4p-1,  -0x1.bd468ap-4, INEXACT)
T(RN,  0x1.717ed08551343p+790,   -0x1.ffe5de592ce5ep-1,   -0x1.96496p-4, INEXACT)
T(RN,  0x1.8389a758142e3p+790,    0x1.229e2901ffb23p-2,   0x1.21fe3ap-2, INEXACT)
T(RN,  0x1.3d218dff0ceb9p+790,   -0x1.f81e84b442048p-1,   0x1.d9a49cp-6, INEXACT)
T(RN,  0x1.1602338370115p+790,   -0x1.1bc380e46710ep-1,  -0x1.3e12a4p-9, INEXACT)
T(RN,  0x1.29e5bd8f66bafp+790,   -0x1.9f41c128c07c4p-4,   0x1.88eaa6p-2, INEXACT)
T(RN,  0x1.22aac71d2f4e4p+790,    0x1.b08679c347f3dp-9,  -0x1.f82768p-2, INEXACT)
T(RN,  0x1.5dcb48123496cp+790,    0x1.93dcce9a7ab73p-1,  -0x1.ffe668p-3, INEXACT)
T(RN,   0x1.db04370d5686p+790,   -0x1.927e0258ee805p-3,   0x1.e8e956p-2, INEXACT)
T(RN,  0x1.688522fa116e1p+790,    0x1.e4ffd519efa02p-1,  -0x1.cdcc3ep-3, INEXACT)
T(RN,   0x1.29c343949981p+791,    0x1.f37bb79bb27c4p-1,  -0x1.fa508ap-3, INEXACT)
T(RN,  0x1.4acf7701d0188p+791,   -0x1.68388404aba1cp-1,   0x1.a3f2eep-3, INEXACT)
T(RN,  0x1.520275a78415ap+791,    0x1.fd5ad608f10aep-1,   0x1.e20992p-4, INEXACT)
T(RN,  0x1.0badebb6cfa77p+791,    0x1.ac552b8e17262p-1,  -0x1.94c62ep-2, INEXACT)
T(RN,  0x1.e8e785b668a88p+791,   -0x1.c2d63605a4ae6p-6,  -0x1.a722fcp-3, INEXACT)
T(RN,  0x1.56c7230a56be9p+791,    0x1.9c4439bf4efcep-2,  -0x1.8c24fep-2, INEXACT)
T(RN,  0x1.25bbc41d2451bp+791,   -0x1.9ae7b55a5c57bp-1,   0x1.ede388p-4, INEXACT)
T(RN,  0x1.b6ee52a037ca3p+791,    0x1.8be4ee1517943p-5,   0x1.838612p-2, INEXACT)
T(RN,  0x1.e748ebacb743ep+791,    0x1.f7d8414a0734ap-3,   0x1.1b9956p-4, INEXACT)
T(RN,   0x1.fe82b298e8cap+791,    0x1.93edd7a0a1124p-1,  0x1.bb5698p-14, INEXACT)
T(RN,   0x1.13a4bd1f4351p+792,   -0x1.064d49ed19635p-3,   0x1.e4c534p-3, INEXACT)
T(RN,  0x1.dd065d6d068cap+792,   -0x1.f2e221e14859fp-1,   0x1.e26fc4p-7, INEXACT)
T(RN,  0x1.4974ae247aea2p+792,    0x1.ffc379706e749p-1,  -0x1.41f3d6p-3, INEXACT)
T(RN,  0x1.5ee1db57955bap+792,    0x1.11156a91c1d25p-1,   0x1.7e8594p-2, INEXACT)
T(RN,  0x1.4f4b61ffc7fa8p+792,    0x1.d5efacb321e1bp-4,   0x1.008068p-2, INEXACT)
T(RN,  0x1.c2688955bd8aap+792,   -0x1.c9722d9796453p-1,   0x1.d316d6p-2, INEXACT)
T(RN,  0x1.8cf94a988bab8p+792,   -0x1.ee800a04a6f58p-1,  -0x1.49662ep-2, INEXACT)
T(RN,  0x1.d88f1c16b0f92p+792,   -0x1.fa744fe1184afp-1,   0x1.00c85cp-3, INEXACT)
T(RN,  0x1.0b3811a061bdbp+792,   -0x1.178543d5cc6d5p-2,  -0x1.fcfafep-6, INEXACT)
T(RN,  0x1.ae55b1350cb92p+792,   -0x1.c570720b56f5bp-1,   0x1.50b992p-2, INEXACT)
T(RN,  0x1.71fe4f1174598p+793,    0x1.8d86d287db64ap-1,  -0x1.c91d86p-3, INEXACT)
T(RN,  0x1.37495772b6b5bp+793,    0x1.14a1c0ed1047fp-1,  -0x1.498412p-2, INEXACT)
T(RN,  0x1.4f45161c7ec2fp+793,   -0x1.051eeed3c02d5p-1,   0x1.4eb694p-4, INEXACT)
T(RN,  0x1.24fd17e08c925p+793,   -0x1.a63cad5bfa718p-1,   0x1.efc1b6p-5, INEXACT)
T(RN,  0x1.ceaa5d397061ep+793,   -0x1.8396b2f61fbb7p-1,  -0x1.6d137ep-3, INEXACT)
T(RN,  0x1.660698a1628d3p+793,     0x1.e8ec391a0fadp-1,  -0x1.6e6204p-2, INEXACT)
T(RN,   0x1.60e4f51c97dbp+793,   -0x1.06cfb78032f07p-1,  -0x1.fe6fcap-2, INEXACT)
T(RN,  0x1.6ea66e33a650fp+793,    0x1.3ad582422fecfp-3,   0x1.ac71b8p-5, INEXACT)
T(RN,  0x1.af36f9b0f0d84p+793,   -0x1.d5ab378393e0ep-2,   -0x1.7acd8p-2, INEXACT)
T(RN,   0x1.3ae7538b2b15p+793,   -0x1.21d5c334eccbep-1,  -0x1.221086p-5, INEXACT)
T(RN,    0x1.d2bbff8b0f5p+794,   -0x1.63e367cfd5cc4p-1,   0x1.c5658ap-2, INEXACT)
T(RN,  0x1.93745320480f8p+794,   -0x1.18f5f51cb301bp-1,    0x1.95ccfp-2, INEXACT)
T(RN,  0x1.62aba69606b0fp+794,   -0x1.da31e94e61df9p-1,  -0x1.c8379cp-3, INEXACT)
T(RN,  0x1.0f75d1a08ba3ap+794,    0x1.eb769cc76befbp-1,  -0x1.3fc5d6p-2, INEXACT)
T(RN,  0x1.2c9ad909412b7p+794,   -0x1.820eb08cf9bc9p-1,    0x1.8927fp-2, INEXACT)
T(RN,  0x1.ea8d28111f10ap+794,    0x1.d6592e8710f01p-3,  -0x1.f267bep-2, INEXACT)
T(RN,  0x1.7cc9cd353b853p+794,    0x1.0bf8e06263db1p-1,  -0x1.3b8314p-2, INEXACT)
T(RN,  0x1.0c2900f47dcf6p+794,    0x1.6592d0ecc8512p-1,    0x1.72811p-6, INEXACT)
T(RN,  0x1.7afe5d5513608p+794,    0x1.d27840b030177p-1,   0x1.3ddb2ep-3, INEXACT)
T(RN,  0x1.33de18de67bc9p+794,    0x1.f9b9714febadcp-1,  -0x1.f9213ep-5, INEXACT)
T(RN,  0x1.cf8d1a90f9034p+795,   -0x1.fb877588de9e3p-1,  -0x1.866c0cp-2, INEXACT)
T(RN,  0x1.8e8e9d28738bap+795,     0x1.abf5f1b3d1f8p-1,    0x1.10bb7p-2, INEXACT)
T(RN,  0x1.cf7e501f15cd1p+795,   -0x1.e409fdf917db1p-1,   0x1.04bcbap-2, INEXACT)
T(RN,  0x1.c354b7c73c332p+795,    0x1.3e76cc9ffc6bcp-2,  -0x1.9ac1fap-5, INEXACT)
T(RN,  0x1.21835e52ddddep+795,    0x1.55bd82db3e40ap-1,  -0x1.0b1228p-4, INEXACT)
T(RN,   0x1.982527e5fe0ep+795,    0x1.fae33931a2708p-1,  -0x1.955f94p-2, INEXACT)
T(RN,  0x1.658f2738d32cep+795,    0x1.e7beee2afccecp-5,   0x1.f430dap-2, INEXACT)
T(RN,  0x1.bdd254eefe476p+795,    0x1.c98302248113cp-1,  -0x1.38077ep-2, INEXACT)
T(RN,  0x1.5e7b1ebf65f55p+795,    0x1.a0a40c0962f54p-6,  -0x1.dba004p-3, INEXACT)
T(RN,  0x1.f534888482adcp+795,     0x1.4b566b4b3144p-1,  -0x1.5e9062p-4, INEXACT)
T(RN,  0x1.0e2b3ffb18f95p+796,   -0x1.3e80e23de65a4p-1,   -0x1.a769cp-2, INEXACT)
T(RN,  0x1.62405f16db9bfp+796,    0x1.1e86980e55a41p-1,   0x1.04d20cp-2, INEXACT)
T(RN,  0x1.8b187af66fb7cp+796,   -0x1.f9d824ce16ca3p-2,  -0x1.92555ap-6, INEXACT)
T(RN,  0x1.84ca589472e82p+796,   -0x1.e859eea2be186p-1,   0x1.3ab194p-2, INEXACT)
T(RN,  0x1.7eee45897a472p+796,   -0x1.d0e66a300afb4p-1,  -0x1.f22d8ep-8, INEXACT)
T(RN,  0x1.baa4efb0125f8p+796,   -0x1.044ffbc9880b2p-1,   -0x1.7e60dp-3, INEXACT)
T(RN,  0x1.bbfe41a3da1e3p+796,   -0x1.a31addcd7f911p-1,   0x1.6c3feap-4, INEXACT)
T(RN,  0x1.4ef8fcaf26affp+796,    0x1.6782b76f32206p-3,   0x1.ab6d76p-2, INEXACT)
T(RN,  0x1.a0032a35119cfp+796,    0x1.58bbafca07b75p-4,  -0x1.b4f376p-3, INEXACT)
T(RN,  0x1.fc9ad9c9d1792p+796,   -0x1.eed913f8544c2p-1,   0x1.ec5a02p-2, INEXACT)
T(RN,  0x1.f1d2e1a6781b2p+797,   -0x1.fc70581a4557bp-1,  -0x1.4ab2ecp-3, INEXACT)
T(RN,  0x1.045c33802c3b2p+797,    0x1.fafbe13b077bbp-1,   0x1.128e2ap-2, INEXACT)
T(RN,  0x1.4dc49b1e8430ap+797,    0x1.40f101885e7cfp-1,  -0x1.0401dep-3, INEXACT)
T(RN,  0x1.869ab6493fb04p+797,     0x1.fc2f3460df6ap-1,   0x1.58446ep-3, INEXACT)
T(RN,  0x1.9ade8bbdbf6c4p+797,   -0x1.8c912555ee3eap-2,  -0x1.3f644ap-2, INEXACT)
T(RN,  0x1.46b30a4361658p+797,   -0x1.d977f92363fa4p-1,  -0x1.bd789ep-6, INEXACT)
T(RN,  0x1.60035da02afd6p+797,    0x1.d01375ecf7202p-2,  -0x1.837434p-6, INEXACT)
T(RN,  0x1.917abda863f65p+797,    0x1.849e2ef224629p-1,   0x1.cc22ecp-3, INEXACT)
T(RN,  0x1.b433f29b868dcp+797,   -0x1.3f6181dcdf096p-1,  -0x1.e9db96p-4, INEXACT)
T(RN,  0x1.c5791e6a41a7ep+797,   -0x1.ef13a5a25b2d7p-2,  -0x1.47f588p-3, INEXACT)
T(RN,  0x1.cb75c2e57637ep+798,    -0x1.9f12385e8f64p-1,     0x1.ecb7p-8, INEXACT)
T(RN,  0x1.ea454cf81ea58p+798,    0x1.83aba0708bbc9p-1,   -0x1.7fc6ep-2, INEXACT)
T(RN,  0x1.0e7e68032f715p+798,   -0x1.ee3841e3fdc71p-1,   0x1.a8a3aap-2, INEXACT)
T(RN,  0x1.b69558a57e9ecp+798,    0x1.b9e1e86f308a8p-2,  -0x1.405456p-2, INEXACT)
T(RN,  0x1.14ce26ed13343p+798,   -0x1.60325dc6f326cp-2,  -0x1.2d41b6p-2, INEXACT)
T(RN,   0x1.2648449531ccp+798,    0x1.5d1e8c96bb246p-1,   0x1.94944cp-2, INEXACT)
T(RN,  0x1.c0c8d9ec37488p+798,   -0x1.63a7684824a95p-1,  -0x1.61aeecp-2, INEXACT)
T(RN,  0x1.ed929396ffd1dp+798,   -0x1.d0ba2c6032d45p-1,   0x1.8eaf66p-6, INEXACT)
T(RN,  0x1.de4f422f49f64p+798,   -0x1.8f55549262453p-1,   -0x1.f636bp-2, INEXACT)
T(RN,  0x1.a5c6764a4eba6p+798,    0x1.ffff5e3ecce2bp-1,   0x1.ffe77ep-4, INEXACT)
T(RN,  0x1.65f2a121a0c0ap+799,   -0x1.ddfc4b3b1040dp-4,  -0x1.ee8efcp-4, INEXACT)
T(RN,  0x1.41ceeb91aedeep+799,    0x1.948afad1728a1p-4,  -0x1.e62df8p-2, INEXACT)
T(RN,  0x1.3553bf2406295p+799,    0x1.8a07bcc55de3dp-1,  -0x1.51f3cap-4, INEXACT)
T(RN,  0x1.a6ba38b2b20adp+799,   -0x1.e4b42b9b3912bp-2,   0x1.12d034p-2, INEXACT)
T(RN,  0x1.ec0b259311183p+799,   -0x1.fefd2f130d9d4p-1,  -0x1.9acd5cp-2, INEXACT)
T(RN,   0x1.77a49a1e6e7cp+799,   -0x1.28713ec9371f7p-1,   0x1.67ff9ep-9, INEXACT)
T(RN,  0x1.3018849aa09bfp+799,    0x1.61b3f698df114p-2,   0x1.fca18cp-2, INEXACT)
T(RN,  0x1.242ea2df39de6p+799,   -0x1.1c60a550ebd37p-1,  -0x1.032936p-5, INEXACT)
T(RN,  0x1.d9f3919f5f2ffp+799,    0x1.cb77bf243d44ep-1,  -0x1.9733aap-5, INEXACT)
T(RN,  0x1.7996468529b26p+799,    0x1.6d41d995e7e96p-1,   0x1.e254d8p-2, INEXACT)
T(RN,   0x1.d7182335ed5dp+800,   -0x1.290e56c53c202p-5,  -0x1.d33404p-7, INEXACT)
T(RN,  0x1.dd29713f14054p+800,    0x1.ccb63c79d5feep-1,   0x1.7c1588p-2, INEXACT)
T(RN,  0x1.48c400fab266bp+800,    0x1.fd24fee7159fep-1,    0x1.3c1b8p-4, INEXACT)
T(RN,  0x1.0daffc3975394p+800,   -0x1.84b7c279e5424p-1,  -0x1.96affap-2, INEXACT)
T(RN,  0x1.c43bae07595e1p+800,     0x1.06b88bbb3d4bp-1,   0x1.c29294p-4, INEXACT)
T(RN,  0x1.5f4acae312608p+800,   -0x1.d85f1f01df6e6p-2,   0x1.c436f2p-2, INEXACT)
T(RN,  0x1.39c13ee7ed755p+800,    0x1.ed89e24279a19p-1,   0x1.e0df72p-2, INEXACT)
T(RN,  0x1.645ceb7e11969p+800,   -0x1.be8906b5cd65cp-1,  -0x1.f13f48p-3, INEXACT)
T(RN,  0x1.3177183d5f421p+800,     0x1.4d7d05cdc9fcp-4,   0x1.c66054p-2, INEXACT)
T(RN,  0x1.104fde57ac988p+800,   -0x1.ad0ac06b42b7bp-1,  -0x1.5d2242p-5, INEXACT)
T(RN,  0x1.1a887567492e4p+801,   -0x1.f5ee0c6d37e6ap-2,   -0x1.ffdcbp-3, INEXACT)
T(RN,  0x1.413c8f2f6ea14p+801,    0x1.c53b8beabe792p-3,   -0x1.61027p-3, INEXACT)
T(RN,   0x1.aab9d5fab10ep+801,    0x1.cde9e699d654ap-1,   0x1.e1fb38p-3, INEXACT)
T(RN,  0x1.7a433acabff04p+801,    0x1.ea0e1d5a4515dp-1,   0x1.17545ap-2, INEXACT)
T(RN,  0x1.33ea74b39b608p+801,   -0x1.1ca9e79029d0bp-1,  -0x1.4870b6p-8, INEXACT)
T(RN,  0x1.fb0fd48e364aap+801,   -0x1.fe3af8696c0aap-1,   0x1.864574p-2, INEXACT)
T(RN,  0x1.9f6036e121eeep+801,    0x1.458c931d79b3bp-3,  -0x1.22b724p-2, INEXACT)
T(RN,   0x1.30b96b9f90b1p+801,    0x1.ff97e05ba490ap-1,  -0x1.69584ap-4, INEXACT)
T(RN,  0x1.6999fa9ae8a8fp+801,    0x1.aece59eb53d19p-1,   0x1.a58c5cp-2, INEXACT)
T(RN,  0x1.2c3904abf54ebp+801,    -0x1.b0d78b73bfa2p-2,   0x1.9f32fcp-3, INEXACT)
T(RN,  0x1.d2b735f8d373ep+802,   -0x1.6a3cdb4f7c3e8p-6,  -0x1.4a28b8p-2, INEXACT)
T(RN,  0x1.591b78ef043a3p+802,   -0x1.fe8cd03a664b3p-1,  -0x1.fe6686p-3, INEXACT)
T(RN,  0x1.1b44e1f72236dp+802,   -0x1.129a47842f2b7p-1,   0x1.412076p-3, INEXACT)
T(RN,  0x1.95d2e3e011b56p+802,    -0x1.0933fedc5d18p-2,  -0x1.ffd93cp-2, INEXACT)
T(RN,  0x1.f7e940b8b805cp+802,    0x1.bb29fa8767f1ep-2,  -0x1.20845cp-2, INEXACT)
T(RN,  0x1.bc982f951a08cp+802,   -0x1.3e45cb7b03f25p-3,   0x1.e18b64p-3, INEXACT)
T(RN,  0x1.ca8363a57e32cp+802,    0x1.4a96bcf7eb5f9p-1,   0x1.32f25ap-3, INEXACT)
T(RN,   0x1.bf41bb22cec2p+802,   -0x1.e03746c83a33bp-4,  -0x1.50cbdep-2, INEXACT)
T(RN,  0x1.9b3976c6aa43bp+802,    -0x1.2029db34c5b7p-2,  -0x1.d25ad8p-2, INEXACT)
T(RN,  0x1.98b1e47b68658p+802,    0x1.c605859fba63ap-1,  -0x1.f4db7ep-3, INEXACT)
T(RN,  0x1.7ed45a4091ce2p+803,   -0x1.e9f6db6d8ef0bp-1,  -0x1.50e378p-2, INEXACT)
T(RN,  0x1.14bb9081d408cp+803,    0x1.2f86aa5d29fd6p-1,    0x1.3b636p-2, INEXACT)
T(RN,  0x1.61bec49668948p+803,    0x1.e2fa2c7c92aebp-2,  -0x1.f93cc6p-2, INEXACT)
T(RN,  0x1.4cdf863349492p+803,   -0x1.ed9c1e6993cc6p-1,    -0x1.06c4p-2, INEXACT)
T(RN,  0x1.c443d58bc4e34p+803,     0x1.e904f255ff84p-1,  -0x1.98d3e6p-2, INEXACT)
T(RN,  0x1.76bba6c4a6eaep+803,   -0x1.bd3a60771f7c5p-3,   0x1.c43dc2p-2, INEXACT)
T(RN,  0x1.6fb63d6f03434p+803,    0x1.3f8998f6f09c5p-1,  -0x1.a09d84p-2, INEXACT)
T(RN,  0x1.673741efcbabfp+803,   -0x1.f3b6fd7b57189p-1,  -0x1.2e8378p-2, INEXACT)
T(RN,  0x1.860c2aaa25a14p+803,    0x1.223807d1e021cp-4,  -0x1.4b8b14p-2, INEXACT)
T(RN,  0x1.0ad9d3c6ca3afp+803,    0x1.43d8c6242216bp-2,  -0x1.818de8p-4, INEXACT)
T(RN,  0x1.82199a6b941dap+804,    0x1.e5b8cd52926fap-1,   0x1.beacd4p-2, INEXACT)
T(RN,  0x1.d596544edc41cp+804,   -0x1.00a22c7420f68p-1,   0x1.61970ep-4, INEXACT)
T(RN,   0x1.e79b23e1532cp+804,    -0x1.e59cfd16042ep-1,   0x1.7422e2p-2, INEXACT)
T(RN,  0x1.1561c1ad5bed3p+804,    0x1.b869010e457a7p-1,   0x1.bdcdfap-2, INEXACT)
T(RN,  0x1.0287bd3d5f8d8p+804,   -0x1.1b047a214891ep-1,   0x1.84915cp-2, INEXACT)
T(RN,  0x1.24e107b5b87c6p+804,   -0x1.54588eff70e27p-1,    0x1.4b7fap-3, INEXACT)
T(RN,  0x1.9bf2573e59ebap+804,    0x1.b887e2e7f7869p-2,  -0x1.095af6p-3, INEXACT)
T(RN,  0x1.0465b2e781a23p+804,     0x1.fe7e471bfd64p-1,  -0x1.2cd24ep-2, INEXACT)
T(RN,  0x1.bd66696905589p+804,    0x1.72ee178898de9p-2,  -0x1.73a52ap-2, INEXACT)
T(RN,  0x1.b00d0d60afd83p+804,   -0x1.2364cfe0f18bfp-9,  -0x1.3e8486p-2, INEXACT)
T(RN,  0x1.23f7619fc8416p+805,    0x1.eedac23a01f09p-4,  -0x1.6bbd6ep-2, INEXACT)
T(RN,  0x1.adb9b101100e6p+805,   -0x1.f0a6d85bba90cp-1,  -0x1.085718p-2, INEXACT)
T(RN,  0x1.6e6bd20be2eaep+805,    0x1.ffbcde2b52cf3p-1,   0x1.1d4a66p-4, INEXACT)
T(RN,  0x1.a6ac9427ea11ap+805,    0x1.6ad67d6a28147p-3,   0x1.cd0fcap-6, INEXACT)
T(RN,  0x1.6c3be2786951ap+805,   -0x1.8877b55436865p-6,   -0x1.a9fb6p-4, INEXACT)
T(RN,  0x1.074d1d7059ffdp+805,   -0x1.fe34aa5a665d7p-1,   0x1.e0b9e2p-6, INEXACT)
T(RN,  0x1.6cca600021a26p+805,    0x1.44f870f055016p-1,  -0x1.be035ap-3, INEXACT)
T(RN,  0x1.93b4b4553efecp+805,    0x1.c24724946e853p-1,    0x1.07bc7p-2, INEXACT)
T(RN,  0x1.e60d2c6ace984p+805,   -0x1.41e74b755a6f6p-1,   0x1.aa79a8p-3, INEXACT)
T(RN,  0x1.0176e29dbda0bp+805,   -0x1.7567b403ed1dap-3,  -0x1.6ca592p-2, INEXACT)
T(RN,  0x1.284ddb8a402b6p+806,   -0x1.5bbba741e2554p-1,  -0x1.c21eaap-2, INEXACT)
T(RN,  0x1.8397fe150adeep+806,     0x1.d253030e4162p-2,   0x1.cf9ef2p-3, INEXACT)
T(RN,   0x1.eaa3cdb2c70dp+806,    0x1.2a888204b6b56p-1,   0x1.6dc17cp-2, INEXACT)
T(RN,   0x1.4be144e8c5cfp+806,    0x1.ff0767f4f0db5p-1,   0x1.c6641ap-3, INEXACT)
T(RN,  0x1.8cf971a0d54e3p+806,    0x1.fd2ac4299dfcdp-3,   0x1.df593cp-2, INEXACT)
T(RN,  0x1.e291ad3106fd8p+806,   -0x1.3e760262fa74cp-1,  -0x1.211dc6p-3, INEXACT)
T(RN,  0x1.568dcd1a43a9dp+806,   -0x1.22fc63b26fe24p-1,    0x1.6e9eep-2, INEXACT)
T(RN,  0x1.70da50acc6bc9p+806,   -0x1.c0ab53c52343cp-3,  -0x1.ba1ac2p-3, INEXACT)
T(RN,  0x1.51eca8c659cd4p+806,    0x1.e43eb668e82e6p-1,  -0x1.2d6e5ap-2, INEXACT)
T(RN,  0x1.742cb98000591p+806,    0x1.d542baf3a5f62p-1,   0x1.1db566p-3, INEXACT)
T(RN,  0x1.72dc92bf3faffp+807,   -0x1.ba625786e1753p-1,  -0x1.c66de4p-3, INEXACT)
T(RN,  0x1.39f6aa95f8b17p+807,     0x1.f228a000a69cp-1,   0x1.d0627cp-2, INEXACT)
T(RN,  0x1.182a8f44036e6p+807,   -0x1.efe4474b28c73p-1,  -0x1.896832p-2, INEXACT)
T(RN,  0x1.d7b4c40ade0abp+807,   -0x1.84eaf6401c1afp-2,   0x1.9ca9fcp-3, INEXACT)
T(RN,  0x1.09f8cfd1e47dfp+807,    0x1.33ee1ddf27a05p-1,   0x1.1e6348p-2, INEXACT)
T(RN,  0x1.cac39098c0044p+807,    0x1.d8d1abb74ff49p-3,  -0x1.5f8a4ep-5, INEXACT)
T(RN,  0x1.3547b5b735043p+807,   -0x1.fbb7356064733p-2,  -0x1.bc8e1cp-2, INEXACT)
T(RN,  0x1.9059c1cfe87c6p+807,    0x1.7f384ec6cb75cp-1,     0x1.af06p-3, INEXACT)
T(RN,   0x1.947ec0b814fdp+807,    0x1.fe402460781eap-1,   -0x1.9d124p-3, INEXACT)
T(RN,   0x1.b948405e147ap+807,    0x1.1c276af1c37c2p-1,  -0x1.eb54acp-2, INEXACT)
T(RN,  0x1.4c1cb2635a567p+808,   -0x1.a65645bfc3b8bp-1,  -0x1.725c54p-4, INEXACT)
T(RN,  0x1.cb326b49c4bbdp+808,   -0x1.d1ca81b75f498p-1,   0x1.b73588p-2, INEXACT)
T(RN,  0x1.a459ba28920dap+808,    0x1.595b3911fc6abp-1,   0x1.203e28p-4, INEXACT)
T(RN,    0x1.d81fd1ec903p+808,    0x1.a0acf611080f9p-3,   0x1.4dfc62p-7, INEXACT)
T(RN,  0x1.7f845a73f0d36p+808,    0x1.9fc552a7542fbp-2,   0x1.16aab4p-2, INEXACT)
T(RN,  0x1.39920a1817828p+808,    0x1.a9880fb92204dp-2,  -0x1.dc5234p-2, INEXACT)
T(RN,  0x1.48a1f36723b84p+808,    0x1.dd4c3facd2db6p-1,  -0x1.374ee6p-2, INEXACT)
T(RN,  0x1.51a19a594b17cp+808,    0x1.afbd56ec9410cp-1,   0x1.9ebcb2p-2, INEXACT)
T(RN,  0x1.33b7463e6a66ep+808,    0x1.6a6343b7d5ec6p-2,   0x1.ce25b2p-2, INEXACT)
T(RN,  0x1.da4ecae2db752p+808,    0x1.5be8442537702p-1,   0x1.e61112p-4, INEXACT)
T(RN,  0x1.dfa507deea424p+809,   -0x1.c14518c6a6cc8p-1,   -0x1.26801p-4, INEXACT)
T(RN,  0x1.4fc8284276fb1p+809,   -0x1.520546989c8f7p-3,  -0x1.b0c2c6p-4, INEXACT)
T(RN,  0x1.c38c206ef33cep+809,   -0x1.f7a01ec526c5dp-3,   0x1.f68958p-2, INEXACT)
T(RN,  0x1.57d86d970fa66p+809,    0x1.0f8385dc73cfbp-1,   0x1.27313ap-2, INEXACT)
T(RN,  0x1.3f0326c855c38p+809,   -0x1.34e5337158efep-1,  -0x1.ec3d6cp-2, INEXACT)
T(RN,  0x1.9d5d21f9e8c86p+809,    0x1.ee547f6388037p-2,   0x1.359964p-4, INEXACT)
T(RN,   0x1.129ddc399903p+809,   -0x1.fe201ce8c1318p-1,  -0x1.6f52fep-4, INEXACT)
T(RN,  0x1.6f7f013d58e42p+809,    0x1.0aa03ab15a7b2p-2,   0x1.9163a2p-2, INEXACT)
T(RN,  0x1.3c492ce529841p+809,   -0x1.62219ae3d3862p-4,    0x1.702dap-2, INEXACT)
T(RN,  0x1.95be77597236cp+809,   -0x1.a82d29e558563p-1,  -0x1.33aa06p-4, INEXACT)
T(RN,  0x1.bad02168f75aep+810,    0x1.eaf9db5ef6841p-8,   0x1.23cd86p-3, INEXACT)
T(RN,  0x1.d04727fb74c74p+810,    0x1.3448d6ede3b95p-2,    0x1.a5aabp-2, INEXACT)
T(RN,  0x1.477063cad5199p+810,    0x1.74f89d312153ep-6,   0x1.6700e6p-2, INEXACT)
T(RN,  0x1.f15f261c3cf38p+810,    0x1.73e13bf413912p-4,  -0x1.de5032p-2, INEXACT)
T(RN,  0x1.54ede5573641dp+810,    0x1.bacfb6201e69dp-1,  -0x1.ac1f38p-2, INEXACT)
T(RN,  0x1.c3001bf3754acp+810,    0x1.63f33304ea76fp-1,  -0x1.697bd8p-5, INEXACT)
T(RN,  0x1.6dc9e87e4a603p+810,    0x1.a852ce7c7dfb7p-4,  -0x1.9b8deap-2, INEXACT)
T(RN,  0x1.1ef3e2807849ep+810,   -0x1.3c316f9588da7p-1,  -0x1.70e924p-3, INEXACT)
T(RN,  0x1.76bc813f113bep+810,   -0x1.064abc6c6d9cap-1,   -0x1.8ebb8p-2, INEXACT)
T(RN,  0x1.a7bdd848eb15cp+810,   -0x1.57c8d604ba66ep-1,  -0x1.759e86p-2, INEXACT)
T(RN,  0x1.83ddbb2dd263ep+811,   -0x1.94e44ea516aedp-1,   0x1.a05136p-3, INEXACT)
T(RN,  0x1.cdef924d44ed4p+811,    0x1.11ca90a0d2ddbp-1,   0x1.ea0aeap-2, INEXACT)
T(RN,  0x1.7c8b44c986d23p+811,    0x1.b66af4355fd5fp-2,   0x1.b15ac2p-2, INEXACT)
T(RN,  0x1.0207003b34fa6p+811,    0x1.8dcdd00ae0b1dp-1,  -0x1.4dedbep-3, INEXACT)
T(RN,   0x1.1f75a0b95a26p+811,    0x1.75a955e3c6942p-1,   0x1.e679e8p-2, INEXACT)
T(RN,  0x1.be1e977688bdcp+811,    0x1.feaf587f5767fp-1,   0x1.68dbd2p-2, INEXACT)
T(RN,   0x1.edf448b3aaacp+811,    0x1.ec34b5e8b291dp-1,    0x1.b78fbp-3, INEXACT)
T(RN,  0x1.ee21683ce5bb6p+811,   -0x1.60440e4adf04ep-4,   0x1.cf0de8p-3, INEXACT)
T(RN,   0x1.811991f108c2p+811,   -0x1.86166e84db268p-1,  -0x1.cd9298p-3, INEXACT)
T(RN,  0x1.298fce0e86a7fp+811,    0x1.f01660ea3a4dbp-1,   -0x1.131bap-2, INEXACT)
T(RN,  0x1.17d4c7f95fbefp+812,    0x1.615c75a6f1b82p-1,  -0x1.48702cp-4, INEXACT)
T(RN,  0x1.d72ec59db9948p+812,   -0x1.7f480639b61b7p-1, -0x1.a81c18p-10, INEXACT)
T(RN,  0x1.ab6d1d673eeddp+812,   -0x1.df7f6531892b5p-1,   0x1.f41a5ap-3, INEXACT)
T(RN,  0x1.765dea2d63b97p+812,    0x1.aedd241d21b3dp-2,   0x1.75e1dap-2, INEXACT)
T(RN,  0x1.64a050532e8dbp+812,    0x1.3e87fdbf4507ep-1,  -0x1.cd940cp-2, INEXACT)
T(RN,  0x1.7ac6dfcc46d46p+812,   -0x1.a5d3d1853ad04p-2,   0x1.5deb54p-2, INEXACT)
T(RN,  0x1.f82309b5befe6p+812,    0x1.fb695393c51b8p-1,  -0x1.dd39ecp-2, INEXACT)
T(RN,  0x1.8efafa656f5eap+812,    0x1.091620f2c29dep-4,  -0x1.94847ep-3, INEXACT)
T(RN,  0x1.9b16079c9ea7ep+812,    0x1.87f8e02705f3ap-2,  -0x1.f35bdcp-2, INEXACT)
T(RN,  0x1.81f5a3b77ab89p+812,    0x1.faf8a780e36ffp-1,    0x1.823cdp-2, INEXACT)
T(RN,  0x1.9c179afbd70c6p+813,    0x1.fe8dce13be6fbp-1,   0x1.94f154p-2, INEXACT)
T(RN,  0x1.934d0fad3dd58p+813,    0x1.ef9e51287527cp-1,  -0x1.a2e56ep-2, INEXACT)
T(RN,  0x1.507e26f484673p+813,   -0x1.7115b8503f256p-1,   -0x1.8ce3bp-2, INEXACT)
T(RN,  0x1.72003e23bc4ddp+813,   -0x1.0d52595f3de2bp-3,  -0x1.71593ep-3, INEXACT)
T(RN,  0x1.b63ff0a4acc56p+813,    0x1.73477e1d09982p-4,  -0x1.ab67e4p-3, INEXACT)
T(RN,  0x1.2cb80fef2731dp+813,    0x1.f3027dd035675p-4,   0x1.3d0b32p-2, INEXACT)
T(RN,  0x1.68e62c3c46551p+813,    0x1.35f7e55ba142ap-6,   0x1.c8b586p-2, INEXACT)
T(RN,  0x1.0d82d62c8353bp+813,   -0x1.2f25e7c973062p-1,    0x1.c8c41p-3, INEXACT)
T(RN,  0x1.2fa30d93da291p+813,   -0x1.78672bdd9f0a9p-1,  -0x1.797266p-2, INEXACT)
T(RN,  0x1.030467194d866p+813,   -0x1.6548f6730e5cdp-1,  -0x1.41896cp-2, INEXACT)
T(RN,  0x1.1ebc00c41115bp+814,    0x1.d1674fa0ab59fp-1,  -0x1.896634p-4, INEXACT)
T(RN,   0x1.215a34c12727p+814,   -0x1.a221413d0e049p-1,   0x1.82046ep-6, INEXACT)
T(RN,  0x1.094cc076435d7p+814,   -0x1.e9dcd61c0f1dbp-4,   0x1.84741ep-2, INEXACT)
T(RN,  0x1.a8b1358fbe2eap+814,    0x1.dc60e9451d92ep-1,   0x1.f2879cp-2, INEXACT)
T(RN,  0x1.f006c11c100d4p+814,   -0x1.3377be42f1af8p-1,  -0x1.5e9652p-4, INEXACT)
T(RN,  0x1.feb79786dd60ap+814,   -0x1.4cbf3368a10fep-1,  -0x1.734e7cp-4, INEXACT)
T(RN,  0x1.a4d8793d1b872p+814,    0x1.86d55c0864701p-1,   0x1.1a6d04p-5, INEXACT)
T(RN,  0x1.5ac53cfd53cddp+814,   -0x1.e1d176dd7bd6ap-1,  -0x1.2b4c68p-6, INEXACT)
T(RN,  0x1.50935cc84f1f6p+814,   -0x1.330a9d8220f7cp-1,   0x1.e6f38cp-2, INEXACT)
T(RN,  0x1.e2b946c449f48p+814,   -0x1.9e9a8b59f3b87p-1,   -0x1.3f5b1p-2, INEXACT)
T(RN,  0x1.7ed1aa28c1a32p+815,    0x1.473a013dfa3ffp-1,  -0x1.898e3ep-2, INEXACT)
T(RN,  0x1.64396a84cdfe6p+815,   -0x1.b8706aa094cffp-3,  -0x1.471cfcp-2, INEXACT)
T(RN,  0x1.16299c14d96c3p+815,    0x1.fb051cd56be5ep-1,   -0x1.ebd5fp-2, INEXACT)
T(RN,  0x1.45982a284be0cp+815,    0x1.04ef308752dd8p-2,   0x1.d246d8p-2, INEXACT)
T(RN,  0x1.d16095c6c930ap+815,   -0x1.3f70a27966b52p-1,   0x1.c89e88p-2, INEXACT)
T(RN,  0x1.77101efbfdc42p+815,   -0x1.ff4eb84615a78p-1,   0x1.62b02cp-3, INEXACT)
T(RN,  0x1.1a4dbfc2a407dp+815,    0x1.dd21f541b718bp-1,   0x1.9633a6p-2, INEXACT)
T(RN,  0x1.3228d3dd4a462p+815,    -0x1.6f4ee92028cbp-2,   0x1.13e3cep-2, INEXACT)
T(RN,  0x1.a6de2b48f9ab2p+815,      0x1.e477be2451ep-4,   -0x1.86746p-3, INEXACT)
T(RN,  0x1.2486d7c898443p+815,    0x1.a575ded6c3b98p-1,  -0x1.9cb74ap-3, INEXACT)
T(RN,  0x1.79ef9a99eef3cp+816,   -0x1.768f9d035b801p-1,  -0x1.c951b2p-2, INEXACT)
T(RN,  0x1.c0b9869e551c7p+816,    0x1.ee8b30ab77e5cp-3,  -0x1.0c7342p-4, INEXACT)
T(RN,  0x1.ff3f8af6071f4p+816,   -0x1.2211162e9a6a3p-2,   0x1.e9b666p-2, INEXACT)
T(RN,  0x1.83e083509489ep+816,    0x1.664d5db540fb6p-1,   0x1.21b4a6p-2, INEXACT)
T(RN,  0x1.849c2edee52eep+816,   -0x1.fe6c2a1ae5c7fp-1,   0x1.a0bdbep-2, INEXACT)
T(RN,  0x1.a7b337ee42d38p+816,   -0x1.bfa565532d861p-1,   0x1.abb8dap-3, INEXACT)
T(RN,  0x1.ca166b854de25p+816,    0x1.fee40798cc608p-1,   -0x1.f8e41p-2, INEXACT)
T(RN,  0x1.cbf1491a2faffp+816,   -0x1.8fb5a45a17157p-4,   0x1.244e7ap-2, INEXACT)
T(RN,   0x1.99548f9e82d6p+816,    0x1.b9ad3b68180a6p-2,   0x1.68bc1ap-3, INEXACT)
T(RN,  0x1.383d850466847p+816,    0x1.6655c78a8e28fp-3,   0x1.86aaeap-5, INEXACT)
T(RN,  0x1.f0d8feeae2544p+817,    0x1.ffca2d4d4805bp-1,  -0x1.8cf9fap-6, INEXACT)
T(RN,  0x1.ebedc92cd03d8p+817,   -0x1.50187e9e6f075p-5,   -0x1.a8c19p-2, INEXACT)
T(RN,  0x1.efad88281a202p+817,   -0x1.f9b65c0787f78p-1,   -0x1.b8141p-2, INEXACT)
T(RN,  0x1.1c1675c369d6ap+817,    0x1.f5cf6d91073abp-1,  -0x1.a08accp-2, INEXACT)
T(RN,  0x1.576f88a91b698p+817,   -0x1.c2a3dc39a42d3p-1,   0x1.8d205ap-2, INEXACT)
T(RN,  0x1.5746365f2e02ep+817,   -0x1.59d5d487f2a4dp-1,   0x1.d06408p-3, INEXACT)
T(RN,  0x1.bdf13e47d518ap+817,     0x1.37d914779a6ap-3,   0x1.6c6988p-2, INEXACT)
T(RN,  0x1.4c3ebb09205fcp+817,   -0x1.b999ccb37e24ap-1,   0x1.1a6a96p-3, INEXACT)
T(RN,  0x1.85fd361a1b6f4p+817,   -0x1.bf92e6b2de544p-1,    0x1.46dcap-2, INEXACT)
T(RN,  0x1.34d2ccd43239dp+817,    0x1.d997dab117ebep-1,  -0x1.5f0a08p-3, INEXACT)
T(RN,  0x1.93a3540c64c52p+818,   -0x1.fb4ab9b957951p-1,  -0x1.02bc26p-6, INEXACT)
T(RN,  0x1.7117f316929a4p+818,   -0x1.4c6539f8bfb87p-1,  -0x1.1b3428p-2, INEXACT)
T(RN,  0x1.2112222296498p+818,   -0x1.dc3dc0efd9738p-1,    0x1.fa43bp-2, INEXACT)
T(RN,   0x1.8cb8fedca394p+818,    0x1.a449c256cf2aep-2,  -0x1.bf7a12p-3, INEXACT)
T(RN,  0x1.5aaf54ff5a044p+818,    0x1.4b397d154611ep-1,   0x1.06dc7cp-3, INEXACT)
T(RN,  0x1.b21e2a165626ep+818,   -0x1.9299d350840b9p-1,   0x1.360214p-2, INEXACT)
T(RN,  0x1.db57223218d02p+818,   -0x1.60da04eb2b51ap-1,  -0x1.ce058cp-5, INEXACT)
T(RN,  0x1.ad3cabdd233ebp+818,    0x1.60f591fceb66bp-1,   0x1.cf478ep-3, INEXACT)
T(RN,   0x1.5d280551c0e7p+818,   -0x1.d36f6e03ad9cap-1,   0x1.441bb8p-3, INEXACT)
T(RN,   0x1.fab930fb3c8ep+818,   -0x1.f085108d8e6fbp-1,  -0x1.da9112p-3, INEXACT)
T(RN,   0x1.665c276a80d8p+819,   -0x1.64e01450b6ca3p-2,  -0x1.ef8c14p-2, INEXACT)
T(RN,  0x1.52ed342d26cacp+819,    0x1.814a2888a4bf6p-1,   0x1.a80ea8p-8, INEXACT)
T(RN,  0x1.41d1df228943ep+819,    0x1.94b0bb79628dbp-2,  -0x1.fa2e3ap-8, INEXACT)
T(RN,  0x1.f7186a1623f2cp+819,    0x1.ffff20a89acb6p-1,  -0x1.d4e3acp-2, INEXACT)
T(RN,  0x1.2b89c230439bcp+819,   -0x1.d7c9ad310260ep-1,   0x1.a07d2ep-2, INEXACT)
T(RN,  0x1.de88223689429p+819,   -0x1.a59c857cab0bap-1,  -0x1.10da8cp-5, INEXACT)
T(RN,  0x1.3c6ae112a4376p+819,   -0x1.ff63261aea8e6p-1,   0x1.799c28p-2, INEXACT)
T(RN,  0x1.3adf9c8fcfb31p+819,    0x1.4be059749917bp-3,   0x1.852b42p-2, INEXACT)
T(RN,  0x1.d8275a2bf86e8p+819,    0x1.97b2afe016c1cp-2,   0x1.b9ea12p-2, INEXACT)
T(RN,  0x1.6e1cca7b737acp+819,    0x1.5fe0a56ffc80ep-2,  -0x1.6723f2p-2, INEXACT)
T(RN,   0x1.615264a98aefp+820,   -0x1.7728b956423edp-1,   0x1.ecd6c4p-2, INEXACT)
T(RN,  0x1.809765a2fb36cp+820,    -0x1.9b450ebf91ffp-3,    0x1.38095p-2, INEXACT)
T(RN,  0x1.c5e74d56cf754p+820,    0x1.3368e754cfccbp-2,    0x1.0b4c2p-2, INEXACT)
T(RN,  0x1.0e86129516389p+820,   -0x1.81065bdffed44p-1,  -0x1.862906p-2, INEXACT)
T(RN,  0x1.adfb1e9e4090ap+820,     -0x1.f6254ed1db5p-1,   0x1.b9f30ep-2, INEXACT)
T(RN,  0x1.36ae2115df36fp+820,    0x1.025b56782789ap-3,  -0x1.dcc5e6p-3, INEXACT)
T(RN,  0x1.7f75e4e05479cp+820,   -0x1.7cb832cb187bep-1,  -0x1.8abbccp-2, INEXACT)
T(RN,  0x1.841bf1b51ecddp+820,   -0x1.1c29b31b4d264p-2,   0x1.19a31ap-2, INEXACT)
T(RN,  0x1.c311288bfb68cp+820,    -0x1.b40427bc7f96p-1,  -0x1.7f60a2p-5, INEXACT)
T(RN,  0x1.cd48c4709ccf2p+820,    0x1.c3535b67d0df6p-1,  -0x1.26ce64p-2, INEXACT)
T(RN,  0x1.b3931b67e4d3bp+821,   -0x1.4d961a6648716p-3,   0x1.e18824p-2, INEXACT)
T(RN,  0x1.841c3d1dcfe6cp+821,   -0x1.0f9aca307ef7bp-2,  -0x1.98b8dcp-2, INEXACT)
T(RN,  0x1.d667eeced89cep+821,   -0x1.291f4b5f997d9p-1,    0x1.9ea67p-4, INEXACT)
T(RN,  0x1.aaefc8c8ceb9ap+821,    0x1.a0cf9e98642b4p-1,  -0x1.a0a1c4p-4, INEXACT)
T(RN,  0x1.50b8292b08b27p+821,    0x1.c544bd45ab9b2p-1,   0x1.14bce8p-2, INEXACT)
T(RN,  0x1.530ff646ca0c5p+821,   -0x1.2260690c5b1ddp-2,   0x1.6ac5a8p-3, INEXACT)
T(RN,  0x1.2c2c0fb37986dp+821,    0x1.952f7a6183dffp-1,  -0x1.853a8ap-3, INEXACT)
T(RN,  0x1.7feea0a665966p+821,   -0x1.f9f89cf62c817p-1,   0x1.c83dcep-2, INEXACT)
T(RN,  0x1.7be7d2d325591p+821,    0x1.fd429df5df6a3p-1,  -0x1.90bde2p-3, INEXACT)
T(RN,  0x1.15a07c9ad9646p+821,    0x1.d99e38f1d0842p-1,  -0x1.da8e9cp-4, INEXACT)
T(RN,  0x1.199da49a73c04p+822,    0x1.372350ce1f264p-1,   0x1.47c0cep-2, INEXACT)
T(RN,  0x1.06689b70ad10bp+822,    0x1.b84b651897f3ep-1,   0x1.d50decp-5, INEXACT)
T(RN,  0x1.d02125f8508eap+822,   -0x1.e83383bb7db66p-1,   0x1.2b7acep-3, INEXACT)
T(RN,  0x1.87b1fd8ebae8ep+822,    0x1.e9713ebcbd728p-5,  -0x1.42b45ap-2, INEXACT)
T(RN,  0x1.3d4f2978d809ep+822,   -0x1.81b618122b62cp-1,  -0x1.d2d234p-6, INEXACT)
T(RN,  0x1.c8b811200c61ep+822,    0x1.e78cb1900531ep-1,   -0x1.7f20fp-5, INEXACT)
T(RN,  0x1.ee7e0184f08fep+822,    0x1.ffd5c0650aadbp-1,   -0x1.6c0d7p-2, INEXACT)
T(RN,  0x1.417a590f7f4e7p+822,    0x1.2407253cdd2a5p-6,  -0x1.80fb56p-2, INEXACT)
T(RN,  0x1.83fe14f67f5e4p+822,    0x1.941b9c28762eep-2,  -0x1.5929cap-5, INEXACT)
T(RN,   0x1.1a3b2785794dp+822,    0x1.caa34a621eebcp-1,   0x1.34481cp-2, INEXACT)
T(RN,   0x1.6d27d71e710fp+823,   -0x1.c3565cae773c4p-1,   0x1.f29b02p-4, INEXACT)
T(RN,  0x1.8cf999a513e32p+823,   -0x1.82a2f1a190d99p-2,   0x1.ac2ebcp-7, INEXACT)
T(RN,  0x1.ecd4dbd9ae2cap+823,   -0x1.67a28240b8596p-1,  -0x1.43c2d2p-2, INEXACT)
T(RN,  0x1.34ca573533df9p+823,   -0x1.ffffc35d6d22ep-1,   0x1.31becap-2, INEXACT)
T(RN,  0x1.682ac58cf0364p+823,    0x1.0a75959939e2ap-3,   0x1.caf1f4p-4, INEXACT)
T(RN,   0x1.fc0a1d954f37p+823,   -0x1.f875439e43894p-1,   0x1.60784cp-2, INEXACT)
T(RN,  0x1.d1ff4e2a3b242p+823,    0x1.655b9ce92cf8ep-2,  -0x1.0909bep-2, INEXACT)
T(RN,  0x1.2d380a57db46cp+823,    0x1.aec243964d373p-1,  -0x1.d91686p-2, INEXACT)
T(RN,  0x1.3c69aa0649892p+823,    0x1.fd98c93b0f12cp-1,  -0x1.1fa1ccp-2, INEXACT)
T(RN,  0x1.eb0f55e11bad6p+823,    0x1.ea9eaf47bdcd2p-1,   -0x1.f911ap-2, INEXACT)
T(RN,   0x1.e0ca0cca1381p+824,   -0x1.855feedab36a7p-5,  -0x1.c3ebf4p-3, INEXACT)
T(RN,  0x1.78783e0d8ab87p+824,   -0x1.ff9ef61ff399ep-1,   0x1.1286e2p-2, INEXACT)
T(RN,  0x1.79268818229e4p+824,    0x1.f0d85da6b1821p-2,  -0x1.cd6b36p-2, INEXACT)
T(RN,  0x1.2d9ed28588944p+824,   -0x1.f66358d5bbf24p-2,   0x1.1a4feep-3, INEXACT)
T(RN,  0x1.996dcc65132f7p+824,   -0x1.fa266f1d3f646p-1,  -0x1.269878p-2, INEXACT)
T(RN,   0x1.b165f4cb2414p+824,   -0x1.df7562c30fa95p-3,  -0x1.35fe5ap-5, INEXACT)
T(RN,  0x1.9b94844811f92p+824,   -0x1.e5cb2f41f0a32p-2,   0x1.4694acp-6, INEXACT)
T(RN,  0x1.f387d30141059p+824,    0x1.f62171d8cb7f5p-1,  -0x1.185e1ap-2, INEXACT)
T(RN,  0x1.179755cf75ffdp+824,   -0x1.f89e15f2fa1b5p-1,   0x1.4b3e74p-9, INEXACT)
T(RN,  0x1.147438f10e67cp+824,    0x1.804b9320bf914p-1,   0x1.4bc9e6p-2, INEXACT)
T(RN,  0x1.152ec43004fffp+825,   -0x1.ea6bcd8f05b53p-1,   0x1.cf253ep-2, INEXACT)
T(RN,   0x1.ee4a59051a36p+825,   -0x1.b1fbe7d30d0ccp-1,   -0x1.f98e3p-3, INEXACT)
T(RN,   0x1.016cfe74d3ccp+825,   -0x1.e54c53ed90b06p-1,   -0x1.7b352p-2, INEXACT)
T(RN,   0x1.9ec9f1aec99ep+825,     0x1.cf9acce9049bp-4,   0x1.2eac2ep-2, INEXACT)
T(RN,  0x1.a56a920053358p+825,    0x1.ce2f254c7583dp-2,   -0x1.c58a4p-3, INEXACT)
T(RN,  0x1.d3fc6da26020cp+825,    0x1.9f43145865bfdp-1,  -0x1.df5552p-4, INEXACT)
T(RN,  0x1.c408d4f669607p+825,   -0x1.0a142afcc758bp-3,   0x1.0c31f4p-2, INEXACT)
T(RN,  0x1.546fea1e1526dp+825,   -0x1.de1dd8b21a9cfp-2,   0x1.f8dddep-2, INEXACT)
T(RN,  0x1.72a0651d1934fp+825,    0x1.4b2e8bc8203f2p-3,   0x1.3b92eap-4, INEXACT)
T(RN,  0x1.ca6b1074ae80fp+825,    0x1.42dbeca871811p-3,   -0x1.e1b28p-4, INEXACT)
T(RN,  0x1.8200b1f750c4ep+826,    0x1.3877de5ff9802p-2,   0x1.03b172p-3, INEXACT)
T(RN,  0x1.720dcbc585939p+826,   -0x1.92b207f54fcf2p-2,  -0x1.ef087ap-6, INEXACT)
T(RN,  0x1.303a53aeed2ecp+826,   -0x1.6e882be1c1275p-2,  -0x1.86406ap-7, INEXACT)
T(RN,  0x1.d02ab558f28fap+826,    0x1.c959d4243c258p-2,  -0x1.59e75ap-2, INEXACT)
T(RN,  0x1.fb6c83ed4908bp+826,   -0x1.0696b58a664d3p-4,  -0x1.ab675cp-2, INEXACT)
T(RN,  0x1.656b40080b8ecp+826,   -0x1.9a50bb6e8716ep-1,  -0x1.88d148p-3, INEXACT)
T(RN,  0x1.884e1209d3d75p+826,    0x1.fe2f738b90277p-1,   0x1.4e2a8ap-2, INEXACT)
T(RN,  0x1.4614ef0f0a24ep+826,   -0x1.18c9b56704ab8p-1,   0x1.cdb8fap-2, INEXACT)
T(RN,  0x1.d22af1c62115ap+826,   -0x1.1691b22d69ee5p-5,  -0x1.d19d42p-4, INEXACT)
T(RN,  0x1.5eb5df0393cd4p+826,    0x1.de1ab73a25ea1p-1,   0x1.8de85ep-3, INEXACT)
T(RN,  0x1.070cee3731b58p+827,   -0x1.56971abb769f6p-2,   0x1.56a206p-2, INEXACT)
T(RN,  0x1.f62f2a4db6c6cp+827,   -0x1.e5516387068fep-1,  -0x1.679792p-3, INEXACT)
T(RN,  0x1.578d86ca43e8cp+827,    0x1.a43c9361e789fp-1,   0x1.a88daep-5, INEXACT)
T(RN,  0x1.08b73e135f2c7p+827,   -0x1.ff73b0012935ep-1,  -0x1.5a219ap-3, INEXACT)
T(RN,  0x1.4f63585aaa4aap+827,    0x1.c9a2e837e31b9p-3,  -0x1.f74b4ep-2, INEXACT)
T(RN,   0x1.e7dab1ad9066p+827,    0x1.9d790a57f0961p-3,   0x1.7b7b02p-2, INEXACT)
T(RN,  0x1.628bc709fce55p+827,    0x1.84972110ddbb4p-1,   0x1.384e6ep-3, INEXACT)
T(RN,  0x1.e2835f65abdabp+827,   -0x1.9e6cc760bdae8p-1,  -0x1.cfec08p-3, INEXACT)
T(RN,  0x1.ab4b80e8ba3eap+827,    0x1.37f6e35a12acbp-3,   0x1.f4a2fcp-3, INEXACT)
T(RN,  0x1.d74fa4908f034p+827,    0x1.24053e04be647p-1,  -0x1.950918p-4, INEXACT)
T(RN,  0x1.19df4565657b6p+828,    0x1.8d8a2e49fd319p-1,  -0x1.5a19fep-4, INEXACT)
T(RN,  0x1.dbbfb0c9d6ae7p+828,    0x1.191a2a79ec6e8p-3,   0x1.e374d6p-4, INEXACT)
T(RN,  0x1.7ed5663ad0345p+828,    0x1.6f659e59b9afep-2,   0x1.f3966cp-3, INEXACT)
T(RN,  0x1.5974ea987d442p+828,    0x1.cc2ac23e117c2p-1,   0x1.7a563cp-2, INEXACT)
T(RN,  0x1.0c7c5306bc23dp+828,   -0x1.4d79291b1f453p-1,  -0x1.d36c18p-3, INEXACT)
T(RN,  0x1.da1b57a2af14dp+828,   -0x1.fffa7e14a630ep-1,   0x1.a60b1cp-2, INEXACT)
T(RN,  0x1.ad3f93f47e822p+828,   -0x1.6c5c57983255bp-2,   0x1.c7ee8cp-4, INEXACT)
T(RN,   0x1.1c069553b8b1p+828,    0x1.c2e1687d5035bp-1,   -0x1.223fbp-2, INEXACT)
T(RN,  0x1.44ead96cc40b2p+828,    0x1.ff8f0c6f85099p-2,  -0x1.61455ep-3, INEXACT)
T(RN,  0x1.5ce33b9a4c07cp+828,    0x1.dcccc2adb92f7p-1,  -0x1.38fcd8p-6, INEXACT)
T(RN,  0x1.55e3217307b09p+829,    0x1.7db5ee3240191p-5,  -0x1.9eb44cp-5, INEXACT)
T(RN,  0x1.aa00ce00bd1d6p+829,    0x1.b4cb90fdc4e2bp-1,  -0x1.0a8d38p-2, INEXACT)
T(RN,   0x1.0478cda6f2a5p+829,   -0x1.deda0e744d16cp-1,   0x1.ec922ap-3, INEXACT)
T(RN,  0x1.a3df9cfc01e8cp+829,   -0x1.fa16a7001b26bp-1,   0x1.4607a8p-5, INEXACT)
T(RN,  0x1.85b260b08c6aap+829,    -0x1.bb4cd4a6bb5dp-1,   0x1.9c5a16p-2, INEXACT)
T(RN,  0x1.02fc6e46d594dp+829,    0x1.dee9d2baaaaa1p-2,  -0x1.7ca556p-2, INEXACT)
T(RN,  0x1.1344c9d0dcc9bp+829,    0x1.83ff1ea21a488p-2,  -0x1.556a34p-2, INEXACT)
T(RN,  0x1.409a3ee0581e2p+829,   -0x1.64510e0fe5e42p-1,   0x1.4e2e38p-2, INEXACT)
T(RN,  0x1.08a6fb1e00826p+829,     0x1.933b5d166db6p-4,   0x1.d4580ap-3, INEXACT)
T(RN,  0x1.239a72db7d7e6p+829,    0x1.4f1c143fab6d9p-1,   0x1.0b0f54p-3, INEXACT)
T(RN,  0x1.d76c999958bd5p+830,   -0x1.a5b9c570062e1p-1,  -0x1.51354cp-3, INEXACT)
T(RN,  0x1.8748f38a67316p+830,    0x1.e6f8aa6d04c2fp-1,   0x1.09d278p-2, INEXACT)
T(RN,    0x1.4c0f593943dp+830,   -0x1.f7fcff541f7bep-1,   -0x1.369c5p-2, INEXACT)
T(RN,  0x1.5eb7e15103c69p+830,    0x1.3c6d22769b042p-1,    0x1.7a848p-2, INEXACT)
T(RN,  0x1.8af218298a811p+830,   -0x1.1d5a6f7f375e5p-4,   0x1.585472p-2, INEXACT)
T(RN,  0x1.ac3994baedb98p+830,   -0x1.1dcf93b9359ecp-1,  -0x1.a90c4cp-2, INEXACT)
T(RN,  0x1.e853e84a3df02p+830,   -0x1.ecba8629614a2p-1,   0x1.bd098cp-2, INEXACT)
T(RN,  0x1.79d847dfdef6ep+830,    0x1.113ad58614f4ep-1,   0x1.4ce00ap-3, INEXACT)
T(RN,  0x1.c53df196d705cp+830,   -0x1.5622fd365eaf6p-1,   0x1.2d99fep-2, INEXACT)
T(RN,  0x1.9dd167ec11876p+830,   -0x1.54adb5a811a71p-1,  -0x1.ff2db6p-2, INEXACT)
T(RN,  0x1.e57f9ce8a51b2p+831,   -0x1.1c2229ff72debp-3,   0x1.0e3798p-6, INEXACT)
T(RN,  0x1.b20ec00373b32p+831,     0x1.9f179d661d95p-4,  -0x1.36c8dep-2, INEXACT)
T(RN,  0x1.e72d39fbbe23ap+831,    0x1.2eb05b6e77932p-3,   0x1.c5e336p-2, INEXACT)
T(RN,  0x1.e4053eb404bcap+831,    0x1.fcfa17922857dp-1,  -0x1.c46382p-4, INEXACT)
T(RN,  0x1.a50ebadfc3df4p+831,   -0x1.90ab2a3943a65p-1,  -0x1.e294acp-7, INEXACT)
T(RN,  0x1.45718f39dd0f6p+831,   -0x1.8159914c562b2p-1,  -0x1.53fe06p-2, INEXACT)
T(RN,  0x1.ea6ab01c3b1e2p+831,    0x1.c9ad283d84fbdp-1,  -0x1.05baeap-2, INEXACT)
T(RN,  0x1.a5734f302dd1ep+831,    0x1.fa0f1c3d8303ep-1,   0x1.5d4e24p-4, INEXACT)
T(RN,  0x1.11daae279fbb8p+831,   -0x1.c95fcd2354012p-4,   0x1.679a62p-2, INEXACT)
T(RN,  0x1.5f47f14714786p+831,   -0x1.4d3f84135861ep-1,   0x1.8160e8p-2, INEXACT)
T(RN,  0x1.7e9974140db1ap+832,    0x1.6793a078d002ap-1,   0x1.1eec7ep-4, INEXACT)
T(RN,  0x1.f92a725774e44p+832,   -0x1.f3188faa1ff8cp-2,  -0x1.e2560ep-3, INEXACT)
T(RN,  0x1.1f5cdbcb87d36p+832,   -0x1.1546f5c36165cp-1,  -0x1.0b7aecp-3, INEXACT)
T(RN,  0x1.63b25e537f38dp+832,   -0x1.c3c5a7ddd28d4p-1,   0x1.aaa68ep-2, INEXACT)
T(RN,  0x1.726f1ff47103ep+832,   -0x1.cf50fe2131192p-1,  -0x1.613f96p-2, INEXACT)
T(RN,  0x1.2730e10ac938fp+832,   -0x1.d3acd3e628e3fp-1,   0x1.1b147ap-2, INEXACT)
T(RN,   0x1.6ae28203447bp+832,    0x1.8eebded62299cp-1,  -0x1.63f984p-5, INEXACT)
T(RN,  0x1.709a135e3c9d9p+832,     0x1.4b6afa8a1bf4p-1,   0x1.0c956cp-4, INEXACT)
T(RN,   0x1.d7b4d54a1c58p+832,    0x1.5d69817642aa4p-1,  -0x1.f29f88p-2, INEXACT)
T(RN,  0x1.0e651ee529b31p+832,    0x1.64c9b060239d2p-1,   0x1.3b9d7ap-2, INEXACT)
T(RN,  0x1.3a42a702967e1p+833,   -0x1.ed0fcfa01e2fdp-1,  -0x1.8d3742p-2, INEXACT)
T(RN,  0x1.95a92790cb01ap+833,    0x1.fe1a2e32751f6p-5,  -0x1.78e468p-2, INEXACT)
T(RN,  0x1.436efe10dc549p+833,   -0x1.ffffa13e35861p-1,   0x1.6bc036p-5, INEXACT)
T(RN,  0x1.ee185e206b0adp+833,    0x1.9807c42d5b27bp-2,  -0x1.90d44ap-2, INEXACT)
T(RN,  0x1.2f8c49038d914p+833,   -0x1.cdc1aaf8a1dc8p-1,    0x1.8f9bep-2, INEXACT)
T(RN,  0x1.2bfe29ecf0da8p+833,   -0x1.54aa8fec8ef66p-1,  -0x1.536f2cp-5, INEXACT)
T(RN,  0x1.ba1f943fc76e2p+833,   -0x1.ea1b52c4ff482p-1,  -0x1.d8f2bep-2, INEXACT)
T(RN,  0x1.874a4fff1dc18p+833,    0x1.9a1138009b0dfp-7,  -0x1.34de2cp-2, INEXACT)
T(RN,  0x1.a56c4bb6f26a9p+833,   -0x1.7282828928661p-1,  -0x1.d9b9cep-7, INEXACT)
T(RN,  0x1.454f2cca076ddp+833,    0x1.9ed1f7a646524p-3,   0x1.676c66p-6, INEXACT)
T(RN,  0x1.18a43f1f5f4b6p+834,    0x1.fff55745c848fp-1,   0x1.5a01ccp-2, INEXACT)
T(RN,  0x1.0e2481a0d5497p+834,   -0x1.7ac97c60c3affp-2,   0x1.63b8f8p-2, INEXACT)
T(RN,  0x1.a76ed1d26f471p+834,    0x1.f037ff4c37b23p-2,   0x1.8f940ep-2, INEXACT)
T(RN,  0x1.3ecbda79605ebp+834,    0x1.91dc33a66d1f3p-2,   0x1.02eb58p-3, INEXACT)
T(RN,  0x1.6e4d19c6e4ebcp+834,   -0x1.bf3a9f643e2e7p-2,   0x1.b0bd02p-2, INEXACT)
T(RN,  0x1.c57f05ddf2d93p+834,    0x1.3ffe9e91ae09ap-1,  -0x1.8a9142p-2, INEXACT)
T(RN,  0x1.4f2a948e2df3fp+834,    0x1.f983d1afc03e3p-1,   0x1.33ee56p-3, INEXACT)
T(RN,  0x1.587ed7541c3bdp+834,   -0x1.fcde30f0c420ep-1,   0x1.aa2e68p-2, INEXACT)
T(RN,  0x1.ee42be747faeep+834,   -0x1.6006f33a4c328p-2,   -0x1.ebb38p-3, INEXACT)
T(RN,  0x1.0e21fdb11534ep+834,   -0x1.394351b69716bp-2,   0x1.3168b6p-3, INEXACT)
T(RN,  0x1.024ae0a6e5f31p+835,    -0x1.4a48ce7daddfp-2,   -0x1.75e2fp-3, INEXACT)
T(RN,  0x1.887743173683bp+835,   -0x1.ec15edf95a085p-1,  -0x1.c79b6ap-9, INEXACT)
T(RN,  0x1.d6d89ed54656fp+835,    0x1.adff54e524f41p-5,   0x1.f15a08p-4, INEXACT)
T(RN,  0x1.9269e234a0812p+835,   -0x1.b02a879b18cecp-1,  -0x1.bafa36p-2, INEXACT)
T(RN,  0x1.0b34969778c54p+835,    -0x1.4bd69caa72b7p-7,  -0x1.05e16ep-4, INEXACT)
T(RN,  0x1.c9c7f0a4b26bcp+835,   -0x1.caa65da011162p-1,  -0x1.6da9e4p-3, INEXACT)
T(RN,  0x1.aaab852178382p+835,   -0x1.04c1b035ba287p-5,   -0x1.2c9eap-7, INEXACT)
T(RN,  0x1.ce386b432243bp+835,   -0x1.91283a319e2ecp-2,  -0x1.4dd8dap-4, INEXACT)
T(RN,  0x1.2bfc93c0c27ebp+835,    0x1.3ad7f0edaeccdp-3,  -0x1.331328p-3, INEXACT)
T(RN,  0x1.51f565a837d58p+835,    0x1.a6ea81ed26c88p-1,   0x1.7b9bf4p-3, INEXACT)
T(RN,  0x1.b1ebbf6a8e55ep+836,   -0x1.f765d0238071fp-1,   0x1.4f20dap-5, INEXACT)
T(RN,  0x1.eccbf49dabca4p+836,    0x1.5f57ebc1151d3p-1,   -0x1.209bep-2, INEXACT)
T(RN,  0x1.ec2392a8bdfaap+836,    0x1.85169b04a0d67p-1,  -0x1.bdb172p-2, INEXACT)
T(RN,   0x1.bb89a3bf8d13p+836,   -0x1.44e67cbb59d19p-1,  -0x1.5b056cp-2, INEXACT)
T(RN,  0x1.657e2739bf8eap+836,    0x1.adfd0ca4d648bp-1,   0x1.b0f47cp-3, INEXACT)
T(RN,  0x1.618ea728c7195p+836,   -0x1.e95fd6c3f436ep-2,  -0x1.080aeep-2, INEXACT)
T(RN,  0x1.f57183e5a277dp+836,   -0x1.647ebb9079d2bp-3,   0x1.712b22p-2, INEXACT)
T(RN,  0x1.b26f5464c93d5p+836,   -0x1.258a9750f38fcp-2,   0x1.998276p-4, INEXACT)
T(RN,  0x1.acf3752b629d2p+836,    0x1.0ec970fc4a684p-6,   0x1.a364c2p-5, INEXACT)
T(RN,  0x1.95acdc132e7dfp+836,   -0x1.8f6416eea29bap-1,   0x1.f041c6p-2, INEXACT)
T(RN,  0x1.36ba14fba2219p+837,   -0x1.8290e63a1348fp-1,   -0x1.9a3d2p-2, INEXACT)
T(RN,  0x1.9051060bfde8bp+837,   -0x1.f7813622fb42bp-1,  -0x1.965a76p-2, INEXACT)
T(RN,  0x1.57091027ef4f1p+837,    0x1.6a39b1180585dp-1,   0x1.9335c6p-2, INEXACT)
T(RN,  0x1.0eb0da56a149ap+837,   -0x1.c13ecdf0fdb98p-1,   0x1.71f3acp-2, INEXACT)
T(RN,   0x1.a71716c5b846p+837,   -0x1.8f75aa0f968d1p-4,   0x1.7909bap-4, INEXACT)
T(RN,  0x1.be1056f0988f4p+837,    0x1.94d99c4b3a8ebp-1,    0x1.289a7p-3, INEXACT)
T(RN,  0x1.46247f8c3d298p+837,   -0x1.61374e6d687a8p-1,   0x1.32ac54p-3, INEXACT)
T(RN,  0x1.d02ee7cbcfa5cp+837,    0x1.d4ab02a2b8cdfp-1,  -0x1.2a4166p-2, INEXACT)
T(RN,  0x1.0f0f0c30bf8b8p+837,   -0x1.bc5c358bc1533p-6,   0x1.a2184ap-2, INEXACT)
T(RN,    0x1.d03f7c1d9c9p+837,   -0x1.da0961279075bp-1,  -0x1.136d3cp-2, INEXACT)
T(RN,  0x1.4fb57cfa22204p+838,   -0x1.60ed83fa0fb0cp-1,  -0x1.aded72p-2, INEXACT)
T(RN,   0x1.f9a8e1b57d9bp+838,   -0x1.0eec681709ddap-2,   0x1.ccb07cp-2, INEXACT)
T(RN,  0x1.8d85b5838b2ecp+838,   -0x1.41f838db23b1cp-1,   0x1.92c7dcp-4, INEXACT)
T(RN,  0x1.dce2c3d2d78dbp+838,    0x1.69b4b4a3e080ap-2,  -0x1.39a46ep-4, INEXACT)
T(RN,   0x1.27d6453d4f1fp+838,    0x1.fbec7fa3b0923p-1,   0x1.31c1bep-2, INEXACT)
T(RN,  0x1.d70f501f08bc2p+838,   -0x1.9d330ee483a0bp-3,  -0x1.8310dap-6, INEXACT)
T(RN,  0x1.99b8781077024p+838,    0x1.4bbd62e7567eep-1,  -0x1.af7694p-2, INEXACT)
T(RN,  0x1.d887cf52acb2dp+838,    0x1.ff12473a8dd1dp-1,  -0x1.5a467cp-4, INEXACT)
T(RN,  0x1.2be0c37920e6ep+838,   -0x1.76a8f9eba4aa8p-1,  -0x1.26982cp-7, INEXACT)
T(RN,  0x1.2f9fbcb517a5cp+838,   -0x1.efb25eba73277p-1,   0x1.60270ap-2, INEXACT)
T(RN,  0x1.2946dbcbc5761p+839,    0x1.de1ba33c09643p-1,  -0x1.0b667cp-2, INEXACT)
T(RN,  0x1.61e671fecccf5p+839,    0x1.aaa4ae6345d9cp-1,  -0x1.ea697ap-2, INEXACT)
T(RN,  0x1.7a3970bcb0eddp+839,   -0x1.340a67c89adc5p-1,   0x1.778b78p-2, INEXACT)
T(RN,  0x1.b11863ec44886p+839,    0x1.6c479069028f4p-1,   0x1.e8c5f6p-2, INEXACT)
T(RN,  0x1.b651d827984a9p+839,    0x1.7e083df7ee065p-1,   0x1.d4bba2p-8, INEXACT)
T(RN,  0x1.c45b3e88dadb9p+839,    0x1.f3df3aa265c9ep-1,  -0x1.5dc634p-2, INEXACT)
T(RN,  0x1.77ecc609e334dp+839,   -0x1.7d9263bc90591p-4,  -0x1.bbdcfcp-4, INEXACT)
T(RN,  0x1.b31e129e484ecp+839,   -0x1.b6371c5a5ccddp-1,    0x1.1a889p-2, INEXACT)
T(RN,  0x1.7f3772e3a3d42p+839,   -0x1.fea7c81009616p-1,  -0x1.8491f2p-4, INEXACT)
T(RN,  0x1.7fbac36edf4bdp+839,   -0x1.0f45861148a5ap-2,  -0x1.98c5c8p-2, INEXACT)
T(RN,  0x1.2e5570b896a54p+840,   -0x1.7bf96fe8b1103p-1,  -0x1.5ab22cp-4, INEXACT)
T(RN,   0x1.70c9b86b2609p+840,    0x1.d02c58e25d0d7p-1,   0x1.f02bfcp-2, INEXACT)
T(RN,  0x1.1043c1c3b28dcp+840,    0x1.fff26b8ebb405p-1,   0x1.7fbc6ap-3, INEXACT)
T(RN,  0x1.ff3353fd35814p+840,   -0x1.e91752d76f7a6p-1,  -0x1.1aeb22p-8, INEXACT)
T(RN,  0x1.61d1c9fac96edp+840,   -0x1.815816d91443ep-4,  -0x1.5dae2ep-2, INEXACT)
T(RN,  0x1.2ddeac4470d9ap+840,   -0x1.69dbc8ac30625p-2,  -0x1.3891cap-4, INEXACT)
T(RN,  0x1.fa11fa7d2b857p+840,   -0x1.32a57d58485c2p-2,   0x1.c641fap-3, INEXACT)
T(RN,  0x1.828ec119e0e8ep+840,    0x1.24b9d206d6714p-2,   0x1.7d3174p-3, INEXACT)
T(RN,  0x1.e225af79da5ecp+840,    0x1.d820799ca4d25p-2,   0x1.f18a8cp-4, INEXACT)
T(RN,  0x1.a3755f832b286p+840,    0x1.943cfb4160b08p-1,  -0x1.7a0272p-6, INEXACT)
T(RN,  0x1.45996a2a41effp+841,   -0x1.7c89db9f0bccap-1,   0x1.35b376p-2, INEXACT)
T(RN,  0x1.237d11217877dp+841,    0x1.ae81e4ca5db88p-1,  -0x1.2d0aa6p-3, INEXACT)
T(RN,  0x1.4e2303c83ae07p+841,   -0x1.43ab471b61f9ep-1,  -0x1.41ab74p-2, INEXACT)
T(RN,  0x1.bdd192c1830c7p+841,    0x1.80d85056f0d1bp-2,  -0x1.c8d694p-4, INEXACT)
T(RN,  0x1.2caee6ca0909ep+841,   -0x1.5a40613e2c38fp-4,   0x1.8c2892p-3, INEXACT)
T(RN,  0x1.0f63732ad800fp+841,    0x1.0c794c0adba86p-2,  -0x1.adbe06p-7, INEXACT)
T(RN,  0x1.766b32a635b81p+841,    0x1.c15241a1259bcp-1,  -0x1.7ec756p-2, INEXACT)
T(RN,  0x1.ccd2f441bfa8fp+841,    0x1.67003ebcee1b9p-1,   0x1.636e18p-2, INEXACT)
T(RN,  0x1.7b8b88b7a154ep+841,    0x1.7f91de0ca2178p-2,   0x1.329f46p-2, INEXACT)
T(RN,   0x1.698da9c33997p+841,   -0x1.fbeab55f99d96p-1,   0x1.a741e6p-2, INEXACT)
T(RN,  0x1.0387d4b94263ep+842,    0x1.e1928eb3f9c8bp-2,   0x1.687d52p-5, INEXACT)
T(RN,  0x1.d4c0af0c4514dp+842,   -0x1.f6a57b8e157b9p-1,  -0x1.d652c2p-3, INEXACT)
T(RN,    0x1.1ae810b78bfp+842,   -0x1.126eb471a9899p-1,   0x1.cc485cp-2, INEXACT)
T(RN,  0x1.c717bfdd9fcc2p+842,    -0x1.29e2e7b1963fp-4,   0x1.2ede64p-4, INEXACT)
T(RN,  0x1.25a0de233b4f7p+842,    0x1.69a7c21f941b3p-1,  -0x1.e8286ap-5, INEXACT)
T(RN,   0x1.d0af3e3e7a0fp+842,    0x1.ff8f0a969a17bp-3,  -0x1.5295b4p-2, INEXACT)
T(RN,  0x1.fa21e16c93ae2p+842,   -0x1.b6ce2e64aabbep-1,   0x1.fdac78p-2, INEXACT)
T(RN,  0x1.96be1b1e689e1p+842,   -0x1.6e22cb4a87591p-2,   0x1.fe424ep-2, INEXACT)
T(RN,  0x1.4d0e14fc67d74p+842,    0x1.f498e8ed90f09p-1,   0x1.9c53ecp-4, INEXACT)
T(RN,  0x1.b56acab07fd81p+842,    0x1.6ea477d9438e2p-2,   0x1.62e578p-2, INEXACT)
T(RN,   0x1.809fb74d8d5ep+843,    0x1.d43cfdb158acdp-4,  -0x1.5ea202p-4, INEXACT)
T(RN,  0x1.e82757eabb0b4p+843,    0x1.751ca95d724e8p-3,   0x1.b36862p-3, INEXACT)
T(RN,   0x1.0ba254bef911p+843,    0x1.b24dad119b4e6p-1,  -0x1.63ca3cp-2, INEXACT)
T(RN,  0x1.efe16cc14d842p+843,   -0x1.89acd2d44f275p-1,  -0x1.30aecap-3, INEXACT)
T(RN,  0x1.6b8d7589594a9p+843,    0x1.9e8f6956befbdp-1,  -0x1.b8e4c8p-6, INEXACT)
T(RN,  0x1.49e20d782432ep+843,   -0x1.b5d3405c6180bp-4,  -0x1.e1f048p-6, INEXACT)
T(RN,  0x1.6ca9b1ab2a32ap+843,   -0x1.e56a0933d5a78p-1,  -0x1.5ea2b4p-2, INEXACT)
T(RN,  0x1.31c59349f8ca8p+843,   -0x1.f660d4bf49b48p-1,  -0x1.d20512p-2, INEXACT)
T(RN,  0x1.31a0ea85af302p+843,   -0x1.07e70719b3f28p-1,  -0x1.d0758ap-5, INEXACT)
T(RN,  0x1.ca6cb1cc5f6a4p+843,   -0x1.dff5f80290ff5p-1,  -0x1.6ee4cep-2, INEXACT)
T(RN,  0x1.ed083616f3729p+844,    0x1.9f7f9a0e068fcp-2,  -0x1.eb28f8p-4, INEXACT)
T(RN,  0x1.60c5bd8d2f6f2p+844,    0x1.f2769293dbb65p-1,  -0x1.9fbf72p-3, INEXACT)
T(RN,   0x1.6cd3f158ad88p+844,   -0x1.27efb21dda39cp-3,   0x1.9e9604p-2, INEXACT)
T(RN,  0x1.07fbb069becdbp+844,    0x1.abc3f46014814p-1,  -0x1.3550c4p-7, INEXACT)
T(RN,  0x1.33f6e03c1eb05p+844,   -0x1.fdc00cdf44bf6p-1,  -0x1.48f0d4p-2, INEXACT)
T(RN,  0x1.2aa48e5864029p+844,    0x1.2d7c10f72907bp-3,  -0x1.bdb694p-2, INEXACT)
T(RN,  0x1.144e39e1c9062p+844,   -0x1.ffb2b1334a9efp-1,   0x1.47783ep-4, INEXACT)
T(RN,  0x1.5632369ede4f6p+844,   -0x1.70ed5833a6d6bp-1,   -0x1.8642fp-2, INEXACT)
T(RN,  0x1.f2d853124175cp+844,    0x1.b2c9596207892p-1,  -0x1.45b9acp-3, INEXACT)
T(RN,  0x1.13a5e51047a88p+844,    0x1.7c0af0ac710f9p-1,  -0x1.c6f8a8p-2, INEXACT)
T(RN,  0x1.28f6d85a62d25p+845,   -0x1.cf67422546718p-1,  -0x1.34501ap-5, INEXACT)
T(RN,  0x1.dbe89a685b9aep+845,   -0x1.9e84727701122p-6,   0x1.f5f80ap-2, INEXACT)
T(RN,  0x1.fd475660a7d8ap+845,   -0x1.d892284ee52eep-1,  -0x1.96b63ep-5, INEXACT)
T(RN,  0x1.2ff3c16d7f9b3p+845,    0x1.a1bdc6acb00a1p-2,  -0x1.7f21a8p-5, INEXACT)
T(RN,  0x1.b6349110681f1p+845,   -0x1.5edfaaad11769p-6,   0x1.dfbc3ap-3, INEXACT)
T(RN,  0x1.41e660fc3944fp+845,     -0x1.7446660d0ecp-4,   0x1.d20f22p-4, INEXACT)
T(RN,  0x1.39b4c46012945p+845,   -0x1.ce45276a9dfbep-1,   0x1.cff9d6p-2, INEXACT)
T(RN,  0x1.30face7f39d2bp+845,    0x1.fa0bc4a219898p-1,  -0x1.c6fbbcp-3, INEXACT)
T(RN,  0x1.2f1b28a20daf5p+845,    0x1.be24508cc5c0fp-1,   0x1.b0c968p-2, INEXACT)
T(RN,  0x1.27b3a57c2a22bp+845,    0x1.314d50f1a200dp-1,   -0x1.40104p-5, INEXACT)
T(RN,  0x1.f583ff58108ddp+846,   -0x1.c9cfe9b3c15c6p-1,  -0x1.38ce3ep-5, INEXACT)
T(RN,  0x1.700e0efcbd879p+846,    0x1.686eaea91b8c1p-1,   0x1.8dcec8p-2, INEXACT)
T(RN,  0x1.edacfadc77d32p+846,   -0x1.c1a89b97015ebp-1,  -0x1.1dad9ep-3, INEXACT)
T(RN,  0x1.a40fde2a11dedp+846,   -0x1.06a3cb12a4c3ap-6,    0x1.ad9cdp-2, INEXACT)
T(RN,  0x1.e64056fa2b584p+846,    0x1.0f5e9d80dfa1ap-1,  -0x1.2d6d14p-2, INEXACT)
T(RN,  0x1.2138067907c72p+846,    0x1.0f26192c078efp-1,  -0x1.9b4164p-6, INEXACT)
T(RN,  0x1.44db300ea86e7p+846,    0x1.864466251885dp-4,   0x1.7d16bep-2, INEXACT)
T(RN,  0x1.587defce446b5p+846,     0x1.ba403f0933f3p-1,   0x1.9d0b6ap-2, INEXACT)
T(RN,  0x1.b2e2ba58c59a8p+846,    0x1.843946352c75fp-2,   0x1.d40eb2p-2, INEXACT)
T(RN,  0x1.466ec85ff7109p+846,    0x1.bc361ad827cf2p-3,  -0x1.efd14cp-2, INEXACT)
T(RN,  0x1.ddf7857ea5614p+847,   -0x1.e253c649e1b7fp-2,  -0x1.88578cp-3, INEXACT)
T(RN,  0x1.24aa7c184efd8p+847,    0x1.7175791c086dep-1,  -0x1.db08e8p-3, INEXACT)
T(RN,  0x1.9e4d1762fba1ap+847,    0x1.96b6da3b9a358p-2,   0x1.54ad14p-3, INEXACT)
T(RN,  0x1.9f239815f2554p+847,    0x1.dccc8b5879201p-1,  -0x1.1cb8c6p-2, INEXACT)
T(RN,   0x1.a4289468891ep+847,   -0x1.85d2e2fe8c9c8p-1,  -0x1.1c621ep-2, INEXACT)
T(RN,  0x1.3cf3b0322aadfp+847,   -0x1.5a57a1daeb875p-1,   0x1.54d72ep-2, INEXACT)
T(RN,  0x1.523ebe3a7bffep+847,   -0x1.003b709cf83e1p-4,    0x1.4e6bep-2, INEXACT)
T(RN,  0x1.82170384a9086p+847,   -0x1.cdaf5fcbdefc9p-1,   0x1.e368eep-3, INEXACT)
T(RN,  0x1.2b9541fb1e7a5p+847,    0x1.4179d88d1e24ep-1,   0x1.8050ccp-3, INEXACT)
T(RN,  0x1.d19cb0e9bf67ap+847,   -0x1.58a00f0b8af75p-2,  -0x1.92832ep-2, INEXACT)
T(RN,  0x1.e1d2224a33f28p+848,    0x1.41f5472213d95p-1,  -0x1.7e02bep-3, INEXACT)
T(RN,  0x1.352f5d989cad4p+848,   -0x1.e7cbb6331da9dp-4,   0x1.d94018p-3, INEXACT)
T(RN,  0x1.51d5219497111p+848,    0x1.95f42c853f8d9p-1,  -0x1.f02bfap-2, INEXACT)
T(RN,   0x1.6b3c86005228p+848,    0x1.a886235ca27c7p-2,  -0x1.ed5116p-3, INEXACT)
T(RN,   0x1.875831b136edp+848,    0x1.e5e1016707e14p-1,   -0x1.3a394p-3, INEXACT)
T(RN,  0x1.34f5a9aea905ap+848,    0x1.9af7098ad3114p-2,   0x1.a96bfep-4, INEXACT)
T(RN,   0x1.84d9ee1d6d41p+848,    0x1.3c28e98fdae08p-4,   0x1.03725ep-4, INEXACT)
T(RN,  0x1.7e3d83da98383p+848,    0x1.14119f292c82ap-1,   0x1.8cba7ap-2, INEXACT)
T(RN,  0x1.642fe241dc127p+848,   -0x1.80e65081d0331p-1,  -0x1.8d3a26p-3, INEXACT)
T(RN,  0x1.a43709302e6a4p+848,    0x1.3fbc5e5be109ep-1,   -0x1.df361p-2, INEXACT)
T(RN,  0x1.f22a3f33492f7p+849,   -0x1.914d9eb92308cp-2,  -0x1.499a82p-2, INEXACT)
T(RN,  0x1.6d12049f85d9dp+849,    0x1.e3052a7cd93dep-1,    0x1.bc95fp-2, INEXACT)
T(RN,  0x1.f407af8944a75p+849,   -0x1.cdaa9dda8576bp-1,   0x1.853f56p-2, INEXACT)
T(RN,  0x1.e3660e9fd3012p+849,    0x1.2011fd8ea79cbp-1,  -0x1.f8c66cp-2, INEXACT)
T(RN,  0x1.d034da8502408p+849,    0x1.b181a34e9a147p-1,  -0x1.1e89fcp-3, INEXACT)
T(RN,  0x1.959ca3735bc44p+849,   -0x1.86cd274760da2p-1,   0x1.242ca6p-2, INEXACT)
T(RN,  0x1.0d97a5d2c9959p+849,    0x1.f380658ba1038p-1,   0x1.981b64p-2, INEXACT)
T(RN,  0x1.8627dfe0f7312p+849,    0x1.518b4e3f3e2dbp-1,   0x1.762284p-2, INEXACT)
T(RN,  0x1.263e8ff03254ep+849,   -0x1.e99efb2e11ec7p-1,   -0x1.f5a47p-3, INEXACT)
T(RN,  0x1.437fa839b3f6fp+849,    0x1.ab383547c0c0ap-1,   0x1.fd73acp-2, INEXACT)
T(RN,  0x1.3463e283dcf5cp+850,    0x1.731b4c880d848p-3,   0x1.8fe018p-3, INEXACT)
T(RN,  0x1.208fab39ce9c4p+850,   -0x1.e50dc8c7bf58ap-1,  -0x1.4b246ep-2, INEXACT)
T(RN,  0x1.15f9c48c26f91p+850,   -0x1.fd8d49131b9d6p-1,   0x1.e0e8bcp-4, INEXACT)
T(RN,  0x1.00221b7cf2714p+850,   -0x1.455858ee9a0bap-1,  -0x1.b43e9ap-3, INEXACT)
T(RN,  0x1.bf947cdb62418p+850,    0x1.397eb4cbad14cp-1,   0x1.1e8978p-5, INEXACT)
T(RN,  0x1.d5518235c583ap+850,    0x1.849a215ac276ep-1,   0x1.6ff346p-3, INEXACT)
T(RN,  0x1.409ed28ef1324p+850,    0x1.bfd19f708bfc2p-2,   0x1.b8c9a4p-2, INEXACT)
T(RN,  0x1.352de17b49aa6p+850,    0x1.3619968100359p-2,  -0x1.1cf6f2p-9, INEXACT)
T(RN,  0x1.f04e7dc6663fbp+850,   -0x1.f832516c49599p-1,   0x1.8278f8p-2, INEXACT)
T(RN,  0x1.654043e8cc9a6p+850,    0x1.97a12ae4f18afp-1,  -0x1.de98e6p-3, INEXACT)
T(RN,   0x1.81c426154cc9p+851,   -0x1.0262042daa4cdp-2,  -0x1.e92714p-3, INEXACT)
T(RN,   0x1.ea567ebd0347p+851,    0x1.ff8ec0f365e3bp-1,   0x1.576934p-2, INEXACT)
T(RN,  0x1.7785c7e693e96p+851,    0x1.e688f4f43371fp-3,   0x1.9b9d3ep-2, INEXACT)
T(RN,  0x1.48435ee1599c9p+851,    0x1.cab7a9a32ccf3p-3,   0x1.da352ep-3, INEXACT)
T(RN,  0x1.0f2b4061ff0a5p+851,    0x1.6cc68fca19246p-1,   0x1.5bf9d4p-2, INEXACT)
T(RN,  0x1.0c3fde27b5b77p+851,    0x1.4d3bb693238a6p-4,   0x1.48e516p-2, INEXACT)
T(RN,  0x1.58560a88539a5p+851,    0x1.fa922a90a9fa5p-2,  -0x1.9a9f84p-4, INEXACT)
T(RN,  0x1.77351d96835a6p+851,    0x1.79c40b8d0668ap-1,  -0x1.87e60ap-2, INEXACT)
T(RN,  0x1.977a21deb910ep+851,     -0x1.d9a73f283d4p-2,  -0x1.2fbecep-4, INEXACT)
T(RN,  0x1.87884d9ce9569p+851,   -0x1.9cbf8017eea7fp-1,  -0x1.3851f4p-2, INEXACT)
T(RN,  0x1.8bf577ec905a4p+852,   -0x1.c62b29ca80ff4p-1,   0x1.58f1f8p-3, INEXACT)
T(RN,  0x1.33ade78fa5845p+852,   -0x1.a56b622307e8fp-1,  -0x1.7b1c9ap-3, INEXACT)
T(RN,   0x1.731131b0464cp+852,      0x1.4b1efc9b235p-1,   0x1.7b5438p-6, INEXACT)
T(RN,   0x1.b9378647efb7p+852,   -0x1.52e6ae63b8861p-1,   0x1.face26p-2, INEXACT)
T(RN,  0x1.01c6c4369c61dp+852,   -0x1.e54da8d6de4f8p-1,  -0x1.0a9818p-2, INEXACT)
T(RN,  0x1.a5926accd01f8p+852,   -0x1.e768b2b06de09p-1,   0x1.a77b3ep-3, INEXACT)
T(RN,  0x1.0c824b55b0054p+852,   -0x1.98700421cc37fp-1,  -0x1.db791ep-2, INEXACT)
T(RN,   0x1.6222d442a432p+852,    0x1.8e43c08e80dedp-1,  -0x1.db1c44p-4, INEXACT)
T(RN,   0x1.f73933a9e966p+852,    0x1.f8a3943555666p-1,  -0x1.8f3ba2p-2, INEXACT)
T(RN,  0x1.94759b82ca9e6p+852,   -0x1.98b32bd2ed878p-1,  -0x1.b3a132p-2, INEXACT)
T(RN,  0x1.60c7fd85ead09p+853,    0x1.f2f91ce114576p-1,  -0x1.d1456ap-6, INEXACT)
T(RN,  0x1.00950ec7f6879p+853,   -0x1.93d8bd87407adp-2,  -0x1.83d266p-2, INEXACT)
T(RN,  0x1.3ba81ccc06c83p+853,   -0x1.e60a905df2d4bp-1,  -0x1.cb97c8p-2, INEXACT)
T(RN,  0x1.45ca3294631b2p+853,    0x1.fffb811dc55bdp-1,   0x1.f7fc1ap-6, INEXACT)
T(RN,   0x1.a6b97ff8ccaap+853,    0x1.f79a2fda12882p-1,   0x1.84ad12p-2, INEXACT)
T(RN,  0x1.bcab7110d803ap+853,   -0x1.aafa44b43c774p-1,   0x1.66d90ep-2, INEXACT)
T(RN,   0x1.baebab99ac1cp+853,    0x1.ffbfd6a7fa279p-1,  -0x1.b7aff8p-5, INEXACT)
T(RN,   0x1.e0a345d79305p+853,   -0x1.752c9895354ddp-1,   0x1.051836p-3, INEXACT)
T(RN,  0x1.8638993f24064p+853,   -0x1.e0c81ea751b25p-1,   0x1.c5a20cp-2, INEXACT)
T(RN,  0x1.70655026cd674p+853,   -0x1.80aa5577bb34bp-1,   0x1.3f426cp-2, INEXACT)
T(RN,  0x1.4f266f1abee42p+854,    0x1.d05ca7be50b6ap-1,    0x1.eca38p-3, INEXACT)
T(RN,  0x1.483cdf3a55c07p+854,   -0x1.624a02bf9b9a4p-1,  -0x1.5340aap-3, INEXACT)
T(RN,  0x1.646e1d40f64e9p+854,    0x1.fbca782042102p-1,  -0x1.171f68p-2, INEXACT)
T(RN,  0x1.9a7df4d886216p+854,    0x1.f7aa11969b2a3p-1,  -0x1.c712d2p-2, INEXACT)
T(RN,  0x1.8047ae3642d44p+854,    0x1.73f2fe752f848p-3,   0x1.7b2006p-2, INEXACT)
T(RN,  0x1.5373769f4f56fp+854,    0x1.d8aa09a7ddeccp-5,   0x1.d36dfap-3, INEXACT)
T(RN,  0x1.b1c3fc431e558p+854,    0x1.88d64b552e14bp-2,   0x1.d2a2f4p-2, INEXACT)
T(RN,  0x1.b9de58766751ep+854,   -0x1.8f26cdce446a5p-1,  -0x1.2a9146p-3, INEXACT)
T(RN,  0x1.cbcf4a0bfdec8p+854,    0x1.c7cd3640f3deep-2,  -0x1.b53342p-2, INEXACT)
T(RN,  0x1.e0ff8355a4b67p+854,    0x1.09c2d8c372b12p-5,  -0x1.da04eep-4, INEXACT)
T(RN,  0x1.2f0f375a2d615p+855,    0x1.56d8ba857ec42p-1,   0x1.b4419ep-2, INEXACT)
T(RN,  0x1.17844fd91b8cfp+855,    0x1.f4cc1652e9a6cp-1,  -0x1.1762f6p-6, INEXACT)
T(RN,  0x1.334fa346564acp+855,    0x1.f82e3f64fdd46p-1,  -0x1.103d2ep-3, INEXACT)
T(RN,  0x1.452e8a608a1f8p+855,   -0x1.d1d61c9203162p-1,  -0x1.ba41a2p-2, INEXACT)
T(RN,  0x1.b9b87419f617ap+855,    0x1.a8bb73cceb7bdp-1,  -0x1.0c5b86p-2, INEXACT)
T(RN,  0x1.13b6c99a8fa1cp+855,   -0x1.0d906ba7807bcp-2,   0x1.a5572ap-4, INEXACT)
T(RN,  0x1.7e2ff53ada169p+855,    0x1.fd5fc5957c20dp-2,  -0x1.1643dep-2, INEXACT)
T(RN,  0x1.e9f45e610ce59p+855,   -0x1.f4edb9d4b18f3p-1,   0x1.52dc9cp-2, INEXACT)
T(RN,  0x1.4c3299615f5a9p+855,    0x1.507c324681b92p-1,   0x1.a761d2p-3, INEXACT)
T(RN,  0x1.6965f9dcf1584p+855,    0x1.e9a060941e2a9p-1,  -0x1.9f9e62p-3, INEXACT)
T(RN,  0x1.d57f1891ca17dp+856,   -0x1.32588eb2940d5p-1,   0x1.2a09f8p-2, INEXACT)
T(RN,  0x1.f204ca55f3c36p+856,    0x1.42966cf4ff482p-1,  -0x1.fa92c4p-3, INEXACT)
T(RN,  0x1.d1864b8f45866p+856,    -0x1.fe9564fe8d6cp-1,  -0x1.bcc226p-2, INEXACT)
T(RN,  0x1.2341e653f71d1p+856,   -0x1.2537dcf0ca63dp-1,  -0x1.7d2ea6p-2, INEXACT)
T(RN,  0x1.21037ae527b25p+856,    0x1.c7aa2624a97fdp-5,   -0x1.a03fdp-2, INEXACT)
T(RN,  0x1.ca86624fdbef5p+856,    0x1.f66bf14d57237p-1,  -0x1.81e1ecp-2, INEXACT)
T(RN,   0x1.83ea58ac249cp+856,    0x1.a6f3e8627fb55p-3,    0x1.4fcabp-5, INEXACT)
T(RN,  0x1.0a544cfa66406p+856,   -0x1.a18409346b72bp-1,  -0x1.267baap-2, INEXACT)
T(RN,  0x1.4246fd57353dcp+856,    0x1.1da8ff47e113ap-1,   0x1.45bff6p-2, INEXACT)
T(RN,  0x1.018696ad6124bp+856,   -0x1.e075b451320ffp-1,     0x1.6cbcp-6, INEXACT)
T(RN,  0x1.2f7134a7ad791p+857,   -0x1.92c91fb0d3b62p-2,   0x1.71cddcp-3, INEXACT)
T(RN,  0x1.39d9f3e672bdbp+857,   -0x1.bb716edca24ffp-1,   0x1.fb3cfcp-5, INEXACT)
T(RN,  0x1.bab2fcf6421f5p+857,    0x1.d94d7485a00f3p-3,  -0x1.19390ap-5, INEXACT)
T(RN,  0x1.56b4a6f1eff08p+857,   -0x1.2c5bfef4a0d5dp-1,   -0x1.b60efp-6, INEXACT)
T(RN,  0x1.67f279193783bp+857,    0x1.8d87263d27619p-1,   0x1.2aa6b4p-3, INEXACT)
T(RN,  0x1.8b49a7d028e96p+857,    0x1.9098851ca7381p-1,    0x1.7a099p-3, INEXACT)
T(RN,  0x1.21d3dc6adf0a3p+857,    0x1.8fd473cd3bc7fp-1,  -0x1.0d9454p-2, INEXACT)
T(RN,  0x1.3d97506e84776p+857,    0x1.b0313e6eec92bp-1,  -0x1.6514ecp-4, INEXACT)
T(RN,  0x1.4a83358c399d7p+857,   -0x1.551d336073c1cp-1,   -0x1.c221ap-2, INEXACT)
T(RN,  0x1.c2c452c2e6bfcp+857,     0x1.4a09ca9ba7c8p-1,  -0x1.1f86ccp-2, INEXACT)
T(RN,  0x1.180be6a455b85p+858,    0x1.aa3c5d063a1cbp-1,    0x1.092e7p-6, INEXACT)
T(RN,  0x1.fa8a63fad8bbep+858,    0x1.e51e49a6e58a6p-2,   0x1.0f9676p-2, INEXACT)
T(RN,  0x1.654093a14d46ap+858,   -0x1.4ae108c4aed6bp-1,  -0x1.51f072p-6, INEXACT)
T(RN,  0x1.9636001cfb4a6p+858,   -0x1.d69bc6639d156p-1,   0x1.8aa238p-5, INEXACT)
T(RN,  0x1.63e01755fea66p+858,   -0x1.d19eb42f342cbp-2,    0x1.d80f2p-2, INEXACT)
T(RN,  0x1.2cc332201d478p+858,   -0x1.98e174f5e1097p-1,   0x1.d4bf96p-2, INEXACT)
T(RN,  0x1.43f998743ce1cp+858,    0x1.8e8bda23f4535p-1,   -0x1.47184p-2, INEXACT)
T(RN,  0x1.7b4a8e07661dep+858,    0x1.6de6298f5be6fp-1,   0x1.23130ep-3, INEXACT)
T(RN,  0x1.bec47d955b802p+858,   -0x1.368cc6fd8c683p-3,  -0x1.fb3dbcp-2, INEXACT)
T(RN,   0x1.7b7e1212d5e2p+858,    0x1.56bbff70bffe9p-2,  -0x1.1b1fb2p-2, INEXACT)
T(RN,  0x1.f578823517dbap+859,    0x1.8e88f3427b843p-1,    0x1.57104p-2, INEXACT)
T(RN,  0x1.7da7dc3b56374p+859,   -0x1.a559d098acf09p-2,  -0x1.b1f6d4p-2, INEXACT)
T(RN,  0x1.015566d9c95f8p+859,    0x1.ff05593f9b27ep-1,  -0x1.fb74e4p-3, INEXACT)
T(RN,  0x1.91a44e4d950cdp+859,   -0x1.7a64439b5a28bp-1,  -0x1.94e34cp-4, INEXACT)
T(RN,  0x1.5d86c46bacd18p+859,    0x1.ce3414a4468d3p-6,   0x1.b995bap-2, INEXACT)
T(RN,  0x1.482628c36ad07p+859,    0x1.fb1bdb9729218p-1,   0x1.654faep-2, INEXACT)
T(RN,  0x1.9105846ee76dcp+859,   -0x1.24151d39de9cep-1,  -0x1.789828p-3, INEXACT)
T(RN,  0x1.a2e3278552342p+859,    0x1.b3ac18a6cdb83p-1,   0x1.42192ep-3, INEXACT)
T(RN,  0x1.c454bcb9ef35cp+859,    -0x1.9e051988e92dp-4,   0x1.17f684p-3, INEXACT)
T(RN,  0x1.cca2190671d27p+859,   -0x1.f79dff0079c95p-1,  -0x1.e528aep-2, INEXACT)
T(RN,  0x1.f3707c7b5bab2p+860,    0x1.58055dee15bbep-1,   0x1.2fad08p-3, INEXACT)
T(RN,  0x1.1b2285a307fb5p+860,    0x1.75a66f9e2c4dap-2,   0x1.8b1e12p-2, INEXACT)
T(RN,  0x1.c5923ef60f0bap+860,   -0x1.21816cc19d266p-2,   0x1.96e8d4p-2, INEXACT)
T(RN,  0x1.3d6c176ff1283p+860,    -0x1.f7888120dc7cp-1,  -0x1.0ea40ap-2, INEXACT)
T(RN,  0x1.345cdf7c9c8e6p+860,    0x1.f3bc12b853fe9p-1,  -0x1.a8b7f8p-3, INEXACT)
T(RN,  0x1.542164f1ed4f9p+860,    0x1.d4e6a3ca70ca2p-1,    0x1.7d964p-2, INEXACT)
T(RN,  0x1.4eb6bb3741789p+860,   -0x1.b21840b710acdp-1,    0x1.324ddp-3, INEXACT)
T(RN,  0x1.a16c1f9d3760cp+860,    -0x1.fd8e2a2c15f3p-1,  -0x1.6de6fep-3, INEXACT)
T(RN,  0x1.9276ac03010e7p+860,    -0x1.c9adee0d51c9p-3,   0x1.82ca24p-5, INEXACT)
T(RN,  0x1.52eb52884809ap+860,    -0x1.98bcebdc0a61p-1,  -0x1.718f2cp-4, INEXACT)
T(RN,  0x1.c641956ce057ap+861,   -0x1.eaec1188aa3d9p-1,   -0x1.e4206p-3, INEXACT)
T(RN,  0x1.36baf709b75a8p+861,   -0x1.d96f4d8497bddp-2,  -0x1.51fb52p-3, INEXACT)
T(RN,  0x1.ca4a109f4a654p+861,    0x1.b5e226e78f335p-2,   -0x1.aa25bp-3, INEXACT)
T(RN,  0x1.0b2aca8d800b2p+861,   -0x1.0493669634b0dp-1,    0x1.f4af6p-3, INEXACT)
T(RN,  0x1.467ed8c98d66ap+861,    0x1.f0b93862989a3p-1,  -0x1.b6a3aep-2, INEXACT)
T(RN,  0x1.fcc9f3f0d2d43p+861,   -0x1.d34cc6769155ap-1,  -0x1.beae82p-3, INEXACT)
T(RN,   0x1.06c2d2398043p+861,   -0x1.85677386dbf1ap-1,  -0x1.daeb98p-2, INEXACT)
T(RN,  0x1.f3e6245ffd4e6p+861,   -0x1.9fcdf437b8ee6p-2,  -0x1.0eecdcp-2, INEXACT)
T(RN,  0x1.48d4f6ca3869dp+861,    0x1.f79f97c56ae11p-1,   0x1.b035f4p-2, INEXACT)
T(RN,  0x1.6756f205ea7ccp+861,   -0x1.cbc9400b2bd26p-3,   0x1.881d12p-2, INEXACT)
T(RN,  0x1.a6c77bb5c15b6p+862,    0x1.e3c34d2b382aep-1,   0x1.fbce26p-3, INEXACT)
T(RN,  0x1.52e28ddac18e3p+862,    0x1.b9eae6bc92734p-1,   0x1.e58f4ap-2, INEXACT)
T(RN,  0x1.8682c3e230fc8p+862,   -0x1.10eb5bfcd7513p-1,  -0x1.d6f938p-2, INEXACT)
T(RN,  0x1.766fe02fac6d1p+862,   -0x1.b3461d22f535ep-1,  -0x1.77a1dep-2, INEXACT)
T(RN,   0x1.00068544c4c9p+862,   -0x1.2f2cb0d6a0333p-4,  -0x1.acb5aep-2, INEXACT)
T(RN,  0x1.ac22a06cb94f6p+862,   -0x1.b576e8a9cab2cp-1,  -0x1.4d0beep-2, INEXACT)
T(RN,  0x1.051a88f8926f2p+862,    -0x1.f086b85d1b91p-1,  -0x1.2837b2p-3, INEXACT)
T(RN,  0x1.1fc825f494fe5p+862,   -0x1.fffab4fe6c8f4p-1,  -0x1.6c09d2p-2, INEXACT)
T(RN,  0x1.e8b3599e58384p+862,    0x1.2e11f5c235625p-4,  -0x1.a078ccp-4, INEXACT)
T(RN,  0x1.f4ef0ec8c69d4p+862,    0x1.b6be367ff5121p-2,  -0x1.62f912p-2, INEXACT)
T(RN,  0x1.3c260cfba3d7fp+863,    0x1.3fc86794afc34p-2,   0x1.76c154p-2, INEXACT)
T(RN,    0x1.93554baec34p+863,   -0x1.ea4120c36624fp-1,   0x1.a7675ep-5, INEXACT)
T(RN,  0x1.6d30240538b97p+863,    0x1.f7f7641101792p-1,   0x1.30b4f2p-2, INEXACT)
T(RN,  0x1.ae00d21639922p+863,     0x1.e45e58d4df5dp-1,  -0x1.936342p-3, INEXACT)
T(RN,  0x1.ad02e52c027b8p+863,    0x1.a9554dd608fbcp-2,  -0x1.70d014p-5, INEXACT)
T(RN,  0x1.8b5bff7828f4cp+863,    0x1.ff1b9d2d32618p-1,   0x1.017df6p-9, INEXACT)
T(RN,  0x1.d6399d6b0888ep+863,    0x1.d7404ff90cdfep-3,   0x1.b92012p-3, INEXACT)
T(RN,  0x1.c98799a748bddp+863,   -0x1.eb369fda56569p-1,  -0x1.12230ep-2, INEXACT)
T(RN,  0x1.29e8c467689e4p+863,    0x1.c0941a6c57a4cp-1,   0x1.9fcfa2p-5, INEXACT)
T(RN,   0x1.e96116812168p+863,   -0x1.fc48c6a0e7ae5p-1,  -0x1.aa6224p-2, INEXACT)
T(RN,  0x1.853428c2151d3p+864,   -0x1.c3328d9608347p-2,   0x1.61ea9ap-2, INEXACT)
T(RN,  0x1.a2ffd7a921ab8p+864,   -0x1.39f00f5272644p-1,  -0x1.3cf974p-2, INEXACT)
T(RN,  0x1.201e908e0e99bp+864,   -0x1.d9c53f89a8ec4p-1,  -0x1.fe6378p-3, INEXACT)
T(RN,  0x1.13261f6343576p+864,   -0x1.3146e54e7d6a2p-1,  -0x1.fb9cbep-2, INEXACT)
T(RN,  0x1.62f968a0be011p+864,   -0x1.9d471fa64ece5p-1,  -0x1.156846p-2, INEXACT)
T(RN,  0x1.0154b323abacdp+864,   -0x1.263721d845379p-1,  -0x1.bd612ep-2, INEXACT)
T(RN,  0x1.638dd4f5d4f65p+864,   -0x1.36961498f3e32p-3,  -0x1.4c28f6p-3, INEXACT)
T(RN,  0x1.1353ac3bb2c51p+864,    0x1.fa4705a2e8198p-1,   0x1.a8a5dap-2, INEXACT)
T(RN,  0x1.11f9fd4bff4f6p+864,    0x1.15572f86b35a5p-7,   0x1.836758p-3, INEXACT)
T(RN,  0x1.6726a31075462p+864,   -0x1.0edae633f69bap-1,   0x1.1b60bcp-2, INEXACT)
T(RN,  0x1.42b0e7a3b2182p+865,   -0x1.ec72094cf2cafp-2,  -0x1.617652p-7, INEXACT)
T(RN,  0x1.2c4b0871a36fcp+865,    0x1.b229c6bfe950ap-4,    0x1.bba9ap-2, INEXACT)
T(RN,  0x1.71a502225ed35p+865,   -0x1.3de6c78e40ffap-7,   0x1.f5c248p-3, INEXACT)
T(RN,  0x1.4f7d2f3e77d0dp+865,   -0x1.2a3982fb2d971p-1,  -0x1.fa5cecp-2, INEXACT)
T(RN,  0x1.889451a8e1776p+865,   -0x1.a95e9ef2b8402p-1,   0x1.8e3638p-6, INEXACT)
T(RN,  0x1.4ad9f10e268f9p+865,     0x1.914cbf10aa42p-1,   -0x1.1dc93p-2, INEXACT)
T(RN,  0x1.01f6e574130dbp+865,   -0x1.339e0d708ca57p-2,   0x1.f9fb76p-4, INEXACT)
T(RN,  0x1.fdef743692b64p+865,    0x1.5d80b2545db17p-2,   -0x1.abb02p-3, INEXACT)
T(RN,  0x1.4f15605c50e62p+865,    0x1.bb02e3cca5a9ap-1,  -0x1.607ccap-2, INEXACT)
T(RN,  0x1.e825c21488e9cp+865,    0x1.7508e0916fb1ep-2,   -0x1.60984p-6, INEXACT)
T(RN,  0x1.a382f8b072c5ap+866,   -0x1.daa804084d809p-1,  -0x1.6bcffep-7, INEXACT)
T(RN,  0x1.c27e85aed2b75p+866,    0x1.8ba74ed467c05p-1,  -0x1.96be4cp-2, INEXACT)
T(RN,  0x1.30a6e6ad8d47ap+866,    0x1.ebbf8df97801ep-2,   0x1.ccd8bap-2, INEXACT)
T(RN,  0x1.a98ba8de5ef38p+866,   -0x1.aab0b3823ad13p-2,   0x1.c0b0e4p-8, INEXACT)
T(RN,  0x1.f843c1c2494ccp+866,    0x1.3bcb3a79d8a2dp-2,  -0x1.448d9cp-7, INEXACT)
T(RN,  0x1.f3680e7c07b22p+866,    0x1.f98f94af4306bp-1,  -0x1.e5797ap-2, INEXACT)
T(RN,   0x1.f1933ff51a51p+866,   -0x1.8899c122e0b5dp-1,   0x1.5f48f6p-2, INEXACT)
T(RN,   0x1.b20ccbcd6578p+866,    0x1.92312bc5e6dc3p-1,  -0x1.a825dcp-2, INEXACT)
T(RN,  0x1.66e5311b758a6p+866,    0x1.c7e99633be5b9p-1,   0x1.b9b11ep-4, INEXACT)
T(RN,  0x1.795177b3ee1bfp+866,    0x1.4b18c0b4b94ccp-1,    0x1.4e1c4p-3, INEXACT)
T(RN,  0x1.30f3346899f19p+867,    0x1.8b5fbf8197e65p-1,  -0x1.203422p-4, INEXACT)
T(RN,  0x1.3bef7014fc7c1p+867,    0x1.ee6f9b0fe056fp-1,  -0x1.17c69ap-4, INEXACT)
T(RN,  0x1.91412c56ebc55p+867,   -0x1.94bb7fe3edd14p-1,  -0x1.f5674ap-4, INEXACT)
T(RN,  0x1.f01807f607e94p+867,    -0x1.4e5886a86c15p-2,  -0x1.7528c8p-2, INEXACT)
T(RN,  0x1.6d324ca4fa512p+867,   -0x1.e24fc76ad2b05p-2,   0x1.a2718cp-3, INEXACT)
T(RN,  0x1.3bc51d0e52728p+867,    0x1.a2d0accf8acdep-7,   0x1.c79776p-3, INEXACT)
T(RN,  0x1.b614cd3b27136p+867,    -0x1.52e09ed61304p-1,   0x1.ab7104p-3, INEXACT)
T(RN,  0x1.1c1aa690596f5p+867,   -0x1.ed3a9a1ec70b4p-2,  -0x1.dce34ep-4, INEXACT)
T(RN,  0x1.6a9aa1c87db2ap+867,    0x1.13df49124d1dcp-1,  -0x1.c1a648p-5, INEXACT)
T(RN,  0x1.00fdc1c61b98dp+867,    0x1.f6b47b7ff22d1p-1,  -0x1.5defb4p-4, INEXACT)
T(RN,  0x1.1696962af3b7cp+868,    0x1.7626f643e169fp-2,   0x1.4ce18ap-3, INEXACT)
T(RN,  0x1.396954054faf7p+868,   -0x1.92b1b4ea4fcf6p-1,   0x1.910cc8p-2, INEXACT)
T(RN,  0x1.d75ce3d3c86f9p+868,    0x1.2aebacf8ddb93p-1,   0x1.d7e9e8p-3, INEXACT)
T(RN,  0x1.7fb54ba0483e1p+868,   -0x1.36b60513d4437p-1,   0x1.95c898p-3, INEXACT)
T(RN,  0x1.c7425f66ee902p+868,    0x1.ccf23021bb471p-2,  -0x1.8e49a2p-2, INEXACT)
T(RN,   0x1.146c524bca53p+868,   -0x1.83debd3a74937p-1,    0x1.51c77p-3, INEXACT)
T(RN,  0x1.0e60e2e4b7e6cp+868,   -0x1.0de25db01fec9p-2,  -0x1.8dad66p-3, INEXACT)
T(RN,  0x1.24382b3a2abcep+868,    0x1.912627983ea1ap-1,   0x1.5b8322p-2, INEXACT)
T(RN,  0x1.4bec4be6ed5a8p+868,    0x1.f5feba3ea77cap-4,  -0x1.5b70a4p-2, INEXACT)
T(RN,  0x1.61133942fca0dp+868,   -0x1.bb395001faca7p-1,   0x1.b9f35cp-3, INEXACT)
T(RN,  0x1.4ca962055620ep+869,    0x1.740e11c07e2aep-3,  -0x1.edb594p-2, INEXACT)
T(RN,  0x1.e1255c729443cp+869,   -0x1.5993eb2e95b11p-2,   0x1.40eb2cp-2, INEXACT)
T(RN,  0x1.e4454171209fcp+869,    0x1.e4d5878dc83c8p-1,  -0x1.b8c138p-2, INEXACT)
T(RN,  0x1.10416c7fe6502p+869,   -0x1.6a8d2334c53f1p-1,  -0x1.5c60b2p-2, INEXACT)
T(RN,  0x1.66077de753a19p+869,    -0x1.049ed921846dp-7,   0x1.0f62fep-5, INEXACT)
T(RN,  0x1.9bb147f306202p+869,   -0x1.ffcd94b93b43bp-1,  -0x1.46e7cap-2, INEXACT)
T(RN,  0x1.5453b44ee7d0cp+869,    0x1.34aa60a30cfd4p-1,  -0x1.32d924p-5, INEXACT)
T(RN,  0x1.3641164280ea5p+869,   -0x1.a03f51cc5cd67p-1,  -0x1.727778p-3, INEXACT)
T(RN,  0x1.8759c147af3ccp+869,   -0x1.4e36c3546aeddp-1,    0x1.f5ff2p-5, INEXACT)
T(RN,  0x1.9b6f896362b77p+869,    0x1.11b95bf01a0c8p-4,  -0x1.55d1d6p-2, INEXACT)
T(RN,  0x1.774f07ef765a6p+870,   -0x1.ce85f076a0b7fp-1,   0x1.3d0b36p-3, INEXACT)
T(RN,  0x1.3d3131c9672b1p+870,   -0x1.45f76068ea059p-7,  -0x1.437d4ep-2, INEXACT)
T(RN,  0x1.18f957d3abbbep+870,    0x1.d1f378e0c2261p-3,  -0x1.16293ep-2, INEXACT)
T(RN,  0x1.e1d9353ac1a77p+870,   -0x1.1548b1cfdfe36p-1,   0x1.1465b2p-2, INEXACT)
T(RN,  0x1.05b241b29e2bfp+870,    0x1.942c2c689b5aep-1,  -0x1.e732a4p-3, INEXACT)
T(RN,  0x1.0a5ed1a845527p+870,    0x1.dd06fd37aa963p-1,   -0x1.decc2p-4, INEXACT)
T(RN,  0x1.f4ea2599edc78p+870,   -0x1.de2d50c5ff178p-1,  -0x1.f8dd48p-2, INEXACT)
T(RN,  0x1.f9a6952b4f602p+870,    -0x1.ffb4ad77d7e4p-1,   0x1.ea4fe4p-2, INEXACT)
T(RN,  0x1.f68b77091d512p+870,    0x1.95a2ce5f238a9p-1,  -0x1.a04104p-2, INEXACT)
T(RN,  0x1.044ca872bc27fp+870,   -0x1.3bf6a69b4613ep-1,  -0x1.ab5d02p-2, INEXACT)
T(RN,  0x1.512591804cd56p+871,    0x1.4929dd3bdbadcp-1,   0x1.e9b70cp-2, INEXACT)
T(RN,  0x1.632714f7cbb92p+871,   -0x1.216d9dcfdc981p-3,    0x1.46e84p-5, INEXACT)
T(RN,  0x1.b85dbeffc2f73p+871,   -0x1.410d882b5ef6dp-2,  -0x1.3da9bcp-2, INEXACT)
T(RN,  0x1.25a79f3b6034ap+871,   -0x1.df16478a0e5cbp-1,  -0x1.7558c4p-4, INEXACT)
T(RN,  0x1.8c34cb8f5ac8ap+871,   -0x1.260539f986a26p-1,  -0x1.0ecfe8p-2, INEXACT)
T(RN,  0x1.71ed75bcae7d8p+871,   -0x1.aa0b91890c474p-1,  -0x1.295cfep-2, INEXACT)
T(RN,  0x1.e4e4e5ea37287p+871,    0x1.2df10eb72c97ep-4,   0x1.141c6cp-6, INEXACT)
T(RN,  0x1.02f4d8c4024b8p+871,    0x1.fe0d7b718ac88p-1,   0x1.346328p-3, INEXACT)
T(RN,  0x1.214594a0cb2c3p+871,   -0x1.c9735a03a99dbp-1,   0x1.5ee6cap-4, INEXACT)
T(RN,  0x1.beecb467b8764p+871,   -0x1.beac978441cd8p-1,   0x1.dd0d8ap-3, INEXACT)
T(RN,  0x1.cc1588e5143bep+872,     0x1.a1e408cb5182p-3,   0x1.c0a9eep-2, INEXACT)
T(RN,  0x1.e591c064ef11dp+872,    0x1.ed4194e80ea3bp-1,  -0x1.6c54b8p-5, INEXACT)
T(RN,  0x1.591e99dde11cap+872,    0x1.aec9ee171a7c7p-1,  -0x1.e7c036p-5, INEXACT)
T(RN,  0x1.e8ac03deb8d46p+872,     0x1.e063aa5ccf99p-1,   0x1.d1db5cp-2, INEXACT)
T(RN,  0x1.13553cb621149p+872,    0x1.29467158bd3b7p-3,   0x1.89f1b4p-2, INEXACT)
T(RN,  0x1.78ae532c27034p+872,    0x1.6f8d15e541ec7p-6,   0x1.eac0cep-2, INEXACT)
T(RN,  0x1.586849216d122p+872,   -0x1.eee8ec787a608p-1,   0x1.bcd2f2p-2, INEXACT)
T(RN,  0x1.2538f7ec1a6e1p+872,   -0x1.b0e6327a70796p-3,  -0x1.2c0f4ap-2, INEXACT)
T(RN,  0x1.2a501d5cbbed7p+872,   -0x1.20648df557ec9p-1,   0x1.a9395cp-4, INEXACT)
T(RN,   0x1.6b9196dcf6acp+872,    0x1.1fbfecef8a358p-4,   0x1.8eeba2p-2, INEXACT)
T(RN,  0x1.59154092dfb24p+873,   -0x1.b984815c129f9p-1,   0x1.ff0edcp-2, INEXACT)
T(RN,  0x1.82d04362294bep+873,    0x1.faf2768bd6e72p-1,  -0x1.6352e8p-2, INEXACT)
T(RN,  0x1.afb4eb307f2b2p+873,   -0x1.d92b435629191p-1,  -0x1.33fc46p-7, INEXACT)
T(RN,  0x1.88c8940df772cp+873,    0x1.8eec9fd7a07bdp-3,    0x1.8c3c2p-2, INEXACT)
T(RN,  0x1.b25ee55d5985dp+873,    0x1.8e174fe9aa438p-1,  -0x1.5a1412p-2, INEXACT)
T(RN,  0x1.75dd398eae045p+873,   -0x1.37d81e2c63b4bp-2,   0x1.46abd2p-2, INEXACT)
T(RN,  0x1.62623ee46c5ccp+873,    0x1.40580c675fc5dp-1,  -0x1.cd380ep-2, INEXACT)
T(RN,  0x1.3b69bb349dffcp+873,    0x1.65870bb99da37p-1,   0x1.0f091ap-2, INEXACT)
T(RN,  0x1.459d6d9f2ec7ep+873,   -0x1.87b9f03fd92e9p-3,   -0x1.65bfdp-4, INEXACT)
T(RN,   0x1.2b073d241ab7p+873,    -0x1.f09cb5f4b713p-1,  -0x1.9cdbbcp-2, INEXACT)
T(RN,   0x1.6428b3228ae1p+874,    0x1.37397e7846abdp-1,   0x1.6562bep-2, INEXACT)
T(RN,  0x1.cc79e2f20c86cp+874,    0x1.ee7d3f0402f61p-1,   0x1.8b9494p-3, INEXACT)
T(RN,  0x1.a309bd77f8fd9p+874,   -0x1.3b080c705aa6dp-1,   0x1.cfea78p-2, INEXACT)
T(RN,  0x1.aa03745afaad2p+874,   -0x1.eaea7585d6219p-1,  -0x1.cfaa34p-2, INEXACT)
T(RN,  0x1.b2703c269e6c2p+874,    0x1.ec34dc9d320e2p-1,   0x1.24dafep-2, INEXACT)
T(RN,  0x1.e862dbbe54972p+874,    0x1.251a73dcca06fp-1,  -0x1.cafc9ep-3, INEXACT)
T(RN,  0x1.4f967cc04c41cp+874,   -0x1.9ebc5db92bc94p-5,  -0x1.18de6cp-2, INEXACT)
T(RN,  0x1.0612727c52366p+874,   -0x1.db9a0928744a9p-1,   0x1.0ff8b8p-2, INEXACT)
T(RN,  0x1.b68f5a52ce49cp+874,   -0x1.19d2568378a3fp-3,  -0x1.b7adaap-3, INEXACT)
T(RN,  0x1.8b3bcb03d8bcdp+874,     0x1.fa5132317db3p-1,   -0x1.239f9p-2, INEXACT)
T(RN,  0x1.938c0862057a6p+875,   -0x1.c37c138c727bdp-2,   0x1.8bd71cp-3, INEXACT)
T(RN,  0x1.776bf52897ce2p+875,    0x1.e2b0d850c621fp-1,  -0x1.787624p-4, INEXACT)
T(RN,  0x1.a89a0dbdcc516p+875,    0x1.d031fbeb79857p-1,   0x1.47676ep-2, INEXACT)
T(RN,  0x1.ff8c19263fdffp+875,    0x1.67643ae3ab4c7p-5,   0x1.1f70cep-5, INEXACT)
T(RN,  0x1.26cc1728b8e5ap+875,   -0x1.db9c01180f987p-5,   0x1.d3f0d4p-2, INEXACT)
T(RN,  0x1.90bc75d364972p+875,    0x1.acfb9214ba615p-3,   0x1.12fcf8p-3, INEXACT)
T(RN,  0x1.e5afca799158bp+875,    0x1.b8ccb7797479bp-7,  -0x1.34351cp-4, INEXACT)
T(RN,  0x1.0da03f5235036p+875,   -0x1.e37284904a39ep-1,   0x1.a29e82p-9, INEXACT)
T(RN,  0x1.bad3d1798cc1ap+875,   -0x1.eb5c9d4c3eaf4p-1,   0x1.1767b6p-2, INEXACT)
T(RN,  0x1.c26e73555222cp+875,     0x1.d3c2511a7604p-3,  -0x1.da7b6cp-2, INEXACT)
T(RN,  0x1.11554a3fb3e23p+876,     0x1.12a9ac77343dp-1,   0x1.030ed6p-2, INEXACT)
T(RN,  0x1.286819bd856f8p+876,   -0x1.a539b5ff16c34p-1,  -0x1.eb53ecp-3, INEXACT)
T(RN,  0x1.3ed0304eb00f4p+876,     0x1.c97b39ccef5ap-1,   0x1.06cdaep-2, INEXACT)
T(RN,   0x1.8af77bc30481p+876,    0x1.49024b4d16047p-1,  -0x1.46e618p-3, INEXACT)
T(RN,  0x1.0e1dfb061f80bp+876,    0x1.34e590d40faabp-3,   0x1.e7fc7cp-2, INEXACT)
T(RN,  0x1.fae9458b419acp+876,   -0x1.fba6c5cbb562ap-1,  -0x1.4ce138p-3, INEXACT)
T(RN,  0x1.bb78e1d5c036ap+876,    0x1.ad86e540d008cp-7,   -0x1.2fe0cp-4, INEXACT)
T(RN,  0x1.1926604be9d8ep+876,    0x1.4a7c7c87db9c6p-1,   0x1.fff54ep-2, INEXACT)
T(RN,  0x1.6ee702a05e08cp+876,    0x1.c4d6a382ef7dfp-1,   0x1.3ab0cep-7, INEXACT)
T(RN,  0x1.3fc64b70b8c09p+876,   -0x1.d7ec315c5825cp-6,  -0x1.102ac6p-5, INEXACT)
T(RN,  0x1.ab2a3ee63d58ep+877,    -0x1.fb6221cf8602p-1,   0x1.7307c2p-2, INEXACT)
T(RN,  0x1.4f811e7048382p+877,     0x1.94f8f35b3113p-1,   0x1.aa20dcp-3, INEXACT)
T(RN,  0x1.8aec3bab5e3bap+877,    0x1.404046ff814ecp-1,    0x1.2833dp-4, INEXACT)
T(RN,   0x1.2b5f7a951951p+877,   -0x1.52e7b8b313c49p-1,   0x1.4fa2b6p-2, INEXACT)
T(RN,  0x1.0654bc43da16bp+877,    0x1.59ec27ce5f7a1p-4,   -0x1.cafcdp-3, INEXACT)
T(RN,  0x1.b748092aab43cp+877,    0x1.a90cf8010f3cbp-1,   0x1.ee54fep-2, INEXACT)
T(RN,  0x1.ea2a6b1607ab6p+877,   -0x1.27b911e257a4dp-1,  -0x1.9f4f74p-2, INEXACT)
T(RN,  0x1.294c0b7f864f5p+877,   -0x1.091f06aed26c1p-1,  -0x1.2351a6p-7, INEXACT)
T(RN,  0x1.b6706ed20faefp+877,   -0x1.ff3483f73062cp-1,   0x1.d73948p-4, INEXACT)
T(RN,  0x1.9ceaa4d7b5abcp+877,   -0x1.3cbfe65e9d7acp-1,  -0x1.1ec728p-2, INEXACT)
T(RN,  0x1.b4d7adf8afab7p+878,     0x1.8b81819e72d8p-2,   0x1.a194bep-2, INEXACT)
T(RN,  0x1.c4b29cc7a4211p+878,    0x1.dee5e87c06e82p-1,   0x1.e50734p-3, INEXACT)
T(RN,  0x1.e0d03b46a6eb8p+878,    0x1.9259eb4da00afp-4,  -0x1.10364ep-4, INEXACT)
T(RN,  0x1.0e64a7f261959p+878,   -0x1.0d9027732e4c4p-1,   0x1.185482p-2, INEXACT)
T(RN,  0x1.1bc169d28e0e3p+878,    0x1.f77940b35530ap-1,  -0x1.2e5f0ep-4, INEXACT)
T(RN,  0x1.86f58d8f0879cp+878,    0x1.c5f8cb5d74562p-1,   0x1.1fcca6p-2, INEXACT)
T(RN,  0x1.e7cbf605071f4p+878,    0x1.75f90a634ddbdp-1,  -0x1.48f3cep-2, INEXACT)
T(RN,  0x1.9b1ca6d83fd75p+878,   -0x1.40afd3c79dfbfp-3,  -0x1.4d3f94p-2, INEXACT)
T(RN,  0x1.34cc1cbd4e5a2p+878,    0x1.c88af39be853ap-1,   0x1.ad00cep-3, INEXACT)
T(RN,  0x1.dc7a300f53c26p+878,    0x1.fffa0e319f198p-1,   0x1.9427e6p-2, INEXACT)
T(RN,  0x1.54ea0e10593cep+879,    -0x1.0517eaa0348bp-2,   0x1.9a8af6p-3, INEXACT)
T(RN,  0x1.c6ca7401b9326p+879,   -0x1.ff7eca1f54dafp-2,  -0x1.0a0a2cp-3, INEXACT)
T(RN,  0x1.5210f8288f3fap+879,    0x1.fff66d31a87c1p-1,  -0x1.227aa8p-3, INEXACT)
T(RN,  0x1.c4698186af518p+879,     0x1.32fcbf6b5b75p-4,  -0x1.75eea4p-3, INEXACT)
T(RN,  0x1.2069d6f6a894ap+879,   -0x1.b5f491ebf1693p-1,   0x1.da9e2cp-3, INEXACT)
T(RN,  0x1.61f6f6194fd7dp+879,   -0x1.ae5be7bc7c39ap-1,  -0x1.28bb14p-4, INEXACT)
T(RN,  0x1.b6b743b2910c8p+879,    0x1.052b18fc18913p-4,  -0x1.3b0e6ep-3, INEXACT)
T(RN,  0x1.c7f6a2ec6d2ecp+879,    0x1.8a1ef944aa1e2p-2,   -0x1.0a483p-4, INEXACT)
T(RN,  0x1.512dcb13ed885p+879,   -0x1.a8bd2ac2a4705p-1,   0x1.9578bap-2, INEXACT)
T(RN,  0x1.7f399545ab838p+879,   -0x1.e2e2a4b47b13cp-2,  -0x1.a4a5a4p-6, INEXACT)
T(RN,  0x1.0be54feeb8852p+880,   -0x1.776ec5817ecf8p-6,     0x1.96c9p-2, INEXACT)
T(RN,  0x1.1e24874b3ef21p+880,   -0x1.e0dbcb280a699p-1,   0x1.0c48d2p-2, INEXACT)
T(RN,  0x1.46fc5c39efc72p+880,    0x1.5eeee99da9748p-3,   0x1.a6665ep-4, INEXACT)
T(RN,   0x1.2e7cc8feb6ffp+880,    -0x1.ffd5e90be9d3p-1,  -0x1.fb3c4ap-2, INEXACT)
T(RN,  0x1.884e665e20c18p+880,    0x1.1931f98c957a2p-6,   0x1.b0ed2cp-3, INEXACT)
T(RN,  0x1.5bb55994ae9efp+880,    0x1.96936660f33d5p-1,  -0x1.b24618p-3, INEXACT)
T(RN,  0x1.e725681b90cbbp+880,    -0x1.a1c052f9987dp-1,   0x1.05ec12p-2, INEXACT)
T(RN,  0x1.e28af4c080e52p+880,    0x1.efb2a4052b92fp-3,  -0x1.87453ap-2, INEXACT)
T(RN,  0x1.9d407473fbedcp+880,    0x1.8753d47798909p-1,  -0x1.1e5848p-2, INEXACT)
T(RN,  0x1.b77fd3ee14782p+880,   -0x1.ad8397dfb9b14p-4,   0x1.66f65ep-3, INEXACT)
T(RN,  0x1.39b3bd419d9d6p+881,   -0x1.e2017bc50ac2ap-1,   0x1.d4b6eep-2, INEXACT)
T(RN,  0x1.ed753354ea4d4p+881,   -0x1.ebb8288966f98p-1,  -0x1.739922p-3, INEXACT)
T(RN,  0x1.5566156b6840ap+881,    0x1.e01b8ae8c3a12p-1,  -0x1.25d4e6p-2, INEXACT)
T(RN,  0x1.96f8b26262eeap+881,   -0x1.0a1d99906d9afp-1,   0x1.3baa08p-2, INEXACT)
T(RN,  0x1.545773decf2b6p+881,   -0x1.e8394da284692p-1,   0x1.16a1f6p-2, INEXACT)
T(RN,  0x1.2c61d179bdd9bp+881,   -0x1.ff8f107de18f4p-1,  -0x1.e84c5ep-2, INEXACT)
T(RN,  0x1.49d094b85cbaep+881,   -0x1.e3fc396b20eebp-1,  -0x1.34fdf8p-2, INEXACT)
T(RN,  0x1.f16315ec066cap+881,     0x1.fb34251edd8ap-1,   0x1.6ed204p-3, INEXACT)
T(RN,  0x1.576e52a4b526ep+881,    0x1.90403483fd16cp-4,    0x1.a9f75p-2, INEXACT)
T(RN,   0x1.07c4db898c16p+881,    0x1.b1cb48a3831c6p-1,  -0x1.4eaffcp-2, INEXACT)
T(RN,  0x1.2387e0b80e402p+882,    0x1.309e978a00373p-1,  -0x1.6b1464p-5, INEXACT)
T(RN,  0x1.14075ad7b9ca2p+882,   -0x1.e504aa3b1f928p-1,  -0x1.f6790cp-5, INEXACT)
T(RN,   0x1.288b0a691dacp+882,     0x1.2b5dfa36d9a5p-3,  -0x1.9d6c7ap-4, INEXACT)
T(RN,  0x1.351bd14a27052p+882,    0x1.0c1d0c866c9e3p-1,   0x1.3bf7e2p-2, INEXACT)
T(RN,  0x1.4e3c898797b1bp+882,    0x1.f706fede9bbddp-1,   0x1.4895dep-4, INEXACT)
T(RN,  0x1.49bc03595b096p+882,   -0x1.bda40b12ae6a4p-1,   0x1.b7d2ecp-3, INEXACT)
T(RN,  0x1.aad6fc854ec6ep+882,   -0x1.a1208e69544afp-6,   0x1.a85a72p-2, INEXACT)
T(RN,  0x1.f45f2b74c0a7ep+882,    0x1.e275689db2dbcp-1,  -0x1.386dcep-2, INEXACT)
T(RN,  0x1.53f0f37ffb67ep+882,   -0x1.0d63993d61ad5p-1,  -0x1.4a804cp-4, INEXACT)
T(RN,  0x1.e1bcd1ad9609fp+882,   -0x1.fe2b8474ad71dp-1,   0x1.4fb7c2p-2, INEXACT)
T(RN,  0x1.bd8ca3bdb110ep+883,    0x1.6046d219d9173p-2,   0x1.085946p-6, INEXACT)
T(RN,   0x1.7e3ce433993ep+883,    0x1.a6a36ce651b2bp-1,  -0x1.1135bcp-3, INEXACT)
T(RN,  0x1.3b3e5593fff42p+883,   -0x1.ff9af23e6c8f6p-1,    -0x1.5105p-2, INEXACT)
T(RN,  0x1.2404d520b6f85p+883,   -0x1.c4e5be994f206p-2,   0x1.29d452p-2, INEXACT)
T(RN,  0x1.2100b11e77f86p+883,    0x1.a132ddc634e68p-2,  -0x1.617428p-2, INEXACT)
T(RN,  0x1.13794f1503c06p+883,    0x1.a992098225b7ap-1,  -0x1.54249ap-2, INEXACT)
T(RN,  0x1.b94576036b3dfp+883,    0x1.3c1ba4172fe97p-2,    0x1.ce0f9p-2, INEXACT)
T(RN,  0x1.94de71ad64a86p+883,   -0x1.48f338368fa62p-1,  -0x1.a2a852p-4, INEXACT)
T(RN,   0x1.44bbb2985111p+883,   -0x1.fa873c0155372p-1,   0x1.70bfdcp-4, INEXACT)
T(RN,  0x1.44be36a21001ap+883,   -0x1.ab84ca23a43f2p-1,   0x1.6a89d2p-2, INEXACT)
T(RN,   0x1.e9e8d278ba17p+884,   -0x1.eea45c178924fp-1,  -0x1.8780bep-2, INEXACT)
T(RN,  0x1.5602a800f8f14p+884,   -0x1.8786aaefebb6ep-1,    0x1.a9d44p-3, INEXACT)
T(RN,  0x1.c01573a503eccp+884,    0x1.0aeb5197b180dp-2,   0x1.e7800ep-2, INEXACT)
T(RN,  0x1.e98e3f8df19dcp+884,    0x1.c89d7c4eeef8fp-1,   0x1.0ff07ep-2, INEXACT)
T(RN,  0x1.1a9cf02b48c06p+884,   -0x1.ffffb04191088p-1,  -0x1.9f1828p-5, INEXACT)
T(RN,  0x1.81fc8dedd1d42p+884,   -0x1.84faea36884d9p-5,  -0x1.eedb22p-3, INEXACT)
T(RN,  0x1.6228a5bf4c127p+884,   -0x1.7724e47309e14p-1,    0x1.d0d5ep-5, INEXACT)
T(RN,  0x1.754bf7ce079a3p+884,   -0x1.5d080d2587ea3p-2,  -0x1.bac4c6p-3, INEXACT)
T(RN,  0x1.204ef7ce72fccp+884,    0x1.e89161402bb69p-1,   0x1.5bb70ap-2, INEXACT)
T(RN,  0x1.7d7793119fe8fp+884,    0x1.c3fbdba39a139p-1,  -0x1.5de9f8p-2, INEXACT)
T(RN,  0x1.9eb01b90f3688p+885,   -0x1.a15a1e989501cp-2,   0x1.9a6decp-2, INEXACT)
T(RN,  0x1.04eef18e238d2p+885,   -0x1.fffffe6e2b242p-1,  -0x1.13523ep-5, INEXACT)
T(RN,  0x1.f15f9a2f25597p+885,   -0x1.77972a055c11ep-5,   -0x1.ebca4p-3, INEXACT)
T(RN,  0x1.72b26aaeb328cp+885,   -0x1.4b8b5fea1322ep-1,    0x1.e8f56p-2, INEXACT)
T(RN,   0x1.69cecf859116p+885,   -0x1.ecfd82e660119p-1,   0x1.036b94p-3, INEXACT)
T(RN,  0x1.b951784c8c916p+885,    0x1.02b2469ecb29fp-1,  -0x1.afec48p-2, INEXACT)
T(RN,   0x1.a96a30a442f5p+885,   -0x1.2e5dba6a8b0b1p-1,  -0x1.c04f48p-2, INEXACT)
T(RN,   0x1.628dbdf3ecc6p+885,   -0x1.c45b2bc68aa4ap-2,   0x1.aaa5e4p-2, INEXACT)
T(RN,  0x1.638812828436cp+885,   -0x1.12286f3157cbdp-1,  -0x1.b522d2p-3, INEXACT)
T(RN,  0x1.991c164ec1f24p+885,   -0x1.7f831df0d5351p-1,  -0x1.47c764p-2, INEXACT)
T(RN,  0x1.bbf0b3081bcfap+886,    -0x1.7f8bc0761873p-1,  -0x1.637298p-3, INEXACT)
T(RN,  0x1.d4be7f5ed2b48p+886,    0x1.4caaf393346fcp-4,   0x1.4ef198p-3, INEXACT)
T(RN,  0x1.8b54b1ee2d5dcp+886,   -0x1.1b54d7f14d3adp-2,  -0x1.619888p-4, INEXACT)
T(RN,  0x1.f6af8a53f5a2ep+886,    0x1.e26e25b244f95p-1,   0x1.36921cp-2, INEXACT)
T(RN,  0x1.45204e9664c79p+886,    0x1.f431e92676683p-1,  -0x1.ae4e78p-3, INEXACT)
T(RN,  0x1.131f6ff458194p+886,   -0x1.72aac21ada92bp-1,   -0x1.b347cp-2, INEXACT)
T(RN,  0x1.abfb5857e31adp+886,   -0x1.5fa6f0071bd2ap-1,  -0x1.13207cp-3, INEXACT)
T(RN,  0x1.f1b1b4671208dp+886,    0x1.745774f9726f1p-1,  -0x1.d1dd92p-2, INEXACT)
T(RN,  0x1.81d586d621bf2p+886,    0x1.c81ca4fd7535ap-1,   0x1.7374d8p-2, INEXACT)
T(RN,   0x1.5f75b798fe6ap+886,   -0x1.dd3e0b9715754p-1,  -0x1.4cc588p-8, INEXACT)
T(RN,  0x1.3c575f19ba7fap+887,    0x1.e48397cfed4d4p-1,   0x1.02c634p-4, INEXACT)
T(RN,  0x1.39ed7ad92493ep+887,   -0x1.30596de6260f4p-4,  -0x1.aace66p-3, INEXACT)
T(RN,   0x1.bcebc96e3241p+887,   -0x1.4e66b77f9b487p-1,   0x1.7cde3cp-2, INEXACT)
T(RN,  0x1.3c13e897640e6p+887,   -0x1.596d3c7275ceep-3,   0x1.cb7dcep-7, INEXACT)
T(RN,   0x1.ec09f5186ca3p+887,    0x1.90096ff288cccp-2,   0x1.b135cep-3, INEXACT)
T(RN,  0x1.298ed65b64857p+887,   -0x1.e3db8b31599a7p-1,   0x1.4bd9b2p-2, INEXACT)
T(RN,  0x1.d8437bda07d63p+887,   -0x1.ff0d1ac0083ffp-1,  -0x1.a53052p-5, INEXACT)
T(RN,  0x1.a5528f21fd6ebp+887,    0x1.f793edf450417p-1,  -0x1.e68904p-3, INEXACT)
T(RN,  0x1.ab54bb3917947p+887,   -0x1.b4d041550495cp-1,   -0x1.a3b8fp-3, INEXACT)
T(RN,  0x1.3544c67c29ef2p+887,   -0x1.30aa96ccdc363p-2,  -0x1.7d4d16p-2, INEXACT)
T(RN,  0x1.cfa679e205708p+888,    -0x1.f53f275f1061p-3,   0x1.baf094p-3, INEXACT)
T(RN,  0x1.109df9607c739p+888,   -0x1.422597b390099p-1,  -0x1.1db5a6p-2, INEXACT)
T(RN,  0x1.2339e8e7b2d72p+888,   -0x1.0c4c5e7bc319ep-2,   0x1.849ca8p-4, INEXACT)
T(RN,  0x1.145e36bc3b067p+888,   -0x1.0628952a61f26p-2,   0x1.a9d1f8p-2, INEXACT)
T(RN,  0x1.70008a768df81p+888,    0x1.16487a5cc75fap-1,   0x1.2a8316p-4, INEXACT)
T(RN,  0x1.7613c574145abp+888,    0x1.388a2c323926ap-3,   0x1.a974cep-4, INEXACT)
T(RN,  0x1.6019f4e87420bp+888,    0x1.e565c2b5371d7p-1,   0x1.ff3beap-2, INEXACT)
T(RN,   0x1.5ce427f9ed5ep+888,   0x1.21b015e4eaa67p-10,  -0x1.3bafcep-5, INEXACT)
T(RN,  0x1.92819bcc2d3bep+888,    0x1.e1f40ef292221p-3,  -0x1.e882bep-2, INEXACT)
T(RN,  0x1.211182c793f9fp+888,   -0x1.f98065bb6ebb3p-1,   0x1.1eb7dcp-2, INEXACT)
T(RN,  0x1.63daeee7ec211p+889,   -0x1.29296645ef2b1p-3,   0x1.66bcacp-2, INEXACT)
T(RN,  0x1.da0b6a6b8d742p+889,    0x1.c882328830b88p-4,   0x1.c548c8p-9, INEXACT)
T(RN,  0x1.9773eb0e832a4p+889,    0x1.c9eb93645c2d2p-1,  -0x1.892642p-5, INEXACT)
T(RN,  0x1.ef7938e7948a3p+889,   -0x1.f9cbd3291735bp-1,    0x1.54c54p-2, INEXACT)
T(RN,  0x1.b13a2c5edb95ep+889,   -0x1.3ad63a0ac5964p-2,    0x1.b2b68p-2, INEXACT)
T(RN,  0x1.60a5c2a658da9p+889,   -0x1.a87c46b0af07cp-2,   0x1.c86cd4p-3, INEXACT)
T(RN,  0x1.38e8d37c7df07p+889,    0x1.4fcb3189bcd1ap-1,   0x1.35649ep-2, INEXACT)
T(RN,  0x1.e173bf8e3aad4p+889,      0x1.fb701feb06ap-3,   0x1.b4da46p-2, INEXACT)
T(RN,  0x1.ff7281b5a9c18p+889,    0x1.7e61d7e9d8459p-1,  -0x1.ff8098p-2, INEXACT)
T(RN,  0x1.96581c67e4b28p+889,    0x1.c12185e1bc92fp-1,  -0x1.0684e4p-3, INEXACT)
T(RN,  0x1.23b4a0db78b3ep+890,   -0x1.42decf58cec0ap-7,   0x1.64c442p-2, INEXACT)
T(RN,   0x1.8e7d348ff6a9p+890,    -0x1.6a351af606cap-1,  -0x1.032d7ep-3, INEXACT)
T(RN,  0x1.5867728ad7114p+890,   -0x1.735d45243c1ffp-2,  -0x1.6b8fc2p-3, INEXACT)
T(RN,  0x1.ee258500b6583p+890,    0x1.78d83f6cb6615p-1,   0x1.0dbaa6p-2, INEXACT)
T(RN,   0x1.8f21483f3fddp+890,   -0x1.fee1baece9b2fp-1,  -0x1.20e30ep-2, INEXACT)
T(RN,  0x1.6e4768a0d1dc4p+890,   -0x1.5535ec125a3eap-6,   0x1.e883b4p-2, INEXACT)
T(RN,  0x1.4fc2909745c26p+890,   -0x1.ff0c57e3fb461p-2,  -0x1.aef64ep-2, INEXACT)
T(RN,  0x1.54587da92621cp+890,   -0x1.8d2c372682a68p-1,  -0x1.252eb4p-3, INEXACT)
T(RN,  0x1.708b948d080b8p+890,    0x1.f8fe60e271a22p-1,   0x1.dab88cp-4, INEXACT)
T(RN,  0x1.1feb4cabce41bp+890,    0x1.d46977e5a06dcp-2,   0x1.4fcd7ap-2, INEXACT)
T(RN,  0x1.ecdb301299c9dp+891,    0x1.19c63c518d207p-1,   -0x1.c69ddp-3, INEXACT)
T(RN,  0x1.d458f6c3205fep+891,    0x1.40e2e293a3738p-2,  -0x1.c8b78cp-2, INEXACT)
T(RN,  0x1.804518834a3c8p+891,    0x1.89105bd5bbc52p-1,  -0x1.a70538p-3, INEXACT)
T(RN,  0x1.a9b6232750148p+891,   -0x1.8a8c6f58fdecbp-2,  -0x1.efdc74p-2, INEXACT)
T(RN,  0x1.dd8191275e4ffp+891,   -0x1.7ec4bf9c509b8p-2,  -0x1.045fb4p-2, INEXACT)
T(RN,  0x1.e351d58cf1a96p+891,   -0x1.7e2286d9c35ffp-2,   -0x1.d2fcep-2, INEXACT)
T(RN,  0x1.a04daefe2a226p+891,   -0x1.6025b5a0fb1e1p-1,   0x1.d0f09cp-2, INEXACT)
T(RN,   0x1.19cf1c2ce5c3p+891,     0x1.8eac32cb8a6fp-4,   0x1.50264cp-4, INEXACT)
T(RN,  0x1.b6908a1b7a8dcp+891,   -0x1.1a677478400c7p-3,  -0x1.ff910ep-2, INEXACT)
T(RN,  0x1.d923eaa9789b5p+891,   -0x1.dafcbc5ed96e8p-1,   0x1.267f44p-2, INEXACT)
T(RN,  0x1.3668cad294c9dp+892,   -0x1.b4090d178f907p-1,  -0x1.071158p-5, INEXACT)
T(RN,  0x1.b6896a4d7d54ap+892,     0x1.f38807bc4a5fp-6,  -0x1.81c63cp-2, INEXACT)
T(RN,  0x1.055fa3647ced1p+892,   -0x1.b821662f57537p-1,  -0x1.054904p-3, INEXACT)
T(RN,  0x1.d950ad12c987dp+892,   -0x1.08c11d8a93d03p-1,    0x1.fb283p-2, INEXACT)
T(RN,  0x1.b173dfa8d6422p+892,   -0x1.c1e60b72f700ap-1,   0x1.a3c4bep-3, INEXACT)
T(RN,  0x1.2d77ef8a42f11p+892,   -0x1.f398a995e9422p-1,  -0x1.3eac24p-3, INEXACT)
T(RN,  0x1.9ffda3cf1e6e4p+892,    0x1.cc84078f9151ep-1,   0x1.634e38p-2, INEXACT)
T(RN,  0x1.91d50ff0025d6p+892,   -0x1.ff7dbafc5f72dp-1,  -0x1.b3decep-5, INEXACT)
T(RN,  0x1.df0612522732ep+892,    0x1.112e1497f7038p-2,   0x1.92bc32p-4, INEXACT)
T(RN,  0x1.89f0d95a9c651p+892,   -0x1.de54999873a38p-1,  -0x1.4772fap-2, INEXACT)
T(RN,  0x1.b091f5c206fc2p+893,    -0x1.77cb7442c8b1p-1,   0x1.610c42p-2, INEXACT)
T(RN,  0x1.3b29789c4f44bp+893,    0x1.cebc7fa74cf82p-2,  -0x1.dde96cp-2, INEXACT)
T(RN,  0x1.ca0a6c180c734p+893,    0x1.dd350ae1b5b95p-9,   0x1.d0808cp-2, INEXACT)
T(RN,  0x1.b8213b6b61bacp+893,     0x1.5ab06ab5f032p-2,   -0x1.03d25p-3, INEXACT)
T(RN,  0x1.a011732aa30d2p+893,    0x1.915b801c1d2bep-1,  -0x1.4d552cp-2, INEXACT)
T(RN,  0x1.a69fb64e6a9ecp+893,     -0x1.91a129a1d69p-1,  -0x1.330f52p-8, INEXACT)
T(RN,  0x1.1f61406e31468p+893,   -0x1.f13df67aebe12p-4,  -0x1.bafdb6p-2, INEXACT)
T(RN,   0x1.84288c0f944ap+893,    0x1.d3c639241d89cp-1,   0x1.3f2d18p-3, INEXACT)
T(RN,  0x1.fe9c812f1390cp+893,    0x1.7ee0e6d2a68ddp-1,   0x1.a2321ep-3, INEXACT)
T(RN,  0x1.b23201897fe38p+893,   -0x1.9d66aec2034b4p-1,   -0x1.b3bb4p-2, INEXACT)
T(RN,  0x1.f23510e9c71b3p+894,    0x1.ff41c6203976ep-1,   0x1.b634a6p-2, INEXACT)
T(RN,  0x1.3381d87077073p+894,    0x1.b1a7040c17f9cp-1,  -0x1.7dd88ep-2, INEXACT)
T(RN,  0x1.2600e4f4c6b35p+894,   -0x1.e6c3513529d15p-1,  -0x1.2848d4p-2, INEXACT)
T(RN,  0x1.72279e4d840d3p+894,   -0x1.c7522add69b25p-2,  -0x1.55c2d2p-3, INEXACT)
T(RN,  0x1.cfca919aac04cp+894,     0x1.505bc7425719p-1,   0x1.d476b6p-3, INEXACT)
T(RN,  0x1.5294648492534p+894,   -0x1.fb0db10328632p-1,  -0x1.0a979cp-2, INEXACT)
T(RN,  0x1.7a2656b13805dp+894,   -0x1.ac4a497f73217p-2,   0x1.9d52aep-5, INEXACT)
T(RN,   0x1.cacd57beefa9p+894,   -0x1.f0f1bae4f823ep-1,   0x1.f90e38p-5, INEXACT)
T(RN,  0x1.b74fc6ebba96cp+894,   -0x1.f99946fedb8a7p-1,   0x1.b9910ap-3, INEXACT)
T(RN,  0x1.e67bae1dbac4ep+894,   -0x1.2287449010817p-1,   0x1.6ce08ep-4, INEXACT)
T(RN,  0x1.59b65511d10a6p+895,   -0x1.db64e11e1a785p-1,  -0x1.349896p-2, INEXACT)
T(RN,  0x1.d3e54006af44bp+895,   -0x1.deeb003413316p-1,  -0x1.8bc55ep-3, INEXACT)
T(RN,  0x1.d2122ce64e25dp+895,    0x1.acd8f57b2fae3p-1,  -0x1.ac9436p-4, INEXACT)
T(RN,  0x1.044d3cda39755p+895,    0x1.048214b4df9a1p-1,    0x1.64d0ep-4, INEXACT)
T(RN,  0x1.7734a7d3ade75p+895,   -0x1.2f8c9bce43dbbp-3,  -0x1.c5d704p-3, INEXACT)
T(RN,  0x1.7946d793434e7p+895,   -0x1.ef5794b927633p-1,   0x1.aa3f5ep-7, INEXACT)
T(RN,  0x1.773ac3ef0fbcep+895,   -0x1.767a7bdc82999p-2,  -0x1.3b07bap-2, INEXACT)
T(RN,  0x1.0a7c9679f1761p+895,   -0x1.97c23f5ffaf4ep-1,  -0x1.27f4bep-3, INEXACT)
T(RN,  0x1.97a89be0c0f89p+895,    0x1.523f9f81cb44ap-2,  -0x1.35fc8ap-2, INEXACT)
T(RN,  0x1.735b28219d70ep+895,    0x1.973655f874173p-1,   0x1.590b7ap-2, INEXACT)
T(RN,  0x1.b1df6ab90a83ap+896,   -0x1.a59a0e24f2864p-1,   0x1.61b882p-5, INEXACT)
T(RN,  0x1.c31df28c59c4ap+896,   -0x1.fa264f9be976ep-1,   -0x1.77b6bp-2, INEXACT)
T(RN,  0x1.15178d08bf574p+896,    0x1.8f378df69bf0ep-1,  -0x1.84b86cp-3, INEXACT)
T(RN,  0x1.f9e1061ef7fbep+896,   -0x1.81ae62bc19939p-1,   0x1.cc9bb4p-2, INEXACT)
T(RN,  0x1.f40172c751831p+896,   -0x1.d78981daf2417p-1,   0x1.0debacp-2, INEXACT)
T(RN,  0x1.49dbf2c4b292ep+896,   -0x1.0216349431b42p-1,  -0x1.c7acdap-4, INEXACT)
T(RN,  0x1.dbd0418fcb6c8p+896,   -0x1.27a6dfd514ebep-2,    0x1.93f03p-2, INEXACT)
T(RN,  0x1.be9304e6f5f26p+896,      0x1.90e83a63216p-1,   0x1.f925dap-2, INEXACT)
T(RN,  0x1.cb0216bc8e54fp+896,   -0x1.115607f290fc5p-5,  -0x1.118036p-2, INEXACT)
T(RN,  0x1.3ed3f80a3ba71p+896,    0x1.ee65064e6bc5dp-1,    0x1.fbe88p-2, INEXACT)
T(RN,  0x1.8330a025ef714p+897,    0x1.ef379ac02ba2cp-1,   0x1.834bb6p-4, INEXACT)
T(RN,  0x1.6737dd2efc205p+897,   -0x1.dbab469f930afp-1,    0x1.43c0bp-4, INEXACT)
T(RN,  0x1.addc7c304d49ap+897,    0x1.8e3cd129f8286p-2,  -0x1.be377cp-2, INEXACT)
T(RN,  0x1.5b1a6bcca7fadp+897,    -0x1.8ca7e3c52466p-1,   0x1.b40466p-2, INEXACT)
T(RN,   0x1.29fe9394791cp+897,   -0x1.ac3a1e89f6682p-1,   0x1.6f610cp-4, INEXACT)
T(RN,  0x1.81790daeae19fp+897,    0x1.2f04aab0feb89p-2,   -0x1.7b253p-2, INEXACT)
T(RN,  0x1.a7522c202a85bp+897,    0x1.367675966198bp-1,  -0x1.76ec38p-3, INEXACT)
T(RN,   0x1.e5afaaeef395p+897,    0x1.2717dd191652ap-1,  -0x1.fdd968p-4, INEXACT)
T(RN,  0x1.058979d69e193p+897,     0x1.4a905bc3a179p-1,   0x1.c5a01cp-2, INEXACT)
T(RN,   0x1.948a10890aabp+897,    0x1.a3026e868f066p-1,   0x1.b155c2p-2, INEXACT)
T(RN,  0x1.a00f0fdb748a8p+898,   -0x1.8c5852ee801c8p-1,  -0x1.090a8cp-2, INEXACT)
T(RN,  0x1.09d9d2d7ea211p+898,    0x1.b467e75d96e0ap-2,   0x1.b357aap-2, INEXACT)
T(RN,  0x1.d7f73c2a5d713p+898,    0x1.e612af959cf03p-1,  -0x1.538f22p-4, INEXACT)
T(RN,   0x1.16940fe54ddep+898,    0x1.445dbec829b5dp-2,   0x1.77ce68p-2, INEXACT)
T(RN,  0x1.93a0d2e085a27p+898,   -0x1.fae25d0fb41ccp-1,  -0x1.937f8cp-3, INEXACT)
T(RN,  0x1.cc9e5136e71b3p+898,   -0x1.c1927a321bf94p-3,   0x1.2b65dep-2, INEXACT)
T(RN,  0x1.fb32374608c3cp+898,    0x1.65168d8f619ccp-1,  -0x1.424b92p-4, INEXACT)
T(RN,  0x1.7144589ff6955p+898,    0x1.f31e5ffcc5c93p-1,   0x1.d4763ap-2, INEXACT)
T(RN,  0x1.844bc5bbf8a47p+898,   -0x1.fff0e6344f435p-1,   0x1.92082ep-2, INEXACT)
T(RN,  0x1.07ac301c9b56ep+898,   -0x1.d9ef3c6d3a2ebp-4,   0x1.71b674p-2, INEXACT)
T(RN,  0x1.cf9ac9554e274p+899,    0x1.7ca82765544e7p-1,  -0x1.994f7ap-2, INEXACT)
T(RN,  0x1.1108633f60921p+899,    0x1.8dec30a4d69d3p-4,  -0x1.b8e362p-3, INEXACT)
T(RN,  0x1.6eb5bf65a02cap+899,   -0x1.069b39e4ced9bp-1,  -0x1.319a7ep-3, INEXACT)
T(RN,  0x1.9cff8c20f2788p+899,    0x1.881d034dbd98ep-2,  -0x1.275ff2p-2, INEXACT)
T(RN,  0x1.117786c7333f3p+899,   -0x1.df0b770c4d623p-1,    0x1.5c914p-2, INEXACT)
T(RN,  0x1.f075d242b1256p+899,   -0x1.d21044631aadbp-1,   0x1.2d7008p-2, INEXACT)
T(RN,  0x1.7bcc39ff14fdcp+899,   -0x1.e8650ffa9b0ccp-1,  -0x1.776cc4p-2, INEXACT)
T(RN,  0x1.018357ebd331ep+899,    0x1.423ad977d7cb3p-2,     0x1.fbb8p-5, INEXACT)
T(RN,  0x1.5a58e4c01fd5dp+899,    0x1.f4a341a745adep-1,   0x1.973154p-4, INEXACT)
T(RN,  0x1.8643d9e4c4112p+899,    0x1.6c0f8b48accf2p-1,  -0x1.d4cf32p-3, INEXACT)
T(RN,  0x1.534839a0e8f21p+900,    0x1.fb1b8029e98e1p-1,   0x1.22e614p-2, INEXACT)
T(RN,  0x1.9a9715b84fd5fp+900,    0x1.5db91d71556bdp-1,  -0x1.e87ed2p-2, INEXACT)
T(RN,   0x1.f24852018979p+900,    0x1.fe134920888bcp-1,   0x1.aea338p-4, INEXACT)
T(RN,  0x1.23d07c489d1c7p+900,    0x1.ff1f4a237f642p-1,  -0x1.ab02bap-3, INEXACT)
T(RN,  0x1.b3aea9327123dp+900,   -0x1.e59161cc4a441p-1,  -0x1.c2a646p-3, INEXACT)
T(RN,  0x1.9564c410da284p+900,    0x1.d6f9ac31a7345p-1,   0x1.b45bbep-3, INEXACT)
T(RN,  0x1.b8c47aabfcb78p+900,   -0x1.7bc8e3a02dc71p-1,  -0x1.4a785ep-8, INEXACT)
T(RN,  0x1.7f76bad0f1c2bp+900,   -0x1.83bf2156194f2p-1,   0x1.e65806p-3, INEXACT)
T(RN,  0x1.baf9999b3b062p+900,   -0x1.a3ab641c8fe57p-1,   0x1.abe08cp-2, INEXACT)
T(RN,  0x1.7354d88a7dce4p+900,   -0x1.e23f39a01bacdp-1,  -0x1.8825d6p-2, INEXACT)
T(RN,  0x1.1380e581ccc62p+901,    0x1.bebfb9fdea271p-1,   0x1.319b0cp-2, INEXACT)
T(RN,  0x1.ab80ab37a3a7ap+901,   -0x1.ff3df92f1450ep-1,  -0x1.f09fdap-3, INEXACT)
T(RN,  0x1.7a597bb0d33bcp+901,    0x1.7f93ccdb4f207p-1,  -0x1.79e664p-2, INEXACT)
T(RN,   0x1.e9215aaee90fp+901,    0x1.a726b3b8262bcp-2,   0x1.f6221ap-3, INEXACT)
T(RN,  0x1.2c3c98bbc5347p+901,   -0x1.d41b98c8dd7b2p-1,   0x1.8eccb8p-3, INEXACT)
T(RN,  0x1.bdb00aac19232p+901,   -0x1.0626590c2c696p-2,   0x1.5694b6p-2, INEXACT)
T(RN,  0x1.92dca189ec246p+901,    0x1.6b1f1e9d9a886p-2,  -0x1.53bf58p-6, INEXACT)
T(RN,  0x1.79e9b2ce419eap+901,    0x1.db792d2bc0181p-1,   -0x1.a8fd3p-3, INEXACT)
T(RN,  0x1.3cf95f24567a8p+901,    0x1.3a55b3e68ec75p-5,   0x1.a19762p-2, INEXACT)
T(RN,  0x1.c76a95ed4edbap+901,    0x1.dcca739f0db1dp-9,  -0x1.909762p-2, INEXACT)
T(RN,  0x1.64f04c64e4019p+902,   -0x1.7c08a8274b2bbp-1,   0x1.1e7268p-4, INEXACT)
T(RN,  0x1.fed5626645879p+902,    0x1.32c57831824bbp-1,   -0x1.5cd03p-4, INEXACT)
T(RN,  0x1.49245f36680dfp+902,   -0x1.0fd6c232b5c8fp-3,    0x1.b7d81p-2, INEXACT)
T(RN,  0x1.c5881cabdefbep+902,   -0x1.d2e497991029dp-1,   0x1.ef5398p-2, INEXACT)
T(RN,  0x1.a3f9330aa78e3p+902,    -0x1.f3d7b2fb899ep-1,   0x1.b63f06p-4, INEXACT)
T(RN,  0x1.15cb967eca065p+902,    0x1.00553603eee76p-2,   -0x1.89352p-6, INEXACT)
T(RN,  0x1.27c9ecfbf34d6p+902,    0x1.dd626a1b2d62fp-1,    0x1.b77e8p-2, INEXACT)
T(RN,  0x1.ac77755ffeae5p+902,   -0x1.25955f2841681p-1,    0x1.2be4ep-3, INEXACT)
T(RN,  0x1.c76f06db6e3a6p+902,   -0x1.b1de8006f15ccp-2,   0x1.0958aap-6, INEXACT)
T(RN,  0x1.888da84bb20f9p+902,    0x1.02c39934395dbp-1,  -0x1.cff2ccp-4, INEXACT)
T(RN,  0x1.956a570840308p+903,   -0x1.93fa76420c6eep-1,  -0x1.99b124p-2, INEXACT)
T(RN,  0x1.26cea02a400b2p+903,    0x1.e838c6a8e254bp-2,  -0x1.612012p-2, INEXACT)
T(RN,    0x1.373873bc657p+903,   -0x1.9f9376dfaf49ap-1,  -0x1.feefa8p-6, INEXACT)
T(RN,  0x1.fa371a8c39612p+903,   -0x1.0b4353129d4a9p-1,  -0x1.20465ep-2, INEXACT)
T(RN,  0x1.085ac76dcf5e4p+903,    0x1.3f4a3c6ae2943p-1,   0x1.970edap-2, INEXACT)
T(RN,  0x1.97e46a7712e56p+903,   -0x1.efca765494672p-2,   0x1.651358p-4, INEXACT)
T(RN,  0x1.ca7b85f9d5521p+903,    0x1.fb253d24d4a7fp-1,  -0x1.f2a678p-2, INEXACT)
T(RN,  0x1.bac11513f81bcp+903,    0x1.b2c882827e152p-2,   0x1.442282p-2, INEXACT)
T(RN,    0x1.f4279d54ae7p+903,   -0x1.6ec867ae7d2f5p-1,   0x1.a05bc6p-2, INEXACT)
T(RN,  0x1.13ffe39192eaep+903,    0x1.28f5adde5add7p-2,   0x1.c2bf34p-5, INEXACT)
T(RN,  0x1.3e4cf69474588p+904,    0x1.92681d9d08944p-2,   -0x1.f8236p-6, INEXACT)
T(RN,  0x1.e236c1c020b5ep+904,   -0x1.fc9d28b9d0b6bp-1,  -0x1.b414a4p-2, INEXACT)
T(RN,  0x1.04744835b9a47p+904,   -0x1.cc8e7dbe63055p-1,   0x1.ef56fcp-3, INEXACT)
T(RN,  0x1.7aff960d5b48cp+904,   -0x1.06f222d6a20d4p-2,  -0x1.e5cba6p-3, INEXACT)
T(RN,  0x1.8410e3574a126p+904,   -0x1.f0fdc9db1e1a4p-1,  -0x1.7d77b2p-2, INEXACT)
T(RN,  0x1.ed134686b0eebp+904,    0x1.001f06075fea9p-1,   0x1.d67112p-5, INEXACT)
T(RN,  0x1.374b855a3cffep+904,    0x1.bc0312bd620a3p-4,  -0x1.978ce8p-2, INEXACT)
T(RN,    0x1.de58d13def9p+904,    -0x1.0b9e1d9215bcp-5,   0x1.3de116p-2, INEXACT)
T(RN,  0x1.197730b04ebe7p+904,   -0x1.ffea529d9d2e5p-1,  -0x1.7ef92ap-2, INEXACT)
T(RN,  0x1.2974404ff9d11p+904,    0x1.f5a4ef53e764bp-1,    0x1.e1093p-3, INEXACT)
T(RN,  0x1.068f54b7c711cp+905,    0x1.c627687d1e3fcp-1,  -0x1.02267ep-3, INEXACT)
T(RN,  0x1.bedf5af1a5454p+905,    0x1.fd4685333c96fp-1,  -0x1.49e6cep-3, INEXACT)
T(RN,  0x1.5f8782332e9b5p+905,   -0x1.52d208c98eb51p-3,    0x1.5bf46p-2, INEXACT)
T(RN,  0x1.cc909a50ed49bp+905,    0x1.618c3be7999ccp-3,   0x1.793522p-2, INEXACT)
T(RN,  0x1.76add305f111ep+905,   -0x1.e801af4efcea3p-2,   0x1.14e924p-3, INEXACT)
T(RN,  0x1.e3c0c575081dap+905,    0x1.92f11745e87f4p-1,  -0x1.ced90ap-2, INEXACT)
T(RN,  0x1.14dbc07656c86p+905,    0x1.fdf95c60f02ddp-3,   -0x1.7c947p-2, INEXACT)
T(RN,  0x1.a344f714d4047p+905,   -0x1.c69de8031095bp-1,   0x1.9bbeeap-2, INEXACT)
T(RN,  0x1.daef4c4640efep+905,   -0x1.d83d275be388bp-1,  -0x1.4135cap-2, INEXACT)
T(RN,  0x1.0b0b49a14f8a7p+905,    -0x1.f94a2495adb8p-1,   0x1.3daf64p-4, INEXACT)
T(RN,  0x1.31dbf19ac1b63p+906,   -0x1.3248d3a9ae7abp-1,   0x1.6739e6p-4, INEXACT)
T(RN,  0x1.ee63193b21852p+906,    0x1.f0f1840a5d7ecp-1,  -0x1.3094e8p-2, INEXACT)
T(RN,  0x1.5aa3792688fe4p+906,   -0x1.6ffae716b6041p-3,   0x1.ca5b4ep-6, INEXACT)
T(RN,   0x1.a76e02c78488p+906,    0x1.fc13a08f759b8p-1,   0x1.960d4ap-4, INEXACT)
T(RN,  0x1.09b304bfb9e9ep+906,    0x1.76d4c980417ddp-1,  -0x1.e93a74p-2, INEXACT)
T(RN,  0x1.e3e25c27cde48p+906,   -0x1.0c7231258c451p-1,    0x1.dc23ap-4, INEXACT)
T(RN,  0x1.b2624817537ecp+906,   -0x1.0a16e835ea9c7p-4,   0x1.656eb2p-2, INEXACT)
T(RN,  0x1.542f13f23fd1ep+906,    0x1.7df57e1c98e16p-3,  -0x1.b35778p-2, INEXACT)
T(RN,  0x1.d134a92c170adp+906,    0x1.ff081ba19e202p-1,  -0x1.b6e0cep-2, INEXACT)
T(RN,  0x1.32d9fa3fc15fep+906,     0x1.bd50920a2132p-2,   0x1.49bc9ap-2, INEXACT)
T(RN,  0x1.1731bd4e7630ap+907,   -0x1.f69e385d67021p-2,  -0x1.45ac44p-2, INEXACT)
T(RN,  0x1.055108448645ep+907,    0x1.8758142813716p-1,   0x1.19f27ep-2, INEXACT)
T(RN,  0x1.1a44adcc81814p+907,    0x1.03240eaa14f5bp-2,   0x1.d82cd8p-3, INEXACT)
T(RN,  0x1.de8cedbcaf305p+907,    0x1.f236e7f962e9ep-2,   0x1.bde1a8p-8, INEXACT)
T(RN,  0x1.7743efd00f30ap+907,    0x1.83dd747b18ab4p-1,  -0x1.55f8b4p-3, INEXACT)
T(RN,  0x1.64b2cc4f96962p+907,    0x1.f0496d5d4a6f6p-1,  -0x1.209914p-2, INEXACT)
T(RN,  0x1.3888fcdcd5484p+907,    0x1.ffce3dd14d044p-1,  -0x1.e9f2bap-2, INEXACT)
T(RN,  0x1.4c62b53512d19p+907,    0x1.f91245e8f92f5p-1,   0x1.691f84p-5, INEXACT)
T(RN,  0x1.c05fa0b7f5843p+907,    0x1.f3579ed1da1a2p-1,  -0x1.5d06f2p-2, INEXACT)
T(RN,  0x1.f038cfa1e2c42p+907,   -0x1.a0ef37f4d15eep-1,   0x1.1fb8eep-4, INEXACT)
T(RN,   0x1.d5a1051ccbc4p+908,    0x1.ee95657891b7fp-1,   0x1.fa7494p-2, INEXACT)
T(RN,  0x1.a59a73d492094p+908,    0x1.e08f53811f1dfp-1,   0x1.a60c62p-2, INEXACT)
T(RN,  0x1.1c219cd4292eap+908,   -0x1.25561ffc205f5p-2,  -0x1.c6d00ap-4, INEXACT)
T(RN,  0x1.33c2f4f736374p+908,    -0x1.1d7eb300c5f3p-3,  -0x1.1691e4p-2, INEXACT)
T(RN,  0x1.d96c60fba9be2p+908,   -0x1.8514196b4a35ap-2,   0x1.4bed24p-4, INEXACT)
T(RN,  0x1.cc82f7b20fbbep+908,   -0x1.fba5cf12ee64ap-1,  -0x1.0caa7ep-6, INEXACT)
T(RN,  0x1.f7517cbd2ab28p+908,    0x1.975378f4be8d8p-1,   0x1.dd940cp-2, INEXACT)
T(RN,  0x1.cf1e8a3eb10f8p+908,    0x1.ecca7f1c32937p-1,   0x1.d0722ap-2, INEXACT)
T(RN,  0x1.328f2a71f35e9p+908,    0x1.9a8d2ca2fd26fp-1,   0x1.adcd02p-2, INEXACT)
T(RN,  0x1.e6c058c48c86ap+908,   -0x1.53e0400b4a7bcp-1,   0x1.b78b6ap-2, INEXACT)
T(RN,  0x1.f694e7551c618p+909,   -0x1.6461058e97a79p-1,   0x1.f2141ep-5, INEXACT)
T(RN,    0x1.700eaafbe59p+909,    0x1.d0bf7557efa24p-4,   0x1.d8eeb4p-3, INEXACT)
T(RN,  0x1.15b9c213081a6p+909,    0x1.6a496b338c582p-1,   0x1.dd39dcp-2, INEXACT)
T(RN,  0x1.9500d974fe48ep+909,   -0x1.b33faf9aa0422p-1,   0x1.262b46p-4, INEXACT)
T(RN,  0x1.17ec23331049cp+909,   -0x1.6cf5bfe9e7c22p-1,  -0x1.5d7b34p-7, INEXACT)
T(RN,  0x1.d4d84dab00ba4p+909,   -0x1.e5cbbbb70eb1bp-1,   -0x1.da198p-3, INEXACT)
T(RN,  0x1.29da3780d2378p+909,   -0x1.adb1eb4bb40f2p-1,  -0x1.a41da8p-4, INEXACT)
T(RN,   0x1.2dfaf01900b8p+909,    0x1.f1ac26b625934p-2,  -0x1.32aaf6p-2, INEXACT)
T(RN,  0x1.3a150778f8fdcp+909,   -0x1.fc383159cbb9bp-1,   0x1.763328p-2, INEXACT)
T(RN,   0x1.e1dd649dc121p+909,   -0x1.f989fa00be2f5p-1,  -0x1.9f5eaep-3, INEXACT)
T(RN,  0x1.188088be737adp+910,   -0x1.b7cb84ca81a15p-3,  -0x1.865a12p-2, INEXACT)
T(RN,  0x1.e519a289f0691p+910,    0x1.1c9ad50c74ea7p-3,    -0x1.d4c7p-4, INEXACT)
T(RN,  0x1.89d26cc84c3fep+910,   -0x1.e224fe1644814p-1,   0x1.d12b3ep-3, INEXACT)
T(RN,  0x1.e2ce272bd40a8p+910,   -0x1.e15e33681375bp-1,  -0x1.94f564p-2, INEXACT)
T(RN,   0x1.d9a27cc1fb4bp+910,    0x1.e69963de1d44bp-1,   0x1.e18f3cp-2, INEXACT)
T(RN,  0x1.ad79a5285a74fp+910,    0x1.a24b415fd6327p-3,   0x1.c242b2p-2, INEXACT)
T(RN,  0x1.00ee67fc823cbp+910,   -0x1.b2df95297646fp-2,  -0x1.16acd4p-3, INEXACT)
T(RN,  0x1.2699e95245dfcp+910,    0x1.c4a5a561aab7ap-1,   0x1.25abecp-3, INEXACT)
T(RN,  0x1.b1cb21f0d9966p+910,     0x1.a703e0a09a65p-1,   0x1.99d04ap-2, INEXACT)
T(RN,  0x1.8f2f7e89a2f73p+910,   -0x1.e5fedd4291fa1p-1,  -0x1.543a14p-4, INEXACT)
T(RN,  0x1.1382a0b65b39dp+911,   -0x1.68c7e0331238bp-2,  -0x1.4bc2e4p-3, INEXACT)
T(RN,  0x1.1d355d453fe62p+911,    0x1.5c458f33a2a7cp-2,   0x1.3fcee6p-2, INEXACT)
T(RN,   0x1.ee943b6d525fp+911,     0x1.ccfd709cf314p-1,   0x1.6fca34p-2, INEXACT)
T(RN,  0x1.f4e6457b7410cp+911,    0x1.1b282f78783e7p-2,  -0x1.bc4d46p-2, INEXACT)
T(RN,  0x1.fb2c69c933f8fp+911,   -0x1.a5497950ba036p-1,  -0x1.adf6b6p-3, INEXACT)
T(RN,  0x1.f43824f709d1ap+911,    0x1.f94aff48359f9p-1,   0x1.38bfbep-3, INEXACT)
T(RN,  0x1.5165821434aedp+911,   -0x1.3f84dc35afacep-3,   -0x1.51b82p-2, INEXACT)
T(RN,  0x1.c9a63ce732cecp+911,    0x1.e494b42a4014ap-1,   0x1.f120cep-3, INEXACT)
T(RN,  0x1.05b25251e37dep+911,   -0x1.193e6fdf518a7p-1,  -0x1.8eabbap-8, INEXACT)
T(RN,   0x1.0ea21a284acep+911,   -0x1.85f1f65f4da97p-1,   0x1.2976a6p-3, INEXACT)
T(RN,  0x1.de7f0a30aacf4p+912,   -0x1.a644fd4dea43dp-2,   0x1.29bddcp-3, INEXACT)
T(RN,   0x1.e74107f75233p+912,    0x1.6b017de5d287dp-3,   0x1.57723cp-2, INEXACT)
T(RN,  0x1.f875a36813ff6p+912,   -0x1.369f90242e8d1p-1,   0x1.10f1eep-2, INEXACT)
T(RN,  0x1.becf53e3a5d6cp+912,   -0x1.70c01e182a41ep-5,  -0x1.95e7f8p-3, INEXACT)
T(RN,  0x1.431b6fd141d6ap+912,   -0x1.d4d31f3c5f666p-2,  -0x1.8e6544p-3, INEXACT)
T(RN,  0x1.7f8c9dd5236dcp+912,   -0x1.2f09faa4dc15fp-5,   0x1.f43d78p-5, INEXACT)
T(RN,  0x1.5828218beefc3p+912,   -0x1.53d15f873f7cfp-1,   0x1.543192p-2, INEXACT)
T(RN,  0x1.b0934c3501024p+912,   -0x1.253afa75a3ecfp-1,   0x1.3eebb6p-4, INEXACT)
T(RN,  0x1.92fc0f18f61dcp+912,    0x1.ffbb4016f01fap-1,  -0x1.4813a2p-4, INEXACT)
T(RN,  0x1.89955170936efp+912,   -0x1.974055572cc4fp-3,   0x1.2b6b98p-6, INEXACT)
T(RN,  0x1.36579c098ea57p+913,   -0x1.2aeed977d1ff1p-3,   0x1.7850e6p-2, INEXACT)
T(RN,  0x1.4e45f03602bf8p+913,   -0x1.4df6d7e383635p-1,  -0x1.a2d03ep-2, INEXACT)
T(RN,  0x1.b306bd8253137p+913,    0x1.2dce8015d82b6p-2,   0x1.cf3848p-2, INEXACT)
T(RN,  0x1.831f74cac2c9fp+913,    0x1.edc0acbecd592p-2,   0x1.5377ecp-9, INEXACT)
T(RN,  0x1.ffca495fd3155p+913,     0x1.cce386173458p-9,   0x1.4f481cp-4, INEXACT)
T(RN,  0x1.1a4fd4ad42f45p+913,   -0x1.4c10664fc52d9p-1,  -0x1.51a988p-2, INEXACT)
T(RN,  0x1.bad40b4503acdp+913,   -0x1.b23b4c2892992p-2,   0x1.876726p-3, INEXACT)
T(RN,  0x1.d140d0419b17ep+913,    0x1.eaa3b2bc17ec6p-1,    0x1.61331p-2, INEXACT)
T(RN,  0x1.50d59f9c25131p+913,   -0x1.0f9929ad50b68p-1,   0x1.d5078cp-2, INEXACT)
T(RN,  0x1.e1a98c7601fdep+913,    0x1.f35e4f7ea4095p-1,  -0x1.02b128p-3, INEXACT)
T(RN,  0x1.cc2f3ae67fffap+914,   -0x1.666305cbfb9f2p-1,  -0x1.47d7fcp-3, INEXACT)
T(RN,  0x1.7cd5d5e0152cbp+914,    0x1.bd4566f5c2f3ap-1,   0x1.2bc26cp-2, INEXACT)
T(RN,    0x1.2257b977f08p+914,   -0x1.fffebb63339c7p-1,  -0x1.c8db6cp-4, INEXACT)
T(RN,  0x1.103a9dc05ac32p+914,   -0x1.40a64b7e4903ap-1,   0x1.c62254p-4, INEXACT)
T(RN,   0x1.a7018751dc1ep+914,    0x1.fa7d6eafc189ep-1,   0x1.ddb17ap-2, INEXACT)
T(RN,  0x1.365b327743f68p+914,   -0x1.f3ea1326472c2p-4,   0x1.8a1ce6p-2, INEXACT)
T(RN,  0x1.39da276a3030ep+914,    0x1.83e8f34244aadp-1,   0x1.0d90b6p-4, INEXACT)
T(RN,  0x1.c7e90b011771ep+914,   -0x1.27825cfaea186p-4,  -0x1.ad303ep-2, INEXACT)
T(RN,   0x1.d4900564ca73p+914,    0x1.47efebea9c9a6p-3,   0x1.6f08ecp-2, INEXACT)
T(RN,  0x1.9f83e48a6fa65p+914,   -0x1.be86116389ff8p-4,  -0x1.a0a87ap-3, INEXACT)
T(RN,  0x1.577cc130a0746p+915,    0x1.e12a9fcbcdcaap-1,  -0x1.15c6bep-4, INEXACT)
T(RN,  0x1.bb622f5aa8892p+915,   -0x1.c810fd043f1dbp-1,  -0x1.58af36p-3, INEXACT)
T(RN,  0x1.46c3516491372p+915,    0x1.b7955eee7b9f7p-1,  -0x1.e5c18ep-3, INEXACT)
T(RN,  0x1.8cde1bcfd459ep+915,   -0x1.c3ded01847d8ep-1,  -0x1.1d10a6p-2, INEXACT)
T(RN,  0x1.dfa4066a35b18p+915,    0x1.ae1df6a76768ep-1,   0x1.77c1fap-3, INEXACT)
T(RN,  0x1.0dc19347e8513p+915,   -0x1.72df62be8e7ffp-2,   0x1.053b8cp-2, INEXACT)
T(RN,  0x1.474808ac0fcc9p+915,   -0x1.c2012d9e143fap-1,  -0x1.e4b74ap-2, INEXACT)
T(RN,  0x1.97789af3df611p+915,    0x1.1adc378b294f8p-2,  -0x1.79333cp-3, INEXACT)
T(RN,  0x1.2347a92343d3ap+915,    0x1.cba929f7fb679p-1,  -0x1.ff21c8p-2, INEXACT)
T(RN,  0x1.9b476d33da9c6p+915,    0x1.bd0ed5fc92c0bp-1,   0x1.e2c858p-4, INEXACT)
T(RN,  0x1.2d8c4961b446ap+916,    0x1.9e8d4a24f20dep-2,   0x1.1037b6p-4, INEXACT)
T(RN,  0x1.d84c181f541f8p+916,   -0x1.fdc78940e544ep-1,  -0x1.735ccap-3, INEXACT)
T(RN,  0x1.dab48de7fdc6cp+916,    0x1.80c1c71e9a509p-1,  -0x1.b4eb18p-2, INEXACT)
T(RN,  0x1.f9af818118799p+916,   -0x1.37c0fd9610d5dp-1,  -0x1.faa4bcp-2, INEXACT)
T(RN,  0x1.40811adab1c42p+916,   -0x1.8292b926d1418p-2,  -0x1.383054p-3, INEXACT)
T(RN,  0x1.95cc72007319cp+916,   -0x1.0c60689cc8303p-1,   -0x1.9192ep-2, INEXACT)
T(RN,  0x1.50bff5f96ef96p+916,    0x1.64e5e36ecd12ep-2,  -0x1.8a247ap-5, INEXACT)
T(RN,  0x1.533d6e1625b8bp+916,   -0x1.e4559b216da71p-4,   0x1.93c8e4p-3, INEXACT)
T(RN,  0x1.d5bc62d573f12p+916,   -0x1.7fc4da6ad4af7p-2,  -0x1.5d4e64p-2, INEXACT)
T(RN,  0x1.aa8f142ee30dap+916,    0x1.37deaf24b678ap-1,   0x1.ff1ff6p-2, INEXACT)
T(RN,  0x1.82ae8af2de681p+917,   -0x1.304b4bab65388p-1,   0x1.e66694p-7, INEXACT)
T(RN,  0x1.098783c84ee85p+917,   -0x1.5f3bd934ee84ep-1,   0x1.67cafap-3, INEXACT)
T(RN,   0x1.bb46e3ff321ep+917,    0x1.fd89f0c61472cp-1,   0x1.8aa87ap-3, INEXACT)
T(RN,  0x1.46845577edb6dp+917,    0x1.f2ac5dbb62b81p-1,   0x1.eb2d34p-4, INEXACT)
T(RN,  0x1.651d05589f2a7p+917,    0x1.13e8e05b8c988p-3,  -0x1.5c37c8p-3, INEXACT)
T(RN,  0x1.777eab1a74ea2p+917,   -0x1.95fa661fc0136p-3,   0x1.46ffc2p-2, INEXACT)
T(RN,  0x1.75394ca7b141ap+917,   -0x1.ff4173bccec0cp-1,   0x1.f0fe6cp-3, INEXACT)
T(RN,  0x1.567470e1147f3p+917,   -0x1.32b60ae3c36b6p-1,   0x1.3a270cp-2, INEXACT)
T(RN,  0x1.ef9608340611ap+917,   -0x1.a723fb371c0e7p-1,  -0x1.b517f6p-6, INEXACT)
T(RN,  0x1.1501a4dac7a8cp+917,   -0x1.e701bceca44f6p-1,   0x1.db3576p-5, INEXACT)
T(RN,  0x1.5b6abf40880bfp+918,    0x1.c912e595f63e8p-1,   0x1.79190ap-4, INEXACT)
T(RN,  0x1.c476040a308aap+918,   -0x1.b9ea17c50eaf2p-2,  -0x1.b84ca2p-3, INEXACT)
T(RN,  0x1.55d80e5b68082p+918,   -0x1.9ac134eed8c3bp-3,    0x1.cdc3ep-6, INEXACT)
T(RN,  0x1.d2ccaa41e0b7ep+918,   -0x1.dbb6e5fd41993p-1,  -0x1.d8a5ecp-2, INEXACT)
T(RN,  0x1.d9d905f37ffbcp+918,    0x1.90fa1fb8b7307p-2,    0x1.2a0bep-2, INEXACT)
T(RN,  0x1.aa7feb8921cfep+918,   -0x1.217ac88c7adf6p-1,   0x1.a2c676p-2, INEXACT)
T(RN,  0x1.9f4c065be087ep+918,    0x1.9808e72d27e7bp-2,  -0x1.dce75cp-3, INEXACT)
T(RN,   0x1.0303ca1830cfp+918,   -0x1.ecae2fc946739p-1,   0x1.7798d4p-2, INEXACT)
T(RN,  0x1.f66d122676d98p+918,   -0x1.f630851b0a575p-1,   0x1.027d22p-2, INEXACT)
T(RN,  0x1.388177894c3a8p+918,    0x1.de9afbc8c3df8p-3,  -0x1.75f02ep-4, INEXACT)
T(RN,  0x1.5e8a10b78d475p+919,   -0x1.1e481ca0d95b4p-2,   0x1.4766dep-4, INEXACT)
T(RN,  0x1.ca914dc7389ffp+919,    0x1.4ebcfe8312e95p-1,  -0x1.eb9c66p-4, INEXACT)
T(RN,  0x1.50f4f1de61a65p+919,    0x1.de5e146b3e80ep-1,  -0x1.043d5ep-2, INEXACT)
T(RN,  0x1.ea54dbd763d2dp+919,     0x1.28033b5205e8p-3,  -0x1.274edap-2, INEXACT)
T(RN,  0x1.0c18369f0f847p+919,    0x1.4562d1981dca9p-3,   0x1.075d4ep-2, INEXACT)
T(RN,  0x1.2c7dc433dc92ep+919,    0x1.24e9592071f5fp-1,  -0x1.1e5876p-2, INEXACT)
T(RN,  0x1.74fbc82095c0ap+919,     0x1.f8961cb8bbf2p-2,   0x1.42aaf6p-2, INEXACT)
T(RN,  0x1.8ef9052d6c74ap+919,   -0x1.eb69b6d38ef35p-2,   0x1.7e01fap-3, INEXACT)
T(RN,  0x1.1a8bd7554c19dp+919,    -0x1.70e36a4fcc43p-2,   0x1.4131c8p-2, INEXACT)
T(RN,  0x1.1f5a1aca75957p+919,   -0x1.da0d256b539f1p-1,   0x1.1ed032p-2, INEXACT)
T(RN,  0x1.aed9f6658ca04p+920,   -0x1.c7dd72d2cc508p-1,   0x1.1d519ap-3, INEXACT)
T(RN,  0x1.5f568a8b20008p+920,   -0x1.fa26b60eef452p-1,  -0x1.61c196p-4, INEXACT)
T(RN,  0x1.3d36a0ca6116bp+920,   -0x1.fffe7d5f4bbb6p-1,   0x1.a592dcp-2, INEXACT)
T(RN,  0x1.7dbf3b84d9241p+920,    0x1.07d02645963dcp-2,  -0x1.430736p-2, INEXACT)
T(RN,  0x1.000999a42ebb8p+920,     0x1.141d4d3e3521p-1,   0x1.53c84ep-3, INEXACT)
T(RN,  0x1.765c5f2ab8018p+920,    -0x1.ff3435345245p-1,   0x1.bd1124p-2, INEXACT)
T(RN,  0x1.ff47b9622517dp+920,    0x1.7766de2452508p-1,   0x1.8d0ddep-2, INEXACT)
T(RN,  0x1.9d16b4a6dc709p+920,    0x1.62d68d5904ff4p-1,  -0x1.6fec56p-5, INEXACT)
T(RN,  0x1.02205622ab1d4p+920,   -0x1.fa8f663d07c54p-1,  -0x1.1ff22cp-6, INEXACT)
T(RN,  0x1.9f0fcf4e23d8ep+920,    0x1.c51972b734ef9p-1,   0x1.af3b1ep-2, INEXACT)
T(RN,  0x1.910db9a4b92a9p+921,   -0x1.ac6ebd88690ccp-1,   0x1.1ae244p-2, INEXACT)
T(RN,  0x1.bdd6fd14b1844p+921,    0x1.1fdff9ccdeb31p-3,  -0x1.5c0eccp-2, INEXACT)
T(RN,   0x1.90419c73161bp+921,    0x1.28ae130cafca9p-1,   -0x1.22769p-3, INEXACT)
T(RN,  0x1.62fe702842066p+921,    0x1.75c085749e1f5p-2,    0x1.0bef1p-2, INEXACT)
T(RN,  0x1.4b913fa9776efp+921,   -0x1.c92ed078523b1p-1,    0x1.2f06fp-3, INEXACT)
T(RN,  0x1.06905e741ea55p+921,    0x1.04dd099328c7dp-5,    0x1.73a0ap-4, INEXACT)
T(RN,  0x1.0310c1a48fa3dp+921,   -0x1.52c863760f8d8p-1,   0x1.73e298p-3, INEXACT)
T(RN,  0x1.49ea1d319aee6p+921,   -0x1.9156a0d726069p-1,    0x1.ae3e9p-2, INEXACT)
T(RN,  0x1.7e007fffd79cdp+921,   -0x1.6f69fab9f7a5fp-1,   0x1.5685e2p-2, INEXACT)
T(RN,  0x1.bdb42a11cc2fbp+921,   -0x1.e4dfe328b2f4bp-2,   0x1.f1d4f2p-3, INEXACT)
T(RN,  0x1.a19129f13949fp+922,   -0x1.e190114f83689p-1,   0x1.8d2776p-3, INEXACT)
T(RN,  0x1.12b007498de1ap+922,    0x1.fd1594b1bfe1dp-1,   0x1.121226p-3, INEXACT)
T(RN,  0x1.18804ad12af7dp+922,   -0x1.808855e511a21p-1,   0x1.46f332p-2, INEXACT)
T(RN,  0x1.d537fd565edf2p+922,   -0x1.deef8cef508b1p-2,  -0x1.bf1ddep-4, INEXACT)
T(RN,  0x1.b4edd1920c05ep+922,   -0x1.c07c8f14fc879p-4,  -0x1.7860eap-2, INEXACT)
T(RN,  0x1.727125ddb875cp+922,   -0x1.7d9c44fdae5d4p-3,   0x1.21d018p-2, INEXACT)
T(RN,  0x1.ac02f75c4ba11p+922,   -0x1.8bc1031e4fc62p-2,  -0x1.de24aap-6, INEXACT)
T(RN,  0x1.e6210403f6aa3p+922,    0x1.a62f80250f565p-2,  -0x1.4bc274p-3, INEXACT)
T(RN,  0x1.185e8fb1fe416p+922,    0x1.f858b3f362af5p-1,   0x1.912016p-4, INEXACT)
T(RN,  0x1.2e5a2cdb6964cp+922,    0x1.c114fee1df408p-2,    0x1.4ba26p-3, INEXACT)
T(RN,  0x1.a7b0853e8fc87p+923,    0x1.df1fb9dbb9105p-1,   0x1.0af4bep-2, INEXACT)
T(RN,  0x1.18f53e71b522dp+923,   -0x1.ef51889f44e65p-1,  -0x1.7dcb58p-2, INEXACT)
T(RN,   0x1.d4af8c1cb9dcp+923,   -0x1.c1b8258a5e619p-1,   0x1.2bb3f6p-3, INEXACT)
T(RN,  0x1.b5a34f1bc3fcep+923,   -0x1.c893ec90c0764p-1,   -0x1.47ad2p-6, INEXACT)
T(RN,  0x1.ffba89f6af086p+923,    0x1.a1823c8c3124ep-1,  -0x1.32311ep-2, INEXACT)
T(RN,  0x1.10435a8a39d8ep+923,    0x1.0619dd937563bp-2,   0x1.28422ep-2, INEXACT)
T(RN,  0x1.e4ba65d986f23p+923,    0x1.208840d68e36bp-1,    0x1.bf4d2p-3, INEXACT)
T(RN,  0x1.1c3b8c8cdfd3bp+923,   -0x1.11f0b40ea0e3bp-1,  -0x1.6a041ap-2, INEXACT)
T(RN,  0x1.dacf9c6e1f66dp+923,    0x1.a735f6c9f0e41p-1,  -0x1.fb7726p-6, INEXACT)
T(RN,  0x1.ea54a3bbd9f4cp+923,   -0x1.fe0bf3e845ceap-1,   0x1.31c982p-2, INEXACT)
T(RN,  0x1.fda9640d7010ep+924,   -0x1.706bec4f32f5ep-1,   0x1.d553e8p-2, INEXACT)
T(RN,  0x1.567c44f329307p+924,    0x1.f8b968b1446f5p-1,   0x1.b84852p-2, INEXACT)
T(RN,  0x1.f1a06c73268b5p+924,   -0x1.460f25706c637p-1,   0x1.5c3f0cp-3, INEXACT)
T(RN,  0x1.131dbd87670b1p+924,   -0x1.7b908c8f10397p-4,   0x1.398c4cp-2, INEXACT)
T(RN,  0x1.3c924a1208bf1p+924,   -0x1.532d416bb1f5ap-1,  -0x1.5d6826p-2, INEXACT)
T(RN,  0x1.56ae3dadf0a88p+924,   -0x1.a2c94e67fb9f9p-1,   0x1.e2adcap-3, INEXACT)
T(RN,  0x1.c2f314b9c686bp+924,   -0x1.fe7133fa0bc0cp-1,  -0x1.eeb9aep-2, INEXACT)
T(RN,  0x1.1652dcb18d58cp+924,   -0x1.b6f7ca1f305d8p-1,   0x1.efa976p-2, INEXACT)
T(RN,  0x1.da59640dd46c8p+924,   -0x1.fffd3e8400c68p-1,   0x1.21e9f6p-2, INEXACT)
T(RN,  0x1.97948bea11edap+924,   -0x1.3219d6ce9b082p-3,   0x1.3a889ep-2, INEXACT)
T(RN,  0x1.4dfef6c51c06bp+925,   -0x1.f0fbebfedf6fep-1,   0x1.03e37ep-2, INEXACT)
T(RN,  0x1.7e9a3b7f4e0f8p+925,   -0x1.55e01ef5a9c5ep-1,   0x1.7cc4b2p-4, INEXACT)
T(RN,  0x1.2c59ff3f94747p+925,   -0x1.1b6ca5b845d98p-1,    0x1.f4f25p-2, INEXACT)
T(RN,   0x1.483f3712050bp+925,   -0x1.b753c22e1a561p-1,  -0x1.6910d4p-2, INEXACT)
T(RN,  0x1.fe432e763f0bcp+925,    0x1.69fcac42d9362p-1,   0x1.f9f0b2p-3, INEXACT)
T(RN,  0x1.c8e9d93af5f15p+925,   -0x1.f5918c63e1024p-1,  -0x1.63ee5ap-2, INEXACT)
T(RN,   0x1.b3585a29c1f3p+925,    0x1.f6907922714a5p-1,   -0x1.db05bp-6, INEXACT)
T(RN,  0x1.720ef7be5ca6ep+925,   -0x1.9c404e5a947dcp-1,  -0x1.1713cep-7, INEXACT)
T(RN,  0x1.7d28319f21ee1p+925,   -0x1.37a8b4826131fp-1,   0x1.c0e18cp-2, INEXACT)
T(RN,  0x1.4248e3e9dca41p+925,    0x1.78595fe0a80ffp-1,   0x1.37bcbep-4, INEXACT)
T(RN,  0x1.7e4f3cd98e254p+926,   -0x1.4d0f05e485051p-1,   0x1.a37e26p-3, INEXACT)
T(RN,  0x1.efe5376ab8364p+926,   -0x1.334e7ca91dff5p-3,   0x1.ec1ed8p-2, INEXACT)
T(RN,  0x1.6486e8be7ef0ap+926,    0x1.f0f14c1ce9ef2p-1,  -0x1.f7e30ap-3, INEXACT)
T(RN,  0x1.f698f305acc2fp+926,   -0x1.4f2f3fe337427p-7,  -0x1.33ad1cp-2, INEXACT)
T(RN,  0x1.79b55a6c2295cp+926,   -0x1.faa968d85559ep-1,   0x1.d15bf8p-4, INEXACT)
T(RN,  0x1.cfc598de81d87p+926,    0x1.7da8786672474p-4,   0x1.3a13fep-3, INEXACT)
T(RN,  0x1.0c2320767e744p+926,   -0x1.e6bc709f13db7p-1,  -0x1.86c868p-2, INEXACT)
T(RN,  0x1.f912781abe2dap+926,   -0x1.181d6226ac82fp-1,  -0x1.96b316p-3, INEXACT)
T(RN,  0x1.f8e0999ad0209p+926,   -0x1.aff0ba60f7962p-3,   0x1.e03b96p-3, INEXACT)
T(RN,  0x1.2e53398578bfdp+926,    0x1.f92ff4f6c76dcp-1,  -0x1.1e1dccp-4, INEXACT)
T(RN,  0x1.df4880e211f9cp+927,    0x1.df6ff1f0a0525p-4,   0x1.f0bde2p-2, INEXACT)
T(RN,  0x1.9418680783942p+927,   -0x1.d4d47a153547dp-2,   0x1.e48ff2p-2, INEXACT)
T(RN,  0x1.78db9cb18a8c3p+927,   -0x1.67fc0111bcb75p-3,   0x1.7638c8p-6, INEXACT)
T(RN,  0x1.f619a2018a436p+927,   -0x1.f0035583b0ccbp-1,  -0x1.d24526p-3, INEXACT)
T(RN,  0x1.d1a2e63406697p+927,   -0x1.3b2ad0ce60217p-1,   -0x1.a5f7ap-7, INEXACT)
T(RN,  0x1.797d36f89d6a9p+927,    0x1.ed236cde6a673p-1,  -0x1.9eb5aap-3, INEXACT)
T(RN,  0x1.6988ef5053e49p+927,    0x1.ffbd0807462b1p-1,   0x1.db1716p-2, INEXACT)
T(RN,  0x1.cd04924082262p+927,    0x1.ccab4f717b539p-1,  -0x1.5c939ep-2, INEXACT)
T(RN,   0x1.359943134fa8p+927,    0x1.72bf84738b33fp-1,  -0x1.375856p-3, INEXACT)
T(RN,  0x1.7b5d2a3c64482p+927,    0x1.f84971ad23527p-1,   0x1.231bdcp-3, INEXACT)
T(RN,  0x1.84c9fdae6fc4ep+928,   -0x1.e7dee2920518ep-1,  -0x1.c34266p-3, INEXACT)
T(RN,  0x1.679e92b17b17dp+928,     0x1.1377ed9b7008p-2,   0x1.7f93b8p-6, INEXACT)
T(RN,  0x1.062234b95681ap+928,    0x1.1d9551c3902a4p-1,   0x1.e97d38p-4, INEXACT)
T(RN,  0x1.c155789cf159cp+928,   -0x1.6c366a17ed007p-1,   0x1.123358p-2, INEXACT)
T(RN,  0x1.ff2d35adec68cp+928,   -0x1.e084dc7d07fa8p-2,  -0x1.aea9ecp-3, INEXACT)
T(RN,  0x1.d00b6d80410c3p+928,    0x1.ba280c4227d3cp-1,  -0x1.570fe8p-6, INEXACT)
T(RN,  0x1.f56ccbb4a36b2p+928,    0x1.ec6c9b3da1f53p-1,   0x1.3f5c76p-3, INEXACT)
T(RN,  0x1.7c8b8112e1c16p+928,   -0x1.c908a1c5575fcp-1,  -0x1.9740aep-5, INEXACT)
T(RN,  0x1.117cf42c3f3d2p+928,   -0x1.7a511e43d924dp-1,   0x1.22ba68p-5, INEXACT)
T(RN,  0x1.54dd4c6b9d033p+928,    0x1.a5a857b82c0d5p-1,   0x1.9ed5bcp-2, INEXACT)
T(RN,  0x1.812b9df45a562p+929,    0x1.97c60e1d43ab5p-1,  -0x1.5ed7d6p-3, INEXACT)
T(RN,  0x1.ca8f66549b0cep+929,   -0x1.59c77e7c0f8f3p-2,    0x1.afb67p-5, INEXACT)
T(RN,  0x1.d3e7a17df27b5p+929,    0x1.9ff112fce10b5p-1,  -0x1.325e38p-3, INEXACT)
T(RN,  0x1.6e6a445d55338p+929,   -0x1.72eb82bbb43f7p-1,   0x1.4ba2dep-2, INEXACT)
T(RN,  0x1.40afd54de5ef6p+929,   -0x1.258c3e3a54b63p-2,  -0x1.76d052p-3, INEXACT)
T(RN,  0x1.9226129632d5cp+929,   -0x1.57103dd4937f6p-2,  -0x1.5fcc08p-5, INEXACT)
T(RN,  0x1.a676cd9ddb41ep+929,    0x1.274035bf3353bp-1,  -0x1.3b2e38p-4, INEXACT)
T(RN,  0x1.a1211c43ac462p+929,     0x1.107ba489b201p-3,   0x1.0c994ap-4, INEXACT)
T(RN,  0x1.54d866e69b08dp+929,    0x1.727902bb24a68p-1,   0x1.ce9eeap-2, INEXACT)
T(RN,  0x1.3fa7e4162e01ap+929,    0x1.ff545194ccdedp-1,   -0x1.51939p-7, INEXACT)
T(RN,   0x1.debd00d0c4e8p+930,   -0x1.1a02a7a128e4cp-3,  -0x1.92c7c4p-3, INEXACT)
T(RN,  0x1.cbff3a9d97368p+930,    0x1.739a697c86fedp-1,   0x1.886e7cp-2, INEXACT)
T(RN,  0x1.2cec6405767a7p+930,   -0x1.975a1e489fb82p-1,  -0x1.e5673ap-3, INEXACT)
T(RN,  0x1.d4f4aab475818p+930,   -0x1.47a2f0ad91b48p-1,   0x1.b8b468p-2, INEXACT)
T(RN,  0x1.7048e983c4709p+930,   -0x1.a66f60c8de82dp-1,   0x1.444c78p-2, INEXACT)
T(RN,  0x1.06417b48167e9p+930,   -0x1.08b4ce67835e4p-1,   0x1.a773cap-3, INEXACT)
T(RN,  0x1.c7009345e3889p+930,    0x1.8bb0862c0ddbcp-5,  -0x1.20c8fap-7, INEXACT)
T(RN,  0x1.33ece0c267a26p+930,    0x1.1a1f63922d68ap-1,   0x1.53f944p-4, INEXACT)
T(RN,  0x1.9a1f4eab82484p+930,   -0x1.d67e3a6152c19p-3,  -0x1.adb50cp-3, INEXACT)
T(RN,  0x1.394a5a7f2e8c4p+930,   -0x1.c163660c4acd1p-1,  -0x1.336dfcp-2, INEXACT)
T(RN,  0x1.e5733a1fbf8aap+931,   -0x1.6ae7c30164a29p-1,   -0x1.4ab6ap-2, INEXACT)
T(RN,  0x1.84c39ce0117b2p+931,    0x1.8e7232ad28af2p-2,   0x1.17acd8p-2, INEXACT)
T(RN,  0x1.c4ca90ee9f2e4p+931,   -0x1.bde8984c24adbp-2,     0x1.2f69p-2, INEXACT)
T(RN,  0x1.05bd00a3eee5bp+931,    0x1.f283624286b57p-1,   -0x1.dedd9p-2, INEXACT)
T(RN,  0x1.cbf31bc5b69c9p+931,      0x1.d2c0d9fad5dp-2,  -0x1.fdf4a2p-2, INEXACT)
T(RN,  0x1.110dc55eeb269p+931,    0x1.76f151ace06f1p-4,  -0x1.108186p-3, INEXACT)
T(RN,   0x1.d02dfec208dap+931,   -0x1.b9992c24603d9p-1,   0x1.3c6076p-2, INEXACT)
T(RN,  0x1.d34050bd0861ap+931,   -0x1.c66fe87fc2325p-1,  -0x1.8c5296p-3, INEXACT)
T(RN,  0x1.83e0c353c5a0cp+931,    0x1.e42238e304192p-3,   0x1.76103cp-2, INEXACT)
T(RN,  0x1.9506c06ab500fp+931,   -0x1.174ddd16ede05p-1,   0x1.85eae8p-3, INEXACT)
T(RN,  0x1.9b756b7b5016bp+932,   -0x1.04cc489f97807p-2,   0x1.a5260ap-2, INEXACT)
T(RN,  0x1.f998d369cf7eep+932,   -0x1.4e221e914f4aep-1,   -0x1.6cff3p-3, INEXACT)
T(RN,  0x1.6f3e408a9266ep+932,    0x1.9f36e02a2adcdp-1,   0x1.bce136p-3, INEXACT)
T(RN,  0x1.a05f2fb1984c6p+932,    0x1.f5e420a3299c9p-2,  -0x1.8ea95ap-2, INEXACT)
T(RN,  0x1.97148a97ab7bep+932,   -0x1.4719b572e72e1p-8,   0x1.1b2cfep-2, INEXACT)
T(RN,  0x1.78b5a03e27ddap+932,    0x1.15a25f04925a8p-2,  -0x1.9ca87cp-6, INEXACT)
T(RN,   0x1.37d3974a102dp+932,    -0x1.fff3ac718a71p-1,  -0x1.297d92p-2, INEXACT)
T(RN,  0x1.c5336c44ff254p+932,   -0x1.c33c1bbf9a332p-1,     0x1.a061p-2, INEXACT)
T(RN,  0x1.eaf8f7ec4eb8cp+932,    0x1.ffbe24844eb6bp-1,    0x1.026dbp-3, INEXACT)
T(RN,  0x1.241f750fb29d2p+932,    0x1.191baa063d5bap-1,  -0x1.fa0506p-2, INEXACT)
T(RN,   0x1.f53e138155fcp+933,    0x1.cb413bb2100ccp-1,   -0x1.ba144p-3, INEXACT)
T(RN,  0x1.80c591c26dd4ap+933,    -0x1.3568f5f8ad38p-1,  -0x1.dd1336p-2, INEXACT)
T(RN,  0x1.9dc0d124603f4p+933,   -0x1.414a69c007385p-2,    0x1.662e7p-4, INEXACT)
T(RN,  0x1.a437a23b779bbp+933,    0x1.03b6c7509ed3bp-1,   0x1.dc4306p-3, INEXACT)
T(RN,  0x1.19752dbee5f6ap+933,    0x1.297c768f24131p-1,   0x1.ffff44p-2, INEXACT)
T(RN,  0x1.a559cea096c0bp+933,    0x1.fbac1dc2a0f35p-1,   0x1.b477c6p-2, INEXACT)
T(RN,  0x1.8744c0ef8bdc6p+933,    0x1.c368afecd30c1p-1,  -0x1.f608aap-5, INEXACT)
T(RN,  0x1.386dc9ea4cb8ap+933,   -0x1.a6221221e8d78p-1,  -0x1.ed2586p-5, INEXACT)
T(RN,  0x1.52664a2058926p+933,    0x1.fd288a615d6c4p-1,   0x1.ad9952p-4, INEXACT)
T(RN,  0x1.a6d8ed75d76d8p+933,    0x1.f4fd54ccfa4bdp-1,  -0x1.fd3c34p-4, INEXACT)
T(RN,  0x1.cc527228ff758p+934,   -0x1.fd55d3c89cdc4p-1,   0x1.7dd75cp-8, INEXACT)
T(RN,  0x1.853bd401f442ap+934,     0x1.6daa6bbd560bp-1,   -0x1.a8912p-2, INEXACT)
T(RN,   0x1.9a923b2ed284p+934,    0x1.d57d8172ac1f1p-1,   0x1.4e44dep-4, INEXACT)
T(RN,  0x1.b3959ee5a9e86p+934,   -0x1.1ee14f476b287p-5,   0x1.6c5348p-2, INEXACT)
T(RN,  0x1.292e2dccf1939p+934,    0x1.ba60a3c2d6a8ap-1,   0x1.cdcc24p-3, INEXACT)
T(RN,  0x1.0d5bdd5e32cb7p+934,    0x1.f59500b41cb1bp-1,   0x1.f4cd7ep-3, INEXACT)
T(RN,  0x1.309a128da09cfp+934,    0x1.f17a0e65de371p-4,   0x1.ecc5c6p-3, INEXACT)
T(RN,  0x1.5f2f7d27b6a07p+934,    0x1.45bc445a70efdp-2,    0x1.cac23p-2, INEXACT)
T(RN,  0x1.38e65d32249a2p+934,    -0x1.e052aa886441p-3,   0x1.20b5fep-4, INEXACT)
T(RN,  0x1.3fcfb45f0a8a9p+934,   -0x1.34dd1d4fd8af1p-1,   0x1.961a08p-2, INEXACT)
T(RN,  0x1.1513e4edd08c1p+935,    0x1.928af6461010bp-3,  -0x1.4e8954p-4, INEXACT)
T(RN,  0x1.09cf85eb98dfap+935,   -0x1.fbb74cb1c9f82p-1,  -0x1.a14f56p-5, INEXACT)
T(RN,  0x1.33a0982d2128dp+935,    0x1.9bbe9ee81cd7fp-1,   0x1.f08ee2p-2, INEXACT)
T(RN,  0x1.0918b504c43bdp+935,    0x1.b94ce2493e08dp-1,   -0x1.47629p-3, INEXACT)
T(RN,  0x1.4f43f3753f078p+935,   -0x1.6ddd02c71574cp-3,  -0x1.63b248p-2, INEXACT)
T(RN,  0x1.da67cafe152bep+935,   -0x1.77d45cf40f492p-1,   0x1.f5b14cp-2, INEXACT)
T(RN,  0x1.49499d7a22adap+935,    0x1.eb5229b678f47p-1,   0x1.1d6e7ap-3, INEXACT)
T(RN,  0x1.5313373a3f588p+935,   -0x1.f5bcd31ea2df1p-1,   0x1.788fe8p-3, INEXACT)
T(RN,  0x1.01d479e6a3cc5p+935,    0x1.1cecc45dfbf63p-2,  -0x1.3ad61ep-2, INEXACT)
T(RN,  0x1.29d28ce8ebb3ap+935,    0x1.ae3dcd8d6541dp-1,  -0x1.8700e2p-2, INEXACT)
T(RN,   0x1.3693a04785fcp+936,    0x1.4a75ae2cb7e4dp-1,   0x1.69f6dcp-3, INEXACT)
T(RN,  0x1.b328df6afd686p+936,   -0x1.fc0c73e94f828p-1,   -0x1.f8e92p-2, INEXACT)
T(RN,  0x1.4464b6353cc4ep+936,   -0x1.917c31266579ap-1,   0x1.106d8ep-4, INEXACT)
T(RN,  0x1.f4e826125ea9cp+936,   -0x1.fbb0b63c3227dp-1,   0x1.62ea7ap-2, INEXACT)
T(RN,   0x1.76777866615cp+936,   -0x1.c83790cec973dp-1,  -0x1.d4359ap-3, INEXACT)
T(RN,  0x1.f2abef7ec775cp+936,   -0x1.1c5d9b30ee0f9p-3,  -0x1.e12bc8p-2, INEXACT)
T(RN,  0x1.b0e1beb1fab07p+936,    0x1.de168cf721e79p-1,   0x1.0da16ep-2, INEXACT)
T(RN,  0x1.b21b0dff42e0ap+936,    0x1.9619672bd20a3p-1,   0x1.75bd4ap-2, INEXACT)
T(RN,  0x1.0f2df33fb010cp+936,    0x1.314a9f7c0d9acp-1,  -0x1.f73a46p-3, INEXACT)
T(RN,  0x1.bd6cd6b8d72f8p+936,    0x1.ed5eb32f21dd2p-1,  -0x1.b780bcp-3, INEXACT)
T(RN,   0x1.561615ecc3dap+937,   -0x1.e6d3a25a96aecp-2,   0x1.e6a838p-3, INEXACT)
T(RN,  0x1.bbe32bfa08ac8p+937,   -0x1.287a86d8e17a1p-1,   -0x1.9426dp-2, INEXACT)
T(RN,  0x1.5c7f228879f2ep+937,   -0x1.25cb2d6794c6bp-1,  -0x1.9eee86p-3, INEXACT)
T(RN,  0x1.a9154ce9a3902p+937,    -0x1.2db7d1c5c2b6p-2,  -0x1.4cdd0cp-2, INEXACT)
T(RN,  0x1.9c63c39084ef6p+937,    0x1.a60e384200d9dp-4,  -0x1.f62a64p-2, INEXACT)
T(RN,  0x1.1c29dccb821f2p+937,    0x1.036fb40243d5fp-5,  -0x1.2c37fap-2, INEXACT)
T(RN,  0x1.5178f219e7fe7p+937,   -0x1.121e79ab1a621p-3,  -0x1.bd67d6p-2, INEXACT)
T(RN,  0x1.c5fde824f1082p+937,     0x1.f29b5ae42145p-1,   0x1.95047cp-7, INEXACT)
T(RN,   0x1.dacb8a91d453p+937,    0x1.bfb0222494ad9p-1,  -0x1.87e4b4p-4, INEXACT)
T(RN,  0x1.df18d35d87a67p+937,    0x1.c7b38aab94f0dp-1,   0x1.71d312p-2, INEXACT)
T(RN,   0x1.5968d0426a0cp+938,    0x1.b7f7ee0c4206dp-1,   -0x1.677ccp-2, INEXACT)
T(RN,  0x1.f1ba5f99b6ad6p+938,    0x1.ed9c2f99b3d04p-2,   0x1.77e544p-5, INEXACT)
T(RN,  0x1.bb0b85dff11eap+938,   -0x1.f2adcc872905ep-1,   0x1.0fe862p-2, INEXACT)
T(RN,  0x1.0c3b909809202p+938,   -0x1.fe301ada19c8dp-1,  -0x1.d75048p-3, INEXACT)
T(RN,  0x1.3dcabc6302c73p+938,    -0x1.ffe40e5fabdap-1,  -0x1.8793b8p-2, INEXACT)
T(RN,  0x1.7b09afe5ea2d6p+938,   -0x1.ffa4fe195f766p-2,  -0x1.2c0f7ep-3, INEXACT)
T(RN,  0x1.1b596bb079ca7p+938,   -0x1.0c5651be3ec13p-1,   0x1.e93f38p-2, INEXACT)
T(RN,  0x1.da68f0033a528p+938,    -0x1.fa2a25633241p-1,   0x1.17f3acp-2, INEXACT)
T(RN,  0x1.946f1244327c5p+938,   -0x1.8fc6cb7fb4216p-1,   0x1.bb3214p-4, INEXACT)
T(RN,   0x1.b3951bdd6981p+938,    0x1.642d49c0e81bbp-2,  -0x1.7702fcp-2, INEXACT)
T(RN,  0x1.07939b10af425p+939,   -0x1.eea8c4ac9e295p-1,   0x1.99c7e8p-2, INEXACT)
T(RN,  0x1.81762805378e2p+939,    0x1.72d6c88865c5dp-1,  -0x1.37bcd4p-2, INEXACT)
T(RN,  0x1.e91318e107438p+939,   -0x1.95b132270d67dp-1,   -0x1.7cb82p-2, INEXACT)
T(RN,   0x1.840d7ab39282p+939,   -0x1.ff6c00a1bf5aap-1,   -0x1.5e2a5p-2, INEXACT)
T(RN,  0x1.0d48721e49e22p+939,   -0x1.f42f15a0e330ap-1,  -0x1.bc8956p-2, INEXACT)
T(RN,  0x1.357bbcbae5e36p+939,    0x1.b5016d77fa00ep-1,  -0x1.c28196p-2, INEXACT)
T(RN,  0x1.e8a43ee9fa636p+939,   -0x1.fde21005d63acp-1,  -0x1.111a7ep-3, INEXACT)
T(RN,  0x1.152b278095f38p+939,    -0x1.fc1fa3f83f58p-1,  -0x1.595ddap-2, INEXACT)
T(RN,   0x1.012697618146p+939,   -0x1.5fad17c6257c6p-1,   0x1.7e0ffcp-5, INEXACT)
T(RN,   0x1.8fe6ad5858f8p+939,   -0x1.f9f6658ef642ep-1,   0x1.690c7ap-4, INEXACT)
T(RN,  0x1.0ff467eadf378p+940,   -0x1.02b1a50982a9ep-1,   0x1.982fa6p-2, INEXACT)
T(RN,  0x1.a4bf15e83c312p+940,   -0x1.83221b9f41acdp-2,   0x1.016b82p-2, INEXACT)
T(RN,  0x1.d7ae49b99e43ep+940,   -0x1.52b44bcd5e93dp-3,   0x1.0df42ep-2, INEXACT)
T(RN,  0x1.6099ee6d3235cp+940,   -0x1.cfe5c8138e223p-1,  -0x1.8fbd44p-2, INEXACT)
T(RN,    0x1.302d2f98829p+940,    0x1.e24a7b661396bp-1,    0x1.67752p-2, INEXACT)
T(RN,  0x1.714cc9db263cdp+940,   -0x1.876854cf4b231p-4,   0x1.f73cdep-2, INEXACT)
T(RN,  0x1.aea41fa433eedp+940,     0x1.dd8e12415a3dp-1,   0x1.10a56ap-3, INEXACT)
T(RN,  0x1.90132682e07eep+940,   -0x1.c2f58165f1282p-8,   0x1.2de668p-2, INEXACT)
T(RN,   0x1.7836c3a8e9bbp+940,   -0x1.c5e954b95384fp-1,  -0x1.d81724p-6, INEXACT)
T(RN,  0x1.ad9d3f648258cp+940,    -0x1.febdc0c88079p-1,  -0x1.95d9d2p-2, INEXACT)
T(RN,  0x1.22b65abf2b5a2p+941,    0x1.d0837a9d1b024p-1,  -0x1.ef8ffep-2, INEXACT)
T(RN,  0x1.55f6678891ffdp+941,    0x1.e6925e02bbda4p-1,  -0x1.5e393ep-2, INEXACT)
T(RN,  0x1.9b97232aa3668p+941,   -0x1.77a59bb8f4fadp-1,   0x1.bfe1a8p-3, INEXACT)
T(RN,  0x1.9fa03a5435d66p+941,   -0x1.adf63776b7938p-1,    0x1.771c4p-2, INEXACT)
T(RN,  0x1.9c0f8d5449119p+941,   -0x1.4e80b1505d254p-1,    0x1.83d64p-2, INEXACT)
T(RN,   0x1.827e27205382p+941,    0x1.f2bae1652a115p-1,   -0x1.132c1p-3, INEXACT)
T(RN,  0x1.a00bf66243e0ep+941,   -0x1.ba0bc3e61ab9ap-1,    0x1.5cb48p-4, INEXACT)
T(RN,   0x1.3e5134d4cce1p+941,    0x1.f07f67da57d77p-1,   -0x1.33bb1p-2, INEXACT)
T(RN,  0x1.f8d4eecdd8466p+941,    0x1.6ba059d181fe5p-2,   0x1.e5ed26p-2, INEXACT)
T(RN,    0x1.3037131573fp+941,    0x1.3b8dfc3c4e7c9p-1,    0x1.88146p-4, INEXACT)
T(RN,  0x1.fa995ed89c228p+942,   -0x1.2cdd01f54009ep-1,  -0x1.5ddfe2p-2, INEXACT)
T(RN,  0x1.3ce5734e11b49p+942,   -0x1.d8ddc60fe859ap-1,   0x1.763ae8p-3, INEXACT)
T(RN,  0x1.ab5230b1a18a2p+942,    0x1.ea5e48c35b2a6p-3,  -0x1.8b11d8p-2, INEXACT)
T(RN,  0x1.8e64c88c3dc1ep+942,   -0x1.1ff39fc17bf89p-2,   0x1.da8592p-3, INEXACT)
T(RN,  0x1.14c8aa92af34dp+942,    0x1.8c16cd8974537p-3,   -0x1.6fe8dp-3, INEXACT)
T(RN,   0x1.be0abd078084p+942,   -0x1.5d0ab8ac69977p-4,   -0x1.bee5bp-3, INEXACT)
T(RN,   0x1.d6527430127ep+942,    0x1.cb30574c5b3a9p-1,  -0x1.0ecd58p-3, INEXACT)
T(RN,  0x1.289255e930287p+942,    0x1.fdafa7162bad5p-1,   0x1.431ffap-3, INEXACT)
T(RN,  0x1.14200bba6d374p+942,    0x1.b8577762d4001p-3,   0x1.6563dap-2, INEXACT)
T(RN,  0x1.7dd35d72be6a2p+942,   -0x1.95a02335158cep-1,   0x1.6581c6p-2, INEXACT)
T(RN,  0x1.2a01480a183d2p+943,    0x1.690dfb79c52d2p-1,   0x1.7b6d32p-3, INEXACT)
T(RN,  0x1.3319de6a349eap+943,    0x1.8b52b2ba02c4bp-2,   0x1.83cd88p-2, INEXACT)
T(RN,  0x1.7a8205d78856cp+943,   -0x1.f4bc0848dc26bp-1,  -0x1.7c8ca2p-2, INEXACT)
T(RN,  0x1.4f22d2814ee0bp+943,    0x1.9eb25377ff8a3p-2,  -0x1.153c58p-8, INEXACT)
T(RN,  0x1.5b13871813068p+943,    0x1.ac53b32ab2ea1p-2,  -0x1.f7ec46p-3, INEXACT)
T(RN,  0x1.655712c2a5a94p+943,    -0x1.f3dc19d20be5p-1,  -0x1.19e59ep-4, INEXACT)
T(RN,  0x1.5b6dc5e68c20bp+943,   -0x1.af7b80edb6751p-1,   -0x1.2c15ep-5, INEXACT)
T(RN,  0x1.8b2abbf96e143p+943,   -0x1.17a59f57b3de9p-2,   0x1.0ff1bcp-7, INEXACT)
T(RN,  0x1.336ca91c63523p+943,    0x1.b042b21be0bdep-2,   0x1.da7a12p-2, INEXACT)
T(RN,  0x1.b6e74c831a09ap+943,   -0x1.c90aff533e98ap-2,   0x1.2a4b08p-2, INEXACT)
T(RN,  0x1.1a1b4f871aaccp+944,    0x1.04f3242c29042p-1,  -0x1.16e542p-3, INEXACT)
T(RN,  0x1.4230855d8c7fdp+944,   -0x1.ad1f9fe387229p-1,   0x1.538104p-2, INEXACT)
T(RN,  0x1.3e248f6036c1ap+944,    0x1.013dee89ad9a2p-1,  -0x1.b4c4dap-3, INEXACT)
T(RN,   0x1.8536e10b8942p+944,   -0x1.41d8019e241bcp-3,  -0x1.157d1ep-3, INEXACT)
T(RN,  0x1.559bf0aa8e80ep+944,   -0x1.fee4b9ae8c045p-1,  -0x1.e2aaf6p-2, INEXACT)
T(RN,  0x1.6762f5acfc762p+944,   -0x1.5003a55141716p-1,  -0x1.629e24p-3, INEXACT)
T(RN,  0x1.bbacf90ebb0dfp+944,   -0x1.c66adbb41508fp-3,   0x1.07948cp-4, INEXACT)
T(RN,  0x1.7598f7f1409d5p+944,   -0x1.58a3036331389p-4,   0x1.1e11b6p-3, INEXACT)
T(RN,  0x1.e06859a352a1ep+944,   -0x1.ffafd6981fa15p-1,  -0x1.de01eap-2, INEXACT)
T(RN,  0x1.6926cfd453afep+944,     0x1.a19a2b26e448p-1,  -0x1.0332cap-2, INEXACT)
T(RN,  0x1.a1ead3564067dp+945,   -0x1.86618e155fb67p-1,   0x1.d5c35ap-2, INEXACT)
T(RN,  0x1.123272c5eb45dp+945,    0x1.9a307fb87d0c8p-2,  -0x1.a43c92p-2, INEXACT)
T(RN,  0x1.e26c6ee54cb7bp+945,    0x1.5d8e8fa64c321p-1,   0x1.4d2438p-5, INEXACT)
T(RN,  0x1.c900a56aecea6p+945,    0x1.f0a8c977ed755p-1,   0x1.7bfcbep-8, INEXACT)
T(RN,  0x1.8c531ac0f4dd6p+945,    0x1.10e8c60ebb57cp-1,   0x1.79ded2p-2, INEXACT)
T(RN,  0x1.38288c01f0c44p+945,    0x1.e0e1465f176f8p-1,   0x1.bb891cp-3, INEXACT)
T(RN,  0x1.8fb8c96bbb815p+945,   -0x1.7f7f6346fd142p-3,   0x1.7702dcp-5, INEXACT)
T(RN,  0x1.4a9ee5654771cp+945,   -0x1.da9e816c18cffp-2,   0x1.da0fb6p-3, INEXACT)
T(RN,  0x1.dcc8c00f02034p+945,   -0x1.65441a86651bep-3,  -0x1.9dfaacp-3, INEXACT)
T(RN,  0x1.7b9a7d13adcedp+945,    0x1.90372c34cf821p-1,   0x1.88fce8p-6, INEXACT)
T(RN,  0x1.3f875b5f90156p+946,    -0x1.e67a06e37d3bp-1,   0x1.1446cep-2, INEXACT)
T(RN,   0x1.86739ecc47bep+946,     0x1.6e9319761f9ep-2,    0x1.e85c5p-3, INEXACT)
T(RN,  0x1.93f7344666952p+946,    0x1.126d58f78aa1ep-3,   0x1.5725f8p-2, INEXACT)
T(RN,  0x1.f4a9c1f71220ap+946,   -0x1.b148de57e176dp-1,   0x1.bbf42ep-2, INEXACT)
T(RN,   0x1.75a59293b2f1p+946,    0x1.fcdd010995b73p-1,   0x1.30510ep-2, INEXACT)
T(RN,  0x1.1c116308639dap+946,   -0x1.7628eb73e1a21p-2,   0x1.3593aap-4, INEXACT)
T(RN,  0x1.0a53997a462f5p+946,   -0x1.30dd46a326676p-1,   0x1.f396a4p-5, INEXACT)
T(RN,  0x1.143e5c9df442bp+946,   -0x1.6297a484edfdcp-2,  -0x1.c3ef8cp-2, INEXACT)
T(RN,  0x1.447dbbf437252p+946,   -0x1.d53a13a30b02fp-2,   0x1.2da8e6p-2, INEXACT)
T(RN,  0x1.5ffefd6b4fccbp+946,    0x1.8ed3efdc6a203p-2,   0x1.38fd58p-2, INEXACT)
T(RN,  0x1.722754ecbc253p+947,   -0x1.ec4d183ffd5d9p-2,  -0x1.790f92p-2, INEXACT)
T(RN,  0x1.bcf920b65debcp+947,    0x1.8e77e944586f3p-1,  -0x1.b222bap-3, INEXACT)
T(RN,  0x1.a812db8e283e4p+947,   -0x1.21c47aea007efp-1,   0x1.fd425ap-2, INEXACT)
T(RN,  0x1.521e7b0cd124cp+947,   -0x1.1376c9c98142dp-1,  -0x1.cf0144p-2, INEXACT)
T(RN,  0x1.3ba2c38e18754p+947,    0x1.7b48373d539f7p-2,   0x1.fd8c76p-7, INEXACT)
T(RN,  0x1.e68dcc783e5e4p+947,   -0x1.0c16690e68477p-3,    0x1.e3391p-2, INEXACT)
T(RN,  0x1.ff6a07ecda294p+947,    0x1.ff309716c47afp-1,   0x1.5bfbd8p-4, INEXACT)
T(RN,   0x1.69ce3880312cp+947,   -0x1.bc9944ed31127p-1,   0x1.27ea0cp-2, INEXACT)
T(RN,  0x1.9296967090a66p+947,   -0x1.5fd0bf5488a2dp-1,   0x1.bb2408p-2, INEXACT)
T(RN,  0x1.829ce641047b5p+947,   -0x1.ee15ebb6c7976p-1,  -0x1.0d14b2p-4, INEXACT)
T(RN,  0x1.82fbc66f7ce14p+948,    0x1.b4683a7d44cf3p-1,  -0x1.43e0fep-8, INEXACT)
T(RN,  0x1.d8d94fb15939ep+948,    0x1.fffdbc6e594f4p-1,  -0x1.2f407ap-2, INEXACT)
T(RN,  0x1.138f599d799dcp+948,    0x1.4c4e3a666865ep-2,  -0x1.a4bd18p-2, INEXACT)
T(RN,   0x1.60965a8d6035p+948,   -0x1.fbe989a28df29p-1,  -0x1.7f5b9cp-2, INEXACT)
T(RN,   0x1.4540a9ab0332p+948,    0x1.196929b2309d8p-2,   -0x1.01d5cp-2, INEXACT)
T(RN,  0x1.5fb4eb6b2e26cp+948,   -0x1.fffcf5a0bbb4ep-1,   0x1.288e42p-2, INEXACT)
T(RN,  0x1.726e34eac0ad6p+948,   -0x1.35487de96b3b6p-1,   0x1.9acc64p-2, INEXACT)
T(RN,  0x1.eadedd597956ep+948,    0x1.a22cce5dfbd8cp-1,  -0x1.95e07ep-2, INEXACT)
T(RN,  0x1.720a3ce77b576p+948,    0x1.8ccb92c2bd58dp-3,   0x1.b91948p-2, INEXACT)
T(RN,  0x1.469685a3a9362p+948,   -0x1.42c2711dc2bf2p-3,   0x1.c97478p-2, INEXACT)
T(RN,  0x1.0f6db179cd64dp+949,    0x1.945a342e887dep-1,   0x1.5647b4p-2, INEXACT)
T(RN,  0x1.170d9442922fbp+949,    0x1.5124fd1da6856p-1,  -0x1.c8ba82p-4, INEXACT)
T(RN,    0x1.beddf2a173ep+949,   -0x1.e23dff7e3e879p-9,  -0x1.51925cp-2, INEXACT)
T(RN,  0x1.03201958406c3p+949,    0x1.f636199aeaab7p-1,  -0x1.0ca7dcp-2, INEXACT)
T(RN,  0x1.395dddb20a7e2p+949,    0x1.f9a85210f4e5ep-1,  -0x1.05af9ap-2, INEXACT)
T(RN,  0x1.e6b5df243152ep+949,   -0x1.b5b7299259f63p-1,   -0x1.f75e5p-3, INEXACT)
T(RN,  0x1.46c7635edafa2p+949,   -0x1.631f75c746176p-2,  -0x1.93c374p-3, INEXACT)
T(RN,   0x1.98219d69c29bp+949,   -0x1.3b7bee4fa506fp-1,   -0x1.69a1ap-3, INEXACT)
T(RN,  0x1.7d0b0a7c8adffp+949,     0x1.59b3d38b7389p-1,   0x1.b99e22p-2, INEXACT)
T(RN,   0x1.c7fabf34433cp+949,    0x1.acc1cf744bf43p-1,  -0x1.ed22ecp-2, INEXACT)
T(RN,  0x1.5f15b5e339a6cp+950,   -0x1.d5d4ad7ce69f7p-1,   0x1.16e22cp-2, INEXACT)
T(RN,  0x1.9c2e61980ca83p+950,   -0x1.83ce3da46ff2cp-2,  -0x1.c2086ap-2, INEXACT)
T(RN,  0x1.6ad9a8c8a4cdfp+950,    0x1.e71ac8633ecedp-2,   0x1.11047ap-2, INEXACT)
T(RN,  0x1.2b96066280b4ep+950,    0x1.80dff7354ef18p-1,   0x1.e1c3a8p-4, INEXACT)
T(RN,  0x1.04064ae4feb1fp+950,    -0x1.6236620763a9p-1,   0x1.562c1cp-3, INEXACT)
T(RN,  0x1.44b36e272a64dp+950,    0x1.33a051a54ea1dp-3,  -0x1.296acep-2, INEXACT)
T(RN,  0x1.25e260cd7f661p+950,   -0x1.eede410c3a353p-1,    0x1.b51eap-2, INEXACT)
T(RN,  0x1.9e579ac8e916bp+950,   -0x1.847b88ba5f17ep-2,   0x1.abc092p-5, INEXACT)
T(RN,  0x1.517de0aa8462cp+950,   -0x1.56c2ae4767fcfp-1,   0x1.5362dap-3, INEXACT)
T(RN,  0x1.09deb5630d87ep+950,    0x1.8e237b4040162p-5,   0x1.d8195ap-2, INEXACT)
T(RN,  0x1.18c2ce1e2cd55p+951,   -0x1.ce770f527928bp-2,   0x1.f8151ap-2, INEXACT)
T(RN,  0x1.e4b1163a18ed2p+951,    0x1.fa01961322ae3p-1,   0x1.155a0cp-2, INEXACT)
T(RN,  0x1.b8cf70d0e17c6p+951,   -0x1.3506f9d60faafp-3,  -0x1.259764p-4, INEXACT)
T(RN,  0x1.4f3e5ac4194cep+951,   -0x1.0126c3b1e9c19p-1,    0x1.e219dp-2, INEXACT)
T(RN,  0x1.6af0fa40c2ea8p+951,   -0x1.aecfb7bf487d5p-1,   0x1.5d922ep-2, INEXACT)
T(RN,  0x1.26bf0afb41bfbp+951,   -0x1.f0ce6313757bap-1,   0x1.69a04cp-2, INEXACT)
T(RN,  0x1.3800491e1b575p+951,    0x1.53e6da66615a6p-1,   0x1.419ec4p-2, INEXACT)
T(RN,  0x1.3c09039dbe776p+951,   -0x1.bc42d9a931eefp-1,   0x1.a8c062p-3, INEXACT)
T(RN,  0x1.20b4bdff71b09p+951,    0x1.304a9420708b6p-4,  -0x1.a4668ap-2, INEXACT)
T(RN,  0x1.985241457e548p+951,    0x1.b31f80d17f3b7p-1,   0x1.3d2504p-2, INEXACT)
T(RN,  0x1.f6e778adcf29cp+952,   -0x1.c32bb17ce8a21p-1,   0x1.c5915ap-2, INEXACT)
T(RN,  0x1.9dbecfd0e54ecp+952,   -0x1.fff7c5a8909f3p-1,  -0x1.4502e6p-2, INEXACT)
T(RN,  0x1.2092928f32621p+952,    0x1.ff959f0d1fc9ep-1,   0x1.7a190ap-2, INEXACT)
T(RN,  0x1.d49b5b95788b8p+952,     0x1.cd71da16592cp-2,   0x1.718e2cp-5, INEXACT)
T(RN,  0x1.87ed2a4c26822p+952,    -0x1.fa8b98218317p-1,  -0x1.0b91cep-3, INEXACT)
T(RN,  0x1.6aede057972a8p+952,   -0x1.fe577c34010c2p-1,   -0x1.fc78bp-5, INEXACT)
T(RN,  0x1.5b19b52aab175p+952,   -0x1.ff4eb11e40a53p-1,   0x1.9d4f32p-6, INEXACT)
T(RN,  0x1.fb1d14196c8e8p+952,   -0x1.271138ff2f769p-1,   0x1.83d8aep-4, INEXACT)
T(RN,  0x1.0553edddfd855p+952,   -0x1.887e98db1a854p-6,  -0x1.3e2e88p-2, INEXACT)
T(RN,  0x1.d8746c3068a3ep+952,   -0x1.a3569788f8629p-3,  -0x1.64c3fcp-2, INEXACT)
T(RN,  0x1.32d73fd865012p+953,    0x1.4d4352736fa4ap-1,    0x1.f929fp-5, INEXACT)
T(RN,  0x1.640aaad3d4b04p+953,    0x1.5476bb4e3d37fp-1,  -0x1.b56c4ep-6, INEXACT)
T(RN,  0x1.1877e125a6654p+953,    -0x1.e1d266aaeafdp-1,   0x1.99ba78p-5, INEXACT)
T(RN,  0x1.acd00c970d0d6p+953,   -0x1.11a9d2c90d3f6p-2,   0x1.fcc6aap-3, INEXACT)
T(RN,  0x1.80a0ea3216b7cp+953,    0x1.b591ebd6ee5aap-2,   0x1.685d1ap-3, INEXACT)
T(RN,   0x1.36e6cc796db2p+953,   -0x1.99626080c009bp-1,  -0x1.f8692ap-3, INEXACT)
T(RN,  0x1.089a68fb2ebcap+953,   -0x1.b437ddfe8e8cbp-1,  -0x1.a5d2e6p-2, INEXACT)
T(RN,  0x1.ea1f5c7c3591ap+953,   -0x1.ca4d732a87ab5p-3,   0x1.273d78p-2, INEXACT)
T(RN,  0x1.533ec70303efbp+953,   -0x1.fe1e9a31ee26dp-1,   0x1.f14d64p-4, INEXACT)
T(RN,  0x1.2e3cc45fb0402p+953,    0x1.9dcf32c2645cbp-2,   0x1.4257bcp-7, INEXACT)
T(RN,   0x1.1cab585550e5p+954,    0x1.3602d77a5996fp-3,  -0x1.c7e276p-3, INEXACT)
T(RN,  0x1.87c1144345a82p+954,    0x1.ddd75c63c27ffp-1,   0x1.5a324ep-8, INEXACT)
T(RN,  0x1.1c17badf269cep+954,    0x1.3672144266842p-2,   0x1.faece4p-2, INEXACT)
T(RN,  0x1.aacfa8af99e4ep+954,    0x1.973eb051ca215p-1,   0x1.6245bap-4, INEXACT)
T(RN,  0x1.1342fd850e479p+954,   -0x1.b079e85a51c17p-1,   0x1.03f33ap-2, INEXACT)
T(RN,  0x1.ca837f644698ep+954,    0x1.38cbdb7706612p-1,   0x1.de5eaap-2, INEXACT)
T(RN,  0x1.c65f457975be7p+954,   -0x1.61d01b505f1f8p-1,  -0x1.7c400cp-4, INEXACT)
T(RN,    0x1.d41a9b5f71fp+954,   -0x1.b3ab5542d275dp-1,  -0x1.9df43ap-3, INEXACT)
T(RN,  0x1.81af819d2194bp+954,    -0x1.fa4d927998bdp-1,  -0x1.ebf036p-3, INEXACT)
T(RN,  0x1.9ee48c6200098p+954,    0x1.7fa81920b27d3p-1,  -0x1.f7c328p-2, INEXACT)
T(RN,  0x1.785b97eb4ae0bp+955,   -0x1.1406724064faep-1,   0x1.979aa4p-3, INEXACT)
T(RN,  0x1.1ff8db598bc62p+955,   -0x1.6f211dd6b1d13p-2,  -0x1.7b46b8p-2, INEXACT)
T(RN,  0x1.671a4aed1823bp+955,   -0x1.726393dd5a0f2p-2,   0x1.210c3ep-2, INEXACT)
T(RN,  0x1.1820be2043fd2p+955,   -0x1.b39d8340cb75dp-1,   -0x1.174d4p-5, INEXACT)
T(RN,  0x1.531cccea9a77ap+955,   -0x1.6805395aa7dd7p-1,   0x1.62a42cp-2, INEXACT)
T(RN,  0x1.772d5c479bf1ap+955,   -0x1.c1fbbdc8b6aaap-1,  -0x1.56ca16p-2, INEXACT)
T(RN,  0x1.9a3f89718b87ep+955,    0x1.ef7c61bb327c6p-2,   0x1.1ca29ap-2, INEXACT)
T(RN,   0x1.7d96ced2d939p+955,    0x1.26041b0b7ac46p-2,  -0x1.d38ae2p-2, INEXACT)
T(RN,  0x1.a195faf5218bep+955,   -0x1.b33e2e3cf3df8p-1,  -0x1.e20f34p-2, INEXACT)
T(RN,  0x1.4ef199681f3cep+955,     0x1.a72bfd7435f2p-1,   0x1.26bcc8p-3, INEXACT)
T(RN,  0x1.bae5e8c85f7bfp+956,    -0x1.c3f8432f1e9bp-1,  -0x1.a45ce8p-2, INEXACT)
T(RN,  0x1.665ed040a2823p+956,   -0x1.fb43408d1207ap-1,  -0x1.f89ab6p-2, INEXACT)
T(RN,  0x1.0192f102a5a08p+956,    0x1.53a5efb976f47p-1,    0x1.56138p-3, INEXACT)
T(RN,  0x1.5a917876b8366p+956,   -0x1.57bee1ae278c9p-2,   0x1.b6ba62p-8, INEXACT)
T(RN,  0x1.095601ae53269p+956,    0x1.eace60a764ea1p-1,  -0x1.7a8092p-2, INEXACT)
T(RN,  0x1.086bacf00c76cp+956,    0x1.17c8b48e25fd4p-3,   0x1.fcaff8p-2, INEXACT)
T(RN,  0x1.ed5d1e556022ep+956,   -0x1.d5412126e10d3p-1,   0x1.c28892p-2, INEXACT)
T(RN,  0x1.2818210baa15ep+956,    0x1.ff64579e66be6p-1,  -0x1.b6c472p-3, INEXACT)
T(RN,  0x1.bb93fd0353b92p+956,    0x1.66ec7d16b6221p-2,   -0x1.6adcdp-2, INEXACT)
T(RN,   0x1.0d0a47ac75c2p+956,   -0x1.16f22fe550b0ep-1,  -0x1.29efc2p-2, INEXACT)
T(RN,  0x1.43737c0869494p+957,   -0x1.535f86e7a2e92p-1,  -0x1.f48ce6p-2, INEXACT)
T(RN,  0x1.1518da9a1d1bdp+957,   -0x1.c492906277e76p-1,   -0x1.9f48ep-2, INEXACT)
T(RN,  0x1.4f77c35b5ae48p+957,    0x1.cac6fee6e5fc8p-2,  -0x1.8a090ep-2, INEXACT)
T(RN,  0x1.249b0b8fb5165p+957,   -0x1.a94806caa31bdp-2,   -0x1.060dfp-4, INEXACT)
T(RN,  0x1.a87b14cda499ep+957,   -0x1.7950c2fa1eda4p-1,   0x1.8ff518p-3, INEXACT)
T(RN,  0x1.0dd420359212cp+957,   -0x1.ffce20be5ecf7p-1,  -0x1.bf2a68p-2, INEXACT)
T(RN,  0x1.096274ce81318p+957,    -0x1.55ab1a0e6518p-4,  -0x1.d14daap-3, INEXACT)
T(RN,  0x1.39e7a26acab06p+957,    0x1.a8dde792a1806p-3,   0x1.929538p-4, INEXACT)
T(RN,  0x1.3d1c5a057c0ecp+957,    0x1.fcbe6ebfaeb8fp-1,  -0x1.34413ep-2, INEXACT)
T(RN,  0x1.c05478bb40863p+957,    -0x1.f7216f9e1a1ap-1,   0x1.d8f338p-4, INEXACT)
T(RN,  0x1.13b41aa0b2eb4p+958,   -0x1.ee392a970ca67p-1,   0x1.e9dad8p-2, INEXACT)
T(RN,  0x1.cdf724983c5b2p+958,   -0x1.e7778fac028a8p-4,  -0x1.ca5654p-2, INEXACT)
T(RN,  0x1.6db731b676a73p+958,    0x1.69b1313a6317bp-1,    -0x1.1ac2p-6, INEXACT)
T(RN,  0x1.521dc464d484ap+958,   -0x1.a0ea4f94982a1p-1,   0x1.8b61f2p-2, INEXACT)
T(RN,  0x1.0ccaf4d3a2777p+958,     0x1.f4ce4fe1183cp-1,  -0x1.8ce57cp-2, INEXACT)
T(RN,  0x1.0567b95bad90dp+958,   -0x1.8d6e3b50c2854p-1,   -0x1.2061bp-2, INEXACT)
T(RN,  0x1.ec4139dfb6992p+958,   -0x1.2f9f05197844fp-2,  -0x1.c88772p-3, INEXACT)
T(RN,  0x1.56b08286754c4p+958,    0x1.fa2d35de9d1b1p-1,  -0x1.72db02p-2, INEXACT)
T(RN,  0x1.57f4323f33c75p+958,    0x1.8bc2e0544bbb9p-3,  -0x1.44fea2p-2, INEXACT)
T(RN,  0x1.5e5dbbd56e446p+958,    0x1.bb494aa3f2f85p-1,   -0x1.23b9cp-4, INEXACT)
T(RN,  0x1.6b9cffced2238p+959,   -0x1.fdfc9fec389bdp-1,  -0x1.85909cp-2, INEXACT)
T(RN,  0x1.464dcede4be61p+959,    0x1.f535b74d1637cp-1,   0x1.8988e4p-3, INEXACT)
T(RN,  0x1.68c100a7b9de8p+959,    0x1.3fdcce41417e3p-5,   0x1.1d7942p-3, INEXACT)
T(RN,  0x1.84c2669dadf0ap+959,   -0x1.c730bd34351fap-1,  -0x1.a2c834p-3, INEXACT)
T(RN,  0x1.7539505987c31p+959,    0x1.4b8011ef8e355p-3,   -0x1.5d7c8p-2, INEXACT)
T(RN,  0x1.5767015ae3abap+959,   -0x1.51918a6411d77p-2,   0x1.47ac76p-3, INEXACT)
T(RN,  0x1.2744a0fefad68p+959,    0x1.5fe0f124ec899p-8,  -0x1.47cd22p-2, INEXACT)
T(RN,  0x1.7bb9dfe730513p+959,    0x1.dee0a706b9663p-1,  -0x1.feada4p-2, INEXACT)
T(RN,  0x1.4c725c474838dp+959,   -0x1.ce7774ca7a8dap-1,   0x1.aaead4p-3, INEXACT)
T(RN,   0x1.c42e278d3fbdp+959,    0x1.a8302b4065625p-1,  -0x1.4100eap-2, INEXACT)
T(RN,  0x1.e7262655386a5p+960,    0x1.cc5bc24e96ad8p-1,   0x1.267b14p-2, INEXACT)
T(RN,  0x1.135eea856d4e4p+960,   -0x1.07276287d36e4p-1,   -0x1.bd32fp-2, INEXACT)
T(RN,   0x1.f436ccf42157p+960,   -0x1.b9336ab27fd26p-1,  -0x1.115534p-4, INEXACT)
T(RN,   0x1.f921208e1f2cp+960,    0x1.ffbbce96b975ep-1,   0x1.fc2446p-2, INEXACT)
T(RN,  0x1.bb62b2e4e33ccp+960,   -0x1.3274b4c3bf034p-1,   0x1.d3e424p-3, INEXACT)
T(RN,  0x1.687f3978774f3p+960,   -0x1.a2f4c2aa62063p-3,   0x1.1785cap-2, INEXACT)
T(RN,  0x1.a58792b499dfap+960,    0x1.df25f7fec0b9dp-1,   0x1.88903ep-5, INEXACT)
T(RN,  0x1.446f7df82a73dp+960,    0x1.cff76c605d37dp-1,   0x1.31a716p-3, INEXACT)
T(RN,  0x1.b8caa460c5d24p+960,    0x1.cd53523242912p-1,   0x1.f001d4p-3, INEXACT)
T(RN,  0x1.14294c0287876p+960,    0x1.7a2bc1bfe478ap-3,  -0x1.1b85e4p-2, INEXACT)
T(RN,  0x1.dd45105cddc22p+961,    0x1.c1dc182a5dd15p-2,  -0x1.0c5a62p-2, INEXACT)
T(RN,  0x1.5e7df7d369d49p+961,   -0x1.b0a978de67183p-1,  -0x1.b8bf36p-4, INEXACT)
T(RN,  0x1.b039742805e08p+961,   -0x1.bf0300d13a81ap-1,  -0x1.43a4e4p-3, INEXACT)
T(RN,  0x1.87828f176c76cp+961,   -0x1.cc6ef60c15c41p-1,  -0x1.f1dba8p-4, INEXACT)
T(RN,  0x1.12cb0f89f5f35p+961,   -0x1.af09ea7809d6dp-3,  -0x1.004a82p-2, INEXACT)
T(RN,  0x1.0789a172b6691p+961,   -0x1.465c8e4e00216p-1,  -0x1.26cde2p-3, INEXACT)
T(RN,  0x1.f27185fccb3fbp+961,    0x1.2e97e6d7de666p-1,   0x1.cefad6p-2, INEXACT)
T(RN,  0x1.b5547ae114046p+961,    0x1.a4349dfcb20b4p-1,  -0x1.456c06p-3, INEXACT)
T(RN,  0x1.c78a9d059c7fcp+961,   -0x1.dd43e96c6e6e6p-1,   0x1.89aa9ap-2, INEXACT)
T(RN,  0x1.9bfbedc0abd4ap+961,   -0x1.6e0bb2235066cp-2,   0x1.6c293ep-3, INEXACT)
T(RN,  0x1.79f46de9bd6b2p+962,    0x1.c12c758ca159cp-1,    0x1.f8724p-3, INEXACT)
T(RN,  0x1.fd91ddb3a3db4p+962,   -0x1.e7ab465aee827p-1,  -0x1.1440b4p-4, INEXACT)
T(RN,  0x1.4dc373ed776d2p+962,   -0x1.ded04b245a923p-1,  -0x1.0a4c76p-6, INEXACT)
T(RN,  0x1.3ae6b10c4c096p+962,   -0x1.c496801331029p-2,   -0x1.85b7dp-2, INEXACT)
T(RN,  0x1.a90fc8259e0bcp+962,   -0x1.ff908e7a93517p-1,     0x1.cb13p-3, INEXACT)
T(RN,   0x1.320927b0ff82p+962,    0x1.26947195c1716p-3,  -0x1.ae0002p-2, INEXACT)
T(RN,  0x1.8723c69de9d18p+962,    0x1.0a54ab1d8573cp-2,  -0x1.4faa7ap-3, INEXACT)
T(RN,  0x1.c2f6b5210bd14p+962,   -0x1.311f9f69935dbp-1,    0x1.e1766p-3, INEXACT)
T(RN,  0x1.0475f340fd993p+962,    0x1.da28b7813d8e8p-1,  -0x1.f00086p-3, INEXACT)
T(RN,  0x1.e88406a7d4e46p+962,   -0x1.ffcbf524f51a7p-1,    0x1.352dfp-3, INEXACT)
T(RN,  0x1.d17899711604cp+963,    0x1.7e3562a239106p-1,  -0x1.d2cdeap-3, INEXACT)
T(RN,  0x1.9fec202dd129ep+963,   -0x1.345b291b68346p-1,   0x1.e54046p-2, INEXACT)
T(RN,  0x1.13cf52b301eeap+963,   -0x1.ee937fc69d2dcp-1,   0x1.3f3774p-2, INEXACT)
T(RN,  0x1.c943f8cacdf28p+963,    0x1.46f27a207d7ccp-1,   0x1.1f54d4p-5, INEXACT)
T(RN,  0x1.d128ba9e181f1p+963,   -0x1.9e2dfac365758p-2,  -0x1.353c92p-5, INEXACT)
T(RN,  0x1.235d9e18abfd4p+963,    0x1.49f0ab8f910e5p-1,   0x1.4e3ba8p-5, INEXACT)
T(RN,  0x1.3d0fe8553ddfap+963,     0x1.edd7d421f5c9p-1,   0x1.a181d8p-2, INEXACT)
T(RN,   0x1.8f36df2cc811p+963,   -0x1.e86b743560401p-1,  -0x1.dbf522p-4, INEXACT)
T(RN,  0x1.f7e752286a5dcp+963,   -0x1.3d3fc00d91198p-1,    0x1.4c896p-5, INEXACT)
T(RN,  0x1.3dc2ebbac7bfep+963,   -0x1.d5d584a307fc2p-1,   -0x1.18b5fp-2, INEXACT)
T(RN,  0x1.79df65f7ef662p+964,   -0x1.f356fda65c448p-1,   0x1.ea7a92p-5, INEXACT)
T(RN,  0x1.989d24a870684p+964,   -0x1.e566e2f1960e3p-1,  -0x1.0a7328p-3, INEXACT)
T(RN,  0x1.2c5e81aaef683p+964,   -0x1.7917675ba9653p-3,   0x1.98e384p-3, INEXACT)
T(RN,  0x1.7058c7cb8dcc8p+964,   -0x1.64205ea9c243ap-1,   0x1.aa2842p-4, INEXACT)
T(RN,  0x1.1838a0a205365p+964,   -0x1.f8f4cebfc4895p-1,  -0x1.a7ee6ep-4, INEXACT)
T(RN,  0x1.7377e13708762p+964,    0x1.07ea45c14e4b3p-1,   0x1.e07e62p-2, INEXACT)
T(RN,  0x1.0ff46ca8a9f7ap+964,     0x1.b12d68f94fc2p-1,  -0x1.1a64cap-2, INEXACT)
T(RN,   0x1.a5f65e32494ep+964,    0x1.b57195e3e8a35p-2,  -0x1.72a178p-2, INEXACT)
T(RN,  0x1.af9b8f454c94bp+964,   -0x1.0191a907a3178p-4,   0x1.b85c9ap-2, INEXACT)
T(RN,  0x1.07a3862fe865bp+964,   -0x1.eab5e6899ba6bp-2,  -0x1.54330cp-2, INEXACT)
T(RN,  0x1.96b8614ab7052p+965,    0x1.fff2a425781a6p-1,   0x1.3545d4p-3, INEXACT)
T(RN,  0x1.d50ca699199f1p+965,    0x1.af450d8c065f5p-1,   0x1.1001dap-2, INEXACT)
T(RN,  0x1.9726a8ee2f422p+965,    0x1.4cd8b01fae769p-2,   0x1.64323ep-2, INEXACT)
T(RN,  0x1.1e7387220524ep+965,   -0x1.8986215abb513p-1,    0x1.f95ecp-2, INEXACT)
T(RN,  0x1.8a5b5da257e9fp+965,   -0x1.a3d4969a090fbp-1,   0x1.0353a6p-2, INEXACT)
T(RN,  0x1.02dedfeec5a4ep+965,   -0x1.b78f30738ed51p-1,  -0x1.57d2f8p-2, INEXACT)
T(RN,   0x1.7e7ebd881004p+965,   -0x1.304bba0968293p-2,   0x1.9f048ap-3, INEXACT)
T(RN,   0x1.1f20720404d5p+965,    0x1.ee6bb8c479132p-1,  -0x1.bfc484p-4, INEXACT)
T(RN,  0x1.e4ba0b557f828p+965,    0x1.d18949d2f0cfbp-1,  -0x1.4ac5f4p-5, INEXACT)
T(RN,  0x1.0504fa88aadfap+965,     -0x1.d8695a5b6dcp-1,  -0x1.26f9b8p-3, INEXACT)
T(RN,  0x1.984a719138995p+966,   -0x1.00db1f5df7a05p-1,  -0x1.a77ae6p-4, INEXACT)
T(RN,  0x1.f5fbbf2d2f2a6p+966,   -0x1.cfeb99c9d5a19p-1,  -0x1.bad13cp-2, INEXACT)
T(RN,  0x1.273d685a14952p+966,    0x1.ef2434241de13p-2,  -0x1.269122p-3, INEXACT)
T(RN,  0x1.a18b98abc0386p+966,   -0x1.f04f54c293756p-1,   0x1.ab7bf4p-2, INEXACT)
T(RN,  0x1.a5152a0781023p+966,   -0x1.6e81ce8240f2dp-2,   -0x1.cb865p-3, INEXACT)
T(RN,  0x1.ebe863c56a814p+966,    0x1.43464b15df48ap-3,   -0x1.8066cp-2, INEXACT)
T(RN,  0x1.8d5de646a2e46p+966,   -0x1.e77143347f324p-1,    0x1.e076dp-4, INEXACT)
T(RN,  0x1.a6dbd21f5933ep+966,    0x1.91ab451863075p-1,  -0x1.6041b4p-4, INEXACT)
T(RN,  0x1.8a4fe149565b8p+966,    0x1.d0213f8f32f31p-1,   0x1.f20832p-2, INEXACT)
T(RN,  0x1.10ac78adab954p+966,    0x1.665945f8aafa5p-1,  -0x1.82058cp-2, INEXACT)
T(RN,  0x1.db233d04ebea1p+967,   -0x1.daef53fae387bp-6,  -0x1.bd00f6p-3, INEXACT)
T(RN,  0x1.5d9fb93565a58p+967,   -0x1.eb86d0f21e2aap-1,  -0x1.aa6842p-2, INEXACT)
T(RN,  0x1.aed86fe0ae772p+967,    0x1.9382ebe6a9d47p-4,   0x1.46043ep-4, INEXACT)
T(RN,  0x1.fb24d2dc70908p+967,   -0x1.f6223e4848b33p-2,  -0x1.64035cp-3, INEXACT)
T(RN,  0x1.01e7584cba93ap+967,   -0x1.a3f7a7842566fp-1,    0x1.42951p-2, INEXACT)
T(RN,  0x1.00d1b248f13b4p+967,   -0x1.0a284038b42dep-2,  0x1.abdb36p-10, INEXACT)
T(RN,  0x1.c962f492d5bb6p+967,    0x1.77847770e1f53p-1,    0x1.ec9f3p-8, INEXACT)
T(RN,   0x1.c3a698dfaa6cp+967,    0x1.d1fc3e8515aadp-5,   0x1.18c238p-3, INEXACT)
T(RN,   0x1.220037d2b4cdp+967,    0x1.a7321342c652ep-1,   0x1.92f3cap-4, INEXACT)
T(RN,  0x1.9e37d307d414dp+967,    0x1.abc4936f4386ep-2,   -0x1.6eed4p-6, INEXACT)
T(RN,  0x1.2ab0b695db13ep+968,    0x1.6108030a00361p-1,  -0x1.cbfa82p-6, INEXACT)
T(RN,  0x1.3295c501c903dp+968,    0x1.c220701325717p-3,   0x1.8077eep-3, INEXACT)
T(RN,  0x1.9864270a7d69cp+968,    0x1.f4d73826a026bp-1,  -0x1.71e6e6p-2, INEXACT)
T(RN,  0x1.8e2385f32a24ep+968,    0x1.3a3632bbe0ce1p-4,  -0x1.6560f4p-4, INEXACT)
T(RN,  0x1.578e768dbf2c5p+968,   -0x1.425fdf4c28d7ap-1,   0x1.a82cc4p-3, INEXACT)
T(RN,  0x1.463448e4f1a02p+968,   -0x1.f4cc4b6f6f10bp-1,   0x1.687bb2p-7, INEXACT)
T(RN,  0x1.dcc7b0e0e794ap+968,   -0x1.24ae18bd36364p-4,   0x1.f2466ep-2, INEXACT)
T(RN,  0x1.360ee14a5dfc6p+968,   -0x1.e09582b9782fbp-1,  -0x1.b5d9f4p-3, INEXACT)
T(RN,  0x1.a69438c17692ep+968,   -0x1.777ba6d6ac1bdp-4,  -0x1.691852p-3, INEXACT)
T(RN,  0x1.2cdfdfb809581p+968,   -0x1.1d19f53ea31afp-1,   0x1.aa9bd6p-2, INEXACT)
T(RN,  0x1.9f1103b09c714p+969,    0x1.8aaf2d81d4adbp-1,  -0x1.e5c69cp-2, INEXACT)
T(RN,   0x1.e023e6801169p+969,   -0x1.f04fdbc545dbcp-2,   0x1.5c2a84p-2, INEXACT)
T(RN,   0x1.da79a17dbfc2p+969,   -0x1.f7dbc8dbfef4ap-1,   0x1.1e0872p-4, INEXACT)
T(RN,  0x1.dc8fdf77c907cp+969,    0x1.ffc886d90f6b2p-1,   0x1.d523c6p-2, INEXACT)
T(RN,   0x1.e4d125fa055ep+969,   -0x1.4c934545c9712p-2,  -0x1.514e3ap-2, INEXACT)
T(RN,  0x1.f21346d7424cfp+969,    0x1.e806f51934b8ep-1,  -0x1.7a1e72p-2, INEXACT)
T(RN,  0x1.88c3433faa618p+969,    0x1.bb92188d22275p-1,  -0x1.db0744p-2, INEXACT)
T(RN,  0x1.5557929e606c1p+969,   -0x1.3c9367169f897p-2,  -0x1.28d9d8p-3, INEXACT)
T(RN,  0x1.de1e65400f3f8p+969,    0x1.af921906c2c5bp-1,    0x1.caf67p-5, INEXACT)
T(RN,  0x1.1d46d922e45d8p+969,   -0x1.95601e792bd24p-2,  -0x1.15bf3ep-3, INEXACT)
T(RN,  0x1.6aa774c4772c3p+970,    0x1.feeefddabfe81p-5,   0x1.a8152cp-3, INEXACT)
T(RN,  0x1.4b0f0e49a2d2dp+970,    0x1.f21bbd929752cp-1,   0x1.29593cp-2, INEXACT)
T(RN,  0x1.a19b0b983f478p+970,   -0x1.2a2fb264dc579p-5,  -0x1.8ab8aep-2, INEXACT)
T(RN,  0x1.9b8418f678963p+970,   -0x1.21d446d0fbff5p-1,  -0x1.0e188ap-2, INEXACT)
T(RN,  0x1.bd652e6ed6ca9p+970,   -0x1.27659dca3d5f3p-1,  -0x1.25acbep-2, INEXACT)
T(RN,  0x1.5f460e5a441a5p+970,   -0x1.4545d13f0414fp-1,   0x1.b445ecp-4, INEXACT)
T(RN,  0x1.02c04ab03e492p+970,    0x1.aecbcf376e83bp-1,  -0x1.fcf9cep-2, INEXACT)
T(RN,  0x1.a64cac94ffc6cp+970,    0x1.fcfc4e05db3c9p-2,   0x1.385da4p-2, INEXACT)
T(RN,  0x1.d2c6cb2bd1926p+970,   -0x1.cc8a1d81b5b46p-1,    0x1.2acf6p-2, INEXACT)
T(RN,  0x1.5854aa1dc9845p+970,   -0x1.eed4b81324b4dp-1,   0x1.6bbe9ep-3, INEXACT)
T(RN,  0x1.1cd42b06d74afp+971,   -0x1.5348b68ccca2ap-1,    0x1.8f4c7p-3, INEXACT)
T(RN,  0x1.005d1dc83abddp+971,   -0x1.c8fcaae787e14p-2,   0x1.7fc266p-2, INEXACT)
T(RN,  0x1.e250884ea5ab4p+971,   -0x1.f5441983e7833p-1,   -0x1.d56bep-4, INEXACT)
T(RN,  0x1.a0f25e889cf31p+971,    0x1.af3332f047a13p-1,    0x1.8f6f4p-3, INEXACT)
T(RN,  0x1.57a763cbccbe8p+971,   -0x1.5bdb50214b19dp-1,  -0x1.00fde2p-2, INEXACT)
T(RN,  0x1.aaf72d69c6ff8p+971,    0x1.141887ba48d28p-2,   0x1.744e3cp-2, INEXACT)
T(RN,  0x1.362e22695b07fp+971,    0x1.e5c11f1e8507cp-3,   0x1.7734acp-3, INEXACT)
T(RN,  0x1.aada6702f18ccp+971,   -0x1.eaeaaeed12fb6p-1,   0x1.3146dcp-4, INEXACT)
T(RN,  0x1.d4aec4577d70dp+971,    0x1.2e068f5731606p-1,  -0x1.745e14p-4, INEXACT)
T(RN,  0x1.8267e91a1fee2p+971,   -0x1.996edd067b536p-1,   -0x1.e1446p-2, INEXACT)
T(RN,  0x1.eb868da632618p+972,   -0x1.ff494e9d604c7p-1,   0x1.2508fap-3, INEXACT)
T(RN,  0x1.751491b0340dcp+972,    0x1.4379c2527abc7p-2,   0x1.668558p-3, INEXACT)
T(RN,  0x1.ea9558a724bc6p+972,   -0x1.e8774b9771889p-1,  -0x1.5f7578p-4, INEXACT)
T(RN,  0x1.968e0bb629ab4p+972,    0x1.4df1ff8ad2ec3p-1,  -0x1.36dfc8p-4, INEXACT)
T(RN,  0x1.f9389636a6d9cp+972,   -0x1.09db94b3cab58p-1,    0x1.1f2abp-2, INEXACT)
T(RN,  0x1.bfd39de065261p+972,    0x1.8260c3e0a9ecap-5,   0x1.9670f6p-3, INEXACT)
T(RN,  0x1.06a13664f41eep+972,    0x1.f7cc50ed7d0aap-1,  -0x1.724e24p-2, INEXACT)
T(RN,  0x1.550eb058eba73p+972,   -0x1.51099b0de6614p-1,  -0x1.0f895ep-2, INEXACT)
T(RN,  0x1.2c55088353d2ep+972,    0x1.9bbb109911b26p-1,  -0x1.9be6ecp-3, INEXACT)
T(RN,  0x1.02513b4189e44p+972,    0x1.47f09a92554eep-1,   -0x1.7da01p-2, INEXACT)
T(RN,  0x1.29b416cb06c1dp+973,    0x1.f7ee5ab75426dp-1,  -0x1.8b3e78p-2, INEXACT)
T(RN,  0x1.665d26db4c0aep+973,    0x1.e551c41e019abp-1,   0x1.b3d15cp-4, INEXACT)
T(RN,  0x1.946f7a59a18aep+973,   -0x1.7d964a67618ffp-7,   0x1.7efdacp-2, INEXACT)
T(RN,  0x1.ce46730b8faf4p+973,    0x1.99021edec9e1bp-1,  -0x1.da9698p-2, INEXACT)
T(RN,  0x1.c53f3b1462954p+973,    0x1.c594981db0c28p-1,  -0x1.d7d1a6p-3, INEXACT)
T(RN,  0x1.f25139418bae7p+973,    0x1.ec806af9493cbp-2,   0x1.cff58ap-2, INEXACT)
T(RN,  0x1.6c6d0ccc3ed91p+973,    0x1.d9320d14892f8p-1,  0x1.32ad52p-13, INEXACT)
T(RN,  0x1.a3a5c287bf179p+973,    0x1.1ba1beeaa8ef5p-1,  -0x1.3558b6p-2, INEXACT)
T(RN,  0x1.aed4eae6352b7p+973,    0x1.a6c1b53ffdd67p-1,    0x1.a7b7dp-2, INEXACT)
T(RN,  0x1.14157aab1930cp+973,   -0x1.eb926797b0274p-1,  -0x1.353baep-2, INEXACT)
T(RN,  0x1.c7f8285157f9ep+974,   -0x1.a6b4b018d6fddp-4,   0x1.f38a1ep-2, INEXACT)
T(RN,  0x1.b50a6f86a7b6ep+974,    0x1.fc54fbbf4f6e6p-3,   -0x1.9c396p-3, INEXACT)
T(RN,  0x1.c985e62863b46p+974,    0x1.e799022994902p-5,   0x1.7bbeb8p-2, INEXACT)
T(RN,   0x1.ba2e39df482ep+974,   -0x1.4d9613b2a418dp-1,  -0x1.277a9cp-3, INEXACT)
T(RN,  0x1.4912c52216e92p+974,    0x1.f98773842e6d4p-1,  -0x1.beee9ap-2, INEXACT)
T(RN,  0x1.41c0866b5a08bp+974,     0x1.b20b30a5427dp-1,  -0x1.53a882p-5, INEXACT)
T(RN,  0x1.84141d330f063p+974,    0x1.c2deca56d9238p-1,  -0x1.0e6936p-2, INEXACT)
T(RN,  0x1.c0ea0c7f6186cp+974,   -0x1.913e0463ad9acp-5,  -0x1.68f3a6p-3, INEXACT)
T(RN,  0x1.7176feb52328ap+974,   -0x1.ffd81094f3878p-1,   0x1.dfe326p-2, INEXACT)
T(RN,  0x1.821377a67d1c8p+974,    0x1.ffeb795562971p-1,  -0x1.2f6f1ap-3, INEXACT)
T(RN,   0x1.42b6604c3f96p+975,    0x1.f782b7ec31683p-1,    0x1.05d4dp-2, INEXACT)
T(RN,  0x1.938ac4ec36318p+975,   -0x1.a712d7e5cd0aap-1,  -0x1.1d940cp-2, INEXACT)
T(RN,  0x1.247809acde32bp+975,   -0x1.fb58d0d7fd3ccp-1,   0x1.daaa42p-3, INEXACT)
T(RN,  0x1.adc531dfded1cp+975,    0x1.fd02c5dbcab27p-1,   0x1.e661c2p-2, INEXACT)
T(RN,  0x1.61c725b04d634p+975,   -0x1.365791b77f389p-1,   0x1.e28ffp-10, INEXACT)
T(RN,  0x1.7314e662a7ad5p+975,    0x1.7e6f3731c37a2p-4,   0x1.0a3f2cp-5, INEXACT)
T(RN,  0x1.ac8eebf87bd53p+975,   -0x1.8398be7213635p-1,  -0x1.138908p-2, INEXACT)
T(RN,   0x1.cc1d7bb3cfbap+975,   -0x1.42aaba3ab987dp-1,  -0x1.a780c2p-2, INEXACT)
T(RN,  0x1.ef7e180ede03ap+975,   -0x1.f3af693ebf12ap-1,  -0x1.e36c4ap-2, INEXACT)
T(RN,  0x1.f11bf340eeb7cp+975,   -0x1.d46f26397acc9p-1,   0x1.6147e2p-2, INEXACT)
T(RN,  0x1.186f253bbd7c4p+976,   -0x1.66593f2c47948p-5,  -0x1.db3e54p-3, INEXACT)
T(RN,  0x1.6f509daa5509dp+976,    0x1.d7d87d6ae7f63p-1,   0x1.5cc73ap-2, INEXACT)
T(RN,  0x1.563724d37ebccp+976,    0x1.a1ce4a652efd8p-3,   0x1.dabf68p-2, INEXACT)
T(RN,  0x1.36a189554c846p+976,    0x1.640ba2c15567cp-1,  -0x1.98d1dep-4, INEXACT)
T(RN,  0x1.449551355bf96p+976,    0x1.1629edfce67dep-4,  -0x1.db8042p-3, INEXACT)
T(RN,  0x1.6c8a44dc17cd4p+976,    0x1.87fa488d8ab4ap-4,   0x1.27990ap-2, INEXACT)
T(RN,  0x1.224b2fbec03f5p+976,   -0x1.8135e182c359ap-1,  -0x1.1f85b4p-2, INEXACT)
T(RN,  0x1.d8e7d64c36558p+976,   -0x1.24037b7d98ac4p-1,  -0x1.dc1034p-2, INEXACT)
T(RN,  0x1.cd582a93ab79ap+976,   -0x1.e829c03a5fd89p-1,  -0x1.941bb8p-2, INEXACT)
T(RN,  0x1.a6ba8d64fad58p+976,    -0x1.92e8d29ca34ap-3,   -0x1.50445p-2, INEXACT)
T(RN,  0x1.01cee4f553f5ep+977,   -0x1.42f8928e691a2p-1,  -0x1.76a396p-4, INEXACT)
T(RN,  0x1.bb46a905c871ep+977,    0x1.1cf69c07da038p-9,  -0x1.a1873cp-5, INEXACT)
T(RN,  0x1.376488ef4facfp+977,   -0x1.af3885406fe9ap-5,   -0x1.17409p-2, INEXACT)
T(RN,  0x1.48e19b6c3a739p+977,   -0x1.3d1e313fd3719p-1,  -0x1.c34deap-2, INEXACT)
T(RN,   0x1.a5852a05a7b8p+977,   -0x1.d27c095b3997ep-1,  -0x1.ab3a08p-5, INEXACT)
T(RN,  0x1.a63d8dc2d02d2p+977,   -0x1.fff03584a477ep-1,   -0x1.d11bcp-2, INEXACT)
T(RN,  0x1.f1e96793842bap+977,   -0x1.90498f44cea3dp-1,    0x1.4dd55p-2, INEXACT)
T(RN,  0x1.cb46e631c2b9cp+977,   -0x1.9f026bf64f9acp-4,   0x1.5b311ep-3, INEXACT)
T(RN,  0x1.e522f3fb49fd8p+977,    0x1.5dfc0105d8195p-1,   0x1.cdbc82p-4, INEXACT)
T(RN,   0x1.edaacaab0b3dp+977,    0x1.fbffc2653f635p-1,  -0x1.e29898p-2, INEXACT)
T(RN,  0x1.1465e15a2146fp+978,    0x1.f04f5c3a9f79ep-1,  -0x1.52052ap-4, INEXACT)
T(RN,  0x1.67696420c17e4p+978,   -0x1.f0b923fa9a1a6p-1,   -0x1.20f0dp-2, INEXACT)
T(RN,  0x1.6200e0cdf028ep+978,   -0x1.e3555c6e1463fp-1,    0x1.87407p-4, INEXACT)
T(RN,   0x1.41e8ec07a985p+978,   -0x1.32337a51787b6p-1,   0x1.81fb92p-4, INEXACT)
T(RN,  0x1.e0ab605690c74p+978,    0x1.d339a8b5d5dd6p-1,   0x1.810cbcp-3, INEXACT)
T(RN,  0x1.9a5295b79f18fp+978,   -0x1.877b1aaaa3b76p-1,  -0x1.7f8904p-4, INEXACT)
T(RN,  0x1.6059c07ffb5b8p+978,    0x1.fa91c0dfaf7a4p-1,  -0x1.873b84p-2, INEXACT)
T(RN,  0x1.b9e71abe08bbep+978,    0x1.46158464653dep-2,  -0x1.5213a8p-3, INEXACT)
T(RN,  0x1.0afbe68e1e7c8p+978,    0x1.9828a3e8873bap-1,   0x1.5144d8p-2, INEXACT)
T(RN,  0x1.3f7d863bfd8e8p+978,    0x1.d193d4cf897d5p-2,   0x1.53efdap-4, INEXACT)
T(RN,  0x1.00d51730d2ba7p+979,    -0x1.d8a8de0e1878p-1,   0x1.dcaa1ep-4, INEXACT)
T(RN,  0x1.a843e2b188f9cp+979,     -0x1.83b3e962d71p-2,   0x1.c84cc8p-2, INEXACT)
T(RN,  0x1.e570dde041ba4p+979,    0x1.47606ff22f23cp-8,  -0x1.97e812p-2, INEXACT)
T(RN,  0x1.e9c215e9c4ee3p+979,   -0x1.1bd052fbc0052p-1,   0x1.bad48cp-4, INEXACT)
T(RN,  0x1.666d108295ac4p+979,    0x1.cd5073b57882fp-1,   0x1.ea1ac6p-3, INEXACT)
T(RN,  0x1.a9514a91e4daap+979,    0x1.c13895ca5b8e5p-3,   0x1.63c858p-6, INEXACT)
T(RN,  0x1.ff9663e2a9b18p+979,   -0x1.f2bf499fe25b6p-1,  -0x1.fed188p-4, INEXACT)
T(RN,  0x1.ca93242296248p+979,    0x1.ffe9847fbe8edp-1,  -0x1.c9abaap-5, INEXACT)
T(RN,  0x1.c994fa370c30cp+979,    0x1.4c3f64e2b1433p-3,   0x1.53928ep-2, INEXACT)
T(RN,  0x1.9848f29c05851p+979,    0x1.05785a1c250b7p-3,  -0x1.a7d1e2p-2, INEXACT)
T(RN,  0x1.93c5ab40b88cep+980,   -0x1.efbd33495905dp-1,  -0x1.28d738p-5, INEXACT)
T(RN,  0x1.40082ee2bdebcp+980,    -0x1.0422815aa7eep-2,  -0x1.a955b6p-6, INEXACT)
T(RN,  0x1.91a475c5d9c5ep+980,   -0x1.5e97a8b07e134p-2,  -0x1.62f75ap-3, INEXACT)
T(RN,  0x1.67a60d537c3e4p+980,   -0x1.05d02c1f1f596p-2,  -0x1.72fe86p-2, INEXACT)
T(RN,  0x1.f131914c2700cp+980,    -0x1.32431cf32906p-1,   0x1.df0018p-2, INEXACT)
T(RN,  0x1.a3e23cd688756p+980,   -0x1.fcde96ca9470cp-1,   0x1.cd6a22p-2, INEXACT)
T(RN,  0x1.320a5f015734ap+980,    0x1.9fdb6d0db31fep-5,  -0x1.5d9476p-2, INEXACT)
T(RN,  0x1.d6fa424b7cc5ep+980,    0x1.eac0e40c03005p-1,    0x1.e5491p-2, INEXACT)
T(RN,  0x1.3341978815594p+980,   -0x1.fa9a368f15eaep-1,    0x1.6a364p-4, INEXACT)
T(RN,  0x1.aadca8619d3a4p+980,    -0x1.8b95d956d1a8p-1,   -0x1.ef815p-2, INEXACT)
T(RN,  0x1.68cbad49d8393p+981,     -0x1.1733bfbc09fp-1,   0x1.557ffep-2, INEXACT)
T(RN,  0x1.41afdde0703d9p+981,   -0x1.e4aeea5e750cbp-1,  -0x1.3baaa8p-2, INEXACT)
T(RN,  0x1.3e3dfad2baf21p+981,   -0x1.139f6783d88b3p-1,   0x1.06e7cap-2, INEXACT)
T(RN,  0x1.0a62a6813d9fbp+981,    0x1.18dd250fa15b2p-2,   0x1.57920ap-2, INEXACT)
T(RN,  0x1.f08050c8d5582p+981,    0x1.fda626b9998eep-1,   0x1.e2c23cp-2, INEXACT)
T(RN,  0x1.2ce6827d82ca3p+981,    0x1.fcddcbc79c9fbp-1,  -0x1.82ebecp-2, INEXACT)
T(RN,  0x1.52cfcb8b6f50dp+981,   -0x1.fd9bb065cd827p-1,  -0x1.bc0d66p-5, INEXACT)
T(RN,   0x1.b6b7b94368b1p+981,   -0x1.68bce637970cbp-1,  -0x1.8e1e7ap-3, INEXACT)
T(RN,  0x1.e61d1b29df074p+981,    0x1.fff5ab5877ddap-1,  -0x1.80c926p-4, INEXACT)
T(RN,  0x1.17a70ed2e1e59p+981,    0x1.6047ad9cf340bp-3,   0x1.3aee2ep-5, INEXACT)
T(RN,  0x1.1cdcb2f707edcp+982,    0x1.fb3abc2bd49acp-1,  -0x1.bf74ccp-2, INEXACT)
T(RN,  0x1.30883d03eb3c7p+982,   -0x1.5c70468ea65b4p-1,  -0x1.334e5cp-4, INEXACT)
T(RN,  0x1.cc1d1446594cfp+982,    0x1.beb6a112fb7e9p-6,   0x1.e1987ap-3, INEXACT)
T(RN,  0x1.d4f7d494edf1ep+982,    0x1.2d725e6d117eep-2,   0x1.140ce8p-2, INEXACT)
T(RN,   0x1.400674202a78p+982,    0x1.bb0fefd613ce9p-3,  -0x1.e753cap-4, INEXACT)
T(RN,  0x1.2018396743e22p+982,    0x1.fffea2ed5f824p-1,   0x1.4e7bbcp-2, INEXACT)
T(RN,  0x1.72cbf669ccc76p+982,    0x1.fda5b5b6ba445p-1,  -0x1.827546p-2, INEXACT)
T(RN,  0x1.f736d7ac68b07p+982,   -0x1.0c25679d7d7b5p-2,   -0x1.184b5p-2, INEXACT)
T(RN,  0x1.f98500dc6ec13p+982,    0x1.d493ed428035ep-2,   0x1.017f06p-5, INEXACT)
T(RN,   0x1.59a1dbc1c127p+982,    -0x1.1d6d42cd6f72p-3,  -0x1.cc0c2cp-2, INEXACT)
T(RN,  0x1.9384a3c50d07ap+983,    0x1.ccca8044b3734p-2,   0x1.e90f32p-3, INEXACT)
T(RN,  0x1.91f7027ac0aa1p+983,   -0x1.b2251d9c76ac5p-1,   -0x1.b6b38p-2, INEXACT)
T(RN,  0x1.942594898fa18p+983,    0x1.46f980b053175p-1,    0x1.f25eap-2, INEXACT)
T(RN,  0x1.d9e25a62b7f6ep+983,    0x1.5171088fbf858p-1,   0x1.b3ab16p-3, INEXACT)
T(RN,  0x1.0f27ed1957a27p+983,     0x1.f67df6e1bdc5p-1,   0x1.dd5b68p-3, INEXACT)
T(RN,  0x1.31e3dca7d450cp+983,   -0x1.a3616fa1ca84bp-1,  -0x1.401ae6p-2, INEXACT)
T(RN,  0x1.f65235ae23144p+983,   -0x1.1d7d64b3f1927p-1,   0x1.6e928ap-2, INEXACT)
T(RN,  0x1.54b27d9461834p+983,    0x1.c588df3191543p-2,   0x1.228e3cp-2, INEXACT)
T(RN,   0x1.863e84daa68cp+983,   -0x1.4269ae6dd3101p-2,   0x1.9aec7cp-4, INEXACT)
T(RN,  0x1.f51fb95637286p+983,    0x1.72879b115227bp-1,  -0x1.15f3d8p-2, INEXACT)
T(RN,  0x1.b7b9f8031c62ap+984,    0x1.0d3a11685fbb2p-1,   0x1.0f1b18p-2, INEXACT)
T(RN,  0x1.23730cf7f60c9p+984,   -0x1.97cc2287ac0dep-3,   0x1.b1a6ccp-2, INEXACT)
T(RN,  0x1.bc6a12cafb366p+984,   -0x1.d31d2c650b546p-1,   0x1.372a32p-3, INEXACT)
T(RN,  0x1.f6988ac83f758p+984,    0x1.1776dbddcec8ap-2,  0x1.28fa5ep-10, INEXACT)
T(RN,  0x1.5ef9c1992c792p+984,   -0x1.f709cabdab3b8p-1,   0x1.18c0e2p-3, INEXACT)
T(RN,  0x1.709c9dbfb4528p+984,    0x1.f1dc4b4ffb482p-5,   0x1.3cd49ap-2, INEXACT)
T(RN,  0x1.7e8b14dd762f9p+984,   -0x1.e79024c2f1423p-2,  -0x1.4d7f8cp-2, INEXACT)
T(RN,  0x1.497bc976aa7dep+984,   -0x1.0cf3de48ca201p-6,  -0x1.7ba9e2p-4, INEXACT)
T(RN,  0x1.318b013bc3f6ap+984,   -0x1.8e7b94101b4d4p-1,  -0x1.c71f0ep-3, INEXACT)
T(RN,  0x1.2bad98dbc4c41p+984,    0x1.ec1a2e4cac289p-4,  -0x1.f660eep-3, INEXACT)
T(RN,  0x1.0fdb01e01e524p+985,    0x1.99baf05cdebccp-1,   -0x1.d7e6cp-8, INEXACT)
T(RN,  0x1.21016a5257ff4p+985,   -0x1.2b7996fe31a51p-1,  -0x1.57a10ap-3, INEXACT)
T(RN,  0x1.42f84bcdea38dp+985,    0x1.af5128a326a4ap-2,   0x1.913e3ap-2, INEXACT)
T(RN,  0x1.7c16370422454p+985,    0x1.2cfb372595de3p-2,  -0x1.568992p-2, INEXACT)
T(RN,  0x1.fbcfcd5e36f2cp+985,    0x1.e387023632b9ap-1,  -0x1.802102p-2, INEXACT)
T(RN,  0x1.dcee8e146e229p+985,   -0x1.40ae3829daa06p-1,  -0x1.f24ea8p-2, INEXACT)
T(RN,  0x1.2e038d0e45491p+985,   -0x1.1e433b2ffb0eap-1,   0x1.0672e2p-3, INEXACT)
T(RN,  0x1.6fa4271425d52p+985,   -0x1.a4fa9b2a725b1p-3,   0x1.a66c32p-2, INEXACT)
T(RN,  0x1.c3857571d6144p+985,   -0x1.d0c11c3f90b83p-2,  -0x1.c6d492p-2, INEXACT)
T(RN,  0x1.a1fe28df1d31bp+985,   -0x1.c1005621e0032p-1,  -0x1.cde2cep-2, INEXACT)
T(RN,  0x1.07bf241bbf8e9p+986,   -0x1.e0225ab628107p-1,   0x1.c1959cp-2, INEXACT)
T(RN,  0x1.ac23e1f69e2cep+986,   -0x1.350ef20080f64p-2,  -0x1.b2b88ep-2, INEXACT)
T(RN,  0x1.57904d091b499p+986,   -0x1.d80a2ed042914p-2,   0x1.24b854p-2, INEXACT)
T(RN,  0x1.bedc85c175b62p+986,   -0x1.e647b462332aep-1,   -0x1.aec31p-7, INEXACT)
T(RN,   0x1.a581f9177e7fp+986,    0x1.96136216530b3p-2,  -0x1.c3be16p-2, INEXACT)
T(RN,  0x1.d4b0ef552473cp+986,    0x1.02c7647898c45p-2,   0x1.17c47ap-6, INEXACT)
T(RN,  0x1.10c7969320908p+986,    0x1.7d5af0bd3e765p-7,  -0x1.f6482ap-2, INEXACT)
T(RN,  0x1.cfb99a99336dap+986,   -0x1.8d3fe4de615c3p-1,   0x1.6eb30ep-3, INEXACT)
T(RN,  0x1.f893bdf1fd6fcp+986,   -0x1.71af073d80dbcp-1,   0x1.3d7114p-2, INEXACT)
T(RN,   0x1.77897ceaf1b2p+986,    0x1.da28ed7497eeap-1,   0x1.2463a6p-3, INEXACT)
T(RN,  0x1.3bafcb23c3306p+987,   -0x1.eecaae3e8890fp-1,   0x1.4716e2p-3, INEXACT)
T(RN,  0x1.3e27a9d95c30ap+987,     0x1.840a6055d6e4p-1,   0x1.caa166p-3, INEXACT)
T(RN,  0x1.5101232d72de3p+987,     0x1.403569d2c516p-1,   0x1.22c212p-3, INEXACT)
T(RN,  0x1.0afb04300cc5fp+987,    0x1.ec06b64ebaefcp-1,  -0x1.5acc48p-3, INEXACT)
T(RN,  0x1.056ff85f11352p+987,     0x1.4c4fc7db08c8p-2,   0x1.518f7cp-2, INEXACT)
T(RN,  0x1.09c3e12e5cf24p+987,    0x1.b8b1b1d57d9a4p-1,   0x1.0274fap-3, INEXACT)
T(RN,  0x1.371264b7d3478p+987,   -0x1.6c892e0906b69p-3,  -0x1.50d492p-2, INEXACT)
T(RN,   0x1.372e1610d044p+987,    0x1.15f230e3657d5p-1,   0x1.2f4ad2p-3, INEXACT)
T(RN,  0x1.5194f98b1e11ap+987,   -0x1.6450bd82e901dp-2,  -0x1.a80fa4p-2, INEXACT)
T(RN,  0x1.f6791beb44228p+987,   -0x1.b694c10484284p-4,   0x1.22ddc6p-2, INEXACT)
T(RN,  0x1.4ef87ed6ac08ap+988,   -0x1.8e25e663b6722p-1,   0x1.945b92p-2, INEXACT)
T(RN,  0x1.7fbd1ad893699p+988,    -0x1.d8c65b88b2d5p-1,  -0x1.75a98ep-5, INEXACT)
T(RN,  0x1.c80e4d68a392ep+988,   -0x1.824b0bde34a03p-1,   0x1.50f078p-7, INEXACT)
T(RN,   0x1.632aeb82b0fdp+988,    -0x1.f051a4fca981p-1,   0x1.81797cp-3, INEXACT)
T(RN,   0x1.b463326ae0fcp+988,    0x1.cc49f1e72466cp-6,  -0x1.58b33cp-2, INEXACT)
T(RN,  0x1.e40623d3f77bap+988,    0x1.ffbab3013c0f2p-1,   0x1.42d106p-5, INEXACT)
T(RN,  0x1.dfd14f599fcecp+988,    0x1.90d7e61d88fa9p-1,   0x1.461c14p-2, INEXACT)
T(RN,  0x1.ab4c75fdf9c48p+988,   -0x1.d2b05e4ab5196p-1,   0x1.4105a2p-3, INEXACT)
T(RN,  0x1.163525274c12ep+988,    0x1.c0544c3fc68abp-3,  -0x1.03b868p-2, INEXACT)
T(RN,  0x1.3b0df4195abccp+988,   -0x1.084fccb44ca6cp-3,  -0x1.cc4cd4p-2, INEXACT)
T(RN,  0x1.bb232062dae8cp+989,   -0x1.d5b042f403ec6p-3,   0x1.954192p-2, INEXACT)
T(RN,   0x1.1a1ff8f2bf9dp+989,   -0x1.3edce8e1461e9p-2,   0x1.8dafa4p-2, INEXACT)
T(RN,  0x1.744a9a1074e2dp+989,    0x1.944e6ce78f5fap-3,  -0x1.f3831ep-3, INEXACT)
T(RN,  0x1.1cb8935cb9dd6p+989,    0x1.6ed34223a3f04p-1,  -0x1.ffbca4p-2, INEXACT)
T(RN,  0x1.ec81278bbf14cp+989,    0x1.294a3eda7700dp-1,  -0x1.bfab16p-2, INEXACT)
T(RN,  0x1.bc70e57c5a764p+989,    0x1.febe24fcd879ep-1,    0x1.cafa3p-3, INEXACT)
T(RN,  0x1.b6a17adf393c8p+989,    0x1.8d92699a1dad7p-1,   -0x1.04857p-3, INEXACT)
T(RN,  0x1.318ad2c3cdd7cp+989,    0x1.e3424e8e76849p-1,  -0x1.8b4d6ap-3, INEXACT)
T(RN,  0x1.1fc2d31c5ed28p+989,    0x1.a8c336b7cc8fdp-1,  -0x1.aa9544p-2, INEXACT)
T(RN,  0x1.8b262e38926aap+989,   -0x1.ff9b629b819d8p-1,   0x1.f16228p-2, INEXACT)
T(RN,  0x1.086afdedb9f47p+990,   -0x1.2af4d75d091f9p-2,   0x1.65f7e2p-4, INEXACT)
T(RN,  0x1.c07b5cde792dap+990,     0x1.748867030be2p-1,  -0x1.201afcp-2, INEXACT)
T(RN,   0x1.0d7028fa43f7p+990,   -0x1.c399a8151bc9fp-1,  -0x1.4a097ep-2, INEXACT)
T(RN,  0x1.65422ab7715eep+990,   -0x1.38ff7cdaf188bp-4,  -0x1.aff85ap-4, INEXACT)
T(RN,  0x1.fe9c2eb8b1af2p+990,   -0x1.599f83562e394p-6,  -0x1.df6c38p-7, INEXACT)
T(RN,  0x1.9d0c27755cfd8p+990,    0x1.f9f2c12b80746p-1,   -0x1.f4b78p-2, INEXACT)
T(RN,  0x1.4d42f9b05ef93p+990,    0x1.5376e3658157dp-1,   0x1.44d9ecp-3, INEXACT)
T(RN,  0x1.469ae238ad1b2p+990,   -0x1.71fea76f957f5p-1,   0x1.3f0744p-5, INEXACT)
T(RN,  0x1.2dd32745d067fp+990,   -0x1.fcd26209ab78fp-1,  -0x1.877008p-2, INEXACT)
T(RN,  0x1.05b31c73056aep+990,    -0x1.44cea94ec92cp-2,   0x1.8d226ep-4, INEXACT)
T(RN,  0x1.42785f6299062p+991,    0x1.97990eefb1b8bp-3,  -0x1.d8f26ep-3, INEXACT)
T(RN,  0x1.ac292fa10e823p+991,    0x1.dc06f4705c424p-1,  -0x1.e61194p-2, INEXACT)
T(RN,   0x1.b3c978575a92p+991,    0x1.0afe2f4954e9dp-2,   0x1.ce466ap-6, INEXACT)
T(RN,  0x1.75c8de9b4923cp+991,    0x1.db80ad31575ecp-1,    0x1.9b27bp-2, INEXACT)
T(RN,  0x1.29caf8820bf54p+991,    0x1.ecc382b158cdfp-1,   0x1.ad51b8p-2, INEXACT)
T(RN,  0x1.44dd3d299f14bp+991,    -0x1.ffdbb4d8900fp-1,   0x1.fae6dep-3, INEXACT)
T(RN,  0x1.df28550561424p+991,    0x1.f211e63b6874ap-3,   0x1.a5bf76p-2, INEXACT)
T(RN,  0x1.539eed672cbd6p+991,   -0x1.37b0aa30921b9p-2,  -0x1.8fb8c8p-2, INEXACT)
T(RN,  0x1.d7c2bc71f8319p+991,    0x1.7d9e85a85cb09p-1,   0x1.c6e99cp-2, INEXACT)
T(RN,  0x1.9f49b883c0f36p+991,   -0x1.2addd6848e40ap-1,   0x1.485db4p-2, INEXACT)
T(RN,  0x1.6bb3e77d94514p+992,    0x1.6eb6122f76e69p-1,  -0x1.c47aa6p-3, INEXACT)
T(RN,  0x1.2655b0c472b5dp+992,   -0x1.190efd42225c4p-1,   0x1.6d8ebap-2, INEXACT)
T(RN,  0x1.322f56a02b382p+992,   -0x1.ecf01b138ec64p-2,     0x1.d11ap-2, INEXACT)
T(RN,  0x1.526768b9c5d55p+992,   -0x1.cba154fa72c55p-1,   0x1.22b88ep-2, INEXACT)
T(RN,  0x1.f058d84a1edcap+992,   -0x1.7f888158a30f2p-1,  -0x1.bdca28p-2, INEXACT)
T(RN,  0x1.0d1e71820240ep+992,   -0x1.eaf4d3acbb16bp-1,   0x1.c1e072p-3, INEXACT)
T(RN,  0x1.6f722401d2833p+992,    0x1.fd2f9074515ebp-1,   0x1.3b62f8p-2, INEXACT)
T(RN,  0x1.ef8bd38ca43ffp+992,    0x1.58293db4cec78p-1,  -0x1.5b6abap-2, INEXACT)
T(RN,  0x1.76d91c07d08aap+992,    0x1.fd533179e1a9bp-1,  -0x1.62df3ep-3, INEXACT)
T(RN,  0x1.fe026401e6202p+992,    0x1.eb9a4bf28bda4p-1,  -0x1.6acce6p-4, INEXACT)
T(RN,  0x1.2a8a932c2df89p+993,    0x1.eba36297da9fap-2,   0x1.24305ap-2, INEXACT)
T(RN,  0x1.6a468c20d3edap+993,   -0x1.cd1b54f14b73ep-1,   0x1.be18a6p-2, INEXACT)
T(RN,  0x1.6fad061e843dbp+993,    0x1.b895d7f236dffp-1,  -0x1.448b46p-2, INEXACT)
T(RN,  0x1.0a1246f9e52e4p+993,   -0x1.e6efba5b5593ep-1,   0x1.a56fc4p-2, INEXACT)
T(RN,  0x1.52f00e0f21a0dp+993,   -0x1.6f608055a8b84p-1,  -0x1.c67a64p-4, INEXACT)
T(RN,  0x1.fd00623d858efp+993,   -0x1.6d8b95ef864ffp-3,  -0x1.65ce64p-2, INEXACT)
T(RN,   0x1.fcd8396c8b4ep+993,   -0x1.dc4f8fd981dfep-1,  -0x1.db44e2p-5, INEXACT)
T(RN,  0x1.afd83f91b7969p+993,   -0x1.1868446688e28p-4,  -0x1.d53caep-3, INEXACT)
T(RN,  0x1.98a65e30d683cp+993,   -0x1.9ae98feefd78dp-3,   0x1.e548bcp-2, INEXACT)
T(RN,  0x1.8a1520c52b524p+993,    0x1.6049b4eb1c4fap-1,  -0x1.cd5c52p-2, INEXACT)
T(RN,  0x1.fec3a9f349768p+994,    -0x1.9d734d035ac6p-1,   0x1.c872b6p-2, INEXACT)
T(RN,  0x1.bd87b5351452bp+994,   -0x1.7fb85918c9815p-1,  -0x1.5cfc06p-2, INEXACT)
T(RN,  0x1.3a695eafc27afp+994,    0x1.8bfe2e66ff757p-3,  -0x1.501e5cp-5, INEXACT)
T(RN,  0x1.83fe3bb0cc6ccp+994,    0x1.e818fb4da7d14p-1,  -0x1.610b3ep-2, INEXACT)
T(RN,  0x1.2429b89e6d0d6p+994,    0x1.578a28437f46bp-3,  -0x1.f6b856p-2, INEXACT)
T(RN,  0x1.973912bf63574p+994,   -0x1.f93cefc4621d3p-1,   0x1.429978p-2, INEXACT)
T(RN,   0x1.d78197399aa5p+994,   -0x1.ffad072eedde9p-1,  -0x1.5d3098p-2, INEXACT)
T(RN,  0x1.e9983ccfc195bp+994,    0x1.b73e598e8ea36p-1,   0x1.c024ecp-3, INEXACT)
T(RN,  0x1.aa85511a85b47p+994,    0x1.d03a51e218737p-2,   0x1.6d287ap-3, INEXACT)
T(RN,  0x1.01b1a7c3b4a48p+994,   -0x1.76a135d7ac182p-2,   0x1.244c48p-4, INEXACT)
T(RN,  0x1.3b5b8a0201b32p+995,    0x1.fde80f6aace8fp-1,  -0x1.16c994p-2, INEXACT)
T(RN,  0x1.a1b09186865f8p+995,    0x1.1378b2da881dbp-1,   0x1.aca5b8p-2, INEXACT)
T(RN,  0x1.20d3570bce536p+995,   -0x1.fdf30b318a301p-1,   0x1.748116p-2, INEXACT)
T(RN,  0x1.717e10a5bc183p+995,   -0x1.c4993bd4823d9p-1,    0x1.7cd87p-2, INEXACT)
T(RN,  0x1.5254b7a1b23f1p+995,    0x1.54f7d2f6ee9a5p-1,   -0x1.dd99fp-3, INEXACT)
T(RN,  0x1.25034a36f4bd3p+995,   -0x1.e36945358543ap-1,   0x1.8d9a12p-2, INEXACT)
T(RN,  0x1.6593993ce659ep+995,   -0x1.80d16a7287c3bp-1,  -0x1.c34ba6p-4, INEXACT)
T(RN,  0x1.e1b6f90f3e417p+995,   -0x1.f96d2df7dbe97p-1,   0x1.01e842p-3, INEXACT)
T(RN,  0x1.3db0e58f348d5p+995,    0x1.f6ea5c68cae54p-1,  -0x1.503d3ep-7, INEXACT)
T(RN,  0x1.da542a2c85e1cp+995,   -0x1.d3f25b7f47754p-3,   0x1.2dab08p-3, INEXACT)
T(RN,  0x1.406e5a654abc4p+996,   -0x1.fdf6a7a1366bdp-1,   0x1.4047cap-2, INEXACT)
T(RN,  0x1.c67af142b130dp+996,   -0x1.ff61f9c91bf36p-1,   -0x1.078e3p-4, INEXACT)
T(RN,  0x1.ed145dee6efd4p+996,   -0x1.b66f70714bfe6p-2,   0x1.364044p-3, INEXACT)
T(RN,  0x1.7ef32148ea002p+996,   -0x1.0c32ecde66454p-1,   -0x1.148ecp-5, INEXACT)
T(RN,  0x1.f9a71f893d67ap+996,   -0x1.13a17cd9a5e31p-1,   0x1.9f76c6p-3, INEXACT)
T(RN,   0x1.1a12ce589e28p+996,   -0x1.211db02d9914dp-4,   0x1.ca1362p-4, INEXACT)
T(RN,  0x1.13c0fd39fd07cp+996,   -0x1.b8990fdf6bbc4p-1,  -0x1.bd0516p-3, INEXACT)
T(RN,  0x1.1c14ccce0e75ap+996,    0x1.0ea3088915fe9p-1,   0x1.6a3588p-3, INEXACT)
T(RN,  0x1.ea68c9cd90bc4p+996,    0x1.e96c5b2c64ad6p-1,  -0x1.d32148p-2, INEXACT)
T(RN,  0x1.28bc189c2f19cp+996,    0x1.6e62b57c148a5p-1,   0x1.f88512p-2, INEXACT)
T(RN,  0x1.ca3dcb371ae53p+997,    0x1.e170874ac2ee4p-3,  -0x1.537c44p-3, INEXACT)
T(RN,  0x1.e55d2521bf242p+997,    0x1.b7f116b53087ep-1,   0x1.253e18p-3, INEXACT)
T(RN,  0x1.dac40d7beeb86p+997,    0x1.d20e56f9fa47ap-1,  -0x1.bf617ep-3, INEXACT)
T(RN,  0x1.f35d3595da7b8p+997,    0x1.653f824444f55p-1,    0x1.cb737p-2, INEXACT)
T(RN,  0x1.2956db201ba75p+997,   -0x1.e0f979678278fp-1,   0x1.81b32ep-2, INEXACT)
T(RN,  0x1.7c57564ac2943p+997,    0x1.3565c8f3428f4p-1,   0x1.c5e144p-8, INEXACT)
T(RN,  0x1.affb07531b54cp+997,   -0x1.653d3fa496c5ap-1,  -0x1.f154e4p-4, INEXACT)
T(RN,  0x1.8473d70ffaafcp+997,    0x1.c7458314548ebp-2,   0x1.fcbe4cp-2, INEXACT)
T(RN,  0x1.4ea61c6bea323p+997,    0x1.eeedcedca9213p-1,   0x1.ee73f8p-4, INEXACT)
T(RN,  0x1.5e15fd692bceep+997,   -0x1.fffd4dad8e4a9p-1,  -0x1.f3c854p-3, INEXACT)
T(RN,  0x1.04ac2b880f09bp+998,   -0x1.537902eec3fb2p-1,   0x1.06fa2ep-5, INEXACT)
T(RN,  0x1.d0c9fcd41d77bp+998,    0x1.925632a22c346p-1,   0x1.0327cep-4, INEXACT)
T(RN,  0x1.d646cdb8e9f3cp+998,   -0x1.ecb4b571980c3p-1,   0x1.102fc2p-3, INEXACT)
T(RN,  0x1.2b92cd16b5702p+998,   -0x1.a7d688150d11fp-1,  -0x1.e351a6p-4, INEXACT)
T(RN,  0x1.3054713da10dcp+998,    0x1.a5c11816570ebp-4,    0x1.2561ep-5, INEXACT)
T(RN,  0x1.8303d34d13b84p+998,    0x1.2f0930e133b82p-2,   0x1.50f15ap-2, INEXACT)
T(RN,  0x1.e9746cbdf64cap+998,   -0x1.fdaa6d5bb4418p-1,   0x1.b76252p-2, INEXACT)
T(RN,  0x1.7aef017d9116cp+998,   -0x1.6b7a01fb54168p-1,   0x1.5d749ap-7, INEXACT)
T(RN,  0x1.435a8cce71ff5p+998,    0x1.4ac3c7ac8bad2p-1,   0x1.956bb2p-4, INEXACT)
T(RN,  0x1.afc879cedadbcp+998,    -0x1.5936ee3e54cbp-1,  -0x1.c077d8p-2, INEXACT)
T(RN,  0x1.8cf8f7a22f674p+999,   -0x1.f3dd913a331d7p-1,  -0x1.34f866p-6, INEXACT)
T(RN,   0x1.c3486ff327e5p+999,    0x1.6300ddee12443p-1,   0x1.a5bfe2p-2, INEXACT)
T(RN,  0x1.fb16bf6c8607ep+999,   -0x1.ffbab68575fe2p-1,   0x1.55eed8p-2, INEXACT)
T(RN,  0x1.659c5558cd117p+999,   -0x1.a86a2c273db0cp-1,   0x1.4e15f8p-4, INEXACT)
T(RN,  0x1.1f4e74a34988ep+999,   -0x1.a4d4f3d13e3dap-1,  -0x1.18370ep-6, INEXACT)
T(RN,  0x1.b1eef0dcb1c4cp+999,    0x1.e0b36f9ecddc2p-1,  -0x1.befebcp-3, INEXACT)
T(RN,  0x1.be7a6bab38e32p+999,    0x1.ff40d6b29c575p-1,   0x1.636208p-2, INEXACT)
T(RN,  0x1.7bca962b7ffa1p+999,   -0x1.aa9d8e848ba1bp-1,   0x1.76cb54p-4, INEXACT)
T(RN,  0x1.95cd85765d758p+999,   -0x1.ff4673fd0ab56p-1,   0x1.207fc4p-5, INEXACT)
T(RN,  0x1.9764986699b63p+999,   -0x1.fe0eaa1d8b255p-1,  -0x1.377e2ep-3, INEXACT)
T(RN, 0x1.015bfb4be3b52p+1000,    0x1.28e08b030c76ap-4,  -0x1.48633ap-3, INEXACT)
T(RN, 0x1.41b6929f1fd47p+1000,   -0x1.32f6a4a01519cp-1,  -0x1.5ff8cap-2, INEXACT)
T(RN, 0x1.f68d8865e427ep+1000,   -0x1.de85fdf2c4a24p-1,  -0x1.77fd02p-3, INEXACT)
T(RN, 0x1.8c0e8a74fb1f2p+1000,   -0x1.ed9a24105a0dap-1,   0x1.62891cp-4, INEXACT)
T(RN, 0x1.a201014128dfap+1000,   -0x1.fefcadad6c6f2p-1,   -0x1.b10d8p-2, INEXACT)
T(RN, 0x1.c28b3108894f6p+1000,   -0x1.d8d7a7ba920e3p-1,   0x1.992ba8p-3, INEXACT)
T(RN, 0x1.708e255c378dcp+1000,    0x1.f82761b81c428p-1,   -0x1.ec1fbp-3, INEXACT)
T(RN, 0x1.c85c5ee3deb7cp+1000,   -0x1.930726c14e89bp-1,  -0x1.333912p-3, INEXACT)
T(RN, 0x1.696930e4d60dbp+1000,   -0x1.c8f62821a5a84p-1,    0x1.e056ap-2, INEXACT)
T(RN, 0x1.a89c3a6360bb4p+1000,    0x1.f97aabb0a1c25p-1,   0x1.7456fcp-3, INEXACT)
T(RN, 0x1.8e587e7242faep+1001,    0x1.e8e0fee5f03edp-1,   0x1.da8d06p-3, INEXACT)
T(RN, 0x1.edc6d08e52c56p+1001,    0x1.cf867aed1c2a3p-4,   -0x1.7daeap-4, INEXACT)
T(RN, 0x1.447b07f892aa2p+1001,   -0x1.ff5b318954997p-1,   0x1.e8e9dep-3, INEXACT)
T(RN, 0x1.ae7d74e676abep+1001,   -0x1.fa9b62a497de7p-1,   0x1.5b7ecap-2, INEXACT)
T(RN, 0x1.a50f4db152fb9p+1001,    0x1.8c99a81ec130cp-2,  -0x1.5c7d38p-3, INEXACT)
T(RN, 0x1.6b188b4466072p+1001,    0x1.e82f118a02babp-1,  -0x1.d2a7c6p-3, INEXACT)
T(RN, 0x1.4cd0dac209e43p+1001,   -0x1.11cd609d710cep-3,  -0x1.e55c4ep-3, INEXACT)
T(RN, 0x1.01088dc6d9a53p+1001,    0x1.19d5f80d18622p-1,   0x1.729a8cp-6, INEXACT)
T(RN, 0x1.db84501ab2753p+1001,    0x1.bbb0d7c6c67bep-1,   0x1.81880ep-6, INEXACT)
T(RN, 0x1.43e46ccbfff19p+1001,    0x1.3b89a7ca1cb0ap-1,    0x1.dc52fp-2, INEXACT)
T(RN, 0x1.0d2d36d01f304p+1002,   -0x1.256c91ba48e2fp-2,   0x1.4de8e6p-3, INEXACT)
T(RN,  0x1.395a99b4b752p+1002,   -0x1.f4b2c88d4aaccp-2,   0x1.3f8b6ap-3, INEXACT)
T(RN, 0x1.105132c4bd573p+1002,   -0x1.98cc1caf7a567p-1,  -0x1.5ff716p-2, INEXACT)
T(RN, 0x1.71d639cd9e84ep+1002,    0x1.e7d01dd143183p-1,  -0x1.dafad6p-2, INEXACT)
T(RN, 0x1.ef41ba50d3d5ep+1002,    0x1.e17e7e560c80ap-1,  -0x1.da0406p-2, INEXACT)
T(RN, 0x1.75451cb706a86p+1002,   -0x1.cf937db7c26cbp-1,   0x1.4af9c6p-2, INEXACT)
T(RN,  0x1.5e1ebf5cd0e8p+1002,   -0x1.cca507c5c9f8bp-3,  -0x1.6a13cep-3, INEXACT)
T(RN, 0x1.43b80396c531ap+1002,    0x1.845a45fa8139dp-4,   0x1.873536p-3, INEXACT)
T(RN, 0x1.a8f751fc57194p+1002,   -0x1.39c133fca2471p-1,  -0x1.15dd2cp-3, INEXACT)
T(RN, 0x1.ebc4fd8efa5cdp+1002,    0x1.a745ca14abee4p-1,  -0x1.10b98ep-2, INEXACT)
T(RN, 0x1.78ed56e672e05p+1003,    0x1.ffd88b320a131p-1,  -0x1.f4c2bep-2, INEXACT)
T(RN, 0x1.8229ae810138ap+1003,   -0x1.4acafc1893736p-1,   0x1.57ace6p-2, INEXACT)
T(RN,  0x1.f559c9622017p+1003,   -0x1.8a6c2f88047a9p-5,   0x1.d0dc52p-2, INEXACT)
T(RN, 0x1.9c55e4e849a3cp+1003,   -0x1.ff02a39f9941ap-1,   -0x1.089e6p-4, INEXACT)
T(RN, 0x1.8d67fb9964941p+1003,   -0x1.8f9dd1eb4b899p-1,  -0x1.be74b4p-2, INEXACT)
T(RN, 0x1.3cfb6e1538833p+1003,     0x1.c26c73396884p-3,   0x1.6e0ba2p-4, INEXACT)
T(RN, 0x1.4e98b90e463d9p+1003,    0x1.82e2d501c0142p-2,   0x1.885b1cp-2, INEXACT)
T(RN, 0x1.eef27a4cde63cp+1003,   -0x1.6f3ae37a8f597p-1,  -0x1.06f892p-3, INEXACT)
T(RN, 0x1.2170c4d5c12c6p+1003,   -0x1.c7ca48a534ba8p-2,   -0x1.a88adp-9, INEXACT)
T(RN, 0x1.d2d21e00a563bp+1003,   -0x1.fe4692a8619fdp-1,   0x1.f7ef94p-2, INEXACT)
T(RN, 0x1.3fe16c8809daap+1004,    0x1.9096d5e7094d7p-3,  -0x1.f38708p-2, INEXACT)
T(RN, 0x1.a0925ae4eddaep+1004,   -0x1.16163ef463c17p-1,   0x1.ca4b72p-3, INEXACT)
T(RN, 0x1.b6ffbb96b08d5p+1004,   -0x1.1fc7696f5c2abp-1,   0x1.59c942p-2, INEXACT)
T(RN, 0x1.5e831e1d94635p+1004,   -0x1.e79caeb0c6719p-1,  -0x1.26d782p-4, INEXACT)
T(RN, 0x1.0264b88aa83ebp+1004,   -0x1.84b12ccb4ca5bp-2,   0x1.a9eefcp-5, INEXACT)
T(RN, 0x1.2972873153f13p+1004,   -0x1.0645c6cf0280bp-3,   0x1.fe176cp-2, INEXACT)
T(RN, 0x1.95638f02691b6p+1004,    0x1.f7b479e89044ap-1,   0x1.d60332p-4, INEXACT)
T(RN, 0x1.6982338bf32b4p+1004,    0x1.685adcf2ae48ap-1,  -0x1.55047ep-3, INEXACT)
T(RN, 0x1.12e7fdfd09a14p+1004,    -0x1.e1398f44a223p-3,  -0x1.1c00acp-2, INEXACT)
T(RN, 0x1.734300b4e2386p+1004,    0x1.fffe0ca2705b6p-1,    0x1.a6041p-3, INEXACT)
T(RN,  0x1.7fd7b7a9b20fp+1005,   -0x1.0efe8b2b57abdp-1,  -0x1.8582aap-3, INEXACT)
T(RN, 0x1.9b8a4ccccfe93p+1005,   -0x1.dd914da13fcc2p-3,   0x1.62b036p-2, INEXACT)
T(RN, 0x1.54b0e0a07f4ccp+1005,    0x1.0dc13ed34b09ap-1,    0x1.29b3ep-2, INEXACT)
T(RN, 0x1.1c5735523d22cp+1005,   -0x1.417bca64446adp-4,  -0x1.3105d6p-5, INEXACT)
T(RN, 0x1.f3036c103c2e4p+1005,   -0x1.33a30945f09f6p-1,  -0x1.8cadeep-2, INEXACT)
T(RN, 0x1.219733fe1b9afp+1005,   -0x1.d2a0a525f5c7cp-1,  -0x1.5b098ep-2, INEXACT)
T(RN,  0x1.ae8e2a46d055p+1005,    0x1.a20ac7e08cecfp-1,  -0x1.7e93fep-2, INEXACT)
T(RN, 0x1.ee3000b4fa362p+1005,    0x1.e928d8e0da4c2p-1,   0x1.af5d2ep-4, INEXACT)
T(RN, 0x1.3f826fded14dap+1005,   -0x1.fff4debfbbf1ap-1,  -0x1.ca8cdep-2, INEXACT)
T(RN, 0x1.436712c5cc723p+1005,    0x1.d1cca0bdf1787p-1,  -0x1.75186ap-6, INEXACT)
T(RN, 0x1.e6195bedf3fd6p+1006,   -0x1.ffa4c521af509p-1,  -0x1.73925cp-2, INEXACT)
T(RN, 0x1.219bdd75c0047p+1006,   -0x1.5ba7660c6bf59p-2,   0x1.f28b18p-3, INEXACT)
T(RN, 0x1.e0ab52ab2a4c4p+1006,   -0x1.82c468bf1618bp-1,   0x1.ab75f2p-3, INEXACT)
T(RN, 0x1.96d125e28d1d7p+1006,   -0x1.aa4f9246c3eeap-2,  -0x1.ec7bb2p-3, INEXACT)
T(RN, 0x1.2f6e0d3319d6ep+1006,   -0x1.f51f9629108d7p-1,   0x1.8ec12ep-2, INEXACT)
T(RN, 0x1.6abb62c4a3a56p+1006,   -0x1.7d5399d6124b6p-1,   0x1.110ab2p-2, INEXACT)
T(RN, 0x1.67b580aff663cp+1006,    0x1.75771aec62297p-3,   0x1.ea8a92p-2, INEXACT)
T(RN,  0x1.e7bd380897fdp+1006,    -0x1.fa68a634140ap-1,   -0x1.dfc27p-4, INEXACT)
T(RN, 0x1.d314b48ecf02ep+1006,   -0x1.b16c6b25e9247p-2,  -0x1.1bb6d2p-2, INEXACT)
T(RN, 0x1.544aa004df6eap+1006,    0x1.83d2aadf76f6ep-1,   0x1.028336p-2, INEXACT)
T(RN,  0x1.e20c5e0a320ep+1007,   -0x1.8d3f670ef5f3dp-1,   -0x1.3042ep-2, INEXACT)
T(RN, 0x1.2500865802b13p+1007,    0x1.b0fde01e291e3p-4,   -0x1.0558dp-3, INEXACT)
T(RN, 0x1.affefcbea5d13p+1007,   -0x1.c5ce7538d1acep-1,   0x1.e37958p-7, INEXACT)
T(RN, 0x1.886478fa3be9ap+1007,   -0x1.cef47b307b978p-1,  -0x1.6b4de2p-3, INEXACT)
T(RN, 0x1.05187fe76e6e4p+1007,   -0x1.76e72f1adc5f6p-1,   0x1.ab2aeap-3, INEXACT)
T(RN, 0x1.9a1ba7088e39ap+1007,     0x1.ff5e483608ffp-1,   0x1.63dadep-3, INEXACT)
T(RN, 0x1.494c64a0efe16p+1007,   -0x1.7c091637e4591p-2,  -0x1.1a3ddap-2, INEXACT)
T(RN, 0x1.097f363d8e6f7p+1007,    0x1.dfa0a9f12c3b4p-1,   -0x1.e35c8p-3, INEXACT)
T(RN, 0x1.9a159e6a5183fp+1007,   -0x1.db407355127a3p-1,  -0x1.4fa446p-6, INEXACT)
T(RN, 0x1.bd1622ca95256p+1007,    0x1.914ad1e82e0abp-7,  -0x1.4caec2p-5, INEXACT)
T(RN,   0x1.18e02d8e4b9p+1008,    0x1.e7603f86246c7p-1,  -0x1.d0fbeap-7, INEXACT)
T(RN, 0x1.6d6fa4f60658ep+1008,   -0x1.bd2551e9ca925p-1,   -0x1.079e9p-2, INEXACT)
T(RN, 0x1.f7debcf6ce99bp+1008,   -0x1.15e93bf96efddp-3,  -0x1.7168aap-3, INEXACT)
T(RN, 0x1.0a318a9ec5e3fp+1008,   -0x1.e6de187acce88p-1,   0x1.a1b0e6p-5, INEXACT)
T(RN, 0x1.57dbe076544b2p+1008,   -0x1.feea5aa90188fp-1,  -0x1.223814p-2, INEXACT)
T(RN, 0x1.217901753fa8cp+1008,   -0x1.c54baabd11f1ap-6,   0x1.5d8238p-2, INEXACT)
T(RN, 0x1.efac9e5c5bd6dp+1008,    0x1.a5936b6c96931p-1,  -0x1.ea0a18p-5, INEXACT)
T(RN,  0x1.e015fbf05bcfp+1008,    0x1.7982b906a9528p-1,  -0x1.2da5f8p-3, INEXACT)
T(RN, 0x1.48b570d64067ep+1008,    0x1.df65dcb47b719p-3,   0x1.417bccp-2, INEXACT)
T(RN, 0x1.5169c91c2a9ccp+1008,   -0x1.f2dd581e761a3p-1,   0x1.05a398p-3, INEXACT)
T(RN, 0x1.e284d3235ce84p+1009,   -0x1.99b2468604656p-1,   -0x1.03581p-5, INEXACT)
T(RN, 0x1.0aac6634fb8c7p+1009,    0x1.d6359c0a4c30cp-3,    0x1.3f865p-2, INEXACT)
T(RN, 0x1.db1e5ba3bb711p+1009,    -0x1.a53f0ce482eep-2,   0x1.967d84p-3, INEXACT)
T(RN, 0x1.1d2bcae6bf7e8p+1009,    0x1.39871fe409a8fp-1,  -0x1.175a92p-2, INEXACT)
T(RN, 0x1.7a154bfa9cc3ap+1009,   -0x1.9356ecf1434dfp-1,   0x1.972e04p-3, INEXACT)
T(RN, 0x1.6bca12ce99ff8p+1009,    0x1.8b658fb64e17dp-1,    0x1.9b2f4p-9, INEXACT)
T(RN, 0x1.d603aa0ef117cp+1009,    0x1.f42641d9163e7p-3,   0x1.91be34p-4, INEXACT)
T(RN, 0x1.f2ee423deaa09p+1009,    0x1.477c41b739f52p-1,  -0x1.4b797ep-2, INEXACT)
T(RN, 0x1.b3e7257e1084ap+1009,   -0x1.90f11c54d0ee7p-1,  -0x1.07312cp-2, INEXACT)
T(RN,   0x1.12757bd90ecp+1009,    0x1.c4a2906a2b36bp-1,  -0x1.a59b44p-2, INEXACT)
T(RN, 0x1.143f552b0cd55p+1010,    0x1.ff35c8cec5bf6p-1,   0x1.92c7d4p-4, INEXACT)
T(RN, 0x1.843bb33c79ba8p+1010,     0x1.aad50050e193p-2,    0x1.e5dcap-2, INEXACT)
T(RN,  0x1.e8459ab8e042p+1010,    0x1.3f297a8ff4cafp-1,  -0x1.f9baa4p-2, INEXACT)
T(RN, 0x1.cea4dadd4fd88p+1010,    0x1.c54f52b0ef989p-2,    0x1.76fa6p-6, INEXACT)
T(RN, 0x1.fc3eb512a983bp+1010,    0x1.b137ec8c0380bp-1,  -0x1.3210dcp-2, INEXACT)
T(RN, 0x1.4f62293ff664ep+1010,   -0x1.16fba76c2bcd1p-1,  -0x1.f5b6bap-4, INEXACT)
T(RN, 0x1.9a1f2f94df6e2p+1010,    0x1.a1e24208764eap-1,  -0x1.b14e08p-9, INEXACT)
T(RN, 0x1.315153618c3bcp+1010,    0x1.75fd8881a1085p-5,   0x1.ad099ep-5, INEXACT)
T(RN, 0x1.6040585f51e28p+1010,    -0x1.16a76a8dcf37p-1,  -0x1.8a4d48p-2, INEXACT)
T(RN, 0x1.35a082cfe641dp+1010,   -0x1.0a2ea946e13e4p-1,  -0x1.d4fc9ap-2, INEXACT)
T(RN, 0x1.575d15b24e0e6p+1011,    0x1.fc0363ba74de2p-1,  -0x1.a34dbep-3, INEXACT)
T(RN, 0x1.9bd4683c87964p+1011,   -0x1.2f920465fecf3p-2,   0x1.6466f6p-3, INEXACT)
T(RN,  0x1.56d57d85236ap+1011,     0x1.69592902ad07p-1,  -0x1.371d92p-5, INEXACT)
T(RN, 0x1.d433a7fc1f33ep+1011,    0x1.7b49b0f5c8f95p-1,   0x1.a62e28p-2, INEXACT)
T(RN, 0x1.ee7de36842be7p+1011,    0x1.f83e0bae9f5bfp-1,    0x1.3d6c3p-2, INEXACT)
T(RN, 0x1.39c16c37f08ffp+1011,   -0x1.413dff5af8915p-3,   0x1.06b508p-4, INEXACT)
T(RN, 0x1.6ffbcb79db3dbp+1011,   -0x1.d9226549ed3a7p-1,   0x1.a097a2p-2, INEXACT)
T(RN, 0x1.3e71caa0d7dc9p+1011,   -0x1.fc0844635e9afp-1,  -0x1.21752ep-3, INEXACT)
T(RN, 0x1.54848516ab07cp+1011,   -0x1.7b912c2a97a13p-2,  -0x1.1f288ep-2, INEXACT)
T(RN, 0x1.bba2c05387074p+1011,    0x1.072e21e4127c6p-1,   0x1.3043ecp-4, INEXACT)
T(RN, 0x1.d664bdd0b0178p+1012,   -0x1.69e39060de289p-2,  -0x1.24ca36p-3, INEXACT)
T(RN, 0x1.d95f1019363a8p+1012,    0x1.83b36079d2a02p-1,   0x1.08850ap-3, INEXACT)
T(RN, 0x1.622804d85b218p+1012,    0x1.fb84993ac809bp-6,    0x1.4f3e6p-4, INEXACT)
T(RN, 0x1.4c085df9ac08cp+1012,    0x1.d6df0f3b28564p-1,   0x1.564b5cp-3, INEXACT)
T(RN, 0x1.94486018c8a6cp+1012,    0x1.fa919563f992ap-1,  -0x1.96431cp-2, INEXACT)
T(RN, 0x1.c6a991af09a95p+1012,   -0x1.5b343fcc27339p-3,   0x1.8e3bbep-2, INEXACT)
T(RN, 0x1.e2c1464276fb2p+1012,   -0x1.728a0d0a9707cp-1,   0x1.7d8a48p-2, INEXACT)
T(RN, 0x1.8bfed4197165cp+1012,    0x1.e99ca76688cc3p-5,  -0x1.0c2f72p-9, INEXACT)
T(RN, 0x1.9a46e32cfe2e6p+1012,   -0x1.b887c584f58dbp-1,    0x1.78811p-2, INEXACT)
T(RN, 0x1.60416569845a8p+1012,   -0x1.d2285b9a4ceaep-1,   0x1.8be6f8p-2, INEXACT)
T(RN,  0x1.7a9f9b47489fp+1013,   -0x1.6024dcf6ea32ap-1,  -0x1.ae49e8p-3, INEXACT)
T(RN, 0x1.e5af486b45fa1p+1013,    0x1.db0b2cd66197dp-1,   -0x1.1daa7p-2, INEXACT)
T(RN, 0x1.ec3a8c42b6ea4p+1013,    0x1.10f2f76801983p-1,  -0x1.e3be04p-3, INEXACT)
T(RN, 0x1.a029eefdaa65cp+1013,   -0x1.ff1c0c0d77708p-1,   0x1.f56db4p-2, INEXACT)
T(RN, 0x1.ee4c716d91ebep+1013,   -0x1.f016838c8fd81p-1,  -0x1.36454ep-2, INEXACT)
T(RN, 0x1.8afd71001adc6p+1013,    0x1.d60973a505d74p-1,   0x1.2a40e4p-3, INEXACT)
T(RN, 0x1.9550b32635d14p+1013,   -0x1.b5ed03020a9b8p-3,  -0x1.1a56dcp-2, INEXACT)
T(RN, 0x1.9329b8e220858p+1013,    0x1.fca7e34996132p-1,  -0x1.7375dep-2, INEXACT)
T(RN, 0x1.4001e69f4bffdp+1013,   -0x1.072ab8022a157p-3,  -0x1.e3c09ap-2, INEXACT)
T(RN, 0x1.f51bbca6fe41ap+1013,    0x1.bbf243c257bc8p-1,   -0x1.188e2p-2, INEXACT)
T(RN, 0x1.b1ec69a9165b7p+1014,    0x1.9fd819d314cbep-1,   0x1.f25ad6p-4, INEXACT)
T(RN, 0x1.18801e8b1c325p+1014,   -0x1.763938492acfap-1,   0x1.24f114p-3, INEXACT)
T(RN, 0x1.c9dd51e2958fcp+1014,    0x1.894828e7e75bep-3,  -0x1.91a35ep-3, INEXACT)
T(RN, 0x1.26920ac4a6e8dp+1014,   -0x1.dd22250cc5347p-1,   0x1.7fed8ap-2, INEXACT)
T(RN, 0x1.ad1088fed286cp+1014,   -0x1.9dda1f7c3ac1dp-1,   0x1.e447acp-2, INEXACT)
T(RN, 0x1.0b074f35fd32ep+1014,   -0x1.3e96aa325f1e9p-2,  -0x1.99bda4p-2, INEXACT)
T(RN, 0x1.2ca31b1682afbp+1014,    0x1.8b16007242a0fp-2,   0x1.e69c3ep-2, INEXACT)
T(RN, 0x1.08d74c255e79bp+1014,   -0x1.902e4510f727ap-2,  -0x1.df6ac4p-2, INEXACT)
T(RN, 0x1.8838ecb54fd86p+1014,   -0x1.814fca4b7a886p-2,  -0x1.35ed06p-3, INEXACT)
T(RN, 0x1.d98bbfd159147p+1014,    0x1.233c70959af85p-1,   0x1.4ff0a4p-4, INEXACT)
T(RN, 0x1.d867eb66d4078p+1015,   -0x1.b30db6bd85817p-1,   0x1.9e63e4p-3, INEXACT)
T(RN, 0x1.fdcf2337830aep+1015,   -0x1.4f585e0b7180fp-1,   -0x1.e45dep-2, INEXACT)
T(RN, 0x1.0515f2341c01dp+1015,    0x1.b411120e6a5ffp-2,  -0x1.f82068p-4, INEXACT)
T(RN, 0x1.f26b7486f1d83p+1015,    0x1.ae5f50e4304adp-1,  -0x1.7abd68p-3, INEXACT)
T(RN, 0x1.26e4f033a9538p+1015,   -0x1.afda5b3503b2dp-4,   -0x1.29c9ep-3, INEXACT)
T(RN, 0x1.f051329a01414p+1015,   -0x1.c799b3a8b7f9bp-5,  -0x1.8a652cp-6, INEXACT)
T(RN, 0x1.16f92ee7a228ep+1015,   -0x1.c9ca6cc6b4231p-1,  -0x1.fc8982p-3, INEXACT)
T(RN, 0x1.839b985e94d9ep+1015,   -0x1.80419ac746e76p-1,  -0x1.95d1a8p-3, INEXACT)
T(RN, 0x1.d7355a4dd131fp+1015,   -0x1.8909168979416p-1,  -0x1.8faeccp-2, INEXACT)
T(RN, 0x1.5b8f47783f33cp+1015,    0x1.ecd11cec86aeep-1,   0x1.13d44ep-5, INEXACT)
T(RN, 0x1.23514fe0df718p+1016,   -0x1.e67a4fe571363p-1,  -0x1.2a9a12p-4, INEXACT)
T(RN, 0x1.150b07336366ap+1016,   -0x1.d3874ebec8e85p-1,  -0x1.d00a94p-4, INEXACT)
T(RN, 0x1.c398dbcbf5fe9p+1016,    0x1.b0203f0e9e507p-1,    -0x1.01a8p-2, INEXACT)
T(RN,   0x1.9bdaf4c2faep+1016,    0x1.36db9e63b0815p-6,   0x1.9ccdfcp-2, INEXACT)
T(RN, 0x1.04dfc1b2b347dp+1016,   -0x1.e250fe68495bfp-1,   0x1.afae94p-4, INEXACT)
T(RN, 0x1.0c2efabb6132cp+1016,   -0x1.edc2a3c7c067cp-4,   0x1.2d3478p-2, INEXACT)
T(RN,  0x1.0366430244a5p+1016,    0x1.84e558a1ccfecp-1,    0x1.3b2cap-4, INEXACT)
T(RN, 0x1.38815574caf9ap+1016,   -0x1.b9c2326e94f57p-1,   0x1.e32eeep-2, INEXACT)
T(RN, 0x1.55cca085c37b3p+1016,   -0x1.79f5bdd8d5b84p-1,  -0x1.5a8cd4p-3, INEXACT)
T(RN, 0x1.e453154fd5118p+1016,   -0x1.df6ecfc917a91p-1,  -0x1.0ad1a4p-5, INEXACT)
T(RN, 0x1.9c33de646ba78p+1017,    0x1.b9819df585503p-1,  -0x1.e1d794p-2, INEXACT)
T(RN, 0x1.d32930d2bdbd2p+1017,    -0x1.f7ff8b842281p-1,  -0x1.2bc23cp-2, INEXACT)
T(RN, 0x1.956d14f1752bcp+1017,    0x1.fec6e7afb67c1p-1,    0x1.da0dap-3, INEXACT)
T(RN, 0x1.dad0b9bf9b0cep+1017,    -0x1.16b7a8825fc5p-3,  -0x1.c29206p-3, INEXACT)
T(RN, 0x1.338baee1fae7bp+1017,    0x1.922828aae0022p-1,   0x1.1b13c8p-2, INEXACT)
T(RN, 0x1.abf510b06a572p+1017,   -0x1.fedc596f8a97cp-1,    0x1.26dc3p-5, INEXACT)
T(RN, 0x1.555c35e44a668p+1017,   -0x1.ec3b7bc4a85e8p-1,    0x1.efdbap-3, INEXACT)
T(RN, 0x1.0eb01d76ea7dep+1017,    0x1.91a242a50a7bbp-1,  -0x1.4e4236p-2, INEXACT)
T(RN, 0x1.76a7136bbb6b4p+1017,    0x1.2312a99e644eep-1,  -0x1.7cd1f4p-2, INEXACT)
T(RN, 0x1.28a865a36baf6p+1017,    0x1.d16b070acdecap-1,  -0x1.692e7ep-2, INEXACT)
T(RN, 0x1.bcbabc53148b2p+1018,   -0x1.fff46d70e2c1ep-1,  -0x1.effe9ap-2, INEXACT)
T(RN, 0x1.a72e7f92d0594p+1018,    0x1.fd74b9c0e6b39p-1,   0x1.5ff858p-3, INEXACT)
T(RN, 0x1.bf3527700e87ep+1018,    0x1.b9a7a36a7eac7p-1,  -0x1.75af92p-2, INEXACT)
T(RN, 0x1.61630a909260dp+1018,    0x1.d5c46f016c24fp-1,   0x1.cc3af8p-4, INEXACT)
T(RN, 0x1.c5c032a1fba7ap+1018,   -0x1.a8aeddc47cc01p-1,  -0x1.4d8496p-3, INEXACT)
T(RN, 0x1.06cb72da9b98ep+1018,   -0x1.d424e5427efa4p-3,  -0x1.01a1c6p-4, INEXACT)
T(RN, 0x1.2a7185358fe1dp+1018,   -0x1.62a7d9b992fa7p-4,   0x1.d01c44p-3, INEXACT)
T(RN, 0x1.fd1437eac3358p+1018,   -0x1.242de85580d75p-1,   0x1.fe3982p-3, INEXACT)
T(RN, 0x1.134cf9aeea879p+1018,   -0x1.f124d5c907c67p-2,   0x1.f9fd1cp-2, INEXACT)
T(RN, 0x1.5a2f4f6b2361fp+1018,    0x1.6bbd9e89b1772p-1,  -0x1.325cbep-4, INEXACT)
T(RN, 0x1.dbbd56c43fddap+1019,    0x1.ff798fb88cacap-1,  -0x1.a2aa68p-2, INEXACT)
T(RN, 0x1.e46606b116ac8p+1019,    0x1.307c7284b3911p-5,   0x1.9b5598p-3, INEXACT)
T(RN,  0x1.78112b7d20d4p+1019,   -0x1.727ef1c33d894p-1,  -0x1.1cb24ap-2, INEXACT)
T(RN, 0x1.090ecd6e00ea2p+1019,   -0x1.697ecf0b5245ep-1,  -0x1.549d04p-5, INEXACT)
T(RN, 0x1.c4dee8b827963p+1019,   -0x1.3f2c626f04d2bp-1,  -0x1.7454fep-5, INEXACT)
T(RN, 0x1.3d8495bcdcb1cp+1019,    0x1.438f864b8fd34p-1,    0x1.35ce9p-4, INEXACT)
T(RN, 0x1.7cac2b1009f7ap+1019,    0x1.81beae334f07bp-1,  -0x1.067298p-2, INEXACT)
T(RN, 0x1.724ef451bdc13p+1019,   -0x1.087f8b7e25e72p-3,  -0x1.2aa70ap-2, INEXACT)
T(RN, 0x1.e6bb0b001d554p+1019,    0x1.8e714eebc4ba4p-1,   0x1.4b788ap-2, INEXACT)
T(RN, 0x1.9a55115bbc57bp+1019,    0x1.ef4ecef71fbadp-2,   0x1.aa290ap-4, INEXACT)
T(RN, 0x1.03684e954c7cfp+1020,   -0x1.1471c51d5bc74p-2,  -0x1.54bddap-2, INEXACT)
T(RN, 0x1.bec7375cbee38p+1020,   -0x1.9a1d5803be64bp-1,  -0x1.137bc8p-2, INEXACT)
T(RN, 0x1.2e7c1dfa37a8dp+1020,    0x1.2df4bd49bf34ep-1,   0x1.33de6ap-6, INEXACT)
T(RN,  0x1.5c72b21a2da4p+1020,     0x1.0fdd84414194p-1,  -0x1.6245fap-2, INEXACT)
T(RN, 0x1.784a43c9e826dp+1020,    -0x1.b9efba66eb7dp-1,  -0x1.0bc65ep-2, INEXACT)
T(RN, 0x1.ae165a8264ae2p+1020,   -0x1.ff9b74a9cdd7bp-1,   0x1.af58dcp-4, INEXACT)
T(RN, 0x1.32f5ba4619864p+1020,    0x1.62857f9adfc86p-1,   0x1.b1c4f2p-2, INEXACT)
T(RN, 0x1.355c3804dfeebp+1020,    0x1.0cf2576b952bdp-1,   0x1.9c344ep-2, INEXACT)
T(RN, 0x1.d3089fde7c5ddp+1020,   -0x1.f32dc675f6171p-1,   0x1.f95e0cp-3, INEXACT)
T(RN, 0x1.3b06ac371fa26p+1020,   -0x1.a37a531091f2ep-1,  -0x1.c0ce6cp-6, INEXACT)
T(RN, 0x1.dd0c5599fbebdp+1021,   -0x1.6cb69add1b106p-1,  -0x1.f25a02p-2, INEXACT)
T(RN, 0x1.d168385f09894p+1021,   -0x1.54eedb777f14dp-1,   0x1.2cdb2ep-2, INEXACT)
T(RN, 0x1.6c6a4dd7159f2p+1021,   -0x1.5d3bdf5b0cafap-3,   0x1.89d238p-2, INEXACT)
T(RN, 0x1.ef53b688d6cbap+1021,    0x1.d92ada0cc13eep-2,   0x1.a20f9ep-7, INEXACT)
T(RN, 0x1.124302ffe627ep+1021,   -0x1.ce9b5f4af145dp-5,  -0x1.deca16p-2, INEXACT)
T(RN, 0x1.22116269ea0d2p+1021,    0x1.92f49546b44adp-1,    0x1.238abp-4, INEXACT)
T(RN, 0x1.0573252f68a95p+1021,    0x1.f539cb34f9af7p-2,   0x1.e303dep-2, INEXACT)
T(RN, 0x1.da37034bebee8p+1021,   -0x1.632a0f3844c4bp-1,  -0x1.28093ep-2, INEXACT)
T(RN, 0x1.c63121ffa203ep+1021,   -0x1.2814dc48aa0e5p-1,  -0x1.eede9ap-3, INEXACT)
T(RN, 0x1.fe78c8f43c8aap+1021,   -0x1.5c66729801103p-4,   0x1.0d19b4p-4, INEXACT)
T(RN, 0x1.88b8d32ae3fa6p+1022,    0x1.e379c6778478dp-6,  -0x1.4b94d2p-4, INEXACT)
T(RN, 0x1.a7f17ee4d6aa6p+1022,   -0x1.d31a38f0e8213p-4,   0x1.9d3358p-2, INEXACT)
T(RN, 0x1.c36efb7e43882p+1022,   -0x1.dcec8ae697827p-1,    0x1.408b2p-2, INEXACT)
T(RN, 0x1.de1a632d12e08p+1022,    0x1.3040a5397e7c9p-1,   0x1.62d016p-4, INEXACT)
T(RN, 0x1.16177212d8b5cp+1022,   -0x1.d52ce1ea8a5d9p-1,  -0x1.05fba2p-2, INEXACT)
T(RN, 0x1.9cdc1bacf5564p+1022,    0x1.9c502e98bee5dp-1,   0x1.cbd6ecp-5, INEXACT)
T(RN, 0x1.fa5b6dda42c9bp+1022,   -0x1.ec04d04ed8ebbp-2,   -0x1.636a3p-2, INEXACT)
T(RN,   0x1.5998ff1d47dp+1022,   -0x1.f3894b72dd244p-1,  -0x1.cce40cp-2, INEXACT)
T(RN, 0x1.4da07c782b6c6p+1022,   -0x1.aab6e624d9e07p-3,    0x1.e0539p-4, INEXACT)
T(RN, 0x1.42dd6bd7bdaa2p+1022,   -0x1.eceb41c73df43p-1,   0x1.76d4e8p-2, INEXACT)
T(RN, 0x1.976201eba9e44p+1023,   -0x1.804ac8e5ddddfp-1,    0x1.63598p-4, INEXACT)
T(RN, 0x1.576b5f9bd4cacp+1023,    0x1.77dcee026180fp-1,   0x1.bc60e6p-2, INEXACT)
T(RN, 0x1.4617d52e7b83bp+1023,   -0x1.cd7ae95a70078p-3,  -0x1.65be52p-2, INEXACT)
T(RN, 0x1.908846ab768a4p+1023,    0x1.7c0dc13f0604ep-1,   0x1.249046p-2, INEXACT)
T(RN,  0x1.8319ea32feb7p+1023,    -0x1.648e1bfe9587p-1,   -0x1.dcd92p-3, INEXACT)
T(RN,  0x1.93f11cfcce9fp+1023,    0x1.c387a4ba7cab1p-2,  -0x1.0aaf56p-3, INEXACT)
T(RN, 0x1.64bba6c62866ep+1023,   -0x1.1cce01dcd6744p-1,   0x1.c33372p-2, INEXACT)
T(RN, 0x1.7dde106e9572bp+1023,   -0x1.4234b43440367p-2,   0x1.7e4838p-3, INEXACT)
T(RN, 0x1.e884711f29316p+1023,   -0x1.96e707b25e786p-1,   0x1.35c16cp-2, INEXACT)
T(RN, 0x1.ecc659b09f268p+1023,    0x1.d8e3ff33ed8e5p-1,  -0x1.ac7864p-4, INEXACT)
