// SPDX-License-Identifier: Unlicense OR BSD-3-Clause

package harfbuzz

// Code generated by typesettings-utils/generators/unicodedata/cmd/main.go DO NOT EDIT.
const (
	_B    = useSM_ex_B
	_CGJ  = useSM_ex_CGJ
	_CS   = useSM_ex_CS
	_G    = useSM_ex_G
	_GB   = useSM_ex_GB
	_H    = useSM_ex_H
	_HN   = useSM_ex_HN
	_HVM  = useSM_ex_HVM
	_IS   = useSM_ex_IS
	_J    = useSM_ex_J
	_N    = useSM_ex_N
	_O    = useSM_ex_O
	_R    = useSM_ex_R
	_SB   = useSM_ex_SB
	_SE   = useSM_ex_SE
	_SUB  = useSM_ex_SUB
	_Sk   = useSM_ex_Sk
	_WJ   = useSM_ex_WJ
	_ZWNJ = useSM_ex_ZWNJ
)
const (
	_CMAbv = useSM_ex_CMAbv
	_CMBlw = useSM_ex_CMBlw
	_FAbv  = useSM_ex_FAbv
	_FBlw  = useSM_ex_FBlw
	_FPst  = useSM_ex_FPst
	_FMAbv = useSM_ex_FMAbv
	_FMBlw = useSM_ex_FMBlw
	_FMPst = useSM_ex_FMPst
	_MAbv  = useSM_ex_MAbv
	_MBlw  = useSM_ex_MBlw
	_MPre  = useSM_ex_MPre
	_MPst  = useSM_ex_MPst
	_SMAbv = useSM_ex_SMAbv
	_SMBlw = useSM_ex_SMBlw
	_VAbv  = useSM_ex_VAbv
	_VBlw  = useSM_ex_VBlw
	_VPre  = useSM_ex_VPre
	_VPst  = useSM_ex_VPst
	_VMAbv = useSM_ex_VMAbv
	_VMBlw = useSM_ex_VMBlw
	_VMPre = useSM_ex_VMPre
	_VMPst = useSM_ex_VMPst
)

var useTable = [...]uint8{

	/* Basic Latin */
	_O, _O, _O, _O, _O, _GB, _O, _O,
	/* 0030 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _O, _O, _O, _O, _O, _O,

	/* Latin-1 Supplement */

	/* 00A0 */ _GB, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _WJ, _O, _O,
	/* 00B0 */ _O, _O, _FMPst, _FMPst, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 00C0 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 00D0 */ _O, _O, _O, _O, _O, _O, _O, _GB,

	/* Combining Diacritical Marks */
	_O, _O, _O, _O, _O, _O, _O, _CGJ,

	/* Arabic */

	/* 0640 */ _B, _O, _O, _O, _O, _O, _O, _O,

	/* NKo */
	_O, _O, _B, _B, _B, _B, _B, _B,
	/* 07D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 07E0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv,
	/* 07F0 */ _VMAbv, _VMAbv, _VMAbv, _VMAbv, _O, _O, _O, _O,

	/* Mandaic */

	/* 0840 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0850 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _CMBlw, _CMBlw, _CMBlw, _WJ, _WJ, _O, _WJ,

	/* Devanagari */

	/* 0900 */ _VMAbv, _VMAbv, _VMAbv, _VMPst, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0910 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0920 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0930 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VAbv, _VPst, _CMBlw, _B, _VPst, _VPre,
	/* 0940 */ _VPst, _VBlw, _VBlw, _VBlw, _VBlw, _VAbv, _VAbv, _VAbv, _VAbv, _VPst, _VPst, _VPst, _VPst, _H, _VPre, _VPst,
	/* 0950 */ _O, _VMAbv, _VMBlw, _O, _O, _VAbv, _VBlw, _VBlw, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0960 */ _B, _B, _VBlw, _VBlw, _O, _O, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0970 */ _O, _O, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,

	/* Bengali */

	/* 0980 */ _GB, _VMAbv, _VMPst, _VMPst, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _B,
	/* 0990 */ _B, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 09A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _B, _B, _B, _B,
	/* 09B0 */ _B, _WJ, _B, _WJ, _WJ, _WJ, _B, _B, _B, _B, _WJ, _WJ, _CMBlw, _B, _VPst, _VPre,
	/* 09C0 */ _VPst, _VBlw, _VBlw, _VBlw, _VBlw, _WJ, _WJ, _VPre, _VPre, _WJ, _WJ, _VPre, _VPre, _H, _O, _WJ,
	/* 09D0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _VPst, _WJ, _WJ, _WJ, _WJ, _B, _B, _WJ, _B,
	/* 09E0 */ _B, _B, _VBlw, _VBlw, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 09F0 */ _B, _B, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _B, _O, _FMAbv, _WJ,

	/* Gurmukhi */

	/* 0A00 */ _WJ, _VMAbv, _VMAbv, _VMPst, _WJ, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _B,
	/* 0A10 */ _B, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0A20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _B, _B, _B, _B,
	/* 0A30 */ _B, _WJ, _B, _B, _WJ, _B, _B, _WJ, _B, _B, _WJ, _WJ, _CMBlw, _WJ, _VPst, _VPre,
	/* 0A40 */ _VPst, _VBlw, _VBlw, _WJ, _WJ, _WJ, _WJ, _VAbv, _VAbv, _WJ, _WJ, _VAbv, _VAbv, _H, _WJ, _WJ,
	/* 0A50 */ _WJ, _VMBlw, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _B, _B, _B, _B, _WJ, _B, _WJ,
	/* 0A60 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0A70 */ _VMAbv, _CMAbv, _GB, _GB, _O, _MBlw, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Gujarati */

	/* 0A80 */ _WJ, _VMAbv, _VMAbv, _VMPst, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B,
	/* 0A90 */ _B, _B, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0AA0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _B, _B, _B, _B,
	/* 0AB0 */ _B, _WJ, _B, _B, _WJ, _B, _B, _B, _B, _B, _WJ, _WJ, _CMBlw, _B, _VPst, _VPre,
	/* 0AC0 */ _VPst, _VBlw, _VBlw, _VBlw, _VBlw, _VAbv, _WJ, _VAbv, _VAbv, _VAbv, _WJ, _VPst, _VPst, _H, _WJ, _WJ,
	/* 0AD0 */ _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 0AE0 */ _B, _B, _VBlw, _VBlw, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0AF0 */ _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _B, _VMAbv, _CMAbv, _VMAbv, _CMAbv, _CMAbv, _CMAbv,
	/* 0B00 */ _WJ, _VMAbv, _VMPst, _VMPst, _WJ, _B, _B, _B,

	/* Oriya */
	_B, _B, _B, _B, _B, _WJ, _WJ, _B,
	/* 0B10 */ _B, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0B20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _B, _B, _B, _B,
	/* 0B30 */ _B, _WJ, _B, _B, _WJ, _B, _B, _B, _B, _B, _WJ, _WJ, _CMBlw, _B, _VPst, _VAbv,
	/* 0B40 */ _VPst, _VBlw, _VBlw, _VBlw, _VBlw, _WJ, _WJ, _VPre, _VPre, _WJ, _WJ, _VPre, _VPre, _H, _WJ, _WJ,
	/* 0B50 */ _WJ, _WJ, _WJ, _WJ, _WJ, _VAbv, _VAbv, _VAbv, _WJ, _WJ, _WJ, _WJ, _B, _B, _WJ, _B,
	/* 0B60 */ _B, _B, _VBlw, _VBlw, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0B70 */ _O, _B, _O, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Tamil */

	/* 0B80 */ _WJ, _WJ, _VMAbv, _O, _WJ, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _B, _B,
	/* 0B90 */ _B, _WJ, _B, _B, _B, _B, _WJ, _WJ, _WJ, _B, _B, _WJ, _B, _WJ, _B, _B,
	/* 0BA0 */ _WJ, _WJ, _WJ, _B, _B, _WJ, _WJ, _WJ, _B, _B, _B, _WJ, _WJ, _WJ, _B, _B,
	/* 0BB0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _VPst, _VPst,
	/* 0BC0 */ _VAbv, _VPst, _VPst, _WJ, _WJ, _WJ, _VPre, _VPre, _VPre, _WJ, _VPre, _VPre, _VPre, _H, _WJ, _WJ,
	/* 0BD0 */ _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _VPst, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 0BE0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0BF0 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Telugu */

	/* 0C00 */ _VMAbv, _VMPst, _VMPst, _VMPst, _VMAbv, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B,
	/* 0C10 */ _B, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0C20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _B, _B, _B, _B,
	/* 0C30 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _CMBlw, _B, _VAbv, _VAbv,
	/* 0C40 */ _VAbv, _VPst, _VPst, _VPst, _VPst, _WJ, _VAbv, _VAbv, _VAbv, _WJ, _VAbv, _VAbv, _VAbv, _H, _WJ, _WJ,
	/* 0C50 */ _WJ, _WJ, _WJ, _WJ, _WJ, _VAbv, _VBlw, _WJ, _B, _B, _B, _WJ, _WJ, _O, _WJ, _WJ,
	/* 0C60 */ _B, _B, _VBlw, _VBlw, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0C70 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _O, _O, _O, _O, _O, _O, _O, _O, _O,

	/* Kannada */

	/* 0C80 */ _B, _VMAbv, _VMPst, _VMPst, _O, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B,
	/* 0C90 */ _B, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0CA0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _B, _B, _B, _B,
	/* 0CB0 */ _B, _B, _B, _B, _WJ, _B, _B, _B, _B, _B, _WJ, _WJ, _CMBlw, _B, _VPst, _VAbv,
	/* 0CC0 */ _VAbv, _VPst, _VPst, _VPst, _VPst, _WJ, _VAbv, _VAbv, _VAbv, _WJ, _VAbv, _VAbv, _VAbv, _H, _WJ, _WJ,
	/* 0CD0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _VPst, _VPst, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _O, _B, _WJ,
	/* 0CE0 */ _B, _B, _VBlw, _VBlw, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0CF0 */ _WJ, _CS, _CS, _VMPst, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Malayalam */

	/* 0D00 */ _VMAbv, _VMAbv, _VMPst, _VMPst, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B,
	/* 0D10 */ _B, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0D20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0D30 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VAbv, _VAbv, _B, _VPst, _VPst,
	/* 0D40 */ _VPst, _VPst, _VPst, _VBlw, _VBlw, _WJ, _VPre, _VPre, _VPre, _WJ, _VPre, _VPre, _VPre, _H, _R, _O,
	/* 0D50 */ _WJ, _WJ, _WJ, _WJ, _O, _O, _O, _VPst, _O, _O, _O, _O, _O, _O, _O, _B,
	/* 0D60 */ _B, _B, _VBlw, _VBlw, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0D70 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,

	/* Sinhala */

	/* 0D80 */ _WJ, _VMAbv, _VMPst, _VMPst, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0D90 */ _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _B, _B, _B, _B, _B, _B,
	/* 0DA0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0DB0 */ _B, _B, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _WJ, _WJ,
	/* 0DC0 */ _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _HVM, _WJ, _WJ, _WJ, _WJ, _VPst,
	/* 0DD0 */ _VPst, _VPst, _VAbv, _VAbv, _VBlw, _WJ, _VBlw, _WJ, _VPst, _VPre, _VPre, _VPre, _VPre, _VPre, _VPre, _VPst,
	/* 0DE0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0DF0 */ _WJ, _WJ, _VPst, _VPst, _O, _WJ, _WJ, _WJ,

	/* Tibetan */

	/* 0F00 */ _B, _B, _O, _O, _B, _B, _B, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 0F10 */ _O, _O, _O, _O, _O, _O, _O, _O, _VBlw, _VBlw, _O, _O, _O, _O, _O, _O,
	/* 0F20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0F30 */ _B, _B, _B, _B, _O, _FMBlw, _O, _FMBlw, _O, _CMAbv, _O, _O, _O, _O, _VPst, _VPre,
	/* 0F40 */ _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _B, _B, _B, _B, _B,
	/* 0F50 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 0F60 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ,
	/* 0F70 */ _WJ, _CMBlw, _VBlw, _VAbv, _VAbv, _VBlw, _VAbv, _VAbv, _VAbv, _VAbv, _VBlw, _VBlw, _VBlw, _VBlw, _VMAbv, _O,
	/* 0F80 */ _VBlw, _VAbv, _VMAbv, _VMAbv, _VBlw, _O, _VMAbv, _VMAbv, _B, _B, _B, _B, _B, _SUB, _SUB, _SUB,
	/* 0F90 */ _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _WJ, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB,
	/* 0FA0 */ _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB,
	/* 0FB0 */ _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _WJ, _O, _O,

	/* Myanmar */

	/* 1000 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1010 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1020 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VPst, _VPst, _VAbv, _VAbv, _VBlw,
	/* 1030 */ _VBlw, _VPre, _VAbv, _VAbv, _VAbv, _VAbv, _VMAbv, _VMBlw, _VMPst, _IS, _VAbv, _MPst, _MPre, _MBlw, _MBlw, _B,
	/* 1040 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _O, _GB, _O, _O, _GB, _O,
	/* 1050 */ _B, _B, _B, _B, _B, _B, _VPst, _VPst, _VBlw, _VBlw, _B, _B, _B, _B, _MBlw, _MBlw,
	/* 1060 */ _MBlw, _B, _VPst, _VMPst, _VMPst, _B, _B, _VPst, _VPst, _VMPst, _VMPst, _VMPst, _VMPst, _VMPst, _B, _B,
	/* 1070 */ _B, _VAbv, _VAbv, _VAbv, _VAbv, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1080 */ _B, _B, _MBlw, _VPst, _VPre, _VAbv, _VAbv, _VMPst, _VMPst, _VMPst, _VMPst, _VMPst, _VMPst, _VMBlw, _B, _VMPst,
	/* 1090 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VMPst, _VMPst, _VPst, _VAbv, _O, _O,

	/* Tagalog */

	/* 1700 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1710 */ _B, _B, _VAbv, _VBlw, _VBlw, _VPst, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _B,

	/* Hanunoo */

	/* 1720 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1730 */ _B, _B, _VAbv, _VBlw, _VPst, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Buhid */

	/* 1740 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1750 */ _B, _B, _VAbv, _VBlw, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Tagbanwa */

	/* 1760 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B,
	/* 1770 */ _B, _WJ, _VAbv, _VBlw, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Khmer */

	/* 1780 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1790 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 17A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 17B0 */ _B, _B, _B, _B, _CGJ, _CGJ, _VPst, _VAbv, _VAbv, _VAbv, _VAbv, _VBlw, _VBlw, _VBlw, _VPre, _VPre,
	/* 17C0 */ _VPre, _VPre, _VPre, _VPre, _VPre, _VPre, _VMAbv, _VMPst, _VPst, _VMAbv, _VMAbv, _FMAbv, _FAbv, _CMAbv, _FMAbv, _VMAbv,
	/* 17D0 */ _FMAbv, _VAbv, _IS, _FMAbv, _O, _O, _O, _O, _O, _O, _O, _O, _B, _FMAbv, _WJ, _WJ,
	/* 17E0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 17F0 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Mongolian */

	/* 1800 */ _B, _O, _O, _O, _O, _O, _O, _B, _O, _O, _B, _CGJ, _CGJ, _CGJ, _WJ, _CGJ,
	/* 1810 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 1820 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1830 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1840 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1850 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1860 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1870 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 1880 */ _GB, _GB, _GB, _GB, _GB, _CMAbv, _CMAbv, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1890 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _CMBlw, _B, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Limbu */

	/* 1900 */ _GB, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1910 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ,
	/* 1920 */ _VAbv, _VAbv, _VBlw, _VPst, _VPst, _VAbv, _VAbv, _VAbv, _VAbv, _SUB, _SUB, _SUB, _WJ, _WJ, _WJ, _WJ,
	/* 1930 */ _FPst, _FPst, _VMBlw, _FPst, _FPst, _FPst, _FPst, _FPst, _FPst, _FBlw, _VMAbv, _FMBlw, _WJ, _WJ, _WJ, _WJ,
	/* 1940 */ _O, _WJ, _WJ, _WJ, _O, _O, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1950 */ _B, _B, _B, _B, _B, _B, _B, _B,

	/* Tai Le */
	_B, _B, _B, _B, _B, _B, _B, _B,
	/* 1960 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ,
	/* 1970 */ _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* New Tai Lue */

	/* 1980 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1990 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 19A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ,
	/* 19B0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 19C0 */ _B, _B, _B, _B, _B, _B, _B, _B, _VMPst, _VMPst, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 19D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _O, _O,
	/* 19E0 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 19F0 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,

	/* Buginese */

	/* 1A00 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1A10 */ _B, _B, _B, _B, _B, _B, _B, _VAbv, _VAbv, _VPre, _VPst, _VAbv, _WJ, _WJ, _O, _O,
	/* 1A20 */ _B, _B, _B, _B, _B, _B, _B, _B,

	/* Tai Tham */
	_B, _B, _B, _B, _B, _B, _B, _B,
	/* 1A30 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1A40 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1A50 */ _B, _B, _B, _B, _B, _MPre, _MBlw, _SUB, _FAbv, _FAbv, _MAbv, _SUB, _SUB, _SUB, _SUB, _WJ,
	/* 1A60 */ _Sk, _VPst, _VAbv, _VPst, _VPst, _VAbv, _VAbv, _VAbv, _VAbv, _VBlw, _VBlw, _VAbv, _VBlw, _VPst, _VPre, _VPre,
	/* 1A70 */ _VPre, _VPre, _VPre, _VAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VAbv, _VMAbv, _VMAbv, _WJ, _WJ, _VMBlw,
	/* 1A80 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 1A90 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Balinese */

	/* 1B00 */ _VMAbv, _VMAbv, _VMAbv, _FAbv, _VMPst, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1B10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1B20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1B30 */ _B, _B, _B, _B, _CMAbv, _VPst, _VAbv, _VAbv, _VBlw, _VBlw, _VBlw, _VBlw, _VAbv, _VAbv, _VPre, _VPre,
	/* 1B40 */ _VPre, _VPre, _VAbv, _VAbv, _H, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ,
	/* 1B50 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _O, _O, _O, _O, _O, _O,
	/* 1B60 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _SMAbv, _SMBlw, _SMAbv, _SMAbv, _SMAbv,
	/* 1B70 */ _SMAbv, _SMAbv, _SMAbv, _SMAbv, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _WJ,

	/* Sundanese */

	/* 1B80 */ _VMAbv, _FAbv, _VMPst, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1B90 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1BA0 */ _B, _SUB, _SUB, _SUB, _VAbv, _VBlw, _VPre, _VPst, _VAbv, _VAbv, _VPst, _IS, _SUB, _SUB, _B, _B,
	/* 1BB0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1BC0 */ _B, _B, _B, _B, _B, _B, _B, _B,

	/* Batak */
	_B, _B, _B, _B, _B, _B, _B, _B,
	/* 1BD0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1BE0 */ _B, _B, _B, _B, _B, _B, _CMAbv, _VPst, _VAbv, _VAbv, _VPst, _VPst, _VPst, _VAbv, _VPst, _VAbv,
	/* 1BF0 */ _FAbv, _FAbv, _CMBlw, _CMBlw, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _O, _O, _O, _O,

	/* Lepcha */

	/* 1C00 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1C10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1C20 */ _B, _B, _B, _B, _SUB, _SUB, _VPst, _VPre, _VPre, _VPre, _VPst, _VPst, _VBlw, _FAbv, _FAbv, _FAbv,
	/* 1C30 */ _FAbv, _FAbv, _FAbv, _FAbv, _VMPre, _VMPre, _FMAbv, _CMBlw, _WJ, _WJ, _WJ, _O, _O, _O, _O, _O,
	/* 1C40 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _B, _B, _B,

	/* Vedic Extensions */

	/* 1CD0 */ _VMAbv, _VMAbv, _VMAbv, _O, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMAbv, _VMAbv, _VMBlw, _VMBlw, _VMBlw, _VMBlw,
	/* 1CE0 */ _VMAbv, _VMPst, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _O, _O, _O, _O, _VMBlw, _O, _O,
	/* 1CF0 */ _O, _O, _O, _O, _VMAbv, _CS, _CS, _VMPst, _VMAbv, _VMAbv, _GB, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Combining Diacritical Marks Supplement */
	_O, _O, _O, _FMAbv, _O, _O, _O, _O,

	/* General Punctuation */
	_O, _O, _O, _WJ, _ZWNJ, _CGJ, _WJ, _WJ,
	/* 2010 */ _GB, _GB, _GB, _GB, _GB, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 2020 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _O,
	/* 2030 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 2040 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 2050 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 2060 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 2070 */ _O, _O, _WJ, _WJ, _FMPst, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,

	/* Superscripts and Subscripts */

	/* 2080 */ _O, _O, _FMPst, _FMPst, _FMPst, _O, _O, _O,

	/* Combining Diacritical Marks for Symbols */

	/* 20F0 */ _VMAbv, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Geometric Shapes */
	_O, _O, _O, _O, _B, _O, _O, _O,

	/* Tifinagh */

	/* 2D30 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 2D40 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 2D50 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 2D60 */ _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _B,
	/* 2D70 */ _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _H,

	/* Syloti Nagri */

	/* A800 */ _B, _B, _VAbv, _B, _B, _B, _H, _B, _B, _B, _B, _VMAbv, _B, _B, _B, _B,
	/* A810 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A820 */ _B, _B, _B, _VPst, _VPst, _VBlw, _VAbv, _VPst, _O, _O, _O, _O, _VBlw, _WJ, _WJ, _WJ,
	/* A830 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Phags-pa */

	/* A840 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A850 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A860 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A870 */ _B, _B, _B, _B, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Saurashtra */

	/* A880 */ _VMPst, _VMPst, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A890 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A8A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A8B0 */ _B, _B, _B, _B, _MPst, _VPst, _VPst, _VPst, _VPst, _VPst, _VPst, _VPst, _VPst, _VPst, _VPst, _VPst,
	/* A8C0 */ _VPst, _VPst, _VPst, _VPst, _H, _VMAbv, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _O, _O,
	/* A8D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* A8E0 */ _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv,

	/* Devanagari Extended */
	_VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv,
	/* A8F0 */ _VMAbv, _VMAbv, _B, _B, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _B, _VAbv,

	/* Kayah Li */

	/* A900 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A910 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A920 */ _B, _B, _B, _B, _B, _B, _VAbv, _VAbv, _VAbv, _VAbv, _VAbv, _VMBlw, _VMBlw, _VMBlw, _O, _O,
	/* A930 */ _B, _B, _B, _B, _B, _B, _B, _B,

	/* Rejang */
	_B, _B, _B, _B, _B, _B, _B, _B,
	/* A940 */ _B, _B, _B, _B, _B, _B, _B, _VBlw, _VBlw, _VBlw, _VAbv, _VBlw, _VBlw, _VBlw, _VBlw, _FAbv,
	/* A950 */ _FAbv, _FAbv, _FPst, _VPst, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _O,
	/* A960 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* A970 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ,

	/* Javanese */

	/* A980 */ _VMAbv, _VMAbv, _FAbv, _VMPst, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A990 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A9A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* A9B0 */ _B, _B, _B, _CMAbv, _VPst, _VPst, _VAbv, _VAbv, _VBlw, _VBlw, _VPre, _VPre, _VAbv, _MBlw, _MPst, _MBlw,
	/* A9C0 */ _H, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _WJ, _O,
	/* A9D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _O, _O,
	/* A9E0 */ _B, _B, _B, _B, _B, _VAbv, _O, _B,

	/* Myanmar Extended-B */
	_B, _B, _B, _B, _B, _B, _B, _B,
	/* A9F0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ,
	/* AA00 */ _B, _B, _B, _B, _B, _B, _B, _B,

	/* Cham */
	_B, _B, _B, _B, _B, _B, _B, _B,
	/* AA10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* AA20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _VMAbv, _VAbv, _VAbv, _VAbv, _VBlw, _VAbv, _VPre,
	/* AA30 */ _VPre, _VAbv, _VBlw, _MPst, _MPre, _MAbv, _MBlw, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* AA40 */ _B, _B, _B, _FAbv, _B, _B, _B, _B, _B, _B, _B, _B, _FAbv, _FPst, _WJ, _WJ,
	/* AA50 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _O, _O, _O, _O,
	/* AA60 */ _B, _B, _B, _B, _B, _B, _B, _B,

	/* Myanmar Extended-A */
	_B, _B, _B, _B, _B, _B, _B, _B,
	/* AA70 */ _O, _B, _B, _B, _GB, _GB, _GB, _O, _O, _O, _B, _VMPst, _VMAbv, _VMPst, _B, _B,
	/* AA80 */ _B, _B, _B, _B, _B, _B, _B, _B,

	/* Tai Viet */
	_B, _B, _B, _B, _B, _B, _B, _B,
	/* AA90 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* AAA0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* AAB0 */ _VAbv, _B, _VAbv, _VAbv, _VBlw, _B, _B, _VAbv, _VAbv, _B, _B, _B, _B, _B, _VAbv, _VMAbv,
	/* AAC0 */ _B, _VMAbv, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* AAD0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _O, _O, _O, _O, _O,

	/* Meetei Mayek Extensions */

	/* AAE0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VPre, _VBlw, _VAbv, _VPre, _VPst,

	/* Meetei Mayek */

	/* ABC0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* ABD0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* ABE0 */ _B, _B, _B, _VPst, _VPst, _VAbv, _VPst, _VPst, _VBlw, _VPst, _VPst, _O, _VMPst, _VBlw, _WJ, _WJ,
	/* ABF0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Variation Selectors */

	/* FE00 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,

	/* Arabic Presentation Forms-B */
	_O, _O, _O, _O, _O, _WJ, _WJ, _WJ,

	/* Specials */

	/* FFF0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _O, _O, _O, _O, _O, _WJ, _WJ,

	/* Vithkuqi */

	/* 10570 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _B, _B,
	/* 10580 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _B, _B,
	/* 10590 */ _B, _B, _B, _WJ, _B, _B, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 105A0 */ _B, _B, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 105B0 */ _B, _B, _WJ, _B, _B, _B, _B, _B,

	/* Kharoshthi */

	/* 10A00 */ _B, _VBlw, _VBlw, _VBlw, _WJ, _VAbv, _VBlw, _WJ, _WJ, _WJ, _WJ, _WJ, _VPst, _VMBlw, _VMBlw, _VMAbv,
	/* 10A10 */ _B, _B, _B, _B, _WJ, _B, _B, _B, _WJ, _B, _B, _B, _B, _B, _B, _B,
	/* 10A20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 10A30 */ _B, _B, _B, _B, _B, _B, _WJ, _WJ, _CMBlw, _CMBlw, _CMBlw, _WJ, _WJ, _WJ, _WJ, _IS,
	/* 10A40 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Manichaean */

	/* 10AC0 */ _B, _B, _B, _B, _B, _B, _B, _B, _O, _B, _B, _B, _B, _B, _B, _B,
	/* 10AD0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 10AE0 */ _B, _B, _B, _B, _B, _CMBlw, _CMBlw, _WJ,

	/* Psalter Pahlavi */

	/* 10B80 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 10B90 */ _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _O, _O, _O, _O, _WJ, _WJ, _WJ,
	/* 10BA0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _O,

	/* Hanifi Rohingya */

	/* 10D00 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 10D10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 10D20 */ _B, _B, _B, _B, _VMAbv, _VMAbv, _VMAbv, _CMAbv, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 10D30 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Yezidi */

	/* 10E80 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 10E90 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 10EA0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _VAbv, _VAbv, _O, _WJ, _WJ,

	/* Sogdian */

	/* 10F30 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 10F40 */ _B, _B, _B, _B, _B, _B, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw,
	/* 10F50 */ _VMBlw, _B, _B, _B, _B, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 10F60 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Old Uyghur */

	/* 10F70 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 10F80 */ _B, _B, _CMBlw, _CMBlw, _CMBlw, _CMBlw, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 10F90 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 10FA0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Chorasmian */

	/* 10FB0 */ _B, _O, _B, _B, _B, _B, _B, _O, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 10FC0 */ _O, _B, _B, _B, _B, _O, _O, _O, _O, _B, _B, _B, _WJ, _WJ, _WJ, _WJ,
	/* 10FD0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 10FE0 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 10FF0 */ _O, _O, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Brahmi */

	/* 11000 */ _VMPst, _VMAbv, _VMPst, _CS, _CS, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11010 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11020 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11030 */ _B, _B, _B, _B, _B, _B, _B, _B, _VAbv, _VAbv, _VAbv, _VAbv, _VBlw, _VBlw, _VBlw, _VBlw,
	/* 11040 */ _VBlw, _VBlw, _VAbv, _VAbv, _VAbv, _VAbv, _H, _O, _O, _O, _O, _O, _O, _O, _WJ, _WJ,
	/* 11050 */ _WJ, _WJ, _N, _N, _N, _N, _N, _N, _N, _N, _N, _N, _N, _N, _N, _N,
	/* 11060 */ _N, _N, _N, _N, _N, _N, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11070 */ _VAbv, _B, _B, _VAbv, _VAbv, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _HN,

	/* Kaithi */

	/* 11080 */ _VMAbv, _VMAbv, _VMPst, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11090 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 110A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 110B0 */ _VPst, _VPre, _VPst, _VBlw, _VBlw, _VAbv, _VAbv, _VPst, _VPst, _H, _CMBlw, _O, _O, _O, _O, _O,

	/* Chakma */

	/* 11100 */ _VMAbv, _VMAbv, _VMAbv, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11110 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11120 */ _B, _B, _B, _B, _B, _B, _B, _VBlw, _VBlw, _VBlw, _VAbv, _VAbv, _VPre, _VBlw, _VAbv, _VAbv,
	/* 11130 */ _VBlw, _VAbv, _VAbv, _IS, _CMAbv, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11140 */ _O, _O, _O, _O, _B, _VPst, _VPst, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Mahajani */

	/* 11150 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11160 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11170 */ _B, _B, _B, _CMBlw, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Sharada */

	/* 11180 */ _VMAbv, _VMAbv, _VMPst, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11190 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 111A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 111B0 */ _B, _B, _B, _VPst, _VPre, _VPst, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VAbv, _VAbv, _VAbv, _VAbv,
	/* 111C0 */ _H, _B, _R, _R, _O, _O, _O, _O, _O, _FMBlw, _CMBlw, _VAbv, _VBlw, _O, _VPre, _VMAbv,
	/* 111D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _O, _O, _O, _O, _O,
	/* 111E0 */ _WJ, _B, _B, _B, _B, _B, _B, _B,

	/* Sinhala Archaic Numbers */
	_B, _B, _B, _B, _B, _B, _B, _B,
	/* 111F0 */ _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Khojki */

	/* 11200 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11210 */ _B, _B, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11220 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VPst, _VPst, _VPst, _VBlw,
	/* 11230 */ _VAbv, _VAbv, _VAbv, _VAbv, _VMAbv, _H, _CMAbv, _CMAbv, _O, _O, _O, _O, _O, _O, _VMAbv, _B,
	/* 11240 */ _B, _VBlw, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Multani */

	/* 11280 */ _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _WJ, _B, _B, _B, _B, _WJ, _B,
	/* 11290 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B,
	/* 112A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 112B0 */ _B, _B, _B, _B, _B, _B, _B, _B,

	/* Khudawadi */
	_B, _B, _B, _B, _B, _B, _B, _B,
	/* 112C0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 112D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VMAbv,
	/* 112E0 */ _VPst, _VPre, _VPst, _VBlw, _VBlw, _VAbv, _VAbv, _VAbv, _VAbv, _CMBlw, _VBlw, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 112F0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 11300 */ _VMAbv, _VMAbv, _VMAbv, _VMAbv, _WJ, _B, _B, _B,

	/* Grantha */
	_B, _B, _B, _B, _B, _WJ, _WJ, _B,
	/* 11310 */ _B, _WJ, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11320 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _B, _B, _B, _B,
	/* 11330 */ _B, _WJ, _B, _B, _WJ, _B, _B, _B, _B, _B, _WJ, _CMBlw, _CMBlw, _B, _VPst, _VPst,
	/* 11340 */ _VAbv, _VPst, _VPst, _VPst, _VPst, _WJ, _WJ, _VPre, _VPre, _WJ, _WJ, _VPre, _VPre, _H, _WJ, _WJ,
	/* 11350 */ _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _VPst, _WJ, _WJ, _WJ, _WJ, _WJ, _O, _B, _B,
	/* 11360 */ _B, _B, _VPst, _VPst, _WJ, _WJ, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _WJ, _WJ, _WJ,

	/* Newa */

	/* 11400 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11410 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11420 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11430 */ _B, _B, _B, _B, _B, _VPst, _VPre, _VPst, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VAbv, _VAbv,
	/* 11440 */ _VPst, _VPst, _H, _VMAbv, _VMAbv, _VMPst, _CMBlw, _B, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 11450 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _O, _O, _WJ, _O, _FMAbv, _B,
	/* 11460 */ _CS, _CS, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 11470 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Tirhuta */

	/* 11480 */ _O, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11490 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 114A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 114B0 */ _VPst, _VPre, _VPst, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VPre, _VAbv, _VPre, _VPre, _VPst, _VPre, _VMAbv,
	/* 114C0 */ _VMAbv, _VMAbv, _H, _CMBlw, _B, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 114D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Siddham */

	/* 11580 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11590 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 115A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VPst,
	/* 115B0 */ _VPre, _VPst, _VBlw, _VBlw, _VBlw, _VBlw, _WJ, _WJ, _VPre, _VPre, _VPre, _VPre, _VMAbv, _VMAbv, _VMPst, _H,
	/* 115C0 */ _CMBlw, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 115D0 */ _O, _O, _O, _O, _O, _O, _O, _O, _B, _B, _B, _B, _VBlw, _VBlw, _WJ, _WJ,
	/* 115E0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 115F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Modi */

	/* 11600 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11610 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11620 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11630 */ _VPst, _VPst, _VPst, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VAbv, _VAbv, _VPst, _VPst, _VMAbv, _VMPst, _H,
	/* 11640 */ _VAbv, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 11650 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 11660 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ,
	/* 11670 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Takri */

	/* 11680 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11690 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 116A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VMAbv, _VMPst, _VAbv, _VPre, _VPst,
	/* 116B0 */ _VBlw, _VBlw, _VAbv, _VAbv, _VAbv, _VAbv, _H, _CMBlw, _B, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 116C0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 116D0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 116E0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 116F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Ahom */

	/* 11700 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11710 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _MBlw, _MPre, _MAbv,
	/* 11720 */ _VPst, _VPst, _VAbv, _VAbv, _VBlw, _VBlw, _VPre, _VAbv, _VBlw, _VAbv, _VAbv, _VAbv, _WJ, _WJ, _WJ, _WJ,
	/* 11730 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _O, _O, _O, _O,

	/* Dogra */

	/* 11800 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11810 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11820 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VPst, _VPre, _VPst, _VBlw,
	/* 11830 */ _VBlw, _VBlw, _VBlw, _VAbv, _VAbv, _VAbv, _VAbv, _VMAbv, _VMPst, _H, _CMBlw, _O, _WJ, _WJ, _WJ, _WJ,

	/* Dives Akuru */

	/* 11900 */ _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _B, _WJ, _WJ, _B, _B, _B, _B,
	/* 11910 */ _B, _B, _B, _B, _WJ, _B, _B, _WJ, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11920 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11930 */ _VPst, _VPst, _VPst, _VPst, _VPst, _VPre, _WJ, _VPre, _VPre, _WJ, _WJ, _VMAbv, _VMAbv, _VPst, _IS, _R,
	/* 11940 */ _MPst, _R, _MPst, _CMBlw, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 11950 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Nandinagari */

	/* 119A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _B, _B, _B, _B, _B, _B,
	/* 119B0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 119C0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 119D0 */ _B, _VPst, _VPre, _VPst, _VBlw, _VBlw, _VBlw, _VBlw, _WJ, _WJ, _VAbv, _VAbv, _VPst, _VPst, _VMPst, _VMPst,
	/* 119E0 */ _H, _B, _O, _O, _VPre, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 119F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Zanabazar Square */

	/* 11A00 */ _B, _VAbv, _VBlw, _VBlw, _VAbv, _VAbv, _VAbv, _VAbv, _VAbv, _VAbv, _VBlw, _B, _B, _B, _B, _B,
	/* 11A10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11A20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11A30 */ _B, _B, _B, _FMBlw, _VBlw, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMPst, _R, _MBlw, _MBlw, _MBlw, _MBlw, _GB,
	/* 11A40 */ _O, _O, _O, _O, _O, _GB, _O, _IS, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Soyombo */

	/* 11A50 */ _B, _VAbv, _VBlw, _VBlw, _VAbv, _VAbv, _VAbv, _VPst, _VPst, _VBlw, _VBlw, _VBlw, _B, _B, _B, _B,
	/* 11A60 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11A70 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11A80 */ _B, _B, _B, _B, _R, _R, _R, _R, _R, _R, _FBlw, _FBlw, _FBlw, _FBlw, _FBlw, _FBlw,
	/* 11A90 */ _FBlw, _FBlw, _FBlw, _FBlw, _FBlw, _FBlw, _VMAbv, _VMPst, _CMAbv, _IS, _O, _O, _O, _B, _O, _O,

	/* Bhaiksuki */

	/* 11C00 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _B, _B, _B, _B,
	/* 11C10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11C20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VPst,
	/* 11C30 */ _VAbv, _VAbv, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _WJ, _VAbv, _VAbv, _VAbv, _VAbv, _VMAbv, _VMAbv, _VMPst, _H,
	/* 11C40 */ _B, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 11C50 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11C60 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ,
	/* 11C70 */ _O, _O, _B, _B, _B, _B, _B, _B,

	/* Marchen */
	_B, _B, _B, _B, _B, _B, _B, _B,
	/* 11C80 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11C90 */ _WJ, _WJ, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB,
	/* 11CA0 */ _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _WJ, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB, _SUB,
	/* 11CB0 */ _VBlw, _VPre, _VBlw, _VAbv, _VPst, _VMAbv, _VMAbv, _WJ,

	/* Masaram Gondi */

	/* 11D00 */ _B, _B, _B, _B, _B, _B, _B, _WJ, _B, _B, _WJ, _B, _B, _B, _B, _B,
	/* 11D10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11D20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11D30 */ _B, _VAbv, _VAbv, _VAbv, _VAbv, _VAbv, _VBlw, _WJ, _WJ, _WJ, _VAbv, _WJ, _VAbv, _VAbv, _WJ, _VAbv,
	/* 11D40 */ _VMAbv, _VMAbv, _CMBlw, _VAbv, _VBlw, _IS, _R, _MBlw, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 11D50 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 11D60 */ _B, _B, _B, _B, _B, _B, _WJ, _B,

	/* Gunjala Gondi */
	_B, _WJ, _B, _B, _B, _B, _B, _B,
	/* 11D70 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11D80 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VPst, _VPst, _VPst, _VPst, _VPst, _WJ,
	/* 11D90 */ _VAbv, _VAbv, _WJ, _VPst, _VPst, _VMAbv, _VMPst, _IS, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 11DA0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Makasar */

	/* 11EE0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11EF0 */ _B, _B, _GB, _VAbv, _VBlw, _VPre, _VPst, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Kawi */

	/* 11F00 */ _VMAbv, _VMAbv, _R, _VMPst, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11F10 */ _B, _WJ, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11F20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 11F30 */ _B, _B, _B, _B, _VPst, _VPst, _VAbv, _VAbv, _VBlw, _VBlw, _VBlw, _WJ, _WJ, _WJ, _VPre, _VPre,
	/* 11F40 */ _VAbv, _VPst, _IS, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 11F50 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Egyptian Hieroglyphs */

	/* 13000 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13010 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13020 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13030 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13040 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13050 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13060 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13070 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13080 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13090 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 130A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 130B0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 130C0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 130D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 130E0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 130F0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13100 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13110 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13120 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13130 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13140 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13150 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13160 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13170 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13180 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13190 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 131A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 131B0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 131C0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 131D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 131E0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 131F0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13200 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13210 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13220 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13230 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13240 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13250 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13260 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13270 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13280 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13290 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 132A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 132B0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 132C0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 132D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 132E0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 132F0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13300 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13310 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13320 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13330 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13340 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13350 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13360 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13370 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13380 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13390 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 133A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 133B0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 133C0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 133D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 133E0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 133F0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13400 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13410 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13420 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 13430 */ _H, _H, _H, _H, _H, _H, _H, _B,

	/* Egyptian Hieroglyph Format Controls */
	_B, _H, _H, _H, _O, _O, _O, _O,
	/* 13440 */ _VMBlw, _B, _B, _B, _B, _B, _B, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw,
	/* 13450 */ _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _VMBlw, _WJ, _WJ,

	/* Tangsa */

	/* 16AC0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 16AD0 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O,
	/* 16AE0 */ _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _O, _WJ, _WJ,
	/* 16AF0 */ _O, _O, _O, _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Pahawh Hmong */

	/* 16B00 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 16B10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 16B20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 16B30 */ _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _O,

	/* Miao */

	/* 16F00 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 16F10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 16F20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 16F30 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 16F40 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _CMBlw,
	/* 16F50 */ _O, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw,
	/* 16F60 */ _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw,
	/* 16F70 */ _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw,
	/* 16F80 */ _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _VBlw, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _VMBlw,
	/* 16F90 */ _VMBlw, _VMBlw, _VMBlw, _O, _O, _O, _O, _O,

	/* Ideographic Symbols and Punctuation */

	/* 16FE0 */ _O, _O, _O, _O, _B, _WJ, _WJ, _WJ,

	/* Khitan Small Script */

	/* 18B00 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18B10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18B20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18B30 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18B40 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18B50 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18B60 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18B70 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18B80 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18B90 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18BA0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18BB0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18BC0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18BD0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18BE0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18BF0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18C00 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18C10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18C20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18C30 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18C40 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18C50 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18C60 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18C70 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18C80 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18C90 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18CA0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18CB0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18CC0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 18CD0 */ _B, _B, _B, _B, _B, _B, _WJ, _WJ,

	/* Duployan */

	/* 1BC00 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1BC10 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1BC20 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1BC30 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1BC40 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1BC50 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1BC60 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 1BC70 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ,
	/* 1BC80 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* 1BC90 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _O, _CMBlw, _CMBlw, _O,

	/* Musical Symbols */

	/* 1D170 */ _O, _O, _O, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Nyiakeng Puachue Hmong */

	/* 1E100 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1E110 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1E120 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ,
	/* 1E130 */ _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _VMAbv, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ,
	/* 1E140 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _B, _B,

	/* Toto */

	/* 1E290 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1E2A0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VMAbv, _WJ,
	/* 1E2B0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Wancho */

	/* 1E2C0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1E2D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1E2E0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VMAbv, _VMAbv, _VMAbv, _VMAbv,
	/* 1E2F0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _O,

	/* Nag Mundari */

	/* 1E4D0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1E4E0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _VAbv, _VAbv, _VAbv, _VAbv,
	/* 1E4F0 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* Adlam */

	/* 1E900 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1E910 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1E920 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1E930 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _B,
	/* 1E940 */ _B, _B, _B, _B, _CMAbv, _CMAbv, _CMAbv, _CMAbv, _CMAbv, _CMAbv, _CMAbv, _B, _WJ, _WJ, _WJ, _WJ,
	/* 1E950 */ _B, _B, _B, _B, _B, _B, _B, _B, _B, _B, _WJ, _WJ, _WJ, _WJ, _O, _O,

	/* Tags */

	/* E0000 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0010 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0020 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0030 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0040 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0050 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0060 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0070 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0080 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* No_Block */
	_WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0090 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E00A0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E00B0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E00C0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E00D0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E00E0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E00F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0100 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,

	/* Variation Selectors Supplement */
	_CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E0110 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E0120 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E0130 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E0140 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E0150 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E0160 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E0170 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E0180 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E0190 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E01A0 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E01B0 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E01C0 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E01D0 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E01E0 */ _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ, _CGJ,
	/* E01F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,

	/* No_Block */
	_WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0200 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0210 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0220 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0230 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0240 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0250 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0260 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0270 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0280 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0290 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E02A0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E02B0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E02C0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E02D0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E02E0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E02F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0300 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0310 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0320 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0330 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0340 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0350 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0360 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0370 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0380 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0390 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E03A0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E03B0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E03C0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E03D0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E03E0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E03F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0400 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0410 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0420 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0430 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0440 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0450 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0460 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0470 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0480 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0490 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E04A0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E04B0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E04C0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E04D0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E04E0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E04F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0500 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0510 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0520 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0530 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0540 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0550 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0560 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0570 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0580 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0590 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E05A0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E05B0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E05C0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E05D0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E05E0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E05F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0600 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0610 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0620 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0630 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0640 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0650 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0660 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0670 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0680 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0690 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E06A0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E06B0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E06C0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E06D0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E06E0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E06F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0700 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0710 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0720 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0730 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0740 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0750 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0760 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0770 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0780 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0790 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E07A0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E07B0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E07C0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E07D0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E07E0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E07F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0800 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0810 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0820 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0830 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0840 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0850 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0860 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0870 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0880 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0890 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E08A0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E08B0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E08C0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E08D0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E08E0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E08F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0900 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0910 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0920 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0930 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0940 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0950 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0960 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0970 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0980 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0990 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E09A0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E09B0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E09C0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E09D0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E09E0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E09F0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0A00 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0A10 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0A20 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0A30 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0A40 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0A50 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0A60 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0A70 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0A80 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0A90 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0AA0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0AB0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0AC0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0AD0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0AE0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0AF0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0B00 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0B10 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0B20 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0B30 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0B40 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0B50 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0B60 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0B70 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0B80 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0B90 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0BA0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0BB0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0BC0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0BD0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0BE0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0BF0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0C00 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0C10 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0C20 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0C30 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0C40 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0C50 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0C60 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0C70 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0C80 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0C90 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0CA0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0CB0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0CC0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0CD0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0CE0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0CF0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0D00 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0D10 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0D20 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0D30 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0D40 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0D50 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0D60 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0D70 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0D80 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0D90 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0DA0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0DB0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0DC0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0DD0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0DE0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0DF0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0E00 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0E10 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0E20 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0E30 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0E40 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0E50 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0E60 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0E70 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0E80 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0E90 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0EA0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0EB0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0EC0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0ED0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0EE0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0EF0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0F00 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0F10 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0F20 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0F30 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0F40 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0F50 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0F60 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0F70 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0F80 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0F90 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0FA0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0FB0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0FC0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0FD0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0FE0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
	/* E0FF0 */ _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ, _WJ,
} /* Table items: 13480; occupancy: 84% */

const (
	offsetUSE0x0028u  = 0
	offsetUSE0x00a0u  = 24
	offsetUSE0x0348u  = 80
	offsetUSE0x0640u  = 88
	offsetUSE0x07c8u  = 96
	offsetUSE0x0840u  = 144
	offsetUSE0x0900u  = 176
	offsetUSE0x0f00u  = 1448
	offsetUSE0x1000u  = 1640
	offsetUSE0x1700u  = 1800
	offsetUSE0x1900u  = 2232
	offsetUSE0x1b00u  = 2648
	offsetUSE0x1cd0u  = 2984
	offsetUSE0x1df8u  = 3032
	offsetUSE0x2008u  = 3040
	offsetUSE0x20f0u  = 3168
	offsetUSE0x25c8u  = 3176
	offsetUSE0x2d30u  = 3184
	offsetUSE0xa800u  = 3264
	offsetUSE0xabc0u  = 4016
	offsetUSE0xfe00u  = 4080
	offsetUSE0xfef8u  = 4096
	offsetUSE0xfff0u  = 4104
	offsetUSE0x10570u = 4120
	offsetUSE0x10a00u = 4192
	offsetUSE0x10ac0u = 4272
	offsetUSE0x10b80u = 4312
	offsetUSE0x10d00u = 4360
	offsetUSE0x10e80u = 4424
	offsetUSE0x10f30u = 4472
	offsetUSE0x11100u = 4872
	offsetUSE0x11280u = 5200
	offsetUSE0x11400u = 5440
	offsetUSE0x11580u = 5664
	offsetUSE0x11800u = 6112
	offsetUSE0x11900u = 6176
	offsetUSE0x119a0u = 6272
	offsetUSE0x11c00u = 6528
	offsetUSE0x11d00u = 6712
	offsetUSE0x11ee0u = 6888
	offsetUSE0x13000u = 7016
	offsetUSE0x16ac0u = 8128
	offsetUSE0x16f00u = 8248
	offsetUSE0x16fe0u = 8400
	offsetUSE0x18b00u = 8408
	offsetUSE0x1bc00u = 8880
	offsetUSE0x1d170u = 9040
	offsetUSE0x1e100u = 9048
	offsetUSE0x1e290u = 9128
	offsetUSE0x1e4d0u = 9240
	offsetUSE0x1e900u = 9288
	offsetUSE0xe0000u = 9384
)

func getUSECategory(u rune) uint8 {
	switch u >> 12 {
	case 0x0:
		if 0x0028 <= u && u <= 0x003F {
			return useTable[u-0x0028+offsetUSE0x0028u]
		}
		if 0x00A0 <= u && u <= 0x00D7 {
			return useTable[u-0x00A0+offsetUSE0x00a0u]
		}
		if 0x0348 <= u && u <= 0x034F {
			return useTable[u-0x0348+offsetUSE0x0348u]
		}
		if 0x0640 <= u && u <= 0x0647 {
			return useTable[u-0x0640+offsetUSE0x0640u]
		}
		if 0x07C8 <= u && u <= 0x07F7 {
			return useTable[u-0x07C8+offsetUSE0x07c8u]
		}
		if 0x0840 <= u && u <= 0x085F {
			return useTable[u-0x0840+offsetUSE0x0840u]
		}
		if 0x0900 <= u && u <= 0x0DF7 {
			return useTable[u-0x0900+offsetUSE0x0900u]
		}
		if 0x0F00 <= u && u <= 0x0FBF {
			return useTable[u-0x0F00+offsetUSE0x0f00u]
		}

	case 0x1:
		if 0x1000 <= u && u <= 0x109F {
			return useTable[u-0x1000+offsetUSE0x1000u]
		}
		if 0x1700 <= u && u <= 0x18AF {
			return useTable[u-0x1700+offsetUSE0x1700u]
		}
		if 0x1900 <= u && u <= 0x1A9F {
			return useTable[u-0x1900+offsetUSE0x1900u]
		}
		if 0x1B00 <= u && u <= 0x1C4F {
			return useTable[u-0x1B00+offsetUSE0x1b00u]
		}
		if 0x1CD0 <= u && u <= 0x1CFF {
			return useTable[u-0x1CD0+offsetUSE0x1cd0u]
		}
		if 0x1DF8 <= u && u <= 0x1DFF {
			return useTable[u-0x1DF8+offsetUSE0x1df8u]
		}

	case 0x2:
		if 0x2008 <= u && u <= 0x2087 {
			return useTable[u-0x2008+offsetUSE0x2008u]
		}
		if 0x20F0 <= u && u <= 0x20F7 {
			return useTable[u-0x20F0+offsetUSE0x20f0u]
		}
		if 0x25C8 <= u && u <= 0x25CF {
			return useTable[u-0x25C8+offsetUSE0x25c8u]
		}
		if 0x2D30 <= u && u <= 0x2D7F {
			return useTable[u-0x2D30+offsetUSE0x2d30u]
		}

	case 0xA:
		if 0xA800 <= u && u <= 0xAAEF {
			return useTable[u-0xA800+offsetUSE0xa800u]
		}
		if 0xABC0 <= u && u <= 0xABFF {
			return useTable[u-0xABC0+offsetUSE0xabc0u]
		}

	case 0xF:
		if 0xFE00 <= u && u <= 0xFE0F {
			return useTable[u-0xFE00+offsetUSE0xfe00u]
		}
		if 0xFEF8 <= u && u <= 0xFEFF {
			return useTable[u-0xFEF8+offsetUSE0xfef8u]
		}
		if 0xFFF0 <= u && u <= 0xFFFF {
			return useTable[u-0xFFF0+offsetUSE0xfff0u]
		}

	case 0x10:
		if 0xFFF0 <= u && u <= 0xFFFF {
			return useTable[u-0xFFF0+offsetUSE0xfff0u]
		}
		if 0x10570 <= u && u <= 0x105B7 {
			return useTable[u-0x10570+offsetUSE0x10570u]
		}
		if 0x10A00 <= u && u <= 0x10A4F {
			return useTable[u-0x10A00+offsetUSE0x10a00u]
		}
		if 0x10AC0 <= u && u <= 0x10AE7 {
			return useTable[u-0x10AC0+offsetUSE0x10ac0u]
		}
		if 0x10B80 <= u && u <= 0x10BAF {
			return useTable[u-0x10B80+offsetUSE0x10b80u]
		}
		if 0x10D00 <= u && u <= 0x10D3F {
			return useTable[u-0x10D00+offsetUSE0x10d00u]
		}
		if 0x10E80 <= u && u <= 0x10EAF {
			return useTable[u-0x10E80+offsetUSE0x10e80u]
		}
		if 0x10F30 <= u && u <= 0x110BF {
			return useTable[u-0x10F30+offsetUSE0x10f30u]
		}

	case 0x11:
		if 0x10F30 <= u && u <= 0x110BF {
			return useTable[u-0x10F30+offsetUSE0x10f30u]
		}
		if 0x11100 <= u && u <= 0x11247 {
			return useTable[u-0x11100+offsetUSE0x11100u]
		}
		if 0x11280 <= u && u <= 0x1136F {
			return useTable[u-0x11280+offsetUSE0x11280u]
		}
		if 0x11400 <= u && u <= 0x114DF {
			return useTable[u-0x11400+offsetUSE0x11400u]
		}
		if 0x11580 <= u && u <= 0x1173F {
			return useTable[u-0x11580+offsetUSE0x11580u]
		}
		if 0x11800 <= u && u <= 0x1183F {
			return useTable[u-0x11800+offsetUSE0x11800u]
		}
		if 0x11900 <= u && u <= 0x1195F {
			return useTable[u-0x11900+offsetUSE0x11900u]
		}
		if 0x119A0 <= u && u <= 0x11A9F {
			return useTable[u-0x119A0+offsetUSE0x119a0u]
		}
		if 0x11C00 <= u && u <= 0x11CB7 {
			return useTable[u-0x11C00+offsetUSE0x11c00u]
		}
		if 0x11D00 <= u && u <= 0x11DAF {
			return useTable[u-0x11D00+offsetUSE0x11d00u]
		}
		if 0x11EE0 <= u && u <= 0x11F5F {
			return useTable[u-0x11EE0+offsetUSE0x11ee0u]
		}

	case 0x13:
		if 0x13000 <= u && u <= 0x13457 {
			return useTable[u-0x13000+offsetUSE0x13000u]
		}

	case 0x16:
		if 0x16AC0 <= u && u <= 0x16B37 {
			return useTable[u-0x16AC0+offsetUSE0x16ac0u]
		}
		if 0x16F00 <= u && u <= 0x16F97 {
			return useTable[u-0x16F00+offsetUSE0x16f00u]
		}
		if 0x16FE0 <= u && u <= 0x16FE7 {
			return useTable[u-0x16FE0+offsetUSE0x16fe0u]
		}

	case 0x18:
		if 0x18B00 <= u && u <= 0x18CD7 {
			return useTable[u-0x18B00+offsetUSE0x18b00u]
		}

	case 0x1B:
		if 0x1BC00 <= u && u <= 0x1BC9F {
			return useTable[u-0x1BC00+offsetUSE0x1bc00u]
		}

	case 0x1D:
		if 0x1D170 <= u && u <= 0x1D177 {
			return useTable[u-0x1D170+offsetUSE0x1d170u]
		}

	case 0x1E:
		if 0x1E100 <= u && u <= 0x1E14F {
			return useTable[u-0x1E100+offsetUSE0x1e100u]
		}
		if 0x1E290 <= u && u <= 0x1E2FF {
			return useTable[u-0x1E290+offsetUSE0x1e290u]
		}
		if 0x1E4D0 <= u && u <= 0x1E4FF {
			return useTable[u-0x1E4D0+offsetUSE0x1e4d0u]
		}
		if 0x1E900 <= u && u <= 0x1E95F {
			return useTable[u-0x1E900+offsetUSE0x1e900u]
		}

	case 0xE0:
		if 0xE0000 <= u && u <= 0xE0FFF {
			return useTable[u-0xE0000+offsetUSE0xe0000u]
		}

	case 0xE1:
		if 0xE0000 <= u && u <= 0xE0FFF {
			return useTable[u-0xE0000+offsetUSE0xe0000u]
		}

	}
	return useSM_ex_O
}
