// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/texttospeech/v1/cloud_tts.proto

package texttospeechpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Gender of the voice as described in
// [SSML voice element](https://www.w3.org/TR/speech-synthesis11/#edef_voice).
type SsmlVoiceGender int32

const (
	// An unspecified gender.
	// In VoiceSelectionParams, this means that the client doesn't care which
	// gender the selected voice will have. In the Voice field of
	// ListVoicesResponse, this may mean that the voice doesn't fit any of the
	// other categories in this enum, or that the gender of the voice isn't known.
	SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED SsmlVoiceGender = 0
	// A male voice.
	SsmlVoiceGender_MALE SsmlVoiceGender = 1
	// A female voice.
	SsmlVoiceGender_FEMALE SsmlVoiceGender = 2
	// A gender-neutral voice. This voice is not yet supported.
	SsmlVoiceGender_NEUTRAL SsmlVoiceGender = 3
)

// Enum value maps for SsmlVoiceGender.
var (
	SsmlVoiceGender_name = map[int32]string{
		0: "SSML_VOICE_GENDER_UNSPECIFIED",
		1: "MALE",
		2: "FEMALE",
		3: "NEUTRAL",
	}
	SsmlVoiceGender_value = map[string]int32{
		"SSML_VOICE_GENDER_UNSPECIFIED": 0,
		"MALE":                          1,
		"FEMALE":                        2,
		"NEUTRAL":                       3,
	}
)

func (x SsmlVoiceGender) Enum() *SsmlVoiceGender {
	p := new(SsmlVoiceGender)
	*p = x
	return p
}

func (x SsmlVoiceGender) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SsmlVoiceGender) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_enumTypes[0].Descriptor()
}

func (SsmlVoiceGender) Type() protoreflect.EnumType {
	return &file_google_cloud_texttospeech_v1_cloud_tts_proto_enumTypes[0]
}

func (x SsmlVoiceGender) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SsmlVoiceGender.Descriptor instead.
func (SsmlVoiceGender) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{0}
}

// Configuration to set up audio encoder. The encoding determines the output
// audio format that we'd like.
type AudioEncoding int32

const (
	// Not specified. Will return result
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
	AudioEncoding_AUDIO_ENCODING_UNSPECIFIED AudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	// Audio content returned as LINEAR16 also contains a WAV header.
	AudioEncoding_LINEAR16 AudioEncoding = 1
	// MP3 audio at 32kbps.
	AudioEncoding_MP3 AudioEncoding = 2
	// Opus encoded audio wrapped in an ogg container. The result is a
	// file which can be played natively on Android, and in browsers (at least
	// Chrome and Firefox). The quality of the encoding is considerably higher
	// than MP3 while using approximately the same bitrate.
	AudioEncoding_OGG_OPUS AudioEncoding = 3
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	// Audio content returned as MULAW also contains a WAV header.
	AudioEncoding_MULAW AudioEncoding = 5
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/A-law.
	// Audio content returned as ALAW also contains a WAV header.
	AudioEncoding_ALAW AudioEncoding = 6
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	// Note that as opposed to LINEAR16, audio won't be wrapped in a WAV (or
	// any other) header.
	AudioEncoding_PCM AudioEncoding = 7
)

// Enum value maps for AudioEncoding.
var (
	AudioEncoding_name = map[int32]string{
		0: "AUDIO_ENCODING_UNSPECIFIED",
		1: "LINEAR16",
		2: "MP3",
		3: "OGG_OPUS",
		5: "MULAW",
		6: "ALAW",
		7: "PCM",
	}
	AudioEncoding_value = map[string]int32{
		"AUDIO_ENCODING_UNSPECIFIED": 0,
		"LINEAR16":                   1,
		"MP3":                        2,
		"OGG_OPUS":                   3,
		"MULAW":                      5,
		"ALAW":                       6,
		"PCM":                        7,
	}
)

func (x AudioEncoding) Enum() *AudioEncoding {
	p := new(AudioEncoding)
	*p = x
	return p
}

func (x AudioEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudioEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_enumTypes[1].Descriptor()
}

func (AudioEncoding) Type() protoreflect.EnumType {
	return &file_google_cloud_texttospeech_v1_cloud_tts_proto_enumTypes[1]
}

func (x AudioEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudioEncoding.Descriptor instead.
func (AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{1}
}

// The phonetic encoding of the phrase.
type CustomPronunciationParams_PhoneticEncoding int32

const (
	// Not specified.
	CustomPronunciationParams_PHONETIC_ENCODING_UNSPECIFIED CustomPronunciationParams_PhoneticEncoding = 0
	// IPA, such as apple -> ˈæpəl.
	// https://en.wikipedia.org/wiki/International_Phonetic_Alphabet
	CustomPronunciationParams_PHONETIC_ENCODING_IPA CustomPronunciationParams_PhoneticEncoding = 1
	// X-SAMPA, such as apple -> "{p@l".
	// https://en.wikipedia.org/wiki/X-SAMPA
	CustomPronunciationParams_PHONETIC_ENCODING_X_SAMPA CustomPronunciationParams_PhoneticEncoding = 2
	// For reading-to-pron conversion to work well, the `pronunciation` field
	//
	//	should only contain Kanji, Hiragana, and Katakana.
	//
	// The pronunciation can also contain pitch accents.
	// The start of a pitch phrase is specified with `^` and the down-pitch
	// position is specified with `!`, for example:
	//
	//	phrase:端  pronunciation:^はし
	//	phrase:箸  pronunciation:^は!し
	//	phrase:橋  pronunciation:^はし!
	//
	// We currently only support the Tokyo dialect, which allows at most one
	// down-pitch per phrase (i.e. at most one `!` between `^`).
	CustomPronunciationParams_PHONETIC_ENCODING_JAPANESE_YOMIGANA CustomPronunciationParams_PhoneticEncoding = 3
	// Used to specify pronunciations for Mandarin words. See
	// https://en.wikipedia.org/wiki/Pinyin.
	//
	// For example: 朝阳, the pronunciation is "chao2 yang2". The number
	// represents the tone, and there is a space between syllables. Neutral
	// tones are represented by 5, for example 孩子 "hai2 zi5".
	CustomPronunciationParams_PHONETIC_ENCODING_PINYIN CustomPronunciationParams_PhoneticEncoding = 4
)

// Enum value maps for CustomPronunciationParams_PhoneticEncoding.
var (
	CustomPronunciationParams_PhoneticEncoding_name = map[int32]string{
		0: "PHONETIC_ENCODING_UNSPECIFIED",
		1: "PHONETIC_ENCODING_IPA",
		2: "PHONETIC_ENCODING_X_SAMPA",
		3: "PHONETIC_ENCODING_JAPANESE_YOMIGANA",
		4: "PHONETIC_ENCODING_PINYIN",
	}
	CustomPronunciationParams_PhoneticEncoding_value = map[string]int32{
		"PHONETIC_ENCODING_UNSPECIFIED":       0,
		"PHONETIC_ENCODING_IPA":               1,
		"PHONETIC_ENCODING_X_SAMPA":           2,
		"PHONETIC_ENCODING_JAPANESE_YOMIGANA": 3,
		"PHONETIC_ENCODING_PINYIN":            4,
	}
)

func (x CustomPronunciationParams_PhoneticEncoding) Enum() *CustomPronunciationParams_PhoneticEncoding {
	p := new(CustomPronunciationParams_PhoneticEncoding)
	*p = x
	return p
}

func (x CustomPronunciationParams_PhoneticEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomPronunciationParams_PhoneticEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_enumTypes[2].Descriptor()
}

func (CustomPronunciationParams_PhoneticEncoding) Type() protoreflect.EnumType {
	return &file_google_cloud_texttospeech_v1_cloud_tts_proto_enumTypes[2]
}

func (x CustomPronunciationParams_PhoneticEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomPronunciationParams_PhoneticEncoding.Descriptor instead.
func (CustomPronunciationParams_PhoneticEncoding) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{5, 0}
}

// Deprecated. The usage of the synthesized audio. Usage does not affect
// billing.
type CustomVoiceParams_ReportedUsage int32

const (
	// Request with reported usage unspecified will be rejected.
	CustomVoiceParams_REPORTED_USAGE_UNSPECIFIED CustomVoiceParams_ReportedUsage = 0
	// For scenarios where the synthesized audio is not downloadable and can
	// only be used once. For example, real-time request in IVR system.
	CustomVoiceParams_REALTIME CustomVoiceParams_ReportedUsage = 1
	// For scenarios where the synthesized audio is downloadable and can be
	// reused. For example, the synthesized audio is downloaded, stored in
	// customer service system and played repeatedly.
	CustomVoiceParams_OFFLINE CustomVoiceParams_ReportedUsage = 2
)

// Enum value maps for CustomVoiceParams_ReportedUsage.
var (
	CustomVoiceParams_ReportedUsage_name = map[int32]string{
		0: "REPORTED_USAGE_UNSPECIFIED",
		1: "REALTIME",
		2: "OFFLINE",
	}
	CustomVoiceParams_ReportedUsage_value = map[string]int32{
		"REPORTED_USAGE_UNSPECIFIED": 0,
		"REALTIME":                   1,
		"OFFLINE":                    2,
	}
)

func (x CustomVoiceParams_ReportedUsage) Enum() *CustomVoiceParams_ReportedUsage {
	p := new(CustomVoiceParams_ReportedUsage)
	*p = x
	return p
}

func (x CustomVoiceParams_ReportedUsage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomVoiceParams_ReportedUsage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_enumTypes[3].Descriptor()
}

func (CustomVoiceParams_ReportedUsage) Type() protoreflect.EnumType {
	return &file_google_cloud_texttospeech_v1_cloud_tts_proto_enumTypes[3]
}

func (x CustomVoiceParams_ReportedUsage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomVoiceParams_ReportedUsage.Descriptor instead.
func (CustomVoiceParams_ReportedUsage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{11, 0}
}

// The top-level message sent by the client for the `ListVoices` method.
type ListVoicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Recommended.
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// If not specified, the API will return all supported voices.
	// If specified, the ListVoices call will only return voices that can be used
	// to synthesize this language_code. For example, if you specify `"en-NZ"`,
	// all `"en-NZ"` voices will be returned. If you specify `"no"`, both
	// `"no-\*"` (Norwegian) and `"nb-\*"` (Norwegian Bokmal) voices will be
	// returned.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListVoicesRequest) Reset() {
	*x = ListVoicesRequest{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVoicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVoicesRequest) ProtoMessage() {}

func (x *ListVoicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVoicesRequest.ProtoReflect.Descriptor instead.
func (*ListVoicesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{0}
}

func (x *ListVoicesRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The message returned to the client by the `ListVoices` method.
type ListVoicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of voices.
	Voices []*Voice `protobuf:"bytes,1,rep,name=voices,proto3" json:"voices,omitempty"`
}

func (x *ListVoicesResponse) Reset() {
	*x = ListVoicesResponse{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVoicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVoicesResponse) ProtoMessage() {}

func (x *ListVoicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVoicesResponse.ProtoReflect.Descriptor instead.
func (*ListVoicesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{1}
}

func (x *ListVoicesResponse) GetVoices() []*Voice {
	if x != nil {
		return x.Voices
	}
	return nil
}

// Description of a voice supported by the TTS service.
type Voice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The languages that this voice supports, expressed as
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tags (e.g.
	// "en-US", "es-419", "cmn-tw").
	LanguageCodes []string `protobuf:"bytes,1,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
	// The name of this voice.  Each distinct voice has a unique name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The gender of this voice.
	SsmlGender SsmlVoiceGender `protobuf:"varint,3,opt,name=ssml_gender,json=ssmlGender,proto3,enum=google.cloud.texttospeech.v1.SsmlVoiceGender" json:"ssml_gender,omitempty"`
	// The natural sample rate (in hertz) for this voice.
	NaturalSampleRateHertz int32 `protobuf:"varint,4,opt,name=natural_sample_rate_hertz,json=naturalSampleRateHertz,proto3" json:"natural_sample_rate_hertz,omitempty"`
}

func (x *Voice) Reset() {
	*x = Voice{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Voice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Voice) ProtoMessage() {}

func (x *Voice) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Voice.ProtoReflect.Descriptor instead.
func (*Voice) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{2}
}

func (x *Voice) GetLanguageCodes() []string {
	if x != nil {
		return x.LanguageCodes
	}
	return nil
}

func (x *Voice) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Voice) GetSsmlGender() SsmlVoiceGender {
	if x != nil {
		return x.SsmlGender
	}
	return SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED
}

func (x *Voice) GetNaturalSampleRateHertz() int32 {
	if x != nil {
		return x.NaturalSampleRateHertz
	}
	return 0
}

// Used for advanced voice options.
type AdvancedVoiceOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only for Journey voices. If false, the synthesis is context aware
	// and has a higher latency.
	LowLatencyJourneySynthesis *bool `protobuf:"varint,1,opt,name=low_latency_journey_synthesis,json=lowLatencyJourneySynthesis,proto3,oneof" json:"low_latency_journey_synthesis,omitempty"`
}

func (x *AdvancedVoiceOptions) Reset() {
	*x = AdvancedVoiceOptions{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedVoiceOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedVoiceOptions) ProtoMessage() {}

func (x *AdvancedVoiceOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedVoiceOptions.ProtoReflect.Descriptor instead.
func (*AdvancedVoiceOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{3}
}

func (x *AdvancedVoiceOptions) GetLowLatencyJourneySynthesis() bool {
	if x != nil && x.LowLatencyJourneySynthesis != nil {
		return *x.LowLatencyJourneySynthesis
	}
	return false
}

// The top-level message sent by the client for the `SynthesizeSpeech` method.
type SynthesizeSpeechRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Synthesizer requires either plain text or SSML as input.
	Input *SynthesisInput `protobuf:"bytes,1,opt,name=input,proto3" json:"input,omitempty"`
	// Required. The desired voice of the synthesized audio.
	Voice *VoiceSelectionParams `protobuf:"bytes,2,opt,name=voice,proto3" json:"voice,omitempty"`
	// Required. The configuration of the synthesized audio.
	AudioConfig *AudioConfig `protobuf:"bytes,3,opt,name=audio_config,json=audioConfig,proto3" json:"audio_config,omitempty"`
	// Advanced voice options.
	AdvancedVoiceOptions *AdvancedVoiceOptions `protobuf:"bytes,8,opt,name=advanced_voice_options,json=advancedVoiceOptions,proto3,oneof" json:"advanced_voice_options,omitempty"`
}

func (x *SynthesizeSpeechRequest) Reset() {
	*x = SynthesizeSpeechRequest{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SynthesizeSpeechRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SynthesizeSpeechRequest) ProtoMessage() {}

func (x *SynthesizeSpeechRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SynthesizeSpeechRequest.ProtoReflect.Descriptor instead.
func (*SynthesizeSpeechRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{4}
}

func (x *SynthesizeSpeechRequest) GetInput() *SynthesisInput {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *SynthesizeSpeechRequest) GetVoice() *VoiceSelectionParams {
	if x != nil {
		return x.Voice
	}
	return nil
}

func (x *SynthesizeSpeechRequest) GetAudioConfig() *AudioConfig {
	if x != nil {
		return x.AudioConfig
	}
	return nil
}

func (x *SynthesizeSpeechRequest) GetAdvancedVoiceOptions() *AdvancedVoiceOptions {
	if x != nil {
		return x.AdvancedVoiceOptions
	}
	return nil
}

// Pronunciation customization for a phrase.
type CustomPronunciationParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The phrase to which the customization is applied.
	// The phrase can be multiple words, such as proper nouns, but shouldn't span
	// the length of the sentence.
	Phrase *string `protobuf:"bytes,1,opt,name=phrase,proto3,oneof" json:"phrase,omitempty"`
	// The phonetic encoding of the phrase.
	PhoneticEncoding *CustomPronunciationParams_PhoneticEncoding `protobuf:"varint,2,opt,name=phonetic_encoding,json=phoneticEncoding,proto3,enum=google.cloud.texttospeech.v1.CustomPronunciationParams_PhoneticEncoding,oneof" json:"phonetic_encoding,omitempty"`
	// The pronunciation of the phrase. This must be in the phonetic encoding
	// specified above.
	Pronunciation *string `protobuf:"bytes,3,opt,name=pronunciation,proto3,oneof" json:"pronunciation,omitempty"`
}

func (x *CustomPronunciationParams) Reset() {
	*x = CustomPronunciationParams{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomPronunciationParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomPronunciationParams) ProtoMessage() {}

func (x *CustomPronunciationParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomPronunciationParams.ProtoReflect.Descriptor instead.
func (*CustomPronunciationParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{5}
}

func (x *CustomPronunciationParams) GetPhrase() string {
	if x != nil && x.Phrase != nil {
		return *x.Phrase
	}
	return ""
}

func (x *CustomPronunciationParams) GetPhoneticEncoding() CustomPronunciationParams_PhoneticEncoding {
	if x != nil && x.PhoneticEncoding != nil {
		return *x.PhoneticEncoding
	}
	return CustomPronunciationParams_PHONETIC_ENCODING_UNSPECIFIED
}

func (x *CustomPronunciationParams) GetPronunciation() string {
	if x != nil && x.Pronunciation != nil {
		return *x.Pronunciation
	}
	return ""
}

// A collection of pronunciation customizations.
type CustomPronunciations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The pronunciation customizations are applied.
	Pronunciations []*CustomPronunciationParams `protobuf:"bytes,1,rep,name=pronunciations,proto3" json:"pronunciations,omitempty"`
}

func (x *CustomPronunciations) Reset() {
	*x = CustomPronunciations{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomPronunciations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomPronunciations) ProtoMessage() {}

func (x *CustomPronunciations) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomPronunciations.ProtoReflect.Descriptor instead.
func (*CustomPronunciations) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{6}
}

func (x *CustomPronunciations) GetPronunciations() []*CustomPronunciationParams {
	if x != nil {
		return x.Pronunciations
	}
	return nil
}

// A collection of turns for multi-speaker synthesis.
type MultiSpeakerMarkup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Speaker turns.
	Turns []*MultiSpeakerMarkup_Turn `protobuf:"bytes,1,rep,name=turns,proto3" json:"turns,omitempty"`
}

func (x *MultiSpeakerMarkup) Reset() {
	*x = MultiSpeakerMarkup{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MultiSpeakerMarkup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiSpeakerMarkup) ProtoMessage() {}

func (x *MultiSpeakerMarkup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiSpeakerMarkup.ProtoReflect.Descriptor instead.
func (*MultiSpeakerMarkup) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{7}
}

func (x *MultiSpeakerMarkup) GetTurns() []*MultiSpeakerMarkup_Turn {
	if x != nil {
		return x.Turns
	}
	return nil
}

// Contains text input to be synthesized. Either `text` or `ssml` must be
// supplied. Supplying both or neither returns
// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. The
// input size is limited to 5000 bytes.
type SynthesisInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The input source, which is either plain text or SSML.
	//
	// Types that are assignable to InputSource:
	//
	//	*SynthesisInput_Text
	//	*SynthesisInput_Markup
	//	*SynthesisInput_Ssml
	//	*SynthesisInput_MultiSpeakerMarkup
	InputSource isSynthesisInput_InputSource `protobuf_oneof:"input_source"`
	// Optional. The pronunciation customizations are applied to the input. If
	// this is set, the input is synthesized using the given pronunciation
	// customizations.
	//
	// The initial support is for en-us, with plans to expand to other locales in
	// the future. Instant Clone voices aren't supported.
	//
	// In order to customize the pronunciation of a phrase, there must be an exact
	// match of the phrase in the input types. If using SSML, the phrase must not
	// be inside a phoneme tag.
	CustomPronunciations *CustomPronunciations `protobuf:"bytes,3,opt,name=custom_pronunciations,json=customPronunciations,proto3" json:"custom_pronunciations,omitempty"`
}

func (x *SynthesisInput) Reset() {
	*x = SynthesisInput{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SynthesisInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SynthesisInput) ProtoMessage() {}

func (x *SynthesisInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SynthesisInput.ProtoReflect.Descriptor instead.
func (*SynthesisInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{8}
}

func (m *SynthesisInput) GetInputSource() isSynthesisInput_InputSource {
	if m != nil {
		return m.InputSource
	}
	return nil
}

func (x *SynthesisInput) GetText() string {
	if x, ok := x.GetInputSource().(*SynthesisInput_Text); ok {
		return x.Text
	}
	return ""
}

func (x *SynthesisInput) GetMarkup() string {
	if x, ok := x.GetInputSource().(*SynthesisInput_Markup); ok {
		return x.Markup
	}
	return ""
}

func (x *SynthesisInput) GetSsml() string {
	if x, ok := x.GetInputSource().(*SynthesisInput_Ssml); ok {
		return x.Ssml
	}
	return ""
}

func (x *SynthesisInput) GetMultiSpeakerMarkup() *MultiSpeakerMarkup {
	if x, ok := x.GetInputSource().(*SynthesisInput_MultiSpeakerMarkup); ok {
		return x.MultiSpeakerMarkup
	}
	return nil
}

func (x *SynthesisInput) GetCustomPronunciations() *CustomPronunciations {
	if x != nil {
		return x.CustomPronunciations
	}
	return nil
}

type isSynthesisInput_InputSource interface {
	isSynthesisInput_InputSource()
}

type SynthesisInput_Text struct {
	// The raw text to be synthesized.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type SynthesisInput_Markup struct {
	// Markup for HD voices specifically. This field may not be used with any
	// other voices.
	Markup string `protobuf:"bytes,5,opt,name=markup,proto3,oneof"`
}

type SynthesisInput_Ssml struct {
	// The SSML document to be synthesized. The SSML document must be valid
	// and well-formed. Otherwise the RPC will fail and return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. For
	// more information, see
	// [SSML](https://cloud.google.com/text-to-speech/docs/ssml).
	Ssml string `protobuf:"bytes,2,opt,name=ssml,proto3,oneof"`
}

type SynthesisInput_MultiSpeakerMarkup struct {
	// The multi-speaker input to be synthesized. Only applicable for
	// multi-speaker synthesis.
	MultiSpeakerMarkup *MultiSpeakerMarkup `protobuf:"bytes,4,opt,name=multi_speaker_markup,json=multiSpeakerMarkup,proto3,oneof"`
}

func (*SynthesisInput_Text) isSynthesisInput_InputSource() {}

func (*SynthesisInput_Markup) isSynthesisInput_InputSource() {}

func (*SynthesisInput_Ssml) isSynthesisInput_InputSource() {}

func (*SynthesisInput_MultiSpeakerMarkup) isSynthesisInput_InputSource() {}

// Description of which voice to use for a synthesis request.
type VoiceSelectionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The language (and potentially also the region) of the voice
	// expressed as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
	// language tag, e.g. "en-US". This should not include a script tag (e.g. use
	// "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
	// from the input provided in the SynthesisInput.  The TTS service
	// will use this parameter to help choose an appropriate voice.  Note that
	// the TTS service may choose a voice with a slightly different language code
	// than the one selected; it may substitute a different region
	// (e.g. using en-US rather than en-CA if there isn't a Canadian voice
	// available), or even a different language, e.g. using "nb" (Norwegian
	// Bokmal) instead of "no" (Norwegian)".
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The name of the voice. If both the name and the gender are not set,
	// the service will choose a voice based on the other parameters such as
	// language_code.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The preferred gender of the voice. If not set, the service will
	// choose a voice based on the other parameters such as language_code and
	// name. Note that this is only a preference, not requirement; if a
	// voice of the appropriate gender is not available, the synthesizer should
	// substitute a voice with a different gender rather than failing the request.
	SsmlGender SsmlVoiceGender `protobuf:"varint,3,opt,name=ssml_gender,json=ssmlGender,proto3,enum=google.cloud.texttospeech.v1.SsmlVoiceGender" json:"ssml_gender,omitempty"`
	// The configuration for a custom voice. If [CustomVoiceParams.model] is set,
	// the service will choose the custom voice matching the specified
	// configuration.
	CustomVoice *CustomVoiceParams `protobuf:"bytes,4,opt,name=custom_voice,json=customVoice,proto3" json:"custom_voice,omitempty"`
	// Optional. The configuration for a voice clone. If
	// [VoiceCloneParams.voice_clone_key] is set, the service chooses the voice
	// clone matching the specified configuration.
	VoiceClone *VoiceCloneParams `protobuf:"bytes,5,opt,name=voice_clone,json=voiceClone,proto3" json:"voice_clone,omitempty"`
}

func (x *VoiceSelectionParams) Reset() {
	*x = VoiceSelectionParams{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoiceSelectionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoiceSelectionParams) ProtoMessage() {}

func (x *VoiceSelectionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoiceSelectionParams.ProtoReflect.Descriptor instead.
func (*VoiceSelectionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{9}
}

func (x *VoiceSelectionParams) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *VoiceSelectionParams) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VoiceSelectionParams) GetSsmlGender() SsmlVoiceGender {
	if x != nil {
		return x.SsmlGender
	}
	return SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED
}

func (x *VoiceSelectionParams) GetCustomVoice() *CustomVoiceParams {
	if x != nil {
		return x.CustomVoice
	}
	return nil
}

func (x *VoiceSelectionParams) GetVoiceClone() *VoiceCloneParams {
	if x != nil {
		return x.VoiceClone
	}
	return nil
}

// Description of audio data to be synthesized.
type AudioConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The format of the audio byte stream.
	AudioEncoding AudioEncoding `protobuf:"varint,1,opt,name=audio_encoding,json=audioEncoding,proto3,enum=google.cloud.texttospeech.v1.AudioEncoding" json:"audio_encoding,omitempty"`
	// Optional. Input only. Speaking rate/speed, in the range [0.25, 2.0]. 1.0 is
	// the normal native speed supported by the specific voice. 2.0 is twice as
	// fast, and 0.5 is half as fast. If unset(0.0), defaults to the native 1.0
	// speed. Any other values < 0.25 or > 2.0 will return an error.
	SpeakingRate float64 `protobuf:"fixed64,2,opt,name=speaking_rate,json=speakingRate,proto3" json:"speaking_rate,omitempty"`
	// Optional. Input only. Speaking pitch, in the range [-20.0, 20.0]. 20 means
	// increase 20 semitones from the original pitch. -20 means decrease 20
	// semitones from the original pitch.
	Pitch float64 `protobuf:"fixed64,3,opt,name=pitch,proto3" json:"pitch,omitempty"`
	// Optional. Input only. Volume gain (in dB) of the normal native volume
	// supported by the specific voice, in the range [-96.0, 16.0]. If unset, or
	// set to a value of 0.0 (dB), will play at normal native signal amplitude. A
	// value of -6.0 (dB) will play at approximately half the amplitude of the
	// normal native signal amplitude. A value of +6.0 (dB) will play at
	// approximately twice the amplitude of the normal native signal amplitude.
	// Strongly recommend not to exceed +10 (dB) as there's usually no effective
	// increase in loudness for any value greater than that.
	VolumeGainDb float64 `protobuf:"fixed64,4,opt,name=volume_gain_db,json=volumeGainDb,proto3" json:"volume_gain_db,omitempty"`
	// Optional. The synthesis sample rate (in hertz) for this audio. When this is
	// specified in SynthesizeSpeechRequest, if this is different from the voice's
	// natural sample rate, then the synthesizer will honor this request by
	// converting to the desired sample rate (which might result in worse audio
	// quality), unless the specified sample rate is not supported for the
	// encoding chosen, in which case it will fail the request and return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
	SampleRateHertz int32 `protobuf:"varint,5,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Optional. Input only. An identifier which selects 'audio effects' profiles
	// that are applied on (post synthesized) text to speech. Effects are applied
	// on top of each other in the order they are given. See
	// [audio
	// profiles](https://cloud.google.com/text-to-speech/docs/audio-profiles) for
	// current supported profile ids.
	EffectsProfileId []string `protobuf:"bytes,6,rep,name=effects_profile_id,json=effectsProfileId,proto3" json:"effects_profile_id,omitempty"`
}

func (x *AudioConfig) Reset() {
	*x = AudioConfig{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudioConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioConfig) ProtoMessage() {}

func (x *AudioConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioConfig.ProtoReflect.Descriptor instead.
func (*AudioConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{10}
}

func (x *AudioConfig) GetAudioEncoding() AudioEncoding {
	if x != nil {
		return x.AudioEncoding
	}
	return AudioEncoding_AUDIO_ENCODING_UNSPECIFIED
}

func (x *AudioConfig) GetSpeakingRate() float64 {
	if x != nil {
		return x.SpeakingRate
	}
	return 0
}

func (x *AudioConfig) GetPitch() float64 {
	if x != nil {
		return x.Pitch
	}
	return 0
}

func (x *AudioConfig) GetVolumeGainDb() float64 {
	if x != nil {
		return x.VolumeGainDb
	}
	return 0
}

func (x *AudioConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

func (x *AudioConfig) GetEffectsProfileId() []string {
	if x != nil {
		return x.EffectsProfileId
	}
	return nil
}

// Description of the custom voice to be synthesized.
type CustomVoiceParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the AutoML model that synthesizes the custom voice.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. Deprecated. The usage of the synthesized audio to be reported.
	//
	// Deprecated: Marked as deprecated in google/cloud/texttospeech/v1/cloud_tts.proto.
	ReportedUsage CustomVoiceParams_ReportedUsage `protobuf:"varint,3,opt,name=reported_usage,json=reportedUsage,proto3,enum=google.cloud.texttospeech.v1.CustomVoiceParams_ReportedUsage" json:"reported_usage,omitempty"`
}

func (x *CustomVoiceParams) Reset() {
	*x = CustomVoiceParams{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomVoiceParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomVoiceParams) ProtoMessage() {}

func (x *CustomVoiceParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomVoiceParams.ProtoReflect.Descriptor instead.
func (*CustomVoiceParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{11}
}

func (x *CustomVoiceParams) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/texttospeech/v1/cloud_tts.proto.
func (x *CustomVoiceParams) GetReportedUsage() CustomVoiceParams_ReportedUsage {
	if x != nil {
		return x.ReportedUsage
	}
	return CustomVoiceParams_REPORTED_USAGE_UNSPECIFIED
}

// The configuration of Voice Clone feature.
type VoiceCloneParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Created by GenerateVoiceCloningKey.
	VoiceCloningKey string `protobuf:"bytes,1,opt,name=voice_cloning_key,json=voiceCloningKey,proto3" json:"voice_cloning_key,omitempty"`
}

func (x *VoiceCloneParams) Reset() {
	*x = VoiceCloneParams{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoiceCloneParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoiceCloneParams) ProtoMessage() {}

func (x *VoiceCloneParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoiceCloneParams.ProtoReflect.Descriptor instead.
func (*VoiceCloneParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{12}
}

func (x *VoiceCloneParams) GetVoiceCloningKey() string {
	if x != nil {
		return x.VoiceCloningKey
	}
	return ""
}

// The message returned to the client by the `SynthesizeSpeech` method.
type SynthesizeSpeechResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The audio data bytes encoded as specified in the request, including the
	// header for encodings that are wrapped in containers (e.g. MP3, OGG_OPUS).
	// For LINEAR16 audio, we include the WAV header. Note: as
	// with all bytes fields, protobuffers use a pure binary representation,
	// whereas JSON representations use base64.
	AudioContent []byte `protobuf:"bytes,1,opt,name=audio_content,json=audioContent,proto3" json:"audio_content,omitempty"`
}

func (x *SynthesizeSpeechResponse) Reset() {
	*x = SynthesizeSpeechResponse{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SynthesizeSpeechResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SynthesizeSpeechResponse) ProtoMessage() {}

func (x *SynthesizeSpeechResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SynthesizeSpeechResponse.ProtoReflect.Descriptor instead.
func (*SynthesizeSpeechResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{13}
}

func (x *SynthesizeSpeechResponse) GetAudioContent() []byte {
	if x != nil {
		return x.AudioContent
	}
	return nil
}

// Description of the desired output audio data.
type StreamingAudioConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The format of the audio byte stream.
	// Streaming supports PCM, ALAW, MULAW and OGG_OPUS. All other encodings
	// return an error.
	AudioEncoding AudioEncoding `protobuf:"varint,1,opt,name=audio_encoding,json=audioEncoding,proto3,enum=google.cloud.texttospeech.v1.AudioEncoding" json:"audio_encoding,omitempty"`
	// Optional. The synthesis sample rate (in hertz) for this audio.
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Optional. Input only. Speaking rate/speed, in the range [0.25, 2.0]. 1.0 is
	// the normal native speed supported by the specific voice. 2.0 is twice as
	// fast, and 0.5 is half as fast. If unset(0.0), defaults to the native 1.0
	// speed. Any other values < 0.25 or > 2.0 will return an error.
	SpeakingRate float64 `protobuf:"fixed64,3,opt,name=speaking_rate,json=speakingRate,proto3" json:"speaking_rate,omitempty"`
}

func (x *StreamingAudioConfig) Reset() {
	*x = StreamingAudioConfig{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingAudioConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingAudioConfig) ProtoMessage() {}

func (x *StreamingAudioConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingAudioConfig.ProtoReflect.Descriptor instead.
func (*StreamingAudioConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{14}
}

func (x *StreamingAudioConfig) GetAudioEncoding() AudioEncoding {
	if x != nil {
		return x.AudioEncoding
	}
	return AudioEncoding_AUDIO_ENCODING_UNSPECIFIED
}

func (x *StreamingAudioConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

func (x *StreamingAudioConfig) GetSpeakingRate() float64 {
	if x != nil {
		return x.SpeakingRate
	}
	return 0
}

// Provides configuration information for the StreamingSynthesize request.
type StreamingSynthesizeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The desired voice of the synthesized audio.
	Voice *VoiceSelectionParams `protobuf:"bytes,1,opt,name=voice,proto3" json:"voice,omitempty"`
	// Optional. The configuration of the synthesized audio.
	StreamingAudioConfig *StreamingAudioConfig `protobuf:"bytes,4,opt,name=streaming_audio_config,json=streamingAudioConfig,proto3" json:"streaming_audio_config,omitempty"`
	// Optional. The pronunciation customizations are applied to the input. If
	// this is set, the input is synthesized using the given pronunciation
	// customizations.
	//
	// The initial support is for en-us, with plans to expand to other locales in
	// the future. Instant Clone voices aren't supported.
	//
	// In order to customize the pronunciation of a phrase, there must be an exact
	// match of the phrase in the input types. If using SSML, the phrase must not
	// be inside a phoneme tag.
	CustomPronunciations *CustomPronunciations `protobuf:"bytes,5,opt,name=custom_pronunciations,json=customPronunciations,proto3" json:"custom_pronunciations,omitempty"`
}

func (x *StreamingSynthesizeConfig) Reset() {
	*x = StreamingSynthesizeConfig{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingSynthesizeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingSynthesizeConfig) ProtoMessage() {}

func (x *StreamingSynthesizeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingSynthesizeConfig.ProtoReflect.Descriptor instead.
func (*StreamingSynthesizeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{15}
}

func (x *StreamingSynthesizeConfig) GetVoice() *VoiceSelectionParams {
	if x != nil {
		return x.Voice
	}
	return nil
}

func (x *StreamingSynthesizeConfig) GetStreamingAudioConfig() *StreamingAudioConfig {
	if x != nil {
		return x.StreamingAudioConfig
	}
	return nil
}

func (x *StreamingSynthesizeConfig) GetCustomPronunciations() *CustomPronunciations {
	if x != nil {
		return x.CustomPronunciations
	}
	return nil
}

// Input to be synthesized.
type StreamingSynthesisInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to InputSource:
	//
	//	*StreamingSynthesisInput_Text
	//	*StreamingSynthesisInput_Markup
	InputSource isStreamingSynthesisInput_InputSource `protobuf_oneof:"input_source"`
}

func (x *StreamingSynthesisInput) Reset() {
	*x = StreamingSynthesisInput{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingSynthesisInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingSynthesisInput) ProtoMessage() {}

func (x *StreamingSynthesisInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingSynthesisInput.ProtoReflect.Descriptor instead.
func (*StreamingSynthesisInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{16}
}

func (m *StreamingSynthesisInput) GetInputSource() isStreamingSynthesisInput_InputSource {
	if m != nil {
		return m.InputSource
	}
	return nil
}

func (x *StreamingSynthesisInput) GetText() string {
	if x, ok := x.GetInputSource().(*StreamingSynthesisInput_Text); ok {
		return x.Text
	}
	return ""
}

func (x *StreamingSynthesisInput) GetMarkup() string {
	if x, ok := x.GetInputSource().(*StreamingSynthesisInput_Markup); ok {
		return x.Markup
	}
	return ""
}

type isStreamingSynthesisInput_InputSource interface {
	isStreamingSynthesisInput_InputSource()
}

type StreamingSynthesisInput_Text struct {
	// The raw text to be synthesized. It is recommended that each input
	// contains complete, terminating sentences, which results in better prosody
	// in the output audio.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type StreamingSynthesisInput_Markup struct {
	// Markup for HD voices specifically. This field may not be used with any
	// other voices.
	Markup string `protobuf:"bytes,5,opt,name=markup,proto3,oneof"`
}

func (*StreamingSynthesisInput_Text) isStreamingSynthesisInput_InputSource() {}

func (*StreamingSynthesisInput_Markup) isStreamingSynthesisInput_InputSource() {}

// Request message for the `StreamingSynthesize` method. Multiple
// `StreamingSynthesizeRequest` messages are sent in one call.
// The first message must contain a `streaming_config` that
// fully specifies the request configuration and must not contain `input`. All
// subsequent messages must only have `input` set.
type StreamingSynthesizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request to be sent, either a StreamingSynthesizeConfig or
	// StreamingSynthesisInput.
	//
	// Types that are assignable to StreamingRequest:
	//
	//	*StreamingSynthesizeRequest_StreamingConfig
	//	*StreamingSynthesizeRequest_Input
	StreamingRequest isStreamingSynthesizeRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
}

func (x *StreamingSynthesizeRequest) Reset() {
	*x = StreamingSynthesizeRequest{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingSynthesizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingSynthesizeRequest) ProtoMessage() {}

func (x *StreamingSynthesizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingSynthesizeRequest.ProtoReflect.Descriptor instead.
func (*StreamingSynthesizeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{17}
}

func (m *StreamingSynthesizeRequest) GetStreamingRequest() isStreamingSynthesizeRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (x *StreamingSynthesizeRequest) GetStreamingConfig() *StreamingSynthesizeConfig {
	if x, ok := x.GetStreamingRequest().(*StreamingSynthesizeRequest_StreamingConfig); ok {
		return x.StreamingConfig
	}
	return nil
}

func (x *StreamingSynthesizeRequest) GetInput() *StreamingSynthesisInput {
	if x, ok := x.GetStreamingRequest().(*StreamingSynthesizeRequest_Input); ok {
		return x.Input
	}
	return nil
}

type isStreamingSynthesizeRequest_StreamingRequest interface {
	isStreamingSynthesizeRequest_StreamingRequest()
}

type StreamingSynthesizeRequest_StreamingConfig struct {
	// StreamingSynthesizeConfig to be used in this streaming attempt. Only
	// specified in the first message sent in a `StreamingSynthesize` call.
	StreamingConfig *StreamingSynthesizeConfig `protobuf:"bytes,1,opt,name=streaming_config,json=streamingConfig,proto3,oneof"`
}

type StreamingSynthesizeRequest_Input struct {
	// Input to synthesize. Specified in all messages but the first in a
	// `StreamingSynthesize` call.
	Input *StreamingSynthesisInput `protobuf:"bytes,2,opt,name=input,proto3,oneof"`
}

func (*StreamingSynthesizeRequest_StreamingConfig) isStreamingSynthesizeRequest_StreamingRequest() {}

func (*StreamingSynthesizeRequest_Input) isStreamingSynthesizeRequest_StreamingRequest() {}

// `StreamingSynthesizeResponse` is the only message returned to the
// client by `StreamingSynthesize` method. A series of zero or more
// `StreamingSynthesizeResponse` messages are streamed back to the client.
type StreamingSynthesizeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The audio data bytes encoded as specified in the request. This is
	// headerless LINEAR16 audio with a sample rate of 24000.
	AudioContent []byte `protobuf:"bytes,1,opt,name=audio_content,json=audioContent,proto3" json:"audio_content,omitempty"`
}

func (x *StreamingSynthesizeResponse) Reset() {
	*x = StreamingSynthesizeResponse{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingSynthesizeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingSynthesizeResponse) ProtoMessage() {}

func (x *StreamingSynthesizeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingSynthesizeResponse.ProtoReflect.Descriptor instead.
func (*StreamingSynthesizeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{18}
}

func (x *StreamingSynthesizeResponse) GetAudioContent() []byte {
	if x != nil {
		return x.AudioContent
	}
	return nil
}

// A multi-speaker turn.
type MultiSpeakerMarkup_Turn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The speaker of the turn, for example, 'O' or 'Q'. Please refer
	// to documentation for available speakers.
	Speaker string `protobuf:"bytes,1,opt,name=speaker,proto3" json:"speaker,omitempty"`
	// Required. The text to speak.
	Text string `protobuf:"bytes,2,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *MultiSpeakerMarkup_Turn) Reset() {
	*x = MultiSpeakerMarkup_Turn{}
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MultiSpeakerMarkup_Turn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiSpeakerMarkup_Turn) ProtoMessage() {}

func (x *MultiSpeakerMarkup_Turn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiSpeakerMarkup_Turn.ProtoReflect.Descriptor instead.
func (*MultiSpeakerMarkup_Turn) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP(), []int{7, 0}
}

func (x *MultiSpeakerMarkup_Turn) GetSpeaker() string {
	if x != nil {
		return x.Speaker
	}
	return ""
}

func (x *MultiSpeakerMarkup_Turn) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

var File_google_cloud_texttospeech_v1_cloud_tts_proto protoreflect.FileDescriptor

var file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x74, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78,
	0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x3d, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x51,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x06, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x06, 0x76, 0x6f, 0x69, 0x63, 0x65,
	0x73, 0x22, 0xcd, 0x01, 0x0a, 0x05, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0b, 0x73, 0x73, 0x6d, 0x6c, 0x5f, 0x67,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74,
	0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x6d, 0x6c, 0x56,
	0x6f, 0x69, 0x63, 0x65, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x52, 0x0a, 0x73, 0x73, 0x6d, 0x6c,
	0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x12, 0x39, 0x0a, 0x19, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61,
	0x6c, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65,
	0x72, 0x74, 0x7a, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x16, 0x6e, 0x61, 0x74, 0x75, 0x72,
	0x61, 0x6c, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74,
	0x7a, 0x22, 0x80, 0x01, 0x0a, 0x14, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x56, 0x6f,
	0x69, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46, 0x0a, 0x1d, 0x6c, 0x6f,
	0x77, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6a, 0x6f, 0x75, 0x72, 0x6e, 0x65,
	0x79, 0x5f, 0x73, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x00, 0x52, 0x1a, 0x6c, 0x6f, 0x77, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x4a,
	0x6f, 0x75, 0x72, 0x6e, 0x65, 0x79, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x73, 0x88,
	0x01, 0x01, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x6a, 0x6f, 0x75, 0x72, 0x6e, 0x65, 0x79, 0x5f, 0x73, 0x79, 0x6e, 0x74, 0x68,
	0x65, 0x73, 0x69, 0x73, 0x22, 0x8e, 0x03, 0x0a, 0x17, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73,
	0x69, 0x7a, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x47, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4d, 0x0a, 0x05, 0x76, 0x6f, 0x69,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x51, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6d, 0x0a, 0x16, 0x61,
	0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74,
	0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48,
	0x00, 0x52, 0x14, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x56, 0x6f, 0x69, 0x63, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x61,
	0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xcb, 0x03, 0x0a, 0x19, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x50, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x7a, 0x0a, 0x11, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x74, 0x69, 0x63, 0x5f, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74,
	0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x50, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x2e, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x74, 0x69, 0x63, 0x45, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x48, 0x01, 0x52, 0x10, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x74, 0x69,
	0x63, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0d,
	0x70, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x22, 0xb6, 0x01, 0x0a, 0x10, 0x50, 0x68, 0x6f, 0x6e,
	0x65, 0x74, 0x69, 0x63, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x21, 0x0a, 0x1d,
	0x50, 0x48, 0x4f, 0x4e, 0x45, 0x54, 0x49, 0x43, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e,
	0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x19, 0x0a, 0x15, 0x50, 0x48, 0x4f, 0x4e, 0x45, 0x54, 0x49, 0x43, 0x5f, 0x45, 0x4e, 0x43, 0x4f,
	0x44, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x50, 0x41, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x48,
	0x4f, 0x4e, 0x45, 0x54, 0x49, 0x43, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f,
	0x58, 0x5f, 0x53, 0x41, 0x4d, 0x50, 0x41, 0x10, 0x02, 0x12, 0x27, 0x0a, 0x23, 0x50, 0x48, 0x4f,
	0x4e, 0x45, 0x54, 0x49, 0x43, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x4a,
	0x41, 0x50, 0x41, 0x4e, 0x45, 0x53, 0x45, 0x5f, 0x59, 0x4f, 0x4d, 0x49, 0x47, 0x41, 0x4e, 0x41,
	0x10, 0x03, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x48, 0x4f, 0x4e, 0x45, 0x54, 0x49, 0x43, 0x5f, 0x45,
	0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x49, 0x4e, 0x59, 0x49, 0x4e, 0x10, 0x04,
	0x42, 0x09, 0x0a, 0x07, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f,
	0x70, 0x68, 0x6f, 0x6e, 0x65, 0x74, 0x69, 0x63, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x70, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x77, 0x0a, 0x14, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f,
	0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x0e, 0x70,
	0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63,
	0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x0e, 0x70, 0x72,
	0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa6, 0x01, 0x0a,
	0x12, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x4d, 0x61, 0x72,
	0x6b, 0x75, 0x70, 0x12, 0x50, 0x0a, 0x05, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x4d, 0x61,
	0x72, 0x6b, 0x75, 0x70, 0x2e, 0x54, 0x75, 0x72, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x74, 0x75, 0x72, 0x6e, 0x73, 0x1a, 0x3e, 0x0a, 0x04, 0x54, 0x75, 0x72, 0x6e, 0x12, 0x1d, 0x0a,
	0x07, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x74, 0x65, 0x78, 0x74, 0x22, 0xba, 0x02, 0x0a, 0x0e, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65,
	0x73, 0x69, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x14, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x18,
	0x0a, 0x06, 0x6d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x06, 0x6d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x12, 0x14, 0x0a, 0x04, 0x73, 0x73, 0x6d, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x73, 0x73, 0x6d, 0x6c, 0x12, 0x64,
	0x0a, 0x14, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f,
	0x6d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74,
	0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x6c, 0x74,
	0x69, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x48, 0x00,
	0x52, 0x12, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x4d, 0x61,
	0x72, 0x6b, 0x75, 0x70, 0x12, 0x6c, 0x0a, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70,
	0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63,
	0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0xce, 0x02, 0x0a, 0x14, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0b, 0x73, 0x73, 0x6d,
	0x6c, 0x5f, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73,
	0x6d, 0x6c, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x52, 0x0a, 0x73,
	0x73, 0x6d, 0x6c, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x12, 0x52, 0x0a, 0x0c, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x52, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x54, 0x0a,
	0x0b, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6c,
	0x6f, 0x6e, 0x65, 0x22, 0xc6, 0x02, 0x0a, 0x0b, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x0e, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74,
	0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2b, 0x0a, 0x0d,
	0x73, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x01, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x70, 0x65,
	0x61, 0x6b, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x05, 0x70, 0x69, 0x74,
	0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x01,
	0x52, 0x05, 0x70, 0x69, 0x74, 0x63, 0x68, 0x12, 0x2c, 0x0a, 0x0e, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x5f, 0x67, 0x61, 0x69, 0x6e, 0x5f, 0x64, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x42,
	0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x47,
	0x61, 0x69, 0x6e, 0x44, 0x62, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65, 0x72, 0x74, 0x7a, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x61, 0x74,
	0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x12, 0x34, 0x0a, 0x12, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x73, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x22, 0x87, 0x02, 0x0a,
	0x11, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x12, 0x39, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x6b, 0x0a,
	0x0e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x6f, 0x69, 0x63, 0x65,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x0d, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x55, 0x73, 0x61, 0x67, 0x65, 0x22, 0x4a, 0x0a, 0x0d, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x52,
	0x45, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x55, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52,
	0x45, 0x41, 0x4c, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x46, 0x46,
	0x4c, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x22, 0x43, 0x0a, 0x10, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x43,
	0x6c, 0x6f, 0x6e, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x76, 0x6f,
	0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x76, 0x6f, 0x69, 0x63,
	0x65, 0x43, 0x6c, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x22, 0x3f, 0x0a, 0x18, 0x53,
	0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x75, 0x64, 0x69, 0x6f,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0xcd, 0x01, 0x0a,
	0x14, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x0e, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78,
	0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0d, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2f,
	0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65,
	0x72, 0x74, 0x7a, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x12,
	0x2b, 0x0a, 0x0d, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x73, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74, 0x65, 0x22, 0xc7, 0x02, 0x0a,
	0x19, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65,
	0x73, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x05, 0x76, 0x6f,
	0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x6d, 0x0a, 0x16, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x14, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6c, 0x0a, 0x15, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x70, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f,
	0x6e, 0x75, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x14, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x59, 0x0a, 0x17, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x73, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x12, 0x14, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x18, 0x0a, 0x06, 0x6d, 0x61, 0x72, 0x6b, 0x75,
	0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x6d, 0x61, 0x72, 0x6b, 0x75,
	0x70, 0x42, 0x0e, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0xe6, 0x01, 0x0a, 0x1a, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53,
	0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x64, 0x0a, 0x10, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x79,
	0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x05,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x13, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x42, 0x0a, 0x1b, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x75, 0x64,
	0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2a, 0x57,
	0x0a, 0x0f, 0x53, 0x73, 0x6d, 0x6c, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x47, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x53, 0x4d, 0x4c, 0x5f, 0x56, 0x4f, 0x49, 0x43, 0x45, 0x5f,
	0x47, 0x45, 0x4e, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4d, 0x41, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x45, 0x4d, 0x41, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x45,
	0x55, 0x54, 0x52, 0x41, 0x4c, 0x10, 0x03, 0x2a, 0x72, 0x0a, 0x0d, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x55, 0x44, 0x49,
	0x4f, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x49, 0x4e, 0x45,
	0x41, 0x52, 0x31, 0x36, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x50, 0x33, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x4f, 0x47, 0x47, 0x5f, 0x4f, 0x50, 0x55, 0x53, 0x10, 0x03, 0x12, 0x09, 0x0a,
	0x05, 0x4d, 0x55, 0x4c, 0x41, 0x57, 0x10, 0x05, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x4c, 0x41, 0x57,
	0x10, 0x06, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x43, 0x4d, 0x10, 0x07, 0x32, 0xc7, 0x04, 0x0a, 0x0c,
	0x54, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x12, 0x93, 0x01, 0x0a,
	0x0a, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74,
	0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56,
	0x6f, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74,
	0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x56, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x22,
	0xda, 0x41, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0c, 0x12, 0x0a, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x6f, 0x69, 0x63,
	0x65, 0x73, 0x12, 0xbc, 0x01, 0x0a, 0x10, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a,
	0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a,
	0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79,
	0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39, 0xda, 0x41, 0x18, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x2c, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x2c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x3a, 0x01, 0x2a, 0x22, 0x13, 0x2f, 0x76,
	0x31, 0x2f, 0x74, 0x65, 0x78, 0x74, 0x3a, 0x73, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a,
	0x65, 0x12, 0x90, 0x01, 0x0a, 0x13, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53,
	0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x6e, 0x74,
	0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x28, 0x01, 0x30, 0x01, 0x1a, 0x4f, 0xca, 0x41, 0x1b, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xbc, 0x02, 0xea, 0x41, 0x55, 0x0a, 0x1b, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x7d,
	0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x42, 0x11, 0x54, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x74, 0x65, 0x78,
	0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x70, 0x62, 0x3b, 0x74,
	0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x70, 0x62, 0xa2, 0x02, 0x04,
	0x43, 0x54, 0x54, 0x53, 0xaa, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x54, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x54, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescOnce sync.Once
	file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescData = file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDesc
)

func file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescGZIP() []byte {
	file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescOnce.Do(func() {
		file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescData)
	})
	return file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDescData
}

var file_google_cloud_texttospeech_v1_cloud_tts_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_texttospeech_v1_cloud_tts_proto_goTypes = []any{
	(SsmlVoiceGender)(0),                            // 0: google.cloud.texttospeech.v1.SsmlVoiceGender
	(AudioEncoding)(0),                              // 1: google.cloud.texttospeech.v1.AudioEncoding
	(CustomPronunciationParams_PhoneticEncoding)(0), // 2: google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding
	(CustomVoiceParams_ReportedUsage)(0),            // 3: google.cloud.texttospeech.v1.CustomVoiceParams.ReportedUsage
	(*ListVoicesRequest)(nil),                       // 4: google.cloud.texttospeech.v1.ListVoicesRequest
	(*ListVoicesResponse)(nil),                      // 5: google.cloud.texttospeech.v1.ListVoicesResponse
	(*Voice)(nil),                                   // 6: google.cloud.texttospeech.v1.Voice
	(*AdvancedVoiceOptions)(nil),                    // 7: google.cloud.texttospeech.v1.AdvancedVoiceOptions
	(*SynthesizeSpeechRequest)(nil),                 // 8: google.cloud.texttospeech.v1.SynthesizeSpeechRequest
	(*CustomPronunciationParams)(nil),               // 9: google.cloud.texttospeech.v1.CustomPronunciationParams
	(*CustomPronunciations)(nil),                    // 10: google.cloud.texttospeech.v1.CustomPronunciations
	(*MultiSpeakerMarkup)(nil),                      // 11: google.cloud.texttospeech.v1.MultiSpeakerMarkup
	(*SynthesisInput)(nil),                          // 12: google.cloud.texttospeech.v1.SynthesisInput
	(*VoiceSelectionParams)(nil),                    // 13: google.cloud.texttospeech.v1.VoiceSelectionParams
	(*AudioConfig)(nil),                             // 14: google.cloud.texttospeech.v1.AudioConfig
	(*CustomVoiceParams)(nil),                       // 15: google.cloud.texttospeech.v1.CustomVoiceParams
	(*VoiceCloneParams)(nil),                        // 16: google.cloud.texttospeech.v1.VoiceCloneParams
	(*SynthesizeSpeechResponse)(nil),                // 17: google.cloud.texttospeech.v1.SynthesizeSpeechResponse
	(*StreamingAudioConfig)(nil),                    // 18: google.cloud.texttospeech.v1.StreamingAudioConfig
	(*StreamingSynthesizeConfig)(nil),               // 19: google.cloud.texttospeech.v1.StreamingSynthesizeConfig
	(*StreamingSynthesisInput)(nil),                 // 20: google.cloud.texttospeech.v1.StreamingSynthesisInput
	(*StreamingSynthesizeRequest)(nil),              // 21: google.cloud.texttospeech.v1.StreamingSynthesizeRequest
	(*StreamingSynthesizeResponse)(nil),             // 22: google.cloud.texttospeech.v1.StreamingSynthesizeResponse
	(*MultiSpeakerMarkup_Turn)(nil),                 // 23: google.cloud.texttospeech.v1.MultiSpeakerMarkup.Turn
}
var file_google_cloud_texttospeech_v1_cloud_tts_proto_depIdxs = []int32{
	6,  // 0: google.cloud.texttospeech.v1.ListVoicesResponse.voices:type_name -> google.cloud.texttospeech.v1.Voice
	0,  // 1: google.cloud.texttospeech.v1.Voice.ssml_gender:type_name -> google.cloud.texttospeech.v1.SsmlVoiceGender
	12, // 2: google.cloud.texttospeech.v1.SynthesizeSpeechRequest.input:type_name -> google.cloud.texttospeech.v1.SynthesisInput
	13, // 3: google.cloud.texttospeech.v1.SynthesizeSpeechRequest.voice:type_name -> google.cloud.texttospeech.v1.VoiceSelectionParams
	14, // 4: google.cloud.texttospeech.v1.SynthesizeSpeechRequest.audio_config:type_name -> google.cloud.texttospeech.v1.AudioConfig
	7,  // 5: google.cloud.texttospeech.v1.SynthesizeSpeechRequest.advanced_voice_options:type_name -> google.cloud.texttospeech.v1.AdvancedVoiceOptions
	2,  // 6: google.cloud.texttospeech.v1.CustomPronunciationParams.phonetic_encoding:type_name -> google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding
	9,  // 7: google.cloud.texttospeech.v1.CustomPronunciations.pronunciations:type_name -> google.cloud.texttospeech.v1.CustomPronunciationParams
	23, // 8: google.cloud.texttospeech.v1.MultiSpeakerMarkup.turns:type_name -> google.cloud.texttospeech.v1.MultiSpeakerMarkup.Turn
	11, // 9: google.cloud.texttospeech.v1.SynthesisInput.multi_speaker_markup:type_name -> google.cloud.texttospeech.v1.MultiSpeakerMarkup
	10, // 10: google.cloud.texttospeech.v1.SynthesisInput.custom_pronunciations:type_name -> google.cloud.texttospeech.v1.CustomPronunciations
	0,  // 11: google.cloud.texttospeech.v1.VoiceSelectionParams.ssml_gender:type_name -> google.cloud.texttospeech.v1.SsmlVoiceGender
	15, // 12: google.cloud.texttospeech.v1.VoiceSelectionParams.custom_voice:type_name -> google.cloud.texttospeech.v1.CustomVoiceParams
	16, // 13: google.cloud.texttospeech.v1.VoiceSelectionParams.voice_clone:type_name -> google.cloud.texttospeech.v1.VoiceCloneParams
	1,  // 14: google.cloud.texttospeech.v1.AudioConfig.audio_encoding:type_name -> google.cloud.texttospeech.v1.AudioEncoding
	3,  // 15: google.cloud.texttospeech.v1.CustomVoiceParams.reported_usage:type_name -> google.cloud.texttospeech.v1.CustomVoiceParams.ReportedUsage
	1,  // 16: google.cloud.texttospeech.v1.StreamingAudioConfig.audio_encoding:type_name -> google.cloud.texttospeech.v1.AudioEncoding
	13, // 17: google.cloud.texttospeech.v1.StreamingSynthesizeConfig.voice:type_name -> google.cloud.texttospeech.v1.VoiceSelectionParams
	18, // 18: google.cloud.texttospeech.v1.StreamingSynthesizeConfig.streaming_audio_config:type_name -> google.cloud.texttospeech.v1.StreamingAudioConfig
	10, // 19: google.cloud.texttospeech.v1.StreamingSynthesizeConfig.custom_pronunciations:type_name -> google.cloud.texttospeech.v1.CustomPronunciations
	19, // 20: google.cloud.texttospeech.v1.StreamingSynthesizeRequest.streaming_config:type_name -> google.cloud.texttospeech.v1.StreamingSynthesizeConfig
	20, // 21: google.cloud.texttospeech.v1.StreamingSynthesizeRequest.input:type_name -> google.cloud.texttospeech.v1.StreamingSynthesisInput
	4,  // 22: google.cloud.texttospeech.v1.TextToSpeech.ListVoices:input_type -> google.cloud.texttospeech.v1.ListVoicesRequest
	8,  // 23: google.cloud.texttospeech.v1.TextToSpeech.SynthesizeSpeech:input_type -> google.cloud.texttospeech.v1.SynthesizeSpeechRequest
	21, // 24: google.cloud.texttospeech.v1.TextToSpeech.StreamingSynthesize:input_type -> google.cloud.texttospeech.v1.StreamingSynthesizeRequest
	5,  // 25: google.cloud.texttospeech.v1.TextToSpeech.ListVoices:output_type -> google.cloud.texttospeech.v1.ListVoicesResponse
	17, // 26: google.cloud.texttospeech.v1.TextToSpeech.SynthesizeSpeech:output_type -> google.cloud.texttospeech.v1.SynthesizeSpeechResponse
	22, // 27: google.cloud.texttospeech.v1.TextToSpeech.StreamingSynthesize:output_type -> google.cloud.texttospeech.v1.StreamingSynthesizeResponse
	25, // [25:28] is the sub-list for method output_type
	22, // [22:25] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_google_cloud_texttospeech_v1_cloud_tts_proto_init() }
func file_google_cloud_texttospeech_v1_cloud_tts_proto_init() {
	if File_google_cloud_texttospeech_v1_cloud_tts_proto != nil {
		return
	}
	file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[3].OneofWrappers = []any{}
	file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[4].OneofWrappers = []any{}
	file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[5].OneofWrappers = []any{}
	file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[8].OneofWrappers = []any{
		(*SynthesisInput_Text)(nil),
		(*SynthesisInput_Markup)(nil),
		(*SynthesisInput_Ssml)(nil),
		(*SynthesisInput_MultiSpeakerMarkup)(nil),
	}
	file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[16].OneofWrappers = []any{
		(*StreamingSynthesisInput_Text)(nil),
		(*StreamingSynthesisInput_Markup)(nil),
	}
	file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes[17].OneofWrappers = []any{
		(*StreamingSynthesizeRequest_StreamingConfig)(nil),
		(*StreamingSynthesizeRequest_Input)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_texttospeech_v1_cloud_tts_proto_goTypes,
		DependencyIndexes: file_google_cloud_texttospeech_v1_cloud_tts_proto_depIdxs,
		EnumInfos:         file_google_cloud_texttospeech_v1_cloud_tts_proto_enumTypes,
		MessageInfos:      file_google_cloud_texttospeech_v1_cloud_tts_proto_msgTypes,
	}.Build()
	File_google_cloud_texttospeech_v1_cloud_tts_proto = out.File
	file_google_cloud_texttospeech_v1_cloud_tts_proto_rawDesc = nil
	file_google_cloud_texttospeech_v1_cloud_tts_proto_goTypes = nil
	file_google_cloud_texttospeech_v1_cloud_tts_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TextToSpeechClient is the client API for TextToSpeech service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TextToSpeechClient interface {
	// Returns a list of Voice supported for synthesis.
	ListVoices(ctx context.Context, in *ListVoicesRequest, opts ...grpc.CallOption) (*ListVoicesResponse, error)
	// Synthesizes speech synchronously: receive results after all text input
	// has been processed.
	SynthesizeSpeech(ctx context.Context, in *SynthesizeSpeechRequest, opts ...grpc.CallOption) (*SynthesizeSpeechResponse, error)
	// Performs bidirectional streaming speech synthesis: receives audio while
	// sending text.
	StreamingSynthesize(ctx context.Context, opts ...grpc.CallOption) (TextToSpeech_StreamingSynthesizeClient, error)
}

type textToSpeechClient struct {
	cc grpc.ClientConnInterface
}

func NewTextToSpeechClient(cc grpc.ClientConnInterface) TextToSpeechClient {
	return &textToSpeechClient{cc}
}

func (c *textToSpeechClient) ListVoices(ctx context.Context, in *ListVoicesRequest, opts ...grpc.CallOption) (*ListVoicesResponse, error) {
	out := new(ListVoicesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.texttospeech.v1.TextToSpeech/ListVoices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *textToSpeechClient) SynthesizeSpeech(ctx context.Context, in *SynthesizeSpeechRequest, opts ...grpc.CallOption) (*SynthesizeSpeechResponse, error) {
	out := new(SynthesizeSpeechResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.texttospeech.v1.TextToSpeech/SynthesizeSpeech", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *textToSpeechClient) StreamingSynthesize(ctx context.Context, opts ...grpc.CallOption) (TextToSpeech_StreamingSynthesizeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_TextToSpeech_serviceDesc.Streams[0], "/google.cloud.texttospeech.v1.TextToSpeech/StreamingSynthesize", opts...)
	if err != nil {
		return nil, err
	}
	x := &textToSpeechStreamingSynthesizeClient{stream}
	return x, nil
}

type TextToSpeech_StreamingSynthesizeClient interface {
	Send(*StreamingSynthesizeRequest) error
	Recv() (*StreamingSynthesizeResponse, error)
	grpc.ClientStream
}

type textToSpeechStreamingSynthesizeClient struct {
	grpc.ClientStream
}

func (x *textToSpeechStreamingSynthesizeClient) Send(m *StreamingSynthesizeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *textToSpeechStreamingSynthesizeClient) Recv() (*StreamingSynthesizeResponse, error) {
	m := new(StreamingSynthesizeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TextToSpeechServer is the server API for TextToSpeech service.
type TextToSpeechServer interface {
	// Returns a list of Voice supported for synthesis.
	ListVoices(context.Context, *ListVoicesRequest) (*ListVoicesResponse, error)
	// Synthesizes speech synchronously: receive results after all text input
	// has been processed.
	SynthesizeSpeech(context.Context, *SynthesizeSpeechRequest) (*SynthesizeSpeechResponse, error)
	// Performs bidirectional streaming speech synthesis: receives audio while
	// sending text.
	StreamingSynthesize(TextToSpeech_StreamingSynthesizeServer) error
}

// UnimplementedTextToSpeechServer can be embedded to have forward compatible implementations.
type UnimplementedTextToSpeechServer struct {
}

func (*UnimplementedTextToSpeechServer) ListVoices(context.Context, *ListVoicesRequest) (*ListVoicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVoices not implemented")
}
func (*UnimplementedTextToSpeechServer) SynthesizeSpeech(context.Context, *SynthesizeSpeechRequest) (*SynthesizeSpeechResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SynthesizeSpeech not implemented")
}
func (*UnimplementedTextToSpeechServer) StreamingSynthesize(TextToSpeech_StreamingSynthesizeServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingSynthesize not implemented")
}

func RegisterTextToSpeechServer(s *grpc.Server, srv TextToSpeechServer) {
	s.RegisterService(&_TextToSpeech_serviceDesc, srv)
}

func _TextToSpeech_ListVoices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVoicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TextToSpeechServer).ListVoices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.texttospeech.v1.TextToSpeech/ListVoices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TextToSpeechServer).ListVoices(ctx, req.(*ListVoicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TextToSpeech_SynthesizeSpeech_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SynthesizeSpeechRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TextToSpeechServer).SynthesizeSpeech(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.texttospeech.v1.TextToSpeech/SynthesizeSpeech",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TextToSpeechServer).SynthesizeSpeech(ctx, req.(*SynthesizeSpeechRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TextToSpeech_StreamingSynthesize_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(TextToSpeechServer).StreamingSynthesize(&textToSpeechStreamingSynthesizeServer{stream})
}

type TextToSpeech_StreamingSynthesizeServer interface {
	Send(*StreamingSynthesizeResponse) error
	Recv() (*StreamingSynthesizeRequest, error)
	grpc.ServerStream
}

type textToSpeechStreamingSynthesizeServer struct {
	grpc.ServerStream
}

func (x *textToSpeechStreamingSynthesizeServer) Send(m *StreamingSynthesizeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *textToSpeechStreamingSynthesizeServer) Recv() (*StreamingSynthesizeRequest, error) {
	m := new(StreamingSynthesizeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _TextToSpeech_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.texttospeech.v1.TextToSpeech",
	HandlerType: (*TextToSpeechServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListVoices",
			Handler:    _TextToSpeech_ListVoices_Handler,
		},
		{
			MethodName: "SynthesizeSpeech",
			Handler:    _TextToSpeech_SynthesizeSpeech_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingSynthesize",
			Handler:       _TextToSpeech_StreamingSynthesize_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/texttospeech/v1/cloud_tts.proto",
}
