// Copyright 2020 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: gapic/metadata/gapic_metadata.proto

package metadata

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Metadata about a GAPIC library service for a specific combination of API,
// version, and computer language.
type GapicMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Schema version of this proto. Current value: 1.0
	Schema string `protobuf:"bytes,1,opt,name=schema,proto3" json:"schema,omitempty"`
	// Any human-readable comments to be included in this file.
	Comment string `protobuf:"bytes,2,opt,name=comment,proto3" json:"comment,omitempty"`
	// Computer language of this generated language. This must be
	// spelled out as it spoken in English, with no capitalization or
	// separators (e.g. "csharp", "nodejs").
	Language string `protobuf:"bytes,3,opt,name=language,proto3" json:"language,omitempty"`
	// The proto package containing the API definition for which this
	// GAPIC library was generated.
	ProtoPackage string `protobuf:"bytes,4,opt,name=proto_package,json=protoPackage,proto3" json:"proto_package,omitempty"`
	// The language-specific library package for this GAPIC library.
	LibraryPackage string `protobuf:"bytes,5,opt,name=library_package,json=libraryPackage,proto3" json:"library_package,omitempty"`
	// A map from each proto-defined service to ServiceForTransports,
	// which allows listing information about transport-specific
	// implementations of the service.
	//
	// The key is the name of the service as it appears in the .proto
	// file.
	Services map[string]*GapicMetadata_ServiceForTransport `protobuf:"bytes,6,rep,name=services,proto3" json:"services,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *GapicMetadata) Reset() {
	*x = GapicMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gapic_metadata_gapic_metadata_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GapicMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GapicMetadata) ProtoMessage() {}

func (x *GapicMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_gapic_metadata_gapic_metadata_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GapicMetadata.ProtoReflect.Descriptor instead.
func (*GapicMetadata) Descriptor() ([]byte, []int) {
	return file_gapic_metadata_gapic_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *GapicMetadata) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

func (x *GapicMetadata) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

func (x *GapicMetadata) GetLanguage() string {
	if x != nil {
		return x.Language
	}
	return ""
}

func (x *GapicMetadata) GetProtoPackage() string {
	if x != nil {
		return x.ProtoPackage
	}
	return ""
}

func (x *GapicMetadata) GetLibraryPackage() string {
	if x != nil {
		return x.LibraryPackage
	}
	return ""
}

func (x *GapicMetadata) GetServices() map[string]*GapicMetadata_ServiceForTransport {
	if x != nil {
		return x.Services
	}
	return nil
}

// A map from a transport name to ServiceAsClient, which allows
// listing information about the client objects that implement the
// parent RPC service for the specified transport.
type GapicMetadata_ServiceForTransport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of transport name to ServiceAsClient. The key name is the transport,
	// lower-cased with no separators (e.g. "grpc", "rest").
	Clients map[string]*GapicMetadata_ServiceAsClient `protobuf:"bytes,1,rep,name=clients,proto3" json:"clients,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The API version for the interface definition found in the
	// `google.api.api_version` annotation of this proto-defined service during
	// code generation.
	// This is the value populated by the client in the API version request
	// parameter as per
	// [AIP-4236](https://google.aip.dev/client-libraries/4236).
	ApiVersion string `protobuf:"bytes,2,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *GapicMetadata_ServiceForTransport) Reset() {
	*x = GapicMetadata_ServiceForTransport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gapic_metadata_gapic_metadata_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GapicMetadata_ServiceForTransport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GapicMetadata_ServiceForTransport) ProtoMessage() {}

func (x *GapicMetadata_ServiceForTransport) ProtoReflect() protoreflect.Message {
	mi := &file_gapic_metadata_gapic_metadata_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GapicMetadata_ServiceForTransport.ProtoReflect.Descriptor instead.
func (*GapicMetadata_ServiceForTransport) Descriptor() ([]byte, []int) {
	return file_gapic_metadata_gapic_metadata_proto_rawDescGZIP(), []int{0, 1}
}

func (x *GapicMetadata_ServiceForTransport) GetClients() map[string]*GapicMetadata_ServiceAsClient {
	if x != nil {
		return x.Clients
	}
	return nil
}

func (x *GapicMetadata_ServiceForTransport) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Information about a specific client implementing a proto-defined service.
type GapicMetadata_ServiceAsClient struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the library client formatted as it appears in the source code
	LibraryClient string `protobuf:"bytes,1,opt,name=library_client,json=libraryClient,proto3" json:"library_client,omitempty"`
	// A mapping from each proto-defined RPC name to the the list of
	// methods in library_client that implement it. There can be more
	// than one library_client method for each RPC. RPCs with no
	// library_client methods need not be included.
	//
	// The key name is the name of the RPC as defined and formatted in
	// the proto file.
	Rpcs map[string]*GapicMetadata_MethodList `protobuf:"bytes,2,rep,name=rpcs,proto3" json:"rpcs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *GapicMetadata_ServiceAsClient) Reset() {
	*x = GapicMetadata_ServiceAsClient{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gapic_metadata_gapic_metadata_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GapicMetadata_ServiceAsClient) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GapicMetadata_ServiceAsClient) ProtoMessage() {}

func (x *GapicMetadata_ServiceAsClient) ProtoReflect() protoreflect.Message {
	mi := &file_gapic_metadata_gapic_metadata_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GapicMetadata_ServiceAsClient.ProtoReflect.Descriptor instead.
func (*GapicMetadata_ServiceAsClient) Descriptor() ([]byte, []int) {
	return file_gapic_metadata_gapic_metadata_proto_rawDescGZIP(), []int{0, 2}
}

func (x *GapicMetadata_ServiceAsClient) GetLibraryClient() string {
	if x != nil {
		return x.LibraryClient
	}
	return ""
}

func (x *GapicMetadata_ServiceAsClient) GetRpcs() map[string]*GapicMetadata_MethodList {
	if x != nil {
		return x.Rpcs
	}
	return nil
}

// List of GAPIC client methods implementing the proto-defined RPC
// for the transport and service specified in the containing
// structures.
type GapicMetadata_MethodList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of methods for a specific proto-service client in the
	// GAPIC. These names should be formatted as they appear in the
	// source code.
	Methods []string `protobuf:"bytes,1,rep,name=methods,proto3" json:"methods,omitempty"`
}

func (x *GapicMetadata_MethodList) Reset() {
	*x = GapicMetadata_MethodList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_gapic_metadata_gapic_metadata_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GapicMetadata_MethodList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GapicMetadata_MethodList) ProtoMessage() {}

func (x *GapicMetadata_MethodList) ProtoReflect() protoreflect.Message {
	mi := &file_gapic_metadata_gapic_metadata_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GapicMetadata_MethodList.ProtoReflect.Descriptor instead.
func (*GapicMetadata_MethodList) Descriptor() ([]byte, []int) {
	return file_gapic_metadata_gapic_metadata_proto_rawDescGZIP(), []int{0, 3}
}

func (x *GapicMetadata_MethodList) GetMethods() []string {
	if x != nil {
		return x.Methods
	}
	return nil
}

var File_gapic_metadata_gapic_metadata_proto protoreflect.FileDescriptor

var file_gapic_metadata_gapic_metadata_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x61, 0x70, 0x69, 0x63, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2f, 0x67, 0x61, 0x70, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x61,
	0x70, 0x69, 0x63, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x9f, 0x07, 0x0a,
	0x0d, 0x47, 0x61, 0x70, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x4e, 0x0a, 0x08, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x61, 0x70, 0x69, 0x63, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x47, 0x61, 0x70, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x75, 0x0a, 0x0d, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4e, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x61, 0x70, 0x69, 0x63, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x47, 0x61, 0x70, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x46, 0x6f, 0x72, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x89, 0x02, 0x0a, 0x13, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x46, 0x6f, 0x72,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x5f, 0x0a, 0x07, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x61, 0x70, 0x69, 0x63, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x47, 0x61, 0x70, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x46, 0x6f, 0x72, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x07, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x70,
	0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x70, 0x0a, 0x0c, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4a, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x61, 0x70, 0x69, 0x63, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x47, 0x61, 0x70, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x73, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xf6, 0x01,
	0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x73, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x04, 0x72, 0x70, 0x63, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x61, 0x70, 0x69, 0x63, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x47,
	0x61, 0x70, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x73, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x70, 0x63,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x72, 0x70, 0x63, 0x73, 0x1a, 0x68, 0x0a, 0x09,
	0x52, 0x70, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x45, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x61, 0x70, 0x69, 0x63, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x47, 0x61, 0x70, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x26, 0x0a, 0x0a, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x4c, 0x69, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x42, 0xba,
	0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x61,
	0x70, 0x69, 0x63, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x12, 0x47, 0x61,
	0x70, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x67, 0x61, 0x70, 0x69, 0x63, 0x2f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x3b, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xaa, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x47, 0x61, 0x70, 0x69, 0x63,
	0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x47, 0x61, 0x70, 0x69, 0x63, 0x5c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xea, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x47, 0x61, 0x70, 0x69,
	0x63, 0x3a, 0x3a, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_gapic_metadata_gapic_metadata_proto_rawDescOnce sync.Once
	file_gapic_metadata_gapic_metadata_proto_rawDescData = file_gapic_metadata_gapic_metadata_proto_rawDesc
)

func file_gapic_metadata_gapic_metadata_proto_rawDescGZIP() []byte {
	file_gapic_metadata_gapic_metadata_proto_rawDescOnce.Do(func() {
		file_gapic_metadata_gapic_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_gapic_metadata_gapic_metadata_proto_rawDescData)
	})
	return file_gapic_metadata_gapic_metadata_proto_rawDescData
}

var file_gapic_metadata_gapic_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_gapic_metadata_gapic_metadata_proto_goTypes = []interface{}{
	(*GapicMetadata)(nil), // 0: google.gapic.metadata.GapicMetadata
	nil,                   // 1: google.gapic.metadata.GapicMetadata.ServicesEntry
	(*GapicMetadata_ServiceForTransport)(nil), // 2: google.gapic.metadata.GapicMetadata.ServiceForTransport
	(*GapicMetadata_ServiceAsClient)(nil),     // 3: google.gapic.metadata.GapicMetadata.ServiceAsClient
	(*GapicMetadata_MethodList)(nil),          // 4: google.gapic.metadata.GapicMetadata.MethodList
	nil,                                       // 5: google.gapic.metadata.GapicMetadata.ServiceForTransport.ClientsEntry
	nil,                                       // 6: google.gapic.metadata.GapicMetadata.ServiceAsClient.RpcsEntry
}
var file_gapic_metadata_gapic_metadata_proto_depIdxs = []int32{
	1, // 0: google.gapic.metadata.GapicMetadata.services:type_name -> google.gapic.metadata.GapicMetadata.ServicesEntry
	2, // 1: google.gapic.metadata.GapicMetadata.ServicesEntry.value:type_name -> google.gapic.metadata.GapicMetadata.ServiceForTransport
	5, // 2: google.gapic.metadata.GapicMetadata.ServiceForTransport.clients:type_name -> google.gapic.metadata.GapicMetadata.ServiceForTransport.ClientsEntry
	6, // 3: google.gapic.metadata.GapicMetadata.ServiceAsClient.rpcs:type_name -> google.gapic.metadata.GapicMetadata.ServiceAsClient.RpcsEntry
	3, // 4: google.gapic.metadata.GapicMetadata.ServiceForTransport.ClientsEntry.value:type_name -> google.gapic.metadata.GapicMetadata.ServiceAsClient
	4, // 5: google.gapic.metadata.GapicMetadata.ServiceAsClient.RpcsEntry.value:type_name -> google.gapic.metadata.GapicMetadata.MethodList
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_gapic_metadata_gapic_metadata_proto_init() }
func file_gapic_metadata_gapic_metadata_proto_init() {
	if File_gapic_metadata_gapic_metadata_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_gapic_metadata_gapic_metadata_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GapicMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gapic_metadata_gapic_metadata_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GapicMetadata_ServiceForTransport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gapic_metadata_gapic_metadata_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GapicMetadata_ServiceAsClient); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_gapic_metadata_gapic_metadata_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GapicMetadata_MethodList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_gapic_metadata_gapic_metadata_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_gapic_metadata_gapic_metadata_proto_goTypes,
		DependencyIndexes: file_gapic_metadata_gapic_metadata_proto_depIdxs,
		MessageInfos:      file_gapic_metadata_gapic_metadata_proto_msgTypes,
	}.Build()
	File_gapic_metadata_gapic_metadata_proto = out.File
	file_gapic_metadata_gapic_metadata_proto_rawDesc = nil
	file_gapic_metadata_gapic_metadata_proto_goTypes = nil
	file_gapic_metadata_gapic_metadata_proto_depIdxs = nil
}
