// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1/vertex_rag_service.proto

package aiplatformpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	VertexRagService_RetrieveContexts_FullMethodName   = "/google.cloud.aiplatform.v1.VertexRagService/RetrieveContexts"
	VertexRagService_AugmentPrompt_FullMethodName      = "/google.cloud.aiplatform.v1.VertexRagService/AugmentPrompt"
	VertexRagService_CorroborateContent_FullMethodName = "/google.cloud.aiplatform.v1.VertexRagService/CorroborateContent"
)

// VertexRagServiceClient is the client API for VertexRagService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type VertexRagServiceClient interface {
	// Retrieves relevant contexts for a query.
	RetrieveContexts(ctx context.Context, in *RetrieveContextsRequest, opts ...grpc.CallOption) (*RetrieveContextsResponse, error)
	// Given an input prompt, it returns augmented prompt from vertex rag store
	//
	//	to guide LLM towards generating grounded responses.
	AugmentPrompt(ctx context.Context, in *AugmentPromptRequest, opts ...grpc.CallOption) (*AugmentPromptResponse, error)
	// Given an input text, it returns a score that evaluates the factuality of
	// the text. It also extracts and returns claims from the text and provides
	// supporting facts.
	CorroborateContent(ctx context.Context, in *CorroborateContentRequest, opts ...grpc.CallOption) (*CorroborateContentResponse, error)
}

type vertexRagServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVertexRagServiceClient(cc grpc.ClientConnInterface) VertexRagServiceClient {
	return &vertexRagServiceClient{cc}
}

func (c *vertexRagServiceClient) RetrieveContexts(ctx context.Context, in *RetrieveContextsRequest, opts ...grpc.CallOption) (*RetrieveContextsResponse, error) {
	out := new(RetrieveContextsResponse)
	err := c.cc.Invoke(ctx, VertexRagService_RetrieveContexts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagServiceClient) AugmentPrompt(ctx context.Context, in *AugmentPromptRequest, opts ...grpc.CallOption) (*AugmentPromptResponse, error) {
	out := new(AugmentPromptResponse)
	err := c.cc.Invoke(ctx, VertexRagService_AugmentPrompt_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagServiceClient) CorroborateContent(ctx context.Context, in *CorroborateContentRequest, opts ...grpc.CallOption) (*CorroborateContentResponse, error) {
	out := new(CorroborateContentResponse)
	err := c.cc.Invoke(ctx, VertexRagService_CorroborateContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VertexRagServiceServer is the server API for VertexRagService service.
// All implementations should embed UnimplementedVertexRagServiceServer
// for forward compatibility
type VertexRagServiceServer interface {
	// Retrieves relevant contexts for a query.
	RetrieveContexts(context.Context, *RetrieveContextsRequest) (*RetrieveContextsResponse, error)
	// Given an input prompt, it returns augmented prompt from vertex rag store
	//
	//	to guide LLM towards generating grounded responses.
	AugmentPrompt(context.Context, *AugmentPromptRequest) (*AugmentPromptResponse, error)
	// Given an input text, it returns a score that evaluates the factuality of
	// the text. It also extracts and returns claims from the text and provides
	// supporting facts.
	CorroborateContent(context.Context, *CorroborateContentRequest) (*CorroborateContentResponse, error)
}

// UnimplementedVertexRagServiceServer should be embedded to have forward compatible implementations.
type UnimplementedVertexRagServiceServer struct {
}

func (UnimplementedVertexRagServiceServer) RetrieveContexts(context.Context, *RetrieveContextsRequest) (*RetrieveContextsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveContexts not implemented")
}
func (UnimplementedVertexRagServiceServer) AugmentPrompt(context.Context, *AugmentPromptRequest) (*AugmentPromptResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AugmentPrompt not implemented")
}
func (UnimplementedVertexRagServiceServer) CorroborateContent(context.Context, *CorroborateContentRequest) (*CorroborateContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CorroborateContent not implemented")
}

// UnsafeVertexRagServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VertexRagServiceServer will
// result in compilation errors.
type UnsafeVertexRagServiceServer interface {
	mustEmbedUnimplementedVertexRagServiceServer()
}

func RegisterVertexRagServiceServer(s grpc.ServiceRegistrar, srv VertexRagServiceServer) {
	s.RegisterService(&VertexRagService_ServiceDesc, srv)
}

func _VertexRagService_RetrieveContexts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveContextsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagServiceServer).RetrieveContexts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagService_RetrieveContexts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagServiceServer).RetrieveContexts(ctx, req.(*RetrieveContextsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagService_AugmentPrompt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AugmentPromptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagServiceServer).AugmentPrompt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagService_AugmentPrompt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagServiceServer).AugmentPrompt(ctx, req.(*AugmentPromptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagService_CorroborateContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CorroborateContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagServiceServer).CorroborateContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagService_CorroborateContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagServiceServer).CorroborateContent(ctx, req.(*CorroborateContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// VertexRagService_ServiceDesc is the grpc.ServiceDesc for VertexRagService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var VertexRagService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.VertexRagService",
	HandlerType: (*VertexRagServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RetrieveContexts",
			Handler:    _VertexRagService_RetrieveContexts_Handler,
		},
		{
			MethodName: "AugmentPrompt",
			Handler:    _VertexRagService_AugmentPrompt_Handler,
		},
		{
			MethodName: "CorroborateContent",
			Handler:    _VertexRagService_CorroborateContent_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/vertex_rag_service.proto",
}
