// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an entry in a transit gateway metering policy to define traffic
// measurement rules.
func (c *Client) CreateTransitGatewayMeteringPolicyEntry(ctx context.Context, params *CreateTransitGatewayMeteringPolicyEntryInput, optFns ...func(*Options)) (*CreateTransitGatewayMeteringPolicyEntryOutput, error) {
	if params == nil {
		params = &CreateTransitGatewayMeteringPolicyEntryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateTransitGatewayMeteringPolicyEntry", params, optFns, c.addOperationCreateTransitGatewayMeteringPolicyEntryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateTransitGatewayMeteringPolicyEntryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateTransitGatewayMeteringPolicyEntryInput struct {

	// The Amazon Web Services account ID to which the metered traffic should be
	// attributed.
	//
	// This member is required.
	MeteredAccount types.TransitGatewayMeteringPayerType

	// The rule number for the metering policy entry. Rules are processed in order
	// from lowest to highest number.
	//
	// This member is required.
	PolicyRuleNumber *int32

	// The ID of the transit gateway metering policy to add the entry to.
	//
	// This member is required.
	TransitGatewayMeteringPolicyId *string

	// The destination CIDR block for traffic matching.
	DestinationCidrBlock *string

	// The destination port range for traffic matching.
	DestinationPortRange *string

	// The ID of the destination transit gateway attachment for traffic matching.
	DestinationTransitGatewayAttachmentId *string

	// The type of the destination transit gateway attachment for traffic matching.
	// Note that the tgw-peering resource type has been deprecated. To configure
	// metering policies for Connect, use the transport attachment type.
	DestinationTransitGatewayAttachmentType types.TransitGatewayAttachmentResourceType

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The protocol for traffic matching (1, 6, 17, etc.).
	Protocol *string

	// The source CIDR block for traffic matching.
	SourceCidrBlock *string

	// The source port range for traffic matching.
	SourcePortRange *string

	// The ID of the source transit gateway attachment for traffic matching.
	SourceTransitGatewayAttachmentId *string

	// The type of the source transit gateway attachment for traffic matching. Note
	// that the tgw-peering resource type has been deprecated. To configure metering
	// policies for Connect, use the transport attachment type.
	SourceTransitGatewayAttachmentType types.TransitGatewayAttachmentResourceType

	noSmithyDocumentSerde
}

type CreateTransitGatewayMeteringPolicyEntryOutput struct {

	// Information about the created transit gateway metering policy entry.
	TransitGatewayMeteringPolicyEntry *types.TransitGatewayMeteringPolicyEntry

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateTransitGatewayMeteringPolicyEntryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpCreateTransitGatewayMeteringPolicyEntry{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpCreateTransitGatewayMeteringPolicyEntry{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateTransitGatewayMeteringPolicyEntry"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateTransitGatewayMeteringPolicyEntryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateTransitGatewayMeteringPolicyEntry(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateTransitGatewayMeteringPolicyEntry(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateTransitGatewayMeteringPolicyEntry",
	}
}
