// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/memory_bank_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Actions that can be performed on a Memory.
type GenerateMemoriesResponse_GeneratedMemory_Action int32

const (
	// Action is unspecified.
	GenerateMemoriesResponse_GeneratedMemory_ACTION_UNSPECIFIED GenerateMemoriesResponse_GeneratedMemory_Action = 0
	// The memory was created.
	GenerateMemoriesResponse_GeneratedMemory_CREATED GenerateMemoriesResponse_GeneratedMemory_Action = 1
	// The memory was updated. The `fact` field may not be updated if the
	// existing fact is still accurate.
	GenerateMemoriesResponse_GeneratedMemory_UPDATED GenerateMemoriesResponse_GeneratedMemory_Action = 2
	// The memory was deleted.
	GenerateMemoriesResponse_GeneratedMemory_DELETED GenerateMemoriesResponse_GeneratedMemory_Action = 3
)

// Enum value maps for GenerateMemoriesResponse_GeneratedMemory_Action.
var (
	GenerateMemoriesResponse_GeneratedMemory_Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "CREATED",
		2: "UPDATED",
		3: "DELETED",
	}
	GenerateMemoriesResponse_GeneratedMemory_Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"CREATED":            1,
		"UPDATED":            2,
		"DELETED":            3,
	}
)

func (x GenerateMemoriesResponse_GeneratedMemory_Action) Enum() *GenerateMemoriesResponse_GeneratedMemory_Action {
	p := new(GenerateMemoriesResponse_GeneratedMemory_Action)
	*p = x
	return p
}

func (x GenerateMemoriesResponse_GeneratedMemory_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateMemoriesResponse_GeneratedMemory_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_enumTypes[0].Descriptor()
}

func (GenerateMemoriesResponse_GeneratedMemory_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_enumTypes[0]
}

func (x GenerateMemoriesResponse_GeneratedMemory_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateMemoriesResponse_GeneratedMemory_Action.Descriptor instead.
func (GenerateMemoriesResponse_GeneratedMemory_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{10, 0, 0}
}

// Request message for
// [MemoryBankService.CreateMemory][google.cloud.aiplatform.v1beta1.MemoryBankService.CreateMemory].
type CreateMemoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the ReasoningEngine to create the Memory
	// under. Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Memory to be created.
	Memory *Memory `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
}

func (x *CreateMemoryRequest) Reset() {
	*x = CreateMemoryRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMemoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMemoryRequest) ProtoMessage() {}

func (x *CreateMemoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMemoryRequest.ProtoReflect.Descriptor instead.
func (*CreateMemoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateMemoryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMemoryRequest) GetMemory() *Memory {
	if x != nil {
		return x.Memory
	}
	return nil
}

// Details of
// [MemoryBankService.CreateMemory][google.cloud.aiplatform.v1beta1.MemoryBankService.CreateMemory]
// operation.
type CreateMemoryOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateMemoryOperationMetadata) Reset() {
	*x = CreateMemoryOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMemoryOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMemoryOperationMetadata) ProtoMessage() {}

func (x *CreateMemoryOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMemoryOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateMemoryOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateMemoryOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [MemoryBankService.GetMemory][google.cloud.aiplatform.v1beta1.MemoryBankService.GetMemory].
type GetMemoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Memory.
	// Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/memories/{memory}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMemoryRequest) Reset() {
	*x = GetMemoryRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMemoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMemoryRequest) ProtoMessage() {}

func (x *GetMemoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMemoryRequest.ProtoReflect.Descriptor instead.
func (*GetMemoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetMemoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [MemoryBankService.UpdateMemory][google.cloud.aiplatform.v1beta1.MemoryBankService.UpdateMemory].
type UpdateMemoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Memory which replaces the resource on the server.
	Memory *Memory `protobuf:"bytes,1,opt,name=memory,proto3" json:"memory,omitempty"`
	// Optional. Mask specifying which fields to update.
	// Supported fields:
	//
	//   - `display_name`
	//   - `description`
	//   - `fact`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateMemoryRequest) Reset() {
	*x = UpdateMemoryRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateMemoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMemoryRequest) ProtoMessage() {}

func (x *UpdateMemoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMemoryRequest.ProtoReflect.Descriptor instead.
func (*UpdateMemoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateMemoryRequest) GetMemory() *Memory {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *UpdateMemoryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Details of
// [MemoryBankService.UpdateMemory][google.cloud.aiplatform.v1beta1.MemoryBankService.UpdateMemory]
// operation.
type UpdateMemoryOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *UpdateMemoryOperationMetadata) Reset() {
	*x = UpdateMemoryOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateMemoryOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMemoryOperationMetadata) ProtoMessage() {}

func (x *UpdateMemoryOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMemoryOperationMetadata.ProtoReflect.Descriptor instead.
func (*UpdateMemoryOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateMemoryOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [MemoryBankService.ListMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.ListMemories].
type ListMemoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the ReasoningEngine to list the Memories
	// under. Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The standard list filter.
	// More detail in [AIP-160](https://google.aip.dev/160).
	//
	// Supported fields (equality match only):
	//   - `scope` (as a JSON string)
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The standard list page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMemoriesRequest) Reset() {
	*x = ListMemoriesRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMemoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMemoriesRequest) ProtoMessage() {}

func (x *ListMemoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMemoriesRequest.ProtoReflect.Descriptor instead.
func (*ListMemoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListMemoriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMemoriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListMemoriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMemoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [MemoryBankService.ListMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.ListMemories].
type ListMemoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of Memories in the requested page.
	Memories []*Memory `protobuf:"bytes,1,rep,name=memories,proto3" json:"memories,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListMemoriesRequest.page_token][google.cloud.aiplatform.v1beta1.ListMemoriesRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMemoriesResponse) Reset() {
	*x = ListMemoriesResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMemoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMemoriesResponse) ProtoMessage() {}

func (x *ListMemoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMemoriesResponse.ProtoReflect.Descriptor instead.
func (*ListMemoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListMemoriesResponse) GetMemories() []*Memory {
	if x != nil {
		return x.Memories
	}
	return nil
}

func (x *ListMemoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [MemoryBankService.DeleteMemory][google.cloud.aiplatform.v1beta1.MemoryBankService.DeleteMemory].
type DeleteMemoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Memory to delete.
	// Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/memories/{memory}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMemoryRequest) Reset() {
	*x = DeleteMemoryRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteMemoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMemoryRequest) ProtoMessage() {}

func (x *DeleteMemoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMemoryRequest.ProtoReflect.Descriptor instead.
func (*DeleteMemoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteMemoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Details of
// [MemoryBankService.DeleteMemory][google.cloud.aiplatform.v1beta1.MemoryBankService.DeleteMemory]
// operation.
type DeleteMemoryOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *DeleteMemoryOperationMetadata) Reset() {
	*x = DeleteMemoryOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteMemoryOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMemoryOperationMetadata) ProtoMessage() {}

func (x *DeleteMemoryOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMemoryOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteMemoryOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteMemoryOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [MemoryBankService.GenerateMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.GenerateMemories].
type GenerateMemoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source content used to generate memories.
	//
	// Types that are assignable to Source:
	//
	//	*GenerateMemoriesRequest_VertexSessionSource_
	//	*GenerateMemoriesRequest_DirectContentsSource_
	Source isGenerateMemoriesRequest_Source `protobuf_oneof:"source"`
	// Required. The resource name of the ReasoningEngine to generate memories
	// for. Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If true, generated memories will not be consolidated with
	// existing memories; all generated memories will be added as new memories
	// regardless of whether they are duplicates of or contradictory to existing
	// memories. By default, memory consolidation is enabled.
	DisableConsolidation bool `protobuf:"varint,4,opt,name=disable_consolidation,json=disableConsolidation,proto3" json:"disable_consolidation,omitempty"`
	// Optional. The scope of the memories that should be generated. Memories will
	// be consolidated across memories with the same scope. Must be provided
	// unless the scope is defined in the source content. If `scope` is provided,
	// it will override the scope defined in the source content. Scope values
	// cannot contain the wildcard character '*'.
	Scope map[string]string `protobuf:"bytes,8,rep,name=scope,proto3" json:"scope,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *GenerateMemoriesRequest) Reset() {
	*x = GenerateMemoriesRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateMemoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateMemoriesRequest) ProtoMessage() {}

func (x *GenerateMemoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateMemoriesRequest.ProtoReflect.Descriptor instead.
func (*GenerateMemoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{9}
}

func (m *GenerateMemoriesRequest) GetSource() isGenerateMemoriesRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *GenerateMemoriesRequest) GetVertexSessionSource() *GenerateMemoriesRequest_VertexSessionSource {
	if x, ok := x.GetSource().(*GenerateMemoriesRequest_VertexSessionSource_); ok {
		return x.VertexSessionSource
	}
	return nil
}

func (x *GenerateMemoriesRequest) GetDirectContentsSource() *GenerateMemoriesRequest_DirectContentsSource {
	if x, ok := x.GetSource().(*GenerateMemoriesRequest_DirectContentsSource_); ok {
		return x.DirectContentsSource
	}
	return nil
}

func (x *GenerateMemoriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GenerateMemoriesRequest) GetDisableConsolidation() bool {
	if x != nil {
		return x.DisableConsolidation
	}
	return false
}

func (x *GenerateMemoriesRequest) GetScope() map[string]string {
	if x != nil {
		return x.Scope
	}
	return nil
}

type isGenerateMemoriesRequest_Source interface {
	isGenerateMemoriesRequest_Source()
}

type GenerateMemoriesRequest_VertexSessionSource_ struct {
	// Defines a Vertex Session as the source content from which to generate
	// memories.
	VertexSessionSource *GenerateMemoriesRequest_VertexSessionSource `protobuf:"bytes,2,opt,name=vertex_session_source,json=vertexSessionSource,proto3,oneof"`
}

type GenerateMemoriesRequest_DirectContentsSource_ struct {
	// Defines a direct source of content as the source content from which to
	// generate memories.
	DirectContentsSource *GenerateMemoriesRequest_DirectContentsSource `protobuf:"bytes,3,opt,name=direct_contents_source,json=directContentsSource,proto3,oneof"`
}

func (*GenerateMemoriesRequest_VertexSessionSource_) isGenerateMemoriesRequest_Source() {}

func (*GenerateMemoriesRequest_DirectContentsSource_) isGenerateMemoriesRequest_Source() {}

// Response message for
// [MemoryBankService.GenerateMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.GenerateMemories].
type GenerateMemoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generated memories.
	GeneratedMemories []*GenerateMemoriesResponse_GeneratedMemory `protobuf:"bytes,1,rep,name=generated_memories,json=generatedMemories,proto3" json:"generated_memories,omitempty"`
}

func (x *GenerateMemoriesResponse) Reset() {
	*x = GenerateMemoriesResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateMemoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateMemoriesResponse) ProtoMessage() {}

func (x *GenerateMemoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateMemoriesResponse.ProtoReflect.Descriptor instead.
func (*GenerateMemoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{10}
}

func (x *GenerateMemoriesResponse) GetGeneratedMemories() []*GenerateMemoriesResponse_GeneratedMemory {
	if x != nil {
		return x.GeneratedMemories
	}
	return nil
}

// Details of
// [MemoryBankService.GenerateMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.GenerateMemories]
// operation.
type GenerateMemoriesOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *GenerateMemoriesOperationMetadata) Reset() {
	*x = GenerateMemoriesOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateMemoriesOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateMemoriesOperationMetadata) ProtoMessage() {}

func (x *GenerateMemoriesOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateMemoriesOperationMetadata.ProtoReflect.Descriptor instead.
func (*GenerateMemoriesOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{11}
}

func (x *GenerateMemoriesOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [MemoryBankService.RetrieveMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.RetrieveMemories].
type RetrieveMemoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parameters for retrieval.
	//
	// Types that are assignable to RetrievalParams:
	//
	//	*RetrieveMemoriesRequest_SimilaritySearchParams_
	//	*RetrieveMemoriesRequest_SimpleRetrievalParams_
	RetrievalParams isRetrieveMemoriesRequest_RetrievalParams `protobuf_oneof:"retrieval_params"`
	// Required. The resource name of the ReasoningEngine to retrieve memories
	// from. Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The scope of the memories to retrieve. A memory must have
	// exactly the same scope (`Memory.scope`) as the scope provided here to be
	// retrieved (same keys and values). Order does not matter, but it is
	// case-sensitive.
	Scope map[string]string `protobuf:"bytes,8,rep,name=scope,proto3" json:"scope,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RetrieveMemoriesRequest) Reset() {
	*x = RetrieveMemoriesRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrieveMemoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveMemoriesRequest) ProtoMessage() {}

func (x *RetrieveMemoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveMemoriesRequest.ProtoReflect.Descriptor instead.
func (*RetrieveMemoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{12}
}

func (m *RetrieveMemoriesRequest) GetRetrievalParams() isRetrieveMemoriesRequest_RetrievalParams {
	if m != nil {
		return m.RetrievalParams
	}
	return nil
}

func (x *RetrieveMemoriesRequest) GetSimilaritySearchParams() *RetrieveMemoriesRequest_SimilaritySearchParams {
	if x, ok := x.GetRetrievalParams().(*RetrieveMemoriesRequest_SimilaritySearchParams_); ok {
		return x.SimilaritySearchParams
	}
	return nil
}

func (x *RetrieveMemoriesRequest) GetSimpleRetrievalParams() *RetrieveMemoriesRequest_SimpleRetrievalParams {
	if x, ok := x.GetRetrievalParams().(*RetrieveMemoriesRequest_SimpleRetrievalParams_); ok {
		return x.SimpleRetrievalParams
	}
	return nil
}

func (x *RetrieveMemoriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *RetrieveMemoriesRequest) GetScope() map[string]string {
	if x != nil {
		return x.Scope
	}
	return nil
}

type isRetrieveMemoriesRequest_RetrievalParams interface {
	isRetrieveMemoriesRequest_RetrievalParams()
}

type RetrieveMemoriesRequest_SimilaritySearchParams_ struct {
	// Parameters for semantic similarity search based retrieval.
	SimilaritySearchParams *RetrieveMemoriesRequest_SimilaritySearchParams `protobuf:"bytes,6,opt,name=similarity_search_params,json=similaritySearchParams,proto3,oneof"`
}

type RetrieveMemoriesRequest_SimpleRetrievalParams_ struct {
	// Parameters for simple (non-similarity search) retrieval.
	SimpleRetrievalParams *RetrieveMemoriesRequest_SimpleRetrievalParams `protobuf:"bytes,7,opt,name=simple_retrieval_params,json=simpleRetrievalParams,proto3,oneof"`
}

func (*RetrieveMemoriesRequest_SimilaritySearchParams_) isRetrieveMemoriesRequest_RetrievalParams() {}

func (*RetrieveMemoriesRequest_SimpleRetrievalParams_) isRetrieveMemoriesRequest_RetrievalParams() {}

// Response message for
// [MemoryBankService.RetrieveMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.RetrieveMemories].
type RetrieveMemoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The retrieved memories.
	RetrievedMemories []*RetrieveMemoriesResponse_RetrievedMemory `protobuf:"bytes,1,rep,name=retrieved_memories,json=retrievedMemories,proto3" json:"retrieved_memories,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	// This token is not set if similarity search was used for retrieval.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *RetrieveMemoriesResponse) Reset() {
	*x = RetrieveMemoriesResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrieveMemoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveMemoriesResponse) ProtoMessage() {}

func (x *RetrieveMemoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveMemoriesResponse.ProtoReflect.Descriptor instead.
func (*RetrieveMemoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{13}
}

func (x *RetrieveMemoriesResponse) GetRetrievedMemories() []*RetrieveMemoriesResponse_RetrievedMemory {
	if x != nil {
		return x.RetrievedMemories
	}
	return nil
}

func (x *RetrieveMemoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Defines an Agent Engine Session from which to generate the memories. If
// `scope` is not provided, the scope will be extracted from the Session
// (i.e. {"user_id": sesison.user_id}).
type GenerateMemoriesRequest_VertexSessionSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Session to generate memories for.
	// Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Optional. Time range to define which session events should be used to
	// generate memories. Start time (inclusive) of the time range. If not set,
	// the start time is unbounded.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional. End time (exclusive) of the time range. If not set, the end
	// time is unbounded.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *GenerateMemoriesRequest_VertexSessionSource) Reset() {
	*x = GenerateMemoriesRequest_VertexSessionSource{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateMemoriesRequest_VertexSessionSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateMemoriesRequest_VertexSessionSource) ProtoMessage() {}

func (x *GenerateMemoriesRequest_VertexSessionSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateMemoriesRequest_VertexSessionSource.ProtoReflect.Descriptor instead.
func (*GenerateMemoriesRequest_VertexSessionSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{9, 0}
}

func (x *GenerateMemoriesRequest_VertexSessionSource) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *GenerateMemoriesRequest_VertexSessionSource) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *GenerateMemoriesRequest_VertexSessionSource) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Defines a direct source of content from which to generate the memories.
type GenerateMemoriesRequest_DirectContentsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The source content (i.e. chat history) to generate memories
	// from.
	Events []*GenerateMemoriesRequest_DirectContentsSource_Event `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
}

func (x *GenerateMemoriesRequest_DirectContentsSource) Reset() {
	*x = GenerateMemoriesRequest_DirectContentsSource{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateMemoriesRequest_DirectContentsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateMemoriesRequest_DirectContentsSource) ProtoMessage() {}

func (x *GenerateMemoriesRequest_DirectContentsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateMemoriesRequest_DirectContentsSource.ProtoReflect.Descriptor instead.
func (*GenerateMemoriesRequest_DirectContentsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{9, 1}
}

func (x *GenerateMemoriesRequest_DirectContentsSource) GetEvents() []*GenerateMemoriesRequest_DirectContentsSource_Event {
	if x != nil {
		return x.Events
	}
	return nil
}

// A single piece of conversation from which to generate memories.
type GenerateMemoriesRequest_DirectContentsSource_Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A single piece of content from which to generate memories.
	Content *Content `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *GenerateMemoriesRequest_DirectContentsSource_Event) Reset() {
	*x = GenerateMemoriesRequest_DirectContentsSource_Event{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateMemoriesRequest_DirectContentsSource_Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateMemoriesRequest_DirectContentsSource_Event) ProtoMessage() {}

func (x *GenerateMemoriesRequest_DirectContentsSource_Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateMemoriesRequest_DirectContentsSource_Event.ProtoReflect.Descriptor instead.
func (*GenerateMemoriesRequest_DirectContentsSource_Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{9, 1, 0}
}

func (x *GenerateMemoriesRequest_DirectContentsSource_Event) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

// A memory generated by the operation.
type GenerateMemoriesResponse_GeneratedMemory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generated Memory.
	Memory *Memory `protobuf:"bytes,1,opt,name=memory,proto3" json:"memory,omitempty"`
	// The action that was performed on the Memory.
	Action GenerateMemoriesResponse_GeneratedMemory_Action `protobuf:"varint,2,opt,name=action,proto3,enum=google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse_GeneratedMemory_Action" json:"action,omitempty"`
}

func (x *GenerateMemoriesResponse_GeneratedMemory) Reset() {
	*x = GenerateMemoriesResponse_GeneratedMemory{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateMemoriesResponse_GeneratedMemory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateMemoriesResponse_GeneratedMemory) ProtoMessage() {}

func (x *GenerateMemoriesResponse_GeneratedMemory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateMemoriesResponse_GeneratedMemory.ProtoReflect.Descriptor instead.
func (*GenerateMemoriesResponse_GeneratedMemory) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{10, 0}
}

func (x *GenerateMemoriesResponse_GeneratedMemory) GetMemory() *Memory {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *GenerateMemoriesResponse_GeneratedMemory) GetAction() GenerateMemoriesResponse_GeneratedMemory_Action {
	if x != nil {
		return x.Action
	}
	return GenerateMemoriesResponse_GeneratedMemory_ACTION_UNSPECIFIED
}

// Parameters for semantic similarity search based retrieval.
type RetrieveMemoriesRequest_SimilaritySearchParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Query to use for similarity search retrieval. If provided, then
	// the parent ReasoningEngine must have
	// [ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig][google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig]
	// set.
	SearchQuery string `protobuf:"bytes,1,opt,name=search_query,json=searchQuery,proto3" json:"search_query,omitempty"`
	// Optional. The maximum number of memories to return.
	// The service may return fewer than this value. If unspecified, at most 3
	// memories will be returned. The maximum value is 100; values above 100
	// will be coerced to 100.
	TopK int32 `protobuf:"varint,2,opt,name=top_k,json=topK,proto3" json:"top_k,omitempty"`
}

func (x *RetrieveMemoriesRequest_SimilaritySearchParams) Reset() {
	*x = RetrieveMemoriesRequest_SimilaritySearchParams{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrieveMemoriesRequest_SimilaritySearchParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveMemoriesRequest_SimilaritySearchParams) ProtoMessage() {}

func (x *RetrieveMemoriesRequest_SimilaritySearchParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveMemoriesRequest_SimilaritySearchParams.ProtoReflect.Descriptor instead.
func (*RetrieveMemoriesRequest_SimilaritySearchParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{12, 0}
}

func (x *RetrieveMemoriesRequest_SimilaritySearchParams) GetSearchQuery() string {
	if x != nil {
		return x.SearchQuery
	}
	return ""
}

func (x *RetrieveMemoriesRequest_SimilaritySearchParams) GetTopK() int32 {
	if x != nil {
		return x.TopK
	}
	return 0
}

// Parameters for simple (non-similarity search) retrieval.
type RetrieveMemoriesRequest_SimpleRetrievalParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The maximum number of memories to return.
	// The service may return fewer than this value. If unspecified, at most 3
	// memories will be returned. The maximum value is 100; values above 100
	// will be coerced to 100.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `RetrieveMemories` call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *RetrieveMemoriesRequest_SimpleRetrievalParams) Reset() {
	*x = RetrieveMemoriesRequest_SimpleRetrievalParams{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrieveMemoriesRequest_SimpleRetrievalParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveMemoriesRequest_SimpleRetrievalParams) ProtoMessage() {}

func (x *RetrieveMemoriesRequest_SimpleRetrievalParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveMemoriesRequest_SimpleRetrievalParams.ProtoReflect.Descriptor instead.
func (*RetrieveMemoriesRequest_SimpleRetrievalParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{12, 1}
}

func (x *RetrieveMemoriesRequest_SimpleRetrievalParams) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *RetrieveMemoriesRequest_SimpleRetrievalParams) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A retrieved memory.
type RetrieveMemoriesResponse_RetrievedMemory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The retrieved Memory.
	Memory *Memory `protobuf:"bytes,1,opt,name=memory,proto3" json:"memory,omitempty"`
	// The distance between the query and the retrieved Memory. Smaller values
	// indicate more similar memories. This is only set if similarity search was
	// used for retrieval.
	Distance float64 `protobuf:"fixed64,2,opt,name=distance,proto3" json:"distance,omitempty"`
}

func (x *RetrieveMemoriesResponse_RetrievedMemory) Reset() {
	*x = RetrieveMemoriesResponse_RetrievedMemory{}
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrieveMemoriesResponse_RetrievedMemory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveMemoriesResponse_RetrievedMemory) ProtoMessage() {}

func (x *RetrieveMemoriesResponse_RetrievedMemory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveMemoriesResponse_RetrievedMemory.ProtoReflect.Descriptor instead.
func (*RetrieveMemoriesResponse_RetrievedMemory) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP(), []int{13, 0}
}

func (x *RetrieveMemoriesResponse_RetrievedMemory) GetMemory() *Memory {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *RetrieveMemoriesResponse_RetrievedMemory) GetDistance() float64 {
	if x != nil {
		return x.Distance
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_memory_bank_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x62, 0x61, 0x6e, 0x6b, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x62, 0x61, 0x6e, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa6, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x22, 0x85, 0x01, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x50, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x4d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x0a, 0x20, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x13, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x85, 0x01, 0x0a, 0x1d, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0xc3, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x6d, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x83, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x43, 0x0a, 0x08, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x53,
	0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x85, 0x08, 0x0a, 0x17,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x82, 0x01, 0x0a, 0x15, 0x76, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x13, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x85, 0x01, 0x0a,
	0x16, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x14,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x38, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x6f,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x14, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x73,
	0x6f, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x1a, 0xd6, 0x01, 0x0a, 0x13, 0x56, 0x65,
	0x72, 0x74, 0x65, 0x78, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x43, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x1a, 0xda, 0x01, 0x0a, 0x14, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x70, 0x0a, 0x06, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x50, 0x0a,
	0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x1a,
	0x38, 0x0a, 0x0a, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0x9c, 0x03, 0x0a, 0x18, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x78, 0x0a, 0x12, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x11, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x85, 0x02, 0x0a, 0x0f, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x3f,
	0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12,
	0x68, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0x0a, 0x06, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44,
	0x10, 0x03, 0x22, 0x89, 0x01, 0x0a, 0x21, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xe6,
	0x05, 0x0a, 0x17, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x8b, 0x01, 0x0a, 0x18, 0x73,
	0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x48, 0x00,
	0x52, 0x16, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x88, 0x01, 0x0a, 0x17, 0x73, 0x69, 0x6d,
	0x70, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x48, 0x00, 0x52, 0x15, 0x73, 0x69,
	0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5e,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x1a, 0x5a,
	0x0a, 0x16, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x18, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x4b, 0x1a, 0x5d, 0x0a, 0x15, 0x53, 0x69,
	0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0x38, 0x0a, 0x0a, 0x53, 0x63, 0x6f,
	0x70, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x42, 0x12, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xac, 0x02, 0x0a, 0x18, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x78, 0x0a, 0x12, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65,
	0x64, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x11, 0x72, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0x6e, 0x0a, 0x0f, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65,
	0x76, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x3f, 0x0a, 0x06, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x64, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x32, 0xe1, 0x10, 0x0a, 0x11, 0x4d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x42, 0x61, 0x6e, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x9e, 0x02, 0x0a,
	0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xb8, 0x01, 0xca, 0x41, 0x27, 0x0a, 0x06, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x12, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x87, 0x01, 0x3a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5a, 0x37,
	0x3a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0xee, 0x01,
	0x0a, 0x09, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x22, 0x84, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x77, 0x5a, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x44, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc1,
	0x02, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdb, 0x01, 0xca, 0x41, 0x27, 0x0a, 0x06, 0x4d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x12, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x12, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x95, 0x01, 0x3a, 0x06, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5a, 0x3e, 0x3a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x32,
	0x34, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x84, 0x02, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x6d, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x86, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x77, 0x5a, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x44, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0xa3, 0x02, 0x0a, 0x0c, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xbd, 0x01, 0xca, 0x41, 0x36, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x1d, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x77, 0x5a, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x44, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xcd, 0x02, 0x0a, 0x10, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdf, 0x01,
	0xca, 0x41, 0x3d, 0x0a, 0x18, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8f, 0x01,
	0x3a, 0x01, 0x2a, 0x5a, 0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x22, 0x4d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x12,
	0xa9, 0x02, 0x0a, 0x10, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4d, 0x65, 0x6d, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4d,
	0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9f, 0x01, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8f, 0x01, 0x3a, 0x01, 0x2a, 0x5a,
	0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x3a, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x22, 0x4d, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x3a, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x1a, 0x4d, 0xca, 0x41, 0x19,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xed, 0x01, 0x0a, 0x23, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x42, 0x16, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x42, 0x61, 0x6e, 0x6b, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70,
	0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65,
	0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_goTypes = []any{
	(GenerateMemoriesResponse_GeneratedMemory_Action)(0), // 0: google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action
	(*CreateMemoryRequest)(nil),                          // 1: google.cloud.aiplatform.v1beta1.CreateMemoryRequest
	(*CreateMemoryOperationMetadata)(nil),                // 2: google.cloud.aiplatform.v1beta1.CreateMemoryOperationMetadata
	(*GetMemoryRequest)(nil),                             // 3: google.cloud.aiplatform.v1beta1.GetMemoryRequest
	(*UpdateMemoryRequest)(nil),                          // 4: google.cloud.aiplatform.v1beta1.UpdateMemoryRequest
	(*UpdateMemoryOperationMetadata)(nil),                // 5: google.cloud.aiplatform.v1beta1.UpdateMemoryOperationMetadata
	(*ListMemoriesRequest)(nil),                          // 6: google.cloud.aiplatform.v1beta1.ListMemoriesRequest
	(*ListMemoriesResponse)(nil),                         // 7: google.cloud.aiplatform.v1beta1.ListMemoriesResponse
	(*DeleteMemoryRequest)(nil),                          // 8: google.cloud.aiplatform.v1beta1.DeleteMemoryRequest
	(*DeleteMemoryOperationMetadata)(nil),                // 9: google.cloud.aiplatform.v1beta1.DeleteMemoryOperationMetadata
	(*GenerateMemoriesRequest)(nil),                      // 10: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
	(*GenerateMemoriesResponse)(nil),                     // 11: google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse
	(*GenerateMemoriesOperationMetadata)(nil),            // 12: google.cloud.aiplatform.v1beta1.GenerateMemoriesOperationMetadata
	(*RetrieveMemoriesRequest)(nil),                      // 13: google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
	(*RetrieveMemoriesResponse)(nil),                     // 14: google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse
	(*GenerateMemoriesRequest_VertexSessionSource)(nil),  // 15: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
	(*GenerateMemoriesRequest_DirectContentsSource)(nil), // 16: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
	nil, // 17: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.ScopeEntry
	(*GenerateMemoriesRequest_DirectContentsSource_Event)(nil), // 18: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
	(*GenerateMemoriesResponse_GeneratedMemory)(nil),           // 19: google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
	(*RetrieveMemoriesRequest_SimilaritySearchParams)(nil),     // 20: google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
	(*RetrieveMemoriesRequest_SimpleRetrievalParams)(nil),      // 21: google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
	nil, // 22: google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.ScopeEntry
	(*RetrieveMemoriesResponse_RetrievedMemory)(nil), // 23: google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
	(*Memory)(nil),                   // 24: google.cloud.aiplatform.v1beta1.Memory
	(*GenericOperationMetadata)(nil), // 25: google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	(*fieldmaskpb.FieldMask)(nil),    // 26: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),    // 27: google.protobuf.Timestamp
	(*Content)(nil),                  // 28: google.cloud.aiplatform.v1beta1.Content
	(*longrunningpb.Operation)(nil),  // 29: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_depIdxs = []int32{
	24, // 0: google.cloud.aiplatform.v1beta1.CreateMemoryRequest.memory:type_name -> google.cloud.aiplatform.v1beta1.Memory
	25, // 1: google.cloud.aiplatform.v1beta1.CreateMemoryOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	24, // 2: google.cloud.aiplatform.v1beta1.UpdateMemoryRequest.memory:type_name -> google.cloud.aiplatform.v1beta1.Memory
	26, // 3: google.cloud.aiplatform.v1beta1.UpdateMemoryRequest.update_mask:type_name -> google.protobuf.FieldMask
	25, // 4: google.cloud.aiplatform.v1beta1.UpdateMemoryOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	24, // 5: google.cloud.aiplatform.v1beta1.ListMemoriesResponse.memories:type_name -> google.cloud.aiplatform.v1beta1.Memory
	25, // 6: google.cloud.aiplatform.v1beta1.DeleteMemoryOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	15, // 7: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.vertex_session_source:type_name -> google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource
	16, // 8: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.direct_contents_source:type_name -> google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource
	17, // 9: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.scope:type_name -> google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.ScopeEntry
	19, // 10: google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.generated_memories:type_name -> google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
	25, // 11: google.cloud.aiplatform.v1beta1.GenerateMemoriesOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	20, // 12: google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.similarity_search_params:type_name -> google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
	21, // 13: google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.simple_retrieval_params:type_name -> google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
	22, // 14: google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.scope:type_name -> google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.ScopeEntry
	23, // 15: google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.retrieved_memories:type_name -> google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
	27, // 16: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource.start_time:type_name -> google.protobuf.Timestamp
	27, // 17: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.VertexSessionSource.end_time:type_name -> google.protobuf.Timestamp
	18, // 18: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.events:type_name -> google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event
	28, // 19: google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest.DirectContentsSource.Event.content:type_name -> google.cloud.aiplatform.v1beta1.Content
	24, // 20: google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.memory:type_name -> google.cloud.aiplatform.v1beta1.Memory
	0,  // 21: google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.action:type_name -> google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action
	24, // 22: google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.memory:type_name -> google.cloud.aiplatform.v1beta1.Memory
	1,  // 23: google.cloud.aiplatform.v1beta1.MemoryBankService.CreateMemory:input_type -> google.cloud.aiplatform.v1beta1.CreateMemoryRequest
	3,  // 24: google.cloud.aiplatform.v1beta1.MemoryBankService.GetMemory:input_type -> google.cloud.aiplatform.v1beta1.GetMemoryRequest
	4,  // 25: google.cloud.aiplatform.v1beta1.MemoryBankService.UpdateMemory:input_type -> google.cloud.aiplatform.v1beta1.UpdateMemoryRequest
	6,  // 26: google.cloud.aiplatform.v1beta1.MemoryBankService.ListMemories:input_type -> google.cloud.aiplatform.v1beta1.ListMemoriesRequest
	8,  // 27: google.cloud.aiplatform.v1beta1.MemoryBankService.DeleteMemory:input_type -> google.cloud.aiplatform.v1beta1.DeleteMemoryRequest
	10, // 28: google.cloud.aiplatform.v1beta1.MemoryBankService.GenerateMemories:input_type -> google.cloud.aiplatform.v1beta1.GenerateMemoriesRequest
	13, // 29: google.cloud.aiplatform.v1beta1.MemoryBankService.RetrieveMemories:input_type -> google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
	29, // 30: google.cloud.aiplatform.v1beta1.MemoryBankService.CreateMemory:output_type -> google.longrunning.Operation
	24, // 31: google.cloud.aiplatform.v1beta1.MemoryBankService.GetMemory:output_type -> google.cloud.aiplatform.v1beta1.Memory
	29, // 32: google.cloud.aiplatform.v1beta1.MemoryBankService.UpdateMemory:output_type -> google.longrunning.Operation
	7,  // 33: google.cloud.aiplatform.v1beta1.MemoryBankService.ListMemories:output_type -> google.cloud.aiplatform.v1beta1.ListMemoriesResponse
	29, // 34: google.cloud.aiplatform.v1beta1.MemoryBankService.DeleteMemory:output_type -> google.longrunning.Operation
	29, // 35: google.cloud.aiplatform.v1beta1.MemoryBankService.GenerateMemories:output_type -> google.longrunning.Operation
	14, // 36: google.cloud.aiplatform.v1beta1.MemoryBankService.RetrieveMemories:output_type -> google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse
	30, // [30:37] is the sub-list for method output_type
	23, // [23:30] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_init() }
func file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_memory_bank_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_content_proto_init()
	file_google_cloud_aiplatform_v1beta1_memory_bank_proto_init()
	file_google_cloud_aiplatform_v1beta1_operation_proto_init()
	file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[9].OneofWrappers = []any{
		(*GenerateMemoriesRequest_VertexSessionSource_)(nil),
		(*GenerateMemoriesRequest_DirectContentsSource_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes[12].OneofWrappers = []any{
		(*RetrieveMemoriesRequest_SimilaritySearchParams_)(nil),
		(*RetrieveMemoriesRequest_SimpleRetrievalParams_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_memory_bank_service_proto = out.File
	file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_memory_bank_service_proto_depIdxs = nil
}
