/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceServletContextListener;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.servlet.ServletContextEvent;
import org.apache.guacamole.EnvironmentModule;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.SystemEnvironmentGuacamoleProperties;
import org.apache.guacamole.SystemFileEnvironmentGuacamoleProperties;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.environment.LocalEnvironment;
import org.apache.guacamole.extension.ExtensionModule;
import org.apache.guacamole.log.LogModule;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.properties.BooleanGuacamoleProperty;
import org.apache.guacamole.properties.FileGuacamoleProperties;
import org.apache.guacamole.properties.GuacamoleProperties;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.rest.RESTServiceModule;
import org.apache.guacamole.rest.auth.HashTokenSessionMap;
import org.apache.guacamole.rest.auth.TokenSessionMap;
import org.apache.guacamole.rest.event.ListenerService;
import org.apache.guacamole.tunnel.TunnelModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuacamoleServletContextListener
extends GuiceServletContextListener {
    public static final String GUICE_INJECTOR = "GUAC_GUICE_INJECTOR";
    private final Logger logger = LoggerFactory.getLogger(GuacamoleServletContextListener.class);
    private static final BooleanGuacamoleProperty ENABLE_ENVIRONMENT_PROPERTIES = new /* Unavailable Anonymous Inner Class!! */;
    private static final BooleanGuacamoleProperty ENABLE_FILE_ENVIRONMENT_PROPERTIES = new /* Unavailable Anonymous Inner Class!! */;
    private Environment environment;
    private TokenSessionMap sessionMap;
    @Inject
    private List<AuthenticationProvider> authProviders;
    @Inject
    private List<File> temporaryFiles;
    @Inject
    private ListenerService listenerService;
    private final AtomicReference<Injector> guiceInjector = new AtomicReference();

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.environment = LocalEnvironment.getInstance();
        try {
            File guacProperties = new File(this.environment.getGuacamoleHome(), "guacamole.properties");
            this.environment.addGuacamoleProperties((GuacamoleProperties)new FileGuacamoleProperties(guacProperties));
            this.logger.info("Read configuration parameters from \"{}\".", (Object)guacProperties);
        }
        catch (GuacamoleException e) {
            this.logger.error("Unable to read guacamole.properties: {}", (Object)e.getMessage());
            this.logger.debug("Error reading guacamole.properties.", (Throwable)e);
        }
        try {
            if (((Boolean)this.environment.getProperty((GuacamoleProperty)ENABLE_ENVIRONMENT_PROPERTIES, (Object)false)).booleanValue()) {
                this.environment.addGuacamoleProperties((GuacamoleProperties)new SystemEnvironmentGuacamoleProperties());
                this.logger.info("Additional configuration parameters may be read from environment variables.");
            }
        }
        catch (GuacamoleException e) {
            this.logger.error("Unable to configure support for environment properties: {}", (Object)e.getMessage());
            this.logger.debug("Error reading \"{}\" property from guacamole.properties.", (Object)ENABLE_ENVIRONMENT_PROPERTIES.getName(), (Object)e);
        }
        try {
            if (((Boolean)this.environment.getProperty((GuacamoleProperty)ENABLE_FILE_ENVIRONMENT_PROPERTIES, (Object)false)).booleanValue()) {
                this.environment.addGuacamoleProperties((GuacamoleProperties)new SystemFileEnvironmentGuacamoleProperties());
                this.logger.info("Additional configuration parameters may be read from files pointed to by \"*_FILE\" environment variables.");
            }
        }
        catch (GuacamoleException e) {
            this.logger.error("Unable to configure support for file environment properties: {}", (Object)e.getMessage());
            this.logger.debug("Error reading \"{}\" property from guacamole.properties.", (Object)ENABLE_FILE_ENVIRONMENT_PROPERTIES.getName(), (Object)e);
        }
        this.sessionMap = new HashTokenSessionMap(this.environment);
        super.contextInitialized(servletContextEvent);
        Injector injector = this.getInjector();
        injector.injectMembers((Object)this);
        servletContextEvent.getServletContext().setAttribute(GUICE_INJECTOR, (Object)injector);
        try {
            this.listenerService.handleEvent((Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (GuacamoleException e) {
            this.logger.error("An extension listening for application startup failed: {}", (Object)e.getMessage());
            this.logger.debug("Extension failed internally while handling the application startup event.", (Throwable)e);
        }
    }

    protected Injector getInjector() {
        return (Injector)this.guiceInjector.updateAndGet(current -> {
            if (current != null) {
                return current;
            }
            Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new EnvironmentModule(this.environment), new LogModule(this.environment)}).createChildInjector(new Module[]{new ExtensionModule(this.environment), new RESTServiceModule(this.sessionMap), new TunnelModule()});
            return injector;
        });
    }

    private void deleteTemporaryFile(File temp) {
        if (!temp.delete()) {
            this.logger.warn("Temporary file/directory \"{}\" could not be deleted. The file may remain until the JVM exits, or may need to be manually deleted.", (Object)temp);
        } else {
            this.logger.debug("Deleted temporary file/directory \"{}\".", (Object)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            servletContextEvent.getServletContext().removeAttribute(GUICE_INJECTOR);
            if (this.sessionMap != null) {
                this.sessionMap.shutdown();
            }
            if (this.authProviders != null) {
                for (AuthenticationProvider authProvider : this.authProviders) {
                    authProvider.shutdown();
                }
            }
            try {
                this.listenerService.handleEvent((Object)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (GuacamoleException e) {
                this.logger.error("An extension listening for application shutdown failed: {}", (Object)e.getMessage());
                this.logger.debug("Extension failed internally while handling the application shutdown event.", (Throwable)e);
            }
        }
        finally {
            if (this.temporaryFiles != null) {
                Lists.reverse((List)this.temporaryFiles).stream().forEachOrdered(arg_0 -> this.deleteTemporaryFile(arg_0));
            }
        }
        super.contextDestroyed(servletContextEvent);
    }
}

