/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.directory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.language.Translatable;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.AtomicDirectoryOperation;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;
import org.apache.guacamole.net.event.DirectoryEvent;
import org.apache.guacamole.rest.directory.DirectoryObjectResource;
import org.apache.guacamole.rest.directory.DirectoryObjectResourceFactory;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;
import org.apache.guacamole.rest.event.ListenerService;
import org.apache.guacamole.rest.jsonpatch.APIPatch;
import org.apache.guacamole.rest.jsonpatch.APIPatchError;
import org.apache.guacamole.rest.jsonpatch.APIPatchResponse;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public abstract class DirectoryResource<InternalType extends Identifiable, ExternalType> {
    private final AuthenticatedUser authenticatedUser;
    private final UserContext userContext;
    private final Class<InternalType> internalType;
    private final Directory<InternalType> directory;
    private final DirectoryObjectTranslator<InternalType, ExternalType> translator;
    private final DirectoryObjectResourceFactory<InternalType, ExternalType> resourceFactory;
    @Inject
    private ListenerService listenerService;

    public DirectoryResource(AuthenticatedUser authenticatedUser, UserContext userContext, Class<InternalType> internalType, Directory<InternalType> directory, DirectoryObjectTranslator<InternalType, ExternalType> translator, DirectoryObjectResourceFactory<InternalType, ExternalType> resourceFactory) {
        this.authenticatedUser = authenticatedUser;
        this.userContext = userContext;
        this.directory = directory;
        this.internalType = internalType;
        this.translator = translator;
        this.resourceFactory = resourceFactory;
    }

    protected abstract ObjectPermissionSet getObjectPermissions(Permissions var1) throws GuacamoleException;

    protected void fireDirectorySuccessEvent(DirectoryEvent.Operation operation, String identifier, InternalType object) throws GuacamoleException {
        this.listenerService.handleEvent((Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void fireDirectoryFailureEvent(DirectoryEvent.Operation operation, String identifier, InternalType object, Throwable failure) throws GuacamoleException {
        this.listenerService.handleEvent((Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected AuthenticatedUser getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    protected UserContext getUserContext() {
        return this.userContext;
    }

    protected Directory<InternalType> getDirectory() {
        return this.directory;
    }

    public DirectoryObjectResourceFactory<InternalType, ExternalType> getResourceFactory() {
        return this.resourceFactory;
    }

    private InternalType filterAndTranslate(ExternalType object) throws GuacamoleException {
        this.translator.filterExternalObject(this.userContext, object);
        return (InternalType)this.translator.toInternalObject(object);
    }

    @GET
    public Map<String, ExternalType> getObjects(@QueryParam(value="permission") List<ObjectPermission.Type> permissions) throws GuacamoleException {
        Permissions effective = this.userContext.self().getEffectivePermissions();
        SystemPermissionSet systemPermissions = effective.getSystemPermissions();
        boolean isAdmin = systemPermissions.hasPermission(SystemPermission.Type.ADMINISTER);
        Collection identifiers = this.directory.getIdentifiers();
        if (!isAdmin && permissions != null && !permissions.isEmpty()) {
            ObjectPermissionSet objectPermissions = this.getObjectPermissions(effective);
            identifiers = objectPermissions.getAccessibleObjects(permissions, identifiers);
        }
        HashMap<String, Object> apiObjects = new HashMap<String, Object>();
        for (Identifiable object : this.directory.getAll(identifiers)) {
            apiObjects.put(object.getIdentifier(), this.translator.toExternalObject(object));
        }
        return apiObjects;
    }

    @Nonnull
    private InternalType getObjectByIdentifier(String identifier, @Nullable Directory<InternalType> directory) throws GuacamoleException {
        Identifiable object;
        if (directory == null) {
            directory = this.directory;
        }
        try {
            object = directory.get(identifier);
            if (object == null) {
                throw new GuacamoleResourceNotFoundException("Not found: \"" + identifier + "\"");
            }
        }
        catch (Error | RuntimeException | GuacamoleException e) {
            this.fireDirectoryFailureEvent(DirectoryEvent.Operation.GET, identifier, null, e);
            throw e;
        }
        return (InternalType)object;
    }

    @Nullable
    private APIPatchError createPatchFailure(@Nonnull APIPatch.Operation op, @Nullable String identifier, @Nonnull String path, @Nonnull Throwable t) {
        if (t instanceof Translatable) {
            return new APIPatchError(op, identifier, path, ((Translatable)t).getTranslatableMessage());
        }
        if (t instanceof GuacamoleException) {
            TranslatableMessage message = new TranslatableMessage("APP.TEXT_UNTRANSLATED", Collections.singletonMap("MESSAGE", ((GuacamoleException)t).getMessage()));
            return new APIPatchError(op, identifier, path, message);
        }
        return null;
    }

    @PATCH
    public APIPatchResponse patchObjects(List<APIPatch<ExternalType>> patches) throws GuacamoleException {
        ArrayList patchOutcomes = new ArrayList();
        this.directory.tryAtomically((AtomicDirectoryOperation)new /* Unavailable Anonymous Inner Class!! */);
        return new APIPatchResponse(patchOutcomes);
    }

    @POST
    public ExternalType createObject(ExternalType object) throws GuacamoleException {
        if (object == null) {
            throw new GuacamoleClientException("Data must be submitted when creating objects.");
        }
        Identifiable internal = this.filterAndTranslate(object);
        try {
            this.directory.add(internal);
            this.fireDirectorySuccessEvent(DirectoryEvent.Operation.ADD, internal.getIdentifier(), internal);
            return object;
        }
        catch (Error | RuntimeException | GuacamoleException e) {
            this.fireDirectoryFailureEvent(DirectoryEvent.Operation.ADD, internal.getIdentifier(), internal, e);
            throw e;
        }
    }

    @Path(value="{identifier}")
    public DirectoryObjectResource<InternalType, ExternalType> getObjectResource(@PathParam(value="identifier") String identifier) throws GuacamoleException {
        Identifiable object = this.getObjectByIdentifier(identifier, null);
        DirectoryObjectResource resource = this.resourceFactory.create(this.authenticatedUser, this.userContext, this.directory, object);
        this.fireDirectorySuccessEvent(DirectoryEvent.Operation.GET, identifier, object);
        return resource;
    }

    static /* synthetic */ Class access$000(DirectoryResource x0) {
        return x0.internalType;
    }

    static /* synthetic */ AuthenticatedUser access$100(DirectoryResource x0) {
        return x0.authenticatedUser;
    }

    static /* synthetic */ UserContext access$200(DirectoryResource x0) {
        return x0.userContext;
    }

    static /* synthetic */ Identifiable access$300(DirectoryResource x0, Object x1) throws GuacamoleException {
        return x0.filterAndTranslate(x1);
    }

    static /* synthetic */ APIPatchError access$400(DirectoryResource x0, APIPatch.Operation x1, String x2, String x3, Throwable x4) {
        return x0.createPatchFailure(x1, x2, x3, x4);
    }

    static /* synthetic */ Identifiable access$500(DirectoryResource x0, String x1, Directory x2) throws GuacamoleException {
        return x0.getObjectByIdentifier(x1, x2);
    }

    static /* synthetic */ DirectoryObjectTranslator access$600(DirectoryResource x0) {
        return x0.translator;
    }
}

