/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.directory;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.event.DirectoryEvent;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;
import org.apache.guacamole.rest.event.ListenerService;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public abstract class DirectoryObjectResource<InternalType extends Identifiable, ExternalType> {
    private final AuthenticatedUser authenticatedUser;
    private final UserContext userContext;
    private final Class<InternalType> internalType;
    private final Directory<InternalType> directory;
    private final InternalType object;
    private final DirectoryObjectTranslator<InternalType, ExternalType> translator;
    @Inject
    private ListenerService listenerService;

    public DirectoryObjectResource(AuthenticatedUser authenticatedUser, UserContext userContext, Class<InternalType> internalType, Directory<InternalType> directory, InternalType object, DirectoryObjectTranslator<InternalType, ExternalType> translator) {
        this.authenticatedUser = authenticatedUser;
        this.userContext = userContext;
        this.directory = directory;
        this.internalType = internalType;
        this.object = object;
        this.translator = translator;
    }

    protected void fireDirectorySuccessEvent(DirectoryEvent.Operation operation) throws GuacamoleException {
        this.listenerService.handleEvent((Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void fireDirectoryFailureEvent(DirectoryEvent.Operation operation, Throwable failure) throws GuacamoleException {
        this.listenerService.handleEvent((Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected AuthenticatedUser getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    protected UserContext getUserContext() {
        return this.userContext;
    }

    protected Directory<InternalType> getDirectory() {
        return this.directory;
    }

    protected InternalType getInternalObject() {
        return (InternalType)this.object;
    }

    @GET
    public ExternalType getObject() throws GuacamoleException {
        return (ExternalType)this.translator.toExternalObject(this.object);
    }

    @PUT
    public void updateObject(ExternalType modifiedObject) throws GuacamoleException {
        if (modifiedObject == null) {
            throw new GuacamoleClientException("Data must be submitted when updating objects.");
        }
        this.translator.filterExternalObject(this.userContext, modifiedObject);
        this.translator.applyExternalChanges(this.object, modifiedObject);
        try {
            this.directory.update(this.object);
            this.fireDirectorySuccessEvent(DirectoryEvent.Operation.UPDATE);
        }
        catch (Error | RuntimeException | GuacamoleException e) {
            this.fireDirectoryFailureEvent(DirectoryEvent.Operation.UPDATE, e);
            throw e;
        }
    }

    @DELETE
    public void deleteObject() throws GuacamoleException {
        try {
            this.directory.remove(this.object.getIdentifier());
            this.fireDirectorySuccessEvent(DirectoryEvent.Operation.REMOVE);
        }
        catch (Error | RuntimeException | GuacamoleException e) {
            this.fireDirectoryFailureEvent(DirectoryEvent.Operation.REMOVE, e);
            throw e;
        }
    }

    static /* synthetic */ Class access$000(DirectoryObjectResource x0) {
        return x0.internalType;
    }

    static /* synthetic */ Identifiable access$100(DirectoryObjectResource x0) {
        return x0.object;
    }

    static /* synthetic */ AuthenticatedUser access$200(DirectoryObjectResource x0) {
        return x0.authenticatedUser;
    }

    static /* synthetic */ UserContext access$300(DirectoryObjectResource x0) {
        return x0.userContext;
    }
}

