/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel;

import java.util.List;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.tunnel.TunnelRequestType;

public abstract class TunnelRequest {
    public static final String AUTH_TOKEN_PARAMETER = "token";
    public static final String AUTH_PROVIDER_IDENTIFIER_PARAMETER = "GUAC_DATA_SOURCE";
    public static final String TYPE_PARAMETER = "GUAC_TYPE";
    public static final String IDENTIFIER_PARAMETER = "GUAC_ID";
    public static final String WIDTH_PARAMETER = "GUAC_WIDTH";
    public static final String HEIGHT_PARAMETER = "GUAC_HEIGHT";
    public static final String DPI_PARAMETER = "GUAC_DPI";
    public static final String AUDIO_PARAMETER = "GUAC_AUDIO";
    public static final String VIDEO_PARAMETER = "GUAC_VIDEO";
    public static final String IMAGE_PARAMETER = "GUAC_IMAGE";
    public static final String TIMEZONE_PARAMETER = "GUAC_TIMEZONE";

    public abstract String getParameter(String var1);

    public abstract List<String> getParameterValues(String var1);

    public String getRequiredParameter(String name) throws GuacamoleException {
        String value = this.getParameter(name);
        if (value == null) {
            throw new GuacamoleClientException("Parameter \"" + name + "\" is required.");
        }
        return value;
    }

    public Integer getIntegerParameter(String name) throws GuacamoleException {
        String value = this.getParameter(name);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new GuacamoleClientException("Parameter \"" + name + "\" must be a valid integer.", (Throwable)e);
        }
    }

    public String getAuthenticationToken() {
        return this.getParameter(AUTH_TOKEN_PARAMETER);
    }

    public String getAuthenticationProviderIdentifier() throws GuacamoleException {
        return this.getRequiredParameter(AUTH_PROVIDER_IDENTIFIER_PARAMETER);
    }

    public TunnelRequestType getType() throws GuacamoleException {
        TunnelRequestType type = TunnelRequestType.parseType((String)this.getRequiredParameter(TYPE_PARAMETER));
        if (type != null) {
            return type;
        }
        throw new GuacamoleClientException("Illegal identifier - unknown type.");
    }

    public String getIdentifier() throws GuacamoleException {
        return this.getRequiredParameter(IDENTIFIER_PARAMETER);
    }

    public Integer getWidth() throws GuacamoleException {
        return this.getIntegerParameter(WIDTH_PARAMETER);
    }

    public Integer getHeight() throws GuacamoleException {
        return this.getIntegerParameter(HEIGHT_PARAMETER);
    }

    public Integer getDPI() throws GuacamoleException {
        return this.getIntegerParameter(DPI_PARAMETER);
    }

    public List<String> getAudioMimetypes() {
        return this.getParameterValues(AUDIO_PARAMETER);
    }

    public List<String> getVideoMimetypes() {
        return this.getParameterValues(VIDEO_PARAMETER);
    }

    public List<String> getImageMimetypes() {
        return this.getParameterValues(IMAGE_PARAMETER);
    }

    public String getTimezone() {
        return this.getParameter(TIMEZONE_PARAMETER);
    }
}

