// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.9
// source: google/cloud/backupdr/logging/v1/eventlog.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is an event
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The event_time field displays the time when the event was reported
	EventTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// The srcid field displays unique id of the event occurred in the backup
	// appliance
	Srcid int64 `protobuf:"varint,2,opt,name=srcid,proto3" json:"srcid,omitempty"`
	// The error_message field describes the detailed error associated with the
	// event
	ErrorMessage string `protobuf:"bytes,3,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// The event_id field displays unique id associated with the error
	EventId int32 `protobuf:"varint,4,opt,name=event_id,json=eventId,proto3" json:"event_id,omitempty"`
	// The component field displays the source of the event
	Component string `protobuf:"bytes,5,opt,name=component,proto3" json:"component,omitempty"`
	// The appliance_id field displays unique id of the appliance on which event
	// occurred
	ApplianceId int64 `protobuf:"varint,6,opt,name=appliance_id,json=applianceId,proto3" json:"appliance_id,omitempty"`
	// The appliance_name field displays name of the appliance on which event
	// occurred
	ApplianceName string `protobuf:"bytes,7,opt,name=appliance_name,json=applianceName,proto3" json:"appliance_name,omitempty"`
	// The source_event_time field displays the time when the event occurred at
	// appliance
	SourceEventTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=source_event_time,json=sourceEventTime,proto3" json:"source_event_time,omitempty"`
	// The app_name field displays name of the application associated with the
	// event
	AppName string `protobuf:"bytes,9,opt,name=app_name,json=appName,proto3" json:"app_name,omitempty"`
	// The app_type field displays type of the application associated with the
	// event
	AppType string `protobuf:"bytes,10,opt,name=app_type,json=appType,proto3" json:"app_type,omitempty"`
	// The job_name field displays name of the job associated with the event
	JobName string `protobuf:"bytes,11,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_backupdr_logging_v1_eventlog_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_logging_v1_eventlog_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDescGZIP(), []int{0}
}

func (x *Event) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (x *Event) GetSrcid() int64 {
	if x != nil {
		return x.Srcid
	}
	return 0
}

func (x *Event) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *Event) GetEventId() int32 {
	if x != nil {
		return x.EventId
	}
	return 0
}

func (x *Event) GetComponent() string {
	if x != nil {
		return x.Component
	}
	return ""
}

func (x *Event) GetApplianceId() int64 {
	if x != nil {
		return x.ApplianceId
	}
	return 0
}

func (x *Event) GetApplianceName() string {
	if x != nil {
		return x.ApplianceName
	}
	return ""
}

func (x *Event) GetSourceEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SourceEventTime
	}
	return nil
}

func (x *Event) GetAppName() string {
	if x != nil {
		return x.AppName
	}
	return ""
}

func (x *Event) GetAppType() string {
	if x != nil {
		return x.AppType
	}
	return ""
}

func (x *Event) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

var File_google_cloud_backupdr_logging_v1_eventlog_proto protoreflect.FileDescriptor

var file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f,
	0x76, 0x31, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x99, 0x03, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x39,
	0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x72, 0x63,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73, 0x72, 0x63, 0x69, 0x64, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12,
	0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a,
	0x0c, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64,
	0x12, 0x25, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x19, 0x0a, 0x08, 0x61, 0x70, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x61, 0x70, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x70,
	0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x70,
	0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65,
	0x42, 0x49, 0x5a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDescOnce sync.Once
	file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDescData = file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDesc
)

func file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDescGZIP() []byte {
	file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDescOnce.Do(func() {
		file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDescData)
	})
	return file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDescData
}

var file_google_cloud_backupdr_logging_v1_eventlog_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_backupdr_logging_v1_eventlog_proto_goTypes = []interface{}{
	(*Event)(nil),                 // 0: google.cloud.backupdr.logging.v1.Event
	(*timestamppb.Timestamp)(nil), // 1: google.protobuf.Timestamp
}
var file_google_cloud_backupdr_logging_v1_eventlog_proto_depIdxs = []int32{
	1, // 0: google.cloud.backupdr.logging.v1.Event.event_time:type_name -> google.protobuf.Timestamp
	1, // 1: google.cloud.backupdr.logging.v1.Event.source_event_time:type_name -> google.protobuf.Timestamp
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_backupdr_logging_v1_eventlog_proto_init() }
func file_google_cloud_backupdr_logging_v1_eventlog_proto_init() {
	if File_google_cloud_backupdr_logging_v1_eventlog_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_backupdr_logging_v1_eventlog_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_backupdr_logging_v1_eventlog_proto_goTypes,
		DependencyIndexes: file_google_cloud_backupdr_logging_v1_eventlog_proto_depIdxs,
		MessageInfos:      file_google_cloud_backupdr_logging_v1_eventlog_proto_msgTypes,
	}.Build()
	File_google_cloud_backupdr_logging_v1_eventlog_proto = out.File
	file_google_cloud_backupdr_logging_v1_eventlog_proto_rawDesc = nil
	file_google_cloud_backupdr_logging_v1_eventlog_proto_goTypes = nil
	file_google_cloud_backupdr_logging_v1_eventlog_proto_depIdxs = nil
}
