// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/networkmanagement/v1/trace.proto

package networkmanagementpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of a load balancer. For more information, see [Summary of Google Cloud
// load
// balancers](https://cloud.google.com/load-balancing/docs/load-balancing-overview#summary-of-google-cloud-load-balancers).
type LoadBalancerType int32

const (
	// Forwarding rule points to a different target than a load balancer or a
	// load balancer type is unknown.
	LoadBalancerType_LOAD_BALANCER_TYPE_UNSPECIFIED LoadBalancerType = 0
	// Global external HTTP(S) load balancer.
	LoadBalancerType_HTTPS_ADVANCED_LOAD_BALANCER LoadBalancerType = 1
	// Global external HTTP(S) load balancer (classic)
	LoadBalancerType_HTTPS_LOAD_BALANCER LoadBalancerType = 2
	// Regional external HTTP(S) load balancer.
	LoadBalancerType_REGIONAL_HTTPS_LOAD_BALANCER LoadBalancerType = 3
	// Internal HTTP(S) load balancer.
	LoadBalancerType_INTERNAL_HTTPS_LOAD_BALANCER LoadBalancerType = 4
	// External SSL proxy load balancer.
	LoadBalancerType_SSL_PROXY_LOAD_BALANCER LoadBalancerType = 5
	// External TCP proxy load balancer.
	LoadBalancerType_TCP_PROXY_LOAD_BALANCER LoadBalancerType = 6
	// Internal regional TCP proxy load balancer.
	LoadBalancerType_INTERNAL_TCP_PROXY_LOAD_BALANCER LoadBalancerType = 7
	// External TCP/UDP Network load balancer.
	LoadBalancerType_NETWORK_LOAD_BALANCER LoadBalancerType = 8
	// Target-pool based external TCP/UDP Network load balancer.
	LoadBalancerType_LEGACY_NETWORK_LOAD_BALANCER LoadBalancerType = 9
	// Internal TCP/UDP load balancer.
	LoadBalancerType_TCP_UDP_INTERNAL_LOAD_BALANCER LoadBalancerType = 10
)

// Enum value maps for LoadBalancerType.
var (
	LoadBalancerType_name = map[int32]string{
		0:  "LOAD_BALANCER_TYPE_UNSPECIFIED",
		1:  "HTTPS_ADVANCED_LOAD_BALANCER",
		2:  "HTTPS_LOAD_BALANCER",
		3:  "REGIONAL_HTTPS_LOAD_BALANCER",
		4:  "INTERNAL_HTTPS_LOAD_BALANCER",
		5:  "SSL_PROXY_LOAD_BALANCER",
		6:  "TCP_PROXY_LOAD_BALANCER",
		7:  "INTERNAL_TCP_PROXY_LOAD_BALANCER",
		8:  "NETWORK_LOAD_BALANCER",
		9:  "LEGACY_NETWORK_LOAD_BALANCER",
		10: "TCP_UDP_INTERNAL_LOAD_BALANCER",
	}
	LoadBalancerType_value = map[string]int32{
		"LOAD_BALANCER_TYPE_UNSPECIFIED":   0,
		"HTTPS_ADVANCED_LOAD_BALANCER":     1,
		"HTTPS_LOAD_BALANCER":              2,
		"REGIONAL_HTTPS_LOAD_BALANCER":     3,
		"INTERNAL_HTTPS_LOAD_BALANCER":     4,
		"SSL_PROXY_LOAD_BALANCER":          5,
		"TCP_PROXY_LOAD_BALANCER":          6,
		"INTERNAL_TCP_PROXY_LOAD_BALANCER": 7,
		"NETWORK_LOAD_BALANCER":            8,
		"LEGACY_NETWORK_LOAD_BALANCER":     9,
		"TCP_UDP_INTERNAL_LOAD_BALANCER":   10,
	}
)

func (x LoadBalancerType) Enum() *LoadBalancerType {
	p := new(LoadBalancerType)
	*p = x
	return p
}

func (x LoadBalancerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[0].Descriptor()
}

func (LoadBalancerType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[0]
}

func (x LoadBalancerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancerType.Descriptor instead.
func (LoadBalancerType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{0}
}

// Type of states that are defined in the network state machine.
// Each step in the packet trace is in a specific state.
type Step_State int32

const (
	// Unspecified state.
	Step_STATE_UNSPECIFIED Step_State = 0
	// Initial state: packet originating from a Compute Engine instance.
	// An InstanceInfo is populated with starting instance information.
	Step_START_FROM_INSTANCE Step_State = 1
	// Initial state: packet originating from the internet.
	// The endpoint information is populated.
	Step_START_FROM_INTERNET Step_State = 2
	// Initial state: packet originating from a Google service.
	// The google_service information is populated.
	Step_START_FROM_GOOGLE_SERVICE Step_State = 27
	// Initial state: packet originating from a VPC or on-premises network
	// with internal source IP.
	// If the source is a VPC network visible to the user, a NetworkInfo
	// is populated with details of the network.
	Step_START_FROM_PRIVATE_NETWORK Step_State = 3
	// Initial state: packet originating from a Google Kubernetes Engine cluster
	// master. A GKEMasterInfo is populated with starting instance information.
	Step_START_FROM_GKE_MASTER Step_State = 21
	// Initial state: packet originating from a Cloud SQL instance.
	// A CloudSQLInstanceInfo is populated with starting instance information.
	Step_START_FROM_CLOUD_SQL_INSTANCE Step_State = 22
	// Initial state: packet originating from a Redis instance.
	// A RedisInstanceInfo is populated with starting instance information.
	Step_START_FROM_REDIS_INSTANCE Step_State = 32
	// Initial state: packet originating from a Redis Cluster.
	// A RedisClusterInfo is populated with starting Cluster information.
	Step_START_FROM_REDIS_CLUSTER Step_State = 33
	// Initial state: packet originating from a Cloud Function.
	// A CloudFunctionInfo is populated with starting function information.
	Step_START_FROM_CLOUD_FUNCTION Step_State = 23
	// Initial state: packet originating from an App Engine service version.
	// An AppEngineVersionInfo is populated with starting version information.
	Step_START_FROM_APP_ENGINE_VERSION Step_State = 25
	// Initial state: packet originating from a Cloud Run revision.
	// A CloudRunRevisionInfo is populated with starting revision information.
	Step_START_FROM_CLOUD_RUN_REVISION Step_State = 26
	// Initial state: packet originating from a Storage Bucket. Used only for
	// return traces.
	// The storage_bucket information is populated.
	Step_START_FROM_STORAGE_BUCKET Step_State = 29
	// Initial state: packet originating from a published service that uses
	// Private Service Connect. Used only for return traces.
	Step_START_FROM_PSC_PUBLISHED_SERVICE Step_State = 30
	// Initial state: packet originating from a serverless network endpoint
	// group backend. Used only for return traces.
	// The serverless_neg information is populated.
	Step_START_FROM_SERVERLESS_NEG Step_State = 31
	// Config checking state: verify ingress firewall rule.
	Step_APPLY_INGRESS_FIREWALL_RULE Step_State = 4
	// Config checking state: verify egress firewall rule.
	Step_APPLY_EGRESS_FIREWALL_RULE Step_State = 5
	// Config checking state: verify route.
	Step_APPLY_ROUTE Step_State = 6
	// Config checking state: match forwarding rule.
	Step_APPLY_FORWARDING_RULE Step_State = 7
	// Config checking state: verify load balancer backend configuration.
	Step_ANALYZE_LOAD_BALANCER_BACKEND Step_State = 28
	// Config checking state: packet sent or received under foreign IP
	// address and allowed.
	Step_SPOOFING_APPROVED Step_State = 8
	// Forwarding state: arriving at a Compute Engine instance.
	Step_ARRIVE_AT_INSTANCE Step_State = 9
	// Forwarding state: arriving at a Compute Engine internal load balancer.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	Step_ARRIVE_AT_INTERNAL_LOAD_BALANCER Step_State = 10
	// Forwarding state: arriving at a Compute Engine external load balancer.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	Step_ARRIVE_AT_EXTERNAL_LOAD_BALANCER Step_State = 11
	// Forwarding state: arriving at a hybrid subnet. Appropriate routing
	// configuration will be determined here.
	Step_ARRIVE_AT_HYBRID_SUBNET Step_State = 38
	// Forwarding state: arriving at a Cloud VPN gateway.
	Step_ARRIVE_AT_VPN_GATEWAY Step_State = 12
	// Forwarding state: arriving at a Cloud VPN tunnel.
	Step_ARRIVE_AT_VPN_TUNNEL Step_State = 13
	// Forwarding state: arriving at an interconnect attachment.
	Step_ARRIVE_AT_INTERCONNECT_ATTACHMENT Step_State = 37
	// Forwarding state: arriving at a VPC connector.
	Step_ARRIVE_AT_VPC_CONNECTOR Step_State = 24
	// Forwarding state: for packets originating from a serverless endpoint
	// forwarded through Direct VPC egress.
	Step_DIRECT_VPC_EGRESS_CONNECTION Step_State = 35
	// Forwarding state: for packets originating from a serverless endpoint
	// forwarded through public (external) connectivity.
	Step_SERVERLESS_EXTERNAL_CONNECTION Step_State = 36
	// Transition state: packet header translated. The `nat` field is populated
	// with the translation information.
	Step_NAT Step_State = 14
	// Transition state: original connection is terminated and a new proxied
	// connection is initiated.
	Step_PROXY_CONNECTION Step_State = 15
	// Final state: packet could be delivered.
	Step_DELIVER Step_State = 16
	// Final state: packet could be dropped.
	Step_DROP Step_State = 17
	// Final state: packet could be forwarded to a network with an unknown
	// configuration.
	Step_FORWARD Step_State = 18
	// Final state: analysis is aborted.
	Step_ABORT Step_State = 19
	// Special state: viewer of the test result does not have permission to
	// see the configuration in this step.
	Step_VIEWER_PERMISSION_MISSING Step_State = 20
)

// Enum value maps for Step_State.
var (
	Step_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "START_FROM_INSTANCE",
		2:  "START_FROM_INTERNET",
		27: "START_FROM_GOOGLE_SERVICE",
		3:  "START_FROM_PRIVATE_NETWORK",
		21: "START_FROM_GKE_MASTER",
		22: "START_FROM_CLOUD_SQL_INSTANCE",
		32: "START_FROM_REDIS_INSTANCE",
		33: "START_FROM_REDIS_CLUSTER",
		23: "START_FROM_CLOUD_FUNCTION",
		25: "START_FROM_APP_ENGINE_VERSION",
		26: "START_FROM_CLOUD_RUN_REVISION",
		29: "START_FROM_STORAGE_BUCKET",
		30: "START_FROM_PSC_PUBLISHED_SERVICE",
		31: "START_FROM_SERVERLESS_NEG",
		4:  "APPLY_INGRESS_FIREWALL_RULE",
		5:  "APPLY_EGRESS_FIREWALL_RULE",
		6:  "APPLY_ROUTE",
		7:  "APPLY_FORWARDING_RULE",
		28: "ANALYZE_LOAD_BALANCER_BACKEND",
		8:  "SPOOFING_APPROVED",
		9:  "ARRIVE_AT_INSTANCE",
		10: "ARRIVE_AT_INTERNAL_LOAD_BALANCER",
		11: "ARRIVE_AT_EXTERNAL_LOAD_BALANCER",
		38: "ARRIVE_AT_HYBRID_SUBNET",
		12: "ARRIVE_AT_VPN_GATEWAY",
		13: "ARRIVE_AT_VPN_TUNNEL",
		37: "ARRIVE_AT_INTERCONNECT_ATTACHMENT",
		24: "ARRIVE_AT_VPC_CONNECTOR",
		35: "DIRECT_VPC_EGRESS_CONNECTION",
		36: "SERVERLESS_EXTERNAL_CONNECTION",
		14: "NAT",
		15: "PROXY_CONNECTION",
		16: "DELIVER",
		17: "DROP",
		18: "FORWARD",
		19: "ABORT",
		20: "VIEWER_PERMISSION_MISSING",
	}
	Step_State_value = map[string]int32{
		"STATE_UNSPECIFIED":                 0,
		"START_FROM_INSTANCE":               1,
		"START_FROM_INTERNET":               2,
		"START_FROM_GOOGLE_SERVICE":         27,
		"START_FROM_PRIVATE_NETWORK":        3,
		"START_FROM_GKE_MASTER":             21,
		"START_FROM_CLOUD_SQL_INSTANCE":     22,
		"START_FROM_REDIS_INSTANCE":         32,
		"START_FROM_REDIS_CLUSTER":          33,
		"START_FROM_CLOUD_FUNCTION":         23,
		"START_FROM_APP_ENGINE_VERSION":     25,
		"START_FROM_CLOUD_RUN_REVISION":     26,
		"START_FROM_STORAGE_BUCKET":         29,
		"START_FROM_PSC_PUBLISHED_SERVICE":  30,
		"START_FROM_SERVERLESS_NEG":         31,
		"APPLY_INGRESS_FIREWALL_RULE":       4,
		"APPLY_EGRESS_FIREWALL_RULE":        5,
		"APPLY_ROUTE":                       6,
		"APPLY_FORWARDING_RULE":             7,
		"ANALYZE_LOAD_BALANCER_BACKEND":     28,
		"SPOOFING_APPROVED":                 8,
		"ARRIVE_AT_INSTANCE":                9,
		"ARRIVE_AT_INTERNAL_LOAD_BALANCER":  10,
		"ARRIVE_AT_EXTERNAL_LOAD_BALANCER":  11,
		"ARRIVE_AT_HYBRID_SUBNET":           38,
		"ARRIVE_AT_VPN_GATEWAY":             12,
		"ARRIVE_AT_VPN_TUNNEL":              13,
		"ARRIVE_AT_INTERCONNECT_ATTACHMENT": 37,
		"ARRIVE_AT_VPC_CONNECTOR":           24,
		"DIRECT_VPC_EGRESS_CONNECTION":      35,
		"SERVERLESS_EXTERNAL_CONNECTION":    36,
		"NAT":                               14,
		"PROXY_CONNECTION":                  15,
		"DELIVER":                           16,
		"DROP":                              17,
		"FORWARD":                           18,
		"ABORT":                             19,
		"VIEWER_PERMISSION_MISSING":         20,
	}
)

func (x Step_State) Enum() *Step_State {
	p := new(Step_State)
	*p = x
	return p
}

func (x Step_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Step_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[1].Descriptor()
}

func (Step_State) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[1]
}

func (x Step_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Step_State.Descriptor instead.
func (Step_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{1, 0}
}

// The status of the instance. We treat all states other than "RUNNING" as
// not running.
type InstanceInfo_Status int32

const (
	// Default unspecified value.
	InstanceInfo_STATUS_UNSPECIFIED InstanceInfo_Status = 0
	// The instance is running.
	InstanceInfo_RUNNING InstanceInfo_Status = 1
	// The instance has any status other than "RUNNING".
	InstanceInfo_NOT_RUNNING InstanceInfo_Status = 2
)

// Enum value maps for InstanceInfo_Status.
var (
	InstanceInfo_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "RUNNING",
		2: "NOT_RUNNING",
	}
	InstanceInfo_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"RUNNING":            1,
		"NOT_RUNNING":        2,
	}
)

func (x InstanceInfo_Status) Enum() *InstanceInfo_Status {
	p := new(InstanceInfo_Status)
	*p = x
	return p
}

func (x InstanceInfo_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceInfo_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[2].Descriptor()
}

func (InstanceInfo_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[2]
}

func (x InstanceInfo_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceInfo_Status.Descriptor instead.
func (InstanceInfo_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{2, 0}
}

// The firewall rule's type.
type FirewallInfo_FirewallRuleType int32

const (
	// Unspecified type.
	FirewallInfo_FIREWALL_RULE_TYPE_UNSPECIFIED FirewallInfo_FirewallRuleType = 0
	// Hierarchical firewall policy rule. For details, see
	// [Hierarchical firewall policies
	// overview](https://cloud.google.com/vpc/docs/firewall-policies).
	FirewallInfo_HIERARCHICAL_FIREWALL_POLICY_RULE FirewallInfo_FirewallRuleType = 1
	// VPC firewall rule. For details, see
	// [VPC firewall rules
	// overview](https://cloud.google.com/vpc/docs/firewalls).
	FirewallInfo_VPC_FIREWALL_RULE FirewallInfo_FirewallRuleType = 2
	// Implied VPC firewall rule. For details, see
	// [Implied
	// rules](https://cloud.google.com/vpc/docs/firewalls#default_firewall_rules).
	FirewallInfo_IMPLIED_VPC_FIREWALL_RULE FirewallInfo_FirewallRuleType = 3
	// Implicit firewall rules that are managed by serverless VPC access to
	// allow ingress access. They are not visible in the Google Cloud console.
	// For details, see [VPC connector's implicit
	// rules](https://cloud.google.com/functions/docs/networking/connecting-vpc#restrict-access).
	FirewallInfo_SERVERLESS_VPC_ACCESS_MANAGED_FIREWALL_RULE FirewallInfo_FirewallRuleType = 4
	// Global network firewall policy rule.
	// For details, see [Network firewall
	// policies](https://cloud.google.com/vpc/docs/network-firewall-policies).
	FirewallInfo_NETWORK_FIREWALL_POLICY_RULE FirewallInfo_FirewallRuleType = 5
	// Regional network firewall policy rule.
	// For details, see [Regional network firewall
	// policies](https://cloud.google.com/firewall/docs/regional-firewall-policies).
	FirewallInfo_NETWORK_REGIONAL_FIREWALL_POLICY_RULE FirewallInfo_FirewallRuleType = 6
	// Firewall policy rule containing attributes not yet supported in
	// Connectivity tests. Firewall analysis is skipped if such a rule can
	// potentially be matched. Please see the [list of unsupported
	// configurations](https://cloud.google.com/network-intelligence-center/docs/connectivity-tests/concepts/overview#unsupported-configs).
	FirewallInfo_UNSUPPORTED_FIREWALL_POLICY_RULE FirewallInfo_FirewallRuleType = 100
	// Tracking state for response traffic created when request traffic goes
	// through allow firewall rule.
	// For details, see [firewall rules
	// specifications](https://cloud.google.com/firewall/docs/firewalls#specifications)
	FirewallInfo_TRACKING_STATE FirewallInfo_FirewallRuleType = 101
	// Firewall analysis was skipped due to executing Connectivity Test in the
	// BypassFirewallChecks mode
	FirewallInfo_ANALYSIS_SKIPPED FirewallInfo_FirewallRuleType = 102
)

// Enum value maps for FirewallInfo_FirewallRuleType.
var (
	FirewallInfo_FirewallRuleType_name = map[int32]string{
		0:   "FIREWALL_RULE_TYPE_UNSPECIFIED",
		1:   "HIERARCHICAL_FIREWALL_POLICY_RULE",
		2:   "VPC_FIREWALL_RULE",
		3:   "IMPLIED_VPC_FIREWALL_RULE",
		4:   "SERVERLESS_VPC_ACCESS_MANAGED_FIREWALL_RULE",
		5:   "NETWORK_FIREWALL_POLICY_RULE",
		6:   "NETWORK_REGIONAL_FIREWALL_POLICY_RULE",
		100: "UNSUPPORTED_FIREWALL_POLICY_RULE",
		101: "TRACKING_STATE",
		102: "ANALYSIS_SKIPPED",
	}
	FirewallInfo_FirewallRuleType_value = map[string]int32{
		"FIREWALL_RULE_TYPE_UNSPECIFIED":              0,
		"HIERARCHICAL_FIREWALL_POLICY_RULE":           1,
		"VPC_FIREWALL_RULE":                           2,
		"IMPLIED_VPC_FIREWALL_RULE":                   3,
		"SERVERLESS_VPC_ACCESS_MANAGED_FIREWALL_RULE": 4,
		"NETWORK_FIREWALL_POLICY_RULE":                5,
		"NETWORK_REGIONAL_FIREWALL_POLICY_RULE":       6,
		"UNSUPPORTED_FIREWALL_POLICY_RULE":            100,
		"TRACKING_STATE":                              101,
		"ANALYSIS_SKIPPED":                            102,
	}
)

func (x FirewallInfo_FirewallRuleType) Enum() *FirewallInfo_FirewallRuleType {
	p := new(FirewallInfo_FirewallRuleType)
	*p = x
	return p
}

func (x FirewallInfo_FirewallRuleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallInfo_FirewallRuleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[3].Descriptor()
}

func (FirewallInfo_FirewallRuleType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[3]
}

func (x FirewallInfo_FirewallRuleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallInfo_FirewallRuleType.Descriptor instead.
func (FirewallInfo_FirewallRuleType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{4, 0}
}

// Target type of the firewall rule.
type FirewallInfo_TargetType int32

const (
	// Target type is not specified. In this case we treat the rule as applying
	// to INSTANCES target type.
	FirewallInfo_TARGET_TYPE_UNSPECIFIED FirewallInfo_TargetType = 0
	// Firewall rule applies to instances.
	FirewallInfo_INSTANCES FirewallInfo_TargetType = 1
	// Firewall rule applies to internal managed load balancers.
	FirewallInfo_INTERNAL_MANAGED_LB FirewallInfo_TargetType = 2
)

// Enum value maps for FirewallInfo_TargetType.
var (
	FirewallInfo_TargetType_name = map[int32]string{
		0: "TARGET_TYPE_UNSPECIFIED",
		1: "INSTANCES",
		2: "INTERNAL_MANAGED_LB",
	}
	FirewallInfo_TargetType_value = map[string]int32{
		"TARGET_TYPE_UNSPECIFIED": 0,
		"INSTANCES":               1,
		"INTERNAL_MANAGED_LB":     2,
	}
)

func (x FirewallInfo_TargetType) Enum() *FirewallInfo_TargetType {
	p := new(FirewallInfo_TargetType)
	*p = x
	return p
}

func (x FirewallInfo_TargetType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallInfo_TargetType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[4].Descriptor()
}

func (FirewallInfo_TargetType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[4]
}

func (x FirewallInfo_TargetType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallInfo_TargetType.Descriptor instead.
func (FirewallInfo_TargetType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{4, 1}
}

// Type of route:
type RouteInfo_RouteType int32

const (
	// Unspecified type. Default value.
	RouteInfo_ROUTE_TYPE_UNSPECIFIED RouteInfo_RouteType = 0
	// Route is a subnet route automatically created by the system.
	RouteInfo_SUBNET RouteInfo_RouteType = 1
	// Static route created by the user, including the default route to the
	// internet.
	RouteInfo_STATIC RouteInfo_RouteType = 2
	// Dynamic route exchanged between BGP peers.
	RouteInfo_DYNAMIC RouteInfo_RouteType = 3
	// A subnet route received from peering network or NCC Hub.
	RouteInfo_PEERING_SUBNET RouteInfo_RouteType = 4
	// A static route received from peering network.
	RouteInfo_PEERING_STATIC RouteInfo_RouteType = 5
	// A dynamic route received from peering network or NCC Hub.
	RouteInfo_PEERING_DYNAMIC RouteInfo_RouteType = 6
	// Policy based route.
	RouteInfo_POLICY_BASED RouteInfo_RouteType = 7
	// Advertised route. Synthetic route which is used to transition from the
	// StartFromPrivateNetwork state in Connectivity tests.
	RouteInfo_ADVERTISED RouteInfo_RouteType = 101
)

// Enum value maps for RouteInfo_RouteType.
var (
	RouteInfo_RouteType_name = map[int32]string{
		0:   "ROUTE_TYPE_UNSPECIFIED",
		1:   "SUBNET",
		2:   "STATIC",
		3:   "DYNAMIC",
		4:   "PEERING_SUBNET",
		5:   "PEERING_STATIC",
		6:   "PEERING_DYNAMIC",
		7:   "POLICY_BASED",
		101: "ADVERTISED",
	}
	RouteInfo_RouteType_value = map[string]int32{
		"ROUTE_TYPE_UNSPECIFIED": 0,
		"SUBNET":                 1,
		"STATIC":                 2,
		"DYNAMIC":                3,
		"PEERING_SUBNET":         4,
		"PEERING_STATIC":         5,
		"PEERING_DYNAMIC":        6,
		"POLICY_BASED":           7,
		"ADVERTISED":             101,
	}
)

func (x RouteInfo_RouteType) Enum() *RouteInfo_RouteType {
	p := new(RouteInfo_RouteType)
	*p = x
	return p
}

func (x RouteInfo_RouteType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouteInfo_RouteType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[5].Descriptor()
}

func (RouteInfo_RouteType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[5]
}

func (x RouteInfo_RouteType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouteInfo_RouteType.Descriptor instead.
func (RouteInfo_RouteType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{5, 0}
}

// Type of next hop:
type RouteInfo_NextHopType int32

const (
	// Unspecified type. Default value.
	RouteInfo_NEXT_HOP_TYPE_UNSPECIFIED RouteInfo_NextHopType = 0
	// Next hop is an IP address.
	RouteInfo_NEXT_HOP_IP RouteInfo_NextHopType = 1
	// Next hop is a Compute Engine instance.
	RouteInfo_NEXT_HOP_INSTANCE RouteInfo_NextHopType = 2
	// Next hop is a VPC network gateway.
	RouteInfo_NEXT_HOP_NETWORK RouteInfo_NextHopType = 3
	// Next hop is a peering VPC. This scenario only happens when the user
	// doesn't have permissions to the project where the next hop resource is
	// located.
	RouteInfo_NEXT_HOP_PEERING RouteInfo_NextHopType = 4
	// Next hop is an interconnect.
	RouteInfo_NEXT_HOP_INTERCONNECT RouteInfo_NextHopType = 5
	// Next hop is a VPN tunnel.
	RouteInfo_NEXT_HOP_VPN_TUNNEL RouteInfo_NextHopType = 6
	// Next hop is a VPN gateway. This scenario only happens when tracing
	// connectivity from an on-premises network to Google Cloud through a VPN.
	// The analysis simulates a packet departing from the on-premises network
	// through a VPN tunnel and arriving at a Cloud VPN gateway.
	RouteInfo_NEXT_HOP_VPN_GATEWAY RouteInfo_NextHopType = 7
	// Next hop is an internet gateway.
	RouteInfo_NEXT_HOP_INTERNET_GATEWAY RouteInfo_NextHopType = 8
	// Next hop is blackhole; that is, the next hop either does not exist or is
	// unusable.
	RouteInfo_NEXT_HOP_BLACKHOLE RouteInfo_NextHopType = 9
	// Next hop is the forwarding rule of an Internal Load Balancer.
	RouteInfo_NEXT_HOP_ILB RouteInfo_NextHopType = 10
	// Next hop is a
	// [router appliance
	// instance](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/ra-overview).
	RouteInfo_NEXT_HOP_ROUTER_APPLIANCE RouteInfo_NextHopType = 11
	// Next hop is an NCC hub. This scenario only happens when the user doesn't
	// have permissions to the project where the next hop resource is located.
	RouteInfo_NEXT_HOP_NCC_HUB RouteInfo_NextHopType = 12
	// Next hop is Secure Web Proxy Gateway.
	RouteInfo_SECURE_WEB_PROXY_GATEWAY RouteInfo_NextHopType = 13
)

// Enum value maps for RouteInfo_NextHopType.
var (
	RouteInfo_NextHopType_name = map[int32]string{
		0:  "NEXT_HOP_TYPE_UNSPECIFIED",
		1:  "NEXT_HOP_IP",
		2:  "NEXT_HOP_INSTANCE",
		3:  "NEXT_HOP_NETWORK",
		4:  "NEXT_HOP_PEERING",
		5:  "NEXT_HOP_INTERCONNECT",
		6:  "NEXT_HOP_VPN_TUNNEL",
		7:  "NEXT_HOP_VPN_GATEWAY",
		8:  "NEXT_HOP_INTERNET_GATEWAY",
		9:  "NEXT_HOP_BLACKHOLE",
		10: "NEXT_HOP_ILB",
		11: "NEXT_HOP_ROUTER_APPLIANCE",
		12: "NEXT_HOP_NCC_HUB",
		13: "SECURE_WEB_PROXY_GATEWAY",
	}
	RouteInfo_NextHopType_value = map[string]int32{
		"NEXT_HOP_TYPE_UNSPECIFIED": 0,
		"NEXT_HOP_IP":               1,
		"NEXT_HOP_INSTANCE":         2,
		"NEXT_HOP_NETWORK":          3,
		"NEXT_HOP_PEERING":          4,
		"NEXT_HOP_INTERCONNECT":     5,
		"NEXT_HOP_VPN_TUNNEL":       6,
		"NEXT_HOP_VPN_GATEWAY":      7,
		"NEXT_HOP_INTERNET_GATEWAY": 8,
		"NEXT_HOP_BLACKHOLE":        9,
		"NEXT_HOP_ILB":              10,
		"NEXT_HOP_ROUTER_APPLIANCE": 11,
		"NEXT_HOP_NCC_HUB":          12,
		"SECURE_WEB_PROXY_GATEWAY":  13,
	}
)

func (x RouteInfo_NextHopType) Enum() *RouteInfo_NextHopType {
	p := new(RouteInfo_NextHopType)
	*p = x
	return p
}

func (x RouteInfo_NextHopType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouteInfo_NextHopType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[6].Descriptor()
}

func (RouteInfo_NextHopType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[6]
}

func (x RouteInfo_NextHopType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouteInfo_NextHopType.Descriptor instead.
func (RouteInfo_NextHopType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{5, 1}
}

// Indicates where routes are applicable.
type RouteInfo_RouteScope int32

const (
	// Unspecified scope. Default value.
	RouteInfo_ROUTE_SCOPE_UNSPECIFIED RouteInfo_RouteScope = 0
	// Route is applicable to packets in Network.
	RouteInfo_NETWORK RouteInfo_RouteScope = 1
	// Route is applicable to packets using NCC Hub's routing table.
	RouteInfo_NCC_HUB RouteInfo_RouteScope = 2
)

// Enum value maps for RouteInfo_RouteScope.
var (
	RouteInfo_RouteScope_name = map[int32]string{
		0: "ROUTE_SCOPE_UNSPECIFIED",
		1: "NETWORK",
		2: "NCC_HUB",
	}
	RouteInfo_RouteScope_value = map[string]int32{
		"ROUTE_SCOPE_UNSPECIFIED": 0,
		"NETWORK":                 1,
		"NCC_HUB":                 2,
	}
)

func (x RouteInfo_RouteScope) Enum() *RouteInfo_RouteScope {
	p := new(RouteInfo_RouteScope)
	*p = x
	return p
}

func (x RouteInfo_RouteScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouteInfo_RouteScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[7].Descriptor()
}

func (RouteInfo_RouteScope) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[7]
}

func (x RouteInfo_RouteScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouteInfo_RouteScope.Descriptor instead.
func (RouteInfo_RouteScope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{5, 2}
}

// Recognized type of a Google Service.
type GoogleServiceInfo_GoogleServiceType int32

const (
	// Unspecified Google Service.
	GoogleServiceInfo_GOOGLE_SERVICE_TYPE_UNSPECIFIED GoogleServiceInfo_GoogleServiceType = 0
	// Identity aware proxy.
	// https://cloud.google.com/iap/docs/using-tcp-forwarding
	GoogleServiceInfo_IAP GoogleServiceInfo_GoogleServiceType = 1
	// One of two services sharing IP ranges:
	// * Load Balancer proxy
	// * Centralized Health Check prober
	// https://cloud.google.com/load-balancing/docs/firewall-rules
	GoogleServiceInfo_GFE_PROXY_OR_HEALTH_CHECK_PROBER GoogleServiceInfo_GoogleServiceType = 2
	// Connectivity from Cloud DNS to forwarding targets or alternate name
	// servers that use private routing.
	// https://cloud.google.com/dns/docs/zones/forwarding-zones#firewall-rules
	// https://cloud.google.com/dns/docs/policies#firewall-rules
	GoogleServiceInfo_CLOUD_DNS GoogleServiceInfo_GoogleServiceType = 3
	// private.googleapis.com and restricted.googleapis.com
	GoogleServiceInfo_GOOGLE_API GoogleServiceInfo_GoogleServiceType = 4
	// Google API via Private Service Connect.
	// https://cloud.google.com/vpc/docs/configure-private-service-connect-apis
	GoogleServiceInfo_GOOGLE_API_PSC GoogleServiceInfo_GoogleServiceType = 5
	// Google API via VPC Service Controls.
	// https://cloud.google.com/vpc/docs/configure-private-service-connect-apis
	GoogleServiceInfo_GOOGLE_API_VPC_SC GoogleServiceInfo_GoogleServiceType = 6
	// Google API via Serverless VPC Access.
	// https://cloud.google.com/vpc/docs/serverless-vpc-access
	GoogleServiceInfo_SERVERLESS_VPC_ACCESS GoogleServiceInfo_GoogleServiceType = 7
)

// Enum value maps for GoogleServiceInfo_GoogleServiceType.
var (
	GoogleServiceInfo_GoogleServiceType_name = map[int32]string{
		0: "GOOGLE_SERVICE_TYPE_UNSPECIFIED",
		1: "IAP",
		2: "GFE_PROXY_OR_HEALTH_CHECK_PROBER",
		3: "CLOUD_DNS",
		4: "GOOGLE_API",
		5: "GOOGLE_API_PSC",
		6: "GOOGLE_API_VPC_SC",
		7: "SERVERLESS_VPC_ACCESS",
	}
	GoogleServiceInfo_GoogleServiceType_value = map[string]int32{
		"GOOGLE_SERVICE_TYPE_UNSPECIFIED":  0,
		"IAP":                              1,
		"GFE_PROXY_OR_HEALTH_CHECK_PROBER": 2,
		"CLOUD_DNS":                        3,
		"GOOGLE_API":                       4,
		"GOOGLE_API_PSC":                   5,
		"GOOGLE_API_VPC_SC":                6,
		"SERVERLESS_VPC_ACCESS":            7,
	}
)

func (x GoogleServiceInfo_GoogleServiceType) Enum() *GoogleServiceInfo_GoogleServiceType {
	p := new(GoogleServiceInfo_GoogleServiceType)
	*p = x
	return p
}

func (x GoogleServiceInfo_GoogleServiceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GoogleServiceInfo_GoogleServiceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[8].Descriptor()
}

func (GoogleServiceInfo_GoogleServiceType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[8]
}

func (x GoogleServiceInfo_GoogleServiceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GoogleServiceInfo_GoogleServiceType.Descriptor instead.
func (GoogleServiceInfo_GoogleServiceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{6, 0}
}

// The type definition for a load balancer:
type LoadBalancerInfo_LoadBalancerType int32

const (
	// Type is unspecified.
	LoadBalancerInfo_LOAD_BALANCER_TYPE_UNSPECIFIED LoadBalancerInfo_LoadBalancerType = 0
	// Internal TCP/UDP load balancer.
	LoadBalancerInfo_INTERNAL_TCP_UDP LoadBalancerInfo_LoadBalancerType = 1
	// Network TCP/UDP load balancer.
	LoadBalancerInfo_NETWORK_TCP_UDP LoadBalancerInfo_LoadBalancerType = 2
	// HTTP(S) proxy load balancer.
	LoadBalancerInfo_HTTP_PROXY LoadBalancerInfo_LoadBalancerType = 3
	// TCP proxy load balancer.
	LoadBalancerInfo_TCP_PROXY LoadBalancerInfo_LoadBalancerType = 4
	// SSL proxy load balancer.
	LoadBalancerInfo_SSL_PROXY LoadBalancerInfo_LoadBalancerType = 5
)

// Enum value maps for LoadBalancerInfo_LoadBalancerType.
var (
	LoadBalancerInfo_LoadBalancerType_name = map[int32]string{
		0: "LOAD_BALANCER_TYPE_UNSPECIFIED",
		1: "INTERNAL_TCP_UDP",
		2: "NETWORK_TCP_UDP",
		3: "HTTP_PROXY",
		4: "TCP_PROXY",
		5: "SSL_PROXY",
	}
	LoadBalancerInfo_LoadBalancerType_value = map[string]int32{
		"LOAD_BALANCER_TYPE_UNSPECIFIED": 0,
		"INTERNAL_TCP_UDP":               1,
		"NETWORK_TCP_UDP":                2,
		"HTTP_PROXY":                     3,
		"TCP_PROXY":                      4,
		"SSL_PROXY":                      5,
	}
)

func (x LoadBalancerInfo_LoadBalancerType) Enum() *LoadBalancerInfo_LoadBalancerType {
	p := new(LoadBalancerInfo_LoadBalancerType)
	*p = x
	return p
}

func (x LoadBalancerInfo_LoadBalancerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancerInfo_LoadBalancerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[9].Descriptor()
}

func (LoadBalancerInfo_LoadBalancerType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[9]
}

func (x LoadBalancerInfo_LoadBalancerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancerInfo_LoadBalancerType.Descriptor instead.
func (LoadBalancerInfo_LoadBalancerType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{8, 0}
}

// The type definition for a load balancer backend configuration:
type LoadBalancerInfo_BackendType int32

const (
	// Type is unspecified.
	LoadBalancerInfo_BACKEND_TYPE_UNSPECIFIED LoadBalancerInfo_BackendType = 0
	// Backend Service as the load balancer's backend.
	LoadBalancerInfo_BACKEND_SERVICE LoadBalancerInfo_BackendType = 1
	// Target Pool as the load balancer's backend.
	LoadBalancerInfo_TARGET_POOL LoadBalancerInfo_BackendType = 2
	// Target Instance as the load balancer's backend.
	LoadBalancerInfo_TARGET_INSTANCE LoadBalancerInfo_BackendType = 3
)

// Enum value maps for LoadBalancerInfo_BackendType.
var (
	LoadBalancerInfo_BackendType_name = map[int32]string{
		0: "BACKEND_TYPE_UNSPECIFIED",
		1: "BACKEND_SERVICE",
		2: "TARGET_POOL",
		3: "TARGET_INSTANCE",
	}
	LoadBalancerInfo_BackendType_value = map[string]int32{
		"BACKEND_TYPE_UNSPECIFIED": 0,
		"BACKEND_SERVICE":          1,
		"TARGET_POOL":              2,
		"TARGET_INSTANCE":          3,
	}
)

func (x LoadBalancerInfo_BackendType) Enum() *LoadBalancerInfo_BackendType {
	p := new(LoadBalancerInfo_BackendType)
	*p = x
	return p
}

func (x LoadBalancerInfo_BackendType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancerInfo_BackendType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[10].Descriptor()
}

func (LoadBalancerInfo_BackendType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[10]
}

func (x LoadBalancerInfo_BackendType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancerInfo_BackendType.Descriptor instead.
func (LoadBalancerInfo_BackendType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{8, 1}
}

// State of a health check firewall configuration:
type LoadBalancerBackend_HealthCheckFirewallState int32

const (
	// State is unspecified. Default state if not populated.
	LoadBalancerBackend_HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED LoadBalancerBackend_HealthCheckFirewallState = 0
	// There are configured firewall rules to allow health check probes to the
	// backend.
	LoadBalancerBackend_CONFIGURED LoadBalancerBackend_HealthCheckFirewallState = 1
	// There are firewall rules configured to allow partial health check ranges
	// or block all health check ranges.
	// If a health check probe is sent from denied IP ranges,
	// the health check to the backend will fail. Then, the backend will be
	// marked unhealthy and will not receive traffic sent to the load balancer.
	LoadBalancerBackend_MISCONFIGURED LoadBalancerBackend_HealthCheckFirewallState = 2
)

// Enum value maps for LoadBalancerBackend_HealthCheckFirewallState.
var (
	LoadBalancerBackend_HealthCheckFirewallState_name = map[int32]string{
		0: "HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED",
		1: "CONFIGURED",
		2: "MISCONFIGURED",
	}
	LoadBalancerBackend_HealthCheckFirewallState_value = map[string]int32{
		"HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED": 0,
		"CONFIGURED":    1,
		"MISCONFIGURED": 2,
	}
)

func (x LoadBalancerBackend_HealthCheckFirewallState) Enum() *LoadBalancerBackend_HealthCheckFirewallState {
	p := new(LoadBalancerBackend_HealthCheckFirewallState)
	*p = x
	return p
}

func (x LoadBalancerBackend_HealthCheckFirewallState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancerBackend_HealthCheckFirewallState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[11].Descriptor()
}

func (LoadBalancerBackend_HealthCheckFirewallState) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[11]
}

func (x LoadBalancerBackend_HealthCheckFirewallState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancerBackend_HealthCheckFirewallState.Descriptor instead.
func (LoadBalancerBackend_HealthCheckFirewallState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{9, 0}
}

// Types of VPN routing policy. For details, refer to [Networks and Tunnel
// routing](https://cloud.google.com/network-connectivity/docs/vpn/concepts/choosing-networks-routing/).
type VpnTunnelInfo_RoutingType int32

const (
	// Unspecified type. Default value.
	VpnTunnelInfo_ROUTING_TYPE_UNSPECIFIED VpnTunnelInfo_RoutingType = 0
	// Route based VPN.
	VpnTunnelInfo_ROUTE_BASED VpnTunnelInfo_RoutingType = 1
	// Policy based routing.
	VpnTunnelInfo_POLICY_BASED VpnTunnelInfo_RoutingType = 2
	// Dynamic (BGP) routing.
	VpnTunnelInfo_DYNAMIC VpnTunnelInfo_RoutingType = 3
)

// Enum value maps for VpnTunnelInfo_RoutingType.
var (
	VpnTunnelInfo_RoutingType_name = map[int32]string{
		0: "ROUTING_TYPE_UNSPECIFIED",
		1: "ROUTE_BASED",
		2: "POLICY_BASED",
		3: "DYNAMIC",
	}
	VpnTunnelInfo_RoutingType_value = map[string]int32{
		"ROUTING_TYPE_UNSPECIFIED": 0,
		"ROUTE_BASED":              1,
		"POLICY_BASED":             2,
		"DYNAMIC":                  3,
	}
)

func (x VpnTunnelInfo_RoutingType) Enum() *VpnTunnelInfo_RoutingType {
	p := new(VpnTunnelInfo_RoutingType)
	*p = x
	return p
}

func (x VpnTunnelInfo_RoutingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpnTunnelInfo_RoutingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[12].Descriptor()
}

func (VpnTunnelInfo_RoutingType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[12]
}

func (x VpnTunnelInfo_RoutingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpnTunnelInfo_RoutingType.Descriptor instead.
func (VpnTunnelInfo_RoutingType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{12, 0}
}

// What type of interconnect attachment this is.
type InterconnectAttachmentInfo_Type int32

const (
	// Unspecified type.
	InterconnectAttachmentInfo_TYPE_UNSPECIFIED InterconnectAttachmentInfo_Type = 0
	// Attachment to a dedicated interconnect.
	InterconnectAttachmentInfo_DEDICATED InterconnectAttachmentInfo_Type = 1
	// Attachment to a partner interconnect, created by the customer.
	InterconnectAttachmentInfo_PARTNER InterconnectAttachmentInfo_Type = 2
	// Attachment to a partner interconnect, created by the partner.
	InterconnectAttachmentInfo_PARTNER_PROVIDER InterconnectAttachmentInfo_Type = 3
	// Attachment to a L2 interconnect, created by the customer.
	InterconnectAttachmentInfo_L2_DEDICATED InterconnectAttachmentInfo_Type = 4
)

// Enum value maps for InterconnectAttachmentInfo_Type.
var (
	InterconnectAttachmentInfo_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "DEDICATED",
		2: "PARTNER",
		3: "PARTNER_PROVIDER",
		4: "L2_DEDICATED",
	}
	InterconnectAttachmentInfo_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"DEDICATED":        1,
		"PARTNER":          2,
		"PARTNER_PROVIDER": 3,
		"L2_DEDICATED":     4,
	}
)

func (x InterconnectAttachmentInfo_Type) Enum() *InterconnectAttachmentInfo_Type {
	p := new(InterconnectAttachmentInfo_Type)
	*p = x
	return p
}

func (x InterconnectAttachmentInfo_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachmentInfo_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[13].Descriptor()
}

func (InterconnectAttachmentInfo_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[13]
}

func (x InterconnectAttachmentInfo_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachmentInfo_Type.Descriptor instead.
func (InterconnectAttachmentInfo_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{13, 0}
}

// Deliver target types:
type DeliverInfo_Target int32

const (
	// Target not specified.
	DeliverInfo_TARGET_UNSPECIFIED DeliverInfo_Target = 0
	// Target is a Compute Engine instance.
	DeliverInfo_INSTANCE DeliverInfo_Target = 1
	// Target is the internet.
	DeliverInfo_INTERNET DeliverInfo_Target = 2
	// Target is a Google API.
	DeliverInfo_GOOGLE_API DeliverInfo_Target = 3
	// Target is a Google Kubernetes Engine cluster master.
	DeliverInfo_GKE_MASTER DeliverInfo_Target = 4
	// Target is a Cloud SQL instance.
	DeliverInfo_CLOUD_SQL_INSTANCE DeliverInfo_Target = 5
	// Target is a published service that uses [Private Service
	// Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
	DeliverInfo_PSC_PUBLISHED_SERVICE DeliverInfo_Target = 6
	// Target is Google APIs that use [Private Service
	// Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-apis).
	DeliverInfo_PSC_GOOGLE_API DeliverInfo_Target = 7
	// Target is a VPC-SC that uses [Private Service
	// Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-apis).
	DeliverInfo_PSC_VPC_SC DeliverInfo_Target = 8
	// Target is a serverless network endpoint group.
	DeliverInfo_SERVERLESS_NEG DeliverInfo_Target = 9
	// Target is a Cloud Storage bucket.
	DeliverInfo_STORAGE_BUCKET DeliverInfo_Target = 10
	// Target is a private network. Used only for return traces.
	DeliverInfo_PRIVATE_NETWORK DeliverInfo_Target = 11
	// Target is a Cloud Function. Used only for return traces.
	DeliverInfo_CLOUD_FUNCTION DeliverInfo_Target = 12
	// Target is a App Engine service version. Used only for return traces.
	DeliverInfo_APP_ENGINE_VERSION DeliverInfo_Target = 13
	// Target is a Cloud Run revision. Used only for return traces.
	DeliverInfo_CLOUD_RUN_REVISION DeliverInfo_Target = 14
	// Target is a Google-managed service. Used only for return traces.
	DeliverInfo_GOOGLE_MANAGED_SERVICE DeliverInfo_Target = 15
	// Target is a Redis Instance.
	DeliverInfo_REDIS_INSTANCE DeliverInfo_Target = 16
	// Target is a Redis Cluster.
	DeliverInfo_REDIS_CLUSTER DeliverInfo_Target = 17
)

// Enum value maps for DeliverInfo_Target.
var (
	DeliverInfo_Target_name = map[int32]string{
		0:  "TARGET_UNSPECIFIED",
		1:  "INSTANCE",
		2:  "INTERNET",
		3:  "GOOGLE_API",
		4:  "GKE_MASTER",
		5:  "CLOUD_SQL_INSTANCE",
		6:  "PSC_PUBLISHED_SERVICE",
		7:  "PSC_GOOGLE_API",
		8:  "PSC_VPC_SC",
		9:  "SERVERLESS_NEG",
		10: "STORAGE_BUCKET",
		11: "PRIVATE_NETWORK",
		12: "CLOUD_FUNCTION",
		13: "APP_ENGINE_VERSION",
		14: "CLOUD_RUN_REVISION",
		15: "GOOGLE_MANAGED_SERVICE",
		16: "REDIS_INSTANCE",
		17: "REDIS_CLUSTER",
	}
	DeliverInfo_Target_value = map[string]int32{
		"TARGET_UNSPECIFIED":     0,
		"INSTANCE":               1,
		"INTERNET":               2,
		"GOOGLE_API":             3,
		"GKE_MASTER":             4,
		"CLOUD_SQL_INSTANCE":     5,
		"PSC_PUBLISHED_SERVICE":  6,
		"PSC_GOOGLE_API":         7,
		"PSC_VPC_SC":             8,
		"SERVERLESS_NEG":         9,
		"STORAGE_BUCKET":         10,
		"PRIVATE_NETWORK":        11,
		"CLOUD_FUNCTION":         12,
		"APP_ENGINE_VERSION":     13,
		"CLOUD_RUN_REVISION":     14,
		"GOOGLE_MANAGED_SERVICE": 15,
		"REDIS_INSTANCE":         16,
		"REDIS_CLUSTER":          17,
	}
)

func (x DeliverInfo_Target) Enum() *DeliverInfo_Target {
	p := new(DeliverInfo_Target)
	*p = x
	return p
}

func (x DeliverInfo_Target) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeliverInfo_Target) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[14].Descriptor()
}

func (DeliverInfo_Target) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[14]
}

func (x DeliverInfo_Target) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeliverInfo_Target.Descriptor instead.
func (DeliverInfo_Target) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{15, 0}
}

// Recognized type of a Google Service.
type DeliverInfo_GoogleServiceType int32

const (
	// Unspecified Google Service.
	DeliverInfo_GOOGLE_SERVICE_TYPE_UNSPECIFIED DeliverInfo_GoogleServiceType = 0
	// Identity aware proxy.
	// https://cloud.google.com/iap/docs/using-tcp-forwarding
	DeliverInfo_IAP DeliverInfo_GoogleServiceType = 1
	// One of two services sharing IP ranges:
	// * Load Balancer proxy
	// * Centralized Health Check prober
	// https://cloud.google.com/load-balancing/docs/firewall-rules
	DeliverInfo_GFE_PROXY_OR_HEALTH_CHECK_PROBER DeliverInfo_GoogleServiceType = 2
	// Connectivity from Cloud DNS to forwarding targets or alternate name
	// servers that use private routing.
	// https://cloud.google.com/dns/docs/zones/forwarding-zones#firewall-rules
	// https://cloud.google.com/dns/docs/policies#firewall-rules
	DeliverInfo_CLOUD_DNS DeliverInfo_GoogleServiceType = 3
	// private.googleapis.com and restricted.googleapis.com
	DeliverInfo_PRIVATE_GOOGLE_ACCESS DeliverInfo_GoogleServiceType = 4
	// Google API via Private Service Connect.
	// https://cloud.google.com/vpc/docs/configure-private-service-connect-apis
	// Google API via Serverless VPC Access.
	// https://cloud.google.com/vpc/docs/serverless-vpc-access
	DeliverInfo_SERVERLESS_VPC_ACCESS DeliverInfo_GoogleServiceType = 5
)

// Enum value maps for DeliverInfo_GoogleServiceType.
var (
	DeliverInfo_GoogleServiceType_name = map[int32]string{
		0: "GOOGLE_SERVICE_TYPE_UNSPECIFIED",
		1: "IAP",
		2: "GFE_PROXY_OR_HEALTH_CHECK_PROBER",
		3: "CLOUD_DNS",
		4: "PRIVATE_GOOGLE_ACCESS",
		5: "SERVERLESS_VPC_ACCESS",
	}
	DeliverInfo_GoogleServiceType_value = map[string]int32{
		"GOOGLE_SERVICE_TYPE_UNSPECIFIED":  0,
		"IAP":                              1,
		"GFE_PROXY_OR_HEALTH_CHECK_PROBER": 2,
		"CLOUD_DNS":                        3,
		"PRIVATE_GOOGLE_ACCESS":            4,
		"SERVERLESS_VPC_ACCESS":            5,
	}
)

func (x DeliverInfo_GoogleServiceType) Enum() *DeliverInfo_GoogleServiceType {
	p := new(DeliverInfo_GoogleServiceType)
	*p = x
	return p
}

func (x DeliverInfo_GoogleServiceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeliverInfo_GoogleServiceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[15].Descriptor()
}

func (DeliverInfo_GoogleServiceType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[15]
}

func (x DeliverInfo_GoogleServiceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeliverInfo_GoogleServiceType.Descriptor instead.
func (DeliverInfo_GoogleServiceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{15, 1}
}

// Forward target types.
type ForwardInfo_Target int32

const (
	// Target not specified.
	ForwardInfo_TARGET_UNSPECIFIED ForwardInfo_Target = 0
	// Forwarded to a VPC peering network.
	ForwardInfo_PEERING_VPC ForwardInfo_Target = 1
	// Forwarded to a Cloud VPN gateway.
	ForwardInfo_VPN_GATEWAY ForwardInfo_Target = 2
	// Forwarded to a Cloud Interconnect connection.
	ForwardInfo_INTERCONNECT ForwardInfo_Target = 3
	// Forwarded to a Google Kubernetes Engine Container cluster master.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	ForwardInfo_GKE_MASTER ForwardInfo_Target = 4
	// Forwarded to the next hop of a custom route imported from a peering VPC.
	ForwardInfo_IMPORTED_CUSTOM_ROUTE_NEXT_HOP ForwardInfo_Target = 5
	// Forwarded to a Cloud SQL instance.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	ForwardInfo_CLOUD_SQL_INSTANCE ForwardInfo_Target = 6
	// Forwarded to a VPC network in another project.
	ForwardInfo_ANOTHER_PROJECT ForwardInfo_Target = 7
	// Forwarded to an NCC Hub.
	ForwardInfo_NCC_HUB ForwardInfo_Target = 8
	// Forwarded to a router appliance.
	ForwardInfo_ROUTER_APPLIANCE ForwardInfo_Target = 9
	// Forwarded to a Secure Web Proxy Gateway.
	ForwardInfo_SECURE_WEB_PROXY_GATEWAY ForwardInfo_Target = 10
)

// Enum value maps for ForwardInfo_Target.
var (
	ForwardInfo_Target_name = map[int32]string{
		0:  "TARGET_UNSPECIFIED",
		1:  "PEERING_VPC",
		2:  "VPN_GATEWAY",
		3:  "INTERCONNECT",
		4:  "GKE_MASTER",
		5:  "IMPORTED_CUSTOM_ROUTE_NEXT_HOP",
		6:  "CLOUD_SQL_INSTANCE",
		7:  "ANOTHER_PROJECT",
		8:  "NCC_HUB",
		9:  "ROUTER_APPLIANCE",
		10: "SECURE_WEB_PROXY_GATEWAY",
	}
	ForwardInfo_Target_value = map[string]int32{
		"TARGET_UNSPECIFIED":             0,
		"PEERING_VPC":                    1,
		"VPN_GATEWAY":                    2,
		"INTERCONNECT":                   3,
		"GKE_MASTER":                     4,
		"IMPORTED_CUSTOM_ROUTE_NEXT_HOP": 5,
		"CLOUD_SQL_INSTANCE":             6,
		"ANOTHER_PROJECT":                7,
		"NCC_HUB":                        8,
		"ROUTER_APPLIANCE":               9,
		"SECURE_WEB_PROXY_GATEWAY":       10,
	}
)

func (x ForwardInfo_Target) Enum() *ForwardInfo_Target {
	p := new(ForwardInfo_Target)
	*p = x
	return p
}

func (x ForwardInfo_Target) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardInfo_Target) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[16].Descriptor()
}

func (ForwardInfo_Target) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[16]
}

func (x ForwardInfo_Target) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardInfo_Target.Descriptor instead.
func (ForwardInfo_Target) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{16, 0}
}

// Abort cause types:
type AbortInfo_Cause int32

const (
	// Cause is unspecified.
	AbortInfo_CAUSE_UNSPECIFIED AbortInfo_Cause = 0
	// Aborted due to unknown network. Deprecated, not used in the new tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	AbortInfo_UNKNOWN_NETWORK AbortInfo_Cause = 1
	// Aborted because no project information can be derived from the test
	// input. Deprecated, not used in the new tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	AbortInfo_UNKNOWN_PROJECT AbortInfo_Cause = 3
	// Aborted because traffic is sent from a public IP to an instance without
	// an external IP. Deprecated, not used in the new tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	AbortInfo_NO_EXTERNAL_IP AbortInfo_Cause = 7
	// Aborted because none of the traces matches destination information
	// specified in the input test request. Deprecated, not used in the new
	// tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	AbortInfo_UNINTENDED_DESTINATION AbortInfo_Cause = 8
	// Aborted because the source endpoint could not be found. Deprecated, not
	// used in the new tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	AbortInfo_SOURCE_ENDPOINT_NOT_FOUND AbortInfo_Cause = 11
	// Aborted because the source network does not match the source endpoint.
	// Deprecated, not used in the new tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	AbortInfo_MISMATCHED_SOURCE_NETWORK AbortInfo_Cause = 12
	// Aborted because the destination endpoint could not be found. Deprecated,
	// not used in the new tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	AbortInfo_DESTINATION_ENDPOINT_NOT_FOUND AbortInfo_Cause = 13
	// Aborted because the destination network does not match the destination
	// endpoint. Deprecated, not used in the new tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	AbortInfo_MISMATCHED_DESTINATION_NETWORK AbortInfo_Cause = 14
	// Aborted because no endpoint with the packet's destination IP address is
	// found.
	AbortInfo_UNKNOWN_IP AbortInfo_Cause = 2
	// Aborted because no endpoint with the packet's destination IP is found in
	// the Google-managed project.
	AbortInfo_GOOGLE_MANAGED_SERVICE_UNKNOWN_IP AbortInfo_Cause = 32
	// Aborted because the source IP address doesn't belong to any of the
	// subnets of the source VPC network.
	AbortInfo_SOURCE_IP_ADDRESS_NOT_IN_SOURCE_NETWORK AbortInfo_Cause = 23
	// Aborted because user lacks permission to access all or part of the
	// network configurations required to run the test.
	AbortInfo_PERMISSION_DENIED AbortInfo_Cause = 4
	// Aborted because user lacks permission to access Cloud NAT configs
	// required to run the test.
	AbortInfo_PERMISSION_DENIED_NO_CLOUD_NAT_CONFIGS AbortInfo_Cause = 28
	// Aborted because user lacks permission to access Network endpoint group
	// endpoint configs required to run the test.
	AbortInfo_PERMISSION_DENIED_NO_NEG_ENDPOINT_CONFIGS AbortInfo_Cause = 29
	// Aborted because user lacks permission to access Cloud Router configs
	// required to run the test.
	AbortInfo_PERMISSION_DENIED_NO_CLOUD_ROUTER_CONFIGS AbortInfo_Cause = 36
	// Aborted because no valid source or destination endpoint is derived from
	// the input test request.
	AbortInfo_NO_SOURCE_LOCATION AbortInfo_Cause = 5
	// Aborted because the source or destination endpoint specified in
	// the request is invalid. Some examples:
	// - The request might contain malformed resource URI, project ID, or IP
	// address.
	// - The request might contain inconsistent information (for example, the
	// request might include both the instance and the network, but the instance
	// might not have a NIC in that network).
	AbortInfo_INVALID_ARGUMENT AbortInfo_Cause = 6
	// Aborted because the number of steps in the trace exceeds a certain
	// limit. It might be caused by a routing loop.
	AbortInfo_TRACE_TOO_LONG AbortInfo_Cause = 9
	// Aborted due to internal server error.
	AbortInfo_INTERNAL_ERROR AbortInfo_Cause = 10
	// Aborted because the test scenario is not supported.
	AbortInfo_UNSUPPORTED AbortInfo_Cause = 15
	// Aborted because the source and destination resources have no common IP
	// version.
	AbortInfo_MISMATCHED_IP_VERSION AbortInfo_Cause = 16
	// Aborted because the connection between the control plane and the node of
	// the source cluster is initiated by the node and managed by the
	// Konnectivity proxy.
	AbortInfo_GKE_KONNECTIVITY_PROXY_UNSUPPORTED AbortInfo_Cause = 17
	// Aborted because expected resource configuration was missing.
	AbortInfo_RESOURCE_CONFIG_NOT_FOUND AbortInfo_Cause = 18
	// Aborted because expected VM instance configuration was missing.
	AbortInfo_VM_INSTANCE_CONFIG_NOT_FOUND AbortInfo_Cause = 24
	// Aborted because expected network configuration was missing.
	AbortInfo_NETWORK_CONFIG_NOT_FOUND AbortInfo_Cause = 25
	// Aborted because expected firewall configuration was missing.
	AbortInfo_FIREWALL_CONFIG_NOT_FOUND AbortInfo_Cause = 26
	// Aborted because expected route configuration was missing.
	AbortInfo_ROUTE_CONFIG_NOT_FOUND AbortInfo_Cause = 27
	// Aborted because PSC endpoint selection for the Google-managed service
	// is ambiguous (several PSC endpoints satisfy test input).
	AbortInfo_GOOGLE_MANAGED_SERVICE_AMBIGUOUS_PSC_ENDPOINT AbortInfo_Cause = 19
	// Aborted because endpoint selection for the Google-managed service is
	// ambiguous (several endpoints satisfy test input).
	AbortInfo_GOOGLE_MANAGED_SERVICE_AMBIGUOUS_ENDPOINT AbortInfo_Cause = 39
	// Aborted because tests with a PSC-based Cloud SQL instance as a source are
	// not supported.
	AbortInfo_SOURCE_PSC_CLOUD_SQL_UNSUPPORTED AbortInfo_Cause = 20
	// Aborted because tests with a Redis Cluster as a source are not supported.
	AbortInfo_SOURCE_REDIS_CLUSTER_UNSUPPORTED AbortInfo_Cause = 34
	// Aborted because tests with a Redis Instance as a source are not
	// supported.
	AbortInfo_SOURCE_REDIS_INSTANCE_UNSUPPORTED AbortInfo_Cause = 35
	// Aborted because tests with a forwarding rule as a source are not
	// supported.
	AbortInfo_SOURCE_FORWARDING_RULE_UNSUPPORTED AbortInfo_Cause = 21
	// Aborted because one of the endpoints is a non-routable IP address
	// (loopback, link-local, etc).
	AbortInfo_NON_ROUTABLE_IP_ADDRESS AbortInfo_Cause = 22
	// Aborted due to an unknown issue in the Google-managed project.
	AbortInfo_UNKNOWN_ISSUE_IN_GOOGLE_MANAGED_PROJECT AbortInfo_Cause = 30
	// Aborted due to an unsupported configuration of the Google-managed
	// project.
	AbortInfo_UNSUPPORTED_GOOGLE_MANAGED_PROJECT_CONFIG AbortInfo_Cause = 31
	// Aborted because the source endpoint is a Cloud Run revision with direct
	// VPC access enabled, but there are no reserved serverless IP ranges.
	AbortInfo_NO_SERVERLESS_IP_RANGES AbortInfo_Cause = 37
	// Aborted because the used protocol is not supported for the used IP
	// version.
	AbortInfo_IP_VERSION_PROTOCOL_MISMATCH AbortInfo_Cause = 40
)

// Enum value maps for AbortInfo_Cause.
var (
	AbortInfo_Cause_name = map[int32]string{
		0:  "CAUSE_UNSPECIFIED",
		1:  "UNKNOWN_NETWORK",
		3:  "UNKNOWN_PROJECT",
		7:  "NO_EXTERNAL_IP",
		8:  "UNINTENDED_DESTINATION",
		11: "SOURCE_ENDPOINT_NOT_FOUND",
		12: "MISMATCHED_SOURCE_NETWORK",
		13: "DESTINATION_ENDPOINT_NOT_FOUND",
		14: "MISMATCHED_DESTINATION_NETWORK",
		2:  "UNKNOWN_IP",
		32: "GOOGLE_MANAGED_SERVICE_UNKNOWN_IP",
		23: "SOURCE_IP_ADDRESS_NOT_IN_SOURCE_NETWORK",
		4:  "PERMISSION_DENIED",
		28: "PERMISSION_DENIED_NO_CLOUD_NAT_CONFIGS",
		29: "PERMISSION_DENIED_NO_NEG_ENDPOINT_CONFIGS",
		36: "PERMISSION_DENIED_NO_CLOUD_ROUTER_CONFIGS",
		5:  "NO_SOURCE_LOCATION",
		6:  "INVALID_ARGUMENT",
		9:  "TRACE_TOO_LONG",
		10: "INTERNAL_ERROR",
		15: "UNSUPPORTED",
		16: "MISMATCHED_IP_VERSION",
		17: "GKE_KONNECTIVITY_PROXY_UNSUPPORTED",
		18: "RESOURCE_CONFIG_NOT_FOUND",
		24: "VM_INSTANCE_CONFIG_NOT_FOUND",
		25: "NETWORK_CONFIG_NOT_FOUND",
		26: "FIREWALL_CONFIG_NOT_FOUND",
		27: "ROUTE_CONFIG_NOT_FOUND",
		19: "GOOGLE_MANAGED_SERVICE_AMBIGUOUS_PSC_ENDPOINT",
		39: "GOOGLE_MANAGED_SERVICE_AMBIGUOUS_ENDPOINT",
		20: "SOURCE_PSC_CLOUD_SQL_UNSUPPORTED",
		34: "SOURCE_REDIS_CLUSTER_UNSUPPORTED",
		35: "SOURCE_REDIS_INSTANCE_UNSUPPORTED",
		21: "SOURCE_FORWARDING_RULE_UNSUPPORTED",
		22: "NON_ROUTABLE_IP_ADDRESS",
		30: "UNKNOWN_ISSUE_IN_GOOGLE_MANAGED_PROJECT",
		31: "UNSUPPORTED_GOOGLE_MANAGED_PROJECT_CONFIG",
		37: "NO_SERVERLESS_IP_RANGES",
		40: "IP_VERSION_PROTOCOL_MISMATCH",
	}
	AbortInfo_Cause_value = map[string]int32{
		"CAUSE_UNSPECIFIED":                             0,
		"UNKNOWN_NETWORK":                               1,
		"UNKNOWN_PROJECT":                               3,
		"NO_EXTERNAL_IP":                                7,
		"UNINTENDED_DESTINATION":                        8,
		"SOURCE_ENDPOINT_NOT_FOUND":                     11,
		"MISMATCHED_SOURCE_NETWORK":                     12,
		"DESTINATION_ENDPOINT_NOT_FOUND":                13,
		"MISMATCHED_DESTINATION_NETWORK":                14,
		"UNKNOWN_IP":                                    2,
		"GOOGLE_MANAGED_SERVICE_UNKNOWN_IP":             32,
		"SOURCE_IP_ADDRESS_NOT_IN_SOURCE_NETWORK":       23,
		"PERMISSION_DENIED":                             4,
		"PERMISSION_DENIED_NO_CLOUD_NAT_CONFIGS":        28,
		"PERMISSION_DENIED_NO_NEG_ENDPOINT_CONFIGS":     29,
		"PERMISSION_DENIED_NO_CLOUD_ROUTER_CONFIGS":     36,
		"NO_SOURCE_LOCATION":                            5,
		"INVALID_ARGUMENT":                              6,
		"TRACE_TOO_LONG":                                9,
		"INTERNAL_ERROR":                                10,
		"UNSUPPORTED":                                   15,
		"MISMATCHED_IP_VERSION":                         16,
		"GKE_KONNECTIVITY_PROXY_UNSUPPORTED":            17,
		"RESOURCE_CONFIG_NOT_FOUND":                     18,
		"VM_INSTANCE_CONFIG_NOT_FOUND":                  24,
		"NETWORK_CONFIG_NOT_FOUND":                      25,
		"FIREWALL_CONFIG_NOT_FOUND":                     26,
		"ROUTE_CONFIG_NOT_FOUND":                        27,
		"GOOGLE_MANAGED_SERVICE_AMBIGUOUS_PSC_ENDPOINT": 19,
		"GOOGLE_MANAGED_SERVICE_AMBIGUOUS_ENDPOINT":     39,
		"SOURCE_PSC_CLOUD_SQL_UNSUPPORTED":              20,
		"SOURCE_REDIS_CLUSTER_UNSUPPORTED":              34,
		"SOURCE_REDIS_INSTANCE_UNSUPPORTED":             35,
		"SOURCE_FORWARDING_RULE_UNSUPPORTED":            21,
		"NON_ROUTABLE_IP_ADDRESS":                       22,
		"UNKNOWN_ISSUE_IN_GOOGLE_MANAGED_PROJECT":       30,
		"UNSUPPORTED_GOOGLE_MANAGED_PROJECT_CONFIG":     31,
		"NO_SERVERLESS_IP_RANGES":                       37,
		"IP_VERSION_PROTOCOL_MISMATCH":                  40,
	}
)

func (x AbortInfo_Cause) Enum() *AbortInfo_Cause {
	p := new(AbortInfo_Cause)
	*p = x
	return p
}

func (x AbortInfo_Cause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AbortInfo_Cause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[17].Descriptor()
}

func (AbortInfo_Cause) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[17]
}

func (x AbortInfo_Cause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AbortInfo_Cause.Descriptor instead.
func (AbortInfo_Cause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{17, 0}
}

// Drop cause types:
type DropInfo_Cause int32

const (
	// Cause is unspecified.
	DropInfo_CAUSE_UNSPECIFIED DropInfo_Cause = 0
	// Destination external address cannot be resolved to a known target. If
	// the address is used in a Google Cloud project, provide the project ID
	// as test input.
	DropInfo_UNKNOWN_EXTERNAL_ADDRESS DropInfo_Cause = 1
	// A Compute Engine instance can only send or receive a packet with a
	// foreign IP address if ip_forward is enabled.
	DropInfo_FOREIGN_IP_DISALLOWED DropInfo_Cause = 2
	// Dropped due to a firewall rule, unless allowed due to connection
	// tracking.
	DropInfo_FIREWALL_RULE DropInfo_Cause = 3
	// Dropped due to no matching routes.
	DropInfo_NO_ROUTE DropInfo_Cause = 4
	// Dropped due to invalid route. Route's next hop is a blackhole.
	DropInfo_ROUTE_BLACKHOLE DropInfo_Cause = 5
	// Packet is sent to a wrong (unintended) network. Example: you trace a
	// packet from VM1:Network1 to VM2:Network2, however, the route configured
	// in Network1 sends the packet destined for VM2's IP address to Network3.
	DropInfo_ROUTE_WRONG_NETWORK DropInfo_Cause = 6
	// Route's next hop IP address cannot be resolved to a GCP resource.
	DropInfo_ROUTE_NEXT_HOP_IP_ADDRESS_NOT_RESOLVED DropInfo_Cause = 42
	// Route's next hop resource is not found.
	DropInfo_ROUTE_NEXT_HOP_RESOURCE_NOT_FOUND DropInfo_Cause = 43
	// Route's next hop instance doesn't have a NIC in the route's network.
	DropInfo_ROUTE_NEXT_HOP_INSTANCE_WRONG_NETWORK DropInfo_Cause = 49
	// Route's next hop IP address is not a primary IP address of the next hop
	// instance.
	DropInfo_ROUTE_NEXT_HOP_INSTANCE_NON_PRIMARY_IP DropInfo_Cause = 50
	// Route's next hop forwarding rule doesn't match next hop IP address.
	DropInfo_ROUTE_NEXT_HOP_FORWARDING_RULE_IP_MISMATCH DropInfo_Cause = 51
	// Route's next hop VPN tunnel is down (does not have valid IKE SAs).
	DropInfo_ROUTE_NEXT_HOP_VPN_TUNNEL_NOT_ESTABLISHED DropInfo_Cause = 52
	// Route's next hop forwarding rule type is invalid (it's not a forwarding
	// rule of the internal passthrough load balancer).
	DropInfo_ROUTE_NEXT_HOP_FORWARDING_RULE_TYPE_INVALID DropInfo_Cause = 53
	// Packet is sent from the Internet or Google service to the private IPv6
	// address.
	DropInfo_NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV6_ADDRESS DropInfo_Cause = 44
	// Packet is sent from the external IPv6 source address of an instance to
	// the private IPv6 address of an instance.
	DropInfo_NO_ROUTE_FROM_EXTERNAL_IPV6_SOURCE_TO_PRIVATE_IPV6_ADDRESS DropInfo_Cause = 98
	// The packet does not match a policy-based VPN tunnel local selector.
	DropInfo_VPN_TUNNEL_LOCAL_SELECTOR_MISMATCH DropInfo_Cause = 45
	// The packet does not match a policy-based VPN tunnel remote selector.
	DropInfo_VPN_TUNNEL_REMOTE_SELECTOR_MISMATCH DropInfo_Cause = 46
	// Packet with internal destination address sent to the internet gateway.
	DropInfo_PRIVATE_TRAFFIC_TO_INTERNET DropInfo_Cause = 7
	// Endpoint with only an internal IP address tries to access Google API and
	// services, but Private Google Access is not enabled in the subnet or is
	// not applicable.
	DropInfo_PRIVATE_GOOGLE_ACCESS_DISALLOWED DropInfo_Cause = 8
	// Source endpoint tries to access Google API and services through the VPN
	// tunnel to another network, but Private Google Access needs to be enabled
	// in the source endpoint network.
	DropInfo_PRIVATE_GOOGLE_ACCESS_VIA_VPN_TUNNEL_UNSUPPORTED DropInfo_Cause = 47
	// Endpoint with only an internal IP address tries to access external hosts,
	// but there is no matching Cloud NAT gateway in the subnet.
	DropInfo_NO_EXTERNAL_ADDRESS DropInfo_Cause = 9
	// Destination internal address cannot be resolved to a known target. If
	// this is a shared VPC scenario, verify if the service project ID is
	// provided as test input. Otherwise, verify if the IP address is being
	// used in the project.
	DropInfo_UNKNOWN_INTERNAL_ADDRESS DropInfo_Cause = 10
	// Forwarding rule's protocol and ports do not match the packet header.
	DropInfo_FORWARDING_RULE_MISMATCH DropInfo_Cause = 11
	// Forwarding rule does not have backends configured.
	DropInfo_FORWARDING_RULE_NO_INSTANCES DropInfo_Cause = 12
	// Firewalls block the health check probes to the backends and cause
	// the backends to be unavailable for traffic from the load balancer.
	// For more details, see [Health check firewall
	// rules](https://cloud.google.com/load-balancing/docs/health-checks#firewall_rules).
	DropInfo_FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK DropInfo_Cause = 13
	// Matching ingress firewall rules by network tags for packets sent via
	// serverless VPC direct egress is unsupported. Behavior is undefined.
	// https://cloud.google.com/run/docs/configuring/vpc-direct-vpc#limitations
	DropInfo_INGRESS_FIREWALL_TAGS_UNSUPPORTED_BY_DIRECT_VPC_EGRESS DropInfo_Cause = 85
	// Packet is sent from or to a Compute Engine instance that is not in a
	// running state.
	DropInfo_INSTANCE_NOT_RUNNING DropInfo_Cause = 14
	// Packet sent from or to a GKE cluster that is not in running state.
	DropInfo_GKE_CLUSTER_NOT_RUNNING DropInfo_Cause = 27
	// Packet sent from or to a Cloud SQL instance that is not in running state.
	DropInfo_CLOUD_SQL_INSTANCE_NOT_RUNNING DropInfo_Cause = 28
	// Packet sent from or to a Redis Instance that is not in running state.
	DropInfo_REDIS_INSTANCE_NOT_RUNNING DropInfo_Cause = 68
	// Packet sent from or to a Redis Cluster that is not in running state.
	DropInfo_REDIS_CLUSTER_NOT_RUNNING DropInfo_Cause = 69
	// The type of traffic is blocked and the user cannot configure a firewall
	// rule to enable it. See [Always blocked
	// traffic](https://cloud.google.com/vpc/docs/firewalls#blockedtraffic) for
	// more details.
	DropInfo_TRAFFIC_TYPE_BLOCKED DropInfo_Cause = 15
	// Access to Google Kubernetes Engine cluster master's endpoint is not
	// authorized. See [Access to the cluster
	// endpoints](https://cloud.google.com/kubernetes-engine/docs/how-to/private-clusters#access_to_the_cluster_endpoints)
	// for more details.
	DropInfo_GKE_MASTER_UNAUTHORIZED_ACCESS DropInfo_Cause = 16
	// Access to the Cloud SQL instance endpoint is not authorized.
	// See [Authorizing with authorized
	// networks](https://cloud.google.com/sql/docs/mysql/authorize-networks) for
	// more details.
	DropInfo_CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS DropInfo_Cause = 17
	// Packet was dropped inside Google Kubernetes Engine Service.
	DropInfo_DROPPED_INSIDE_GKE_SERVICE DropInfo_Cause = 18
	// Packet was dropped inside Cloud SQL Service.
	DropInfo_DROPPED_INSIDE_CLOUD_SQL_SERVICE DropInfo_Cause = 19
	// Packet was dropped because there is no peering between the originating
	// network and the Google Managed Services Network.
	DropInfo_GOOGLE_MANAGED_SERVICE_NO_PEERING DropInfo_Cause = 20
	// Packet was dropped because the Google-managed service uses Private
	// Service Connect (PSC), but the PSC endpoint is not found in the project.
	DropInfo_GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT DropInfo_Cause = 38
	// Packet was dropped because the GKE cluster uses Private Service Connect
	// (PSC), but the PSC endpoint is not found in the project.
	DropInfo_GKE_PSC_ENDPOINT_MISSING DropInfo_Cause = 36
	// Packet was dropped because the Cloud SQL instance has neither a private
	// nor a public IP address.
	DropInfo_CLOUD_SQL_INSTANCE_NO_IP_ADDRESS DropInfo_Cause = 21
	// Packet was dropped because a GKE cluster private endpoint is
	// unreachable from a region different from the cluster's region.
	DropInfo_GKE_CONTROL_PLANE_REGION_MISMATCH DropInfo_Cause = 30
	// Packet sent from a public GKE cluster control plane to a private
	// IP address.
	DropInfo_PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION DropInfo_Cause = 31
	// Packet was dropped because there is no route from a GKE cluster
	// control plane to a destination network.
	DropInfo_GKE_CONTROL_PLANE_NO_ROUTE DropInfo_Cause = 32
	// Packet sent from a Cloud SQL instance to an external IP address is not
	// allowed. The Cloud SQL instance is not configured to send packets to
	// external IP addresses.
	DropInfo_CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC DropInfo_Cause = 33
	// Packet sent from a Cloud SQL instance with only a public IP address to a
	// private IP address.
	DropInfo_PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION DropInfo_Cause = 34
	// Packet was dropped because there is no route from a Cloud SQL
	// instance to a destination network.
	DropInfo_CLOUD_SQL_INSTANCE_NO_ROUTE DropInfo_Cause = 35
	// Packet was dropped because the Cloud SQL instance requires all
	// connections to use Cloud SQL connectors and to target the Cloud SQL proxy
	// port (3307).
	DropInfo_CLOUD_SQL_CONNECTOR_REQUIRED DropInfo_Cause = 63
	// Packet could be dropped because the Cloud Function is not in an active
	// status.
	DropInfo_CLOUD_FUNCTION_NOT_ACTIVE DropInfo_Cause = 22
	// Packet could be dropped because no VPC connector is set.
	DropInfo_VPC_CONNECTOR_NOT_SET DropInfo_Cause = 23
	// Packet could be dropped because the VPC connector is not in a running
	// state.
	DropInfo_VPC_CONNECTOR_NOT_RUNNING DropInfo_Cause = 24
	// Packet could be dropped because the traffic from the serverless service
	// to the VPC connector is not allowed.
	DropInfo_VPC_CONNECTOR_SERVERLESS_TRAFFIC_BLOCKED DropInfo_Cause = 60
	// Packet could be dropped because the health check traffic to the VPC
	// connector is not allowed.
	DropInfo_VPC_CONNECTOR_HEALTH_CHECK_TRAFFIC_BLOCKED DropInfo_Cause = 61
	// Packet could be dropped because it was sent from a different region
	// to a regional forwarding without global access.
	DropInfo_FORWARDING_RULE_REGION_MISMATCH DropInfo_Cause = 25
	// The Private Service Connect endpoint is in a project that is not approved
	// to connect to the service.
	DropInfo_PSC_CONNECTION_NOT_ACCEPTED DropInfo_Cause = 26
	// The packet is sent to the Private Service Connect endpoint over the
	// peering, but [it's not
	// supported](https://cloud.google.com/vpc/docs/configure-private-service-connect-services#on-premises).
	DropInfo_PSC_ENDPOINT_ACCESSED_FROM_PEERED_NETWORK DropInfo_Cause = 41
	// The packet is sent to the Private Service Connect backend (network
	// endpoint group), but the producer PSC forwarding rule does not have
	// global access enabled.
	DropInfo_PSC_NEG_PRODUCER_ENDPOINT_NO_GLOBAL_ACCESS DropInfo_Cause = 48
	// The packet is sent to the Private Service Connect backend (network
	// endpoint group), but the producer PSC forwarding rule has multiple ports
	// specified.
	DropInfo_PSC_NEG_PRODUCER_FORWARDING_RULE_MULTIPLE_PORTS DropInfo_Cause = 54
	// The packet is sent to the Private Service Connect backend (network
	// endpoint group) targeting a Cloud SQL service attachment, but this
	// configuration is not supported.
	DropInfo_CLOUD_SQL_PSC_NEG_UNSUPPORTED DropInfo_Cause = 58
	// No NAT subnets are defined for the PSC service attachment.
	DropInfo_NO_NAT_SUBNETS_FOR_PSC_SERVICE_ATTACHMENT DropInfo_Cause = 57
	// PSC endpoint is accessed via NCC, but PSC transitivity configuration is
	// not yet propagated.
	DropInfo_PSC_TRANSITIVITY_NOT_PROPAGATED DropInfo_Cause = 64
	// The packet sent from the hybrid NEG proxy matches a non-dynamic route,
	// but such a configuration is not supported.
	DropInfo_HYBRID_NEG_NON_DYNAMIC_ROUTE_MATCHED DropInfo_Cause = 55
	// The packet sent from the hybrid NEG proxy matches a dynamic route with a
	// next hop in a different region, but such a configuration is not
	// supported.
	DropInfo_HYBRID_NEG_NON_LOCAL_DYNAMIC_ROUTE_MATCHED DropInfo_Cause = 56
	// Packet sent from a Cloud Run revision that is not ready.
	DropInfo_CLOUD_RUN_REVISION_NOT_READY DropInfo_Cause = 29
	// Packet was dropped inside Private Service Connect service producer.
	DropInfo_DROPPED_INSIDE_PSC_SERVICE_PRODUCER DropInfo_Cause = 37
	// Packet sent to a load balancer, which requires a proxy-only subnet and
	// the subnet is not found.
	DropInfo_LOAD_BALANCER_HAS_NO_PROXY_SUBNET DropInfo_Cause = 39
	// Packet sent to Cloud Nat without active NAT IPs.
	DropInfo_CLOUD_NAT_NO_ADDRESSES DropInfo_Cause = 40
	// Packet is stuck in a routing loop.
	DropInfo_ROUTING_LOOP DropInfo_Cause = 59
	// Packet is dropped inside a Google-managed service due to being delivered
	// in return trace to an endpoint that doesn't match the endpoint the packet
	// was sent from in forward trace. Used only for return traces.
	DropInfo_DROPPED_INSIDE_GOOGLE_MANAGED_SERVICE DropInfo_Cause = 62
	// Packet is dropped due to a load balancer backend instance not having a
	// network interface in the network expected by the load balancer.
	DropInfo_LOAD_BALANCER_BACKEND_INVALID_NETWORK DropInfo_Cause = 65
	// Packet is dropped due to a backend service named port not being defined
	// on the instance group level.
	DropInfo_BACKEND_SERVICE_NAMED_PORT_NOT_DEFINED DropInfo_Cause = 66
	// Packet is dropped due to a destination IP range being part of a Private
	// NAT IP range.
	DropInfo_DESTINATION_IS_PRIVATE_NAT_IP_RANGE DropInfo_Cause = 67
	// Generic drop cause for a packet being dropped inside a Redis Instance
	// service project.
	DropInfo_DROPPED_INSIDE_REDIS_INSTANCE_SERVICE DropInfo_Cause = 70
	// Packet is dropped due to an unsupported port being used to connect to a
	// Redis Instance. Port 6379 should be used to connect to a Redis Instance.
	DropInfo_REDIS_INSTANCE_UNSUPPORTED_PORT DropInfo_Cause = 71
	// Packet is dropped due to connecting from PUPI address to a PSA based
	// Redis Instance.
	DropInfo_REDIS_INSTANCE_CONNECTING_FROM_PUPI_ADDRESS DropInfo_Cause = 72
	// Packet is dropped due to no route to the destination network.
	DropInfo_REDIS_INSTANCE_NO_ROUTE_TO_DESTINATION_NETWORK DropInfo_Cause = 73
	// Redis Instance does not have an external IP address.
	DropInfo_REDIS_INSTANCE_NO_EXTERNAL_IP DropInfo_Cause = 74
	// Packet is dropped due to an unsupported protocol being used to connect to
	// a Redis Instance. Only TCP connections are accepted by a Redis Instance.
	DropInfo_REDIS_INSTANCE_UNSUPPORTED_PROTOCOL DropInfo_Cause = 78
	// Generic drop cause for a packet being dropped inside a Redis Cluster
	// service project.
	DropInfo_DROPPED_INSIDE_REDIS_CLUSTER_SERVICE DropInfo_Cause = 75
	// Packet is dropped due to an unsupported port being used to connect to a
	// Redis Cluster. Ports 6379 and 11000 to 13047 should be used to connect to
	// a Redis Cluster.
	DropInfo_REDIS_CLUSTER_UNSUPPORTED_PORT DropInfo_Cause = 76
	// Redis Cluster does not have an external IP address.
	DropInfo_REDIS_CLUSTER_NO_EXTERNAL_IP DropInfo_Cause = 77
	// Packet is dropped due to an unsupported protocol being used to connect to
	// a Redis Cluster. Only TCP connections are accepted by a Redis Cluster.
	DropInfo_REDIS_CLUSTER_UNSUPPORTED_PROTOCOL DropInfo_Cause = 79
	// Packet from the non-GCP (on-prem) or unknown GCP network is dropped due
	// to the destination IP address not belonging to any IP prefix advertised
	// via BGP by the Cloud Router.
	DropInfo_NO_ADVERTISED_ROUTE_TO_GCP_DESTINATION DropInfo_Cause = 80
	// Packet from the non-GCP (on-prem) or unknown GCP network is dropped due
	// to the destination IP address not belonging to any IP prefix included to
	// the local traffic selector of the VPN tunnel.
	DropInfo_NO_TRAFFIC_SELECTOR_TO_GCP_DESTINATION DropInfo_Cause = 81
	// Packet from the unknown peered network is dropped due to no known route
	// from the source network to the destination IP address.
	DropInfo_NO_KNOWN_ROUTE_FROM_PEERED_NETWORK_TO_DESTINATION DropInfo_Cause = 82
	// Sending packets processed by the Private NAT Gateways to the Private
	// Service Connect endpoints is not supported.
	DropInfo_PRIVATE_NAT_TO_PSC_ENDPOINT_UNSUPPORTED DropInfo_Cause = 83
	// Packet is sent to the PSC port mapping service, but its destination port
	// does not match any port mapping rules.
	DropInfo_PSC_PORT_MAPPING_PORT_MISMATCH DropInfo_Cause = 86
	// Sending packets directly to the PSC port mapping service without going
	// through the PSC connection is not supported.
	DropInfo_PSC_PORT_MAPPING_WITHOUT_PSC_CONNECTION_UNSUPPORTED DropInfo_Cause = 87
	// Packet with destination IP address within the reserved NAT64 range is
	// dropped due to matching a route of an unsupported type.
	DropInfo_UNSUPPORTED_ROUTE_MATCHED_FOR_NAT64_DESTINATION DropInfo_Cause = 88
	// Packet could be dropped because hybrid endpoint like a VPN gateway or
	// Interconnect is not allowed to send traffic to the Internet.
	DropInfo_TRAFFIC_FROM_HYBRID_ENDPOINT_TO_INTERNET_DISALLOWED DropInfo_Cause = 89
	// Packet with destination IP address within the reserved NAT64 range is
	// dropped due to no matching NAT gateway in the subnet.
	DropInfo_NO_MATCHING_NAT64_GATEWAY DropInfo_Cause = 90
	// Packet is dropped due to being sent to a backend of a passthrough load
	// balancer that doesn't use the same IP version as the frontend.
	DropInfo_LOAD_BALANCER_BACKEND_IP_VERSION_MISMATCH DropInfo_Cause = 96
	// Packet from the unknown NCC network is dropped due to no known route
	// from the source network to the destination IP address.
	DropInfo_NO_KNOWN_ROUTE_FROM_NCC_NETWORK_TO_DESTINATION DropInfo_Cause = 97
	// Packet is dropped by Cloud NAT due to using an unsupported protocol.
	DropInfo_CLOUD_NAT_PROTOCOL_UNSUPPORTED DropInfo_Cause = 99
	// Packet is dropped due to using an unsupported protocol (any other than
	// UDP) for L2 Interconnect.
	DropInfo_L2_INTERCONNECT_UNSUPPORTED_PROTOCOL DropInfo_Cause = 100
	// Packet is dropped due to using an unsupported port (any other than
	// 6081) for L2 Interconnect.
	DropInfo_L2_INTERCONNECT_UNSUPPORTED_PORT DropInfo_Cause = 101
	// Packet is dropped due to destination IP not matching the appliance
	// mapping IPs configured on the L2 Interconnect attachment.
	DropInfo_L2_INTERCONNECT_DESTINATION_IP_MISMATCH DropInfo_Cause = 102
	// Packet could be dropped because it matches a route associated with an NCC
	// spoke in the hybrid subnet context, but such a configuration is not
	// supported.
	DropInfo_NCC_ROUTE_WITHIN_HYBRID_SUBNET_UNSUPPORTED DropInfo_Cause = 104
	// Packet is dropped because the region of the hybrid subnet is different
	// from the region of the next hop of the route matched within this hybrid
	// subnet.
	DropInfo_HYBRID_SUBNET_REGION_MISMATCH DropInfo_Cause = 105
)

// Enum value maps for DropInfo_Cause.
var (
	DropInfo_Cause_name = map[int32]string{
		0:   "CAUSE_UNSPECIFIED",
		1:   "UNKNOWN_EXTERNAL_ADDRESS",
		2:   "FOREIGN_IP_DISALLOWED",
		3:   "FIREWALL_RULE",
		4:   "NO_ROUTE",
		5:   "ROUTE_BLACKHOLE",
		6:   "ROUTE_WRONG_NETWORK",
		42:  "ROUTE_NEXT_HOP_IP_ADDRESS_NOT_RESOLVED",
		43:  "ROUTE_NEXT_HOP_RESOURCE_NOT_FOUND",
		49:  "ROUTE_NEXT_HOP_INSTANCE_WRONG_NETWORK",
		50:  "ROUTE_NEXT_HOP_INSTANCE_NON_PRIMARY_IP",
		51:  "ROUTE_NEXT_HOP_FORWARDING_RULE_IP_MISMATCH",
		52:  "ROUTE_NEXT_HOP_VPN_TUNNEL_NOT_ESTABLISHED",
		53:  "ROUTE_NEXT_HOP_FORWARDING_RULE_TYPE_INVALID",
		44:  "NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV6_ADDRESS",
		98:  "NO_ROUTE_FROM_EXTERNAL_IPV6_SOURCE_TO_PRIVATE_IPV6_ADDRESS",
		45:  "VPN_TUNNEL_LOCAL_SELECTOR_MISMATCH",
		46:  "VPN_TUNNEL_REMOTE_SELECTOR_MISMATCH",
		7:   "PRIVATE_TRAFFIC_TO_INTERNET",
		8:   "PRIVATE_GOOGLE_ACCESS_DISALLOWED",
		47:  "PRIVATE_GOOGLE_ACCESS_VIA_VPN_TUNNEL_UNSUPPORTED",
		9:   "NO_EXTERNAL_ADDRESS",
		10:  "UNKNOWN_INTERNAL_ADDRESS",
		11:  "FORWARDING_RULE_MISMATCH",
		12:  "FORWARDING_RULE_NO_INSTANCES",
		13:  "FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK",
		85:  "INGRESS_FIREWALL_TAGS_UNSUPPORTED_BY_DIRECT_VPC_EGRESS",
		14:  "INSTANCE_NOT_RUNNING",
		27:  "GKE_CLUSTER_NOT_RUNNING",
		28:  "CLOUD_SQL_INSTANCE_NOT_RUNNING",
		68:  "REDIS_INSTANCE_NOT_RUNNING",
		69:  "REDIS_CLUSTER_NOT_RUNNING",
		15:  "TRAFFIC_TYPE_BLOCKED",
		16:  "GKE_MASTER_UNAUTHORIZED_ACCESS",
		17:  "CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS",
		18:  "DROPPED_INSIDE_GKE_SERVICE",
		19:  "DROPPED_INSIDE_CLOUD_SQL_SERVICE",
		20:  "GOOGLE_MANAGED_SERVICE_NO_PEERING",
		38:  "GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT",
		36:  "GKE_PSC_ENDPOINT_MISSING",
		21:  "CLOUD_SQL_INSTANCE_NO_IP_ADDRESS",
		30:  "GKE_CONTROL_PLANE_REGION_MISMATCH",
		31:  "PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION",
		32:  "GKE_CONTROL_PLANE_NO_ROUTE",
		33:  "CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC",
		34:  "PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION",
		35:  "CLOUD_SQL_INSTANCE_NO_ROUTE",
		63:  "CLOUD_SQL_CONNECTOR_REQUIRED",
		22:  "CLOUD_FUNCTION_NOT_ACTIVE",
		23:  "VPC_CONNECTOR_NOT_SET",
		24:  "VPC_CONNECTOR_NOT_RUNNING",
		60:  "VPC_CONNECTOR_SERVERLESS_TRAFFIC_BLOCKED",
		61:  "VPC_CONNECTOR_HEALTH_CHECK_TRAFFIC_BLOCKED",
		25:  "FORWARDING_RULE_REGION_MISMATCH",
		26:  "PSC_CONNECTION_NOT_ACCEPTED",
		41:  "PSC_ENDPOINT_ACCESSED_FROM_PEERED_NETWORK",
		48:  "PSC_NEG_PRODUCER_ENDPOINT_NO_GLOBAL_ACCESS",
		54:  "PSC_NEG_PRODUCER_FORWARDING_RULE_MULTIPLE_PORTS",
		58:  "CLOUD_SQL_PSC_NEG_UNSUPPORTED",
		57:  "NO_NAT_SUBNETS_FOR_PSC_SERVICE_ATTACHMENT",
		64:  "PSC_TRANSITIVITY_NOT_PROPAGATED",
		55:  "HYBRID_NEG_NON_DYNAMIC_ROUTE_MATCHED",
		56:  "HYBRID_NEG_NON_LOCAL_DYNAMIC_ROUTE_MATCHED",
		29:  "CLOUD_RUN_REVISION_NOT_READY",
		37:  "DROPPED_INSIDE_PSC_SERVICE_PRODUCER",
		39:  "LOAD_BALANCER_HAS_NO_PROXY_SUBNET",
		40:  "CLOUD_NAT_NO_ADDRESSES",
		59:  "ROUTING_LOOP",
		62:  "DROPPED_INSIDE_GOOGLE_MANAGED_SERVICE",
		65:  "LOAD_BALANCER_BACKEND_INVALID_NETWORK",
		66:  "BACKEND_SERVICE_NAMED_PORT_NOT_DEFINED",
		67:  "DESTINATION_IS_PRIVATE_NAT_IP_RANGE",
		70:  "DROPPED_INSIDE_REDIS_INSTANCE_SERVICE",
		71:  "REDIS_INSTANCE_UNSUPPORTED_PORT",
		72:  "REDIS_INSTANCE_CONNECTING_FROM_PUPI_ADDRESS",
		73:  "REDIS_INSTANCE_NO_ROUTE_TO_DESTINATION_NETWORK",
		74:  "REDIS_INSTANCE_NO_EXTERNAL_IP",
		78:  "REDIS_INSTANCE_UNSUPPORTED_PROTOCOL",
		75:  "DROPPED_INSIDE_REDIS_CLUSTER_SERVICE",
		76:  "REDIS_CLUSTER_UNSUPPORTED_PORT",
		77:  "REDIS_CLUSTER_NO_EXTERNAL_IP",
		79:  "REDIS_CLUSTER_UNSUPPORTED_PROTOCOL",
		80:  "NO_ADVERTISED_ROUTE_TO_GCP_DESTINATION",
		81:  "NO_TRAFFIC_SELECTOR_TO_GCP_DESTINATION",
		82:  "NO_KNOWN_ROUTE_FROM_PEERED_NETWORK_TO_DESTINATION",
		83:  "PRIVATE_NAT_TO_PSC_ENDPOINT_UNSUPPORTED",
		86:  "PSC_PORT_MAPPING_PORT_MISMATCH",
		87:  "PSC_PORT_MAPPING_WITHOUT_PSC_CONNECTION_UNSUPPORTED",
		88:  "UNSUPPORTED_ROUTE_MATCHED_FOR_NAT64_DESTINATION",
		89:  "TRAFFIC_FROM_HYBRID_ENDPOINT_TO_INTERNET_DISALLOWED",
		90:  "NO_MATCHING_NAT64_GATEWAY",
		96:  "LOAD_BALANCER_BACKEND_IP_VERSION_MISMATCH",
		97:  "NO_KNOWN_ROUTE_FROM_NCC_NETWORK_TO_DESTINATION",
		99:  "CLOUD_NAT_PROTOCOL_UNSUPPORTED",
		100: "L2_INTERCONNECT_UNSUPPORTED_PROTOCOL",
		101: "L2_INTERCONNECT_UNSUPPORTED_PORT",
		102: "L2_INTERCONNECT_DESTINATION_IP_MISMATCH",
		104: "NCC_ROUTE_WITHIN_HYBRID_SUBNET_UNSUPPORTED",
		105: "HYBRID_SUBNET_REGION_MISMATCH",
	}
	DropInfo_Cause_value = map[string]int32{
		"CAUSE_UNSPECIFIED":                                          0,
		"UNKNOWN_EXTERNAL_ADDRESS":                                   1,
		"FOREIGN_IP_DISALLOWED":                                      2,
		"FIREWALL_RULE":                                              3,
		"NO_ROUTE":                                                   4,
		"ROUTE_BLACKHOLE":                                            5,
		"ROUTE_WRONG_NETWORK":                                        6,
		"ROUTE_NEXT_HOP_IP_ADDRESS_NOT_RESOLVED":                     42,
		"ROUTE_NEXT_HOP_RESOURCE_NOT_FOUND":                          43,
		"ROUTE_NEXT_HOP_INSTANCE_WRONG_NETWORK":                      49,
		"ROUTE_NEXT_HOP_INSTANCE_NON_PRIMARY_IP":                     50,
		"ROUTE_NEXT_HOP_FORWARDING_RULE_IP_MISMATCH":                 51,
		"ROUTE_NEXT_HOP_VPN_TUNNEL_NOT_ESTABLISHED":                  52,
		"ROUTE_NEXT_HOP_FORWARDING_RULE_TYPE_INVALID":                53,
		"NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV6_ADDRESS":             44,
		"NO_ROUTE_FROM_EXTERNAL_IPV6_SOURCE_TO_PRIVATE_IPV6_ADDRESS": 98,
		"VPN_TUNNEL_LOCAL_SELECTOR_MISMATCH":                         45,
		"VPN_TUNNEL_REMOTE_SELECTOR_MISMATCH":                        46,
		"PRIVATE_TRAFFIC_TO_INTERNET":                                7,
		"PRIVATE_GOOGLE_ACCESS_DISALLOWED":                           8,
		"PRIVATE_GOOGLE_ACCESS_VIA_VPN_TUNNEL_UNSUPPORTED":           47,
		"NO_EXTERNAL_ADDRESS":                                        9,
		"UNKNOWN_INTERNAL_ADDRESS":                                   10,
		"FORWARDING_RULE_MISMATCH":                                   11,
		"FORWARDING_RULE_NO_INSTANCES":                               12,
		"FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK":       13,
		"INGRESS_FIREWALL_TAGS_UNSUPPORTED_BY_DIRECT_VPC_EGRESS":     85,
		"INSTANCE_NOT_RUNNING":                                       14,
		"GKE_CLUSTER_NOT_RUNNING":                                    27,
		"CLOUD_SQL_INSTANCE_NOT_RUNNING":                             28,
		"REDIS_INSTANCE_NOT_RUNNING":                                 68,
		"REDIS_CLUSTER_NOT_RUNNING":                                  69,
		"TRAFFIC_TYPE_BLOCKED":                                       15,
		"GKE_MASTER_UNAUTHORIZED_ACCESS":                             16,
		"CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS":                     17,
		"DROPPED_INSIDE_GKE_SERVICE":                                 18,
		"DROPPED_INSIDE_CLOUD_SQL_SERVICE":                           19,
		"GOOGLE_MANAGED_SERVICE_NO_PEERING":                          20,
		"GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT":                     38,
		"GKE_PSC_ENDPOINT_MISSING":                                   36,
		"CLOUD_SQL_INSTANCE_NO_IP_ADDRESS":                           21,
		"GKE_CONTROL_PLANE_REGION_MISMATCH":                          30,
		"PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION":            31,
		"GKE_CONTROL_PLANE_NO_ROUTE":                                 32,
		"CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC":     33,
		"PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION":           34,
		"CLOUD_SQL_INSTANCE_NO_ROUTE":                                35,
		"CLOUD_SQL_CONNECTOR_REQUIRED":                               63,
		"CLOUD_FUNCTION_NOT_ACTIVE":                                  22,
		"VPC_CONNECTOR_NOT_SET":                                      23,
		"VPC_CONNECTOR_NOT_RUNNING":                                  24,
		"VPC_CONNECTOR_SERVERLESS_TRAFFIC_BLOCKED":                   60,
		"VPC_CONNECTOR_HEALTH_CHECK_TRAFFIC_BLOCKED":                 61,
		"FORWARDING_RULE_REGION_MISMATCH":                            25,
		"PSC_CONNECTION_NOT_ACCEPTED":                                26,
		"PSC_ENDPOINT_ACCESSED_FROM_PEERED_NETWORK":                  41,
		"PSC_NEG_PRODUCER_ENDPOINT_NO_GLOBAL_ACCESS":                 48,
		"PSC_NEG_PRODUCER_FORWARDING_RULE_MULTIPLE_PORTS":            54,
		"CLOUD_SQL_PSC_NEG_UNSUPPORTED":                              58,
		"NO_NAT_SUBNETS_FOR_PSC_SERVICE_ATTACHMENT":                  57,
		"PSC_TRANSITIVITY_NOT_PROPAGATED":                            64,
		"HYBRID_NEG_NON_DYNAMIC_ROUTE_MATCHED":                       55,
		"HYBRID_NEG_NON_LOCAL_DYNAMIC_ROUTE_MATCHED":                 56,
		"CLOUD_RUN_REVISION_NOT_READY":                               29,
		"DROPPED_INSIDE_PSC_SERVICE_PRODUCER":                        37,
		"LOAD_BALANCER_HAS_NO_PROXY_SUBNET":                          39,
		"CLOUD_NAT_NO_ADDRESSES":                                     40,
		"ROUTING_LOOP":                                               59,
		"DROPPED_INSIDE_GOOGLE_MANAGED_SERVICE":                      62,
		"LOAD_BALANCER_BACKEND_INVALID_NETWORK":                      65,
		"BACKEND_SERVICE_NAMED_PORT_NOT_DEFINED":                     66,
		"DESTINATION_IS_PRIVATE_NAT_IP_RANGE":                        67,
		"DROPPED_INSIDE_REDIS_INSTANCE_SERVICE":                      70,
		"REDIS_INSTANCE_UNSUPPORTED_PORT":                            71,
		"REDIS_INSTANCE_CONNECTING_FROM_PUPI_ADDRESS":                72,
		"REDIS_INSTANCE_NO_ROUTE_TO_DESTINATION_NETWORK":             73,
		"REDIS_INSTANCE_NO_EXTERNAL_IP":                              74,
		"REDIS_INSTANCE_UNSUPPORTED_PROTOCOL":                        78,
		"DROPPED_INSIDE_REDIS_CLUSTER_SERVICE":                       75,
		"REDIS_CLUSTER_UNSUPPORTED_PORT":                             76,
		"REDIS_CLUSTER_NO_EXTERNAL_IP":                               77,
		"REDIS_CLUSTER_UNSUPPORTED_PROTOCOL":                         79,
		"NO_ADVERTISED_ROUTE_TO_GCP_DESTINATION":                     80,
		"NO_TRAFFIC_SELECTOR_TO_GCP_DESTINATION":                     81,
		"NO_KNOWN_ROUTE_FROM_PEERED_NETWORK_TO_DESTINATION":          82,
		"PRIVATE_NAT_TO_PSC_ENDPOINT_UNSUPPORTED":                    83,
		"PSC_PORT_MAPPING_PORT_MISMATCH":                             86,
		"PSC_PORT_MAPPING_WITHOUT_PSC_CONNECTION_UNSUPPORTED":        87,
		"UNSUPPORTED_ROUTE_MATCHED_FOR_NAT64_DESTINATION":            88,
		"TRAFFIC_FROM_HYBRID_ENDPOINT_TO_INTERNET_DISALLOWED":        89,
		"NO_MATCHING_NAT64_GATEWAY":                                  90,
		"LOAD_BALANCER_BACKEND_IP_VERSION_MISMATCH":                  96,
		"NO_KNOWN_ROUTE_FROM_NCC_NETWORK_TO_DESTINATION":             97,
		"CLOUD_NAT_PROTOCOL_UNSUPPORTED":                             99,
		"L2_INTERCONNECT_UNSUPPORTED_PROTOCOL":                       100,
		"L2_INTERCONNECT_UNSUPPORTED_PORT":                           101,
		"L2_INTERCONNECT_DESTINATION_IP_MISMATCH":                    102,
		"NCC_ROUTE_WITHIN_HYBRID_SUBNET_UNSUPPORTED":                 104,
		"HYBRID_SUBNET_REGION_MISMATCH":                              105,
	}
)

func (x DropInfo_Cause) Enum() *DropInfo_Cause {
	p := new(DropInfo_Cause)
	*p = x
	return p
}

func (x DropInfo_Cause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DropInfo_Cause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[18].Descriptor()
}

func (DropInfo_Cause) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[18]
}

func (x DropInfo_Cause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DropInfo_Cause.Descriptor instead.
func (DropInfo_Cause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{18, 0}
}

// Types of NAT.
type NatInfo_Type int32

const (
	// Type is unspecified.
	NatInfo_TYPE_UNSPECIFIED NatInfo_Type = 0
	// From Compute Engine instance's internal address to external address.
	NatInfo_INTERNAL_TO_EXTERNAL NatInfo_Type = 1
	// From Compute Engine instance's external address to internal address.
	NatInfo_EXTERNAL_TO_INTERNAL NatInfo_Type = 2
	// Cloud NAT Gateway.
	NatInfo_CLOUD_NAT NatInfo_Type = 3
	// Private service connect NAT.
	NatInfo_PRIVATE_SERVICE_CONNECT NatInfo_Type = 4
	// GKE Pod IP address masquerading.
	NatInfo_GKE_POD_IP_MASQUERADING NatInfo_Type = 5
)

// Enum value maps for NatInfo_Type.
var (
	NatInfo_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "INTERNAL_TO_EXTERNAL",
		2: "EXTERNAL_TO_INTERNAL",
		3: "CLOUD_NAT",
		4: "PRIVATE_SERVICE_CONNECT",
		5: "GKE_POD_IP_MASQUERADING",
	}
	NatInfo_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":        0,
		"INTERNAL_TO_EXTERNAL":    1,
		"EXTERNAL_TO_INTERNAL":    2,
		"CLOUD_NAT":               3,
		"PRIVATE_SERVICE_CONNECT": 4,
		"GKE_POD_IP_MASQUERADING": 5,
	}
)

func (x NatInfo_Type) Enum() *NatInfo_Type {
	p := new(NatInfo_Type)
	*p = x
	return p
}

func (x NatInfo_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NatInfo_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[19].Descriptor()
}

func (NatInfo_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[19]
}

func (x NatInfo_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NatInfo_Type.Descriptor instead.
func (NatInfo_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{29, 0}
}

// Health check firewalls configuration state enum.
type LoadBalancerBackendInfo_HealthCheckFirewallsConfigState int32

const (
	// Configuration state unspecified. It usually means that the backend has
	// no health check attached, or there was an unexpected configuration error
	// preventing Connectivity tests from verifying health check configuration.
	LoadBalancerBackendInfo_HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED LoadBalancerBackendInfo_HealthCheckFirewallsConfigState = 0
	// Firewall rules (policies) allowing health check traffic from all required
	// IP ranges to the backend are configured.
	LoadBalancerBackendInfo_FIREWALLS_CONFIGURED LoadBalancerBackendInfo_HealthCheckFirewallsConfigState = 1
	// Firewall rules (policies) allow health check traffic only from a part of
	// required IP ranges.
	LoadBalancerBackendInfo_FIREWALLS_PARTIALLY_CONFIGURED LoadBalancerBackendInfo_HealthCheckFirewallsConfigState = 2
	// Firewall rules (policies) deny health check traffic from all required
	// IP ranges to the backend.
	LoadBalancerBackendInfo_FIREWALLS_NOT_CONFIGURED LoadBalancerBackendInfo_HealthCheckFirewallsConfigState = 3
	// The network contains firewall rules of unsupported types, so Connectivity
	// tests were not able to verify health check configuration status. Please
	// refer to the documentation for the list of unsupported configurations:
	// https://cloud.google.com/network-intelligence-center/docs/connectivity-tests/concepts/overview#unsupported-configs
	LoadBalancerBackendInfo_FIREWALLS_UNSUPPORTED LoadBalancerBackendInfo_HealthCheckFirewallsConfigState = 4
)

// Enum value maps for LoadBalancerBackendInfo_HealthCheckFirewallsConfigState.
var (
	LoadBalancerBackendInfo_HealthCheckFirewallsConfigState_name = map[int32]string{
		0: "HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED",
		1: "FIREWALLS_CONFIGURED",
		2: "FIREWALLS_PARTIALLY_CONFIGURED",
		3: "FIREWALLS_NOT_CONFIGURED",
		4: "FIREWALLS_UNSUPPORTED",
	}
	LoadBalancerBackendInfo_HealthCheckFirewallsConfigState_value = map[string]int32{
		"HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED": 0,
		"FIREWALLS_CONFIGURED":                            1,
		"FIREWALLS_PARTIALLY_CONFIGURED":                  2,
		"FIREWALLS_NOT_CONFIGURED":                        3,
		"FIREWALLS_UNSUPPORTED":                           4,
	}
)

func (x LoadBalancerBackendInfo_HealthCheckFirewallsConfigState) Enum() *LoadBalancerBackendInfo_HealthCheckFirewallsConfigState {
	p := new(LoadBalancerBackendInfo_HealthCheckFirewallsConfigState)
	*p = x
	return p
}

func (x LoadBalancerBackendInfo_HealthCheckFirewallsConfigState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancerBackendInfo_HealthCheckFirewallsConfigState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[20].Descriptor()
}

func (LoadBalancerBackendInfo_HealthCheckFirewallsConfigState) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[20]
}

func (x LoadBalancerBackendInfo_HealthCheckFirewallsConfigState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancerBackendInfo_HealthCheckFirewallsConfigState.Descriptor instead.
func (LoadBalancerBackendInfo_HealthCheckFirewallsConfigState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{31, 0}
}

// Trace represents one simulated packet forwarding path.
//
//   - Each trace contains multiple ordered steps.
//   - Each step is in a particular state with associated configuration.
//   - State is categorized as final or non-final states.
//   - Each final state has a reason associated.
//   - Each trace must end with a final state (the last step).
//
// ```
//
//	|---------------------Trace----------------------|
//	Step1(State) Step2(State) ---  StepN(State(final))
//
// ```
type Trace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Derived from the source and destination endpoints definition specified by
	// user request, and validated by the data plane model.
	// If there are multiple traces starting from different source locations, then
	// the endpoint_info may be different between traces.
	EndpointInfo *EndpointInfo `protobuf:"bytes,1,opt,name=endpoint_info,json=endpointInfo,proto3" json:"endpoint_info,omitempty"`
	// A trace of a test contains multiple steps from the initial state to the
	// final state (delivered, dropped, forwarded, or aborted).
	//
	// The steps are ordered by the processing sequence within the simulated
	// network state machine. It is critical to preserve the order of the steps
	// and avoid reordering or sorting them.
	Steps []*Step `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
	// ID of trace. For forward traces, this ID is unique for each trace. For
	// return traces, it matches ID of associated forward trace. A single forward
	// trace can be associated with none, one or more than one return trace.
	ForwardTraceId int32 `protobuf:"varint,4,opt,name=forward_trace_id,json=forwardTraceId,proto3" json:"forward_trace_id,omitempty"`
}

func (x *Trace) Reset() {
	*x = Trace{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Trace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trace) ProtoMessage() {}

func (x *Trace) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trace.ProtoReflect.Descriptor instead.
func (*Trace) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{0}
}

func (x *Trace) GetEndpointInfo() *EndpointInfo {
	if x != nil {
		return x.EndpointInfo
	}
	return nil
}

func (x *Trace) GetSteps() []*Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *Trace) GetForwardTraceId() int32 {
	if x != nil {
		return x.ForwardTraceId
	}
	return 0
}

// A simulated forwarding path is composed of multiple steps.
// Each step has a well-defined state and an associated configuration.
type Step struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A description of the step. Usually this is a summary of the state.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Each step is in one of the pre-defined states.
	State Step_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.networkmanagement.v1.Step_State" json:"state,omitempty"`
	// This is a step that leads to the final state Drop.
	CausesDrop bool `protobuf:"varint,3,opt,name=causes_drop,json=causesDrop,proto3" json:"causes_drop,omitempty"`
	// Project ID that contains the configuration this step is validating.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Configuration or metadata associated with each step.
	// The configuration is filtered based on viewer's permission. If a viewer
	// has no permission to view the configuration in this step, for non-final
	// states a special state is populated (VIEWER_PERMISSION_MISSING), and for
	// final state the configuration is cleared.
	//
	// Types that are assignable to StepInfo:
	//
	//	*Step_Instance
	//	*Step_Firewall
	//	*Step_Route
	//	*Step_Endpoint
	//	*Step_GoogleService
	//	*Step_ForwardingRule
	//	*Step_HybridSubnet
	//	*Step_VpnGateway
	//	*Step_VpnTunnel
	//	*Step_InterconnectAttachment
	//	*Step_VpcConnector
	//	*Step_DirectVpcEgressConnection
	//	*Step_ServerlessExternalConnection
	//	*Step_Deliver
	//	*Step_Forward
	//	*Step_Abort
	//	*Step_Drop
	//	*Step_LoadBalancer
	//	*Step_Network
	//	*Step_GkeMaster
	//	*Step_CloudSqlInstance
	//	*Step_RedisInstance
	//	*Step_RedisCluster
	//	*Step_CloudFunction
	//	*Step_AppEngineVersion
	//	*Step_CloudRunRevision
	//	*Step_Nat
	//	*Step_ProxyConnection
	//	*Step_LoadBalancerBackendInfo
	//	*Step_StorageBucket
	//	*Step_ServerlessNeg
	StepInfo isStep_StepInfo `protobuf_oneof:"step_info"`
}

func (x *Step) Reset() {
	*x = Step{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Step) ProtoMessage() {}

func (x *Step) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Step.ProtoReflect.Descriptor instead.
func (*Step) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{1}
}

func (x *Step) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Step) GetState() Step_State {
	if x != nil {
		return x.State
	}
	return Step_STATE_UNSPECIFIED
}

func (x *Step) GetCausesDrop() bool {
	if x != nil {
		return x.CausesDrop
	}
	return false
}

func (x *Step) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (m *Step) GetStepInfo() isStep_StepInfo {
	if m != nil {
		return m.StepInfo
	}
	return nil
}

func (x *Step) GetInstance() *InstanceInfo {
	if x, ok := x.GetStepInfo().(*Step_Instance); ok {
		return x.Instance
	}
	return nil
}

func (x *Step) GetFirewall() *FirewallInfo {
	if x, ok := x.GetStepInfo().(*Step_Firewall); ok {
		return x.Firewall
	}
	return nil
}

func (x *Step) GetRoute() *RouteInfo {
	if x, ok := x.GetStepInfo().(*Step_Route); ok {
		return x.Route
	}
	return nil
}

func (x *Step) GetEndpoint() *EndpointInfo {
	if x, ok := x.GetStepInfo().(*Step_Endpoint); ok {
		return x.Endpoint
	}
	return nil
}

func (x *Step) GetGoogleService() *GoogleServiceInfo {
	if x, ok := x.GetStepInfo().(*Step_GoogleService); ok {
		return x.GoogleService
	}
	return nil
}

func (x *Step) GetForwardingRule() *ForwardingRuleInfo {
	if x, ok := x.GetStepInfo().(*Step_ForwardingRule); ok {
		return x.ForwardingRule
	}
	return nil
}

func (x *Step) GetHybridSubnet() *HybridSubnetInfo {
	if x, ok := x.GetStepInfo().(*Step_HybridSubnet); ok {
		return x.HybridSubnet
	}
	return nil
}

func (x *Step) GetVpnGateway() *VpnGatewayInfo {
	if x, ok := x.GetStepInfo().(*Step_VpnGateway); ok {
		return x.VpnGateway
	}
	return nil
}

func (x *Step) GetVpnTunnel() *VpnTunnelInfo {
	if x, ok := x.GetStepInfo().(*Step_VpnTunnel); ok {
		return x.VpnTunnel
	}
	return nil
}

func (x *Step) GetInterconnectAttachment() *InterconnectAttachmentInfo {
	if x, ok := x.GetStepInfo().(*Step_InterconnectAttachment); ok {
		return x.InterconnectAttachment
	}
	return nil
}

func (x *Step) GetVpcConnector() *VpcConnectorInfo {
	if x, ok := x.GetStepInfo().(*Step_VpcConnector); ok {
		return x.VpcConnector
	}
	return nil
}

func (x *Step) GetDirectVpcEgressConnection() *DirectVpcEgressConnectionInfo {
	if x, ok := x.GetStepInfo().(*Step_DirectVpcEgressConnection); ok {
		return x.DirectVpcEgressConnection
	}
	return nil
}

func (x *Step) GetServerlessExternalConnection() *ServerlessExternalConnectionInfo {
	if x, ok := x.GetStepInfo().(*Step_ServerlessExternalConnection); ok {
		return x.ServerlessExternalConnection
	}
	return nil
}

func (x *Step) GetDeliver() *DeliverInfo {
	if x, ok := x.GetStepInfo().(*Step_Deliver); ok {
		return x.Deliver
	}
	return nil
}

func (x *Step) GetForward() *ForwardInfo {
	if x, ok := x.GetStepInfo().(*Step_Forward); ok {
		return x.Forward
	}
	return nil
}

func (x *Step) GetAbort() *AbortInfo {
	if x, ok := x.GetStepInfo().(*Step_Abort); ok {
		return x.Abort
	}
	return nil
}

func (x *Step) GetDrop() *DropInfo {
	if x, ok := x.GetStepInfo().(*Step_Drop); ok {
		return x.Drop
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
func (x *Step) GetLoadBalancer() *LoadBalancerInfo {
	if x, ok := x.GetStepInfo().(*Step_LoadBalancer); ok {
		return x.LoadBalancer
	}
	return nil
}

func (x *Step) GetNetwork() *NetworkInfo {
	if x, ok := x.GetStepInfo().(*Step_Network); ok {
		return x.Network
	}
	return nil
}

func (x *Step) GetGkeMaster() *GKEMasterInfo {
	if x, ok := x.GetStepInfo().(*Step_GkeMaster); ok {
		return x.GkeMaster
	}
	return nil
}

func (x *Step) GetCloudSqlInstance() *CloudSQLInstanceInfo {
	if x, ok := x.GetStepInfo().(*Step_CloudSqlInstance); ok {
		return x.CloudSqlInstance
	}
	return nil
}

func (x *Step) GetRedisInstance() *RedisInstanceInfo {
	if x, ok := x.GetStepInfo().(*Step_RedisInstance); ok {
		return x.RedisInstance
	}
	return nil
}

func (x *Step) GetRedisCluster() *RedisClusterInfo {
	if x, ok := x.GetStepInfo().(*Step_RedisCluster); ok {
		return x.RedisCluster
	}
	return nil
}

func (x *Step) GetCloudFunction() *CloudFunctionInfo {
	if x, ok := x.GetStepInfo().(*Step_CloudFunction); ok {
		return x.CloudFunction
	}
	return nil
}

func (x *Step) GetAppEngineVersion() *AppEngineVersionInfo {
	if x, ok := x.GetStepInfo().(*Step_AppEngineVersion); ok {
		return x.AppEngineVersion
	}
	return nil
}

func (x *Step) GetCloudRunRevision() *CloudRunRevisionInfo {
	if x, ok := x.GetStepInfo().(*Step_CloudRunRevision); ok {
		return x.CloudRunRevision
	}
	return nil
}

func (x *Step) GetNat() *NatInfo {
	if x, ok := x.GetStepInfo().(*Step_Nat); ok {
		return x.Nat
	}
	return nil
}

func (x *Step) GetProxyConnection() *ProxyConnectionInfo {
	if x, ok := x.GetStepInfo().(*Step_ProxyConnection); ok {
		return x.ProxyConnection
	}
	return nil
}

func (x *Step) GetLoadBalancerBackendInfo() *LoadBalancerBackendInfo {
	if x, ok := x.GetStepInfo().(*Step_LoadBalancerBackendInfo); ok {
		return x.LoadBalancerBackendInfo
	}
	return nil
}

func (x *Step) GetStorageBucket() *StorageBucketInfo {
	if x, ok := x.GetStepInfo().(*Step_StorageBucket); ok {
		return x.StorageBucket
	}
	return nil
}

func (x *Step) GetServerlessNeg() *ServerlessNegInfo {
	if x, ok := x.GetStepInfo().(*Step_ServerlessNeg); ok {
		return x.ServerlessNeg
	}
	return nil
}

type isStep_StepInfo interface {
	isStep_StepInfo()
}

type Step_Instance struct {
	// Display information of a Compute Engine instance.
	Instance *InstanceInfo `protobuf:"bytes,5,opt,name=instance,proto3,oneof"`
}

type Step_Firewall struct {
	// Display information of a Compute Engine firewall rule.
	Firewall *FirewallInfo `protobuf:"bytes,6,opt,name=firewall,proto3,oneof"`
}

type Step_Route struct {
	// Display information of a Compute Engine route.
	Route *RouteInfo `protobuf:"bytes,7,opt,name=route,proto3,oneof"`
}

type Step_Endpoint struct {
	// Display information of the source and destination under analysis.
	// The endpoint information in an intermediate state may differ with the
	// initial input, as it might be modified by state like NAT,
	// or Connection Proxy.
	Endpoint *EndpointInfo `protobuf:"bytes,8,opt,name=endpoint,proto3,oneof"`
}

type Step_GoogleService struct {
	// Display information of a Google service
	GoogleService *GoogleServiceInfo `protobuf:"bytes,24,opt,name=google_service,json=googleService,proto3,oneof"`
}

type Step_ForwardingRule struct {
	// Display information of a Compute Engine forwarding rule.
	ForwardingRule *ForwardingRuleInfo `protobuf:"bytes,9,opt,name=forwarding_rule,json=forwardingRule,proto3,oneof"`
}

type Step_HybridSubnet struct {
	// Display information of a hybrid subnet.
	HybridSubnet *HybridSubnetInfo `protobuf:"bytes,36,opt,name=hybrid_subnet,json=hybridSubnet,proto3,oneof"`
}

type Step_VpnGateway struct {
	// Display information of a Compute Engine VPN gateway.
	VpnGateway *VpnGatewayInfo `protobuf:"bytes,10,opt,name=vpn_gateway,json=vpnGateway,proto3,oneof"`
}

type Step_VpnTunnel struct {
	// Display information of a Compute Engine VPN tunnel.
	VpnTunnel *VpnTunnelInfo `protobuf:"bytes,11,opt,name=vpn_tunnel,json=vpnTunnel,proto3,oneof"`
}

type Step_InterconnectAttachment struct {
	// Display information of an interconnect attachment.
	InterconnectAttachment *InterconnectAttachmentInfo `protobuf:"bytes,35,opt,name=interconnect_attachment,json=interconnectAttachment,proto3,oneof"`
}

type Step_VpcConnector struct {
	// Display information of a VPC connector.
	VpcConnector *VpcConnectorInfo `protobuf:"bytes,21,opt,name=vpc_connector,json=vpcConnector,proto3,oneof"`
}

type Step_DirectVpcEgressConnection struct {
	// Display information of a serverless direct VPC egress connection.
	DirectVpcEgressConnection *DirectVpcEgressConnectionInfo `protobuf:"bytes,33,opt,name=direct_vpc_egress_connection,json=directVpcEgressConnection,proto3,oneof"`
}

type Step_ServerlessExternalConnection struct {
	// Display information of a serverless public (external) connection.
	ServerlessExternalConnection *ServerlessExternalConnectionInfo `protobuf:"bytes,34,opt,name=serverless_external_connection,json=serverlessExternalConnection,proto3,oneof"`
}

type Step_Deliver struct {
	// Display information of the final state "deliver" and reason.
	Deliver *DeliverInfo `protobuf:"bytes,12,opt,name=deliver,proto3,oneof"`
}

type Step_Forward struct {
	// Display information of the final state "forward" and reason.
	Forward *ForwardInfo `protobuf:"bytes,13,opt,name=forward,proto3,oneof"`
}

type Step_Abort struct {
	// Display information of the final state "abort" and reason.
	Abort *AbortInfo `protobuf:"bytes,14,opt,name=abort,proto3,oneof"`
}

type Step_Drop struct {
	// Display information of the final state "drop" and reason.
	Drop *DropInfo `protobuf:"bytes,15,opt,name=drop,proto3,oneof"`
}

type Step_LoadBalancer struct {
	// Display information of the load balancers. Deprecated in favor of the
	// `load_balancer_backend_info` field, not used in new tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	LoadBalancer *LoadBalancerInfo `protobuf:"bytes,16,opt,name=load_balancer,json=loadBalancer,proto3,oneof"`
}

type Step_Network struct {
	// Display information of a Google Cloud network.
	Network *NetworkInfo `protobuf:"bytes,17,opt,name=network,proto3,oneof"`
}

type Step_GkeMaster struct {
	// Display information of a Google Kubernetes Engine cluster master.
	GkeMaster *GKEMasterInfo `protobuf:"bytes,18,opt,name=gke_master,json=gkeMaster,proto3,oneof"`
}

type Step_CloudSqlInstance struct {
	// Display information of a Cloud SQL instance.
	CloudSqlInstance *CloudSQLInstanceInfo `protobuf:"bytes,19,opt,name=cloud_sql_instance,json=cloudSqlInstance,proto3,oneof"`
}

type Step_RedisInstance struct {
	// Display information of a Redis Instance.
	RedisInstance *RedisInstanceInfo `protobuf:"bytes,30,opt,name=redis_instance,json=redisInstance,proto3,oneof"`
}

type Step_RedisCluster struct {
	// Display information of a Redis Cluster.
	RedisCluster *RedisClusterInfo `protobuf:"bytes,31,opt,name=redis_cluster,json=redisCluster,proto3,oneof"`
}

type Step_CloudFunction struct {
	// Display information of a Cloud Function.
	CloudFunction *CloudFunctionInfo `protobuf:"bytes,20,opt,name=cloud_function,json=cloudFunction,proto3,oneof"`
}

type Step_AppEngineVersion struct {
	// Display information of an App Engine service version.
	AppEngineVersion *AppEngineVersionInfo `protobuf:"bytes,22,opt,name=app_engine_version,json=appEngineVersion,proto3,oneof"`
}

type Step_CloudRunRevision struct {
	// Display information of a Cloud Run revision.
	CloudRunRevision *CloudRunRevisionInfo `protobuf:"bytes,23,opt,name=cloud_run_revision,json=cloudRunRevision,proto3,oneof"`
}

type Step_Nat struct {
	// Display information of a NAT.
	Nat *NatInfo `protobuf:"bytes,25,opt,name=nat,proto3,oneof"`
}

type Step_ProxyConnection struct {
	// Display information of a ProxyConnection.
	ProxyConnection *ProxyConnectionInfo `protobuf:"bytes,26,opt,name=proxy_connection,json=proxyConnection,proto3,oneof"`
}

type Step_LoadBalancerBackendInfo struct {
	// Display information of a specific load balancer backend.
	LoadBalancerBackendInfo *LoadBalancerBackendInfo `protobuf:"bytes,27,opt,name=load_balancer_backend_info,json=loadBalancerBackendInfo,proto3,oneof"`
}

type Step_StorageBucket struct {
	// Display information of a Storage Bucket. Used only for return traces.
	StorageBucket *StorageBucketInfo `protobuf:"bytes,28,opt,name=storage_bucket,json=storageBucket,proto3,oneof"`
}

type Step_ServerlessNeg struct {
	// Display information of a Serverless network endpoint group backend. Used
	// only for return traces.
	ServerlessNeg *ServerlessNegInfo `protobuf:"bytes,29,opt,name=serverless_neg,json=serverlessNeg,proto3,oneof"`
}

func (*Step_Instance) isStep_StepInfo() {}

func (*Step_Firewall) isStep_StepInfo() {}

func (*Step_Route) isStep_StepInfo() {}

func (*Step_Endpoint) isStep_StepInfo() {}

func (*Step_GoogleService) isStep_StepInfo() {}

func (*Step_ForwardingRule) isStep_StepInfo() {}

func (*Step_HybridSubnet) isStep_StepInfo() {}

func (*Step_VpnGateway) isStep_StepInfo() {}

func (*Step_VpnTunnel) isStep_StepInfo() {}

func (*Step_InterconnectAttachment) isStep_StepInfo() {}

func (*Step_VpcConnector) isStep_StepInfo() {}

func (*Step_DirectVpcEgressConnection) isStep_StepInfo() {}

func (*Step_ServerlessExternalConnection) isStep_StepInfo() {}

func (*Step_Deliver) isStep_StepInfo() {}

func (*Step_Forward) isStep_StepInfo() {}

func (*Step_Abort) isStep_StepInfo() {}

func (*Step_Drop) isStep_StepInfo() {}

func (*Step_LoadBalancer) isStep_StepInfo() {}

func (*Step_Network) isStep_StepInfo() {}

func (*Step_GkeMaster) isStep_StepInfo() {}

func (*Step_CloudSqlInstance) isStep_StepInfo() {}

func (*Step_RedisInstance) isStep_StepInfo() {}

func (*Step_RedisCluster) isStep_StepInfo() {}

func (*Step_CloudFunction) isStep_StepInfo() {}

func (*Step_AppEngineVersion) isStep_StepInfo() {}

func (*Step_CloudRunRevision) isStep_StepInfo() {}

func (*Step_Nat) isStep_StepInfo() {}

func (*Step_ProxyConnection) isStep_StepInfo() {}

func (*Step_LoadBalancerBackendInfo) isStep_StepInfo() {}

func (*Step_StorageBucket) isStep_StepInfo() {}

func (*Step_ServerlessNeg) isStep_StepInfo() {}

// For display only. Metadata associated with a Compute Engine instance.
type InstanceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Compute Engine instance.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Compute Engine instance.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Name of the network interface of a Compute Engine instance.
	Interface string `protobuf:"bytes,3,opt,name=interface,proto3" json:"interface,omitempty"`
	// URI of a Compute Engine network.
	NetworkUri string `protobuf:"bytes,4,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Internal IP address of the network interface.
	InternalIp string `protobuf:"bytes,5,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// External IP address of the network interface.
	ExternalIp string `protobuf:"bytes,6,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
	// Network tags configured on the instance.
	NetworkTags []string `protobuf:"bytes,7,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// Service account authorized for the instance.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	ServiceAccount string `protobuf:"bytes,8,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// URI of the PSC network attachment the NIC is attached to (if relevant).
	PscNetworkAttachmentUri string `protobuf:"bytes,9,opt,name=psc_network_attachment_uri,json=pscNetworkAttachmentUri,proto3" json:"psc_network_attachment_uri,omitempty"`
	// Indicates whether the Compute Engine instance is running.
	// Deprecated: use the `status` field instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	Running bool `protobuf:"varint,10,opt,name=running,proto3" json:"running,omitempty"`
	// The status of the instance.
	Status InstanceInfo_Status `protobuf:"varint,11,opt,name=status,proto3,enum=google.cloud.networkmanagement.v1.InstanceInfo_Status" json:"status,omitempty"`
}

func (x *InstanceInfo) Reset() {
	*x = InstanceInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InstanceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceInfo) ProtoMessage() {}

func (x *InstanceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceInfo.ProtoReflect.Descriptor instead.
func (*InstanceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{2}
}

func (x *InstanceInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *InstanceInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *InstanceInfo) GetInterface() string {
	if x != nil {
		return x.Interface
	}
	return ""
}

func (x *InstanceInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *InstanceInfo) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *InstanceInfo) GetExternalIp() string {
	if x != nil {
		return x.ExternalIp
	}
	return ""
}

func (x *InstanceInfo) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
func (x *InstanceInfo) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *InstanceInfo) GetPscNetworkAttachmentUri() string {
	if x != nil {
		return x.PscNetworkAttachmentUri
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
func (x *InstanceInfo) GetRunning() bool {
	if x != nil {
		return x.Running
	}
	return false
}

func (x *InstanceInfo) GetStatus() InstanceInfo_Status {
	if x != nil {
		return x.Status
	}
	return InstanceInfo_STATUS_UNSPECIFIED
}

// For display only. Metadata associated with a Compute Engine network.
type NetworkInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Compute Engine network.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Compute Engine network.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI of the subnet matching the source IP address of the test.
	MatchedSubnetUri string `protobuf:"bytes,5,opt,name=matched_subnet_uri,json=matchedSubnetUri,proto3" json:"matched_subnet_uri,omitempty"`
	// The IP range of the subnet matching the source IP address of the test.
	MatchedIpRange string `protobuf:"bytes,4,opt,name=matched_ip_range,json=matchedIpRange,proto3" json:"matched_ip_range,omitempty"`
	// The region of the subnet matching the source IP address of the test.
	Region string `protobuf:"bytes,6,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *NetworkInfo) Reset() {
	*x = NetworkInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkInfo) ProtoMessage() {}

func (x *NetworkInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkInfo.ProtoReflect.Descriptor instead.
func (*NetworkInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{3}
}

func (x *NetworkInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *NetworkInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *NetworkInfo) GetMatchedSubnetUri() string {
	if x != nil {
		return x.MatchedSubnetUri
	}
	return ""
}

func (x *NetworkInfo) GetMatchedIpRange() string {
	if x != nil {
		return x.MatchedIpRange
	}
	return ""
}

func (x *NetworkInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// For display only. Metadata associated with a VPC firewall rule, an implied
// VPC firewall rule, or a firewall policy rule.
type FirewallInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The display name of the firewall rule. This field might be empty for
	// firewall policy rules.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The URI of the firewall rule. This field is not applicable to implied
	// VPC firewall rules.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Possible values: INGRESS, EGRESS
	Direction string `protobuf:"bytes,3,opt,name=direction,proto3" json:"direction,omitempty"`
	// Possible values: ALLOW, DENY, APPLY_SECURITY_PROFILE_GROUP
	Action string `protobuf:"bytes,4,opt,name=action,proto3" json:"action,omitempty"`
	// The priority of the firewall rule.
	Priority int32 `protobuf:"varint,5,opt,name=priority,proto3" json:"priority,omitempty"`
	// The URI of the VPC network that the firewall rule is associated with.
	// This field is not applicable to hierarchical firewall policy rules.
	NetworkUri string `protobuf:"bytes,6,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// The target tags defined by the VPC firewall rule. This field is not
	// applicable to firewall policy rules.
	TargetTags []string `protobuf:"bytes,7,rep,name=target_tags,json=targetTags,proto3" json:"target_tags,omitempty"`
	// The target service accounts specified by the firewall rule.
	TargetServiceAccounts []string `protobuf:"bytes,8,rep,name=target_service_accounts,json=targetServiceAccounts,proto3" json:"target_service_accounts,omitempty"`
	// The name of the firewall policy that this rule is associated with.
	// This field is not applicable to VPC firewall rules and implied VPC firewall
	// rules.
	Policy string `protobuf:"bytes,9,opt,name=policy,proto3" json:"policy,omitempty"`
	// The URI of the firewall policy that this rule is associated with.
	// This field is not applicable to VPC firewall rules and implied VPC firewall
	// rules.
	PolicyUri string `protobuf:"bytes,11,opt,name=policy_uri,json=policyUri,proto3" json:"policy_uri,omitempty"`
	// The firewall rule's type.
	FirewallRuleType FirewallInfo_FirewallRuleType `protobuf:"varint,10,opt,name=firewall_rule_type,json=firewallRuleType,proto3,enum=google.cloud.networkmanagement.v1.FirewallInfo_FirewallRuleType" json:"firewall_rule_type,omitempty"`
	// The priority of the firewall policy that this rule is associated with.
	// This field is not applicable to VPC firewall rules and implied VPC firewall
	// rules.
	PolicyPriority int32 `protobuf:"varint,12,opt,name=policy_priority,json=policyPriority,proto3" json:"policy_priority,omitempty"`
	// Target type of the firewall rule.
	TargetType FirewallInfo_TargetType `protobuf:"varint,13,opt,name=target_type,json=targetType,proto3,enum=google.cloud.networkmanagement.v1.FirewallInfo_TargetType" json:"target_type,omitempty"`
}

func (x *FirewallInfo) Reset() {
	*x = FirewallInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FirewallInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirewallInfo) ProtoMessage() {}

func (x *FirewallInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirewallInfo.ProtoReflect.Descriptor instead.
func (*FirewallInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{4}
}

func (x *FirewallInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *FirewallInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *FirewallInfo) GetDirection() string {
	if x != nil {
		return x.Direction
	}
	return ""
}

func (x *FirewallInfo) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *FirewallInfo) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *FirewallInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *FirewallInfo) GetTargetTags() []string {
	if x != nil {
		return x.TargetTags
	}
	return nil
}

func (x *FirewallInfo) GetTargetServiceAccounts() []string {
	if x != nil {
		return x.TargetServiceAccounts
	}
	return nil
}

func (x *FirewallInfo) GetPolicy() string {
	if x != nil {
		return x.Policy
	}
	return ""
}

func (x *FirewallInfo) GetPolicyUri() string {
	if x != nil {
		return x.PolicyUri
	}
	return ""
}

func (x *FirewallInfo) GetFirewallRuleType() FirewallInfo_FirewallRuleType {
	if x != nil {
		return x.FirewallRuleType
	}
	return FirewallInfo_FIREWALL_RULE_TYPE_UNSPECIFIED
}

func (x *FirewallInfo) GetPolicyPriority() int32 {
	if x != nil {
		return x.PolicyPriority
	}
	return 0
}

func (x *FirewallInfo) GetTargetType() FirewallInfo_TargetType {
	if x != nil {
		return x.TargetType
	}
	return FirewallInfo_TARGET_TYPE_UNSPECIFIED
}

// For display only. Metadata associated with a Compute Engine route.
type RouteInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of route.
	RouteType RouteInfo_RouteType `protobuf:"varint,8,opt,name=route_type,json=routeType,proto3,enum=google.cloud.networkmanagement.v1.RouteInfo_RouteType" json:"route_type,omitempty"`
	// Type of next hop.
	NextHopType RouteInfo_NextHopType `protobuf:"varint,9,opt,name=next_hop_type,json=nextHopType,proto3,enum=google.cloud.networkmanagement.v1.RouteInfo_NextHopType" json:"next_hop_type,omitempty"`
	// Indicates where route is applicable. Deprecated, routes with NCC_HUB scope
	// are not included in the trace in new tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	RouteScope RouteInfo_RouteScope `protobuf:"varint,14,opt,name=route_scope,json=routeScope,proto3,enum=google.cloud.networkmanagement.v1.RouteInfo_RouteScope" json:"route_scope,omitempty"`
	// Name of a route.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a route. SUBNET, STATIC, PEERING_SUBNET (only for peering network)
	// and POLICY_BASED routes only.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Region of the route. DYNAMIC, PEERING_DYNAMIC, POLICY_BASED and ADVERTISED
	// routes only. If set for POLICY_BASED route, this is a region of VLAN
	// attachments for Cloud Interconnect the route applies to.
	Region string `protobuf:"bytes,19,opt,name=region,proto3" json:"region,omitempty"`
	// Destination IP range of the route.
	DestIpRange string `protobuf:"bytes,3,opt,name=dest_ip_range,json=destIpRange,proto3" json:"dest_ip_range,omitempty"`
	// String type of the next hop of the route (for example, "VPN tunnel").
	// Deprecated in favor of the next_hop_type and next_hop_uri fields, not used
	// in new tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	NextHop string `protobuf:"bytes,4,opt,name=next_hop,json=nextHop,proto3" json:"next_hop,omitempty"`
	// URI of a VPC network where route is located.
	NetworkUri string `protobuf:"bytes,5,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Priority of the route.
	Priority int32 `protobuf:"varint,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// Instance tags of the route.
	InstanceTags []string `protobuf:"bytes,7,rep,name=instance_tags,json=instanceTags,proto3" json:"instance_tags,omitempty"`
	// Source IP address range of the route. POLICY_BASED routes only.
	SrcIpRange string `protobuf:"bytes,10,opt,name=src_ip_range,json=srcIpRange,proto3" json:"src_ip_range,omitempty"`
	// Destination port ranges of the route. POLICY_BASED routes only.
	DestPortRanges []string `protobuf:"bytes,11,rep,name=dest_port_ranges,json=destPortRanges,proto3" json:"dest_port_ranges,omitempty"`
	// Source port ranges of the route. POLICY_BASED routes only.
	SrcPortRanges []string `protobuf:"bytes,12,rep,name=src_port_ranges,json=srcPortRanges,proto3" json:"src_port_ranges,omitempty"`
	// Protocols of the route. POLICY_BASED routes only.
	Protocols []string `protobuf:"bytes,13,rep,name=protocols,proto3" json:"protocols,omitempty"`
	// URI of the NCC Hub the route is advertised by. PEERING_SUBNET and
	// PEERING_DYNAMIC routes that are advertised by NCC Hub only.
	NccHubUri *string `protobuf:"bytes,15,opt,name=ncc_hub_uri,json=nccHubUri,proto3,oneof" json:"ncc_hub_uri,omitempty"`
	// URI of the destination NCC Spoke. PEERING_SUBNET and PEERING_DYNAMIC routes
	// that are advertised by NCC Hub only.
	NccSpokeUri *string `protobuf:"bytes,16,opt,name=ncc_spoke_uri,json=nccSpokeUri,proto3,oneof" json:"ncc_spoke_uri,omitempty"`
	// For ADVERTISED dynamic routes, the URI of the Cloud Router that advertised
	// the corresponding IP prefix.
	AdvertisedRouteSourceRouterUri *string `protobuf:"bytes,17,opt,name=advertised_route_source_router_uri,json=advertisedRouteSourceRouterUri,proto3,oneof" json:"advertised_route_source_router_uri,omitempty"`
	// For ADVERTISED routes, the URI of their next hop, i.e. the URI of the
	// hybrid endpoint (VPN tunnel, Interconnect attachment, NCC router appliance)
	// the advertised prefix is advertised through, or URI of the source peered
	// network. Deprecated in favor of the next_hop_uri field, not used in new
	// tests.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	AdvertisedRouteNextHopUri *string `protobuf:"bytes,18,opt,name=advertised_route_next_hop_uri,json=advertisedRouteNextHopUri,proto3,oneof" json:"advertised_route_next_hop_uri,omitempty"`
	// URI of the next hop resource.
	NextHopUri string `protobuf:"bytes,20,opt,name=next_hop_uri,json=nextHopUri,proto3" json:"next_hop_uri,omitempty"`
	// URI of a VPC network where the next hop resource is located.
	NextHopNetworkUri string `protobuf:"bytes,21,opt,name=next_hop_network_uri,json=nextHopNetworkUri,proto3" json:"next_hop_network_uri,omitempty"`
	// For PEERING_SUBNET and PEERING_STATIC routes, the URI of the originating
	// SUBNET/STATIC route.
	OriginatingRouteUri string `protobuf:"bytes,22,opt,name=originating_route_uri,json=originatingRouteUri,proto3" json:"originating_route_uri,omitempty"`
	// For PEERING_SUBNET, PEERING_STATIC and PEERING_DYNAMIC routes, the name of
	// the originating SUBNET/STATIC/DYNAMIC route.
	OriginatingRouteDisplayName string `protobuf:"bytes,23,opt,name=originating_route_display_name,json=originatingRouteDisplayName,proto3" json:"originating_route_display_name,omitempty"`
	// For PEERING_SUBNET and PEERING_DYNAMIC routes that are advertised by NCC
	// Hub, the URI of the corresponding route in NCC Hub's routing table.
	NccHubRouteUri string `protobuf:"bytes,24,opt,name=ncc_hub_route_uri,json=nccHubRouteUri,proto3" json:"ncc_hub_route_uri,omitempty"`
}

func (x *RouteInfo) Reset() {
	*x = RouteInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RouteInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteInfo) ProtoMessage() {}

func (x *RouteInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteInfo.ProtoReflect.Descriptor instead.
func (*RouteInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{5}
}

func (x *RouteInfo) GetRouteType() RouteInfo_RouteType {
	if x != nil {
		return x.RouteType
	}
	return RouteInfo_ROUTE_TYPE_UNSPECIFIED
}

func (x *RouteInfo) GetNextHopType() RouteInfo_NextHopType {
	if x != nil {
		return x.NextHopType
	}
	return RouteInfo_NEXT_HOP_TYPE_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
func (x *RouteInfo) GetRouteScope() RouteInfo_RouteScope {
	if x != nil {
		return x.RouteScope
	}
	return RouteInfo_ROUTE_SCOPE_UNSPECIFIED
}

func (x *RouteInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *RouteInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *RouteInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *RouteInfo) GetDestIpRange() string {
	if x != nil {
		return x.DestIpRange
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
func (x *RouteInfo) GetNextHop() string {
	if x != nil {
		return x.NextHop
	}
	return ""
}

func (x *RouteInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *RouteInfo) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *RouteInfo) GetInstanceTags() []string {
	if x != nil {
		return x.InstanceTags
	}
	return nil
}

func (x *RouteInfo) GetSrcIpRange() string {
	if x != nil {
		return x.SrcIpRange
	}
	return ""
}

func (x *RouteInfo) GetDestPortRanges() []string {
	if x != nil {
		return x.DestPortRanges
	}
	return nil
}

func (x *RouteInfo) GetSrcPortRanges() []string {
	if x != nil {
		return x.SrcPortRanges
	}
	return nil
}

func (x *RouteInfo) GetProtocols() []string {
	if x != nil {
		return x.Protocols
	}
	return nil
}

func (x *RouteInfo) GetNccHubUri() string {
	if x != nil && x.NccHubUri != nil {
		return *x.NccHubUri
	}
	return ""
}

func (x *RouteInfo) GetNccSpokeUri() string {
	if x != nil && x.NccSpokeUri != nil {
		return *x.NccSpokeUri
	}
	return ""
}

func (x *RouteInfo) GetAdvertisedRouteSourceRouterUri() string {
	if x != nil && x.AdvertisedRouteSourceRouterUri != nil {
		return *x.AdvertisedRouteSourceRouterUri
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
func (x *RouteInfo) GetAdvertisedRouteNextHopUri() string {
	if x != nil && x.AdvertisedRouteNextHopUri != nil {
		return *x.AdvertisedRouteNextHopUri
	}
	return ""
}

func (x *RouteInfo) GetNextHopUri() string {
	if x != nil {
		return x.NextHopUri
	}
	return ""
}

func (x *RouteInfo) GetNextHopNetworkUri() string {
	if x != nil {
		return x.NextHopNetworkUri
	}
	return ""
}

func (x *RouteInfo) GetOriginatingRouteUri() string {
	if x != nil {
		return x.OriginatingRouteUri
	}
	return ""
}

func (x *RouteInfo) GetOriginatingRouteDisplayName() string {
	if x != nil {
		return x.OriginatingRouteDisplayName
	}
	return ""
}

func (x *RouteInfo) GetNccHubRouteUri() string {
	if x != nil {
		return x.NccHubRouteUri
	}
	return ""
}

// For display only. Details of a Google Service sending packets to a
// VPC network. Although the source IP might be a publicly routable address,
// some Google Services use special routes within Google production
// infrastructure to reach Compute Engine Instances.
// https://cloud.google.com/vpc/docs/routes#special_return_paths
type GoogleServiceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source IP address.
	SourceIp string `protobuf:"bytes,1,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// Recognized type of a Google Service.
	GoogleServiceType GoogleServiceInfo_GoogleServiceType `protobuf:"varint,2,opt,name=google_service_type,json=googleServiceType,proto3,enum=google.cloud.networkmanagement.v1.GoogleServiceInfo_GoogleServiceType" json:"google_service_type,omitempty"`
}

func (x *GoogleServiceInfo) Reset() {
	*x = GoogleServiceInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoogleServiceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleServiceInfo) ProtoMessage() {}

func (x *GoogleServiceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleServiceInfo.ProtoReflect.Descriptor instead.
func (*GoogleServiceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{6}
}

func (x *GoogleServiceInfo) GetSourceIp() string {
	if x != nil {
		return x.SourceIp
	}
	return ""
}

func (x *GoogleServiceInfo) GetGoogleServiceType() GoogleServiceInfo_GoogleServiceType {
	if x != nil {
		return x.GoogleServiceType
	}
	return GoogleServiceInfo_GOOGLE_SERVICE_TYPE_UNSPECIFIED
}

// For display only. Metadata associated with a Compute Engine forwarding rule.
type ForwardingRuleInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the forwarding rule.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of the forwarding rule.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Protocol defined in the forwarding rule that matches the packet.
	MatchedProtocol string `protobuf:"bytes,3,opt,name=matched_protocol,json=matchedProtocol,proto3" json:"matched_protocol,omitempty"`
	// Port range defined in the forwarding rule that matches the packet.
	MatchedPortRange string `protobuf:"bytes,6,opt,name=matched_port_range,json=matchedPortRange,proto3" json:"matched_port_range,omitempty"`
	// VIP of the forwarding rule.
	Vip string `protobuf:"bytes,4,opt,name=vip,proto3" json:"vip,omitempty"`
	// Target type of the forwarding rule.
	Target string `protobuf:"bytes,5,opt,name=target,proto3" json:"target,omitempty"`
	// Network URI.
	NetworkUri string `protobuf:"bytes,7,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Region of the forwarding rule. Set only for regional forwarding rules.
	Region string `protobuf:"bytes,8,opt,name=region,proto3" json:"region,omitempty"`
	// Name of the load balancer the forwarding rule belongs to. Empty for
	// forwarding rules not related to load balancers (like PSC forwarding rules).
	LoadBalancerName string `protobuf:"bytes,9,opt,name=load_balancer_name,json=loadBalancerName,proto3" json:"load_balancer_name,omitempty"`
	// URI of the PSC service attachment this forwarding rule targets (if
	// applicable).
	PscServiceAttachmentUri string `protobuf:"bytes,10,opt,name=psc_service_attachment_uri,json=pscServiceAttachmentUri,proto3" json:"psc_service_attachment_uri,omitempty"`
	// PSC Google API target this forwarding rule targets (if applicable).
	PscGoogleApiTarget string `protobuf:"bytes,11,opt,name=psc_google_api_target,json=pscGoogleApiTarget,proto3" json:"psc_google_api_target,omitempty"`
}

func (x *ForwardingRuleInfo) Reset() {
	*x = ForwardingRuleInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ForwardingRuleInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardingRuleInfo) ProtoMessage() {}

func (x *ForwardingRuleInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardingRuleInfo.ProtoReflect.Descriptor instead.
func (*ForwardingRuleInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{7}
}

func (x *ForwardingRuleInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ForwardingRuleInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ForwardingRuleInfo) GetMatchedProtocol() string {
	if x != nil {
		return x.MatchedProtocol
	}
	return ""
}

func (x *ForwardingRuleInfo) GetMatchedPortRange() string {
	if x != nil {
		return x.MatchedPortRange
	}
	return ""
}

func (x *ForwardingRuleInfo) GetVip() string {
	if x != nil {
		return x.Vip
	}
	return ""
}

func (x *ForwardingRuleInfo) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *ForwardingRuleInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *ForwardingRuleInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *ForwardingRuleInfo) GetLoadBalancerName() string {
	if x != nil {
		return x.LoadBalancerName
	}
	return ""
}

func (x *ForwardingRuleInfo) GetPscServiceAttachmentUri() string {
	if x != nil {
		return x.PscServiceAttachmentUri
	}
	return ""
}

func (x *ForwardingRuleInfo) GetPscGoogleApiTarget() string {
	if x != nil {
		return x.PscGoogleApiTarget
	}
	return ""
}

// For display only. Metadata associated with a load balancer.
type LoadBalancerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the load balancer.
	LoadBalancerType LoadBalancerInfo_LoadBalancerType `protobuf:"varint,1,opt,name=load_balancer_type,json=loadBalancerType,proto3,enum=google.cloud.networkmanagement.v1.LoadBalancerInfo_LoadBalancerType" json:"load_balancer_type,omitempty"`
	// URI of the health check for the load balancer. Deprecated and no longer
	// populated as different load balancer backends might have different health
	// checks.
	//
	// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
	HealthCheckUri string `protobuf:"bytes,2,opt,name=health_check_uri,json=healthCheckUri,proto3" json:"health_check_uri,omitempty"`
	// Information for the loadbalancer backends.
	Backends []*LoadBalancerBackend `protobuf:"bytes,3,rep,name=backends,proto3" json:"backends,omitempty"`
	// Type of load balancer's backend configuration.
	BackendType LoadBalancerInfo_BackendType `protobuf:"varint,4,opt,name=backend_type,json=backendType,proto3,enum=google.cloud.networkmanagement.v1.LoadBalancerInfo_BackendType" json:"backend_type,omitempty"`
	// Backend configuration URI.
	BackendUri string `protobuf:"bytes,5,opt,name=backend_uri,json=backendUri,proto3" json:"backend_uri,omitempty"`
}

func (x *LoadBalancerInfo) Reset() {
	*x = LoadBalancerInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadBalancerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerInfo) ProtoMessage() {}

func (x *LoadBalancerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerInfo.ProtoReflect.Descriptor instead.
func (*LoadBalancerInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{8}
}

func (x *LoadBalancerInfo) GetLoadBalancerType() LoadBalancerInfo_LoadBalancerType {
	if x != nil {
		return x.LoadBalancerType
	}
	return LoadBalancerInfo_LOAD_BALANCER_TYPE_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/cloud/networkmanagement/v1/trace.proto.
func (x *LoadBalancerInfo) GetHealthCheckUri() string {
	if x != nil {
		return x.HealthCheckUri
	}
	return ""
}

func (x *LoadBalancerInfo) GetBackends() []*LoadBalancerBackend {
	if x != nil {
		return x.Backends
	}
	return nil
}

func (x *LoadBalancerInfo) GetBackendType() LoadBalancerInfo_BackendType {
	if x != nil {
		return x.BackendType
	}
	return LoadBalancerInfo_BACKEND_TYPE_UNSPECIFIED
}

func (x *LoadBalancerInfo) GetBackendUri() string {
	if x != nil {
		return x.BackendUri
	}
	return ""
}

// For display only. Metadata associated with a specific load balancer backend.
type LoadBalancerBackend struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Compute Engine instance or network endpoint.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Compute Engine instance or network endpoint.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// State of the health check firewall configuration.
	HealthCheckFirewallState LoadBalancerBackend_HealthCheckFirewallState `protobuf:"varint,3,opt,name=health_check_firewall_state,json=healthCheckFirewallState,proto3,enum=google.cloud.networkmanagement.v1.LoadBalancerBackend_HealthCheckFirewallState" json:"health_check_firewall_state,omitempty"`
	// A list of firewall rule URIs allowing probes from health check IP ranges.
	HealthCheckAllowingFirewallRules []string `protobuf:"bytes,4,rep,name=health_check_allowing_firewall_rules,json=healthCheckAllowingFirewallRules,proto3" json:"health_check_allowing_firewall_rules,omitempty"`
	// A list of firewall rule URIs blocking probes from health check IP ranges.
	HealthCheckBlockingFirewallRules []string `protobuf:"bytes,5,rep,name=health_check_blocking_firewall_rules,json=healthCheckBlockingFirewallRules,proto3" json:"health_check_blocking_firewall_rules,omitempty"`
}

func (x *LoadBalancerBackend) Reset() {
	*x = LoadBalancerBackend{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadBalancerBackend) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerBackend) ProtoMessage() {}

func (x *LoadBalancerBackend) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerBackend.ProtoReflect.Descriptor instead.
func (*LoadBalancerBackend) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{9}
}

func (x *LoadBalancerBackend) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *LoadBalancerBackend) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *LoadBalancerBackend) GetHealthCheckFirewallState() LoadBalancerBackend_HealthCheckFirewallState {
	if x != nil {
		return x.HealthCheckFirewallState
	}
	return LoadBalancerBackend_HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED
}

func (x *LoadBalancerBackend) GetHealthCheckAllowingFirewallRules() []string {
	if x != nil {
		return x.HealthCheckAllowingFirewallRules
	}
	return nil
}

func (x *LoadBalancerBackend) GetHealthCheckBlockingFirewallRules() []string {
	if x != nil {
		return x.HealthCheckBlockingFirewallRules
	}
	return nil
}

// For display only. Metadata associated with a hybrid subnet.
type HybridSubnetInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a hybrid subnet.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a hybrid subnet.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Name of a Google Cloud region where the hybrid subnet is configured.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *HybridSubnetInfo) Reset() {
	*x = HybridSubnetInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HybridSubnetInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridSubnetInfo) ProtoMessage() {}

func (x *HybridSubnetInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridSubnetInfo.ProtoReflect.Descriptor instead.
func (*HybridSubnetInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{10}
}

func (x *HybridSubnetInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *HybridSubnetInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *HybridSubnetInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// For display only. Metadata associated with a Compute Engine VPN gateway.
type VpnGatewayInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a VPN gateway.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a VPN gateway.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI of a Compute Engine network where the VPN gateway is configured.
	NetworkUri string `protobuf:"bytes,3,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// IP address of the VPN gateway.
	IpAddress string `protobuf:"bytes,4,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// A VPN tunnel that is associated with this VPN gateway.
	// There may be multiple VPN tunnels configured on a VPN gateway, and only
	// the one relevant to the test is displayed.
	VpnTunnelUri string `protobuf:"bytes,5,opt,name=vpn_tunnel_uri,json=vpnTunnelUri,proto3" json:"vpn_tunnel_uri,omitempty"`
	// Name of a Google Cloud region where this VPN gateway is configured.
	Region string `protobuf:"bytes,6,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *VpnGatewayInfo) Reset() {
	*x = VpnGatewayInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VpnGatewayInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpnGatewayInfo) ProtoMessage() {}

func (x *VpnGatewayInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpnGatewayInfo.ProtoReflect.Descriptor instead.
func (*VpnGatewayInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{11}
}

func (x *VpnGatewayInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VpnGatewayInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *VpnGatewayInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *VpnGatewayInfo) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *VpnGatewayInfo) GetVpnTunnelUri() string {
	if x != nil {
		return x.VpnTunnelUri
	}
	return ""
}

func (x *VpnGatewayInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// For display only. Metadata associated with a Compute Engine VPN tunnel.
type VpnTunnelInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a VPN tunnel.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a VPN tunnel.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI of the VPN gateway at local end of the tunnel.
	SourceGateway string `protobuf:"bytes,3,opt,name=source_gateway,json=sourceGateway,proto3" json:"source_gateway,omitempty"`
	// URI of a VPN gateway at remote end of the tunnel.
	RemoteGateway string `protobuf:"bytes,4,opt,name=remote_gateway,json=remoteGateway,proto3" json:"remote_gateway,omitempty"`
	// Remote VPN gateway's IP address.
	RemoteGatewayIp string `protobuf:"bytes,5,opt,name=remote_gateway_ip,json=remoteGatewayIp,proto3" json:"remote_gateway_ip,omitempty"`
	// Local VPN gateway's IP address.
	SourceGatewayIp string `protobuf:"bytes,6,opt,name=source_gateway_ip,json=sourceGatewayIp,proto3" json:"source_gateway_ip,omitempty"`
	// URI of a Compute Engine network where the VPN tunnel is configured.
	NetworkUri string `protobuf:"bytes,7,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Name of a Google Cloud region where this VPN tunnel is configured.
	Region string `protobuf:"bytes,8,opt,name=region,proto3" json:"region,omitempty"`
	// Type of the routing policy.
	RoutingType VpnTunnelInfo_RoutingType `protobuf:"varint,9,opt,name=routing_type,json=routingType,proto3,enum=google.cloud.networkmanagement.v1.VpnTunnelInfo_RoutingType" json:"routing_type,omitempty"`
}

func (x *VpnTunnelInfo) Reset() {
	*x = VpnTunnelInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VpnTunnelInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpnTunnelInfo) ProtoMessage() {}

func (x *VpnTunnelInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpnTunnelInfo.ProtoReflect.Descriptor instead.
func (*VpnTunnelInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{12}
}

func (x *VpnTunnelInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VpnTunnelInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *VpnTunnelInfo) GetSourceGateway() string {
	if x != nil {
		return x.SourceGateway
	}
	return ""
}

func (x *VpnTunnelInfo) GetRemoteGateway() string {
	if x != nil {
		return x.RemoteGateway
	}
	return ""
}

func (x *VpnTunnelInfo) GetRemoteGatewayIp() string {
	if x != nil {
		return x.RemoteGatewayIp
	}
	return ""
}

func (x *VpnTunnelInfo) GetSourceGatewayIp() string {
	if x != nil {
		return x.SourceGatewayIp
	}
	return ""
}

func (x *VpnTunnelInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *VpnTunnelInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *VpnTunnelInfo) GetRoutingType() VpnTunnelInfo_RoutingType {
	if x != nil {
		return x.RoutingType
	}
	return VpnTunnelInfo_ROUTING_TYPE_UNSPECIFIED
}

// For display only. Metadata associated with an Interconnect attachment.
type InterconnectAttachmentInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of an Interconnect attachment.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of an Interconnect attachment.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI of the Interconnect where the Interconnect attachment is
	// configured.
	InterconnectUri string `protobuf:"bytes,3,opt,name=interconnect_uri,json=interconnectUri,proto3" json:"interconnect_uri,omitempty"`
	// Name of a Google Cloud region where the Interconnect attachment is
	// configured.
	Region string `protobuf:"bytes,4,opt,name=region,proto3" json:"region,omitempty"`
	// URI of the Cloud Router to be used for dynamic routing.
	CloudRouterUri string `protobuf:"bytes,5,opt,name=cloud_router_uri,json=cloudRouterUri,proto3" json:"cloud_router_uri,omitempty"`
	// The type of interconnect attachment this is.
	Type InterconnectAttachmentInfo_Type `protobuf:"varint,6,opt,name=type,proto3,enum=google.cloud.networkmanagement.v1.InterconnectAttachmentInfo_Type" json:"type,omitempty"`
	// Appliance IP address that was matched for L2_DEDICATED attachments.
	L2AttachmentMatchedIpAddress string `protobuf:"bytes,7,opt,name=l2_attachment_matched_ip_address,json=l2AttachmentMatchedIpAddress,proto3" json:"l2_attachment_matched_ip_address,omitempty"`
}

func (x *InterconnectAttachmentInfo) Reset() {
	*x = InterconnectAttachmentInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InterconnectAttachmentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterconnectAttachmentInfo) ProtoMessage() {}

func (x *InterconnectAttachmentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterconnectAttachmentInfo.ProtoReflect.Descriptor instead.
func (*InterconnectAttachmentInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{13}
}

func (x *InterconnectAttachmentInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *InterconnectAttachmentInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *InterconnectAttachmentInfo) GetInterconnectUri() string {
	if x != nil {
		return x.InterconnectUri
	}
	return ""
}

func (x *InterconnectAttachmentInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *InterconnectAttachmentInfo) GetCloudRouterUri() string {
	if x != nil {
		return x.CloudRouterUri
	}
	return ""
}

func (x *InterconnectAttachmentInfo) GetType() InterconnectAttachmentInfo_Type {
	if x != nil {
		return x.Type
	}
	return InterconnectAttachmentInfo_TYPE_UNSPECIFIED
}

func (x *InterconnectAttachmentInfo) GetL2AttachmentMatchedIpAddress() string {
	if x != nil {
		return x.L2AttachmentMatchedIpAddress
	}
	return ""
}

// For display only. The specification of the endpoints for the test.
// EndpointInfo is derived from source and destination Endpoint and validated
// by the backend data plane model.
type EndpointInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source IP address.
	SourceIp string `protobuf:"bytes,1,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// Destination IP address.
	DestinationIp string `protobuf:"bytes,2,opt,name=destination_ip,json=destinationIp,proto3" json:"destination_ip,omitempty"`
	// IP protocol in string format, for example: "TCP", "UDP", "ICMP".
	Protocol string `protobuf:"bytes,3,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Source port. Only valid when protocol is TCP or UDP.
	SourcePort int32 `protobuf:"varint,4,opt,name=source_port,json=sourcePort,proto3" json:"source_port,omitempty"`
	// Destination port. Only valid when protocol is TCP or UDP.
	DestinationPort int32 `protobuf:"varint,5,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	// URI of the network where this packet originates from.
	SourceNetworkUri string `protobuf:"bytes,6,opt,name=source_network_uri,json=sourceNetworkUri,proto3" json:"source_network_uri,omitempty"`
	// URI of the network where this packet is sent to.
	DestinationNetworkUri string `protobuf:"bytes,7,opt,name=destination_network_uri,json=destinationNetworkUri,proto3" json:"destination_network_uri,omitempty"`
	// URI of the source telemetry agent this packet originates from.
	SourceAgentUri string `protobuf:"bytes,8,opt,name=source_agent_uri,json=sourceAgentUri,proto3" json:"source_agent_uri,omitempty"`
}

func (x *EndpointInfo) Reset() {
	*x = EndpointInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EndpointInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndpointInfo) ProtoMessage() {}

func (x *EndpointInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndpointInfo.ProtoReflect.Descriptor instead.
func (*EndpointInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{14}
}

func (x *EndpointInfo) GetSourceIp() string {
	if x != nil {
		return x.SourceIp
	}
	return ""
}

func (x *EndpointInfo) GetDestinationIp() string {
	if x != nil {
		return x.DestinationIp
	}
	return ""
}

func (x *EndpointInfo) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *EndpointInfo) GetSourcePort() int32 {
	if x != nil {
		return x.SourcePort
	}
	return 0
}

func (x *EndpointInfo) GetDestinationPort() int32 {
	if x != nil {
		return x.DestinationPort
	}
	return 0
}

func (x *EndpointInfo) GetSourceNetworkUri() string {
	if x != nil {
		return x.SourceNetworkUri
	}
	return ""
}

func (x *EndpointInfo) GetDestinationNetworkUri() string {
	if x != nil {
		return x.DestinationNetworkUri
	}
	return ""
}

func (x *EndpointInfo) GetSourceAgentUri() string {
	if x != nil {
		return x.SourceAgentUri
	}
	return ""
}

// Details of the final state "deliver" and associated resource.
type DeliverInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target type where the packet is delivered to.
	Target DeliverInfo_Target `protobuf:"varint,1,opt,name=target,proto3,enum=google.cloud.networkmanagement.v1.DeliverInfo_Target" json:"target,omitempty"`
	// URI of the resource that the packet is delivered to.
	ResourceUri string `protobuf:"bytes,2,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	// IP address of the target (if applicable).
	IpAddress string `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// Name of the Cloud Storage Bucket the packet is delivered to (if
	// applicable).
	StorageBucket string `protobuf:"bytes,4,opt,name=storage_bucket,json=storageBucket,proto3" json:"storage_bucket,omitempty"`
	// PSC Google API target the packet is delivered to (if applicable).
	PscGoogleApiTarget string `protobuf:"bytes,5,opt,name=psc_google_api_target,json=pscGoogleApiTarget,proto3" json:"psc_google_api_target,omitempty"`
	// Recognized type of a Google Service the packet is delivered to (if
	// applicable).
	GoogleServiceType DeliverInfo_GoogleServiceType `protobuf:"varint,6,opt,name=google_service_type,json=googleServiceType,proto3,enum=google.cloud.networkmanagement.v1.DeliverInfo_GoogleServiceType" json:"google_service_type,omitempty"`
}

func (x *DeliverInfo) Reset() {
	*x = DeliverInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeliverInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeliverInfo) ProtoMessage() {}

func (x *DeliverInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeliverInfo.ProtoReflect.Descriptor instead.
func (*DeliverInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{15}
}

func (x *DeliverInfo) GetTarget() DeliverInfo_Target {
	if x != nil {
		return x.Target
	}
	return DeliverInfo_TARGET_UNSPECIFIED
}

func (x *DeliverInfo) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

func (x *DeliverInfo) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *DeliverInfo) GetStorageBucket() string {
	if x != nil {
		return x.StorageBucket
	}
	return ""
}

func (x *DeliverInfo) GetPscGoogleApiTarget() string {
	if x != nil {
		return x.PscGoogleApiTarget
	}
	return ""
}

func (x *DeliverInfo) GetGoogleServiceType() DeliverInfo_GoogleServiceType {
	if x != nil {
		return x.GoogleServiceType
	}
	return DeliverInfo_GOOGLE_SERVICE_TYPE_UNSPECIFIED
}

// Details of the final state "forward" and associated resource.
type ForwardInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target type where this packet is forwarded to.
	Target ForwardInfo_Target `protobuf:"varint,1,opt,name=target,proto3,enum=google.cloud.networkmanagement.v1.ForwardInfo_Target" json:"target,omitempty"`
	// URI of the resource that the packet is forwarded to.
	ResourceUri string `protobuf:"bytes,2,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	// IP address of the target (if applicable).
	IpAddress string `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
}

func (x *ForwardInfo) Reset() {
	*x = ForwardInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ForwardInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardInfo) ProtoMessage() {}

func (x *ForwardInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardInfo.ProtoReflect.Descriptor instead.
func (*ForwardInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{16}
}

func (x *ForwardInfo) GetTarget() ForwardInfo_Target {
	if x != nil {
		return x.Target
	}
	return ForwardInfo_TARGET_UNSPECIFIED
}

func (x *ForwardInfo) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

func (x *ForwardInfo) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

// Details of the final state "abort" and associated resource.
type AbortInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Causes that the analysis is aborted.
	Cause AbortInfo_Cause `protobuf:"varint,1,opt,name=cause,proto3,enum=google.cloud.networkmanagement.v1.AbortInfo_Cause" json:"cause,omitempty"`
	// URI of the resource that caused the abort.
	ResourceUri string `protobuf:"bytes,2,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	// IP address that caused the abort.
	IpAddress string `protobuf:"bytes,4,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// List of project IDs the user specified in the request but lacks access to.
	// In this case, analysis is aborted with the PERMISSION_DENIED cause.
	ProjectsMissingPermission []string `protobuf:"bytes,3,rep,name=projects_missing_permission,json=projectsMissingPermission,proto3" json:"projects_missing_permission,omitempty"`
}

func (x *AbortInfo) Reset() {
	*x = AbortInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AbortInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AbortInfo) ProtoMessage() {}

func (x *AbortInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AbortInfo.ProtoReflect.Descriptor instead.
func (*AbortInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{17}
}

func (x *AbortInfo) GetCause() AbortInfo_Cause {
	if x != nil {
		return x.Cause
	}
	return AbortInfo_CAUSE_UNSPECIFIED
}

func (x *AbortInfo) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

func (x *AbortInfo) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *AbortInfo) GetProjectsMissingPermission() []string {
	if x != nil {
		return x.ProjectsMissingPermission
	}
	return nil
}

// Details of the final state "drop" and associated resource.
type DropInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cause that the packet is dropped.
	Cause DropInfo_Cause `protobuf:"varint,1,opt,name=cause,proto3,enum=google.cloud.networkmanagement.v1.DropInfo_Cause" json:"cause,omitempty"`
	// URI of the resource that caused the drop.
	ResourceUri string `protobuf:"bytes,2,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	// Source IP address of the dropped packet (if relevant).
	SourceIp string `protobuf:"bytes,3,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// Destination IP address of the dropped packet (if relevant).
	DestinationIp string `protobuf:"bytes,4,opt,name=destination_ip,json=destinationIp,proto3" json:"destination_ip,omitempty"`
	// Region of the dropped packet (if relevant).
	Region string `protobuf:"bytes,5,opt,name=region,proto3" json:"region,omitempty"`
	// Geolocation (region code) of the source IP address (if relevant).
	SourceGeolocationCode string `protobuf:"bytes,6,opt,name=source_geolocation_code,json=sourceGeolocationCode,proto3" json:"source_geolocation_code,omitempty"`
	// Geolocation (region code) of the destination IP address (if relevant).
	DestinationGeolocationCode string `protobuf:"bytes,7,opt,name=destination_geolocation_code,json=destinationGeolocationCode,proto3" json:"destination_geolocation_code,omitempty"`
}

func (x *DropInfo) Reset() {
	*x = DropInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DropInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DropInfo) ProtoMessage() {}

func (x *DropInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DropInfo.ProtoReflect.Descriptor instead.
func (*DropInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{18}
}

func (x *DropInfo) GetCause() DropInfo_Cause {
	if x != nil {
		return x.Cause
	}
	return DropInfo_CAUSE_UNSPECIFIED
}

func (x *DropInfo) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

func (x *DropInfo) GetSourceIp() string {
	if x != nil {
		return x.SourceIp
	}
	return ""
}

func (x *DropInfo) GetDestinationIp() string {
	if x != nil {
		return x.DestinationIp
	}
	return ""
}

func (x *DropInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *DropInfo) GetSourceGeolocationCode() string {
	if x != nil {
		return x.SourceGeolocationCode
	}
	return ""
}

func (x *DropInfo) GetDestinationGeolocationCode() string {
	if x != nil {
		return x.DestinationGeolocationCode
	}
	return ""
}

// For display only. Metadata associated with a Google Kubernetes Engine (GKE)
// cluster master.
type GKEMasterInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI of a GKE cluster.
	ClusterUri string `protobuf:"bytes,2,opt,name=cluster_uri,json=clusterUri,proto3" json:"cluster_uri,omitempty"`
	// URI of a GKE cluster network.
	ClusterNetworkUri string `protobuf:"bytes,4,opt,name=cluster_network_uri,json=clusterNetworkUri,proto3" json:"cluster_network_uri,omitempty"`
	// Internal IP address of a GKE cluster control plane.
	InternalIp string `protobuf:"bytes,5,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// External IP address of a GKE cluster control plane.
	ExternalIp string `protobuf:"bytes,6,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
	// DNS endpoint of a GKE cluster control plane.
	DnsEndpoint string `protobuf:"bytes,7,opt,name=dns_endpoint,json=dnsEndpoint,proto3" json:"dns_endpoint,omitempty"`
}

func (x *GKEMasterInfo) Reset() {
	*x = GKEMasterInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GKEMasterInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GKEMasterInfo) ProtoMessage() {}

func (x *GKEMasterInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GKEMasterInfo.ProtoReflect.Descriptor instead.
func (*GKEMasterInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{19}
}

func (x *GKEMasterInfo) GetClusterUri() string {
	if x != nil {
		return x.ClusterUri
	}
	return ""
}

func (x *GKEMasterInfo) GetClusterNetworkUri() string {
	if x != nil {
		return x.ClusterNetworkUri
	}
	return ""
}

func (x *GKEMasterInfo) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *GKEMasterInfo) GetExternalIp() string {
	if x != nil {
		return x.ExternalIp
	}
	return ""
}

func (x *GKEMasterInfo) GetDnsEndpoint() string {
	if x != nil {
		return x.DnsEndpoint
	}
	return ""
}

// For display only. Metadata associated with a Cloud SQL instance.
type CloudSQLInstanceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Cloud SQL instance.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Cloud SQL instance.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI of a Cloud SQL instance network or empty string if the instance does
	// not have one.
	NetworkUri string `protobuf:"bytes,4,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Internal IP address of a Cloud SQL instance.
	InternalIp string `protobuf:"bytes,5,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// External IP address of a Cloud SQL instance.
	ExternalIp string `protobuf:"bytes,6,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
	// Region in which the Cloud SQL instance is running.
	Region string `protobuf:"bytes,7,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *CloudSQLInstanceInfo) Reset() {
	*x = CloudSQLInstanceInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudSQLInstanceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudSQLInstanceInfo) ProtoMessage() {}

func (x *CloudSQLInstanceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudSQLInstanceInfo.ProtoReflect.Descriptor instead.
func (*CloudSQLInstanceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{20}
}

func (x *CloudSQLInstanceInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CloudSQLInstanceInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *CloudSQLInstanceInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *CloudSQLInstanceInfo) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *CloudSQLInstanceInfo) GetExternalIp() string {
	if x != nil {
		return x.ExternalIp
	}
	return ""
}

func (x *CloudSQLInstanceInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// For display only. Metadata associated with a Cloud Redis Instance.
type RedisInstanceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Cloud Redis Instance.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Cloud Redis Instance.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI of a Cloud Redis Instance network.
	NetworkUri string `protobuf:"bytes,3,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Primary endpoint IP address of a Cloud Redis Instance.
	PrimaryEndpointIp string `protobuf:"bytes,4,opt,name=primary_endpoint_ip,json=primaryEndpointIp,proto3" json:"primary_endpoint_ip,omitempty"`
	// Read endpoint IP address of a Cloud Redis Instance (if applicable).
	ReadEndpointIp string `protobuf:"bytes,5,opt,name=read_endpoint_ip,json=readEndpointIp,proto3" json:"read_endpoint_ip,omitempty"`
	// Region in which the Cloud Redis Instance is defined.
	Region string `protobuf:"bytes,6,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *RedisInstanceInfo) Reset() {
	*x = RedisInstanceInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisInstanceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisInstanceInfo) ProtoMessage() {}

func (x *RedisInstanceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisInstanceInfo.ProtoReflect.Descriptor instead.
func (*RedisInstanceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{21}
}

func (x *RedisInstanceInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *RedisInstanceInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *RedisInstanceInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *RedisInstanceInfo) GetPrimaryEndpointIp() string {
	if x != nil {
		return x.PrimaryEndpointIp
	}
	return ""
}

func (x *RedisInstanceInfo) GetReadEndpointIp() string {
	if x != nil {
		return x.ReadEndpointIp
	}
	return ""
}

func (x *RedisInstanceInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// For display only. Metadata associated with a Redis Cluster.
type RedisClusterInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Redis Cluster.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Redis Cluster in format
	// "projects/{project_id}/locations/{location}/clusters/{cluster_id}"
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI of the network containing the Redis Cluster endpoints in format
	// "projects/{project_id}/global/networks/{network_id}".
	NetworkUri string `protobuf:"bytes,3,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Discovery endpoint IP address of a Redis Cluster.
	DiscoveryEndpointIpAddress string `protobuf:"bytes,4,opt,name=discovery_endpoint_ip_address,json=discoveryEndpointIpAddress,proto3" json:"discovery_endpoint_ip_address,omitempty"`
	// Secondary endpoint IP address of a Redis Cluster.
	SecondaryEndpointIpAddress string `protobuf:"bytes,5,opt,name=secondary_endpoint_ip_address,json=secondaryEndpointIpAddress,proto3" json:"secondary_endpoint_ip_address,omitempty"`
	// Name of the region in which the Redis Cluster is defined. For example,
	// "us-central1".
	Location string `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *RedisClusterInfo) Reset() {
	*x = RedisClusterInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RedisClusterInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisClusterInfo) ProtoMessage() {}

func (x *RedisClusterInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisClusterInfo.ProtoReflect.Descriptor instead.
func (*RedisClusterInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{22}
}

func (x *RedisClusterInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *RedisClusterInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *RedisClusterInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *RedisClusterInfo) GetDiscoveryEndpointIpAddress() string {
	if x != nil {
		return x.DiscoveryEndpointIpAddress
	}
	return ""
}

func (x *RedisClusterInfo) GetSecondaryEndpointIpAddress() string {
	if x != nil {
		return x.SecondaryEndpointIpAddress
	}
	return ""
}

func (x *RedisClusterInfo) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// For display only. Metadata associated with a Cloud Function.
type CloudFunctionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Cloud Function.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Cloud Function.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Location in which the Cloud Function is deployed.
	Location string `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
	// Latest successfully deployed version id of the Cloud Function.
	VersionId int64 `protobuf:"varint,4,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
}

func (x *CloudFunctionInfo) Reset() {
	*x = CloudFunctionInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudFunctionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudFunctionInfo) ProtoMessage() {}

func (x *CloudFunctionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudFunctionInfo.ProtoReflect.Descriptor instead.
func (*CloudFunctionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{23}
}

func (x *CloudFunctionInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CloudFunctionInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *CloudFunctionInfo) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *CloudFunctionInfo) GetVersionId() int64 {
	if x != nil {
		return x.VersionId
	}
	return 0
}

// For display only. Metadata associated with a Cloud Run revision.
type CloudRunRevisionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Cloud Run revision.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Cloud Run revision.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Location in which this revision is deployed.
	Location string `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
	// URI of Cloud Run service this revision belongs to.
	ServiceUri string `protobuf:"bytes,5,opt,name=service_uri,json=serviceUri,proto3" json:"service_uri,omitempty"`
}

func (x *CloudRunRevisionInfo) Reset() {
	*x = CloudRunRevisionInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudRunRevisionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudRunRevisionInfo) ProtoMessage() {}

func (x *CloudRunRevisionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudRunRevisionInfo.ProtoReflect.Descriptor instead.
func (*CloudRunRevisionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{24}
}

func (x *CloudRunRevisionInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CloudRunRevisionInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *CloudRunRevisionInfo) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *CloudRunRevisionInfo) GetServiceUri() string {
	if x != nil {
		return x.ServiceUri
	}
	return ""
}

// For display only. Metadata associated with an App Engine version.
type AppEngineVersionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of an App Engine version.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of an App Engine version.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Runtime of the App Engine version.
	Runtime string `protobuf:"bytes,3,opt,name=runtime,proto3" json:"runtime,omitempty"`
	// App Engine execution environment for a version.
	Environment string `protobuf:"bytes,4,opt,name=environment,proto3" json:"environment,omitempty"`
}

func (x *AppEngineVersionInfo) Reset() {
	*x = AppEngineVersionInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppEngineVersionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppEngineVersionInfo) ProtoMessage() {}

func (x *AppEngineVersionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppEngineVersionInfo.ProtoReflect.Descriptor instead.
func (*AppEngineVersionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{25}
}

func (x *AppEngineVersionInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AppEngineVersionInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *AppEngineVersionInfo) GetRuntime() string {
	if x != nil {
		return x.Runtime
	}
	return ""
}

func (x *AppEngineVersionInfo) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

// For display only. Metadata associated with a VPC connector.
type VpcConnectorInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a VPC connector.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a VPC connector.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Location in which the VPC connector is deployed.
	Location string `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *VpcConnectorInfo) Reset() {
	*x = VpcConnectorInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VpcConnectorInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpcConnectorInfo) ProtoMessage() {}

func (x *VpcConnectorInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpcConnectorInfo.ProtoReflect.Descriptor instead.
func (*VpcConnectorInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{26}
}

func (x *VpcConnectorInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VpcConnectorInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *VpcConnectorInfo) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// For display only. Metadata associated with a serverless direct VPC egress
// connection.
type DirectVpcEgressConnectionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI of direct access network.
	NetworkUri string `protobuf:"bytes,1,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// URI of direct access subnetwork.
	SubnetworkUri string `protobuf:"bytes,2,opt,name=subnetwork_uri,json=subnetworkUri,proto3" json:"subnetwork_uri,omitempty"`
	// Selected IP range.
	SelectedIpRange string `protobuf:"bytes,3,opt,name=selected_ip_range,json=selectedIpRange,proto3" json:"selected_ip_range,omitempty"`
	// Selected starting IP address, from the selected IP range.
	SelectedIpAddress string `protobuf:"bytes,4,opt,name=selected_ip_address,json=selectedIpAddress,proto3" json:"selected_ip_address,omitempty"`
	// Region in which the Direct VPC egress is deployed.
	Region string `protobuf:"bytes,5,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *DirectVpcEgressConnectionInfo) Reset() {
	*x = DirectVpcEgressConnectionInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DirectVpcEgressConnectionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectVpcEgressConnectionInfo) ProtoMessage() {}

func (x *DirectVpcEgressConnectionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectVpcEgressConnectionInfo.ProtoReflect.Descriptor instead.
func (*DirectVpcEgressConnectionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{27}
}

func (x *DirectVpcEgressConnectionInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *DirectVpcEgressConnectionInfo) GetSubnetworkUri() string {
	if x != nil {
		return x.SubnetworkUri
	}
	return ""
}

func (x *DirectVpcEgressConnectionInfo) GetSelectedIpRange() string {
	if x != nil {
		return x.SelectedIpRange
	}
	return ""
}

func (x *DirectVpcEgressConnectionInfo) GetSelectedIpAddress() string {
	if x != nil {
		return x.SelectedIpAddress
	}
	return ""
}

func (x *DirectVpcEgressConnectionInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// For display only. Metadata associated with a serverless public connection.
type ServerlessExternalConnectionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selected starting IP address, from the Google dynamic address pool.
	SelectedIpAddress string `protobuf:"bytes,1,opt,name=selected_ip_address,json=selectedIpAddress,proto3" json:"selected_ip_address,omitempty"`
}

func (x *ServerlessExternalConnectionInfo) Reset() {
	*x = ServerlessExternalConnectionInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerlessExternalConnectionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerlessExternalConnectionInfo) ProtoMessage() {}

func (x *ServerlessExternalConnectionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerlessExternalConnectionInfo.ProtoReflect.Descriptor instead.
func (*ServerlessExternalConnectionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{28}
}

func (x *ServerlessExternalConnectionInfo) GetSelectedIpAddress() string {
	if x != nil {
		return x.SelectedIpAddress
	}
	return ""
}

// For display only. Metadata associated with NAT.
type NatInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of NAT.
	Type NatInfo_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.networkmanagement.v1.NatInfo_Type" json:"type,omitempty"`
	// IP protocol in string format, for example: "TCP", "UDP", "ICMP".
	Protocol string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// URI of the network where NAT translation takes place.
	NetworkUri string `protobuf:"bytes,3,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Source IP address before NAT translation.
	OldSourceIp string `protobuf:"bytes,4,opt,name=old_source_ip,json=oldSourceIp,proto3" json:"old_source_ip,omitempty"`
	// Source IP address after NAT translation.
	NewSourceIp string `protobuf:"bytes,5,opt,name=new_source_ip,json=newSourceIp,proto3" json:"new_source_ip,omitempty"`
	// Destination IP address before NAT translation.
	OldDestinationIp string `protobuf:"bytes,6,opt,name=old_destination_ip,json=oldDestinationIp,proto3" json:"old_destination_ip,omitempty"`
	// Destination IP address after NAT translation.
	NewDestinationIp string `protobuf:"bytes,7,opt,name=new_destination_ip,json=newDestinationIp,proto3" json:"new_destination_ip,omitempty"`
	// Source port before NAT translation. Only valid when protocol is TCP or UDP.
	OldSourcePort int32 `protobuf:"varint,8,opt,name=old_source_port,json=oldSourcePort,proto3" json:"old_source_port,omitempty"`
	// Source port after NAT translation. Only valid when protocol is TCP or UDP.
	NewSourcePort int32 `protobuf:"varint,9,opt,name=new_source_port,json=newSourcePort,proto3" json:"new_source_port,omitempty"`
	// Destination port before NAT translation. Only valid when protocol is TCP or
	// UDP.
	OldDestinationPort int32 `protobuf:"varint,10,opt,name=old_destination_port,json=oldDestinationPort,proto3" json:"old_destination_port,omitempty"`
	// Destination port after NAT translation. Only valid when protocol is TCP or
	// UDP.
	NewDestinationPort int32 `protobuf:"varint,11,opt,name=new_destination_port,json=newDestinationPort,proto3" json:"new_destination_port,omitempty"`
	// Uri of the Cloud Router. Only valid when type is CLOUD_NAT.
	RouterUri string `protobuf:"bytes,12,opt,name=router_uri,json=routerUri,proto3" json:"router_uri,omitempty"`
	// The name of Cloud NAT Gateway. Only valid when type is CLOUD_NAT.
	NatGatewayName string `protobuf:"bytes,13,opt,name=nat_gateway_name,json=natGatewayName,proto3" json:"nat_gateway_name,omitempty"`
}

func (x *NatInfo) Reset() {
	*x = NatInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NatInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NatInfo) ProtoMessage() {}

func (x *NatInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NatInfo.ProtoReflect.Descriptor instead.
func (*NatInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{29}
}

func (x *NatInfo) GetType() NatInfo_Type {
	if x != nil {
		return x.Type
	}
	return NatInfo_TYPE_UNSPECIFIED
}

func (x *NatInfo) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *NatInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *NatInfo) GetOldSourceIp() string {
	if x != nil {
		return x.OldSourceIp
	}
	return ""
}

func (x *NatInfo) GetNewSourceIp() string {
	if x != nil {
		return x.NewSourceIp
	}
	return ""
}

func (x *NatInfo) GetOldDestinationIp() string {
	if x != nil {
		return x.OldDestinationIp
	}
	return ""
}

func (x *NatInfo) GetNewDestinationIp() string {
	if x != nil {
		return x.NewDestinationIp
	}
	return ""
}

func (x *NatInfo) GetOldSourcePort() int32 {
	if x != nil {
		return x.OldSourcePort
	}
	return 0
}

func (x *NatInfo) GetNewSourcePort() int32 {
	if x != nil {
		return x.NewSourcePort
	}
	return 0
}

func (x *NatInfo) GetOldDestinationPort() int32 {
	if x != nil {
		return x.OldDestinationPort
	}
	return 0
}

func (x *NatInfo) GetNewDestinationPort() int32 {
	if x != nil {
		return x.NewDestinationPort
	}
	return 0
}

func (x *NatInfo) GetRouterUri() string {
	if x != nil {
		return x.RouterUri
	}
	return ""
}

func (x *NatInfo) GetNatGatewayName() string {
	if x != nil {
		return x.NatGatewayName
	}
	return ""
}

// For display only. Metadata associated with ProxyConnection.
type ProxyConnectionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IP protocol in string format, for example: "TCP", "UDP", "ICMP".
	Protocol string `protobuf:"bytes,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Source IP address of an original connection.
	OldSourceIp string `protobuf:"bytes,2,opt,name=old_source_ip,json=oldSourceIp,proto3" json:"old_source_ip,omitempty"`
	// Source IP address of a new connection.
	NewSourceIp string `protobuf:"bytes,3,opt,name=new_source_ip,json=newSourceIp,proto3" json:"new_source_ip,omitempty"`
	// Destination IP address of an original connection
	OldDestinationIp string `protobuf:"bytes,4,opt,name=old_destination_ip,json=oldDestinationIp,proto3" json:"old_destination_ip,omitempty"`
	// Destination IP address of a new connection.
	NewDestinationIp string `protobuf:"bytes,5,opt,name=new_destination_ip,json=newDestinationIp,proto3" json:"new_destination_ip,omitempty"`
	// Source port of an original connection. Only valid when protocol is TCP or
	// UDP.
	OldSourcePort int32 `protobuf:"varint,6,opt,name=old_source_port,json=oldSourcePort,proto3" json:"old_source_port,omitempty"`
	// Source port of a new connection. Only valid when protocol is TCP or UDP.
	NewSourcePort int32 `protobuf:"varint,7,opt,name=new_source_port,json=newSourcePort,proto3" json:"new_source_port,omitempty"`
	// Destination port of an original connection. Only valid when protocol is TCP
	// or UDP.
	OldDestinationPort int32 `protobuf:"varint,8,opt,name=old_destination_port,json=oldDestinationPort,proto3" json:"old_destination_port,omitempty"`
	// Destination port of a new connection. Only valid when protocol is TCP or
	// UDP.
	NewDestinationPort int32 `protobuf:"varint,9,opt,name=new_destination_port,json=newDestinationPort,proto3" json:"new_destination_port,omitempty"`
	// Uri of proxy subnet.
	SubnetUri string `protobuf:"bytes,10,opt,name=subnet_uri,json=subnetUri,proto3" json:"subnet_uri,omitempty"`
	// URI of the network where connection is proxied.
	NetworkUri string `protobuf:"bytes,11,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
}

func (x *ProxyConnectionInfo) Reset() {
	*x = ProxyConnectionInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConnectionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConnectionInfo) ProtoMessage() {}

func (x *ProxyConnectionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConnectionInfo.ProtoReflect.Descriptor instead.
func (*ProxyConnectionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{30}
}

func (x *ProxyConnectionInfo) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *ProxyConnectionInfo) GetOldSourceIp() string {
	if x != nil {
		return x.OldSourceIp
	}
	return ""
}

func (x *ProxyConnectionInfo) GetNewSourceIp() string {
	if x != nil {
		return x.NewSourceIp
	}
	return ""
}

func (x *ProxyConnectionInfo) GetOldDestinationIp() string {
	if x != nil {
		return x.OldDestinationIp
	}
	return ""
}

func (x *ProxyConnectionInfo) GetNewDestinationIp() string {
	if x != nil {
		return x.NewDestinationIp
	}
	return ""
}

func (x *ProxyConnectionInfo) GetOldSourcePort() int32 {
	if x != nil {
		return x.OldSourcePort
	}
	return 0
}

func (x *ProxyConnectionInfo) GetNewSourcePort() int32 {
	if x != nil {
		return x.NewSourcePort
	}
	return 0
}

func (x *ProxyConnectionInfo) GetOldDestinationPort() int32 {
	if x != nil {
		return x.OldDestinationPort
	}
	return 0
}

func (x *ProxyConnectionInfo) GetNewDestinationPort() int32 {
	if x != nil {
		return x.NewDestinationPort
	}
	return 0
}

func (x *ProxyConnectionInfo) GetSubnetUri() string {
	if x != nil {
		return x.SubnetUri
	}
	return ""
}

func (x *ProxyConnectionInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

// For display only. Metadata associated with the load balancer backend.
type LoadBalancerBackendInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display name of the backend. For example, it might be an instance name for
	// the instance group backends, or an IP address and port for zonal network
	// endpoint group backends.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// URI of the backend instance (if applicable). Populated for instance group
	// backends, and zonal NEG backends.
	InstanceUri string `protobuf:"bytes,2,opt,name=instance_uri,json=instanceUri,proto3" json:"instance_uri,omitempty"`
	// URI of the backend service this backend belongs to (if applicable).
	BackendServiceUri string `protobuf:"bytes,3,opt,name=backend_service_uri,json=backendServiceUri,proto3" json:"backend_service_uri,omitempty"`
	// URI of the instance group this backend belongs to (if applicable).
	InstanceGroupUri string `protobuf:"bytes,4,opt,name=instance_group_uri,json=instanceGroupUri,proto3" json:"instance_group_uri,omitempty"`
	// URI of the network endpoint group this backend belongs to (if applicable).
	NetworkEndpointGroupUri string `protobuf:"bytes,5,opt,name=network_endpoint_group_uri,json=networkEndpointGroupUri,proto3" json:"network_endpoint_group_uri,omitempty"`
	// URI of the backend bucket this backend targets (if applicable).
	BackendBucketUri string `protobuf:"bytes,8,opt,name=backend_bucket_uri,json=backendBucketUri,proto3" json:"backend_bucket_uri,omitempty"`
	// URI of the PSC service attachment this PSC NEG backend targets (if
	// applicable).
	PscServiceAttachmentUri string `protobuf:"bytes,9,opt,name=psc_service_attachment_uri,json=pscServiceAttachmentUri,proto3" json:"psc_service_attachment_uri,omitempty"`
	// PSC Google API target this PSC NEG backend targets (if applicable).
	PscGoogleApiTarget string `protobuf:"bytes,10,opt,name=psc_google_api_target,json=pscGoogleApiTarget,proto3" json:"psc_google_api_target,omitempty"`
	// URI of the health check attached to this backend (if applicable).
	HealthCheckUri string `protobuf:"bytes,6,opt,name=health_check_uri,json=healthCheckUri,proto3" json:"health_check_uri,omitempty"`
	// Output only. Health check firewalls configuration state for the backend.
	// This is a result of the static firewall analysis (verifying that health
	// check traffic from required IP ranges to the backend is allowed or not).
	// The backend might still be unhealthy even if these firewalls are
	// configured. Please refer to the documentation for more information:
	// https://cloud.google.com/load-balancing/docs/firewall-rules
	HealthCheckFirewallsConfigState LoadBalancerBackendInfo_HealthCheckFirewallsConfigState `protobuf:"varint,7,opt,name=health_check_firewalls_config_state,json=healthCheckFirewallsConfigState,proto3,enum=google.cloud.networkmanagement.v1.LoadBalancerBackendInfo_HealthCheckFirewallsConfigState" json:"health_check_firewalls_config_state,omitempty"`
}

func (x *LoadBalancerBackendInfo) Reset() {
	*x = LoadBalancerBackendInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadBalancerBackendInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerBackendInfo) ProtoMessage() {}

func (x *LoadBalancerBackendInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerBackendInfo.ProtoReflect.Descriptor instead.
func (*LoadBalancerBackendInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{31}
}

func (x *LoadBalancerBackendInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LoadBalancerBackendInfo) GetInstanceUri() string {
	if x != nil {
		return x.InstanceUri
	}
	return ""
}

func (x *LoadBalancerBackendInfo) GetBackendServiceUri() string {
	if x != nil {
		return x.BackendServiceUri
	}
	return ""
}

func (x *LoadBalancerBackendInfo) GetInstanceGroupUri() string {
	if x != nil {
		return x.InstanceGroupUri
	}
	return ""
}

func (x *LoadBalancerBackendInfo) GetNetworkEndpointGroupUri() string {
	if x != nil {
		return x.NetworkEndpointGroupUri
	}
	return ""
}

func (x *LoadBalancerBackendInfo) GetBackendBucketUri() string {
	if x != nil {
		return x.BackendBucketUri
	}
	return ""
}

func (x *LoadBalancerBackendInfo) GetPscServiceAttachmentUri() string {
	if x != nil {
		return x.PscServiceAttachmentUri
	}
	return ""
}

func (x *LoadBalancerBackendInfo) GetPscGoogleApiTarget() string {
	if x != nil {
		return x.PscGoogleApiTarget
	}
	return ""
}

func (x *LoadBalancerBackendInfo) GetHealthCheckUri() string {
	if x != nil {
		return x.HealthCheckUri
	}
	return ""
}

func (x *LoadBalancerBackendInfo) GetHealthCheckFirewallsConfigState() LoadBalancerBackendInfo_HealthCheckFirewallsConfigState {
	if x != nil {
		return x.HealthCheckFirewallsConfigState
	}
	return LoadBalancerBackendInfo_HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED
}

// For display only. Metadata associated with Storage Bucket.
type StorageBucketInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Storage Bucket name.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
}

func (x *StorageBucketInfo) Reset() {
	*x = StorageBucketInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageBucketInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageBucketInfo) ProtoMessage() {}

func (x *StorageBucketInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageBucketInfo.ProtoReflect.Descriptor instead.
func (*StorageBucketInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{32}
}

func (x *StorageBucketInfo) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

// For display only. Metadata associated with the serverless network endpoint
// group backend.
type ServerlessNegInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI of the serverless network endpoint group.
	NegUri string `protobuf:"bytes,1,opt,name=neg_uri,json=negUri,proto3" json:"neg_uri,omitempty"`
}

func (x *ServerlessNegInfo) Reset() {
	*x = ServerlessNegInfo{}
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerlessNegInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerlessNegInfo) ProtoMessage() {}

func (x *ServerlessNegInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerlessNegInfo.ProtoReflect.Descriptor instead.
func (*ServerlessNegInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{33}
}

func (x *ServerlessNegInfo) GetNegUri() string {
	if x != nil {
		return x.NegUri
	}
	return ""
}

var File_google_cloud_networkmanagement_v1_trace_proto protoreflect.FileDescriptor

var file_google_cloud_networkmanagement_v1_trace_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xc6, 0x01, 0x0a, 0x05, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x54, 0x0a, 0x0d, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x3d, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x12,
	0x28, 0x0a, 0x10, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x54, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x22, 0xa2, 0x20, 0x0a, 0x04, 0x53, 0x74,
	0x65, 0x70, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x61, 0x75,
	0x73, 0x65, 0x73, 0x5f, 0x64, 0x72, 0x6f, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a,
	0x63, 0x61, 0x75, 0x73, 0x65, 0x73, 0x44, 0x72, 0x6f, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x4d, 0x0a, 0x08, 0x66, 0x69, 0x72, 0x65,
	0x77, 0x61, 0x6c, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x08, 0x66,
	0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x12, 0x44, 0x0a, 0x05, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x05, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x4d, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x48, 0x00, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x0e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x18,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x60, 0x0a, 0x0f, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0e, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x5a, 0x0a,
	0x0d, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64, 0x5f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x24,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x53,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0c, 0x68, 0x79, 0x62,
	0x72, 0x69, 0x64, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x54, 0x0a, 0x0b, 0x76, 0x70, 0x6e,
	0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x70, 0x6e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x48, 0x00, 0x52, 0x0a, 0x76, 0x70, 0x6e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12,
	0x51, 0x0a, 0x0a, 0x76, 0x70, 0x6e, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x09, 0x76, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e,
	0x65, 0x6c, 0x12, 0x78, 0x0a, 0x17, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x23, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x48, 0x00, 0x52, 0x16, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0d,
	0x76, 0x70, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x15, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0c, 0x76, 0x70, 0x63, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x83, 0x01, 0x0a, 0x1c, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x5f, 0x76, 0x70, 0x63, 0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x56, 0x70, 0x63, 0x45, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x48, 0x00, 0x52, 0x19, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x56, 0x70, 0x63, 0x45, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8b,
	0x01, 0x0a, 0x1e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x1c,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x07,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52,
	0x07, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x12, 0x4a, 0x0a, 0x07, 0x66, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x07, 0x66, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x12, 0x44, 0x0a, 0x05, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x48, 0x00, 0x52, 0x05, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x64, 0x72,
	0x6f, 0x70, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x72, 0x6f,
	0x70, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x04, 0x64, 0x72, 0x6f, 0x70, 0x12, 0x5e, 0x0a,
	0x0d, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52,
	0x0c, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x12, 0x4a, 0x0a,
	0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00,
	0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x51, 0x0a, 0x0a, 0x67, 0x6b, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x4b, 0x45, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x48,
	0x00, 0x52, 0x09, 0x67, 0x6b, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x12, 0x67, 0x0a, 0x12,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x53, 0x51, 0x4c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x48, 0x00, 0x52, 0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x0e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x64, 0x69, 0x73, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x5a, 0x0a, 0x0d, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x64, 0x69, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f,
	0x48, 0x00, 0x52, 0x0c, 0x72, 0x65, 0x64, 0x69, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x5d, 0x0a, 0x0e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00,
	0x52, 0x0d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x67, 0x0a, 0x12, 0x61, 0x70, 0x70, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x10, 0x61, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x12, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x17,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75,
	0x6e, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52,
	0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x3e, 0x0a, 0x03, 0x6e, 0x61, 0x74, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x61, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x03, 0x6e, 0x61,
	0x74, 0x12, 0x63, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x79, 0x0a, 0x1a, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x63, 0x6b, 0x65,
	0x6e, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x17, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x5d, 0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x48,
	0x00, 0x52, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x5d, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x6e,
	0x65, 0x67, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x4e, 0x65, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00,
	0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x4e, 0x65, 0x67, 0x22,
	0xaf, 0x08, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x17, 0x0a, 0x13, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x49,
	0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x45, 0x54,
	0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d,
	0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10,
	0x1b, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f,
	0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10,
	0x03, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f,
	0x47, 0x4b, 0x45, 0x5f, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x10, 0x15, 0x12, 0x21, 0x0a, 0x1d,
	0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44,
	0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x16, 0x12,
	0x1d, 0x0a, 0x19, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x52, 0x45,
	0x44, 0x49, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x20, 0x12, 0x1c,
	0x0a, 0x18, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x52, 0x45, 0x44,
	0x49, 0x53, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x10, 0x21, 0x12, 0x1d, 0x0a, 0x19,
	0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44,
	0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x17, 0x12, 0x21, 0x0a, 0x1d, 0x53,
	0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x41, 0x50, 0x50, 0x5f, 0x45, 0x4e,
	0x47, 0x49, 0x4e, 0x45, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x19, 0x12, 0x21,
	0x0a, 0x1d, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x43, 0x4c, 0x4f,
	0x55, 0x44, 0x5f, 0x52, 0x55, 0x4e, 0x5f, 0x52, 0x45, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x10,
	0x1a, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f,
	0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x1d,
	0x12, 0x24, 0x0a, 0x20, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x50,
	0x53, 0x43, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x52,
	0x56, 0x49, 0x43, 0x45, 0x10, 0x1e, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f,
	0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x4c, 0x45, 0x53, 0x53, 0x5f,
	0x4e, 0x45, 0x47, 0x10, 0x1f, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x5f, 0x49,
	0x4e, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f,
	0x52, 0x55, 0x4c, 0x45, 0x10, 0x04, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x5f,
	0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f,
	0x52, 0x55, 0x4c, 0x45, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x5f,
	0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0x06, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x50, 0x50, 0x4c, 0x59,
	0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x55, 0x4c, 0x45,
	0x10, 0x07, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x4e, 0x41, 0x4c, 0x59, 0x5a, 0x45, 0x5f, 0x4c, 0x4f,
	0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x42, 0x41, 0x43, 0x4b,
	0x45, 0x4e, 0x44, 0x10, 0x1c, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x50, 0x4f, 0x4f, 0x46, 0x49, 0x4e,
	0x47, 0x5f, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x08, 0x12, 0x16, 0x0a, 0x12,
	0x41, 0x52, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x54, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e,
	0x43, 0x45, 0x10, 0x09, 0x12, 0x28, 0x0a, 0x20, 0x41, 0x52, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x41,
	0x54, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f,
	0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x10, 0x0a, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x28,
	0x0a, 0x20, 0x41, 0x52, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x54, 0x5f, 0x45, 0x58, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43,
	0x45, 0x52, 0x10, 0x0b, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x52, 0x52, 0x49,
	0x56, 0x45, 0x5f, 0x41, 0x54, 0x5f, 0x48, 0x59, 0x42, 0x52, 0x49, 0x44, 0x5f, 0x53, 0x55, 0x42,
	0x4e, 0x45, 0x54, 0x10, 0x26, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x52, 0x52, 0x49, 0x56, 0x45, 0x5f,
	0x41, 0x54, 0x5f, 0x56, 0x50, 0x4e, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x10, 0x0c,
	0x12, 0x18, 0x0a, 0x14, 0x41, 0x52, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x54, 0x5f, 0x56, 0x50,
	0x4e, 0x5f, 0x54, 0x55, 0x4e, 0x4e, 0x45, 0x4c, 0x10, 0x0d, 0x12, 0x25, 0x0a, 0x21, 0x41, 0x52,
	0x52, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x54, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x43, 0x4f, 0x4e,
	0x4e, 0x45, 0x43, 0x54, 0x5f, 0x41, 0x54, 0x54, 0x41, 0x43, 0x48, 0x4d, 0x45, 0x4e, 0x54, 0x10,
	0x25, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x52, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x54, 0x5f, 0x56,
	0x50, 0x43, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x10, 0x18, 0x12, 0x20,
	0x0a, 0x1c, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x56, 0x50, 0x43, 0x5f, 0x45, 0x47, 0x52,
	0x45, 0x53, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x23,
	0x12, 0x22, 0x0a, 0x1e, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x45,
	0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x24, 0x12, 0x07, 0x0a, 0x03, 0x4e, 0x41, 0x54, 0x10, 0x0e, 0x12, 0x14, 0x0a,
	0x10, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x0f, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x10, 0x10,
	0x12, 0x08, 0x0a, 0x04, 0x44, 0x52, 0x4f, 0x50, 0x10, 0x11, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4f,
	0x52, 0x57, 0x41, 0x52, 0x44, 0x10, 0x12, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x42, 0x4f, 0x52, 0x54,
	0x10, 0x13, 0x12, 0x1d, 0x0a, 0x19, 0x56, 0x49, 0x45, 0x57, 0x45, 0x52, 0x5f, 0x50, 0x45, 0x52,
	0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x10,
	0x14, 0x42, 0x0b, 0x0a, 0x09, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0xff,
	0x03, 0x0a, 0x0c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x75, 0x72, 0x69, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
	0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x55, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f,
	0x69, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x49, 0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x5f, 0x69, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x1a, 0x70, 0x73, 0x63, 0x5f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x70, 0x73, 0x63, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x55,
	0x72, 0x69, 0x12, 0x1c, 0x0a, 0x07, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x12, 0x4e, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x22, 0x3e, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54,
	0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x22, 0xb2, 0x01, 0x0a, 0x0b, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x2c, 0x0a, 0x12, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64,
	0x5f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x55, 0x72, 0x69, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x69,
	0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x22, 0xf3, 0x07, 0x0a, 0x0c, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61,
	0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1c, 0x0a, 0x09, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a,
	0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x1f,
	0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x61, 0x67, 0x73, 0x12,
	0x36, 0x0a, 0x17, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x15, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x55, 0x72, 0x69, 0x12, 0x6e,
	0x0a, 0x12, 0x66, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x46, 0x69, 0x72, 0x65,
	0x77, 0x61, 0x6c, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10, 0x66, 0x69,
	0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x27,
	0x0a, 0x0f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x5b, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x22, 0xe1, 0x02, 0x0a, 0x10, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c,
	0x6c, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x46, 0x49, 0x52,
	0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x25, 0x0a,
	0x21, 0x48, 0x49, 0x45, 0x52, 0x41, 0x52, 0x43, 0x48, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x46, 0x49,
	0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x52, 0x55,
	0x4c, 0x45, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x56, 0x50, 0x43, 0x5f, 0x46, 0x49, 0x52, 0x45,
	0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x49,
	0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x5f, 0x56, 0x50, 0x43, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57,
	0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x2f, 0x0a, 0x2b, 0x53, 0x45,
	0x52, 0x56, 0x45, 0x52, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x56, 0x50, 0x43, 0x5f, 0x41, 0x43, 0x43,
	0x45, 0x53, 0x53, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x46, 0x49, 0x52, 0x45,
	0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x04, 0x12, 0x20, 0x0a, 0x1c, 0x4e,
	0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f,
	0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x05, 0x12, 0x29, 0x0a,
	0x25, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x41,
	0x4c, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43,
	0x59, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x06, 0x12, 0x24, 0x0a, 0x20, 0x55, 0x4e, 0x53, 0x55,
	0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c,
	0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x64, 0x12, 0x12,
	0x0a, 0x0e, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x10, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x4e, 0x41, 0x4c, 0x59, 0x53, 0x49, 0x53, 0x5f, 0x53,
	0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10, 0x66, 0x22, 0x51, 0x0a, 0x0a, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x53,
	0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x4d,
	0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x4c, 0x42, 0x10, 0x02, 0x22, 0xce, 0x0e, 0x0a, 0x09,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x55, 0x0a, 0x0a, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x5c, 0x0a, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0b, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5c,
	0x0a, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x0a, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72,
	0x69, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0d, 0x64, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1d, 0x0a,
	0x08, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x07, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x12, 0x1f, 0x0a, 0x0b,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x61, 0x67, 0x73, 0x12, 0x20,
	0x0a, 0x0c, 0x73, 0x72, 0x63, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x72, 0x63, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x28, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x73, 0x74,
	0x50, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x72,
	0x63, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x72, 0x63, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x18,
	0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73,
	0x12, 0x23, 0x0a, 0x0b, 0x6e, 0x63, 0x63, 0x5f, 0x68, 0x75, 0x62, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x6e, 0x63, 0x63, 0x48, 0x75, 0x62, 0x55,
	0x72, 0x69, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0d, 0x6e, 0x63, 0x63, 0x5f, 0x73, 0x70, 0x6f,
	0x6b, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0b,
	0x6e, 0x63, 0x63, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x55, 0x72, 0x69, 0x88, 0x01, 0x01, 0x12, 0x4f,
	0x0a, 0x22, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x1e, 0x61, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x55, 0x72, 0x69, 0x88, 0x01, 0x01, 0x12,
	0x49, 0x0a, 0x1d, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x5f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x48, 0x03, 0x52, 0x19, 0x61, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4e, 0x65, 0x78,
	0x74, 0x48, 0x6f, 0x70, 0x55, 0x72, 0x69, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x0c, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x55, 0x72, 0x69, 0x12, 0x2f, 0x0a, 0x14,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6e, 0x65, 0x78, 0x74,
	0x48, 0x6f, 0x70, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x32, 0x0a,
	0x15, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x55, 0x72,
	0x69, 0x12, 0x43, 0x0a, 0x1e, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1b, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x11, 0x6e, 0x63, 0x63, 0x5f, 0x68, 0x75,
	0x62, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x18, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x6e, 0x63, 0x63, 0x48, 0x75, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x55, 0x72,
	0x69, 0x22, 0xab, 0x01, 0x0a, 0x09, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1a, 0x0a, 0x16, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x55, 0x42, 0x4e, 0x45, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x41, 0x54, 0x49,
	0x43, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x10, 0x03,
	0x12, 0x12, 0x0a, 0x0e, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x55, 0x42, 0x4e,
	0x45, 0x54, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x49, 0x43, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x45, 0x45, 0x52,
	0x49, 0x4e, 0x47, 0x5f, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x10, 0x06, 0x12, 0x10, 0x0a,
	0x0c, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x44, 0x10, 0x07, 0x12,
	0x0e, 0x0a, 0x0a, 0x41, 0x44, 0x56, 0x45, 0x52, 0x54, 0x49, 0x53, 0x45, 0x44, 0x10, 0x65, 0x22,
	0xea, 0x02, 0x0a, 0x0b, 0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f,
	0x0a, 0x0b, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x49, 0x50, 0x10, 0x01, 0x12,
	0x15, 0x0a, 0x11, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4e, 0x43, 0x45, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48,
	0x4f, 0x50, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10,
	0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47,
	0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x49,
	0x4e, 0x54, 0x45, 0x52, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x10, 0x05, 0x12, 0x17, 0x0a,
	0x13, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x56, 0x50, 0x4e, 0x5f, 0x54, 0x55,
	0x4e, 0x4e, 0x45, 0x4c, 0x10, 0x06, 0x12, 0x18, 0x0a, 0x14, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48,
	0x4f, 0x50, 0x5f, 0x56, 0x50, 0x4e, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x10, 0x07,
	0x12, 0x1d, 0x0a, 0x19, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x4e, 0x45, 0x54, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x10, 0x08, 0x12,
	0x16, 0x0a, 0x12, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x42, 0x4c, 0x41, 0x43,
	0x4b, 0x48, 0x4f, 0x4c, 0x45, 0x10, 0x09, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x45, 0x58, 0x54, 0x5f,
	0x48, 0x4f, 0x50, 0x5f, 0x49, 0x4c, 0x42, 0x10, 0x0a, 0x12, 0x1d, 0x0a, 0x19, 0x4e, 0x45, 0x58,
	0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x52, 0x5f, 0x41, 0x50, 0x50,
	0x4c, 0x49, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x0b, 0x12, 0x14, 0x0a, 0x10, 0x4e, 0x45, 0x58, 0x54,
	0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x4e, 0x43, 0x43, 0x5f, 0x48, 0x55, 0x42, 0x10, 0x0c, 0x12, 0x1c,
	0x0a, 0x18, 0x53, 0x45, 0x43, 0x55, 0x52, 0x45, 0x5f, 0x57, 0x45, 0x42, 0x5f, 0x50, 0x52, 0x4f,
	0x58, 0x59, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x10, 0x0d, 0x22, 0x43, 0x0a, 0x0a,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x4f,
	0x55, 0x54, 0x45, 0x5f, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x45, 0x54, 0x57, 0x4f,
	0x52, 0x4b, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x43, 0x43, 0x5f, 0x48, 0x55, 0x42, 0x10,
	0x02, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x6e, 0x63, 0x63, 0x5f, 0x68, 0x75, 0x62, 0x5f, 0x75, 0x72,
	0x69, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6e, 0x63, 0x63, 0x5f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f,
	0x75, 0x72, 0x69, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x61,
	0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x5f, 0x75, 0x72, 0x69, 0x22, 0xf7, 0x02, 0x0a,
	0x11, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x70, 0x12,
	0x76, 0x0a, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xcc, 0x01, 0x0a, 0x11, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a,
	0x1f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x49, 0x41, 0x50, 0x10, 0x01, 0x12, 0x24, 0x0a, 0x20, 0x47,
	0x46, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x5f, 0x4f, 0x52, 0x5f, 0x48, 0x45, 0x41, 0x4c,
	0x54, 0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x52, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x44, 0x4e, 0x53, 0x10, 0x03,
	0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41, 0x50, 0x49, 0x10, 0x04,
	0x12, 0x12, 0x0a, 0x0e, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x50,
	0x53, 0x43, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41,
	0x50, 0x49, 0x5f, 0x56, 0x50, 0x43, 0x5f, 0x53, 0x43, 0x10, 0x06, 0x12, 0x19, 0x0a, 0x15, 0x53,
	0x45, 0x52, 0x56, 0x45, 0x52, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x56, 0x50, 0x43, 0x5f, 0x41, 0x43,
	0x43, 0x45, 0x53, 0x53, 0x10, 0x07, 0x22, 0xa3, 0x03, 0x0a, 0x12, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x72, 0x69, 0x12, 0x29, 0x0a, 0x10, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x2c, 0x0a,
	0x12, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x76,
	0x69, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x76, 0x69, 0x70, 0x12, 0x16, 0x0a,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x2c,
	0x0a, 0x12, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6c, 0x6f, 0x61, 0x64,
	0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x1a,
	0x70, 0x73, 0x63, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x17, 0x70, 0x73, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x31, 0x0a, 0x15, 0x70, 0x73, 0x63,
	0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x70, 0x73, 0x63, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x70, 0x69, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x87, 0x05, 0x0a,
	0x10, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x72, 0x0a, 0x12, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x10, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x10, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x0e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x55, 0x72, 0x69, 0x12, 0x52, 0x0a, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x08, 0x62,
	0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x73, 0x12, 0x62, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b,
	0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x62,
	0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x55, 0x72, 0x69, 0x22, 0x8f, 0x01, 0x0a,
	0x10, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x22, 0x0a, 0x1e, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43,
	0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41,
	0x4c, 0x5f, 0x54, 0x43, 0x50, 0x5f, 0x55, 0x44, 0x50, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4e,
	0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x54, 0x43, 0x50, 0x5f, 0x55, 0x44, 0x50, 0x10, 0x02,
	0x12, 0x0e, 0x0a, 0x0a, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x10, 0x03,
	0x12, 0x0d, 0x0a, 0x09, 0x54, 0x43, 0x50, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x10, 0x04, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x53, 0x4c, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x10, 0x05, 0x22, 0x66,
	0x0a, 0x0b, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a,
	0x18, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x42,
	0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x01,
	0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x10,
	0x02, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4e, 0x43, 0x45, 0x10, 0x03, 0x22, 0xe7, 0x03, 0x0a, 0x13, 0x4c, 0x6f, 0x61, 0x64, 0x42,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x69, 0x12, 0x8e, 0x01, 0x0a, 0x1b, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x5f, 0x66, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x46, 0x69, 0x72,
	0x65, 0x77, 0x61, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x18, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x4e, 0x0a, 0x24, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69,
	0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x20, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41,
	0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x24, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69,
	0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x20, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x22, 0x6a, 0x0a, 0x18, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x2b, 0x0a, 0x27, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b,
	0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a,
	0x0a, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x45, 0x44, 0x10, 0x01, 0x12, 0x11, 0x0a,
	0x0d, 0x4d, 0x49, 0x53, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x45, 0x44, 0x10, 0x02,
	0x22, 0x5f, 0x0a, 0x10, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x22, 0xc3, 0x01, 0x0a, 0x0e, 0x56, 0x70, 0x6e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70,
	0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x76, 0x70, 0x6e,
	0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x76, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x55, 0x72, 0x69, 0x12,
	0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x22, 0xe1, 0x03, 0x0a, 0x0d, 0x56, 0x70, 0x6e, 0x54,
	0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x25,
	0x0a, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x2a, 0x0a, 0x11,
	0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69,
	0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x70, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x70, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x49, 0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a,
	0x0c, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x22, 0x5b,
	0x0a, 0x0b, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a,
	0x18, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x52,
	0x4f, 0x55, 0x54, 0x45, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c,
	0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b,
	0x0a, 0x07, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x10, 0x03, 0x22, 0xca, 0x03, 0x0a, 0x1a,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12,
	0x29, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x55, 0x72, 0x69, 0x12, 0x56, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x50, 0x0a, 0x20, 0x6c, 0x32, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x69, 0x70,
	0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08,
	0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x04, 0x52, 0x1c, 0x6c, 0x32, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x49, 0x70, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x60, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x45, 0x44, 0x49, 0x43, 0x41, 0x54, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x41, 0x52, 0x54, 0x4e, 0x45, 0x52, 0x10, 0x02,
	0x12, 0x14, 0x0a, 0x10, 0x50, 0x41, 0x52, 0x54, 0x4e, 0x45, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x56,
	0x49, 0x44, 0x45, 0x52, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x4c, 0x32, 0x5f, 0x44, 0x45, 0x44,
	0x49, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x04, 0x22, 0xca, 0x02, 0x0a, 0x0c, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x70, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x70, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x55, 0x72, 0x69, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x28, 0x0a, 0x10, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x55, 0x72, 0x69, 0x22, 0x9d, 0x07, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4d, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x27, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xe2, 0x8c, 0xcf,
	0xd7, 0x08, 0x02, 0x08, 0x04, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x31, 0x0a, 0x15, 0x70, 0x73, 0x63, 0x5f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x70, 0x73, 0x63, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x70, 0x69, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x70, 0x0a, 0x13, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xf7, 0x02, 0x0a,
	0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x41, 0x52, 0x47, 0x45,
	0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x47,
	0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41, 0x50, 0x49, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x47,
	0x4b, 0x45, 0x5f, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x10, 0x05, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x53, 0x43, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49,
	0x53, 0x48, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x06, 0x12, 0x12,
	0x0a, 0x0e, 0x50, 0x53, 0x43, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41, 0x50, 0x49,
	0x10, 0x07, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x53, 0x43, 0x5f, 0x56, 0x50, 0x43, 0x5f, 0x53, 0x43,
	0x10, 0x08, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x4c, 0x45, 0x53, 0x53,
	0x5f, 0x4e, 0x45, 0x47, 0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47,
	0x45, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x0a, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x52,
	0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x0b, 0x12,
	0x12, 0x0a, 0x0e, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x0c, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x50, 0x50, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e,
	0x45, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x0d, 0x12, 0x16, 0x0a, 0x12, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x52, 0x55, 0x4e, 0x5f, 0x52, 0x45, 0x56, 0x49, 0x53, 0x49, 0x4f,
	0x4e, 0x10, 0x0e, 0x12, 0x1a, 0x0a, 0x16, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4d, 0x41,
	0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x0f, 0x12,
	0x12, 0x0a, 0x0e, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x10, 0x10, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x43, 0x4c, 0x55,
	0x53, 0x54, 0x45, 0x52, 0x10, 0x11, 0x22, 0xac, 0x01, 0x0a, 0x11, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f,
	0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x07, 0x0a, 0x03, 0x49, 0x41, 0x50, 0x10, 0x01, 0x12, 0x24, 0x0a, 0x20, 0x47, 0x46,
	0x45, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x5f, 0x4f, 0x52, 0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54,
	0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x52, 0x10, 0x02,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x44, 0x4e, 0x53, 0x10, 0x03, 0x12,
	0x19, 0x0a, 0x15, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c,
	0x45, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x45,
	0x52, 0x56, 0x45, 0x52, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x56, 0x50, 0x43, 0x5f, 0x41, 0x43, 0x43,
	0x45, 0x53, 0x53, 0x10, 0x05, 0x22, 0xa9, 0x03, 0x0a, 0x0b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4d, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x27, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xe2, 0x8c, 0xcf,
	0xd7, 0x08, 0x02, 0x08, 0x04, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x22, 0xfe, 0x01, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x54,
	0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x56,
	0x50, 0x43, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x50, 0x4e, 0x5f, 0x47, 0x41, 0x54, 0x45,
	0x57, 0x41, 0x59, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x43, 0x4f,
	0x4e, 0x4e, 0x45, 0x43, 0x54, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0a, 0x47, 0x4b, 0x45, 0x5f, 0x4d,
	0x41, 0x53, 0x54, 0x45, 0x52, 0x10, 0x04, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x49,
	0x4d, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x52,
	0x4f, 0x55, 0x54, 0x45, 0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x10, 0x05, 0x12,
	0x1a, 0x0a, 0x12, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53,
	0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x06, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41,
	0x4e, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x07,
	0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x43, 0x43, 0x5f, 0x48, 0x55, 0x42, 0x10, 0x08, 0x12, 0x14, 0x0a,
	0x10, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x52, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x41, 0x4e, 0x43,
	0x45, 0x10, 0x09, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x45, 0x43, 0x55, 0x52, 0x45, 0x5f, 0x57, 0x45,
	0x42, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x10,
	0x0a, 0x22, 0x80, 0x0c, 0x0a, 0x09, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x48, 0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x61, 0x75,
	0x73, 0x65, 0x52, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x27, 0x0a, 0x0a,
	0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x08, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x04, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x3e, 0x0a, 0x1b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x19, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x9c, 0x0a, 0x0a, 0x05, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x0f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12,
	0x17, 0x0a, 0x0f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45,
	0x43, 0x54, 0x10, 0x03, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x16, 0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x45,
	0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x49, 0x50, 0x10, 0x07, 0x1a, 0x02, 0x08, 0x01,
	0x12, 0x1e, 0x0a, 0x16, 0x55, 0x4e, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x5f, 0x44,
	0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x1a, 0x02, 0x08, 0x01,
	0x12, 0x21, 0x0a, 0x19, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f,
	0x49, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x0b, 0x1a,
	0x02, 0x08, 0x01, 0x12, 0x21, 0x0a, 0x19, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45,
	0x44, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b,
	0x10, 0x0c, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x26, 0x0a, 0x1e, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x0d, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x26,
	0x0a, 0x1e, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x5f, 0x44, 0x45, 0x53,
	0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b,
	0x10, 0x0e, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x5f, 0x49, 0x50, 0x10, 0x02, 0x12, 0x25, 0x0a, 0x21, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45,
	0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49, 0x50, 0x10, 0x20, 0x12, 0x2b, 0x0a,
	0x27, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x49, 0x50, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45,
	0x53, 0x53, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x17, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x45,
	0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10,
	0x04, 0x12, 0x2a, 0x0a, 0x26, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x5f, 0x4e, 0x4f, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f,
	0x4e, 0x41, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x53, 0x10, 0x1c, 0x12, 0x2d, 0x0a,
	0x29, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49,
	0x45, 0x44, 0x5f, 0x4e, 0x4f, 0x5f, 0x4e, 0x45, 0x47, 0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49,
	0x4e, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x53, 0x10, 0x1d, 0x12, 0x2d, 0x0a, 0x29,
	0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45,
	0x44, 0x5f, 0x4e, 0x4f, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45,
	0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x53, 0x10, 0x24, 0x12, 0x16, 0x0a, 0x12, 0x4e,
	0x4f, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x41,
	0x52, 0x47, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e, 0x54, 0x52, 0x41,
	0x43, 0x45, 0x5f, 0x54, 0x4f, 0x4f, 0x5f, 0x4c, 0x4f, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x12, 0x0a,
	0x0e, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10,
	0x0a, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44,
	0x10, 0x0f, 0x12, 0x19, 0x0a, 0x15, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44,
	0x5f, 0x49, 0x50, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x10, 0x12, 0x26, 0x0a,
	0x22, 0x47, 0x4b, 0x45, 0x5f, 0x4b, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x56, 0x49, 0x54,
	0x59, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52,
	0x54, 0x45, 0x44, 0x10, 0x11, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55,
	0x4e, 0x44, 0x10, 0x12, 0x12, 0x20, 0x0a, 0x1c, 0x56, 0x4d, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41,
	0x4e, 0x43, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46,
	0x4f, 0x55, 0x4e, 0x44, 0x10, 0x18, 0x12, 0x1c, 0x0a, 0x18, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52,
	0x4b, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55,
	0x4e, 0x44, 0x10, 0x19, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c,
	0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e,
	0x44, 0x10, 0x1a, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x1b, 0x12,
	0x31, 0x0a, 0x2d, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45,
	0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x4d, 0x42, 0x49, 0x47, 0x55,
	0x4f, 0x55, 0x53, 0x5f, 0x50, 0x53, 0x43, 0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54,
	0x10, 0x13, 0x12, 0x2d, 0x0a, 0x29, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x4e,
	0x41, 0x47, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x4d, 0x42,
	0x49, 0x47, 0x55, 0x4f, 0x55, 0x53, 0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x10,
	0x27, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x50, 0x53, 0x43, 0x5f,
	0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50,
	0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x14, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f,
	0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x22, 0x12, 0x25, 0x0a,
	0x21, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x49, 0x4e,
	0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54,
	0x45, 0x44, 0x10, 0x23, 0x12, 0x26, 0x0a, 0x22, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x46,
	0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x15, 0x12, 0x1b, 0x0a, 0x17,
	0x4e, 0x4f, 0x4e, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x49, 0x50, 0x5f,
	0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x16, 0x12, 0x2b, 0x0a, 0x27, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x5f, 0x49, 0x4e, 0x5f, 0x47, 0x4f,
	0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f,
	0x4a, 0x45, 0x43, 0x54, 0x10, 0x1e, 0x12, 0x2d, 0x0a, 0x29, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50,
	0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x4e,
	0x41, 0x47, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x10, 0x1f, 0x12, 0x1b, 0x0a, 0x17, 0x4e, 0x4f, 0x5f, 0x53, 0x45, 0x52, 0x56,
	0x45, 0x52, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x49, 0x50, 0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x53,
	0x10, 0x25, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x50, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54,
	0x43, 0x48, 0x10, 0x28, 0x22, 0xb3, 0x21, 0x0a, 0x08, 0x44, 0x72, 0x6f, 0x70, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x47, 0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x72, 0x6f, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x61,
	0x75, 0x73, 0x65, 0x52, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x1b, 0x0a,
	0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x70, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x70, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x70, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x17, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x67, 0x65, 0x6f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x47, 0x65, 0x6f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x40, 0x0a, 0x1c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x67, 0x65, 0x6f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x47, 0x65, 0x6f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x64, 0x65, 0x22, 0xe4, 0x1e, 0x0a, 0x05, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f,
	0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53,
	0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x4f, 0x52, 0x45, 0x49, 0x47, 0x4e, 0x5f, 0x49, 0x50,
	0x5f, 0x44, 0x49, 0x53, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44, 0x10, 0x02, 0x12, 0x11, 0x0a,
	0x0d, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x03,
	0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x4f, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0x04, 0x12, 0x13,
	0x0a, 0x0f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x42, 0x4c, 0x41, 0x43, 0x4b, 0x48, 0x4f, 0x4c,
	0x45, 0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x57, 0x52, 0x4f,
	0x4e, 0x47, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x06, 0x12, 0x2a, 0x0a, 0x26,
	0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x49,
	0x50, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x45,
	0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x10, 0x2a, 0x12, 0x25, 0x0a, 0x21, 0x52, 0x4f, 0x55, 0x54,
	0x45, 0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x2b, 0x12,
	0x29, 0x0a, 0x25, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f,
	0x50, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x57, 0x52, 0x4f, 0x4e, 0x47,
	0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x31, 0x12, 0x2a, 0x0a, 0x26, 0x52, 0x4f,
	0x55, 0x54, 0x45, 0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x49, 0x4e, 0x53,
	0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52,
	0x59, 0x5f, 0x49, 0x50, 0x10, 0x32, 0x12, 0x2e, 0x0a, 0x2a, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f,
	0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44,
	0x49, 0x4e, 0x47, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x49, 0x50, 0x5f, 0x4d, 0x49, 0x53, 0x4d,
	0x41, 0x54, 0x43, 0x48, 0x10, 0x33, 0x12, 0x2d, 0x0a, 0x29, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f,
	0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x56, 0x50, 0x4e, 0x5f, 0x54, 0x55, 0x4e,
	0x4e, 0x45, 0x4c, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x49, 0x53,
	0x48, 0x45, 0x44, 0x10, 0x34, 0x12, 0x2f, 0x0a, 0x2b, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x4e,
	0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x49,
	0x4e, 0x47, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x56,
	0x41, 0x4c, 0x49, 0x44, 0x10, 0x35, 0x12, 0x32, 0x0a, 0x2e, 0x4e, 0x4f, 0x5f, 0x52, 0x4f, 0x55,
	0x54, 0x45, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x45, 0x54,
	0x5f, 0x54, 0x4f, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x50, 0x56, 0x36,
	0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x2c, 0x12, 0x3e, 0x0a, 0x3a, 0x4e, 0x4f,
	0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x45, 0x58, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x49, 0x50, 0x56, 0x36, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x54, 0x4f, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x50, 0x56, 0x36,
	0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x62, 0x12, 0x26, 0x0a, 0x22, 0x56, 0x50,
	0x4e, 0x5f, 0x54, 0x55, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x53,
	0x45, 0x4c, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48,
	0x10, 0x2d, 0x12, 0x27, 0x0a, 0x23, 0x56, 0x50, 0x4e, 0x5f, 0x54, 0x55, 0x4e, 0x4e, 0x45, 0x4c,
	0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54, 0x4f, 0x52,
	0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x2e, 0x12, 0x1f, 0x0a, 0x1b, 0x50,
	0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x54,
	0x4f, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x10, 0x07, 0x12, 0x24, 0x0a, 0x20,
	0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41,
	0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44,
	0x10, 0x08, 0x12, 0x34, 0x0a, 0x30, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x47, 0x4f,
	0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x56, 0x49, 0x41, 0x5f,
	0x56, 0x50, 0x4e, 0x5f, 0x54, 0x55, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x2f, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x4f, 0x5f, 0x45,
	0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10,
	0x09, 0x12, 0x1c, 0x0a, 0x18, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x0a, 0x12,
	0x1c, 0x0a, 0x18, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x55,
	0x4c, 0x45, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x0b, 0x12, 0x20, 0x0a,
	0x1c, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x55, 0x4c, 0x45,
	0x5f, 0x4e, 0x4f, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x53, 0x10, 0x0c, 0x12,
	0x38, 0x0a, 0x34, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x42, 0x4c, 0x4f, 0x43,
	0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43,
	0x45, 0x52, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54,
	0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x10, 0x0d, 0x12, 0x3a, 0x0a, 0x36, 0x49, 0x4e, 0x47,
	0x52, 0x45, 0x53, 0x53, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x54, 0x41,
	0x47, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x42,
	0x59, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x56, 0x50, 0x43, 0x5f, 0x45, 0x47, 0x52,
	0x45, 0x53, 0x53, 0x10, 0x55, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x0e, 0x12,
	0x1b, 0x0a, 0x17, 0x47, 0x4b, 0x45, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x1b, 0x12, 0x22, 0x0a, 0x1e,
	0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e,
	0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x1c,
	0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e,
	0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x44,
	0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45,
	0x52, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x45, 0x12,
	0x18, 0x0a, 0x14, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x10, 0x0f, 0x12, 0x22, 0x0a, 0x1e, 0x47, 0x4b, 0x45,
	0x5f, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52,
	0x49, 0x5a, 0x45, 0x44, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x10, 0x12, 0x2a, 0x0a,
	0x26, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41,
	0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x45, 0x44,
	0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x11, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x52, 0x4f,
	0x50, 0x50, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x53, 0x49, 0x44, 0x45, 0x5f, 0x47, 0x4b, 0x45, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x12, 0x12, 0x24, 0x0a, 0x20, 0x44, 0x52, 0x4f,
	0x50, 0x50, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x53, 0x49, 0x44, 0x45, 0x5f, 0x43, 0x4c, 0x4f, 0x55,
	0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x13, 0x12,
	0x25, 0x0a, 0x21, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45,
	0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x5f, 0x50, 0x45, 0x45,
	0x52, 0x49, 0x4e, 0x47, 0x10, 0x14, 0x12, 0x2a, 0x0a, 0x26, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45,
	0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45,
	0x5f, 0x4e, 0x4f, 0x5f, 0x50, 0x53, 0x43, 0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54,
	0x10, 0x26, 0x12, 0x1c, 0x0a, 0x18, 0x47, 0x4b, 0x45, 0x5f, 0x50, 0x53, 0x43, 0x5f, 0x45, 0x4e,
	0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x10, 0x24,
	0x12, 0x24, 0x0a, 0x20, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e,
	0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x5f, 0x49, 0x50, 0x5f, 0x41, 0x44, 0x44,
	0x52, 0x45, 0x53, 0x53, 0x10, 0x15, 0x12, 0x25, 0x0a, 0x21, 0x47, 0x4b, 0x45, 0x5f, 0x43, 0x4f,
	0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x45, 0x5f, 0x52, 0x45, 0x47, 0x49,
	0x4f, 0x4e, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x1e, 0x12, 0x33, 0x0a,
	0x2f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x47, 0x4b, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54,
	0x52, 0x4f, 0x4c, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x50, 0x52, 0x49,
	0x56, 0x41, 0x54, 0x45, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x1f, 0x12, 0x1e, 0x0a, 0x1a, 0x47, 0x4b, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f,
	0x4c, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x45, 0x5f, 0x4e, 0x4f, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45,
	0x10, 0x20, 0x12, 0x3a, 0x0a, 0x36, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f,
	0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x55, 0x52, 0x45, 0x44, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x45, 0x58, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x10, 0x21, 0x12, 0x34,
	0x0a, 0x30, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53,
	0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x50,
	0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x22, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51,
	0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x5f, 0x52, 0x4f,
	0x55, 0x54, 0x45, 0x10, 0x23, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53,
	0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x52, 0x45, 0x51,
	0x55, 0x49, 0x52, 0x45, 0x44, 0x10, 0x3f, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x4c, 0x4f, 0x55, 0x44,
	0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x16, 0x12, 0x19, 0x0a, 0x15, 0x56, 0x50, 0x43, 0x5f, 0x43, 0x4f,
	0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x45, 0x54, 0x10,
	0x17, 0x12, 0x1d, 0x0a, 0x19, 0x56, 0x50, 0x43, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54,
	0x4f, 0x52, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x18,
	0x12, 0x2c, 0x0a, 0x28, 0x56, 0x50, 0x43, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f,
	0x52, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x52, 0x41,
	0x46, 0x46, 0x49, 0x43, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x10, 0x3c, 0x12, 0x2e,
	0x0a, 0x2a, 0x56, 0x50, 0x43, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f,
	0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x54, 0x52, 0x41,
	0x46, 0x46, 0x49, 0x43, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x10, 0x3d, 0x12, 0x23,
	0x0a, 0x1f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x55, 0x4c,
	0x45, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43,
	0x48, 0x10, 0x19, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x53, 0x43, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54,
	0x45, 0x44, 0x10, 0x1a, 0x12, 0x2d, 0x0a, 0x29, 0x50, 0x53, 0x43, 0x5f, 0x45, 0x4e, 0x44, 0x50,
	0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x45, 0x44, 0x5f, 0x46, 0x52,
	0x4f, 0x4d, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x45, 0x44, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52,
	0x4b, 0x10, 0x29, 0x12, 0x2e, 0x0a, 0x2a, 0x50, 0x53, 0x43, 0x5f, 0x4e, 0x45, 0x47, 0x5f, 0x50,
	0x52, 0x4f, 0x44, 0x55, 0x43, 0x45, 0x52, 0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54,
	0x5f, 0x4e, 0x4f, 0x5f, 0x47, 0x4c, 0x4f, 0x42, 0x41, 0x4c, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x10, 0x30, 0x12, 0x33, 0x0a, 0x2f, 0x50, 0x53, 0x43, 0x5f, 0x4e, 0x45, 0x47, 0x5f, 0x50,
	0x52, 0x4f, 0x44, 0x55, 0x43, 0x45, 0x52, 0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x49,
	0x4e, 0x47, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x50, 0x4c, 0x45,
	0x5f, 0x50, 0x4f, 0x52, 0x54, 0x53, 0x10, 0x36, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4c, 0x4f, 0x55,
	0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x50, 0x53, 0x43, 0x5f, 0x4e, 0x45, 0x47, 0x5f, 0x55, 0x4e,
	0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x3a, 0x12, 0x2d, 0x0a, 0x29, 0x4e,
	0x4f, 0x5f, 0x4e, 0x41, 0x54, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x53, 0x5f, 0x46, 0x4f,
	0x52, 0x5f, 0x50, 0x53, 0x43, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x54,
	0x54, 0x41, 0x43, 0x48, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x39, 0x12, 0x23, 0x0a, 0x1f, 0x50, 0x53,
	0x43, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x50, 0x41, 0x47, 0x41, 0x54, 0x45, 0x44, 0x10, 0x40, 0x12,
	0x28, 0x0a, 0x24, 0x48, 0x59, 0x42, 0x52, 0x49, 0x44, 0x5f, 0x4e, 0x45, 0x47, 0x5f, 0x4e, 0x4f,
	0x4e, 0x5f, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f,
	0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x10, 0x37, 0x12, 0x2e, 0x0a, 0x2a, 0x48, 0x59, 0x42,
	0x52, 0x49, 0x44, 0x5f, 0x4e, 0x45, 0x47, 0x5f, 0x4e, 0x4f, 0x4e, 0x5f, 0x4c, 0x4f, 0x43, 0x41,
	0x4c, 0x5f, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f,
	0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x10, 0x38, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x4c, 0x4f,
	0x55, 0x44, 0x5f, 0x52, 0x55, 0x4e, 0x5f, 0x52, 0x45, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x1d, 0x12, 0x27, 0x0a, 0x23, 0x44,
	0x52, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x53, 0x49, 0x44, 0x45, 0x5f, 0x50, 0x53,
	0x43, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43,
	0x45, 0x52, 0x10, 0x25, 0x12, 0x25, 0x0a, 0x21, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c,
	0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x48, 0x41, 0x53, 0x5f, 0x4e, 0x4f, 0x5f, 0x50, 0x52, 0x4f,
	0x58, 0x59, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x10, 0x27, 0x12, 0x1a, 0x0a, 0x16, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x4e, 0x41, 0x54, 0x5f, 0x4e, 0x4f, 0x5f, 0x41, 0x44, 0x44, 0x52,
	0x45, 0x53, 0x53, 0x45, 0x53, 0x10, 0x28, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x4f, 0x55, 0x54, 0x49,
	0x4e, 0x47, 0x5f, 0x4c, 0x4f, 0x4f, 0x50, 0x10, 0x3b, 0x12, 0x29, 0x0a, 0x25, 0x44, 0x52, 0x4f,
	0x50, 0x50, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x53, 0x49, 0x44, 0x45, 0x5f, 0x47, 0x4f, 0x4f, 0x47,
	0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49,
	0x43, 0x45, 0x10, 0x3e, 0x12, 0x29, 0x0a, 0x25, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c,
	0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x49, 0x4e,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x41, 0x12,
	0x2a, 0x0a, 0x26, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49,
	0x43, 0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x44, 0x5f, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4e, 0x4f,
	0x54, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x42, 0x12, 0x27, 0x0a, 0x23, 0x44,
	0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x53, 0x5f, 0x50, 0x52,
	0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x41, 0x54, 0x5f, 0x49, 0x50, 0x5f, 0x52, 0x41, 0x4e,
	0x47, 0x45, 0x10, 0x43, 0x12, 0x29, 0x0a, 0x25, 0x44, 0x52, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x5f,
	0x49, 0x4e, 0x53, 0x49, 0x44, 0x45, 0x5f, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x49, 0x4e, 0x53,
	0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x46, 0x12,
	0x23, 0x0a, 0x1f, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x4f,
	0x52, 0x54, 0x10, 0x47, 0x12, 0x2f, 0x0a, 0x2b, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x49, 0x4e,
	0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4e,
	0x47, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x50, 0x55, 0x50, 0x49, 0x5f, 0x41, 0x44, 0x44, 0x52,
	0x45, 0x53, 0x53, 0x10, 0x48, 0x12, 0x32, 0x0a, 0x2e, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x49,
	0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45,
	0x5f, 0x54, 0x4f, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x49, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x45, 0x44,
	0x49, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x5f, 0x45,
	0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x49, 0x50, 0x10, 0x4a, 0x12, 0x27, 0x0a, 0x23,
	0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f,
	0x43, 0x4f, 0x4c, 0x10, 0x4e, 0x12, 0x28, 0x0a, 0x24, 0x44, 0x52, 0x4f, 0x50, 0x50, 0x45, 0x44,
	0x5f, 0x49, 0x4e, 0x53, 0x49, 0x44, 0x45, 0x5f, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x43, 0x4c,
	0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x4b, 0x12,
	0x22, 0x0a, 0x1e, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52,
	0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x4f, 0x52,
	0x54, 0x10, 0x4c, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x43, 0x4c, 0x55,
	0x53, 0x54, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c,
	0x5f, 0x49, 0x50, 0x10, 0x4d, 0x12, 0x26, 0x0a, 0x22, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x43,
	0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54,
	0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x10, 0x4f, 0x12, 0x2a, 0x0a,
	0x26, 0x4e, 0x4f, 0x5f, 0x41, 0x44, 0x56, 0x45, 0x52, 0x54, 0x49, 0x53, 0x45, 0x44, 0x5f, 0x52,
	0x4f, 0x55, 0x54, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x47, 0x43, 0x50, 0x5f, 0x44, 0x45, 0x53, 0x54,
	0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x50, 0x12, 0x2a, 0x0a, 0x26, 0x4e, 0x4f, 0x5f,
	0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54, 0x4f, 0x52,
	0x5f, 0x54, 0x4f, 0x5f, 0x47, 0x43, 0x50, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x51, 0x12, 0x35, 0x0a, 0x31, 0x4e, 0x4f, 0x5f, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x50, 0x45, 0x45,
	0x52, 0x45, 0x44, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x54, 0x4f, 0x5f, 0x44,
	0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x52, 0x12, 0x2b, 0x0a, 0x27,
	0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x41, 0x54, 0x5f, 0x54, 0x4f, 0x5f, 0x50,
	0x53, 0x43, 0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x55,
	0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x53, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x53, 0x43,
	0x5f, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4d, 0x41, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4f,
	0x52, 0x54, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x56, 0x12, 0x37, 0x0a,
	0x33, 0x50, 0x53, 0x43, 0x5f, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4d, 0x41, 0x50, 0x50, 0x49, 0x4e,
	0x47, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x4f, 0x55, 0x54, 0x5f, 0x50, 0x53, 0x43, 0x5f, 0x43, 0x4f,
	0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f,
	0x52, 0x54, 0x45, 0x44, 0x10, 0x57, 0x12, 0x33, 0x0a, 0x2f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50,
	0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43,
	0x48, 0x45, 0x44, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x4e, 0x41, 0x54, 0x36, 0x34, 0x5f, 0x44, 0x45,
	0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x58, 0x12, 0x37, 0x0a, 0x33, 0x54,
	0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x48, 0x59, 0x42, 0x52,
	0x49, 0x44, 0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x54, 0x4f, 0x5f, 0x49,
	0x4e, 0x54, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x4c, 0x4c, 0x4f, 0x57,
	0x45, 0x44, 0x10, 0x59, 0x12, 0x1d, 0x0a, 0x19, 0x4e, 0x4f, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48,
	0x49, 0x4e, 0x47, 0x5f, 0x4e, 0x41, 0x54, 0x36, 0x34, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41,
	0x59, 0x10, 0x5a, 0x12, 0x2d, 0x0a, 0x29, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41,
	0x4e, 0x43, 0x45, 0x52, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x49, 0x50, 0x5f,
	0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48,
	0x10, 0x60, 0x12, 0x32, 0x0a, 0x2e, 0x4e, 0x4f, 0x5f, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x52,
	0x4f, 0x55, 0x54, 0x45, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x4e, 0x43, 0x43, 0x5f, 0x4e, 0x45,
	0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x54, 0x4f, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x61, 0x12, 0x22, 0x0a, 0x1e, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f,
	0x4e, 0x41, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x55, 0x4e, 0x53,
	0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x63, 0x12, 0x28, 0x0a, 0x24, 0x4c, 0x32,
	0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43,
	0x4f, 0x4c, 0x10, 0x64, 0x12, 0x24, 0x0a, 0x20, 0x4c, 0x32, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52,
	0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52,
	0x54, 0x45, 0x44, 0x5f, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x65, 0x12, 0x2b, 0x0a, 0x27, 0x4c, 0x32,
	0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x5f, 0x44, 0x45,
	0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x50, 0x5f, 0x4d, 0x49, 0x53,
	0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x66, 0x12, 0x2e, 0x0a, 0x2a, 0x4e, 0x43, 0x43, 0x5f, 0x52,
	0x4f, 0x55, 0x54, 0x45, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x49, 0x4e, 0x5f, 0x48, 0x59, 0x42, 0x52,
	0x49, 0x44, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50,
	0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x68, 0x12, 0x21, 0x0a, 0x1d, 0x48, 0x59, 0x42, 0x52, 0x49,
	0x44, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x5f,
	0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x69, 0x22, 0xc5, 0x01, 0x0a, 0x0d, 0x47,
	0x4b, 0x45, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x0a, 0x0b,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x72, 0x69, 0x12, 0x2e, 0x0a,
	0x13, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x1f, 0x0a,
	0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x1f,
	0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x6e, 0x73, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x6e, 0x73, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x22, 0xc6, 0x01, 0x0a, 0x14, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x51, 0x4c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72,
	0x69, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x49, 0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69,
	0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x49, 0x70, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x22, 0xdb, 0x01, 0x0a, 0x11,
	0x52, 0x65, 0x64, 0x69, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x70, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x70, 0x12, 0x28, 0x0a, 0x10, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49,
	0x70, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x22, 0x9e, 0x02, 0x0a, 0x10, 0x52, 0x65,
	0x64, 0x69, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x55, 0x72, 0x69, 0x12, 0x4b, 0x0a, 0x1d, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xe2, 0x8c, 0xcf,
	0xd7, 0x08, 0x02, 0x08, 0x04, 0x52, 0x1a, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x4b, 0x0a, 0x1d, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02,
	0x08, 0x04, 0x52, 0x1a, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1a,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0x0a, 0x11, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x22, 0x88, 0x01, 0x0a, 0x14, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1a,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x55, 0x72, 0x69, 0x22, 0x87, 0x01, 0x0a, 0x14,
	0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x63, 0x0a, 0x10, 0x56, 0x70, 0x63, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1a,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xef, 0x01, 0x0a, 0x1d, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x56, 0x70, 0x63, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x0a, 0x0b,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x25, 0x0a,
	0x0e, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x55, 0x72, 0x69, 0x12, 0x34, 0x0a, 0x11, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x08, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x04, 0x52, 0x0f, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x38, 0x0a, 0x13, 0x73, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08,
	0x04, 0x52, 0x11, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x49, 0x70, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x22, 0x5c, 0x0a, 0x20,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x38, 0x0a, 0x13, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xe2,
	0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x04, 0x52, 0x11, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0xc8, 0x05, 0x0a, 0x07, 0x4e,
	0x61, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x43, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x22, 0x0a, 0x0d, 0x6f, 0x6c, 0x64, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x6f, 0x6c, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x70, 0x12, 0x22, 0x0a, 0x0d,
	0x6e, 0x65, 0x77, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x77, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x70,
	0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x6c, 0x64, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x6c,
	0x64, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x70, 0x12, 0x2c,
	0x0a, 0x12, 0x6e, 0x65, 0x77, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6e, 0x65, 0x77, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x70, 0x12, 0x26, 0x0a, 0x0f,
	0x6f, 0x6c, 0x64, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6f, 0x6c, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x50, 0x6f, 0x72, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x77, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6e,
	0x65, 0x77, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x30, 0x0a, 0x14,
	0x6f, 0x6c, 0x64, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x6f, 0x72, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x6f, 0x6c, 0x64, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x30,
	0x0a, 0x14, 0x6e, 0x65, 0x77, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x6e, 0x65,
	0x77, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x72, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x55, 0x72, 0x69, 0x12,
	0x28, 0x0a, 0x10, 0x6e, 0x61, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6e, 0x61, 0x74, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x99, 0x01, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x54, 0x4f, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c,
	0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x54,
	0x4f, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x4e, 0x41, 0x54, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x50,
	0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x43,
	0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x17, 0x47, 0x4b, 0x45, 0x5f,
	0x50, 0x4f, 0x44, 0x5f, 0x49, 0x50, 0x5f, 0x4d, 0x41, 0x53, 0x51, 0x55, 0x45, 0x52, 0x41, 0x44,
	0x49, 0x4e, 0x47, 0x10, 0x05, 0x22, 0xc9, 0x03, 0x0a, 0x13, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x22, 0x0a, 0x0d, 0x6f, 0x6c, 0x64,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x6f, 0x6c, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x70, 0x12, 0x22, 0x0a,
	0x0d, 0x6e, 0x65, 0x77, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x77, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x70, 0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x6c, 0x64, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f,
	0x6c, 0x64, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x70, 0x12,
	0x2c, 0x0a, 0x12, 0x6e, 0x65, 0x77, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6e, 0x65, 0x77,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x70, 0x12, 0x26, 0x0a,
	0x0f, 0x6f, 0x6c, 0x64, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6f, 0x6c, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x77, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d,
	0x6e, 0x65, 0x77, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x30, 0x0a,
	0x14, 0x6f, 0x6c, 0x64, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x6f, 0x6c, 0x64,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x72, 0x74, 0x12,
	0x30, 0x0a, 0x14, 0x6e, 0x65, 0x77, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x6e,
	0x65, 0x77, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x72,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x55, 0x72, 0x69,
	0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72,
	0x69, 0x22, 0xb3, 0x06, 0x0a, 0x17, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x72, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x55, 0x72, 0x69, 0x12, 0x2e, 0x0a, 0x13, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x55, 0x72, 0x69, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x55,
	0x72, 0x69, 0x12, 0x3b, 0x0a, 0x1a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x72, 0x69, 0x12,
	0x2c, 0x0a, 0x12, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x62, 0x61, 0x63,
	0x6b, 0x65, 0x6e, 0x64, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x55, 0x72, 0x69, 0x12, 0x3b, 0x0a,
	0x1a, 0x70, 0x73, 0x63, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x17, 0x70, 0x73, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x31, 0x0a, 0x15, 0x70, 0x73,
	0x63, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x70, 0x73, 0x63, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x70, 0x69, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x28, 0x0a,
	0x10, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x55, 0x72, 0x69, 0x12, 0xad, 0x01, 0x0a, 0x23, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x66, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c,
	0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x46, 0x69, 0x72,
	0x65, 0x77, 0x61, 0x6c, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0xcd, 0x01, 0x0a, 0x1f, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x33, 0x0a, 0x2f, 0x48,
	0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x46, 0x49, 0x52, 0x45,
	0x57, 0x41, 0x4c, 0x4c, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x18, 0x0a, 0x14, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x53, 0x5f, 0x43, 0x4f,
	0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x45, 0x44, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x46, 0x49,
	0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x53, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x4c,
	0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1c,
	0x0a, 0x18, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x53, 0x5f, 0x4e, 0x4f, 0x54, 0x5f,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x45, 0x44, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15,
	0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50,
	0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x04, 0x22, 0x2b, 0x0a, 0x11, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x22, 0x2c, 0x0a, 0x11, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x6c, 0x65,
	0x73, 0x73, 0x4e, 0x65, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x17, 0x0a, 0x07, 0x6e, 0x65, 0x67,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x65, 0x67, 0x55,
	0x72, 0x69, 0x2a, 0xf6, 0x02, 0x0a, 0x10, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x4c, 0x4f, 0x41, 0x44, 0x5f,
	0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x48,
	0x54, 0x54, 0x50, 0x53, 0x5f, 0x41, 0x44, 0x56, 0x41, 0x4e, 0x43, 0x45, 0x44, 0x5f, 0x4c, 0x4f,
	0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x10, 0x01, 0x12, 0x17, 0x0a,
	0x13, 0x48, 0x54, 0x54, 0x50, 0x53, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41,
	0x4e, 0x43, 0x45, 0x52, 0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e,
	0x41, 0x4c, 0x5f, 0x48, 0x54, 0x54, 0x50, 0x53, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41,
	0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x10, 0x03, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x48, 0x54, 0x54, 0x50, 0x53, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f,
	0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x53,
	0x4c, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c,
	0x41, 0x4e, 0x43, 0x45, 0x52, 0x10, 0x05, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x43, 0x50, 0x5f, 0x50,
	0x52, 0x4f, 0x58, 0x59, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43,
	0x45, 0x52, 0x10, 0x06, 0x12, 0x24, 0x0a, 0x20, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c,
	0x5f, 0x54, 0x43, 0x50, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f,
	0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x10, 0x07, 0x12, 0x19, 0x0a, 0x15, 0x4e, 0x45,
	0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e,
	0x43, 0x45, 0x52, 0x10, 0x08, 0x12, 0x20, 0x0a, 0x1c, 0x4c, 0x45, 0x47, 0x41, 0x43, 0x59, 0x5f,
	0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c,
	0x41, 0x4e, 0x43, 0x45, 0x52, 0x10, 0x09, 0x12, 0x22, 0x0a, 0x1e, 0x54, 0x43, 0x50, 0x5f, 0x55,
	0x44, 0x50, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x4c, 0x4f, 0x41, 0x44,
	0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x10, 0x0a, 0x42, 0xf9, 0x01, 0x0a, 0x25,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0a, 0x54, 0x72, 0x61, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x21, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkmanagement_v1_trace_proto_rawDescOnce sync.Once
	file_google_cloud_networkmanagement_v1_trace_proto_rawDescData = file_google_cloud_networkmanagement_v1_trace_proto_rawDesc
)

func file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP() []byte {
	file_google_cloud_networkmanagement_v1_trace_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkmanagement_v1_trace_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkmanagement_v1_trace_proto_rawDescData)
	})
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescData
}

var file_google_cloud_networkmanagement_v1_trace_proto_enumTypes = make([]protoimpl.EnumInfo, 21)
var file_google_cloud_networkmanagement_v1_trace_proto_msgTypes = make([]protoimpl.MessageInfo, 34)
var file_google_cloud_networkmanagement_v1_trace_proto_goTypes = []any{
	(LoadBalancerType)(0),                                        // 0: google.cloud.networkmanagement.v1.LoadBalancerType
	(Step_State)(0),                                              // 1: google.cloud.networkmanagement.v1.Step.State
	(InstanceInfo_Status)(0),                                     // 2: google.cloud.networkmanagement.v1.InstanceInfo.Status
	(FirewallInfo_FirewallRuleType)(0),                           // 3: google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType
	(FirewallInfo_TargetType)(0),                                 // 4: google.cloud.networkmanagement.v1.FirewallInfo.TargetType
	(RouteInfo_RouteType)(0),                                     // 5: google.cloud.networkmanagement.v1.RouteInfo.RouteType
	(RouteInfo_NextHopType)(0),                                   // 6: google.cloud.networkmanagement.v1.RouteInfo.NextHopType
	(RouteInfo_RouteScope)(0),                                    // 7: google.cloud.networkmanagement.v1.RouteInfo.RouteScope
	(GoogleServiceInfo_GoogleServiceType)(0),                     // 8: google.cloud.networkmanagement.v1.GoogleServiceInfo.GoogleServiceType
	(LoadBalancerInfo_LoadBalancerType)(0),                       // 9: google.cloud.networkmanagement.v1.LoadBalancerInfo.LoadBalancerType
	(LoadBalancerInfo_BackendType)(0),                            // 10: google.cloud.networkmanagement.v1.LoadBalancerInfo.BackendType
	(LoadBalancerBackend_HealthCheckFirewallState)(0),            // 11: google.cloud.networkmanagement.v1.LoadBalancerBackend.HealthCheckFirewallState
	(VpnTunnelInfo_RoutingType)(0),                               // 12: google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType
	(InterconnectAttachmentInfo_Type)(0),                         // 13: google.cloud.networkmanagement.v1.InterconnectAttachmentInfo.Type
	(DeliverInfo_Target)(0),                                      // 14: google.cloud.networkmanagement.v1.DeliverInfo.Target
	(DeliverInfo_GoogleServiceType)(0),                           // 15: google.cloud.networkmanagement.v1.DeliverInfo.GoogleServiceType
	(ForwardInfo_Target)(0),                                      // 16: google.cloud.networkmanagement.v1.ForwardInfo.Target
	(AbortInfo_Cause)(0),                                         // 17: google.cloud.networkmanagement.v1.AbortInfo.Cause
	(DropInfo_Cause)(0),                                          // 18: google.cloud.networkmanagement.v1.DropInfo.Cause
	(NatInfo_Type)(0),                                            // 19: google.cloud.networkmanagement.v1.NatInfo.Type
	(LoadBalancerBackendInfo_HealthCheckFirewallsConfigState)(0), // 20: google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState
	(*Trace)(nil),                                                // 21: google.cloud.networkmanagement.v1.Trace
	(*Step)(nil),                                                 // 22: google.cloud.networkmanagement.v1.Step
	(*InstanceInfo)(nil),                                         // 23: google.cloud.networkmanagement.v1.InstanceInfo
	(*NetworkInfo)(nil),                                          // 24: google.cloud.networkmanagement.v1.NetworkInfo
	(*FirewallInfo)(nil),                                         // 25: google.cloud.networkmanagement.v1.FirewallInfo
	(*RouteInfo)(nil),                                            // 26: google.cloud.networkmanagement.v1.RouteInfo
	(*GoogleServiceInfo)(nil),                                    // 27: google.cloud.networkmanagement.v1.GoogleServiceInfo
	(*ForwardingRuleInfo)(nil),                                   // 28: google.cloud.networkmanagement.v1.ForwardingRuleInfo
	(*LoadBalancerInfo)(nil),                                     // 29: google.cloud.networkmanagement.v1.LoadBalancerInfo
	(*LoadBalancerBackend)(nil),                                  // 30: google.cloud.networkmanagement.v1.LoadBalancerBackend
	(*HybridSubnetInfo)(nil),                                     // 31: google.cloud.networkmanagement.v1.HybridSubnetInfo
	(*VpnGatewayInfo)(nil),                                       // 32: google.cloud.networkmanagement.v1.VpnGatewayInfo
	(*VpnTunnelInfo)(nil),                                        // 33: google.cloud.networkmanagement.v1.VpnTunnelInfo
	(*InterconnectAttachmentInfo)(nil),                           // 34: google.cloud.networkmanagement.v1.InterconnectAttachmentInfo
	(*EndpointInfo)(nil),                                         // 35: google.cloud.networkmanagement.v1.EndpointInfo
	(*DeliverInfo)(nil),                                          // 36: google.cloud.networkmanagement.v1.DeliverInfo
	(*ForwardInfo)(nil),                                          // 37: google.cloud.networkmanagement.v1.ForwardInfo
	(*AbortInfo)(nil),                                            // 38: google.cloud.networkmanagement.v1.AbortInfo
	(*DropInfo)(nil),                                             // 39: google.cloud.networkmanagement.v1.DropInfo
	(*GKEMasterInfo)(nil),                                        // 40: google.cloud.networkmanagement.v1.GKEMasterInfo
	(*CloudSQLInstanceInfo)(nil),                                 // 41: google.cloud.networkmanagement.v1.CloudSQLInstanceInfo
	(*RedisInstanceInfo)(nil),                                    // 42: google.cloud.networkmanagement.v1.RedisInstanceInfo
	(*RedisClusterInfo)(nil),                                     // 43: google.cloud.networkmanagement.v1.RedisClusterInfo
	(*CloudFunctionInfo)(nil),                                    // 44: google.cloud.networkmanagement.v1.CloudFunctionInfo
	(*CloudRunRevisionInfo)(nil),                                 // 45: google.cloud.networkmanagement.v1.CloudRunRevisionInfo
	(*AppEngineVersionInfo)(nil),                                 // 46: google.cloud.networkmanagement.v1.AppEngineVersionInfo
	(*VpcConnectorInfo)(nil),                                     // 47: google.cloud.networkmanagement.v1.VpcConnectorInfo
	(*DirectVpcEgressConnectionInfo)(nil),                        // 48: google.cloud.networkmanagement.v1.DirectVpcEgressConnectionInfo
	(*ServerlessExternalConnectionInfo)(nil),                     // 49: google.cloud.networkmanagement.v1.ServerlessExternalConnectionInfo
	(*NatInfo)(nil),                                              // 50: google.cloud.networkmanagement.v1.NatInfo
	(*ProxyConnectionInfo)(nil),                                  // 51: google.cloud.networkmanagement.v1.ProxyConnectionInfo
	(*LoadBalancerBackendInfo)(nil),                              // 52: google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
	(*StorageBucketInfo)(nil),                                    // 53: google.cloud.networkmanagement.v1.StorageBucketInfo
	(*ServerlessNegInfo)(nil),                                    // 54: google.cloud.networkmanagement.v1.ServerlessNegInfo
}
var file_google_cloud_networkmanagement_v1_trace_proto_depIdxs = []int32{
	35, // 0: google.cloud.networkmanagement.v1.Trace.endpoint_info:type_name -> google.cloud.networkmanagement.v1.EndpointInfo
	22, // 1: google.cloud.networkmanagement.v1.Trace.steps:type_name -> google.cloud.networkmanagement.v1.Step
	1,  // 2: google.cloud.networkmanagement.v1.Step.state:type_name -> google.cloud.networkmanagement.v1.Step.State
	23, // 3: google.cloud.networkmanagement.v1.Step.instance:type_name -> google.cloud.networkmanagement.v1.InstanceInfo
	25, // 4: google.cloud.networkmanagement.v1.Step.firewall:type_name -> google.cloud.networkmanagement.v1.FirewallInfo
	26, // 5: google.cloud.networkmanagement.v1.Step.route:type_name -> google.cloud.networkmanagement.v1.RouteInfo
	35, // 6: google.cloud.networkmanagement.v1.Step.endpoint:type_name -> google.cloud.networkmanagement.v1.EndpointInfo
	27, // 7: google.cloud.networkmanagement.v1.Step.google_service:type_name -> google.cloud.networkmanagement.v1.GoogleServiceInfo
	28, // 8: google.cloud.networkmanagement.v1.Step.forwarding_rule:type_name -> google.cloud.networkmanagement.v1.ForwardingRuleInfo
	31, // 9: google.cloud.networkmanagement.v1.Step.hybrid_subnet:type_name -> google.cloud.networkmanagement.v1.HybridSubnetInfo
	32, // 10: google.cloud.networkmanagement.v1.Step.vpn_gateway:type_name -> google.cloud.networkmanagement.v1.VpnGatewayInfo
	33, // 11: google.cloud.networkmanagement.v1.Step.vpn_tunnel:type_name -> google.cloud.networkmanagement.v1.VpnTunnelInfo
	34, // 12: google.cloud.networkmanagement.v1.Step.interconnect_attachment:type_name -> google.cloud.networkmanagement.v1.InterconnectAttachmentInfo
	47, // 13: google.cloud.networkmanagement.v1.Step.vpc_connector:type_name -> google.cloud.networkmanagement.v1.VpcConnectorInfo
	48, // 14: google.cloud.networkmanagement.v1.Step.direct_vpc_egress_connection:type_name -> google.cloud.networkmanagement.v1.DirectVpcEgressConnectionInfo
	49, // 15: google.cloud.networkmanagement.v1.Step.serverless_external_connection:type_name -> google.cloud.networkmanagement.v1.ServerlessExternalConnectionInfo
	36, // 16: google.cloud.networkmanagement.v1.Step.deliver:type_name -> google.cloud.networkmanagement.v1.DeliverInfo
	37, // 17: google.cloud.networkmanagement.v1.Step.forward:type_name -> google.cloud.networkmanagement.v1.ForwardInfo
	38, // 18: google.cloud.networkmanagement.v1.Step.abort:type_name -> google.cloud.networkmanagement.v1.AbortInfo
	39, // 19: google.cloud.networkmanagement.v1.Step.drop:type_name -> google.cloud.networkmanagement.v1.DropInfo
	29, // 20: google.cloud.networkmanagement.v1.Step.load_balancer:type_name -> google.cloud.networkmanagement.v1.LoadBalancerInfo
	24, // 21: google.cloud.networkmanagement.v1.Step.network:type_name -> google.cloud.networkmanagement.v1.NetworkInfo
	40, // 22: google.cloud.networkmanagement.v1.Step.gke_master:type_name -> google.cloud.networkmanagement.v1.GKEMasterInfo
	41, // 23: google.cloud.networkmanagement.v1.Step.cloud_sql_instance:type_name -> google.cloud.networkmanagement.v1.CloudSQLInstanceInfo
	42, // 24: google.cloud.networkmanagement.v1.Step.redis_instance:type_name -> google.cloud.networkmanagement.v1.RedisInstanceInfo
	43, // 25: google.cloud.networkmanagement.v1.Step.redis_cluster:type_name -> google.cloud.networkmanagement.v1.RedisClusterInfo
	44, // 26: google.cloud.networkmanagement.v1.Step.cloud_function:type_name -> google.cloud.networkmanagement.v1.CloudFunctionInfo
	46, // 27: google.cloud.networkmanagement.v1.Step.app_engine_version:type_name -> google.cloud.networkmanagement.v1.AppEngineVersionInfo
	45, // 28: google.cloud.networkmanagement.v1.Step.cloud_run_revision:type_name -> google.cloud.networkmanagement.v1.CloudRunRevisionInfo
	50, // 29: google.cloud.networkmanagement.v1.Step.nat:type_name -> google.cloud.networkmanagement.v1.NatInfo
	51, // 30: google.cloud.networkmanagement.v1.Step.proxy_connection:type_name -> google.cloud.networkmanagement.v1.ProxyConnectionInfo
	52, // 31: google.cloud.networkmanagement.v1.Step.load_balancer_backend_info:type_name -> google.cloud.networkmanagement.v1.LoadBalancerBackendInfo
	53, // 32: google.cloud.networkmanagement.v1.Step.storage_bucket:type_name -> google.cloud.networkmanagement.v1.StorageBucketInfo
	54, // 33: google.cloud.networkmanagement.v1.Step.serverless_neg:type_name -> google.cloud.networkmanagement.v1.ServerlessNegInfo
	2,  // 34: google.cloud.networkmanagement.v1.InstanceInfo.status:type_name -> google.cloud.networkmanagement.v1.InstanceInfo.Status
	3,  // 35: google.cloud.networkmanagement.v1.FirewallInfo.firewall_rule_type:type_name -> google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType
	4,  // 36: google.cloud.networkmanagement.v1.FirewallInfo.target_type:type_name -> google.cloud.networkmanagement.v1.FirewallInfo.TargetType
	5,  // 37: google.cloud.networkmanagement.v1.RouteInfo.route_type:type_name -> google.cloud.networkmanagement.v1.RouteInfo.RouteType
	6,  // 38: google.cloud.networkmanagement.v1.RouteInfo.next_hop_type:type_name -> google.cloud.networkmanagement.v1.RouteInfo.NextHopType
	7,  // 39: google.cloud.networkmanagement.v1.RouteInfo.route_scope:type_name -> google.cloud.networkmanagement.v1.RouteInfo.RouteScope
	8,  // 40: google.cloud.networkmanagement.v1.GoogleServiceInfo.google_service_type:type_name -> google.cloud.networkmanagement.v1.GoogleServiceInfo.GoogleServiceType
	9,  // 41: google.cloud.networkmanagement.v1.LoadBalancerInfo.load_balancer_type:type_name -> google.cloud.networkmanagement.v1.LoadBalancerInfo.LoadBalancerType
	30, // 42: google.cloud.networkmanagement.v1.LoadBalancerInfo.backends:type_name -> google.cloud.networkmanagement.v1.LoadBalancerBackend
	10, // 43: google.cloud.networkmanagement.v1.LoadBalancerInfo.backend_type:type_name -> google.cloud.networkmanagement.v1.LoadBalancerInfo.BackendType
	11, // 44: google.cloud.networkmanagement.v1.LoadBalancerBackend.health_check_firewall_state:type_name -> google.cloud.networkmanagement.v1.LoadBalancerBackend.HealthCheckFirewallState
	12, // 45: google.cloud.networkmanagement.v1.VpnTunnelInfo.routing_type:type_name -> google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType
	13, // 46: google.cloud.networkmanagement.v1.InterconnectAttachmentInfo.type:type_name -> google.cloud.networkmanagement.v1.InterconnectAttachmentInfo.Type
	14, // 47: google.cloud.networkmanagement.v1.DeliverInfo.target:type_name -> google.cloud.networkmanagement.v1.DeliverInfo.Target
	15, // 48: google.cloud.networkmanagement.v1.DeliverInfo.google_service_type:type_name -> google.cloud.networkmanagement.v1.DeliverInfo.GoogleServiceType
	16, // 49: google.cloud.networkmanagement.v1.ForwardInfo.target:type_name -> google.cloud.networkmanagement.v1.ForwardInfo.Target
	17, // 50: google.cloud.networkmanagement.v1.AbortInfo.cause:type_name -> google.cloud.networkmanagement.v1.AbortInfo.Cause
	18, // 51: google.cloud.networkmanagement.v1.DropInfo.cause:type_name -> google.cloud.networkmanagement.v1.DropInfo.Cause
	19, // 52: google.cloud.networkmanagement.v1.NatInfo.type:type_name -> google.cloud.networkmanagement.v1.NatInfo.Type
	20, // 53: google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.health_check_firewalls_config_state:type_name -> google.cloud.networkmanagement.v1.LoadBalancerBackendInfo.HealthCheckFirewallsConfigState
	54, // [54:54] is the sub-list for method output_type
	54, // [54:54] is the sub-list for method input_type
	54, // [54:54] is the sub-list for extension type_name
	54, // [54:54] is the sub-list for extension extendee
	0,  // [0:54] is the sub-list for field type_name
}

func init() { file_google_cloud_networkmanagement_v1_trace_proto_init() }
func file_google_cloud_networkmanagement_v1_trace_proto_init() {
	if File_google_cloud_networkmanagement_v1_trace_proto != nil {
		return
	}
	file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[1].OneofWrappers = []any{
		(*Step_Instance)(nil),
		(*Step_Firewall)(nil),
		(*Step_Route)(nil),
		(*Step_Endpoint)(nil),
		(*Step_GoogleService)(nil),
		(*Step_ForwardingRule)(nil),
		(*Step_HybridSubnet)(nil),
		(*Step_VpnGateway)(nil),
		(*Step_VpnTunnel)(nil),
		(*Step_InterconnectAttachment)(nil),
		(*Step_VpcConnector)(nil),
		(*Step_DirectVpcEgressConnection)(nil),
		(*Step_ServerlessExternalConnection)(nil),
		(*Step_Deliver)(nil),
		(*Step_Forward)(nil),
		(*Step_Abort)(nil),
		(*Step_Drop)(nil),
		(*Step_LoadBalancer)(nil),
		(*Step_Network)(nil),
		(*Step_GkeMaster)(nil),
		(*Step_CloudSqlInstance)(nil),
		(*Step_RedisInstance)(nil),
		(*Step_RedisCluster)(nil),
		(*Step_CloudFunction)(nil),
		(*Step_AppEngineVersion)(nil),
		(*Step_CloudRunRevision)(nil),
		(*Step_Nat)(nil),
		(*Step_ProxyConnection)(nil),
		(*Step_LoadBalancerBackendInfo)(nil),
		(*Step_StorageBucket)(nil),
		(*Step_ServerlessNeg)(nil),
	}
	file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[5].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkmanagement_v1_trace_proto_rawDesc,
			NumEnums:      21,
			NumMessages:   34,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_networkmanagement_v1_trace_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkmanagement_v1_trace_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkmanagement_v1_trace_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkmanagement_v1_trace_proto_msgTypes,
	}.Build()
	File_google_cloud_networkmanagement_v1_trace_proto = out.File
	file_google_cloud_networkmanagement_v1_trace_proto_rawDesc = nil
	file_google_cloud_networkmanagement_v1_trace_proto_goTypes = nil
	file_google_cloud_networkmanagement_v1_trace_proto_depIdxs = nil
}
