// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigValueTypeSlice(t *testing.T) {
	src := []*otlpprofiles.ValueType{}
	dest := []*otlpprofiles.ValueType{}
	// Test CopyTo empty
	dest = CopyOrigValueTypeSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.ValueType{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestValueTypeSlice()
	dest = CopyOrigValueTypeSlice(dest, src)
	assert.Equal(t, GenerateOrigTestValueTypeSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigValueTypeSlice(dest, src)
	assert.Equal(t, GenerateOrigTestValueTypeSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigValueTypeSlice(dest, []*otlpprofiles.ValueType{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigValueTypeSlice(dest, src)
	assert.Equal(t, GenerateOrigTestValueTypeSlice(), dest)
}
