// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlist"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlistitem"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
)

// AllowListUpdate is the builder for updating AllowList entities.
type AllowListUpdate struct {
	config
	hooks    []Hook
	mutation *AllowListMutation
}

// Where appends a list predicates to the AllowListUpdate builder.
func (alu *AllowListUpdate) Where(ps ...predicate.AllowList) *AllowListUpdate {
	alu.mutation.Where(ps...)
	return alu
}

// SetUpdatedAt sets the "updated_at" field.
func (alu *AllowListUpdate) SetUpdatedAt(t time.Time) *AllowListUpdate {
	alu.mutation.SetUpdatedAt(t)
	return alu
}

// SetName sets the "name" field.
func (alu *AllowListUpdate) SetName(s string) *AllowListUpdate {
	alu.mutation.SetName(s)
	return alu
}

// SetNillableName sets the "name" field if the given value is not nil.
func (alu *AllowListUpdate) SetNillableName(s *string) *AllowListUpdate {
	if s != nil {
		alu.SetName(*s)
	}
	return alu
}

// SetFromConsole sets the "from_console" field.
func (alu *AllowListUpdate) SetFromConsole(b bool) *AllowListUpdate {
	alu.mutation.SetFromConsole(b)
	return alu
}

// SetNillableFromConsole sets the "from_console" field if the given value is not nil.
func (alu *AllowListUpdate) SetNillableFromConsole(b *bool) *AllowListUpdate {
	if b != nil {
		alu.SetFromConsole(*b)
	}
	return alu
}

// SetDescription sets the "description" field.
func (alu *AllowListUpdate) SetDescription(s string) *AllowListUpdate {
	alu.mutation.SetDescription(s)
	return alu
}

// SetNillableDescription sets the "description" field if the given value is not nil.
func (alu *AllowListUpdate) SetNillableDescription(s *string) *AllowListUpdate {
	if s != nil {
		alu.SetDescription(*s)
	}
	return alu
}

// ClearDescription clears the value of the "description" field.
func (alu *AllowListUpdate) ClearDescription() *AllowListUpdate {
	alu.mutation.ClearDescription()
	return alu
}

// AddAllowlistItemIDs adds the "allowlist_items" edge to the AllowListItem entity by IDs.
func (alu *AllowListUpdate) AddAllowlistItemIDs(ids ...int) *AllowListUpdate {
	alu.mutation.AddAllowlistItemIDs(ids...)
	return alu
}

// AddAllowlistItems adds the "allowlist_items" edges to the AllowListItem entity.
func (alu *AllowListUpdate) AddAllowlistItems(a ...*AllowListItem) *AllowListUpdate {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return alu.AddAllowlistItemIDs(ids...)
}

// Mutation returns the AllowListMutation object of the builder.
func (alu *AllowListUpdate) Mutation() *AllowListMutation {
	return alu.mutation
}

// ClearAllowlistItems clears all "allowlist_items" edges to the AllowListItem entity.
func (alu *AllowListUpdate) ClearAllowlistItems() *AllowListUpdate {
	alu.mutation.ClearAllowlistItems()
	return alu
}

// RemoveAllowlistItemIDs removes the "allowlist_items" edge to AllowListItem entities by IDs.
func (alu *AllowListUpdate) RemoveAllowlistItemIDs(ids ...int) *AllowListUpdate {
	alu.mutation.RemoveAllowlistItemIDs(ids...)
	return alu
}

// RemoveAllowlistItems removes "allowlist_items" edges to AllowListItem entities.
func (alu *AllowListUpdate) RemoveAllowlistItems(a ...*AllowListItem) *AllowListUpdate {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return alu.RemoveAllowlistItemIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (alu *AllowListUpdate) Save(ctx context.Context) (int, error) {
	alu.defaults()
	return withHooks(ctx, alu.sqlSave, alu.mutation, alu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (alu *AllowListUpdate) SaveX(ctx context.Context) int {
	affected, err := alu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (alu *AllowListUpdate) Exec(ctx context.Context) error {
	_, err := alu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (alu *AllowListUpdate) ExecX(ctx context.Context) {
	if err := alu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (alu *AllowListUpdate) defaults() {
	if _, ok := alu.mutation.UpdatedAt(); !ok {
		v := allowlist.UpdateDefaultUpdatedAt()
		alu.mutation.SetUpdatedAt(v)
	}
}

func (alu *AllowListUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(allowlist.Table, allowlist.Columns, sqlgraph.NewFieldSpec(allowlist.FieldID, field.TypeInt))
	if ps := alu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := alu.mutation.UpdatedAt(); ok {
		_spec.SetField(allowlist.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := alu.mutation.Name(); ok {
		_spec.SetField(allowlist.FieldName, field.TypeString, value)
	}
	if value, ok := alu.mutation.FromConsole(); ok {
		_spec.SetField(allowlist.FieldFromConsole, field.TypeBool, value)
	}
	if value, ok := alu.mutation.Description(); ok {
		_spec.SetField(allowlist.FieldDescription, field.TypeString, value)
	}
	if alu.mutation.DescriptionCleared() {
		_spec.ClearField(allowlist.FieldDescription, field.TypeString)
	}
	if alu.mutation.AllowlistIDCleared() {
		_spec.ClearField(allowlist.FieldAllowlistID, field.TypeString)
	}
	if alu.mutation.AllowlistItemsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   allowlist.AllowlistItemsTable,
			Columns: allowlist.AllowlistItemsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlistitem.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := alu.mutation.RemovedAllowlistItemsIDs(); len(nodes) > 0 && !alu.mutation.AllowlistItemsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   allowlist.AllowlistItemsTable,
			Columns: allowlist.AllowlistItemsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlistitem.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := alu.mutation.AllowlistItemsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   allowlist.AllowlistItemsTable,
			Columns: allowlist.AllowlistItemsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlistitem.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, alu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{allowlist.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	alu.mutation.done = true
	return n, nil
}

// AllowListUpdateOne is the builder for updating a single AllowList entity.
type AllowListUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *AllowListMutation
}

// SetUpdatedAt sets the "updated_at" field.
func (aluo *AllowListUpdateOne) SetUpdatedAt(t time.Time) *AllowListUpdateOne {
	aluo.mutation.SetUpdatedAt(t)
	return aluo
}

// SetName sets the "name" field.
func (aluo *AllowListUpdateOne) SetName(s string) *AllowListUpdateOne {
	aluo.mutation.SetName(s)
	return aluo
}

// SetNillableName sets the "name" field if the given value is not nil.
func (aluo *AllowListUpdateOne) SetNillableName(s *string) *AllowListUpdateOne {
	if s != nil {
		aluo.SetName(*s)
	}
	return aluo
}

// SetFromConsole sets the "from_console" field.
func (aluo *AllowListUpdateOne) SetFromConsole(b bool) *AllowListUpdateOne {
	aluo.mutation.SetFromConsole(b)
	return aluo
}

// SetNillableFromConsole sets the "from_console" field if the given value is not nil.
func (aluo *AllowListUpdateOne) SetNillableFromConsole(b *bool) *AllowListUpdateOne {
	if b != nil {
		aluo.SetFromConsole(*b)
	}
	return aluo
}

// SetDescription sets the "description" field.
func (aluo *AllowListUpdateOne) SetDescription(s string) *AllowListUpdateOne {
	aluo.mutation.SetDescription(s)
	return aluo
}

// SetNillableDescription sets the "description" field if the given value is not nil.
func (aluo *AllowListUpdateOne) SetNillableDescription(s *string) *AllowListUpdateOne {
	if s != nil {
		aluo.SetDescription(*s)
	}
	return aluo
}

// ClearDescription clears the value of the "description" field.
func (aluo *AllowListUpdateOne) ClearDescription() *AllowListUpdateOne {
	aluo.mutation.ClearDescription()
	return aluo
}

// AddAllowlistItemIDs adds the "allowlist_items" edge to the AllowListItem entity by IDs.
func (aluo *AllowListUpdateOne) AddAllowlistItemIDs(ids ...int) *AllowListUpdateOne {
	aluo.mutation.AddAllowlistItemIDs(ids...)
	return aluo
}

// AddAllowlistItems adds the "allowlist_items" edges to the AllowListItem entity.
func (aluo *AllowListUpdateOne) AddAllowlistItems(a ...*AllowListItem) *AllowListUpdateOne {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return aluo.AddAllowlistItemIDs(ids...)
}

// Mutation returns the AllowListMutation object of the builder.
func (aluo *AllowListUpdateOne) Mutation() *AllowListMutation {
	return aluo.mutation
}

// ClearAllowlistItems clears all "allowlist_items" edges to the AllowListItem entity.
func (aluo *AllowListUpdateOne) ClearAllowlistItems() *AllowListUpdateOne {
	aluo.mutation.ClearAllowlistItems()
	return aluo
}

// RemoveAllowlistItemIDs removes the "allowlist_items" edge to AllowListItem entities by IDs.
func (aluo *AllowListUpdateOne) RemoveAllowlistItemIDs(ids ...int) *AllowListUpdateOne {
	aluo.mutation.RemoveAllowlistItemIDs(ids...)
	return aluo
}

// RemoveAllowlistItems removes "allowlist_items" edges to AllowListItem entities.
func (aluo *AllowListUpdateOne) RemoveAllowlistItems(a ...*AllowListItem) *AllowListUpdateOne {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return aluo.RemoveAllowlistItemIDs(ids...)
}

// Where appends a list predicates to the AllowListUpdate builder.
func (aluo *AllowListUpdateOne) Where(ps ...predicate.AllowList) *AllowListUpdateOne {
	aluo.mutation.Where(ps...)
	return aluo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (aluo *AllowListUpdateOne) Select(field string, fields ...string) *AllowListUpdateOne {
	aluo.fields = append([]string{field}, fields...)
	return aluo
}

// Save executes the query and returns the updated AllowList entity.
func (aluo *AllowListUpdateOne) Save(ctx context.Context) (*AllowList, error) {
	aluo.defaults()
	return withHooks(ctx, aluo.sqlSave, aluo.mutation, aluo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (aluo *AllowListUpdateOne) SaveX(ctx context.Context) *AllowList {
	node, err := aluo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (aluo *AllowListUpdateOne) Exec(ctx context.Context) error {
	_, err := aluo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (aluo *AllowListUpdateOne) ExecX(ctx context.Context) {
	if err := aluo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (aluo *AllowListUpdateOne) defaults() {
	if _, ok := aluo.mutation.UpdatedAt(); !ok {
		v := allowlist.UpdateDefaultUpdatedAt()
		aluo.mutation.SetUpdatedAt(v)
	}
}

func (aluo *AllowListUpdateOne) sqlSave(ctx context.Context) (_node *AllowList, err error) {
	_spec := sqlgraph.NewUpdateSpec(allowlist.Table, allowlist.Columns, sqlgraph.NewFieldSpec(allowlist.FieldID, field.TypeInt))
	id, ok := aluo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "AllowList.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := aluo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, allowlist.FieldID)
		for _, f := range fields {
			if !allowlist.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != allowlist.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := aluo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := aluo.mutation.UpdatedAt(); ok {
		_spec.SetField(allowlist.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := aluo.mutation.Name(); ok {
		_spec.SetField(allowlist.FieldName, field.TypeString, value)
	}
	if value, ok := aluo.mutation.FromConsole(); ok {
		_spec.SetField(allowlist.FieldFromConsole, field.TypeBool, value)
	}
	if value, ok := aluo.mutation.Description(); ok {
		_spec.SetField(allowlist.FieldDescription, field.TypeString, value)
	}
	if aluo.mutation.DescriptionCleared() {
		_spec.ClearField(allowlist.FieldDescription, field.TypeString)
	}
	if aluo.mutation.AllowlistIDCleared() {
		_spec.ClearField(allowlist.FieldAllowlistID, field.TypeString)
	}
	if aluo.mutation.AllowlistItemsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   allowlist.AllowlistItemsTable,
			Columns: allowlist.AllowlistItemsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlistitem.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aluo.mutation.RemovedAllowlistItemsIDs(); len(nodes) > 0 && !aluo.mutation.AllowlistItemsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   allowlist.AllowlistItemsTable,
			Columns: allowlist.AllowlistItemsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlistitem.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aluo.mutation.AllowlistItemsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   allowlist.AllowlistItemsTable,
			Columns: allowlist.AllowlistItemsPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlistitem.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &AllowList{config: aluo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, aluo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{allowlist.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	aluo.mutation.done = true
	return _node, nil
}
