/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.ProblemLocator;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@Incubating
@ServiceScope(value={Scope.BuildSession.class})
public class ExceptionProblemRegistry {
    private final Multimap<Throwable, InternalProblem> problemsForThrowables = Multimaps.synchronizedMultimap((Multimap)MultimapBuilder.linkedHashKeys().linkedHashSetValues().build());

    public void onProblem(Throwable exception, InternalProblem problem) {
        this.problemsForThrowables.put((Object)exception, (Object)problem);
    }

    public ProblemLocator getProblemLocator() {
        return new DefaultProblemLocator(this.problemsForThrowables);
    }

    private static class DefaultProblemLocator
    implements ProblemLocator {
        private final Multimap<Throwable, InternalProblem> problemsForThrowables;
        private Multimap<String, Throwable> exceptionLookup = null;

        DefaultProblemLocator(Multimap<Throwable, InternalProblem> problemsForThrowables) {
            this.problemsForThrowables = ImmutableMultimap.copyOf(problemsForThrowables);
        }

        Multimap<String, Throwable> exceptionLookup() {
            if (this.exceptionLookup == null) {
                this.exceptionLookup = DefaultProblemLocator.initLookup(this.problemsForThrowables.keySet());
            }
            return this.exceptionLookup;
        }

        private static Multimap<String, Throwable> initLookup(Set<Throwable> exceptions) {
            ArrayListMultimap lookup = ArrayListMultimap.create();
            for (Throwable exception : exceptions) {
                lookup.put((Object)DefaultProblemLocator.key(exception), (Object)exception);
            }
            return lookup;
        }

        private static String key(Throwable t) {
            return t.getClass().getName() + ":" + DefaultProblemLocator.messageOf(t);
        }

        private static String messageOf(Throwable t) {
            String result = "";
            try {
                String message = t.getMessage();
                result = message == null ? "" : message;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return result;
        }

        @Override
        public Collection<InternalProblem> findAll(Throwable t) {
            Throwable throwable = this.find(t);
            return throwable == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)this.problemsForThrowables.get((Object)throwable));
        }

        @Nullable
        private Throwable find(Throwable t) {
            try {
                if (this.problemsForThrowables.keySet().contains(t)) {
                    return t;
                }
                Collection candidates = this.exceptionLookup().get((Object)DefaultProblemLocator.key(t));
                for (Throwable candidate : candidates) {
                    if (!this.deepEquals(candidate, t, new ArrayList<Throwable>())) continue;
                    return candidate;
                }
            }
            catch (RuntimeException ignore) {
                return null;
            }
            return null;
        }

        private boolean deepEquals(Throwable t1, Throwable t2, List<Throwable> seen) {
            if (seen.contains(t1) || seen.contains(t2)) {
                return false;
            }
            if (t1 == null && t2 == null) {
                return true;
            }
            if (t1 == null || t2 == null) {
                return false;
            }
            if (!t1.getClass().equals(t2.getClass()) || !DefaultProblemLocator.messageOf(t1).equals(DefaultProblemLocator.messageOf(t2))) {
                return false;
            }
            StackTraceElement[] s1 = t1.getStackTrace();
            StackTraceElement[] s2 = t2.getStackTrace();
            for (int i = 0; i < s1.length && i < s2.length; ++i) {
                if (this.isStackTraceElementEquals(s1[i], s2[i])) continue;
                return false;
            }
            seen.add(t1);
            seen.add(t2);
            return this.deepEquals(t1.getCause(), t2.getCause(), seen);
        }

        private boolean isStackTraceElementEquals(StackTraceElement s1, StackTraceElement s2) {
            if (!s1.getClassName().equals(s2.getClassName())) {
                return false;
            }
            String s1File = s1.getFileName();
            String s2File = s2.getFileName();
            if (s1File == null && s2File != null || s1File != null && s2File == null) {
                return false;
            }
            if (s1File != null && s2File != null && !s1File.equals(s2File)) {
                return false;
            }
            return s1.getLineNumber() == s2.getLineNumber();
        }
    }
}

