## What's Changed

This release introduces a new configuration file format: `.tflint.json`. This is useful for workflows such as automatically generating configuration files.
Please note that in order to use the `.tflint.json`, enabled plugins must be built with SDK v0.23+.

From this release, Cosign signatures (`checksums.txt.keyless.sig` and `checksums.txt.pem`) are deprecated. They will not be included in future releases. If your installation scripts depend on them, please migrate to `gh attestation verify`.

### Enhancements
* Add JSON configuration file support by @rorychatterton in https://github.com/terraform-linters/tflint/pull/2391
* Report structured errors in JUnit and CheckStyle XML formatters by @bendrucker in https://github.com/terraform-linters/tflint/pull/2407

### Changes
* Alphabetize rulesets in version output by @bendrucker in https://github.com/terraform-linters/tflint/pull/2404
* release: Pin Cosign version and deprecate Cosign signatures by @wata727 in https://github.com/terraform-linters/tflint/pull/2405

### Bug Fixes
* fix: only read TF_VAR for root module by @bendrucker in https://github.com/terraform-linters/tflint/pull/2413

### Chores
* build(deps): Bump actions/attest-build-provenance from 2.4.0 to 3.0.0 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2376
* build(deps): Bump actions/setup-go from 5.5.0 to 6.0.0 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2377
* build(deps): Bump the go-x group with 3 updates by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2378
* build(deps): Bump github.com/spf13/afero from 1.14.0 to 1.15.0 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2380
* build(deps): Bump github.com/zclconf/go-cty from 1.16.4 to 1.17.0 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2379
* build(deps): Bump golang.org/x/net from 0.43.0 to 0.44.0 in the go-x group by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2381
* build(deps): Bump google.golang.org/grpc from 1.75.0 to 1.75.1 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2382
* build(deps): Bump github.com/sigstore/sigstore-go from 1.1.1 to 1.1.2 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2383
* build(deps): Bump sigstore/cosign-installer from 3.9.2 to 3.10.0 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2384
* build(deps): Bump mislav/bump-homebrew-formula-action from 3.5 to 3.6 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2388
* fix(script): GitHub API rate limit by @Sander0542 in https://github.com/terraform-linters/tflint/pull/2390
* Bump tflint-plugin-sdk to v0.23.0 by @wata727 in https://github.com/terraform-linters/tflint/pull/2393
* build(deps): Bump github.com/sigstore/sigstore-go from 1.1.2 to 1.1.3 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2394
* build(deps): Bump docker/login-action from 3.5.0 to 3.6.0 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2395
* build(deps): Bump the go-x group with 4 updates by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2397
* build(deps): Bump google.golang.org/grpc from 1.75.1 to 1.76.0 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2398
* build(deps): Bump sigstore/cosign-installer from 3.10.0 to 4.0.0 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2399
* build(deps): Bump golang.org/x/net from 0.45.0 to 0.46.0 in the go-x group by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2400
* build(deps): Bump github.com/terraform-linters/tflint-plugin-sdk from 0.23.0 to 0.23.1 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2402
* build(deps): Bump golangci/golangci-lint-action from 8.0.0 to 9.0.0 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2408
* build(deps): Bump docker/metadata-action from 5.8.0 to 5.9.0 by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2409
* build(deps): Bump golang.org/x/oauth2 from 0.32.0 to 0.33.0 in the go-x group by @dependabot[bot] in https://github.com/terraform-linters/tflint/pull/2410

## New Contributors
* @Sander0542 made their first contribution in https://github.com/terraform-linters/tflint/pull/2390
* @rorychatterton made their first contribution in https://github.com/terraform-linters/tflint/pull/2391

**Full Changelog**: https://github.com/terraform-linters/tflint/compare/v0.59.1...v0.60.0
