/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.velocity.VelocityContext;
import org.traccar.api.BaseResource;
import org.traccar.api.signature.TokenManager;
import org.traccar.mail.MailManager;
import org.traccar.model.User;
import org.traccar.notification.NotificationMessage;
import org.traccar.notification.TextTemplateFormatter;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="password")
@Produces(value={"application/json"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class PasswordResource
extends BaseResource {
    @Inject
    private MailManager mailManager;
    @Inject
    private TokenManager tokenManager;
    @Inject
    private TextTemplateFormatter textTemplateFormatter;

    @Path(value="reset")
    @PermitAll
    @POST
    public Response reset(@FormParam(value="email") String email) throws StorageException, MessagingException, GeneralSecurityException, IOException {
        User user = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Equals("email", email)));
        if (user != null) {
            VelocityContext velocityContext = this.textTemplateFormatter.prepareContext(this.permissionsService.getServer(), user);
            NotificationMessage fullMessage = this.textTemplateFormatter.formatMessage(velocityContext, "passwordReset", false);
            this.mailManager.sendMessage(user, true, fullMessage.subject(), fullMessage.body());
        }
        return Response.ok().build();
    }

    @Path(value="update")
    @PermitAll
    @POST
    public Response update(@FormParam(value="token") String token, @FormParam(value="password") String password) throws StorageException, GeneralSecurityException, IOException {
        long userId = this.tokenManager.verifyToken(token).getUserId();
        User user = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", userId)));
        if (user != null) {
            user.setPassword(password);
            this.storage.updateObject(user, new Request((Columns)new Columns.Include("hashedPassword", "salt"), new Condition.Equals("id", userId)));
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

