/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.time.Instant;
import java.util.List;
import java.util.function.Consumer;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.Document;
import org.springframework.data.mongodb.core.ChangeStreamEvent;
import org.springframework.data.mongodb.core.ChangeStreamOptions;
import org.springframework.data.mongodb.core.ReactiveChangeStreamOperation;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

class ReactiveChangeStreamOperationSupport
implements ReactiveChangeStreamOperation {
    private final ReactiveMongoTemplate template;

    ReactiveChangeStreamOperationSupport(ReactiveMongoTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveChangeStreamOperation.ReactiveChangeStream<T> changeStream(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveChangeStreamSupport<T>(this.template, domainType, domainType, null, null);
    }

    static class ReactiveChangeStreamSupport<T>
    implements ReactiveChangeStreamOperation.ReactiveChangeStream<T>,
    ReactiveChangeStreamOperation.ChangeStreamWithFilterAndProjection<T> {
        private final ReactiveMongoTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        @Nullable
        private final String collection;
        @Nullable
        private final ChangeStreamOptions options;

        private ReactiveChangeStreamSupport(ReactiveMongoTemplate template, Class<?> domainType, Class<T> returnType, @Nullable String collection, @Nullable ChangeStreamOptions options) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.collection = collection;
            this.options = options;
        }

        @Override
        public ReactiveChangeStreamOperation.ChangeStreamWithFilterAndProjection<T> watchCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection name must not be null nor empty");
            return new ReactiveChangeStreamSupport<T>(this.template, this.domainType, this.returnType, collection, this.options);
        }

        @Override
        public ReactiveChangeStreamOperation.ChangeStreamWithFilterAndProjection<T> watchCollection(Class<?> entityClass) {
            Assert.notNull(entityClass, (String)"Collection type not be null");
            return this.watchCollection(this.template.getCollectionName(entityClass));
        }

        @Override
        public ReactiveChangeStreamOperation.TerminatingChangeStream<T> resumeAt(Object token) {
            return this.withOptions(builder -> {
                if (token instanceof Instant) {
                    Instant instant = (Instant)token;
                    builder.resumeAt(instant);
                } else if (token instanceof BsonTimestamp) {
                    BsonTimestamp bsonTimestamp = (BsonTimestamp)token;
                    builder.resumeAt(bsonTimestamp);
                }
            });
        }

        @Override
        public ReactiveChangeStreamOperation.TerminatingChangeStream<T> resumeAfter(Object token) {
            Assert.isInstanceOf(BsonValue.class, (Object)token, (String)"Token must be a BsonValue");
            return this.withOptions(builder -> builder.resumeAfter((BsonValue)token));
        }

        @Override
        public ReactiveChangeStreamOperation.TerminatingChangeStream<T> startAfter(Object token) {
            Assert.isInstanceOf(BsonValue.class, (Object)token, (String)"Token must be a BsonValue");
            return this.withOptions(builder -> builder.startAfter((BsonValue)token));
        }

        @Override
        public ReactiveChangeStreamSupport<T> withOptions(Consumer<ChangeStreamOptions.ChangeStreamOptionsBuilder> optionsConsumer) {
            ChangeStreamOptions.ChangeStreamOptionsBuilder builder = this.initOptionsBuilder();
            optionsConsumer.accept(builder);
            return new ReactiveChangeStreamSupport<T>(this.template, this.domainType, this.returnType, this.collection, builder.build());
        }

        @Override
        public <R> ReactiveChangeStreamOperation.ChangeStreamWithFilterAndProjection<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"ResultType must not be null");
            return new ReactiveChangeStreamSupport<R>(this.template, this.domainType, resultType, this.collection, this.options);
        }

        @Override
        public ReactiveChangeStreamOperation.ChangeStreamWithFilterAndProjection<T> filter(Aggregation filter) {
            return this.withOptions(builder -> builder.filter(filter));
        }

        @Override
        public ReactiveChangeStreamOperation.ChangeStreamWithFilterAndProjection<T> filter(CriteriaDefinition by) {
            MatchOperation $match = Aggregation.match(by);
            TypedAggregation<?> aggregation = !Document.class.equals(this.domainType) ? Aggregation.newAggregation(this.domainType, $match) : Aggregation.newAggregation($match);
            return this.filter(aggregation);
        }

        @Override
        public Flux<ChangeStreamEvent<T>> listen() {
            return this.template.changeStream(this.collection, this.options != null ? this.options : ChangeStreamOptions.empty(), this.returnType);
        }

        private ChangeStreamOptions.ChangeStreamOptionsBuilder initOptionsBuilder() {
            ChangeStreamOptions.ChangeStreamOptionsBuilder builder = ChangeStreamOptions.builder();
            if (this.options == null) {
                return builder;
            }
            this.options.getFilter().ifPresent(it -> {
                if (it instanceof Aggregation) {
                    Aggregation aggregation = (Aggregation)it;
                    builder.filter(aggregation);
                } else {
                    builder.filter(((List)it).toArray(new Document[0]));
                }
            });
            this.options.getFullDocumentLookup().ifPresent(builder::fullDocumentLookup);
            this.options.getFullDocumentBeforeChangeLookup().ifPresent(builder::fullDocumentBeforeChangeLookup);
            this.options.getCollation().ifPresent(builder::collation);
            if (this.options.isResumeAfter()) {
                this.options.getResumeToken().ifPresent(builder::resumeAfter);
                this.options.getResumeBsonTimestamp().ifPresent(builder::resumeAfter);
            } else if (this.options.isStartAfter()) {
                this.options.getResumeToken().ifPresent(builder::startAfter);
            } else {
                this.options.getResumeTimestamp().ifPresent(builder::resumeAt);
                this.options.getResumeBsonTimestamp().ifPresent(builder::resumeAt);
            }
            return builder;
        }
    }
}

