/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;

public final class ExponentialScaler
implements Function<Double, Double>,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final ExponentialScaler SQR_SCALER = new ExponentialScaler(2.0);
    public static final ExponentialScaler SQRT_SCALER = new ExponentialScaler(0.5);
    private final double _a;
    private final double _b;
    private final double _c;

    public ExponentialScaler(double a, double b, double c) {
        this._a = a;
        this._b = b;
        this._c = c;
    }

    public ExponentialScaler(double b, double c) {
        this(1.0, b, c);
    }

    public ExponentialScaler(double c) {
        this(1.0, 0.0, c);
    }

    @Override
    public Double apply(Double value) {
        return Math.pow(this._a * value + this._b, this._c);
    }

    public int hashCode() {
        int hash = 17;
        hash += 31 * Double.hashCode(this._a) + 37;
        hash += 31 * Double.hashCode(this._b) + 37;
        return hash += 31 * Double.hashCode(this._c) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ExponentialScaler && Objects.equals(((ExponentialScaler)obj)._a, this._a) && Objects.equals(((ExponentialScaler)obj)._b, this._b) && Objects.equals(((ExponentialScaler)obj)._c, this._c);
    }

    public String toString() {
        return String.format("%s[a=%f, b=%f, c=%f]", this.getClass().getSimpleName(), this._a, this._b, this._c);
    }
}

