/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AbstractChromosome;
import io.jenetics.EnumGene;
import io.jenetics.internal.math.comb;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.internal.util.array;
import io.jenetics.internal.util.bit;
import io.jenetics.internal.util.reflect;
import io.jenetics.internal.util.require;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.MSeq;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class PermutationChromosome<T>
extends AbstractChromosome<EnumGene<T>>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private ISeq<T> _validAlleles;

    private PermutationChromosome(ISeq<EnumGene<T>> genes, Boolean valid) {
        super(genes);
        assert (!genes.isEmpty());
        this._validAlleles = ((EnumGene)genes.get(0)).getValidAlleles();
        this._valid = valid;
    }

    public PermutationChromosome(ISeq<EnumGene<T>> genes) {
        this(genes, null);
    }

    public ISeq<T> getValidAlleles() {
        return this._validAlleles;
    }

    @Override
    public boolean isValid() {
        if (this._valid == null) {
            byte[] check = bit.newArray(this._validAlleles.length());
            this._valid = this._genes.forAll(g -> !bit.getAndSet(check, g.getAlleleIndex()));
        }
        return this._valid;
    }

    @Override
    public PermutationChromosome<T> newInstance() {
        return PermutationChromosome.of(this._validAlleles, this.length());
    }

    @Override
    public PermutationChromosome<T> newInstance(ISeq<EnumGene<T>> genes) {
        return new PermutationChromosome<T>(genes);
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).value();
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(x$0 -> super.equals(x$0));
    }

    @Override
    public String toString() {
        return this._genes.asList().stream().map(g -> g.getAllele().toString()).collect(Collectors.joining("|"));
    }

    public static <T> PermutationChromosome<T> of(ISeq<? extends T> alleles, int length) {
        require.positive(length);
        if (length > alleles.size()) {
            throw new IllegalArgumentException(String.format("The sub-set size must be be greater then the base-set: %d > %d", length, alleles.size()));
        }
        int[] subset = array.shuffle(comb.subset(alleles.size(), length));
        ISeq<EnumGene<T>> genes = IntStream.of(subset).mapToObj(i -> EnumGene.of(i, alleles)).collect(ISeq.toISeq());
        return new PermutationChromosome<T>(genes, true);
    }

    public static <T> PermutationChromosome<T> of(ISeq<? extends T> alleles) {
        return PermutationChromosome.of(alleles, alleles.size());
    }

    @SafeVarargs
    public static <T> PermutationChromosome<T> of(T ... alleles) {
        return PermutationChromosome.of(ISeq.of(alleles));
    }

    public static PermutationChromosome<Integer> ofInteger(int length) {
        return PermutationChromosome.ofInteger(0, require.positive(length));
    }

    public static PermutationChromosome<Integer> ofInteger(int start, int end) {
        if (end <= start) {
            throw new IllegalArgumentException(String.format("end <= start: %d <= %d", end, start));
        }
        return PermutationChromosome.ofInteger(IntRange.of(start, end), end - start);
    }

    public static PermutationChromosome<Integer> ofInteger(IntRange range, int length) {
        return PermutationChromosome.of(range.stream().boxed().collect(ISeq.toISeq()), length);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this._validAlleles);
        for (EnumGene gene : this._genes) {
            out.writeInt(gene.getAlleleIndex());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._validAlleles = (ISeq)in.readObject();
        MSeq<EnumGene<T>> genes = MSeq.ofLength(this._validAlleles.length());
        for (int i = 0; i < this._validAlleles.length(); ++i) {
            genes.set(i, new EnumGene<T>(in.readInt(), this._validAlleles));
        }
        reflect.setField(this, "_genes", genes.toISeq());
    }
}

