/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.NumericGene;
import io.jenetics.engine.EvolutionResult;
import io.jenetics.engine.ExecutionTimeLimit;
import io.jenetics.engine.FitnessConvergenceLimit;
import io.jenetics.engine.FitnessThresholdLimit;
import io.jenetics.engine.GeneConvergenceLimit;
import io.jenetics.engine.PopulationConvergenceLimit;
import io.jenetics.engine.SteadyFitnessLimit;
import io.jenetics.internal.util.require;
import io.jenetics.stat.DoubleMoments;
import io.jenetics.util.NanoClock;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public final class Limits {
    private Limits() {
        require.noInstance();
    }

    public static Predicate<Object> infinite() {
        return result -> true;
    }

    public static Predicate<Object> byFixedGeneration(final long generation) {
        if (generation < 0L) {
            throw new IllegalArgumentException(String.format("The number of generations must greater than one, but was %d", generation));
        }
        return new Predicate<Object>(){
            private final AtomicLong _current = new AtomicLong();

            @Override
            public boolean test(Object o) {
                return this._current.incrementAndGet() <= generation;
            }
        };
    }

    public static <C extends Comparable<? super C>> Predicate<EvolutionResult<?, C>> bySteadyFitness(int generations) {
        return new SteadyFitnessLimit(generations);
    }

    public static Predicate<Object> byExecutionTime(Duration duration, Clock clock) {
        return new ExecutionTimeLimit(duration, clock);
    }

    public static Predicate<Object> byExecutionTime(Duration duration) {
        return Limits.byExecutionTime(duration, NanoClock.systemUTC());
    }

    public static <C extends Comparable<? super C>> Predicate<EvolutionResult<?, C>> byFitnessThreshold(C threshold) {
        return new FitnessThresholdLimit<C>(threshold);
    }

    public static <N extends Number> Predicate<EvolutionResult<?, N>> byFitnessConvergence(int shortFilterSize, int longFilterSize, BiPredicate<DoubleMoments, DoubleMoments> proceed) {
        return new FitnessConvergenceLimit(shortFilterSize, longFilterSize, proceed);
    }

    public static <N extends Number> Predicate<EvolutionResult<?, N>> byFitnessConvergence(int shortFilterSize, int longFilterSize, double epsilon) {
        if (epsilon < 0.0 || epsilon > 1.0) {
            throw new IllegalArgumentException(String.format("The given epsilon is not in the range [0, 1]: %f", epsilon));
        }
        return new FitnessConvergenceLimit(shortFilterSize, longFilterSize, (s, l) -> Limits.eps(s.getMean(), l.getMean()) >= epsilon);
    }

    private static double eps(double s, double l) {
        double div = Math.max(Math.abs(s), Math.abs(l));
        return Math.abs(s - l) / (div <= 1.0E-19 ? 1.0 : div);
    }

    public static <N extends Number> Predicate<EvolutionResult<?, N>> byPopulationConvergence(BiPredicate<Double, DoubleMoments> proceed) {
        return new PopulationConvergenceLimit(proceed);
    }

    public static <N extends Number> Predicate<EvolutionResult<?, N>> byPopulationConvergence(double epsilon) {
        if (epsilon < 0.0 || epsilon > 1.0) {
            throw new IllegalArgumentException(String.format("The given epsilon is not in the range [0, 1]: %f", epsilon));
        }
        return new PopulationConvergenceLimit((best, moments) -> Limits.eps(best, moments.getMean()) >= epsilon);
    }

    public static <G extends NumericGene<?, G>> Predicate<EvolutionResult<G, ?>> byGeneConvergence(Predicate<DoubleMoments> geneConvergence, double convergedGeneRate) {
        return new GeneConvergenceLimit(geneConvergence, convergedGeneRate);
    }

    public static <G extends NumericGene<?, G>> Predicate<EvolutionResult<G, ?>> byGeneConvergence(double convergenceRate, double convergedGeneRate) {
        return Limits.byGeneConvergence(stat -> stat.getMax() * convergenceRate <= stat.getMean(), convergedGeneRate);
    }
}

