/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

import io.jenetics.internal.util.IndexSorter;
import io.jenetics.internal.util.IntComparator;
import io.jenetics.internal.util.array;
import io.jenetics.util.Seq;
import java.util.Comparator;

final class HeapSorter
extends IndexSorter {
    static final HeapSorter INSTANCE = new HeapSorter();

    HeapSorter() {
    }

    @Override
    public <T> int[] sort(Seq<? extends T> array2, int[] indexes, Comparator<? super T> comparator) {
        for (int k = array2.size() / 2; k >= 0; --k) {
            HeapSorter.sink(array2, indexes, comparator, k, array2.size());
        }
        int i = array2.size();
        while (--i >= 1) {
            array.swap(indexes, 0, i);
            HeapSorter.sink(array2, indexes, comparator, 0, i);
        }
        return indexes;
    }

    private static <T> void sink(Seq<? extends T> array2, int[] indexes, Comparator<? super T> comparator, int start, int end) {
        int m = start;
        while (2 * m < end) {
            int j = 2 * m;
            if (j < end - 1 && comparator.compare(array2.get(indexes[j]), array2.get(indexes[j + 1])) > 0) {
                ++j;
            }
            if (comparator.compare(array2.get(indexes[m]), array2.get(indexes[j])) <= 0) break;
            array.swap(indexes, m, j);
            m = j;
        }
    }

    @Override
    public <T> int[] sort(T[] array2, int[] indexes, Comparator<? super T> comparator) {
        for (int k = array2.length / 2; k >= 0; --k) {
            HeapSorter.sink(array2, indexes, comparator, k, array2.length);
        }
        int i = array2.length;
        while (--i >= 1) {
            array.swap(indexes, 0, i);
            HeapSorter.sink(array2, indexes, comparator, 0, i);
        }
        return indexes;
    }

    private static <T> void sink(T[] array2, int[] indexes, Comparator<? super T> comparator, int start, int end) {
        int m = start;
        while (2 * m < end) {
            int j = 2 * m;
            if (j < end - 1 && comparator.compare(array2[indexes[j]], array2[indexes[j + 1]]) > 0) {
                ++j;
            }
            if (comparator.compare(array2[indexes[m]], array2[indexes[j]]) <= 0) break;
            array.swap(indexes, m, j);
            m = j;
        }
    }

    @Override
    public int[] sort(int[] array2, int[] indexes, IntComparator comparator) {
        for (int k = array2.length / 2; k >= 0; --k) {
            HeapSorter.sink(array2, indexes, comparator, k, array2.length);
        }
        int i = array2.length;
        while (--i >= 1) {
            array.swap(indexes, 0, i);
            HeapSorter.sink(array2, indexes, comparator, 0, i);
        }
        return indexes;
    }

    private static void sink(int[] array2, int[] indexes, IntComparator comparator, int start, int end) {
        int m = start;
        while (2 * m < end) {
            int j = 2 * m;
            if (j < end - 1 && comparator.compare(array2[indexes[j]], array2[indexes[j + 1]]) > 0) {
                ++j;
            }
            if (comparator.compare(array2[indexes[m]], array2[indexes[j]]) <= 0) break;
            array.swap(indexes, m, j);
            m = j;
        }
    }

    @Override
    public int[] sort(long[] array2, int[] indexes) {
        for (int k = array2.length / 2; k >= 0; --k) {
            HeapSorter.sink(array2, indexes, k, array2.length);
        }
        int i = array2.length;
        while (--i >= 1) {
            array.swap(indexes, 0, i);
            HeapSorter.sink(array2, indexes, 0, i);
        }
        return indexes;
    }

    private static void sink(long[] array2, int[] indexes, int start, int end) {
        int m = start;
        while (2 * m < end) {
            int j = 2 * m;
            if (j < end - 1 && array2[indexes[j]] > array2[indexes[j + 1]]) {
                ++j;
            }
            if (array2[indexes[m]] <= array2[indexes[j]]) break;
            array.swap(indexes, m, j);
            m = j;
        }
    }

    @Override
    public int[] sort(double[] array2, int[] indexes) {
        for (int k = array2.length / 2; k >= 0; --k) {
            HeapSorter.sink(array2, indexes, k, array2.length);
        }
        int i = array2.length;
        while (--i >= 1) {
            array.swap(indexes, 0, i);
            HeapSorter.sink(array2, indexes, 0, i);
        }
        return indexes;
    }

    private static void sink(double[] array2, int[] indexes, int start, int end) {
        int m = start;
        while (2 * m < end) {
            int j = 2 * m;
            if (j < end - 1 && array2[indexes[j]] > array2[indexes[j + 1]]) {
                ++j;
            }
            if (array2[indexes[m]] <= array2[indexes[j]]) break;
            array.swap(indexes, m, j);
            m = j;
        }
    }
}

