/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

public final class require {
    private require() {
        require.noInstance();
    }

    public static void noInstance() {
        String message = "Object instantiation is not allowed";
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length >= 3) {
            message = String.format("Instantiation of '%s' is not allowed.", trace[2].getClassName());
        }
        throw new AssertionError((Object)message);
    }

    public static double nonNegative(double value, String message) {
        if (value < 0.0) {
            throw new IllegalArgumentException(String.format("%s must not be negative: %f.", message, value));
        }
        return value;
    }

    public static double nonNegative(double value) {
        return require.nonNegative(value, "Value");
    }

    public static int nonNegative(int length) {
        if (length < 0) {
            throw new NegativeArraySizeException("Length must be greater than zero, but was " + length + ". ");
        }
        return length;
    }

    public static int positive(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException(String.format("Value is not positive: %d", value));
        }
        return value;
    }

    public static long positive(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException(String.format("Value is not positive: %d", value));
        }
        return value;
    }

    public static double probability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException(String.format("The given probability is not in the range [0, 1]: %f", p));
        }
        return p;
    }
}

