/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sampler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.netbeans.modules.sampler.Sampler;
import org.netbeans.modules.sampler.SamplesOutputStream;

class CLISampler
extends Sampler {
    private final ThreadMXBean threadMXBean;
    private final File output;

    public static void main(String ... stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.out.println("Usage: <port> <snapshot.npss>");
            System.out.println();
            System.out.println("First of all start your application with following parameters:");
            System.out.println("  -Dcom.sun.management.jmxremote.authenticate=false");
            System.out.println("  -Dcom.sun.management.jmxremote.ssl=false");
            System.out.println("  -Dcom.sun.management.jmxremote.port=<port>");
            System.out.println("Then you can start this sampler with correct port and file to write snapshot to.");
            System.exit(1);
        }
        if (!SamplesOutputStream.isSupported()) {
            System.err.println("Sampling is not supported by JVM");
            System.exit(2);
        }
        String string = stringArray[0];
        try {
            string = "service:jmx:rmi:///jndi/rmi://localhost:" + Integer.parseInt(stringArray[0]) + "/jmxrmi";
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        System.err.println("Connecting to " + string);
        JMXServiceURL jMXServiceURL = new JMXServiceURL(string);
        JMXConnector jMXConnector = null;
        Throwable throwable = null;
        for (int i = 0; i < 100; ++i) {
            try {
                jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, null);
                break;
            }
            catch (IOException iOException) {
                throwable = iOException;
                System.err.println("Connection failed. Will retry in 300ms.");
                Thread.sleep(300L);
                continue;
            }
        }
        if (jMXConnector == null) {
            throwable.printStackTrace();
            System.err.println("Cannot connect to " + string);
            System.exit(3);
        }
        MBeanServerConnection mBeanServerConnection = jMXConnector.getMBeanServerConnection();
        ThreadMXBean threadMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=Threading", ThreadMXBean.class);
        File file = new File(stringArray[1]);
        CLISampler cLISampler = new CLISampler(threadMXBean, file);
        cLISampler.start();
        System.out.println("Press enter to generate sample into " + file);
        System.in.read();
        cLISampler.stop();
        System.out.println();
        System.out.println("Sample written to " + file);
        System.exit(0);
    }

    CLISampler(ThreadMXBean threadMXBean, File file) {
        super("CLISampler");
        this.threadMXBean = threadMXBean;
        this.output = file;
    }

    @Override
    protected ThreadMXBean getThreadMXBean() {
        return this.threadMXBean;
    }

    @Override
    protected void saveSnapshot(byte[] byArray) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.output);){
            fileOutputStream.write(byArray);
        }
    }

    @Override
    protected void printStackTrace(Throwable throwable) {
        throwable.printStackTrace();
        System.exit(2);
    }

    @Override
    protected void openProgress(int n) {
    }

    @Override
    protected void closeProgress() {
    }

    @Override
    protected void progress(int n) {
        System.out.print("#");
        System.out.flush();
    }
}

