/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.web.common.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.AbstractFirReflectionApiCallChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0007\u001a\u00020\u0003H\u0014R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ!\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0014R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0012J/\u0010\u0013\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014R\u00020\bR\u00020\u0015j\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirWebReflectionAPICallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/AbstractFirReflectionApiCallChecker;", "isWasm", "", "<init>", "(Z)V", "()Z", "isWholeReflectionApiAvailable", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "isAllowedKClassMember", "name", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/name/Name;)Z", "isAllowedReflectionApi", "containingClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/name/ClassId;)Z", "report", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkers.web.common"})
public final class FirWebReflectionAPICallChecker
extends AbstractFirReflectionApiCallChecker {
    private final boolean isWasm;

    public FirWebReflectionAPICallChecker(boolean isWasm) {
        this.isWasm = isWasm;
    }

    public final boolean isWasm() {
        return this.isWasm;
    }

    @Override
    protected boolean isWholeReflectionApiAvailable(@NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isAllowedKClassMember(@NotNull CheckerContext context2, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(name2, "name");
        if (super.isAllowedKClassMember(context2, name2)) return true;
        if (!Intrinsics.areEqual(name2, AbstractFirReflectionApiCallChecker.getK_CLASS_IS_INTERFACE_NAME())) return false;
        return true;
    }

    @Override
    protected boolean isAllowedReflectionApi(@NotNull CheckerContext context2, @NotNull Name name2, @NotNull ClassId containingClassId) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(containingClassId, "containingClassId");
        return super.isAllowedReflectionApi(context2, name2, containingClassId) || StandardClassIds.Annotations.INSTANCE.getAssociatedObjectAnnotations().contains(containingClassId) || Intrinsics.areEqual(name2, StandardNames.FqNames.findAssociatedObject.shortName());
    }

    @Override
    protected void report(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement source) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        String backend = this.isWasm ? "Wasm" : "JS";
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirWebCommonErrors.INSTANCE.getUNSUPPORTED_REFLECTION_API(), (Object)("This reflection API is not supported in Kotlin/" + backend + '.'), null, 16, null);
    }
}

