/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheCleanupStrategyFactory;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.streams.DefaultValueStore;
import org.gradle.cache.internal.streams.ValueStore;
import org.gradle.cache.scopes.BuildTreeScopedCacheBuilderFactory;
import org.gradle.internal.cc.impl.ConfigurationCacheRepository;
import org.gradle.internal.cc.impl.ConfigurationCacheRepositoryKt;
import org.gradle.internal.cc.impl.ConfigurationCacheStateFile;
import org.gradle.internal.cc.impl.ConfigurationCacheStateStore;
import org.gradle.internal.cc.impl.StateType;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.extensions.stdlib.UnsafeLazyKt;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.time.TimestampSuppliers;
import org.jetbrains.annotations.NotNull;

@ServiceScope(value={Scope.BuildSession.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u000b\b\u0001\u0018\u00002\u00020\u0001:\u00072345678B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001f\u0010\u0010\u001a\u00020\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\b\u0015J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0002J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020(H\u0002J3\u0010,\u001a\u0002H-\"\b\b\u0000\u0010-*\u00020.2\u0006\u0010/\u001a\u00020(2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002H-0\u0013H\u0002\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#\u00a8\u00069"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository;", "Lorg/gradle/internal/concurrent/Stoppable;", "cacheBuilderFactory", "Lorg/gradle/cache/scopes/BuildTreeScopedCacheBuilderFactory;", "cacheCleanupStrategyFactory", "Lorg/gradle/cache/CacheCleanupStrategyFactory;", "fileAccessTimeJournal", "Lorg/gradle/internal/file/FileAccessTimeJournal;", "fileSystem", "Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;", "<init>", "(Lorg/gradle/cache/scopes/BuildTreeScopedCacheBuilderFactory;Lorg/gradle/cache/CacheCleanupStrategyFactory;Lorg/gradle/internal/file/FileAccessTimeJournal;Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;)V", "forKey", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore;", "cacheKey", "", "withExclusiveCleanupAccess", "", "action", "Lkotlin/Function1;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$CleanupContext;", "Lkotlin/ExtensionFunctionType;", "cleanupDepth", "", "cleanupMaxAgeDays", "cache", "Lorg/gradle/cache/PersistentCache;", "stop", "withLruCacheCleanup", "Lorg/gradle/cache/CacheBuilder;", "cleanupEligibleFilesFinder", "Lorg/gradle/cache/internal/SingleDepthFilesFinder;", "fileAccessTracker", "Lorg/gradle/internal/file/impl/SingleDepthFileAccessTracker;", "getFileAccessTracker", "()Lorg/gradle/internal/file/impl/SingleDepthFileAccessTracker;", "fileAccessTracker$delegate", "Lkotlin/Lazy;", "chmod", "file", "Ljava/io/File;", "mode", "markAccessed", "stateFile", "withExclusiveAccessToCache", "T", "", "baseDir", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "dirForEntry", "CleanupContext", "Layout", "WriteableLayout", "ReadableLayout", "ReadableConfigurationCacheStateFile", "WriteableConfigurationCacheStateFile", "StoreImpl", "configuration-cache"})
public final class ConfigurationCacheRepository
implements Stoppable {
    @NotNull
    private final CacheCleanupStrategyFactory cacheCleanupStrategyFactory;
    @NotNull
    private final FileAccessTimeJournal fileAccessTimeJournal;
    @NotNull
    private final FileSystem fileSystem;
    private final int cleanupDepth;
    private final int cleanupMaxAgeDays;
    @NotNull
    private final PersistentCache cache;
    @NotNull
    private final Lazy fileAccessTracker$delegate;

    public ConfigurationCacheRepository(@NotNull BuildTreeScopedCacheBuilderFactory cacheBuilderFactory, @NotNull CacheCleanupStrategyFactory cacheCleanupStrategyFactory, @NotNull FileAccessTimeJournal fileAccessTimeJournal, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)cacheBuilderFactory, (String)"cacheBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)cacheCleanupStrategyFactory, (String)"cacheCleanupStrategyFactory");
        Intrinsics.checkNotNullParameter((Object)fileAccessTimeJournal, (String)"fileAccessTimeJournal");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.cacheCleanupStrategyFactory = cacheCleanupStrategyFactory;
        this.fileAccessTimeJournal = fileAccessTimeJournal;
        this.fileSystem = fileSystem;
        this.cleanupDepth = 1;
        this.cleanupMaxAgeDays = 7;
        CacheBuilder cacheBuilder = cacheBuilderFactory.createCrossVersionCacheBuilder("configuration-cache").withDisplayName("Configuration Cache").withInitialLockMode(FileLockManager.LockMode.OnDemand);
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilder, (String)"withInitialLockMode(...)");
        PersistentCache persistentCache = this.withLruCacheCleanup(cacheBuilder).open();
        Intrinsics.checkNotNullExpressionValue((Object)persistentCache, (String)"open(...)");
        this.cache = persistentCache;
        this.fileAccessTracker$delegate = UnsafeLazyKt.unsafeLazy(() -> ConfigurationCacheRepository.fileAccessTracker_delegate$lambda$0(this));
    }

    @NotNull
    public final ConfigurationCacheStateStore forKey(@NotNull String cacheKey) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return new StoreImpl(this.dirForEntry(cacheKey));
    }

    public final void withExclusiveCleanupAccess(@NotNull Function1<? super CleanupContext, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.cache.withFileLock(new Runnable(action, this){
            final /* synthetic */ Function1<CleanupContext, Unit> $action;
            final /* synthetic */ ConfigurationCacheRepository this$0;
            {
                this.$action = $action;
                this.this$0 = $receiver;
            }

            public final void run() {
                this.$action.invoke((Object)new CleanupContext(this.this$0){
                    final /* synthetic */ ConfigurationCacheRepository this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public FilesFinder getEligibleFilesFinder() {
                        return (FilesFinder)ConfigurationCacheRepository.access$cleanupEligibleFilesFinder(this.this$0);
                    }

                    public File dirForEntry(String entry) {
                        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                        return ConfigurationCacheRepository.access$dirForEntry(this.this$0, entry);
                    }

                    public void applyCleanupAction(CleanupAction action, CleanupProgressMonitor monitor) {
                        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
                        action.clean((CleanableStore)ConfigurationCacheRepository.access$getCache$p(this.this$0), monitor);
                    }
                });
            }
        });
    }

    public void stop() {
        this.cache.close();
    }

    private final CacheBuilder withLruCacheCleanup(CacheBuilder $this$withLruCacheCleanup) {
        CacheBuilder cacheBuilder = $this$withLruCacheCleanup.withCleanupStrategy(this.cacheCleanupStrategyFactory.daily((CleanupAction)new LeastRecentlyUsedCacheCleanup((FilesFinder)this.cleanupEligibleFilesFinder(), this.fileAccessTimeJournal, TimestampSuppliers.daysAgo((int)this.cleanupMaxAgeDays))));
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilder, (String)"withCleanupStrategy(...)");
        return cacheBuilder;
    }

    private final SingleDepthFilesFinder cleanupEligibleFilesFinder() {
        return new SingleDepthFilesFinder(this.cleanupDepth);
    }

    private final SingleDepthFileAccessTracker getFileAccessTracker() {
        Lazy lazy = this.fileAccessTracker$delegate;
        return (SingleDepthFileAccessTracker)lazy.getValue();
    }

    private final void chmod(File file, int mode) {
        this.fileSystem.chmod(file, mode);
    }

    private final void markAccessed(File stateFile) {
        this.getFileAccessTracker().markAccessed(stateFile);
    }

    private final <T> T withExclusiveAccessToCache(File baseDir, Function1<? super File, ? extends T> action) {
        Object object = this.cache.withFileLock(new Supplier(action, baseDir){
            final /* synthetic */ Function1<File, T> $action;
            final /* synthetic */ File $baseDir;
            {
                this.$action = $action;
                this.$baseDir = $baseDir;
            }

            public final T get() {
                return (T)this.$action.invoke((Object)this.$baseDir);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"withFileLock(...)");
        return (T)object;
    }

    private final File dirForEntry(String cacheKey) {
        File file = this.cache.getBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBaseDir(...)");
        return FilesKt.resolve((File)file, (String)cacheKey);
    }

    private static final SingleDepthFileAccessTracker fileAccessTracker_delegate$lambda$0(ConfigurationCacheRepository this$0) {
        return new SingleDepthFileAccessTracker(this$0.fileAccessTimeJournal, this$0.cache.getBaseDir(), this$0.cleanupDepth);
    }

    public static final /* synthetic */ SingleDepthFilesFinder access$cleanupEligibleFilesFinder(ConfigurationCacheRepository $this) {
        return $this.cleanupEligibleFilesFinder();
    }

    public static final /* synthetic */ File access$dirForEntry(ConfigurationCacheRepository $this, String cacheKey) {
        return $this.dirForEntry(cacheKey);
    }

    public static final /* synthetic */ PersistentCache access$getCache$p(ConfigurationCacheRepository $this) {
        return $this.cache;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010\u00c0\u0006\u0003"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$CleanupContext;", "", "eligibleFilesFinder", "Lorg/gradle/cache/internal/FilesFinder;", "getEligibleFilesFinder", "()Lorg/gradle/cache/internal/FilesFinder;", "dirForEntry", "Ljava/io/File;", "entry", "", "applyCleanupAction", "", "action", "Lorg/gradle/cache/CleanupAction;", "monitor", "Lorg/gradle/cache/CleanupProgressMonitor;", "configuration-cache"})
    public static interface CleanupContext {
        @NotNull
        public FilesFinder getEligibleFilesFinder();

        @NotNull
        public File dirForEntry(@NotNull String var1);

        public void applyCleanupAction(@NotNull CleanupAction var1, @NotNull CleanupProgressMonitor var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$Layout;", "", "<init>", "()V", "fileForRead", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "fileFor", "configuration-cache"})
    public static abstract class Layout {
        @NotNull
        public abstract ConfigurationCacheStateFile fileForRead(@NotNull StateType var1);

        @NotNull
        public abstract ConfigurationCacheStateFile fileFor(@NotNull StateType var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$ReadableConfigurationCacheStateFile;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "file", "Ljava/io/File;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "onFileAccess", "Lkotlin/Function1;", "", "<init>", "(Ljava/io/File;Lorg/gradle/internal/cc/impl/StateType;Lkotlin/jvm/functions/Function1;)V", "getStateType", "()Lorg/gradle/internal/cc/impl/StateType;", "exists", "", "getExists", "()Z", "stateFile", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore$StateFile;", "getStateFile", "()Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore$StateFile;", "outputStream", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "delete", "moveFrom", "stateFileForIncludedBuild", "build", "Lorg/gradle/api/internal/BuildDefinition;", "relatedStateFile", "path", "Lorg/gradle/util/Path;", "stateFileForSharedObjects", "configuration-cache"})
    public static final class ReadableConfigurationCacheStateFile
    implements ConfigurationCacheStateFile {
        @NotNull
        private final File file;
        @NotNull
        private final StateType stateType;
        @NotNull
        private final Function1<File, Unit> onFileAccess;

        public ReadableConfigurationCacheStateFile(@NotNull File file, @NotNull StateType stateType, @NotNull Function1<? super File, Unit> onFileAccess) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Intrinsics.checkNotNullParameter(onFileAccess, (String)"onFileAccess");
            this.file = file;
            this.stateType = stateType;
            this.onFileAccess = onFileAccess;
        }

        @Override
        @NotNull
        public StateType getStateType() {
            return this.stateType;
        }

        @Override
        public boolean getExists() {
            return this.file.isFile();
        }

        @Override
        @NotNull
        public ConfigurationCacheStateStore.StateFile getStateFile() {
            return new ConfigurationCacheStateStore.StateFile(this.getStateType(), this.file);
        }

        @Override
        @NotNull
        public OutputStream outputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public InputStream inputStream() {
            File file = this.file;
            this.onFileAccess.invoke((Object)file);
            return new FileInputStream(file);
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void moveFrom(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile stateFileForIncludedBuild(@NotNull BuildDefinition build) {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            return new ReadableConfigurationCacheStateFile(ConfigurationCacheRepositoryKt.access$includedBuildFileFor(this.file, build), this.getStateType(), this.onFileAccess);
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile relatedStateFile(@NotNull org.gradle.util.Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new ReadableConfigurationCacheStateFile(ConfigurationCacheRepositoryKt.access$relatedStateFileFor(this.file, path), this.getStateType(), this.onFileAccess);
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile stateFileForSharedObjects() {
            return new ReadableConfigurationCacheStateFile(ConfigurationCacheRepositoryKt.access$sharedObjectsFileFor(this.file), StateType.WorkShared, this.onFileAccess);
        }

        @Override
        @NotNull
        public String getName() {
            return ConfigurationCacheStateFile.super.getName();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$ReadableLayout;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$Layout;", "cacheDir", "Ljava/io/File;", "onFileAccess", "Lkotlin/Function1;", "", "<init>", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)V", "fileForRead", "Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$ReadableConfigurationCacheStateFile;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "fileFor", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "configuration-cache"})
    public static final class ReadableLayout
    extends Layout {
        @NotNull
        private final File cacheDir;
        @NotNull
        private final Function1<File, Unit> onFileAccess;

        public ReadableLayout(@NotNull File cacheDir, @NotNull Function1<? super File, Unit> onFileAccess) {
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            Intrinsics.checkNotNullParameter(onFileAccess, (String)"onFileAccess");
            this.cacheDir = cacheDir;
            this.onFileAccess = onFileAccess;
        }

        @Override
        @NotNull
        public ReadableConfigurationCacheStateFile fileForRead(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return ConfigurationCacheRepositoryKt.readableConfigurationCacheStateFile(this.cacheDir, stateType, this.onFileAccess);
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile fileFor(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return ConfigurationCacheRepositoryKt.readableConfigurationCacheStateFile(this.cacheDir, stateType, this.onFileAccess);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J8\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\u0004\b\u0000\u0010\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010H\u0016J4\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\f0\u0012\"\b\b\u0000\u0010\f*\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\f0\u0015H\u0016J1\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\f0\u0012\"\b\b\u0000\u0010\f*\u00020\u00132\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\f0\u0015\u00a2\u0006\u0002\b\u0018H\u0016J-\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\f0\u0012\"\u0004\b\u0000\u0010\f2\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\f0\u0015\u00a2\u0006\u0002\b\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$StoreImpl;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore;", "baseDir", "Ljava/io/File;", "<init>", "(Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository;Ljava/io/File;)V", "assignSpoolFile", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore$StateFile;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "createValueStore", "Lorg/gradle/cache/internal/streams/ValueStore;", "T", "writer", "Lorg/gradle/cache/internal/streams/ValueStore$Writer;", "reader", "Lorg/gradle/cache/internal/streams/ValueStore$Reader;", "useForStateLoad", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore$StateAccessResult;", "", "action", "Lkotlin/Function1;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$Layout;", "Lkotlin/ExtensionFunctionType;", "useForStore", "configuration-cache"})
    @SourceDebugExtension(value={"SMAP\nConfigurationCacheRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheRepository.kt\norg/gradle/internal/cc/impl/ConfigurationCacheRepository$StoreImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,366:1\n1321#2,2:367\n*S KotlinDebug\n*F\n+ 1 ConfigurationCacheRepository.kt\norg/gradle/internal/cc/impl/ConfigurationCacheRepository$StoreImpl\n*L\n259#1:367,2\n*E\n"})
    private final class StoreImpl
    implements ConfigurationCacheStateStore {
        @NotNull
        private final File baseDir;

        public StoreImpl(File baseDir) {
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            this.baseDir = baseDir;
        }

        @Override
        @NotNull
        public ConfigurationCacheStateStore.StateFile assignSpoolFile(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Files.createDirectories(this.baseDir.toPath(), new FileAttribute[0]);
            Path tempFile = Files.createTempFile(this.baseDir.toPath(), ConfigurationCacheRepositoryKt.access$getFileBaseName(stateType), ".tmp", new FileAttribute[0]);
            File file = tempFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return new ConfigurationCacheStateStore.StateFile(stateType, file);
        }

        @Override
        @NotNull
        public <T> ValueStore<T> createValueStore(@NotNull StateType stateType, @NotNull ValueStore.Writer<T> writer2, @NotNull ValueStore.Reader<T> reader2) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Intrinsics.checkNotNullParameter(writer2, (String)"writer");
            Intrinsics.checkNotNullParameter(reader2, (String)"reader");
            return (ValueStore)new DefaultValueStore(this.baseDir, ConfigurationCacheRepositoryKt.access$getFileBaseName(stateType), writer2, reader2);
        }

        @Override
        @NotNull
        public <T> ConfigurationCacheStateStore.StateAccessResult<T> useForStateLoad(@NotNull StateType stateType, @NotNull Function1<? super ConfigurationCacheStateFile, ? extends T> action) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return this.useForStateLoad(arg_0 -> StoreImpl.useForStateLoad$lambda$0(action, stateType, arg_0));
        }

        @Override
        @NotNull
        public <T> ConfigurationCacheStateStore.StateAccessResult<T> useForStateLoad(@NotNull Function1<? super Layout, ? extends T> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return (ConfigurationCacheStateStore.StateAccessResult)ConfigurationCacheRepository.this.withExclusiveAccessToCache(this.baseDir, arg_0 -> StoreImpl.useForStateLoad$lambda$1(ConfigurationCacheRepository.this, action, arg_0));
        }

        @Override
        @NotNull
        public <T> ConfigurationCacheStateStore.StateAccessResult<T> useForStore(@NotNull Function1<? super Layout, ? extends T> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return (ConfigurationCacheStateStore.StateAccessResult)ConfigurationCacheRepository.this.withExclusiveAccessToCache(this.baseDir, arg_0 -> StoreImpl.useForStore$lambda$4(ConfigurationCacheRepository.this, action, arg_0));
        }

        private static final Object useForStateLoad$lambda$0(Function1 $action, StateType $stateType, Layout $this$useForStateLoad) {
            Intrinsics.checkNotNullParameter((Object)$this$useForStateLoad, (String)"$this$useForStateLoad");
            return $action.invoke((Object)$this$useForStateLoad.fileFor($stateType));
        }

        private static final ConfigurationCacheStateStore.StateAccessResult useForStateLoad$lambda$1(ConfigurationCacheRepository this$0, Function1 $action, File cacheDir) {
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            this$0.markAccessed(cacheDir);
            List stateFiles = Collections.synchronizedList(new ArrayList());
            Object actionResult2 = $action.invoke((Object)new ReadableLayout(cacheDir, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(stateFiles){

                public final void invoke(File p0) {
                    ((List)this.receiver).add(p0);
                }
            })));
            Intrinsics.checkNotNull(stateFiles);
            return new ConfigurationCacheStateStore.StateAccessResult<Object>(actionResult2, CollectionsKt.toList((Iterable)stateFiles));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private static final ConfigurationCacheStateStore.StateAccessResult useForStore$lambda$4(ConfigurationCacheRepository this$0, Function1 $action, File cacheDir) {
            void $this$forEach$iv;
            Object object;
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            if (!cacheDir.isDirectory()) {
                Files.createDirectories(cacheDir.toPath(), new FileAttribute[0]);
                this$0.chmod(cacheDir, 448);
            }
            this$0.markAccessed(cacheDir);
            List stateFiles = Collections.synchronizedList(new ArrayList());
            WriteableLayout layout2 = new WriteableLayout(cacheDir, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(stateFiles){

                public final void invoke(File p0) {
                    ((List)this.receiver).add(p0);
                }
            }));
            try {
                object = $action.invoke((Object)layout2);
            }
            catch (Throwable throwable) {
                void $this$forEach$iv2;
                Intrinsics.checkNotNull(stateFiles);
                Sequence $i$f$forEach = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)stateFiles), (Function1)useForStore.1.actionResult.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    this$0.chmod(it, 384);
                }
                throw throwable;
            }
            Intrinsics.checkNotNull(stateFiles);
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)stateFiles), (Function1)useForStore.1.actionResult.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this$0.chmod(it, 384);
            }
            Object actionResult2 = object;
            return new ConfigurationCacheStateStore.StateAccessResult<Object>(actionResult2, CollectionsKt.toList((Iterable)stateFiles));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$WriteableConfigurationCacheStateFile;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "file", "Ljava/io/File;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "onFileAccess", "Lkotlin/Function1;", "", "<init>", "(Ljava/io/File;Lorg/gradle/internal/cc/impl/StateType;Lkotlin/jvm/functions/Function1;)V", "getStateType", "()Lorg/gradle/internal/cc/impl/StateType;", "exists", "", "getExists", "()Z", "stateFile", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore$StateFile;", "getStateFile", "()Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore$StateFile;", "outputStream", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "delete", "moveFrom", "stateFileForIncludedBuild", "build", "Lorg/gradle/api/internal/BuildDefinition;", "relatedStateFile", "path", "Lorg/gradle/util/Path;", "stateFileForSharedObjects", "configuration-cache"})
    private static final class WriteableConfigurationCacheStateFile
    implements ConfigurationCacheStateFile {
        @NotNull
        private final File file;
        @NotNull
        private final StateType stateType;
        @NotNull
        private final Function1<File, Unit> onFileAccess;

        public WriteableConfigurationCacheStateFile(@NotNull File file, @NotNull StateType stateType, @NotNull Function1<? super File, Unit> onFileAccess) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Intrinsics.checkNotNullParameter(onFileAccess, (String)"onFileAccess");
            this.file = file;
            this.stateType = stateType;
            this.onFileAccess = onFileAccess;
        }

        @Override
        @NotNull
        public StateType getStateType() {
            return this.stateType;
        }

        @Override
        public boolean getExists() {
            return false;
        }

        @Override
        @NotNull
        public ConfigurationCacheStateStore.StateFile getStateFile() {
            return new ConfigurationCacheStateStore.StateFile(this.getStateType(), this.file);
        }

        @Override
        @NotNull
        public OutputStream outputStream() {
            File file = this.file;
            this.onFileAccess.invoke((Object)file);
            return new FileOutputStream(file);
        }

        @Override
        @NotNull
        public InputStream inputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete() {
            if (this.file.exists()) {
                Files.delete(this.file.toPath());
            }
        }

        @Override
        public void moveFrom(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(file.toPath(), this.file.toPath(), copyOptionArray);
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile stateFileForIncludedBuild(@NotNull BuildDefinition build) {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            return new WriteableConfigurationCacheStateFile(ConfigurationCacheRepositoryKt.access$includedBuildFileFor(this.file, build), this.getStateType(), this.onFileAccess);
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile relatedStateFile(@NotNull org.gradle.util.Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new WriteableConfigurationCacheStateFile(ConfigurationCacheRepositoryKt.access$relatedStateFileFor(this.file, path), this.getStateType(), this.onFileAccess);
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile stateFileForSharedObjects() {
            return new WriteableConfigurationCacheStateFile(ConfigurationCacheRepositoryKt.access$sharedObjectsFileFor(this.file), StateType.WorkShared, this.onFileAccess);
        }

        @Override
        @NotNull
        public String getName() {
            return ConfigurationCacheStateFile.super.getName();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$WriteableLayout;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$Layout;", "cacheDir", "Ljava/io/File;", "onFileAccess", "Lkotlin/Function1;", "", "<init>", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)V", "fileForRead", "Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$ReadableConfigurationCacheStateFile;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "fileFor", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "configuration-cache"})
    private static final class WriteableLayout
    extends Layout {
        @NotNull
        private final File cacheDir;
        @NotNull
        private final Function1<File, Unit> onFileAccess;

        public WriteableLayout(@NotNull File cacheDir, @NotNull Function1<? super File, Unit> onFileAccess) {
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            Intrinsics.checkNotNullParameter(onFileAccess, (String)"onFileAccess");
            this.cacheDir = cacheDir;
            this.onFileAccess = onFileAccess;
        }

        @Override
        @NotNull
        public ReadableConfigurationCacheStateFile fileForRead(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return ConfigurationCacheRepositoryKt.readableConfigurationCacheStateFile(this.cacheDir, stateType, (Function1<? super File, Unit>)((Function1)WriteableLayout::fileForRead$lambda$0));
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile fileFor(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return new WriteableConfigurationCacheStateFile(ConfigurationCacheRepositoryKt.access$stateFile(this.cacheDir, stateType), stateType, this.onFileAccess);
        }

        private static final Unit fileForRead$lambda$0(File it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }
    }
}

