//autogenerated:yes
//nolint:revive,misspell,govet,lll
package common

// Reports results of completed compass calibration. Sent until MAG_CAL_ACK received.
type MessageMagCalReport struct {
	// Compass being calibrated.
	CompassId uint8
	// Bitmask of compasses being calibrated.
	CalMask uint8
	// Calibration Status.
	CalStatus MAG_CAL_STATUS `mavenum:"uint8"`
	// 0=requires a MAV_CMD_DO_ACCEPT_MAG_CAL, 1=saved to parameters.
	Autosaved uint8
	// RMS milligauss residuals.
	Fitness float32
	// X offset.
	OfsX float32
	// Y offset.
	OfsY float32
	// Z offset.
	OfsZ float32
	// X diagonal (matrix 11).
	DiagX float32
	// Y diagonal (matrix 22).
	DiagY float32
	// Z diagonal (matrix 33).
	DiagZ float32
	// X off-diagonal (matrix 12 and 21).
	OffdiagX float32
	// Y off-diagonal (matrix 13 and 31).
	OffdiagY float32
	// Z off-diagonal (matrix 32 and 23).
	OffdiagZ float32
	// Confidence in orientation (higher is better).
	OrientationConfidence float32 `mavext:"true"`
	// orientation before calibration.
	OldOrientation MAV_SENSOR_ORIENTATION `mavenum:"uint8" mavext:"true"`
	// orientation after calibration.
	NewOrientation MAV_SENSOR_ORIENTATION `mavenum:"uint8" mavext:"true"`
	// field radius correction factor
	ScaleFactor float32 `mavext:"true"`
}

// GetID implements the message.Message interface.
func (*MessageMagCalReport) GetID() uint32 {
	return 192
}
