//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

// Flags in RALLY_POINT message.
type RALLY_FLAGS uint64

const (
	// Flag set when requiring favorable winds for landing.
	FAVORABLE_WIND RALLY_FLAGS = 1
	// Flag set when plane is to immediately descend to break altitude and land without GCS intervention. Flag not set when plane is to loiter at Rally point until commanded to land.
	LAND_IMMEDIATELY RALLY_FLAGS = 2
	// True if the following altitude frame value is valid.
	ALT_FRAME_VALID RALLY_FLAGS = 4
	// 2 bit value representing altitude frame. 0: absolute, 1: relative home, 2: relative origin, 3: relative terrain
	ALT_FRAME RALLY_FLAGS = 24
)

var value_to_label_RALLY_FLAGS = map[RALLY_FLAGS]string{
	FAVORABLE_WIND:   "FAVORABLE_WIND",
	LAND_IMMEDIATELY: "LAND_IMMEDIATELY",
	ALT_FRAME_VALID:  "ALT_FRAME_VALID",
	ALT_FRAME:        "ALT_FRAME",
}

var label_to_value_RALLY_FLAGS = map[string]RALLY_FLAGS{
	"FAVORABLE_WIND":   FAVORABLE_WIND,
	"LAND_IMMEDIATELY": LAND_IMMEDIATELY,
	"ALT_FRAME_VALID":  ALT_FRAME_VALID,
	"ALT_FRAME":        ALT_FRAME,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e RALLY_FLAGS) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_RALLY_FLAGS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *RALLY_FLAGS) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_RALLY_FLAGS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = RALLY_FLAGS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e RALLY_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
