//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

type FENCE_BREACH uint64

const (
	// No last fence breach
	FENCE_BREACH_NONE FENCE_BREACH = 0
	// Breached minimum altitude
	FENCE_BREACH_MINALT FENCE_BREACH = 1
	// Breached maximum altitude
	FENCE_BREACH_MAXALT FENCE_BREACH = 2
	// Breached fence boundary
	FENCE_BREACH_BOUNDARY FENCE_BREACH = 3
)

var value_to_label_FENCE_BREACH = map[FENCE_BREACH]string{
	FENCE_BREACH_NONE:     "FENCE_BREACH_NONE",
	FENCE_BREACH_MINALT:   "FENCE_BREACH_MINALT",
	FENCE_BREACH_MAXALT:   "FENCE_BREACH_MAXALT",
	FENCE_BREACH_BOUNDARY: "FENCE_BREACH_BOUNDARY",
}

var label_to_value_FENCE_BREACH = map[string]FENCE_BREACH{
	"FENCE_BREACH_NONE":     FENCE_BREACH_NONE,
	"FENCE_BREACH_MINALT":   FENCE_BREACH_MINALT,
	"FENCE_BREACH_MAXALT":   FENCE_BREACH_MAXALT,
	"FENCE_BREACH_BOUNDARY": FENCE_BREACH_BOUNDARY,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e FENCE_BREACH) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_FENCE_BREACH[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *FENCE_BREACH) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_FENCE_BREACH[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = FENCE_BREACH(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e FENCE_BREACH) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
