//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ualberta

import (
	"fmt"
	"strconv"
)

// Available autopilot modes for ualberta uav
type UALBERTA_AUTOPILOT_MODE uint64

const (
	// Raw input pulse widts sent to output
	MODE_MANUAL_DIRECT UALBERTA_AUTOPILOT_MODE = 1
	// Inputs are normalized using calibration, the converted back to raw pulse widths for output
	MODE_MANUAL_SCALED UALBERTA_AUTOPILOT_MODE = 2
	MODE_AUTO_PID_ATT  UALBERTA_AUTOPILOT_MODE = 3
	MODE_AUTO_PID_VEL  UALBERTA_AUTOPILOT_MODE = 4
	MODE_AUTO_PID_POS  UALBERTA_AUTOPILOT_MODE = 5
)

var value_to_label_UALBERTA_AUTOPILOT_MODE = map[UALBERTA_AUTOPILOT_MODE]string{
	MODE_MANUAL_DIRECT: "MODE_MANUAL_DIRECT",
	MODE_MANUAL_SCALED: "MODE_MANUAL_SCALED",
	MODE_AUTO_PID_ATT:  "MODE_AUTO_PID_ATT",
	MODE_AUTO_PID_VEL:  "MODE_AUTO_PID_VEL",
	MODE_AUTO_PID_POS:  "MODE_AUTO_PID_POS",
}

var label_to_value_UALBERTA_AUTOPILOT_MODE = map[string]UALBERTA_AUTOPILOT_MODE{
	"MODE_MANUAL_DIRECT": MODE_MANUAL_DIRECT,
	"MODE_MANUAL_SCALED": MODE_MANUAL_SCALED,
	"MODE_AUTO_PID_ATT":  MODE_AUTO_PID_ATT,
	"MODE_AUTO_PID_VEL":  MODE_AUTO_PID_VEL,
	"MODE_AUTO_PID_POS":  MODE_AUTO_PID_POS,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e UALBERTA_AUTOPILOT_MODE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_UALBERTA_AUTOPILOT_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *UALBERTA_AUTOPILOT_MODE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_UALBERTA_AUTOPILOT_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = UALBERTA_AUTOPILOT_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e UALBERTA_AUTOPILOT_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
