package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ShowErrorLogRequest Request Object
type ShowErrorLogRequest struct {

	// 实例ID，可以调用“查询实例列表”接口获取。如果未申请实例，可以调用“创建实例”接口创建。
	InstanceId string `json:"instance_id"`

	// 开始时间，格式为“yyyy-mm-ddThh:mm:ssZ”。其中，T指某个时间的开始，Z指时区偏移量，例如北京时间偏移显示为+0800。开始时间不得早于当前时间31天。
	StartTime string `json:"start_time"`

	// 结束时间，格式为“yyyy-mm-ddThh:mm:ssZ”。其中，T指某个时间的开始；Z指时区偏移量，例如北京时间偏移显示为+0800。 只能查询当前时间前一个月内的错误日志。结束时间不能晚于当前时间。
	EndTime string `json:"end_time"`

	// 节点ID，取空值，表示查询实例下所有允许查询的节点。
	NodeId *string `json:"node_id,omitempty"`

	// 语句类型，取空值，表示查询所有语句类型，也可指定如下日志类型： - Warning - Error
	Type *string `json:"type,omitempty"`

	// 索引位置，偏移量。取值范围为 [0, 1999]。 从第一条数据偏移offset条数据后开始查询，默认为0（偏移0条数据，表示从第一条数据开始查询） - 必须为数字，不能为负数。
	Offset *int32 `json:"offset,omitempty"`

	// 查询记录数。取值范围[1, 100]，默认10 （表示默认返回10条数据）。 - limit 与 offset的和需要满足小于等于2000的条件。
	Limit *int32 `json:"limit,omitempty"`
}

func (o ShowErrorLogRequest) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ShowErrorLogRequest struct{}"
	}

	return strings.Join([]string{"ShowErrorLogRequest", string(data)}, " ")
}
