package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

// ShowJobExeListNewRequest Request Object
type ShowJobExeListNewRequest struct {

	// 集群ID。获取方法，请参见[获取集群ID](https://support.huaweicloud.com/api-mrs/mrs_02_9001.html)。
	ClusterId string `json:"cluster_id"`

	// 作业名称，只能由字母、数字、中划线和下划线组成，并且长度为1～128个字符。
	JobName *string `json:"job_name,omitempty"`

	// 作业ID，只能由字母、数字、中划线(-)组成，并且长度为1~64字符。
	JobId *string `json:"job_id,omitempty"`

	// 用户名称、只能由字母、数字、特殊字符(-_.)组成，且不能以数字开头，并且长度为1～32字符。
	User *string `json:"user,omitempty"`

	// 作业类型。 - MapReduce - SparkPython - SparkSubmit：SparkPython类型的作业在查询时作业类型请选择SparkSubmit。 - HiveScript - HiveSql - DistCp，导入、导出数据。 - SparkScript - SparkSql - Flink
	JobType *string `json:"job_type,omitempty"`

	// 作业运行状态。 - FAILED：失败 - KILLED：已终止 - NEW：已创建 - NEW_SAVING：已创建保存中 - SUBMITTED：已提交 - ACCEPTED：已接受 - RUNNING：运行中 - FINISHED：已完成
	JobState *ShowJobExeListNewRequestJobState `json:"job_state,omitempty"`

	// 作业运行结果。 - FAILED：执行失败的作业。 - KILLED：执行中被手动终止的作业。 - UNDEFINED：正在执行的作业。 - SUCCEEDED：执行成功的作业。
	JobResult *ShowJobExeListNewRequestJobResult `json:"job_result,omitempty"`

	// 作业的资源对列类型名称，作业的资源对列类型名称，只能由数字、字母和特殊字符(-_)组成, 并且长度为1～64字符。
	Queue *string `json:"queue,omitempty"`

	// 返回结果中每页显示条数。缺省值：10
	Limit *string `json:"limit,omitempty"`

	// 表示作业列表从该偏移量开始查询。缺省值：0
	Offset *string `json:"offset,omitempty"`

	// 返回结果的排序方式，默认值为desc。 - asc：按升序排列 - desc：按降序排列
	SortBy *string `json:"sort_by,omitempty"`

	// 查询该时间之后提交的作业，UTC的毫秒时间戳。例如：1562032041362。
	SubmittedTimeBegin *int64 `json:"submitted_time_begin,omitempty"`

	// 查询该时间之前提交的作业UTC的毫秒时间戳。例如：1562032041362。
	SubmittedTimeEnd *int64 `json:"submitted_time_end,omitempty"`
}

func (o ShowJobExeListNewRequest) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ShowJobExeListNewRequest struct{}"
	}

	return strings.Join([]string{"ShowJobExeListNewRequest", string(data)}, " ")
}

type ShowJobExeListNewRequestJobState struct {
	value string
}

type ShowJobExeListNewRequestJobStateEnum struct {
	FAILED     ShowJobExeListNewRequestJobState
	KILLED     ShowJobExeListNewRequestJobState
	NEW        ShowJobExeListNewRequestJobState
	NEW_SAVING ShowJobExeListNewRequestJobState
	SUBMITTED  ShowJobExeListNewRequestJobState
	ACCEPTED   ShowJobExeListNewRequestJobState
	RUNNING    ShowJobExeListNewRequestJobState
	FINISHED   ShowJobExeListNewRequestJobState
}

func GetShowJobExeListNewRequestJobStateEnum() ShowJobExeListNewRequestJobStateEnum {
	return ShowJobExeListNewRequestJobStateEnum{
		FAILED: ShowJobExeListNewRequestJobState{
			value: "FAILED",
		},
		KILLED: ShowJobExeListNewRequestJobState{
			value: "KILLED",
		},
		NEW: ShowJobExeListNewRequestJobState{
			value: "NEW",
		},
		NEW_SAVING: ShowJobExeListNewRequestJobState{
			value: "NEW_SAVING",
		},
		SUBMITTED: ShowJobExeListNewRequestJobState{
			value: "SUBMITTED",
		},
		ACCEPTED: ShowJobExeListNewRequestJobState{
			value: "ACCEPTED",
		},
		RUNNING: ShowJobExeListNewRequestJobState{
			value: "RUNNING",
		},
		FINISHED: ShowJobExeListNewRequestJobState{
			value: "FINISHED",
		},
	}
}

func (c ShowJobExeListNewRequestJobState) Value() string {
	return c.value
}

func (c ShowJobExeListNewRequestJobState) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *ShowJobExeListNewRequestJobState) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}

type ShowJobExeListNewRequestJobResult struct {
	value string
}

type ShowJobExeListNewRequestJobResultEnum struct {
	FAILED    ShowJobExeListNewRequestJobResult
	KILLED    ShowJobExeListNewRequestJobResult
	UNDEFINED ShowJobExeListNewRequestJobResult
	SUCCEEDED ShowJobExeListNewRequestJobResult
}

func GetShowJobExeListNewRequestJobResultEnum() ShowJobExeListNewRequestJobResultEnum {
	return ShowJobExeListNewRequestJobResultEnum{
		FAILED: ShowJobExeListNewRequestJobResult{
			value: "FAILED",
		},
		KILLED: ShowJobExeListNewRequestJobResult{
			value: "KILLED",
		},
		UNDEFINED: ShowJobExeListNewRequestJobResult{
			value: "UNDEFINED",
		},
		SUCCEEDED: ShowJobExeListNewRequestJobResult{
			value: "SUCCEEDED",
		},
	}
}

func (c ShowJobExeListNewRequestJobResult) Value() string {
	return c.value
}

func (c ShowJobExeListNewRequestJobResult) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *ShowJobExeListNewRequestJobResult) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
