// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataproc/v1/clusters.proto

package dataprocpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ClusterController_CreateCluster_FullMethodName   = "/google.cloud.dataproc.v1.ClusterController/CreateCluster"
	ClusterController_UpdateCluster_FullMethodName   = "/google.cloud.dataproc.v1.ClusterController/UpdateCluster"
	ClusterController_StopCluster_FullMethodName     = "/google.cloud.dataproc.v1.ClusterController/StopCluster"
	ClusterController_StartCluster_FullMethodName    = "/google.cloud.dataproc.v1.ClusterController/StartCluster"
	ClusterController_DeleteCluster_FullMethodName   = "/google.cloud.dataproc.v1.ClusterController/DeleteCluster"
	ClusterController_GetCluster_FullMethodName      = "/google.cloud.dataproc.v1.ClusterController/GetCluster"
	ClusterController_ListClusters_FullMethodName    = "/google.cloud.dataproc.v1.ClusterController/ListClusters"
	ClusterController_DiagnoseCluster_FullMethodName = "/google.cloud.dataproc.v1.ClusterController/DiagnoseCluster"
)

// ClusterControllerClient is the client API for ClusterController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ClusterControllerClient interface {
	// Creates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	// The cluster must be in a
	// [`RUNNING`][google.cloud.dataproc.v1.ClusterStatus.State] state or an error
	// is returned.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops a cluster in a project.
	StopCluster(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a cluster in a project.
	StartCluster(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project alphabetically.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets cluster diagnostic information. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	// After the operation completes,
	// [Operation.response][google.longrunning.Operation.response]
	// contains
	// [DiagnoseClusterResults](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#diagnoseclusterresults).
	DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type clusterControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewClusterControllerClient(cc grpc.ClientConnInterface) ClusterControllerClient {
	return &clusterControllerClient{cc}
}

func (c *clusterControllerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ClusterController_CreateCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ClusterController_UpdateCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) StopCluster(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ClusterController_StopCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) StartCluster(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ClusterController_StartCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ClusterController_DeleteCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, ClusterController_GetCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, ClusterController_ListClusters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ClusterController_DiagnoseCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterControllerServer is the server API for ClusterController service.
// All implementations should embed UnimplementedClusterControllerServer
// for forward compatibility
type ClusterControllerServer interface {
	// Creates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error)
	// Updates a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	// The cluster must be in a
	// [`RUNNING`][google.cloud.dataproc.v1.ClusterStatus.State] state or an error
	// is returned.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error)
	// Stops a cluster in a project.
	StopCluster(context.Context, *StopClusterRequest) (*longrunningpb.Operation, error)
	// Starts a cluster in a project.
	StartCluster(context.Context, *StartClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a cluster in a project. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project alphabetically.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets cluster diagnostic information. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
	// After the operation completes,
	// [Operation.response][google.longrunning.Operation.response]
	// contains
	// [DiagnoseClusterResults](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#diagnoseclusterresults).
	DiagnoseCluster(context.Context, *DiagnoseClusterRequest) (*longrunningpb.Operation, error)
}

// UnimplementedClusterControllerServer should be embedded to have forward compatible implementations.
type UnimplementedClusterControllerServer struct {
}

func (UnimplementedClusterControllerServer) CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (UnimplementedClusterControllerServer) UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (UnimplementedClusterControllerServer) StopCluster(context.Context, *StopClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopCluster not implemented")
}
func (UnimplementedClusterControllerServer) StartCluster(context.Context, *StartClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartCluster not implemented")
}
func (UnimplementedClusterControllerServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (UnimplementedClusterControllerServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (UnimplementedClusterControllerServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (UnimplementedClusterControllerServer) DiagnoseCluster(context.Context, *DiagnoseClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiagnoseCluster not implemented")
}

// UnsafeClusterControllerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ClusterControllerServer will
// result in compilation errors.
type UnsafeClusterControllerServer interface {
	mustEmbedUnimplementedClusterControllerServer()
}

func RegisterClusterControllerServer(s grpc.ServiceRegistrar, srv ClusterControllerServer) {
	s.RegisterService(&ClusterController_ServiceDesc, srv)
}

func _ClusterController_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterController_CreateCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterController_UpdateCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_StopCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).StopCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterController_StopCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).StopCluster(ctx, req.(*StopClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_StartCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).StartCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterController_StartCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).StartCluster(ctx, req.(*StartClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterController_DeleteCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterController_GetCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterController_ListClusters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DiagnoseCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiagnoseClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ClusterController_DiagnoseCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, req.(*DiagnoseClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ClusterController_ServiceDesc is the grpc.ServiceDesc for ClusterController service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ClusterController_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.ClusterController",
	HandlerType: (*ClusterControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterController_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterController_UpdateCluster_Handler,
		},
		{
			MethodName: "StopCluster",
			Handler:    _ClusterController_StopCluster_Handler,
		},
		{
			MethodName: "StartCluster",
			Handler:    _ClusterController_StartCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterController_DeleteCluster_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterController_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _ClusterController_ListClusters_Handler,
		},
		{
			MethodName: "DiagnoseCluster",
			Handler:    _ClusterController_DiagnoseCluster_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/clusters.proto",
}
